from __future__ import annotations
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, Union

class VulnerabilityState(AdditionalDataHolder, Parsable):
    @property
    def additional_data(self,) -> Dict[str, Any]:
        """
        Gets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Returns: Dict[str, Any]
        """
        return self._additional_data
    
    @additional_data.setter
    def additional_data(self,value: Dict[str, Any]) -> None:
        """
        Sets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Args:
            value: Value to set for the AdditionalData property.
        """
        self._additional_data = value
    
    def __init__(self,) -> None:
        """
        Instantiates a new vulnerabilityState and sets the default values.
        """
        # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        self._additional_data: Dict[str, Any] = {}

        # Common Vulnerabilities and Exposures (CVE) for the vulnerability.
        self._cve: Optional[str] = None
        # The OdataType property
        self._odata_type: Optional[str] = None
        # Base Common Vulnerability Scoring System (CVSS) severity score for this vulnerability.
        self._severity: Optional[str] = None
        # Indicates whether the detected vulnerability (file) was running at the time of detection or was the file detected at rest on the disk.
        self._was_running: Optional[bool] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> VulnerabilityState:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: VulnerabilityState
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return VulnerabilityState()
    
    @property
    def cve(self,) -> Optional[str]:
        """
        Gets the cve property value. Common Vulnerabilities and Exposures (CVE) for the vulnerability.
        Returns: Optional[str]
        """
        return self._cve
    
    @cve.setter
    def cve(self,value: Optional[str] = None) -> None:
        """
        Sets the cve property value. Common Vulnerabilities and Exposures (CVE) for the vulnerability.
        Args:
            value: Value to set for the cve property.
        """
        self._cve = value
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "cve": lambda n : setattr(self, 'cve', n.get_str_value()),
            "@odata.type": lambda n : setattr(self, 'odata_type', n.get_str_value()),
            "severity": lambda n : setattr(self, 'severity', n.get_str_value()),
            "was_running": lambda n : setattr(self, 'was_running', n.get_bool_value()),
        }
        return fields
    
    @property
    def odata_type(self,) -> Optional[str]:
        """
        Gets the @odata.type property value. The OdataType property
        Returns: Optional[str]
        """
        return self._odata_type
    
    @odata_type.setter
    def odata_type(self,value: Optional[str] = None) -> None:
        """
        Sets the @odata.type property value. The OdataType property
        Args:
            value: Value to set for the OdataType property.
        """
        self._odata_type = value
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        writer.write_str_value("cve", self.cve)
        writer.write_str_value("@odata.type", self.odata_type)
        writer.write_str_value("severity", self.severity)
        writer.write_bool_value("wasRunning", self.was_running)
        writer.write_additional_data_value(self.additional_data)
    
    @property
    def severity(self,) -> Optional[str]:
        """
        Gets the severity property value. Base Common Vulnerability Scoring System (CVSS) severity score for this vulnerability.
        Returns: Optional[str]
        """
        return self._severity
    
    @severity.setter
    def severity(self,value: Optional[str] = None) -> None:
        """
        Sets the severity property value. Base Common Vulnerability Scoring System (CVSS) severity score for this vulnerability.
        Args:
            value: Value to set for the severity property.
        """
        self._severity = value
    
    @property
    def was_running(self,) -> Optional[bool]:
        """
        Gets the wasRunning property value. Indicates whether the detected vulnerability (file) was running at the time of detection or was the file detected at rest on the disk.
        Returns: Optional[bool]
        """
        return self._was_running
    
    @was_running.setter
    def was_running(self,value: Optional[bool] = None) -> None:
        """
        Sets the wasRunning property value. Indicates whether the detected vulnerability (file) was running at the time of detection or was the file detected at rest on the disk.
        Args:
            value: Value to set for the wasRunning property.
        """
        self._was_running = value
    

