from __future__ import annotations
from datetime import datetime
from kiota_abstractions.serialization import Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, Union

from . import entity, windows_malware_execution_state, windows_malware_threat_state

class MalwareStateForWindowsDevice(entity.Entity):
    """
    Malware state for a windows device
    """
    def __init__(self,) -> None:
        """
        Instantiates a new malwareStateForWindowsDevice and sets the default values.
        """
        super().__init__()
        # Number of times the malware is detected
        self._detection_count: Optional[int] = None
        # Device name
        self._device_name: Optional[str] = None
        # Execution status of the malware like blocked/executing etc. Possible values are: unknown, blocked, allowed, running, notRunning.
        self._execution_state: Optional[windows_malware_execution_state.WindowsMalwareExecutionState] = None
        # Initial detection datetime of the malware
        self._initial_detection_date_time: Optional[datetime] = None
        # The last time this particular threat was changed
        self._last_state_change_date_time: Optional[datetime] = None
        # The OdataType property
        self.odata_type: Optional[str] = None
        # Threat status of the malware like cleaned/quarantined/allowed etc. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
        self._threat_state: Optional[windows_malware_threat_state.WindowsMalwareThreatState] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> MalwareStateForWindowsDevice:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: MalwareStateForWindowsDevice
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return MalwareStateForWindowsDevice()
    
    @property
    def detection_count(self,) -> Optional[int]:
        """
        Gets the detectionCount property value. Number of times the malware is detected
        Returns: Optional[int]
        """
        return self._detection_count
    
    @detection_count.setter
    def detection_count(self,value: Optional[int] = None) -> None:
        """
        Sets the detectionCount property value. Number of times the malware is detected
        Args:
            value: Value to set for the detectionCount property.
        """
        self._detection_count = value
    
    @property
    def device_name(self,) -> Optional[str]:
        """
        Gets the deviceName property value. Device name
        Returns: Optional[str]
        """
        return self._device_name
    
    @device_name.setter
    def device_name(self,value: Optional[str] = None) -> None:
        """
        Sets the deviceName property value. Device name
        Args:
            value: Value to set for the deviceName property.
        """
        self._device_name = value
    
    @property
    def execution_state(self,) -> Optional[windows_malware_execution_state.WindowsMalwareExecutionState]:
        """
        Gets the executionState property value. Execution status of the malware like blocked/executing etc. Possible values are: unknown, blocked, allowed, running, notRunning.
        Returns: Optional[windows_malware_execution_state.WindowsMalwareExecutionState]
        """
        return self._execution_state
    
    @execution_state.setter
    def execution_state(self,value: Optional[windows_malware_execution_state.WindowsMalwareExecutionState] = None) -> None:
        """
        Sets the executionState property value. Execution status of the malware like blocked/executing etc. Possible values are: unknown, blocked, allowed, running, notRunning.
        Args:
            value: Value to set for the executionState property.
        """
        self._execution_state = value
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "detection_count": lambda n : setattr(self, 'detection_count', n.get_int_value()),
            "device_name": lambda n : setattr(self, 'device_name', n.get_str_value()),
            "execution_state": lambda n : setattr(self, 'execution_state', n.get_enum_value(windows_malware_execution_state.WindowsMalwareExecutionState)),
            "initial_detection_date_time": lambda n : setattr(self, 'initial_detection_date_time', n.get_datetime_value()),
            "last_state_change_date_time": lambda n : setattr(self, 'last_state_change_date_time', n.get_datetime_value()),
            "threat_state": lambda n : setattr(self, 'threat_state', n.get_enum_value(windows_malware_threat_state.WindowsMalwareThreatState)),
        }
        super_fields = super().get_field_deserializers()
        fields.update(super_fields)
        return fields
    
    @property
    def initial_detection_date_time(self,) -> Optional[datetime]:
        """
        Gets the initialDetectionDateTime property value. Initial detection datetime of the malware
        Returns: Optional[datetime]
        """
        return self._initial_detection_date_time
    
    @initial_detection_date_time.setter
    def initial_detection_date_time(self,value: Optional[datetime] = None) -> None:
        """
        Sets the initialDetectionDateTime property value. Initial detection datetime of the malware
        Args:
            value: Value to set for the initialDetectionDateTime property.
        """
        self._initial_detection_date_time = value
    
    @property
    def last_state_change_date_time(self,) -> Optional[datetime]:
        """
        Gets the lastStateChangeDateTime property value. The last time this particular threat was changed
        Returns: Optional[datetime]
        """
        return self._last_state_change_date_time
    
    @last_state_change_date_time.setter
    def last_state_change_date_time(self,value: Optional[datetime] = None) -> None:
        """
        Sets the lastStateChangeDateTime property value. The last time this particular threat was changed
        Args:
            value: Value to set for the lastStateChangeDateTime property.
        """
        self._last_state_change_date_time = value
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        super().serialize(writer)
        writer.write_int_value("detectionCount", self.detection_count)
        writer.write_str_value("deviceName", self.device_name)
        writer.write_enum_value("executionState", self.execution_state)
        writer.write_datetime_value("initialDetectionDateTime", self.initial_detection_date_time)
        writer.write_datetime_value("lastStateChangeDateTime", self.last_state_change_date_time)
        writer.write_enum_value("threatState", self.threat_state)
    
    @property
    def threat_state(self,) -> Optional[windows_malware_threat_state.WindowsMalwareThreatState]:
        """
        Gets the threatState property value. Threat status of the malware like cleaned/quarantined/allowed etc. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
        Returns: Optional[windows_malware_threat_state.WindowsMalwareThreatState]
        """
        return self._threat_state
    
    @threat_state.setter
    def threat_state(self,value: Optional[windows_malware_threat_state.WindowsMalwareThreatState] = None) -> None:
        """
        Sets the threatState property value. Threat status of the malware like cleaned/quarantined/allowed etc. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
        Args:
            value: Value to set for the threatState property.
        """
        self._threat_state = value
    

