from __future__ import annotations
from datetime import datetime
from kiota_abstractions.serialization import Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, Union

from . import mac_os_vpp_app_assigned_license, mac_os_vpp_app_revoke_licenses_action_result, mobile_app, vpp_licensing_type, vpp_token_account_type

class MacOsVppApp(mobile_app.MobileApp):
    @property
    def app_store_url(self,) -> Optional[str]:
        """
        Gets the appStoreUrl property value. The store URL.
        Returns: Optional[str]
        """
        return self._app_store_url
    
    @app_store_url.setter
    def app_store_url(self,value: Optional[str] = None) -> None:
        """
        Sets the appStoreUrl property value. The store URL.
        Args:
            value: Value to set for the appStoreUrl property.
        """
        self._app_store_url = value
    
    @property
    def assigned_licenses(self,) -> Optional[List[mac_os_vpp_app_assigned_license.MacOsVppAppAssignedLicense]]:
        """
        Gets the assignedLicenses property value. The licenses assigned to this app.
        Returns: Optional[List[mac_os_vpp_app_assigned_license.MacOsVppAppAssignedLicense]]
        """
        return self._assigned_licenses
    
    @assigned_licenses.setter
    def assigned_licenses(self,value: Optional[List[mac_os_vpp_app_assigned_license.MacOsVppAppAssignedLicense]] = None) -> None:
        """
        Sets the assignedLicenses property value. The licenses assigned to this app.
        Args:
            value: Value to set for the assignedLicenses property.
        """
        self._assigned_licenses = value
    
    @property
    def bundle_id(self,) -> Optional[str]:
        """
        Gets the bundleId property value. The Identity Name.
        Returns: Optional[str]
        """
        return self._bundle_id
    
    @bundle_id.setter
    def bundle_id(self,value: Optional[str] = None) -> None:
        """
        Sets the bundleId property value. The Identity Name.
        Args:
            value: Value to set for the bundleId property.
        """
        self._bundle_id = value
    
    def __init__(self,) -> None:
        """
        Instantiates a new MacOsVppApp and sets the default values.
        """
        super().__init__()
        self.odata_type = "#microsoft.graph.macOsVppApp"
        # The store URL.
        self._app_store_url: Optional[str] = None
        # The licenses assigned to this app.
        self._assigned_licenses: Optional[List[mac_os_vpp_app_assigned_license.MacOsVppAppAssignedLicense]] = None
        # The Identity Name.
        self._bundle_id: Optional[str] = None
        # The supported License Type.
        self._licensing_type: Optional[vpp_licensing_type.VppLicensingType] = None
        # The VPP application release date and time.
        self._release_date_time: Optional[datetime] = None
        # Results of revoke license actions on this app.
        self._revoke_license_action_results: Optional[List[mac_os_vpp_app_revoke_licenses_action_result.MacOsVppAppRevokeLicensesActionResult]] = None
        # The total number of VPP licenses.
        self._total_license_count: Optional[int] = None
        # The number of VPP licenses in use.
        self._used_license_count: Optional[int] = None
        # Possible types of an Apple Volume Purchase Program token.
        self._vpp_token_account_type: Optional[vpp_token_account_type.VppTokenAccountType] = None
        # The Apple Id associated with the given Apple Volume Purchase Program Token.
        self._vpp_token_apple_id: Optional[str] = None
        # Identifier of the VPP token associated with this app.
        self._vpp_token_id: Optional[str] = None
        # The organization associated with the Apple Volume Purchase Program Token
        self._vpp_token_organization_name: Optional[str] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> MacOsVppApp:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: MacOsVppApp
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return MacOsVppApp()
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "app_store_url": lambda n : setattr(self, 'app_store_url', n.get_str_value()),
            "assigned_licenses": lambda n : setattr(self, 'assigned_licenses', n.get_collection_of_object_values(mac_os_vpp_app_assigned_license.MacOsVppAppAssignedLicense)),
            "bundle_id": lambda n : setattr(self, 'bundle_id', n.get_str_value()),
            "licensing_type": lambda n : setattr(self, 'licensing_type', n.get_object_value(vpp_licensing_type.VppLicensingType)),
            "release_date_time": lambda n : setattr(self, 'release_date_time', n.get_datetime_value()),
            "revoke_license_action_results": lambda n : setattr(self, 'revoke_license_action_results', n.get_collection_of_object_values(mac_os_vpp_app_revoke_licenses_action_result.MacOsVppAppRevokeLicensesActionResult)),
            "total_license_count": lambda n : setattr(self, 'total_license_count', n.get_int_value()),
            "used_license_count": lambda n : setattr(self, 'used_license_count', n.get_int_value()),
            "vpp_token_account_type": lambda n : setattr(self, 'vpp_token_account_type', n.get_enum_value(vpp_token_account_type.VppTokenAccountType)),
            "vpp_token_apple_id": lambda n : setattr(self, 'vpp_token_apple_id', n.get_str_value()),
            "vpp_token_id": lambda n : setattr(self, 'vpp_token_id', n.get_str_value()),
            "vpp_token_organization_name": lambda n : setattr(self, 'vpp_token_organization_name', n.get_str_value()),
        }
        super_fields = super().get_field_deserializers()
        fields.update(super_fields)
        return fields
    
    @property
    def licensing_type(self,) -> Optional[vpp_licensing_type.VppLicensingType]:
        """
        Gets the licensingType property value. The supported License Type.
        Returns: Optional[vpp_licensing_type.VppLicensingType]
        """
        return self._licensing_type
    
    @licensing_type.setter
    def licensing_type(self,value: Optional[vpp_licensing_type.VppLicensingType] = None) -> None:
        """
        Sets the licensingType property value. The supported License Type.
        Args:
            value: Value to set for the licensingType property.
        """
        self._licensing_type = value
    
    @property
    def release_date_time(self,) -> Optional[datetime]:
        """
        Gets the releaseDateTime property value. The VPP application release date and time.
        Returns: Optional[datetime]
        """
        return self._release_date_time
    
    @release_date_time.setter
    def release_date_time(self,value: Optional[datetime] = None) -> None:
        """
        Sets the releaseDateTime property value. The VPP application release date and time.
        Args:
            value: Value to set for the releaseDateTime property.
        """
        self._release_date_time = value
    
    @property
    def revoke_license_action_results(self,) -> Optional[List[mac_os_vpp_app_revoke_licenses_action_result.MacOsVppAppRevokeLicensesActionResult]]:
        """
        Gets the revokeLicenseActionResults property value. Results of revoke license actions on this app.
        Returns: Optional[List[mac_os_vpp_app_revoke_licenses_action_result.MacOsVppAppRevokeLicensesActionResult]]
        """
        return self._revoke_license_action_results
    
    @revoke_license_action_results.setter
    def revoke_license_action_results(self,value: Optional[List[mac_os_vpp_app_revoke_licenses_action_result.MacOsVppAppRevokeLicensesActionResult]] = None) -> None:
        """
        Sets the revokeLicenseActionResults property value. Results of revoke license actions on this app.
        Args:
            value: Value to set for the revokeLicenseActionResults property.
        """
        self._revoke_license_action_results = value
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        super().serialize(writer)
        writer.write_str_value("appStoreUrl", self.app_store_url)
        writer.write_collection_of_object_values("assignedLicenses", self.assigned_licenses)
        writer.write_str_value("bundleId", self.bundle_id)
        writer.write_object_value("licensingType", self.licensing_type)
        writer.write_datetime_value("releaseDateTime", self.release_date_time)
        writer.write_collection_of_object_values("revokeLicenseActionResults", self.revoke_license_action_results)
        writer.write_int_value("totalLicenseCount", self.total_license_count)
        writer.write_int_value("usedLicenseCount", self.used_license_count)
        writer.write_enum_value("vppTokenAccountType", self.vpp_token_account_type)
        writer.write_str_value("vppTokenAppleId", self.vpp_token_apple_id)
        writer.write_str_value("vppTokenId", self.vpp_token_id)
        writer.write_str_value("vppTokenOrganizationName", self.vpp_token_organization_name)
    
    @property
    def total_license_count(self,) -> Optional[int]:
        """
        Gets the totalLicenseCount property value. The total number of VPP licenses.
        Returns: Optional[int]
        """
        return self._total_license_count
    
    @total_license_count.setter
    def total_license_count(self,value: Optional[int] = None) -> None:
        """
        Sets the totalLicenseCount property value. The total number of VPP licenses.
        Args:
            value: Value to set for the totalLicenseCount property.
        """
        self._total_license_count = value
    
    @property
    def used_license_count(self,) -> Optional[int]:
        """
        Gets the usedLicenseCount property value. The number of VPP licenses in use.
        Returns: Optional[int]
        """
        return self._used_license_count
    
    @used_license_count.setter
    def used_license_count(self,value: Optional[int] = None) -> None:
        """
        Sets the usedLicenseCount property value. The number of VPP licenses in use.
        Args:
            value: Value to set for the usedLicenseCount property.
        """
        self._used_license_count = value
    
    @property
    def vpp_token_account_type(self,) -> Optional[vpp_token_account_type.VppTokenAccountType]:
        """
        Gets the vppTokenAccountType property value. Possible types of an Apple Volume Purchase Program token.
        Returns: Optional[vpp_token_account_type.VppTokenAccountType]
        """
        return self._vpp_token_account_type
    
    @vpp_token_account_type.setter
    def vpp_token_account_type(self,value: Optional[vpp_token_account_type.VppTokenAccountType] = None) -> None:
        """
        Sets the vppTokenAccountType property value. Possible types of an Apple Volume Purchase Program token.
        Args:
            value: Value to set for the vppTokenAccountType property.
        """
        self._vpp_token_account_type = value
    
    @property
    def vpp_token_apple_id(self,) -> Optional[str]:
        """
        Gets the vppTokenAppleId property value. The Apple Id associated with the given Apple Volume Purchase Program Token.
        Returns: Optional[str]
        """
        return self._vpp_token_apple_id
    
    @vpp_token_apple_id.setter
    def vpp_token_apple_id(self,value: Optional[str] = None) -> None:
        """
        Sets the vppTokenAppleId property value. The Apple Id associated with the given Apple Volume Purchase Program Token.
        Args:
            value: Value to set for the vppTokenAppleId property.
        """
        self._vpp_token_apple_id = value
    
    @property
    def vpp_token_id(self,) -> Optional[str]:
        """
        Gets the vppTokenId property value. Identifier of the VPP token associated with this app.
        Returns: Optional[str]
        """
        return self._vpp_token_id
    
    @vpp_token_id.setter
    def vpp_token_id(self,value: Optional[str] = None) -> None:
        """
        Sets the vppTokenId property value. Identifier of the VPP token associated with this app.
        Args:
            value: Value to set for the vppTokenId property.
        """
        self._vpp_token_id = value
    
    @property
    def vpp_token_organization_name(self,) -> Optional[str]:
        """
        Gets the vppTokenOrganizationName property value. The organization associated with the Apple Volume Purchase Program Token
        Returns: Optional[str]
        """
        return self._vpp_token_organization_name
    
    @vpp_token_organization_name.setter
    def vpp_token_organization_name(self,value: Optional[str] = None) -> None:
        """
        Sets the vppTokenOrganizationName property value. The organization associated with the Apple Volume Purchase Program Token
        Args:
            value: Value to set for the vppTokenOrganizationName property.
        """
        self._vpp_token_organization_name = value
    

