from __future__ import annotations
from kiota_abstractions.serialization import Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, Union

from . import group_policy_uploaded_presentation

class GroupPolicyPresentationCheckBox(group_policy_uploaded_presentation.GroupPolicyUploadedPresentation):
    def __init__(self,) -> None:
        """
        Instantiates a new GroupPolicyPresentationCheckBox and sets the default values.
        """
        super().__init__()
        self.odata_type = "#microsoft.graph.groupPolicyPresentationCheckBox"
        # Default value for the check box. The default value is false.
        self._default_checked: Optional[bool] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> GroupPolicyPresentationCheckBox:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: GroupPolicyPresentationCheckBox
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return GroupPolicyPresentationCheckBox()
    
    @property
    def default_checked(self,) -> Optional[bool]:
        """
        Gets the defaultChecked property value. Default value for the check box. The default value is false.
        Returns: Optional[bool]
        """
        return self._default_checked
    
    @default_checked.setter
    def default_checked(self,value: Optional[bool] = None) -> None:
        """
        Sets the defaultChecked property value. Default value for the check box. The default value is false.
        Args:
            value: Value to set for the defaultChecked property.
        """
        self._default_checked = value
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "default_checked": lambda n : setattr(self, 'default_checked', n.get_bool_value()),
        }
        super_fields = super().get_field_deserializers()
        fields.update(super_fields)
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        super().serialize(writer)
        writer.write_bool_value("defaultChecked", self.default_checked)
    

