from __future__ import annotations
from kiota_abstractions.serialization import Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, Union

from . import app_vulnerability_managed_device, app_vulnerability_mobile_app, app_vulnerability_task_mitigation_type, device_app_management_task

class AppVulnerabilityTask(device_app_management_task.DeviceAppManagementTask):
    @property
    def app_name(self,) -> Optional[str]:
        """
        Gets the appName property value. The app name.
        Returns: Optional[str]
        """
        return self._app_name
    
    @app_name.setter
    def app_name(self,value: Optional[str] = None) -> None:
        """
        Sets the appName property value. The app name.
        Args:
            value: Value to set for the appName property.
        """
        self._app_name = value
    
    @property
    def app_publisher(self,) -> Optional[str]:
        """
        Gets the appPublisher property value. The app publisher.
        Returns: Optional[str]
        """
        return self._app_publisher
    
    @app_publisher.setter
    def app_publisher(self,value: Optional[str] = None) -> None:
        """
        Sets the appPublisher property value. The app publisher.
        Args:
            value: Value to set for the appPublisher property.
        """
        self._app_publisher = value
    
    @property
    def app_version(self,) -> Optional[str]:
        """
        Gets the appVersion property value. The app version.
        Returns: Optional[str]
        """
        return self._app_version
    
    @app_version.setter
    def app_version(self,value: Optional[str] = None) -> None:
        """
        Sets the appVersion property value. The app version.
        Args:
            value: Value to set for the appVersion property.
        """
        self._app_version = value
    
    def __init__(self,) -> None:
        """
        Instantiates a new AppVulnerabilityTask and sets the default values.
        """
        super().__init__()
        self.odata_type = "#microsoft.graph.appVulnerabilityTask"
        # The app name.
        self._app_name: Optional[str] = None
        # The app publisher.
        self._app_publisher: Optional[str] = None
        # The app version.
        self._app_version: Optional[str] = None
        # Information about the mitigation.
        self._insights: Optional[str] = None
        # The number of vulnerable devices.
        self._managed_device_count: Optional[int] = None
        # The vulnerable managed devices.
        self._managed_devices: Optional[List[app_vulnerability_managed_device.AppVulnerabilityManagedDevice]] = None
        # Device app management task mitigation type.
        self._mitigation_type: Optional[app_vulnerability_task_mitigation_type.AppVulnerabilityTaskMitigationType] = None
        # The number of vulnerable mobile apps.
        self._mobile_app_count: Optional[int] = None
        # The vulnerable mobile apps.
        self._mobile_apps: Optional[List[app_vulnerability_mobile_app.AppVulnerabilityMobileApp]] = None
        # The remediation steps.
        self._remediation: Optional[str] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> AppVulnerabilityTask:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: AppVulnerabilityTask
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return AppVulnerabilityTask()
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "app_name": lambda n : setattr(self, 'app_name', n.get_str_value()),
            "app_publisher": lambda n : setattr(self, 'app_publisher', n.get_str_value()),
            "app_version": lambda n : setattr(self, 'app_version', n.get_str_value()),
            "insights": lambda n : setattr(self, 'insights', n.get_str_value()),
            "managed_device_count": lambda n : setattr(self, 'managed_device_count', n.get_int_value()),
            "managed_devices": lambda n : setattr(self, 'managed_devices', n.get_collection_of_object_values(app_vulnerability_managed_device.AppVulnerabilityManagedDevice)),
            "mitigation_type": lambda n : setattr(self, 'mitigation_type', n.get_enum_value(app_vulnerability_task_mitigation_type.AppVulnerabilityTaskMitigationType)),
            "mobile_app_count": lambda n : setattr(self, 'mobile_app_count', n.get_int_value()),
            "mobile_apps": lambda n : setattr(self, 'mobile_apps', n.get_collection_of_object_values(app_vulnerability_mobile_app.AppVulnerabilityMobileApp)),
            "remediation": lambda n : setattr(self, 'remediation', n.get_str_value()),
        }
        super_fields = super().get_field_deserializers()
        fields.update(super_fields)
        return fields
    
    @property
    def insights(self,) -> Optional[str]:
        """
        Gets the insights property value. Information about the mitigation.
        Returns: Optional[str]
        """
        return self._insights
    
    @insights.setter
    def insights(self,value: Optional[str] = None) -> None:
        """
        Sets the insights property value. Information about the mitigation.
        Args:
            value: Value to set for the insights property.
        """
        self._insights = value
    
    @property
    def managed_device_count(self,) -> Optional[int]:
        """
        Gets the managedDeviceCount property value. The number of vulnerable devices.
        Returns: Optional[int]
        """
        return self._managed_device_count
    
    @managed_device_count.setter
    def managed_device_count(self,value: Optional[int] = None) -> None:
        """
        Sets the managedDeviceCount property value. The number of vulnerable devices.
        Args:
            value: Value to set for the managedDeviceCount property.
        """
        self._managed_device_count = value
    
    @property
    def managed_devices(self,) -> Optional[List[app_vulnerability_managed_device.AppVulnerabilityManagedDevice]]:
        """
        Gets the managedDevices property value. The vulnerable managed devices.
        Returns: Optional[List[app_vulnerability_managed_device.AppVulnerabilityManagedDevice]]
        """
        return self._managed_devices
    
    @managed_devices.setter
    def managed_devices(self,value: Optional[List[app_vulnerability_managed_device.AppVulnerabilityManagedDevice]] = None) -> None:
        """
        Sets the managedDevices property value. The vulnerable managed devices.
        Args:
            value: Value to set for the managedDevices property.
        """
        self._managed_devices = value
    
    @property
    def mitigation_type(self,) -> Optional[app_vulnerability_task_mitigation_type.AppVulnerabilityTaskMitigationType]:
        """
        Gets the mitigationType property value. Device app management task mitigation type.
        Returns: Optional[app_vulnerability_task_mitigation_type.AppVulnerabilityTaskMitigationType]
        """
        return self._mitigation_type
    
    @mitigation_type.setter
    def mitigation_type(self,value: Optional[app_vulnerability_task_mitigation_type.AppVulnerabilityTaskMitigationType] = None) -> None:
        """
        Sets the mitigationType property value. Device app management task mitigation type.
        Args:
            value: Value to set for the mitigationType property.
        """
        self._mitigation_type = value
    
    @property
    def mobile_app_count(self,) -> Optional[int]:
        """
        Gets the mobileAppCount property value. The number of vulnerable mobile apps.
        Returns: Optional[int]
        """
        return self._mobile_app_count
    
    @mobile_app_count.setter
    def mobile_app_count(self,value: Optional[int] = None) -> None:
        """
        Sets the mobileAppCount property value. The number of vulnerable mobile apps.
        Args:
            value: Value to set for the mobileAppCount property.
        """
        self._mobile_app_count = value
    
    @property
    def mobile_apps(self,) -> Optional[List[app_vulnerability_mobile_app.AppVulnerabilityMobileApp]]:
        """
        Gets the mobileApps property value. The vulnerable mobile apps.
        Returns: Optional[List[app_vulnerability_mobile_app.AppVulnerabilityMobileApp]]
        """
        return self._mobile_apps
    
    @mobile_apps.setter
    def mobile_apps(self,value: Optional[List[app_vulnerability_mobile_app.AppVulnerabilityMobileApp]] = None) -> None:
        """
        Sets the mobileApps property value. The vulnerable mobile apps.
        Args:
            value: Value to set for the mobileApps property.
        """
        self._mobile_apps = value
    
    @property
    def remediation(self,) -> Optional[str]:
        """
        Gets the remediation property value. The remediation steps.
        Returns: Optional[str]
        """
        return self._remediation
    
    @remediation.setter
    def remediation(self,value: Optional[str] = None) -> None:
        """
        Sets the remediation property value. The remediation steps.
        Args:
            value: Value to set for the remediation property.
        """
        self._remediation = value
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        super().serialize(writer)
        writer.write_str_value("appName", self.app_name)
        writer.write_str_value("appPublisher", self.app_publisher)
        writer.write_str_value("appVersion", self.app_version)
        writer.write_str_value("insights", self.insights)
        writer.write_int_value("managedDeviceCount", self.managed_device_count)
        writer.write_collection_of_object_values("managedDevices", self.managed_devices)
        writer.write_enum_value("mitigationType", self.mitigation_type)
        writer.write_int_value("mobileAppCount", self.mobile_app_count)
        writer.write_collection_of_object_values("mobileApps", self.mobile_apps)
        writer.write_str_value("remediation", self.remediation)
    

