/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import java.io.IOException;
import java.util.List;
import junit.framework.Assert;
import no.priv.garshol.duke.utils.SparqlClient;
import no.priv.garshol.duke.utils.SparqlResult;
import org.junit.Test;
import org.xml.sax.InputSource;

public class SparqlClientTest {
    @Test
    public void testEmpty() throws IOException {
        SparqlResult result = this.load("sparql-empty.xml");
        Assert.assertEquals((int)0, (int)result.getRows().size());
        Assert.assertEquals((int)0, (int)result.getVariables().size());
    }

    @Test
    public void testOneRow() throws IOException {
        SparqlResult result = this.load("sparql-onerow.xml");
        Assert.assertEquals((int)1, (int)result.getVariables().size());
        Assert.assertEquals((String)"x", (String)((String)result.getVariables().get(0)));
        Assert.assertEquals((int)1, (int)result.getRows().size());
        String[] row = (String[])result.getRows().get(0);
        Assert.assertEquals((int)1, (int)row.length);
        Assert.assertEquals((String)"1", (String)row[0]);
    }

    @Test
    public void testOneRow2Col() throws IOException {
        SparqlResult result = this.load("sparql-onerow2col.xml");
        Assert.assertEquals((int)2, (int)result.getVariables().size());
        Assert.assertEquals((String)"x", (String)((String)result.getVariables().get(0)));
        Assert.assertEquals((String)"y", (String)((String)result.getVariables().get(1)));
        Assert.assertEquals((int)1, (int)result.getRows().size());
        String[] row = (String[])result.getRows().get(0);
        Assert.assertEquals((int)2, (int)row.length);
        Assert.assertEquals((String)"1", (String)row[0]);
        Assert.assertEquals((String)"http://example.org", (String)row[1]);
    }

    @Test
    public void testTwoRow2Col() throws IOException {
        SparqlResult result = this.load("sparql-tworow2col.xml");
        Assert.assertEquals((int)2, (int)result.getVariables().size());
        Assert.assertEquals((String)"x", (String)((String)result.getVariables().get(0)));
        Assert.assertEquals((String)"y", (String)((String)result.getVariables().get(1)));
        List results = result.getRows();
        Assert.assertEquals((int)2, (int)results.size());
        String[] row = (String[])results.get(0);
        Assert.assertEquals((int)2, (int)row.length);
        Assert.assertEquals((String)"1", (String)row[0]);
        Assert.assertEquals((String)"http://example.org", (String)row[1]);
        row = (String[])results.get(1);
        Assert.assertEquals((int)2, (int)row.length);
        Assert.assertEquals((String)"2", (String)row[0]);
        Assert.assertEquals((String)"http://example.com", (String)row[1]);
    }

    @Test
    public void testTwoRow2ColInconsistent() throws IOException {
        SparqlResult result = this.load("sparql-tworow2col-inconsistent.xml");
        Assert.assertEquals((int)2, (int)result.getVariables().size());
        Assert.assertEquals((String)"x", (String)((String)result.getVariables().get(0)));
        Assert.assertEquals((String)"y", (String)((String)result.getVariables().get(1)));
        List results = result.getRows();
        Assert.assertEquals((int)2, (int)results.size());
        String[] row = (String[])results.get(0);
        Assert.assertEquals((int)2, (int)row.length);
        Assert.assertEquals((String)"1", (String)row[0]);
        Assert.assertEquals((String)"http://example.org", (String)row[1]);
        row = (String[])results.get(1);
        Assert.assertEquals((int)2, (int)row.length);
        Assert.assertEquals((String)"2", (String)row[0]);
        Assert.assertEquals((String)"http://example.com", (String)row[1]);
    }

    @Test
    public void testBnode() throws IOException {
        SparqlResult result = this.load("sparql-bnode.xml");
        Assert.assertEquals((int)1, (int)result.getVariables().size());
        Assert.assertEquals((String)"x", (String)((String)result.getVariables().get(0)));
        Assert.assertEquals((int)1, (int)result.getRows().size());
        String[] row = (String[])result.getRows().get(0);
        Assert.assertEquals((int)1, (int)row.length);
        Assert.assertEquals((String)"r2", (String)row[0]);
    }

    private SparqlResult load(String file) throws IOException {
        return SparqlClient.loadResultSet((InputSource)this.getStream(file));
    }

    private InputSource getStream(String file) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return new InputSource(cl.getResourceAsStream(file));
    }
}

