/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.ConfigurationImpl;
import no.priv.garshol.duke.DataSource;
import no.priv.garshol.duke.Processor;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.PropertyImpl;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordIterator;
import no.priv.garshol.duke.comparators.Levenshtein;
import no.priv.garshol.duke.datasources.InMemoryDataSource;
import no.priv.garshol.duke.matchers.MatchListener;
import no.priv.garshol.duke.utils.DefaultRecordIterator;
import no.priv.garshol.duke.utils.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeduplicatorTest {
    private ConfigurationImpl config;
    private Processor processor;
    private TestUtils.TestListener listener;

    @Before
    public void setup() throws IOException {
        this.listener = new TestUtils.TestListener();
        Levenshtein comp = new Levenshtein();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        props.add(new PropertyImpl("NAME", (Comparator)comp, 0.3, 0.8));
        props.add(new PropertyImpl("EMAIL", (Comparator)comp, 0.3, 0.8));
        this.config = new ConfigurationImpl();
        this.config.setProperties(props);
        this.config.setThreshold(0.85);
        this.config.setMaybeThreshold(0.8);
        this.processor = new Processor((Configuration)this.config, true);
        this.processor.addMatchListener((MatchListener)this.listener);
    }

    @After
    public void cleanup() throws IOException {
        this.processor.close();
    }

    @Test
    public void testEmpty() throws IOException {
        this.processor.deduplicate(new ArrayList());
        Assert.assertEquals((long)0L, (long)this.listener.getMatches().size());
        Assert.assertEquals((long)0L, (long)this.listener.getRecordCount());
    }

    @Test
    public void testNoProperties() throws IOException {
        ArrayList<Record> records = new ArrayList<Record>();
        records.add(TestUtils.makeRecord());
        records.add(TestUtils.makeRecord());
        this.processor.deduplicate(records);
        Assert.assertEquals((long)0L, (long)this.listener.getMatches().size());
        Assert.assertEquals((long)2L, (long)this.listener.getRecordCount());
    }

    @Test
    public void testDoesNotMatch() throws IOException {
        ArrayList<Record> records = new ArrayList<Record>();
        records.add(TestUtils.makeRecord("ID", "1", "NAME", "A"));
        records.add(TestUtils.makeRecord("ID", "2", "NAME", "B"));
        this.processor.deduplicate(records);
        Assert.assertEquals((long)0L, (long)this.listener.getMatches().size());
        Assert.assertEquals((long)2L, (long)this.listener.getRecordCount());
    }

    @Test
    public void testDoesNotMatchEnough() throws IOException {
        ArrayList<Record> records = new ArrayList<Record>();
        records.add(TestUtils.makeRecord("ID", "1", "NAME", "A"));
        records.add(TestUtils.makeRecord("ID", "2", "NAME", "A"));
        this.processor.deduplicate(records);
        Assert.assertEquals((long)0L, (long)this.listener.getMatches().size());
        Assert.assertEquals((long)2L, (long)this.listener.getRecordCount());
    }

    @Test
    public void testMatches1() throws IOException {
        ArrayList<Record> records = new ArrayList<Record>();
        records.add(TestUtils.makeRecord("ID", "1", "NAME", "aaaaa", "EMAIL", "BBBBB"));
        records.add(TestUtils.makeRecord("ID", "2", "NAME", "aaaaa", "EMAIL", "BBBBB"));
        this.processor.deduplicate(records);
        Assert.assertEquals((long)2L, (long)this.listener.getRecordCount());
        List<TestUtils.Pair> matches = this.listener.getMatches();
        Assert.assertEquals((long)2L, (long)matches.size());
    }

    @Test
    public void testMatches2() throws IOException {
        ArrayList<Record> records = new ArrayList<Record>();
        records.add(TestUtils.makeRecord("ID", "1", "NAME", "AAAAA", "EMAIL", "BBBBB"));
        records.add(TestUtils.makeRecord("ID", "2", "NAME", "AAAAA", "EMAIL", "BBBBB"));
        this.processor.deduplicate(records);
        Assert.assertEquals((long)2L, (long)this.listener.getRecordCount());
        List<TestUtils.Pair> matches = this.listener.getMatches();
        Assert.assertEquals((long)2L, (long)matches.size());
    }

    @Test
    public void testLuceneKeyword() throws IOException {
        ArrayList<Record> records = new ArrayList<Record>();
        records.add(TestUtils.makeRecord("ID", "1", "NAME", "AND", "EMAIL", "BBBBB"));
        records.add(TestUtils.makeRecord("ID", "2", "NAME", "AND", "EMAIL", "BBBBB"));
        this.processor.deduplicate(records);
        Assert.assertEquals((long)2L, (long)this.listener.getRecordCount());
        List<TestUtils.Pair> matches = this.listener.getMatches();
        Assert.assertEquals((long)2L, (long)matches.size());
    }

    @Test
    public void testMultiToken() throws IOException {
        ArrayList<Record> records = new ArrayList<Record>();
        records.add(TestUtils.makeRecord("ID", "1", "NAME", "aaaaaaaaa aaaaa", "EMAIL", "bbbbb"));
        records.add(TestUtils.makeRecord("ID", "2", "NAME", "aaaaaaaaa aaaab", "EMAIL", "bbbbb"));
        this.processor.deduplicate(records);
        Assert.assertEquals((long)2L, (long)this.listener.getRecordCount());
        List<TestUtils.Pair> matches = this.listener.getMatches();
        Assert.assertEquals((long)2L, (long)matches.size());
    }

    @Test
    public void testMaybe() throws IOException {
        this.config.setMaybeThreshold(0.0);
        ArrayList<Record> records = new ArrayList<Record>();
        records.add(TestUtils.makeRecord("ID", "1", "NAME", "aaaaaa", "EMAIL", "bbbbb"));
        records.add(TestUtils.makeRecord("ID", "2", "NAME", "bbbb", "EMAIL", "bbbbb"));
        this.processor.deduplicate(records);
        List<TestUtils.Pair> matches = this.listener.getMatches();
        Assert.assertEquals((String)"wrong number of records processed", (long)2L, (long)this.listener.getRecordCount());
        Assert.assertEquals((String)"found matches, but shouldn't have", (long)0L, (long)matches.size());
        Assert.assertEquals((String)"found maybe matches, but shouldn't have", (long)0L, (long)this.listener.getMaybeCount());
        Assert.assertEquals((String)"wrong number of no-matches", (long)2L, (long)this.listener.getNoMatchCount());
    }

    @Test
    public void testNoComparator() throws IOException {
        this.config.getPropertyByName("EMAIL").setComparator(null);
        ArrayList<Record> records = new ArrayList<Record>();
        records.add(TestUtils.makeRecord("ID", "1", "NAME", "aaaaa", "EMAIL", "BBBBB"));
        records.add(TestUtils.makeRecord("ID", "2", "NAME", "aaaaa", "EMAIL", "BBBBB"));
        this.processor.deduplicate(records);
        Assert.assertEquals((long)0L, (long)this.listener.getMatches().size());
        Assert.assertEquals((long)2L, (long)this.listener.getRecordCount());
    }

    @Test
    public void testIgnoreProperty() throws IOException {
        Property prop = this.config.getPropertyByName("EMAIL");
        prop.setIgnoreProperty(true);
        ArrayList<Record> records = new ArrayList<Record>();
        records.add(TestUtils.makeRecord("ID", "1", "NAME", "aaaaa", "EMAIL", "BBBBB"));
        records.add(TestUtils.makeRecord("ID", "2", "NAME", "aaaaa", "EMAIL", "BBBBB"));
        this.processor.deduplicate(records);
        Assert.assertEquals((long)0L, (long)this.listener.getMatches().size());
    }

    @Test
    public void testBatchRemainder() throws IOException {
        ArrayList<Record> records = new ArrayList<Record>();
        records.add(TestUtils.makeRecord("ID", "1", "NAME", "aaaaa", "EMAIL", "BBBBB"));
        records.add(TestUtils.makeRecord("ID", "2", "NAME", "aaaaa", "EMAIL", "BBBBB"));
        records.add(TestUtils.makeRecord("ID", "3", "NAME", "aaaaa", "EMAIL", "BBBBB"));
        TestDataSource source = new TestDataSource(records);
        this.config.addDataSource(0, (DataSource)source);
        this.processor.deduplicate(2);
        Assert.assertEquals((String)"wrong number of matches", (long)4L, (long)this.listener.getMatches().size());
        Assert.assertEquals((String)"wrong number of records processed", (long)3L, (long)this.listener.getRecordCount());
        Assert.assertEquals((String)"wrong number of batches", (long)2L, (long)source.getBatchCount());
    }

    static class TestRecordIterator
    extends DefaultRecordIterator {
        private TestDataSource source;

        public TestRecordIterator(TestDataSource source, Iterator<Record> it) {
            super(it);
            this.source = source;
        }

        public void batchProcessed() {
            this.source.batchProcessed();
        }
    }

    static class TestDataSource
    extends InMemoryDataSource {
        private int batch_count;

        public TestDataSource(Collection<Record> records) {
            super(records);
        }

        public RecordIterator getRecords() {
            return new TestRecordIterator(this, this.records.iterator());
        }

        public void batchProcessed() {
            ++this.batch_count;
        }

        public int getBatchCount() {
            return this.batch_count;
        }
    }
}

