/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Assert;
import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.ConfigLoader;
import no.priv.garshol.duke.ConfigWriter;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.ConfigurationImpl;
import no.priv.garshol.duke.DataSource;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.PropertyImpl;
import no.priv.garshol.duke.comparators.Levenshtein;
import no.priv.garshol.duke.datasources.CSVDataSource;
import no.priv.garshol.duke.datasources.Column;
import no.priv.garshol.duke.datasources.JDBCDataSource;
import no.priv.garshol.duke.datasources.JNDIDataSource;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.xml.sax.SAXException;

public class ConfigWriterTest {
    @Rule
    public TemporaryFolder tmpdir = new TemporaryFolder();

    @Test
    public void testEmpty() throws IOException, SAXException {
        Configuration config = ConfigLoader.load((String)"classpath:config-empty.xml");
        Assert.assertTrue((boolean)config.getDataSources().isEmpty());
        Assert.assertTrue((boolean)config.getDataSources(1).isEmpty());
        Assert.assertTrue((boolean)config.getDataSources(2).isEmpty());
        Assert.assertEquals((Object)config.getThreshold(), (Object)0.4);
        Assert.assertEquals((Object)config.getMaybeThreshold(), (Object)0.0);
        Assert.assertTrue((boolean)config.getProperties().isEmpty());
        File outfile = this.tmpdir.newFile("config.xml");
        ConfigWriter writer = new ConfigWriter((OutputStream)new FileOutputStream(outfile.getAbsolutePath()));
        writer.write(config);
        config = ConfigLoader.load((String)outfile.getAbsolutePath());
        Assert.assertTrue((boolean)config.getDataSources().isEmpty());
        Assert.assertTrue((boolean)config.getDataSources(1).isEmpty());
        Assert.assertTrue((boolean)config.getDataSources(2).isEmpty());
        Assert.assertEquals((Object)config.getThreshold(), (Object)0.4);
        Assert.assertEquals((Object)config.getMaybeThreshold(), (Object)0.0);
        Assert.assertTrue((boolean)config.getProperties().isEmpty());
    }

    @Test
    public void testDefaultProbs() throws IOException, SAXException {
        Levenshtein lev = new Levenshtein();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        props.add(new PropertyImpl("NAME", (Comparator)lev, 0.3, 0.8));
        props.add(new PropertyImpl("EMAIL", (Comparator)lev, 0.3, 0.8));
        ConfigurationImpl config = new ConfigurationImpl();
        config.setProperties(props);
        config.setThreshold(0.85);
        config.setMaybeThreshold(0.7);
        File outfile = this.tmpdir.newFile("config.xml");
        ConfigWriter writer = new ConfigWriter((OutputStream)new FileOutputStream(outfile.getAbsolutePath()));
        writer.write((Configuration)config);
        config = ConfigLoader.load((String)outfile.getAbsolutePath());
        Assert.assertTrue((boolean)config.getDataSources().isEmpty());
        Assert.assertTrue((boolean)config.getDataSources(1).isEmpty());
        Assert.assertTrue((boolean)config.getDataSources(2).isEmpty());
        Assert.assertEquals((Object)config.getThreshold(), (Object)0.85);
        Assert.assertEquals((Object)config.getMaybeThreshold(), (Object)0.7);
        Assert.assertEquals((int)3, (int)config.getProperties().size());
        Property prop = config.getPropertyByName("ID");
        Assert.assertTrue((String)"ID property lost", (boolean)prop.isIdProperty());
        prop = config.getPropertyByName("NAME");
        Assert.assertEquals(lev.getClass(), prop.getComparator().getClass());
        Assert.assertEquals((Object)0.3, (Object)prop.getLowProbability());
        Assert.assertEquals((Object)0.8, (Object)prop.getHighProbability());
        prop = config.getPropertyByName("EMAIL");
        Assert.assertEquals(lev.getClass(), prop.getComparator().getClass());
        Assert.assertEquals((Object)0.3, (Object)prop.getLowProbability());
        Assert.assertEquals((Object)0.8, (Object)prop.getHighProbability());
    }

    @Test
    public void testCSV() throws IOException, SAXException {
        Levenshtein lev = new Levenshtein();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        props.add(new PropertyImpl("NAME", (Comparator)lev, 0.3, 0.8));
        props.add(new PropertyImpl("EMAIL", (Comparator)lev, 0.3, 0.8));
        ConfigurationImpl config = new ConfigurationImpl();
        config.setProperties(props);
        config.setThreshold(0.85);
        config.setMaybeThreshold(0.7);
        CSVDataSource csv = new CSVDataSource();
        csv.setInputFile("test.csv");
        csv.addColumn(new Column("id", "ID", null, null));
        csv.addColumn(new Column("name", "NAME", null, null));
        Column emailCol = new Column("email", "EMAIL", null, null);
        emailCol.setSplitOn(";");
        csv.addColumn(emailCol);
        config.addDataSource(0, (DataSource)csv);
        File outfile = this.tmpdir.newFile("config.xml");
        ConfigWriter writer = new ConfigWriter((OutputStream)new FileOutputStream(outfile.getAbsolutePath()));
        writer.write((Configuration)config);
        config = ConfigLoader.load((String)outfile.getAbsolutePath());
        Assert.assertEquals((int)1, (int)config.getDataSources().size());
        csv = (CSVDataSource)config.getDataSources().iterator().next();
        Assert.assertTrue((boolean)csv.getInputFile().endsWith("test.csv"));
        Assert.assertEquals((int)3, (int)csv.getColumns().size());
        Collection csvEmailColList = csv.getColumn("email");
        Column csvEmailCol = (Column)csvEmailColList.toArray()[0];
        Assert.assertTrue((boolean)csvEmailCol.isSplit());
        Assert.assertTrue((boolean)config.getDataSources(1).isEmpty());
        Assert.assertTrue((boolean)config.getDataSources(2).isEmpty());
        Assert.assertEquals((Object)config.getThreshold(), (Object)0.85);
        Assert.assertEquals((Object)config.getMaybeThreshold(), (Object)0.7);
        Assert.assertEquals((int)3, (int)config.getProperties().size());
        Property prop = config.getPropertyByName("ID");
        Assert.assertTrue((String)"ID property lost", (boolean)prop.isIdProperty());
        prop = config.getPropertyByName("NAME");
        Assert.assertEquals(lev.getClass(), prop.getComparator().getClass());
        Assert.assertEquals((Object)0.3, (Object)prop.getLowProbability());
        Assert.assertEquals((Object)0.8, (Object)prop.getHighProbability());
        prop = config.getPropertyByName("EMAIL");
        Assert.assertEquals(lev.getClass(), prop.getComparator().getClass());
        Assert.assertEquals((Object)0.3, (Object)prop.getLowProbability());
        Assert.assertEquals((Object)0.8, (Object)prop.getHighProbability());
    }

    @Test
    public void testJDBC() throws IOException, SAXException {
        Levenshtein lev = new Levenshtein();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        props.add(new PropertyImpl("NAME", (Comparator)lev, 0.3, 0.8));
        props.add(new PropertyImpl("EMAIL", (Comparator)lev, 0.3, 0.8));
        ConfigurationImpl config = new ConfigurationImpl();
        config.setProperties(props);
        config.setThreshold(0.85);
        config.setMaybeThreshold(0.7);
        JDBCDataSource jdbc = new JDBCDataSource();
        jdbc.setDriverClass("klass");
        jdbc.setConnectionString("konnection");
        jdbc.setUserName("user");
        jdbc.setPassword("secret");
        jdbc.setQuery("select");
        jdbc.addColumn(new Column("id", "ID", null, null));
        jdbc.addColumn(new Column("name", "NAME", null, null));
        jdbc.addColumn(new Column("email", "EMAIL", null, null));
        config.addDataSource(0, (DataSource)jdbc);
        File outfile = this.tmpdir.newFile("config.xml");
        ConfigWriter writer = new ConfigWriter((OutputStream)new FileOutputStream(outfile.getAbsolutePath()));
        writer.write((Configuration)config);
        config = ConfigLoader.load((String)outfile.getAbsolutePath());
        Assert.assertEquals((int)1, (int)config.getDataSources().size());
        jdbc = (JDBCDataSource)config.getDataSources().iterator().next();
        Assert.assertEquals((String)"klass", (String)jdbc.getDriverClass());
        Assert.assertEquals((String)"konnection", (String)jdbc.getConnectionString());
        Assert.assertEquals((String)"user", (String)jdbc.getUserName());
        Assert.assertEquals((String)"secret", (String)jdbc.getPassword());
        Assert.assertEquals((String)"select", (String)jdbc.getQuery());
        Assert.assertEquals((int)3, (int)jdbc.getColumns().size());
        Assert.assertTrue((boolean)config.getDataSources(1).isEmpty());
        Assert.assertTrue((boolean)config.getDataSources(2).isEmpty());
        Assert.assertEquals((Object)config.getThreshold(), (Object)0.85);
        Assert.assertEquals((Object)config.getMaybeThreshold(), (Object)0.7);
        Assert.assertEquals((int)3, (int)config.getProperties().size());
        Property prop = config.getPropertyByName("ID");
        Assert.assertTrue((String)"ID property lost", (boolean)prop.isIdProperty());
        prop = config.getPropertyByName("NAME");
        Assert.assertEquals(lev.getClass(), prop.getComparator().getClass());
        Assert.assertEquals((Object)0.3, (Object)prop.getLowProbability());
        Assert.assertEquals((Object)0.8, (Object)prop.getHighProbability());
        prop = config.getPropertyByName("EMAIL");
        Assert.assertEquals(lev.getClass(), prop.getComparator().getClass());
        Assert.assertEquals((Object)0.3, (Object)prop.getLowProbability());
        Assert.assertEquals((Object)0.8, (Object)prop.getHighProbability());
    }

    @Test
    public void testJNDI() throws IOException, SAXException {
        Levenshtein lev = new Levenshtein();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        props.add(new PropertyImpl("NAME", (Comparator)lev, 0.3, 0.8));
        props.add(new PropertyImpl("EMAIL", (Comparator)lev, 0.3, 0.8));
        ConfigurationImpl config = new ConfigurationImpl();
        config.setProperties(props);
        config.setThreshold(0.85);
        config.setMaybeThreshold(0.7);
        JNDIDataSource jndi = new JNDIDataSource();
        jndi.setJndiPath("path");
        jndi.setQuery("select");
        jndi.addColumn(new Column("id", "ID", null, null));
        jndi.addColumn(new Column("name", "NAME", null, null));
        jndi.addColumn(new Column("email", "EMAIL", null, null));
        config.addDataSource(0, (DataSource)jndi);
        File outfile = this.tmpdir.newFile("config.xml");
        ConfigWriter writer = new ConfigWriter((OutputStream)new FileOutputStream(outfile.getAbsolutePath()));
        writer.write((Configuration)config);
        config = ConfigLoader.load((String)outfile.getAbsolutePath());
        Assert.assertEquals((int)1, (int)config.getDataSources().size());
        jndi = (JNDIDataSource)config.getDataSources().iterator().next();
        Assert.assertEquals((String)"select", (String)jndi.getQuery());
        Assert.assertEquals((int)3, (int)jndi.getColumns().size());
        Assert.assertTrue((boolean)config.getDataSources(1).isEmpty());
        Assert.assertTrue((boolean)config.getDataSources(2).isEmpty());
        Assert.assertEquals((Object)config.getThreshold(), (Object)0.85);
        Assert.assertEquals((Object)config.getMaybeThreshold(), (Object)0.7);
        Assert.assertEquals((int)3, (int)config.getProperties().size());
        Property prop = config.getPropertyByName("ID");
        Assert.assertTrue((String)"ID property lost", (boolean)prop.isIdProperty());
        prop = config.getPropertyByName("NAME");
        Assert.assertEquals(lev.getClass(), prop.getComparator().getClass());
        Assert.assertEquals((Object)0.3, (Object)prop.getLowProbability());
        Assert.assertEquals((Object)0.8, (Object)prop.getHighProbability());
        prop = config.getPropertyByName("EMAIL");
        Assert.assertEquals(lev.getClass(), prop.getComparator().getClass());
        Assert.assertEquals((Object)0.3, (Object)prop.getLowProbability());
        Assert.assertEquals((Object)0.8, (Object)prop.getHighProbability());
    }
}

