# Generated by Django 3.2.12 on 2022-03-11 23:23

from django.db import migrations, models

from payments import PaymentStatus

def create_invoices(apps, schema_editor):
    db_alias = schema_editor.connection.alias

    Person = apps.get_model("core", "Person")
    EventRegistration = apps.get_model("paweljong", "EventRegistration")
    SEPAMandate = apps.get_model("djp_sepa", "SEPAMandate")

    from aleksis.apps.paweljong.models import EventRegistration as RealEventRegistration

    EventRegistration.get_invoice = RealEventRegistration.get_invoice
    EventRegistration._get_total_amount = RealEventRegistration._get_total_amount
    EventRegistration.get_purchased_items = RealEventRegistration.get_purchased_items
    Person.addressing_name = property(lambda p: p.first_name + " " + p.last_name)

    for registration in EventRegistration.objects.using(db_alias).all():
        invoice = registration.get_invoice()
        invoice.status = PaymentStatus.PREAUTH
        if registration.accept_sepa:
            invoice.variant = "sdd"
            SEPAMandate.objects.create(payment_id=invoice.pk, account_holder=f"{registration.person.addressing_name}", iban=registration.iban, bic="XXXXXXXXXXX", date=registration.date_registered)
        else:
            invoice.variant = "pledge"
        invoice.save()


class Migration(migrations.Migration):

    dependencies = [
        ('paweljong', '0017_fix_voucher_max_length'),
        ('tezor', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(create_invoices),
        migrations.RemoveField(
            model_name='eventregistration',
            name='accept_sepa',
        ),
        migrations.RemoveField(
            model_name='eventregistration',
            name='iban',
        ),
    ]
