"""This files contains code to create the atom struct files
for hexon 1 and h2 (chains aA,b,C and D,E,F) of adenovirus
with PDBid= 6qi5
"""
import os

h1="""data_atom
# 
_pdbx_database_status.entry_id                           atom 
_pdbx_database_status.ndb_tid                            ? 
_pdbx_database_status.status_code                        ? 
_pdbx_database_status.status_code_sf                     ? 
_pdbx_database_status.status_code_mr                     ? 
_pdbx_database_status.status_code_cs                     ? 
_pdbx_database_status.status_coordinates_in_NDB          ? 
_pdbx_database_status.recvd_deposit_form                 ? 
_pdbx_database_status.date_deposition_form               ? 
_pdbx_database_status.recvd_coordinates                  ? 
_pdbx_database_status.date_coordinates                   ? 
_pdbx_database_status.recvd_struct_fact                  ? 
_pdbx_database_status.date_struct_fact                   ? 
_pdbx_database_status.recvd_internal_approval            ? 
_pdbx_database_status.recvd_nmr_constraints              ? 
_pdbx_database_status.date_nmr_constraints               ? 
_pdbx_database_status.recvd_chemical_shifts              ? 
_pdbx_database_status.date_chemical_shifts               ? 
_pdbx_database_status.recvd_manuscript                   ? 
_pdbx_database_status.date_manuscript                    ? 
_pdbx_database_status.name_depositor                     ? 
_pdbx_database_status.pdbx_annotator                     ? 
_pdbx_database_status.recvd_author_approval              ? 
_pdbx_database_status.date_author_approval               ? 
_pdbx_database_status.recvd_initial_deposition_date      ? 
_pdbx_database_status.date_submitted                     ? 
_pdbx_database_status.author_approval_type               ? 
_pdbx_database_status.author_release_status_code         ? 
_pdbx_database_status.auth_req_rel_date                  ? 
_pdbx_database_status.date_revised                       ? 
_pdbx_database_status.revision_id                        ? 
_pdbx_database_status.replaced_entry_id                  ? 
_pdbx_database_status.revision_description               ? 
_pdbx_database_status.date_of_NDB_release                ? 
_pdbx_database_status.date_released_to_PDB               ? 
_pdbx_database_status.date_of_PDB_release                ? 
_pdbx_database_status.date_of_sf_release                 ? 
_pdbx_database_status.date_of_mr_release                 ? 
_pdbx_database_status.date_of_cs_release                 ? 
_pdbx_database_status.date_hold_coordinates              ? 
_pdbx_database_status.date_hold_struct_fact              ? 
_pdbx_database_status.hold_for_publication               ? 
_pdbx_database_status.date_hold_nmr_constraints          ? 
_pdbx_database_status.date_hold_chemical_shifts          ? 
_pdbx_database_status.dep_release_code_coordinates       ? 
_pdbx_database_status.dep_release_code_struct_fact       ? 
_pdbx_database_status.dep_release_code_nmr_constraints   ? 
_pdbx_database_status.dep_release_code_chemical_shifts   ? 
_pdbx_database_status.dep_release_code_sequence          ? 
_pdbx_database_status.pdb_date_of_author_approval        ? 
_pdbx_database_status.deposit_site                       ? 
_pdbx_database_status.process_site                       ? 
_pdbx_database_status.skip_PDB_REMARK                    ? 
_pdbx_database_status.SG_entry                           ? 
_pdbx_database_status.date_begin_deposition              ? 
_pdbx_database_status.date_author_release_request        ? 
_pdbx_database_status.date_begin_release_preparation     ? 
_pdbx_database_status.date_begin_processing              ? 
_pdbx_database_status.date_end_processing                ? 
_pdbx_database_status.pdb_format_compatible              Y 
_pdbx_database_status.title_suppression                  ? 
_pdbx_database_status.methods_development_category       ? 
# 
loop_
_entity_poly.entity_id 
_entity_poly.type 
_entity_poly.nstd_linkage 
_entity_poly.nstd_monomer 
_entity_poly.pdbx_seq_one_letter_code 
_entity_poly.pdbx_seq_one_letter_code_can 
_entity_poly.pdbx_sequence_evidence_code 
_entity_poly.pdbx_strand_id 
_entity_poly.pdbx_target_identifier 
1 "polypeptide(L)" no no 
;MEPQREFFHIAGRSAKEYLSENLVQFIQATQNYFNIGEKFRDPYVAPSAGVTTDRSQKLQLRVVPIQTEDNVNYYKARFT
LNVGDNRLVDLGSSYFDIKGTLDRGPSFKPYGGTAYNPLAPKSAPINSAFTVGNDTHFVAQLPQTYAAGGTGVTEAIQQQ
VSGVDPNPQVGQPNYAGPVVVNTTNNAGLGRIVSADSEGQQFPCYGAYAPPQSAGGDVSTAAVTKTYINTTNNNGRVSGT
MATDTITWENPDAHFADFVDDRRATAAGNRPNYIGFRDNFIGMMYYNSGSNTGSFSSQTQQLNIVLDLNDRNSELSYQYL
LADLTSRWHYFALWNQAVDDYDHHVRILENDGYEEGPPNLAFPPHVISNPFAPAAVGTGMTVNEQQQTAAVTANTVALIG
YGNIPAVEMNLPANLKRTFLYSNVAMYLPDTYKFTPANVDLPENHLSYGYINGRLPLPNIVDTWTDIGARWSLDVMDTVN
PFNHHRNTGLKYRSQLLGNGRYCDFHIQVPQKFFAIKNLLLLPGTYNYEWYFRKDPNMVLQSTLGNDLRADGASITYTQI
NLYVSFFPMNYDTQSELELMLRNATNDQNFSDYLGAVNNLYQIPAGSSTVVVNIPDRSWGAFRGWSFTRLKVSETPRIGA
TQDPNFQYSGSIPYLDGTFYLSHTFQRCSIQWDSSVPWPGNDRMLTPNWFEIKRPINQDAEGNDTMQSNLTKDFFMVQMA
ASYNQGYQGFNWPNCTKHYGFINNFEPMSRQVPEYGANYPNLMAAYLANPQTMPIWNNCGFQQKTATNVLLERCGHPYVA
NWPYPLSGRNAVPNQVTERKFLVDRYLWQIPFSSNFLNMGTLTDLGQNVMYANSSHSLNMQFTVDPMTEPTYLMLLFGVF
DQVVINQPTRSGISVAYLRLPFASG
;
;MEPQREFFHIAGRSAKEYLSENLVQFIQATQNYFNIGEKFRDPYVAPSAGVTTDRSQKLQLRVVPIQTEDNVNYYKARFT
LNVGDNRLVDLGSSYFDIKGTLDRGPSFKPYGGTAYNPLAPKSAPINSAFTVGNDTHFVAQLPQTYAAGGTGVTEAIQQQ
VSGVDPNPQVGQPNYAGPVVVNTTNNAGLGRIVSADSEGQQFPCYGAYAPPQSAGGDVSTAAVTKTYINTTNNNGRVSGT
MATDTITWENPDAHFADFVDDRRATAAGNRPNYIGFRDNFIGMMYYNSGSNTGSFSSQTQQLNIVLDLNDRNSELSYQYL
LADLTSRWHYFALWNQAVDDYDHHVRILENDGYEEGPPNLAFPPHVISNPFAPAAVGTGMTVNEQQQTAAVTANTVALIG
YGNIPAVEMNLPANLKRTFLYSNVAMYLPDTYKFTPANVDLPENHLSYGYINGRLPLPNIVDTWTDIGARWSLDVMDTVN
PFNHHRNTGLKYRSQLLGNGRYCDFHIQVPQKFFAIKNLLLLPGTYNYEWYFRKDPNMVLQSTLGNDLRADGASITYTQI
NLYVSFFPMNYDTQSELELMLRNATNDQNFSDYLGAVNNLYQIPAGSSTVVVNIPDRSWGAFRGWSFTRLKVSETPRIGA
TQDPNFQYSGSIPYLDGTFYLSHTFQRCSIQWDSSVPWPGNDRMLTPNWFEIKRPINQDAEGNDTMQSNLTKDFFMVQMA
ASYNQGYQGFNWPNCTKHYGFINNFEPMSRQVPEYGANYPNLMAAYLANPQTMPIWNNCGFQQKTATNVLLERCGHPYVA
NWPYPLSGRNAVPNQVTERKFLVDRYLWQIPFSSNFLNMGTLTDLGQNVMYANSSHSLNMQFTVDPMTEPTYLMLLFGVF
DQVVINQPTRSGISVAYLRLPFASG
;
"derived from coordinates" A ? 
2 "polypeptide(L)" no no 
;MEPQREFFHIAGRSAKEYLSENLVQFIQATQNYFNIGEKFRDPYVAPSAGVTTDRSQKLQLRVVPIQTEDNVNYYKARFT
LNVGDNRLVDLGSSYFDIKGTLDRGPSFKPYGGTAYNPLAPKSAPINSAFTVGNDTHFVAQLPQTYAAGGTGVTEAIQQQ
VSGVDPNPQVGQPNYAGPVVVNTTNNAGLGRIVSADSEGQQFPCYGAYAPPQSAGGDVSTAAVTKTYINTTNNNGRVSGT
MATDTITWENPDAHFADFVDDRRATAAGNRPNYIGFRDNFIGMMYYNSGSNTGSFSSQTQQLNIVLDLNDRNSELSYQYL
LADLTSRWHYFALWNQAVDDYDHHVRILENDGYEEGPPNLAFPPHVISNPFAPAAVGTGMTVNEQQQTAAVTANTVALIG
YGNIPAVEMNLPANLKRTFLYSNVAMYLPDTYKFTPANVDLPENHLSYGYINGRLPLPNIVDTWTDIGARWSLDVMDTVN
PFNHHRNTGLKYRSQLLGNGRYCDFHIQVPQKFFAIKNLLLLPGTYNYEWYFRKDPNMVLQSTLGNDLRADGASITYTQI
NLYVSFFPMNYDTQSELELMLRNATNDQNFSDYLGAVNNLYQIPAGSSTVVVNIPDRSWGAFRGWSFTRLKVSETPRIGA
TQDPNFQYSGSIPYLDGTFYLSHTFQRCSIQWDSSVPWPGNDRMLTPNWFEIKRPINQDAEGNDTMQSNLTKDFFMVQMA
ASYNQGYQGFNWPNCTKHYGFINNFEPMSRQVPEYGANYPNLMAAYLANPQTMPIWNNCGFQQKTATNVLLERCGHPYVA
NWPYPLSGRNAVPNQVTERKFLVDRYLWQIPFSSNFLNMGTLTDLGQNVMYANSSHSLNMQFTVDPMTEPTYLMLLFGVF
DQVINQPTRSGISVAYLRLPFASG
;
;MEPQREFFHIAGRSAKEYLSENLVQFIQATQNYFNIGEKFRDPYVAPSAGVTTDRSQKLQLRVVPIQTEDNVNYYKARFT
LNVGDNRLVDLGSSYFDIKGTLDRGPSFKPYGGTAYNPLAPKSAPINSAFTVGNDTHFVAQLPQTYAAGGTGVTEAIQQQ
VSGVDPNPQVGQPNYAGPVVVNTTNNAGLGRIVSADSEGQQFPCYGAYAPPQSAGGDVSTAAVTKTYINTTNNNGRVSGT
MATDTITWENPDAHFADFVDDRRATAAGNRPNYIGFRDNFIGMMYYNSGSNTGSFSSQTQQLNIVLDLNDRNSELSYQYL
LADLTSRWHYFALWNQAVDDYDHHVRILENDGYEEGPPNLAFPPHVISNPFAPAAVGTGMTVNEQQQTAAVTANTVALIG
YGNIPAVEMNLPANLKRTFLYSNVAMYLPDTYKFTPANVDLPENHLSYGYINGRLPLPNIVDTWTDIGARWSLDVMDTVN
PFNHHRNTGLKYRSQLLGNGRYCDFHIQVPQKFFAIKNLLLLPGTYNYEWYFRKDPNMVLQSTLGNDLRADGASITYTQI
NLYVSFFPMNYDTQSELELMLRNATNDQNFSDYLGAVNNLYQIPAGSSTVVVNIPDRSWGAFRGWSFTRLKVSETPRIGA
TQDPNFQYSGSIPYLDGTFYLSHTFQRCSIQWDSSVPWPGNDRMLTPNWFEIKRPINQDAEGNDTMQSNLTKDFFMVQMA
ASYNQGYQGFNWPNCTKHYGFINNFEPMSRQVPEYGANYPNLMAAYLANPQTMPIWNNCGFQQKTATNVLLERCGHPYVA
NWPYPLSGRNAVPNQVTERKFLVDRYLWQIPFSSNFLNMGTLTDLGQNVMYANSSHSLNMQFTVDPMTEPTYLMLLFGVF
DQVINQPTRSGISVAYLRLPFASG
;
"derived from coordinates" B ? 
3 "polypeptide(L)" no no 
;MEPQREFFHIAGRSAKEYLSENLVQFIQATQNYFNIGEKFRDPYVAPSAGVTTDRSQKLQLRVVPIQTEDNVNYYKARFT
LNVGDNRLVDLGSSYFDIKGTLDRGPSFKPYGGTAYNPLAPKSAPINSAFTVGNDTHFVAQLPQTYAAGGTGVTEAIQQQ
VSGVDPNPQVGQPNYAGPVVVNTTNNAGLGRIVSADSEGQQFPCYGAYAPPQSAGGDVSTAAVTKTYINTTNNNGRVSGT
MATDTITWENPDAHFADFVDDRRATAAGNRPNYIGFRDNFIGMMYYNSGSNTGSFSSQTQQLNIVLDLNDRNSELSYQYL
LADLTSRWHYFALWNQAVDDYDHHVRILENDGYEEGPPNLAFPPHVISNPFAPAAVGTGMTVNEQQQTAAVTANTVALIG
YGNIPAVEMNLPANLKRTFLYSNVAMYLPDTYKFTPANVDLPENHLSYGYINGRLPLPNIVDTWTDIGARWSLDVMDTVN
PFNHHRNTGLKYRSQLLGNGRYCDFHIQVPQKFFAIKNLLLLPGTYNYEWYFRKDPNMVLQSTLGNDLRADGASITYTQI
NLYVSFFPMNYDTQSELELMLRNATNDQNFSDYLGAVNNLYQIPAGSSTVVVNIPDRSWGAFRGWSFTRLKVSETPRIGA
TQDPNFQYSGSIPYLDGTFYLSHTFQRCSIQWDSSVPWPGNDRMLTPNWFEIKRPINQDAEGNDTMQSNLTKDFFMVQMA
ASYNQGYQGFNWPNCTKHYGFINNFEPMSRQVPEYGANYPNLMAAYLANPQTMPIWNNCGFQQKTATNVLLERCGHPYVA
NWPYPLSGRNAVPNQVTERKFLVDRYLWQIPFSSNFLNMGTLTDLGQNVMYANSSHSLNMQFTVDPMTEPTYLMLLFGVF
DQVVINQPTRSGISVAYLRLPFASGSA
;
;MEPQREFFHIAGRSAKEYLSENLVQFIQATQNYFNIGEKFRDPYVAPSAGVTTDRSQKLQLRVVPIQTEDNVNYYKARFT
LNVGDNRLVDLGSSYFDIKGTLDRGPSFKPYGGTAYNPLAPKSAPINSAFTVGNDTHFVAQLPQTYAAGGTGVTEAIQQQ
VSGVDPNPQVGQPNYAGPVVVNTTNNAGLGRIVSADSEGQQFPCYGAYAPPQSAGGDVSTAAVTKTYINTTNNNGRVSGT
MATDTITWENPDAHFADFVDDRRATAAGNRPNYIGFRDNFIGMMYYNSGSNTGSFSSQTQQLNIVLDLNDRNSELSYQYL
LADLTSRWHYFALWNQAVDDYDHHVRILENDGYEEGPPNLAFPPHVISNPFAPAAVGTGMTVNEQQQTAAVTANTVALIG
YGNIPAVEMNLPANLKRTFLYSNVAMYLPDTYKFTPANVDLPENHLSYGYINGRLPLPNIVDTWTDIGARWSLDVMDTVN
PFNHHRNTGLKYRSQLLGNGRYCDFHIQVPQKFFAIKNLLLLPGTYNYEWYFRKDPNMVLQSTLGNDLRADGASITYTQI
NLYVSFFPMNYDTQSELELMLRNATNDQNFSDYLGAVNNLYQIPAGSSTVVVNIPDRSWGAFRGWSFTRLKVSETPRIGA
TQDPNFQYSGSIPYLDGTFYLSHTFQRCSIQWDSSVPWPGNDRMLTPNWFEIKRPINQDAEGNDTMQSNLTKDFFMVQMA
ASYNQGYQGFNWPNCTKHYGFINNFEPMSRQVPEYGANYPNLMAAYLANPQTMPIWNNCGFQQKTATNVLLERCGHPYVA
NWPYPLSGRNAVPNQVTERKFLVDRYLWQIPFSSNFLNMGTLTDLGQNVMYANSSHSLNMQFTVDPMTEPTYLMLLFGVF
DQVVINQPTRSGISVAYLRLPFASGSA
;
"derived from coordinates" C ? 
# 
loop_
_entity_poly_seq.entity_id 
_entity_poly_seq.num 
_entity_poly_seq.mon_id 
_entity_poly_seq.hetero 
1 1   MET n 
1 2   GLU n 
1 3   PRO n 
1 4   GLN n 
1 5   ARG n 
1 6   GLU n 
1 7   PHE n 
1 8   PHE n 
1 9   HIS n 
1 10  ILE n 
1 11  ALA n 
1 12  GLY n 
1 13  ARG n 
1 14  SER n 
1 15  ALA n 
1 16  LYS n 
1 17  GLU n 
1 18  TYR n 
1 19  LEU n 
1 20  SER n 
1 21  GLU n 
1 22  ASN n 
1 23  LEU n 
1 24  VAL n 
1 25  GLN n 
1 26  PHE n 
1 27  ILE n 
1 28  GLN n 
1 29  ALA n 
1 30  THR n 
1 31  GLN n 
1 32  ASN n 
1 33  TYR n 
1 34  PHE n 
1 35  ASN n 
1 36  ILE n 
1 37  GLY n 
1 38  GLU n 
1 39  LYS n 
1 40  PHE n 
1 41  ARG n 
1 42  ASP n 
1 43  PRO n 
1 44  TYR n 
1 45  VAL n 
1 46  ALA n 
1 47  PRO n 
1 48  SER n 
1 49  ALA n 
1 50  GLY n 
1 51  VAL n 
1 52  THR n 
1 53  THR n 
1 54  ASP n 
1 55  ARG n 
1 56  SER n 
1 57  GLN n 
1 58  LYS n 
1 59  LEU n 
1 60  GLN n 
1 61  LEU n 
1 62  ARG n 
1 63  VAL n 
1 64  VAL n 
1 65  PRO n 
1 66  ILE n 
1 67  GLN n 
1 68  THR n 
1 69  GLU n 
1 70  ASP n 
1 71  ASN n 
1 72  VAL n 
1 73  ASN n 
1 74  TYR n 
1 75  TYR n 
1 76  LYS n 
1 77  ALA n 
1 78  ARG n 
1 79  PHE n 
1 80  THR n 
1 81  LEU n 
1 82  ASN n 
1 83  VAL n 
1 84  GLY n 
1 85  ASP n 
1 86  ASN n 
1 87  ARG n 
1 88  LEU n 
1 89  VAL n 
1 90  ASP n 
1 91  LEU n 
1 92  GLY n 
1 93  SER n 
1 94  SER n 
1 95  TYR n 
1 96  PHE n 
1 97  ASP n 
1 98  ILE n 
1 99  LYS n 
1 100 GLY n 
1 101 THR n 
1 102 LEU n 
1 103 ASP n 
1 104 ARG n 
1 105 GLY n 
1 106 PRO n 
1 107 SER n 
1 108 PHE n 
1 109 LYS n 
1 110 PRO n 
1 111 TYR n 
1 112 GLY n 
1 113 GLY n 
1 114 THR n 
1 115 ALA n 
1 116 TYR n 
1 117 ASN n 
1 118 PRO n 
1 119 LEU n 
1 120 ALA n 
1 121 PRO n 
1 122 LYS n 
1 123 SER n 
1 124 ALA n 
1 125 PRO n 
1 126 ILE n 
1 127 ASN n 
1 128 SER n 
1 129 ALA n 
1 130 PHE n 
1 131 THR n 
1 132 VAL n 
1 133 GLY n 
1 134 ASN n 
1 135 ASP n 
1 136 THR n 
1 137 HIS n 
1 138 PHE n 
1 139 VAL n 
1 140 ALA n 
1 141 GLN n 
1 142 LEU n 
1 143 PRO n 
1 144 GLN n 
1 145 THR n 
1 146 TYR n 
1 147 ALA n 
1 148 ALA n 
1 149 GLY n 
1 150 GLY n 
1 151 THR n 
1 152 GLY n 
1 153 VAL n 
1 154 THR n 
1 155 GLU n 
1 156 ALA n 
1 157 ILE n 
1 158 GLN n 
1 159 GLN n 
1 160 GLN n 
1 161 VAL n 
1 162 SER n 
1 163 GLY n 
1 164 VAL n 
1 165 ASP n 
1 166 PRO n 
1 167 ASN n 
1 168 PRO n 
1 169 GLN n 
1 170 VAL n 
1 171 GLY n 
1 172 GLN n 
1 173 PRO n 
1 174 ASN n 
1 175 TYR n 
1 176 ALA n 
1 177 GLY n 
1 178 PRO n 
1 179 VAL n 
1 180 VAL n 
1 181 VAL n 
1 182 ASN n 
1 183 THR n 
1 184 THR n 
1 185 ASN n 
1 186 ASN n 
1 187 ALA n 
1 188 GLY n 
1 189 LEU n 
1 190 GLY n 
1 191 ARG n 
1 192 ILE n 
1 193 VAL n 
1 194 SER n 
1 195 ALA n 
1 196 ASP n 
1 197 SER n 
1 198 GLU n 
1 199 GLY n 
1 200 GLN n 
1 201 GLN n 
1 202 PHE n 
1 203 PRO n 
1 204 CYS n 
1 205 TYR n 
1 206 GLY n 
1 207 ALA n 
1 208 TYR n 
1 209 ALA n 
1 210 PRO n 
1 211 PRO n 
1 212 GLN n 
1 213 SER n 
1 214 ALA n 
1 215 GLY n 
1 216 GLY n 
1 217 ASP n 
1 218 VAL n 
1 219 SER n 
1 220 THR n 
1 221 ALA n 
1 222 ALA n 
1 223 VAL n 
1 224 THR n 
1 225 LYS n 
1 226 THR n 
1 227 TYR n 
1 228 ILE n 
1 229 ASN n 
1 230 THR n 
1 231 THR n 
1 232 ASN n 
1 233 ASN n 
1 234 ASN n 
1 235 GLY n 
1 236 ARG n 
1 237 VAL n 
1 238 SER n 
1 239 GLY n 
1 240 THR n 
1 241 MET n 
1 242 ALA n 
1 243 THR n 
1 244 ASP n 
1 245 THR n 
1 246 ILE n 
1 247 THR n 
1 248 TRP n 
1 249 GLU n 
1 250 ASN n 
1 251 PRO n 
1 252 ASP n 
1 253 ALA n 
1 254 HIS n 
1 255 PHE n 
1 256 ALA n 
1 257 ASP n 
1 258 PHE n 
1 259 VAL n 
1 260 ASP n 
1 261 ASP n 
1 262 ARG n 
1 263 ARG n 
1 264 ALA n 
1 265 THR n 
1 266 ALA n 
1 267 ALA n 
1 268 GLY n 
1 269 ASN n 
1 270 ARG n 
1 271 PRO n 
1 272 ASN n 
1 273 TYR n 
1 274 ILE n 
1 275 GLY n 
1 276 PHE n 
1 277 ARG n 
1 278 ASP n 
1 279 ASN n 
1 280 PHE n 
1 281 ILE n 
1 282 GLY n 
1 283 MET n 
1 284 MET n 
1 285 TYR n 
1 286 TYR n 
1 287 ASN n 
1 288 SER n 
1 289 GLY n 
1 290 SER n 
1 291 ASN n 
1 292 THR n 
1 293 GLY n 
1 294 SER n 
1 295 PHE n 
1 296 SER n 
1 297 SER n 
1 298 GLN n 
1 299 THR n 
1 300 GLN n 
1 301 GLN n 
1 302 LEU n 
1 303 ASN n 
1 304 ILE n 
1 305 VAL n 
1 306 LEU n 
1 307 ASP n 
1 308 LEU n 
1 309 ASN n 
1 310 ASP n 
1 311 ARG n 
1 312 ASN n 
1 313 SER n 
1 314 GLU n 
1 315 LEU n 
1 316 SER n 
1 317 TYR n 
1 318 GLN n 
1 319 TYR n 
1 320 LEU n 
1 321 LEU n 
1 322 ALA n 
1 323 ASP n 
1 324 LEU n 
1 325 THR n 
1 326 SER n 
1 327 ARG n 
1 328 TRP n 
1 329 HIS n 
1 330 TYR n 
1 331 PHE n 
1 332 ALA n 
1 333 LEU n 
1 334 TRP n 
1 335 ASN n 
1 336 GLN n 
1 337 ALA n 
1 338 VAL n 
1 339 ASP n 
1 340 ASP n 
1 341 TYR n 
1 342 ASP n 
1 343 HIS n 
1 344 HIS n 
1 345 VAL n 
1 346 ARG n 
1 347 ILE n 
1 348 LEU n 
1 349 GLU n 
1 350 ASN n 
1 351 ASP n 
1 352 GLY n 
1 353 TYR n 
1 354 GLU n 
1 355 GLU n 
1 356 GLY n 
1 357 PRO n 
1 358 PRO n 
1 359 ASN n 
1 360 LEU n 
1 361 ALA n 
1 362 PHE n 
1 363 PRO n 
1 364 PRO n 
1 365 HIS n 
1 366 VAL n 
1 367 ILE n 
1 368 SER n 
1 369 ASN n 
1 370 PRO n 
1 371 PHE n 
1 372 ALA n 
1 373 PRO n 
1 374 ALA n 
1 375 ALA n 
1 376 VAL n 
1 377 GLY n 
1 378 THR n 
1 379 GLY n 
1 380 MET n 
1 381 THR n 
1 382 VAL n 
1 383 ASN n 
1 384 GLU n 
1 385 GLN n 
1 386 GLN n 
1 387 GLN n 
1 388 THR n 
1 389 ALA n 
1 390 ALA n 
1 391 VAL n 
1 392 THR n 
1 393 ALA n 
1 394 ASN n 
1 395 THR n 
1 396 VAL n 
1 397 ALA n 
1 398 LEU n 
1 399 ILE n 
1 400 GLY n 
1 401 TYR n 
1 402 GLY n 
1 403 ASN n 
1 404 ILE n 
1 405 PRO n 
1 406 ALA n 
1 407 VAL n 
1 408 GLU n 
1 409 MET n 
1 410 ASN n 
1 411 LEU n 
1 412 PRO n 
1 413 ALA n 
1 414 ASN n 
1 415 LEU n 
1 416 LYS n 
1 417 ARG n 
1 418 THR n 
1 419 PHE n 
1 420 LEU n 
1 421 TYR n 
1 422 SER n 
1 423 ASN n 
1 424 VAL n 
1 425 ALA n 
1 426 MET n 
1 427 TYR n 
1 428 LEU n 
1 429 PRO n 
1 430 ASP n 
1 431 THR n 
1 432 TYR n 
1 433 LYS n 
1 434 PHE n 
1 435 THR n 
1 436 PRO n 
1 437 ALA n 
1 438 ASN n 
1 439 VAL n 
1 440 ASP n 
1 441 LEU n 
1 442 PRO n 
1 443 GLU n 
1 444 ASN n 
1 445 HIS n 
1 446 LEU n 
1 447 SER n 
1 448 TYR n 
1 449 GLY n 
1 450 TYR n 
1 451 ILE n 
1 452 ASN n 
1 453 GLY n 
1 454 ARG n 
1 455 LEU n 
1 456 PRO n 
1 457 LEU n 
1 458 PRO n 
1 459 ASN n 
1 460 ILE n 
1 461 VAL n 
1 462 ASP n 
1 463 THR n 
1 464 TRP n 
1 465 THR n 
1 466 ASP n 
1 467 ILE n 
1 468 GLY n 
1 469 ALA n 
1 470 ARG n 
1 471 TRP n 
1 472 SER n 
1 473 LEU n 
1 474 ASP n 
1 475 VAL n 
1 476 MET n 
1 477 ASP n 
1 478 THR n 
1 479 VAL n 
1 480 ASN n 
1 481 PRO n 
1 482 PHE n 
1 483 ASN n 
1 484 HIS n 
1 485 HIS n 
1 486 ARG n 
1 487 ASN n 
1 488 THR n 
1 489 GLY n 
1 490 LEU n 
1 491 LYS n 
1 492 TYR n 
1 493 ARG n 
1 494 SER n 
1 495 GLN n 
1 496 LEU n 
1 497 LEU n 
1 498 GLY n 
1 499 ASN n 
1 500 GLY n 
1 501 ARG n 
1 502 TYR n 
1 503 CYS n 
1 504 ASP n 
1 505 PHE n 
1 506 HIS n 
1 507 ILE n 
1 508 GLN n 
1 509 VAL n 
1 510 PRO n 
1 511 GLN n 
1 512 LYS n 
1 513 PHE n 
1 514 PHE n 
1 515 ALA n 
1 516 ILE n 
1 517 LYS n 
1 518 ASN n 
1 519 LEU n 
1 520 LEU n 
1 521 LEU n 
1 522 LEU n 
1 523 PRO n 
1 524 GLY n 
1 525 THR n 
1 526 TYR n 
1 527 ASN n 
1 528 TYR n 
1 529 GLU n 
1 530 TRP n 
1 531 TYR n 
1 532 PHE n 
1 533 ARG n 
1 534 LYS n 
1 535 ASP n 
1 536 PRO n 
1 537 ASN n 
1 538 MET n 
1 539 VAL n 
1 540 LEU n 
1 541 GLN n 
1 542 SER n 
1 543 THR n 
1 544 LEU n 
1 545 GLY n 
1 546 ASN n 
1 547 ASP n 
1 548 LEU n 
1 549 ARG n 
1 550 ALA n 
1 551 ASP n 
1 552 GLY n 
1 553 ALA n 
1 554 SER n 
1 555 ILE n 
1 556 THR n 
1 557 TYR n 
1 558 THR n 
1 559 GLN n 
1 560 ILE n 
1 561 ASN n 
1 562 LEU n 
1 563 TYR n 
1 564 VAL n 
1 565 SER n 
1 566 PHE n 
1 567 PHE n 
1 568 PRO n 
1 569 MET n 
1 570 ASN n 
1 571 TYR n 
1 572 ASP n 
1 573 THR n 
1 574 GLN n 
1 575 SER n 
1 576 GLU n 
1 577 LEU n 
1 578 GLU n 
1 579 LEU n 
1 580 MET n 
1 581 LEU n 
1 582 ARG n 
1 583 ASN n 
1 584 ALA n 
1 585 THR n 
1 586 ASN n 
1 587 ASP n 
1 588 GLN n 
1 589 ASN n 
1 590 PHE n 
1 591 SER n 
1 592 ASP n 
1 593 TYR n 
1 594 LEU n 
1 595 GLY n 
1 596 ALA n 
1 597 VAL n 
1 598 ASN n 
1 599 ASN n 
1 600 LEU n 
1 601 TYR n 
1 602 GLN n 
1 603 ILE n 
1 604 PRO n 
1 605 ALA n 
1 606 GLY n 
1 607 SER n 
1 608 SER n 
1 609 THR n 
1 610 VAL n 
1 611 VAL n 
1 612 VAL n 
1 613 ASN n 
1 614 ILE n 
1 615 PRO n 
1 616 ASP n 
1 617 ARG n 
1 618 SER n 
1 619 TRP n 
1 620 GLY n 
1 621 ALA n 
1 622 PHE n 
1 623 ARG n 
1 624 GLY n 
1 625 TRP n 
1 626 SER n 
1 627 PHE n 
1 628 THR n 
1 629 ARG n 
1 630 LEU n 
1 631 LYS n 
1 632 VAL n 
1 633 SER n 
1 634 GLU n 
1 635 THR n 
1 636 PRO n 
1 637 ARG n 
1 638 ILE n 
1 639 GLY n 
1 640 ALA n 
1 641 THR n 
1 642 GLN n 
1 643 ASP n 
1 644 PRO n 
1 645 ASN n 
1 646 PHE n 
1 647 GLN n 
1 648 TYR n 
1 649 SER n 
1 650 GLY n 
1 651 SER n 
1 652 ILE n 
1 653 PRO n 
1 654 TYR n 
1 655 LEU n 
1 656 ASP n 
1 657 GLY n 
1 658 THR n 
1 659 PHE n 
1 660 TYR n 
1 661 LEU n 
1 662 SER n 
1 663 HIS n 
1 664 THR n 
1 665 PHE n 
1 666 GLN n 
1 667 ARG n 
1 668 CYS n 
1 669 SER n 
1 670 ILE n 
1 671 GLN n 
1 672 TRP n 
1 673 ASP n 
1 674 SER n 
1 675 SER n 
1 676 VAL n 
1 677 PRO n 
1 678 TRP n 
1 679 PRO n 
1 680 GLY n 
1 681 ASN n 
1 682 ASP n 
1 683 ARG n 
1 684 MET n 
1 685 LEU n 
1 686 THR n 
1 687 PRO n 
1 688 ASN n 
1 689 TRP n 
1 690 PHE n 
1 691 GLU n 
1 692 ILE n 
1 693 LYS n 
1 694 ARG n 
1 695 PRO n 
1 696 ILE n 
1 697 ASN n 
1 698 GLN n 
1 699 ASP n 
1 700 ALA n 
1 701 GLU n 
1 702 GLY n 
1 703 ASN n 
1 704 ASP n 
1 705 THR n 
1 706 MET n 
1 707 GLN n 
1 708 SER n 
1 709 ASN n 
1 710 LEU n 
1 711 THR n 
1 712 LYS n 
1 713 ASP n 
1 714 PHE n 
1 715 PHE n 
1 716 MET n 
1 717 VAL n 
1 718 GLN n 
1 719 MET n 
1 720 ALA n 
1 721 ALA n 
1 722 SER n 
1 723 TYR n 
1 724 ASN n 
1 725 GLN n 
1 726 GLY n 
1 727 TYR n 
1 728 GLN n 
1 729 GLY n 
1 730 PHE n 
1 731 ASN n 
1 732 TRP n 
1 733 PRO n 
1 734 ASN n 
1 735 CYS n 
1 736 THR n 
1 737 LYS n 
1 738 HIS n 
1 739 TYR n 
1 740 GLY n 
1 741 PHE n 
1 742 ILE n 
1 743 ASN n 
1 744 ASN n 
1 745 PHE n 
1 746 GLU n 
1 747 PRO n 
1 748 MET n 
1 749 SER n 
1 750 ARG n 
1 751 GLN n 
1 752 VAL n 
1 753 PRO n 
1 754 GLU n 
1 755 TYR n 
1 756 GLY n 
1 757 ALA n 
1 758 ASN n 
1 759 TYR n 
1 760 PRO n 
1 761 ASN n 
1 762 LEU n 
1 763 MET n 
1 764 ALA n 
1 765 ALA n 
1 766 TYR n 
1 767 LEU n 
1 768 ALA n 
1 769 ASN n 
1 770 PRO n 
1 771 GLN n 
1 772 THR n 
1 773 MET n 
1 774 PRO n 
1 775 ILE n 
1 776 TRP n 
1 777 ASN n 
1 778 ASN n 
1 779 CYS n 
1 780 GLY n 
1 781 PHE n 
1 782 GLN n 
1 783 GLN n 
1 784 LYS n 
1 785 THR n 
1 786 ALA n 
1 787 THR n 
1 788 ASN n 
1 789 VAL n 
1 790 LEU n 
1 791 LEU n 
1 792 GLU n 
1 793 ARG n 
1 794 CYS n 
1 795 GLY n 
1 796 HIS n 
1 797 PRO n 
1 798 TYR n 
1 799 VAL n 
1 800 ALA n 
1 801 ASN n 
1 802 TRP n 
1 803 PRO n 
1 804 TYR n 
1 805 PRO n 
1 806 LEU n 
1 807 SER n 
1 808 GLY n 
1 809 ARG n 
1 810 ASN n 
1 811 ALA n 
1 812 VAL n 
1 813 PRO n 
1 814 ASN n 
1 815 GLN n 
1 816 VAL n 
1 817 THR n 
1 818 GLU n 
1 819 ARG n 
1 820 LYS n 
1 821 PHE n 
1 822 LEU n 
1 823 VAL n 
1 824 ASP n 
1 825 ARG n 
1 826 TYR n 
1 827 LEU n 
1 828 TRP n 
1 829 GLN n 
1 830 ILE n 
1 831 PRO n 
1 832 PHE n 
1 833 SER n 
1 834 SER n 
1 835 ASN n 
1 836 PHE n 
1 837 LEU n 
1 838 ASN n 
1 839 MET n 
1 840 GLY n 
1 841 THR n 
1 842 LEU n 
1 843 THR n 
1 844 ASP n 
1 845 LEU n 
1 846 GLY n 
1 847 GLN n 
1 848 ASN n 
1 849 VAL n 
1 850 MET n 
1 851 TYR n 
1 852 ALA n 
1 853 ASN n 
1 854 SER n 
1 855 SER n 
1 856 HIS n 
1 857 SER n 
1 858 LEU n 
1 859 ASN n 
1 860 MET n 
1 861 GLN n 
1 862 PHE n 
1 863 THR n 
1 864 VAL n 
1 865 ASP n 
1 866 PRO n 
1 867 MET n 
1 868 THR n 
1 869 GLU n 
1 870 PRO n 
1 871 THR n 
1 872 TYR n 
1 873 LEU n 
1 874 MET n 
1 875 LEU n 
1 876 LEU n 
1 877 PHE n 
1 878 GLY n 
1 879 VAL n 
1 880 PHE n 
1 881 ASP n 
1 882 GLN n 
1 883 VAL n 
1 884 VAL n 
1 885 ILE n 
1 886 ASN n 
1 887 GLN n 
1 888 PRO n 
1 889 THR n 
1 890 ARG n 
1 891 SER n 
1 892 GLY n 
1 893 ILE n 
1 894 SER n 
1 895 VAL n 
1 896 ALA n 
1 897 TYR n 
1 898 LEU n 
1 899 ARG n 
1 900 LEU n 
1 901 PRO n 
1 902 PHE n 
1 903 ALA n 
1 904 SER n 
1 905 GLY n 
2 1   MET n 
2 2   GLU n 
2 3   PRO n 
2 4   GLN n 
2 5   ARG n 
2 6   GLU n 
2 7   PHE n 
2 8   PHE n 
2 9   HIS n 
2 10  ILE n 
2 11  ALA n 
2 12  GLY n 
2 13  ARG n 
2 14  SER n 
2 15  ALA n 
2 16  LYS n 
2 17  GLU n 
2 18  TYR n 
2 19  LEU n 
2 20  SER n 
2 21  GLU n 
2 22  ASN n 
2 23  LEU n 
2 24  VAL n 
2 25  GLN n 
2 26  PHE n 
2 27  ILE n 
2 28  GLN n 
2 29  ALA n 
2 30  THR n 
2 31  GLN n 
2 32  ASN n 
2 33  TYR n 
2 34  PHE n 
2 35  ASN n 
2 36  ILE n 
2 37  GLY n 
2 38  GLU n 
2 39  LYS n 
2 40  PHE n 
2 41  ARG n 
2 42  ASP n 
2 43  PRO n 
2 44  TYR n 
2 45  VAL n 
2 46  ALA n 
2 47  PRO n 
2 48  SER n 
2 49  ALA n 
2 50  GLY n 
2 51  VAL n 
2 52  THR n 
2 53  THR n 
2 54  ASP n 
2 55  ARG n 
2 56  SER n 
2 57  GLN n 
2 58  LYS n 
2 59  LEU n 
2 60  GLN n 
2 61  LEU n 
2 62  ARG n 
2 63  VAL n 
2 64  VAL n 
2 65  PRO n 
2 66  ILE n 
2 67  GLN n 
2 68  THR n 
2 69  GLU n 
2 70  ASP n 
2 71  ASN n 
2 72  VAL n 
2 73  ASN n 
2 74  TYR n 
2 75  TYR n 
2 76  LYS n 
2 77  ALA n 
2 78  ARG n 
2 79  PHE n 
2 80  THR n 
2 81  LEU n 
2 82  ASN n 
2 83  VAL n 
2 84  GLY n 
2 85  ASP n 
2 86  ASN n 
2 87  ARG n 
2 88  LEU n 
2 89  VAL n 
2 90  ASP n 
2 91  LEU n 
2 92  GLY n 
2 93  SER n 
2 94  SER n 
2 95  TYR n 
2 96  PHE n 
2 97  ASP n 
2 98  ILE n 
2 99  LYS n 
2 100 GLY n 
2 101 THR n 
2 102 LEU n 
2 103 ASP n 
2 104 ARG n 
2 105 GLY n 
2 106 PRO n 
2 107 SER n 
2 108 PHE n 
2 109 LYS n 
2 110 PRO n 
2 111 TYR n 
2 112 GLY n 
2 113 GLY n 
2 114 THR n 
2 115 ALA n 
2 116 TYR n 
2 117 ASN n 
2 118 PRO n 
2 119 LEU n 
2 120 ALA n 
2 121 PRO n 
2 122 LYS n 
2 123 SER n 
2 124 ALA n 
2 125 PRO n 
2 126 ILE n 
2 127 ASN n 
2 128 SER n 
2 129 ALA n 
2 130 PHE n 
2 131 THR n 
2 132 VAL n 
2 133 GLY n 
2 134 ASN n 
2 135 ASP n 
2 136 THR n 
2 137 HIS n 
2 138 PHE n 
2 139 VAL n 
2 140 ALA n 
2 141 GLN n 
2 142 LEU n 
2 143 PRO n 
2 144 GLN n 
2 145 THR n 
2 146 TYR n 
2 147 ALA n 
2 148 ALA n 
2 149 GLY n 
2 150 GLY n 
2 151 THR n 
2 152 GLY n 
2 153 VAL n 
2 154 THR n 
2 155 GLU n 
2 156 ALA n 
2 157 ILE n 
2 158 GLN n 
2 159 GLN n 
2 160 GLN n 
2 161 VAL n 
2 162 SER n 
2 163 GLY n 
2 164 VAL n 
2 165 ASP n 
2 166 PRO n 
2 167 ASN n 
2 168 PRO n 
2 169 GLN n 
2 170 VAL n 
2 171 GLY n 
2 172 GLN n 
2 173 PRO n 
2 174 ASN n 
2 175 TYR n 
2 176 ALA n 
2 177 GLY n 
2 178 PRO n 
2 179 VAL n 
2 180 VAL n 
2 181 VAL n 
2 182 ASN n 
2 183 THR n 
2 184 THR n 
2 185 ASN n 
2 186 ASN n 
2 187 ALA n 
2 188 GLY n 
2 189 LEU n 
2 190 GLY n 
2 191 ARG n 
2 192 ILE n 
2 193 VAL n 
2 194 SER n 
2 195 ALA n 
2 196 ASP n 
2 197 SER n 
2 198 GLU n 
2 199 GLY n 
2 200 GLN n 
2 201 GLN n 
2 202 PHE n 
2 203 PRO n 
2 204 CYS n 
2 205 TYR n 
2 206 GLY n 
2 207 ALA n 
2 208 TYR n 
2 209 ALA n 
2 210 PRO n 
2 211 PRO n 
2 212 GLN n 
2 213 SER n 
2 214 ALA n 
2 215 GLY n 
2 216 GLY n 
2 217 ASP n 
2 218 VAL n 
2 219 SER n 
2 220 THR n 
2 221 ALA n 
2 222 ALA n 
2 223 VAL n 
2 224 THR n 
2 225 LYS n 
2 226 THR n 
2 227 TYR n 
2 228 ILE n 
2 229 ASN n 
2 230 THR n 
2 231 THR n 
2 232 ASN n 
2 233 ASN n 
2 234 ASN n 
2 235 GLY n 
2 236 ARG n 
2 237 VAL n 
2 238 SER n 
2 239 GLY n 
2 240 THR n 
2 241 MET n 
2 242 ALA n 
2 243 THR n 
2 244 ASP n 
2 245 THR n 
2 246 ILE n 
2 247 THR n 
2 248 TRP n 
2 249 GLU n 
2 250 ASN n 
2 251 PRO n 
2 252 ASP n 
2 253 ALA n 
2 254 HIS n 
2 255 PHE n 
2 256 ALA n 
2 257 ASP n 
2 258 PHE n 
2 259 VAL n 
2 260 ASP n 
2 261 ASP n 
2 262 ARG n 
2 263 ARG n 
2 264 ALA n 
2 265 THR n 
2 266 ALA n 
2 267 ALA n 
2 268 GLY n 
2 269 ASN n 
2 270 ARG n 
2 271 PRO n 
2 272 ASN n 
2 273 TYR n 
2 274 ILE n 
2 275 GLY n 
2 276 PHE n 
2 277 ARG n 
2 278 ASP n 
2 279 ASN n 
2 280 PHE n 
2 281 ILE n 
2 282 GLY n 
2 283 MET n 
2 284 MET n 
2 285 TYR n 
2 286 TYR n 
2 287 ASN n 
2 288 SER n 
2 289 GLY n 
2 290 SER n 
2 291 ASN n 
2 292 THR n 
2 293 GLY n 
2 294 SER n 
2 295 PHE n 
2 296 SER n 
2 297 SER n 
2 298 GLN n 
2 299 THR n 
2 300 GLN n 
2 301 GLN n 
2 302 LEU n 
2 303 ASN n 
2 304 ILE n 
2 305 VAL n 
2 306 LEU n 
2 307 ASP n 
2 308 LEU n 
2 309 ASN n 
2 310 ASP n 
2 311 ARG n 
2 312 ASN n 
2 313 SER n 
2 314 GLU n 
2 315 LEU n 
2 316 SER n 
2 317 TYR n 
2 318 GLN n 
2 319 TYR n 
2 320 LEU n 
2 321 LEU n 
2 322 ALA n 
2 323 ASP n 
2 324 LEU n 
2 325 THR n 
2 326 SER n 
2 327 ARG n 
2 328 TRP n 
2 329 HIS n 
2 330 TYR n 
2 331 PHE n 
2 332 ALA n 
2 333 LEU n 
2 334 TRP n 
2 335 ASN n 
2 336 GLN n 
2 337 ALA n 
2 338 VAL n 
2 339 ASP n 
2 340 ASP n 
2 341 TYR n 
2 342 ASP n 
2 343 HIS n 
2 344 HIS n 
2 345 VAL n 
2 346 ARG n 
2 347 ILE n 
2 348 LEU n 
2 349 GLU n 
2 350 ASN n 
2 351 ASP n 
2 352 GLY n 
2 353 TYR n 
2 354 GLU n 
2 355 GLU n 
2 356 GLY n 
2 357 PRO n 
2 358 PRO n 
2 359 ASN n 
2 360 LEU n 
2 361 ALA n 
2 362 PHE n 
2 363 PRO n 
2 364 PRO n 
2 365 HIS n 
2 366 VAL n 
2 367 ILE n 
2 368 SER n 
2 369 ASN n 
2 370 PRO n 
2 371 PHE n 
2 372 ALA n 
2 373 PRO n 
2 374 ALA n 
2 375 ALA n 
2 376 VAL n 
2 377 GLY n 
2 378 THR n 
2 379 GLY n 
2 380 MET n 
2 381 THR n 
2 382 VAL n 
2 383 ASN n 
2 384 GLU n 
2 385 GLN n 
2 386 GLN n 
2 387 GLN n 
2 388 THR n 
2 389 ALA n 
2 390 ALA n 
2 391 VAL n 
2 392 THR n 
2 393 ALA n 
2 394 ASN n 
2 395 THR n 
2 396 VAL n 
2 397 ALA n 
2 398 LEU n 
2 399 ILE n 
2 400 GLY n 
2 401 TYR n 
2 402 GLY n 
2 403 ASN n 
2 404 ILE n 
2 405 PRO n 
2 406 ALA n 
2 407 VAL n 
2 408 GLU n 
2 409 MET n 
2 410 ASN n 
2 411 LEU n 
2 412 PRO n 
2 413 ALA n 
2 414 ASN n 
2 415 LEU n 
2 416 LYS n 
2 417 ARG n 
2 418 THR n 
2 419 PHE n 
2 420 LEU n 
2 421 TYR n 
2 422 SER n 
2 423 ASN n 
2 424 VAL n 
2 425 ALA n 
2 426 MET n 
2 427 TYR n 
2 428 LEU n 
2 429 PRO n 
2 430 ASP n 
2 431 THR n 
2 432 TYR n 
2 433 LYS n 
2 434 PHE n 
2 435 THR n 
2 436 PRO n 
2 437 ALA n 
2 438 ASN n 
2 439 VAL n 
2 440 ASP n 
2 441 LEU n 
2 442 PRO n 
2 443 GLU n 
2 444 ASN n 
2 445 HIS n 
2 446 LEU n 
2 447 SER n 
2 448 TYR n 
2 449 GLY n 
2 450 TYR n 
2 451 ILE n 
2 452 ASN n 
2 453 GLY n 
2 454 ARG n 
2 455 LEU n 
2 456 PRO n 
2 457 LEU n 
2 458 PRO n 
2 459 ASN n 
2 460 ILE n 
2 461 VAL n 
2 462 ASP n 
2 463 THR n 
2 464 TRP n 
2 465 THR n 
2 466 ASP n 
2 467 ILE n 
2 468 GLY n 
2 469 ALA n 
2 470 ARG n 
2 471 TRP n 
2 472 SER n 
2 473 LEU n 
2 474 ASP n 
2 475 VAL n 
2 476 MET n 
2 477 ASP n 
2 478 THR n 
2 479 VAL n 
2 480 ASN n 
2 481 PRO n 
2 482 PHE n 
2 483 ASN n 
2 484 HIS n 
2 485 HIS n 
2 486 ARG n 
2 487 ASN n 
2 488 THR n 
2 489 GLY n 
2 490 LEU n 
2 491 LYS n 
2 492 TYR n 
2 493 ARG n 
2 494 SER n 
2 495 GLN n 
2 496 LEU n 
2 497 LEU n 
2 498 GLY n 
2 499 ASN n 
2 500 GLY n 
2 501 ARG n 
2 502 TYR n 
2 503 CYS n 
2 504 ASP n 
2 505 PHE n 
2 506 HIS n 
2 507 ILE n 
2 508 GLN n 
2 509 VAL n 
2 510 PRO n 
2 511 GLN n 
2 512 LYS n 
2 513 PHE n 
2 514 PHE n 
2 515 ALA n 
2 516 ILE n 
2 517 LYS n 
2 518 ASN n 
2 519 LEU n 
2 520 LEU n 
2 521 LEU n 
2 522 LEU n 
2 523 PRO n 
2 524 GLY n 
2 525 THR n 
2 526 TYR n 
2 527 ASN n 
2 528 TYR n 
2 529 GLU n 
2 530 TRP n 
2 531 TYR n 
2 532 PHE n 
2 533 ARG n 
2 534 LYS n 
2 535 ASP n 
2 536 PRO n 
2 537 ASN n 
2 538 MET n 
2 539 VAL n 
2 540 LEU n 
2 541 GLN n 
2 542 SER n 
2 543 THR n 
2 544 LEU n 
2 545 GLY n 
2 546 ASN n 
2 547 ASP n 
2 548 LEU n 
2 549 ARG n 
2 550 ALA n 
2 551 ASP n 
2 552 GLY n 
2 553 ALA n 
2 554 SER n 
2 555 ILE n 
2 556 THR n 
2 557 TYR n 
2 558 THR n 
2 559 GLN n 
2 560 ILE n 
2 561 ASN n 
2 562 LEU n 
2 563 TYR n 
2 564 VAL n 
2 565 SER n 
2 566 PHE n 
2 567 PHE n 
2 568 PRO n 
2 569 MET n 
2 570 ASN n 
2 571 TYR n 
2 572 ASP n 
2 573 THR n 
2 574 GLN n 
2 575 SER n 
2 576 GLU n 
2 577 LEU n 
2 578 GLU n 
2 579 LEU n 
2 580 MET n 
2 581 LEU n 
2 582 ARG n 
2 583 ASN n 
2 584 ALA n 
2 585 THR n 
2 586 ASN n 
2 587 ASP n 
2 588 GLN n 
2 589 ASN n 
2 590 PHE n 
2 591 SER n 
2 592 ASP n 
2 593 TYR n 
2 594 LEU n 
2 595 GLY n 
2 596 ALA n 
2 597 VAL n 
2 598 ASN n 
2 599 ASN n 
2 600 LEU n 
2 601 TYR n 
2 602 GLN n 
2 603 ILE n 
2 604 PRO n 
2 605 ALA n 
2 606 GLY n 
2 607 SER n 
2 608 SER n 
2 609 THR n 
2 610 VAL n 
2 611 VAL n 
2 612 VAL n 
2 613 ASN n 
2 614 ILE n 
2 615 PRO n 
2 616 ASP n 
2 617 ARG n 
2 618 SER n 
2 619 TRP n 
2 620 GLY n 
2 621 ALA n 
2 622 PHE n 
2 623 ARG n 
2 624 GLY n 
2 625 TRP n 
2 626 SER n 
2 627 PHE n 
2 628 THR n 
2 629 ARG n 
2 630 LEU n 
2 631 LYS n 
2 632 VAL n 
2 633 SER n 
2 634 GLU n 
2 635 THR n 
2 636 PRO n 
2 637 ARG n 
2 638 ILE n 
2 639 GLY n 
2 640 ALA n 
2 641 THR n 
2 642 GLN n 
2 643 ASP n 
2 644 PRO n 
2 645 ASN n 
2 646 PHE n 
2 647 GLN n 
2 648 TYR n 
2 649 SER n 
2 650 GLY n 
2 651 SER n 
2 652 ILE n 
2 653 PRO n 
2 654 TYR n 
2 655 LEU n 
2 656 ASP n 
2 657 GLY n 
2 658 THR n 
2 659 PHE n 
2 660 TYR n 
2 661 LEU n 
2 662 SER n 
2 663 HIS n 
2 664 THR n 
2 665 PHE n 
2 666 GLN n 
2 667 ARG n 
2 668 CYS n 
2 669 SER n 
2 670 ILE n 
2 671 GLN n 
2 672 TRP n 
2 673 ASP n 
2 674 SER n 
2 675 SER n 
2 676 VAL n 
2 677 PRO n 
2 678 TRP n 
2 679 PRO n 
2 680 GLY n 
2 681 ASN n 
2 682 ASP n 
2 683 ARG n 
2 684 MET n 
2 685 LEU n 
2 686 THR n 
2 687 PRO n 
2 688 ASN n 
2 689 TRP n 
2 690 PHE n 
2 691 GLU n 
2 692 ILE n 
2 693 LYS n 
2 694 ARG n 
2 695 PRO n 
2 696 ILE n 
2 697 ASN n 
2 698 GLN n 
2 699 ASP n 
2 700 ALA n 
2 701 GLU n 
2 702 GLY n 
2 703 ASN n 
2 704 ASP n 
2 705 THR n 
2 706 MET n 
2 707 GLN n 
2 708 SER n 
2 709 ASN n 
2 710 LEU n 
2 711 THR n 
2 712 LYS n 
2 713 ASP n 
2 714 PHE n 
2 715 PHE n 
2 716 MET n 
2 717 VAL n 
2 718 GLN n 
2 719 MET n 
2 720 ALA n 
2 721 ALA n 
2 722 SER n 
2 723 TYR n 
2 724 ASN n 
2 725 GLN n 
2 726 GLY n 
2 727 TYR n 
2 728 GLN n 
2 729 GLY n 
2 730 PHE n 
2 731 ASN n 
2 732 TRP n 
2 733 PRO n 
2 734 ASN n 
2 735 CYS n 
2 736 THR n 
2 737 LYS n 
2 738 HIS n 
2 739 TYR n 
2 740 GLY n 
2 741 PHE n 
2 742 ILE n 
2 743 ASN n 
2 744 ASN n 
2 745 PHE n 
2 746 GLU n 
2 747 PRO n 
2 748 MET n 
2 749 SER n 
2 750 ARG n 
2 751 GLN n 
2 752 VAL n 
2 753 PRO n 
2 754 GLU n 
2 755 TYR n 
2 756 GLY n 
2 757 ALA n 
2 758 ASN n 
2 759 TYR n 
2 760 PRO n 
2 761 ASN n 
2 762 LEU n 
2 763 MET n 
2 764 ALA n 
2 765 ALA n 
2 766 TYR n 
2 767 LEU n 
2 768 ALA n 
2 769 ASN n 
2 770 PRO n 
2 771 GLN n 
2 772 THR n 
2 773 MET n 
2 774 PRO n 
2 775 ILE n 
2 776 TRP n 
2 777 ASN n 
2 778 ASN n 
2 779 CYS n 
2 780 GLY n 
2 781 PHE n 
2 782 GLN n 
2 783 GLN n 
2 784 LYS n 
2 785 THR n 
2 786 ALA n 
2 787 THR n 
2 788 ASN n 
2 789 VAL n 
2 790 LEU n 
2 791 LEU n 
2 792 GLU n 
2 793 ARG n 
2 794 CYS n 
2 795 GLY n 
2 796 HIS n 
2 797 PRO n 
2 798 TYR n 
2 799 VAL n 
2 800 ALA n 
2 801 ASN n 
2 802 TRP n 
2 803 PRO n 
2 804 TYR n 
2 805 PRO n 
2 806 LEU n 
2 807 SER n 
2 808 GLY n 
2 809 ARG n 
2 810 ASN n 
2 811 ALA n 
2 812 VAL n 
2 813 PRO n 
2 814 ASN n 
2 815 GLN n 
2 816 VAL n 
2 817 THR n 
2 818 GLU n 
2 819 ARG n 
2 820 LYS n 
2 821 PHE n 
2 822 LEU n 
2 823 VAL n 
2 824 ASP n 
2 825 ARG n 
2 826 TYR n 
2 827 LEU n 
2 828 TRP n 
2 829 GLN n 
2 830 ILE n 
2 831 PRO n 
2 832 PHE n 
2 833 SER n 
2 834 SER n 
2 835 ASN n 
2 836 PHE n 
2 837 LEU n 
2 838 ASN n 
2 839 MET n 
2 840 GLY n 
2 841 THR n 
2 842 LEU n 
2 843 THR n 
2 844 ASP n 
2 845 LEU n 
2 846 GLY n 
2 847 GLN n 
2 848 ASN n 
2 849 VAL n 
2 850 MET n 
2 851 TYR n 
2 852 ALA n 
2 853 ASN n 
2 854 SER n 
2 855 SER n 
2 856 HIS n 
2 857 SER n 
2 858 LEU n 
2 859 ASN n 
2 860 MET n 
2 861 GLN n 
2 862 PHE n 
2 863 THR n 
2 864 VAL n 
2 865 ASP n 
2 866 PRO n 
2 867 MET n 
2 868 THR n 
2 869 GLU n 
2 870 PRO n 
2 871 THR n 
2 872 TYR n 
2 873 LEU n 
2 874 MET n 
2 875 LEU n 
2 876 LEU n 
2 877 PHE n 
2 878 GLY n 
2 879 VAL n 
2 880 PHE n 
2 881 ASP n 
2 882 GLN n 
2 883 VAL n 
2 884 ILE n 
2 885 ASN n 
2 886 GLN n 
2 887 PRO n 
2 888 THR n 
2 889 ARG n 
2 890 SER n 
2 891 GLY n 
2 892 ILE n 
2 893 SER n 
2 894 VAL n 
2 895 ALA n 
2 896 TYR n 
2 897 LEU n 
2 898 ARG n 
2 899 LEU n 
2 900 PRO n 
2 901 PHE n 
2 902 ALA n 
2 903 SER n 
2 904 GLY n 
3 1   MET n 
3 2   GLU n 
3 3   PRO n 
3 4   GLN n 
3 5   ARG n 
3 6   GLU n 
3 7   PHE n 
3 8   PHE n 
3 9   HIS n 
3 10  ILE n 
3 11  ALA n 
3 12  GLY n 
3 13  ARG n 
3 14  SER n 
3 15  ALA n 
3 16  LYS n 
3 17  GLU n 
3 18  TYR n 
3 19  LEU n 
3 20  SER n 
3 21  GLU n 
3 22  ASN n 
3 23  LEU n 
3 24  VAL n 
3 25  GLN n 
3 26  PHE n 
3 27  ILE n 
3 28  GLN n 
3 29  ALA n 
3 30  THR n 
3 31  GLN n 
3 32  ASN n 
3 33  TYR n 
3 34  PHE n 
3 35  ASN n 
3 36  ILE n 
3 37  GLY n 
3 38  GLU n 
3 39  LYS n 
3 40  PHE n 
3 41  ARG n 
3 42  ASP n 
3 43  PRO n 
3 44  TYR n 
3 45  VAL n 
3 46  ALA n 
3 47  PRO n 
3 48  SER n 
3 49  ALA n 
3 50  GLY n 
3 51  VAL n 
3 52  THR n 
3 53  THR n 
3 54  ASP n 
3 55  ARG n 
3 56  SER n 
3 57  GLN n 
3 58  LYS n 
3 59  LEU n 
3 60  GLN n 
3 61  LEU n 
3 62  ARG n 
3 63  VAL n 
3 64  VAL n 
3 65  PRO n 
3 66  ILE n 
3 67  GLN n 
3 68  THR n 
3 69  GLU n 
3 70  ASP n 
3 71  ASN n 
3 72  VAL n 
3 73  ASN n 
3 74  TYR n 
3 75  TYR n 
3 76  LYS n 
3 77  ALA n 
3 78  ARG n 
3 79  PHE n 
3 80  THR n 
3 81  LEU n 
3 82  ASN n 
3 83  VAL n 
3 84  GLY n 
3 85  ASP n 
3 86  ASN n 
3 87  ARG n 
3 88  LEU n 
3 89  VAL n 
3 90  ASP n 
3 91  LEU n 
3 92  GLY n 
3 93  SER n 
3 94  SER n 
3 95  TYR n 
3 96  PHE n 
3 97  ASP n 
3 98  ILE n 
3 99  LYS n 
3 100 GLY n 
3 101 THR n 
3 102 LEU n 
3 103 ASP n 
3 104 ARG n 
3 105 GLY n 
3 106 PRO n 
3 107 SER n 
3 108 PHE n 
3 109 LYS n 
3 110 PRO n 
3 111 TYR n 
3 112 GLY n 
3 113 GLY n 
3 114 THR n 
3 115 ALA n 
3 116 TYR n 
3 117 ASN n 
3 118 PRO n 
3 119 LEU n 
3 120 ALA n 
3 121 PRO n 
3 122 LYS n 
3 123 SER n 
3 124 ALA n 
3 125 PRO n 
3 126 ILE n 
3 127 ASN n 
3 128 SER n 
3 129 ALA n 
3 130 PHE n 
3 131 THR n 
3 132 VAL n 
3 133 GLY n 
3 134 ASN n 
3 135 ASP n 
3 136 THR n 
3 137 HIS n 
3 138 PHE n 
3 139 VAL n 
3 140 ALA n 
3 141 GLN n 
3 142 LEU n 
3 143 PRO n 
3 144 GLN n 
3 145 THR n 
3 146 TYR n 
3 147 ALA n 
3 148 ALA n 
3 149 GLY n 
3 150 GLY n 
3 151 THR n 
3 152 GLY n 
3 153 VAL n 
3 154 THR n 
3 155 GLU n 
3 156 ALA n 
3 157 ILE n 
3 158 GLN n 
3 159 GLN n 
3 160 GLN n 
3 161 VAL n 
3 162 SER n 
3 163 GLY n 
3 164 VAL n 
3 165 ASP n 
3 166 PRO n 
3 167 ASN n 
3 168 PRO n 
3 169 GLN n 
3 170 VAL n 
3 171 GLY n 
3 172 GLN n 
3 173 PRO n 
3 174 ASN n 
3 175 TYR n 
3 176 ALA n 
3 177 GLY n 
3 178 PRO n 
3 179 VAL n 
3 180 VAL n 
3 181 VAL n 
3 182 ASN n 
3 183 THR n 
3 184 THR n 
3 185 ASN n 
3 186 ASN n 
3 187 ALA n 
3 188 GLY n 
3 189 LEU n 
3 190 GLY n 
3 191 ARG n 
3 192 ILE n 
3 193 VAL n 
3 194 SER n 
3 195 ALA n 
3 196 ASP n 
3 197 SER n 
3 198 GLU n 
3 199 GLY n 
3 200 GLN n 
3 201 GLN n 
3 202 PHE n 
3 203 PRO n 
3 204 CYS n 
3 205 TYR n 
3 206 GLY n 
3 207 ALA n 
3 208 TYR n 
3 209 ALA n 
3 210 PRO n 
3 211 PRO n 
3 212 GLN n 
3 213 SER n 
3 214 ALA n 
3 215 GLY n 
3 216 GLY n 
3 217 ASP n 
3 218 VAL n 
3 219 SER n 
3 220 THR n 
3 221 ALA n 
3 222 ALA n 
3 223 VAL n 
3 224 THR n 
3 225 LYS n 
3 226 THR n 
3 227 TYR n 
3 228 ILE n 
3 229 ASN n 
3 230 THR n 
3 231 THR n 
3 232 ASN n 
3 233 ASN n 
3 234 ASN n 
3 235 GLY n 
3 236 ARG n 
3 237 VAL n 
3 238 SER n 
3 239 GLY n 
3 240 THR n 
3 241 MET n 
3 242 ALA n 
3 243 THR n 
3 244 ASP n 
3 245 THR n 
3 246 ILE n 
3 247 THR n 
3 248 TRP n 
3 249 GLU n 
3 250 ASN n 
3 251 PRO n 
3 252 ASP n 
3 253 ALA n 
3 254 HIS n 
3 255 PHE n 
3 256 ALA n 
3 257 ASP n 
3 258 PHE n 
3 259 VAL n 
3 260 ASP n 
3 261 ASP n 
3 262 ARG n 
3 263 ARG n 
3 264 ALA n 
3 265 THR n 
3 266 ALA n 
3 267 ALA n 
3 268 GLY n 
3 269 ASN n 
3 270 ARG n 
3 271 PRO n 
3 272 ASN n 
3 273 TYR n 
3 274 ILE n 
3 275 GLY n 
3 276 PHE n 
3 277 ARG n 
3 278 ASP n 
3 279 ASN n 
3 280 PHE n 
3 281 ILE n 
3 282 GLY n 
3 283 MET n 
3 284 MET n 
3 285 TYR n 
3 286 TYR n 
3 287 ASN n 
3 288 SER n 
3 289 GLY n 
3 290 SER n 
3 291 ASN n 
3 292 THR n 
3 293 GLY n 
3 294 SER n 
3 295 PHE n 
3 296 SER n 
3 297 SER n 
3 298 GLN n 
3 299 THR n 
3 300 GLN n 
3 301 GLN n 
3 302 LEU n 
3 303 ASN n 
3 304 ILE n 
3 305 VAL n 
3 306 LEU n 
3 307 ASP n 
3 308 LEU n 
3 309 ASN n 
3 310 ASP n 
3 311 ARG n 
3 312 ASN n 
3 313 SER n 
3 314 GLU n 
3 315 LEU n 
3 316 SER n 
3 317 TYR n 
3 318 GLN n 
3 319 TYR n 
3 320 LEU n 
3 321 LEU n 
3 322 ALA n 
3 323 ASP n 
3 324 LEU n 
3 325 THR n 
3 326 SER n 
3 327 ARG n 
3 328 TRP n 
3 329 HIS n 
3 330 TYR n 
3 331 PHE n 
3 332 ALA n 
3 333 LEU n 
3 334 TRP n 
3 335 ASN n 
3 336 GLN n 
3 337 ALA n 
3 338 VAL n 
3 339 ASP n 
3 340 ASP n 
3 341 TYR n 
3 342 ASP n 
3 343 HIS n 
3 344 HIS n 
3 345 VAL n 
3 346 ARG n 
3 347 ILE n 
3 348 LEU n 
3 349 GLU n 
3 350 ASN n 
3 351 ASP n 
3 352 GLY n 
3 353 TYR n 
3 354 GLU n 
3 355 GLU n 
3 356 GLY n 
3 357 PRO n 
3 358 PRO n 
3 359 ASN n 
3 360 LEU n 
3 361 ALA n 
3 362 PHE n 
3 363 PRO n 
3 364 PRO n 
3 365 HIS n 
3 366 VAL n 
3 367 ILE n 
3 368 SER n 
3 369 ASN n 
3 370 PRO n 
3 371 PHE n 
3 372 ALA n 
3 373 PRO n 
3 374 ALA n 
3 375 ALA n 
3 376 VAL n 
3 377 GLY n 
3 378 THR n 
3 379 GLY n 
3 380 MET n 
3 381 THR n 
3 382 VAL n 
3 383 ASN n 
3 384 GLU n 
3 385 GLN n 
3 386 GLN n 
3 387 GLN n 
3 388 THR n 
3 389 ALA n 
3 390 ALA n 
3 391 VAL n 
3 392 THR n 
3 393 ALA n 
3 394 ASN n 
3 395 THR n 
3 396 VAL n 
3 397 ALA n 
3 398 LEU n 
3 399 ILE n 
3 400 GLY n 
3 401 TYR n 
3 402 GLY n 
3 403 ASN n 
3 404 ILE n 
3 405 PRO n 
3 406 ALA n 
3 407 VAL n 
3 408 GLU n 
3 409 MET n 
3 410 ASN n 
3 411 LEU n 
3 412 PRO n 
3 413 ALA n 
3 414 ASN n 
3 415 LEU n 
3 416 LYS n 
3 417 ARG n 
3 418 THR n 
3 419 PHE n 
3 420 LEU n 
3 421 TYR n 
3 422 SER n 
3 423 ASN n 
3 424 VAL n 
3 425 ALA n 
3 426 MET n 
3 427 TYR n 
3 428 LEU n 
3 429 PRO n 
3 430 ASP n 
3 431 THR n 
3 432 TYR n 
3 433 LYS n 
3 434 PHE n 
3 435 THR n 
3 436 PRO n 
3 437 ALA n 
3 438 ASN n 
3 439 VAL n 
3 440 ASP n 
3 441 LEU n 
3 442 PRO n 
3 443 GLU n 
3 444 ASN n 
3 445 HIS n 
3 446 LEU n 
3 447 SER n 
3 448 TYR n 
3 449 GLY n 
3 450 TYR n 
3 451 ILE n 
3 452 ASN n 
3 453 GLY n 
3 454 ARG n 
3 455 LEU n 
3 456 PRO n 
3 457 LEU n 
3 458 PRO n 
3 459 ASN n 
3 460 ILE n 
3 461 VAL n 
3 462 ASP n 
3 463 THR n 
3 464 TRP n 
3 465 THR n 
3 466 ASP n 
3 467 ILE n 
3 468 GLY n 
3 469 ALA n 
3 470 ARG n 
3 471 TRP n 
3 472 SER n 
3 473 LEU n 
3 474 ASP n 
3 475 VAL n 
3 476 MET n 
3 477 ASP n 
3 478 THR n 
3 479 VAL n 
3 480 ASN n 
3 481 PRO n 
3 482 PHE n 
3 483 ASN n 
3 484 HIS n 
3 485 HIS n 
3 486 ARG n 
3 487 ASN n 
3 488 THR n 
3 489 GLY n 
3 490 LEU n 
3 491 LYS n 
3 492 TYR n 
3 493 ARG n 
3 494 SER n 
3 495 GLN n 
3 496 LEU n 
3 497 LEU n 
3 498 GLY n 
3 499 ASN n 
3 500 GLY n 
3 501 ARG n 
3 502 TYR n 
3 503 CYS n 
3 504 ASP n 
3 505 PHE n 
3 506 HIS n 
3 507 ILE n 
3 508 GLN n 
3 509 VAL n 
3 510 PRO n 
3 511 GLN n 
3 512 LYS n 
3 513 PHE n 
3 514 PHE n 
3 515 ALA n 
3 516 ILE n 
3 517 LYS n 
3 518 ASN n 
3 519 LEU n 
3 520 LEU n 
3 521 LEU n 
3 522 LEU n 
3 523 PRO n 
3 524 GLY n 
3 525 THR n 
3 526 TYR n 
3 527 ASN n 
3 528 TYR n 
3 529 GLU n 
3 530 TRP n 
3 531 TYR n 
3 532 PHE n 
3 533 ARG n 
3 534 LYS n 
3 535 ASP n 
3 536 PRO n 
3 537 ASN n 
3 538 MET n 
3 539 VAL n 
3 540 LEU n 
3 541 GLN n 
3 542 SER n 
3 543 THR n 
3 544 LEU n 
3 545 GLY n 
3 546 ASN n 
3 547 ASP n 
3 548 LEU n 
3 549 ARG n 
3 550 ALA n 
3 551 ASP n 
3 552 GLY n 
3 553 ALA n 
3 554 SER n 
3 555 ILE n 
3 556 THR n 
3 557 TYR n 
3 558 THR n 
3 559 GLN n 
3 560 ILE n 
3 561 ASN n 
3 562 LEU n 
3 563 TYR n 
3 564 VAL n 
3 565 SER n 
3 566 PHE n 
3 567 PHE n 
3 568 PRO n 
3 569 MET n 
3 570 ASN n 
3 571 TYR n 
3 572 ASP n 
3 573 THR n 
3 574 GLN n 
3 575 SER n 
3 576 GLU n 
3 577 LEU n 
3 578 GLU n 
3 579 LEU n 
3 580 MET n 
3 581 LEU n 
3 582 ARG n 
3 583 ASN n 
3 584 ALA n 
3 585 THR n 
3 586 ASN n 
3 587 ASP n 
3 588 GLN n 
3 589 ASN n 
3 590 PHE n 
3 591 SER n 
3 592 ASP n 
3 593 TYR n 
3 594 LEU n 
3 595 GLY n 
3 596 ALA n 
3 597 VAL n 
3 598 ASN n 
3 599 ASN n 
3 600 LEU n 
3 601 TYR n 
3 602 GLN n 
3 603 ILE n 
3 604 PRO n 
3 605 ALA n 
3 606 GLY n 
3 607 SER n 
3 608 SER n 
3 609 THR n 
3 610 VAL n 
3 611 VAL n 
3 612 VAL n 
3 613 ASN n 
3 614 ILE n 
3 615 PRO n 
3 616 ASP n 
3 617 ARG n 
3 618 SER n 
3 619 TRP n 
3 620 GLY n 
3 621 ALA n 
3 622 PHE n 
3 623 ARG n 
3 624 GLY n 
3 625 TRP n 
3 626 SER n 
3 627 PHE n 
3 628 THR n 
3 629 ARG n 
3 630 LEU n 
3 631 LYS n 
3 632 VAL n 
3 633 SER n 
3 634 GLU n 
3 635 THR n 
3 636 PRO n 
3 637 ARG n 
3 638 ILE n 
3 639 GLY n 
3 640 ALA n 
3 641 THR n 
3 642 GLN n 
3 643 ASP n 
3 644 PRO n 
3 645 ASN n 
3 646 PHE n 
3 647 GLN n 
3 648 TYR n 
3 649 SER n 
3 650 GLY n 
3 651 SER n 
3 652 ILE n 
3 653 PRO n 
3 654 TYR n 
3 655 LEU n 
3 656 ASP n 
3 657 GLY n 
3 658 THR n 
3 659 PHE n 
3 660 TYR n 
3 661 LEU n 
3 662 SER n 
3 663 HIS n 
3 664 THR n 
3 665 PHE n 
3 666 GLN n 
3 667 ARG n 
3 668 CYS n 
3 669 SER n 
3 670 ILE n 
3 671 GLN n 
3 672 TRP n 
3 673 ASP n 
3 674 SER n 
3 675 SER n 
3 676 VAL n 
3 677 PRO n 
3 678 TRP n 
3 679 PRO n 
3 680 GLY n 
3 681 ASN n 
3 682 ASP n 
3 683 ARG n 
3 684 MET n 
3 685 LEU n 
3 686 THR n 
3 687 PRO n 
3 688 ASN n 
3 689 TRP n 
3 690 PHE n 
3 691 GLU n 
3 692 ILE n 
3 693 LYS n 
3 694 ARG n 
3 695 PRO n 
3 696 ILE n 
3 697 ASN n 
3 698 GLN n 
3 699 ASP n 
3 700 ALA n 
3 701 GLU n 
3 702 GLY n 
3 703 ASN n 
3 704 ASP n 
3 705 THR n 
3 706 MET n 
3 707 GLN n 
3 708 SER n 
3 709 ASN n 
3 710 LEU n 
3 711 THR n 
3 712 LYS n 
3 713 ASP n 
3 714 PHE n 
3 715 PHE n 
3 716 MET n 
3 717 VAL n 
3 718 GLN n 
3 719 MET n 
3 720 ALA n 
3 721 ALA n 
3 722 SER n 
3 723 TYR n 
3 724 ASN n 
3 725 GLN n 
3 726 GLY n 
3 727 TYR n 
3 728 GLN n 
3 729 GLY n 
3 730 PHE n 
3 731 ASN n 
3 732 TRP n 
3 733 PRO n 
3 734 ASN n 
3 735 CYS n 
3 736 THR n 
3 737 LYS n 
3 738 HIS n 
3 739 TYR n 
3 740 GLY n 
3 741 PHE n 
3 742 ILE n 
3 743 ASN n 
3 744 ASN n 
3 745 PHE n 
3 746 GLU n 
3 747 PRO n 
3 748 MET n 
3 749 SER n 
3 750 ARG n 
3 751 GLN n 
3 752 VAL n 
3 753 PRO n 
3 754 GLU n 
3 755 TYR n 
3 756 GLY n 
3 757 ALA n 
3 758 ASN n 
3 759 TYR n 
3 760 PRO n 
3 761 ASN n 
3 762 LEU n 
3 763 MET n 
3 764 ALA n 
3 765 ALA n 
3 766 TYR n 
3 767 LEU n 
3 768 ALA n 
3 769 ASN n 
3 770 PRO n 
3 771 GLN n 
3 772 THR n 
3 773 MET n 
3 774 PRO n 
3 775 ILE n 
3 776 TRP n 
3 777 ASN n 
3 778 ASN n 
3 779 CYS n 
3 780 GLY n 
3 781 PHE n 
3 782 GLN n 
3 783 GLN n 
3 784 LYS n 
3 785 THR n 
3 786 ALA n 
3 787 THR n 
3 788 ASN n 
3 789 VAL n 
3 790 LEU n 
3 791 LEU n 
3 792 GLU n 
3 793 ARG n 
3 794 CYS n 
3 795 GLY n 
3 796 HIS n 
3 797 PRO n 
3 798 TYR n 
3 799 VAL n 
3 800 ALA n 
3 801 ASN n 
3 802 TRP n 
3 803 PRO n 
3 804 TYR n 
3 805 PRO n 
3 806 LEU n 
3 807 SER n 
3 808 GLY n 
3 809 ARG n 
3 810 ASN n 
3 811 ALA n 
3 812 VAL n 
3 813 PRO n 
3 814 ASN n 
3 815 GLN n 
3 816 VAL n 
3 817 THR n 
3 818 GLU n 
3 819 ARG n 
3 820 LYS n 
3 821 PHE n 
3 822 LEU n 
3 823 VAL n 
3 824 ASP n 
3 825 ARG n 
3 826 TYR n 
3 827 LEU n 
3 828 TRP n 
3 829 GLN n 
3 830 ILE n 
3 831 PRO n 
3 832 PHE n 
3 833 SER n 
3 834 SER n 
3 835 ASN n 
3 836 PHE n 
3 837 LEU n 
3 838 ASN n 
3 839 MET n 
3 840 GLY n 
3 841 THR n 
3 842 LEU n 
3 843 THR n 
3 844 ASP n 
3 845 LEU n 
3 846 GLY n 
3 847 GLN n 
3 848 ASN n 
3 849 VAL n 
3 850 MET n 
3 851 TYR n 
3 852 ALA n 
3 853 ASN n 
3 854 SER n 
3 855 SER n 
3 856 HIS n 
3 857 SER n 
3 858 LEU n 
3 859 ASN n 
3 860 MET n 
3 861 GLN n 
3 862 PHE n 
3 863 THR n 
3 864 VAL n 
3 865 ASP n 
3 866 PRO n 
3 867 MET n 
3 868 THR n 
3 869 GLU n 
3 870 PRO n 
3 871 THR n 
3 872 TYR n 
3 873 LEU n 
3 874 MET n 
3 875 LEU n 
3 876 LEU n 
3 877 PHE n 
3 878 GLY n 
3 879 VAL n 
3 880 PHE n 
3 881 ASP n 
3 882 GLN n 
3 883 VAL n 
3 884 VAL n 
3 885 ILE n 
3 886 ASN n 
3 887 GLN n 
3 888 PRO n 
3 889 THR n 
3 890 ARG n 
3 891 SER n 
3 892 GLY n 
3 893 ILE n 
3 894 SER n 
3 895 VAL n 
3 896 ALA n 
3 897 TYR n 
3 898 LEU n 
3 899 ARG n 
3 900 LEU n 
3 901 PRO n 
3 902 PHE n 
3 903 ALA n 
3 904 SER n 
3 905 GLY n 
3 906 SER n 
3 907 ALA n 
# 
loop_
_entity.id 
_entity.type 
_entity.src_method 
_entity.pdbx_description 
_entity.formula_weight 
_entity.pdbx_number_of_molecules 
_entity.pdbx_ec 
_entity.pdbx_mutation 
_entity.pdbx_fragment 
_entity.details 
1 polymer man ? 101531.594 1 ? ? ? ? 
2 polymer man ? 101432.461 1 ? ? ? ? 
3 polymer man ? 101689.750 1 ? ? ? ? 
# 
loop_
_pdbx_poly_seq_scheme.asym_id 
_pdbx_poly_seq_scheme.entity_id 
_pdbx_poly_seq_scheme.seq_id 
_pdbx_poly_seq_scheme.mon_id 
_pdbx_poly_seq_scheme.ndb_seq_num 
_pdbx_poly_seq_scheme.pdb_seq_num 
_pdbx_poly_seq_scheme.auth_seq_num 
_pdbx_poly_seq_scheme.pdb_mon_id 
_pdbx_poly_seq_scheme.auth_mon_id 
_pdbx_poly_seq_scheme.pdb_strand_id 
_pdbx_poly_seq_scheme.pdb_ins_code 
_pdbx_poly_seq_scheme.hetero 
A 1 1   MET 1   1   1   MET MET A . n 
A 1 2   GLU 2   2   2   GLU GLU A . n 
A 1 3   PRO 3   3   3   PRO PRO A . n 
A 1 4   GLN 4   4   4   GLN GLN A . n 
A 1 5   ARG 5   5   5   ARG ARG A . n 
A 1 6   GLU 6   6   6   GLU GLU A . n 
A 1 7   PHE 7   7   7   PHE PHE A . n 
A 1 8   PHE 8   8   8   PHE PHE A . n 
A 1 9   HIS 9   9   9   HIS HIS A . n 
A 1 10  ILE 10  10  10  ILE ILE A . n 
A 1 11  ALA 11  11  11  ALA ALA A . n 
A 1 12  GLY 12  12  12  GLY GLY A . n 
A 1 13  ARG 13  13  13  ARG ARG A . n 
A 1 14  SER 14  14  14  SER SER A . n 
A 1 15  ALA 15  15  15  ALA ALA A . n 
A 1 16  LYS 16  16  16  LYS LYS A . n 
A 1 17  GLU 17  17  17  GLU GLU A . n 
A 1 18  TYR 18  18  18  TYR TYR A . n 
A 1 19  LEU 19  19  19  LEU LEU A . n 
A 1 20  SER 20  20  20  SER SER A . n 
A 1 21  GLU 21  21  21  GLU GLU A . n 
A 1 22  ASN 22  22  22  ASN ASN A . n 
A 1 23  LEU 23  23  23  LEU LEU A . n 
A 1 24  VAL 24  24  24  VAL VAL A . n 
A 1 25  GLN 25  25  25  GLN GLN A . n 
A 1 26  PHE 26  26  26  PHE PHE A . n 
A 1 27  ILE 27  27  27  ILE ILE A . n 
A 1 28  GLN 28  28  28  GLN GLN A . n 
A 1 29  ALA 29  29  29  ALA ALA A . n 
A 1 30  THR 30  30  30  THR THR A . n 
A 1 31  GLN 31  31  31  GLN GLN A . n 
A 1 32  ASN 32  32  32  ASN ASN A . n 
A 1 33  TYR 33  33  33  TYR TYR A . n 
A 1 34  PHE 34  34  34  PHE PHE A . n 
A 1 35  ASN 35  35  35  ASN ASN A . n 
A 1 36  ILE 36  36  36  ILE ILE A . n 
A 1 37  GLY 37  37  37  GLY GLY A . n 
A 1 38  GLU 38  38  38  GLU GLU A . n 
A 1 39  LYS 39  39  39  LYS LYS A . n 
A 1 40  PHE 40  40  40  PHE PHE A . n 
A 1 41  ARG 41  41  41  ARG ARG A . n 
A 1 42  ASP 42  42  42  ASP ASP A . n 
A 1 43  PRO 43  43  43  PRO PRO A . n 
A 1 44  TYR 44  44  44  TYR TYR A . n 
A 1 45  VAL 45  45  45  VAL VAL A . n 
A 1 46  ALA 46  46  46  ALA ALA A . n 
A 1 47  PRO 47  47  47  PRO PRO A . n 
A 1 48  SER 48  48  48  SER SER A . n 
A 1 49  ALA 49  49  49  ALA ALA A . n 
A 1 50  GLY 50  50  50  GLY GLY A . n 
A 1 51  VAL 51  51  51  VAL VAL A . n 
A 1 52  THR 52  52  52  THR THR A . n 
A 1 53  THR 53  53  53  THR THR A . n 
A 1 54  ASP 54  54  54  ASP ASP A . n 
A 1 55  ARG 55  55  55  ARG ARG A . n 
A 1 56  SER 56  56  56  SER SER A . n 
A 1 57  GLN 57  57  57  GLN GLN A . n 
A 1 58  LYS 58  58  58  LYS LYS A . n 
A 1 59  LEU 59  59  59  LEU LEU A . n 
A 1 60  GLN 60  60  60  GLN GLN A . n 
A 1 61  LEU 61  61  61  LEU LEU A . n 
A 1 62  ARG 62  62  62  ARG ARG A . n 
A 1 63  VAL 63  63  63  VAL VAL A . n 
A 1 64  VAL 64  64  64  VAL VAL A . n 
A 1 65  PRO 65  65  65  PRO PRO A . n 
A 1 66  ILE 66  66  66  ILE ILE A . n 
A 1 67  GLN 67  67  67  GLN GLN A . n 
A 1 68  THR 68  68  68  THR THR A . n 
A 1 69  GLU 69  69  69  GLU GLU A . n 
A 1 70  ASP 70  70  70  ASP ASP A . n 
A 1 71  ASN 71  71  71  ASN ASN A . n 
A 1 72  VAL 72  72  72  VAL VAL A . n 
A 1 73  ASN 73  73  73  ASN ASN A . n 
A 1 74  TYR 74  74  74  TYR TYR A . n 
A 1 75  TYR 75  75  75  TYR TYR A . n 
A 1 76  LYS 76  76  76  LYS LYS A . n 
A 1 77  ALA 77  77  77  ALA ALA A . n 
A 1 78  ARG 78  78  78  ARG ARG A . n 
A 1 79  PHE 79  79  79  PHE PHE A . n 
A 1 80  THR 80  80  80  THR THR A . n 
A 1 81  LEU 81  81  81  LEU LEU A . n 
A 1 82  ASN 82  82  82  ASN ASN A . n 
A 1 83  VAL 83  83  83  VAL VAL A . n 
A 1 84  GLY 84  84  84  GLY GLY A . n 
A 1 85  ASP 85  85  85  ASP ASP A . n 
A 1 86  ASN 86  86  86  ASN ASN A . n 
A 1 87  ARG 87  87  87  ARG ARG A . n 
A 1 88  LEU 88  88  88  LEU LEU A . n 
A 1 89  VAL 89  89  89  VAL VAL A . n 
A 1 90  ASP 90  90  90  ASP ASP A . n 
A 1 91  LEU 91  91  91  LEU LEU A . n 
A 1 92  GLY 92  92  92  GLY GLY A . n 
A 1 93  SER 93  93  93  SER SER A . n 
A 1 94  SER 94  94  94  SER SER A . n 
A 1 95  TYR 95  95  95  TYR TYR A . n 
A 1 96  PHE 96  96  96  PHE PHE A . n 
A 1 97  ASP 97  97  97  ASP ASP A . n 
A 1 98  ILE 98  98  98  ILE ILE A . n 
A 1 99  LYS 99  99  99  LYS LYS A . n 
A 1 100 GLY 100 100 100 GLY GLY A . n 
A 1 101 THR 101 101 101 THR THR A . n 
A 1 102 LEU 102 102 102 LEU LEU A . n 
A 1 103 ASP 103 103 103 ASP ASP A . n 
A 1 104 ARG 104 104 104 ARG ARG A . n 
A 1 105 GLY 105 105 105 GLY GLY A . n 
A 1 106 PRO 106 106 106 PRO PRO A . n 
A 1 107 SER 107 107 107 SER SER A . n 
A 1 108 PHE 108 108 108 PHE PHE A . n 
A 1 109 LYS 109 109 109 LYS LYS A . n 
A 1 110 PRO 110 110 110 PRO PRO A . n 
A 1 111 TYR 111 111 111 TYR TYR A . n 
A 1 112 GLY 112 112 112 GLY GLY A . n 
A 1 113 GLY 113 113 113 GLY GLY A . n 
A 1 114 THR 114 114 114 THR THR A . n 
A 1 115 ALA 115 115 115 ALA ALA A . n 
A 1 116 TYR 116 116 116 TYR TYR A . n 
A 1 117 ASN 117 117 117 ASN ASN A . n 
A 1 118 PRO 118 118 118 PRO PRO A . n 
A 1 119 LEU 119 119 119 LEU LEU A . n 
A 1 120 ALA 120 120 120 ALA ALA A . n 
A 1 121 PRO 121 121 121 PRO PRO A . n 
A 1 122 LYS 122 122 122 LYS LYS A . n 
A 1 123 SER 123 123 123 SER SER A . n 
A 1 124 ALA 124 124 124 ALA ALA A . n 
A 1 125 PRO 125 125 125 PRO PRO A . n 
A 1 126 ILE 126 126 126 ILE ILE A . n 
A 1 127 ASN 127 127 127 ASN ASN A . n 
A 1 128 SER 128 128 128 SER SER A . n 
A 1 129 ALA 129 129 129 ALA ALA A . n 
A 1 130 PHE 130 130 130 PHE PHE A . n 
A 1 131 THR 131 131 131 THR THR A . n 
A 1 132 VAL 132 132 132 VAL VAL A . n 
A 1 133 GLY 133 133 133 GLY GLY A . n 
A 1 134 ASN 134 134 134 ASN ASN A . n 
A 1 135 ASP 135 135 135 ASP ASP A . n 
A 1 136 THR 136 136 136 THR THR A . n 
A 1 137 HIS 137 137 137 HIS HIS A . n 
A 1 138 PHE 138 138 138 PHE PHE A . n 
A 1 139 VAL 139 139 139 VAL VAL A . n 
A 1 140 ALA 140 140 140 ALA ALA A . n 
A 1 141 GLN 141 141 141 GLN GLN A . n 
A 1 142 LEU 142 142 142 LEU LEU A . n 
A 1 143 PRO 143 143 143 PRO PRO A . n 
A 1 144 GLN 144 144 144 GLN GLN A . n 
A 1 145 THR 145 145 145 THR THR A . n 
A 1 146 TYR 146 146 146 TYR TYR A . n 
A 1 147 ALA 147 147 147 ALA ALA A . n 
A 1 148 ALA 148 148 148 ALA ALA A . n 
A 1 149 GLY 149 149 149 GLY GLY A . n 
A 1 150 GLY 150 150 150 GLY GLY A . n 
A 1 151 THR 151 151 151 THR THR A . n 
A 1 152 GLY 152 152 152 GLY GLY A . n 
A 1 153 VAL 153 153 153 VAL VAL A . n 
A 1 154 THR 154 154 154 THR THR A . n 
A 1 155 GLU 155 155 155 GLU GLU A . n 
A 1 156 ALA 156 156 156 ALA ALA A . n 
A 1 157 ILE 157 157 157 ILE ILE A . n 
A 1 158 GLN 158 158 158 GLN GLN A . n 
A 1 159 GLN 159 159 159 GLN GLN A . n 
A 1 160 GLN 160 160 160 GLN GLN A . n 
A 1 161 VAL 161 161 161 VAL VAL A . n 
A 1 162 SER 162 162 162 SER SER A . n 
A 1 163 GLY 163 163 163 GLY GLY A . n 
A 1 164 VAL 164 164 164 VAL VAL A . n 
A 1 165 ASP 165 165 165 ASP ASP A . n 
A 1 166 PRO 166 166 166 PRO PRO A . n 
A 1 167 ASN 167 167 167 ASN ASN A . n 
A 1 168 PRO 168 168 168 PRO PRO A . n 
A 1 169 GLN 169 169 169 GLN GLN A . n 
A 1 170 VAL 170 170 170 VAL VAL A . n 
A 1 171 GLY 171 171 171 GLY GLY A . n 
A 1 172 GLN 172 172 172 GLN GLN A . n 
A 1 173 PRO 173 173 173 PRO PRO A . n 
A 1 174 ASN 174 174 174 ASN ASN A . n 
A 1 175 TYR 175 175 175 TYR TYR A . n 
A 1 176 ALA 176 176 176 ALA ALA A . n 
A 1 177 GLY 177 177 177 GLY GLY A . n 
A 1 178 PRO 178 178 178 PRO PRO A . n 
A 1 179 VAL 179 179 179 VAL VAL A . n 
A 1 180 VAL 180 180 180 VAL VAL A . n 
A 1 181 VAL 181 181 181 VAL VAL A . n 
A 1 182 ASN 182 182 182 ASN ASN A . n 
A 1 183 THR 183 183 183 THR THR A . n 
A 1 184 THR 184 184 184 THR THR A . n 
A 1 185 ASN 185 185 185 ASN ASN A . n 
A 1 186 ASN 186 186 186 ASN ASN A . n 
A 1 187 ALA 187 187 187 ALA ALA A . n 
A 1 188 GLY 188 188 188 GLY GLY A . n 
A 1 189 LEU 189 189 189 LEU LEU A . n 
A 1 190 GLY 190 190 190 GLY GLY A . n 
A 1 191 ARG 191 191 191 ARG ARG A . n 
A 1 192 ILE 192 192 192 ILE ILE A . n 
A 1 193 VAL 193 193 193 VAL VAL A . n 
A 1 194 SER 194 194 194 SER SER A . n 
A 1 195 ALA 195 195 195 ALA ALA A . n 
A 1 196 ASP 196 196 196 ASP ASP A . n 
A 1 197 SER 197 197 197 SER SER A . n 
A 1 198 GLU 198 198 198 GLU GLU A . n 
A 1 199 GLY 199 199 199 GLY GLY A . n 
A 1 200 GLN 200 200 200 GLN GLN A . n 
A 1 201 GLN 201 201 201 GLN GLN A . n 
A 1 202 PHE 202 202 202 PHE PHE A . n 
A 1 203 PRO 203 203 203 PRO PRO A . n 
A 1 204 CYS 204 204 204 CYS CYS A . n 
A 1 205 TYR 205 205 205 TYR TYR A . n 
A 1 206 GLY 206 206 206 GLY GLY A . n 
A 1 207 ALA 207 207 207 ALA ALA A . n 
A 1 208 TYR 208 208 208 TYR TYR A . n 
A 1 209 ALA 209 209 209 ALA ALA A . n 
A 1 210 PRO 210 210 210 PRO PRO A . n 
A 1 211 PRO 211 211 211 PRO PRO A . n 
A 1 212 GLN 212 212 212 GLN GLN A . n 
A 1 213 SER 213 213 213 SER SER A . n 
A 1 214 ALA 214 214 214 ALA ALA A . n 
A 1 215 GLY 215 215 215 GLY GLY A . n 
A 1 216 GLY 216 216 216 GLY GLY A . n 
A 1 217 ASP 217 217 217 ASP ASP A . n 
A 1 218 VAL 218 218 218 VAL VAL A . n 
A 1 219 SER 219 219 219 SER SER A . n 
A 1 220 THR 220 220 220 THR THR A . n 
A 1 221 ALA 221 221 221 ALA ALA A . n 
A 1 222 ALA 222 222 222 ALA ALA A . n 
A 1 223 VAL 223 223 223 VAL VAL A . n 
A 1 224 THR 224 224 224 THR THR A . n 
A 1 225 LYS 225 225 225 LYS LYS A . n 
A 1 226 THR 226 226 226 THR THR A . n 
A 1 227 TYR 227 227 227 TYR TYR A . n 
A 1 228 ILE 228 228 228 ILE ILE A . n 
A 1 229 ASN 229 229 229 ASN ASN A . n 
A 1 230 THR 230 230 230 THR THR A . n 
A 1 231 THR 231 231 231 THR THR A . n 
A 1 232 ASN 232 232 232 ASN ASN A . n 
A 1 233 ASN 233 233 233 ASN ASN A . n 
A 1 234 ASN 234 234 234 ASN ASN A . n 
A 1 235 GLY 235 235 235 GLY GLY A . n 
A 1 236 ARG 236 236 236 ARG ARG A . n 
A 1 237 VAL 237 237 237 VAL VAL A . n 
A 1 238 SER 238 238 238 SER SER A . n 
A 1 239 GLY 239 239 239 GLY GLY A . n 
A 1 240 THR 240 240 240 THR THR A . n 
A 1 241 MET 241 241 241 MET MET A . n 
A 1 242 ALA 242 242 242 ALA ALA A . n 
A 1 243 THR 243 243 243 THR THR A . n 
A 1 244 ASP 244 244 244 ASP ASP A . n 
A 1 245 THR 245 245 245 THR THR A . n 
A 1 246 ILE 246 246 246 ILE ILE A . n 
A 1 247 THR 247 247 247 THR THR A . n 
A 1 248 TRP 248 248 248 TRP TRP A . n 
A 1 249 GLU 249 249 249 GLU GLU A . n 
A 1 250 ASN 250 250 250 ASN ASN A . n 
A 1 251 PRO 251 251 251 PRO PRO A . n 
A 1 252 ASP 252 252 252 ASP ASP A . n 
A 1 253 ALA 253 253 253 ALA ALA A . n 
A 1 254 HIS 254 254 254 HIS HIS A . n 
A 1 255 PHE 255 255 255 PHE PHE A . n 
A 1 256 ALA 256 256 256 ALA ALA A . n 
A 1 257 ASP 257 257 257 ASP ASP A . n 
A 1 258 PHE 258 258 258 PHE PHE A . n 
A 1 259 VAL 259 259 259 VAL VAL A . n 
A 1 260 ASP 260 260 260 ASP ASP A . n 
A 1 261 ASP 261 261 261 ASP ASP A . n 
A 1 262 ARG 262 262 262 ARG ARG A . n 
A 1 263 ARG 263 263 263 ARG ARG A . n 
A 1 264 ALA 264 264 264 ALA ALA A . n 
A 1 265 THR 265 265 265 THR THR A . n 
A 1 266 ALA 266 266 266 ALA ALA A . n 
A 1 267 ALA 267 267 267 ALA ALA A . n 
A 1 268 GLY 268 268 268 GLY GLY A . n 
A 1 269 ASN 269 269 269 ASN ASN A . n 
A 1 270 ARG 270 270 270 ARG ARG A . n 
A 1 271 PRO 271 271 271 PRO PRO A . n 
A 1 272 ASN 272 272 272 ASN ASN A . n 
A 1 273 TYR 273 273 273 TYR TYR A . n 
A 1 274 ILE 274 274 274 ILE ILE A . n 
A 1 275 GLY 275 275 275 GLY GLY A . n 
A 1 276 PHE 276 276 276 PHE PHE A . n 
A 1 277 ARG 277 277 277 ARG ARG A . n 
A 1 278 ASP 278 278 278 ASP ASP A . n 
A 1 279 ASN 279 279 279 ASN ASN A . n 
A 1 280 PHE 280 280 280 PHE PHE A . n 
A 1 281 ILE 281 281 281 ILE ILE A . n 
A 1 282 GLY 282 282 282 GLY GLY A . n 
A 1 283 MET 283 283 283 MET MET A . n 
A 1 284 MET 284 284 284 MET MET A . n 
A 1 285 TYR 285 285 285 TYR TYR A . n 
A 1 286 TYR 286 286 286 TYR TYR A . n 
A 1 287 ASN 287 287 287 ASN ASN A . n 
A 1 288 SER 288 288 288 SER SER A . n 
A 1 289 GLY 289 289 289 GLY GLY A . n 
A 1 290 SER 290 290 290 SER SER A . n 
A 1 291 ASN 291 291 291 ASN ASN A . n 
A 1 292 THR 292 292 292 THR THR A . n 
A 1 293 GLY 293 293 293 GLY GLY A . n 
A 1 294 SER 294 294 294 SER SER A . n 
A 1 295 PHE 295 295 295 PHE PHE A . n 
A 1 296 SER 296 296 296 SER SER A . n 
A 1 297 SER 297 297 297 SER SER A . n 
A 1 298 GLN 298 298 298 GLN GLN A . n 
A 1 299 THR 299 299 299 THR THR A . n 
A 1 300 GLN 300 300 300 GLN GLN A . n 
A 1 301 GLN 301 301 301 GLN GLN A . n 
A 1 302 LEU 302 302 302 LEU LEU A . n 
A 1 303 ASN 303 303 303 ASN ASN A . n 
A 1 304 ILE 304 304 304 ILE ILE A . n 
A 1 305 VAL 305 305 305 VAL VAL A . n 
A 1 306 LEU 306 306 306 LEU LEU A . n 
A 1 307 ASP 307 307 307 ASP ASP A . n 
A 1 308 LEU 308 308 308 LEU LEU A . n 
A 1 309 ASN 309 309 309 ASN ASN A . n 
A 1 310 ASP 310 310 310 ASP ASP A . n 
A 1 311 ARG 311 311 311 ARG ARG A . n 
A 1 312 ASN 312 312 312 ASN ASN A . n 
A 1 313 SER 313 313 313 SER SER A . n 
A 1 314 GLU 314 314 314 GLU GLU A . n 
A 1 315 LEU 315 315 315 LEU LEU A . n 
A 1 316 SER 316 316 316 SER SER A . n 
A 1 317 TYR 317 317 317 TYR TYR A . n 
A 1 318 GLN 318 318 318 GLN GLN A . n 
A 1 319 TYR 319 319 319 TYR TYR A . n 
A 1 320 LEU 320 320 320 LEU LEU A . n 
A 1 321 LEU 321 321 321 LEU LEU A . n 
A 1 322 ALA 322 322 322 ALA ALA A . n 
A 1 323 ASP 323 323 323 ASP ASP A . n 
A 1 324 LEU 324 324 324 LEU LEU A . n 
A 1 325 THR 325 325 325 THR THR A . n 
A 1 326 SER 326 326 326 SER SER A . n 
A 1 327 ARG 327 327 327 ARG ARG A . n 
A 1 328 TRP 328 328 328 TRP TRP A . n 
A 1 329 HIS 329 329 329 HIS HIS A . n 
A 1 330 TYR 330 330 330 TYR TYR A . n 
A 1 331 PHE 331 331 331 PHE PHE A . n 
A 1 332 ALA 332 332 332 ALA ALA A . n 
A 1 333 LEU 333 333 333 LEU LEU A . n 
A 1 334 TRP 334 334 334 TRP TRP A . n 
A 1 335 ASN 335 335 335 ASN ASN A . n 
A 1 336 GLN 336 336 336 GLN GLN A . n 
A 1 337 ALA 337 337 337 ALA ALA A . n 
A 1 338 VAL 338 338 338 VAL VAL A . n 
A 1 339 ASP 339 339 339 ASP ASP A . n 
A 1 340 ASP 340 340 340 ASP ASP A . n 
A 1 341 TYR 341 341 341 TYR TYR A . n 
A 1 342 ASP 342 342 342 ASP ASP A . n 
A 1 343 HIS 343 343 343 HIS HIS A . n 
A 1 344 HIS 344 344 344 HIS HIS A . n 
A 1 345 VAL 345 345 345 VAL VAL A . n 
A 1 346 ARG 346 346 346 ARG ARG A . n 
A 1 347 ILE 347 347 347 ILE ILE A . n 
A 1 348 LEU 348 348 348 LEU LEU A . n 
A 1 349 GLU 349 349 349 GLU GLU A . n 
A 1 350 ASN 350 350 350 ASN ASN A . n 
A 1 351 ASP 351 351 351 ASP ASP A . n 
A 1 352 GLY 352 352 352 GLY GLY A . n 
A 1 353 TYR 353 353 353 TYR TYR A . n 
A 1 354 GLU 354 354 354 GLU GLU A . n 
A 1 355 GLU 355 355 355 GLU GLU A . n 
A 1 356 GLY 356 356 356 GLY GLY A . n 
A 1 357 PRO 357 357 357 PRO PRO A . n 
A 1 358 PRO 358 358 358 PRO PRO A . n 
A 1 359 ASN 359 359 359 ASN ASN A . n 
A 1 360 LEU 360 360 360 LEU LEU A . n 
A 1 361 ALA 361 361 361 ALA ALA A . n 
A 1 362 PHE 362 362 362 PHE PHE A . n 
A 1 363 PRO 363 363 363 PRO PRO A . n 
A 1 364 PRO 364 364 364 PRO PRO A . n 
A 1 365 HIS 365 365 365 HIS HIS A . n 
A 1 366 VAL 366 366 366 VAL VAL A . n 
A 1 367 ILE 367 367 367 ILE ILE A . n 
A 1 368 SER 368 368 368 SER SER A . n 
A 1 369 ASN 369 369 369 ASN ASN A . n 
A 1 370 PRO 370 370 370 PRO PRO A . n 
A 1 371 PHE 371 371 371 PHE PHE A . n 
A 1 372 ALA 372 372 372 ALA ALA A . n 
A 1 373 PRO 373 373 373 PRO PRO A . n 
A 1 374 ALA 374 374 374 ALA ALA A . n 
A 1 375 ALA 375 375 375 ALA ALA A . n 
A 1 376 VAL 376 376 376 VAL VAL A . n 
A 1 377 GLY 377 377 377 GLY GLY A . n 
A 1 378 THR 378 378 378 THR THR A . n 
A 1 379 GLY 379 379 379 GLY GLY A . n 
A 1 380 MET 380 380 380 MET MET A . n 
A 1 381 THR 381 381 381 THR THR A . n 
A 1 382 VAL 382 382 382 VAL VAL A . n 
A 1 383 ASN 383 383 383 ASN ASN A . n 
A 1 384 GLU 384 384 384 GLU GLU A . n 
A 1 385 GLN 385 385 385 GLN GLN A . n 
A 1 386 GLN 386 386 386 GLN GLN A . n 
A 1 387 GLN 387 387 387 GLN GLN A . n 
A 1 388 THR 388 388 388 THR THR A . n 
A 1 389 ALA 389 389 389 ALA ALA A . n 
A 1 390 ALA 390 390 390 ALA ALA A . n 
A 1 391 VAL 391 391 391 VAL VAL A . n 
A 1 392 THR 392 392 392 THR THR A . n 
A 1 393 ALA 393 393 393 ALA ALA A . n 
A 1 394 ASN 394 394 394 ASN ASN A . n 
A 1 395 THR 395 395 395 THR THR A . n 
A 1 396 VAL 396 396 396 VAL VAL A . n 
A 1 397 ALA 397 397 397 ALA ALA A . n 
A 1 398 LEU 398 398 398 LEU LEU A . n 
A 1 399 ILE 399 399 399 ILE ILE A . n 
A 1 400 GLY 400 400 400 GLY GLY A . n 
A 1 401 TYR 401 401 401 TYR TYR A . n 
A 1 402 GLY 402 402 402 GLY GLY A . n 
A 1 403 ASN 403 403 403 ASN ASN A . n 
A 1 404 ILE 404 404 404 ILE ILE A . n 
A 1 405 PRO 405 405 405 PRO PRO A . n 
A 1 406 ALA 406 406 406 ALA ALA A . n 
A 1 407 VAL 407 407 407 VAL VAL A . n 
A 1 408 GLU 408 408 408 GLU GLU A . n 
A 1 409 MET 409 409 409 MET MET A . n 
A 1 410 ASN 410 410 410 ASN ASN A . n 
A 1 411 LEU 411 411 411 LEU LEU A . n 
A 1 412 PRO 412 412 412 PRO PRO A . n 
A 1 413 ALA 413 413 413 ALA ALA A . n 
A 1 414 ASN 414 414 414 ASN ASN A . n 
A 1 415 LEU 415 415 415 LEU LEU A . n 
A 1 416 LYS 416 416 416 LYS LYS A . n 
A 1 417 ARG 417 417 417 ARG ARG A . n 
A 1 418 THR 418 418 418 THR THR A . n 
A 1 419 PHE 419 419 419 PHE PHE A . n 
A 1 420 LEU 420 420 420 LEU LEU A . n 
A 1 421 TYR 421 421 421 TYR TYR A . n 
A 1 422 SER 422 422 422 SER SER A . n 
A 1 423 ASN 423 423 423 ASN ASN A . n 
A 1 424 VAL 424 424 424 VAL VAL A . n 
A 1 425 ALA 425 425 425 ALA ALA A . n 
A 1 426 MET 426 426 426 MET MET A . n 
A 1 427 TYR 427 427 427 TYR TYR A . n 
A 1 428 LEU 428 428 428 LEU LEU A . n 
A 1 429 PRO 429 429 429 PRO PRO A . n 
A 1 430 ASP 430 430 430 ASP ASP A . n 
A 1 431 THR 431 431 431 THR THR A . n 
A 1 432 TYR 432 432 432 TYR TYR A . n 
A 1 433 LYS 433 433 433 LYS LYS A . n 
A 1 434 PHE 434 434 434 PHE PHE A . n 
A 1 435 THR 435 435 435 THR THR A . n 
A 1 436 PRO 436 436 436 PRO PRO A . n 
A 1 437 ALA 437 437 437 ALA ALA A . n 
A 1 438 ASN 438 438 438 ASN ASN A . n 
A 1 439 VAL 439 439 439 VAL VAL A . n 
A 1 440 ASP 440 440 440 ASP ASP A . n 
A 1 441 LEU 441 441 441 LEU LEU A . n 
A 1 442 PRO 442 442 442 PRO PRO A . n 
A 1 443 GLU 443 443 443 GLU GLU A . n 
A 1 444 ASN 444 444 444 ASN ASN A . n 
A 1 445 HIS 445 445 445 HIS HIS A . n 
A 1 446 LEU 446 446 446 LEU LEU A . n 
A 1 447 SER 447 447 447 SER SER A . n 
A 1 448 TYR 448 448 448 TYR TYR A . n 
A 1 449 GLY 449 449 449 GLY GLY A . n 
A 1 450 TYR 450 450 450 TYR TYR A . n 
A 1 451 ILE 451 451 451 ILE ILE A . n 
A 1 452 ASN 452 452 452 ASN ASN A . n 
A 1 453 GLY 453 453 453 GLY GLY A . n 
A 1 454 ARG 454 454 454 ARG ARG A . n 
A 1 455 LEU 455 455 455 LEU LEU A . n 
A 1 456 PRO 456 456 456 PRO PRO A . n 
A 1 457 LEU 457 457 457 LEU LEU A . n 
A 1 458 PRO 458 458 458 PRO PRO A . n 
A 1 459 ASN 459 459 459 ASN ASN A . n 
A 1 460 ILE 460 460 460 ILE ILE A . n 
A 1 461 VAL 461 461 461 VAL VAL A . n 
A 1 462 ASP 462 462 462 ASP ASP A . n 
A 1 463 THR 463 463 463 THR THR A . n 
A 1 464 TRP 464 464 464 TRP TRP A . n 
A 1 465 THR 465 465 465 THR THR A . n 
A 1 466 ASP 466 466 466 ASP ASP A . n 
A 1 467 ILE 467 467 467 ILE ILE A . n 
A 1 468 GLY 468 468 468 GLY GLY A . n 
A 1 469 ALA 469 469 469 ALA ALA A . n 
A 1 470 ARG 470 470 470 ARG ARG A . n 
A 1 471 TRP 471 471 471 TRP TRP A . n 
A 1 472 SER 472 472 472 SER SER A . n 
A 1 473 LEU 473 473 473 LEU LEU A . n 
A 1 474 ASP 474 474 474 ASP ASP A . n 
A 1 475 VAL 475 475 475 VAL VAL A . n 
A 1 476 MET 476 476 476 MET MET A . n 
A 1 477 ASP 477 477 477 ASP ASP A . n 
A 1 478 THR 478 478 478 THR THR A . n 
A 1 479 VAL 479 479 479 VAL VAL A . n 
A 1 480 ASN 480 480 480 ASN ASN A . n 
A 1 481 PRO 481 481 481 PRO PRO A . n 
A 1 482 PHE 482 482 482 PHE PHE A . n 
A 1 483 ASN 483 483 483 ASN ASN A . n 
A 1 484 HIS 484 484 484 HIS HIS A . n 
A 1 485 HIS 485 485 485 HIS HIS A . n 
A 1 486 ARG 486 486 486 ARG ARG A . n 
A 1 487 ASN 487 487 487 ASN ASN A . n 
A 1 488 THR 488 488 488 THR THR A . n 
A 1 489 GLY 489 489 489 GLY GLY A . n 
A 1 490 LEU 490 490 490 LEU LEU A . n 
A 1 491 LYS 491 491 491 LYS LYS A . n 
A 1 492 TYR 492 492 492 TYR TYR A . n 
A 1 493 ARG 493 493 493 ARG ARG A . n 
A 1 494 SER 494 494 494 SER SER A . n 
A 1 495 GLN 495 495 495 GLN GLN A . n 
A 1 496 LEU 496 496 496 LEU LEU A . n 
A 1 497 LEU 497 497 497 LEU LEU A . n 
A 1 498 GLY 498 498 498 GLY GLY A . n 
A 1 499 ASN 499 499 499 ASN ASN A . n 
A 1 500 GLY 500 500 500 GLY GLY A . n 
A 1 501 ARG 501 501 501 ARG ARG A . n 
A 1 502 TYR 502 502 502 TYR TYR A . n 
A 1 503 CYS 503 503 503 CYS CYS A . n 
A 1 504 ASP 504 504 504 ASP ASP A . n 
A 1 505 PHE 505 505 505 PHE PHE A . n 
A 1 506 HIS 506 506 506 HIS HIS A . n 
A 1 507 ILE 507 507 507 ILE ILE A . n 
A 1 508 GLN 508 508 508 GLN GLN A . n 
A 1 509 VAL 509 509 509 VAL VAL A . n 
A 1 510 PRO 510 510 510 PRO PRO A . n 
A 1 511 GLN 511 511 511 GLN GLN A . n 
A 1 512 LYS 512 512 512 LYS LYS A . n 
A 1 513 PHE 513 513 513 PHE PHE A . n 
A 1 514 PHE 514 514 514 PHE PHE A . n 
A 1 515 ALA 515 515 515 ALA ALA A . n 
A 1 516 ILE 516 516 516 ILE ILE A . n 
A 1 517 LYS 517 517 517 LYS LYS A . n 
A 1 518 ASN 518 518 518 ASN ASN A . n 
A 1 519 LEU 519 519 519 LEU LEU A . n 
A 1 520 LEU 520 520 520 LEU LEU A . n 
A 1 521 LEU 521 521 521 LEU LEU A . n 
A 1 522 LEU 522 522 522 LEU LEU A . n 
A 1 523 PRO 523 523 523 PRO PRO A . n 
A 1 524 GLY 524 524 524 GLY GLY A . n 
A 1 525 THR 525 525 525 THR THR A . n 
A 1 526 TYR 526 526 526 TYR TYR A . n 
A 1 527 ASN 527 527 527 ASN ASN A . n 
A 1 528 TYR 528 528 528 TYR TYR A . n 
A 1 529 GLU 529 529 529 GLU GLU A . n 
A 1 530 TRP 530 530 530 TRP TRP A . n 
A 1 531 TYR 531 531 531 TYR TYR A . n 
A 1 532 PHE 532 532 532 PHE PHE A . n 
A 1 533 ARG 533 533 533 ARG ARG A . n 
A 1 534 LYS 534 534 534 LYS LYS A . n 
A 1 535 ASP 535 535 535 ASP ASP A . n 
A 1 536 PRO 536 536 536 PRO PRO A . n 
A 1 537 ASN 537 537 537 ASN ASN A . n 
A 1 538 MET 538 538 538 MET MET A . n 
A 1 539 VAL 539 539 539 VAL VAL A . n 
A 1 540 LEU 540 540 540 LEU LEU A . n 
A 1 541 GLN 541 541 541 GLN GLN A . n 
A 1 542 SER 542 542 542 SER SER A . n 
A 1 543 THR 543 543 543 THR THR A . n 
A 1 544 LEU 544 544 544 LEU LEU A . n 
A 1 545 GLY 545 545 545 GLY GLY A . n 
A 1 546 ASN 546 546 546 ASN ASN A . n 
A 1 547 ASP 547 547 547 ASP ASP A . n 
A 1 548 LEU 548 548 548 LEU LEU A . n 
A 1 549 ARG 549 549 549 ARG ARG A . n 
A 1 550 ALA 550 550 550 ALA ALA A . n 
A 1 551 ASP 551 551 551 ASP ASP A . n 
A 1 552 GLY 552 552 552 GLY GLY A . n 
A 1 553 ALA 553 553 553 ALA ALA A . n 
A 1 554 SER 554 554 554 SER SER A . n 
A 1 555 ILE 555 555 555 ILE ILE A . n 
A 1 556 THR 556 556 556 THR THR A . n 
A 1 557 TYR 557 557 557 TYR TYR A . n 
A 1 558 THR 558 558 558 THR THR A . n 
A 1 559 GLN 559 559 559 GLN GLN A . n 
A 1 560 ILE 560 560 560 ILE ILE A . n 
A 1 561 ASN 561 561 561 ASN ASN A . n 
A 1 562 LEU 562 562 562 LEU LEU A . n 
A 1 563 TYR 563 563 563 TYR TYR A . n 
A 1 564 VAL 564 564 564 VAL VAL A . n 
A 1 565 SER 565 565 565 SER SER A . n 
A 1 566 PHE 566 566 566 PHE PHE A . n 
A 1 567 PHE 567 567 567 PHE PHE A . n 
A 1 568 PRO 568 568 568 PRO PRO A . n 
A 1 569 MET 569 569 569 MET MET A . n 
A 1 570 ASN 570 570 570 ASN ASN A . n 
A 1 571 TYR 571 571 571 TYR TYR A . n 
A 1 572 ASP 572 572 572 ASP ASP A . n 
A 1 573 THR 573 573 573 THR THR A . n 
A 1 574 GLN 574 574 574 GLN GLN A . n 
A 1 575 SER 575 575 575 SER SER A . n 
A 1 576 GLU 576 576 576 GLU GLU A . n 
A 1 577 LEU 577 577 577 LEU LEU A . n 
A 1 578 GLU 578 578 578 GLU GLU A . n 
A 1 579 LEU 579 579 579 LEU LEU A . n 
A 1 580 MET 580 580 580 MET MET A . n 
A 1 581 LEU 581 581 581 LEU LEU A . n 
A 1 582 ARG 582 582 582 ARG ARG A . n 
A 1 583 ASN 583 583 583 ASN ASN A . n 
A 1 584 ALA 584 584 584 ALA ALA A . n 
A 1 585 THR 585 585 585 THR THR A . n 
A 1 586 ASN 586 586 586 ASN ASN A . n 
A 1 587 ASP 587 587 587 ASP ASP A . n 
A 1 588 GLN 588 588 588 GLN GLN A . n 
A 1 589 ASN 589 589 589 ASN ASN A . n 
A 1 590 PHE 590 590 590 PHE PHE A . n 
A 1 591 SER 591 591 591 SER SER A . n 
A 1 592 ASP 592 592 592 ASP ASP A . n 
A 1 593 TYR 593 593 593 TYR TYR A . n 
A 1 594 LEU 594 594 594 LEU LEU A . n 
A 1 595 GLY 595 595 595 GLY GLY A . n 
A 1 596 ALA 596 596 596 ALA ALA A . n 
A 1 597 VAL 597 597 597 VAL VAL A . n 
A 1 598 ASN 598 598 598 ASN ASN A . n 
A 1 599 ASN 599 599 599 ASN ASN A . n 
A 1 600 LEU 600 600 600 LEU LEU A . n 
A 1 601 TYR 601 601 601 TYR TYR A . n 
A 1 602 GLN 602 602 602 GLN GLN A . n 
A 1 603 ILE 603 603 603 ILE ILE A . n 
A 1 604 PRO 604 604 604 PRO PRO A . n 
A 1 605 ALA 605 605 605 ALA ALA A . n 
A 1 606 GLY 606 606 606 GLY GLY A . n 
A 1 607 SER 607 607 607 SER SER A . n 
A 1 608 SER 608 608 608 SER SER A . n 
A 1 609 THR 609 609 609 THR THR A . n 
A 1 610 VAL 610 610 610 VAL VAL A . n 
A 1 611 VAL 611 611 611 VAL VAL A . n 
A 1 612 VAL 612 612 612 VAL VAL A . n 
A 1 613 ASN 613 613 613 ASN ASN A . n 
A 1 614 ILE 614 614 614 ILE ILE A . n 
A 1 615 PRO 615 615 615 PRO PRO A . n 
A 1 616 ASP 616 616 616 ASP ASP A . n 
A 1 617 ARG 617 617 617 ARG ARG A . n 
A 1 618 SER 618 618 618 SER SER A . n 
A 1 619 TRP 619 619 619 TRP TRP A . n 
A 1 620 GLY 620 620 620 GLY GLY A . n 
A 1 621 ALA 621 621 621 ALA ALA A . n 
A 1 622 PHE 622 622 622 PHE PHE A . n 
A 1 623 ARG 623 623 623 ARG ARG A . n 
A 1 624 GLY 624 624 624 GLY GLY A . n 
A 1 625 TRP 625 625 625 TRP TRP A . n 
A 1 626 SER 626 626 626 SER SER A . n 
A 1 627 PHE 627 627 627 PHE PHE A . n 
A 1 628 THR 628 628 628 THR THR A . n 
A 1 629 ARG 629 629 629 ARG ARG A . n 
A 1 630 LEU 630 630 630 LEU LEU A . n 
A 1 631 LYS 631 631 631 LYS LYS A . n 
A 1 632 VAL 632 632 632 VAL VAL A . n 
A 1 633 SER 633 633 633 SER SER A . n 
A 1 634 GLU 634 634 634 GLU GLU A . n 
A 1 635 THR 635 635 635 THR THR A . n 
A 1 636 PRO 636 636 636 PRO PRO A . n 
A 1 637 ARG 637 637 637 ARG ARG A . n 
A 1 638 ILE 638 638 638 ILE ILE A . n 
A 1 639 GLY 639 639 639 GLY GLY A . n 
A 1 640 ALA 640 640 640 ALA ALA A . n 
A 1 641 THR 641 641 641 THR THR A . n 
A 1 642 GLN 642 642 642 GLN GLN A . n 
A 1 643 ASP 643 643 643 ASP ASP A . n 
A 1 644 PRO 644 644 644 PRO PRO A . n 
A 1 645 ASN 645 645 645 ASN ASN A . n 
A 1 646 PHE 646 646 646 PHE PHE A . n 
A 1 647 GLN 647 647 647 GLN GLN A . n 
A 1 648 TYR 648 648 648 TYR TYR A . n 
A 1 649 SER 649 649 649 SER SER A . n 
A 1 650 GLY 650 650 650 GLY GLY A . n 
A 1 651 SER 651 651 651 SER SER A . n 
A 1 652 ILE 652 652 652 ILE ILE A . n 
A 1 653 PRO 653 653 653 PRO PRO A . n 
A 1 654 TYR 654 654 654 TYR TYR A . n 
A 1 655 LEU 655 655 655 LEU LEU A . n 
A 1 656 ASP 656 656 656 ASP ASP A . n 
A 1 657 GLY 657 657 657 GLY GLY A . n 
A 1 658 THR 658 658 658 THR THR A . n 
A 1 659 PHE 659 659 659 PHE PHE A . n 
A 1 660 TYR 660 660 660 TYR TYR A . n 
A 1 661 LEU 661 661 661 LEU LEU A . n 
A 1 662 SER 662 662 662 SER SER A . n 
A 1 663 HIS 663 663 663 HIS HIS A . n 
A 1 664 THR 664 664 664 THR THR A . n 
A 1 665 PHE 665 665 665 PHE PHE A . n 
A 1 666 GLN 666 666 666 GLN GLN A . n 
A 1 667 ARG 667 667 667 ARG ARG A . n 
A 1 668 CYS 668 668 668 CYS CYS A . n 
A 1 669 SER 669 669 669 SER SER A . n 
A 1 670 ILE 670 670 670 ILE ILE A . n 
A 1 671 GLN 671 671 671 GLN GLN A . n 
A 1 672 TRP 672 672 672 TRP TRP A . n 
A 1 673 ASP 673 673 673 ASP ASP A . n 
A 1 674 SER 674 674 674 SER SER A . n 
A 1 675 SER 675 675 675 SER SER A . n 
A 1 676 VAL 676 676 676 VAL VAL A . n 
A 1 677 PRO 677 677 677 PRO PRO A . n 
A 1 678 TRP 678 678 678 TRP TRP A . n 
A 1 679 PRO 679 679 679 PRO PRO A . n 
A 1 680 GLY 680 680 680 GLY GLY A . n 
A 1 681 ASN 681 681 681 ASN ASN A . n 
A 1 682 ASP 682 682 682 ASP ASP A . n 
A 1 683 ARG 683 683 683 ARG ARG A . n 
A 1 684 MET 684 684 684 MET MET A . n 
A 1 685 LEU 685 685 685 LEU LEU A . n 
A 1 686 THR 686 686 686 THR THR A . n 
A 1 687 PRO 687 687 687 PRO PRO A . n 
A 1 688 ASN 688 688 688 ASN ASN A . n 
A 1 689 TRP 689 689 689 TRP TRP A . n 
A 1 690 PHE 690 690 690 PHE PHE A . n 
A 1 691 GLU 691 691 691 GLU GLU A . n 
A 1 692 ILE 692 692 692 ILE ILE A . n 
A 1 693 LYS 693 693 693 LYS LYS A . n 
A 1 694 ARG 694 694 694 ARG ARG A . n 
A 1 695 PRO 695 695 695 PRO PRO A . n 
A 1 696 ILE 696 696 696 ILE ILE A . n 
A 1 697 ASN 697 697 697 ASN ASN A . n 
A 1 698 GLN 698 698 698 GLN GLN A . n 
A 1 699 ASP 699 699 699 ASP ASP A . n 
A 1 700 ALA 700 700 700 ALA ALA A . n 
A 1 701 GLU 701 701 701 GLU GLU A . n 
A 1 702 GLY 702 702 702 GLY GLY A . n 
A 1 703 ASN 703 703 703 ASN ASN A . n 
A 1 704 ASP 704 704 704 ASP ASP A . n 
A 1 705 THR 705 705 705 THR THR A . n 
A 1 706 MET 706 706 706 MET MET A . n 
A 1 707 GLN 707 707 707 GLN GLN A . n 
A 1 708 SER 708 708 708 SER SER A . n 
A 1 709 ASN 709 709 709 ASN ASN A . n 
A 1 710 LEU 710 710 710 LEU LEU A . n 
A 1 711 THR 711 711 711 THR THR A . n 
A 1 712 LYS 712 712 712 LYS LYS A . n 
A 1 713 ASP 713 713 713 ASP ASP A . n 
A 1 714 PHE 714 714 714 PHE PHE A . n 
A 1 715 PHE 715 715 715 PHE PHE A . n 
A 1 716 MET 716 716 716 MET MET A . n 
A 1 717 VAL 717 717 717 VAL VAL A . n 
A 1 718 GLN 718 718 718 GLN GLN A . n 
A 1 719 MET 719 719 719 MET MET A . n 
A 1 720 ALA 720 720 720 ALA ALA A . n 
A 1 721 ALA 721 721 721 ALA ALA A . n 
A 1 722 SER 722 722 722 SER SER A . n 
A 1 723 TYR 723 723 723 TYR TYR A . n 
A 1 724 ASN 724 724 724 ASN ASN A . n 
A 1 725 GLN 725 725 725 GLN GLN A . n 
A 1 726 GLY 726 726 726 GLY GLY A . n 
A 1 727 TYR 727 727 727 TYR TYR A . n 
A 1 728 GLN 728 728 728 GLN GLN A . n 
A 1 729 GLY 729 729 729 GLY GLY A . n 
A 1 730 PHE 730 730 730 PHE PHE A . n 
A 1 731 ASN 731 731 731 ASN ASN A . n 
A 1 732 TRP 732 732 732 TRP TRP A . n 
A 1 733 PRO 733 733 733 PRO PRO A . n 
A 1 734 ASN 734 734 734 ASN ASN A . n 
A 1 735 CYS 735 735 735 CYS CYS A . n 
A 1 736 THR 736 736 736 THR THR A . n 
A 1 737 LYS 737 737 737 LYS LYS A . n 
A 1 738 HIS 738 738 738 HIS HIS A . n 
A 1 739 TYR 739 739 739 TYR TYR A . n 
A 1 740 GLY 740 740 740 GLY GLY A . n 
A 1 741 PHE 741 741 741 PHE PHE A . n 
A 1 742 ILE 742 742 742 ILE ILE A . n 
A 1 743 ASN 743 743 743 ASN ASN A . n 
A 1 744 ASN 744 744 744 ASN ASN A . n 
A 1 745 PHE 745 745 745 PHE PHE A . n 
A 1 746 GLU 746 746 746 GLU GLU A . n 
A 1 747 PRO 747 747 747 PRO PRO A . n 
A 1 748 MET 748 748 748 MET MET A . n 
A 1 749 SER 749 749 749 SER SER A . n 
A 1 750 ARG 750 750 750 ARG ARG A . n 
A 1 751 GLN 751 751 751 GLN GLN A . n 
A 1 752 VAL 752 752 752 VAL VAL A . n 
A 1 753 PRO 753 753 753 PRO PRO A . n 
A 1 754 GLU 754 754 754 GLU GLU A . n 
A 1 755 TYR 755 755 755 TYR TYR A . n 
A 1 756 GLY 756 756 756 GLY GLY A . n 
A 1 757 ALA 757 757 757 ALA ALA A . n 
A 1 758 ASN 758 758 758 ASN ASN A . n 
A 1 759 TYR 759 759 759 TYR TYR A . n 
A 1 760 PRO 760 760 760 PRO PRO A . n 
A 1 761 ASN 761 761 761 ASN ASN A . n 
A 1 762 LEU 762 762 762 LEU LEU A . n 
A 1 763 MET 763 763 763 MET MET A . n 
A 1 764 ALA 764 764 764 ALA ALA A . n 
A 1 765 ALA 765 765 765 ALA ALA A . n 
A 1 766 TYR 766 766 766 TYR TYR A . n 
A 1 767 LEU 767 767 767 LEU LEU A . n 
A 1 768 ALA 768 768 768 ALA ALA A . n 
A 1 769 ASN 769 769 769 ASN ASN A . n 
A 1 770 PRO 770 770 770 PRO PRO A . n 
A 1 771 GLN 771 771 771 GLN GLN A . n 
A 1 772 THR 772 772 772 THR THR A . n 
A 1 773 MET 773 773 773 MET MET A . n 
A 1 774 PRO 774 774 774 PRO PRO A . n 
A 1 775 ILE 775 775 775 ILE ILE A . n 
A 1 776 TRP 776 776 776 TRP TRP A . n 
A 1 777 ASN 777 777 777 ASN ASN A . n 
A 1 778 ASN 778 778 778 ASN ASN A . n 
A 1 779 CYS 779 779 779 CYS CYS A . n 
A 1 780 GLY 780 780 780 GLY GLY A . n 
A 1 781 PHE 781 781 781 PHE PHE A . n 
A 1 782 GLN 782 782 782 GLN GLN A . n 
A 1 783 GLN 783 783 783 GLN GLN A . n 
A 1 784 LYS 784 784 784 LYS LYS A . n 
A 1 785 THR 785 785 785 THR THR A . n 
A 1 786 ALA 786 786 786 ALA ALA A . n 
A 1 787 THR 787 787 787 THR THR A . n 
A 1 788 ASN 788 788 788 ASN ASN A . n 
A 1 789 VAL 789 789 789 VAL VAL A . n 
A 1 790 LEU 790 790 790 LEU LEU A . n 
A 1 791 LEU 791 791 791 LEU LEU A . n 
A 1 792 GLU 792 792 792 GLU GLU A . n 
A 1 793 ARG 793 793 793 ARG ARG A . n 
A 1 794 CYS 794 794 794 CYS CYS A . n 
A 1 795 GLY 795 795 795 GLY GLY A . n 
A 1 796 HIS 796 796 796 HIS HIS A . n 
A 1 797 PRO 797 797 797 PRO PRO A . n 
A 1 798 TYR 798 798 798 TYR TYR A . n 
A 1 799 VAL 799 799 799 VAL VAL A . n 
A 1 800 ALA 800 800 800 ALA ALA A . n 
A 1 801 ASN 801 801 801 ASN ASN A . n 
A 1 802 TRP 802 802 802 TRP TRP A . n 
A 1 803 PRO 803 803 803 PRO PRO A . n 
A 1 804 TYR 804 804 804 TYR TYR A . n 
A 1 805 PRO 805 805 805 PRO PRO A . n 
A 1 806 LEU 806 806 806 LEU LEU A . n 
A 1 807 SER 807 807 807 SER SER A . n 
A 1 808 GLY 808 808 808 GLY GLY A . n 
A 1 809 ARG 809 809 809 ARG ARG A . n 
A 1 810 ASN 810 810 810 ASN ASN A . n 
A 1 811 ALA 811 811 811 ALA ALA A . n 
A 1 812 VAL 812 812 812 VAL VAL A . n 
A 1 813 PRO 813 813 813 PRO PRO A . n 
A 1 814 ASN 814 814 814 ASN ASN A . n 
A 1 815 GLN 815 815 815 GLN GLN A . n 
A 1 816 VAL 816 816 816 VAL VAL A . n 
A 1 817 THR 817 817 817 THR THR A . n 
A 1 818 GLU 818 818 818 GLU GLU A . n 
A 1 819 ARG 819 819 819 ARG ARG A . n 
A 1 820 LYS 820 820 820 LYS LYS A . n 
A 1 821 PHE 821 821 821 PHE PHE A . n 
A 1 822 LEU 822 822 822 LEU LEU A . n 
A 1 823 VAL 823 823 823 VAL VAL A . n 
A 1 824 ASP 824 824 824 ASP ASP A . n 
A 1 825 ARG 825 825 825 ARG ARG A . n 
A 1 826 TYR 826 826 826 TYR TYR A . n 
A 1 827 LEU 827 827 827 LEU LEU A . n 
A 1 828 TRP 828 828 828 TRP TRP A . n 
A 1 829 GLN 829 829 829 GLN GLN A . n 
A 1 830 ILE 830 830 830 ILE ILE A . n 
A 1 831 PRO 831 831 831 PRO PRO A . n 
A 1 832 PHE 832 832 832 PHE PHE A . n 
A 1 833 SER 833 833 833 SER SER A . n 
A 1 834 SER 834 834 834 SER SER A . n 
A 1 835 ASN 835 835 835 ASN ASN A . n 
A 1 836 PHE 836 836 836 PHE PHE A . n 
A 1 837 LEU 837 837 837 LEU LEU A . n 
A 1 838 ASN 838 838 838 ASN ASN A . n 
A 1 839 MET 839 839 839 MET MET A . n 
A 1 840 GLY 840 840 840 GLY GLY A . n 
A 1 841 THR 841 841 841 THR THR A . n 
A 1 842 LEU 842 842 842 LEU LEU A . n 
A 1 843 THR 843 843 843 THR THR A . n 
A 1 844 ASP 844 844 844 ASP ASP A . n 
A 1 845 LEU 845 845 845 LEU LEU A . n 
A 1 846 GLY 846 846 846 GLY GLY A . n 
A 1 847 GLN 847 847 847 GLN GLN A . n 
A 1 848 ASN 848 848 848 ASN ASN A . n 
A 1 849 VAL 849 849 849 VAL VAL A . n 
A 1 850 MET 850 850 850 MET MET A . n 
A 1 851 TYR 851 851 851 TYR TYR A . n 
A 1 852 ALA 852 852 852 ALA ALA A . n 
A 1 853 ASN 853 853 853 ASN ASN A . n 
A 1 854 SER 854 854 854 SER SER A . n 
A 1 855 SER 855 855 855 SER SER A . n 
A 1 856 HIS 856 856 856 HIS HIS A . n 
A 1 857 SER 857 857 857 SER SER A . n 
A 1 858 LEU 858 858 858 LEU LEU A . n 
A 1 859 ASN 859 859 859 ASN ASN A . n 
A 1 860 MET 860 860 860 MET MET A . n 
A 1 861 GLN 861 861 861 GLN GLN A . n 
A 1 862 PHE 862 862 862 PHE PHE A . n 
A 1 863 THR 863 863 863 THR THR A . n 
A 1 864 VAL 864 864 864 VAL VAL A . n 
A 1 865 ASP 865 865 865 ASP ASP A . n 
A 1 866 PRO 866 866 866 PRO PRO A . n 
A 1 867 MET 867 867 867 MET MET A . n 
A 1 868 THR 868 868 868 THR THR A . n 
A 1 869 GLU 869 869 869 GLU GLU A . n 
A 1 870 PRO 870 870 870 PRO PRO A . n 
A 1 871 THR 871 871 871 THR THR A . n 
A 1 872 TYR 872 872 872 TYR TYR A . n 
A 1 873 LEU 873 873 873 LEU LEU A . n 
A 1 874 MET 874 874 874 MET MET A . n 
A 1 875 LEU 875 875 875 LEU LEU A . n 
A 1 876 LEU 876 876 876 LEU LEU A . n 
A 1 877 PHE 877 877 877 PHE PHE A . n 
A 1 878 GLY 878 878 878 GLY GLY A . n 
A 1 879 VAL 879 879 879 VAL VAL A . n 
A 1 880 PHE 880 880 880 PHE PHE A . n 
A 1 881 ASP 881 881 881 ASP ASP A . n 
A 1 882 GLN 882 882 882 GLN GLN A . n 
A 1 883 VAL 883 883 883 VAL VAL A . n 
A 1 884 VAL 884 884 884 VAL VAL A . n 
A 1 885 ILE 885 885 885 ILE ILE A . n 
A 1 886 ASN 886 886 886 ASN ASN A . n 
A 1 887 GLN 887 887 887 GLN GLN A . n 
A 1 888 PRO 888 888 888 PRO PRO A . n 
A 1 889 THR 889 889 889 THR THR A . n 
A 1 890 ARG 890 890 890 ARG ARG A . n 
A 1 891 SER 891 891 891 SER SER A . n 
A 1 892 GLY 892 892 892 GLY GLY A . n 
A 1 893 ILE 893 893 893 ILE ILE A . n 
A 1 894 SER 894 894 894 SER SER A . n 
A 1 895 VAL 895 895 895 VAL VAL A . n 
A 1 896 ALA 896 896 896 ALA ALA A . n 
A 1 897 TYR 897 897 897 TYR TYR A . n 
A 1 898 LEU 898 898 898 LEU LEU A . n 
A 1 899 ARG 899 899 899 ARG ARG A . n 
A 1 900 LEU 900 900 900 LEU LEU A . n 
A 1 901 PRO 901 901 901 PRO PRO A . n 
A 1 902 PHE 902 902 902 PHE PHE A . n 
A 1 903 ALA 903 903 903 ALA ALA A . n 
A 1 904 SER 904 904 904 SER SER A . n 
A 1 905 GLY 905 905 905 GLY GLY A . n 
B 2 1   MET 1   1   1   MET MET B . n 
B 2 2   GLU 2   2   2   GLU GLU B . n 
B 2 3   PRO 3   3   3   PRO PRO B . n 
B 2 4   GLN 4   4   4   GLN GLN B . n 
B 2 5   ARG 5   5   5   ARG ARG B . n 
B 2 6   GLU 6   6   6   GLU GLU B . n 
B 2 7   PHE 7   7   7   PHE PHE B . n 
B 2 8   PHE 8   8   8   PHE PHE B . n 
B 2 9   HIS 9   9   9   HIS HIS B . n 
B 2 10  ILE 10  10  10  ILE ILE B . n 
B 2 11  ALA 11  11  11  ALA ALA B . n 
B 2 12  GLY 12  12  12  GLY GLY B . n 
B 2 13  ARG 13  13  13  ARG ARG B . n 
B 2 14  SER 14  14  14  SER SER B . n 
B 2 15  ALA 15  15  15  ALA ALA B . n 
B 2 16  LYS 16  16  16  LYS LYS B . n 
B 2 17  GLU 17  17  17  GLU GLU B . n 
B 2 18  TYR 18  18  18  TYR TYR B . n 
B 2 19  LEU 19  19  19  LEU LEU B . n 
B 2 20  SER 20  20  20  SER SER B . n 
B 2 21  GLU 21  21  21  GLU GLU B . n 
B 2 22  ASN 22  22  22  ASN ASN B . n 
B 2 23  LEU 23  23  23  LEU LEU B . n 
B 2 24  VAL 24  24  24  VAL VAL B . n 
B 2 25  GLN 25  25  25  GLN GLN B . n 
B 2 26  PHE 26  26  26  PHE PHE B . n 
B 2 27  ILE 27  27  27  ILE ILE B . n 
B 2 28  GLN 28  28  28  GLN GLN B . n 
B 2 29  ALA 29  29  29  ALA ALA B . n 
B 2 30  THR 30  30  30  THR THR B . n 
B 2 31  GLN 31  31  31  GLN GLN B . n 
B 2 32  ASN 32  32  32  ASN ASN B . n 
B 2 33  TYR 33  33  33  TYR TYR B . n 
B 2 34  PHE 34  34  34  PHE PHE B . n 
B 2 35  ASN 35  35  35  ASN ASN B . n 
B 2 36  ILE 36  36  36  ILE ILE B . n 
B 2 37  GLY 37  37  37  GLY GLY B . n 
B 2 38  GLU 38  38  38  GLU GLU B . n 
B 2 39  LYS 39  39  39  LYS LYS B . n 
B 2 40  PHE 40  40  40  PHE PHE B . n 
B 2 41  ARG 41  41  41  ARG ARG B . n 
B 2 42  ASP 42  42  42  ASP ASP B . n 
B 2 43  PRO 43  43  43  PRO PRO B . n 
B 2 44  TYR 44  44  44  TYR TYR B . n 
B 2 45  VAL 45  45  45  VAL VAL B . n 
B 2 46  ALA 46  46  46  ALA ALA B . n 
B 2 47  PRO 47  47  47  PRO PRO B . n 
B 2 48  SER 48  48  48  SER SER B . n 
B 2 49  ALA 49  49  49  ALA ALA B . n 
B 2 50  GLY 50  50  50  GLY GLY B . n 
B 2 51  VAL 51  51  51  VAL VAL B . n 
B 2 52  THR 52  52  52  THR THR B . n 
B 2 53  THR 53  53  53  THR THR B . n 
B 2 54  ASP 54  54  54  ASP ASP B . n 
B 2 55  ARG 55  55  55  ARG ARG B . n 
B 2 56  SER 56  56  56  SER SER B . n 
B 2 57  GLN 57  57  57  GLN GLN B . n 
B 2 58  LYS 58  58  58  LYS LYS B . n 
B 2 59  LEU 59  59  59  LEU LEU B . n 
B 2 60  GLN 60  60  60  GLN GLN B . n 
B 2 61  LEU 61  61  61  LEU LEU B . n 
B 2 62  ARG 62  62  62  ARG ARG B . n 
B 2 63  VAL 63  63  63  VAL VAL B . n 
B 2 64  VAL 64  64  64  VAL VAL B . n 
B 2 65  PRO 65  65  65  PRO PRO B . n 
B 2 66  ILE 66  66  66  ILE ILE B . n 
B 2 67  GLN 67  67  67  GLN GLN B . n 
B 2 68  THR 68  68  68  THR THR B . n 
B 2 69  GLU 69  69  69  GLU GLU B . n 
B 2 70  ASP 70  70  70  ASP ASP B . n 
B 2 71  ASN 71  71  71  ASN ASN B . n 
B 2 72  VAL 72  72  72  VAL VAL B . n 
B 2 73  ASN 73  73  73  ASN ASN B . n 
B 2 74  TYR 74  74  74  TYR TYR B . n 
B 2 75  TYR 75  75  75  TYR TYR B . n 
B 2 76  LYS 76  76  76  LYS LYS B . n 
B 2 77  ALA 77  77  77  ALA ALA B . n 
B 2 78  ARG 78  78  78  ARG ARG B . n 
B 2 79  PHE 79  79  79  PHE PHE B . n 
B 2 80  THR 80  80  80  THR THR B . n 
B 2 81  LEU 81  81  81  LEU LEU B . n 
B 2 82  ASN 82  82  82  ASN ASN B . n 
B 2 83  VAL 83  83  83  VAL VAL B . n 
B 2 84  GLY 84  84  84  GLY GLY B . n 
B 2 85  ASP 85  85  85  ASP ASP B . n 
B 2 86  ASN 86  86  86  ASN ASN B . n 
B 2 87  ARG 87  87  87  ARG ARG B . n 
B 2 88  LEU 88  88  88  LEU LEU B . n 
B 2 89  VAL 89  89  89  VAL VAL B . n 
B 2 90  ASP 90  90  90  ASP ASP B . n 
B 2 91  LEU 91  91  91  LEU LEU B . n 
B 2 92  GLY 92  92  92  GLY GLY B . n 
B 2 93  SER 93  93  93  SER SER B . n 
B 2 94  SER 94  94  94  SER SER B . n 
B 2 95  TYR 95  95  95  TYR TYR B . n 
B 2 96  PHE 96  96  96  PHE PHE B . n 
B 2 97  ASP 97  97  97  ASP ASP B . n 
B 2 98  ILE 98  98  98  ILE ILE B . n 
B 2 99  LYS 99  99  99  LYS LYS B . n 
B 2 100 GLY 100 100 100 GLY GLY B . n 
B 2 101 THR 101 101 101 THR THR B . n 
B 2 102 LEU 102 102 102 LEU LEU B . n 
B 2 103 ASP 103 103 103 ASP ASP B . n 
B 2 104 ARG 104 104 104 ARG ARG B . n 
B 2 105 GLY 105 105 105 GLY GLY B . n 
B 2 106 PRO 106 106 106 PRO PRO B . n 
B 2 107 SER 107 107 107 SER SER B . n 
B 2 108 PHE 108 108 108 PHE PHE B . n 
B 2 109 LYS 109 109 109 LYS LYS B . n 
B 2 110 PRO 110 110 110 PRO PRO B . n 
B 2 111 TYR 111 111 111 TYR TYR B . n 
B 2 112 GLY 112 112 112 GLY GLY B . n 
B 2 113 GLY 113 113 113 GLY GLY B . n 
B 2 114 THR 114 114 114 THR THR B . n 
B 2 115 ALA 115 115 115 ALA ALA B . n 
B 2 116 TYR 116 116 116 TYR TYR B . n 
B 2 117 ASN 117 117 117 ASN ASN B . n 
B 2 118 PRO 118 118 118 PRO PRO B . n 
B 2 119 LEU 119 119 119 LEU LEU B . n 
B 2 120 ALA 120 120 120 ALA ALA B . n 
B 2 121 PRO 121 121 121 PRO PRO B . n 
B 2 122 LYS 122 122 122 LYS LYS B . n 
B 2 123 SER 123 123 123 SER SER B . n 
B 2 124 ALA 124 124 124 ALA ALA B . n 
B 2 125 PRO 125 125 125 PRO PRO B . n 
B 2 126 ILE 126 126 126 ILE ILE B . n 
B 2 127 ASN 127 127 127 ASN ASN B . n 
B 2 128 SER 128 128 128 SER SER B . n 
B 2 129 ALA 129 129 129 ALA ALA B . n 
B 2 130 PHE 130 130 130 PHE PHE B . n 
B 2 131 THR 131 131 131 THR THR B . n 
B 2 132 VAL 132 132 132 VAL VAL B . n 
B 2 133 GLY 133 133 133 GLY GLY B . n 
B 2 134 ASN 134 134 134 ASN ASN B . n 
B 2 135 ASP 135 135 135 ASP ASP B . n 
B 2 136 THR 136 136 136 THR THR B . n 
B 2 137 HIS 137 137 137 HIS HIS B . n 
B 2 138 PHE 138 138 138 PHE PHE B . n 
B 2 139 VAL 139 139 139 VAL VAL B . n 
B 2 140 ALA 140 140 140 ALA ALA B . n 
B 2 141 GLN 141 141 141 GLN GLN B . n 
B 2 142 LEU 142 142 142 LEU LEU B . n 
B 2 143 PRO 143 143 143 PRO PRO B . n 
B 2 144 GLN 144 144 144 GLN GLN B . n 
B 2 145 THR 145 145 145 THR THR B . n 
B 2 146 TYR 146 146 146 TYR TYR B . n 
B 2 147 ALA 147 147 147 ALA ALA B . n 
B 2 148 ALA 148 148 148 ALA ALA B . n 
B 2 149 GLY 149 149 149 GLY GLY B . n 
B 2 150 GLY 150 150 150 GLY GLY B . n 
B 2 151 THR 151 151 151 THR THR B . n 
B 2 152 GLY 152 152 152 GLY GLY B . n 
B 2 153 VAL 153 153 153 VAL VAL B . n 
B 2 154 THR 154 154 154 THR THR B . n 
B 2 155 GLU 155 155 155 GLU GLU B . n 
B 2 156 ALA 156 156 156 ALA ALA B . n 
B 2 157 ILE 157 157 157 ILE ILE B . n 
B 2 158 GLN 158 158 158 GLN GLN B . n 
B 2 159 GLN 159 159 159 GLN GLN B . n 
B 2 160 GLN 160 160 160 GLN GLN B . n 
B 2 161 VAL 161 161 161 VAL VAL B . n 
B 2 162 SER 162 162 162 SER SER B . n 
B 2 163 GLY 163 163 163 GLY GLY B . n 
B 2 164 VAL 164 164 164 VAL VAL B . n 
B 2 165 ASP 165 165 165 ASP ASP B . n 
B 2 166 PRO 166 166 166 PRO PRO B . n 
B 2 167 ASN 167 167 167 ASN ASN B . n 
B 2 168 PRO 168 168 168 PRO PRO B . n 
B 2 169 GLN 169 169 169 GLN GLN B . n 
B 2 170 VAL 170 170 170 VAL VAL B . n 
B 2 171 GLY 171 171 171 GLY GLY B . n 
B 2 172 GLN 172 172 172 GLN GLN B . n 
B 2 173 PRO 173 173 173 PRO PRO B . n 
B 2 174 ASN 174 174 174 ASN ASN B . n 
B 2 175 TYR 175 175 175 TYR TYR B . n 
B 2 176 ALA 176 176 176 ALA ALA B . n 
B 2 177 GLY 177 177 177 GLY GLY B . n 
B 2 178 PRO 178 178 178 PRO PRO B . n 
B 2 179 VAL 179 179 179 VAL VAL B . n 
B 2 180 VAL 180 180 180 VAL VAL B . n 
B 2 181 VAL 181 181 181 VAL VAL B . n 
B 2 182 ASN 182 182 182 ASN ASN B . n 
B 2 183 THR 183 183 183 THR THR B . n 
B 2 184 THR 184 184 184 THR THR B . n 
B 2 185 ASN 185 185 185 ASN ASN B . n 
B 2 186 ASN 186 186 186 ASN ASN B . n 
B 2 187 ALA 187 187 187 ALA ALA B . n 
B 2 188 GLY 188 188 188 GLY GLY B . n 
B 2 189 LEU 189 189 189 LEU LEU B . n 
B 2 190 GLY 190 190 190 GLY GLY B . n 
B 2 191 ARG 191 191 191 ARG ARG B . n 
B 2 192 ILE 192 192 192 ILE ILE B . n 
B 2 193 VAL 193 193 193 VAL VAL B . n 
B 2 194 SER 194 194 194 SER SER B . n 
B 2 195 ALA 195 195 195 ALA ALA B . n 
B 2 196 ASP 196 196 196 ASP ASP B . n 
B 2 197 SER 197 197 197 SER SER B . n 
B 2 198 GLU 198 198 198 GLU GLU B . n 
B 2 199 GLY 199 199 199 GLY GLY B . n 
B 2 200 GLN 200 200 200 GLN GLN B . n 
B 2 201 GLN 201 201 201 GLN GLN B . n 
B 2 202 PHE 202 202 202 PHE PHE B . n 
B 2 203 PRO 203 203 203 PRO PRO B . n 
B 2 204 CYS 204 204 204 CYS CYS B . n 
B 2 205 TYR 205 205 205 TYR TYR B . n 
B 2 206 GLY 206 206 206 GLY GLY B . n 
B 2 207 ALA 207 207 207 ALA ALA B . n 
B 2 208 TYR 208 208 208 TYR TYR B . n 
B 2 209 ALA 209 209 209 ALA ALA B . n 
B 2 210 PRO 210 210 210 PRO PRO B . n 
B 2 211 PRO 211 211 211 PRO PRO B . n 
B 2 212 GLN 212 212 212 GLN GLN B . n 
B 2 213 SER 213 213 213 SER SER B . n 
B 2 214 ALA 214 214 214 ALA ALA B . n 
B 2 215 GLY 215 215 215 GLY GLY B . n 
B 2 216 GLY 216 216 216 GLY GLY B . n 
B 2 217 ASP 217 217 217 ASP ASP B . n 
B 2 218 VAL 218 218 218 VAL VAL B . n 
B 2 219 SER 219 219 219 SER SER B . n 
B 2 220 THR 220 220 220 THR THR B . n 
B 2 221 ALA 221 221 221 ALA ALA B . n 
B 2 222 ALA 222 222 222 ALA ALA B . n 
B 2 223 VAL 223 223 223 VAL VAL B . n 
B 2 224 THR 224 224 224 THR THR B . n 
B 2 225 LYS 225 225 225 LYS LYS B . n 
B 2 226 THR 226 226 226 THR THR B . n 
B 2 227 TYR 227 227 227 TYR TYR B . n 
B 2 228 ILE 228 228 228 ILE ILE B . n 
B 2 229 ASN 229 229 229 ASN ASN B . n 
B 2 230 THR 230 230 230 THR THR B . n 
B 2 231 THR 231 231 231 THR THR B . n 
B 2 232 ASN 232 232 232 ASN ASN B . n 
B 2 233 ASN 233 233 233 ASN ASN B . n 
B 2 234 ASN 234 234 234 ASN ASN B . n 
B 2 235 GLY 235 235 235 GLY GLY B . n 
B 2 236 ARG 236 236 236 ARG ARG B . n 
B 2 237 VAL 237 237 237 VAL VAL B . n 
B 2 238 SER 238 238 238 SER SER B . n 
B 2 239 GLY 239 239 239 GLY GLY B . n 
B 2 240 THR 240 240 240 THR THR B . n 
B 2 241 MET 241 241 241 MET MET B . n 
B 2 242 ALA 242 242 242 ALA ALA B . n 
B 2 243 THR 243 243 243 THR THR B . n 
B 2 244 ASP 244 244 244 ASP ASP B . n 
B 2 245 THR 245 245 245 THR THR B . n 
B 2 246 ILE 246 246 246 ILE ILE B . n 
B 2 247 THR 247 247 247 THR THR B . n 
B 2 248 TRP 248 248 248 TRP TRP B . n 
B 2 249 GLU 249 249 249 GLU GLU B . n 
B 2 250 ASN 250 250 250 ASN ASN B . n 
B 2 251 PRO 251 251 251 PRO PRO B . n 
B 2 252 ASP 252 252 252 ASP ASP B . n 
B 2 253 ALA 253 253 253 ALA ALA B . n 
B 2 254 HIS 254 254 254 HIS HIS B . n 
B 2 255 PHE 255 255 255 PHE PHE B . n 
B 2 256 ALA 256 256 256 ALA ALA B . n 
B 2 257 ASP 257 257 257 ASP ASP B . n 
B 2 258 PHE 258 258 258 PHE PHE B . n 
B 2 259 VAL 259 259 259 VAL VAL B . n 
B 2 260 ASP 260 260 260 ASP ASP B . n 
B 2 261 ASP 261 261 261 ASP ASP B . n 
B 2 262 ARG 262 262 262 ARG ARG B . n 
B 2 263 ARG 263 263 263 ARG ARG B . n 
B 2 264 ALA 264 264 264 ALA ALA B . n 
B 2 265 THR 265 265 265 THR THR B . n 
B 2 266 ALA 266 266 266 ALA ALA B . n 
B 2 267 ALA 267 267 267 ALA ALA B . n 
B 2 268 GLY 268 268 268 GLY GLY B . n 
B 2 269 ASN 269 269 269 ASN ASN B . n 
B 2 270 ARG 270 270 270 ARG ARG B . n 
B 2 271 PRO 271 271 271 PRO PRO B . n 
B 2 272 ASN 272 272 272 ASN ASN B . n 
B 2 273 TYR 273 273 273 TYR TYR B . n 
B 2 274 ILE 274 274 274 ILE ILE B . n 
B 2 275 GLY 275 275 275 GLY GLY B . n 
B 2 276 PHE 276 276 276 PHE PHE B . n 
B 2 277 ARG 277 277 277 ARG ARG B . n 
B 2 278 ASP 278 278 278 ASP ASP B . n 
B 2 279 ASN 279 279 279 ASN ASN B . n 
B 2 280 PHE 280 280 280 PHE PHE B . n 
B 2 281 ILE 281 281 281 ILE ILE B . n 
B 2 282 GLY 282 282 282 GLY GLY B . n 
B 2 283 MET 283 283 283 MET MET B . n 
B 2 284 MET 284 284 284 MET MET B . n 
B 2 285 TYR 285 285 285 TYR TYR B . n 
B 2 286 TYR 286 286 286 TYR TYR B . n 
B 2 287 ASN 287 287 287 ASN ASN B . n 
B 2 288 SER 288 288 288 SER SER B . n 
B 2 289 GLY 289 289 289 GLY GLY B . n 
B 2 290 SER 290 290 290 SER SER B . n 
B 2 291 ASN 291 291 291 ASN ASN B . n 
B 2 292 THR 292 292 292 THR THR B . n 
B 2 293 GLY 293 293 293 GLY GLY B . n 
B 2 294 SER 294 294 294 SER SER B . n 
B 2 295 PHE 295 295 295 PHE PHE B . n 
B 2 296 SER 296 296 296 SER SER B . n 
B 2 297 SER 297 297 297 SER SER B . n 
B 2 298 GLN 298 298 298 GLN GLN B . n 
B 2 299 THR 299 299 299 THR THR B . n 
B 2 300 GLN 300 300 300 GLN GLN B . n 
B 2 301 GLN 301 301 301 GLN GLN B . n 
B 2 302 LEU 302 302 302 LEU LEU B . n 
B 2 303 ASN 303 303 303 ASN ASN B . n 
B 2 304 ILE 304 304 304 ILE ILE B . n 
B 2 305 VAL 305 305 305 VAL VAL B . n 
B 2 306 LEU 306 306 306 LEU LEU B . n 
B 2 307 ASP 307 307 307 ASP ASP B . n 
B 2 308 LEU 308 308 308 LEU LEU B . n 
B 2 309 ASN 309 309 309 ASN ASN B . n 
B 2 310 ASP 310 310 310 ASP ASP B . n 
B 2 311 ARG 311 311 311 ARG ARG B . n 
B 2 312 ASN 312 312 312 ASN ASN B . n 
B 2 313 SER 313 313 313 SER SER B . n 
B 2 314 GLU 314 314 314 GLU GLU B . n 
B 2 315 LEU 315 315 315 LEU LEU B . n 
B 2 316 SER 316 316 316 SER SER B . n 
B 2 317 TYR 317 317 317 TYR TYR B . n 
B 2 318 GLN 318 318 318 GLN GLN B . n 
B 2 319 TYR 319 319 319 TYR TYR B . n 
B 2 320 LEU 320 320 320 LEU LEU B . n 
B 2 321 LEU 321 321 321 LEU LEU B . n 
B 2 322 ALA 322 322 322 ALA ALA B . n 
B 2 323 ASP 323 323 323 ASP ASP B . n 
B 2 324 LEU 324 324 324 LEU LEU B . n 
B 2 325 THR 325 325 325 THR THR B . n 
B 2 326 SER 326 326 326 SER SER B . n 
B 2 327 ARG 327 327 327 ARG ARG B . n 
B 2 328 TRP 328 328 328 TRP TRP B . n 
B 2 329 HIS 329 329 329 HIS HIS B . n 
B 2 330 TYR 330 330 330 TYR TYR B . n 
B 2 331 PHE 331 331 331 PHE PHE B . n 
B 2 332 ALA 332 332 332 ALA ALA B . n 
B 2 333 LEU 333 333 333 LEU LEU B . n 
B 2 334 TRP 334 334 334 TRP TRP B . n 
B 2 335 ASN 335 335 335 ASN ASN B . n 
B 2 336 GLN 336 336 336 GLN GLN B . n 
B 2 337 ALA 337 337 337 ALA ALA B . n 
B 2 338 VAL 338 338 338 VAL VAL B . n 
B 2 339 ASP 339 339 339 ASP ASP B . n 
B 2 340 ASP 340 340 340 ASP ASP B . n 
B 2 341 TYR 341 341 341 TYR TYR B . n 
B 2 342 ASP 342 342 342 ASP ASP B . n 
B 2 343 HIS 343 343 343 HIS HIS B . n 
B 2 344 HIS 344 344 344 HIS HIS B . n 
B 2 345 VAL 345 345 345 VAL VAL B . n 
B 2 346 ARG 346 346 346 ARG ARG B . n 
B 2 347 ILE 347 347 347 ILE ILE B . n 
B 2 348 LEU 348 348 348 LEU LEU B . n 
B 2 349 GLU 349 349 349 GLU GLU B . n 
B 2 350 ASN 350 350 350 ASN ASN B . n 
B 2 351 ASP 351 351 351 ASP ASP B . n 
B 2 352 GLY 352 352 352 GLY GLY B . n 
B 2 353 TYR 353 353 353 TYR TYR B . n 
B 2 354 GLU 354 354 354 GLU GLU B . n 
B 2 355 GLU 355 355 355 GLU GLU B . n 
B 2 356 GLY 356 356 356 GLY GLY B . n 
B 2 357 PRO 357 357 357 PRO PRO B . n 
B 2 358 PRO 358 358 358 PRO PRO B . n 
B 2 359 ASN 359 359 359 ASN ASN B . n 
B 2 360 LEU 360 360 360 LEU LEU B . n 
B 2 361 ALA 361 361 361 ALA ALA B . n 
B 2 362 PHE 362 362 362 PHE PHE B . n 
B 2 363 PRO 363 363 363 PRO PRO B . n 
B 2 364 PRO 364 364 364 PRO PRO B . n 
B 2 365 HIS 365 365 365 HIS HIS B . n 
B 2 366 VAL 366 366 366 VAL VAL B . n 
B 2 367 ILE 367 367 367 ILE ILE B . n 
B 2 368 SER 368 368 368 SER SER B . n 
B 2 369 ASN 369 369 369 ASN ASN B . n 
B 2 370 PRO 370 370 370 PRO PRO B . n 
B 2 371 PHE 371 371 371 PHE PHE B . n 
B 2 372 ALA 372 372 372 ALA ALA B . n 
B 2 373 PRO 373 373 373 PRO PRO B . n 
B 2 374 ALA 374 374 374 ALA ALA B . n 
B 2 375 ALA 375 375 375 ALA ALA B . n 
B 2 376 VAL 376 376 376 VAL VAL B . n 
B 2 377 GLY 377 377 377 GLY GLY B . n 
B 2 378 THR 378 378 378 THR THR B . n 
B 2 379 GLY 379 379 379 GLY GLY B . n 
B 2 380 MET 380 380 380 MET MET B . n 
B 2 381 THR 381 381 381 THR THR B . n 
B 2 382 VAL 382 382 382 VAL VAL B . n 
B 2 383 ASN 383 383 383 ASN ASN B . n 
B 2 384 GLU 384 384 384 GLU GLU B . n 
B 2 385 GLN 385 385 385 GLN GLN B . n 
B 2 386 GLN 386 386 386 GLN GLN B . n 
B 2 387 GLN 387 387 387 GLN GLN B . n 
B 2 388 THR 388 388 388 THR THR B . n 
B 2 389 ALA 389 389 389 ALA ALA B . n 
B 2 390 ALA 390 390 390 ALA ALA B . n 
B 2 391 VAL 391 391 391 VAL VAL B . n 
B 2 392 THR 392 392 392 THR THR B . n 
B 2 393 ALA 393 393 393 ALA ALA B . n 
B 2 394 ASN 394 394 394 ASN ASN B . n 
B 2 395 THR 395 395 395 THR THR B . n 
B 2 396 VAL 396 396 396 VAL VAL B . n 
B 2 397 ALA 397 397 397 ALA ALA B . n 
B 2 398 LEU 398 398 398 LEU LEU B . n 
B 2 399 ILE 399 399 399 ILE ILE B . n 
B 2 400 GLY 400 400 400 GLY GLY B . n 
B 2 401 TYR 401 401 401 TYR TYR B . n 
B 2 402 GLY 402 402 402 GLY GLY B . n 
B 2 403 ASN 403 403 403 ASN ASN B . n 
B 2 404 ILE 404 404 404 ILE ILE B . n 
B 2 405 PRO 405 405 405 PRO PRO B . n 
B 2 406 ALA 406 406 406 ALA ALA B . n 
B 2 407 VAL 407 407 407 VAL VAL B . n 
B 2 408 GLU 408 408 408 GLU GLU B . n 
B 2 409 MET 409 409 409 MET MET B . n 
B 2 410 ASN 410 410 410 ASN ASN B . n 
B 2 411 LEU 411 411 411 LEU LEU B . n 
B 2 412 PRO 412 412 412 PRO PRO B . n 
B 2 413 ALA 413 413 413 ALA ALA B . n 
B 2 414 ASN 414 414 414 ASN ASN B . n 
B 2 415 LEU 415 415 415 LEU LEU B . n 
B 2 416 LYS 416 416 416 LYS LYS B . n 
B 2 417 ARG 417 417 417 ARG ARG B . n 
B 2 418 THR 418 418 418 THR THR B . n 
B 2 419 PHE 419 419 419 PHE PHE B . n 
B 2 420 LEU 420 420 420 LEU LEU B . n 
B 2 421 TYR 421 421 421 TYR TYR B . n 
B 2 422 SER 422 422 422 SER SER B . n 
B 2 423 ASN 423 423 423 ASN ASN B . n 
B 2 424 VAL 424 424 424 VAL VAL B . n 
B 2 425 ALA 425 425 425 ALA ALA B . n 
B 2 426 MET 426 426 426 MET MET B . n 
B 2 427 TYR 427 427 427 TYR TYR B . n 
B 2 428 LEU 428 428 428 LEU LEU B . n 
B 2 429 PRO 429 429 429 PRO PRO B . n 
B 2 430 ASP 430 430 430 ASP ASP B . n 
B 2 431 THR 431 431 431 THR THR B . n 
B 2 432 TYR 432 432 432 TYR TYR B . n 
B 2 433 LYS 433 433 433 LYS LYS B . n 
B 2 434 PHE 434 434 434 PHE PHE B . n 
B 2 435 THR 435 435 435 THR THR B . n 
B 2 436 PRO 436 436 436 PRO PRO B . n 
B 2 437 ALA 437 437 437 ALA ALA B . n 
B 2 438 ASN 438 438 438 ASN ASN B . n 
B 2 439 VAL 439 439 439 VAL VAL B . n 
B 2 440 ASP 440 440 440 ASP ASP B . n 
B 2 441 LEU 441 441 441 LEU LEU B . n 
B 2 442 PRO 442 442 442 PRO PRO B . n 
B 2 443 GLU 443 443 443 GLU GLU B . n 
B 2 444 ASN 444 444 444 ASN ASN B . n 
B 2 445 HIS 445 445 445 HIS HIS B . n 
B 2 446 LEU 446 446 446 LEU LEU B . n 
B 2 447 SER 447 447 447 SER SER B . n 
B 2 448 TYR 448 448 448 TYR TYR B . n 
B 2 449 GLY 449 449 449 GLY GLY B . n 
B 2 450 TYR 450 450 450 TYR TYR B . n 
B 2 451 ILE 451 451 451 ILE ILE B . n 
B 2 452 ASN 452 452 452 ASN ASN B . n 
B 2 453 GLY 453 453 453 GLY GLY B . n 
B 2 454 ARG 454 454 454 ARG ARG B . n 
B 2 455 LEU 455 455 455 LEU LEU B . n 
B 2 456 PRO 456 456 456 PRO PRO B . n 
B 2 457 LEU 457 457 457 LEU LEU B . n 
B 2 458 PRO 458 458 458 PRO PRO B . n 
B 2 459 ASN 459 459 459 ASN ASN B . n 
B 2 460 ILE 460 460 460 ILE ILE B . n 
B 2 461 VAL 461 461 461 VAL VAL B . n 
B 2 462 ASP 462 462 462 ASP ASP B . n 
B 2 463 THR 463 463 463 THR THR B . n 
B 2 464 TRP 464 464 464 TRP TRP B . n 
B 2 465 THR 465 465 465 THR THR B . n 
B 2 466 ASP 466 466 466 ASP ASP B . n 
B 2 467 ILE 467 467 467 ILE ILE B . n 
B 2 468 GLY 468 468 468 GLY GLY B . n 
B 2 469 ALA 469 469 469 ALA ALA B . n 
B 2 470 ARG 470 470 470 ARG ARG B . n 
B 2 471 TRP 471 471 471 TRP TRP B . n 
B 2 472 SER 472 472 472 SER SER B . n 
B 2 473 LEU 473 473 473 LEU LEU B . n 
B 2 474 ASP 474 474 474 ASP ASP B . n 
B 2 475 VAL 475 475 475 VAL VAL B . n 
B 2 476 MET 476 476 476 MET MET B . n 
B 2 477 ASP 477 477 477 ASP ASP B . n 
B 2 478 THR 478 478 478 THR THR B . n 
B 2 479 VAL 479 479 479 VAL VAL B . n 
B 2 480 ASN 480 480 480 ASN ASN B . n 
B 2 481 PRO 481 481 481 PRO PRO B . n 
B 2 482 PHE 482 482 482 PHE PHE B . n 
B 2 483 ASN 483 483 483 ASN ASN B . n 
B 2 484 HIS 484 484 484 HIS HIS B . n 
B 2 485 HIS 485 485 485 HIS HIS B . n 
B 2 486 ARG 486 486 486 ARG ARG B . n 
B 2 487 ASN 487 487 487 ASN ASN B . n 
B 2 488 THR 488 488 488 THR THR B . n 
B 2 489 GLY 489 489 489 GLY GLY B . n 
B 2 490 LEU 490 490 490 LEU LEU B . n 
B 2 491 LYS 491 491 491 LYS LYS B . n 
B 2 492 TYR 492 492 492 TYR TYR B . n 
B 2 493 ARG 493 493 493 ARG ARG B . n 
B 2 494 SER 494 494 494 SER SER B . n 
B 2 495 GLN 495 495 495 GLN GLN B . n 
B 2 496 LEU 496 496 496 LEU LEU B . n 
B 2 497 LEU 497 497 497 LEU LEU B . n 
B 2 498 GLY 498 498 498 GLY GLY B . n 
B 2 499 ASN 499 499 499 ASN ASN B . n 
B 2 500 GLY 500 500 500 GLY GLY B . n 
B 2 501 ARG 501 501 501 ARG ARG B . n 
B 2 502 TYR 502 502 502 TYR TYR B . n 
B 2 503 CYS 503 503 503 CYS CYS B . n 
B 2 504 ASP 504 504 504 ASP ASP B . n 
B 2 505 PHE 505 505 505 PHE PHE B . n 
B 2 506 HIS 506 506 506 HIS HIS B . n 
B 2 507 ILE 507 507 507 ILE ILE B . n 
B 2 508 GLN 508 508 508 GLN GLN B . n 
B 2 509 VAL 509 509 509 VAL VAL B . n 
B 2 510 PRO 510 510 510 PRO PRO B . n 
B 2 511 GLN 511 511 511 GLN GLN B . n 
B 2 512 LYS 512 512 512 LYS LYS B . n 
B 2 513 PHE 513 513 513 PHE PHE B . n 
B 2 514 PHE 514 514 514 PHE PHE B . n 
B 2 515 ALA 515 515 515 ALA ALA B . n 
B 2 516 ILE 516 516 516 ILE ILE B . n 
B 2 517 LYS 517 517 517 LYS LYS B . n 
B 2 518 ASN 518 518 518 ASN ASN B . n 
B 2 519 LEU 519 519 519 LEU LEU B . n 
B 2 520 LEU 520 520 520 LEU LEU B . n 
B 2 521 LEU 521 521 521 LEU LEU B . n 
B 2 522 LEU 522 522 522 LEU LEU B . n 
B 2 523 PRO 523 523 523 PRO PRO B . n 
B 2 524 GLY 524 524 524 GLY GLY B . n 
B 2 525 THR 525 525 525 THR THR B . n 
B 2 526 TYR 526 526 526 TYR TYR B . n 
B 2 527 ASN 527 527 527 ASN ASN B . n 
B 2 528 TYR 528 528 528 TYR TYR B . n 
B 2 529 GLU 529 529 529 GLU GLU B . n 
B 2 530 TRP 530 530 530 TRP TRP B . n 
B 2 531 TYR 531 531 531 TYR TYR B . n 
B 2 532 PHE 532 532 532 PHE PHE B . n 
B 2 533 ARG 533 533 533 ARG ARG B . n 
B 2 534 LYS 534 534 534 LYS LYS B . n 
B 2 535 ASP 535 535 535 ASP ASP B . n 
B 2 536 PRO 536 536 536 PRO PRO B . n 
B 2 537 ASN 537 537 537 ASN ASN B . n 
B 2 538 MET 538 538 538 MET MET B . n 
B 2 539 VAL 539 539 539 VAL VAL B . n 
B 2 540 LEU 540 540 540 LEU LEU B . n 
B 2 541 GLN 541 541 541 GLN GLN B . n 
B 2 542 SER 542 542 542 SER SER B . n 
B 2 543 THR 543 543 543 THR THR B . n 
B 2 544 LEU 544 544 544 LEU LEU B . n 
B 2 545 GLY 545 545 545 GLY GLY B . n 
B 2 546 ASN 546 546 546 ASN ASN B . n 
B 2 547 ASP 547 547 547 ASP ASP B . n 
B 2 548 LEU 548 548 548 LEU LEU B . n 
B 2 549 ARG 549 549 549 ARG ARG B . n 
B 2 550 ALA 550 550 550 ALA ALA B . n 
B 2 551 ASP 551 551 551 ASP ASP B . n 
B 2 552 GLY 552 552 552 GLY GLY B . n 
B 2 553 ALA 553 553 553 ALA ALA B . n 
B 2 554 SER 554 554 554 SER SER B . n 
B 2 555 ILE 555 555 555 ILE ILE B . n 
B 2 556 THR 556 556 556 THR THR B . n 
B 2 557 TYR 557 557 557 TYR TYR B . n 
B 2 558 THR 558 558 558 THR THR B . n 
B 2 559 GLN 559 559 559 GLN GLN B . n 
B 2 560 ILE 560 560 560 ILE ILE B . n 
B 2 561 ASN 561 561 561 ASN ASN B . n 
B 2 562 LEU 562 562 562 LEU LEU B . n 
B 2 563 TYR 563 563 563 TYR TYR B . n 
B 2 564 VAL 564 564 564 VAL VAL B . n 
B 2 565 SER 565 565 565 SER SER B . n 
B 2 566 PHE 566 566 566 PHE PHE B . n 
B 2 567 PHE 567 567 567 PHE PHE B . n 
B 2 568 PRO 568 568 568 PRO PRO B . n 
B 2 569 MET 569 569 569 MET MET B . n 
B 2 570 ASN 570 570 570 ASN ASN B . n 
B 2 571 TYR 571 571 571 TYR TYR B . n 
B 2 572 ASP 572 572 572 ASP ASP B . n 
B 2 573 THR 573 573 573 THR THR B . n 
B 2 574 GLN 574 574 574 GLN GLN B . n 
B 2 575 SER 575 575 575 SER SER B . n 
B 2 576 GLU 576 576 576 GLU GLU B . n 
B 2 577 LEU 577 577 577 LEU LEU B . n 
B 2 578 GLU 578 578 578 GLU GLU B . n 
B 2 579 LEU 579 579 579 LEU LEU B . n 
B 2 580 MET 580 580 580 MET MET B . n 
B 2 581 LEU 581 581 581 LEU LEU B . n 
B 2 582 ARG 582 582 582 ARG ARG B . n 
B 2 583 ASN 583 583 583 ASN ASN B . n 
B 2 584 ALA 584 584 584 ALA ALA B . n 
B 2 585 THR 585 585 585 THR THR B . n 
B 2 586 ASN 586 586 586 ASN ASN B . n 
B 2 587 ASP 587 587 587 ASP ASP B . n 
B 2 588 GLN 588 588 588 GLN GLN B . n 
B 2 589 ASN 589 589 589 ASN ASN B . n 
B 2 590 PHE 590 590 590 PHE PHE B . n 
B 2 591 SER 591 591 591 SER SER B . n 
B 2 592 ASP 592 592 592 ASP ASP B . n 
B 2 593 TYR 593 593 593 TYR TYR B . n 
B 2 594 LEU 594 594 594 LEU LEU B . n 
B 2 595 GLY 595 595 595 GLY GLY B . n 
B 2 596 ALA 596 596 596 ALA ALA B . n 
B 2 597 VAL 597 597 597 VAL VAL B . n 
B 2 598 ASN 598 598 598 ASN ASN B . n 
B 2 599 ASN 599 599 599 ASN ASN B . n 
B 2 600 LEU 600 600 600 LEU LEU B . n 
B 2 601 TYR 601 601 601 TYR TYR B . n 
B 2 602 GLN 602 602 602 GLN GLN B . n 
B 2 603 ILE 603 603 603 ILE ILE B . n 
B 2 604 PRO 604 604 604 PRO PRO B . n 
B 2 605 ALA 605 605 605 ALA ALA B . n 
B 2 606 GLY 606 606 606 GLY GLY B . n 
B 2 607 SER 607 607 607 SER SER B . n 
B 2 608 SER 608 608 608 SER SER B . n 
B 2 609 THR 609 609 609 THR THR B . n 
B 2 610 VAL 610 610 610 VAL VAL B . n 
B 2 611 VAL 611 611 611 VAL VAL B . n 
B 2 612 VAL 612 612 612 VAL VAL B . n 
B 2 613 ASN 613 613 613 ASN ASN B . n 
B 2 614 ILE 614 614 614 ILE ILE B . n 
B 2 615 PRO 615 615 615 PRO PRO B . n 
B 2 616 ASP 616 616 616 ASP ASP B . n 
B 2 617 ARG 617 617 617 ARG ARG B . n 
B 2 618 SER 618 618 618 SER SER B . n 
B 2 619 TRP 619 619 619 TRP TRP B . n 
B 2 620 GLY 620 620 620 GLY GLY B . n 
B 2 621 ALA 621 621 621 ALA ALA B . n 
B 2 622 PHE 622 622 622 PHE PHE B . n 
B 2 623 ARG 623 623 623 ARG ARG B . n 
B 2 624 GLY 624 624 624 GLY GLY B . n 
B 2 625 TRP 625 625 625 TRP TRP B . n 
B 2 626 SER 626 626 626 SER SER B . n 
B 2 627 PHE 627 627 627 PHE PHE B . n 
B 2 628 THR 628 628 628 THR THR B . n 
B 2 629 ARG 629 629 629 ARG ARG B . n 
B 2 630 LEU 630 630 630 LEU LEU B . n 
B 2 631 LYS 631 631 631 LYS LYS B . n 
B 2 632 VAL 632 632 632 VAL VAL B . n 
B 2 633 SER 633 633 633 SER SER B . n 
B 2 634 GLU 634 634 634 GLU GLU B . n 
B 2 635 THR 635 635 635 THR THR B . n 
B 2 636 PRO 636 636 636 PRO PRO B . n 
B 2 637 ARG 637 637 637 ARG ARG B . n 
B 2 638 ILE 638 638 638 ILE ILE B . n 
B 2 639 GLY 639 639 639 GLY GLY B . n 
B 2 640 ALA 640 640 640 ALA ALA B . n 
B 2 641 THR 641 641 641 THR THR B . n 
B 2 642 GLN 642 642 642 GLN GLN B . n 
B 2 643 ASP 643 643 643 ASP ASP B . n 
B 2 644 PRO 644 644 644 PRO PRO B . n 
B 2 645 ASN 645 645 645 ASN ASN B . n 
B 2 646 PHE 646 646 646 PHE PHE B . n 
B 2 647 GLN 647 647 647 GLN GLN B . n 
B 2 648 TYR 648 648 648 TYR TYR B . n 
B 2 649 SER 649 649 649 SER SER B . n 
B 2 650 GLY 650 650 650 GLY GLY B . n 
B 2 651 SER 651 651 651 SER SER B . n 
B 2 652 ILE 652 652 652 ILE ILE B . n 
B 2 653 PRO 653 653 653 PRO PRO B . n 
B 2 654 TYR 654 654 654 TYR TYR B . n 
B 2 655 LEU 655 655 655 LEU LEU B . n 
B 2 656 ASP 656 656 656 ASP ASP B . n 
B 2 657 GLY 657 657 657 GLY GLY B . n 
B 2 658 THR 658 658 658 THR THR B . n 
B 2 659 PHE 659 659 659 PHE PHE B . n 
B 2 660 TYR 660 660 660 TYR TYR B . n 
B 2 661 LEU 661 661 661 LEU LEU B . n 
B 2 662 SER 662 662 662 SER SER B . n 
B 2 663 HIS 663 663 663 HIS HIS B . n 
B 2 664 THR 664 664 664 THR THR B . n 
B 2 665 PHE 665 665 665 PHE PHE B . n 
B 2 666 GLN 666 666 666 GLN GLN B . n 
B 2 667 ARG 667 667 667 ARG ARG B . n 
B 2 668 CYS 668 668 668 CYS CYS B . n 
B 2 669 SER 669 669 669 SER SER B . n 
B 2 670 ILE 670 670 670 ILE ILE B . n 
B 2 671 GLN 671 671 671 GLN GLN B . n 
B 2 672 TRP 672 672 672 TRP TRP B . n 
B 2 673 ASP 673 673 673 ASP ASP B . n 
B 2 674 SER 674 674 674 SER SER B . n 
B 2 675 SER 675 675 675 SER SER B . n 
B 2 676 VAL 676 676 676 VAL VAL B . n 
B 2 677 PRO 677 677 677 PRO PRO B . n 
B 2 678 TRP 678 678 678 TRP TRP B . n 
B 2 679 PRO 679 679 679 PRO PRO B . n 
B 2 680 GLY 680 680 680 GLY GLY B . n 
B 2 681 ASN 681 681 681 ASN ASN B . n 
B 2 682 ASP 682 682 682 ASP ASP B . n 
B 2 683 ARG 683 683 683 ARG ARG B . n 
B 2 684 MET 684 684 684 MET MET B . n 
B 2 685 LEU 685 685 685 LEU LEU B . n 
B 2 686 THR 686 686 686 THR THR B . n 
B 2 687 PRO 687 687 687 PRO PRO B . n 
B 2 688 ASN 688 688 688 ASN ASN B . n 
B 2 689 TRP 689 689 689 TRP TRP B . n 
B 2 690 PHE 690 690 690 PHE PHE B . n 
B 2 691 GLU 691 691 691 GLU GLU B . n 
B 2 692 ILE 692 692 692 ILE ILE B . n 
B 2 693 LYS 693 693 693 LYS LYS B . n 
B 2 694 ARG 694 694 694 ARG ARG B . n 
B 2 695 PRO 695 695 695 PRO PRO B . n 
B 2 696 ILE 696 696 696 ILE ILE B . n 
B 2 697 ASN 697 697 697 ASN ASN B . n 
B 2 698 GLN 698 698 698 GLN GLN B . n 
B 2 699 ASP 699 699 699 ASP ASP B . n 
B 2 700 ALA 700 700 700 ALA ALA B . n 
B 2 701 GLU 701 701 701 GLU GLU B . n 
B 2 702 GLY 702 702 702 GLY GLY B . n 
B 2 703 ASN 703 703 703 ASN ASN B . n 
B 2 704 ASP 704 704 704 ASP ASP B . n 
B 2 705 THR 705 705 705 THR THR B . n 
B 2 706 MET 706 706 706 MET MET B . n 
B 2 707 GLN 707 707 707 GLN GLN B . n 
B 2 708 SER 708 708 708 SER SER B . n 
B 2 709 ASN 709 709 709 ASN ASN B . n 
B 2 710 LEU 710 710 710 LEU LEU B . n 
B 2 711 THR 711 711 711 THR THR B . n 
B 2 712 LYS 712 712 712 LYS LYS B . n 
B 2 713 ASP 713 713 713 ASP ASP B . n 
B 2 714 PHE 714 714 714 PHE PHE B . n 
B 2 715 PHE 715 715 715 PHE PHE B . n 
B 2 716 MET 716 716 716 MET MET B . n 
B 2 717 VAL 717 717 717 VAL VAL B . n 
B 2 718 GLN 718 718 718 GLN GLN B . n 
B 2 719 MET 719 719 719 MET MET B . n 
B 2 720 ALA 720 720 720 ALA ALA B . n 
B 2 721 ALA 721 721 721 ALA ALA B . n 
B 2 722 SER 722 722 722 SER SER B . n 
B 2 723 TYR 723 723 723 TYR TYR B . n 
B 2 724 ASN 724 724 724 ASN ASN B . n 
B 2 725 GLN 725 725 725 GLN GLN B . n 
B 2 726 GLY 726 726 726 GLY GLY B . n 
B 2 727 TYR 727 727 727 TYR TYR B . n 
B 2 728 GLN 728 728 728 GLN GLN B . n 
B 2 729 GLY 729 729 729 GLY GLY B . n 
B 2 730 PHE 730 730 730 PHE PHE B . n 
B 2 731 ASN 731 731 731 ASN ASN B . n 
B 2 732 TRP 732 732 732 TRP TRP B . n 
B 2 733 PRO 733 733 733 PRO PRO B . n 
B 2 734 ASN 734 734 734 ASN ASN B . n 
B 2 735 CYS 735 735 735 CYS CYS B . n 
B 2 736 THR 736 736 736 THR THR B . n 
B 2 737 LYS 737 737 737 LYS LYS B . n 
B 2 738 HIS 738 738 738 HIS HIS B . n 
B 2 739 TYR 739 739 739 TYR TYR B . n 
B 2 740 GLY 740 740 740 GLY GLY B . n 
B 2 741 PHE 741 741 741 PHE PHE B . n 
B 2 742 ILE 742 742 742 ILE ILE B . n 
B 2 743 ASN 743 743 743 ASN ASN B . n 
B 2 744 ASN 744 744 744 ASN ASN B . n 
B 2 745 PHE 745 745 745 PHE PHE B . n 
B 2 746 GLU 746 746 746 GLU GLU B . n 
B 2 747 PRO 747 747 747 PRO PRO B . n 
B 2 748 MET 748 748 748 MET MET B . n 
B 2 749 SER 749 749 749 SER SER B . n 
B 2 750 ARG 750 750 750 ARG ARG B . n 
B 2 751 GLN 751 751 751 GLN GLN B . n 
B 2 752 VAL 752 752 752 VAL VAL B . n 
B 2 753 PRO 753 753 753 PRO PRO B . n 
B 2 754 GLU 754 754 754 GLU GLU B . n 
B 2 755 TYR 755 755 755 TYR TYR B . n 
B 2 756 GLY 756 756 756 GLY GLY B . n 
B 2 757 ALA 757 757 757 ALA ALA B . n 
B 2 758 ASN 758 758 758 ASN ASN B . n 
B 2 759 TYR 759 759 759 TYR TYR B . n 
B 2 760 PRO 760 760 760 PRO PRO B . n 
B 2 761 ASN 761 761 761 ASN ASN B . n 
B 2 762 LEU 762 762 762 LEU LEU B . n 
B 2 763 MET 763 763 763 MET MET B . n 
B 2 764 ALA 764 764 764 ALA ALA B . n 
B 2 765 ALA 765 765 765 ALA ALA B . n 
B 2 766 TYR 766 766 766 TYR TYR B . n 
B 2 767 LEU 767 767 767 LEU LEU B . n 
B 2 768 ALA 768 768 768 ALA ALA B . n 
B 2 769 ASN 769 769 769 ASN ASN B . n 
B 2 770 PRO 770 770 770 PRO PRO B . n 
B 2 771 GLN 771 771 771 GLN GLN B . n 
B 2 772 THR 772 772 772 THR THR B . n 
B 2 773 MET 773 773 773 MET MET B . n 
B 2 774 PRO 774 774 774 PRO PRO B . n 
B 2 775 ILE 775 775 775 ILE ILE B . n 
B 2 776 TRP 776 776 776 TRP TRP B . n 
B 2 777 ASN 777 777 777 ASN ASN B . n 
B 2 778 ASN 778 778 778 ASN ASN B . n 
B 2 779 CYS 779 779 779 CYS CYS B . n 
B 2 780 GLY 780 780 780 GLY GLY B . n 
B 2 781 PHE 781 781 781 PHE PHE B . n 
B 2 782 GLN 782 782 782 GLN GLN B . n 
B 2 783 GLN 783 783 783 GLN GLN B . n 
B 2 784 LYS 784 784 784 LYS LYS B . n 
B 2 785 THR 785 785 785 THR THR B . n 
B 2 786 ALA 786 786 786 ALA ALA B . n 
B 2 787 THR 787 787 787 THR THR B . n 
B 2 788 ASN 788 788 788 ASN ASN B . n 
B 2 789 VAL 789 789 789 VAL VAL B . n 
B 2 790 LEU 790 790 790 LEU LEU B . n 
B 2 791 LEU 791 791 791 LEU LEU B . n 
B 2 792 GLU 792 792 792 GLU GLU B . n 
B 2 793 ARG 793 793 793 ARG ARG B . n 
B 2 794 CYS 794 794 794 CYS CYS B . n 
B 2 795 GLY 795 795 795 GLY GLY B . n 
B 2 796 HIS 796 796 796 HIS HIS B . n 
B 2 797 PRO 797 797 797 PRO PRO B . n 
B 2 798 TYR 798 798 798 TYR TYR B . n 
B 2 799 VAL 799 799 799 VAL VAL B . n 
B 2 800 ALA 800 800 800 ALA ALA B . n 
B 2 801 ASN 801 801 801 ASN ASN B . n 
B 2 802 TRP 802 802 802 TRP TRP B . n 
B 2 803 PRO 803 803 803 PRO PRO B . n 
B 2 804 TYR 804 804 804 TYR TYR B . n 
B 2 805 PRO 805 805 805 PRO PRO B . n 
B 2 806 LEU 806 806 806 LEU LEU B . n 
B 2 807 SER 807 807 807 SER SER B . n 
B 2 808 GLY 808 808 808 GLY GLY B . n 
B 2 809 ARG 809 809 809 ARG ARG B . n 
B 2 810 ASN 810 810 810 ASN ASN B . n 
B 2 811 ALA 811 811 811 ALA ALA B . n 
B 2 812 VAL 812 812 812 VAL VAL B . n 
B 2 813 PRO 813 813 813 PRO PRO B . n 
B 2 814 ASN 814 814 814 ASN ASN B . n 
B 2 815 GLN 815 815 815 GLN GLN B . n 
B 2 816 VAL 816 816 816 VAL VAL B . n 
B 2 817 THR 817 817 817 THR THR B . n 
B 2 818 GLU 818 818 818 GLU GLU B . n 
B 2 819 ARG 819 819 819 ARG ARG B . n 
B 2 820 LYS 820 820 820 LYS LYS B . n 
B 2 821 PHE 821 821 821 PHE PHE B . n 
B 2 822 LEU 822 822 822 LEU LEU B . n 
B 2 823 VAL 823 823 823 VAL VAL B . n 
B 2 824 ASP 824 824 824 ASP ASP B . n 
B 2 825 ARG 825 825 825 ARG ARG B . n 
B 2 826 TYR 826 826 826 TYR TYR B . n 
B 2 827 LEU 827 827 827 LEU LEU B . n 
B 2 828 TRP 828 828 828 TRP TRP B . n 
B 2 829 GLN 829 829 829 GLN GLN B . n 
B 2 830 ILE 830 830 830 ILE ILE B . n 
B 2 831 PRO 831 831 831 PRO PRO B . n 
B 2 832 PHE 832 832 832 PHE PHE B . n 
B 2 833 SER 833 833 833 SER SER B . n 
B 2 834 SER 834 834 834 SER SER B . n 
B 2 835 ASN 835 835 835 ASN ASN B . n 
B 2 836 PHE 836 836 836 PHE PHE B . n 
B 2 837 LEU 837 837 837 LEU LEU B . n 
B 2 838 ASN 838 838 838 ASN ASN B . n 
B 2 839 MET 839 839 839 MET MET B . n 
B 2 840 GLY 840 840 840 GLY GLY B . n 
B 2 841 THR 841 841 841 THR THR B . n 
B 2 842 LEU 842 842 842 LEU LEU B . n 
B 2 843 THR 843 843 843 THR THR B . n 
B 2 844 ASP 844 844 844 ASP ASP B . n 
B 2 845 LEU 845 845 845 LEU LEU B . n 
B 2 846 GLY 846 846 846 GLY GLY B . n 
B 2 847 GLN 847 847 847 GLN GLN B . n 
B 2 848 ASN 848 848 848 ASN ASN B . n 
B 2 849 VAL 849 849 849 VAL VAL B . n 
B 2 850 MET 850 850 850 MET MET B . n 
B 2 851 TYR 851 851 851 TYR TYR B . n 
B 2 852 ALA 852 852 852 ALA ALA B . n 
B 2 853 ASN 853 853 853 ASN ASN B . n 
B 2 854 SER 854 854 854 SER SER B . n 
B 2 855 SER 855 855 855 SER SER B . n 
B 2 856 HIS 856 856 856 HIS HIS B . n 
B 2 857 SER 857 857 857 SER SER B . n 
B 2 858 LEU 858 858 858 LEU LEU B . n 
B 2 859 ASN 859 859 859 ASN ASN B . n 
B 2 860 MET 860 860 860 MET MET B . n 
B 2 861 GLN 861 861 861 GLN GLN B . n 
B 2 862 PHE 862 862 862 PHE PHE B . n 
B 2 863 THR 863 863 863 THR THR B . n 
B 2 864 VAL 864 864 864 VAL VAL B . n 
B 2 865 ASP 865 865 865 ASP ASP B . n 
B 2 866 PRO 866 866 866 PRO PRO B . n 
B 2 867 MET 867 867 867 MET MET B . n 
B 2 868 THR 868 868 868 THR THR B . n 
B 2 869 GLU 869 869 869 GLU GLU B . n 
B 2 870 PRO 870 870 870 PRO PRO B . n 
B 2 871 THR 871 871 871 THR THR B . n 
B 2 872 TYR 872 872 872 TYR TYR B . n 
B 2 873 LEU 873 873 873 LEU LEU B . n 
B 2 874 MET 874 874 874 MET MET B . n 
B 2 875 LEU 875 875 875 LEU LEU B . n 
B 2 876 LEU 876 876 876 LEU LEU B . n 
B 2 877 PHE 877 877 877 PHE PHE B . n 
B 2 878 GLY 878 878 878 GLY GLY B . n 
B 2 879 VAL 879 879 879 VAL VAL B . n 
B 2 880 PHE 880 880 880 PHE PHE B . n 
B 2 881 ASP 881 881 881 ASP ASP B . n 
B 2 882 GLN 882 882 882 GLN GLN B . n 
B 2 883 VAL 883 883 883 VAL VAL B . n 
B 2 884 ILE 884 885 885 ILE ILE B . n 
B 2 885 ASN 885 886 886 ASN ASN B . n 
B 2 886 GLN 886 887 887 GLN GLN B . n 
B 2 887 PRO 887 888 888 PRO PRO B . n 
B 2 888 THR 888 889 889 THR THR B . n 
B 2 889 ARG 889 890 890 ARG ARG B . n 
B 2 890 SER 890 891 891 SER SER B . n 
B 2 891 GLY 891 892 892 GLY GLY B . n 
B 2 892 ILE 892 893 893 ILE ILE B . n 
B 2 893 SER 893 894 894 SER SER B . n 
B 2 894 VAL 894 895 895 VAL VAL B . n 
B 2 895 ALA 895 896 896 ALA ALA B . n 
B 2 896 TYR 896 897 897 TYR TYR B . n 
B 2 897 LEU 897 898 898 LEU LEU B . n 
B 2 898 ARG 898 899 899 ARG ARG B . n 
B 2 899 LEU 899 900 900 LEU LEU B . n 
B 2 900 PRO 900 901 901 PRO PRO B . n 
B 2 901 PHE 901 902 902 PHE PHE B . n 
B 2 902 ALA 902 903 903 ALA ALA B . n 
B 2 903 SER 903 904 904 SER SER B . n 
B 2 904 GLY 904 905 905 GLY GLY B . n 
C 3 1   MET 1   1   1   MET MET C . n 
C 3 2   GLU 2   2   2   GLU GLU C . n 
C 3 3   PRO 3   3   3   PRO PRO C . n 
C 3 4   GLN 4   4   4   GLN GLN C . n 
C 3 5   ARG 5   5   5   ARG ARG C . n 
C 3 6   GLU 6   6   6   GLU GLU C . n 
C 3 7   PHE 7   7   7   PHE PHE C . n 
C 3 8   PHE 8   8   8   PHE PHE C . n 
C 3 9   HIS 9   9   9   HIS HIS C . n 
C 3 10  ILE 10  10  10  ILE ILE C . n 
C 3 11  ALA 11  11  11  ALA ALA C . n 
C 3 12  GLY 12  12  12  GLY GLY C . n 
C 3 13  ARG 13  13  13  ARG ARG C . n 
C 3 14  SER 14  14  14  SER SER C . n 
C 3 15  ALA 15  15  15  ALA ALA C . n 
C 3 16  LYS 16  16  16  LYS LYS C . n 
C 3 17  GLU 17  17  17  GLU GLU C . n 
C 3 18  TYR 18  18  18  TYR TYR C . n 
C 3 19  LEU 19  19  19  LEU LEU C . n 
C 3 20  SER 20  20  20  SER SER C . n 
C 3 21  GLU 21  21  21  GLU GLU C . n 
C 3 22  ASN 22  22  22  ASN ASN C . n 
C 3 23  LEU 23  23  23  LEU LEU C . n 
C 3 24  VAL 24  24  24  VAL VAL C . n 
C 3 25  GLN 25  25  25  GLN GLN C . n 
C 3 26  PHE 26  26  26  PHE PHE C . n 
C 3 27  ILE 27  27  27  ILE ILE C . n 
C 3 28  GLN 28  28  28  GLN GLN C . n 
C 3 29  ALA 29  29  29  ALA ALA C . n 
C 3 30  THR 30  30  30  THR THR C . n 
C 3 31  GLN 31  31  31  GLN GLN C . n 
C 3 32  ASN 32  32  32  ASN ASN C . n 
C 3 33  TYR 33  33  33  TYR TYR C . n 
C 3 34  PHE 34  34  34  PHE PHE C . n 
C 3 35  ASN 35  35  35  ASN ASN C . n 
C 3 36  ILE 36  36  36  ILE ILE C . n 
C 3 37  GLY 37  37  37  GLY GLY C . n 
C 3 38  GLU 38  38  38  GLU GLU C . n 
C 3 39  LYS 39  39  39  LYS LYS C . n 
C 3 40  PHE 40  40  40  PHE PHE C . n 
C 3 41  ARG 41  41  41  ARG ARG C . n 
C 3 42  ASP 42  42  42  ASP ASP C . n 
C 3 43  PRO 43  43  43  PRO PRO C . n 
C 3 44  TYR 44  44  44  TYR TYR C . n 
C 3 45  VAL 45  45  45  VAL VAL C . n 
C 3 46  ALA 46  46  46  ALA ALA C . n 
C 3 47  PRO 47  47  47  PRO PRO C . n 
C 3 48  SER 48  48  48  SER SER C . n 
C 3 49  ALA 49  49  49  ALA ALA C . n 
C 3 50  GLY 50  50  50  GLY GLY C . n 
C 3 51  VAL 51  51  51  VAL VAL C . n 
C 3 52  THR 52  52  52  THR THR C . n 
C 3 53  THR 53  53  53  THR THR C . n 
C 3 54  ASP 54  54  54  ASP ASP C . n 
C 3 55  ARG 55  55  55  ARG ARG C . n 
C 3 56  SER 56  56  56  SER SER C . n 
C 3 57  GLN 57  57  57  GLN GLN C . n 
C 3 58  LYS 58  58  58  LYS LYS C . n 
C 3 59  LEU 59  59  59  LEU LEU C . n 
C 3 60  GLN 60  60  60  GLN GLN C . n 
C 3 61  LEU 61  61  61  LEU LEU C . n 
C 3 62  ARG 62  62  62  ARG ARG C . n 
C 3 63  VAL 63  63  63  VAL VAL C . n 
C 3 64  VAL 64  64  64  VAL VAL C . n 
C 3 65  PRO 65  65  65  PRO PRO C . n 
C 3 66  ILE 66  66  66  ILE ILE C . n 
C 3 67  GLN 67  67  67  GLN GLN C . n 
C 3 68  THR 68  68  68  THR THR C . n 
C 3 69  GLU 69  69  69  GLU GLU C . n 
C 3 70  ASP 70  70  70  ASP ASP C . n 
C 3 71  ASN 71  71  71  ASN ASN C . n 
C 3 72  VAL 72  72  72  VAL VAL C . n 
C 3 73  ASN 73  73  73  ASN ASN C . n 
C 3 74  TYR 74  74  74  TYR TYR C . n 
C 3 75  TYR 75  75  75  TYR TYR C . n 
C 3 76  LYS 76  76  76  LYS LYS C . n 
C 3 77  ALA 77  77  77  ALA ALA C . n 
C 3 78  ARG 78  78  78  ARG ARG C . n 
C 3 79  PHE 79  79  79  PHE PHE C . n 
C 3 80  THR 80  80  80  THR THR C . n 
C 3 81  LEU 81  81  81  LEU LEU C . n 
C 3 82  ASN 82  82  82  ASN ASN C . n 
C 3 83  VAL 83  83  83  VAL VAL C . n 
C 3 84  GLY 84  84  84  GLY GLY C . n 
C 3 85  ASP 85  85  85  ASP ASP C . n 
C 3 86  ASN 86  86  86  ASN ASN C . n 
C 3 87  ARG 87  87  87  ARG ARG C . n 
C 3 88  LEU 88  88  88  LEU LEU C . n 
C 3 89  VAL 89  89  89  VAL VAL C . n 
C 3 90  ASP 90  90  90  ASP ASP C . n 
C 3 91  LEU 91  91  91  LEU LEU C . n 
C 3 92  GLY 92  92  92  GLY GLY C . n 
C 3 93  SER 93  93  93  SER SER C . n 
C 3 94  SER 94  94  94  SER SER C . n 
C 3 95  TYR 95  95  95  TYR TYR C . n 
C 3 96  PHE 96  96  96  PHE PHE C . n 
C 3 97  ASP 97  97  97  ASP ASP C . n 
C 3 98  ILE 98  98  98  ILE ILE C . n 
C 3 99  LYS 99  99  99  LYS LYS C . n 
C 3 100 GLY 100 100 100 GLY GLY C . n 
C 3 101 THR 101 101 101 THR THR C . n 
C 3 102 LEU 102 102 102 LEU LEU C . n 
C 3 103 ASP 103 103 103 ASP ASP C . n 
C 3 104 ARG 104 104 104 ARG ARG C . n 
C 3 105 GLY 105 105 105 GLY GLY C . n 
C 3 106 PRO 106 106 106 PRO PRO C . n 
C 3 107 SER 107 107 107 SER SER C . n 
C 3 108 PHE 108 108 108 PHE PHE C . n 
C 3 109 LYS 109 109 109 LYS LYS C . n 
C 3 110 PRO 110 110 110 PRO PRO C . n 
C 3 111 TYR 111 111 111 TYR TYR C . n 
C 3 112 GLY 112 112 112 GLY GLY C . n 
C 3 113 GLY 113 113 113 GLY GLY C . n 
C 3 114 THR 114 114 114 THR THR C . n 
C 3 115 ALA 115 115 115 ALA ALA C . n 
C 3 116 TYR 116 116 116 TYR TYR C . n 
C 3 117 ASN 117 117 117 ASN ASN C . n 
C 3 118 PRO 118 118 118 PRO PRO C . n 
C 3 119 LEU 119 119 119 LEU LEU C . n 
C 3 120 ALA 120 120 120 ALA ALA C . n 
C 3 121 PRO 121 121 121 PRO PRO C . n 
C 3 122 LYS 122 122 122 LYS LYS C . n 
C 3 123 SER 123 123 123 SER SER C . n 
C 3 124 ALA 124 124 124 ALA ALA C . n 
C 3 125 PRO 125 125 125 PRO PRO C . n 
C 3 126 ILE 126 126 126 ILE ILE C . n 
C 3 127 ASN 127 127 127 ASN ASN C . n 
C 3 128 SER 128 128 128 SER SER C . n 
C 3 129 ALA 129 129 129 ALA ALA C . n 
C 3 130 PHE 130 130 130 PHE PHE C . n 
C 3 131 THR 131 131 131 THR THR C . n 
C 3 132 VAL 132 132 132 VAL VAL C . n 
C 3 133 GLY 133 133 133 GLY GLY C . n 
C 3 134 ASN 134 134 134 ASN ASN C . n 
C 3 135 ASP 135 135 135 ASP ASP C . n 
C 3 136 THR 136 136 136 THR THR C . n 
C 3 137 HIS 137 137 137 HIS HIS C . n 
C 3 138 PHE 138 138 138 PHE PHE C . n 
C 3 139 VAL 139 139 139 VAL VAL C . n 
C 3 140 ALA 140 140 140 ALA ALA C . n 
C 3 141 GLN 141 141 141 GLN GLN C . n 
C 3 142 LEU 142 142 142 LEU LEU C . n 
C 3 143 PRO 143 143 143 PRO PRO C . n 
C 3 144 GLN 144 144 144 GLN GLN C . n 
C 3 145 THR 145 145 145 THR THR C . n 
C 3 146 TYR 146 146 146 TYR TYR C . n 
C 3 147 ALA 147 147 147 ALA ALA C . n 
C 3 148 ALA 148 148 148 ALA ALA C . n 
C 3 149 GLY 149 149 149 GLY GLY C . n 
C 3 150 GLY 150 150 150 GLY GLY C . n 
C 3 151 THR 151 151 151 THR THR C . n 
C 3 152 GLY 152 152 152 GLY GLY C . n 
C 3 153 VAL 153 153 153 VAL VAL C . n 
C 3 154 THR 154 154 154 THR THR C . n 
C 3 155 GLU 155 155 155 GLU GLU C . n 
C 3 156 ALA 156 156 156 ALA ALA C . n 
C 3 157 ILE 157 157 157 ILE ILE C . n 
C 3 158 GLN 158 158 158 GLN GLN C . n 
C 3 159 GLN 159 159 159 GLN GLN C . n 
C 3 160 GLN 160 160 160 GLN GLN C . n 
C 3 161 VAL 161 161 161 VAL VAL C . n 
C 3 162 SER 162 162 162 SER SER C . n 
C 3 163 GLY 163 163 163 GLY GLY C . n 
C 3 164 VAL 164 164 164 VAL VAL C . n 
C 3 165 ASP 165 165 165 ASP ASP C . n 
C 3 166 PRO 166 166 166 PRO PRO C . n 
C 3 167 ASN 167 167 167 ASN ASN C . n 
C 3 168 PRO 168 168 168 PRO PRO C . n 
C 3 169 GLN 169 169 169 GLN GLN C . n 
C 3 170 VAL 170 170 170 VAL VAL C . n 
C 3 171 GLY 171 171 171 GLY GLY C . n 
C 3 172 GLN 172 172 172 GLN GLN C . n 
C 3 173 PRO 173 173 173 PRO PRO C . n 
C 3 174 ASN 174 174 174 ASN ASN C . n 
C 3 175 TYR 175 175 175 TYR TYR C . n 
C 3 176 ALA 176 176 176 ALA ALA C . n 
C 3 177 GLY 177 177 177 GLY GLY C . n 
C 3 178 PRO 178 178 178 PRO PRO C . n 
C 3 179 VAL 179 179 179 VAL VAL C . n 
C 3 180 VAL 180 180 180 VAL VAL C . n 
C 3 181 VAL 181 181 181 VAL VAL C . n 
C 3 182 ASN 182 182 182 ASN ASN C . n 
C 3 183 THR 183 183 183 THR THR C . n 
C 3 184 THR 184 184 184 THR THR C . n 
C 3 185 ASN 185 185 185 ASN ASN C . n 
C 3 186 ASN 186 186 186 ASN ASN C . n 
C 3 187 ALA 187 187 187 ALA ALA C . n 
C 3 188 GLY 188 188 188 GLY GLY C . n 
C 3 189 LEU 189 189 189 LEU LEU C . n 
C 3 190 GLY 190 190 190 GLY GLY C . n 
C 3 191 ARG 191 191 191 ARG ARG C . n 
C 3 192 ILE 192 192 192 ILE ILE C . n 
C 3 193 VAL 193 193 193 VAL VAL C . n 
C 3 194 SER 194 194 194 SER SER C . n 
C 3 195 ALA 195 195 195 ALA ALA C . n 
C 3 196 ASP 196 196 196 ASP ASP C . n 
C 3 197 SER 197 197 197 SER SER C . n 
C 3 198 GLU 198 198 198 GLU GLU C . n 
C 3 199 GLY 199 199 199 GLY GLY C . n 
C 3 200 GLN 200 200 200 GLN GLN C . n 
C 3 201 GLN 201 201 201 GLN GLN C . n 
C 3 202 PHE 202 202 202 PHE PHE C . n 
C 3 203 PRO 203 203 203 PRO PRO C . n 
C 3 204 CYS 204 204 204 CYS CYS C . n 
C 3 205 TYR 205 205 205 TYR TYR C . n 
C 3 206 GLY 206 206 206 GLY GLY C . n 
C 3 207 ALA 207 207 207 ALA ALA C . n 
C 3 208 TYR 208 208 208 TYR TYR C . n 
C 3 209 ALA 209 209 209 ALA ALA C . n 
C 3 210 PRO 210 210 210 PRO PRO C . n 
C 3 211 PRO 211 211 211 PRO PRO C . n 
C 3 212 GLN 212 212 212 GLN GLN C . n 
C 3 213 SER 213 213 213 SER SER C . n 
C 3 214 ALA 214 214 214 ALA ALA C . n 
C 3 215 GLY 215 215 215 GLY GLY C . n 
C 3 216 GLY 216 216 216 GLY GLY C . n 
C 3 217 ASP 217 217 217 ASP ASP C . n 
C 3 218 VAL 218 218 218 VAL VAL C . n 
C 3 219 SER 219 219 219 SER SER C . n 
C 3 220 THR 220 220 220 THR THR C . n 
C 3 221 ALA 221 221 221 ALA ALA C . n 
C 3 222 ALA 222 222 222 ALA ALA C . n 
C 3 223 VAL 223 223 223 VAL VAL C . n 
C 3 224 THR 224 224 224 THR THR C . n 
C 3 225 LYS 225 225 225 LYS LYS C . n 
C 3 226 THR 226 226 226 THR THR C . n 
C 3 227 TYR 227 227 227 TYR TYR C . n 
C 3 228 ILE 228 228 228 ILE ILE C . n 
C 3 229 ASN 229 229 229 ASN ASN C . n 
C 3 230 THR 230 230 230 THR THR C . n 
C 3 231 THR 231 231 231 THR THR C . n 
C 3 232 ASN 232 232 232 ASN ASN C . n 
C 3 233 ASN 233 233 233 ASN ASN C . n 
C 3 234 ASN 234 234 234 ASN ASN C . n 
C 3 235 GLY 235 235 235 GLY GLY C . n 
C 3 236 ARG 236 236 236 ARG ARG C . n 
C 3 237 VAL 237 237 237 VAL VAL C . n 
C 3 238 SER 238 238 238 SER SER C . n 
C 3 239 GLY 239 239 239 GLY GLY C . n 
C 3 240 THR 240 240 240 THR THR C . n 
C 3 241 MET 241 241 241 MET MET C . n 
C 3 242 ALA 242 242 242 ALA ALA C . n 
C 3 243 THR 243 243 243 THR THR C . n 
C 3 244 ASP 244 244 244 ASP ASP C . n 
C 3 245 THR 245 245 245 THR THR C . n 
C 3 246 ILE 246 246 246 ILE ILE C . n 
C 3 247 THR 247 247 247 THR THR C . n 
C 3 248 TRP 248 248 248 TRP TRP C . n 
C 3 249 GLU 249 249 249 GLU GLU C . n 
C 3 250 ASN 250 250 250 ASN ASN C . n 
C 3 251 PRO 251 251 251 PRO PRO C . n 
C 3 252 ASP 252 252 252 ASP ASP C . n 
C 3 253 ALA 253 253 253 ALA ALA C . n 
C 3 254 HIS 254 254 254 HIS HIS C . n 
C 3 255 PHE 255 255 255 PHE PHE C . n 
C 3 256 ALA 256 256 256 ALA ALA C . n 
C 3 257 ASP 257 257 257 ASP ASP C . n 
C 3 258 PHE 258 258 258 PHE PHE C . n 
C 3 259 VAL 259 259 259 VAL VAL C . n 
C 3 260 ASP 260 260 260 ASP ASP C . n 
C 3 261 ASP 261 261 261 ASP ASP C . n 
C 3 262 ARG 262 262 262 ARG ARG C . n 
C 3 263 ARG 263 263 263 ARG ARG C . n 
C 3 264 ALA 264 264 264 ALA ALA C . n 
C 3 265 THR 265 265 265 THR THR C . n 
C 3 266 ALA 266 266 266 ALA ALA C . n 
C 3 267 ALA 267 267 267 ALA ALA C . n 
C 3 268 GLY 268 268 268 GLY GLY C . n 
C 3 269 ASN 269 269 269 ASN ASN C . n 
C 3 270 ARG 270 270 270 ARG ARG C . n 
C 3 271 PRO 271 271 271 PRO PRO C . n 
C 3 272 ASN 272 272 272 ASN ASN C . n 
C 3 273 TYR 273 273 273 TYR TYR C . n 
C 3 274 ILE 274 274 274 ILE ILE C . n 
C 3 275 GLY 275 275 275 GLY GLY C . n 
C 3 276 PHE 276 276 276 PHE PHE C . n 
C 3 277 ARG 277 277 277 ARG ARG C . n 
C 3 278 ASP 278 278 278 ASP ASP C . n 
C 3 279 ASN 279 279 279 ASN ASN C . n 
C 3 280 PHE 280 280 280 PHE PHE C . n 
C 3 281 ILE 281 281 281 ILE ILE C . n 
C 3 282 GLY 282 282 282 GLY GLY C . n 
C 3 283 MET 283 283 283 MET MET C . n 
C 3 284 MET 284 284 284 MET MET C . n 
C 3 285 TYR 285 285 285 TYR TYR C . n 
C 3 286 TYR 286 286 286 TYR TYR C . n 
C 3 287 ASN 287 287 287 ASN ASN C . n 
C 3 288 SER 288 288 288 SER SER C . n 
C 3 289 GLY 289 289 289 GLY GLY C . n 
C 3 290 SER 290 290 290 SER SER C . n 
C 3 291 ASN 291 291 291 ASN ASN C . n 
C 3 292 THR 292 292 292 THR THR C . n 
C 3 293 GLY 293 293 293 GLY GLY C . n 
C 3 294 SER 294 294 294 SER SER C . n 
C 3 295 PHE 295 295 295 PHE PHE C . n 
C 3 296 SER 296 296 296 SER SER C . n 
C 3 297 SER 297 297 297 SER SER C . n 
C 3 298 GLN 298 298 298 GLN GLN C . n 
C 3 299 THR 299 299 299 THR THR C . n 
C 3 300 GLN 300 300 300 GLN GLN C . n 
C 3 301 GLN 301 301 301 GLN GLN C . n 
C 3 302 LEU 302 302 302 LEU LEU C . n 
C 3 303 ASN 303 303 303 ASN ASN C . n 
C 3 304 ILE 304 304 304 ILE ILE C . n 
C 3 305 VAL 305 305 305 VAL VAL C . n 
C 3 306 LEU 306 306 306 LEU LEU C . n 
C 3 307 ASP 307 307 307 ASP ASP C . n 
C 3 308 LEU 308 308 308 LEU LEU C . n 
C 3 309 ASN 309 309 309 ASN ASN C . n 
C 3 310 ASP 310 310 310 ASP ASP C . n 
C 3 311 ARG 311 311 311 ARG ARG C . n 
C 3 312 ASN 312 312 312 ASN ASN C . n 
C 3 313 SER 313 313 313 SER SER C . n 
C 3 314 GLU 314 314 314 GLU GLU C . n 
C 3 315 LEU 315 315 315 LEU LEU C . n 
C 3 316 SER 316 316 316 SER SER C . n 
C 3 317 TYR 317 317 317 TYR TYR C . n 
C 3 318 GLN 318 318 318 GLN GLN C . n 
C 3 319 TYR 319 319 319 TYR TYR C . n 
C 3 320 LEU 320 320 320 LEU LEU C . n 
C 3 321 LEU 321 321 321 LEU LEU C . n 
C 3 322 ALA 322 322 322 ALA ALA C . n 
C 3 323 ASP 323 323 323 ASP ASP C . n 
C 3 324 LEU 324 324 324 LEU LEU C . n 
C 3 325 THR 325 325 325 THR THR C . n 
C 3 326 SER 326 326 326 SER SER C . n 
C 3 327 ARG 327 327 327 ARG ARG C . n 
C 3 328 TRP 328 328 328 TRP TRP C . n 
C 3 329 HIS 329 329 329 HIS HIS C . n 
C 3 330 TYR 330 330 330 TYR TYR C . n 
C 3 331 PHE 331 331 331 PHE PHE C . n 
C 3 332 ALA 332 332 332 ALA ALA C . n 
C 3 333 LEU 333 333 333 LEU LEU C . n 
C 3 334 TRP 334 334 334 TRP TRP C . n 
C 3 335 ASN 335 335 335 ASN ASN C . n 
C 3 336 GLN 336 336 336 GLN GLN C . n 
C 3 337 ALA 337 337 337 ALA ALA C . n 
C 3 338 VAL 338 338 338 VAL VAL C . n 
C 3 339 ASP 339 339 339 ASP ASP C . n 
C 3 340 ASP 340 340 340 ASP ASP C . n 
C 3 341 TYR 341 341 341 TYR TYR C . n 
C 3 342 ASP 342 342 342 ASP ASP C . n 
C 3 343 HIS 343 343 343 HIS HIS C . n 
C 3 344 HIS 344 344 344 HIS HIS C . n 
C 3 345 VAL 345 345 345 VAL VAL C . n 
C 3 346 ARG 346 346 346 ARG ARG C . n 
C 3 347 ILE 347 347 347 ILE ILE C . n 
C 3 348 LEU 348 348 348 LEU LEU C . n 
C 3 349 GLU 349 349 349 GLU GLU C . n 
C 3 350 ASN 350 350 350 ASN ASN C . n 
C 3 351 ASP 351 351 351 ASP ASP C . n 
C 3 352 GLY 352 352 352 GLY GLY C . n 
C 3 353 TYR 353 353 353 TYR TYR C . n 
C 3 354 GLU 354 354 354 GLU GLU C . n 
C 3 355 GLU 355 355 355 GLU GLU C . n 
C 3 356 GLY 356 356 356 GLY GLY C . n 
C 3 357 PRO 357 357 357 PRO PRO C . n 
C 3 358 PRO 358 358 358 PRO PRO C . n 
C 3 359 ASN 359 359 359 ASN ASN C . n 
C 3 360 LEU 360 360 360 LEU LEU C . n 
C 3 361 ALA 361 361 361 ALA ALA C . n 
C 3 362 PHE 362 362 362 PHE PHE C . n 
C 3 363 PRO 363 363 363 PRO PRO C . n 
C 3 364 PRO 364 364 364 PRO PRO C . n 
C 3 365 HIS 365 365 365 HIS HIS C . n 
C 3 366 VAL 366 366 366 VAL VAL C . n 
C 3 367 ILE 367 367 367 ILE ILE C . n 
C 3 368 SER 368 368 368 SER SER C . n 
C 3 369 ASN 369 369 369 ASN ASN C . n 
C 3 370 PRO 370 370 370 PRO PRO C . n 
C 3 371 PHE 371 371 371 PHE PHE C . n 
C 3 372 ALA 372 372 372 ALA ALA C . n 
C 3 373 PRO 373 373 373 PRO PRO C . n 
C 3 374 ALA 374 374 374 ALA ALA C . n 
C 3 375 ALA 375 375 375 ALA ALA C . n 
C 3 376 VAL 376 376 376 VAL VAL C . n 
C 3 377 GLY 377 377 377 GLY GLY C . n 
C 3 378 THR 378 378 378 THR THR C . n 
C 3 379 GLY 379 379 379 GLY GLY C . n 
C 3 380 MET 380 380 380 MET MET C . n 
C 3 381 THR 381 381 381 THR THR C . n 
C 3 382 VAL 382 382 382 VAL VAL C . n 
C 3 383 ASN 383 383 383 ASN ASN C . n 
C 3 384 GLU 384 384 384 GLU GLU C . n 
C 3 385 GLN 385 385 385 GLN GLN C . n 
C 3 386 GLN 386 386 386 GLN GLN C . n 
C 3 387 GLN 387 387 387 GLN GLN C . n 
C 3 388 THR 388 388 388 THR THR C . n 
C 3 389 ALA 389 389 389 ALA ALA C . n 
C 3 390 ALA 390 390 390 ALA ALA C . n 
C 3 391 VAL 391 391 391 VAL VAL C . n 
C 3 392 THR 392 392 392 THR THR C . n 
C 3 393 ALA 393 393 393 ALA ALA C . n 
C 3 394 ASN 394 394 394 ASN ASN C . n 
C 3 395 THR 395 395 395 THR THR C . n 
C 3 396 VAL 396 396 396 VAL VAL C . n 
C 3 397 ALA 397 397 397 ALA ALA C . n 
C 3 398 LEU 398 398 398 LEU LEU C . n 
C 3 399 ILE 399 399 399 ILE ILE C . n 
C 3 400 GLY 400 400 400 GLY GLY C . n 
C 3 401 TYR 401 401 401 TYR TYR C . n 
C 3 402 GLY 402 402 402 GLY GLY C . n 
C 3 403 ASN 403 403 403 ASN ASN C . n 
C 3 404 ILE 404 404 404 ILE ILE C . n 
C 3 405 PRO 405 405 405 PRO PRO C . n 
C 3 406 ALA 406 406 406 ALA ALA C . n 
C 3 407 VAL 407 407 407 VAL VAL C . n 
C 3 408 GLU 408 408 408 GLU GLU C . n 
C 3 409 MET 409 409 409 MET MET C . n 
C 3 410 ASN 410 410 410 ASN ASN C . n 
C 3 411 LEU 411 411 411 LEU LEU C . n 
C 3 412 PRO 412 412 412 PRO PRO C . n 
C 3 413 ALA 413 413 413 ALA ALA C . n 
C 3 414 ASN 414 414 414 ASN ASN C . n 
C 3 415 LEU 415 415 415 LEU LEU C . n 
C 3 416 LYS 416 416 416 LYS LYS C . n 
C 3 417 ARG 417 417 417 ARG ARG C . n 
C 3 418 THR 418 418 418 THR THR C . n 
C 3 419 PHE 419 419 419 PHE PHE C . n 
C 3 420 LEU 420 420 420 LEU LEU C . n 
C 3 421 TYR 421 421 421 TYR TYR C . n 
C 3 422 SER 422 422 422 SER SER C . n 
C 3 423 ASN 423 423 423 ASN ASN C . n 
C 3 424 VAL 424 424 424 VAL VAL C . n 
C 3 425 ALA 425 425 425 ALA ALA C . n 
C 3 426 MET 426 426 426 MET MET C . n 
C 3 427 TYR 427 427 427 TYR TYR C . n 
C 3 428 LEU 428 428 428 LEU LEU C . n 
C 3 429 PRO 429 429 429 PRO PRO C . n 
C 3 430 ASP 430 430 430 ASP ASP C . n 
C 3 431 THR 431 431 431 THR THR C . n 
C 3 432 TYR 432 432 432 TYR TYR C . n 
C 3 433 LYS 433 433 433 LYS LYS C . n 
C 3 434 PHE 434 434 434 PHE PHE C . n 
C 3 435 THR 435 435 435 THR THR C . n 
C 3 436 PRO 436 436 436 PRO PRO C . n 
C 3 437 ALA 437 437 437 ALA ALA C . n 
C 3 438 ASN 438 438 438 ASN ASN C . n 
C 3 439 VAL 439 439 439 VAL VAL C . n 
C 3 440 ASP 440 440 440 ASP ASP C . n 
C 3 441 LEU 441 441 441 LEU LEU C . n 
C 3 442 PRO 442 442 442 PRO PRO C . n 
C 3 443 GLU 443 443 443 GLU GLU C . n 
C 3 444 ASN 444 444 444 ASN ASN C . n 
C 3 445 HIS 445 445 445 HIS HIS C . n 
C 3 446 LEU 446 446 446 LEU LEU C . n 
C 3 447 SER 447 447 447 SER SER C . n 
C 3 448 TYR 448 448 448 TYR TYR C . n 
C 3 449 GLY 449 449 449 GLY GLY C . n 
C 3 450 TYR 450 450 450 TYR TYR C . n 
C 3 451 ILE 451 451 451 ILE ILE C . n 
C 3 452 ASN 452 452 452 ASN ASN C . n 
C 3 453 GLY 453 453 453 GLY GLY C . n 
C 3 454 ARG 454 454 454 ARG ARG C . n 
C 3 455 LEU 455 455 455 LEU LEU C . n 
C 3 456 PRO 456 456 456 PRO PRO C . n 
C 3 457 LEU 457 457 457 LEU LEU C . n 
C 3 458 PRO 458 458 458 PRO PRO C . n 
C 3 459 ASN 459 459 459 ASN ASN C . n 
C 3 460 ILE 460 460 460 ILE ILE C . n 
C 3 461 VAL 461 461 461 VAL VAL C . n 
C 3 462 ASP 462 462 462 ASP ASP C . n 
C 3 463 THR 463 463 463 THR THR C . n 
C 3 464 TRP 464 464 464 TRP TRP C . n 
C 3 465 THR 465 465 465 THR THR C . n 
C 3 466 ASP 466 466 466 ASP ASP C . n 
C 3 467 ILE 467 467 467 ILE ILE C . n 
C 3 468 GLY 468 468 468 GLY GLY C . n 
C 3 469 ALA 469 469 469 ALA ALA C . n 
C 3 470 ARG 470 470 470 ARG ARG C . n 
C 3 471 TRP 471 471 471 TRP TRP C . n 
C 3 472 SER 472 472 472 SER SER C . n 
C 3 473 LEU 473 473 473 LEU LEU C . n 
C 3 474 ASP 474 474 474 ASP ASP C . n 
C 3 475 VAL 475 475 475 VAL VAL C . n 
C 3 476 MET 476 476 476 MET MET C . n 
C 3 477 ASP 477 477 477 ASP ASP C . n 
C 3 478 THR 478 478 478 THR THR C . n 
C 3 479 VAL 479 479 479 VAL VAL C . n 
C 3 480 ASN 480 480 480 ASN ASN C . n 
C 3 481 PRO 481 481 481 PRO PRO C . n 
C 3 482 PHE 482 482 482 PHE PHE C . n 
C 3 483 ASN 483 483 483 ASN ASN C . n 
C 3 484 HIS 484 484 484 HIS HIS C . n 
C 3 485 HIS 485 485 485 HIS HIS C . n 
C 3 486 ARG 486 486 486 ARG ARG C . n 
C 3 487 ASN 487 487 487 ASN ASN C . n 
C 3 488 THR 488 488 488 THR THR C . n 
C 3 489 GLY 489 489 489 GLY GLY C . n 
C 3 490 LEU 490 490 490 LEU LEU C . n 
C 3 491 LYS 491 491 491 LYS LYS C . n 
C 3 492 TYR 492 492 492 TYR TYR C . n 
C 3 493 ARG 493 493 493 ARG ARG C . n 
C 3 494 SER 494 494 494 SER SER C . n 
C 3 495 GLN 495 495 495 GLN GLN C . n 
C 3 496 LEU 496 496 496 LEU LEU C . n 
C 3 497 LEU 497 497 497 LEU LEU C . n 
C 3 498 GLY 498 498 498 GLY GLY C . n 
C 3 499 ASN 499 499 499 ASN ASN C . n 
C 3 500 GLY 500 500 500 GLY GLY C . n 
C 3 501 ARG 501 501 501 ARG ARG C . n 
C 3 502 TYR 502 502 502 TYR TYR C . n 
C 3 503 CYS 503 503 503 CYS CYS C . n 
C 3 504 ASP 504 504 504 ASP ASP C . n 
C 3 505 PHE 505 505 505 PHE PHE C . n 
C 3 506 HIS 506 506 506 HIS HIS C . n 
C 3 507 ILE 507 507 507 ILE ILE C . n 
C 3 508 GLN 508 508 508 GLN GLN C . n 
C 3 509 VAL 509 509 509 VAL VAL C . n 
C 3 510 PRO 510 510 510 PRO PRO C . n 
C 3 511 GLN 511 511 511 GLN GLN C . n 
C 3 512 LYS 512 512 512 LYS LYS C . n 
C 3 513 PHE 513 513 513 PHE PHE C . n 
C 3 514 PHE 514 514 514 PHE PHE C . n 
C 3 515 ALA 515 515 515 ALA ALA C . n 
C 3 516 ILE 516 516 516 ILE ILE C . n 
C 3 517 LYS 517 517 517 LYS LYS C . n 
C 3 518 ASN 518 518 518 ASN ASN C . n 
C 3 519 LEU 519 519 519 LEU LEU C . n 
C 3 520 LEU 520 520 520 LEU LEU C . n 
C 3 521 LEU 521 521 521 LEU LEU C . n 
C 3 522 LEU 522 522 522 LEU LEU C . n 
C 3 523 PRO 523 523 523 PRO PRO C . n 
C 3 524 GLY 524 524 524 GLY GLY C . n 
C 3 525 THR 525 525 525 THR THR C . n 
C 3 526 TYR 526 526 526 TYR TYR C . n 
C 3 527 ASN 527 527 527 ASN ASN C . n 
C 3 528 TYR 528 528 528 TYR TYR C . n 
C 3 529 GLU 529 529 529 GLU GLU C . n 
C 3 530 TRP 530 530 530 TRP TRP C . n 
C 3 531 TYR 531 531 531 TYR TYR C . n 
C 3 532 PHE 532 532 532 PHE PHE C . n 
C 3 533 ARG 533 533 533 ARG ARG C . n 
C 3 534 LYS 534 534 534 LYS LYS C . n 
C 3 535 ASP 535 535 535 ASP ASP C . n 
C 3 536 PRO 536 536 536 PRO PRO C . n 
C 3 537 ASN 537 537 537 ASN ASN C . n 
C 3 538 MET 538 538 538 MET MET C . n 
C 3 539 VAL 539 539 539 VAL VAL C . n 
C 3 540 LEU 540 540 540 LEU LEU C . n 
C 3 541 GLN 541 541 541 GLN GLN C . n 
C 3 542 SER 542 542 542 SER SER C . n 
C 3 543 THR 543 543 543 THR THR C . n 
C 3 544 LEU 544 544 544 LEU LEU C . n 
C 3 545 GLY 545 545 545 GLY GLY C . n 
C 3 546 ASN 546 546 546 ASN ASN C . n 
C 3 547 ASP 547 547 547 ASP ASP C . n 
C 3 548 LEU 548 548 548 LEU LEU C . n 
C 3 549 ARG 549 549 549 ARG ARG C . n 
C 3 550 ALA 550 550 550 ALA ALA C . n 
C 3 551 ASP 551 551 551 ASP ASP C . n 
C 3 552 GLY 552 552 552 GLY GLY C . n 
C 3 553 ALA 553 553 553 ALA ALA C . n 
C 3 554 SER 554 554 554 SER SER C . n 
C 3 555 ILE 555 555 555 ILE ILE C . n 
C 3 556 THR 556 556 556 THR THR C . n 
C 3 557 TYR 557 557 557 TYR TYR C . n 
C 3 558 THR 558 558 558 THR THR C . n 
C 3 559 GLN 559 559 559 GLN GLN C . n 
C 3 560 ILE 560 560 560 ILE ILE C . n 
C 3 561 ASN 561 561 561 ASN ASN C . n 
C 3 562 LEU 562 562 562 LEU LEU C . n 
C 3 563 TYR 563 563 563 TYR TYR C . n 
C 3 564 VAL 564 564 564 VAL VAL C . n 
C 3 565 SER 565 565 565 SER SER C . n 
C 3 566 PHE 566 566 566 PHE PHE C . n 
C 3 567 PHE 567 567 567 PHE PHE C . n 
C 3 568 PRO 568 568 568 PRO PRO C . n 
C 3 569 MET 569 569 569 MET MET C . n 
C 3 570 ASN 570 570 570 ASN ASN C . n 
C 3 571 TYR 571 571 571 TYR TYR C . n 
C 3 572 ASP 572 572 572 ASP ASP C . n 
C 3 573 THR 573 573 573 THR THR C . n 
C 3 574 GLN 574 574 574 GLN GLN C . n 
C 3 575 SER 575 575 575 SER SER C . n 
C 3 576 GLU 576 576 576 GLU GLU C . n 
C 3 577 LEU 577 577 577 LEU LEU C . n 
C 3 578 GLU 578 578 578 GLU GLU C . n 
C 3 579 LEU 579 579 579 LEU LEU C . n 
C 3 580 MET 580 580 580 MET MET C . n 
C 3 581 LEU 581 581 581 LEU LEU C . n 
C 3 582 ARG 582 582 582 ARG ARG C . n 
C 3 583 ASN 583 583 583 ASN ASN C . n 
C 3 584 ALA 584 584 584 ALA ALA C . n 
C 3 585 THR 585 585 585 THR THR C . n 
C 3 586 ASN 586 586 586 ASN ASN C . n 
C 3 587 ASP 587 587 587 ASP ASP C . n 
C 3 588 GLN 588 588 588 GLN GLN C . n 
C 3 589 ASN 589 589 589 ASN ASN C . n 
C 3 590 PHE 590 590 590 PHE PHE C . n 
C 3 591 SER 591 591 591 SER SER C . n 
C 3 592 ASP 592 592 592 ASP ASP C . n 
C 3 593 TYR 593 593 593 TYR TYR C . n 
C 3 594 LEU 594 594 594 LEU LEU C . n 
C 3 595 GLY 595 595 595 GLY GLY C . n 
C 3 596 ALA 596 596 596 ALA ALA C . n 
C 3 597 VAL 597 597 597 VAL VAL C . n 
C 3 598 ASN 598 598 598 ASN ASN C . n 
C 3 599 ASN 599 599 599 ASN ASN C . n 
C 3 600 LEU 600 600 600 LEU LEU C . n 
C 3 601 TYR 601 601 601 TYR TYR C . n 
C 3 602 GLN 602 602 602 GLN GLN C . n 
C 3 603 ILE 603 603 603 ILE ILE C . n 
C 3 604 PRO 604 604 604 PRO PRO C . n 
C 3 605 ALA 605 605 605 ALA ALA C . n 
C 3 606 GLY 606 606 606 GLY GLY C . n 
C 3 607 SER 607 607 607 SER SER C . n 
C 3 608 SER 608 608 608 SER SER C . n 
C 3 609 THR 609 609 609 THR THR C . n 
C 3 610 VAL 610 610 610 VAL VAL C . n 
C 3 611 VAL 611 611 611 VAL VAL C . n 
C 3 612 VAL 612 612 612 VAL VAL C . n 
C 3 613 ASN 613 613 613 ASN ASN C . n 
C 3 614 ILE 614 614 614 ILE ILE C . n 
C 3 615 PRO 615 615 615 PRO PRO C . n 
C 3 616 ASP 616 616 616 ASP ASP C . n 
C 3 617 ARG 617 617 617 ARG ARG C . n 
C 3 618 SER 618 618 618 SER SER C . n 
C 3 619 TRP 619 619 619 TRP TRP C . n 
C 3 620 GLY 620 620 620 GLY GLY C . n 
C 3 621 ALA 621 621 621 ALA ALA C . n 
C 3 622 PHE 622 622 622 PHE PHE C . n 
C 3 623 ARG 623 623 623 ARG ARG C . n 
C 3 624 GLY 624 624 624 GLY GLY C . n 
C 3 625 TRP 625 625 625 TRP TRP C . n 
C 3 626 SER 626 626 626 SER SER C . n 
C 3 627 PHE 627 627 627 PHE PHE C . n 
C 3 628 THR 628 628 628 THR THR C . n 
C 3 629 ARG 629 629 629 ARG ARG C . n 
C 3 630 LEU 630 630 630 LEU LEU C . n 
C 3 631 LYS 631 631 631 LYS LYS C . n 
C 3 632 VAL 632 632 632 VAL VAL C . n 
C 3 633 SER 633 633 633 SER SER C . n 
C 3 634 GLU 634 634 634 GLU GLU C . n 
C 3 635 THR 635 635 635 THR THR C . n 
C 3 636 PRO 636 636 636 PRO PRO C . n 
C 3 637 ARG 637 637 637 ARG ARG C . n 
C 3 638 ILE 638 638 638 ILE ILE C . n 
C 3 639 GLY 639 639 639 GLY GLY C . n 
C 3 640 ALA 640 640 640 ALA ALA C . n 
C 3 641 THR 641 641 641 THR THR C . n 
C 3 642 GLN 642 642 642 GLN GLN C . n 
C 3 643 ASP 643 643 643 ASP ASP C . n 
C 3 644 PRO 644 644 644 PRO PRO C . n 
C 3 645 ASN 645 645 645 ASN ASN C . n 
C 3 646 PHE 646 646 646 PHE PHE C . n 
C 3 647 GLN 647 647 647 GLN GLN C . n 
C 3 648 TYR 648 648 648 TYR TYR C . n 
C 3 649 SER 649 649 649 SER SER C . n 
C 3 650 GLY 650 650 650 GLY GLY C . n 
C 3 651 SER 651 651 651 SER SER C . n 
C 3 652 ILE 652 652 652 ILE ILE C . n 
C 3 653 PRO 653 653 653 PRO PRO C . n 
C 3 654 TYR 654 654 654 TYR TYR C . n 
C 3 655 LEU 655 655 655 LEU LEU C . n 
C 3 656 ASP 656 656 656 ASP ASP C . n 
C 3 657 GLY 657 657 657 GLY GLY C . n 
C 3 658 THR 658 658 658 THR THR C . n 
C 3 659 PHE 659 659 659 PHE PHE C . n 
C 3 660 TYR 660 660 660 TYR TYR C . n 
C 3 661 LEU 661 661 661 LEU LEU C . n 
C 3 662 SER 662 662 662 SER SER C . n 
C 3 663 HIS 663 663 663 HIS HIS C . n 
C 3 664 THR 664 664 664 THR THR C . n 
C 3 665 PHE 665 665 665 PHE PHE C . n 
C 3 666 GLN 666 666 666 GLN GLN C . n 
C 3 667 ARG 667 667 667 ARG ARG C . n 
C 3 668 CYS 668 668 668 CYS CYS C . n 
C 3 669 SER 669 669 669 SER SER C . n 
C 3 670 ILE 670 670 670 ILE ILE C . n 
C 3 671 GLN 671 671 671 GLN GLN C . n 
C 3 672 TRP 672 672 672 TRP TRP C . n 
C 3 673 ASP 673 673 673 ASP ASP C . n 
C 3 674 SER 674 674 674 SER SER C . n 
C 3 675 SER 675 675 675 SER SER C . n 
C 3 676 VAL 676 676 676 VAL VAL C . n 
C 3 677 PRO 677 677 677 PRO PRO C . n 
C 3 678 TRP 678 678 678 TRP TRP C . n 
C 3 679 PRO 679 679 679 PRO PRO C . n 
C 3 680 GLY 680 680 680 GLY GLY C . n 
C 3 681 ASN 681 681 681 ASN ASN C . n 
C 3 682 ASP 682 682 682 ASP ASP C . n 
C 3 683 ARG 683 683 683 ARG ARG C . n 
C 3 684 MET 684 684 684 MET MET C . n 
C 3 685 LEU 685 685 685 LEU LEU C . n 
C 3 686 THR 686 686 686 THR THR C . n 
C 3 687 PRO 687 687 687 PRO PRO C . n 
C 3 688 ASN 688 688 688 ASN ASN C . n 
C 3 689 TRP 689 689 689 TRP TRP C . n 
C 3 690 PHE 690 690 690 PHE PHE C . n 
C 3 691 GLU 691 691 691 GLU GLU C . n 
C 3 692 ILE 692 692 692 ILE ILE C . n 
C 3 693 LYS 693 693 693 LYS LYS C . n 
C 3 694 ARG 694 694 694 ARG ARG C . n 
C 3 695 PRO 695 695 695 PRO PRO C . n 
C 3 696 ILE 696 696 696 ILE ILE C . n 
C 3 697 ASN 697 697 697 ASN ASN C . n 
C 3 698 GLN 698 698 698 GLN GLN C . n 
C 3 699 ASP 699 699 699 ASP ASP C . n 
C 3 700 ALA 700 700 700 ALA ALA C . n 
C 3 701 GLU 701 701 701 GLU GLU C . n 
C 3 702 GLY 702 702 702 GLY GLY C . n 
C 3 703 ASN 703 703 703 ASN ASN C . n 
C 3 704 ASP 704 704 704 ASP ASP C . n 
C 3 705 THR 705 705 705 THR THR C . n 
C 3 706 MET 706 706 706 MET MET C . n 
C 3 707 GLN 707 707 707 GLN GLN C . n 
C 3 708 SER 708 708 708 SER SER C . n 
C 3 709 ASN 709 709 709 ASN ASN C . n 
C 3 710 LEU 710 710 710 LEU LEU C . n 
C 3 711 THR 711 711 711 THR THR C . n 
C 3 712 LYS 712 712 712 LYS LYS C . n 
C 3 713 ASP 713 713 713 ASP ASP C . n 
C 3 714 PHE 714 714 714 PHE PHE C . n 
C 3 715 PHE 715 715 715 PHE PHE C . n 
C 3 716 MET 716 716 716 MET MET C . n 
C 3 717 VAL 717 717 717 VAL VAL C . n 
C 3 718 GLN 718 718 718 GLN GLN C . n 
C 3 719 MET 719 719 719 MET MET C . n 
C 3 720 ALA 720 720 720 ALA ALA C . n 
C 3 721 ALA 721 721 721 ALA ALA C . n 
C 3 722 SER 722 722 722 SER SER C . n 
C 3 723 TYR 723 723 723 TYR TYR C . n 
C 3 724 ASN 724 724 724 ASN ASN C . n 
C 3 725 GLN 725 725 725 GLN GLN C . n 
C 3 726 GLY 726 726 726 GLY GLY C . n 
C 3 727 TYR 727 727 727 TYR TYR C . n 
C 3 728 GLN 728 728 728 GLN GLN C . n 
C 3 729 GLY 729 729 729 GLY GLY C . n 
C 3 730 PHE 730 730 730 PHE PHE C . n 
C 3 731 ASN 731 731 731 ASN ASN C . n 
C 3 732 TRP 732 732 732 TRP TRP C . n 
C 3 733 PRO 733 733 733 PRO PRO C . n 
C 3 734 ASN 734 734 734 ASN ASN C . n 
C 3 735 CYS 735 735 735 CYS CYS C . n 
C 3 736 THR 736 736 736 THR THR C . n 
C 3 737 LYS 737 737 737 LYS LYS C . n 
C 3 738 HIS 738 738 738 HIS HIS C . n 
C 3 739 TYR 739 739 739 TYR TYR C . n 
C 3 740 GLY 740 740 740 GLY GLY C . n 
C 3 741 PHE 741 741 741 PHE PHE C . n 
C 3 742 ILE 742 742 742 ILE ILE C . n 
C 3 743 ASN 743 743 743 ASN ASN C . n 
C 3 744 ASN 744 744 744 ASN ASN C . n 
C 3 745 PHE 745 745 745 PHE PHE C . n 
C 3 746 GLU 746 746 746 GLU GLU C . n 
C 3 747 PRO 747 747 747 PRO PRO C . n 
C 3 748 MET 748 748 748 MET MET C . n 
C 3 749 SER 749 749 749 SER SER C . n 
C 3 750 ARG 750 750 750 ARG ARG C . n 
C 3 751 GLN 751 751 751 GLN GLN C . n 
C 3 752 VAL 752 752 752 VAL VAL C . n 
C 3 753 PRO 753 753 753 PRO PRO C . n 
C 3 754 GLU 754 754 754 GLU GLU C . n 
C 3 755 TYR 755 755 755 TYR TYR C . n 
C 3 756 GLY 756 756 756 GLY GLY C . n 
C 3 757 ALA 757 757 757 ALA ALA C . n 
C 3 758 ASN 758 758 758 ASN ASN C . n 
C 3 759 TYR 759 759 759 TYR TYR C . n 
C 3 760 PRO 760 760 760 PRO PRO C . n 
C 3 761 ASN 761 761 761 ASN ASN C . n 
C 3 762 LEU 762 762 762 LEU LEU C . n 
C 3 763 MET 763 763 763 MET MET C . n 
C 3 764 ALA 764 764 764 ALA ALA C . n 
C 3 765 ALA 765 765 765 ALA ALA C . n 
C 3 766 TYR 766 766 766 TYR TYR C . n 
C 3 767 LEU 767 767 767 LEU LEU C . n 
C 3 768 ALA 768 768 768 ALA ALA C . n 
C 3 769 ASN 769 769 769 ASN ASN C . n 
C 3 770 PRO 770 770 770 PRO PRO C . n 
C 3 771 GLN 771 771 771 GLN GLN C . n 
C 3 772 THR 772 772 772 THR THR C . n 
C 3 773 MET 773 773 773 MET MET C . n 
C 3 774 PRO 774 774 774 PRO PRO C . n 
C 3 775 ILE 775 775 775 ILE ILE C . n 
C 3 776 TRP 776 776 776 TRP TRP C . n 
C 3 777 ASN 777 777 777 ASN ASN C . n 
C 3 778 ASN 778 778 778 ASN ASN C . n 
C 3 779 CYS 779 779 779 CYS CYS C . n 
C 3 780 GLY 780 780 780 GLY GLY C . n 
C 3 781 PHE 781 781 781 PHE PHE C . n 
C 3 782 GLN 782 782 782 GLN GLN C . n 
C 3 783 GLN 783 783 783 GLN GLN C . n 
C 3 784 LYS 784 784 784 LYS LYS C . n 
C 3 785 THR 785 785 785 THR THR C . n 
C 3 786 ALA 786 786 786 ALA ALA C . n 
C 3 787 THR 787 787 787 THR THR C . n 
C 3 788 ASN 788 788 788 ASN ASN C . n 
C 3 789 VAL 789 789 789 VAL VAL C . n 
C 3 790 LEU 790 790 790 LEU LEU C . n 
C 3 791 LEU 791 791 791 LEU LEU C . n 
C 3 792 GLU 792 792 792 GLU GLU C . n 
C 3 793 ARG 793 793 793 ARG ARG C . n 
C 3 794 CYS 794 794 794 CYS CYS C . n 
C 3 795 GLY 795 795 795 GLY GLY C . n 
C 3 796 HIS 796 796 796 HIS HIS C . n 
C 3 797 PRO 797 797 797 PRO PRO C . n 
C 3 798 TYR 798 798 798 TYR TYR C . n 
C 3 799 VAL 799 799 799 VAL VAL C . n 
C 3 800 ALA 800 800 800 ALA ALA C . n 
C 3 801 ASN 801 801 801 ASN ASN C . n 
C 3 802 TRP 802 802 802 TRP TRP C . n 
C 3 803 PRO 803 803 803 PRO PRO C . n 
C 3 804 TYR 804 804 804 TYR TYR C . n 
C 3 805 PRO 805 805 805 PRO PRO C . n 
C 3 806 LEU 806 806 806 LEU LEU C . n 
C 3 807 SER 807 807 807 SER SER C . n 
C 3 808 GLY 808 808 808 GLY GLY C . n 
C 3 809 ARG 809 809 809 ARG ARG C . n 
C 3 810 ASN 810 810 810 ASN ASN C . n 
C 3 811 ALA 811 811 811 ALA ALA C . n 
C 3 812 VAL 812 812 812 VAL VAL C . n 
C 3 813 PRO 813 813 813 PRO PRO C . n 
C 3 814 ASN 814 814 814 ASN ASN C . n 
C 3 815 GLN 815 815 815 GLN GLN C . n 
C 3 816 VAL 816 816 816 VAL VAL C . n 
C 3 817 THR 817 817 817 THR THR C . n 
C 3 818 GLU 818 818 818 GLU GLU C . n 
C 3 819 ARG 819 819 819 ARG ARG C . n 
C 3 820 LYS 820 820 820 LYS LYS C . n 
C 3 821 PHE 821 821 821 PHE PHE C . n 
C 3 822 LEU 822 822 822 LEU LEU C . n 
C 3 823 VAL 823 823 823 VAL VAL C . n 
C 3 824 ASP 824 824 824 ASP ASP C . n 
C 3 825 ARG 825 825 825 ARG ARG C . n 
C 3 826 TYR 826 826 826 TYR TYR C . n 
C 3 827 LEU 827 827 827 LEU LEU C . n 
C 3 828 TRP 828 828 828 TRP TRP C . n 
C 3 829 GLN 829 829 829 GLN GLN C . n 
C 3 830 ILE 830 830 830 ILE ILE C . n 
C 3 831 PRO 831 831 831 PRO PRO C . n 
C 3 832 PHE 832 832 832 PHE PHE C . n 
C 3 833 SER 833 833 833 SER SER C . n 
C 3 834 SER 834 834 834 SER SER C . n 
C 3 835 ASN 835 835 835 ASN ASN C . n 
C 3 836 PHE 836 836 836 PHE PHE C . n 
C 3 837 LEU 837 837 837 LEU LEU C . n 
C 3 838 ASN 838 838 838 ASN ASN C . n 
C 3 839 MET 839 839 839 MET MET C . n 
C 3 840 GLY 840 840 840 GLY GLY C . n 
C 3 841 THR 841 841 841 THR THR C . n 
C 3 842 LEU 842 842 842 LEU LEU C . n 
C 3 843 THR 843 843 843 THR THR C . n 
C 3 844 ASP 844 844 844 ASP ASP C . n 
C 3 845 LEU 845 845 845 LEU LEU C . n 
C 3 846 GLY 846 846 846 GLY GLY C . n 
C 3 847 GLN 847 847 847 GLN GLN C . n 
C 3 848 ASN 848 848 848 ASN ASN C . n 
C 3 849 VAL 849 849 849 VAL VAL C . n 
C 3 850 MET 850 850 850 MET MET C . n 
C 3 851 TYR 851 851 851 TYR TYR C . n 
C 3 852 ALA 852 852 852 ALA ALA C . n 
C 3 853 ASN 853 853 853 ASN ASN C . n 
C 3 854 SER 854 854 854 SER SER C . n 
C 3 855 SER 855 855 855 SER SER C . n 
C 3 856 HIS 856 856 856 HIS HIS C . n 
C 3 857 SER 857 857 857 SER SER C . n 
C 3 858 LEU 858 858 858 LEU LEU C . n 
C 3 859 ASN 859 859 859 ASN ASN C . n 
C 3 860 MET 860 860 860 MET MET C . n 
C 3 861 GLN 861 861 861 GLN GLN C . n 
C 3 862 PHE 862 862 862 PHE PHE C . n 
C 3 863 THR 863 863 863 THR THR C . n 
C 3 864 VAL 864 864 864 VAL VAL C . n 
C 3 865 ASP 865 865 865 ASP ASP C . n 
C 3 866 PRO 866 866 866 PRO PRO C . n 
C 3 867 MET 867 867 867 MET MET C . n 
C 3 868 THR 868 868 868 THR THR C . n 
C 3 869 GLU 869 869 869 GLU GLU C . n 
C 3 870 PRO 870 870 870 PRO PRO C . n 
C 3 871 THR 871 871 871 THR THR C . n 
C 3 872 TYR 872 872 872 TYR TYR C . n 
C 3 873 LEU 873 873 873 LEU LEU C . n 
C 3 874 MET 874 874 874 MET MET C . n 
C 3 875 LEU 875 875 875 LEU LEU C . n 
C 3 876 LEU 876 876 876 LEU LEU C . n 
C 3 877 PHE 877 877 877 PHE PHE C . n 
C 3 878 GLY 878 878 878 GLY GLY C . n 
C 3 879 VAL 879 879 879 VAL VAL C . n 
C 3 880 PHE 880 880 880 PHE PHE C . n 
C 3 881 ASP 881 881 881 ASP ASP C . n 
C 3 882 GLN 882 882 882 GLN GLN C . n 
C 3 883 VAL 883 883 883 VAL VAL C . n 
C 3 884 VAL 884 884 884 VAL VAL C . n 
C 3 885 ILE 885 885 885 ILE ILE C . n 
C 3 886 ASN 886 886 886 ASN ASN C . n 
C 3 887 GLN 887 887 887 GLN GLN C . n 
C 3 888 PRO 888 888 888 PRO PRO C . n 
C 3 889 THR 889 889 889 THR THR C . n 
C 3 890 ARG 890 890 890 ARG ARG C . n 
C 3 891 SER 891 891 891 SER SER C . n 
C 3 892 GLY 892 892 892 GLY GLY C . n 
C 3 893 ILE 893 893 893 ILE ILE C . n 
C 3 894 SER 894 894 894 SER SER C . n 
C 3 895 VAL 895 895 895 VAL VAL C . n 
C 3 896 ALA 896 896 896 ALA ALA C . n 
C 3 897 TYR 897 897 897 TYR TYR C . n 
C 3 898 LEU 898 898 898 LEU LEU C . n 
C 3 899 ARG 899 899 899 ARG ARG C . n 
C 3 900 LEU 900 900 900 LEU LEU C . n 
C 3 901 PRO 901 901 901 PRO PRO C . n 
C 3 902 PHE 902 902 902 PHE PHE C . n 
C 3 903 ALA 903 903 903 ALA ALA C . n 
C 3 904 SER 904 904 904 SER SER C . n 
C 3 905 GLY 905 905 905 GLY GLY C . n 
C 3 906 SER 906 906 906 SER SER C . n 
C 3 907 ALA 907 907 907 ALA ALA C . n 
# 
loop_
_chem_comp.id 
_chem_comp.type 
_chem_comp.mon_nstd_flag 
_chem_comp.name 
_chem_comp.pdbx_synonyms 
_chem_comp.formula 
_chem_comp.formula_weight 
ALA "L-peptide linking" y ALANINE         ? "C3 H7 N O2"     89.093  
ARG "L-peptide linking" y ARGININE        ? "C6 H15 N4 O2 1" 175.209 
ASN "L-peptide linking" y ASPARAGINE      ? "C4 H8 N2 O3"    132.118 
ASP "L-peptide linking" y "ASPARTIC ACID" ? "C4 H7 N O4"     133.103 
CYS "L-peptide linking" y CYSTEINE        ? "C3 H7 N O2 S"   121.158 
GLN "L-peptide linking" y GLUTAMINE       ? "C5 H10 N2 O3"   146.144 
GLU "L-peptide linking" y "GLUTAMIC ACID" ? "C5 H9 N O4"     147.129 
GLY "peptide linking"   y GLYCINE         ? "C2 H5 N O2"     75.067  
HIS "L-peptide linking" y HISTIDINE       ? "C6 H10 N3 O2 1" 156.162 
ILE "L-peptide linking" y ISOLEUCINE      ? "C6 H13 N O2"    131.173 
LEU "L-peptide linking" y LEUCINE         ? "C6 H13 N O2"    131.173 
LYS "L-peptide linking" y LYSINE          ? "C6 H15 N2 O2 1" 147.195 
MET "L-peptide linking" y METHIONINE      ? "C5 H11 N O2 S"  149.211 
PHE "L-peptide linking" y PHENYLALANINE   ? "C9 H11 N O2"    165.189 
PRO "L-peptide linking" y PROLINE         ? "C5 H9 N O2"     115.130 
SER "L-peptide linking" y SERINE          ? "C3 H7 N O3"     105.093 
THR "L-peptide linking" y THREONINE       ? "C4 H9 N O3"     119.119 
TRP "L-peptide linking" y TRYPTOPHAN      ? "C11 H12 N2 O2"  204.225 
TYR "L-peptide linking" y TYROSINE        ? "C9 H11 N O3"    181.189 
VAL "L-peptide linking" y VALINE          ? "C5 H11 N O2"    117.146 
# 
loop_
_struct_asym.id 
_struct_asym.pdbx_PDB_id 
_struct_asym.pdbx_alt_id 
_struct_asym.pdbx_blank_PDB_chainid_flag 
_struct_asym.pdbx_type 
_struct_asym.pdbx_order 
_struct_asym.pdbx_modified 
_struct_asym.entity_id 
_struct_asym.details 
A A A N ATOMP 1 N 1 ? 
B B B N ATOMP 2 N 2 ? 
C C C N ATOMP 3 N 3 ? 
# 
_struct_conf_type.id          HELX_P 
_struct_conf_type.criteria    ? 
_struct_conf_type.reference   ? 
# 
loop_
_struct_conf.conf_type_id 
_struct_conf.id 
_struct_conf.pdbx_PDB_helix_id 
_struct_conf.beg_label_comp_id 
_struct_conf.beg_label_asym_id 
_struct_conf.beg_label_seq_id 
_struct_conf.pdbx_beg_PDB_ins_code 
_struct_conf.end_label_comp_id 
_struct_conf.end_label_asym_id 
_struct_conf.end_label_seq_id 
_struct_conf.pdbx_end_PDB_ins_code 
_struct_conf.beg_auth_comp_id 
_struct_conf.beg_auth_asym_id 
_struct_conf.beg_auth_seq_id 
_struct_conf.end_auth_comp_id 
_struct_conf.end_auth_asym_id 
_struct_conf.end_auth_seq_id 
_struct_conf.pdbx_PDB_helix_class 
_struct_conf.details 
_struct_conf.pdbx_PDB_helix_length 
HELX_P HELX_P1  AA1 PRO A 3   ? PHE A 8   ? PRO A 3   PHE A 8   1 ? 6  
HELX_P HELX_P2  AA2 SER A 14  ? LEU A 19  ? SER A 14  LEU A 19  1 ? 6  
HELX_P HELX_P3  AA3 SER A 20  ? THR A 30  ? SER A 20  THR A 30  1 ? 11 
HELX_P HELX_P4  AA4 GLY A 92  ? SER A 94  ? GLY A 92  SER A 94  5 ? 3  
HELX_P HELX_P5  AA5 ASP A 278 ? ILE A 281 ? ASP A 278 ILE A 281 5 ? 4  
HELX_P HELX_P6  AA6 ASN A 312 ? THR A 325 ? ASN A 312 THR A 325 1 ? 14 
HELX_P HELX_P7  AA7 ASP A 342 ? ILE A 347 ? ASP A 342 ILE A 347 1 ? 6  
HELX_P HELX_P8  AA8 ASN A 410 ? VAL A 424 ? ASN A 410 VAL A 424 1 ? 15 
HELX_P HELX_P9  AA9 PRO A 429 ? THR A 431 ? PRO A 429 THR A 431 5 ? 3  
HELX_P HELX_P10 AB1 SER A 447 ? ASN A 452 ? SER A 447 ASN A 452 1 ? 6  
HELX_P HELX_P11 AB2 PRO A 458 ? VAL A 461 ? PRO A 458 VAL A 461 5 ? 4  
HELX_P HELX_P12 AB3 ASN A 487 ? LEU A 496 ? ASN A 487 LEU A 496 1 ? 10 
HELX_P HELX_P13 AB4 ASP A 535 ? VAL A 539 ? ASP A 535 VAL A 539 1 ? 5  
HELX_P HELX_P14 AB5 THR A 573 ? ARG A 582 ? THR A 573 ARG A 582 1 ? 10 
HELX_P HELX_P15 AB6 ASN A 583 ? ASP A 587 ? ASN A 583 ASP A 587 5 ? 5  
HELX_P HELX_P16 AB7 THR A 711 ? ASN A 724 ? THR A 711 ASN A 724 1 ? 14 
HELX_P HELX_P17 AB8 ASN A 761 ? ASN A 769 ? ASN A 761 ASN A 769 1 ? 9  
HELX_P HELX_P18 AB9 ASN A 848 ? ASN A 853 ? ASN A 848 ASN A 853 1 ? 6  
HELX_P HELX_P19 AC1 SER B 20  ? THR B 30  ? SER B 20  THR B 30  1 ? 11 
HELX_P HELX_P20 AC2 ILE B 36  ? PHE B 40  ? ILE B 36  PHE B 40  5 ? 5  
HELX_P HELX_P21 AC3 GLY B 92  ? SER B 94  ? GLY B 92  SER B 94  5 ? 3  
HELX_P HELX_P22 AC4 ASP B 278 ? ILE B 281 ? ASP B 278 ILE B 281 5 ? 4  
HELX_P HELX_P23 AC5 LEU B 315 ? THR B 325 ? LEU B 315 THR B 325 1 ? 11 
HELX_P HELX_P24 AC6 ASP B 342 ? ILE B 347 ? ASP B 342 ILE B 347 1 ? 6  
HELX_P HELX_P25 AC7 ASN B 410 ? VAL B 424 ? ASN B 410 VAL B 424 1 ? 15 
HELX_P HELX_P26 AC8 PRO B 429 ? THR B 431 ? PRO B 429 THR B 431 5 ? 3  
HELX_P HELX_P27 AC9 SER B 447 ? ARG B 454 ? SER B 447 ARG B 454 1 ? 8  
HELX_P HELX_P28 AD1 PRO B 458 ? VAL B 461 ? PRO B 458 VAL B 461 5 ? 4  
HELX_P HELX_P29 AD2 ASN B 487 ? LEU B 496 ? ASN B 487 LEU B 496 1 ? 10 
HELX_P HELX_P30 AD3 ASP B 535 ? VAL B 539 ? ASP B 535 VAL B 539 1 ? 5  
HELX_P HELX_P31 AD4 ASN B 570 ? LEU B 581 ? ASN B 570 LEU B 581 1 ? 12 
HELX_P HELX_P32 AD5 THR B 711 ? ASN B 724 ? THR B 711 ASN B 724 1 ? 14 
HELX_P HELX_P33 AD6 LEU B 762 ? ASN B 769 ? LEU B 762 ASN B 769 1 ? 8  
HELX_P HELX_P34 AD7 THR B 843 ? ASN B 848 ? THR B 843 ASN B 848 1 ? 6  
HELX_P HELX_P35 AD8 MET B 850 ? ASN B 853 ? MET B 850 ASN B 853 5 ? 4  
HELX_P HELX_P36 AD9 PRO C 3   ? PHE C 8   ? PRO C 3   PHE C 8   1 ? 6  
HELX_P HELX_P37 AE1 LEU C 23  ? GLN C 31  ? LEU C 23  GLN C 31  1 ? 9  
HELX_P HELX_P38 AE2 GLY C 92  ? SER C 94  ? GLY C 92  SER C 94  5 ? 3  
HELX_P HELX_P39 AE3 GLY C 152 ? GLN C 158 ? GLY C 152 GLN C 158 1 ? 7  
HELX_P HELX_P40 AE4 ASP C 278 ? ILE C 281 ? ASP C 278 ILE C 281 5 ? 4  
HELX_P HELX_P41 AE5 SER C 288 ? THR C 292 ? SER C 288 THR C 292 5 ? 5  
HELX_P HELX_P42 AE6 ASN C 312 ? THR C 325 ? ASN C 312 THR C 325 1 ? 14 
HELX_P HELX_P43 AE7 ASP C 342 ? ILE C 347 ? ASP C 342 ILE C 347 1 ? 6  
HELX_P HELX_P44 AE8 ASN C 410 ? ASN C 423 ? ASN C 410 ASN C 423 1 ? 14 
HELX_P HELX_P45 AE9 SER C 447 ? ARG C 454 ? SER C 447 ARG C 454 1 ? 8  
HELX_P HELX_P46 AF1 PRO C 458 ? VAL C 461 ? PRO C 458 VAL C 461 5 ? 4  
HELX_P HELX_P47 AF2 GLY C 489 ? SER C 494 ? GLY C 489 SER C 494 1 ? 6  
HELX_P HELX_P48 AF3 ASP C 535 ? VAL C 539 ? ASP C 535 VAL C 539 1 ? 5  
HELX_P HELX_P49 AF4 ASP C 547 ? GLY C 552 ? ASP C 547 GLY C 552 1 ? 6  
HELX_P HELX_P50 AF5 ASN C 570 ? ARG C 582 ? ASN C 570 ARG C 582 1 ? 13 
HELX_P HELX_P51 AF6 ASN C 583 ? ASP C 587 ? ASN C 583 ASP C 587 5 ? 5  
HELX_P HELX_P52 AF7 ILE C 652 ? GLY C 657 ? ILE C 652 GLY C 657 1 ? 6  
HELX_P HELX_P53 AF8 THR C 711 ? TYR C 723 ? THR C 711 TYR C 723 1 ? 13 
HELX_P HELX_P54 AF9 ASN C 761 ? ASN C 769 ? ASN C 761 ASN C 769 1 ? 9  
HELX_P HELX_P55 AG1 ASP C 844 ? VAL C 849 ? ASP C 844 VAL C 849 1 ? 6  
HELX_P HELX_P56 AG2 MET C 850 ? SER C 854 ? MET C 850 SER C 854 5 ? 5  
# 
loop_
_struct_mon_prot_cis.pdbx_id 
_struct_mon_prot_cis.label_comp_id 
_struct_mon_prot_cis.label_seq_id 
_struct_mon_prot_cis.label_asym_id 
_struct_mon_prot_cis.label_alt_id 
_struct_mon_prot_cis.pdbx_PDB_ins_code 
_struct_mon_prot_cis.auth_comp_id 
_struct_mon_prot_cis.auth_seq_id 
_struct_mon_prot_cis.auth_asym_id 
_struct_mon_prot_cis.pdbx_label_comp_id_2 
_struct_mon_prot_cis.pdbx_label_seq_id_2 
_struct_mon_prot_cis.pdbx_label_asym_id_2 
_struct_mon_prot_cis.pdbx_PDB_ins_code_2 
_struct_mon_prot_cis.pdbx_auth_comp_id_2 
_struct_mon_prot_cis.pdbx_auth_seq_id_2 
_struct_mon_prot_cis.pdbx_auth_asym_id_2 
_struct_mon_prot_cis.pdbx_PDB_model_num 
_struct_mon_prot_cis.pdbx_omega_angle 
1  GLU 2   A . ? GLU 2   A PRO 3   A ? PRO 3   A 1 7.83   
2  TRP 678 A . ? TRP 678 A PRO 679 A ? PRO 679 A 1 -1.20  
3  TRP 802 A . ? TRP 802 A PRO 803 A ? PRO 803 A 1 2.57   
4  LEU 900 A . ? LEU 900 A PRO 901 A ? PRO 901 A 1 -1.83  
5  GLU 2   B . ? GLU 2   B PRO 3   B ? PRO 3   B 1 7.76   
6  ASP 165 B . ? ASP 165 B PRO 166 B ? PRO 166 B 1 0.86   
7  GLN 172 B . ? GLN 172 B PRO 173 B ? PRO 173 B 1 6.95   
8  TRP 678 B . ? TRP 678 B PRO 679 B ? PRO 679 B 1 2.80   
9  MET 773 B . ? MET 773 B PRO 774 B ? PRO 774 B 1 -13.85 
10 TRP 802 B . ? TRP 802 B PRO 803 B ? PRO 803 B 1 3.65   
11 LEU 899 B . ? LEU 900 B PRO 900 B ? PRO 901 B 1 3.24   
12 ASP 165 C . ? ASP 165 C PRO 166 C ? PRO 166 C 1 -1.91  
13 TRP 678 C . ? TRP 678 C PRO 679 C ? PRO 679 C 1 -0.57  
14 TRP 802 C . ? TRP 802 C PRO 803 C ? PRO 803 C 1 7.18   
15 LEU 900 C . ? LEU 900 C PRO 901 C ? PRO 901 C 1 9.86   
# 
loop_
_struct_sheet.id 
_struct_sheet.type 
_struct_sheet.number_strands 
_struct_sheet.details 
AA1 ? 4 ? 
AA2 ? 4 ? 
AA3 ? 4 ? 
AA4 ? 2 ? 
AA5 ? 2 ? 
AA6 ? 4 ? 
AA7 ? 2 ? 
AA8 ? 2 ? 
AA9 ? 2 ? 
AB1 ? 2 ? 
AB2 ? 3 ? 
AB3 ? 3 ? 
AB4 ? 3 ? 
AB5 ? 2 ? 
AB6 ? 3 ? 
AB7 ? 4 ? 
AB8 ? 4 ? 
AB9 ? 2 ? 
AC1 ? 4 ? 
AC2 ? 4 ? 
AC3 ? 4 ? 
AC4 ? 2 ? 
AC5 ? 3 ? 
AC6 ? 2 ? 
AC7 ? 3 ? 
AC8 ? 2 ? 
AC9 ? 2 ? 
AD1 ? 2 ? 
AD2 ? 2 ? 
AD3 ? 2 ? 
AD4 ? 4 ? 
AD5 ? 4 ? 
AD6 ? 4 ? 
AD7 ? 2 ? 
AD8 ? 3 ? 
AD9 ? 4 ? 
AE1 ? 4 ? 
AE2 ? 4 ? 
AE3 ? 2 ? 
AE4 ? 2 ? 
AE5 ? 2 ? 
AE6 ? 2 ? 
AE7 ? 2 ? 
AE8 ? 2 ? 
AE9 ? 3 ? 
AF1 ? 4 ? 
AF2 ? 4 ? 
AF3 ? 2 ? 
# 
loop_
_struct_sheet_order.sheet_id 
_struct_sheet_order.range_id_1 
_struct_sheet_order.range_id_2 
_struct_sheet_order.offset 
_struct_sheet_order.sense 
AA1 1 2 ? anti-parallel 
AA1 2 3 ? anti-parallel 
AA1 3 4 ? anti-parallel 
AA2 1 2 ? anti-parallel 
AA2 2 3 ? anti-parallel 
AA2 3 4 ? anti-parallel 
AA3 1 2 ? anti-parallel 
AA3 2 3 ? anti-parallel 
AA3 3 4 ? anti-parallel 
AA4 1 2 ? anti-parallel 
AA5 1 2 ? anti-parallel 
AA6 1 2 ? anti-parallel 
AA6 2 3 ? parallel      
AA6 3 4 ? anti-parallel 
AA7 1 2 ? anti-parallel 
AA8 1 2 ? anti-parallel 
AA9 1 2 ? anti-parallel 
AB1 1 2 ? anti-parallel 
AB2 1 2 ? anti-parallel 
AB2 2 3 ? anti-parallel 
AB3 1 2 ? parallel      
AB3 2 3 ? parallel      
AB4 1 2 ? parallel      
AB4 2 3 ? anti-parallel 
AB5 1 2 ? anti-parallel 
AB6 1 2 ? anti-parallel 
AB6 2 3 ? anti-parallel 
AB7 1 2 ? anti-parallel 
AB7 2 3 ? anti-parallel 
AB7 3 4 ? anti-parallel 
AB8 1 2 ? anti-parallel 
AB8 2 3 ? anti-parallel 
AB8 3 4 ? anti-parallel 
AB9 1 2 ? anti-parallel 
AC1 1 2 ? anti-parallel 
AC1 2 3 ? anti-parallel 
AC1 3 4 ? anti-parallel 
AC2 1 2 ? anti-parallel 
AC2 2 3 ? anti-parallel 
AC2 3 4 ? anti-parallel 
AC3 1 2 ? anti-parallel 
AC3 2 3 ? anti-parallel 
AC3 3 4 ? anti-parallel 
AC4 1 2 ? anti-parallel 
AC5 1 2 ? anti-parallel 
AC5 2 3 ? parallel      
AC6 1 2 ? anti-parallel 
AC7 1 2 ? parallel      
AC7 2 3 ? anti-parallel 
AC8 1 2 ? anti-parallel 
AC9 1 2 ? anti-parallel 
AD1 1 2 ? anti-parallel 
AD2 1 2 ? anti-parallel 
AD3 1 2 ? anti-parallel 
AD4 1 2 ? anti-parallel 
AD4 2 3 ? anti-parallel 
AD4 3 4 ? anti-parallel 
AD5 1 2 ? anti-parallel 
AD5 2 3 ? anti-parallel 
AD5 3 4 ? anti-parallel 
AD6 1 2 ? anti-parallel 
AD6 2 3 ? anti-parallel 
AD6 3 4 ? anti-parallel 
AD7 1 2 ? anti-parallel 
AD8 1 2 ? anti-parallel 
AD8 2 3 ? anti-parallel 
AD9 1 2 ? anti-parallel 
AD9 2 3 ? anti-parallel 
AD9 3 4 ? anti-parallel 
AE1 1 2 ? anti-parallel 
AE1 2 3 ? anti-parallel 
AE1 3 4 ? anti-parallel 
AE2 1 2 ? anti-parallel 
AE2 2 3 ? anti-parallel 
AE2 3 4 ? anti-parallel 
AE3 1 2 ? anti-parallel 
AE4 1 2 ? anti-parallel 
AE5 1 2 ? anti-parallel 
AE6 1 2 ? anti-parallel 
AE7 1 2 ? anti-parallel 
AE8 1 2 ? anti-parallel 
AE9 1 2 ? anti-parallel 
AE9 2 3 ? anti-parallel 
AF1 1 2 ? anti-parallel 
AF1 2 3 ? anti-parallel 
AF1 3 4 ? anti-parallel 
AF2 1 2 ? anti-parallel 
AF2 2 3 ? anti-parallel 
AF2 3 4 ? anti-parallel 
AF3 1 2 ? anti-parallel 
# 
loop_
_struct_sheet_range.sheet_id 
_struct_sheet_range.id 
_struct_sheet_range.beg_label_comp_id 
_struct_sheet_range.beg_label_asym_id 
_struct_sheet_range.beg_label_seq_id 
_struct_sheet_range.pdbx_beg_PDB_ins_code 
_struct_sheet_range.end_label_comp_id 
_struct_sheet_range.end_label_asym_id 
_struct_sheet_range.end_label_seq_id 
_struct_sheet_range.pdbx_end_PDB_ins_code 
_struct_sheet_range.beg_auth_comp_id 
_struct_sheet_range.beg_auth_asym_id 
_struct_sheet_range.beg_auth_seq_id 
_struct_sheet_range.end_auth_comp_id 
_struct_sheet_range.end_auth_asym_id 
_struct_sheet_range.end_auth_seq_id 
AA1 1 GLN A 60  ? VAL A 63  ? GLN A 60  VAL A 63  
AA1 2 LEU A 562 ? SER A 565 ? LEU A 562 SER A 565 
AA1 3 TYR A 95  ? ASP A 103 ? TYR A 95  ASP A 103 
AA1 4 TYR A 502 ? VAL A 509 ? TYR A 502 VAL A 509 
AA2 1 GLN A 60  ? VAL A 63  ? GLN A 60  VAL A 63  
AA2 2 LEU A 562 ? SER A 565 ? LEU A 562 SER A 565 
AA2 3 TYR A 95  ? ASP A 103 ? TYR A 95  ASP A 103 
AA2 4 SER A 554 ? GLN A 559 ? SER A 554 GLN A 559 
AA3 1 GLU A 69  ? ASP A 70  ? GLU A 69  ASP A 70  
AA3 2 TYR A 74  ? PHE A 79  ? TYR A 74  PHE A 79  
AA3 3 ASN A 527 ? ARG A 533 ? ASN A 527 ARG A 533 
AA3 4 SER A 294 ? SER A 296 ? SER A 294 SER A 296 
AA4 1 ASN A 82  ? VAL A 83  ? ASN A 82  VAL A 83  
AA4 2 GLY A 524 ? THR A 525 ? GLY A 524 THR A 525 
AA5 1 VAL A 89  ? ASP A 90  ? VAL A 89  ASP A 90  
AA5 2 LEU A 520 ? LEU A 521 ? LEU A 520 LEU A 521 
AA6 1 SER A 128 ? ALA A 129 ? SER A 128 ALA A 129 
AA6 2 THR A 136 ? VAL A 139 ? THR A 136 VAL A 139 
AA6 3 THR B 395 ? ILE B 399 ? THR B 395 ILE B 399 
AA6 4 ALA B 375 ? GLY B 377 ? ALA B 375 GLY B 377 
AA7 1 GLN A 144 ? THR A 145 ? GLN A 144 THR A 145 
AA7 2 GLY A 188 ? LEU A 189 ? GLY A 188 LEU A 189 
AA8 1 ASP A 257 ? PHE A 258 ? ASP A 257 PHE A 258 
AA8 2 ALA A 264 ? THR A 265 ? ALA A 264 THR A 265 
AA9 1 ILE A 274 ? PHE A 276 ? ILE A 274 PHE A 276 
AA9 2 LEU A 540 ? SER A 542 ? LEU A 540 SER A 542 
AB1 1 LEU A 360 ? ALA A 361 ? LEU A 360 ALA A 361 
AB1 2 VAL A 407 ? GLU A 408 ? VAL A 407 GLU A 408 
AB2 1 THR A 388 ? VAL A 391 ? THR A 388 VAL A 391 
AB2 2 THR A 378 ? ASN A 383 ? THR A 378 ASN A 383 
AB2 3 TYR C 227 ? ASN C 229 ? TYR C 227 ASN C 229 
AB3 1 THR A 395 ? VAL A 396 ? THR A 395 VAL A 396 
AB3 2 ASP C 135 ? LEU C 142 ? ASP C 135 LEU C 142 
AB3 3 ILE A 399 ? TYR A 401 ? ILE A 399 TYR A 401 
AB4 1 THR A 395 ? VAL A 396 ? THR A 395 VAL A 396 
AB4 2 ASP C 135 ? LEU C 142 ? ASP C 135 LEU C 142 
AB4 3 SER C 128 ? VAL C 132 ? SER C 128 VAL C 132 
AB5 1 LYS A 433 ? PHE A 434 ? LYS A 433 PHE A 434 
AB5 2 LEU A 455 ? PRO A 456 ? LEU A 455 PRO A 456 
AB6 1 GLN A 588 ? SER A 591 ? GLN A 588 SER A 591 
AB6 2 PHE A 880 ? ASN A 886 ? PHE A 880 ASN A 886 
AB6 3 SER A 894 ? LEU A 900 ? SER A 894 LEU A 900 
AB7 1 ALA A 596 ? ILE A 603 ? ALA A 596 ILE A 603 
AB7 2 THR A 871 ? GLY A 878 ? THR A 871 GLY A 878 
AB7 3 GLY A 624 ? LYS A 631 ? GLY A 624 LYS A 631 
AB7 4 TRP A 828 ? PRO A 831 ? TRP A 828 PRO A 831 
AB8 1 THR A 609 ? ARG A 617 ? THR A 609 ARG A 617 
AB8 2 HIS A 856 ? THR A 863 ? HIS A 856 THR A 863 
AB8 3 ARG A 667 ? GLN A 671 ? ARG A 667 GLN A 671 
AB8 4 PRO A 677 ? TRP A 678 ? PRO A 677 TRP A 678 
AB9 1 GLU A 746 ? VAL A 752 ? GLU A 746 VAL A 752 
AB9 2 VAL A 816 ? LEU A 822 ? VAL A 816 LEU A 822 
AC1 1 GLN B 60  ? VAL B 63  ? GLN B 60  VAL B 63  
AC1 2 GLN B 559 ? SER B 565 ? GLN B 559 SER B 565 
AC1 3 TYR B 95  ? ASP B 103 ? TYR B 95  ASP B 103 
AC1 4 TYR B 502 ? VAL B 509 ? TYR B 502 VAL B 509 
AC2 1 GLN B 60  ? VAL B 63  ? GLN B 60  VAL B 63  
AC2 2 GLN B 559 ? SER B 565 ? GLN B 559 SER B 565 
AC2 3 TYR B 95  ? ASP B 103 ? TYR B 95  ASP B 103 
AC2 4 SER B 554 ? ILE B 555 ? SER B 554 ILE B 555 
AC3 1 GLU B 69  ? ASP B 70  ? GLU B 69  ASP B 70  
AC3 2 TYR B 74  ? VAL B 83  ? TYR B 74  VAL B 83  
AC3 3 GLY B 524 ? ARG B 533 ? GLY B 524 ARG B 533 
AC3 4 SER B 294 ? SER B 297 ? SER B 294 SER B 297 
AC4 1 VAL B 89  ? ASP B 90  ? VAL B 89  ASP B 90  
AC4 2 LEU B 520 ? LEU B 521 ? LEU B 520 LEU B 521 
AC5 1 SER B 128 ? VAL B 132 ? SER B 128 VAL B 132 
AC5 2 ASP B 135 ? VAL B 139 ? ASP B 135 VAL B 139 
AC5 3 VAL C 396 ? LEU C 398 ? VAL C 396 LEU C 398 
AC6 1 GLN B 144 ? ALA B 147 ? GLN B 144 ALA B 147 
AC6 2 ASN B 186 ? LEU B 189 ? ASN B 186 LEU B 189 
AC7 1 ILE B 192 ? VAL B 193 ? ILE B 192 VAL B 193 
AC7 2 ALA B 242 ? ASP B 244 ? ALA B 242 ASP B 244 
AC7 3 THR B 224 ? LYS B 225 ? THR B 224 LYS B 225 
AC8 1 ALA B 253 ? PHE B 258 ? ALA B 253 PHE B 258 
AC8 2 ALA B 264 ? GLY B 268 ? ALA B 264 GLY B 268 
AC9 1 GLY B 275 ? PHE B 276 ? GLY B 275 PHE B 276 
AC9 2 LEU B 540 ? GLN B 541 ? LEU B 540 GLN B 541 
AD1 1 ASN B 359 ? ALA B 361 ? ASN B 359 ALA B 361 
AD1 2 VAL B 407 ? MET B 409 ? VAL B 407 MET B 409 
AD2 1 MET B 380 ? VAL B 382 ? MET B 380 VAL B 382 
AD2 2 ALA B 389 ? VAL B 391 ? ALA B 389 VAL B 391 
AD3 1 LYS B 433 ? PHE B 434 ? LYS B 433 PHE B 434 
AD3 2 LEU B 455 ? PRO B 456 ? LEU B 455 PRO B 456 
AD4 1 ALA B 596 ? LEU B 600 ? ALA B 596 LEU B 600 
AD4 2 THR B 871 ? GLY B 878 ? THR B 871 GLY B 878 
AD4 3 GLY B 624 ? LYS B 631 ? GLY B 624 LYS B 631 
AD4 4 TRP B 828 ? PRO B 831 ? TRP B 828 PRO B 831 
AD5 1 THR B 609 ? SER B 618 ? THR B 609 SER B 618 
AD5 2 SER B 855 ? THR B 863 ? SER B 855 THR B 863 
AD5 3 ARG B 667 ? TRP B 672 ? ARG B 667 TRP B 672 
AD5 4 VAL B 676 ? TRP B 678 ? VAL B 676 TRP B 678 
AD6 1 THR B 609 ? SER B 618 ? THR B 609 SER B 618 
AD6 2 SER B 855 ? THR B 863 ? SER B 855 THR B 863 
AD6 3 ARG B 667 ? TRP B 672 ? ARG B 667 TRP B 672 
AD6 4 PHE B 690 ? GLU B 691 ? PHE B 690 GLU B 691 
AD7 1 PHE B 745 ? VAL B 752 ? PHE B 745 VAL B 752 
AD7 2 VAL B 816 ? VAL B 823 ? VAL B 816 VAL B 823 
AD8 1 GLN B 882 ? VAL B 883 ? GLN B 882 VAL B 883 
AD8 2 SER B 893 ? LEU B 897 ? SER B 894 LEU B 898 
AD8 3 ASN B 885 ? ASN B 885 ? ASN B 886 ASN B 886 
AD9 1 ARG C 62  ? VAL C 63  ? ARG C 62  VAL C 63  
AD9 2 SER C 554 ? TYR C 563 ? SER C 554 TYR C 563 
AD9 3 TYR C 95  ? ASP C 103 ? TYR C 95  ASP C 103 
AD9 4 TYR C 502 ? CYS C 503 ? TYR C 502 CYS C 503 
AE1 1 ARG C 62  ? VAL C 63  ? ARG C 62  VAL C 63  
AE1 2 SER C 554 ? TYR C 563 ? SER C 554 TYR C 563 
AE1 3 TYR C 95  ? ASP C 103 ? TYR C 95  ASP C 103 
AE1 4 HIS C 506 ? VAL C 509 ? HIS C 506 VAL C 509 
AE2 1 GLN C 67  ? ASP C 70  ? GLN C 67  ASP C 70  
AE2 2 TYR C 74  ? VAL C 83  ? TYR C 74  VAL C 83  
AE2 3 GLY C 524 ? ARG C 533 ? GLY C 524 ARG C 533 
AE2 4 SER C 294 ? SER C 297 ? SER C 294 SER C 297 
AE3 1 VAL C 89  ? ASP C 90  ? VAL C 89  ASP C 90  
AE3 2 LEU C 520 ? LEU C 521 ? LEU C 520 LEU C 521 
AE4 1 ALA C 253 ? PHE C 258 ? ALA C 253 PHE C 258 
AE4 2 ALA C 264 ? GLY C 268 ? ALA C 264 GLY C 268 
AE5 1 GLY C 275 ? PHE C 276 ? GLY C 275 PHE C 276 
AE5 2 LEU C 540 ? GLN C 541 ? LEU C 540 GLN C 541 
AE6 1 ASN C 359 ? ALA C 361 ? ASN C 359 ALA C 361 
AE6 2 VAL C 407 ? MET C 409 ? VAL C 407 MET C 409 
AE7 1 THR C 381 ? VAL C 382 ? THR C 381 VAL C 382 
AE7 2 ALA C 389 ? ALA C 390 ? ALA C 389 ALA C 390 
AE8 1 LYS C 433 ? PHE C 434 ? LYS C 433 PHE C 434 
AE8 2 LEU C 455 ? PRO C 456 ? LEU C 455 PRO C 456 
AE9 1 GLN C 588 ? SER C 591 ? GLN C 588 SER C 591 
AE9 2 PHE C 880 ? THR C 889 ? PHE C 880 THR C 889 
AE9 3 GLY C 892 ? LEU C 900 ? GLY C 892 LEU C 900 
AF1 1 ALA C 596 ? LEU C 600 ? ALA C 596 LEU C 600 
AF1 2 THR C 871 ? GLY C 878 ? THR C 871 GLY C 878 
AF1 3 GLY C 624 ? LYS C 631 ? GLY C 624 LYS C 631 
AF1 4 TRP C 828 ? PRO C 831 ? TRP C 828 PRO C 831 
AF2 1 THR C 609 ? ASN C 613 ? THR C 609 ASN C 613 
AF2 2 ASN C 859 ? VAL C 864 ? ASN C 859 VAL C 864 
AF2 3 PHE C 665 ? GLN C 671 ? PHE C 665 GLN C 671 
AF2 4 PHE C 690 ? GLU C 691 ? PHE C 690 GLU C 691 
AF3 1 PHE C 745 ? PRO C 753 ? PHE C 745 PRO C 753 
AF3 2 GLN C 815 ? VAL C 823 ? GLN C 815 VAL C 823 
# 
_atom_sites.entry_id                    atom 
_atom_sites.fract_transf_matrix[1][1]   1.000000 
_atom_sites.fract_transf_matrix[1][2]   0.000000 
_atom_sites.fract_transf_matrix[1][3]   0.000000 
_atom_sites.fract_transf_matrix[2][1]   0.000000 
_atom_sites.fract_transf_matrix[2][2]   1.000000 
_atom_sites.fract_transf_matrix[2][3]   0.000000 
_atom_sites.fract_transf_matrix[3][1]   0.000000 
_atom_sites.fract_transf_matrix[3][2]   0.000000 
_atom_sites.fract_transf_matrix[3][3]   1.000000 
_atom_sites.fract_transf_vector[1]      0.00000 
_atom_sites.fract_transf_vector[2]      0.00000 
_atom_sites.fract_transf_vector[3]      0.00000 
# 
loop_
_pdbx_validate_rmsd_angle.id 
_pdbx_validate_rmsd_angle.PDB_model_num 
_pdbx_validate_rmsd_angle.auth_atom_id_1 
_pdbx_validate_rmsd_angle.auth_asym_id_1 
_pdbx_validate_rmsd_angle.auth_comp_id_1 
_pdbx_validate_rmsd_angle.auth_seq_id_1 
_pdbx_validate_rmsd_angle.PDB_ins_code_1 
_pdbx_validate_rmsd_angle.label_alt_id_1 
_pdbx_validate_rmsd_angle.auth_atom_id_2 
_pdbx_validate_rmsd_angle.auth_asym_id_2 
_pdbx_validate_rmsd_angle.auth_comp_id_2 
_pdbx_validate_rmsd_angle.auth_seq_id_2 
_pdbx_validate_rmsd_angle.PDB_ins_code_2 
_pdbx_validate_rmsd_angle.label_alt_id_2 
_pdbx_validate_rmsd_angle.auth_atom_id_3 
_pdbx_validate_rmsd_angle.auth_asym_id_3 
_pdbx_validate_rmsd_angle.auth_comp_id_3 
_pdbx_validate_rmsd_angle.auth_seq_id_3 
_pdbx_validate_rmsd_angle.PDB_ins_code_3 
_pdbx_validate_rmsd_angle.label_alt_id_3 
_pdbx_validate_rmsd_angle.angle_value 
_pdbx_validate_rmsd_angle.angle_target_value 
_pdbx_validate_rmsd_angle.angle_deviation 
_pdbx_validate_rmsd_angle.angle_standard_deviation 
_pdbx_validate_rmsd_angle.linker_flag 
1 1 CB A ASP 252 ? ? CG A ASP 252 ? ? OD1 A ASP 252 ? ? 123.79 118.30 5.49  0.90 N 
2 1 CA B LEU 348 ? ? CB B LEU 348 ? ? CG  B LEU 348 ? ? 135.93 115.30 20.63 2.30 N 
# 
loop_
_pdbx_validate_torsion.id 
_pdbx_validate_torsion.PDB_model_num 
_pdbx_validate_torsion.auth_comp_id 
_pdbx_validate_torsion.auth_asym_id 
_pdbx_validate_torsion.auth_seq_id 
_pdbx_validate_torsion.PDB_ins_code 
_pdbx_validate_torsion.label_alt_id 
_pdbx_validate_torsion.phi 
_pdbx_validate_torsion.psi 
1   1 SER A 48  ? ? 67.53   -3.17   
2   1 ASN A 86  ? ? 59.01   17.06   
3   1 PRO A 110 ? ? -86.83  42.12   
4   1 ALA A 147 ? ? -59.56  -179.79 
5   1 ALA A 148 ? ? 60.11   67.25   
6   1 GLU A 198 ? ? 60.69   66.16   
7   1 PRO A 203 ? ? -69.98  -175.04 
8   1 ASN A 234 ? ? 68.14   -4.43   
9   1 MET A 241 ? ? 58.96   70.20   
10  1 HIS A 254 ? ? -141.55 30.94   
11  1 PHE A 255 ? ? 58.41   72.40   
12  1 ASP A 260 ? ? 74.19   -29.63  
13  1 ASP A 261 ? ? -155.81 -35.34  
14  1 ASN A 279 ? ? 58.29   19.40   
15  1 SER A 368 ? ? -170.40 149.31  
16  1 GLN A 385 ? ? 71.37   -6.58   
17  1 ASP A 462 ? ? -163.39 -169.24 
18  1 THR A 478 ? ? -91.29  47.38   
19  1 ASN A 487 ? ? -66.97  95.78   
20  1 ARG A 617 ? ? -126.78 -166.83 
21  1 SER A 649 ? ? -140.60 31.56   
22  1 THR A 658 ? ? 34.60   40.24   
23  1 LEU A 661 ? ? -98.23  37.21   
24  1 PHE A 665 ? ? -140.12 52.85   
25  1 VAL A 676 ? ? 57.12   75.78   
26  1 ASN A 681 ? ? -94.75  34.77   
27  1 ASN A 697 ? ? 87.05   -1.12   
28  1 ASN A 758 ? ? 66.34   -1.39   
29  1 ASN A 778 ? ? 31.50   47.95   
30  1 GLU A 792 ? ? 58.88   77.22   
31  1 ARG A 793 ? ? -39.51  141.72  
32  1 LEU A 827 ? ? 60.20   77.40   
33  1 TRP A 828 ? ? -37.02  129.69  
34  1 ASN A 838 ? ? -100.92 79.08   
35  1 GLN B 4   ? ? 62.08   -2.77   
36  1 PRO B 110 ? ? -85.81  41.35   
37  1 ASN B 134 ? ? -93.57  -61.85  
38  1 GLN B 141 ? ? -163.12 115.84  
39  1 PRO B 168 ? ? -84.08  36.88   
40  1 GLN B 169 ? ? -146.64 29.22   
41  1 VAL B 179 ? ? -39.49  127.32  
42  1 PRO B 203 ? ? -68.96  -174.71 
43  1 ALA B 221 ? ? -126.12 -169.42 
44  1 MET B 241 ? ? 56.67   70.79   
45  1 VAL B 259 ? ? -121.13 -57.38  
46  1 ASN B 279 ? ? 59.49   19.22   
47  1 THR B 299 ? ? 60.18   85.97   
48  1 GLN B 300 ? ? 78.18   71.76   
49  1 GLN B 301 ? ? -66.04  7.33    
50  1 LEU B 315 ? ? 69.16   -11.61  
51  1 LEU B 348 ? ? 58.26   73.44   
52  1 GLU B 384 ? ? 58.80   78.04   
53  1 GLN B 385 ? ? 83.15   12.05   
54  1 TYR B 432 ? ? -97.51  32.61   
55  1 ASP B 462 ? ? -162.75 -166.26 
56  1 ASP B 551 ? ? -92.19  50.79   
57  1 THR B 558 ? ? -91.32  -61.66  
58  1 ASN B 586 ? ? -98.99  36.82   
59  1 ASP B 673 ? ? 34.19   39.89   
60  1 SER B 674 ? ? 64.49   -0.70   
61  1 ASP B 682 ? ? 31.44   54.63   
62  1 ASN B 697 ? ? 78.98   -7.24   
63  1 TYR B 727 ? ? 68.91   -7.95   
64  1 TYR B 739 ? ? -93.00  50.73   
65  1 TYR B 759 ? ? 52.07   74.76   
66  1 ASN B 778 ? ? 31.53   52.89   
67  1 ASN B 848 ? ? -85.20  45.11   
68  1 MET B 850 ? ? -142.07 -23.77  
69  1 ASN B 853 ? ? 72.55   -11.93  
70  1 GLU C 21  ? ? 72.16   -11.38  
71  1 THR C 30  ? ? -67.40  -77.10  
72  1 GLN C 31  ? ? 59.75   -13.70  
73  1 ASN C 32  ? ? -125.91 -50.17  
74  1 VAL C 51  ? ? -103.75 -61.44  
75  1 PRO C 110 ? ? -86.11  41.55   
76  1 SER C 162 ? ? 34.21   44.32   
77  1 ASN C 174 ? ? 72.16   -14.53  
78  1 TYR C 175 ? ? -144.02 18.00   
79  1 ALA C 187 ? ? -94.10  -60.00  
80  1 PRO C 203 ? ? -69.35  -174.64 
81  1 ALA C 221 ? ? -127.35 -166.97 
82  1 SER C 238 ? ? -99.49  56.61   
83  1 MET C 241 ? ? 48.65   73.43   
84  1 ASP C 252 ? ? 72.54   -8.86   
85  1 THR C 299 ? ? 67.36   -7.27   
86  1 HIS C 365 ? ? -97.55  38.73   
87  1 VAL C 366 ? ? -38.90  -33.04  
88  1 VAL C 391 ? ? -97.99  -65.18  
89  1 TYR C 427 ? ? -96.93  35.03   
90  1 PRO C 429 ? ? -67.48  -177.43 
91  1 ASN C 459 ? ? -102.54 64.00   
92  1 ARG C 470 ? ? -69.26  98.24   
93  1 MET C 476 ? ? -99.92  30.83   
94  1 ASN C 483 ? ? -95.76  56.11   
95  1 ASN C 681 ? ? 58.89   16.84   
96  1 ASN C 703 ? ? -102.89 65.54   
97  1 ASN C 724 ? ? 32.62   46.26   
98  1 TYR C 727 ? ? 71.32   -6.82   
99  1 ASN C 778 ? ? 32.50   55.38   
100 1 THR C 785 ? ? -89.85  44.87   
101 1 ASN C 810 ? ? -97.76  33.47   
102 1 SER C 854 ? ? -83.86  -84.61  
103 1 SER C 855 ? ? 173.01  168.02  
104 1 SER C 904 ? ? -162.39 -164.53 
105 1 SER C 906 ? ? -160.12 118.35  
# 
loop_
_pdbx_validate_peptide_omega.id 
_pdbx_validate_peptide_omega.PDB_model_num 
_pdbx_validate_peptide_omega.auth_comp_id_1 
_pdbx_validate_peptide_omega.auth_asym_id_1 
_pdbx_validate_peptide_omega.auth_seq_id_1 
_pdbx_validate_peptide_omega.PDB_ins_code_1 
_pdbx_validate_peptide_omega.label_alt_id_1 
_pdbx_validate_peptide_omega.auth_comp_id_2 
_pdbx_validate_peptide_omega.auth_asym_id_2 
_pdbx_validate_peptide_omega.auth_seq_id_2 
_pdbx_validate_peptide_omega.PDB_ins_code_2 
_pdbx_validate_peptide_omega.label_alt_id_2 
_pdbx_validate_peptide_omega.omega 
1 1 ASP A 260 ? ? ASP A 261 ? ? 147.08  
2 1 ASP A 261 ? ? ARG A 262 ? ? -146.41 
3 1 GLN A 298 ? ? THR A 299 ? ? 148.79  
4 1 LEU A 791 ? ? GLU A 792 ? ? 145.85  
5 1 PRO B 178 ? ? VAL B 179 ? ? -136.36 
6 1 THR B 299 ? ? GLN B 300 ? ? -137.38 
7 1 ASN B 697 ? ? GLN B 698 ? ? 149.98  
8 1 THR B 772 ? ? MET B 773 ? ? -139.80 
9 1 HIS C 365 ? ? VAL C 366 ? ? -138.35 
# 
_pdbx_validate_polymer_linkage.id               1 
_pdbx_validate_polymer_linkage.PDB_model_num    1 
_pdbx_validate_polymer_linkage.auth_atom_id_1   C 
_pdbx_validate_polymer_linkage.auth_asym_id_1   B 
_pdbx_validate_polymer_linkage.auth_comp_id_1   VAL 
_pdbx_validate_polymer_linkage.auth_seq_id_1    883 
_pdbx_validate_polymer_linkage.PDB_ins_code_1   ? 
_pdbx_validate_polymer_linkage.label_alt_id_1   ? 
_pdbx_validate_polymer_linkage.auth_atom_id_2   N 
_pdbx_validate_polymer_linkage.auth_asym_id_2   B 
_pdbx_validate_polymer_linkage.auth_comp_id_2   ILE 
_pdbx_validate_polymer_linkage.auth_seq_id_2    885 
_pdbx_validate_polymer_linkage.PDB_ins_code_2   ? 
_pdbx_validate_polymer_linkage.label_alt_id_2   ? 
_pdbx_validate_polymer_linkage.dist             4.18 
# 
loop_
_atom_type.symbol 
C 
N 
O 
S 
# 
_entry.id   atom 
# 
loop_
_pdbx_seq_map_depositor_info.entity_id 
_pdbx_seq_map_depositor_info.auth_asym_id 
_pdbx_seq_map_depositor_info.one_letter_code 
_pdbx_seq_map_depositor_info.one_letter_code_mod 
1 A 
;MEPQREFFHIAGRSAKEYLSENLVQFIQATQNYFNIGEKFRDPYVAPSAGVTTDRSQKLQLRVVPIQTEDNVNYYKARFT
LNVGDNRLVDLGSSYFDIKGTLDRGPSFKPYGGTAYNPLAPKSAPINSAFTVGNDTHFVAQLPQTYAAGGTGVTEAIQQQ
VSGVDPNPQVGQPNYAGPVVVNTTNNAGLGRIVSADSEGQQFPCYGAYAPPQSAGGDVSTAAVTKTYINTTNNNGRVSGT
MATDTITWENPDAHFADFVDDRRATAAGNRPNYIGFRDNFIGMMYYNSGSNTGSFSSQTQQLNIVLDLNDRNSELSYQYL
LADLTSRWHYFALWNQAVDDYDHHVRILENDGYEEGPPNLAFPPHVISNPFAPAAVGTGMTVNEQQQTAAVTANTVALIG
YGNIPAVEMNLPANLKRTFLYSNVAMYLPDTYKFTPANVDLPENHLSYGYINGRLPLPNIVDTWTDIGARWSLDVMDTVN
PFNHHRNTGLKYRSQLLGNGRYCDFHIQVPQKFFAIKNLLLLPGTYNYEWYFRKDPNMVLQSTLGNDLRADGASITYTQI
NLYVSFFPMNYDTQSELELMLRNATNDQNFSDYLGAVNNLYQIPAGSSTVVVNIPDRSWGAFRGWSFTRLKVSETPRIGA
TQDPNFQYSGSIPYLDGTFYLSHTFQRCSIQWDSSVPWPGNDRMLTPNWFEIKRPINQDAEGNDTMQSNLTKDFFMVQMA
ASYNQGYQGFNWPNCTKHYGFINNFEPMSRQVPEYGANYPNLMAAYLANPQTMPIWNNCGFQQKTATNVLLERCGHPYVA
NWPYPLSGRNAVPNQVTERKFLVDRYLWQIPFSSNFLNMGTLTDLGQNVMYANSSHSLNMQFTVDPMTEPTYLMLLFGVF
DQVVINQPTRSGISVAYLRLPFASG
;
;MEPQREFFHIAGRSAKEYLSENLVQFIQATQNYFNIGEKFRDPYVAPSAGVTTDRSQKLQLRVVPIQTEDNVNYYKARFT
LNVGDNRLVDLGSSYFDIKGTLDRGPSFKPYGGTAYNPLAPKSAPINSAFTVGNDTHFVAQLPQTYAAGGTGVTEAIQQQ
VSGVDPNPQVGQPNYAGPVVVNTTNNAGLGRIVSADSEGQQFPCYGAYAPPQSAGGDVSTAAVTKTYINTTNNNGRVSGT
MATDTITWENPDAHFADFVDDRRATAAGNRPNYIGFRDNFIGMMYYNSGSNTGSFSSQTQQLNIVLDLNDRNSELSYQYL
LADLTSRWHYFALWNQAVDDYDHHVRILENDGYEEGPPNLAFPPHVISNPFAPAAVGTGMTVNEQQQTAAVTANTVALIG
YGNIPAVEMNLPANLKRTFLYSNVAMYLPDTYKFTPANVDLPENHLSYGYINGRLPLPNIVDTWTDIGARWSLDVMDTVN
PFNHHRNTGLKYRSQLLGNGRYCDFHIQVPQKFFAIKNLLLLPGTYNYEWYFRKDPNMVLQSTLGNDLRADGASITYTQI
NLYVSFFPMNYDTQSELELMLRNATNDQNFSDYLGAVNNLYQIPAGSSTVVVNIPDRSWGAFRGWSFTRLKVSETPRIGA
TQDPNFQYSGSIPYLDGTFYLSHTFQRCSIQWDSSVPWPGNDRMLTPNWFEIKRPINQDAEGNDTMQSNLTKDFFMVQMA
ASYNQGYQGFNWPNCTKHYGFINNFEPMSRQVPEYGANYPNLMAAYLANPQTMPIWNNCGFQQKTATNVLLERCGHPYVA
NWPYPLSGRNAVPNQVTERKFLVDRYLWQIPFSSNFLNMGTLTDLGQNVMYANSSHSLNMQFTVDPMTEPTYLMLLFGVF
DQVVINQPTRSGISVAYLRLPFASG
;
2 B 
;MEPQREFFHIAGRSAKEYLSENLVQFIQATQNYFNIGEKFRDPYVAPSAGVTTDRSQKLQLRVVPIQTEDNVNYYKARFT
LNVGDNRLVDLGSSYFDIKGTLDRGPSFKPYGGTAYNPLAPKSAPINSAFTVGNDTHFVAQLPQTYAAGGTGVTEAIQQQ
VSGVDPNPQVGQPNYAGPVVVNTTNNAGLGRIVSADSEGQQFPCYGAYAPPQSAGGDVSTAAVTKTYINTTNNNGRVSGT
MATDTITWENPDAHFADFVDDRRATAAGNRPNYIGFRDNFIGMMYYNSGSNTGSFSSQTQQLNIVLDLNDRNSELSYQYL
LADLTSRWHYFALWNQAVDDYDHHVRILENDGYEEGPPNLAFPPHVISNPFAPAAVGTGMTVNEQQQTAAVTANTVALIG
YGNIPAVEMNLPANLKRTFLYSNVAMYLPDTYKFTPANVDLPENHLSYGYINGRLPLPNIVDTWTDIGARWSLDVMDTVN
PFNHHRNTGLKYRSQLLGNGRYCDFHIQVPQKFFAIKNLLLLPGTYNYEWYFRKDPNMVLQSTLGNDLRADGASITYTQI
NLYVSFFPMNYDTQSELELMLRNATNDQNFSDYLGAVNNLYQIPAGSSTVVVNIPDRSWGAFRGWSFTRLKVSETPRIGA
TQDPNFQYSGSIPYLDGTFYLSHTFQRCSIQWDSSVPWPGNDRMLTPNWFEIKRPINQDAEGNDTMQSNLTKDFFMVQMA
ASYNQGYQGFNWPNCTKHYGFINNFEPMSRQVPEYGANYPNLMAAYLANPQTMPIWNNCGFQQKTATNVLLERCGHPYVA
NWPYPLSGRNAVPNQVTERKFLVDRYLWQIPFSSNFLNMGTLTDLGQNVMYANSSHSLNMQFTVDPMTEPTYLMLLFGVF
DQVINQPTRSGISVAYLRLPFASG
;
;MEPQREFFHIAGRSAKEYLSENLVQFIQATQNYFNIGEKFRDPYVAPSAGVTTDRSQKLQLRVVPIQTEDNVNYYKARFT
LNVGDNRLVDLGSSYFDIKGTLDRGPSFKPYGGTAYNPLAPKSAPINSAFTVGNDTHFVAQLPQTYAAGGTGVTEAIQQQ
VSGVDPNPQVGQPNYAGPVVVNTTNNAGLGRIVSADSEGQQFPCYGAYAPPQSAGGDVSTAAVTKTYINTTNNNGRVSGT
MATDTITWENPDAHFADFVDDRRATAAGNRPNYIGFRDNFIGMMYYNSGSNTGSFSSQTQQLNIVLDLNDRNSELSYQYL
LADLTSRWHYFALWNQAVDDYDHHVRILENDGYEEGPPNLAFPPHVISNPFAPAAVGTGMTVNEQQQTAAVTANTVALIG
YGNIPAVEMNLPANLKRTFLYSNVAMYLPDTYKFTPANVDLPENHLSYGYINGRLPLPNIVDTWTDIGARWSLDVMDTVN
PFNHHRNTGLKYRSQLLGNGRYCDFHIQVPQKFFAIKNLLLLPGTYNYEWYFRKDPNMVLQSTLGNDLRADGASITYTQI
NLYVSFFPMNYDTQSELELMLRNATNDQNFSDYLGAVNNLYQIPAGSSTVVVNIPDRSWGAFRGWSFTRLKVSETPRIGA
TQDPNFQYSGSIPYLDGTFYLSHTFQRCSIQWDSSVPWPGNDRMLTPNWFEIKRPINQDAEGNDTMQSNLTKDFFMVQMA
ASYNQGYQGFNWPNCTKHYGFINNFEPMSRQVPEYGANYPNLMAAYLANPQTMPIWNNCGFQQKTATNVLLERCGHPYVA
NWPYPLSGRNAVPNQVTERKFLVDRYLWQIPFSSNFLNMGTLTDLGQNVMYANSSHSLNMQFTVDPMTEPTYLMLLFGVF
DQVINQPTRSGISVAYLRLPFASG
;
3 C 
;MEPQREFFHIAGRSAKEYLSENLVQFIQATQNYFNIGEKFRDPYVAPSAGVTTDRSQKLQLRVVPIQTEDNVNYYKARFT
LNVGDNRLVDLGSSYFDIKGTLDRGPSFKPYGGTAYNPLAPKSAPINSAFTVGNDTHFVAQLPQTYAAGGTGVTEAIQQQ
VSGVDPNPQVGQPNYAGPVVVNTTNNAGLGRIVSADSEGQQFPCYGAYAPPQSAGGDVSTAAVTKTYINTTNNNGRVSGT
MATDTITWENPDAHFADFVDDRRATAAGNRPNYIGFRDNFIGMMYYNSGSNTGSFSSQTQQLNIVLDLNDRNSELSYQYL
LADLTSRWHYFALWNQAVDDYDHHVRILENDGYEEGPPNLAFPPHVISNPFAPAAVGTGMTVNEQQQTAAVTANTVALIG
YGNIPAVEMNLPANLKRTFLYSNVAMYLPDTYKFTPANVDLPENHLSYGYINGRLPLPNIVDTWTDIGARWSLDVMDTVN
PFNHHRNTGLKYRSQLLGNGRYCDFHIQVPQKFFAIKNLLLLPGTYNYEWYFRKDPNMVLQSTLGNDLRADGASITYTQI
NLYVSFFPMNYDTQSELELMLRNATNDQNFSDYLGAVNNLYQIPAGSSTVVVNIPDRSWGAFRGWSFTRLKVSETPRIGA
TQDPNFQYSGSIPYLDGTFYLSHTFQRCSIQWDSSVPWPGNDRMLTPNWFEIKRPINQDAEGNDTMQSNLTKDFFMVQMA
ASYNQGYQGFNWPNCTKHYGFINNFEPMSRQVPEYGANYPNLMAAYLANPQTMPIWNNCGFQQKTATNVLLERCGHPYVA
NWPYPLSGRNAVPNQVTERKFLVDRYLWQIPFSSNFLNMGTLTDLGQNVMYANSSHSLNMQFTVDPMTEPTYLMLLFGVF
DQVVINQPTRSGISVAYLRLPFASGSA
;
;MEPQREFFHIAGRSAKEYLSENLVQFIQATQNYFNIGEKFRDPYVAPSAGVTTDRSQKLQLRVVPIQTEDNVNYYKARFT
LNVGDNRLVDLGSSYFDIKGTLDRGPSFKPYGGTAYNPLAPKSAPINSAFTVGNDTHFVAQLPQTYAAGGTGVTEAIQQQ
VSGVDPNPQVGQPNYAGPVVVNTTNNAGLGRIVSADSEGQQFPCYGAYAPPQSAGGDVSTAAVTKTYINTTNNNGRVSGT
MATDTITWENPDAHFADFVDDRRATAAGNRPNYIGFRDNFIGMMYYNSGSNTGSFSSQTQQLNIVLDLNDRNSELSYQYL
LADLTSRWHYFALWNQAVDDYDHHVRILENDGYEEGPPNLAFPPHVISNPFAPAAVGTGMTVNEQQQTAAVTANTVALIG
YGNIPAVEMNLPANLKRTFLYSNVAMYLPDTYKFTPANVDLPENHLSYGYINGRLPLPNIVDTWTDIGARWSLDVMDTVN
PFNHHRNTGLKYRSQLLGNGRYCDFHIQVPQKFFAIKNLLLLPGTYNYEWYFRKDPNMVLQSTLGNDLRADGASITYTQI
NLYVSFFPMNYDTQSELELMLRNATNDQNFSDYLGAVNNLYQIPAGSSTVVVNIPDRSWGAFRGWSFTRLKVSETPRIGA
TQDPNFQYSGSIPYLDGTFYLSHTFQRCSIQWDSSVPWPGNDRMLTPNWFEIKRPINQDAEGNDTMQSNLTKDFFMVQMA
ASYNQGYQGFNWPNCTKHYGFINNFEPMSRQVPEYGANYPNLMAAYLANPQTMPIWNNCGFQQKTATNVLLERCGHPYVA
NWPYPLSGRNAVPNQVTERKFLVDRYLWQIPFSSNFLNMGTLTDLGQNVMYANSSHSLNMQFTVDPMTEPTYLMLLFGVF
DQVVINQPTRSGISVAYLRLPFASGSA
;
# 
loop_
_pdbx_struct_sheet_hbond.sheet_id 
_pdbx_struct_sheet_hbond.range_id_1 
_pdbx_struct_sheet_hbond.range_id_2 
_pdbx_struct_sheet_hbond.range_1_label_atom_id 
_pdbx_struct_sheet_hbond.range_1_label_comp_id 
_pdbx_struct_sheet_hbond.range_1_label_asym_id 
_pdbx_struct_sheet_hbond.range_1_label_seq_id 
_pdbx_struct_sheet_hbond.range_1_PDB_ins_code 
_pdbx_struct_sheet_hbond.range_1_auth_atom_id 
_pdbx_struct_sheet_hbond.range_1_auth_comp_id 
_pdbx_struct_sheet_hbond.range_1_auth_asym_id 
_pdbx_struct_sheet_hbond.range_1_auth_seq_id 
_pdbx_struct_sheet_hbond.range_2_label_atom_id 
_pdbx_struct_sheet_hbond.range_2_label_comp_id 
_pdbx_struct_sheet_hbond.range_2_label_asym_id 
_pdbx_struct_sheet_hbond.range_2_label_seq_id 
_pdbx_struct_sheet_hbond.range_2_PDB_ins_code 
_pdbx_struct_sheet_hbond.range_2_auth_atom_id 
_pdbx_struct_sheet_hbond.range_2_auth_comp_id 
_pdbx_struct_sheet_hbond.range_2_auth_asym_id 
_pdbx_struct_sheet_hbond.range_2_auth_seq_id 
AA1 1 2 N VAL A 63  ? N VAL A 63  O LEU A 562 ? O LEU A 562 
AA1 2 3 O TYR A 563 ? O TYR A 563 N TYR A 95  ? N TYR A 95  
AA1 3 4 N LEU A 102 ? N LEU A 102 O CYS A 503 ? O CYS A 503 
AA2 1 2 N VAL A 63  ? N VAL A 63  O LEU A 562 ? O LEU A 562 
AA2 2 3 O TYR A 563 ? O TYR A 563 N TYR A 95  ? N TYR A 95  
AA2 3 4 N ASP A 103 ? N ASP A 103 O SER A 554 ? O SER A 554 
AA3 1 2 N GLU A 69  ? N GLU A 69  O LYS A 76  ? O LYS A 76  
AA3 2 3 N PHE A 79  ? N PHE A 79  O TYR A 528 ? O TYR A 528 
AA3 3 4 O ASN A 527 ? O ASN A 527 N SER A 296 ? N SER A 296 
AA4 1 2 N VAL A 83  ? N VAL A 83  O GLY A 524 ? O GLY A 524 
AA5 1 2 N VAL A 89  ? N VAL A 89  O LEU A 521 ? O LEU A 521 
AA6 1 2 N SER A 128 ? N SER A 128 O VAL A 139 ? O VAL A 139 
AA6 2 3 N PHE A 138 ? N PHE A 138 O LEU B 398 ? O LEU B 398 
AA6 3 4 O ALA B 397 ? O ALA B 397 N GLY B 377 ? N GLY B 377 
AA7 1 2 N GLN A 144 ? N GLN A 144 O LEU A 189 ? O LEU A 189 
AA8 1 2 N ASP A 257 ? N ASP A 257 O THR A 265 ? O THR A 265 
AA9 1 2 N GLY A 275 ? N GLY A 275 O GLN A 541 ? O GLN A 541 
AB1 1 2 N ALA A 361 ? N ALA A 361 O VAL A 407 ? O VAL A 407 
AB2 1 2 O ALA A 390 ? O ALA A 390 N THR A 381 ? N THR A 381 
AB2 2 3 N MET A 380 ? N MET A 380 O TYR C 227 ? O TYR C 227 
AB3 1 2 N VAL A 396 ? N VAL A 396 O THR C 136 ? O THR C 136 
AB3 2 3 O LEU C 142 ? O LEU C 142 N GLY A 400 ? N GLY A 400 
AB4 1 2 N VAL A 396 ? N VAL A 396 O THR C 136 ? O THR C 136 
AB4 2 3 O HIS C 137 ? O HIS C 137 N PHE C 130 ? N PHE C 130 
AB5 1 2 N PHE A 434 ? N PHE A 434 O LEU A 455 ? O LEU A 455 
AB6 1 2 N PHE A 590 ? N PHE A 590 O VAL A 883 ? O VAL A 883 
AB6 2 3 N PHE A 880 ? N PHE A 880 O LEU A 900 ? O LEU A 900 
AB7 1 2 N ILE A 603 ? N ILE A 603 O THR A 871 ? O THR A 871 
AB7 2 3 O GLY A 878 ? O GLY A 878 N GLY A 624 ? N GLY A 624 
AB7 3 4 N TRP A 625 ? N TRP A 625 O ILE A 830 ? O ILE A 830 
AB8 1 2 N ILE A 614 ? N ILE A 614 O LEU A 858 ? O LEU A 858 
AB8 2 3 O ASN A 859 ? O ASN A 859 N GLN A 671 ? N GLN A 671 
AB8 3 4 N ILE A 670 ? N ILE A 670 O TRP A 678 ? O TRP A 678 
AB9 1 2 N ARG A 750 ? N ARG A 750 O GLU A 818 ? O GLU A 818 
AC1 1 2 N LEU B 61  ? N LEU B 61  O VAL B 564 ? O VAL B 564 
AC1 2 3 O ASN B 561 ? O ASN B 561 N ASP B 97  ? N ASP B 97  
AC1 3 4 N PHE B 96  ? N PHE B 96  O VAL B 509 ? O VAL B 509 
AC2 1 2 N LEU B 61  ? N LEU B 61  O VAL B 564 ? O VAL B 564 
AC2 2 3 O ASN B 561 ? O ASN B 561 N ASP B 97  ? N ASP B 97  
AC2 3 4 N ASP B 103 ? N ASP B 103 O SER B 554 ? O SER B 554 
AC3 1 2 N GLU B 69  ? N GLU B 69  O LYS B 76  ? O LYS B 76  
AC3 2 3 N LEU B 81  ? N LEU B 81  O TYR B 526 ? O TYR B 526 
AC3 3 4 O ASN B 527 ? O ASN B 527 N SER B 296 ? N SER B 296 
AC4 1 2 N VAL B 89  ? N VAL B 89  O LEU B 521 ? O LEU B 521 
AC5 1 2 N SER B 128 ? N SER B 128 O VAL B 139 ? O VAL B 139 
AC5 2 3 N PHE B 138 ? N PHE B 138 O LEU C 398 ? O LEU C 398 
AC6 1 2 N TYR B 146 ? N TYR B 146 O ALA B 187 ? O ALA B 187 
AC7 1 2 N ILE B 192 ? N ILE B 192 O ALA B 242 ? O ALA B 242 
AC7 2 3 O THR B 243 ? O THR B 243 N THR B 224 ? N THR B 224 
AC8 1 2 N HIS B 254 ? N HIS B 254 O ALA B 267 ? O ALA B 267 
AC9 1 2 N GLY B 275 ? N GLY B 275 O GLN B 541 ? O GLN B 541 
AD1 1 2 N ALA B 361 ? N ALA B 361 O VAL B 407 ? O VAL B 407 
AD2 1 2 N THR B 381 ? N THR B 381 O ALA B 390 ? O ALA B 390 
AD3 1 2 N PHE B 434 ? N PHE B 434 O LEU B 455 ? O LEU B 455 
AD4 1 2 N ASN B 599 ? N ASN B 599 O LEU B 875 ? O LEU B 875 
AD4 2 3 O TYR B 872 ? O TYR B 872 N LEU B 630 ? N LEU B 630 
AD4 3 4 N TRP B 625 ? N TRP B 625 O ILE B 830 ? O ILE B 830 
AD5 1 2 N VAL B 612 ? N VAL B 612 O MET B 860 ? O MET B 860 
AD5 2 3 O ASN B 859 ? O ASN B 859 N GLN B 671 ? N GLN B 671 
AD5 3 4 N TRP B 672 ? N TRP B 672 O VAL B 676 ? O VAL B 676 
AD6 1 2 N VAL B 612 ? N VAL B 612 O MET B 860 ? O MET B 860 
AD6 2 3 O ASN B 859 ? O ASN B 859 N GLN B 671 ? N GLN B 671 
AD6 3 4 N CYS B 668 ? N CYS B 668 O PHE B 690 ? O PHE B 690 
AD7 1 2 N VAL B 752 ? N VAL B 752 O VAL B 816 ? O VAL B 816 
AD8 1 2 N GLN B 882 ? N GLN B 882 O LEU B 897 ? O LEU B 898 
AD8 2 3 O SER B 893 ? O SER B 894 N ASN B 885 ? N ASN B 886 
AD9 1 2 N VAL C 63  ? N VAL C 63  O LEU C 562 ? O LEU C 562 
AD9 2 3 O SER C 554 ? O SER C 554 N ASP C 103 ? N ASP C 103 
AD9 3 4 N LEU C 102 ? N LEU C 102 O CYS C 503 ? O CYS C 503 
AE1 1 2 N VAL C 63  ? N VAL C 63  O LEU C 562 ? O LEU C 562 
AE1 2 3 O SER C 554 ? O SER C 554 N ASP C 103 ? N ASP C 103 
AE1 3 4 N ILE C 98  ? N ILE C 98  O ILE C 507 ? O ILE C 507 
AE2 1 2 N GLU C 69  ? N GLU C 69  O LYS C 76  ? O LYS C 76  
AE2 2 3 N PHE C 79  ? N PHE C 79  O TYR C 528 ? O TYR C 528 
AE2 3 4 O GLU C 529 ? O GLU C 529 N SER C 294 ? N SER C 294 
AE3 1 2 N VAL C 89  ? N VAL C 89  O LEU C 521 ? O LEU C 521 
AE4 1 2 N HIS C 254 ? N HIS C 254 O ALA C 267 ? O ALA C 267 
AE5 1 2 N GLY C 275 ? N GLY C 275 O GLN C 541 ? O GLN C 541 
AE6 1 2 N ALA C 361 ? N ALA C 361 O VAL C 407 ? O VAL C 407 
AE7 1 2 N THR C 381 ? N THR C 381 O ALA C 390 ? O ALA C 390 
AE8 1 2 N PHE C 434 ? N PHE C 434 O LEU C 455 ? O LEU C 455 
AE9 1 2 N PHE C 590 ? N PHE C 590 O VAL C 883 ? O VAL C 883 
AE9 2 3 N ASN C 886 ? N ASN C 886 O SER C 894 ? O SER C 894 
AF1 1 2 N ASN C 599 ? N ASN C 599 O LEU C 875 ? O LEU C 875 
AF1 2 3 O TYR C 872 ? O TYR C 872 N LEU C 630 ? N LEU C 630 
AF1 3 4 N TRP C 625 ? N TRP C 625 O ILE C 830 ? O ILE C 830 
AF2 1 2 N VAL C 610 ? N VAL C 610 O PHE C 862 ? O PHE C 862 
AF2 2 3 O THR C 863 ? O THR C 863 N GLN C 666 ? N GLN C 666 
AF2 3 4 N CYS C 668 ? N CYS C 668 O PHE C 690 ? O PHE C 690 
AF3 1 2 N VAL C 752 ? N VAL C 752 O VAL C 816 ? O VAL C 816 
# 
loop_
_atom_site.group_PDB 
_atom_site.id 
_atom_site.type_symbol 
_atom_site.label_atom_id 
_atom_site.label_alt_id 
_atom_site.label_comp_id 
_atom_site.label_asym_id 
_atom_site.label_entity_id 
_atom_site.label_seq_id 
_atom_site.pdbx_PDB_ins_code 
_atom_site.Cartn_x 
_atom_site.Cartn_y 
_atom_site.Cartn_z 
_atom_site.occupancy 
_atom_site.B_iso_or_equiv 
_atom_site.pdbx_formal_charge 
_atom_site.auth_seq_id 
_atom_site.auth_comp_id 
_atom_site.auth_asym_id 
_atom_site.auth_atom_id 
_atom_site.pdbx_auth_seq_id 
_atom_site.pdbx_auth_comp_id 
_atom_site.pdbx_auth_asym_id 
_atom_site.pdbx_auth_atom_name 
_atom_site.pdbx_PDB_model_num 
ATOM 1     N N   . MET A 1 1   ? 231.943 -73.474 261.717 1.0 57.98465  ? 1   MET A N   1   MET A N   1 
ATOM 2     C CA  . MET A 1 1   ? 231.228 -73.156 260.487 1.0 57.98465  ? 1   MET A CA  1   MET A CA  1 
ATOM 3     C C   . MET A 1 1   ? 229.909 -72.474 260.790 1.0 57.98465  ? 1   MET A C   1   MET A C   1 
ATOM 4     O O   . MET A 1 1   ? 229.106 -73.014 261.534 1.0 57.98465  ? 1   MET A O   1   MET A O   1 
ATOM 5     C CB  . MET A 1 1   ? 230.982 -74.420 259.670 1.0 57.98465  ? 1   MET A CB  1   MET A CB  1 
ATOM 6     C CG  . MET A 1 1   ? 230.252 -74.176 258.370 1.0 57.98465  ? 1   MET A CG  1   MET A CG  1 
ATOM 7     S SD  . MET A 1 1   ? 230.079 -75.693 257.426 1.0 57.98465  ? 1   MET A SD  1   MET A SD  1 
ATOM 8     C CE  . MET A 1 1   ? 228.895 -76.563 258.440 1.0 57.98465  ? 1   MET A CE  1   MET A CE  1 
ATOM 9     N N   . GLU A 1 2   ? 229.696 -71.299 260.206 1.0 55.57151  ? 2   GLU A N   2   GLU A N   1 
ATOM 10    C CA  . GLU A 1 2   ? 228.488 -70.529 260.480 1.0 55.57151  ? 2   GLU A CA  2   GLU A CA  1 
ATOM 11    C C   . GLU A 1 2   ? 227.276 -71.242 259.890 1.0 55.57151  ? 2   GLU A C   2   GLU A C   1 
ATOM 12    O O   . GLU A 1 2   ? 227.406 -71.911 258.857 1.0 55.57151  ? 2   GLU A O   2   GLU A O   1 
ATOM 13    C CB  . GLU A 1 2   ? 228.634 -69.110 259.921 1.0 55.57151  ? 2   GLU A CB  2   GLU A CB  1 
ATOM 14    C CG  . GLU A 1 2   ? 228.882 -69.003 258.426 1.0 55.57151  ? 2   GLU A CG  2   GLU A CG  1 
ATOM 15    C CD  . GLU A 1 2   ? 227.610 -68.812 257.633 1.0 55.57151  ? 2   GLU A CD  2   GLU A CD  1 
ATOM 16    O OE1 . GLU A 1 2   ? 226.595 -68.414 258.239 1.0 55.57151  ? 2   GLU A OE1 2   GLU A OE1 1 
ATOM 17    O OE2 . GLU A 1 2   ? 227.627 -69.044 256.406 1.0 55.57151  ? 2   GLU A OE2 2   GLU A OE2 1 
ATOM 18    N N   . PRO A 1 3   ? 226.089 -71.149 260.514 1.0 53.12578  ? 3   PRO A N   3   PRO A N   1 
ATOM 19    C CA  . PRO A 1 3   ? 225.649 -70.335 261.651 1.0 53.12578  ? 3   PRO A CA  3   PRO A CA  1 
ATOM 20    C C   . PRO A 1 3   ? 226.013 -70.847 263.044 1.0 53.12578  ? 3   PRO A C   3   PRO A C   1 
ATOM 21    O O   . PRO A 1 3   ? 225.442 -70.349 264.008 1.0 53.12578  ? 3   PRO A O   3   PRO A O   1 
ATOM 22    C CB  . PRO A 1 3   ? 224.134 -70.333 261.495 1.0 53.12578  ? 3   PRO A CB  3   PRO A CB  1 
ATOM 23    C CG  . PRO A 1 3   ? 223.842 -71.638 260.886 1.0 53.12578  ? 3   PRO A CG  3   PRO A CG  1 
ATOM 24    C CD  . PRO A 1 3   ? 224.976 -71.933 259.957 1.0 53.12578  ? 3   PRO A CD  3   PRO A CD  1 
ATOM 25    N N   . GLN A 1 4   ? 226.921 -71.817 263.166 1.0 51.72651  ? 4   GLN A N   4   GLN A N   1 
ATOM 26    C CA  . GLN A 1 4   ? 227.434 -72.146 264.490 1.0 51.72651  ? 4   GLN A CA  4   GLN A CA  1 
ATOM 27    C C   . GLN A 1 4   ? 228.467 -71.136 264.966 1.0 51.72651  ? 4   GLN A C   4   GLN A C   1 
ATOM 28    O O   . GLN A 1 4   ? 228.808 -71.137 266.151 1.0 51.72651  ? 4   GLN A O   4   GLN A O   1 
ATOM 29    C CB  . GLN A 1 4   ? 228.040 -73.551 264.530 1.0 51.72651  ? 4   GLN A CB  4   GLN A CB  1 
ATOM 30    C CG  . GLN A 1 4   ? 227.041 -74.696 264.548 1.0 51.72651  ? 4   GLN A CG  4   GLN A CG  1 
ATOM 31    C CD  . GLN A 1 4   ? 226.400 -74.959 263.202 1.0 51.72651  ? 4   GLN A CD  4   GLN A CD  1 
ATOM 32    O OE1 . GLN A 1 4   ? 225.187 -74.841 263.046 1.0 51.72651  ? 4   GLN A OE1 4   GLN A OE1 1 
ATOM 33    N NE2 . GLN A 1 4   ? 227.213 -75.329 262.224 1.0 51.72651  ? 4   GLN A NE2 4   GLN A NE2 1 
ATOM 34    N N   . ARG A 1 5   ? 228.997 -70.296 264.073 1.0 49.64482  ? 5   ARG A N   5   ARG A N   1 
ATOM 35    C CA  . ARG A 1 5   ? 229.752 -69.131 264.522 1.0 49.64482  ? 5   ARG A CA  5   ARG A CA  1 
ATOM 36    C C   . ARG A 1 5   ? 228.850 -68.149 265.246 1.0 49.64482  ? 5   ARG A C   5   ARG A C   1 
ATOM 37    O O   . ARG A 1 5   ? 229.153 -67.717 266.362 1.0 49.64482  ? 5   ARG A O   5   ARG A O   1 
ATOM 38    C CB  . ARG A 1 5   ? 230.375 -68.388 263.351 1.0 49.64482  ? 5   ARG A CB  5   ARG A CB  1 
ATOM 39    C CG  . ARG A 1 5   ? 231.495 -68.994 262.559 1.0 49.64482  ? 5   ARG A CG  5   ARG A CG  1 
ATOM 40    C CD  . ARG A 1 5   ? 231.783 -67.909 261.547 1.0 49.64482  ? 5   ARG A CD  5   ARG A CD  1 
ATOM 41    N NE  . ARG A 1 5   ? 232.790 -68.171 260.536 1.0 49.64482  ? 5   ARG A NE  5   ARG A NE  1 
ATOM 42    C CZ  . ARG A 1 5   ? 233.061 -67.297 259.573 1.0 49.64482  ? 5   ARG A CZ  5   ARG A CZ  1 
ATOM 43    N NH1 . ARG A 1 5   ? 232.396 -66.152 259.526 1.0 49.64482  ? 5   ARG A NH1 5   ARG A NH1 1 
ATOM 44    N NH2 . ARG A 1 5   ? 233.983 -67.548 258.661 1.0 49.64482  ? 5   ARG A NH2 5   ARG A NH2 1 
ATOM 45    N N   . GLU A 1 6   ? 227.748 -67.770 264.598 1.0 48.35212  ? 6   GLU A N   6   GLU A N   1 
ATOM 46    C CA  . GLU A 1 6   ? 226.903 -66.671 265.040 1.0 48.35212  ? 6   GLU A CA  6   GLU A CA  1 
ATOM 47    C C   . GLU A 1 6   ? 226.159 -66.992 266.328 1.0 48.35212  ? 6   GLU A C   6   GLU A C   1 
ATOM 48    O O   . GLU A 1 6   ? 225.862 -66.078 267.102 1.0 48.35212  ? 6   GLU A O   6   GLU A O   1 
ATOM 49    C CB  . GLU A 1 6   ? 225.922 -66.326 263.917 1.0 48.35212  ? 6   GLU A CB  6   GLU A CB  1 
ATOM 50    C CG  . GLU A 1 6   ? 225.083 -65.084 264.123 1.0 48.35212  ? 6   GLU A CG  6   GLU A CG  1 
ATOM 51    C CD  . GLU A 1 6   ? 224.161 -64.813 262.953 1.0 48.35212  ? 6   GLU A CD  6   GLU A CD  1 
ATOM 52    O OE1 . GLU A 1 6   ? 224.162 -65.614 261.994 1.0 48.35212  ? 6   GLU A OE1 6   GLU A OE1 1 
ATOM 53    O OE2 . GLU A 1 6   ? 223.432 -63.801 262.992 1.0 48.35212  ? 6   GLU A OE2 6   GLU A OE2 1 
ATOM 54    N N   . PHE A 1 7   ? 225.872 -68.266 266.587 1.0 41.94774  ? 7   PHE A N   7   PHE A N   1 
ATOM 55    C CA  . PHE A 1 7   ? 225.215 -68.630 267.834 1.0 41.94774  ? 7   PHE A CA  7   PHE A CA  1 
ATOM 56    C C   . PHE A 1 7   ? 226.158 -68.536 269.021 1.0 41.94774  ? 7   PHE A C   7   PHE A C   1 
ATOM 57    O O   . PHE A 1 7   ? 225.725 -68.182 270.121 1.0 41.94774  ? 7   PHE A O   7   PHE A O   1 
ATOM 58    C CB  . PHE A 1 7   ? 224.637 -70.039 267.733 1.0 41.94774  ? 7   PHE A CB  7   PHE A CB  1 
ATOM 59    C CG  . PHE A 1 7   ? 223.920 -70.486 268.967 1.0 41.94774  ? 7   PHE A CG  7   PHE A CG  1 
ATOM 60    C CD1 . PHE A 1 7   ? 222.698 -69.936 269.307 1.0 41.94774  ? 7   PHE A CD1 7   PHE A CD1 1 
ATOM 61    C CD2 . PHE A 1 7   ? 224.454 -71.472 269.775 1.0 41.94774  ? 7   PHE A CD2 7   PHE A CD2 1 
ATOM 62    C CE1 . PHE A 1 7   ? 222.030 -70.348 270.440 1.0 41.94774  ? 7   PHE A CE1 7   PHE A CE1 1 
ATOM 63    C CE2 . PHE A 1 7   ? 223.792 -71.892 270.906 1.0 41.94774  ? 7   PHE A CE2 7   PHE A CE2 1 
ATOM 64    C CZ  . PHE A 1 7   ? 222.578 -71.329 271.239 1.0 41.94774  ? 7   PHE A CZ  7   PHE A CZ  1 
ATOM 65    N N   . PHE A 1 8   ? 227.437 -68.837 268.824 1.0 41.07355  ? 8   PHE A N   8   PHE A N   1 
ATOM 66    C CA  . PHE A 1 8   ? 228.426 -68.750 269.886 1.0 41.07355  ? 8   PHE A CA  8   PHE A CA  1 
ATOM 67    C C   . PHE A 1 8   ? 229.194 -67.442 269.865 1.0 41.07355  ? 8   PHE A C   8   PHE A C   1 
ATOM 68    O O   . PHE A 1 8   ? 230.134 -67.285 270.649 1.0 41.07355  ? 8   PHE A O   8   PHE A O   1 
ATOM 69    C CB  . PHE A 1 8   ? 229.390 -69.928 269.797 1.0 41.07355  ? 8   PHE A CB  8   PHE A CB  1 
ATOM 70    C CG  . PHE A 1 8   ? 228.748 -71.230 270.123 1.0 41.07355  ? 8   PHE A CG  8   PHE A CG  1 
ATOM 71    C CD1 . PHE A 1 8   ? 228.599 -71.627 271.434 1.0 41.07355  ? 8   PHE A CD1 8   PHE A CD1 1 
ATOM 72    C CD2 . PHE A 1 8   ? 228.244 -72.036 269.122 1.0 41.07355  ? 8   PHE A CD2 8   PHE A CD2 1 
ATOM 73    C CE1 . PHE A 1 8   ? 227.987 -72.816 271.737 1.0 41.07355  ? 8   PHE A CE1 8   PHE A CE1 1 
ATOM 74    C CE2 . PHE A 1 8   ? 227.631 -73.230 269.419 1.0 41.07355  ? 8   PHE A CE2 8   PHE A CE2 1 
ATOM 75    C CZ  . PHE A 1 8   ? 227.502 -73.620 270.730 1.0 41.07355  ? 8   PHE A CZ  8   PHE A CZ  1 
ATOM 76    N N   . HIS A 1 9   ? 228.821 -66.528 268.965 1.0 41.33292  ? 9   HIS A N   9   HIS A N   1 
ATOM 77    C CA  . HIS A 1 9   ? 229.275 -65.135 268.948 1.0 41.33292  ? 9   HIS A CA  9   HIS A CA  1 
ATOM 78    C C   . HIS A 1 9   ? 230.777 -65.019 268.719 1.0 41.33292  ? 9   HIS A C   9   HIS A C   1 
ATOM 79    O O   . HIS A 1 9   ? 231.454 -64.177 269.307 1.0 41.33292  ? 9   HIS A O   9   HIS A O   1 
ATOM 80    C CB  . HIS A 1 9   ? 228.837 -64.402 270.213 1.0 41.33292  ? 9   HIS A CB  9   HIS A CB  1 
ATOM 81    C CG  . HIS A 1 9   ? 227.354 -64.306 270.341 1.0 41.33292  ? 9   HIS A CG  9   HIS A CG  1 
ATOM 82    N ND1 . HIS A 1 9   ? 226.609 -63.395 269.628 1.0 41.33292  ? 9   HIS A ND1 9   HIS A ND1 1 
ATOM 83    C CD2 . HIS A 1 9   ? 226.469 -65.046 271.048 1.0 41.33292  ? 9   HIS A CD2 9   HIS A CD2 1 
ATOM 84    C CE1 . HIS A 1 9   ? 225.331 -63.556 269.917 1.0 41.33292  ? 9   HIS A CE1 9   HIS A CE1 1 
ATOM 85    N NE2 . HIS A 1 9   ? 225.219 -64.549 270.780 1.0 41.33292  ? 9   HIS A NE2 9   HIS A NE2 1 
ATOM 86    N N   . ILE A 1 10  ? 231.299 -65.892 267.862 1.0 42.25914  ? 10  ILE A N   10  ILE A N   1 
ATOM 87    C CA  . ILE A 1 10  ? 232.599 -65.651 267.253 1.0 42.25914  ? 10  ILE A CA  10  ILE A CA  1 
ATOM 88    C C   . ILE A 1 10  ? 232.521 -64.448 266.325 1.0 42.25914  ? 10  ILE A C   10  ILE A C   1 
ATOM 89    O O   . ILE A 1 10  ? 233.346 -63.531 266.393 1.0 42.25914  ? 10  ILE A O   10  ILE A O   1 
ATOM 90    C CB  . ILE A 1 10  ? 233.074 -66.916 266.520 1.0 42.25914  ? 10  ILE A CB  10  ILE A CB  1 
ATOM 91    C CG1 . ILE A 1 10  ? 233.428 -68.004 267.534 1.0 42.25914  ? 10  ILE A CG1 10  ILE A CG1 1 
ATOM 92    C CG2 . ILE A 1 10  ? 234.217 -66.613 265.582 1.0 42.25914  ? 10  ILE A CG2 10  ILE A CG2 1 
ATOM 93    C CD1 . ILE A 1 10  ? 233.668 -69.350 266.921 1.0 42.25914  ? 10  ILE A CD1 10  ILE A CD1 1 
ATOM 94    N N   . ALA A 1 11  ? 231.514 -64.426 265.460 1.0 42.97873  ? 11  ALA A N   11  ALA A N   1 
ATOM 95    C CA  . ALA A 1 11  ? 231.191 -63.279 264.628 1.0 42.97873  ? 11  ALA A CA  11  ALA A CA  1 
ATOM 96    C C   . ALA A 1 11  ? 229.693 -63.028 264.717 1.0 42.97873  ? 11  ALA A C   11  ALA A C   1 
ATOM 97    O O   . ALA A 1 11  ? 228.947 -63.810 265.311 1.0 42.97873  ? 11  ALA A O   11  ALA A O   1 
ATOM 98    C CB  . ALA A 1 11  ? 231.624 -63.503 263.176 1.0 42.97873  ? 11  ALA A CB  11  ALA A CB  1 
ATOM 99    N N   . GLY A 1 12  ? 229.243 -61.925 264.117 1.0 43.37105  ? 12  GLY A N   12  GLY A N   1 
ATOM 100   C CA  . GLY A 1 12  ? 227.835 -61.586 264.079 1.0 43.37105  ? 12  GLY A CA  12  GLY A CA  1 
ATOM 101   C C   . GLY A 1 12  ? 227.578 -60.210 264.673 1.0 43.37105  ? 12  GLY A C   12  GLY A C   1 
ATOM 102   O O   . GLY A 1 12  ? 228.291 -59.246 264.374 1.0 43.37105  ? 12  GLY A O   12  GLY A O   1 
ATOM 103   N N   . ARG A 1 13  ? 226.557 -60.130 265.516 1.0 42.27434  ? 13  ARG A N   13  ARG A N   1 
ATOM 104   C CA  . ARG A 1 13  ? 226.094 -58.860 266.049 1.0 42.27434  ? 13  ARG A CA  13  ARG A CA  1 
ATOM 105   C C   . ARG A 1 13  ? 226.755 -58.550 267.386 1.0 42.27434  ? 13  ARG A C   13  ARG A C   1 
ATOM 106   O O   . ARG A 1 13  ? 227.147 -59.447 268.133 1.0 42.27434  ? 13  ARG A O   13  ARG A O   1 
ATOM 107   C CB  . ARG A 1 13  ? 224.577 -58.877 266.211 1.0 42.27434  ? 13  ARG A CB  13  ARG A CB  1 
ATOM 108   C CG  . ARG A 1 13  ? 223.830 -58.959 264.899 1.0 42.27434  ? 13  ARG A CG  13  ARG A CG  1 
ATOM 109   C CD  . ARG A 1 13  ? 222.336 -59.004 265.125 1.0 42.27434  ? 13  ARG A CD  13  ARG A CD  1 
ATOM 110   N NE  . ARG A 1 13  ? 221.927 -60.242 265.776 1.0 42.27434  ? 13  ARG A NE  13  ARG A NE  1 
ATOM 111   C CZ  . ARG A 1 13  ? 220.696 -60.480 266.210 1.0 42.27434  ? 13  ARG A CZ  13  ARG A CZ  1 
ATOM 112   N NH1 . ARG A 1 13  ? 219.753 -59.563 266.060 1.0 42.27434  ? 13  ARG A NH1 13  ARG A NH1 1 
ATOM 113   N NH2 . ARG A 1 13  ? 220.406 -61.634 266.792 1.0 42.27434  ? 13  ARG A NH2 13  ARG A NH2 1 
ATOM 114   N N   . SER A 1 14  ? 226.863 -57.259 267.682 1.0 43.59332  ? 14  SER A N   14  SER A N   1 
ATOM 115   C CA  . SER A 1 14  ? 227.497 -56.798 268.904 1.0 43.59332  ? 14  SER A CA  14  SER A CA  1 
ATOM 116   C C   . SER A 1 14  ? 226.565 -56.985 270.096 1.0 43.59332  ? 14  SER A C   14  SER A C   1 
ATOM 117   O O   . SER A 1 14  ? 225.394 -57.338 269.951 1.0 43.59332  ? 14  SER A O   14  SER A O   1 
ATOM 118   C CB  . SER A 1 14  ? 227.909 -55.335 268.773 1.0 43.59332  ? 14  SER A CB  14  SER A CB  1 
ATOM 119   O OG  . SER A 1 14  ? 226.774 -54.501 268.641 1.0 43.59332  ? 14  SER A OG  14  SER A OG  1 
ATOM 120   N N   . ALA A 1 15  ? 227.099 -56.699 271.288 1.0 44.20948  ? 15  ALA A N   15  ALA A N   1 
ATOM 121   C CA  . ALA A 1 15  ? 226.447 -57.090 272.536 1.0 44.20948  ? 15  ALA A CA  15  ALA A CA  1 
ATOM 122   C C   . ALA A 1 15  ? 225.160 -56.322 272.792 1.0 44.20948  ? 15  ALA A C   15  ALA A C   1 
ATOM 123   O O   . ALA A 1 15  ? 224.248 -56.848 273.435 1.0 44.20948  ? 15  ALA A O   15  ALA A O   1 
ATOM 124   C CB  . ALA A 1 15  ? 227.406 -56.900 273.708 1.0 44.20948  ? 15  ALA A CB  15  ALA A CB  1 
ATOM 125   N N   . LYS A 1 16  ? 225.060 -55.093 272.299 1.0 45.91085  ? 16  LYS A N   16  LYS A N   1 
ATOM 126   C CA  . LYS A 1 16  ? 223.853 -54.299 272.450 1.0 45.91085  ? 16  LYS A CA  16  LYS A CA  1 
ATOM 127   C C   . LYS A 1 16  ? 222.870 -54.515 271.311 1.0 45.91085  ? 16  LYS A C   16  LYS A C   1 
ATOM 128   O O   . LYS A 1 16  ? 221.930 -53.728 271.157 1.0 45.91085  ? 16  LYS A O   16  LYS A O   1 
ATOM 129   C CB  . LYS A 1 16  ? 224.212 -52.819 272.565 1.0 45.91085  ? 16  LYS A CB  16  LYS A CB  1 
ATOM 130   C CG  . LYS A 1 16  ? 224.889 -52.256 271.334 1.0 45.91085  ? 16  LYS A CG  16  LYS A CG  1 
ATOM 131   C CD  . LYS A 1 16  ? 225.211 -50.788 271.517 1.0 45.91085  ? 16  LYS A CD  16  LYS A CD  1 
ATOM 132   C CE  . LYS A 1 16  ? 226.354 -50.602 272.499 1.0 45.91085  ? 16  LYS A CE  16  LYS A CE  1 
ATOM 133   N NZ  . LYS A 1 16  ? 226.770 -49.177 272.607 1.0 45.91085  ? 16  LYS A NZ  16  LYS A NZ  1 
ATOM 134   N N   . GLU A 1 17  ? 223.060 -55.563 270.515 1.0 45.38657  ? 17  GLU A N   17  GLU A N   1 
ATOM 135   C CA  . GLU A 1 17  ? 222.190 -55.842 269.382 1.0 45.38657  ? 17  GLU A CA  17  GLU A CA  1 
ATOM 136   C C   . GLU A 1 17  ? 221.437 -57.153 269.531 1.0 45.38657  ? 17  GLU A C   17  GLU A C   1 
ATOM 137   O O   . GLU A 1 17  ? 220.218 -57.178 269.334 1.0 45.38657  ? 17  GLU A O   17  GLU A O   1 
ATOM 138   C CB  . GLU A 1 17  ? 223.008 -55.839 268.086 1.0 45.38657  ? 17  GLU A CB  17  GLU A CB  1 
ATOM 139   C CG  . GLU A 1 17  ? 223.563 -54.469 267.735 1.0 45.38657  ? 17  GLU A CG  17  GLU A CG  1 
ATOM 140   C CD  . GLU A 1 17  ? 224.433 -54.481 266.494 1.0 45.38657  ? 17  GLU A CD  17  GLU A CD  1 
ATOM 141   O OE1 . GLU A 1 17  ? 224.694 -55.575 265.956 1.0 45.38657  ? 17  GLU A OE1 17  GLU A OE1 1 
ATOM 142   O OE2 . GLU A 1 17  ? 224.868 -53.393 266.062 1.0 45.38657  ? 17  GLU A OE2 17  GLU A OE2 1 
ATOM 143   N N   . TYR A 1 18  ? 222.116 -58.248 269.878 1.0 41.2827   ? 18  TYR A N   18  TYR A N   1 
ATOM 144   C CA  . TYR A 1 18  ? 221.395 -59.505 270.023 1.0 41.2827   ? 18  TYR A CA  18  TYR A CA  1 
ATOM 145   C C   . TYR A 1 18  ? 220.648 -59.603 271.342 1.0 41.2827   ? 18  TYR A C   18  TYR A C   1 
ATOM 146   O O   . TYR A 1 18  ? 219.714 -60.403 271.447 1.0 41.2827   ? 18  TYR A O   18  TYR A O   1 
ATOM 147   C CB  . TYR A 1 18  ? 222.330 -60.710 269.856 1.0 41.2827   ? 18  TYR A CB  18  TYR A CB  1 
ATOM 148   C CG  . TYR A 1 18  ? 223.433 -60.864 270.877 1.0 41.2827   ? 18  TYR A CG  18  TYR A CG  1 
ATOM 149   C CD1 . TYR A 1 18  ? 224.675 -60.301 270.661 1.0 41.2827   ? 18  TYR A CD1 18  TYR A CD1 1 
ATOM 150   C CD2 . TYR A 1 18  ? 223.250 -61.615 272.030 1.0 41.2827   ? 18  TYR A CD2 18  TYR A CD2 1 
ATOM 151   C CE1 . TYR A 1 18  ? 225.694 -60.451 271.570 1.0 41.2827   ? 18  TYR A CE1 18  TYR A CE1 1 
ATOM 152   C CE2 . TYR A 1 18  ? 224.265 -61.765 272.949 1.0 41.2827   ? 18  TYR A CE2 18  TYR A CE2 1 
ATOM 153   C CZ  . TYR A 1 18  ? 225.484 -61.177 272.710 1.0 41.2827   ? 18  TYR A CZ  18  TYR A CZ  1 
ATOM 154   O OH  . TYR A 1 18  ? 226.506 -61.319 273.612 1.0 41.2827   ? 18  TYR A OH  18  TYR A OH  1 
ATOM 155   N N   . LEU A 1 19  ? 221.031 -58.823 272.346 1.0 39.72751  ? 19  LEU A N   19  LEU A N   1 
ATOM 156   C CA  . LEU A 1 19  ? 220.245 -58.781 273.564 1.0 39.72751  ? 19  LEU A CA  19  LEU A CA  1 
ATOM 157   C C   . LEU A 1 19  ? 218.955 -58.011 273.326 1.0 39.72751  ? 19  LEU A C   19  LEU A C   1 
ATOM 158   O O   . LEU A 1 19  ? 218.855 -57.182 272.421 1.0 39.72751  ? 19  LEU A O   19  LEU A O   1 
ATOM 159   C CB  . LEU A 1 19  ? 221.027 -58.133 274.700 1.0 39.72751  ? 19  LEU A CB  19  LEU A CB  1 
ATOM 160   C CG  . LEU A 1 19  ? 222.244 -58.904 275.187 1.0 39.72751  ? 19  LEU A CG  19  LEU A CG  1 
ATOM 161   C CD1 . LEU A 1 19  ? 222.953 -58.120 276.265 1.0 39.72751  ? 19  LEU A CD1 19  LEU A CD1 1 
ATOM 162   C CD2 . LEU A 1 19  ? 221.824 -60.255 275.693 1.0 39.72751  ? 19  LEU A CD2 19  LEU A CD2 1 
ATOM 163   N N   . SER A 1 20  ? 217.955 -58.309 274.146 1.0 41.09156  ? 20  SER A N   20  SER A N   1 
ATOM 164   C CA  . SER A 1 20  ? 216.685 -57.612 274.047 1.0 41.09156  ? 20  SER A CA  20  SER A CA  1 
ATOM 165   C C   . SER A 1 20  ? 216.836 -56.181 274.536 1.0 41.09156  ? 20  SER A C   20  SER A C   1 
ATOM 166   O O   . SER A 1 20  ? 217.618 -55.891 275.442 1.0 41.09156  ? 20  SER A O   20  SER A O   1 
ATOM 167   C CB  . SER A 1 20  ? 215.617 -58.336 274.856 1.0 41.09156  ? 20  SER A CB  20  SER A CB  1 
ATOM 168   O OG  . SER A 1 20  ? 215.936 -58.306 276.230 1.0 41.09156  ? 20  SER A OG  20  SER A OG  1 
ATOM 169   N N   . GLU A 1 21  ? 216.070 -55.279 273.924 1.0 45.91167  ? 21  GLU A N   21  GLU A N   1 
ATOM 170   C CA  . GLU A 1 21  ? 216.248 -53.854 274.161 1.0 45.91167  ? 21  GLU A CA  21  GLU A CA  1 
ATOM 171   C C   . GLU A 1 21  ? 215.752 -53.403 275.524 1.0 45.91167  ? 21  GLU A C   21  GLU A C   1 
ATOM 172   O O   . GLU A 1 21  ? 216.047 -52.273 275.920 1.0 45.91167  ? 21  GLU A O   21  GLU A O   1 
ATOM 173   C CB  . GLU A 1 21  ? 215.549 -53.051 273.067 1.0 45.91167  ? 21  GLU A CB  21  GLU A CB  1 
ATOM 174   C CG  . GLU A 1 21  ? 216.161 -53.247 271.692 1.0 45.91167  ? 21  GLU A CG  21  GLU A CG  1 
ATOM 175   C CD  . GLU A 1 21  ? 217.564 -52.680 271.587 1.0 45.91167  ? 21  GLU A CD  21  GLU A CD  1 
ATOM 176   O OE1 . GLU A 1 21  ? 217.843 -51.649 272.237 1.0 45.91167  ? 21  GLU A OE1 21  GLU A OE1 1 
ATOM 177   O OE2 . GLU A 1 21  ? 218.391 -53.267 270.858 1.0 45.91167  ? 21  GLU A OE2 21  GLU A OE2 1 
ATOM 178   N N   . ASN A 1 22  ? 215.008 -54.239 276.246 1.0 43.8857   ? 22  ASN A N   22  ASN A N   1 
ATOM 179   C CA  . ASN A 1 22  ? 214.680 -53.912 277.626 1.0 43.8857   ? 22  ASN A CA  22  ASN A CA  1 
ATOM 180   C C   . ASN A 1 22  ? 215.777 -54.350 278.581 1.0 43.8857   ? 22  ASN A C   22  ASN A C   1 
ATOM 181   O O   . ASN A 1 22  ? 215.964 -53.723 279.628 1.0 43.8857   ? 22  ASN A O   22  ASN A O   1 
ATOM 182   C CB  . ASN A 1 22  ? 213.357 -54.555 278.025 1.0 43.8857   ? 22  ASN A CB  22  ASN A CB  1 
ATOM 183   C CG  . ASN A 1 22  ? 212.195 -54.026 277.230 1.0 43.8857   ? 22  ASN A CG  22  ASN A CG  1 
ATOM 184   O OD1 . ASN A 1 22  ? 211.558 -54.763 276.480 1.0 43.8857   ? 22  ASN A OD1 22  ASN A OD1 1 
ATOM 185   N ND2 . ASN A 1 22  ? 211.910 -52.741 277.383 1.0 43.8857   ? 22  ASN A ND2 22  ASN A ND2 1 
ATOM 186   N N   . LEU A 1 23  ? 216.511 -55.411 278.241 1.0 41.9571   ? 23  LEU A N   23  LEU A N   1 
ATOM 187   C CA  . LEU A 1 23  ? 217.595 -55.867 279.105 1.0 41.9571   ? 23  LEU A CA  23  LEU A CA  1 
ATOM 188   C C   . LEU A 1 23  ? 218.786 -54.924 279.033 1.0 41.9571   ? 23  LEU A C   23  LEU A C   1 
ATOM 189   O O   . LEU A 1 23  ? 219.473 -54.708 280.038 1.0 41.9571   ? 23  LEU A O   23  LEU A O   1 
ATOM 190   C CB  . LEU A 1 23  ? 218.011 -57.284 278.722 1.0 41.9571   ? 23  LEU A CB  23  LEU A CB  1 
ATOM 191   C CG  . LEU A 1 23  ? 219.093 -57.932 279.578 1.0 41.9571   ? 23  LEU A CG  23  LEU A CG  1 
ATOM 192   C CD1 . LEU A 1 23  ? 218.606 -58.067 280.999 1.0 41.9571   ? 23  LEU A CD1 23  LEU A CD1 1 
ATOM 193   C CD2 . LEU A 1 23  ? 219.476 -59.277 279.017 1.0 41.9571   ? 23  LEU A CD2 23  LEU A CD2 1 
ATOM 194   N N   . VAL A 1 24  ? 219.038 -54.350 277.857 1.0 41.87937  ? 24  VAL A N   24  VAL A N   1 
ATOM 195   C CA  . VAL A 1 24  ? 220.135 -53.402 277.701 1.0 41.87937  ? 24  VAL A CA  24  VAL A CA  1 
ATOM 196   C C   . VAL A 1 24  ? 219.850 -52.128 278.484 1.0 41.87937  ? 24  VAL A C   24  VAL A C   1 
ATOM 197   O O   . VAL A 1 24  ? 220.748 -51.547 279.103 1.0 41.87937  ? 24  VAL A O   24  VAL A O   1 
ATOM 198   C CB  . VAL A 1 24  ? 220.369 -53.123 276.206 1.0 41.87937  ? 24  VAL A CB  24  VAL A CB  1 
ATOM 199   C CG1 . VAL A 1 24  ? 221.490 -52.126 276.002 1.0 41.87937  ? 24  VAL A CG1 24  VAL A CG1 1 
ATOM 200   C CG2 . VAL A 1 24  ? 220.674 -54.413 275.480 1.0 41.87937  ? 24  VAL A CG2 24  VAL A CG2 1 
ATOM 201   N N   . GLN A 1 25  ? 218.586 -51.707 278.523 1.0 44.40939  ? 25  GLN A N   25  GLN A N   1 
ATOM 202   C CA  . GLN A 1 25  ? 218.212 -50.549 279.324 1.0 44.40939  ? 25  GLN A CA  25  GLN A CA  1 
ATOM 203   C C   . GLN A 1 25  ? 218.225 -50.851 280.814 1.0 44.40939  ? 25  GLN A C   25  GLN A C   1 
ATOM 204   O O   . GLN A 1 25  ? 218.246 -49.917 281.620 1.0 44.40939  ? 25  GLN A O   25  GLN A O   1 
ATOM 205   C CB  . GLN A 1 25  ? 216.836 -50.045 278.901 1.0 44.40939  ? 25  GLN A CB  25  GLN A CB  1 
ATOM 206   C CG  . GLN A 1 25  ? 216.805 -49.466 277.503 1.0 44.40939  ? 25  GLN A CG  25  GLN A CG  1 
ATOM 207   C CD  . GLN A 1 25  ? 215.419 -49.033 277.086 1.0 44.40939  ? 25  GLN A CD  25  GLN A CD  1 
ATOM 208   O OE1 . GLN A 1 25  ? 214.450 -49.225 277.818 1.0 44.40939  ? 25  GLN A OE1 25  GLN A OE1 1 
ATOM 209   N NE2 . GLN A 1 25  ? 215.316 -48.444 275.903 1.0 44.40939  ? 25  GLN A NE2 25  GLN A NE2 1 
ATOM 210   N N   . PHE A 1 26  ? 218.209 -52.127 281.198 1.0 43.17829  ? 26  PHE A N   26  PHE A N   1 
ATOM 211   C CA  . PHE A 1 26  ? 218.368 -52.483 282.601 1.0 43.17829  ? 26  PHE A CA  26  PHE A CA  1 
ATOM 212   C C   . PHE A 1 26  ? 219.828 -52.423 283.022 1.0 43.17829  ? 26  PHE A C   26  PHE A C   1 
ATOM 213   O O   . PHE A 1 26  ? 220.153 -51.840 284.060 1.0 43.17829  ? 26  PHE A O   26  PHE A O   1 
ATOM 214   C CB  . PHE A 1 26  ? 217.807 -53.879 282.857 1.0 43.17829  ? 26  PHE A CB  26  PHE A CB  1 
ATOM 215   C CG  . PHE A 1 26  ? 217.850 -54.293 284.293 1.0 43.17829  ? 26  PHE A CG  26  PHE A CG  1 
ATOM 216   C CD1 . PHE A 1 26  ? 216.900 -53.833 285.183 1.0 43.17829  ? 26  PHE A CD1 26  PHE A CD1 1 
ATOM 217   C CD2 . PHE A 1 26  ? 218.842 -55.139 284.757 1.0 43.17829  ? 26  PHE A CD2 26  PHE A CD2 1 
ATOM 218   C CE1 . PHE A 1 26  ? 216.934 -54.212 286.507 1.0 43.17829  ? 26  PHE A CE1 26  PHE A CE1 1 
ATOM 219   C CE2 . PHE A 1 26  ? 218.888 -55.510 286.084 1.0 43.17829  ? 26  PHE A CE2 26  PHE A CE2 1 
ATOM 220   C CZ  . PHE A 1 26  ? 217.926 -55.055 286.956 1.0 43.17829  ? 26  PHE A CZ  26  PHE A CZ  1 
ATOM 221   N N   . ILE A 1 27  ? 220.726 -53.007 282.221 1.0 44.05866  ? 27  ILE A N   27  ILE A N   1 
ATOM 222   C CA  . ILE A 1 27  ? 222.129 -53.114 282.602 1.0 44.05866  ? 27  ILE A CA  27  ILE A CA  1 
ATOM 223   C C   . ILE A 1 27  ? 222.903 -51.826 282.370 1.0 44.05866  ? 27  ILE A C   27  ILE A C   1 
ATOM 224   O O   . ILE A 1 27  ? 224.105 -51.779 282.660 1.0 44.05866  ? 27  ILE A O   27  ILE A O   1 
ATOM 225   C CB  . ILE A 1 27  ? 222.813 -54.272 281.853 1.0 44.05866  ? 27  ILE A CB  27  ILE A CB  1 
ATOM 226   C CG1 . ILE A 1 27  ? 222.865 -53.987 280.360 1.0 44.05866  ? 27  ILE A CG1 27  ILE A CG1 1 
ATOM 227   C CG2 . ILE A 1 27  ? 222.051 -55.551 282.067 1.0 44.05866  ? 27  ILE A CG2 27  ILE A CG2 1 
ATOM 228   C CD1 . ILE A 1 27  ? 223.689 -54.988 279.587 1.0 44.05866  ? 27  ILE A CD1 27  ILE A CD1 1 
ATOM 229   N N   . GLN A 1 28  ? 222.262 -50.788 281.842 1.0 47.18165  ? 28  GLN A N   28  GLN A N   1 
ATOM 230   C CA  . GLN A 1 28  ? 222.843 -49.454 281.827 1.0 47.18165  ? 28  GLN A CA  28  GLN A CA  1 
ATOM 231   C C   . GLN A 1 28  ? 222.372 -48.603 282.989 1.0 47.18165  ? 28  GLN A C   28  GLN A C   1 
ATOM 232   O O   . GLN A 1 28  ? 223.074 -47.667 283.381 1.0 47.18165  ? 28  GLN A O   28  GLN A O   1 
ATOM 233   C CB  . GLN A 1 28  ? 222.510 -48.733 280.519 1.0 47.18165  ? 28  GLN A CB  28  GLN A CB  1 
ATOM 234   C CG  . GLN A 1 28  ? 223.188 -49.313 279.298 1.0 47.18165  ? 28  GLN A CG  28  GLN A CG  1 
ATOM 235   C CD  . GLN A 1 28  ? 222.806 -48.581 278.032 1.0 47.18165  ? 28  GLN A CD  28  GLN A CD  1 
ATOM 236   O OE1 . GLN A 1 28  ? 221.987 -47.663 278.056 1.0 47.18165  ? 28  GLN A OE1 28  GLN A OE1 1 
ATOM 237   N NE2 . GLN A 1 28  ? 223.393 -48.987 276.913 1.0 47.18165  ? 28  GLN A NE2 28  GLN A NE2 1 
ATOM 238   N N   . ALA A 1 29  ? 221.198 -48.901 283.541 1.0 45.8107   ? 29  ALA A N   29  ALA A N   1 
ATOM 239   C CA  . ALA A 1 29  ? 220.752 -48.226 284.752 1.0 45.8107   ? 29  ALA A CA  29  ALA A CA  1 
ATOM 240   C C   . ALA A 1 29  ? 221.473 -48.785 285.969 1.0 45.8107   ? 29  ALA A C   29  ALA A C   1 
ATOM 241   O O   . ALA A 1 29  ? 222.179 -48.060 286.676 1.0 45.8107   ? 29  ALA A O   29  ALA A O   1 
ATOM 242   C CB  . ALA A 1 29  ? 219.238 -48.365 284.906 1.0 45.8107   ? 29  ALA A CB  29  ALA A CB  1 
ATOM 243   N N   . THR A 1 30  ? 221.314 -50.082 286.222 1.0 47.38698  ? 30  THR A N   30  THR A N   1 
ATOM 244   C CA  . THR A 1 30  ? 222.042 -50.756 287.294 1.0 47.38698  ? 30  THR A CA  30  THR A CA  1 
ATOM 245   C C   . THR A 1 30  ? 223.418 -51.115 286.751 1.0 47.38698  ? 30  THR A C   30  THR A C   1 
ATOM 246   O O   . THR A 1 30  ? 223.665 -52.221 286.270 1.0 47.38698  ? 30  THR A O   30  THR A O   1 
ATOM 247   C CB  . THR A 1 30  ? 221.301 -51.997 287.765 1.0 47.38698  ? 30  THR A CB  30  THR A CB  1 
ATOM 248   O OG1 . THR A 1 30  ? 221.321 -52.980 286.726 1.0 47.38698  ? 30  THR A OG1 30  THR A OG1 1 
ATOM 249   C CG2 . THR A 1 30  ? 219.861 -51.661 288.076 1.0 47.38698  ? 30  THR A CG2 30  THR A CG2 1 
ATOM 250   N N   . GLN A 1 31  ? 224.325 -50.146 286.799 1.0 50.15399  ? 31  GLN A N   31  GLN A N   1 
ATOM 251   C CA  . GLN A 1 31  ? 225.664 -50.381 286.280 1.0 50.15399  ? 31  GLN A CA  31  GLN A CA  1 
ATOM 252   C C   . GLN A 1 31  ? 226.706 -49.977 287.310 1.0 50.15399  ? 31  GLN A C   31  GLN A C   1 
ATOM 253   O O   . GLN A 1 31  ? 227.779 -50.581 287.393 1.0 50.15399  ? 31  GLN A O   31  GLN A O   1 
ATOM 254   C CB  . GLN A 1 31  ? 225.869 -49.613 284.974 1.0 50.15399  ? 31  GLN A CB  31  GLN A CB  1 
ATOM 255   C CG  . GLN A 1 31  ? 227.170 -49.916 284.260 1.0 50.15399  ? 31  GLN A CG  31  GLN A CG  1 
ATOM 256   C CD  . GLN A 1 31  ? 227.306 -49.150 282.968 1.0 50.15399  ? 31  GLN A CD  31  GLN A CD  1 
ATOM 257   O OE1 . GLN A 1 31  ? 226.440 -48.353 282.613 1.0 50.15399  ? 31  GLN A OE1 31  GLN A OE1 1 
ATOM 258   N NE2 . GLN A 1 31  ? 228.400 -49.382 282.255 1.0 50.15399  ? 31  GLN A NE2 31  GLN A NE2 1 
ATOM 259   N N   . ASN A 1 32  ? 226.389 -48.970 288.118 1.0 51.72112  ? 32  ASN A N   32  ASN A N   1 
ATOM 260   C CA  . ASN A 1 32  ? 227.349 -48.481 289.093 1.0 51.72112  ? 32  ASN A CA  32  ASN A CA  1 
ATOM 261   C C   . ASN A 1 32  ? 227.465 -49.383 290.312 1.0 51.72112  ? 32  ASN A C   32  ASN A C   1 
ATOM 262   O O   . ASN A 1 32  ? 228.428 -49.248 291.072 1.0 51.72112  ? 32  ASN A O   32  ASN A O   1 
ATOM 263   C CB  . ASN A 1 32  ? 226.976 -47.066 289.532 1.0 51.72112  ? 32  ASN A CB  32  ASN A CB  1 
ATOM 264   C CG  . ASN A 1 32  ? 227.178 -46.046 288.431 1.0 51.72112  ? 32  ASN A CG  32  ASN A CG  1 
ATOM 265   O OD1 . ASN A 1 32  ? 228.162 -46.098 287.696 1.0 51.72112  ? 32  ASN A OD1 32  ASN A OD1 1 
ATOM 266   N ND2 . ASN A 1 32  ? 226.246 -45.109 288.314 1.0 51.72112  ? 32  ASN A ND2 32  ASN A ND2 1 
ATOM 267   N N   . TYR A 1 33  ? 226.521 -50.299 290.517 1.0 48.7631   ? 33  TYR A N   33  TYR A N   1 
ATOM 268   C CA  . TYR A 1 33  ? 226.549 -51.152 291.693 1.0 48.7631   ? 33  TYR A CA  33  TYR A CA  1 
ATOM 269   C C   . TYR A 1 33  ? 226.281 -52.623 291.418 1.0 48.7631   ? 33  TYR A C   33  TYR A C   1 
ATOM 270   O O   . TYR A 1 33  ? 226.533 -53.446 292.303 1.0 48.7631   ? 33  TYR A O   33  TYR A O   1 
ATOM 271   C CB  . TYR A 1 33  ? 225.548 -50.647 292.745 1.0 48.7631   ? 33  TYR A CB  33  TYR A CB  1 
ATOM 272   C CG  . TYR A 1 33  ? 224.098 -50.625 292.315 1.0 48.7631   ? 33  TYR A CG  33  TYR A CG  1 
ATOM 273   C CD1 . TYR A 1 33  ? 223.562 -49.519 291.673 1.0 48.7631   ? 33  TYR A CD1 33  TYR A CD1 1 
ATOM 274   C CD2 . TYR A 1 33  ? 223.254 -51.690 292.594 1.0 48.7631   ? 33  TYR A CD2 33  TYR A CD2 1 
ATOM 275   C CE1 . TYR A 1 33  ? 222.237 -49.488 291.293 1.0 48.7631   ? 33  TYR A CE1 33  TYR A CE1 1 
ATOM 276   C CE2 . TYR A 1 33  ? 221.929 -51.668 292.218 1.0 48.7631   ? 33  TYR A CE2 33  TYR A CE2 1 
ATOM 277   C CZ  . TYR A 1 33  ? 221.428 -50.565 291.569 1.0 48.7631   ? 33  TYR A CZ  33  TYR A CZ  1 
ATOM 278   O OH  . TYR A 1 33  ? 220.107 -50.539 291.198 1.0 48.7631   ? 33  TYR A OH  33  TYR A OH  1 
ATOM 279   N N   . PHE A 1 34  ? 225.788 -52.986 290.238 1.0 48.95546  ? 34  PHE A N   34  PHE A N   1 
ATOM 280   C CA  . PHE A 1 34  ? 225.506 -54.391 289.947 1.0 48.95546  ? 34  PHE A CA  34  PHE A CA  1 
ATOM 281   C C   . PHE A 1 34  ? 225.738 -54.593 288.449 1.0 48.95546  ? 34  PHE A C   34  PHE A C   1 
ATOM 282   O O   . PHE A 1 34  ? 224.824 -54.436 287.641 1.0 48.95546  ? 34  PHE A O   34  PHE A O   1 
ATOM 283   C CB  . PHE A 1 34  ? 224.088 -54.742 290.370 1.0 48.95546  ? 34  PHE A CB  34  PHE A CB  1 
ATOM 284   C CG  . PHE A 1 34  ? 223.733 -56.183 290.194 1.0 48.95546  ? 34  PHE A CG  34  PHE A CG  1 
ATOM 285   C CD1 . PHE A 1 34  ? 224.334 -57.157 290.976 1.0 48.95546  ? 34  PHE A CD1 34  PHE A CD1 1 
ATOM 286   C CD2 . PHE A 1 34  ? 222.753 -56.559 289.293 1.0 48.95546  ? 34  PHE A CD2 34  PHE A CD2 1 
ATOM 287   C CE1 . PHE A 1 34  ? 223.996 -58.486 290.830 1.0 48.95546  ? 34  PHE A CE1 34  PHE A CE1 1 
ATOM 288   C CE2 . PHE A 1 34  ? 222.403 -57.882 289.148 1.0 48.95546  ? 34  PHE A CE2 34  PHE A CE2 1 
ATOM 289   C CZ  . PHE A 1 34  ? 223.029 -58.848 289.913 1.0 48.95546  ? 34  PHE A CZ  34  PHE A CZ  1 
ATOM 290   N N   . ASN A 1 35  ? 226.964 -54.971 288.099 1.0 47.48311  ? 35  ASN A N   35  ASN A N   1 
ATOM 291   C CA  . ASN A 1 35  ? 227.409 -54.969 286.711 1.0 47.48311  ? 35  ASN A CA  35  ASN A CA  1 
ATOM 292   C C   . ASN A 1 35  ? 227.082 -56.311 286.066 1.0 47.48311  ? 35  ASN A C   35  ASN A C   1 
ATOM 293   O O   . ASN A 1 35  ? 227.446 -57.366 286.594 1.0 47.48311  ? 35  ASN A O   35  ASN A O   1 
ATOM 294   C CB  . ASN A 1 35  ? 228.907 -54.684 286.629 1.0 47.48311  ? 35  ASN A CB  35  ASN A CB  1 
ATOM 295   C CG  . ASN A 1 35  ? 229.352 -54.305 285.230 1.0 47.48311  ? 35  ASN A CG  35  ASN A CG  1 
ATOM 296   O OD1 . ASN A 1 35  ? 228.540 -54.203 284.314 1.0 47.48311  ? 35  ASN A OD1 35  ASN A OD1 1 
ATOM 297   N ND2 . ASN A 1 35  ? 230.653 -54.104 285.058 1.0 47.48311  ? 35  ASN A ND2 35  ASN A ND2 1 
ATOM 298   N N   . ILE A 1 36  ? 226.395 -56.264 284.926 1.0 44.279    ? 36  ILE A N   36  ILE A N   1 
ATOM 299   C CA  . ILE A 1 36  ? 226.049 -57.460 284.180 1.0 44.279    ? 36  ILE A CA  36  ILE A CA  1 
ATOM 300   C C   . ILE A 1 36  ? 226.718 -57.496 282.808 1.0 44.279    ? 36  ILE A C   36  ILE A C   1 
ATOM 301   O O   . ILE A 1 36  ? 227.078 -58.581 282.335 1.0 44.279    ? 36  ILE A O   36  ILE A O   1 
ATOM 302   C CB  . ILE A 1 36  ? 224.513 -57.580 284.052 1.0 44.279    ? 36  ILE A CB  36  ILE A CB  1 
ATOM 303   C CG1 . ILE A 1 36  ? 223.874 -57.591 285.432 1.0 44.279    ? 36  ILE A CG1 36  ILE A CG1 1 
ATOM 304   C CG2 . ILE A 1 36  ? 224.078 -58.858 283.352 1.0 44.279    ? 36  ILE A CG2 36  ILE A CG2 1 
ATOM 305   C CD1 . ILE A 1 36  ? 224.357 -58.725 286.276 1.0 44.279    ? 36  ILE A CD1 36  ILE A CD1 1 
ATOM 306   N N   . GLY A 1 37  ? 226.993 -56.342 282.203 1.0 43.00372  ? 37  GLY A N   37  GLY A N   1 
ATOM 307   C CA  . GLY A 1 37  ? 227.472 -56.261 280.833 1.0 43.00372  ? 37  GLY A CA  37  GLY A CA  1 
ATOM 308   C C   . GLY A 1 37  ? 228.836 -56.845 280.516 1.0 43.00372  ? 37  GLY A C   37  GLY A C   1 
ATOM 309   O O   . GLY A 1 37  ? 229.276 -56.795 279.365 1.0 43.00372  ? 37  GLY A O   37  GLY A O   1 
ATOM 310   N N   . GLU A 1 38  ? 229.517 -57.399 281.515 1.0 42.60742  ? 38  GLU A N   38  GLU A N   1 
ATOM 311   C CA  . GLU A 1 38  ? 230.720 -58.183 281.300 1.0 42.60742  ? 38  GLU A CA  38  GLU A CA  1 
ATOM 312   C C   . GLU A 1 38  ? 230.432 -59.672 281.234 1.0 42.60742  ? 38  GLU A C   38  GLU A C   1 
ATOM 313   O O   . GLU A 1 38  ? 231.369 -60.469 281.141 1.0 42.60742  ? 38  GLU A O   38  GLU A O   1 
ATOM 314   C CB  . GLU A 1 38  ? 231.744 -57.899 282.401 1.0 42.60742  ? 38  GLU A CB  38  GLU A CB  1 
ATOM 315   C CG  . GLU A 1 38  ? 232.268 -56.478 282.384 1.0 42.60742  ? 38  GLU A CG  38  GLU A CG  1 
ATOM 316   C CD  . GLU A 1 38  ? 233.094 -56.175 281.150 1.0 42.60742  ? 38  GLU A CD  38  GLU A CD  1 
ATOM 317   O OE1 . GLU A 1 38  ? 233.795 -57.084 280.659 1.0 42.60742  ? 38  GLU A OE1 38  GLU A OE1 1 
ATOM 318   O OE2 . GLU A 1 38  ? 233.036 -55.027 280.665 1.0 42.60742  ? 38  GLU A OE2 38  GLU A OE2 1 
ATOM 319   N N   . LYS A 1 39  ? 229.164 -60.066 281.287 1.0 39.70621  ? 39  LYS A N   39  LYS A N   1 
ATOM 320   C CA  . LYS A 1 39  ? 228.768 -61.457 281.145 1.0 39.70621  ? 39  LYS A CA  39  LYS A CA  1 
ATOM 321   C C   . LYS A 1 39  ? 228.240 -61.759 279.755 1.0 39.70621  ? 39  LYS A C   39  LYS A C   1 
ATOM 322   O O   . LYS A 1 39  ? 227.615 -62.803 279.554 1.0 39.70621  ? 39  LYS A O   39  LYS A O   1 
ATOM 323   C CB  . LYS A 1 39  ? 227.711 -61.810 282.188 1.0 39.70621  ? 39  LYS A CB  39  LYS A CB  1 
ATOM 324   C CG  . LYS A 1 39  ? 228.198 -61.649 283.607 1.0 39.70621  ? 39  LYS A CG  39  LYS A CG  1 
ATOM 325   C CD  . LYS A 1 39  ? 227.149 -62.061 284.608 1.0 39.70621  ? 39  LYS A CD  39  LYS A CD  1 
ATOM 326   C CE  . LYS A 1 39  ? 227.608 -61.746 286.005 1.0 39.70621  ? 39  LYS A CE  39  LYS A CE  1 
ATOM 327   N NZ  . LYS A 1 39  ? 228.798 -62.527 286.379 1.0 39.70621  ? 39  LYS A NZ  39  LYS A NZ  1 
ATOM 328   N N   . PHE A 1 40  ? 228.466 -60.869 278.795 1.0 40.00552  ? 40  PHE A N   40  PHE A N   1 
ATOM 329   C CA  . PHE A 1 40  ? 227.953 -61.029 277.444 1.0 40.00552  ? 40  PHE A CA  40  PHE A CA  1 
ATOM 330   C C   . PHE A 1 40  ? 229.075 -60.756 276.458 1.0 40.00552  ? 40  PHE A C   40  PHE A C   1 
ATOM 331   O O   . PHE A 1 40  ? 229.606 -59.643 276.408 1.0 40.00552  ? 40  PHE A O   40  PHE A O   1 
ATOM 332   C CB  . PHE A 1 40  ? 226.763 -60.106 277.199 1.0 40.00552  ? 40  PHE A CB  40  PHE A CB  1 
ATOM 333   C CG  . PHE A 1 40  ? 225.563 -60.459 278.019 1.0 40.00552  ? 40  PHE A CG  40  PHE A CG  1 
ATOM 334   C CD1 . PHE A 1 40  ? 224.737 -61.500 277.642 1.0 40.00552  ? 40  PHE A CD1 40  PHE A CD1 1 
ATOM 335   C CD2 . PHE A 1 40  ? 225.269 -59.763 279.175 1.0 40.00552  ? 40  PHE A CD2 40  PHE A CD2 1 
ATOM 336   C CE1 . PHE A 1 40  ? 223.637 -61.835 278.401 1.0 40.00552  ? 40  PHE A CE1 40  PHE A CE1 1 
ATOM 337   C CE2 . PHE A 1 40  ? 224.169 -60.094 279.934 1.0 40.00552  ? 40  PHE A CE2 40  PHE A CE2 1 
ATOM 338   C CZ  . PHE A 1 40  ? 223.354 -61.130 279.546 1.0 40.00552  ? 40  PHE A CZ  40  PHE A CZ  1 
ATOM 339   N N   . ARG A 1 41  ? 229.432 -61.775 275.686 1.0 40.98419  ? 41  ARG A N   41  ARG A N   1 
ATOM 340   C CA  . ARG A 1 41  ? 230.577 -61.707 274.794 1.0 40.98419  ? 41  ARG A CA  41  ARG A CA  1 
ATOM 341   C C   . ARG A 1 41  ? 230.263 -60.832 273.587 1.0 40.98419  ? 41  ARG A C   41  ARG A C   1 
ATOM 342   O O   . ARG A 1 41  ? 229.151 -60.839 273.057 1.0 40.98419  ? 41  ARG A O   41  ARG A O   1 
ATOM 343   C CB  . ARG A 1 41  ? 230.966 -63.119 274.359 1.0 40.98419  ? 41  ARG A CB  41  ARG A CB  1 
ATOM 344   C CG  . ARG A 1 41  ? 232.190 -63.222 273.498 1.0 40.98419  ? 41  ARG A CG  41  ARG A CG  1 
ATOM 345   C CD  . ARG A 1 41  ? 233.438 -62.846 274.251 1.0 40.98419  ? 41  ARG A CD  41  ARG A CD  1 
ATOM 346   N NE  . ARG A 1 41  ? 234.588 -62.915 273.362 1.0 40.98419  ? 41  ARG A NE  41  ARG A NE  1 
ATOM 347   C CZ  . ARG A 1 41  ? 235.791 -62.444 273.657 1.0 40.98419  ? 41  ARG A CZ  41  ARG A CZ  1 
ATOM 348   N NH1 . ARG A 1 41  ? 236.007 -61.865 274.829 1.0 40.98419  ? 41  ARG A NH1 41  ARG A NH1 1 
ATOM 349   N NH2 . ARG A 1 41  ? 236.774 -62.547 272.776 1.0 40.98419  ? 41  ARG A NH2 41  ARG A NH2 1 
ATOM 350   N N   . ASP A 1 42  ? 231.260 -60.059 273.163 1.0 42.04052  ? 42  ASP A N   42  ASP A N   1 
ATOM 351   C CA  . ASP A 1 42  ? 231.111 -59.099 272.076 1.0 42.04052  ? 42  ASP A CA  42  ASP A CA  1 
ATOM 352   C C   . ASP A 1 42  ? 232.137 -59.418 270.998 1.0 42.04052  ? 42  ASP A C   42  ASP A C   1 
ATOM 353   O O   . ASP A 1 42  ? 233.351 -59.415 271.284 1.0 42.04052  ? 42  ASP A O   42  ASP A O   1 
ATOM 354   C CB  . ASP A 1 42  ? 231.295 -57.679 272.608 1.0 42.04052  ? 42  ASP A CB  42  ASP A CB  1 
ATOM 355   C CG  . ASP A 1 42  ? 230.976 -56.630 271.582 1.0 42.04052  ? 42  ASP A CG  42  ASP A CG  1 
ATOM 356   O OD1 . ASP A 1 42  ? 229.778 -56.408 271.323 1.0 42.04052  ? 42  ASP A OD1 42  ASP A OD1 1 
ATOM 357   O OD2 . ASP A 1 42  ? 231.922 -56.027 271.034 1.0 42.04052  ? 42  ASP A OD2 42  ASP A OD2 1 
ATOM 358   N N   . PRO A 1 43  ? 231.722 -59.695 269.766 1.0 40.82852  ? 43  PRO A N   43  PRO A N   1 
ATOM 359   C CA  . PRO A 1 43  ? 232.687 -60.059 268.726 1.0 40.82852  ? 43  PRO A CA  43  PRO A CA  1 
ATOM 360   C C   . PRO A 1 43  ? 233.461 -58.852 268.222 1.0 40.82852  ? 43  PRO A C   43  PRO A C   1 
ATOM 361   O O   . PRO A 1 43  ? 233.023 -57.706 268.318 1.0 40.82852  ? 43  PRO A O   43  PRO A O   1 
ATOM 362   C CB  . PRO A 1 43  ? 231.807 -60.649 267.622 1.0 40.82852  ? 43  PRO A CB  43  PRO A CB  1 
ATOM 363   C CG  . PRO A 1 43  ? 230.508 -59.982 267.803 1.0 40.82852  ? 43  PRO A CG  43  PRO A CG  1 
ATOM 364   C CD  . PRO A 1 43  ? 230.337 -59.771 269.277 1.0 40.82852  ? 43  PRO A CD  43  PRO A CD  1 
ATOM 365   N N   . TYR A 1 44  ? 234.639 -59.135 267.667 1.0 41.50439  ? 44  TYR A N   44  TYR A N   1 
ATOM 366   C CA  . TYR A 1 44  ? 235.538 -58.089 267.182 1.0 41.50439  ? 44  TYR A CA  44  TYR A CA  1 
ATOM 367   C C   . TYR A 1 44  ? 236.219 -58.646 265.936 1.0 41.50439  ? 44  TYR A C   44  TYR A C   1 
ATOM 368   O O   . TYR A 1 44  ? 237.075 -59.528 266.036 1.0 41.50439  ? 44  TYR A O   44  TYR A O   1 
ATOM 369   C CB  . TYR A 1 44  ? 236.533 -57.694 268.262 1.0 41.50439  ? 44  TYR A CB  44  TYR A CB  1 
ATOM 370   C CG  . TYR A 1 44  ? 237.456 -56.564 267.896 1.0 41.50439  ? 44  TYR A CG  44  TYR A CG  1 
ATOM 371   C CD1 . TYR A 1 44  ? 236.973 -55.278 267.727 1.0 41.50439  ? 44  TYR A CD1 44  TYR A CD1 1 
ATOM 372   C CD2 . TYR A 1 44  ? 238.819 -56.771 267.776 1.0 41.50439  ? 44  TYR A CD2 44  TYR A CD2 1 
ATOM 373   C CE1 . TYR A 1 44  ? 237.817 -54.238 267.406 1.0 41.50439  ? 44  TYR A CE1 44  TYR A CE1 1 
ATOM 374   C CE2 . TYR A 1 44  ? 239.671 -55.736 267.463 1.0 41.50439  ? 44  TYR A CE2 44  TYR A CE2 1 
ATOM 375   C CZ  . TYR A 1 44  ? 239.165 -54.474 267.276 1.0 41.50439  ? 44  TYR A CZ  44  TYR A CZ  1 
ATOM 376   O OH  . TYR A 1 44  ? 240.015 -53.442 266.961 1.0 41.50439  ? 44  TYR A OH  44  TYR A OH  1 
ATOM 377   N N   . VAL A 1 45  ? 235.832 -58.130 264.774 1.0 42.08686  ? 45  VAL A N   45  VAL A N   1 
ATOM 378   C CA  . VAL A 1 45  ? 236.050 -58.791 263.494 1.0 42.08686  ? 45  VAL A CA  45  VAL A CA  1 
ATOM 379   C C   . VAL A 1 45  ? 236.958 -57.931 262.624 1.0 42.08686  ? 45  VAL A C   45  VAL A C   1 
ATOM 380   O O   . VAL A 1 45  ? 236.710 -56.733 262.451 1.0 42.08686  ? 45  VAL A O   45  VAL A O   1 
ATOM 381   C CB  . VAL A 1 45  ? 234.706 -59.066 262.797 1.0 42.08686  ? 45  VAL A CB  45  VAL A CB  1 
ATOM 382   C CG1 . VAL A 1 45  ? 234.909 -59.588 261.409 1.0 42.08686  ? 45  VAL A CG1 45  VAL A CG1 1 
ATOM 383   C CG2 . VAL A 1 45  ? 233.897 -60.057 263.603 1.0 42.08686  ? 45  VAL A CG2 45  VAL A CG2 1 
ATOM 384   N N   . ALA A 1 46  ? 238.009 -58.545 262.081 1.0 44.66665  ? 46  ALA A N   46  ALA A N   1 
ATOM 385   C CA  . ALA A 1 46  ? 238.889 -57.875 261.137 1.0 44.66665  ? 46  ALA A CA  46  ALA A CA  1 
ATOM 386   C C   . ALA A 1 46  ? 238.231 -57.814 259.755 1.0 44.66665  ? 46  ALA A C   46  ALA A C   1 
ATOM 387   O O   . ALA A 1 46  ? 237.435 -58.687 259.408 1.0 44.66665  ? 46  ALA A O   46  ALA A O   1 
ATOM 388   C CB  . ALA A 1 46  ? 240.223 -58.615 261.064 1.0 44.66665  ? 46  ALA A CB  46  ALA A CB  1 
ATOM 389   N N   . PRO A 1 47  ? 238.539 -56.787 258.947 1.0 46.92743  ? 47  PRO A N   47  PRO A N   1 
ATOM 390   C CA  . PRO A 1 47  ? 237.775 -56.583 257.700 1.0 46.92743  ? 47  PRO A CA  47  PRO A CA  1 
ATOM 391   C C   . PRO A 1 47  ? 238.052 -57.594 256.593 1.0 46.92743  ? 47  PRO A C   47  PRO A C   1 
ATOM 392   O O   . PRO A 1 47  ? 237.182 -57.771 255.730 1.0 46.92743  ? 47  PRO A O   47  PRO A O   1 
ATOM 393   C CB  . PRO A 1 47  ? 238.182 -55.170 257.270 1.0 46.92743  ? 47  PRO A CB  47  PRO A CB  1 
ATOM 394   C CG  . PRO A 1 47  ? 239.482 -54.943 257.913 1.0 46.92743  ? 47  PRO A CG  47  PRO A CG  1 
ATOM 395   C CD  . PRO A 1 47  ? 239.434 -55.647 259.215 1.0 46.92743  ? 47  PRO A CD  47  PRO A CD  1 
ATOM 396   N N   . SER A 1 48  ? 239.243 -58.199 256.548 1.0 50.42028  ? 48  SER A N   48  SER A N   1 
ATOM 397   C CA  . SER A 1 48  ? 239.607 -59.368 255.737 1.0 50.42028  ? 48  SER A CA  48  SER A CA  1 
ATOM 398   C C   . SER A 1 48  ? 239.642 -59.158 254.227 1.0 50.42028  ? 48  SER A C   48  SER A C   1 
ATOM 399   O O   . SER A 1 48  ? 240.011 -60.083 253.496 1.0 50.42028  ? 48  SER A O   48  SER A O   1 
ATOM 400   C CB  . SER A 1 48  ? 238.682 -60.556 256.017 1.0 50.42028  ? 48  SER A CB  48  SER A CB  1 
ATOM 401   O OG  . SER A 1 48  ? 237.403 -60.361 255.435 1.0 50.42028  ? 48  SER A OG  48  SER A OG  1 
ATOM 402   N N   . ALA A 1 49  ? 239.285 -57.972 253.742 1.0 52.09663  ? 49  ALA A N   49  ALA A N   1 
ATOM 403   C CA  . ALA A 1 49  ? 239.257 -57.719 252.309 1.0 52.09663  ? 49  ALA A CA  49  ALA A CA  1 
ATOM 404   C C   . ALA A 1 49  ? 239.295 -56.221 252.074 1.0 52.09663  ? 49  ALA A C   49  ALA A C   1 
ATOM 405   O O   . ALA A 1 49  ? 238.518 -55.477 252.676 1.0 52.09663  ? 49  ALA A O   49  ALA A O   1 
ATOM 406   C CB  . ALA A 1 49  ? 238.006 -58.316 251.652 1.0 52.09663  ? 49  ALA A CB  49  ALA A CB  1 
ATOM 407   N N   . GLY A 1 50  ? 240.189 -55.790 251.195 1.0 54.43053  ? 50  GLY A N   50  GLY A N   1 
ATOM 408   C CA  . GLY A 1 50  ? 240.322 -54.393 250.860 1.0 54.43053  ? 50  GLY A CA  50  GLY A CA  1 
ATOM 409   C C   . GLY A 1 50  ? 241.416 -53.662 251.603 1.0 54.43053  ? 50  GLY A C   50  GLY A C   1 
ATOM 410   O O   . GLY A 1 50  ? 241.728 -52.523 251.241 1.0 54.43053  ? 50  GLY A O   50  GLY A O   1 
ATOM 411   N N   . VAL A 1 51  ? 242.011 -54.277 252.621 1.0 51.50943  ? 51  VAL A N   51  VAL A N   1 
ATOM 412   C CA  . VAL A 1 51  ? 243.044 -53.612 253.403 1.0 51.50943  ? 51  VAL A CA  51  VAL A CA  1 
ATOM 413   C C   . VAL A 1 51  ? 244.422 -54.050 252.932 1.0 51.50943  ? 51  VAL A C   51  VAL A C   1 
ATOM 414   O O   . VAL A 1 51  ? 245.229 -53.223 252.495 1.0 51.50943  ? 51  VAL A O   51  VAL A O   1 
ATOM 415   C CB  . VAL A 1 51  ? 242.867 -53.885 254.904 1.0 51.50943  ? 51  VAL A CB  51  VAL A CB  1 
ATOM 416   C CG1 . VAL A 1 51  ? 244.032 -53.315 255.677 1.0 51.50943  ? 51  VAL A CG1 51  VAL A CG1 1 
ATOM 417   C CG2 . VAL A 1 51  ? 241.584 -53.268 255.384 1.0 51.50943  ? 51  VAL A CG2 51  VAL A CG2 1 
ATOM 418   N N   . THR A 1 52  ? 244.703 -55.344 253.011 1.0 52.46779  ? 52  THR A N   52  THR A N   1 
ATOM 419   C CA  . THR A 1 52  ? 246.023 -55.861 252.691 1.0 52.46779  ? 52  THR A CA  52  THR A CA  1 
ATOM 420   C C   . THR A 1 52  ? 245.993 -56.590 251.357 1.0 52.46779  ? 52  THR A C   52  THR A C   1 
ATOM 421   O O   . THR A 1 52  ? 245.095 -57.396 251.099 1.0 52.46779  ? 52  THR A O   52  THR A O   1 
ATOM 422   C CB  . THR A 1 52  ? 246.521 -56.802 253.787 1.0 52.46779  ? 52  THR A CB  52  THR A CB  1 
ATOM 423   O OG1 . THR A 1 52  ? 246.463 -56.129 255.048 1.0 52.46779  ? 52  THR A OG1 52  THR A OG1 1 
ATOM 424   C CG2 . THR A 1 52  ? 247.963 -57.206 253.522 1.0 52.46779  ? 52  THR A CG2 52  THR A CG2 1 
ATOM 425   N N   . THR A 1 53  ? 246.981 -56.298 250.512 1.0 54.11748  ? 53  THR A N   53  THR A N   1 
ATOM 426   C CA  . THR A 1 53  ? 247.132 -56.980 249.241 1.0 54.11748  ? 53  THR A CA  53  THR A CA  1 
ATOM 427   C C   . THR A 1 53  ? 247.508 -58.443 249.449 1.0 54.11748  ? 53  THR A C   53  THR A C   1 
ATOM 428   O O   . THR A 1 53  ? 247.898 -58.878 250.535 1.0 54.11748  ? 53  THR A O   53  THR A O   1 
ATOM 429   C CB  . THR A 1 53  ? 248.197 -56.303 248.384 1.0 54.11748  ? 53  THR A CB  53  THR A CB  1 
ATOM 430   O OG1 . THR A 1 53  ? 248.213 -56.907 247.087 1.0 54.11748  ? 53  THR A OG1 53  THR A OG1 1 
ATOM 431   C CG2 . THR A 1 53  ? 249.564 -56.464 249.013 1.0 54.11748  ? 53  THR A CG2 53  THR A CG2 1 
ATOM 432   N N   . ASP A 1 54  ? 247.385 -59.205 248.370 1.0 58.44906  ? 54  ASP A N   54  ASP A N   1 
ATOM 433   C CA  . ASP A 1 54  ? 247.744 -60.611 248.369 1.0 58.44906  ? 54  ASP A CA  54  ASP A CA  1 
ATOM 434   C C   . ASP A 1 54  ? 249.046 -60.887 247.636 1.0 58.44906  ? 54  ASP A C   54  ASP A C   1 
ATOM 435   O O   . ASP A 1 54  ? 249.734 -61.861 247.959 1.0 58.44906  ? 54  ASP A O   54  ASP A O   1 
ATOM 436   C CB  . ASP A 1 54  ? 246.623 -61.428 247.725 1.0 58.44906  ? 54  ASP A CB  54  ASP A CB  1 
ATOM 437   C CG  . ASP A 1 54  ? 246.873 -62.905 247.805 1.0 58.44906  ? 54  ASP A CG  54  ASP A CG  1 
ATOM 438   O OD1 . ASP A 1 54  ? 246.576 -63.517 248.851 1.0 58.44906  ? 54  ASP A OD1 54  ASP A OD1 1 
ATOM 439   O OD2 . ASP A 1 54  ? 247.440 -63.436 246.834 1.0 58.44906  ? 54  ASP A OD2 54  ASP A OD2 1 
ATOM 440   N N   . ARG A 1 55  ? 249.401 -60.032 246.681 1.0 52.14939  ? 55  ARG A N   55  ARG A N   1 
ATOM 441   C CA  . ARG A 1 55  ? 250.522 -60.256 245.783 1.0 52.14939  ? 55  ARG A CA  55  ARG A CA  1 
ATOM 442   C C   . ARG A 1 55  ? 251.851 -60.214 246.528 1.0 52.14939  ? 55  ARG A C   55  ARG A C   1 
ATOM 443   O O   . ARG A 1 55  ? 251.967 -59.659 247.623 1.0 52.14939  ? 55  ARG A O   55  ARG A O   1 
ATOM 444   C CB  . ARG A 1 55  ? 250.504 -59.213 244.672 1.0 52.14939  ? 55  ARG A CB  55  ARG A CB  1 
ATOM 445   C CG  . ARG A 1 55  ? 249.302 -59.356 243.770 1.0 52.14939  ? 55  ARG A CG  55  ARG A CG  1 
ATOM 446   C CD  . ARG A 1 55  ? 249.278 -58.302 242.699 1.0 52.14939  ? 55  ARG A CD  55  ARG A CD  1 
ATOM 447   N NE  . ARG A 1 55  ? 248.083 -58.402 241.873 1.0 52.14939  ? 55  ARG A NE  55  ARG A NE  1 
ATOM 448   C CZ  . ARG A 1 55  ? 248.001 -59.134 240.769 1.0 52.14939  ? 55  ARG A CZ  55  ARG A CZ  1 
ATOM 449   N NH1 . ARG A 1 55  ? 249.049 -59.829 240.354 1.0 52.14939  ? 55  ARG A NH1 55  ARG A NH1 1 
ATOM 450   N NH2 . ARG A 1 55  ? 246.872 -59.170 240.078 1.0 52.14939  ? 55  ARG A NH2 55  ARG A NH2 1 
ATOM 451   N N   . SER A 1 56  ? 252.859 -60.832 245.917 1.0 49.32131  ? 56  SER A N   56  SER A N   1 
ATOM 452   C CA  . SER A 1 56  ? 254.174 -60.984 246.531 1.0 49.32131  ? 56  SER A CA  56  SER A CA  1 
ATOM 453   C C   . SER A 1 56  ? 254.862 -59.630 246.617 1.0 49.32131  ? 56  SER A C   56  SER A C   1 
ATOM 454   O O   . SER A 1 56  ? 255.272 -59.067 245.599 1.0 49.32131  ? 56  SER A O   56  SER A O   1 
ATOM 455   C CB  . SER A 1 56  ? 255.013 -61.972 245.728 1.0 49.32131  ? 56  SER A CB  56  SER A CB  1 
ATOM 456   O OG  . SER A 1 56  ? 256.302 -62.116 246.291 1.0 49.32131  ? 56  SER A OG  56  SER A OG  1 
ATOM 457   N N   . GLN A 1 57  ? 255.002 -59.117 247.832 1.0 48.72204  ? 57  GLN A N   57  GLN A N   1 
ATOM 458   C CA  . GLN A 1 57  ? 255.536 -57.788 248.068 1.0 48.72204  ? 57  GLN A CA  57  GLN A CA  1 
ATOM 459   C C   . GLN A 1 57  ? 256.436 -57.833 249.289 1.0 48.72204  ? 57  GLN A C   57  GLN A C   1 
ATOM 460   O O   . GLN A 1 57  ? 256.079 -58.436 250.302 1.0 48.72204  ? 57  GLN A O   57  GLN A O   1 
ATOM 461   C CB  . GLN A 1 57  ? 254.401 -56.787 248.276 1.0 48.72204  ? 57  GLN A CB  57  GLN A CB  1 
ATOM 462   C CG  . GLN A 1 57  ? 254.831 -55.360 248.481 1.0 48.72204  ? 57  GLN A CG  57  GLN A CG  1 
ATOM 463   C CD  . GLN A 1 57  ? 253.652 -54.423 248.613 1.0 48.72204  ? 57  GLN A CD  57  GLN A CD  1 
ATOM 464   O OE1 . GLN A 1 57  ? 252.498 -54.844 248.540 1.0 48.72204  ? 57  GLN A OE1 57  GLN A OE1 1 
ATOM 465   N NE2 . GLN A 1 57  ? 253.935 -53.147 248.822 1.0 48.72204  ? 57  GLN A NE2 57  GLN A NE2 1 
ATOM 466   N N   . LYS A 1 58  ? 257.602 -57.202 249.189 1.0 49.35996  ? 58  LYS A N   58  LYS A N   1 
ATOM 467   C CA  . LYS A 1 58  ? 258.514 -57.144 250.321 1.0 49.35996  ? 58  LYS A CA  58  LYS A CA  1 
ATOM 468   C C   . LYS A 1 58  ? 257.952 -56.242 251.411 1.0 49.35996  ? 58  LYS A C   58  LYS A C   1 
ATOM 469   O O   . LYS A 1 58  ? 257.384 -55.185 251.131 1.0 49.35996  ? 58  LYS A O   58  LYS A O   1 
ATOM 470   C CB  . LYS A 1 58  ? 259.884 -56.645 249.869 1.0 49.35996  ? 58  LYS A CB  58  LYS A CB  1 
ATOM 471   C CG  . LYS A 1 58  ? 260.962 -56.746 250.918 1.0 49.35996  ? 58  LYS A CG  58  LYS A CG  1 
ATOM 472   C CD  . LYS A 1 58  ? 262.302 -56.298 250.371 1.0 49.35996  ? 58  LYS A CD  58  LYS A CD  1 
ATOM 473   C CE  . LYS A 1 58  ? 262.883 -57.317 249.399 1.0 49.35996  ? 58  LYS A CE  58  LYS A CE  1 
ATOM 474   N NZ  . LYS A 1 58  ? 263.246 -58.602 250.067 1.0 49.35996  ? 58  LYS A NZ  58  LYS A NZ  1 
ATOM 475   N N   . LEU A 1 59  ? 258.097 -56.673 252.662 1.0 47.23803  ? 59  LEU A N   59  LEU A N   1 
ATOM 476   C CA  . LEU A 1 59  ? 257.488 -55.986 253.795 1.0 47.23803  ? 59  LEU A CA  59  LEU A CA  1 
ATOM 477   C C   . LEU A 1 59  ? 258.416 -54.964 254.435 1.0 47.23803  ? 59  LEU A C   59  LEU A C   1 
ATOM 478   O O   . LEU A 1 59  ? 257.968 -53.881 254.809 1.0 47.23803  ? 59  LEU A O   59  LEU A O   1 
ATOM 479   C CB  . LEU A 1 59  ? 257.050 -57.008 254.855 1.0 47.23803  ? 59  LEU A CB  59  LEU A CB  1 
ATOM 480   C CG  . LEU A 1 59  ? 256.016 -56.585 255.900 1.0 47.23803  ? 59  LEU A CG  59  LEU A CG  1 
ATOM 481   C CD1 . LEU A 1 59  ? 254.708 -56.489 255.148 1.0 47.23803  ? 59  LEU A CD1 59  LEU A CD1 1 
ATOM 482   C CD2 . LEU A 1 59  ? 255.869 -57.553 257.041 1.0 47.23803  ? 59  LEU A CD2 59  LEU A CD2 1 
ATOM 483   N N   . GLN A 1 60  ? 259.699 -55.287 254.579 1.0 49.16449  ? 60  GLN A N   60  GLN A N   1 
ATOM 484   C CA  . GLN A 1 60  ? 260.691 -54.388 255.149 1.0 49.16449  ? 60  GLN A CA  60  GLN A CA  1 
ATOM 485   C C   . GLN A 1 60  ? 261.928 -54.387 254.261 1.0 49.16449  ? 60  GLN A C   60  GLN A C   1 
ATOM 486   O O   . GLN A 1 60  ? 262.450 -55.449 253.915 1.0 49.16449  ? 60  GLN A O   60  GLN A O   1 
ATOM 487   C CB  . GLN A 1 60  ? 261.046 -54.809 256.577 1.0 49.16449  ? 60  GLN A CB  60  GLN A CB  1 
ATOM 488   C CG  . GLN A 1 60  ? 262.008 -53.880 257.275 1.0 49.16449  ? 60  GLN A CG  60  GLN A CG  1 
ATOM 489   C CD  . GLN A 1 60  ? 262.239 -54.257 258.721 1.0 49.16449  ? 60  GLN A CD  60  GLN A CD  1 
ATOM 490   O OE1 . GLN A 1 60  ? 261.712 -55.255 259.209 1.0 49.16449  ? 60  GLN A OE1 60  GLN A OE1 1 
ATOM 491   N NE2 . GLN A 1 60  ? 263.024 -53.451 259.419 1.0 49.16449  ? 60  GLN A NE2 60  GLN A NE2 1 
ATOM 492   N N   . LEU A 1 61  ? 262.392 -53.195 253.890 1.0 46.00055  ? 61  LEU A N   61  LEU A N   1 
ATOM 493   C CA  . LEU A 1 61  ? 263.399 -53.021 252.850 1.0 46.00055  ? 61  LEU A CA  61  LEU A CA  1 
ATOM 494   C C   . LEU A 1 61  ? 264.701 -52.499 253.438 1.0 46.00055  ? 61  LEU A C   61  LEU A C   1 
ATOM 495   O O   . LEU A 1 61  ? 264.694 -51.532 254.204 1.0 46.00055  ? 61  LEU A O   61  LEU A O   1 
ATOM 496   C CB  . LEU A 1 61  ? 262.902 -52.052 251.776 1.0 46.00055  ? 61  LEU A CB  61  LEU A CB  1 
ATOM 497   C CG  . LEU A 1 61  ? 263.877 -51.758 250.637 1.0 46.00055  ? 61  LEU A CG  61  LEU A CG  1 
ATOM 498   C CD1 . LEU A 1 61  ? 264.155 -53.022 249.852 1.0 46.00055  ? 61  LEU A CD1 61  LEU A CD1 1 
ATOM 499   C CD2 . LEU A 1 61  ? 263.379 -50.638 249.728 1.0 46.00055  ? 61  LEU A CD2 61  LEU A CD2 1 
ATOM 500   N N   . ARG A 1 62  ? 265.813 -53.132 253.073 1.0 47.94863  ? 62  ARG A N   62  ARG A N   1 
ATOM 501   C CA  . ARG A 1 62  ? 267.144 -52.606 253.341 1.0 47.94863  ? 62  ARG A CA  62  ARG A CA  1 
ATOM 502   C C   . ARG A 1 62  ? 267.657 -51.937 252.075 1.0 47.94863  ? 62  ARG A C   62  ARG A C   1 
ATOM 503   O O   . ARG A 1 62  ? 267.472 -52.464 250.973 1.0 47.94863  ? 62  ARG A O   62  ARG A O   1 
ATOM 504   C CB  . ARG A 1 62  ? 268.097 -53.707 253.824 1.0 47.94863  ? 62  ARG A CB  62  ARG A CB  1 
ATOM 505   C CG  . ARG A 1 62  ? 268.345 -54.914 252.911 1.0 47.94863  ? 62  ARG A CG  62  ARG A CG  1 
ATOM 506   C CD  . ARG A 1 62  ? 269.587 -54.770 252.019 1.0 47.94863  ? 62  ARG A CD  62  ARG A CD  1 
ATOM 507   N NE  . ARG A 1 62  ? 270.793 -54.436 252.774 1.0 47.94863  ? 62  ARG A NE  62  ARG A NE  1 
ATOM 508   C CZ  . ARG A 1 62  ? 271.550 -55.316 253.419 1.0 47.94863  ? 62  ARG A CZ  62  ARG A CZ  1 
ATOM 509   N NH1 . ARG A 1 62  ? 271.241 -56.603 253.408 1.0 47.94863  ? 62  ARG A NH1 62  ARG A NH1 1 
ATOM 510   N NH2 . ARG A 1 62  ? 272.625 -54.907 254.073 1.0 47.94863  ? 62  ARG A NH2 62  ARG A NH2 1 
ATOM 511   N N   . VAL A 1 63  ? 268.280 -50.776 252.224 1.0 43.39959  ? 63  VAL A N   63  VAL A N   1 
ATOM 512   C CA  . VAL A 1 63  ? 268.897 -50.073 251.109 1.0 43.39959  ? 63  VAL A CA  63  VAL A CA  1 
ATOM 513   C C   . VAL A 1 63  ? 270.271 -49.584 251.550 1.0 43.39959  ? 63  VAL A C   63  VAL A C   1 
ATOM 514   O O   . VAL A 1 63  ? 270.423 -49.023 252.640 1.0 43.39959  ? 63  VAL A O   63  VAL A O   1 
ATOM 515   C CB  . VAL A 1 63  ? 267.990 -48.940 250.578 1.0 43.39959  ? 63  VAL A CB  63  VAL A CB  1 
ATOM 516   C CG1 . VAL A 1 63  ? 267.555 -47.985 251.667 1.0 43.39959  ? 63  VAL A CG1 63  VAL A CG1 1 
ATOM 517   C CG2 . VAL A 1 63  ? 268.669 -48.175 249.457 1.0 43.39959  ? 63  VAL A CG2 63  VAL A CG2 1 
ATOM 518   N N   . VAL A 1 64  ? 271.279 -49.858 250.728 1.0 42.62348  ? 64  VAL A N   64  VAL A N   1 
ATOM 519   C CA  . VAL A 1 64  ? 272.674 -49.595 251.064 1.0 42.62348  ? 64  VAL A CA  64  VAL A CA  1 
ATOM 520   C C   . VAL A 1 64  ? 273.058 -48.293 250.365 1.0 42.62348  ? 64  VAL A C   64  VAL A C   1 
ATOM 521   O O   . VAL A 1 64  ? 272.349 -47.889 249.433 1.0 42.62348  ? 64  VAL A O   64  VAL A O   1 
ATOM 522   C CB  . VAL A 1 64  ? 273.553 -50.792 250.659 1.0 42.62348  ? 64  VAL A CB  64  VAL A CB  1 
ATOM 523   C CG1 . VAL A 1 64  ? 273.011 -52.065 251.274 1.0 42.62348  ? 64  VAL A CG1 64  VAL A CG1 1 
ATOM 524   C CG2 . VAL A 1 64  ? 273.662 -50.907 249.172 1.0 42.62348  ? 64  VAL A CG2 64  VAL A CG2 1 
ATOM 525   N N   . PRO A 1 65  ? 274.112 -47.578 250.779 1.0 42.75347  ? 65  PRO A N   65  PRO A N   1 
ATOM 526   C CA  . PRO A 1 65  ? 274.380 -46.270 250.173 1.0 42.75347  ? 65  PRO A CA  65  PRO A CA  1 
ATOM 527   C C   . PRO A 1 65  ? 274.894 -46.355 248.746 1.0 42.75347  ? 65  PRO A C   65  PRO A C   1 
ATOM 528   O O   . PRO A 1 65  ? 275.563 -47.312 248.351 1.0 42.75347  ? 65  PRO A O   65  PRO A O   1 
ATOM 529   C CB  . PRO A 1 65  ? 275.438 -45.663 251.097 1.0 42.75347  ? 65  PRO A CB  65  PRO A CB  1 
ATOM 530   C CG  . PRO A 1 65  ? 276.065 -46.802 251.744 1.0 42.75347  ? 65  PRO A CG  65  PRO A CG  1 
ATOM 531   C CD  . PRO A 1 65  ? 274.999 -47.805 251.934 1.0 42.75347  ? 65  PRO A CD  65  PRO A CD  1 
ATOM 532   N N   . ILE A 1 66  ? 274.561 -45.321 247.972 1.0 46.93114  ? 66  ILE A N   66  ILE A N   1 
ATOM 533   C CA  . ILE A 1 66  ? 274.988 -45.246 246.579 1.0 46.93114  ? 66  ILE A CA  66  ILE A CA  1 
ATOM 534   C C   . ILE A 1 66  ? 276.460 -44.886 246.493 1.0 46.93114  ? 66  ILE A C   66  ILE A C   1 
ATOM 535   O O   . ILE A 1 66  ? 277.250 -45.575 245.840 1.0 46.93114  ? 66  ILE A O   66  ILE A O   1 
ATOM 536   C CB  . ILE A 1 66  ? 274.136 -44.220 245.814 1.0 46.93114  ? 66  ILE A CB  66  ILE A CB  1 
ATOM 537   C CG1 . ILE A 1 66  ? 272.662 -44.590 245.872 1.0 46.93114  ? 66  ILE A CG1 66  ILE A CG1 1 
ATOM 538   C CG2 . ILE A 1 66  ? 274.595 -44.117 244.379 1.0 46.93114  ? 66  ILE A CG2 66  ILE A CG2 1 
ATOM 539   C CD1 . ILE A 1 66  ? 272.326 -45.881 245.188 1.0 46.93114  ? 66  ILE A CD1 66  ILE A CD1 1 
ATOM 540   N N   . GLN A 1 67  ? 276.848 -43.790 247.140 1.0 51.69286  ? 67  GLN A N   67  GLN A N   1 
ATOM 541   C CA  . GLN A 1 67  ? 278.169 -43.211 246.915 1.0 51.69286  ? 67  GLN A CA  67  GLN A CA  1 
ATOM 542   C C   . GLN A 1 67  ? 278.579 -42.499 248.205 1.0 51.69286  ? 67  GLN A C   67  GLN A C   1 
ATOM 543   O O   . GLN A 1 67  ? 278.189 -41.356 248.446 1.0 51.69286  ? 67  GLN A O   67  GLN A O   1 
ATOM 544   C CB  . GLN A 1 67  ? 278.133 -42.275 245.715 1.0 51.69286  ? 67  GLN A CB  67  GLN A CB  1 
ATOM 545   C CG  . GLN A 1 67  ? 279.480 -41.858 245.150 1.0 51.69286  ? 67  GLN A CG  67  GLN A CG  1 
ATOM 546   C CD  . GLN A 1 67  ? 280.068 -40.647 245.826 1.0 51.69286  ? 67  GLN A CD  67  GLN A CD  1 
ATOM 547   O OE1 . GLN A 1 67  ? 281.201 -40.672 246.298 1.0 51.69286  ? 67  GLN A OE1 67  GLN A OE1 1 
ATOM 548   N NE2 . GLN A 1 67  ? 279.313 -39.560 245.838 1.0 51.69286  ? 67  GLN A NE2 67  GLN A NE2 1 
ATOM 549   N N   . THR A 1 68  ? 279.364 -43.190 249.024 1.0 52.83315  ? 68  THR A N   68  THR A N   1 
ATOM 550   C CA  . THR A 1 68  ? 279.804 -42.635 250.292 1.0 52.83315  ? 68  THR A CA  68  THR A CA  1 
ATOM 551   C C   . THR A 1 68  ? 280.995 -41.703 250.098 1.0 52.83315  ? 68  THR A C   68  THR A C   1 
ATOM 552   O O   . THR A 1 68  ? 281.544 -41.559 249.005 1.0 52.83315  ? 68  THR A O   68  THR A O   1 
ATOM 553   C CB  . THR A 1 68  ? 280.195 -43.739 251.265 1.0 52.83315  ? 68  THR A CB  68  THR A CB  1 
ATOM 554   O OG1 . THR A 1 68  ? 281.298 -44.477 250.729 1.0 52.83315  ? 68  THR A OG1 68  THR A OG1 1 
ATOM 555   C CG2 . THR A 1 68  ? 279.044 -44.670 251.481 1.0 52.83315  ? 68  THR A CG2 68  THR A CG2 1 
ATOM 556   N N   . GLU A 1 69  ? 281.402 -41.074 251.195 1.0 56.13069  ? 69  GLU A N   69  GLU A N   1 
ATOM 557   C CA  . GLU A 1 69  ? 282.615 -40.271 251.226 1.0 56.13069  ? 69  GLU A CA  69  GLU A CA  1 
ATOM 558   C C   . GLU A 1 69  ? 283.138 -40.277 252.648 1.0 56.13069  ? 69  GLU A C   69  GLU A C   1 
ATOM 559   O O   . GLU A 1 69  ? 282.373 -40.073 253.592 1.0 56.13069  ? 69  GLU A O   69  GLU A O   1 
ATOM 560   C CB  . GLU A 1 69  ? 282.365 -38.836 250.764 1.0 56.13069  ? 69  GLU A CB  69  GLU A CB  1 
ATOM 561   C CG  . GLU A 1 69  ? 283.614 -37.974 250.738 1.0 56.13069  ? 69  GLU A CG  69  GLU A CG  1 
ATOM 562   C CD  . GLU A 1 69  ? 283.344 -36.561 250.271 1.0 56.13069  ? 69  GLU A CD  69  GLU A CD  1 
ATOM 563   O OE1 . GLU A 1 69  ? 282.174 -36.237 249.981 1.0 56.13069  ? 69  GLU A OE1 69  GLU A OE1 1 
ATOM 564   O OE2 . GLU A 1 69  ? 284.306 -35.771 250.197 1.0 56.13069  ? 69  GLU A OE2 69  GLU A OE2 1 
ATOM 565   N N   . ASP A 1 70  ? 284.435 -40.506 252.793 1.0 58.41753  ? 70  ASP A N   70  ASP A N   1 
ATOM 566   C CA  . ASP A 1 70  ? 285.068 -40.648 254.092 1.0 58.41753  ? 70  ASP A CA  70  ASP A CA  1 
ATOM 567   C C   . ASP A 1 70  ? 286.267 -39.716 254.146 1.0 58.41753  ? 70  ASP A C   70  ASP A C   1 
ATOM 568   O O   . ASP A 1 70  ? 287.097 -39.713 253.232 1.0 58.41753  ? 70  ASP A O   70  ASP A O   1 
ATOM 569   C CB  . ASP A 1 70  ? 285.486 -42.107 254.314 1.0 58.41753  ? 70  ASP A CB  70  ASP A CB  1 
ATOM 570   C CG  . ASP A 1 70  ? 285.910 -42.398 255.739 1.0 58.41753  ? 70  ASP A CG  70  ASP A CG  1 
ATOM 571   O OD1 . ASP A 1 70  ? 285.920 -41.480 256.578 1.0 58.41753  ? 70  ASP A OD1 70  ASP A OD1 1 
ATOM 572   O OD2 . ASP A 1 70  ? 286.240 -43.567 256.025 1.0 58.41753  ? 70  ASP A OD2 70  ASP A OD2 1 
ATOM 573   N N   . ASN A 1 71  ? 286.346 -38.919 255.203 1.0 58.41638  ? 71  ASN A N   71  ASN A N   1 
ATOM 574   C CA  . ASN A 1 71  ? 287.538 -38.131 255.490 1.0 58.41638  ? 71  ASN A CA  71  ASN A CA  1 
ATOM 575   C C   . ASN A 1 71  ? 287.690 -38.057 257.004 1.0 58.41638  ? 71  ASN A C   71  ASN A C   1 
ATOM 576   O O   . ASN A 1 71  ? 287.112 -38.860 257.743 1.0 58.41638  ? 71  ASN A O   71  ASN A O   1 
ATOM 577   C CB  . ASN A 1 71  ? 287.496 -36.759 254.794 1.0 58.41638  ? 71  ASN A CB  71  ASN A CB  1 
ATOM 578   C CG  . ASN A 1 71  ? 286.279 -35.939 255.154 1.0 58.41638  ? 71  ASN A CG  71  ASN A CG  1 
ATOM 579   O OD1 . ASN A 1 71  ? 285.402 -36.370 255.899 1.0 58.41638  ? 71  ASN A OD1 71  ASN A OD1 1 
ATOM 580   N ND2 . ASN A 1 71  ? 286.241 -34.719 254.642 1.0 58.41638  ? 71  ASN A ND2 71  ASN A ND2 1 
ATOM 581   N N   . VAL A 1 72  ? 288.500 -37.102 257.467 1.0 60.50798  ? 72  VAL A N   72  VAL A N   1 
ATOM 582   C CA  . VAL A 1 72  ? 288.861 -37.026 258.879 1.0 60.50798  ? 72  VAL A CA  72  VAL A CA  1 
ATOM 583   C C   . VAL A 1 72  ? 287.660 -36.634 259.731 1.0 60.50798  ? 72  VAL A C   72  VAL A C   1 
ATOM 584   O O   . VAL A 1 72  ? 287.415 -37.224 260.789 1.0 60.50798  ? 72  VAL A O   72  VAL A O   1 
ATOM 585   C CB  . VAL A 1 72  ? 290.031 -36.043 259.061 1.0 60.50798  ? 72  VAL A CB  72  VAL A CB  1 
ATOM 586   C CG1 . VAL A 1 72  ? 290.406 -35.905 260.528 1.0 60.50798  ? 72  VAL A CG1 72  VAL A CG1 1 
ATOM 587   C CG2 . VAL A 1 72  ? 291.225 -36.488 258.241 1.0 60.50798  ? 72  VAL A CG2 72  VAL A CG2 1 
ATOM 588   N N   . ASN A 1 73  ? 286.874 -35.663 259.276 1.0 59.03599  ? 73  ASN A N   73  ASN A N   1 
ATOM 589   C CA  . ASN A 1 73  ? 285.855 -35.076 260.134 1.0 59.03599  ? 73  ASN A CA  73  ASN A CA  1 
ATOM 590   C C   . ASN A 1 73  ? 284.486 -35.727 260.020 1.0 59.03599  ? 73  ASN A C   73  ASN A C   1 
ATOM 591   O O   . ASN A 1 73  ? 283.841 -35.946 261.049 1.0 59.03599  ? 73  ASN A O   73  ASN A O   1 
ATOM 592   C CB  . ASN A 1 73  ? 285.724 -33.581 259.844 1.0 59.03599  ? 73  ASN A CB  73  ASN A CB  1 
ATOM 593   C CG  . ASN A 1 73  ? 286.976 -32.818 260.196 1.0 59.03599  ? 73  ASN A CG  73  ASN A CG  1 
ATOM 594   O OD1 . ASN A 1 73  ? 287.637 -32.252 259.328 1.0 59.03599  ? 73  ASN A OD1 73  ASN A OD1 1 
ATOM 595   N ND2 . ASN A 1 73  ? 287.318 -32.809 261.477 1.0 59.03599  ? 73  ASN A ND2 73  ASN A ND2 1 
ATOM 596   N N   . TYR A 1 74  ? 284.013 -36.043 258.818 1.0 55.15487  ? 74  TYR A N   74  TYR A N   1 
ATOM 597   C CA  . TYR A 1 74  ? 282.648 -36.530 258.666 1.0 55.15487  ? 74  TYR A CA  74  TYR A CA  1 
ATOM 598   C C   . TYR A 1 74  ? 282.657 -37.807 257.837 1.0 55.15487  ? 74  TYR A C   74  TYR A C   1 
ATOM 599   O O   . TYR A 1 74  ? 283.713 -38.338 257.484 1.0 55.15487  ? 74  TYR A O   74  TYR A O   1 
ATOM 600   C CB  . TYR A 1 74  ? 281.742 -35.448 258.061 1.0 55.15487  ? 74  TYR A CB  74  TYR A CB  1 
ATOM 601   C CG  . TYR A 1 74  ? 282.106 -34.990 256.668 1.0 55.15487  ? 74  TYR A CG  74  TYR A CG  1 
ATOM 602   C CD1 . TYR A 1 74  ? 282.981 -33.934 256.474 1.0 55.15487  ? 74  TYR A CD1 74  TYR A CD1 1 
ATOM 603   C CD2 . TYR A 1 74  ? 281.544 -35.588 255.548 1.0 55.15487  ? 74  TYR A CD2 74  TYR A CD2 1 
ATOM 604   C CE1 . TYR A 1 74  ? 283.304 -33.503 255.208 1.0 55.15487  ? 74  TYR A CE1 74  TYR A CE1 1 
ATOM 605   C CE2 . TYR A 1 74  ? 281.867 -35.168 254.279 1.0 55.15487  ? 74  TYR A CE2 74  TYR A CE2 1 
ATOM 606   C CZ  . TYR A 1 74  ? 282.747 -34.126 254.115 1.0 55.15487  ? 74  TYR A CZ  74  TYR A CZ  1 
ATOM 607   O OH  . TYR A 1 74  ? 283.069 -33.699 252.847 1.0 55.15487  ? 74  TYR A OH  74  TYR A OH  1 
ATOM 608   N N   . TYR A 1 75  ? 281.458 -38.303 257.529 1.0 51.19929  ? 75  TYR A N   75  TYR A N   1 
ATOM 609   C CA  . TYR A 1 75  ? 281.294 -39.515 256.730 1.0 51.19929  ? 75  TYR A CA  75  TYR A CA  1 
ATOM 610   C C   . TYR A 1 75  ? 279.975 -39.395 255.972 1.0 51.19929  ? 75  TYR A C   75  TYR A C   1 
ATOM 611   O O   . TYR A 1 75  ? 278.914 -39.685 256.530 1.0 51.19929  ? 75  TYR A O   75  TYR A O   1 
ATOM 612   C CB  . TYR A 1 75  ? 281.320 -40.755 257.610 1.0 51.19929  ? 75  TYR A CB  75  TYR A CB  1 
ATOM 613   C CG  . TYR A 1 75  ? 281.179 -42.051 256.851 1.0 51.19929  ? 75  TYR A CG  75  TYR A CG  1 
ATOM 614   C CD1 . TYR A 1 75  ? 282.248 -42.586 256.149 1.0 51.19929  ? 75  TYR A CD1 75  TYR A CD1 1 
ATOM 615   C CD2 . TYR A 1 75  ? 279.975 -42.739 256.835 1.0 51.19929  ? 75  TYR A CD2 75  TYR A CD2 1 
ATOM 616   C CE1 . TYR A 1 75  ? 282.123 -43.771 255.453 1.0 51.19929  ? 75  TYR A CE1 75  TYR A CE1 1 
ATOM 617   C CE2 . TYR A 1 75  ? 279.838 -43.921 256.140 1.0 51.19929  ? 75  TYR A CE2 75  TYR A CE2 1 
ATOM 618   C CZ  . TYR A 1 75  ? 280.915 -44.432 255.453 1.0 51.19929  ? 75  TYR A CZ  75  TYR A CZ  1 
ATOM 619   O OH  . TYR A 1 75  ? 280.786 -45.610 254.760 1.0 51.19929  ? 75  TYR A OH  75  TYR A OH  1 
ATOM 620   N N   . LYS A 1 76  ? 280.047 -38.967 254.714 1.0 51.61013  ? 76  LYS A N   76  LYS A N   1 
ATOM 621   C CA  . LYS A 1 76  ? 278.858 -38.875 253.877 1.0 51.61013  ? 76  LYS A CA  76  LYS A CA  1 
ATOM 622   C C   . LYS A 1 76  ? 278.359 -40.262 253.504 1.0 51.61013  ? 76  LYS A C   76  LYS A C   1 
ATOM 623   O O   . LYS A 1 76  ? 279.147 -41.161 253.207 1.0 51.61013  ? 76  LYS A O   76  LYS A O   1 
ATOM 624   C CB  . LYS A 1 76  ? 279.161 -38.083 252.599 1.0 51.61013  ? 76  LYS A CB  76  LYS A CB  1 
ATOM 625   C CG  . LYS A 1 76  ? 277.986 -37.967 251.621 1.0 51.61013  ? 76  LYS A CG  76  LYS A CG  1 
ATOM 626   C CD  . LYS A 1 76  ? 278.276 -37.078 250.430 1.0 51.61013  ? 76  LYS A CD  76  LYS A CD  1 
ATOM 627   C CE  . LYS A 1 76  ? 279.129 -37.783 249.402 1.0 51.61013  ? 76  LYS A CE  76  LYS A CE  1 
ATOM 628   N NZ  . LYS A 1 76  ? 278.398 -38.898 248.749 1.0 51.61013  ? 76  LYS A NZ  76  LYS A NZ  1 
ATOM 629   N N   . ALA A 1 77  ? 277.043 -40.437 253.536 1.0 47.84455  ? 77  ALA A N   77  ALA A N   1 
ATOM 630   C CA  . ALA A 1 77  ? 276.389 -41.534 252.845 1.0 47.84455  ? 77  ALA A CA  77  ALA A CA  1 
ATOM 631   C C   . ALA A 1 77  ? 275.199 -40.984 252.078 1.0 47.84455  ? 77  ALA A C   77  ALA A C   1 
ATOM 632   O O   . ALA A 1 77  ? 274.560 -40.023 252.507 1.0 47.84455  ? 77  ALA A O   77  ALA A O   1 
ATOM 633   C CB  . ALA A 1 77  ? 275.934 -42.614 253.801 1.0 47.84455  ? 77  ALA A CB  77  ALA A CB  1 
ATOM 634   N N   . ARG A 1 78  ? 274.914 -41.591 250.932 1.0 46.02559  ? 78  ARG A N   78  ARG A N   1 
ATOM 635   C CA  . ARG A 1 78  ? 273.861 -41.117 250.044 1.0 46.02559  ? 78  ARG A CA  78  ARG A CA  1 
ATOM 636   C C   . ARG A 1 78  ? 273.030 -42.299 249.580 1.0 46.02559  ? 78  ARG A C   78  ARG A C   1 
ATOM 637   O O   . ARG A 1 78  ? 273.557 -43.227 248.962 1.0 46.02559  ? 78  ARG A O   78  ARG A O   1 
ATOM 638   C CB  . ARG A 1 78  ? 274.448 -40.363 248.851 1.0 46.02559  ? 78  ARG A CB  78  ARG A CB  1 
ATOM 639   C CG  . ARG A 1 78  ? 273.415 -39.863 247.864 1.0 46.02559  ? 78  ARG A CG  78  ARG A CG  1 
ATOM 640   C CD  . ARG A 1 78  ? 274.059 -39.019 246.786 1.0 46.02559  ? 78  ARG A CD  78  ARG A CD  1 
ATOM 641   N NE  . ARG A 1 78  ? 273.086 -38.614 245.784 1.0 46.02559  ? 78  ARG A NE  78  ARG A NE  1 
ATOM 642   C CZ  . ARG A 1 78  ? 272.820 -39.322 244.692 1.0 46.02559  ? 78  ARG A CZ  78  ARG A CZ  1 
ATOM 643   N NH1 . ARG A 1 78  ? 273.458 -40.457 244.465 1.0 46.02559  ? 78  ARG A NH1 78  ARG A NH1 1 
ATOM 644   N NH2 . ARG A 1 78  ? 271.917 -38.905 243.820 1.0 46.02559  ? 78  ARG A NH2 78  ARG A NH2 1 
ATOM 645   N N   . PHE A 1 79  ? 271.738 -42.256 249.870 1.0 43.47025  ? 79  PHE A N   79  PHE A N   1 
ATOM 646   C CA  . PHE A 1 79  ? 270.824 -43.357 249.619 1.0 43.47025  ? 79  PHE A CA  79  PHE A CA  1 
ATOM 647   C C   . PHE A 1 79  ? 269.833 -42.969 248.535 1.0 43.47025  ? 79  PHE A C   79  PHE A C   1 
ATOM 648   O O   . PHE A 1 79  ? 269.493 -41.795 248.380 1.0 43.47025  ? 79  PHE A O   79  PHE A O   1 
ATOM 649   C CB  . PHE A 1 79  ? 270.064 -43.723 250.891 1.0 43.47025  ? 79  PHE A CB  79  PHE A CB  1 
ATOM 650   C CG  . PHE A 1 79  ? 270.934 -44.247 251.982 1.0 43.47025  ? 79  PHE A CG  79  PHE A CG  1 
ATOM 651   C CD1 . PHE A 1 79  ? 271.245 -45.588 252.047 1.0 43.47025  ? 79  PHE A CD1 79  PHE A CD1 1 
ATOM 652   C CD2 . PHE A 1 79  ? 271.460 -43.394 252.933 1.0 43.47025  ? 79  PHE A CD2 79  PHE A CD2 1 
ATOM 653   C CE1 . PHE A 1 79  ? 272.047 -46.072 253.048 1.0 43.47025  ? 79  PHE A CE1 79  PHE A CE1 1 
ATOM 654   C CE2 . PHE A 1 79  ? 272.269 -43.873 253.930 1.0 43.47025  ? 79  PHE A CE2 79  PHE A CE2 1 
ATOM 655   C CZ  . PHE A 1 79  ? 272.558 -45.213 253.985 1.0 43.47025  ? 79  PHE A CZ  79  PHE A CZ  1 
ATOM 656   N N   . THR A 1 80  ? 269.375 -43.959 247.781 1.0 43.50057  ? 80  THR A N   80  THR A N   1 
ATOM 657   C CA  . THR A 1 80  ? 268.268 -43.780 246.848 1.0 43.50057  ? 80  THR A CA  80  THR A CA  1 
ATOM 658   C C   . THR A 1 80  ? 267.098 -44.572 247.422 1.0 43.50057  ? 80  THR A C   80  THR A C   1 
ATOM 659   O O   . THR A 1 80  ? 266.927 -45.759 247.140 1.0 43.50057  ? 80  THR A O   80  THR A O   1 
ATOM 660   C CB  . THR A 1 80  ? 268.628 -44.225 245.434 1.0 43.50057  ? 80  THR A CB  80  THR A CB  1 
ATOM 661   O OG1 . THR A 1 80  ? 269.745 -43.462 244.972 1.0 43.50057  ? 80  THR A OG1 80  THR A OG1 1 
ATOM 662   C CG2 . THR A 1 80  ? 267.469 -43.978 244.479 1.0 43.50057  ? 80  THR A CG2 80  THR A CG2 1 
ATOM 663   N N   . LEU A 1 81  ? 266.318 -43.912 248.272 1.0 43.32963  ? 81  LEU A N   81  LEU A N   1 
ATOM 664   C CA  . LEU A 1 81  ? 265.072 -44.485 248.759 1.0 43.32963  ? 81  LEU A CA  81  LEU A CA  1 
ATOM 665   C C   . LEU A 1 81  ? 264.085 -44.521 247.608 1.0 43.32963  ? 81  LEU A C   81  LEU A C   1 
ATOM 666   O O   . LEU A 1 81  ? 263.506 -43.494 247.243 1.0 43.32963  ? 81  LEU A O   81  LEU A O   1 
ATOM 667   C CB  . LEU A 1 81  ? 264.531 -43.670 249.926 1.0 43.32963  ? 81  LEU A CB  81  LEU A CB  1 
ATOM 668   C CG  . LEU A 1 81  ? 263.196 -44.142 250.494 1.0 43.32963  ? 81  LEU A CG  81  LEU A CG  1 
ATOM 669   C CD1 . LEU A 1 81  ? 263.302 -45.568 250.978 1.0 43.32963  ? 81  LEU A CD1 81  LEU A CD1 1 
ATOM 670   C CD2 . LEU A 1 81  ? 262.770 -43.228 251.621 1.0 43.32963  ? 81  LEU A CD2 81  LEU A CD2 1 
ATOM 671   N N   . ASN A 1 82  ? 263.907 -45.695 247.019 1.0 45.77094  ? 82  ASN A N   82  ASN A N   1 
ATOM 672   C CA  . ASN A 1 82  ? 263.172 -45.837 245.772 1.0 45.77094  ? 82  ASN A CA  82  ASN A CA  1 
ATOM 673   C C   . ASN A 1 82  ? 261.806 -46.427 246.099 1.0 45.77094  ? 82  ASN A C   82  ASN A C   1 
ATOM 674   O O   . ASN A 1 82  ? 261.589 -47.634 246.026 1.0 45.77094  ? 82  ASN A O   82  ASN A O   1 
ATOM 675   C CB  . ASN A 1 82  ? 263.956 -46.697 244.821 1.0 45.77094  ? 82  ASN A CB  82  ASN A CB  1 
ATOM 676   C CG  . ASN A 1 82  ? 263.447 -46.616 243.405 1.0 45.77094  ? 82  ASN A CG  82  ASN A CG  1 
ATOM 677   O OD1 . ASN A 1 82  ? 262.493 -45.899 243.113 1.0 45.77094  ? 82  ASN A OD1 82  ASN A OD1 1 
ATOM 678   N ND2 . ASN A 1 82  ? 264.088 -47.354 242.508 1.0 45.77094  ? 82  ASN A ND2 82  ASN A ND2 1 
ATOM 679   N N   . VAL A 1 83  ? 260.877 -45.552 246.467 1.0 45.29528  ? 83  VAL A N   83  VAL A N   1 
ATOM 680   C CA  . VAL A 1 83  ? 259.509 -45.964 246.749 1.0 45.29528  ? 83  VAL A CA  83  VAL A CA  1 
ATOM 681   C C   . VAL A 1 83  ? 258.803 -46.120 245.412 1.0 45.29528  ? 83  VAL A C   83  VAL A C   1 
ATOM 682   O O   . VAL A 1 83  ? 258.524 -45.134 244.729 1.0 45.29528  ? 83  VAL A O   83  VAL A O   1 
ATOM 683   C CB  . VAL A 1 83  ? 258.785 -44.953 247.642 1.0 45.29528  ? 83  VAL A CB  83  VAL A CB  1 
ATOM 684   C CG1 . VAL A 1 83  ? 257.350 -45.373 247.858 1.0 45.29528  ? 83  VAL A CG1 83  VAL A CG1 1 
ATOM 685   C CG2 . VAL A 1 83  ? 259.504 -44.823 248.955 1.0 45.29528  ? 83  VAL A CG2 83  VAL A CG2 1 
ATOM 686   N N   . GLY A 1 84  ? 258.506 -47.354 245.034 1.0 47.53199  ? 84  GLY A N   84  GLY A N   1 
ATOM 687   C CA  . GLY A 1 84  ? 257.809 -47.580 243.792 1.0 47.53199  ? 84  GLY A CA  84  GLY A CA  1 
ATOM 688   C C   . GLY A 1 84  ? 256.342 -47.222 243.908 1.0 47.53199  ? 84  GLY A C   84  GLY A C   1 
ATOM 689   O O   . GLY A 1 84  ? 255.864 -46.681 244.906 1.0 47.53199  ? 84  GLY A O   84  GLY A O   1 
ATOM 690   N N   . ASP A 1 85  ? 255.605 -47.568 242.859 1.0 51.46881  ? 85  ASP A N   85  ASP A N   1 
ATOM 691   C CA  . ASP A 1 85  ? 254.159 -47.424 242.864 1.0 51.46881  ? 85  ASP A CA  85  ASP A CA  1 
ATOM 692   C C   . ASP A 1 85  ? 253.552 -48.399 243.873 1.0 51.46881  ? 85  ASP A C   85  ASP A C   1 
ATOM 693   O O   . ASP A 1 85  ? 254.228 -49.289 244.385 1.0 51.46881  ? 85  ASP A O   85  ASP A O   1 
ATOM 694   C CB  . ASP A 1 85  ? 253.616 -47.669 241.458 1.0 51.46881  ? 85  ASP A CB  85  ASP A CB  1 
ATOM 695   C CG  . ASP A 1 85  ? 252.221 -47.135 241.265 1.0 51.46881  ? 85  ASP A CG  85  ASP A CG  1 
ATOM 696   O OD1 . ASP A 1 85  ? 251.654 -46.570 242.221 1.0 51.46881  ? 85  ASP A OD1 85  ASP A OD1 1 
ATOM 697   O OD2 . ASP A 1 85  ? 251.690 -47.285 240.145 1.0 51.46881  ? 85  ASP A OD2 85  ASP A OD2 1 
ATOM 698   N N   . ASN A 1 86  ? 252.294 -48.158 244.240 1.0 50.51716  ? 86  ASN A N   86  ASN A N   1 
ATOM 699   C CA  . ASN A 1 86  ? 251.492 -49.013 245.119 1.0 50.51716  ? 86  ASN A CA  86  ASN A CA  1 
ATOM 700   C C   . ASN A 1 86  ? 252.103 -49.220 246.507 1.0 50.51716  ? 86  ASN A C   86  ASN A C   1 
ATOM 701   O O   . ASN A 1 86  ? 251.708 -50.149 247.219 1.0 50.51716  ? 86  ASN A O   86  ASN A O   1 
ATOM 702   C CB  . ASN A 1 86  ? 251.216 -50.369 244.461 1.0 50.51716  ? 86  ASN A CB  86  ASN A CB  1 
ATOM 703   C CG  . ASN A 1 86  ? 250.351 -50.242 243.235 1.0 50.51716  ? 86  ASN A CG  86  ASN A CG  1 
ATOM 704   O OD1 . ASN A 1 86  ? 249.367 -49.505 243.231 1.0 50.51716  ? 86  ASN A OD1 86  ASN A OD1 1 
ATOM 705   N ND2 . ASN A 1 86  ? 250.722 -50.942 242.174 1.0 50.51716  ? 86  ASN A ND2 86  ASN A ND2 1 
ATOM 706   N N   . ARG A 1 87  ? 253.053 -48.381 246.906 1.0 49.1302   ? 87  ARG A N   87  ARG A N   1 
ATOM 707   C CA  . ARG A 1 87  ? 253.757 -48.502 248.169 1.0 49.1302   ? 87  ARG A CA  87  ARG A CA  1 
ATOM 708   C C   . ARG A 1 87  ? 253.701 -47.180 248.912 1.0 49.1302   ? 87  ARG A C   87  ARG A C   1 
ATOM 709   O O   . ARG A 1 87  ? 253.747 -46.106 248.310 1.0 49.1302   ? 87  ARG A O   87  ARG A O   1 
ATOM 710   C CB  . ARG A 1 87  ? 255.216 -48.906 247.966 1.0 49.1302   ? 87  ARG A CB  87  ARG A CB  1 
ATOM 711   C CG  . ARG A 1 87  ? 255.445 -50.357 247.607 1.0 49.1302   ? 87  ARG A CG  87  ARG A CG  1 
ATOM 712   C CD  . ARG A 1 87  ? 256.931 -50.600 247.462 1.0 49.1302   ? 87  ARG A CD  87  ARG A CD  1 
ATOM 713   N NE  . ARG A 1 87  ? 257.273 -52.011 247.300 1.0 49.1302   ? 87  ARG A NE  87  ARG A NE  1 
ATOM 714   C CZ  . ARG A 1 87  ? 258.510 -52.458 247.102 1.0 49.1302   ? 87  ARG A CZ  87  ARG A CZ  1 
ATOM 715   N NH1 . ARG A 1 87  ? 259.524 -51.605 247.028 1.0 49.1302   ? 87  ARG A NH1 87  ARG A NH1 1 
ATOM 716   N NH2 . ARG A 1 87  ? 258.738 -53.752 246.968 1.0 49.1302   ? 87  ARG A NH2 87  ARG A NH2 1 
ATOM 717   N N   . LEU A 1 88  ? 253.598 -47.270 250.230 1.0 46.36756  ? 88  LEU A N   88  LEU A N   1 
ATOM 718   C CA  . LEU A 1 88  ? 253.547 -46.108 251.100 1.0 46.36756  ? 88  LEU A CA  88  LEU A CA  1 
ATOM 719   C C   . LEU A 1 88  ? 254.496 -46.330 252.262 1.0 46.36756  ? 88  LEU A C   88  LEU A C   1 
ATOM 720   O O   . LEU A 1 88  ? 254.497 -47.404 252.869 1.0 46.36756  ? 88  LEU A O   88  LEU A O   1 
ATOM 721   C CB  . LEU A 1 88  ? 252.140 -45.884 251.625 1.0 46.36756  ? 88  LEU A CB  88  LEU A CB  1 
ATOM 722   C CG  . LEU A 1 88  ? 251.070 -45.527 250.605 1.0 46.36756  ? 88  LEU A CG  88  LEU A CG  1 
ATOM 723   C CD1 . LEU A 1 88  ? 249.735 -45.590 251.278 1.0 46.36756  ? 88  LEU A CD1 88  LEU A CD1 1 
ATOM 724   C CD2 . LEU A 1 88  ? 251.315 -44.149 250.045 1.0 46.36756  ? 88  LEU A CD2 88  LEU A CD2 1 
ATOM 725   N N   . VAL A 1 89  ? 255.302 -45.323 252.576 1.0 42.05872  ? 89  VAL A N   89  VAL A N   1 
ATOM 726   C CA  . VAL A 1 89  ? 256.230 -45.409 253.694 1.0 42.05872  ? 89  VAL A CA  89  VAL A CA  1 
ATOM 727   C C   . VAL A 1 89  ? 256.033 -44.192 254.586 1.0 42.05872  ? 89  VAL A C   89  VAL A C   1 
ATOM 728   O O   . VAL A 1 89  ? 255.829 -43.075 254.097 1.0 42.05872  ? 89  VAL A O   89  VAL A O   1 
ATOM 729   C CB  . VAL A 1 89  ? 257.694 -45.559 253.218 1.0 42.05872  ? 89  VAL A CB  89  VAL A CB  1 
ATOM 730   C CG1 . VAL A 1 89  ? 258.153 -44.399 252.371 1.0 42.05872  ? 89  VAL A CG1 89  VAL A CG1 1 
ATOM 731   C CG2 . VAL A 1 89  ? 258.646 -45.763 254.389 1.0 42.05872  ? 89  VAL A CG2 89  VAL A CG2 1 
ATOM 732   N N   . ASP A 1 90  ? 255.996 -44.427 255.891 1.0 44.1223   ? 90  ASP A N   90  ASP A N   1 
ATOM 733   C CA  . ASP A 1 90  ? 256.110 -43.363 256.871 1.0 44.1223   ? 90  ASP A CA  90  ASP A CA  1 
ATOM 734   C C   . ASP A 1 90  ? 257.569 -43.294 257.293 1.0 44.1223   ? 90  ASP A C   90  ASP A C   1 
ATOM 735   O O   . ASP A 1 90  ? 258.177 -44.322 257.604 1.0 44.1223   ? 90  ASP A O   90  ASP A O   1 
ATOM 736   C CB  . ASP A 1 90  ? 255.204 -43.635 258.072 1.0 44.1223   ? 90  ASP A CB  90  ASP A CB  1 
ATOM 737   C CG  . ASP A 1 90  ? 255.035 -42.423 258.976 1.0 44.1223   ? 90  ASP A CG  90  ASP A CG  1 
ATOM 738   O OD1 . ASP A 1 90  ? 255.617 -41.361 258.685 1.0 44.1223   ? 90  ASP A OD1 90  ASP A OD1 1 
ATOM 739   O OD2 . ASP A 1 90  ? 254.310 -42.528 259.984 1.0 44.1223   ? 90  ASP A OD2 90  ASP A OD2 1 
ATOM 740   N N   . LEU A 1 91  ? 258.133 -42.089 257.307 1.0 42.40387  ? 91  LEU A N   91  LEU A N   1 
ATOM 741   C CA  . LEU A 1 91  ? 259.531 -41.945 257.690 1.0 42.40387  ? 91  LEU A CA  91  LEU A CA  1 
ATOM 742   C C   . LEU A 1 91  ? 259.761 -42.068 259.190 1.0 42.40387  ? 91  LEU A C   91  LEU A C   1 
ATOM 743   O O   . LEU A 1 91  ? 260.913 -41.982 259.625 1.0 42.40387  ? 91  LEU A O   91  LEU A O   1 
ATOM 744   C CB  . LEU A 1 91  ? 260.092 -40.612 257.199 1.0 42.40387  ? 91  LEU A CB  91  LEU A CB  1 
ATOM 745   C CG  . LEU A 1 91  ? 260.229 -40.448 255.689 1.0 42.40387  ? 91  LEU A CG  91  LEU A CG  1 
ATOM 746   C CD1 . LEU A 1 91  ? 260.765 -39.069 255.355 1.0 42.40387  ? 91  LEU A CD1 91  LEU A CD1 1 
ATOM 747   C CD2 . LEU A 1 91  ? 261.104 -41.521 255.085 1.0 42.40387  ? 91  LEU A CD2 91  LEU A CD2 1 
ATOM 748   N N   . GLY A 1 92  ? 258.710 -42.256 259.990 1.0 43.96405  ? 92  GLY A N   92  GLY A N   1 
ATOM 749   C CA  . GLY A 1 92  ? 258.907 -42.667 261.366 1.0 43.96405  ? 92  GLY A CA  92  GLY A CA  1 
ATOM 750   C C   . GLY A 1 92  ? 259.476 -44.065 261.474 1.0 43.96405  ? 92  GLY A C   92  GLY A C   1 
ATOM 751   O O   . GLY A 1 92  ? 260.166 -44.386 262.445 1.0 43.96405  ? 92  GLY A O   92  GLY A O   1 
ATOM 752   N N   . SER A 1 93  ? 259.211 -44.909 260.478 1.0 43.12069  ? 93  SER A N   93  SER A N   1 
ATOM 753   C CA  . SER A 1 93  ? 259.797 -46.238 260.407 1.0 43.12069  ? 93  SER A CA  93  SER A CA  1 
ATOM 754   C C   . SER A 1 93  ? 261.223 -46.233 259.879 1.0 43.12069  ? 93  SER A C   93  SER A C   1 
ATOM 755   O O   . SER A 1 93  ? 261.850 -47.295 259.834 1.0 43.12069  ? 93  SER A O   93  SER A O   1 
ATOM 756   C CB  . SER A 1 93  ? 258.941 -47.137 259.522 1.0 43.12069  ? 93  SER A CB  93  SER A CB  1 
ATOM 757   O OG  . SER A 1 93  ? 258.957 -46.675 258.187 1.0 43.12069  ? 93  SER A OG  93  SER A OG  1 
ATOM 758   N N   . SER A 1 94  ? 261.746 -45.080 259.475 1.0 42.18277  ? 94  SER A N   94  SER A N   1 
ATOM 759   C CA  . SER A 1 94  ? 263.090 -45.009 258.927 1.0 42.18277  ? 94  SER A CA  94  SER A CA  1 
ATOM 760   C C   . SER A 1 94  ? 264.118 -44.833 260.030 1.0 42.18277  ? 94  SER A C   94  SER A C   1 
ATOM 761   O O   . SER A 1 94  ? 263.922 -44.051 260.962 1.0 42.18277  ? 94  SER A O   94  SER A O   1 
ATOM 762   C CB  . SER A 1 94  ? 263.202 -43.853 257.938 1.0 42.18277  ? 94  SER A CB  94  SER A CB  1 
ATOM 763   O OG  . SER A 1 94  ? 262.370 -44.067 256.817 1.0 42.18277  ? 94  SER A OG  94  SER A OG  1 
ATOM 764   N N   . TYR A 1 95  ? 265.221 -45.568 259.916 1.0 42.9658   ? 95  TYR A N   95  TYR A N   1 
ATOM 765   C CA  . TYR A 1 95  ? 266.366 -45.388 260.792 1.0 42.9658   ? 95  TYR A CA  95  TYR A CA  1 
ATOM 766   C C   . TYR A 1 95  ? 267.611 -45.879 260.079 1.0 42.9658   ? 95  TYR A C   95  TYR A C   1 
ATOM 767   O O   . TYR A 1 95  ? 267.536 -46.732 259.193 1.0 42.9658   ? 95  TYR A O   95  TYR A O   1 
ATOM 768   C CB  . TYR A 1 95  ? 266.190 -46.113 262.129 1.0 42.9658   ? 95  TYR A CB  95  TYR A CB  1 
ATOM 769   C CG  . TYR A 1 95  ? 265.975 -47.605 262.059 1.0 42.9658   ? 95  TYR A CG  95  TYR A CG  1 
ATOM 770   C CD1 . TYR A 1 95  ? 264.699 -48.130 261.958 1.0 42.9658   ? 95  TYR A CD1 95  TYR A CD1 1 
ATOM 771   C CD2 . TYR A 1 95  ? 267.040 -48.488 262.142 1.0 42.9658   ? 95  TYR A CD2 95  TYR A CD2 1 
ATOM 772   C CE1 . TYR A 1 95  ? 264.492 -49.489 261.909 1.0 42.9658   ? 95  TYR A CE1 95  TYR A CE1 1 
ATOM 773   C CE2 . TYR A 1 95  ? 266.841 -49.845 262.088 1.0 42.9658   ? 95  TYR A CE2 95  TYR A CE2 1 
ATOM 774   C CZ  . TYR A 1 95  ? 265.567 -50.339 261.977 1.0 42.9658   ? 95  TYR A CZ  95  TYR A CZ  1 
ATOM 775   O OH  . TYR A 1 95  ? 265.371 -51.696 261.929 1.0 42.9658   ? 95  TYR A OH  95  TYR A OH  1 
ATOM 776   N N   . PHE A 1 96  ? 268.753 -45.328 260.471 1.0 42.64101  ? 96  PHE A N   96  PHE A N   1 
ATOM 777   C CA  . PHE A 1 96  ? 270.036 -45.756 259.938 1.0 42.64101  ? 96  PHE A CA  96  PHE A CA  1 
ATOM 778   C C   . PHE A 1 96  ? 270.597 -46.854 260.829 1.0 42.64101  ? 96  PHE A C   96  PHE A C   1 
ATOM 779   O O   . PHE A 1 96  ? 270.754 -46.661 262.038 1.0 42.64101  ? 96  PHE A O   96  PHE A O   1 
ATOM 780   C CB  . PHE A 1 96  ? 271.019 -44.591 259.867 1.0 42.64101  ? 96  PHE A CB  96  PHE A CB  1 
ATOM 781   C CG  . PHE A 1 96  ? 270.617 -43.503 258.921 1.0 42.64101  ? 96  PHE A CG  96  PHE A CG  1 
ATOM 782   C CD1 . PHE A 1 96  ? 270.887 -43.603 257.570 1.0 42.64101  ? 96  PHE A CD1 96  PHE A CD1 1 
ATOM 783   C CD2 . PHE A 1 96  ? 269.984 -42.368 259.388 1.0 42.64101  ? 96  PHE A CD2 96  PHE A CD2 1 
ATOM 784   C CE1 . PHE A 1 96  ? 270.526 -42.592 256.703 1.0 42.64101  ? 96  PHE A CE1 96  PHE A CE1 1 
ATOM 785   C CE2 . PHE A 1 96  ? 269.620 -41.359 258.523 1.0 42.64101  ? 96  PHE A CE2 96  PHE A CE2 1 
ATOM 786   C CZ  . PHE A 1 96  ? 269.896 -41.471 257.183 1.0 42.64101  ? 96  PHE A CZ  96  PHE A CZ  1 
ATOM 787   N N   . ASP A 1 97  ? 270.894 -47.998 260.232 1.0 45.07464  ? 97  ASP A N   97  ASP A N   1 
ATOM 788   C CA  . ASP A 1 97  ? 271.422 -49.153 260.949 1.0 45.07464  ? 97  ASP A CA  97  ASP A CA  1 
ATOM 789   C C   . ASP A 1 97  ? 272.935 -49.139 260.784 1.0 45.07464  ? 97  ASP A C   97  ASP A C   1 
ATOM 790   O O   . ASP A 1 97  ? 273.481 -49.678 259.825 1.0 45.07464  ? 97  ASP A O   97  ASP A O   1 
ATOM 791   C CB  . ASP A 1 97  ? 270.789 -50.431 260.419 1.0 45.07464  ? 97  ASP A CB  97  ASP A CB  1 
ATOM 792   C CG  . ASP A 1 97  ? 271.268 -51.664 261.138 1.0 45.07464  ? 97  ASP A CG  97  ASP A CG  1 
ATOM 793   O OD1 . ASP A 1 97  ? 270.889 -51.872 262.310 1.0 45.07464  ? 97  ASP A OD1 97  ASP A OD1 1 
ATOM 794   O OD2 . ASP A 1 97  ? 272.001 -52.451 260.509 1.0 45.07464  ? 97  ASP A OD2 97  ASP A OD2 1 
ATOM 795   N N   . ILE A 1 98  ? 273.614 -48.510 261.731 1.0 45.72381  ? 98  ILE A N   98  ILE A N   1 
ATOM 796   C CA  . ILE A 1 98  ? 275.047 -48.268 261.644 1.0 45.72381  ? 98  ILE A CA  98  ILE A CA  1 
ATOM 797   C C   . ILE A 1 98  ? 275.795 -49.422 262.289 1.0 45.72381  ? 98  ILE A C   98  ILE A C   1 
ATOM 798   O O   . ILE A 1 98  ? 275.524 -49.785 263.438 1.0 45.72381  ? 98  ILE A O   98  ILE A O   1 
ATOM 799   C CB  . ILE A 1 98  ? 275.409 -46.941 262.326 1.0 45.72381  ? 98  ILE A CB  98  ILE A CB  1 
ATOM 800   C CG1 . ILE A 1 98  ? 274.778 -45.765 261.593 1.0 45.72381  ? 98  ILE A CG1 98  ILE A CG1 1 
ATOM 801   C CG2 . ILE A 1 98  ? 276.891 -46.778 262.430 1.0 45.72381  ? 98  ILE A CG2 98  ILE A CG2 1 
ATOM 802   C CD1 . ILE A 1 98  ? 274.867 -44.490 262.373 1.0 45.72381  ? 98  ILE A CD1 98  ILE A CD1 1 
ATOM 803   N N   . LYS A 1 99  ? 276.739 -49.998 261.555 1.0 49.33816  ? 99  LYS A N   99  LYS A N   1 
ATOM 804   C CA  . LYS A 1 99  ? 277.661 -50.987 262.087 1.0 49.33816  ? 99  LYS A CA  99  LYS A CA  1 
ATOM 805   C C   . LYS A 1 99  ? 279.075 -50.445 261.964 1.0 49.33816  ? 99  LYS A C   99  LYS A C   1 
ATOM 806   O O   . LYS A 1 99  ? 279.430 -49.847 260.946 1.0 49.33816  ? 99  LYS A O   99  LYS A O   1 
ATOM 807   C CB  . LYS A 1 99  ? 277.538 -52.317 261.343 1.0 49.33816  ? 99  LYS A CB  99  LYS A CB  1 
ATOM 808   C CG  . LYS A 1 99  ? 278.368 -53.438 261.934 1.0 49.33816  ? 99  LYS A CG  99  LYS A CG  1 
ATOM 809   C CD  . LYS A 1 99  ? 278.304 -54.688 261.081 1.0 49.33816  ? 99  LYS A CD  99  LYS A CD  1 
ATOM 810   C CE  . LYS A 1 99  ? 276.962 -55.369 261.213 1.0 49.33816  ? 99  LYS A CE  99  LYS A CE  1 
ATOM 811   N NZ  . LYS A 1 99  ? 276.940 -56.659 260.476 1.0 49.33816  ? 99  LYS A NZ  99  LYS A NZ  1 
ATOM 812   N N   . GLY A 1 100 ? 279.874 -50.634 263.006 1.0 51.08411  ? 100 GLY A N   100 GLY A N   1 
ATOM 813   C CA  . GLY A 1 100 ? 281.241 -50.171 262.978 1.0 51.08411  ? 100 GLY A CA  100 GLY A CA  1 
ATOM 814   C C   . GLY A 1 100 ? 282.063 -50.824 264.065 1.0 51.08411  ? 100 GLY A C   100 GLY A C   1 
ATOM 815   O O   . GLY A 1 100 ? 281.661 -51.825 264.658 1.0 51.08411  ? 100 GLY A O   100 GLY A O   1 
ATOM 816   N N   . THR A 1 101 ? 283.231 -50.241 264.317 1.0 54.70061  ? 101 THR A N   101 THR A N   1 
ATOM 817   C CA  . THR A 1 101 ? 284.056 -50.613 265.455 1.0 54.70061  ? 101 THR A CA  101 THR A CA  1 
ATOM 818   C C   . THR A 1 101 ? 284.481 -49.354 266.192 1.0 54.70061  ? 101 THR A C   101 THR A C   1 
ATOM 819   O O   . THR A 1 101 ? 284.495 -48.258 265.627 1.0 54.70061  ? 101 THR A O   101 THR A O   1 
ATOM 820   C CB  . THR A 1 101 ? 285.283 -51.441 265.043 1.0 54.70061  ? 101 THR A CB  101 THR A CB  1 
ATOM 821   O OG1 . THR A 1 101 ? 286.021 -51.817 266.213 1.0 54.70061  ? 101 THR A OG1 101 THR A OG1 1 
ATOM 822   C CG2 . THR A 1 101 ? 286.178 -50.674 264.103 1.0 54.70061  ? 101 THR A CG2 101 THR A CG2 1 
ATOM 823   N N   . LEU A 1 102 ? 284.809 -49.515 267.467 1.0 55.06145  ? 102 LEU A N   102 LEU A N   1 
ATOM 824   C CA  . LEU A 1 102 ? 285.001 -48.386 268.361 1.0 55.06145  ? 102 LEU A CA  102 LEU A CA  1 
ATOM 825   C C   . LEU A 1 102 ? 286.251 -48.570 269.206 1.0 55.06145  ? 102 LEU A C   102 LEU A C   1 
ATOM 826   O O   . LEU A 1 102 ? 286.501 -49.652 269.741 1.0 55.06145  ? 102 LEU A O   102 LEU A O   1 
ATOM 827   C CB  . LEU A 1 102 ? 283.778 -48.199 269.263 1.0 55.06145  ? 102 LEU A CB  102 LEU A CB  1 
ATOM 828   C CG  . LEU A 1 102 ? 283.861 -47.095 270.316 1.0 55.06145  ? 102 LEU A CG  102 LEU A CG  1 
ATOM 829   C CD1 . LEU A 1 102 ? 284.064 -45.752 269.677 1.0 55.06145  ? 102 LEU A CD1 102 LEU A CD1 1 
ATOM 830   C CD2 . LEU A 1 102 ? 282.625 -47.066 271.164 1.0 55.06145  ? 102 LEU A CD2 102 LEU A CD2 1 
ATOM 831   N N   . ASP A 1 103 ? 287.036 -47.506 269.301 1.0 59.4164   ? 103 ASP A N   103 ASP A N   1 
ATOM 832   C CA  . ASP A 1 103 ? 288.196 -47.429 270.173 1.0 59.4164   ? 103 ASP A CA  103 ASP A CA  1 
ATOM 833   C C   . ASP A 1 103 ? 287.861 -46.435 271.276 1.0 59.4164   ? 103 ASP A C   103 ASP A C   1 
ATOM 834   O O   . ASP A 1 103 ? 287.659 -45.249 271.001 1.0 59.4164   ? 103 ASP A O   103 ASP A O   1 
ATOM 835   C CB  . ASP A 1 103 ? 289.423 -46.988 269.375 1.0 59.4164   ? 103 ASP A CB  103 ASP A CB  1 
ATOM 836   C CG  . ASP A 1 103 ? 290.720 -47.136 270.140 1.0 59.4164   ? 103 ASP A CG  103 ASP A CG  1 
ATOM 837   O OD1 . ASP A 1 103 ? 290.701 -47.533 271.314 1.0 59.4164   ? 103 ASP A OD1 103 ASP A OD1 1 
ATOM 838   O OD2 . ASP A 1 103 ? 291.781 -46.856 269.549 1.0 59.4164   ? 103 ASP A OD2 103 ASP A OD2 1 
ATOM 839   N N   . ARG A 1 104 ? 287.790 -46.916 272.514 1.0 58.23158  ? 104 ARG A N   104 ARG A N   1 
ATOM 840   C CA  . ARG A 1 104 ? 287.441 -46.051 273.631 1.0 58.23158  ? 104 ARG A CA  104 ARG A CA  1 
ATOM 841   C C   . ARG A 1 104 ? 288.641 -45.352 274.248 1.0 58.23158  ? 104 ARG A C   104 ARG A C   1 
ATOM 842   O O   . ARG A 1 104 ? 288.455 -44.403 275.015 1.0 58.23158  ? 104 ARG A O   104 ARG A O   1 
ATOM 843   C CB  . ARG A 1 104 ? 286.729 -46.839 274.726 1.0 58.23158  ? 104 ARG A CB  104 ARG A CB  1 
ATOM 844   C CG  . ARG A 1 104 ? 285.332 -47.317 274.406 1.0 58.23158  ? 104 ARG A CG  104 ARG A CG  1 
ATOM 845   C CD  . ARG A 1 104 ? 284.806 -47.972 275.656 1.0 58.23158  ? 104 ARG A CD  104 ARG A CD  1 
ATOM 846   N NE  . ARG A 1 104 ? 283.460 -48.516 275.574 1.0 58.23158  ? 104 ARG A NE  104 ARG A NE  1 
ATOM 847   C CZ  . ARG A 1 104 ? 283.197 -49.771 275.244 1.0 58.23158  ? 104 ARG A CZ  104 ARG A CZ  1 
ATOM 848   N NH1 . ARG A 1 104 ? 281.951 -50.200 275.215 1.0 58.23158  ? 104 ARG A NH1 104 ARG A NH1 1 
ATOM 849   N NH2 . ARG A 1 104 ? 284.183 -50.596 274.933 1.0 58.23158  ? 104 ARG A NH2 104 ARG A NH2 1 
ATOM 850   N N   . GLY A 1 105 ? 289.854 -45.794 273.950 1.0 63.04746  ? 105 GLY A N   105 GLY A N   1 
ATOM 851   C CA  . GLY A 1 105 ? 291.036 -45.146 274.460 1.0 63.04746  ? 105 GLY A CA  105 GLY A CA  1 
ATOM 852   C C   . GLY A 1 105 ? 291.430 -45.638 275.835 1.0 63.04746  ? 105 GLY A C   105 GLY A C   1 
ATOM 853   O O   . GLY A 1 105 ? 290.720 -46.425 276.467 1.0 63.04746  ? 105 GLY A O   105 GLY A O   1 
ATOM 854   N N   . PRO A 1 106 ? 292.579 -45.171 276.332 1.0 64.22472  ? 106 PRO A N   106 PRO A N   1 
ATOM 855   C CA  . PRO A 1 106 ? 293.078 -45.655 277.624 1.0 64.22472  ? 106 PRO A CA  106 PRO A CA  1 
ATOM 856   C C   . PRO A 1 106 ? 292.374 -45.061 278.830 1.0 64.22472  ? 106 PRO A C   106 PRO A C   1 
ATOM 857   O O   . PRO A 1 106 ? 292.618 -45.522 279.952 1.0 64.22472  ? 106 PRO A O   106 PRO A O   1 
ATOM 858   C CB  . PRO A 1 106 ? 294.549 -45.237 277.599 1.0 64.22472  ? 106 PRO A CB  106 PRO A CB  1 
ATOM 859   C CG  . PRO A 1 106 ? 294.561 -44.028 276.749 1.0 64.22472  ? 106 PRO A CG  106 PRO A CG  1 
ATOM 860   C CD  . PRO A 1 106 ? 293.523 -44.244 275.692 1.0 64.22472  ? 106 PRO A CD  106 PRO A CD  1 
ATOM 861   N N   . SER A 1 107 ? 291.516 -44.062 278.643 1.0 62.12648  ? 107 SER A N   107 SER A N   1 
ATOM 862   C CA  . SER A 1 107 ? 290.818 -43.417 279.746 1.0 62.12648  ? 107 SER A CA  107 SER A CA  1 
ATOM 863   C C   . SER A 1 107 ? 289.575 -44.166 280.190 1.0 62.12648  ? 107 SER A C   107 SER A C   1 
ATOM 864   O O   . SER A 1 107 ? 288.827 -43.651 281.023 1.0 62.12648  ? 107 SER A O   107 SER A O   1 
ATOM 865   C CB  . SER A 1 107 ? 290.421 -41.997 279.357 1.0 62.12648  ? 107 SER A CB  107 SER A CB  1 
ATOM 866   O OG  . SER A 1 107 ? 289.456 -42.004 278.325 1.0 62.12648  ? 107 SER A OG  107 SER A OG  1 
ATOM 867   N N   . PHE A 1 108 ? 289.328 -45.349 279.652 1.0 58.12093  ? 108 PHE A N   108 PHE A N   1 
ATOM 868   C CA  . PHE A 1 108 ? 288.115 -46.090 279.939 1.0 58.12093  ? 108 PHE A CA  108 PHE A CA  1 
ATOM 869   C C   . PHE A 1 108 ? 288.362 -47.043 281.096 1.0 58.12093  ? 108 PHE A C   108 PHE A C   1 
ATOM 870   O O   . PHE A 1 108 ? 289.355 -47.775 281.100 1.0 58.12093  ? 108 PHE A O   108 PHE A O   1 
ATOM 871   C CB  . PHE A 1 108 ? 287.671 -46.844 278.690 1.0 58.12093  ? 108 PHE A CB  108 PHE A CB  1 
ATOM 872   C CG  . PHE A 1 108 ? 286.408 -47.611 278.859 1.0 58.12093  ? 108 PHE A CG  108 PHE A CG  1 
ATOM 873   C CD1 . PHE A 1 108 ? 285.208 -46.955 279.041 1.0 58.12093  ? 108 PHE A CD1 108 PHE A CD1 1 
ATOM 874   C CD2 . PHE A 1 108 ? 286.409 -48.988 278.780 1.0 58.12093  ? 108 PHE A CD2 108 PHE A CD2 1 
ATOM 875   C CE1 . PHE A 1 108 ? 284.033 -47.665 279.175 1.0 58.12093  ? 108 PHE A CE1 108 PHE A CE1 1 
ATOM 876   C CE2 . PHE A 1 108 ? 285.239 -49.697 278.899 1.0 58.12093  ? 108 PHE A CE2 108 PHE A CE2 1 
ATOM 877   C CZ  . PHE A 1 108 ? 284.052 -49.035 279.106 1.0 58.12093  ? 108 PHE A CZ  108 PHE A CZ  1 
ATOM 878   N N   . LYS A 1 109 ? 287.468 -47.023 282.076 1.0 58.87191  ? 109 LYS A N   109 LYS A N   1 
ATOM 879   C CA  . LYS A 1 109 ? 287.566 -47.898 283.236 1.0 58.87191  ? 109 LYS A CA  109 LYS A CA  1 
ATOM 880   C C   . LYS A 1 109 ? 286.164 -48.064 283.806 1.0 58.87191  ? 109 LYS A C   109 LYS A C   1 
ATOM 881   O O   . LYS A 1 109 ? 285.722 -47.250 284.625 1.0 58.87191  ? 109 LYS A O   109 LYS A O   1 
ATOM 882   C CB  . LYS A 1 109 ? 288.551 -47.319 284.256 1.0 58.87191  ? 109 LYS A CB  109 LYS A CB  1 
ATOM 883   C CG  . LYS A 1 109 ? 288.889 -48.224 285.423 1.0 58.87191  ? 109 LYS A CG  109 LYS A CG  1 
ATOM 884   C CD  . LYS A 1 109 ? 288.172 -47.790 286.682 1.0 58.87191  ? 109 LYS A CD  109 LYS A CD  1 
ATOM 885   C CE  . LYS A 1 109 ? 288.504 -48.668 287.855 1.0 58.87191  ? 109 LYS A CE  109 LYS A CE  1 
ATOM 886   N NZ  . LYS A 1 109 ? 289.903 -48.533 288.258 1.0 58.87191  ? 109 LYS A NZ  109 LYS A NZ  1 
ATOM 887   N N   . PRO A 1 110 ? 285.421 -49.079 283.373 1.0 57.73937  ? 110 PRO A N   110 PRO A N   1 
ATOM 888   C CA  . PRO A 1 110 ? 283.986 -49.126 283.676 1.0 57.73937  ? 110 PRO A CA  110 PRO A CA  1 
ATOM 889   C C   . PRO A 1 110 ? 283.609 -49.766 284.999 1.0 57.73937  ? 110 PRO A C   110 PRO A C   1 
ATOM 890   O O   . PRO A 1 110 ? 282.605 -50.479 285.044 1.0 57.73937  ? 110 PRO A O   110 PRO A O   1 
ATOM 891   C CB  . PRO A 1 110 ? 283.433 -49.968 282.526 1.0 57.73937  ? 110 PRO A CB  110 PRO A CB  1 
ATOM 892   C CG  . PRO A 1 110 ? 284.545 -50.895 282.215 1.0 57.73937  ? 110 PRO A CG  110 PRO A CG  1 
ATOM 893   C CD  . PRO A 1 110 ? 285.810 -50.117 282.409 1.0 57.73937  ? 110 PRO A CD  110 PRO A CD  1 
ATOM 894   N N   . TYR A 1 111 ? 284.334 -49.488 286.076 1.0 59.83536  ? 111 TYR A N   111 TYR A N   1 
ATOM 895   C CA  . TYR A 1 111 ? 284.012 -50.052 287.382 1.0 59.83536  ? 111 TYR A CA  111 TYR A CA  1 
ATOM 896   C C   . TYR A 1 111 ? 284.708 -49.222 288.448 1.0 59.83536  ? 111 TYR A C   111 TYR A C   1 
ATOM 897   O O   . TYR A 1 111 ? 285.272 -48.165 288.166 1.0 59.83536  ? 111 TYR A O   111 TYR A O   1 
ATOM 898   C CB  . TYR A 1 111 ? 284.389 -51.536 287.470 1.0 59.83536  ? 111 TYR A CB  111 TYR A CB  1 
ATOM 899   C CG  . TYR A 1 111 ? 285.843 -51.860 287.250 1.0 59.83536  ? 111 TYR A CG  111 TYR A CG  1 
ATOM 900   C CD1 . TYR A 1 111 ? 286.342 -52.074 285.974 1.0 59.83536  ? 111 TYR A CD1 111 TYR A CD1 1 
ATOM 901   C CD2 . TYR A 1 111 ? 286.705 -52.001 288.319 1.0 59.83536  ? 111 TYR A CD2 111 TYR A CD2 1 
ATOM 902   C CE1 . TYR A 1 111 ? 287.671 -52.385 285.772 1.0 59.83536  ? 111 TYR A CE1 111 TYR A CE1 1 
ATOM 903   C CE2 . TYR A 1 111 ? 288.032 -52.314 288.126 1.0 59.83536  ? 111 TYR A CE2 111 TYR A CE2 1 
ATOM 904   C CZ  . TYR A 1 111 ? 288.507 -52.508 286.852 1.0 59.83536  ? 111 TYR A CZ  111 TYR A CZ  1 
ATOM 905   O OH  . TYR A 1 111 ? 289.828 -52.823 286.660 1.0 59.83536  ? 111 TYR A OH  111 TYR A OH  1 
ATOM 906   N N   . GLY A 1 112 ? 284.648 -49.697 289.685 1.0 61.58358  ? 112 GLY A N   112 GLY A N   1 
ATOM 907   C CA  . GLY A 1 112 ? 285.250 -49.012 290.810 1.0 61.58358  ? 112 GLY A CA  112 GLY A CA  1 
ATOM 908   C C   . GLY A 1 112 ? 286.294 -49.882 291.477 1.0 61.58358  ? 112 GLY A C   112 GLY A C   1 
ATOM 909   O O   . GLY A 1 112 ? 286.160 -51.105 291.527 1.0 61.58358  ? 112 GLY A O   112 GLY A O   1 
ATOM 910   N N   . GLY A 1 113 ? 287.337 -49.245 291.990 1.0 65.72837  ? 113 GLY A N   113 GLY A N   1 
ATOM 911   C CA  . GLY A 1 113 ? 288.376 -49.997 292.674 1.0 65.72837  ? 113 GLY A CA  113 GLY A CA  1 
ATOM 912   C C   . GLY A 1 113 ? 289.254 -50.733 291.683 1.0 65.72837  ? 113 GLY A C   113 GLY A C   1 
ATOM 913   O O   . GLY A 1 113 ? 289.558 -50.230 290.598 1.0 65.72837  ? 113 GLY A O   113 GLY A O   1 
ATOM 914   N N   . THR A 1 114 ? 289.661 -51.945 292.050 1.0 65.22975  ? 114 THR A N   114 THR A N   1 
ATOM 915   C CA  . THR A 1 114 ? 290.551 -52.751 291.230 1.0 65.22975  ? 114 THR A CA  114 THR A CA  1 
ATOM 916   C C   . THR A 1 114 ? 289.934 -54.122 291.014 1.0 65.22975  ? 114 THR A C   114 THR A C   1 
ATOM 917   O O   . THR A 1 114 ? 288.886 -54.454 291.571 1.0 65.22975  ? 114 THR A O   114 THR A O   1 
ATOM 918   C CB  . THR A 1 114 ? 291.928 -52.905 291.874 1.0 65.22975  ? 114 THR A CB  114 THR A CB  1 
ATOM 919   O OG1 . THR A 1 114 ? 292.805 -53.580 290.969 1.0 65.22975  ? 114 THR A OG1 114 THR A OG1 1 
ATOM 920   C CG2 . THR A 1 114 ? 291.813 -53.726 293.126 1.0 65.22975  ? 114 THR A CG2 114 THR A CG2 1 
ATOM 921   N N   . ALA A 1 115 ? 290.602 -54.925 290.191 1.0 65.35757  ? 115 ALA A N   115 ALA A N   1 
ATOM 922   C CA  . ALA A 1 115 ? 290.214 -56.309 289.970 1.0 65.35757  ? 115 ALA A CA  115 ALA A CA  1 
ATOM 923   C C   . ALA A 1 115 ? 291.340 -57.272 290.304 1.0 65.35757  ? 115 ALA A C   115 ALA A C   1 
ATOM 924   O O   . ALA A 1 115 ? 291.248 -58.457 289.972 1.0 65.35757  ? 115 ALA A O   115 ALA A O   1 
ATOM 925   C CB  . ALA A 1 115 ? 289.764 -56.515 288.523 1.0 65.35757  ? 115 ALA A CB  115 ALA A CB  1 
ATOM 926   N N   . TYR A 1 116 ? 292.402 -56.794 290.947 1.0 66.5974   ? 116 TYR A N   116 TYR A N   1 
ATOM 927   C CA  . TYR A 1 116 ? 293.572 -57.609 291.235 1.0 66.5974   ? 116 TYR A CA  116 TYR A CA  1 
ATOM 928   C C   . TYR A 1 116 ? 293.965 -57.405 292.686 1.0 66.5974   ? 116 TYR A C   116 TYR A C   1 
ATOM 929   O O   . TYR A 1 116 ? 294.218 -56.270 293.101 1.0 66.5974   ? 116 TYR A O   116 TYR A O   1 
ATOM 930   C CB  . TYR A 1 116 ? 294.723 -57.250 290.301 1.0 66.5974   ? 116 TYR A CB  116 TYR A CB  1 
ATOM 931   C CG  . TYR A 1 116 ? 294.372 -57.500 288.864 1.0 66.5974   ? 116 TYR A CG  116 TYR A CG  1 
ATOM 932   C CD1 . TYR A 1 116 ? 294.315 -58.788 288.367 1.0 66.5974   ? 116 TYR A CD1 116 TYR A CD1 1 
ATOM 933   C CD2 . TYR A 1 116 ? 294.091 -56.452 288.006 1.0 66.5974   ? 116 TYR A CD2 116 TYR A CD2 1 
ATOM 934   C CE1 . TYR A 1 116 ? 293.982 -59.029 287.055 1.0 66.5974   ? 116 TYR A CE1 116 TYR A CE1 1 
ATOM 935   C CE2 . TYR A 1 116 ? 293.764 -56.682 286.689 1.0 66.5974   ? 116 TYR A CE2 116 TYR A CE2 1 
ATOM 936   C CZ  . TYR A 1 116 ? 293.714 -57.972 286.219 1.0 66.5974   ? 116 TYR A CZ  116 TYR A CZ  1 
ATOM 937   O OH  . TYR A 1 116 ? 293.387 -58.205 284.905 1.0 66.5974   ? 116 TYR A OH  116 TYR A OH  1 
ATOM 938   N N   . ASN A 1 117 ? 294.049 -58.510 293.424 1.0 66.40158  ? 117 ASN A N   117 ASN A N   1 
ATOM 939   C CA  . ASN A 1 117 ? 294.206 -58.528 294.875 1.0 66.40158  ? 117 ASN A CA  117 ASN A CA  1 
ATOM 940   C C   . ASN A 1 117 ? 293.248 -57.576 295.602 1.0 66.40158  ? 117 ASN A C   117 ASN A C   1 
ATOM 941   O O   . ASN A 1 117 ? 293.691 -56.711 296.363 1.0 66.40158  ? 117 ASN A O   117 ASN A O   1 
ATOM 942   C CB  . ASN A 1 117 ? 295.649 -58.220 295.248 1.0 66.40158  ? 117 ASN A CB  117 ASN A CB  1 
ATOM 943   C CG  . ASN A 1 117 ? 296.637 -59.164 294.593 1.0 66.40158  ? 117 ASN A CG  117 ASN A CG  1 
ATOM 944   O OD1 . ASN A 1 117 ? 297.365 -58.774 293.687 1.0 66.40158  ? 117 ASN A OD1 117 ASN A OD1 1 
ATOM 945   N ND2 . ASN A 1 117 ? 296.697 -60.391 295.072 1.0 66.40158  ? 117 ASN A ND2 117 ASN A ND2 1 
ATOM 946   N N   . PRO A 1 118 ? 291.931 -57.704 295.390 1.0 64.60499  ? 118 PRO A N   118 PRO A N   1 
ATOM 947   C CA  . PRO A 1 118 ? 291.023 -56.636 295.832 1.0 64.60499  ? 118 PRO A CA  118 PRO A CA  1 
ATOM 948   C C   . PRO A 1 118 ? 290.778 -56.617 297.327 1.0 64.60499  ? 118 PRO A C   118 PRO A C   1 
ATOM 949   O O   . PRO A 1 118 ? 290.356 -55.580 297.845 1.0 64.60499  ? 118 PRO A O   118 PRO A O   1 
ATOM 950   C CB  . PRO A 1 118 ? 289.733 -56.944 295.071 1.0 64.60499  ? 118 PRO A CB  118 PRO A CB  1 
ATOM 951   C CG  . PRO A 1 118 ? 289.741 -58.412 294.973 1.0 64.60499  ? 118 PRO A CG  118 PRO A CG  1 
ATOM 952   C CD  . PRO A 1 118 ? 291.173 -58.838 294.828 1.0 64.60499  ? 118 PRO A CD  118 PRO A CD  1 
ATOM 953   N N   . LEU A 1 119 ? 291.023 -57.718 298.032 1.0 63.72346  ? 119 LEU A N   119 LEU A N   1 
ATOM 954   C CA  . LEU A 1 119 ? 290.843 -57.772 299.474 1.0 63.72346  ? 119 LEU A CA  119 LEU A CA  1 
ATOM 955   C C   . LEU A 1 119 ? 292.083 -57.349 300.240 1.0 63.72346  ? 119 LEU A C   119 LEU A C   1 
ATOM 956   O O   . LEU A 1 119 ? 292.065 -57.364 301.474 1.0 63.72346  ? 119 LEU A O   119 LEU A O   1 
ATOM 957   C CB  . LEU A 1 119 ? 290.444 -59.181 299.909 1.0 63.72346  ? 119 LEU A CB  119 LEU A CB  1 
ATOM 958   C CG  . LEU A 1 119 ? 289.081 -59.657 299.425 1.0 63.72346  ? 119 LEU A CG  119 LEU A CG  1 
ATOM 959   C CD1 . LEU A 1 119 ? 288.836 -61.094 299.843 1.0 63.72346  ? 119 LEU A CD1 119 LEU A CD1 1 
ATOM 960   C CD2 . LEU A 1 119 ? 288.000 -58.746 299.961 1.0 63.72346  ? 119 LEU A CD2 119 LEU A CD2 1 
ATOM 961   N N   . ALA A 1 120 ? 293.143 -56.985 299.554 1.0 65.49605  ? 120 ALA A N   120 ALA A N   1 
ATOM 962   C CA  . ALA A 1 120 ? 294.357 -56.592 300.240 1.0 65.49605  ? 120 ALA A CA  120 ALA A CA  1 
ATOM 963   C C   . ALA A 1 120 ? 294.236 -55.167 300.767 1.0 65.49605  ? 120 ALA A C   120 ALA A C   1 
ATOM 964   O O   . ALA A 1 120 ? 293.510 -54.350 300.197 1.0 65.49605  ? 120 ALA A O   120 ALA A O   1 
ATOM 965   C CB  . ALA A 1 120 ? 295.551 -56.685 299.300 1.0 65.49605  ? 120 ALA A CB  120 ALA A CB  1 
ATOM 966   N N   . PRO A 1 121 ? 294.911 -54.854 301.870 1.0 68.33787  ? 121 PRO A N   121 PRO A N   1 
ATOM 967   C CA  . PRO A 1 121 ? 295.074 -53.450 302.251 1.0 68.33787  ? 121 PRO A CA  121 PRO A CA  1 
ATOM 968   C C   . PRO A 1 121 ? 295.933 -52.727 301.231 1.0 68.33787  ? 121 PRO A C   121 PRO A C   1 
ATOM 969   O O   . PRO A 1 121 ? 296.828 -53.309 300.616 1.0 68.33787  ? 121 PRO A O   121 PRO A O   1 
ATOM 970   C CB  . PRO A 1 121 ? 295.769 -53.527 303.613 1.0 68.33787  ? 121 PRO A CB  121 PRO A CB  1 
ATOM 971   C CG  . PRO A 1 121 ? 295.425 -54.875 304.130 1.0 68.33787  ? 121 PRO A CG  121 PRO A CG  1 
ATOM 972   C CD  . PRO A 1 121 ? 295.384 -55.762 302.927 1.0 68.33787  ? 121 PRO A CD  121 PRO A CD  1 
ATOM 973   N N   . LYS A 1 122 ? 295.643 -51.440 301.048 1.0 70.31358  ? 122 LYS A N   122 LYS A N   1 
ATOM 974   C CA  . LYS A 1 122 ? 296.283 -50.681 299.983 1.0 70.31358  ? 122 LYS A CA  122 LYS A CA  1 
ATOM 975   C C   . LYS A 1 122 ? 297.745 -50.376 300.276 1.0 70.31358  ? 122 LYS A C   122 LYS A C   1 
ATOM 976   O O   . LYS A 1 122 ? 298.491 -50.044 299.351 1.0 70.31358  ? 122 LYS A O   122 LYS A O   1 
ATOM 977   C CB  . LYS A 1 122 ? 295.508 -49.390 299.740 1.0 70.31358  ? 122 LYS A CB  122 LYS A CB  1 
ATOM 978   C CG  . LYS A 1 122 ? 294.099 -49.624 299.222 1.0 70.31358  ? 122 LYS A CG  122 LYS A CG  1 
ATOM 979   C CD  . LYS A 1 122 ? 293.345 -48.323 299.030 1.0 70.31358  ? 122 LYS A CD  122 LYS A CD  1 
ATOM 980   C CE  . LYS A 1 122 ? 291.978 -48.570 298.415 1.0 70.31358  ? 122 LYS A CE  122 LYS A CE  1 
ATOM 981   N NZ  . LYS A 1 122 ? 291.084 -49.330 299.326 1.0 70.31358  ? 122 LYS A NZ  122 LYS A NZ  1 
ATOM 982   N N   . SER A 1 123 ? 298.174 -50.488 301.528 1.0 74.41354  ? 123 SER A N   123 SER A N   1 
ATOM 983   C CA  . SER A 1 123 ? 299.566 -50.271 301.893 1.0 74.41354  ? 123 SER A CA  123 SER A CA  1 
ATOM 984   C C   . SER A 1 123 ? 300.394 -51.547 301.867 1.0 74.41354  ? 123 SER A C   123 SER A C   1 
ATOM 985   O O   . SER A 1 123 ? 301.581 -51.503 302.204 1.0 74.41354  ? 123 SER A O   123 SER A O   1 
ATOM 986   C CB  . SER A 1 123 ? 299.650 -49.639 303.284 1.0 74.41354  ? 123 SER A CB  123 SER A CB  1 
ATOM 987   O OG  . SER A 1 123 ? 300.998 -49.486 303.688 1.0 74.41354  ? 123 SER A OG  123 SER A OG  1 
ATOM 988   N N   . ALA A 1 124 ? 299.808 -52.667 301.476 1.0 72.05401  ? 124 ALA A N   124 ALA A N   1 
ATOM 989   C CA  . ALA A 1 124 ? 300.479 -53.954 301.594 1.0 72.05401  ? 124 ALA A CA  124 ALA A CA  1 
ATOM 990   C C   . ALA A 1 124 ? 301.476 -54.143 300.459 1.0 72.05401  ? 124 ALA A C   124 ALA A C   1 
ATOM 991   O O   . ALA A 1 124 ? 301.134 -53.910 299.297 1.0 72.05401  ? 124 ALA A O   124 ALA A O   1 
ATOM 992   C CB  . ALA A 1 124 ? 299.464 -55.086 301.575 1.0 72.05401  ? 124 ALA A CB  124 ALA A CB  1 
ATOM 993   N N   . PRO A 1 125 ? 302.711 -54.539 300.752 1.0 73.38651  ? 125 PRO A N   125 PRO A N   1 
ATOM 994   C CA  . PRO A 1 125 ? 303.640 -54.933 299.693 1.0 73.38651  ? 125 PRO A CA  125 PRO A CA  1 
ATOM 995   C C   . PRO A 1 125 ? 303.607 -56.430 299.438 1.0 73.38651  ? 125 PRO A C   125 PRO A C   1 
ATOM 996   O O   . PRO A 1 125 ? 303.296 -57.236 300.314 1.0 73.38651  ? 125 PRO A O   125 PRO A O   1 
ATOM 997   C CB  . PRO A 1 125 ? 305.000 -54.512 300.264 1.0 73.38651  ? 125 PRO A CB  125 PRO A CB  1 
ATOM 998   C CG  . PRO A 1 125 ? 304.828 -54.673 301.727 1.0 73.38651  ? 125 PRO A CG  125 PRO A CG  1 
ATOM 999   C CD  . PRO A 1 125 ? 303.402 -54.316 302.033 1.0 73.38651  ? 125 PRO A CD  125 PRO A CD  1 
ATOM 1000  N N   . ILE A 1 126 ? 303.943 -56.799 298.204 1.0 75.03362  ? 126 ILE A N   126 ILE A N   1 
ATOM 1001  C CA  . ILE A 1 126 ? 304.124 -58.205 297.862 1.0 75.03362  ? 126 ILE A CA  126 ILE A CA  1 
ATOM 1002  C C   . ILE A 1 126 ? 305.488 -58.660 298.352 1.0 75.03362  ? 126 ILE A C   126 ILE A C   1 
ATOM 1003  O O   . ILE A 1 126 ? 306.322 -57.840 298.747 1.0 75.03362  ? 126 ILE A O   126 ILE A O   1 
ATOM 1004  C CB  . ILE A 1 126 ? 304.008 -58.456 296.352 1.0 75.03362  ? 126 ILE A CB  126 ILE A CB  1 
ATOM 1005  C CG1 . ILE A 1 126 ? 305.108 -57.707 295.624 1.0 75.03362  ? 126 ILE A CG1 126 ILE A CG1 1 
ATOM 1006  C CG2 . ILE A 1 126 ? 302.655 -58.065 295.849 1.0 75.03362  ? 126 ILE A CG2 126 ILE A CG2 1 
ATOM 1007  C CD1 . ILE A 1 126 ? 305.242 -58.126 294.221 1.0 75.03362  ? 126 ILE A CD1 126 ILE A CD1 1 
ATOM 1008  N N   . ASN A 1 127 ? 305.729 -59.966 298.326 1.0 77.72453  ? 127 ASN A N   127 ASN A N   1 
ATOM 1009  C CA  . ASN A 1 127 ? 307.048 -60.478 298.655 1.0 77.72453  ? 127 ASN A CA  127 ASN A CA  1 
ATOM 1010  C C   . ASN A 1 127 ? 307.988 -60.156 297.502 1.0 77.72453  ? 127 ASN A C   127 ASN A C   1 
ATOM 1011  O O   . ASN A 1 127 ? 307.791 -60.634 296.381 1.0 77.72453  ? 127 ASN A O   127 ASN A O   1 
ATOM 1012  C CB  . ASN A 1 127 ? 306.998 -61.980 298.902 1.0 77.72453  ? 127 ASN A CB  127 ASN A CB  1 
ATOM 1013  C CG  . ASN A 1 127 ? 305.977 -62.365 299.937 1.0 77.72453  ? 127 ASN A CG  127 ASN A CG  1 
ATOM 1014  O OD1 . ASN A 1 127 ? 305.616 -61.567 300.806 1.0 77.72453  ? 127 ASN A OD1 127 ASN A OD1 1 
ATOM 1015  N ND2 . ASN A 1 127 ? 305.552 -63.616 299.897 1.0 77.72453  ? 127 ASN A ND2 127 ASN A ND2 1 
ATOM 1016  N N   . SER A 1 128 ? 309.002 -59.340 297.764 1.0 82.82646  ? 128 SER A N   128 SER A N   1 
ATOM 1017  C CA  . SER A 1 128 ? 309.792 -58.780 296.678 1.0 82.82646  ? 128 SER A CA  128 SER A CA  1 
ATOM 1018  C C   . SER A 1 128 ? 311.192 -58.454 297.177 1.0 82.82646  ? 128 SER A C   128 SER A C   1 
ATOM 1019  O O   . SER A 1 128 ? 311.516 -58.630 298.354 1.0 82.82646  ? 128 SER A O   128 SER A O   1 
ATOM 1020  C CB  . SER A 1 128 ? 309.111 -57.536 296.102 1.0 82.82646  ? 128 SER A CB  128 SER A CB  1 
ATOM 1021  O OG  . SER A 1 128 ? 309.028 -56.516 297.076 1.0 82.82646  ? 128 SER A OG  128 SER A OG  1 
ATOM 1022  N N   . ALA A 1 129 ? 312.023 -57.979 296.253 1.0 86.76763  ? 129 ALA A N   129 ALA A N   1 
ATOM 1023  C CA  . ALA A 1 129 ? 313.356 -57.475 296.535 1.0 86.76763  ? 129 ALA A CA  129 ALA A CA  1 
ATOM 1024  C C   . ALA A 1 129 ? 313.455 -56.039 296.044 1.0 86.76763  ? 129 ALA A C   129 ALA A C   1 
ATOM 1025  O O   . ALA A 1 129 ? 312.805 -55.659 295.066 1.0 86.76763  ? 129 ALA A O   129 ALA A O   1 
ATOM 1026  C CB  . ALA A 1 129 ? 314.430 -58.334 295.864 1.0 86.76763  ? 129 ALA A CB  129 ALA A CB  1 
ATOM 1027  N N   . PHE A 1 130 ? 314.271 -55.240 296.722 1.0 91.78184  ? 130 PHE A N   130 PHE A N   1 
ATOM 1028  C CA  . PHE A 1 130 ? 314.354 -53.816 296.441 1.0 91.78184  ? 130 PHE A CA  130 PHE A CA  1 
ATOM 1029  C C   . PHE A 1 130 ? 315.786 -53.417 296.114 1.0 91.78184  ? 130 PHE A C   130 PHE A C   1 
ATOM 1030  O O   . PHE A 1 130 ? 316.721 -54.210 296.232 1.0 91.78184  ? 130 PHE A O   130 PHE A O   1 
ATOM 1031  C CB  . PHE A 1 130 ? 313.826 -53.000 297.620 1.0 91.78184  ? 130 PHE A CB  130 PHE A CB  1 
ATOM 1032  C CG  . PHE A 1 130 ? 312.378 -53.220 297.882 1.0 91.78184  ? 130 PHE A CG  130 PHE A CG  1 
ATOM 1033  C CD1 . PHE A 1 130 ? 311.423 -52.590 297.107 1.0 91.78184  ? 130 PHE A CD1 130 PHE A CD1 1 
ATOM 1034  C CD2 . PHE A 1 130 ? 311.969 -54.077 298.883 1.0 91.78184  ? 130 PHE A CD2 130 PHE A CD2 1 
ATOM 1035  C CE1 . PHE A 1 130 ? 310.080 -52.801 297.337 1.0 91.78184  ? 130 PHE A CE1 130 PHE A CE1 1 
ATOM 1036  C CE2 . PHE A 1 130 ? 310.632 -54.291 299.120 1.0 91.78184  ? 130 PHE A CE2 130 PHE A CE2 1 
ATOM 1037  C CZ  . PHE A 1 130 ? 309.684 -53.655 298.345 1.0 91.78184  ? 130 PHE A CZ  130 PHE A CZ  1 
ATOM 1038  N N   . THR A 1 131 ? 315.944 -52.162 295.682 1.0 98.84214  ? 131 THR A N   131 THR A N   1 
ATOM 1039  C CA  . THR A 1 131 ? 317.216 -51.650 295.183 1.0 98.84214  ? 131 THR A CA  131 THR A CA  1 
ATOM 1040  C C   . THR A 1 131 ? 317.581 -50.304 295.797 1.0 98.84214  ? 131 THR A C   131 THR A C   1 
ATOM 1041  O O   . THR A 1 131 ? 318.318 -49.528 295.184 1.0 98.84214  ? 131 THR A O   131 THR A O   1 
ATOM 1042  C CB  . THR A 1 131 ? 317.201 -51.513 293.659 1.0 98.84214  ? 131 THR A CB  131 THR A CB  1 
ATOM 1043  O OG1 . THR A 1 131 ? 316.086 -50.706 293.259 1.0 98.84214  ? 131 THR A OG1 131 THR A OG1 1 
ATOM 1044  C CG2 . THR A 1 131 ? 317.141 -52.861 292.967 1.0 98.84214  ? 131 THR A CG2 131 THR A CG2 1 
ATOM 1045  N N   . VAL A 1 132 ? 317.085 -50.000 296.992 1.0 102.95991 ? 132 VAL A N   132 VAL A N   1 
ATOM 1046  C CA  . VAL A 1 132 ? 317.364 -48.707 297.610 1.0 102.95991 ? 132 VAL A CA  132 VAL A CA  1 
ATOM 1047  C C   . VAL A 1 132 ? 318.797 -48.689 298.143 1.0 102.95991 ? 132 VAL A C   132 VAL A C   1 
ATOM 1048  O O   . VAL A 1 132 ? 319.205 -49.558 298.922 1.0 102.95991 ? 132 VAL A O   132 VAL A O   1 
ATOM 1049  C CB  . VAL A 1 132 ? 316.320 -48.368 298.691 1.0 102.95991 ? 132 VAL A CB  132 VAL A CB  1 
ATOM 1050  C CG1 . VAL A 1 132 ? 316.133 -49.496 299.715 1.0 102.95991 ? 132 VAL A CG1 132 VAL A CG1 1 
ATOM 1051  C CG2 . VAL A 1 132 ? 316.669 -47.057 299.383 1.0 102.95991 ? 132 VAL A CG2 132 VAL A CG2 1 
ATOM 1052  N N   . GLY A 1 133 ? 319.584 -47.719 297.676 1.0 103.82543 ? 133 GLY A N   133 GLY A N   1 
ATOM 1053  C CA  . GLY A 1 133 ? 321.005 -47.701 297.988 1.0 103.82543 ? 133 GLY A CA  133 GLY A CA  1 
ATOM 1054  C C   . GLY A 1 133 ? 321.731 -48.838 297.293 1.0 103.82543 ? 133 GLY A C   133 GLY A C   1 
ATOM 1055  O O   . GLY A 1 133 ? 321.360 -49.270 296.196 1.0 103.82543 ? 133 GLY A O   133 GLY A O   1 
ATOM 1056  N N   . ASN A 1 134 ? 322.787 -49.330 297.937 1.0 104.60525 ? 134 ASN A N   134 ASN A N   1 
ATOM 1057  C CA  . ASN A 1 134 ? 323.414 -50.574 297.519 1.0 104.60525 ? 134 ASN A CA  134 ASN A CA  1 
ATOM 1058  C C   . ASN A 1 134 ? 322.898 -51.773 298.298 1.0 104.60525 ? 134 ASN A C   134 ASN A C   1 
ATOM 1059  O O   . ASN A 1 134 ? 323.041 -52.908 297.832 1.0 104.60525 ? 134 ASN A O   134 ASN A O   1 
ATOM 1060  C CB  . ASN A 1 134 ? 324.935 -50.487 297.676 1.0 104.60525 ? 134 ASN A CB  134 ASN A CB  1 
ATOM 1061  C CG  . ASN A 1 134 ? 325.550 -49.435 296.782 1.0 104.60525 ? 134 ASN A CG  134 ASN A CG  1 
ATOM 1062  O OD1 . ASN A 1 134 ? 326.114 -48.451 297.259 1.0 104.60525 ? 134 ASN A OD1 134 ASN A OD1 1 
ATOM 1063  N ND2 . ASN A 1 134 ? 325.440 -49.633 295.474 1.0 104.60525 ? 134 ASN A ND2 134 ASN A ND2 1 
ATOM 1064  N N   . ASP A 1 135 ? 322.304 -51.538 299.461 1.0 101.94111 ? 135 ASP A N   135 ASP A N   1 
ATOM 1065  C CA  . ASP A 1 135 ? 321.673 -52.576 300.266 1.0 101.94111 ? 135 ASP A CA  135 ASP A CA  1 
ATOM 1066  C C   . ASP A 1 135 ? 320.405 -53.025 299.555 1.0 101.94111 ? 135 ASP A C   135 ASP A C   1 
ATOM 1067  O O   . ASP A 1 135 ? 319.367 -52.367 299.639 1.0 101.94111 ? 135 ASP A O   135 ASP A O   1 
ATOM 1068  C CB  . ASP A 1 135 ? 321.370 -52.023 301.656 1.0 101.94111 ? 135 ASP A CB  135 ASP A CB  1 
ATOM 1069  C CG  . ASP A 1 135 ? 320.905 -53.085 302.648 1.0 101.94111 ? 135 ASP A CG  135 ASP A CG  1 
ATOM 1070  O OD1 . ASP A 1 135 ? 320.811 -54.278 302.302 1.0 101.94111 ? 135 ASP A OD1 135 ASP A OD1 1 
ATOM 1071  O OD2 . ASP A 1 135 ? 320.615 -52.707 303.802 1.0 101.94111 ? 135 ASP A OD2 135 ASP A OD2 1 
ATOM 1072  N N   . THR A 1 136 ? 320.475 -54.148 298.847 1.0 98.84305  ? 136 THR A N   136 THR A N   1 
ATOM 1073  C CA  . THR A 1 136 ? 319.268 -54.746 298.293 1.0 98.84305  ? 136 THR A CA  136 THR A CA  1 
ATOM 1074  C C   . THR A 1 136 ? 318.481 -55.417 299.415 1.0 98.84305  ? 136 THR A C   136 THR A C   1 
ATOM 1075  O O   . THR A 1 136 ? 319.036 -56.177 300.215 1.0 98.84305  ? 136 THR A O   136 THR A O   1 
ATOM 1076  C CB  . THR A 1 136 ? 319.598 -55.712 297.147 1.0 98.84305  ? 136 THR A CB  136 THR A CB  1 
ATOM 1077  O OG1 . THR A 1 136 ? 318.402 -56.363 296.699 1.0 98.84305  ? 136 THR A OG1 136 THR A OG1 1 
ATOM 1078  C CG2 . THR A 1 136 ? 320.662 -56.739 297.512 1.0 98.84305  ? 136 THR A CG2 136 THR A CG2 1 
ATOM 1079  N N   . HIS A 1 137 ? 317.204 -55.081 299.516 1.0 95.16322  ? 137 HIS A N   137 HIS A N   1 
ATOM 1080  C CA  . HIS A 1 137 ? 316.399 -55.559 300.624 1.0 95.16322  ? 137 HIS A CA  137 HIS A CA  1 
ATOM 1081  C C   . HIS A 1 137 ? 315.584 -56.777 300.220 1.0 95.16322  ? 137 HIS A C   137 HIS A C   1 
ATOM 1082  O O   . HIS A 1 137 ? 315.498 -57.151 299.049 1.0 95.16322  ? 137 HIS A O   137 HIS A O   1 
ATOM 1083  C CB  . HIS A 1 137 ? 315.467 -54.462 301.132 1.0 95.16322  ? 137 HIS A CB  137 HIS A CB  1 
ATOM 1084  C CG  . HIS A 1 137 ? 316.177 -53.327 301.795 1.0 95.16322  ? 137 HIS A CG  137 HIS A CG  1 
ATOM 1085  N ND1 . HIS A 1 137 ? 315.523 -52.202 302.248 1.0 95.16322  ? 137 HIS A ND1 137 HIS A ND1 1 
ATOM 1086  C CD2 . HIS A 1 137 ? 317.489 -53.132 302.063 1.0 95.16322  ? 137 HIS A CD2 137 HIS A CD2 1 
ATOM 1087  C CE1 . HIS A 1 137 ? 316.399 -51.372 302.784 1.0 95.16322  ? 137 HIS A CE1 137 HIS A CE1 1 
ATOM 1088  N NE2 . HIS A 1 137 ? 317.600 -51.913 302.686 1.0 95.16322  ? 137 HIS A NE2 137 HIS A NE2 1 
ATOM 1089  N N   . PHE A 1 138 ? 314.989 -57.405 301.221 1.0 90.23081  ? 138 PHE A N   138 PHE A N   1 
ATOM 1090  C CA  . PHE A 1 138 ? 313.969 -58.413 301.005 1.0 90.23081  ? 138 PHE A CA  138 PHE A CA  1 
ATOM 1091  C C   . PHE A 1 138 ? 312.868 -58.193 302.021 1.0 90.23081  ? 138 PHE A C   138 PHE A C   1 
ATOM 1092  O O   . PHE A 1 138 ? 313.144 -57.937 303.195 1.0 90.23081  ? 138 PHE A O   138 PHE A O   1 
ATOM 1093  C CB  . PHE A 1 138 ? 314.509 -59.837 301.160 1.0 90.23081  ? 138 PHE A CB  138 PHE A CB  1 
ATOM 1094  C CG  . PHE A 1 138 ? 315.511 -60.232 300.131 1.0 90.23081  ? 138 PHE A CG  138 PHE A CG  1 
ATOM 1095  C CD1 . PHE A 1 138 ? 315.108 -60.622 298.868 1.0 90.23081  ? 138 PHE A CD1 138 PHE A CD1 1 
ATOM 1096  C CD2 . PHE A 1 138 ? 316.860 -60.236 300.433 1.0 90.23081  ? 138 PHE A CD2 138 PHE A CD2 1 
ATOM 1097  C CE1 . PHE A 1 138 ? 316.036 -60.996 297.917 1.0 90.23081  ? 138 PHE A CE1 138 PHE A CE1 1 
ATOM 1098  C CE2 . PHE A 1 138 ? 317.792 -60.607 299.490 1.0 90.23081  ? 138 PHE A CE2 138 PHE A CE2 1 
ATOM 1099  C CZ  . PHE A 1 138 ? 317.380 -60.987 298.231 1.0 90.23081  ? 138 PHE A CZ  138 PHE A CZ  1 
ATOM 1100  N N   . VAL A 1 139 ? 311.626 -58.278 301.575 1.0 84.8799   ? 139 VAL A N   139 VAL A N   1 
ATOM 1101  C CA  . VAL A 1 139 ? 310.499 -58.438 302.477 1.0 84.8799   ? 139 VAL A CA  139 VAL A CA  1 
ATOM 1102  C C   . VAL A 1 139 ? 309.651 -59.573 301.926 1.0 84.8799   ? 139 VAL A C   139 VAL A C   1 
ATOM 1103  O O   . VAL A 1 139 ? 309.487 -59.708 300.711 1.0 84.8799   ? 139 VAL A O   139 VAL A O   1 
ATOM 1104  C CB  . VAL A 1 139 ? 309.710 -57.118 302.663 1.0 84.8799   ? 139 VAL A CB  139 VAL A CB  1 
ATOM 1105  C CG1 . VAL A 1 139 ? 309.090 -56.608 301.379 1.0 84.8799   ? 139 VAL A CG1 139 VAL A CG1 1 
ATOM 1106  C CG2 . VAL A 1 139 ? 308.654 -57.271 303.738 1.0 84.8799   ? 139 VAL A CG2 139 VAL A CG2 1 
ATOM 1107  N N   . ALA A 1 140 ? 309.198 -60.459 302.816 1.0 80.96699  ? 140 ALA A N   140 ALA A N   1 
ATOM 1108  C CA  . ALA A 1 140 ? 308.457 -61.629 302.374 1.0 80.96699  ? 140 ALA A CA  140 ALA A CA  1 
ATOM 1109  C C   . ALA A 1 140 ? 307.555 -62.137 303.500 1.0 80.96699  ? 140 ALA A C   140 ALA A C   1 
ATOM 1110  O O   . ALA A 1 140 ? 307.656 -61.710 304.648 1.0 80.96699  ? 140 ALA A O   140 ALA A O   1 
ATOM 1111  C CB  . ALA A 1 140 ? 309.385 -62.753 301.895 1.0 80.96699  ? 140 ALA A CB  140 ALA A CB  1 
ATOM 1112  N N   . GLN A 1 141 ? 306.650 -63.040 303.130 1.0 80.48934  ? 141 GLN A N   141 GLN A N   1 
ATOM 1113  C CA  . GLN A 1 141 ? 305.840 -63.814 304.063 1.0 80.48934  ? 141 GLN A CA  141 GLN A CA  1 
ATOM 1114  C C   . GLN A 1 141 ? 305.981 -65.275 303.669 1.0 80.48934  ? 141 GLN A C   141 GLN A C   1 
ATOM 1115  O O   . GLN A 1 141 ? 305.806 -65.615 302.493 1.0 80.48934  ? 141 GLN A O   141 GLN A O   1 
ATOM 1116  C CB  . GLN A 1 141 ? 304.369 -63.384 304.028 1.0 80.48934  ? 141 GLN A CB  141 GLN A CB  1 
ATOM 1117  C CG  . GLN A 1 141 ? 303.471 -64.109 305.017 1.0 80.48934  ? 141 GLN A CG  141 GLN A CG  1 
ATOM 1118  C CD  . GLN A 1 141 ? 303.827 -63.821 306.462 1.0 80.48934  ? 141 GLN A CD  141 GLN A CD  1 
ATOM 1119  O OE1 . GLN A 1 141 ? 304.466 -64.630 307.129 1.0 80.48934  ? 141 GLN A OE1 141 GLN A OE1 1 
ATOM 1120  N NE2 . GLN A 1 141 ? 303.393 -62.674 306.959 1.0 80.48934  ? 141 GLN A NE2 141 GLN A NE2 1 
ATOM 1121  N N   . LEU A 1 142 ? 306.319 -66.132 304.631 1.0 83.03391  ? 142 LEU A N   142 LEU A N   1 
ATOM 1122  C CA  . LEU A 1 142 ? 306.643 -67.532 304.360 1.0 83.03391  ? 142 LEU A CA  142 LEU A CA  1 
ATOM 1123  C C   . LEU A 1 142 ? 305.659 -68.462 305.057 1.0 83.03391  ? 142 LEU A C   142 LEU A C   1 
ATOM 1124  O O   . LEU A 1 142 ? 305.855 -68.827 306.226 1.0 83.03391  ? 142 LEU A O   142 LEU A O   1 
ATOM 1125  C CB  . LEU A 1 142 ? 308.081 -67.843 304.772 1.0 83.03391  ? 142 LEU A CB  142 LEU A CB  1 
ATOM 1126  C CG  . LEU A 1 142 ? 309.128 -67.147 303.906 1.0 83.03391  ? 142 LEU A CG  142 LEU A CG  1 
ATOM 1127  C CD1 . LEU A 1 142 ? 310.528 -67.401 304.425 1.0 83.03391  ? 142 LEU A CD1 142 LEU A CD1 1 
ATOM 1128  C CD2 . LEU A 1 142 ? 308.990 -67.605 302.467 1.0 83.03391  ? 142 LEU A CD2 142 LEU A CD2 1 
ATOM 1129  N N   . PRO A 1 143 ? 304.576 -68.860 304.378 1.0 81.42598  ? 143 PRO A N   143 PRO A N   1 
ATOM 1130  C CA  . PRO A 1 143 ? 303.600 -69.774 304.987 1.0 81.42598  ? 143 PRO A CA  143 PRO A CA  1 
ATOM 1131  C C   . PRO A 1 143 ? 304.097 -71.202 305.163 1.0 81.42598  ? 143 PRO A C   143 PRO A C   1 
ATOM 1132  O O   . PRO A 1 143 ? 303.986 -71.766 306.254 1.0 81.42598  ? 143 PRO A O   143 PRO A O   1 
ATOM 1133  C CB  . PRO A 1 143 ? 302.430 -69.731 303.996 1.0 81.42598  ? 143 PRO A CB  143 PRO A CB  1 
ATOM 1134  C CG  . PRO A 1 143 ? 302.636 -68.496 303.190 1.0 81.42598  ? 143 PRO A CG  143 PRO A CG  1 
ATOM 1135  C CD  . PRO A 1 143 ? 304.112 -68.363 303.076 1.0 81.42598  ? 143 PRO A CD  143 PRO A CD  1 
ATOM 1136  N N   . GLN A 1 144 ? 304.635 -71.802 304.106 1.0 82.75824  ? 144 GLN A N   144 GLN A N   1 
ATOM 1137  C CA  . GLN A 1 144 ? 304.889 -73.234 304.094 1.0 82.75824  ? 144 GLN A CA  144 GLN A CA  1 
ATOM 1138  C C   . GLN A 1 144 ? 306.141 -73.580 304.897 1.0 82.75824  ? 144 GLN A C   144 GLN A C   1 
ATOM 1139  O O   . GLN A 1 144 ? 306.980 -72.726 305.189 1.0 82.75824  ? 144 GLN A O   144 GLN A O   1 
ATOM 1140  C CB  . GLN A 1 144 ? 305.040 -73.733 302.660 1.0 82.75824  ? 144 GLN A CB  144 GLN A CB  1 
ATOM 1141  C CG  . GLN A 1 144 ? 303.804 -73.554 301.809 1.0 82.75824  ? 144 GLN A CG  144 GLN A CG  1 
ATOM 1142  C CD  . GLN A 1 144 ? 304.000 -74.028 300.391 1.0 82.75824  ? 144 GLN A CD  144 GLN A CD  1 
ATOM 1143  O OE1 . GLN A 1 144 ? 305.076 -74.483 300.023 1.0 82.75824  ? 144 GLN A OE1 144 GLN A OE1 1 
ATOM 1144  N NE2 . GLN A 1 144 ? 302.964 -73.906 299.580 1.0 82.75824  ? 144 GLN A NE2 144 GLN A NE2 1 
ATOM 1145  N N   . THR A 1 145 ? 306.257 -74.861 305.253 1.0 90.67289  ? 145 THR A N   145 THR A N   1 
ATOM 1146  C CA  . THR A 1 145 ? 307.383 -75.368 306.027 1.0 90.67289  ? 145 THR A CA  145 THR A CA  1 
ATOM 1147  C C   . THR A 1 145 ? 307.981 -76.598 305.355 1.0 90.67289  ? 145 THR A C   145 THR A C   1 
ATOM 1148  O O   . THR A 1 145 ? 307.294 -77.331 304.640 1.0 90.67289  ? 145 THR A O   145 THR A O   1 
ATOM 1149  C CB  . THR A 1 145 ? 306.979 -75.733 307.474 1.0 90.67289  ? 145 THR A CB  145 THR A CB  1 
ATOM 1150  O OG1 . THR A 1 145 ? 305.955 -76.734 307.456 1.0 90.67289  ? 145 THR A OG1 145 THR A OG1 1 
ATOM 1151  C CG2 . THR A 1 145 ? 306.482 -74.513 308.241 1.0 90.67289  ? 145 THR A CG2 145 THR A CG2 1 
ATOM 1152  N N   . TYR A 1 146 ? 309.276 -76.816 305.597 1.0 95.83479  ? 146 TYR A N   146 TYR A N   1 
ATOM 1153  C CA  . TYR A 1 146 ? 309.997 -78.012 305.148 1.0 95.83479  ? 146 TYR A CA  146 TYR A CA  1 
ATOM 1154  C C   . TYR A 1 146 ? 310.818 -78.551 306.329 1.0 95.83479  ? 146 TYR A C   146 TYR A C   1 
ATOM 1155  O O   . TYR A 1 146 ? 312.044 -78.627 306.318 1.0 95.83479  ? 146 TYR A O   146 TYR A O   1 
ATOM 1156  C CB  . TYR A 1 146 ? 310.798 -77.784 303.852 1.0 95.83479  ? 146 TYR A CB  146 TYR A CB  1 
ATOM 1157  C CG  . TYR A 1 146 ? 311.914 -76.765 303.840 1.0 95.83479  ? 146 TYR A CG  146 TYR A CG  1 
ATOM 1158  C CD1 . TYR A 1 146 ? 311.642 -75.422 303.664 1.0 95.83479  ? 146 TYR A CD1 146 TYR A CD1 1 
ATOM 1159  C CD2 . TYR A 1 146 ? 313.247 -77.163 303.880 1.0 95.83479  ? 146 TYR A CD2 146 TYR A CD2 1 
ATOM 1160  C CE1 . TYR A 1 146 ? 312.658 -74.499 303.612 1.0 95.83479  ? 146 TYR A CE1 146 TYR A CE1 1 
ATOM 1161  C CE2 . TYR A 1 146 ? 314.266 -76.245 303.840 1.0 95.83479  ? 146 TYR A CE2 146 TYR A CE2 1 
ATOM 1162  C CZ  . TYR A 1 146 ? 313.966 -74.915 303.702 1.0 95.83479  ? 146 TYR A CZ  146 TYR A CZ  1 
ATOM 1163  O OH  . TYR A 1 146 ? 314.984 -73.996 303.649 1.0 95.83479  ? 146 TYR A OH  146 TYR A OH  1 
ATOM 1164  N N   . ALA A 1 147 ? 310.085 -78.909 307.384 1.0 100.94918 ? 147 ALA A N   147 ALA A N   1 
ATOM 1165  C CA  . ALA A 1 147 ? 310.549 -79.130 308.751 1.0 100.94918 ? 147 ALA A CA  147 ALA A CA  1 
ATOM 1166  C C   . ALA A 1 147 ? 311.606 -80.210 308.961 1.0 100.94918 ? 147 ALA A C   147 ALA A C   1 
ATOM 1167  O O   . ALA A 1 147 ? 312.039 -80.872 308.012 1.0 100.94918 ? 147 ALA A O   147 ALA A O   1 
ATOM 1168  C CB  . ALA A 1 147 ? 309.344 -79.484 309.621 1.0 100.94918 ? 147 ALA A CB  147 ALA A CB  1 
ATOM 1169  N N   . ALA A 1 148 ? 311.997 -80.379 310.233 1.0 105.74508 ? 148 ALA A N   148 ALA A N   1 
ATOM 1170  C CA  . ALA A 1 148 ? 313.129 -81.186 310.706 1.0 105.74508 ? 148 ALA A CA  148 ALA A CA  1 
ATOM 1171  C C   . ALA A 1 148 ? 314.444 -80.675 310.108 1.0 105.74508 ? 148 ALA A C   148 ALA A C   1 
ATOM 1172  O O   . ALA A 1 148 ? 315.111 -81.331 309.307 1.0 105.74508 ? 148 ALA A O   148 ALA A O   1 
ATOM 1173  C CB  . ALA A 1 148 ? 312.932 -82.689 310.448 1.0 105.74508 ? 148 ALA A CB  148 ALA A CB  1 
ATOM 1174  N N   . GLY A 1 149 ? 314.795 -79.468 310.543 1.0 104.23067 ? 149 GLY A N   149 GLY A N   1 
ATOM 1175  C CA  . GLY A 1 149 ? 316.016 -78.821 310.115 1.0 104.23067 ? 149 GLY A CA  149 GLY A CA  1 
ATOM 1176  C C   . GLY A 1 149 ? 317.222 -79.191 310.955 1.0 104.23067 ? 149 GLY A C   149 GLY A C   1 
ATOM 1177  O O   . GLY A 1 149 ? 317.603 -80.363 311.027 1.0 104.23067 ? 149 GLY A O   149 GLY A O   1 
ATOM 1178  N N   . GLY A 1 150 ? 317.827 -78.196 311.596 1.0 104.80108 ? 150 GLY A N   150 GLY A N   1 
ATOM 1179  C CA  . GLY A 1 150 ? 319.133 -78.338 312.210 1.0 104.80108 ? 150 GLY A CA  150 GLY A CA  1 
ATOM 1180  C C   . GLY A 1 150 ? 320.021 -77.232 311.685 1.0 104.80108 ? 150 GLY A C   150 GLY A C   1 
ATOM 1181  O O   . GLY A 1 150 ? 319.789 -76.057 311.983 1.0 104.80108 ? 150 GLY A O   150 GLY A O   1 
ATOM 1182  N N   . THR A 1 151 ? 321.044 -77.582 310.914 1.0 105.42095 ? 151 THR A N   151 THR A N   1 
ATOM 1183  C CA  . THR A 1 151 ? 321.572 -76.633 309.950 1.0 105.42095 ? 151 THR A CA  151 THR A CA  1 
ATOM 1184  C C   . THR A 1 151 ? 320.624 -76.599 308.759 1.0 105.42095 ? 151 THR A C   151 THR A C   1 
ATOM 1185  O O   . THR A 1 151 ? 320.067 -77.624 308.354 1.0 105.42095 ? 151 THR A O   151 THR A O   1 
ATOM 1186  C CB  . THR A 1 151 ? 323.006 -76.988 309.535 1.0 105.42095 ? 151 THR A CB  151 THR A CB  1 
ATOM 1187  O OG1 . THR A 1 151 ? 323.480 -76.041 308.569 1.0 105.42095 ? 151 THR A OG1 151 THR A OG1 1 
ATOM 1188  C CG2 . THR A 1 151 ? 323.123 -78.406 308.987 1.0 105.42095 ? 151 THR A CG2 151 THR A CG2 1 
ATOM 1189  N N   . GLY A 1 152 ? 320.384 -75.405 308.240 1.0 102.59793 ? 152 GLY A N   152 GLY A N   1 
ATOM 1190  C CA  . GLY A 1 152 ? 319.322 -75.249 307.272 1.0 102.59793 ? 152 GLY A CA  152 GLY A CA  1 
ATOM 1191  C C   . GLY A 1 152 ? 319.672 -75.604 305.847 1.0 102.59793 ? 152 GLY A C   152 GLY A C   1 
ATOM 1192  O O   . GLY A 1 152 ? 318.833 -75.430 304.959 1.0 102.59793 ? 152 GLY A O   152 GLY A O   1 
ATOM 1193  N N   . VAL A 1 153 ? 320.870 -76.120 305.599 1.0 103.47094 ? 153 VAL A N   153 VAL A N   1 
ATOM 1194  C CA  . VAL A 1 153 ? 321.351 -76.272 304.234 1.0 103.47094 ? 153 VAL A CA  153 VAL A CA  1 
ATOM 1195  C C   . VAL A 1 153 ? 321.058 -77.665 303.680 1.0 103.47094 ? 153 VAL A C   153 VAL A C   1 
ATOM 1196  O O   . VAL A 1 153 ? 320.781 -77.810 302.484 1.0 103.47094 ? 153 VAL A O   153 VAL A O   1 
ATOM 1197  C CB  . VAL A 1 153 ? 322.856 -75.949 304.206 1.0 103.47094 ? 153 VAL A CB  153 VAL A CB  1 
ATOM 1198  C CG1 . VAL A 1 153 ? 323.406 -75.949 302.791 1.0 103.47094 ? 153 VAL A CG1 153 VAL A CG1 1 
ATOM 1199  C CG2 . VAL A 1 153 ? 323.124 -74.621 304.900 1.0 103.47094 ? 153 VAL A CG2 153 VAL A CG2 1 
ATOM 1200  N N   . THR A 1 154 ? 321.057 -78.690 304.537 1.0 105.3698  ? 154 THR A N   154 THR A N   1 
ATOM 1201  C CA  . THR A 1 154 ? 320.903 -80.078 304.109 1.0 105.3698  ? 154 THR A CA  154 THR A CA  1 
ATOM 1202  C C   . THR A 1 154 ? 319.516 -80.399 303.561 1.0 105.3698  ? 154 THR A C   154 THR A C   1 
ATOM 1203  O O   . THR A 1 154 ? 319.351 -81.450 302.935 1.0 105.3698  ? 154 THR A O   154 THR A O   1 
ATOM 1204  C CB  . THR A 1 154 ? 321.227 -81.020 305.274 1.0 105.3698  ? 154 THR A CB  154 THR A CB  1 
ATOM 1205  O OG1 . THR A 1 154 ? 321.214 -82.377 304.813 1.0 105.3698  ? 154 THR A OG1 154 THR A OG1 1 
ATOM 1206  C CG2 . THR A 1 154 ? 320.214 -80.854 306.403 1.0 105.3698  ? 154 THR A CG2 154 THR A CG2 1 
ATOM 1207  N N   . GLU A 1 155 ? 318.529 -79.534 303.777 1.0 102.89083 ? 155 GLU A N   155 GLU A N   1 
ATOM 1208  C CA  . GLU A 1 155 ? 317.212 -79.688 303.184 1.0 102.89083 ? 155 GLU A CA  155 GLU A CA  1 
ATOM 1209  C C   . GLU A 1 155 ? 316.827 -78.509 302.304 1.0 102.89083 ? 155 GLU A C   155 GLU A C   1 
ATOM 1210  O O   . GLU A 1 155 ? 315.672 -78.427 301.874 1.0 102.89083 ? 155 GLU A O   155 GLU A O   1 
ATOM 1211  C CB  . GLU A 1 155 ? 316.154 -79.890 304.279 1.0 102.89083 ? 155 GLU A CB  155 GLU A CB  1 
ATOM 1212  C CG  . GLU A 1 155 ? 316.273 -81.226 304.998 1.0 102.89083 ? 155 GLU A CG  155 GLU A CG  1 
ATOM 1213  C CD  . GLU A 1 155 ? 315.242 -81.406 306.099 1.0 102.89083 ? 155 GLU A CD  155 GLU A CD  1 
ATOM 1214  O OE1 . GLU A 1 155 ? 314.525 -80.434 306.416 1.0 102.89083 ? 155 GLU A OE1 155 GLU A OE1 1 
ATOM 1215  O OE2 . GLU A 1 155 ? 315.146 -82.524 306.645 1.0 102.89083 ? 155 GLU A OE2 155 GLU A OE2 1 
ATOM 1216  N N   . ALA A 1 156 ? 317.759 -77.597 302.021 1.0 100.7381  ? 156 ALA A N   156 ALA A N   1 
ATOM 1217  C CA  . ALA A 1 156 ? 317.476 -76.423 301.205 1.0 100.7381  ? 156 ALA A CA  156 ALA A CA  1 
ATOM 1218  C C   . ALA A 1 156 ? 317.736 -76.667 299.724 1.0 100.7381  ? 156 ALA A C   156 ALA A C   1 
ATOM 1219  O O   . ALA A 1 156 ? 316.960 -76.206 298.880 1.0 100.7381  ? 156 ALA A O   156 ALA A O   1 
ATOM 1220  C CB  . ALA A 1 156 ? 318.308 -75.236 301.688 1.0 100.7381  ? 156 ALA A CB  156 ALA A CB  1 
ATOM 1221  N N   . ILE A 1 157 ? 318.823 -77.371 299.396 1.0 100.70087 ? 157 ILE A N   157 ILE A N   1 
ATOM 1222  C CA  . ILE A 1 157 ? 319.081 -77.762 298.012 1.0 100.70087 ? 157 ILE A CA  157 ILE A CA  1 
ATOM 1223  C C   . ILE A 1 157 ? 318.029 -78.766 297.554 1.0 100.70087 ? 157 ILE A C   157 ILE A C   1 
ATOM 1224  O O   . ILE A 1 157 ? 317.583 -78.732 296.399 1.0 100.70087 ? 157 ILE A O   157 ILE A O   1 
ATOM 1225  C CB  . ILE A 1 157 ? 320.523 -78.302 297.864 1.0 100.70087 ? 157 ILE A CB  157 ILE A CB  1 
ATOM 1226  C CG1 . ILE A 1 157 ? 321.553 -77.192 298.086 1.0 100.70087 ? 157 ILE A CG1 157 ILE A CG1 1 
ATOM 1227  C CG2 . ILE A 1 157 ? 320.782 -78.887 296.486 1.0 100.70087 ? 157 ILE A CG2 157 ILE A CG2 1 
ATOM 1228  C CD1 . ILE A 1 157 ? 322.124 -77.109 299.477 1.0 100.70087 ? 157 ILE A CD1 157 ILE A CD1 1 
ATOM 1229  N N   . GLN A 1 158 ? 317.548 -79.606 298.469 1.0 99.32097  ? 158 GLN A N   158 GLN A N   1 
ATOM 1230  C CA  . GLN A 1 158 ? 316.408 -80.471 298.205 1.0 99.32097  ? 158 GLN A CA  158 GLN A CA  1 
ATOM 1231  C C   . GLN A 1 158 ? 315.129 -79.644 298.040 1.0 99.32097  ? 158 GLN A C   158 GLN A C   1 
ATOM 1232  O O   . GLN A 1 158 ? 315.113 -78.425 298.242 1.0 99.32097  ? 158 GLN A O   158 GLN A O   1 
ATOM 1233  C CB  . GLN A 1 158 ? 316.248 -81.491 299.328 1.0 99.32097  ? 158 GLN A CB  158 GLN A CB  1 
ATOM 1234  C CG  . GLN A 1 158 ? 317.396 -82.466 299.428 1.0 99.32097  ? 158 GLN A CG  158 GLN A CG  1 
ATOM 1235  C CD  . GLN A 1 158 ? 317.537 -83.309 298.181 1.0 99.32097  ? 158 GLN A CD  158 GLN A CD  1 
ATOM 1236  O OE1 . GLN A 1 158 ? 318.469 -83.126 297.398 1.0 99.32097  ? 158 GLN A OE1 158 GLN A OE1 1 
ATOM 1237  N NE2 . GLN A 1 158 ? 316.611 -84.241 297.988 1.0 99.32097  ? 158 GLN A NE2 158 GLN A NE2 1 
ATOM 1238  N N   . GLN A 1 159 ? 314.043 -80.351 297.709 1.0 97.65411  ? 159 GLN A N   159 GLN A N   1 
ATOM 1239  C CA  . GLN A 1 159 ? 312.726 -79.819 297.315 1.0 97.65411  ? 159 GLN A CA  159 GLN A CA  1 
ATOM 1240  C C   . GLN A 1 159 ? 312.866 -78.687 296.287 1.0 97.65411  ? 159 GLN A C   159 GLN A C   1 
ATOM 1241  O O   . GLN A 1 159 ? 312.653 -77.505 296.550 1.0 97.65411  ? 159 GLN A O   159 GLN A O   1 
ATOM 1242  C CB  . GLN A 1 159 ? 311.837 -79.476 298.534 1.0 97.65411  ? 159 GLN A CB  159 GLN A CB  1 
ATOM 1243  C CG  . GLN A 1 159 ? 312.269 -78.495 299.637 1.0 97.65411  ? 159 GLN A CG  159 GLN A CG  1 
ATOM 1244  C CD  . GLN A 1 159 ? 311.778 -77.083 299.420 1.0 97.65411  ? 159 GLN A CD  159 GLN A CD  1 
ATOM 1245  O OE1 . GLN A 1 159 ? 310.738 -76.863 298.804 1.0 97.65411  ? 159 GLN A OE1 159 GLN A OE1 1 
ATOM 1246  N NE2 . GLN A 1 159 ? 312.524 -76.116 299.931 1.0 97.65411  ? 159 GLN A NE2 159 GLN A NE2 1 
ATOM 1247  N N   . GLN A 1 160 ? 313.296 -79.114 295.098 1.0 96.33557  ? 160 GLN A N   160 GLN A N   1 
ATOM 1248  C CA  . GLN A 1 160 ? 313.445 -78.239 293.943 1.0 96.33557  ? 160 GLN A CA  160 GLN A CA  1 
ATOM 1249  C C   . GLN A 1 160 ? 312.116 -77.587 293.565 1.0 96.33557  ? 160 GLN A C   160 GLN A C   1 
ATOM 1250  O O   . GLN A 1 160 ? 311.031 -78.071 293.897 1.0 96.33557  ? 160 GLN A O   160 GLN A O   1 
ATOM 1251  C CB  . GLN A 1 160 ? 313.993 -79.025 292.750 1.0 96.33557  ? 160 GLN A CB  160 GLN A CB  1 
ATOM 1252  C CG  . GLN A 1 160 ? 313.013 -80.025 292.140 1.0 96.33557  ? 160 GLN A CG  160 GLN A CG  1 
ATOM 1253  C CD  . GLN A 1 160 ? 313.046 -81.385 292.812 1.0 96.33557  ? 160 GLN A CD  160 GLN A CD  1 
ATOM 1254  O OE1 . GLN A 1 160 ? 313.571 -81.540 293.913 1.0 96.33557  ? 160 GLN A OE1 160 GLN A OE1 1 
ATOM 1255  N NE2 . GLN A 1 160 ? 312.478 -82.383 292.146 1.0 96.33557  ? 160 GLN A NE2 160 GLN A NE2 1 
ATOM 1256  N N   . VAL A 1 161 ? 312.217 -76.468 292.853 1.0 91.82693  ? 161 VAL A N   161 VAL A N   1 
ATOM 1257  C CA  . VAL A 1 161 ? 311.052 -75.649 292.549 1.0 91.82693  ? 161 VAL A CA  161 VAL A CA  1 
ATOM 1258  C C   . VAL A 1 161 ? 310.810 -75.590 291.050 1.0 91.82693  ? 161 VAL A C   161 VAL A C   1 
ATOM 1259  O O   . VAL A 1 161 ? 311.561 -76.169 290.257 1.0 91.82693  ? 161 VAL A O   161 VAL A O   1 
ATOM 1260  C CB  . VAL A 1 161 ? 311.212 -74.232 293.122 1.0 91.82693  ? 161 VAL A CB  161 VAL A CB  1 
ATOM 1261  C CG1 . VAL A 1 161 ? 311.211 -74.274 294.634 1.0 91.82693  ? 161 VAL A CG1 161 VAL A CG1 1 
ATOM 1262  C CG2 . VAL A 1 161 ? 312.496 -73.616 292.608 1.0 91.82693  ? 161 VAL A CG2 161 VAL A CG2 1 
ATOM 1263  N N   . SER A 1 162 ? 309.756 -74.886 290.662 1.0 89.76248  ? 162 SER A N   162 SER A N   1 
ATOM 1264  C CA  . SER A 1 162 ? 309.373 -74.713 289.271 1.0 89.76248  ? 162 SER A CA  162 SER A CA  1 
ATOM 1265  C C   . SER A 1 162 ? 308.706 -73.350 289.151 1.0 89.76248  ? 162 SER A C   162 SER A C   1 
ATOM 1266  O O   . SER A 1 162 ? 308.861 -72.491 290.025 1.0 89.76248  ? 162 SER A O   162 SER A O   1 
ATOM 1267  C CB  . SER A 1 162 ? 308.465 -75.865 288.813 1.0 89.76248  ? 162 SER A CB  162 SER A CB  1 
ATOM 1268  O OG  . SER A 1 162 ? 308.007 -75.653 287.491 1.0 89.76248  ? 162 SER A OG  162 SER A OG  1 
ATOM 1269  N N   . GLY A 1 163 ? 307.972 -73.141 288.060 1.0 87.55083  ? 163 GLY A N   163 GLY A N   1 
ATOM 1270  C CA  . GLY A 1 163 ? 307.192 -71.926 287.940 1.0 87.55083  ? 163 GLY A CA  163 GLY A CA  1 
ATOM 1271  C C   . GLY A 1 163 ? 306.006 -71.896 288.879 1.0 87.55083  ? 163 GLY A C   163 GLY A C   1 
ATOM 1272  O O   . GLY A 1 163 ? 305.616 -70.827 289.356 1.0 87.55083  ? 163 GLY A O   163 GLY A O   1 
ATOM 1273  N N   . VAL A 1 164 ? 305.418 -73.058 289.162 1.0 86.28803  ? 164 VAL A N   164 VAL A N   1 
ATOM 1274  C CA  . VAL A 1 164 ? 304.219 -73.148 289.989 1.0 86.28803  ? 164 VAL A CA  164 VAL A CA  1 
ATOM 1275  C C   . VAL A 1 164 ? 304.387 -74.169 291.107 1.0 86.28803  ? 164 VAL A C   164 VAL A C   1 
ATOM 1276  O O   . VAL A 1 164 ? 303.396 -74.620 291.690 1.0 86.28803  ? 164 VAL A O   164 VAL A O   1 
ATOM 1277  C CB  . VAL A 1 164 ? 302.987 -73.507 289.138 1.0 86.28803  ? 164 VAL A CB  164 VAL A CB  1 
ATOM 1278  C CG1 . VAL A 1 164 ? 302.627 -72.378 288.191 1.0 86.28803  ? 164 VAL A CG1 164 VAL A CG1 1 
ATOM 1279  C CG2 . VAL A 1 164 ? 303.251 -74.784 288.358 1.0 86.28803  ? 164 VAL A CG2 164 VAL A CG2 1 
ATOM 1280  N N   . ASP A 1 165 ? 305.628 -74.549 291.420 1.0 89.40863  ? 165 ASP A N   165 ASP A N   1 
ATOM 1281  C CA  . ASP A 1 165 ? 305.789 -75.577 292.446 1.0 89.40863  ? 165 ASP A CA  165 ASP A CA  1 
ATOM 1282  C C   . ASP A 1 165 ? 305.642 -74.978 293.852 1.0 89.40863  ? 165 ASP A C   165 ASP A C   1 
ATOM 1283  O O   . ASP A 1 165 ? 304.957 -75.591 294.679 1.0 89.40863  ? 165 ASP A O   165 ASP A O   1 
ATOM 1284  C CB  . ASP A 1 165 ? 307.113 -76.339 292.262 1.0 89.40863  ? 165 ASP A CB  165 ASP A CB  1 
ATOM 1285  C CG  . ASP A 1 165 ? 307.166 -77.642 293.053 1.0 89.40863  ? 165 ASP A CG  165 ASP A CG  1 
ATOM 1286  O OD1 . ASP A 1 165 ? 306.171 -78.009 293.711 1.0 89.40863  ? 165 ASP A OD1 165 ASP A OD1 1 
ATOM 1287  O OD2 . ASP A 1 165 ? 308.221 -78.307 293.021 1.0 89.40863  ? 165 ASP A OD2 165 ASP A OD2 1 
ATOM 1288  N N   . PRO A 1 166 ? 306.220 -73.789 294.200 1.0 83.69886  ? 166 PRO A N   166 PRO A N   1 
ATOM 1289  C CA  . PRO A 1 166 ? 305.695 -73.095 295.383 1.0 83.69886  ? 166 PRO A CA  166 PRO A CA  1 
ATOM 1290  C C   . PRO A 1 166 ? 304.459 -72.290 295.010 1.0 83.69886  ? 166 PRO A C   166 PRO A C   1 
ATOM 1291  O O   . PRO A 1 166 ? 304.512 -71.382 294.175 1.0 83.69886  ? 166 PRO A O   166 PRO A O   1 
ATOM 1292  C CB  . PRO A 1 166 ? 306.867 -72.203 295.816 1.0 83.69886  ? 166 PRO A CB  166 PRO A CB  1 
ATOM 1293  C CG  . PRO A 1 166 ? 307.629 -71.962 294.602 1.0 83.69886  ? 166 PRO A CG  166 PRO A CG  1 
ATOM 1294  C CD  . PRO A 1 166 ? 307.497 -73.180 293.764 1.0 83.69886  ? 166 PRO A CD  166 PRO A CD  1 
ATOM 1295  N N   . ASN A 1 167 ? 303.355 -72.643 295.586 1.0 77.2598   ? 167 ASN A N   167 ASN A N   1 
ATOM 1296  C CA  . ASN A 1 167 ? 302.115 -71.990 295.187 1.0 77.2598   ? 167 ASN A CA  167 ASN A CA  1 
ATOM 1297  C C   . ASN A 1 167 ? 301.780 -70.895 296.193 1.0 77.2598   ? 167 ASN A C   167 ASN A C   1 
ATOM 1298  O O   . ASN A 1 167 ? 301.818 -71.149 297.402 1.0 77.2598   ? 167 ASN A O   167 ASN A O   1 
ATOM 1299  C CB  . ASN A 1 167 ? 300.991 -73.017 295.114 1.0 77.2598   ? 167 ASN A CB  167 ASN A CB  1 
ATOM 1300  C CG  . ASN A 1 167 ? 299.785 -72.537 294.324 1.0 77.2598   ? 167 ASN A CG  167 ASN A CG  1 
ATOM 1301  O OD1 . ASN A 1 167 ? 299.752 -71.422 293.820 1.0 77.2598   ? 167 ASN A OD1 167 ASN A OD1 1 
ATOM 1302  N ND2 . ASN A 1 167 ? 298.786 -73.402 294.204 1.0 77.2598   ? 167 ASN A ND2 167 ASN A ND2 1 
ATOM 1303  N N   . PRO A 1 168 ? 301.498 -69.665 295.747 1.0 73.12799  ? 168 PRO A N   168 PRO A N   1 
ATOM 1304  C CA  . PRO A 1 168 ? 301.097 -68.611 296.696 1.0 73.12799  ? 168 PRO A CA  168 PRO A CA  1 
ATOM 1305  C C   . PRO A 1 168 ? 299.792 -68.873 297.423 1.0 73.12799  ? 168 PRO A C   168 PRO A C   1 
ATOM 1306  O O   . PRO A 1 168 ? 299.544 -68.248 298.460 1.0 73.12799  ? 168 PRO A O   168 PRO A O   1 
ATOM 1307  C CB  . PRO A 1 168 ? 300.994 -67.368 295.807 1.0 73.12799  ? 168 PRO A CB  168 PRO A CB  1 
ATOM 1308  C CG  . PRO A 1 168 ? 301.940 -67.629 294.718 1.0 73.12799  ? 168 PRO A CG  168 PRO A CG  1 
ATOM 1309  C CD  . PRO A 1 168 ? 301.872 -69.098 294.442 1.0 73.12799  ? 168 PRO A CD  168 PRO A CD  1 
ATOM 1310  N N   . GLN A 1 169 ? 298.947 -69.767 296.921 1.0 75.17415  ? 169 GLN A N   169 GLN A N   1 
ATOM 1311  C CA  . GLN A 1 169 ? 297.727 -70.097 297.641 1.0 75.17415  ? 169 GLN A CA  169 GLN A CA  1 
ATOM 1312  C C   . GLN A 1 169 ? 297.962 -71.207 298.658 1.0 75.17415  ? 169 GLN A C   169 GLN A C   1 
ATOM 1313  O O   . GLN A 1 169 ? 297.398 -71.170 299.757 1.0 75.17415  ? 169 GLN A O   169 GLN A O   1 
ATOM 1314  C CB  . GLN A 1 169 ? 296.636 -70.484 296.648 1.0 75.17415  ? 169 GLN A CB  169 GLN A CB  1 
ATOM 1315  C CG  . GLN A 1 169 ? 296.182 -69.325 295.787 1.0 75.17415  ? 169 GLN A CG  169 GLN A CG  1 
ATOM 1316  C CD  . GLN A 1 169 ? 295.181 -69.735 294.738 1.0 75.17415  ? 169 GLN A CD  169 GLN A CD  1 
ATOM 1317  O OE1 . GLN A 1 169 ? 294.888 -70.916 294.575 1.0 75.17415  ? 169 GLN A OE1 169 GLN A OE1 1 
ATOM 1318  N NE2 . GLN A 1 169 ? 294.644 -68.759 294.019 1.0 75.17415  ? 169 GLN A NE2 169 GLN A NE2 1 
ATOM 1319  N N   . VAL A 1 170 ? 298.794 -72.189 298.322 1.0 78.52736  ? 170 VAL A N   170 VAL A N   1 
ATOM 1320  C CA  . VAL A 1 170 ? 299.091 -73.283 299.239 1.0 78.52736  ? 170 VAL A CA  170 VAL A CA  1 
ATOM 1321  C C   . VAL A 1 170 ? 300.014 -72.770 300.334 1.0 78.52736  ? 170 VAL A C   170 VAL A C   1 
ATOM 1322  O O   . VAL A 1 170 ? 301.093 -72.238 300.053 1.0 78.52736  ? 170 VAL A O   170 VAL A O   1 
ATOM 1323  C CB  . VAL A 1 170 ? 299.732 -74.466 298.496 1.0 78.52736  ? 170 VAL A CB  170 VAL A CB  1 
ATOM 1324  C CG1 . VAL A 1 170 ? 300.030 -75.597 299.465 1.0 78.52736  ? 170 VAL A CG1 170 VAL A CG1 1 
ATOM 1325  C CG2 . VAL A 1 170 ? 298.836 -74.951 297.387 1.0 78.52736  ? 170 VAL A CG2 170 VAL A CG2 1 
ATOM 1326  N N   . GLY A 1 171 ? 299.597 -72.934 301.584 1.0 80.7461   ? 171 GLY A N   171 GLY A N   1 
ATOM 1327  C CA  . GLY A 1 171 ? 300.414 -72.500 302.699 1.0 80.7461   ? 171 GLY A CA  171 GLY A CA  1 
ATOM 1328  C C   . GLY A 1 171 ? 300.412 -73.462 303.864 1.0 80.7461   ? 171 GLY A C   171 GLY A C   1 
ATOM 1329  O O   . GLY A 1 171 ? 300.684 -74.654 303.692 1.0 80.7461   ? 171 GLY A O   171 GLY A O   1 
ATOM 1330  N N   . GLN A 1 172 ? 300.135 -72.944 305.059 1.0 83.69892  ? 172 GLN A N   172 GLN A N   1 
ATOM 1331  C CA  . GLN A 1 172 ? 299.919 -73.794 306.217 1.0 83.69892  ? 172 GLN A CA  172 GLN A CA  1 
ATOM 1332  C C   . GLN A 1 172 ? 298.676 -74.656 306.003 1.0 83.69892  ? 172 GLN A C   172 GLN A C   1 
ATOM 1333  O O   . GLN A 1 172 ? 297.753 -74.257 305.287 1.0 83.69892  ? 172 GLN A O   172 GLN A O   1 
ATOM 1334  C CB  . GLN A 1 172 ? 299.741 -72.949 307.477 1.0 83.69892  ? 172 GLN A CB  172 GLN A CB  1 
ATOM 1335  C CG  . GLN A 1 172 ? 300.981 -72.228 307.955 1.0 83.69892  ? 172 GLN A CG  172 GLN A CG  1 
ATOM 1336  C CD  . GLN A 1 172 ? 302.025 -73.179 308.489 1.0 83.69892  ? 172 GLN A CD  172 GLN A CD  1 
ATOM 1337  O OE1 . GLN A 1 172 ? 301.700 -74.193 309.101 1.0 83.69892  ? 172 GLN A OE1 172 GLN A OE1 1 
ATOM 1338  N NE2 . GLN A 1 172 ? 303.290 -72.845 308.280 1.0 83.69892  ? 172 GLN A NE2 172 GLN A NE2 1 
ATOM 1339  N N   . PRO A 1 173 ? 298.628 -75.846 306.597 1.0 83.44066  ? 173 PRO A N   173 PRO A N   1 
ATOM 1340  C CA  . PRO A 1 173 ? 297.369 -76.592 306.632 1.0 83.44066  ? 173 PRO A CA  173 PRO A CA  1 
ATOM 1341  C C   . PRO A 1 173 ? 296.355 -75.888 307.516 1.0 83.44066  ? 173 PRO A C   173 PRO A C   1 
ATOM 1342  O O   . PRO A 1 173 ? 296.695 -75.040 308.344 1.0 83.44066  ? 173 PRO A O   173 PRO A O   1 
ATOM 1343  C CB  . PRO A 1 173 ? 297.771 -77.948 307.216 1.0 83.44066  ? 173 PRO A CB  173 PRO A CB  1 
ATOM 1344  C CG  . PRO A 1 173 ? 298.992 -77.665 308.002 1.0 83.44066  ? 173 PRO A CG  173 PRO A CG  1 
ATOM 1345  C CD  . PRO A 1 173 ? 299.719 -76.593 307.245 1.0 83.44066  ? 173 PRO A CD  173 PRO A CD  1 
ATOM 1346  N N   . ASN A 1 174 ? 295.089 -76.246 307.316 1.0 81.1463   ? 174 ASN A N   174 ASN A N   1 
ATOM 1347  C CA  . ASN A 1 174 ? 294.005 -75.631 308.068 1.0 81.1463   ? 174 ASN A CA  174 ASN A CA  1 
ATOM 1348  C C   . ASN A 1 174 ? 294.090 -76.006 309.542 1.0 81.1463   ? 174 ASN A C   174 ASN A C   1 
ATOM 1349  O O   . ASN A 1 174 ? 294.651 -77.044 309.905 1.0 81.1463   ? 174 ASN A O   174 ASN A O   1 
ATOM 1350  C CB  . ASN A 1 174 ? 292.653 -76.051 307.497 1.0 81.1463   ? 174 ASN A CB  174 ASN A CB  1 
ATOM 1351  C CG  . ASN A 1 174 ? 292.360 -75.406 306.156 1.0 81.1463   ? 174 ASN A CG  174 ASN A CG  1 
ATOM 1352  O OD1 . ASN A 1 174 ? 292.619 -74.220 305.958 1.0 81.1463   ? 174 ASN A OD1 174 ASN A OD1 1 
ATOM 1353  N ND2 . ASN A 1 174 ? 291.816 -76.184 305.229 1.0 81.1463   ? 174 ASN A ND2 174 ASN A ND2 1 
ATOM 1354  N N   . TYR A 1 175 ? 293.568 -75.105 310.385 1.0 82.37517  ? 175 TYR A N   175 TYR A N   1 
ATOM 1355  C CA  . TYR A 1 175 ? 293.500 -75.251 311.845 1.0 82.37517  ? 175 TYR A CA  175 TYR A CA  1 
ATOM 1356  C C   . TYR A 1 175 ? 294.879 -75.328 312.485 1.0 82.37517  ? 175 TYR A C   175 TYR A C   1 
ATOM 1357  O O   . TYR A 1 175 ? 295.066 -75.986 313.510 1.0 82.37517  ? 175 TYR A O   175 TYR A O   1 
ATOM 1358  C CB  . TYR A 1 175 ? 292.657 -76.456 312.258 1.0 82.37517  ? 175 TYR A CB  175 TYR A CB  1 
ATOM 1359  C CG  . TYR A 1 175 ? 291.236 -76.334 311.824 1.0 82.37517  ? 175 TYR A CG  175 TYR A CG  1 
ATOM 1360  C CD1 . TYR A 1 175 ? 290.315 -75.673 312.612 1.0 82.37517  ? 175 TYR A CD1 175 TYR A CD1 1 
ATOM 1361  C CD2 . TYR A 1 175 ? 290.820 -76.846 310.604 1.0 82.37517  ? 175 TYR A CD2 175 TYR A CD2 1 
ATOM 1362  C CE1 . TYR A 1 175 ? 289.014 -75.554 312.216 1.0 82.37517  ? 175 TYR A CE1 175 TYR A CE1 1 
ATOM 1363  C CE2 . TYR A 1 175 ? 289.522 -76.726 310.195 1.0 82.37517  ? 175 TYR A CE2 175 TYR A CE2 1 
ATOM 1364  C CZ  . TYR A 1 175 ? 288.627 -76.077 311.004 1.0 82.37517  ? 175 TYR A CZ  175 TYR A CZ  1 
ATOM 1365  O OH  . TYR A 1 175 ? 287.331 -75.954 310.600 1.0 82.37517  ? 175 TYR A OH  175 TYR A OH  1 
ATOM 1366  N N   . ALA A 1 176 ? 295.853 -74.650 311.885 1.0 86.59083  ? 176 ALA A N   176 ALA A N   1 
ATOM 1367  C CA  . ALA A 1 176 ? 297.112 -74.420 312.572 1.0 86.59083  ? 176 ALA A CA  176 ALA A CA  1 
ATOM 1368  C C   . ALA A 1 176 ? 296.958 -73.396 313.687 1.0 86.59083  ? 176 ALA A C   176 ALA A C   1 
ATOM 1369  O O   . ALA A 1 176 ? 297.765 -73.388 314.622 1.0 86.59083  ? 176 ALA A O   176 ALA A O   1 
ATOM 1370  C CB  . ALA A 1 176 ? 298.176 -73.963 311.577 1.0 86.59083  ? 176 ALA A CB  176 ALA A CB  1 
ATOM 1371  N N   . GLY A 1 177 ? 295.937 -72.546 313.610 1.0 89.74633  ? 177 GLY A N   177 GLY A N   1 
ATOM 1372  C CA  . GLY A 1 177 ? 295.710 -71.522 314.595 1.0 89.74633  ? 177 GLY A CA  177 GLY A CA  1 
ATOM 1373  C C   . GLY A 1 177 ? 296.732 -70.412 314.489 1.0 89.74633  ? 177 GLY A C   177 GLY A C   1 
ATOM 1374  O O   . GLY A 1 177 ? 297.283 -70.144 313.418 1.0 89.74633  ? 177 GLY A O   177 GLY A O   1 
ATOM 1375  N N   . PRO A 1 178 ? 297.013 -69.744 315.604 1.0 89.21958  ? 178 PRO A N   178 PRO A N   1 
ATOM 1376  C CA  . PRO A 1 178 ? 298.086 -68.737 315.633 1.0 89.21958  ? 178 PRO A CA  178 PRO A CA  1 
ATOM 1377  C C   . PRO A 1 178 ? 299.453 -69.373 315.863 1.0 89.21958  ? 178 PRO A C   178 PRO A C   1 
ATOM 1378  O O   . PRO A 1 178 ? 300.128 -69.115 316.864 1.0 89.21958  ? 178 PRO A O   178 PRO A O   1 
ATOM 1379  C CB  . PRO A 1 178 ? 297.656 -67.840 316.798 1.0 89.21958  ? 178 PRO A CB  178 PRO A CB  1 
ATOM 1380  C CG  . PRO A 1 178 ? 296.975 -68.780 317.728 1.0 89.21958  ? 178 PRO A CG  178 PRO A CG  1 
ATOM 1381  C CD  . PRO A 1 178 ? 296.262 -69.785 316.870 1.0 89.21958  ? 178 PRO A CD  178 PRO A CD  1 
ATOM 1382  N N   . VAL A 1 179 ? 299.864 -70.229 314.928 1.0 90.35718  ? 179 VAL A N   179 VAL A N   1 
ATOM 1383  C CA  . VAL A 1 179 ? 301.072 -71.020 315.113 1.0 90.35718  ? 179 VAL A CA  179 VAL A CA  1 
ATOM 1384  C C   . VAL A 1 179 ? 302.301 -70.127 314.982 1.0 90.35718  ? 179 VAL A C   179 VAL A C   1 
ATOM 1385  O O   . VAL A 1 179 ? 302.386 -69.269 314.092 1.0 90.35718  ? 179 VAL A O   179 VAL A O   1 
ATOM 1386  C CB  . VAL A 1 179 ? 301.086 -72.213 314.138 1.0 90.35718  ? 179 VAL A CB  179 VAL A CB  1 
ATOM 1387  C CG1 . VAL A 1 179 ? 301.012 -71.772 312.678 1.0 90.35718  ? 179 VAL A CG1 179 VAL A CG1 1 
ATOM 1388  C CG2 . VAL A 1 179 ? 302.301 -73.101 314.375 1.0 90.35718  ? 179 VAL A CG2 179 VAL A CG2 1 
ATOM 1389  N N   . VAL A 1 180 ? 303.219 -70.261 315.929 1.0 91.62453  ? 180 VAL A N   180 VAL A N   1 
ATOM 1390  C CA  . VAL A 1 180 ? 304.485 -69.544 315.905 1.0 91.62453  ? 180 VAL A CA  180 VAL A CA  1 
ATOM 1391  C C   . VAL A 1 180 ? 305.516 -70.496 315.325 1.0 91.62453  ? 180 VAL A C   180 VAL A C   1 
ATOM 1392  O O   . VAL A 1 180 ? 305.889 -71.485 315.965 1.0 91.62453  ? 180 VAL A O   180 VAL A O   1 
ATOM 1393  C CB  . VAL A 1 180 ? 304.889 -69.057 317.301 1.0 91.62453  ? 180 VAL A CB  180 VAL A CB  1 
ATOM 1394  C CG1 . VAL A 1 180 ? 306.247 -68.383 317.250 1.0 91.62453  ? 180 VAL A CG1 180 VAL A CG1 1 
ATOM 1395  C CG2 . VAL A 1 180 ? 303.836 -68.113 317.851 1.0 91.62453  ? 180 VAL A CG2 180 VAL A CG2 1 
ATOM 1396  N N   . VAL A 1 181 ? 305.956 -70.218 314.101 1.0 92.67254  ? 181 VAL A N   181 VAL A N   1 
ATOM 1397  C CA  . VAL A 1 181 ? 306.940 -71.064 313.435 1.0 92.67254  ? 181 VAL A CA  181 VAL A CA  1 
ATOM 1398  C C   . VAL A 1 181 ? 308.285 -70.849 314.119 1.0 92.67254  ? 181 VAL A C   181 VAL A C   1 
ATOM 1399  O O   . VAL A 1 181 ? 308.883 -69.776 314.007 1.0 92.67254  ? 181 VAL A O   181 VAL A O   1 
ATOM 1400  C CB  . VAL A 1 181 ? 307.023 -70.764 311.935 1.0 92.67254  ? 181 VAL A CB  181 VAL A CB  1 
ATOM 1401  C CG1 . VAL A 1 181 ? 308.120 -71.593 311.293 1.0 92.67254  ? 181 VAL A CG1 181 VAL A CG1 1 
ATOM 1402  C CG2 . VAL A 1 181 ? 305.690 -71.037 311.264 1.0 92.67254  ? 181 VAL A CG2 181 VAL A CG2 1 
ATOM 1403  N N   . ASN A 1 182 ? 308.738 -71.858 314.861 1.0 95.50563  ? 182 ASN A N   182 ASN A N   1 
ATOM 1404  C CA  . ASN A 1 182 ? 310.059 -71.826 315.474 1.0 95.50563  ? 182 ASN A CA  182 ASN A CA  1 
ATOM 1405  C C   . ASN A 1 182 ? 311.108 -71.835 314.374 1.0 95.50563  ? 182 ASN A C   182 ASN A C   1 
ATOM 1406  O O   . ASN A 1 182 ? 311.146 -72.762 313.562 1.0 95.50563  ? 182 ASN A O   182 ASN A O   1 
ATOM 1407  C CB  . ASN A 1 182 ? 310.238 -73.028 316.399 1.0 95.50563  ? 182 ASN A CB  182 ASN A CB  1 
ATOM 1408  C CG  . ASN A 1 182 ? 311.466 -72.915 317.288 1.0 95.50563  ? 182 ASN A CG  182 ASN A CG  1 
ATOM 1409  O OD1 . ASN A 1 182 ? 312.187 -71.919 317.259 1.0 95.50563  ? 182 ASN A OD1 182 ASN A OD1 1 
ATOM 1410  N ND2 . ASN A 1 182 ? 311.712 -73.951 318.080 1.0 95.50563  ? 182 ASN A ND2 182 ASN A ND2 1 
ATOM 1411  N N   . THR A 1 183 ? 311.948 -70.799 314.338 1.0 95.2848   ? 183 THR A N   183 THR A N   1 
ATOM 1412  C CA  . THR A 1 183 ? 312.922 -70.679 313.259 1.0 95.2848   ? 183 THR A CA  183 THR A CA  1 
ATOM 1413  C C   . THR A 1 183 ? 313.995 -71.757 313.369 1.0 95.2848   ? 183 THR A C   183 THR A C   1 
ATOM 1414  O O   . THR A 1 183 ? 314.563 -72.179 312.356 1.0 95.2848   ? 183 THR A O   183 THR A O   1 
ATOM 1415  C CB  . THR A 1 183 ? 313.539 -69.282 313.279 1.0 95.2848   ? 183 THR A CB  183 THR A CB  1 
ATOM 1416  O OG1 . THR A 1 183 ? 312.497 -68.317 313.458 1.0 95.2848   ? 183 THR A OG1 183 THR A OG1 1 
ATOM 1417  C CG2 . THR A 1 183 ? 314.184 -68.979 311.946 1.0 95.2848   ? 183 THR A CG2 183 THR A CG2 1 
ATOM 1418  N N   . THR A 1 184 ? 314.258 -72.233 314.582 1.0 96.92218  ? 184 THR A N   184 THR A N   1 
ATOM 1419  C CA  . THR A 1 184 ? 314.988 -73.473 314.776 1.0 96.92218  ? 184 THR A CA  184 THR A CA  1 
ATOM 1420  C C   . THR A 1 184 ? 314.042 -74.646 314.535 1.0 96.92218  ? 184 THR A C   184 THR A C   1 
ATOM 1421  O O   . THR A 1 184 ? 312.881 -74.611 314.957 1.0 96.92218  ? 184 THR A O   184 THR A O   1 
ATOM 1422  C CB  . THR A 1 184 ? 315.567 -73.523 316.192 1.0 96.92218  ? 184 THR A CB  184 THR A CB  1 
ATOM 1423  O OG1 . THR A 1 184 ? 316.371 -72.359 316.418 1.0 96.92218  ? 184 THR A OG1 184 THR A OG1 1 
ATOM 1424  C CG2 . THR A 1 184 ? 316.435 -74.754 316.389 1.0 96.92218  ? 184 THR A CG2 184 THR A CG2 1 
ATOM 1425  N N   . ASN A 1 185 ? 314.531 -75.651 313.797 1.0 99.63102  ? 185 ASN A N   185 ASN A N   1 
ATOM 1426  C CA  . ASN A 1 185 ? 313.867 -76.901 313.408 1.0 99.63102  ? 185 ASN A CA  185 ASN A CA  1 
ATOM 1427  C C   . ASN A 1 185 ? 312.710 -76.716 312.431 1.0 99.63102  ? 185 ASN A C   185 ASN A C   1 
ATOM 1428  O O   . ASN A 1 185 ? 311.994 -77.685 312.148 1.0 99.63102  ? 185 ASN A O   185 ASN A O   1 
ATOM 1429  C CB  . ASN A 1 185 ? 313.373 -77.711 314.614 1.0 99.63102  ? 185 ASN A CB  185 ASN A CB  1 
ATOM 1430  C CG  . ASN A 1 185 ? 314.506 -78.287 315.425 1.0 99.63102  ? 185 ASN A CG  185 ASN A CG  1 
ATOM 1431  O OD1 . ASN A 1 185 ? 315.481 -78.798 314.876 1.0 99.63102  ? 185 ASN A OD1 185 ASN A OD1 1 
ATOM 1432  N ND2 . ASN A 1 185 ? 314.389 -78.202 316.743 1.0 99.63102  ? 185 ASN A ND2 185 ASN A ND2 1 
ATOM 1433  N N   . ASN A 1 186 ? 312.498 -75.510 311.909 1.0 96.99919  ? 186 ASN A N   186 ASN A N   1 
ATOM 1434  C CA  . ASN A 1 186 ? 311.590 -75.280 310.794 1.0 96.99919  ? 186 ASN A CA  186 ASN A CA  1 
ATOM 1435  C C   . ASN A 1 186 ? 312.230 -74.245 309.885 1.0 96.99919  ? 186 ASN A C   186 ASN A C   1 
ATOM 1436  O O   . ASN A 1 186 ? 313.243 -73.632 310.229 1.0 96.99919  ? 186 ASN A O   186 ASN A O   1 
ATOM 1437  C CB  . ASN A 1 186 ? 310.211 -74.784 311.246 1.0 96.99919  ? 186 ASN A CB  186 ASN A CB  1 
ATOM 1438  C CG  . ASN A 1 186 ? 309.517 -75.741 312.184 1.0 96.99919  ? 186 ASN A CG  186 ASN A CG  1 
ATOM 1439  O OD1 . ASN A 1 186 ? 309.343 -75.451 313.366 1.0 96.99919  ? 186 ASN A OD1 186 ASN A OD1 1 
ATOM 1440  N ND2 . ASN A 1 186 ? 309.093 -76.875 311.661 1.0 96.99919  ? 186 ASN A ND2 186 ASN A ND2 1 
ATOM 1441  N N   . ALA A 1 187 ? 311.620 -74.042 308.720 1.0 92.96233  ? 187 ALA A N   187 ALA A N   1 
ATOM 1442  C CA  . ALA A 1 187 ? 312.082 -73.036 307.775 1.0 92.96233  ? 187 ALA A CA  187 ALA A CA  1 
ATOM 1443  C C   . ALA A 1 187 ? 310.931 -72.681 306.846 1.0 92.96233  ? 187 ALA A C   187 ALA A C   1 
ATOM 1444  O O   . ALA A 1 187 ? 310.051 -73.505 306.594 1.0 92.96233  ? 187 ALA A O   187 ALA A O   1 
ATOM 1445  C CB  . ALA A 1 187 ? 313.292 -73.526 306.975 1.0 92.96233  ? 187 ALA A CB  187 ALA A CB  1 
ATOM 1446  N N   . GLY A 1 188 ? 310.947 -71.448 306.340 1.0 89.51242  ? 188 GLY A N   188 GLY A N   1 
ATOM 1447  C CA  . GLY A 1 188 ? 309.862 -70.984 305.503 1.0 89.51242  ? 188 GLY A CA  188 GLY A CA  1 
ATOM 1448  C C   . GLY A 1 188 ? 310.018 -71.383 304.048 1.0 89.51242  ? 188 GLY A C   188 GLY A C   1 
ATOM 1449  O O   . GLY A 1 188 ? 311.080 -71.788 303.592 1.0 89.51242  ? 188 GLY A O   188 GLY A O   1 
ATOM 1450  N N   . LEU A 1 189 ? 308.930 -71.248 303.297 1.0 85.74091  ? 189 LEU A N   189 LEU A N   1 
ATOM 1451  C CA  . LEU A 1 189 ? 308.893 -71.719 301.916 1.0 85.74091  ? 189 LEU A CA  189 LEU A CA  1 
ATOM 1452  C C   . LEU A 1 189 ? 307.840 -70.934 301.152 1.0 85.74091  ? 189 LEU A C   189 LEU A C   1 
ATOM 1453  O O   . LEU A 1 189 ? 306.651 -71.028 301.467 1.0 85.74091  ? 189 LEU A O   189 LEU A O   1 
ATOM 1454  C CB  . LEU A 1 189 ? 308.600 -73.218 301.876 1.0 85.74091  ? 189 LEU A CB  189 LEU A CB  1 
ATOM 1455  C CG  . LEU A 1 189 ? 308.368 -73.949 300.556 1.0 85.74091  ? 189 LEU A CG  189 LEU A CG  1 
ATOM 1456  C CD1 . LEU A 1 189 ? 309.535 -73.821 299.622 1.0 85.74091  ? 189 LEU A CD1 189 LEU A CD1 1 
ATOM 1457  C CD2 . LEU A 1 189 ? 308.109 -75.415 300.853 1.0 85.74091  ? 189 LEU A CD2 189 LEU A CD2 1 
ATOM 1458  N N   . GLY A 1 190 ? 308.274 -70.165 300.157 1.0 83.93667  ? 190 GLY A N   190 GLY A N   1 
ATOM 1459  C CA  . GLY A 1 190 ? 307.358 -69.344 299.388 1.0 83.93667  ? 190 GLY A CA  190 GLY A CA  1 
ATOM 1460  C C   . GLY A 1 190 ? 307.951 -68.792 298.108 1.0 83.93667  ? 190 GLY A C   190 GLY A C   1 
ATOM 1461  O O   . GLY A 1 190 ? 308.827 -69.417 297.504 1.0 83.93667  ? 190 GLY A O   190 GLY A O   1 
ATOM 1462  N N   . ARG A 1 191 ? 307.475 -67.625 297.677 1.0 80.6472   ? 191 ARG A N   191 ARG A N   1 
ATOM 1463  C CA  . ARG A 1 191 ? 307.958 -66.976 296.467 1.0 80.6472   ? 191 ARG A CA  191 ARG A CA  1 
ATOM 1464  C C   . ARG A 1 191 ? 308.273 -65.516 296.744 1.0 80.6472   ? 191 ARG A C   191 ARG A C   1 
ATOM 1465  O O   . ARG A 1 191 ? 307.681 -64.897 297.628 1.0 80.6472   ? 191 ARG A O   191 ARG A O   1 
ATOM 1466  C CB  . ARG A 1 191 ? 306.933 -67.030 295.333 1.0 80.6472   ? 191 ARG A CB  191 ARG A CB  1 
ATOM 1467  C CG  . ARG A 1 191 ? 306.646 -68.404 294.794 1.0 80.6472   ? 191 ARG A CG  191 ARG A CG  1 
ATOM 1468  C CD  . ARG A 1 191 ? 305.584 -68.342 293.717 1.0 80.6472   ? 191 ARG A CD  191 ARG A CD  1 
ATOM 1469  N NE  . ARG A 1 191 ? 306.043 -67.639 292.527 1.0 80.6472   ? 191 ARG A NE  191 ARG A NE  1 
ATOM 1470  C CZ  . ARG A 1 191 ? 306.666 -68.226 291.514 1.0 80.6472   ? 191 ARG A CZ  191 ARG A CZ  1 
ATOM 1471  N NH1 . ARG A 1 191 ? 306.903 -69.529 291.547 1.0 80.6472   ? 191 ARG A NH1 191 ARG A NH1 1 
ATOM 1472  N NH2 . ARG A 1 191 ? 307.050 -67.511 290.467 1.0 80.6472   ? 191 ARG A NH2 191 ARG A NH2 1 
ATOM 1473  N N   . ILE A 1 192 ? 309.215 -64.974 295.975 1.0 81.1923   ? 192 ILE A N   192 ILE A N   1 
ATOM 1474  C CA  . ILE A 1 192 ? 309.425 -63.534 295.871 1.0 81.1923   ? 192 ILE A CA  192 ILE A CA  1 
ATOM 1475  C C   . ILE A 1 192 ? 309.527 -63.197 294.395 1.0 81.1923   ? 192 ILE A C   192 ILE A C   1 
ATOM 1476  O O   . ILE A 1 192 ? 309.349 -64.067 293.539 1.0 81.1923   ? 192 ILE A O   192 ILE A O   1 
ATOM 1477  C CB  . ILE A 1 192 ? 310.684 -63.050 296.613 1.0 81.1923   ? 192 ILE A CB  192 ILE A CB  1 
ATOM 1478  C CG1 . ILE A 1 192 ? 311.929 -63.755 296.081 1.0 81.1923   ? 192 ILE A CG1 192 ILE A CG1 1 
ATOM 1479  C CG2 . ILE A 1 192 ? 310.544 -63.204 298.108 1.0 81.1923   ? 192 ILE A CG2 192 ILE A CG2 1 
ATOM 1480  C CD1 . ILE A 1 192 ? 313.212 -63.131 296.564 1.0 81.1923   ? 192 ILE A CD1 192 ILE A CD1 1 
ATOM 1481  N N   . VAL A 1 193 ? 309.812 -61.937 294.090 1.0 82.41084  ? 193 VAL A N   193 VAL A N   1 
ATOM 1482  C CA  . VAL A 1 193 ? 310.166 -61.506 292.745 1.0 82.41084  ? 193 VAL A CA  193 VAL A CA  1 
ATOM 1483  C C   . VAL A 1 193 ? 311.513 -60.795 292.813 1.0 82.41084  ? 193 VAL A C   193 VAL A C   1 
ATOM 1484  O O   . VAL A 1 193 ? 311.738 -59.968 293.704 1.0 82.41084  ? 193 VAL A O   193 VAL A O   1 
ATOM 1485  C CB  . VAL A 1 193 ? 309.063 -60.624 292.122 1.0 82.41084  ? 193 VAL A CB  193 VAL A CB  1 
ATOM 1486  C CG1 . VAL A 1 193 ? 308.599 -59.569 293.084 1.0 82.41084  ? 193 VAL A CG1 193 VAL A CG1 1 
ATOM 1487  C CG2 . VAL A 1 193 ? 309.566 -59.943 290.872 1.0 82.41084  ? 193 VAL A CG2 193 VAL A CG2 1 
ATOM 1488  N N   . SER A 1 194 ? 312.431 -61.178 291.922 1.0 85.41873  ? 194 SER A N   194 SER A N   1 
ATOM 1489  C CA  . SER A 1 194 ? 313.758 -60.582 291.889 1.0 85.41873  ? 194 SER A CA  194 SER A CA  1 
ATOM 1490  C C   . SER A 1 194 ? 313.688 -59.104 291.548 1.0 85.41873  ? 194 SER A C   194 SER A C   1 
ATOM 1491  O O   . SER A 1 194 ? 312.773 -58.640 290.863 1.0 85.41873  ? 194 SER A O   194 SER A O   1 
ATOM 1492  C CB  . SER A 1 194 ? 314.643 -61.274 290.855 1.0 85.41873  ? 194 SER A CB  194 SER A CB  1 
ATOM 1493  O OG  . SER A 1 194 ? 314.901 -62.613 291.206 1.0 85.41873  ? 194 SER A OG  194 SER A OG  1 
ATOM 1494  N N   . ALA A 1 195 ? 314.673 -58.366 292.040 1.0 86.08649  ? 195 ALA A N   195 ALA A N   1 
ATOM 1495  C CA  . ALA A 1 195 ? 314.894 -57.006 291.600 1.0 86.08649  ? 195 ALA A CA  195 ALA A CA  1 
ATOM 1496  C C   . ALA A 1 195 ? 315.551 -57.015 290.224 1.0 86.08649  ? 195 ALA A C   195 ALA A C   1 
ATOM 1497  O O   . ALA A 1 195 ? 315.987 -58.060 289.730 1.0 86.08649  ? 195 ALA A O   195 ALA A O   1 
ATOM 1498  C CB  . ALA A 1 195 ? 315.756 -56.258 292.610 1.0 86.08649  ? 195 ALA A CB  195 ALA A CB  1 
ATOM 1499  N N   . ASP A 1 196 ? 315.637 -55.820 289.628 1.0 88.55069  ? 196 ASP A N   196 ASP A N   1 
ATOM 1500  C CA  . ASP A 1 196 ? 316.068 -55.610 288.240 1.0 88.55069  ? 196 ASP A CA  196 ASP A CA  1 
ATOM 1501  C C   . ASP A 1 196 ? 315.250 -56.476 287.284 1.0 88.55069  ? 196 ASP A C   196 ASP A C   1 
ATOM 1502  O O   . ASP A 1 196 ? 315.782 -57.278 286.513 1.0 88.55069  ? 196 ASP A O   196 ASP A O   1 
ATOM 1503  C CB  . ASP A 1 196 ? 317.572 -55.859 288.070 1.0 88.55069  ? 196 ASP A CB  196 ASP A CB  1 
ATOM 1504  C CG  . ASP A 1 196 ? 318.420 -54.832 288.791 1.0 88.55069  ? 196 ASP A CG  196 ASP A CG  1 
ATOM 1505  O OD1 . ASP A 1 196 ? 317.973 -53.674 288.921 1.0 88.55069  ? 196 ASP A OD1 196 ASP A OD1 1 
ATOM 1506  O OD2 . ASP A 1 196 ? 319.532 -55.184 289.235 1.0 88.55069  ? 196 ASP A OD2 196 ASP A OD2 1 
ATOM 1507  N N   . SER A 1 197 ? 313.928 -56.320 287.360 1.0 84.71965  ? 197 SER A N   197 SER A N   1 
ATOM 1508  C CA  . SER A 1 197 ? 312.995 -57.173 286.632 1.0 84.71965  ? 197 SER A CA  197 SER A CA  1 
ATOM 1509  C C   . SER A 1 197 ? 312.005 -56.317 285.843 1.0 84.71965  ? 197 SER A C   197 SER A C   1 
ATOM 1510  O O   . SER A 1 197 ? 310.815 -56.618 285.793 1.0 84.71965  ? 197 SER A O   197 SER A O   1 
ATOM 1511  C CB  . SER A 1 197 ? 312.254 -58.114 287.576 1.0 84.71965  ? 197 SER A CB  197 SER A CB  1 
ATOM 1512  O OG  . SER A 1 197 ? 311.381 -57.393 288.425 1.0 84.71965  ? 197 SER A OG  197 SER A OG  1 
ATOM 1513  N N   . GLU A 1 198 ? 312.514 -55.233 285.250 1.0 86.93474  ? 198 GLU A N   198 GLU A N   1 
ATOM 1514  C CA  . GLU A 1 198 ? 311.874 -54.512 284.139 1.0 86.93474  ? 198 GLU A CA  198 GLU A CA  1 
ATOM 1515  C C   . GLU A 1 198 ? 310.499 -53.943 284.490 1.0 86.93474  ? 198 GLU A C   198 GLU A C   1 
ATOM 1516  O O   . GLU A 1 198 ? 309.472 -54.371 283.961 1.0 86.93474  ? 198 GLU A O   198 GLU A O   1 
ATOM 1517  C CB  . GLU A 1 198 ? 311.778 -55.411 282.904 1.0 86.93474  ? 198 GLU A CB  198 GLU A CB  1 
ATOM 1518  C CG  . GLU A 1 198 ? 313.119 -55.799 282.308 1.0 86.93474  ? 198 GLU A CG  198 GLU A CG  1 
ATOM 1519  C CD  . GLU A 1 198 ? 313.850 -54.622 281.691 1.0 86.93474  ? 198 GLU A CD  198 GLU A CD  1 
ATOM 1520  O OE1 . GLU A 1 198 ? 313.180 -53.715 281.152 1.0 86.93474  ? 198 GLU A OE1 198 GLU A OE1 1 
ATOM 1521  O OE2 . GLU A 1 198 ? 315.098 -54.601 281.750 1.0 86.93474  ? 198 GLU A OE2 198 GLU A OE2 1 
ATOM 1522  N N   . GLY A 1 199 ? 310.472 -52.976 285.402 1.0 84.35136  ? 199 GLY A N   199 GLY A N   1 
ATOM 1523  C CA  . GLY A 1 199 ? 309.233 -52.258 285.632 1.0 84.35136  ? 199 GLY A CA  199 GLY A CA  1 
ATOM 1524  C C   . GLY A 1 199 ? 309.206 -51.509 286.942 1.0 84.35136  ? 199 GLY A C   199 GLY A C   1 
ATOM 1525  O O   . GLY A 1 199 ? 310.145 -51.569 287.742 1.0 84.35136  ? 199 GLY A O   199 GLY A O   1 
ATOM 1526  N N   . GLN A 1 200 ? 308.100 -50.797 287.151 1.0 81.53524  ? 200 GLN A N   200 GLN A N   1 
ATOM 1527  C CA  . GLN A 1 200 ? 307.892 -50.015 288.363 1.0 81.53524  ? 200 GLN A CA  200 GLN A CA  1 
ATOM 1528  C C   . GLN A 1 200 ? 307.432 -50.925 289.493 1.0 81.53524  ? 200 GLN A C   200 GLN A C   1 
ATOM 1529  O O   . GLN A 1 200 ? 306.510 -51.728 289.313 1.0 81.53524  ? 200 GLN A O   200 GLN A O   1 
ATOM 1530  C CB  . GLN A 1 200 ? 306.860 -48.918 288.112 1.0 81.53524  ? 200 GLN A CB  200 GLN A CB  1 
ATOM 1531  C CG  . GLN A 1 200 ? 306.591 -48.035 289.314 1.0 81.53524  ? 200 GLN A CG  200 GLN A CG  1 
ATOM 1532  C CD  . GLN A 1 200 ? 307.816 -47.267 289.757 1.0 81.53524  ? 200 GLN A CD  200 GLN A CD  1 
ATOM 1533  O OE1 . GLN A 1 200 ? 308.452 -47.614 290.750 1.0 81.53524  ? 200 GLN A OE1 200 GLN A OE1 1 
ATOM 1534  N NE2 . GLN A 1 200 ? 308.151 -46.212 289.024 1.0 81.53524  ? 200 GLN A NE2 200 GLN A NE2 1 
ATOM 1535  N N   . GLN A 1 201 ? 308.074 -50.805 290.652 1.0 80.7854   ? 201 GLN A N   201 GLN A N   1 
ATOM 1536  C CA  . GLN A 1 201 ? 307.641 -51.549 291.826 1.0 80.7854   ? 201 GLN A CA  201 GLN A CA  1 
ATOM 1537  C C   . GLN A 1 201 ? 306.314 -50.995 292.324 1.0 80.7854   ? 201 GLN A C   201 GLN A C   1 
ATOM 1538  O O   . GLN A 1 201 ? 306.121 -49.778 292.391 1.0 80.7854   ? 201 GLN A O   201 GLN A O   1 
ATOM 1539  C CB  . GLN A 1 201 ? 308.706 -51.473 292.919 1.0 80.7854   ? 201 GLN A CB  201 GLN A CB  1 
ATOM 1540  C CG  . GLN A 1 201 ? 308.393 -52.294 294.157 1.0 80.7854   ? 201 GLN A CG  201 GLN A CG  1 
ATOM 1541  C CD  . GLN A 1 201 ? 308.367 -53.782 293.882 1.0 80.7854   ? 201 GLN A CD  201 GLN A CD  1 
ATOM 1542  O OE1 . GLN A 1 201 ? 309.204 -54.306 293.149 1.0 80.7854   ? 201 GLN A OE1 201 GLN A OE1 1 
ATOM 1543  N NE2 . GLN A 1 201 ? 307.402 -54.473 294.473 1.0 80.7854   ? 201 GLN A NE2 201 GLN A NE2 1 
ATOM 1544  N N   . PHE A 1 202 ? 305.399 -51.889 292.661 1.0 73.61545  ? 202 PHE A N   202 PHE A N   1 
ATOM 1545  C CA  . PHE A 1 202 ? 304.013 -51.558 292.938 1.0 73.61545  ? 202 PHE A CA  202 PHE A CA  1 
ATOM 1546  C C   . PHE A 1 202 ? 303.526 -52.390 294.114 1.0 73.61545  ? 202 PHE A C   202 PHE A C   1 
ATOM 1547  O O   . PHE A 1 202 ? 303.988 -53.519 294.309 1.0 73.61545  ? 202 PHE A O   202 PHE A O   1 
ATOM 1548  C CB  . PHE A 1 202 ? 303.165 -51.837 291.688 1.0 73.61545  ? 202 PHE A CB  202 PHE A CB  1 
ATOM 1549  C CG  . PHE A 1 202 ? 301.770 -51.334 291.777 1.0 73.61545  ? 202 PHE A CG  202 PHE A CG  1 
ATOM 1550  C CD1 . PHE A 1 202 ? 301.498 -49.994 291.606 1.0 73.61545  ? 202 PHE A CD1 202 PHE A CD1 1 
ATOM 1551  C CD2 . PHE A 1 202 ? 300.729 -52.195 292.034 1.0 73.61545  ? 202 PHE A CD2 202 PHE A CD2 1 
ATOM 1552  C CE1 . PHE A 1 202 ? 300.222 -49.519 291.697 1.0 73.61545  ? 202 PHE A CE1 202 PHE A CE1 1 
ATOM 1553  C CE2 . PHE A 1 202 ? 299.445 -51.726 292.127 1.0 73.61545  ? 202 PHE A CE2 202 PHE A CE2 1 
ATOM 1554  C CZ  . PHE A 1 202 ? 299.198 -50.388 291.955 1.0 73.61545  ? 202 PHE A CZ  202 PHE A CZ  1 
ATOM 1555  N N   . PRO A 1 203 ? 302.604 -51.865 294.925 1.0 72.46707  ? 203 PRO A N   203 PRO A N   1 
ATOM 1556  C CA  . PRO A 1 203 ? 302.098 -52.637 296.069 1.0 72.46707  ? 203 PRO A CA  203 PRO A CA  1 
ATOM 1557  C C   . PRO A 1 203 ? 301.227 -53.817 295.664 1.0 72.46707  ? 203 PRO A C   203 PRO A C   1 
ATOM 1558  O O   . PRO A 1 203 ? 301.063 -54.144 294.489 1.0 72.46707  ? 203 PRO A O   203 PRO A O   1 
ATOM 1559  C CB  . PRO A 1 203 ? 301.281 -51.610 296.856 1.0 72.46707  ? 203 PRO A CB  203 PRO A CB  1 
ATOM 1560  C CG  . PRO A 1 203 ? 301.859 -50.324 296.495 1.0 72.46707  ? 203 PRO A CG  203 PRO A CG  1 
ATOM 1561  C CD  . PRO A 1 203 ? 302.259 -50.441 295.062 1.0 72.46707  ? 203 PRO A CD  203 PRO A CD  1 
ATOM 1562  N N   . CYS A 1 204 ? 300.669 -54.474 296.683 1.0 70.95561  ? 204 CYS A N   204 CYS A N   1 
ATOM 1563  C CA  . CYS A 1 204 ? 299.892 -55.684 296.441 1.0 70.95561  ? 204 CYS A CA  204 CYS A CA  1 
ATOM 1564  C C   . CYS A 1 204 ? 298.551 -55.367 295.803 1.0 70.95561  ? 204 CYS A C   204 CYS A C   1 
ATOM 1565  O O   . CYS A 1 204 ? 298.108 -56.073 294.891 1.0 70.95561  ? 204 CYS A O   204 CYS A O   1 
ATOM 1566  C CB  . CYS A 1 204 ? 299.691 -56.450 297.745 1.0 70.95561  ? 204 CYS A CB  204 CYS A CB  1 
ATOM 1567  S SG  . CYS A 1 204 ? 298.797 -58.005 297.561 1.0 70.95561  ? 204 CYS A SG  204 CYS A SG  1 
ATOM 1568  N N   . TYR A 1 205 ? 297.905 -54.297 296.251 1.0 66.82536  ? 205 TYR A N   205 TYR A N   1 
ATOM 1569  C CA  . TYR A 1 205 ? 296.562 -53.938 295.809 1.0 66.82536  ? 205 TYR A CA  205 TYR A CA  1 
ATOM 1570  C C   . TYR A 1 205 ? 296.617 -53.430 294.375 1.0 66.82536  ? 205 TYR A C   205 TYR A C   1 
ATOM 1571  O O   . TYR A 1 205 ? 296.928 -52.262 294.134 1.0 66.82536  ? 205 TYR A O   205 TYR A O   1 
ATOM 1572  C CB  . TYR A 1 205 ? 295.990 -52.878 296.740 1.0 66.82536  ? 205 TYR A CB  205 TYR A CB  1 
ATOM 1573  C CG  . TYR A 1 205 ? 294.586 -52.432 296.436 1.0 66.82536  ? 205 TYR A CG  205 TYR A CG  1 
ATOM 1574  C CD1 . TYR A 1 205 ? 293.494 -53.179 296.843 1.0 66.82536  ? 205 TYR A CD1 205 TYR A CD1 1 
ATOM 1575  C CD2 . TYR A 1 205 ? 294.353 -51.251 295.752 1.0 66.82536  ? 205 TYR A CD2 205 TYR A CD2 1 
ATOM 1576  C CE1 . TYR A 1 205 ? 292.209 -52.756 296.575 1.0 66.82536  ? 205 TYR A CE1 205 TYR A CE1 1 
ATOM 1577  C CE2 . TYR A 1 205 ? 293.084 -50.825 295.478 1.0 66.82536  ? 205 TYR A CE2 205 TYR A CE2 1 
ATOM 1578  C CZ  . TYR A 1 205 ? 292.017 -51.575 295.890 1.0 66.82536  ? 205 TYR A CZ  205 TYR A CZ  1 
ATOM 1579  O OH  . TYR A 1 205 ? 290.753 -51.132 295.601 1.0 66.82536  ? 205 TYR A OH  205 TYR A OH  1 
ATOM 1580  N N   . GLY A 1 206 ? 296.321 -54.303 293.423 1.0 67.37306  ? 206 GLY A N   206 GLY A N   1 
ATOM 1581  C CA  . GLY A 1 206 ? 296.256 -53.916 292.034 1.0 67.37306  ? 206 GLY A CA  206 GLY A CA  1 
ATOM 1582  C C   . GLY A 1 206 ? 297.408 -54.369 291.173 1.0 67.37306  ? 206 GLY A C   206 GLY A C   1 
ATOM 1583  O O   . GLY A 1 206 ? 297.501 -53.930 290.024 1.0 67.37306  ? 206 GLY A O   206 GLY A O   1 
ATOM 1584  N N   . ALA A 1 207 ? 298.274 -55.239 291.677 1.0 66.59508  ? 207 ALA A N   207 ALA A N   1 
ATOM 1585  C CA  . ALA A 1 207 ? 299.457 -55.657 290.942 1.0 66.59508  ? 207 ALA A CA  207 ALA A CA  1 
ATOM 1586  C C   . ALA A 1 207 ? 299.105 -56.777 289.975 1.0 66.59508  ? 207 ALA A C   207 ALA A C   1 
ATOM 1587  O O   . ALA A 1 207 ? 298.501 -57.778 290.367 1.0 66.59508  ? 207 ALA A O   207 ALA A O   1 
ATOM 1588  C CB  . ALA A 1 207 ? 300.548 -56.114 291.903 1.0 66.59508  ? 207 ALA A CB  207 ALA A CB  1 
ATOM 1589  N N   . TYR A 1 208 ? 299.494 -56.609 288.716 1.0 67.61853  ? 208 TYR A N   208 TYR A N   1 
ATOM 1590  C CA  . TYR A 1 208 ? 299.188 -57.569 287.672 1.0 67.61853  ? 208 TYR A CA  208 TYR A CA  1 
ATOM 1591  C C   . TYR A 1 208 ? 300.473 -58.120 287.069 1.0 67.61853  ? 208 TYR A C   208 TYR A C   1 
ATOM 1592  O O   . TYR A 1 208 ? 301.497 -57.434 287.008 1.0 67.61853  ? 208 TYR A O   208 TYR A O   1 
ATOM 1593  C CB  . TYR A 1 208 ? 298.316 -56.934 286.587 1.0 67.61853  ? 208 TYR A CB  208 TYR A CB  1 
ATOM 1594  C CG  . TYR A 1 208 ? 297.973 -57.872 285.466 1.0 67.61853  ? 208 TYR A CG  208 TYR A CG  1 
ATOM 1595  C CD1 . TYR A 1 208 ? 297.101 -58.915 285.671 1.0 67.61853  ? 208 TYR A CD1 208 TYR A CD1 1 
ATOM 1596  C CD2 . TYR A 1 208 ? 298.540 -57.728 284.217 1.0 67.61853  ? 208 TYR A CD2 208 TYR A CD2 1 
ATOM 1597  C CE1 . TYR A 1 208 ? 296.783 -59.786 284.668 1.0 67.61853  ? 208 TYR A CE1 208 TYR A CE1 1 
ATOM 1598  C CE2 . TYR A 1 208 ? 298.233 -58.598 283.199 1.0 67.61853  ? 208 TYR A CE2 208 TYR A CE2 1 
ATOM 1599  C CZ  . TYR A 1 208 ? 297.352 -59.625 283.437 1.0 67.61853  ? 208 TYR A CZ  208 TYR A CZ  1 
ATOM 1600  O OH  . TYR A 1 208 ? 297.036 -60.497 282.438 1.0 67.61853  ? 208 TYR A OH  208 TYR A OH  1 
ATOM 1601  N N   . ALA A 1 209 ? 300.402 -59.373 286.633 1.0 68.77151  ? 209 ALA A N   209 ALA A N   1 
ATOM 1602  C CA  . ALA A 1 209 ? 301.507 -60.138 286.083 1.0 68.77151  ? 209 ALA A CA  209 ALA A CA  1 
ATOM 1603  C C   . ALA A 1 209 ? 300.978 -61.075 285.009 1.0 68.77151  ? 209 ALA A C   209 ALA A C   1 
ATOM 1604  O O   . ALA A 1 209 ? 300.265 -62.028 285.335 1.0 68.77151  ? 209 ALA A O   209 ALA A O   1 
ATOM 1605  C CB  . ALA A 1 209 ? 302.189 -60.934 287.187 1.0 68.77151  ? 209 ALA A CB  209 ALA A CB  1 
ATOM 1606  N N   . PRO A 1 210 ? 301.294 -60.852 283.738 1.0 70.06188  ? 210 PRO A N   210 PRO A N   1 
ATOM 1607  C CA  . PRO A 1 210 ? 300.700 -61.661 282.666 1.0 70.06188  ? 210 PRO A CA  210 PRO A CA  1 
ATOM 1608  C C   . PRO A 1 210 ? 301.239 -63.080 282.677 1.0 70.06188  ? 210 PRO A C   210 PRO A C   1 
ATOM 1609  O O   . PRO A 1 210 ? 302.452 -63.293 282.822 1.0 70.06188  ? 210 PRO A O   210 PRO A O   1 
ATOM 1610  C CB  . PRO A 1 210 ? 301.111 -60.913 281.392 1.0 70.06188  ? 210 PRO A CB  210 PRO A CB  1 
ATOM 1611  C CG  . PRO A 1 210 ? 302.339 -60.171 281.773 1.0 70.06188  ? 210 PRO A CG  210 PRO A CG  1 
ATOM 1612  C CD  . PRO A 1 210 ? 302.176 -59.797 283.214 1.0 70.06188  ? 210 PRO A CD  210 PRO A CD  1 
ATOM 1613  N N   . PRO A 1 211 ? 300.365 -64.075 282.554 1.0 70.82167  ? 211 PRO A N   211 PRO A N   1 
ATOM 1614  C CA  . PRO A 1 211 ? 300.805 -65.471 282.633 1.0 70.82167  ? 211 PRO A CA  211 PRO A CA  1 
ATOM 1615  C C   . PRO A 1 211 ? 301.552 -65.894 281.379 1.0 70.82167  ? 211 PRO A C   211 PRO A C   1 
ATOM 1616  O O   . PRO A 1 211 ? 301.567 -65.207 280.358 1.0 70.82167  ? 211 PRO A O   211 PRO A O   1 
ATOM 1617  C CB  . PRO A 1 211 ? 299.496 -66.243 282.784 1.0 70.82167  ? 211 PRO A CB  211 PRO A CB  1 
ATOM 1618  C CG  . PRO A 1 211 ? 298.494 -65.381 282.127 1.0 70.82167  ? 211 PRO A CG  211 PRO A CG  1 
ATOM 1619  C CD  . PRO A 1 211 ? 298.906 -63.971 282.402 1.0 70.82167  ? 211 PRO A CD  211 PRO A CD  1 
ATOM 1620  N N   . GLN A 1 212 ? 302.179 -67.062 281.471 1.0 75.8604   ? 212 GLN A N   212 GLN A N   1 
ATOM 1621  C CA  . GLN A 1 212 ? 303.015 -67.568 280.394 1.0 75.8604   ? 212 GLN A CA  212 GLN A CA  1 
ATOM 1622  C C   . GLN A 1 212 ? 302.554 -68.898 279.824 1.0 75.8604   ? 212 GLN A C   212 GLN A C   1 
ATOM 1623  O O   . GLN A 1 212 ? 302.833 -69.174 278.657 1.0 75.8604   ? 212 GLN A O   212 GLN A O   1 
ATOM 1624  C CB  . GLN A 1 212 ? 304.466 -67.700 280.870 1.0 75.8604   ? 212 GLN A CB  212 GLN A CB  1 
ATOM 1625  C CG  . GLN A 1 212 ? 305.087 -66.374 281.261 1.0 75.8604   ? 212 GLN A CG  212 GLN A CG  1 
ATOM 1626  C CD  . GLN A 1 212 ? 305.221 -65.432 280.086 1.0 75.8604   ? 212 GLN A CD  212 GLN A CD  1 
ATOM 1627  O OE1 . GLN A 1 212 ? 305.573 -65.845 278.983 1.0 75.8604   ? 212 GLN A OE1 212 GLN A OE1 1 
ATOM 1628  N NE2 . GLN A 1 212 ? 304.930 -64.158 280.311 1.0 75.8604   ? 212 GLN A NE2 212 GLN A NE2 1 
ATOM 1629  N N   . SER A 1 213 ? 301.863 -69.727 280.602 1.0 79.34382  ? 213 SER A N   213 SER A N   1 
ATOM 1630  C CA  . SER A 1 213 ? 301.302 -70.969 280.091 1.0 79.34382  ? 213 SER A CA  213 SER A CA  1 
ATOM 1631  C C   . SER A 1 213 ? 300.052 -71.306 280.892 1.0 79.34382  ? 213 SER A C   213 SER A C   1 
ATOM 1632  O O   . SER A 1 213 ? 299.654 -70.573 281.800 1.0 79.34382  ? 213 SER A O   213 SER A O   1 
ATOM 1633  C CB  . SER A 1 213 ? 302.318 -72.111 280.144 1.0 79.34382  ? 213 SER A CB  213 SER A CB  1 
ATOM 1634  O OG  . SER A 1 213 ? 301.728 -73.322 279.709 1.0 79.34382  ? 213 SER A OG  213 SER A OG  1 
ATOM 1635  N N   . ALA A 1 214 ? 299.431 -72.435 280.545 1.0 79.78184  ? 214 ALA A N   214 ALA A N   1 
ATOM 1636  C CA  . ALA A 1 214 ? 298.167 -72.825 281.156 1.0 79.78184  ? 214 ALA A CA  214 ALA A CA  1 
ATOM 1637  C C   . ALA A 1 214 ? 298.315 -73.269 282.603 1.0 79.78184  ? 214 ALA A C   214 ALA A C   1 
ATOM 1638  O O   . ALA A 1 214 ? 297.315 -73.301 283.325 1.0 79.78184  ? 214 ALA A O   214 ALA A O   1 
ATOM 1639  C CB  . ALA A 1 214 ? 297.512 -73.939 280.339 1.0 79.78184  ? 214 ALA A CB  214 ALA A CB  1 
ATOM 1640  N N   . GLY A 1 215 ? 299.523 -73.609 283.043 1.0 79.7839   ? 215 GLY A N   215 GLY A N   1 
ATOM 1641  C CA  . GLY A 1 215 ? 299.726 -73.938 284.438 1.0 79.7839   ? 215 GLY A CA  215 GLY A CA  1 
ATOM 1642  C C   . GLY A 1 215 ? 299.717 -72.756 285.376 1.0 79.7839   ? 215 GLY A C   215 GLY A C   1 
ATOM 1643  O O   . GLY A 1 215 ? 299.582 -72.945 286.587 1.0 79.7839   ? 215 GLY A O   215 GLY A O   1 
ATOM 1644  N N   . GLY A 1 216 ? 299.846 -71.544 284.849 1.0 80.08119  ? 216 GLY A N   216 GLY A N   1 
ATOM 1645  C CA  . GLY A 1 216 ? 299.873 -70.356 285.670 1.0 80.08119  ? 216 GLY A CA  216 GLY A CA  1 
ATOM 1646  C C   . GLY A 1 216 ? 301.247 -69.798 285.947 1.0 80.08119  ? 216 GLY A C   216 GLY A C   1 
ATOM 1647  O O   . GLY A 1 216 ? 301.380 -68.953 286.839 1.0 80.08119  ? 216 GLY A O   216 GLY A O   1 
ATOM 1648  N N   . ASP A 1 217 ? 302.270 -70.248 285.227 1.0 82.11161  ? 217 ASP A N   217 ASP A N   1 
ATOM 1649  C CA  . ASP A 1 217 ? 303.615 -69.745 285.458 1.0 82.11161  ? 217 ASP A CA  217 ASP A CA  1 
ATOM 1650  C C   . ASP A 1 217 ? 303.740 -68.311 284.961 1.0 82.11161  ? 217 ASP A C   217 ASP A C   1 
ATOM 1651  O O   . ASP A 1 217 ? 303.092 -67.910 283.991 1.0 82.11161  ? 217 ASP A O   217 ASP A O   1 
ATOM 1652  C CB  . ASP A 1 217 ? 304.652 -70.648 284.790 1.0 82.11161  ? 217 ASP A CB  217 ASP A CB  1 
ATOM 1653  C CG  . ASP A 1 217 ? 304.355 -70.899 283.330 1.0 82.11161  ? 217 ASP A CG  217 ASP A CG  1 
ATOM 1654  O OD1 . ASP A 1 217 ? 303.254 -70.540 282.880 1.0 82.11161  ? 217 ASP A OD1 217 ASP A OD1 1 
ATOM 1655  O OD2 . ASP A 1 217 ? 305.223 -71.436 282.618 1.0 82.11161  ? 217 ASP A OD2 217 ASP A OD2 1 
ATOM 1656  N N   . VAL A 1 218 ? 304.561 -67.530 285.655 1.0 80.83191  ? 218 VAL A N   218 VAL A N   1 
ATOM 1657  C CA  . VAL A 1 218 ? 304.631 -66.093 285.430 1.0 80.83191  ? 218 VAL A CA  218 VAL A CA  1 
ATOM 1658  C C   . VAL A 1 218 ? 306.026 -65.732 284.930 1.0 80.83191  ? 218 VAL A C   218 VAL A C   1 
ATOM 1659  O O   . VAL A 1 218 ? 306.191 -64.815 284.116 1.0 80.83191  ? 218 VAL A O   218 VAL A O   1 
ATOM 1660  C CB  . VAL A 1 218 ? 304.272 -65.343 286.727 1.0 80.83191  ? 218 VAL A CB  218 VAL A CB  1 
ATOM 1661  C CG1 . VAL A 1 218 ? 304.329 -63.865 286.534 1.0 80.83191  ? 218 VAL A CG1 218 VAL A CG1 1 
ATOM 1662  C CG2 . VAL A 1 218 ? 302.891 -65.747 287.219 1.0 80.83191  ? 218 VAL A CG2 218 VAL A CG2 1 
ATOM 1663  N N   . SER A 1 219 ? 307.028 -66.496 285.366 1.0 86.8058   ? 219 SER A N   219 SER A N   1 
ATOM 1664  C CA  . SER A 1 219 ? 308.433 -66.151 285.158 1.0 86.8058   ? 219 SER A CA  219 SER A CA  1 
ATOM 1665  C C   . SER A 1 219 ? 308.808 -66.275 283.690 1.0 86.8058   ? 219 SER A C   219 SER A C   1 
ATOM 1666  O O   . SER A 1 219 ? 308.900 -67.383 283.153 1.0 86.8058   ? 219 SER A O   219 SER A O   1 
ATOM 1667  C CB  . SER A 1 219 ? 309.321 -67.043 286.018 1.0 86.8058   ? 219 SER A CB  219 SER A CB  1 
ATOM 1668  O OG  . SER A 1 219 ? 309.260 -68.389 285.587 1.0 86.8058   ? 219 SER A OG  219 SER A OG  1 
ATOM 1669  N N   . THR A 1 220 ? 309.032 -65.132 283.040 1.0 87.85025  ? 220 THR A N   220 THR A N   1 
ATOM 1670  C CA  . THR A 1 220 ? 309.487 -65.143 281.657 1.0 87.85025  ? 220 THR A CA  220 THR A CA  1 
ATOM 1671  C C   . THR A 1 220 ? 310.942 -65.583 281.533 1.0 87.85025  ? 220 THR A C   220 THR A C   1 
ATOM 1672  O O   . THR A 1 220 ? 311.356 -66.010 280.451 1.0 87.85025  ? 220 THR A O   220 THR A O   1 
ATOM 1673  C CB  . THR A 1 220 ? 309.273 -63.764 281.024 1.0 87.85025  ? 220 THR A CB  220 THR A CB  1 
ATOM 1674  O OG1 . THR A 1 220 ? 309.629 -63.810 279.637 1.0 87.85025  ? 220 THR A OG1 220 THR A OG1 1 
ATOM 1675  C CG2 . THR A 1 220 ? 310.088 -62.691 281.732 1.0 87.85025  ? 220 THR A CG2 220 THR A CG2 1 
ATOM 1676  N N   . ALA A 1 221 ? 311.721 -65.491 282.605 1.0 89.05482  ? 221 ALA A N   221 ALA A N   1 
ATOM 1677  C CA  . ALA A 1 221 ? 313.033 -66.105 282.680 1.0 89.05482  ? 221 ALA A CA  221 ALA A CA  1 
ATOM 1678  C C   . ALA A 1 221 ? 312.939 -67.356 283.548 1.0 89.05482  ? 221 ALA A C   221 ALA A C   1 
ATOM 1679  O O   . ALA A 1 221 ? 311.850 -67.785 283.940 1.0 89.05482  ? 221 ALA A O   221 ALA A O   1 
ATOM 1680  C CB  . ALA A 1 221 ? 314.064 -65.109 283.211 1.0 89.05482  ? 221 ALA A CB  221 ALA A CB  1 
ATOM 1681  N N   . ALA A 1 222 ? 314.086 -67.954 283.854 1.0 90.63388  ? 222 ALA A N   222 ALA A N   1 
ATOM 1682  C CA  . ALA A 1 222 ? 314.105 -69.166 284.655 1.0 90.63388  ? 222 ALA A CA  222 ALA A CA  1 
ATOM 1683  C C   . ALA A 1 222 ? 313.845 -68.844 286.125 1.0 90.63388  ? 222 ALA A C   222 ALA A C   1 
ATOM 1684  O O   . ALA A 1 222 ? 313.807 -67.684 286.545 1.0 90.63388  ? 222 ALA A O   222 ALA A O   1 
ATOM 1685  C CB  . ALA A 1 222 ? 315.440 -69.890 284.498 1.0 90.63388  ? 222 ALA A CB  222 ALA A CB  1 
ATOM 1686  N N   . VAL A 1 223 ? 313.663 -69.895 286.913 1.0 90.30791  ? 223 VAL A N   223 VAL A N   1 
ATOM 1687  C CA  . VAL A 1 223 ? 313.369 -69.764 288.334 1.0 90.30791  ? 223 VAL A CA  223 VAL A CA  1 
ATOM 1688  C C   . VAL A 1 223 ? 314.636 -70.085 289.123 1.0 90.30791  ? 223 VAL A C   223 VAL A C   1 
ATOM 1689  O O   . VAL A 1 223 ? 315.486 -70.873 288.689 1.0 90.30791  ? 223 VAL A O   223 VAL A O   1 
ATOM 1690  C CB  . VAL A 1 223 ? 312.167 -70.660 288.723 1.0 90.30791  ? 223 VAL A CB  223 VAL A CB  1 
ATOM 1691  C CG1 . VAL A 1 223 ? 312.508 -72.147 288.640 1.0 90.30791  ? 223 VAL A CG1 223 VAL A CG1 1 
ATOM 1692  C CG2 . VAL A 1 223 ? 311.595 -70.282 290.084 1.0 90.30791  ? 223 VAL A CG2 223 VAL A CG2 1 
ATOM 1693  N N   . THR A 1 224 ? 314.799 -69.418 290.265 1.0 90.31063  ? 224 THR A N   224 THR A N   1 
ATOM 1694  C CA  . THR A 1 224 ? 316.019 -69.499 291.055 1.0 90.31063  ? 224 THR A CA  224 THR A CA  1 
ATOM 1695  C C   . THR A 1 224 ? 315.629 -69.416 292.527 1.0 90.31063  ? 224 THR A C   224 THR A C   1 
ATOM 1696  O O   . THR A 1 224 ? 314.663 -68.741 292.882 1.0 90.31063  ? 224 THR A O   224 THR A O   1 
ATOM 1697  C CB  . THR A 1 224 ? 316.992 -68.368 290.661 1.0 90.31063  ? 224 THR A CB  224 THR A CB  1 
ATOM 1698  O OG1 . THR A 1 224 ? 317.211 -68.391 289.245 1.0 90.31063  ? 224 THR A OG1 224 THR A OG1 1 
ATOM 1699  C CG2 . THR A 1 224 ? 318.346 -68.508 291.342 1.0 90.31063  ? 224 THR A CG2 224 THR A CG2 1 
ATOM 1700  N N   . LYS A 1 225 ? 316.351 -70.135 293.380 1.0 91.59871  ? 225 LYS A N   225 LYS A N   1 
ATOM 1701  C CA  . LYS A 1 225 ? 316.150 -70.019 294.816 1.0 91.59871  ? 225 LYS A CA  225 LYS A CA  1 
ATOM 1702  C C   . LYS A 1 225 ? 317.069 -68.944 295.386 1.0 91.59871  ? 225 LYS A C   225 LYS A C   1 
ATOM 1703  O O   . LYS A 1 225 ? 318.188 -68.743 294.908 1.0 91.59871  ? 225 LYS A O   225 LYS A O   1 
ATOM 1704  C CB  . LYS A 1 225 ? 316.412 -71.355 295.508 1.0 91.59871  ? 225 LYS A CB  225 LYS A CB  1 
ATOM 1705  C CG  . LYS A 1 225 ? 315.448 -72.453 295.107 1.0 91.59871  ? 225 LYS A CG  225 LYS A CG  1 
ATOM 1706  C CD  . LYS A 1 225 ? 315.736 -73.737 295.858 1.0 91.59871  ? 225 LYS A CD  225 LYS A CD  1 
ATOM 1707  C CE  . LYS A 1 225 ? 314.812 -74.856 295.426 1.0 91.59871  ? 225 LYS A CE  225 LYS A CE  1 
ATOM 1708  N NZ  . LYS A 1 225 ? 315.058 -76.120 296.169 1.0 91.59871  ? 225 LYS A NZ  225 LYS A NZ  1 
ATOM 1709  N N   . THR A 1 226 ? 316.588 -68.253 296.420 1.0 93.46876  ? 226 THR A N   226 THR A N   1 
ATOM 1710  C CA  . THR A 1 226 ? 317.322 -67.133 297.017 1.0 93.46876  ? 226 THR A CA  226 THR A CA  1 
ATOM 1711  C C   . THR A 1 226 ? 317.144 -67.210 298.532 1.0 93.46876  ? 226 THR A C   226 THR A C   1 
ATOM 1712  O O   . THR A 1 226 ? 316.150 -66.712 299.067 1.0 93.46876  ? 226 THR A O   226 THR A O   1 
ATOM 1713  C CB  . THR A 1 226 ? 316.824 -65.801 296.468 1.0 93.46876  ? 226 THR A CB  226 THR A CB  1 
ATOM 1714  O OG1 . THR A 1 226 ? 316.917 -65.809 295.039 1.0 93.46876  ? 226 THR A OG1 226 THR A OG1 1 
ATOM 1715  C CG2 . THR A 1 226 ? 317.669 -64.655 297.003 1.0 93.46876  ? 226 THR A CG2 226 THR A CG2 1 
ATOM 1716  N N   . TYR A 1 227 ? 318.117 -67.799 299.221 1.0 94.72911  ? 227 TYR A N   227 TYR A N   1 
ATOM 1717  C CA  . TYR A 1 227 ? 317.915 -68.223 300.599 1.0 94.72911  ? 227 TYR A CA  227 TYR A CA  1 
ATOM 1718  C C   . TYR A 1 227 ? 318.021 -67.051 301.577 1.0 94.72911  ? 227 TYR A C   227 TYR A C   1 
ATOM 1719  O O   . TYR A 1 227 ? 318.336 -65.919 301.206 1.0 94.72911  ? 227 TYR A O   227 TYR A O   1 
ATOM 1720  C CB  . TYR A 1 227 ? 318.911 -69.314 300.958 1.0 94.72911  ? 227 TYR A CB  227 TYR A CB  1 
ATOM 1721  C CG  . TYR A 1 227 ? 318.774 -70.536 300.084 1.0 94.72911  ? 227 TYR A CG  227 TYR A CG  1 
ATOM 1722  C CD1 . TYR A 1 227 ? 317.705 -71.404 300.235 1.0 94.72911  ? 227 TYR A CD1 227 TYR A CD1 1 
ATOM 1723  C CD2 . TYR A 1 227 ? 319.722 -70.828 299.121 1.0 94.72911  ? 227 TYR A CD2 227 TYR A CD2 1 
ATOM 1724  C CE1 . TYR A 1 227 ? 317.577 -72.520 299.444 1.0 94.72911  ? 227 TYR A CE1 227 TYR A CE1 1 
ATOM 1725  C CE2 . TYR A 1 227 ? 319.606 -71.952 298.327 1.0 94.72911  ? 227 TYR A CE2 227 TYR A CE2 1 
ATOM 1726  C CZ  . TYR A 1 227 ? 318.533 -72.794 298.498 1.0 94.72911  ? 227 TYR A CZ  227 TYR A CZ  1 
ATOM 1727  O OH  . TYR A 1 227 ? 318.411 -73.911 297.713 1.0 94.72911  ? 227 TYR A OH  227 TYR A OH  1 
ATOM 1728  N N   . ILE A 1 228 ? 317.753 -67.344 302.856 1.0 94.85399  ? 228 ILE A N   228 ILE A N   1 
ATOM 1729  C CA  . ILE A 1 228 ? 317.577 -66.317 303.878 1.0 94.85399  ? 228 ILE A CA  228 ILE A CA  1 
ATOM 1730  C C   . ILE A 1 228 ? 317.882 -66.925 305.248 1.0 94.85399  ? 228 ILE A C   228 ILE A C   1 
ATOM 1731  O O   . ILE A 1 228 ? 317.919 -68.146 305.414 1.0 94.85399  ? 228 ILE A O   228 ILE A O   1 
ATOM 1732  C CB  . ILE A 1 228 ? 316.134 -65.748 303.810 1.0 94.85399  ? 228 ILE A CB  228 ILE A CB  1 
ATOM 1733  C CG1 . ILE A 1 228 ? 316.022 -64.361 304.438 1.0 94.85399  ? 228 ILE A CG1 228 ILE A CG1 1 
ATOM 1734  C CG2 . ILE A 1 228 ? 315.153 -66.671 304.490 1.0 94.85399  ? 228 ILE A CG2 228 ILE A CG2 1 
ATOM 1735  C CD1 . ILE A 1 228 ? 314.693 -63.724 304.217 1.0 94.85399  ? 228 ILE A CD1 228 ILE A CD1 1 
ATOM 1736  N N   . ASN A 1 229 ? 318.123 -66.058 306.235 1.0 96.02526  ? 229 ASN A N   229 ASN A N   1 
ATOM 1737  C CA  . ASN A 1 229 ? 318.282 -66.463 307.627 1.0 96.02526  ? 229 ASN A CA  229 ASN A CA  1 
ATOM 1738  C C   . ASN A 1 229 ? 317.787 -65.353 308.536 1.0 96.02526  ? 229 ASN A C   229 ASN A C   1 
ATOM 1739  O O   . ASN A 1 229 ? 318.128 -64.186 308.327 1.0 96.02526  ? 229 ASN A O   229 ASN A O   1 
ATOM 1740  C CB  . ASN A 1 229 ? 319.742 -66.747 307.966 1.0 96.02526  ? 229 ASN A CB  229 ASN A CB  1 
ATOM 1741  C CG  . ASN A 1 229 ? 319.918 -67.408 309.312 1.0 96.02526  ? 229 ASN A CG  229 ASN A CG  1 
ATOM 1742  O OD1 . ASN A 1 229 ? 318.952 -67.755 309.992 1.0 96.02526  ? 229 ASN A OD1 229 ASN A OD1 1 
ATOM 1743  N ND2 . ASN A 1 229 ? 321.170 -67.582 309.712 1.0 96.02526  ? 229 ASN A ND2 229 ASN A ND2 1 
ATOM 1744  N N   . THR A 1 230 ? 316.995 -65.725 309.551 1.0 93.95155  ? 230 THR A N   230 THR A N   1 
ATOM 1745  C CA  . THR A 1 230 ? 316.737 -64.882 310.722 1.0 93.95155  ? 230 THR A CA  230 THR A CA  1 
ATOM 1746  C C   . THR A 1 230 ? 316.972 -65.744 311.966 1.0 93.95155  ? 230 THR A C   230 THR A C   1 
ATOM 1747  O O   . THR A 1 230 ? 316.019 -66.198 312.600 1.0 93.95155  ? 230 THR A O   230 THR A O   1 
ATOM 1748  C CB  . THR A 1 230 ? 315.310 -64.313 310.707 1.0 93.95155  ? 230 THR A CB  230 THR A CB  1 
ATOM 1749  O OG1 . THR A 1 230 ? 314.371 -65.393 310.733 1.0 93.95155  ? 230 THR A OG1 230 THR A OG1 1 
ATOM 1750  C CG2 . THR A 1 230 ? 315.055 -63.460 309.473 1.0 93.95155  ? 230 THR A CG2 230 THR A CG2 1 
ATOM 1751  N N   . THR A 1 231 ? 318.236 -65.912 312.342 1.0 98.51208  ? 231 THR A N   231 THR A N   1 
ATOM 1752  C CA  . THR A 1 231 ? 318.656 -66.630 313.550 1.0 98.51208  ? 231 THR A CA  231 THR A CA  1 
ATOM 1753  C C   . THR A 1 231 ? 319.912 -65.949 314.076 1.0 98.51208  ? 231 THR A C   231 THR A C   1 
ATOM 1754  O O   . THR A 1 231 ? 320.204 -64.798 313.734 1.0 98.51208  ? 231 THR A O   231 THR A O   1 
ATOM 1755  C CB  . THR A 1 231 ? 318.952 -68.128 313.311 1.0 98.51208  ? 231 THR A CB  231 THR A CB  1 
ATOM 1756  O OG1 . THR A 1 231 ? 319.930 -68.282 312.276 1.0 98.51208  ? 231 THR A OG1 231 THR A OG1 1 
ATOM 1757  C CG2 . THR A 1 231 ? 317.723 -68.949 313.002 1.0 98.51208  ? 231 THR A CG2 231 THR A CG2 1 
ATOM 1758  N N   . ASN A 1 232 ? 320.651 -66.664 314.923 1.0 101.67612 ? 232 ASN A N   232 ASN A N   1 
ATOM 1759  C CA  . ASN A 1 232 ? 322.005 -66.291 315.304 1.0 101.67612 ? 232 ASN A CA  232 ASN A CA  1 
ATOM 1760  C C   . ASN A 1 232 ? 322.987 -67.425 315.037 1.0 101.67612 ? 232 ASN A C   232 ASN A C   1 
ATOM 1761  O O   . ASN A 1 232 ? 324.041 -67.493 315.676 1.0 101.67612 ? 232 ASN A O   232 ASN A O   1 
ATOM 1762  C CB  . ASN A 1 232 ? 322.048 -65.881 316.775 1.0 101.67612 ? 232 ASN A CB  232 ASN A CB  1 
ATOM 1763  C CG  . ASN A 1 232 ? 321.268 -64.615 317.043 1.0 101.67612 ? 232 ASN A CG  232 ASN A CG  1 
ATOM 1764  O OD1 . ASN A 1 232 ? 321.330 -63.657 316.273 1.0 101.67612 ? 232 ASN A OD1 232 ASN A OD1 1 
ATOM 1765  N ND2 . ASN A 1 232 ? 320.520 -64.607 318.137 1.0 101.67612 ? 232 ASN A ND2 232 ASN A ND2 1 
ATOM 1766  N N   . ASN A 1 233 ? 322.659 -68.316 314.098 1.0 103.16013 ? 233 ASN A N   233 ASN A N   1 
ATOM 1767  C CA  . ASN A 1 233 ? 323.442 -69.527 313.882 1.0 103.16013 ? 233 ASN A CA  233 ASN A CA  1 
ATOM 1768  C C   . ASN A 1 233 ? 324.564 -69.356 312.869 1.0 103.16013 ? 233 ASN A C   233 ASN A C   1 
ATOM 1769  O O   . ASN A 1 233 ? 325.460 -70.207 312.828 1.0 103.16013 ? 233 ASN A O   233 ASN A O   1 
ATOM 1770  C CB  . ASN A 1 233 ? 322.532 -70.666 313.420 1.0 103.16013 ? 233 ASN A CB  233 ASN A CB  1 
ATOM 1771  C CG  . ASN A 1 233 ? 321.635 -71.176 314.525 1.0 103.16013 ? 233 ASN A CG  233 ASN A CG  1 
ATOM 1772  O OD1 . ASN A 1 233 ? 322.063 -71.312 315.669 1.0 103.16013 ? 233 ASN A OD1 233 ASN A OD1 1 
ATOM 1773  N ND2 . ASN A 1 233 ? 320.386 -71.470 314.187 1.0 103.16013 ? 233 ASN A ND2 233 ASN A ND2 1 
ATOM 1774  N N   . ASN A 1 234 ? 324.490 -68.330 312.014 1.0 103.35042 ? 234 ASN A N   234 ASN A N   1 
ATOM 1775  C CA  . ASN A 1 234 ? 325.459 -67.922 310.991 1.0 103.35042 ? 234 ASN A CA  234 ASN A CA  1 
ATOM 1776  C C   . ASN A 1 234 ? 325.580 -68.917 309.831 1.0 103.35042 ? 234 ASN A C   234 ASN A C   1 
ATOM 1777  O O   . ASN A 1 234 ? 326.299 -68.630 308.866 1.0 103.35042 ? 234 ASN A O   234 ASN A O   1 
ATOM 1778  C CB  . ASN A 1 234 ? 326.859 -67.664 311.577 1.0 103.35042 ? 234 ASN A CB  234 ASN A CB  1 
ATOM 1779  C CG  . ASN A 1 234 ? 327.644 -66.620 310.809 1.0 103.35042 ? 234 ASN A CG  234 ASN A CG  1 
ATOM 1780  O OD1 . ASN A 1 234 ? 328.693 -66.171 311.267 1.0 103.35042 ? 234 ASN A OD1 234 ASN A OD1 1 
ATOM 1781  N ND2 . ASN A 1 234 ? 327.127 -66.200 309.660 1.0 103.35042 ? 234 ASN A ND2 234 ASN A ND2 1 
ATOM 1782  N N   . GLY A 1 235 ? 324.902 -70.063 309.880 1.0 103.99428 ? 235 GLY A N   235 GLY A N   1 
ATOM 1783  C CA  . GLY A 1 235 ? 324.966 -71.035 308.808 1.0 103.99428 ? 235 GLY A CA  235 GLY A CA  1 
ATOM 1784  C C   . GLY A 1 235 ? 323.637 -71.714 308.551 1.0 103.99428 ? 235 GLY A C   235 GLY A C   1 
ATOM 1785  O O   . GLY A 1 235 ? 323.529 -72.571 307.670 1.0 103.99428 ? 235 GLY A O   235 GLY A O   1 
ATOM 1786  N N   . ARG A 1 236 ? 322.616 -71.341 309.313 1.0 100.5933  ? 236 ARG A N   236 ARG A N   1 
ATOM 1787  C CA  . ARG A 1 236 ? 321.287 -71.892 309.103 1.0 100.5933  ? 236 ARG A CA  236 ARG A CA  1 
ATOM 1788  C C   . ARG A 1 236 ? 320.603 -71.174 307.947 1.0 100.5933  ? 236 ARG A C   236 ARG A C   1 
ATOM 1789  O O   . ARG A 1 236 ? 320.724 -69.958 307.798 1.0 100.5933  ? 236 ARG A O   236 ARG A O   1 
ATOM 1790  C CB  . ARG A 1 236 ? 320.444 -71.772 310.375 1.0 100.5933  ? 236 ARG A CB  236 ARG A CB  1 
ATOM 1791  C CG  . ARG A 1 236 ? 319.068 -72.405 310.246 1.0 100.5933  ? 236 ARG A CG  236 ARG A CG  1 
ATOM 1792  C CD  . ARG A 1 236 ? 318.264 -72.416 311.525 1.0 100.5933  ? 236 ARG A CD  236 ARG A CD  1 
ATOM 1793  N NE  . ARG A 1 236 ? 316.927 -72.945 311.275 1.0 100.5933  ? 236 ARG A NE  236 ARG A NE  1 
ATOM 1794  C CZ  . ARG A 1 236 ? 316.623 -74.239 311.274 1.0 100.5933  ? 236 ARG A CZ  236 ARG A CZ  1 
ATOM 1795  N NH1 . ARG A 1 236 ? 317.558 -75.143 311.518 1.0 100.5933  ? 236 ARG A NH1 236 ARG A NH1 1 
ATOM 1796  N NH2 . ARG A 1 236 ? 315.379 -74.628 311.030 1.0 100.5933  ? 236 ARG A NH2 236 ARG A NH2 1 
ATOM 1797  N N   . VAL A 1 237 ? 319.911 -71.938 307.110 1.0 98.05112  ? 237 VAL A N   237 VAL A N   1 
ATOM 1798  C CA  . VAL A 1 237 ? 319.013 -71.399 306.097 1.0 98.05112  ? 237 VAL A CA  237 VAL A CA  1 
ATOM 1799  C C   . VAL A 1 237 ? 317.590 -71.559 306.609 1.0 98.05112  ? 237 VAL A C   237 VAL A C   1 
ATOM 1800  O O   . VAL A 1 237 ? 317.178 -72.664 306.980 1.0 98.05112  ? 237 VAL A O   237 VAL A O   1 
ATOM 1801  C CB  . VAL A 1 237 ? 319.197 -72.113 304.752 1.0 98.05112  ? 237 VAL A CB  237 VAL A CB  1 
ATOM 1802  C CG1 . VAL A 1 237 ? 318.146 -71.657 303.771 1.0 98.05112  ? 237 VAL A CG1 237 VAL A CG1 1 
ATOM 1803  C CG2 . VAL A 1 237 ? 320.593 -71.872 304.214 1.0 98.05112  ? 237 VAL A CG2 237 VAL A CG2 1 
ATOM 1804  N N   . SER A 1 238 ? 316.832 -70.466 306.629 1.0 94.02166  ? 238 SER A N   238 SER A N   1 
ATOM 1805  C CA  . SER A 1 238 ? 315.480 -70.481 307.166 1.0 94.02166  ? 238 SER A CA  238 SER A CA  1 
ATOM 1806  C C   . SER A 1 238 ? 314.403 -70.245 306.119 1.0 94.02166  ? 238 SER A C   238 SER A C   1 
ATOM 1807  O O   . SER A 1 238 ? 313.227 -70.146 306.478 1.0 94.02166  ? 238 SER A O   238 SER A O   1 
ATOM 1808  C CB  . SER A 1 238 ? 315.350 -69.441 308.278 1.0 94.02166  ? 238 SER A CB  238 SER A CB  1 
ATOM 1809  O OG  . SER A 1 238 ? 316.202 -69.763 309.358 1.0 94.02166  ? 238 SER A OG  238 SER A OG  1 
ATOM 1810  N N   . GLY A 1 239 ? 314.761 -70.152 304.845 1.0 93.46841  ? 239 GLY A N   239 GLY A N   1 
ATOM 1811  C CA  . GLY A 1 239 ? 313.769 -69.999 303.800 1.0 93.46841  ? 239 GLY A CA  239 GLY A CA  1 
ATOM 1812  C C   . GLY A 1 239 ? 314.416 -70.112 302.443 1.0 93.46841  ? 239 GLY A C   239 GLY A C   1 
ATOM 1813  O O   . GLY A 1 239 ? 315.628 -69.927 302.297 1.0 93.46841  ? 239 GLY A O   239 GLY A O   1 
ATOM 1814  N N   . THR A 1 240 ? 313.593 -70.418 301.443 1.0 91.93729  ? 240 THR A N   240 THR A N   1 
ATOM 1815  C CA  . THR A 1 240 ? 314.097 -70.644 300.094 1.0 91.93729  ? 240 THR A CA  240 THR A CA  1 
ATOM 1816  C C   . THR A 1 240 ? 313.701 -69.552 299.113 1.0 91.93729  ? 240 THR A C   240 THR A C   1 
ATOM 1817  O O   . THR A 1 240 ? 314.577 -69.004 298.440 1.0 91.93729  ? 240 THR A O   240 THR A O   1 
ATOM 1818  C CB  . THR A 1 240 ? 313.617 -71.994 299.565 1.0 91.93729  ? 240 THR A CB  240 THR A CB  1 
ATOM 1819  O OG1 . THR A 1 240 ? 312.198 -71.951 299.414 1.0 91.93729  ? 240 THR A OG1 240 THR A OG1 1 
ATOM 1820  C CG2 . THR A 1 240 ? 313.980 -73.094 300.536 1.0 91.93729  ? 240 THR A CG2 240 THR A CG2 1 
ATOM 1821  N N   . MET A 1 241 ? 312.399 -69.262 298.994 1.0 89.50372  ? 241 MET A N   241 MET A N   1 
ATOM 1822  C CA  . MET A 1 241 ? 311.842 -68.135 298.233 1.0 89.50372  ? 241 MET A CA  241 MET A CA  1 
ATOM 1823  C C   . MET A 1 241 ? 312.236 -68.192 296.753 1.0 89.50372  ? 241 MET A C   241 MET A C   1 
ATOM 1824  O O   . MET A 1 241 ? 313.082 -67.428 296.281 1.0 89.50372  ? 241 MET A O   241 MET A O   1 
ATOM 1825  C CB  . MET A 1 241 ? 312.253 -66.791 298.843 1.0 89.50372  ? 241 MET A CB  241 MET A CB  1 
ATOM 1826  C CG  . MET A 1 241 ? 311.825 -66.618 300.272 1.0 89.50372  ? 241 MET A CG  241 MET A CG  1 
ATOM 1827  S SD  . MET A 1 241 ? 312.165 -64.958 300.865 1.0 89.50372  ? 241 MET A SD  241 MET A SD  1 
ATOM 1828  C CE  . MET A 1 241 ? 313.947 -64.946 300.796 1.0 89.50372  ? 241 MET A CE  241 MET A CE  1 
ATOM 1829  N N   . ALA A 1 242 ? 311.655 -69.173 296.058 1.0 86.43696  ? 242 ALA A N   242 ALA A N   1 
ATOM 1830  C CA  . ALA A 1 242 ? 311.853 -69.337 294.620 1.0 86.43696  ? 242 ALA A CA  242 ALA A CA  1 
ATOM 1831  C C   . ALA A 1 242 ? 311.462 -68.080 293.853 1.0 86.43696  ? 242 ALA A C   242 ALA A C   1 
ATOM 1832  O O   . ALA A 1 242 ? 310.283 -67.723 293.792 1.0 86.43696  ? 242 ALA A O   242 ALA A O   1 
ATOM 1833  C CB  . ALA A 1 242 ? 311.048 -70.528 294.109 1.0 86.43696  ? 242 ALA A CB  242 ALA A CB  1 
ATOM 1834  N N   . THR A 1 243 ? 312.450 -67.406 293.265 1.0 85.67474  ? 243 THR A N   243 THR A N   1 
ATOM 1835  C CA  . THR A 1 243 ? 312.257 -66.044 292.794 1.0 85.67474  ? 243 THR A CA  243 THR A CA  1 
ATOM 1836  C C   . THR A 1 243 ? 311.518 -66.026 291.458 1.0 85.67474  ? 243 THR A C   243 THR A C   1 
ATOM 1837  O O   . THR A 1 243 ? 311.147 -67.061 290.899 1.0 85.67474  ? 243 THR A O   243 THR A O   1 
ATOM 1838  C CB  . THR A 1 243 ? 313.593 -65.314 292.689 1.0 85.67474  ? 243 THR A CB  243 THR A CB  1 
ATOM 1839  O OG1 . THR A 1 243 ? 313.348 -63.921 292.473 1.0 85.67474  ? 243 THR A OG1 243 THR A OG1 1 
ATOM 1840  C CG2 . THR A 1 243 ? 314.409 -65.835 291.524 1.0 85.67474  ? 243 THR A CG2 243 THR A CG2 1 
ATOM 1841  N N   . ASP A 1 244 ? 311.309 -64.820 290.938 1.0 84.17778  ? 244 ASP A N   244 ASP A N   1 
ATOM 1842  C CA  . ASP A 1 244 ? 310.406 -64.609 289.822 1.0 84.17778  ? 244 ASP A CA  244 ASP A CA  1 
ATOM 1843  C C   . ASP A 1 244 ? 310.812 -63.314 289.131 1.0 84.17778  ? 244 ASP A C   244 ASP A C   1 
ATOM 1844  O O   . ASP A 1 244 ? 311.481 -62.462 289.718 1.0 84.17778  ? 244 ASP A O   244 ASP A O   1 
ATOM 1845  C CB  . ASP A 1 244 ? 308.958 -64.566 290.328 1.0 84.17778  ? 244 ASP A CB  244 ASP A CB  1 
ATOM 1846  C CG  . ASP A 1 244 ? 307.935 -64.651 289.224 1.0 84.17778  ? 244 ASP A CG  244 ASP A CG  1 
ATOM 1847  O OD1 . ASP A 1 244 ? 308.314 -64.671 288.044 1.0 84.17778  ? 244 ASP A OD1 244 ASP A OD1 1 
ATOM 1848  O OD2 . ASP A 1 244 ? 306.733 -64.709 289.540 1.0 84.17778  ? 244 ASP A OD2 244 ASP A OD2 1 
ATOM 1849  N N   . THR A 1 245 ? 310.421 -63.190 287.863 1.0 84.29882  ? 245 THR A N   245 THR A N   1 
ATOM 1850  C CA  . THR A 1 245 ? 310.569 -61.947 287.119 1.0 84.29882  ? 245 THR A CA  245 THR A CA  1 
ATOM 1851  C C   . THR A 1 245 ? 309.257 -61.603 286.426 1.0 84.29882  ? 245 THR A C   245 THR A C   1 
ATOM 1852  O O   . THR A 1 245 ? 308.531 -62.487 285.962 1.0 84.29882  ? 245 THR A O   245 THR A O   1 
ATOM 1853  C CB  . THR A 1 245 ? 311.731 -62.024 286.116 1.0 84.29882  ? 245 THR A CB  245 THR A CB  1 
ATOM 1854  O OG1 . THR A 1 245 ? 311.797 -60.805 285.365 1.0 84.29882  ? 245 THR A OG1 245 THR A OG1 1 
ATOM 1855  C CG2 . THR A 1 245 ? 311.587 -63.204 285.188 1.0 84.29882  ? 245 THR A CG2 245 THR A CG2 1 
ATOM 1856  N N   . ILE A 1 246 ? 308.930 -60.311 286.418 1.0 81.32392  ? 246 ILE A N   246 ILE A N   1 
ATOM 1857  C CA  . ILE A 1 246 ? 307.652 -59.800 285.945 1.0 81.32392  ? 246 ILE A CA  246 ILE A CA  1 
ATOM 1858  C C   . ILE A 1 246 ? 307.979 -58.804 284.825 1.0 81.32392  ? 246 ILE A C   246 ILE A C   1 
ATOM 1859  O O   . ILE A 1 246 ? 309.143 -58.546 284.525 1.0 81.32392  ? 246 ILE A O   246 ILE A O   1 
ATOM 1860  C CB  . ILE A 1 246 ? 306.842 -59.134 287.092 1.0 81.32392  ? 246 ILE A CB  246 ILE A CB  1 
ATOM 1861  C CG1 . ILE A 1 246 ? 306.911 -59.951 288.382 1.0 81.32392  ? 246 ILE A CG1 246 ILE A CG1 1 
ATOM 1862  C CG2 . ILE A 1 246 ? 305.342 -59.065 286.819 1.0 81.32392  ? 246 ILE A CG2 246 ILE A CG2 1 
ATOM 1863  C CD1 . ILE A 1 246 ? 306.288 -61.320 288.330 1.0 81.32392  ? 246 ILE A CD1 246 ILE A CD1 1 
ATOM 1864  N N   . THR A 1 247 ? 306.945 -58.284 284.168 1.0 82.35401  ? 247 THR A N   247 THR A N   1 
ATOM 1865  C CA  . THR A 1 247 ? 307.065 -57.059 283.396 1.0 82.35401  ? 247 THR A CA  247 THR A CA  1 
ATOM 1866  C C   . THR A 1 247 ? 306.422 -55.867 284.089 1.0 82.35401  ? 247 THR A C   247 THR A C   1 
ATOM 1867  O O   . THR A 1 247 ? 306.529 -54.749 283.573 1.0 82.35401  ? 247 THR A O   247 THR A O   1 
ATOM 1868  C CB  . THR A 1 247 ? 306.444 -57.233 282.010 1.0 82.35401  ? 247 THR A CB  247 THR A CB  1 
ATOM 1869  O OG1 . THR A 1 247 ? 306.709 -56.069 281.219 1.0 82.35401  ? 247 THR A OG1 247 THR A OG1 1 
ATOM 1870  C CG2 . THR A 1 247 ? 304.945 -57.433 282.130 1.0 82.35401  ? 247 THR A CG2 247 THR A CG2 1 
ATOM 1871  N N   . TRP A 1 248 ? 305.749 -56.094 285.225 1.0 80.75882  ? 248 TRP A N   248 TRP A N   1 
ATOM 1872  C CA  . TRP A 1 248 ? 305.253 -55.071 286.154 1.0 80.75882  ? 248 TRP A CA  248 TRP A CA  1 
ATOM 1873  C C   . TRP A 1 248 ? 304.264 -54.110 285.490 1.0 80.75882  ? 248 TRP A C   248 TRP A C   1 
ATOM 1874  O O   . TRP A 1 248 ? 304.529 -52.925 285.297 1.0 80.75882  ? 248 TRP A O   248 TRP A O   1 
ATOM 1875  C CB  . TRP A 1 248 ? 306.404 -54.285 286.785 1.0 80.75882  ? 248 TRP A CB  248 TRP A CB  1 
ATOM 1876  C CG  . TRP A 1 248 ? 307.210 -55.071 287.727 1.0 80.75882  ? 248 TRP A CG  248 TRP A CG  1 
ATOM 1877  C CD1 . TRP A 1 248 ? 308.402 -55.668 287.478 1.0 80.75882  ? 248 TRP A CD1 248 TRP A CD1 1 
ATOM 1878  C CD2 . TRP A 1 248 ? 306.890 -55.355 289.086 1.0 80.75882  ? 248 TRP A CD2 248 TRP A CD2 1 
ATOM 1879  N NE1 . TRP A 1 248 ? 308.854 -56.309 288.602 1.0 80.75882  ? 248 TRP A NE1 248 TRP A NE1 1 
ATOM 1880  C CE2 . TRP A 1 248 ? 307.940 -56.131 289.605 1.0 80.75882  ? 248 TRP A CE2 248 TRP A CE2 1 
ATOM 1881  C CE3 . TRP A 1 248 ? 305.819 -55.029 289.916 1.0 80.75882  ? 248 TRP A CE3 248 TRP A CE3 1 
ATOM 1882  C CZ2 . TRP A 1 248 ? 307.950 -56.584 290.911 1.0 80.75882  ? 248 TRP A CZ2 248 TRP A CZ2 1 
ATOM 1883  C CZ3 . TRP A 1 248 ? 305.831 -55.480 291.212 1.0 80.75882  ? 248 TRP A CZ3 248 TRP A CZ3 1 
ATOM 1884  C CH2 . TRP A 1 248 ? 306.891 -56.247 291.698 1.0 80.75882  ? 248 TRP A CH2 248 TRP A CH2 1 
ATOM 1885  N N   . GLU A 1 249 ? 303.120 -54.661 285.129 1.0 77.23919  ? 249 GLU A N   249 GLU A N   1 
ATOM 1886  C CA  . GLU A 1 249 ? 301.997 -53.839 284.727 1.0 77.23919  ? 249 GLU A CA  249 GLU A CA  1 
ATOM 1887  C C   . GLU A 1 249 ? 301.174 -53.500 285.960 1.0 77.23919  ? 249 GLU A C   249 GLU A C   1 
ATOM 1888  O O   . GLU A 1 249 ? 300.951 -54.350 286.825 1.0 77.23919  ? 249 GLU A O   249 GLU A O   1 
ATOM 1889  C CB  . GLU A 1 249 ? 301.138 -54.561 283.697 1.0 77.23919  ? 249 GLU A CB  249 GLU A CB  1 
ATOM 1890  C CG  . GLU A 1 249 ? 301.829 -54.776 282.367 1.0 77.23919  ? 249 GLU A CG  249 GLU A CG  1 
ATOM 1891  C CD  . GLU A 1 249 ? 300.965 -55.544 281.400 1.0 77.23919  ? 249 GLU A CD  249 GLU A CD  1 
ATOM 1892  O OE1 . GLU A 1 249 ? 299.874 -55.987 281.810 1.0 77.23919  ? 249 GLU A OE1 249 GLU A OE1 1 
ATOM 1893  O OE2 . GLU A 1 249 ? 301.376 -55.717 280.236 1.0 77.23919  ? 249 GLU A OE2 249 GLU A OE2 1 
ATOM 1894  N N   . ASN A 1 250 ? 300.746 -52.247 286.050 1.0 74.21768  ? 250 ASN A N   250 ASN A N   1 
ATOM 1895  C CA  . ASN A 1 250 ? 299.837 -51.799 287.104 1.0 74.21768  ? 250 ASN A CA  250 ASN A CA  1 
ATOM 1896  C C   . ASN A 1 250 ? 298.608 -51.159 286.474 1.0 74.21768  ? 250 ASN A C   250 ASN A C   1 
ATOM 1897  O O   . ASN A 1 250 ? 298.537 -49.934 286.323 1.0 74.21768  ? 250 ASN A O   250 ASN A O   1 
ATOM 1898  C CB  . ASN A 1 250 ? 300.549 -50.862 288.093 1.0 74.21768  ? 250 ASN A CB  250 ASN A CB  1 
ATOM 1899  C CG  . ASN A 1 250 ? 301.385 -49.788 287.411 1.0 74.21768  ? 250 ASN A CG  250 ASN A CG  1 
ATOM 1900  O OD1 . ASN A 1 250 ? 301.459 -49.722 286.180 1.0 74.21768  ? 250 ASN A OD1 250 ASN A OD1 1 
ATOM 1901  N ND2 . ASN A 1 250 ? 302.007 -48.936 288.210 1.0 74.21768  ? 250 ASN A ND2 250 ASN A ND2 1 
ATOM 1902  N N   . PRO A 1 251 ? 297.610 -51.954 286.095 1.0 71.13301  ? 251 PRO A N   251 PRO A N   1 
ATOM 1903  C CA  . PRO A 1 251 ? 296.332 -51.366 285.701 1.0 71.13301  ? 251 PRO A CA  251 PRO A CA  1 
ATOM 1904  C C   . PRO A 1 251 ? 295.556 -50.947 286.939 1.0 71.13301  ? 251 PRO A C   251 PRO A C   1 
ATOM 1905  O O   . PRO A 1 251 ? 295.948 -51.232 288.072 1.0 71.13301  ? 251 PRO A O   251 PRO A O   1 
ATOM 1906  C CB  . PRO A 1 251 ? 295.628 -52.495 284.950 1.0 71.13301  ? 251 PRO A CB  251 PRO A CB  1 
ATOM 1907  C CG  . PRO A 1 251 ? 296.155 -53.706 285.572 1.0 71.13301  ? 251 PRO A CG  251 PRO A CG  1 
ATOM 1908  C CD  . PRO A 1 251 ? 297.593 -53.413 285.916 1.0 71.13301  ? 251 PRO A CD  251 PRO A CD  1 
ATOM 1909  N N   . ASP A 1 252 ? 294.502 -50.170 286.682 1.0 69.40913  ? 252 ASP A N   252 ASP A N   1 
ATOM 1910  C CA  . ASP A 1 252 ? 293.429 -49.702 287.563 1.0 69.40913  ? 252 ASP A CA  252 ASP A CA  1 
ATOM 1911  C C   . ASP A 1 252 ? 293.844 -49.282 288.978 1.0 69.40913  ? 252 ASP A C   252 ASP A C   1 
ATOM 1912  O O   . ASP A 1 252 ? 293.074 -49.461 289.925 1.0 69.40913  ? 252 ASP A O   252 ASP A O   1 
ATOM 1913  C CB  . ASP A 1 252 ? 292.267 -50.728 287.556 1.0 69.40913  ? 252 ASP A CB  252 ASP A CB  1 
ATOM 1914  C CG  . ASP A 1 252 ? 292.560 -52.064 288.247 1.0 69.40913  ? 252 ASP A CG  252 ASP A CG  1 
ATOM 1915  O OD1 . ASP A 1 252 ? 293.558 -52.272 288.946 1.0 69.40913  ? 252 ASP A OD1 252 ASP A OD1 1 
ATOM 1916  O OD2 . ASP A 1 252 ? 291.735 -52.975 288.056 1.0 69.40913  ? 252 ASP A OD2 252 ASP A OD2 1 
ATOM 1917  N N   . ALA A 1 253 ? 295.035 -48.689 289.119 1.0 68.4918   ? 253 ALA A N   253 ALA A N   1 
ATOM 1918  C CA  . ALA A 1 253 ? 295.512 -48.089 290.364 1.0 68.4918   ? 253 ALA A CA  253 ALA A CA  1 
ATOM 1919  C C   . ALA A 1 253 ? 296.667 -47.150 290.038 1.0 68.4918   ? 253 ALA A C   253 ALA A C   1 
ATOM 1920  O O   . ALA A 1 253 ? 297.411 -47.381 289.082 1.0 68.4918   ? 253 ALA A O   253 ALA A O   1 
ATOM 1921  C CB  . ALA A 1 253 ? 295.947 -49.143 291.381 1.0 68.4918   ? 253 ALA A CB  253 ALA A CB  1 
ATOM 1922  N N   . HIS A 1 254 ? 296.816 -46.080 290.836 1.0 70.01398  ? 254 HIS A N   254 HIS A N   1 
ATOM 1923  C CA  . HIS A 1 254 ? 297.595 -44.951 290.338 1.0 70.01398  ? 254 HIS A CA  254 HIS A CA  1 
ATOM 1924  C C   . HIS A 1 254 ? 298.480 -44.270 291.383 1.0 70.01398  ? 254 HIS A C   254 HIS A C   1 
ATOM 1925  O O   . HIS A 1 254 ? 298.739 -43.066 291.258 1.0 70.01398  ? 254 HIS A O   254 HIS A O   1 
ATOM 1926  C CB  . HIS A 1 254 ? 296.670 -43.903 289.727 1.0 70.01398  ? 254 HIS A CB  254 HIS A CB  1 
ATOM 1927  C CG  . HIS A 1 254 ? 295.733 -43.281 290.713 1.0 70.01398  ? 254 HIS A CG  254 HIS A CG  1 
ATOM 1928  N ND1 . HIS A 1 254 ? 294.574 -43.897 291.129 1.0 70.01398  ? 254 HIS A ND1 254 HIS A ND1 1 
ATOM 1929  C CD2 . HIS A 1 254 ? 295.791 -42.103 291.375 1.0 70.01398  ? 254 HIS A CD2 254 HIS A CD2 1 
ATOM 1930  C CE1 . HIS A 1 254 ? 293.954 -43.121 292.000 1.0 70.01398  ? 254 HIS A CE1 254 HIS A CE1 1 
ATOM 1931  N NE2 . HIS A 1 254 ? 294.673 -42.027 292.167 1.0 70.01398  ? 254 HIS A NE2 254 HIS A NE2 1 
ATOM 1932  N N   . PHE A 1 255 ? 298.981 -45.014 292.380 1.0 76.29733  ? 255 PHE A N   255 PHE A N   1 
ATOM 1933  C CA  . PHE A 1 255 ? 299.930 -44.517 293.392 1.0 76.29733  ? 255 PHE A CA  255 PHE A CA  1 
ATOM 1934  C C   . PHE A 1 255 ? 299.356 -43.326 294.169 1.0 76.29733  ? 255 PHE A C   255 PHE A C   1 
ATOM 1935  O O   . PHE A 1 255 ? 299.707 -42.174 293.912 1.0 76.29733  ? 255 PHE A O   255 PHE A O   1 
ATOM 1936  C CB  . PHE A 1 255 ? 301.291 -44.132 292.791 1.0 76.29733  ? 255 PHE A CB  255 PHE A CB  1 
ATOM 1937  C CG  . PHE A 1 255 ? 302.111 -45.286 292.307 1.0 76.29733  ? 255 PHE A CG  255 PHE A CG  1 
ATOM 1938  C CD1 . PHE A 1 255 ? 302.786 -46.093 293.205 1.0 76.29733  ? 255 PHE A CD1 255 PHE A CD1 1 
ATOM 1939  C CD2 . PHE A 1 255 ? 302.259 -45.524 290.951 1.0 76.29733  ? 255 PHE A CD2 255 PHE A CD2 1 
ATOM 1940  C CE1 . PHE A 1 255 ? 303.560 -47.143 292.763 1.0 76.29733  ? 255 PHE A CE1 255 PHE A CE1 1 
ATOM 1941  C CE2 . PHE A 1 255 ? 303.035 -46.574 290.501 1.0 76.29733  ? 255 PHE A CE2 255 PHE A CE2 1 
ATOM 1942  C CZ  . PHE A 1 255 ? 303.692 -47.378 291.409 1.0 76.29733  ? 255 PHE A CZ  255 PHE A CZ  1 
ATOM 1943  N N   . ALA A 1 256 ? 298.383 -43.634 295.039 1.0 79.09581  ? 256 ALA A N   256 ALA A N   1 
ATOM 1944  C CA  . ALA A 1 256 ? 297.759 -42.620 295.896 1.0 79.09581  ? 256 ALA A CA  256 ALA A CA  1 
ATOM 1945  C C   . ALA A 1 256 ? 298.785 -41.813 296.692 1.0 79.09581  ? 256 ALA A C   256 ALA A C   1 
ATOM 1946  O O   . ALA A 1 256 ? 298.717 -40.581 296.728 1.0 79.09581  ? 256 ALA A O   256 ALA A O   1 
ATOM 1947  C CB  . ALA A 1 256 ? 296.757 -43.280 296.841 1.0 79.09581  ? 256 ALA A CB  256 ALA A CB  1 
ATOM 1948  N N   . ASP A 1 257 ? 299.749 -42.485 297.320 1.0 82.6438   ? 257 ASP A N   257 ASP A N   1 
ATOM 1949  C CA  . ASP A 1 257 ? 300.979 -41.850 297.779 1.0 82.6438   ? 257 ASP A CA  257 ASP A CA  1 
ATOM 1950  C C   . ASP A 1 257 ? 302.158 -42.721 297.380 1.0 82.6438   ? 257 ASP A C   257 ASP A C   1 
ATOM 1951  O O   . ASP A 1 257 ? 301.994 -43.880 296.997 1.0 82.6438   ? 257 ASP A O   257 ASP A O   1 
ATOM 1952  C CB  . ASP A 1 257 ? 301.008 -41.605 299.292 1.0 82.6438   ? 257 ASP A CB  257 ASP A CB  1 
ATOM 1953  C CG  . ASP A 1 257 ? 300.299 -40.326 299.696 1.0 82.6438   ? 257 ASP A CG  257 ASP A CG  1 
ATOM 1954  O OD1 . ASP A 1 257 ? 300.234 -39.387 298.879 1.0 82.6438   ? 257 ASP A OD1 257 ASP A OD1 1 
ATOM 1955  O OD2 . ASP A 1 257 ? 299.843 -40.236 300.853 1.0 82.6438   ? 257 ASP A OD2 257 ASP A OD2 1 
ATOM 1956  N N   . PHE A 1 258 ? 303.357 -42.148 297.494 1.0 87.34247  ? 258 PHE A N   258 PHE A N   1 
ATOM 1957  C CA  . PHE A 1 258 ? 304.580 -42.799 297.040 1.0 87.34247  ? 258 PHE A CA  258 PHE A CA  1 
ATOM 1958  C C   . PHE A 1 258 ? 305.804 -42.109 297.622 1.0 87.34247  ? 258 PHE A C   258 PHE A C   1 
ATOM 1959  O O   . PHE A 1 258 ? 305.906 -40.880 297.570 1.0 87.34247  ? 258 PHE A O   258 PHE A O   1 
ATOM 1960  C CB  . PHE A 1 258 ? 304.651 -42.782 295.512 1.0 87.34247  ? 258 PHE A CB  258 PHE A CB  1 
ATOM 1961  C CG  . PHE A 1 258 ? 305.859 -43.461 294.952 1.0 87.34247  ? 258 PHE A CG  258 PHE A CG  1 
ATOM 1962  C CD1 . PHE A 1 258 ? 305.943 -44.840 294.929 1.0 87.34247  ? 258 PHE A CD1 258 PHE A CD1 1 
ATOM 1963  C CD2 . PHE A 1 258 ? 306.902 -42.719 294.427 1.0 87.34247  ? 258 PHE A CD2 258 PHE A CD2 1 
ATOM 1964  C CE1 . PHE A 1 258 ? 307.053 -45.470 294.405 1.0 87.34247  ? 258 PHE A CE1 258 PHE A CE1 1 
ATOM 1965  C CE2 . PHE A 1 258 ? 308.013 -43.341 293.902 1.0 87.34247  ? 258 PHE A CE2 258 PHE A CE2 1 
ATOM 1966  C CZ  . PHE A 1 258 ? 308.089 -44.719 293.891 1.0 87.34247  ? 258 PHE A CZ  258 PHE A CZ  1 
ATOM 1967  N N   . VAL A 1 259 ? 306.737 -42.877 298.178 1.0 91.86426  ? 259 VAL A N   259 VAL A N   1 
ATOM 1968  C CA  . VAL A 1 259 ? 308.011 -42.294 298.580 1.0 91.86426  ? 259 VAL A CA  259 VAL A CA  1 
ATOM 1969  C C   . VAL A 1 259 ? 309.191 -43.201 298.215 1.0 91.86426  ? 259 VAL A C   259 VAL A C   1 
ATOM 1970  O O   . VAL A 1 259 ? 309.461 -44.231 298.843 1.0 91.86426  ? 259 VAL A O   259 VAL A O   1 
ATOM 1971  C CB  . VAL A 1 259 ? 307.970 -41.866 300.066 1.0 91.86426  ? 259 VAL A CB  259 VAL A CB  1 
ATOM 1972  C CG1 . VAL A 1 259 ? 307.449 -42.951 300.962 1.0 91.86426  ? 259 VAL A CG1 259 VAL A CG1 1 
ATOM 1973  C CG2 . VAL A 1 259 ? 309.335 -41.407 300.529 1.0 91.86426  ? 259 VAL A CG2 259 VAL A CG2 1 
ATOM 1974  N N   . ASP A 1 260 ? 309.795 -42.861 297.081 1.0 98.16397  ? 260 ASP A N   260 ASP A N   1 
ATOM 1975  C CA  . ASP A 1 260 ? 311.175 -43.059 296.646 1.0 98.16397  ? 260 ASP A CA  260 ASP A CA  1 
ATOM 1976  C C   . ASP A 1 260 ? 311.623 -44.461 296.229 1.0 98.16397  ? 260 ASP A C   260 ASP A C   1 
ATOM 1977  O O   . ASP A 1 260 ? 312.485 -44.551 295.345 1.0 98.16397  ? 260 ASP A O   260 ASP A O   1 
ATOM 1978  C CB  . ASP A 1 260 ? 312.094 -42.558 297.775 1.0 98.16397  ? 260 ASP A CB  260 ASP A CB  1 
ATOM 1979  C CG  . ASP A 1 260 ? 313.571 -42.577 297.403 1.0 98.16397  ? 260 ASP A CG  260 ASP A CG  1 
ATOM 1980  O OD1 . ASP A 1 260 ? 314.005 -41.708 296.617 1.0 98.16397  ? 260 ASP A OD1 260 ASP A OD1 1 
ATOM 1981  O OD2 . ASP A 1 260 ? 314.296 -43.467 297.900 1.0 98.16397  ? 260 ASP A OD2 260 ASP A OD2 1 
ATOM 1982  N N   . ASP A 1 261 ? 311.058 -45.554 296.770 1.0 97.03475  ? 261 ASP A N   261 ASP A N   1 
ATOM 1983  C CA  . ASP A 1 261 ? 310.894 -46.785 295.993 1.0 97.03475  ? 261 ASP A CA  261 ASP A CA  1 
ATOM 1984  C C   . ASP A 1 261 ? 309.773 -47.686 296.497 1.0 97.03475  ? 261 ASP A C   261 ASP A C   1 
ATOM 1985  O O   . ASP A 1 261 ? 309.076 -48.331 295.708 1.0 97.03475  ? 261 ASP A O   261 ASP A O   1 
ATOM 1986  C CB  . ASP A 1 261 ? 312.181 -47.623 295.974 1.0 97.03475  ? 261 ASP A CB  261 ASP A CB  1 
ATOM 1987  C CG  . ASP A 1 261 ? 312.122 -48.746 294.958 1.0 97.03475  ? 261 ASP A CG  261 ASP A CG  1 
ATOM 1988  O OD1 . ASP A 1 261 ? 312.219 -48.454 293.750 1.0 97.03475  ? 261 ASP A OD1 261 ASP A OD1 1 
ATOM 1989  O OD2 . ASP A 1 261 ? 311.968 -49.916 295.359 1.0 97.03475  ? 261 ASP A OD2 261 ASP A OD2 1 
ATOM 1990  N N   . ARG A 1 262 ? 309.587 -47.718 297.818 1.0 94.63456  ? 262 ARG A N   262 ARG A N   1 
ATOM 1991  C CA  . ARG A 1 262 ? 309.144 -48.944 298.478 1.0 94.63456  ? 262 ARG A CA  262 ARG A CA  1 
ATOM 1992  C C   . ARG A 1 262 ? 307.801 -48.825 299.180 1.0 94.63456  ? 262 ARG A C   262 ARG A C   1 
ATOM 1993  O O   . ARG A 1 262 ? 306.884 -49.591 298.873 1.0 94.63456  ? 262 ARG A O   262 ARG A O   1 
ATOM 1994  C CB  . ARG A 1 262 ? 310.206 -49.397 299.486 1.0 94.63456  ? 262 ARG A CB  262 ARG A CB  1 
ATOM 1995  C CG  . ARG A 1 262 ? 309.810 -50.643 300.257 1.0 94.63456  ? 262 ARG A CG  262 ARG A CG  1 
ATOM 1996  C CD  . ARG A 1 262 ? 310.906 -51.110 301.200 1.0 94.63456  ? 262 ARG A CD  262 ARG A CD  1 
ATOM 1997  N NE  . ARG A 1 262 ? 310.555 -52.374 301.841 1.0 94.63456  ? 262 ARG A NE  262 ARG A NE  1 
ATOM 1998  C CZ  . ARG A 1 262 ? 309.879 -52.474 302.980 1.0 94.63456  ? 262 ARG A CZ  262 ARG A CZ  1 
ATOM 1999  N NH1 . ARG A 1 262 ? 309.478 -51.381 303.611 1.0 94.63456  ? 262 ARG A NH1 262 ARG A NH1 1 
ATOM 2000  N NH2 . ARG A 1 262 ? 309.602 -53.665 303.488 1.0 94.63456  ? 262 ARG A NH2 262 ARG A NH2 1 
ATOM 2001  N N   . ARG A 1 263 ? 307.663 -47.917 300.135 1.0 89.49908  ? 263 ARG A N   263 ARG A N   1 
ATOM 2002  C CA  . ARG A 1 263 ? 306.438 -47.832 300.911 1.0 89.49908  ? 263 ARG A CA  263 ARG A CA  1 
ATOM 2003  C C   . ARG A 1 263 ? 305.500 -46.841 300.228 1.0 89.49908  ? 263 ARG A C   263 ARG A C   1 
ATOM 2004  O O   . ARG A 1 263 ? 305.881 -45.702 299.936 1.0 89.49908  ? 263 ARG A O   263 ARG A O   1 
ATOM 2005  C CB  . ARG A 1 263 ? 306.732 -47.489 302.378 1.0 89.49908  ? 263 ARG A CB  263 ARG A CB  1 
ATOM 2006  C CG  . ARG A 1 263 ? 307.376 -46.148 302.692 1.0 89.49908  ? 263 ARG A CG  263 ARG A CG  1 
ATOM 2007  C CD  . ARG A 1 263 ? 308.888 -46.227 302.792 1.0 89.49908  ? 263 ARG A CD  263 ARG A CD  1 
ATOM 2008  N NE  . ARG A 1 263 ? 309.469 -44.938 303.160 1.0 89.49908  ? 263 ARG A NE  263 ARG A NE  1 
ATOM 2009  C CZ  . ARG A 1 263 ? 309.760 -44.580 304.405 1.0 89.49908  ? 263 ARG A CZ  263 ARG A CZ  1 
ATOM 2010  N NH1 . ARG A 1 263 ? 309.510 -45.411 305.407 1.0 89.49908  ? 263 ARG A NH1 263 ARG A NH1 1 
ATOM 2011  N NH2 . ARG A 1 263 ? 310.288 -43.387 304.651 1.0 89.49908  ? 263 ARG A NH2 263 ARG A NH2 1 
ATOM 2012  N N   . ALA A 1 264 ? 304.296 -47.313 299.910 1.0 82.31462  ? 264 ALA A N   264 ALA A N   1 
ATOM 2013  C CA  . ALA A 1 264 ? 303.346 -46.572 299.094 1.0 82.31462  ? 264 ALA A CA  264 ALA A CA  1 
ATOM 2014  C C   . ALA A 1 264 ? 301.961 -47.185 299.211 1.0 82.31462  ? 264 ALA A C   264 ALA A C   1 
ATOM 2015  O O   . ALA A 1 264 ? 301.826 -48.374 299.515 1.0 82.31462  ? 264 ALA A O   264 ALA A O   1 
ATOM 2016  C CB  . ALA A 1 264 ? 303.782 -46.564 297.627 1.0 82.31462  ? 264 ALA A CB  264 ALA A CB  1 
ATOM 2017  N N   . THR A 1 265 ? 300.928 -46.387 298.985 1.0 78.12892  ? 265 THR A N   265 THR A N   1 
ATOM 2018  C CA  . THR A 1 265 ? 299.590 -46.926 298.828 1.0 78.12892  ? 265 THR A CA  265 THR A CA  1 
ATOM 2019  C C   . THR A 1 265 ? 299.112 -46.720 297.400 1.0 78.12892  ? 265 THR A C   265 THR A C   1 
ATOM 2020  O O   . THR A 1 265 ? 299.634 -45.888 296.657 1.0 78.12892  ? 265 THR A O   265 THR A O   1 
ATOM 2021  C CB  . THR A 1 265 ? 298.606 -46.273 299.793 1.0 78.12892  ? 265 THR A CB  265 THR A CB  1 
ATOM 2022  O OG1 . THR A 1 265 ? 298.572 -44.863 299.555 1.0 78.12892  ? 265 THR A OG1 265 THR A OG1 1 
ATOM 2023  C CG2 . THR A 1 265 ? 299.003 -46.550 301.228 1.0 78.12892  ? 265 THR A CG2 265 THR A CG2 1 
ATOM 2024  N N   . ALA A 1 266 ? 298.100 -47.491 297.025 1.0 72.2483   ? 266 ALA A N   266 ALA A N   1 
ATOM 2025  C CA  . ALA A 1 266 ? 297.531 -47.429 295.689 1.0 72.2483   ? 266 ALA A CA  266 ALA A CA  1 
ATOM 2026  C C   . ALA A 1 266 ? 296.021 -47.365 295.807 1.0 72.2483   ? 266 ALA A C   266 ALA A C   1 
ATOM 2027  O O   . ALA A 1 266 ? 295.396 -48.316 296.279 1.0 72.2483   ? 266 ALA A O   266 ALA A O   1 
ATOM 2028  C CB  . ALA A 1 266 ? 297.948 -48.638 294.854 1.0 72.2483   ? 266 ALA A CB  266 ALA A CB  1 
ATOM 2029  N N   . ALA A 1 267 ? 295.442 -46.246 295.401 1.0 69.7954   ? 267 ALA A N   267 ALA A N   1 
ATOM 2030  C CA  . ALA A 1 267 ? 294.003 -46.162 295.246 1.0 69.7954   ? 267 ALA A CA  267 ALA A CA  1 
ATOM 2031  C C   . ALA A 1 267 ? 293.635 -46.545 293.824 1.0 69.7954   ? 267 ALA A C   267 ALA A C   1 
ATOM 2032  O O   . ALA A 1 267 ? 294.388 -46.287 292.883 1.0 69.7954   ? 267 ALA A O   267 ALA A O   1 
ATOM 2033  C CB  . ALA A 1 267 ? 293.497 -44.755 295.558 1.0 69.7954   ? 267 ALA A CB  267 ALA A CB  1 
ATOM 2034  N N   . GLY A 1 268 ? 292.472 -47.177 293.676 1.0 67.10087  ? 268 GLY A N   268 GLY A N   1 
ATOM 2035  C CA  . GLY A 1 268 ? 291.997 -47.548 292.361 1.0 67.10087  ? 268 GLY A CA  268 GLY A CA  1 
ATOM 2036  C C   . GLY A 1 268 ? 291.659 -46.341 291.511 1.0 67.10087  ? 268 GLY A C   268 GLY A C   1 
ATOM 2037  O O   . GLY A 1 268 ? 291.434 -45.239 292.008 1.0 67.10087  ? 268 GLY A O   268 GLY A O   1 
ATOM 2038  N N   . ASN A 1 269 ? 291.642 -46.551 290.198 1.0 65.23299  ? 269 ASN A N   269 ASN A N   1 
ATOM 2039  C CA  . ASN A 1 269 ? 291.374 -45.447 289.294 1.0 65.23299  ? 269 ASN A CA  269 ASN A CA  1 
ATOM 2040  C C   . ASN A 1 269 ? 289.904 -45.046 289.348 1.0 65.23299  ? 269 ASN A C   269 ASN A C   1 
ATOM 2041  O O   . ASN A 1 269 ? 289.038 -45.802 289.794 1.0 65.23299  ? 269 ASN A O   269 ASN A O   1 
ATOM 2042  C CB  . ASN A 1 269 ? 291.766 -45.794 287.858 1.0 65.23299  ? 269 ASN A CB  269 ASN A CB  1 
ATOM 2043  C CG  . ASN A 1 269 ? 293.258 -45.846 287.661 1.0 65.23299  ? 269 ASN A CG  269 ASN A CG  1 
ATOM 2044  O OD1 . ASN A 1 269 ? 293.999 -45.186 288.375 1.0 65.23299  ? 269 ASN A OD1 269 ASN A OD1 1 
ATOM 2045  N ND2 . ASN A 1 269 ? 293.698 -46.534 286.622 1.0 65.23299  ? 269 ASN A ND2 269 ASN A ND2 1 
ATOM 2046  N N   . ARG A 1 270 ? 289.641 -43.825 288.903 1.0 62.71252  ? 270 ARG A N   270 ARG A N   1 
ATOM 2047  C CA  . ARG A 1 270 ? 288.298 -43.273 288.951 1.0 62.71252  ? 270 ARG A CA  270 ARG A CA  1 
ATOM 2048  C C   . ARG A 1 270 ? 287.396 -44.002 287.960 1.0 62.71252  ? 270 ARG A C   270 ARG A C   1 
ATOM 2049  O O   . ARG A 1 270 ? 287.846 -44.370 286.872 1.0 62.71252  ? 270 ARG A O   270 ARG A O   1 
ATOM 2050  C CB  . ARG A 1 270 ? 288.347 -41.787 288.624 1.0 62.71252  ? 270 ARG A CB  270 ARG A CB  1 
ATOM 2051  C CG  . ARG A 1 270 ? 289.105 -40.978 289.649 1.0 62.71252  ? 270 ARG A CG  270 ARG A CG  1 
ATOM 2052  C CD  . ARG A 1 270 ? 289.404 -39.602 289.114 1.0 62.71252  ? 270 ARG A CD  270 ARG A CD  1 
ATOM 2053  N NE  . ARG A 1 270 ? 288.224 -38.788 288.886 1.0 62.71252  ? 270 ARG A NE  270 ARG A NE  1 
ATOM 2054  C CZ  . ARG A 1 270 ? 287.766 -37.886 289.747 1.0 62.71252  ? 270 ARG A CZ  270 ARG A CZ  1 
ATOM 2055  N NH1 . ARG A 1 270 ? 288.398 -37.669 290.886 1.0 62.71252  ? 270 ARG A NH1 270 ARG A NH1 1 
ATOM 2056  N NH2 . ARG A 1 270 ? 286.684 -37.171 289.459 1.0 62.71252  ? 270 ARG A NH2 270 ARG A NH2 1 
ATOM 2057  N N   . PRO A 1 271 ? 286.138 -44.261 288.319 1.0 58.11914  ? 271 PRO A N   271 PRO A N   1 
ATOM 2058  C CA  . PRO A 1 271 ? 285.213 -44.900 287.374 1.0 58.11914  ? 271 PRO A CA  271 PRO A CA  1 
ATOM 2059  C C   . PRO A 1 271 ? 284.897 -43.959 286.222 1.0 58.11914  ? 271 PRO A C   271 PRO A C   1 
ATOM 2060  O O   . PRO A 1 271 ? 284.395 -42.853 286.426 1.0 58.11914  ? 271 PRO A O   271 PRO A O   1 
ATOM 2061  C CB  . PRO A 1 271 ? 283.977 -45.195 288.230 1.0 58.11914  ? 271 PRO A CB  271 PRO A CB  1 
ATOM 2062  C CG  . PRO A 1 271 ? 284.070 -44.264 289.377 1.0 58.11914  ? 271 PRO A CG  271 PRO A CG  1 
ATOM 2063  C CD  . PRO A 1 271 ? 285.525 -44.058 289.641 1.0 58.11914  ? 271 PRO A CD  271 PRO A CD  1 
ATOM 2064  N N   . ASN A 1 272 ? 285.225 -44.396 285.010 1.0 57.34946  ? 272 ASN A N   272 ASN A N   1 
ATOM 2065  C CA  . ASN A 1 272 ? 285.049 -43.593 283.803 1.0 57.34946  ? 272 ASN A CA  272 ASN A CA  1 
ATOM 2066  C C   . ASN A 1 272 ? 284.287 -44.446 282.798 1.0 57.34946  ? 272 ASN A C   272 ASN A C   1 
ATOM 2067  O O   . ASN A 1 272 ? 284.871 -45.315 282.148 1.0 57.34946  ? 272 ASN A O   272 ASN A O   1 
ATOM 2068  C CB  . ASN A 1 272 ? 286.391 -43.145 283.242 1.0 57.34946  ? 272 ASN A CB  272 ASN A CB  1 
ATOM 2069  C CG  . ASN A 1 272 ? 286.253 -42.067 282.194 1.0 57.34946  ? 272 ASN A CG  272 ASN A CG  1 
ATOM 2070  O OD1 . ASN A 1 272 ? 285.154 -41.609 281.904 1.0 57.34946  ? 272 ASN A OD1 272 ASN A OD1 1 
ATOM 2071  N ND2 . ASN A 1 272 ? 287.371 -41.660 281.612 1.0 57.34946  ? 272 ASN A ND2 272 ASN A ND2 1 
ATOM 2072  N N   . TYR A 1 273 ? 282.988 -44.203 282.674 1.0 55.50975  ? 273 TYR A N   273 TYR A N   1 
ATOM 2073  C CA  . TYR A 1 273 ? 282.162 -44.901 281.703 1.0 55.50975  ? 273 TYR A CA  273 TYR A CA  1 
ATOM 2074  C C   . TYR A 1 273 ? 282.131 -44.102 280.411 1.0 55.50975  ? 273 TYR A C   273 TYR A C   1 
ATOM 2075  O O   . TYR A 1 273 ? 281.786 -42.917 280.420 1.0 55.50975  ? 273 TYR A O   273 TYR A O   1 
ATOM 2076  C CB  . TYR A 1 273 ? 280.744 -45.085 282.235 1.0 55.50975  ? 273 TYR A CB  273 TYR A CB  1 
ATOM 2077  C CG  . TYR A 1 273 ? 280.642 -45.988 283.432 1.0 55.50975  ? 273 TYR A CG  273 TYR A CG  1 
ATOM 2078  C CD1 . TYR A 1 273 ? 280.592 -47.362 283.281 1.0 55.50975  ? 273 TYR A CD1 273 TYR A CD1 1 
ATOM 2079  C CD2 . TYR A 1 273 ? 280.594 -45.466 284.713 1.0 55.50975  ? 273 TYR A CD2 273 TYR A CD2 1 
ATOM 2080  C CE1 . TYR A 1 273 ? 280.496 -48.189 284.370 1.0 55.50975  ? 273 TYR A CE1 273 TYR A CE1 1 
ATOM 2081  C CE2 . TYR A 1 273 ? 280.501 -46.288 285.810 1.0 55.50975  ? 273 TYR A CE2 273 TYR A CE2 1 
ATOM 2082  C CZ  . TYR A 1 273 ? 280.453 -47.647 285.631 1.0 55.50975  ? 273 TYR A CZ  273 TYR A CZ  1 
ATOM 2083  O OH  . TYR A 1 273 ? 280.359 -48.475 286.721 1.0 55.50975  ? 273 TYR A OH  273 TYR A OH  1 
ATOM 2084  N N   . ILE A 1 274 ? 282.490 -44.742 279.306 1.0 55.12655  ? 274 ILE A N   274 ILE A N   1 
ATOM 2085  C CA  . ILE A 1 274 ? 282.448 -44.110 277.994 1.0 55.12655  ? 274 ILE A CA  274 ILE A CA  1 
ATOM 2086  C C   . ILE A 1 274 ? 281.484 -44.891 277.119 1.0 55.12655  ? 274 ILE A C   274 ILE A C   1 
ATOM 2087  O O   . ILE A 1 274 ? 281.707 -46.074 276.839 1.0 55.12655  ? 274 ILE A O   274 ILE A O   1 
ATOM 2088  C CB  . ILE A 1 274 ? 283.833 -44.030 277.342 1.0 55.12655  ? 274 ILE A CB  274 ILE A CB  1 
ATOM 2089  C CG1 . ILE A 1 274 ? 284.750 -43.133 278.162 1.0 55.12655  ? 274 ILE A CG1 274 ILE A CG1 1 
ATOM 2090  C CG2 . ILE A 1 274 ? 283.717 -43.495 275.936 1.0 55.12655  ? 274 ILE A CG2 274 ILE A CG2 1 
ATOM 2091  C CD1 . ILE A 1 274 ? 286.177 -43.173 277.707 1.0 55.12655  ? 274 ILE A CD1 274 ILE A CD1 1 
ATOM 2092  N N   . GLY A 1 275 ? 280.415 -44.231 276.690 1.0 52.00673  ? 275 GLY A N   275 GLY A N   1 
ATOM 2093  C CA  . GLY A 1 275 ? 279.463 -44.830 275.779 1.0 52.00673  ? 275 GLY A CA  275 GLY A CA  1 
ATOM 2094  C C   . GLY A 1 275 ? 278.869 -43.781 274.870 1.0 52.00673  ? 275 GLY A C   275 GLY A C   1 
ATOM 2095  O O   . GLY A 1 275 ? 279.314 -42.632 274.888 1.0 52.00673  ? 275 GLY A O   275 GLY A O   1 
ATOM 2096  N N   . PHE A 1 276 ? 277.871 -44.145 274.073 1.0 50.07507  ? 276 PHE A N   276 PHE A N   1 
ATOM 2097  C CA  . PHE A 1 276 ? 277.231 -43.147 273.237 1.0 50.07507  ? 276 PHE A CA  276 PHE A CA  1 
ATOM 2098  C C   . PHE A 1 276 ? 276.319 -42.258 274.076 1.0 50.07507  ? 276 PHE A C   276 PHE A C   1 
ATOM 2099  O O   . PHE A 1 276 ? 276.036 -42.530 275.244 1.0 50.07507  ? 276 PHE A O   276 PHE A O   1 
ATOM 2100  C CB  . PHE A 1 276 ? 276.438 -43.803 272.110 1.0 50.07507  ? 276 PHE A CB  276 PHE A CB  1 
ATOM 2101  C CG  . PHE A 1 276 ? 277.292 -44.503 271.099 1.0 50.07507  ? 276 PHE A CG  276 PHE A CG  1 
ATOM 2102  C CD1 . PHE A 1 276 ? 278.024 -43.781 270.178 1.0 50.07507  ? 276 PHE A CD1 276 PHE A CD1 1 
ATOM 2103  C CD2 . PHE A 1 276 ? 277.342 -45.881 271.049 1.0 50.07507  ? 276 PHE A CD2 276 PHE A CD2 1 
ATOM 2104  C CE1 . PHE A 1 276 ? 278.810 -44.419 269.246 1.0 50.07507  ? 276 PHE A CE1 276 PHE A CE1 1 
ATOM 2105  C CE2 . PHE A 1 276 ? 278.119 -46.521 270.109 1.0 50.07507  ? 276 PHE A CE2 276 PHE A CE2 1 
ATOM 2106  C CZ  . PHE A 1 276 ? 278.855 -45.787 269.212 1.0 50.07507  ? 276 PHE A CZ  276 PHE A CZ  1 
ATOM 2107  N N   . ARG A 1 277 ? 275.859 -41.174 273.461 1.0 51.35061  ? 277 ARG A N   277 ARG A N   1 
ATOM 2108  C CA  . ARG A 1 277 ? 274.972 -40.249 274.140 1.0 51.35061  ? 277 ARG A CA  277 ARG A CA  1 
ATOM 2109  C C   . ARG A 1 277 ? 273.571 -40.837 274.255 1.0 51.35061  ? 277 ARG A C   277 ARG A C   1 
ATOM 2110  O O   . ARG A 1 277 ? 273.256 -41.892 273.699 1.0 51.35061  ? 277 ARG A O   277 ARG A O   1 
ATOM 2111  C CB  . ARG A 1 277 ? 274.910 -38.924 273.390 1.0 51.35061  ? 277 ARG A CB  277 ARG A CB  1 
ATOM 2112  C CG  . ARG A 1 277 ? 276.220 -38.198 273.334 1.0 51.35061  ? 277 ARG A CG  277 ARG A CG  1 
ATOM 2113  C CD  . ARG A 1 277 ? 276.544 -37.587 274.660 1.0 51.35061  ? 277 ARG A CD  277 ARG A CD  1 
ATOM 2114  N NE  . ARG A 1 277 ? 277.863 -36.975 274.648 1.0 51.35061  ? 277 ARG A NE  277 ARG A NE  1 
ATOM 2115  C CZ  . ARG A 1 277 ? 278.086 -35.708 274.338 1.0 51.35061  ? 277 ARG A CZ  277 ARG A CZ  1 
ATOM 2116  N NH1 . ARG A 1 277 ? 277.072 -34.923 274.022 1.0 51.35061  ? 277 ARG A NH1 277 ARG A NH1 1 
ATOM 2117  N NH2 . ARG A 1 277 ? 279.319 -35.228 274.347 1.0 51.35061  ? 277 ARG A NH2 277 ARG A NH2 1 
ATOM 2118  N N   . ASP A 1 278 ? 272.731 -40.142 275.016 1.0 50.97313  ? 278 ASP A N   278 ASP A N   1 
ATOM 2119  C CA  . ASP A 1 278 ? 271.302 -40.404 274.983 1.0 50.97313  ? 278 ASP A CA  278 ASP A CA  1 
ATOM 2120  C C   . ASP A 1 278 ? 270.776 -40.104 273.591 1.0 50.97313  ? 278 ASP A C   278 ASP A C   1 
ATOM 2121  O O   . ASP A 1 278 ? 271.159 -39.107 272.982 1.0 50.97313  ? 278 ASP A O   278 ASP A O   1 
ATOM 2122  C CB  . ASP A 1 278 ? 270.584 -39.526 275.998 1.0 50.97313  ? 278 ASP A CB  278 ASP A CB  1 
ATOM 2123  C CG  . ASP A 1 278 ? 269.127 -39.892 276.162 1.0 50.97313  ? 278 ASP A CG  278 ASP A CG  1 
ATOM 2124  O OD1 . ASP A 1 278 ? 268.677 -40.917 275.610 1.0 50.97313  ? 278 ASP A OD1 278 ASP A OD1 1 
ATOM 2125  O OD2 . ASP A 1 278 ? 268.413 -39.120 276.822 1.0 50.97313  ? 278 ASP A OD2 278 ASP A OD2 1 
ATOM 2126  N N   . ASN A 1 279 ? 269.938 -41.007 273.070 1.0 48.54159  ? 279 ASN A N   279 ASN A N   1 
ATOM 2127  C CA  . ASN A 1 279 ? 269.256 -40.889 271.775 1.0 48.54159  ? 279 ASN A CA  279 ASN A CA  1 
ATOM 2128  C C   . ASN A 1 279 ? 270.210 -40.731 270.592 1.0 48.54159  ? 279 ASN A C   279 ASN A C   1 
ATOM 2129  O O   . ASN A 1 279 ? 269.778 -40.300 269.518 1.0 48.54159  ? 279 ASN A O   279 ASN A O   1 
ATOM 2130  C CB  . ASN A 1 279 ? 268.245 -39.738 271.774 1.0 48.54159  ? 279 ASN A CB  279 ASN A CB  1 
ATOM 2131  C CG  . ASN A 1 279 ? 267.111 -39.964 272.736 1.0 48.54159  ? 279 ASN A CG  279 ASN A CG  1 
ATOM 2132  O OD1 . ASN A 1 279 ? 266.977 -39.256 273.731 1.0 48.54159  ? 279 ASN A OD1 279 ASN A OD1 1 
ATOM 2133  N ND2 . ASN A 1 279 ? 266.275 -40.947 272.441 1.0 48.54159  ? 279 ASN A ND2 279 ASN A ND2 1 
ATOM 2134  N N   . PHE A 1 280 ? 271.479 -41.108 270.777 1.0 47.10006  ? 280 PHE A N   280 PHE A N   1 
ATOM 2135  C CA  . PHE A 1 280 ? 272.580 -40.868 269.839 1.0 47.10006  ? 280 PHE A CA  280 PHE A CA  1 
ATOM 2136  C C   . PHE A 1 280 ? 272.648 -39.405 269.412 1.0 47.10006  ? 280 PHE A C   280 PHE A C   1 
ATOM 2137  O O   . PHE A 1 280 ? 272.733 -39.077 268.228 1.0 47.10006  ? 280 PHE A O   280 PHE A O   1 
ATOM 2138  C CB  . PHE A 1 280 ? 272.495 -41.802 268.635 1.0 47.10006  ? 280 PHE A CB  280 PHE A CB  1 
ATOM 2139  C CG  . PHE A 1 280 ? 272.626 -43.240 268.998 1.0 47.10006  ? 280 PHE A CG  280 PHE A CG  1 
ATOM 2140  C CD1 . PHE A 1 280 ? 273.851 -43.755 269.374 1.0 47.10006  ? 280 PHE A CD1 280 PHE A CD1 1 
ATOM 2141  C CD2 . PHE A 1 280 ? 271.531 -44.078 268.959 1.0 47.10006  ? 280 PHE A CD2 280 PHE A CD2 1 
ATOM 2142  C CE1 . PHE A 1 280 ? 273.977 -45.079 269.720 1.0 47.10006  ? 280 PHE A CE1 280 PHE A CE1 1 
ATOM 2143  C CE2 . PHE A 1 280 ? 271.655 -45.405 269.289 1.0 47.10006  ? 280 PHE A CE2 280 PHE A CE2 1 
ATOM 2144  C CZ  . PHE A 1 280 ? 272.874 -45.901 269.686 1.0 47.10006  ? 280 PHE A CZ  280 PHE A CZ  1 
ATOM 2145  N N   . ILE A 1 281 ? 272.575 -38.518 270.403 1.0 48.61933  ? 281 ILE A N   281 ILE A N   1 
ATOM 2146  C CA  . ILE A 1 281 ? 272.801 -37.099 270.173 1.0 48.61933  ? 281 ILE A CA  281 ILE A CA  1 
ATOM 2147  C C   . ILE A 1 281 ? 274.251 -36.888 269.766 1.0 48.61933  ? 281 ILE A C   281 ILE A C   1 
ATOM 2148  O O   . ILE A 1 281 ? 275.166 -37.470 270.355 1.0 48.61933  ? 281 ILE A O   281 ILE A O   1 
ATOM 2149  C CB  . ILE A 1 281 ? 272.438 -36.291 271.429 1.0 48.61933  ? 281 ILE A CB  281 ILE A CB  1 
ATOM 2150  C CG1 . ILE A 1 281 ? 270.926 -36.245 271.615 1.0 48.61933  ? 281 ILE A CG1 281 ILE A CG1 1 
ATOM 2151  C CG2 . ILE A 1 281 ? 272.986 -34.896 271.376 1.0 48.61933  ? 281 ILE A CG2 281 ILE A CG2 1 
ATOM 2152  C CD1 . ILE A 1 281 ? 270.504 -35.630 272.894 1.0 48.61933  ? 281 ILE A CD1 281 ILE A CD1 1 
ATOM 2153  N N   . GLY A 1 282 ? 274.466 -36.097 268.722 1.0 51.42997  ? 282 GLY A N   282 GLY A N   1 
ATOM 2154  C CA  . GLY A 1 282 ? 275.809 -35.726 268.349 1.0 51.42997  ? 282 GLY A CA  282 GLY A CA  1 
ATOM 2155  C C   . GLY A 1 282 ? 276.502 -36.696 267.430 1.0 51.42997  ? 282 GLY A C   282 GLY A C   1 
ATOM 2156  O O   . GLY A 1 282 ? 277.732 -36.679 267.353 1.0 51.42997  ? 282 GLY A O   282 GLY A O   1 
ATOM 2157  N N   . MET A 1 283 ? 275.760 -37.557 266.749 1.0 50.71614  ? 283 MET A N   283 MET A N   1 
ATOM 2158  C CA  . MET A 1 283 ? 276.324 -38.375 265.691 1.0 50.71614  ? 283 MET A CA  283 MET A CA  1 
ATOM 2159  C C   . MET A 1 283 ? 275.968 -37.839 264.317 1.0 50.71614  ? 283 MET A C   283 MET A C   1 
ATOM 2160  O O   . MET A 1 283 ? 276.718 -38.052 263.358 1.0 50.71614  ? 283 MET A O   283 MET A O   1 
ATOM 2161  C CB  . MET A 1 283 ? 275.831 -39.817 265.840 1.0 50.71614  ? 283 MET A CB  283 MET A CB  1 
ATOM 2162  C CG  . MET A 1 283 ? 276.484 -40.824 264.932 1.0 50.71614  ? 283 MET A CG  283 MET A CG  1 
ATOM 2163  S SD  . MET A 1 283 ? 275.916 -42.459 265.350 1.0 50.71614  ? 283 MET A SD  283 MET A SD  1 
ATOM 2164  C CE  . MET A 1 283 ? 276.722 -42.594 266.933 1.0 50.71614  ? 283 MET A CE  283 MET A CE  1 
ATOM 2165  N N   . MET A 1 284 ? 274.881 -37.089 264.228 1.0 50.90934  ? 284 MET A N   284 MET A N   1 
ATOM 2166  C CA  . MET A 1 284 ? 274.303 -36.651 262.973 1.0 50.90934  ? 284 MET A CA  284 MET A CA  1 
ATOM 2167  C C   . MET A 1 284 ? 274.257 -35.132 262.953 1.0 50.90934  ? 284 MET A C   284 MET A C   1 
ATOM 2168  O O   . MET A 1 284 ? 273.766 -34.513 263.902 1.0 50.90934  ? 284 MET A O   284 MET A O   1 
ATOM 2169  C CB  . MET A 1 284 ? 272.912 -37.255 262.826 1.0 50.90934  ? 284 MET A CB  284 MET A CB  1 
ATOM 2170  C CG  . MET A 1 284 ? 272.943 -38.753 262.605 1.0 50.90934  ? 284 MET A CG  284 MET A CG  1 
ATOM 2171  S SD  . MET A 1 284 ? 271.325 -39.545 262.618 1.0 50.90934  ? 284 MET A SD  284 MET A SD  1 
ATOM 2172  C CE  . MET A 1 284 ? 270.634 -39.004 261.066 1.0 50.90934  ? 284 MET A CE  284 MET A CE  1 
ATOM 2173  N N   . TYR A 1 285 ? 274.766 -34.538 261.878 1.0 51.99167  ? 285 TYR A N   285 TYR A N   1 
ATOM 2174  C CA  . TYR A 1 285 ? 274.895 -33.086 261.782 1.0 51.99167  ? 285 TYR A CA  285 TYR A CA  1 
ATOM 2175  C C   . TYR A 1 285 ? 273.519 -32.463 261.612 1.0 51.99167  ? 285 TYR A C   285 TYR A C   1 
ATOM 2176  O O   . TYR A 1 285 ? 273.024 -32.313 260.493 1.0 51.99167  ? 285 TYR A O   285 TYR A O   1 
ATOM 2177  C CB  . TYR A 1 285 ? 275.786 -32.701 260.609 1.0 51.99167  ? 285 TYR A CB  285 TYR A CB  1 
ATOM 2178  C CG  . TYR A 1 285 ? 277.264 -32.954 260.770 1.0 51.99167  ? 285 TYR A CG  285 TYR A CG  1 
ATOM 2179  C CD1 . TYR A 1 285 ? 278.081 -32.033 261.404 1.0 51.99167  ? 285 TYR A CD1 285 TYR A CD1 1 
ATOM 2180  C CD2 . TYR A 1 285 ? 277.847 -34.091 260.246 1.0 51.99167  ? 285 TYR A CD2 285 TYR A CD2 1 
ATOM 2181  C CE1 . TYR A 1 285 ? 279.438 -32.251 261.528 1.0 51.99167  ? 285 TYR A CE1 285 TYR A CE1 1 
ATOM 2182  C CE2 . TYR A 1 285 ? 279.198 -34.312 260.360 1.0 51.99167  ? 285 TYR A CE2 285 TYR A CE2 1 
ATOM 2183  C CZ  . TYR A 1 285 ? 279.987 -33.393 261.004 1.0 51.99167  ? 285 TYR A CZ  285 TYR A CZ  1 
ATOM 2184  O OH  . TYR A 1 285 ? 281.334 -33.624 261.127 1.0 51.99167  ? 285 TYR A OH  285 TYR A OH  1 
ATOM 2185  N N   . TYR A 1 286 ? 272.900 -32.088 262.723 1.0 50.36089  ? 286 TYR A N   286 TYR A N   1 
ATOM 2186  C CA  . TYR A 1 286 ? 271.700 -31.272 262.712 1.0 50.36089  ? 286 TYR A CA  286 TYR A CA  1 
ATOM 2187  C C   . TYR A 1 286 ? 272.088 -29.829 262.984 1.0 50.36089  ? 286 TYR A C   286 TYR A C   1 
ATOM 2188  O O   . TYR A 1 286 ? 272.922 -29.562 263.854 1.0 50.36089  ? 286 TYR A O   286 TYR A O   1 
ATOM 2189  C CB  . TYR A 1 286 ? 270.692 -31.739 263.760 1.0 50.36089  ? 286 TYR A CB  286 TYR A CB  1 
ATOM 2190  C CG  . TYR A 1 286 ? 270.056 -33.072 263.463 1.0 50.36089  ? 286 TYR A CG  286 TYR A CG  1 
ATOM 2191  C CD1 . TYR A 1 286 ? 268.982 -33.173 262.600 1.0 50.36089  ? 286 TYR A CD1 286 TYR A CD1 1 
ATOM 2192  C CD2 . TYR A 1 286 ? 270.532 -34.225 264.049 1.0 50.36089  ? 286 TYR A CD2 286 TYR A CD2 1 
ATOM 2193  C CE1 . TYR A 1 286 ? 268.399 -34.397 262.338 1.0 50.36089  ? 286 TYR A CE1 286 TYR A CE1 1 
ATOM 2194  C CE2 . TYR A 1 286 ? 269.958 -35.443 263.800 1.0 50.36089  ? 286 TYR A CE2 286 TYR A CE2 1 
ATOM 2195  C CZ  . TYR A 1 286 ? 268.899 -35.525 262.940 1.0 50.36089  ? 286 TYR A CZ  286 TYR A CZ  1 
ATOM 2196  O OH  . TYR A 1 286 ? 268.336 -36.748 262.688 1.0 50.36089  ? 286 TYR A OH  286 TYR A OH  1 
ATOM 2197  N N   . ASN A 1 287 ? 271.487 -28.919 262.210 1.0 53.98353  ? 287 ASN A N   287 ASN A N   1 
ATOM 2198  C CA  . ASN A 1 287 ? 271.629 -27.466 262.356 1.0 53.98353  ? 287 ASN A CA  287 ASN A CA  1 
ATOM 2199  C C   . ASN A 1 287 ? 273.082 -27.020 262.218 1.0 53.98353  ? 287 ASN A C   287 ASN A C   1 
ATOM 2200  O O   . ASN A 1 287 ? 273.677 -26.457 263.138 1.0 53.98353  ? 287 ASN A O   287 ASN A O   1 
ATOM 2201  C CB  . ASN A 1 287 ? 271.022 -26.985 263.670 1.0 53.98353  ? 287 ASN A CB  287 ASN A CB  1 
ATOM 2202  C CG  . ASN A 1 287 ? 269.567 -27.345 263.787 1.0 53.98353  ? 287 ASN A CG  287 ASN A CG  1 
ATOM 2203  O OD1 . ASN A 1 287 ? 269.174 -28.088 264.680 1.0 53.98353  ? 287 ASN A OD1 287 ASN A OD1 1 
ATOM 2204  N ND2 . ASN A 1 287 ? 268.758 -26.845 262.863 1.0 53.98353  ? 287 ASN A ND2 287 ASN A ND2 1 
ATOM 2205  N N   . SER A 1 288 ? 273.656 -27.291 261.052 1.0 61.59848  ? 288 SER A N   288 SER A N   1 
ATOM 2206  C CA  . SER A 1 288 ? 274.982 -26.810 260.697 1.0 61.59848  ? 288 SER A CA  288 SER A CA  1 
ATOM 2207  C C   . SER A 1 288 ? 274.943 -26.328 259.260 1.0 61.59848  ? 288 SER A C   288 SER A C   1 
ATOM 2208  O O   . SER A 1 288 ? 274.398 -27.014 258.390 1.0 61.59848  ? 288 SER A O   288 SER A O   1 
ATOM 2209  C CB  . SER A 1 288 ? 276.041 -27.901 260.859 1.0 61.59848  ? 288 SER A CB  288 SER A CB  1 
ATOM 2210  O OG  . SER A 1 288 ? 276.165 -28.288 262.213 1.0 61.59848  ? 288 SER A OG  288 SER A OG  1 
ATOM 2211  N N   . GLY A 1 289 ? 275.508 -25.146 259.013 1.0 62.18943  ? 289 GLY A N   289 GLY A N   1 
ATOM 2212  C CA  . GLY A 1 289 ? 275.607 -24.663 257.649 1.0 62.18943  ? 289 GLY A CA  289 GLY A CA  1 
ATOM 2213  C C   . GLY A 1 289 ? 276.642 -25.412 256.838 1.0 62.18943  ? 289 GLY A C   289 GLY A C   1 
ATOM 2214  O O   . GLY A 1 289 ? 276.555 -25.461 255.608 1.0 62.18943  ? 289 GLY A O   289 GLY A O   1 
ATOM 2215  N N   . SER A 1 290 ? 277.627 -26.007 257.512 1.0 63.35715  ? 290 SER A N   290 SER A N   1 
ATOM 2216  C CA  . SER A 1 290 ? 278.665 -26.761 256.821 1.0 63.35715  ? 290 SER A CA  290 SER A CA  1 
ATOM 2217  C C   . SER A 1 290 ? 278.118 -28.060 256.255 1.0 63.35715  ? 290 SER A C   290 SER A C   1 
ATOM 2218  O O   . SER A 1 290 ? 278.429 -28.434 255.119 1.0 63.35715  ? 290 SER A O   290 SER A O   1 
ATOM 2219  C CB  . SER A 1 290 ? 279.808 -27.076 257.784 1.0 63.35715  ? 290 SER A CB  290 SER A CB  1 
ATOM 2220  O OG  . SER A 1 290 ? 280.363 -25.907 258.355 1.0 63.35715  ? 290 SER A OG  290 SER A OG  1 
ATOM 2221  N N   . ASN A 1 291 ? 277.306 -28.763 257.041 1.0 59.50338  ? 291 ASN A N   291 ASN A N   1 
ATOM 2222  C CA  . ASN A 1 291 ? 277.020 -30.180 256.838 1.0 59.50338  ? 291 ASN A CA  291 ASN A CA  1 
ATOM 2223  C C   . ASN A 1 291 ? 275.514 -30.405 256.898 1.0 59.50338  ? 291 ASN A C   291 ASN A C   1 
ATOM 2224  O O   . ASN A 1 291 ? 274.967 -30.714 257.959 1.0 59.50338  ? 291 ASN A O   291 ASN A O   1 
ATOM 2225  C CB  . ASN A 1 291 ? 277.747 -30.994 257.886 1.0 59.50338  ? 291 ASN A CB  291 ASN A CB  1 
ATOM 2226  C CG  . ASN A 1 291 ? 279.239 -30.790 257.839 1.0 59.50338  ? 291 ASN A CG  291 ASN A CG  1 
ATOM 2227  O OD1 . ASN A 1 291 ? 279.844 -30.339 258.809 1.0 59.50338  ? 291 ASN A OD1 291 ASN A OD1 1 
ATOM 2228  N ND2 . ASN A 1 291 ? 279.839 -31.083 256.696 1.0 59.50338  ? 291 ASN A ND2 291 ASN A ND2 1 
ATOM 2229  N N   . THR A 1 292 ? 274.849 -30.275 255.757 1.0 57.72644  ? 292 THR A N   292 THR A N   1 
ATOM 2230  C CA  . THR A 1 292 ? 273.398 -30.352 255.682 1.0 57.72644  ? 292 THR A CA  292 THR A CA  1 
ATOM 2231  C C   . THR A 1 292 ? 272.995 -31.545 254.830 1.0 57.72644  ? 292 THR A C   292 THR A C   1 
ATOM 2232  O O   . THR A 1 292 ? 273.463 -31.690 253.697 1.0 57.72644  ? 292 THR A O   292 THR A O   1 
ATOM 2233  C CB  . THR A 1 292 ? 272.822 -29.060 255.098 1.0 57.72644  ? 292 THR A CB  292 THR A CB  1 
ATOM 2234  O OG1 . THR A 1 292 ? 273.224 -27.952 255.911 1.0 57.72644  ? 292 THR A OG1 292 THR A OG1 1 
ATOM 2235  C CG2 . THR A 1 292 ? 271.308 -29.115 255.054 1.0 57.72644  ? 292 THR A CG2 292 THR A CG2 1 
ATOM 2236  N N   . GLY A 1 293 ? 272.130 -32.394 255.374 1.0 50.46183  ? 293 GLY A N   293 GLY A N   1 
ATOM 2237  C CA  . GLY A 1 293 ? 271.587 -33.504 254.624 1.0 50.46183  ? 293 GLY A CA  293 GLY A CA  1 
ATOM 2238  C C   . GLY A 1 293 ? 270.557 -33.047 253.613 1.0 50.46183  ? 293 GLY A C   293 GLY A C   1 
ATOM 2239  O O   . GLY A 1 293 ? 270.227 -31.868 253.491 1.0 50.46183  ? 293 GLY A O   293 GLY A O   1 
ATOM 2240  N N   . SER A 1 294 ? 270.021 -34.012 252.875 1.0 45.56087  ? 294 SER A N   294 SER A N   1 
ATOM 2241  C CA  . SER A 1 294 ? 269.172 -33.671 251.740 1.0 45.56087  ? 294 SER A CA  294 SER A CA  1 
ATOM 2242  C C   . SER A 1 294 ? 268.217 -34.810 251.435 1.0 45.56087  ? 294 SER A C   294 SER A C   1 
ATOM 2243  O O   . SER A 1 294 ? 268.655 -35.883 251.018 1.0 45.56087  ? 294 SER A O   294 SER A O   1 
ATOM 2244  C CB  . SER A 1 294 ? 270.022 -33.353 250.518 1.0 45.56087  ? 294 SER A CB  294 SER A CB  1 
ATOM 2245  O OG  . SER A 1 294 ? 269.204 -33.171 249.379 1.0 45.56087  ? 294 SER A OG  294 SER A OG  1 
ATOM 2246  N N   . PHE A 1 295 ? 266.924 -34.573 251.613 1.0 41.22488  ? 295 PHE A N   295 PHE A N   1 
ATOM 2247  C CA  . PHE A 1 295 ? 265.898 -35.441 251.053 1.0 41.22488  ? 295 PHE A CA  295 PHE A CA  1 
ATOM 2248  C C   . PHE A 1 295 ? 265.299 -34.735 249.847 1.0 41.22488  ? 295 PHE A C   295 PHE A C   1 
ATOM 2249  O O   . PHE A 1 295 ? 264.768 -33.628 249.973 1.0 41.22488  ? 295 PHE A O   295 PHE A O   1 
ATOM 2250  C CB  . PHE A 1 295 ? 264.817 -35.782 252.074 1.0 41.22488  ? 295 PHE A CB  295 PHE A CB  1 
ATOM 2251  C CG  . PHE A 1 295 ? 263.776 -36.725 251.552 1.0 41.22488  ? 295 PHE A CG  295 PHE A CG  1 
ATOM 2252  C CD1 . PHE A 1 295 ? 264.047 -38.069 251.405 1.0 41.22488  ? 295 PHE A CD1 295 PHE A CD1 1 
ATOM 2253  C CD2 . PHE A 1 295 ? 262.530 -36.263 251.190 1.0 41.22488  ? 295 PHE A CD2 295 PHE A CD2 1 
ATOM 2254  C CE1 . PHE A 1 295 ? 263.095 -38.937 250.921 1.0 41.22488  ? 295 PHE A CE1 295 PHE A CE1 1 
ATOM 2255  C CE2 . PHE A 1 295 ? 261.571 -37.122 250.704 1.0 41.22488  ? 295 PHE A CE2 295 PHE A CE2 1 
ATOM 2256  C CZ  . PHE A 1 295 ? 261.855 -38.463 250.568 1.0 41.22488  ? 295 PHE A CZ  295 PHE A CZ  1 
ATOM 2257  N N   . SER A 1 296 ? 265.389 -35.365 248.681 1.0 41.42926  ? 296 SER A N   296 SER A N   1 
ATOM 2258  C CA  . SER A 1 296 ? 264.972 -34.713 247.452 1.0 41.42926  ? 296 SER A CA  296 SER A CA  1 
ATOM 2259  C C   . SER A 1 296 ? 264.428 -35.752 246.488 1.0 41.42926  ? 296 SER A C   296 SER A C   1 
ATOM 2260  O O   . SER A 1 296 ? 264.725 -36.944 246.589 1.0 41.42926  ? 296 SER A O   296 SER A O   1 
ATOM 2261  C CB  . SER A 1 296 ? 266.130 -33.952 246.813 1.0 41.42926  ? 296 SER A CB  296 SER A CB  1 
ATOM 2262  O OG  . SER A 1 296 ? 267.122 -34.853 246.366 1.0 41.42926  ? 296 SER A OG  296 SER A OG  1 
ATOM 2263  N N   . SER A 1 297 ? 263.631 -35.280 245.538 1.0 42.86285  ? 297 SER A N   297 SER A N   1 
ATOM 2264  C CA  . SER A 1 297 ? 263.063 -36.143 244.514 1.0 42.86285  ? 297 SER A CA  297 SER A CA  1 
ATOM 2265  C C   . SER A 1 297 ? 263.965 -36.198 243.292 1.0 42.86285  ? 297 SER A C   297 SER A C   1 
ATOM 2266  O O   . SER A 1 297 ? 265.137 -35.820 243.361 1.0 42.86285  ? 297 SER A O   297 SER A O   1 
ATOM 2267  C CB  . SER A 1 297 ? 261.677 -35.653 244.115 1.0 42.86285  ? 297 SER A CB  297 SER A CB  1 
ATOM 2268  O OG  . SER A 1 297 ? 261.768 -34.388 243.491 1.0 42.86285  ? 297 SER A OG  297 SER A OG  1 
ATOM 2269  N N   . GLN A 1 298 ? 263.434 -36.699 242.179 1.0 45.58629  ? 298 GLN A N   298 GLN A N   1 
ATOM 2270  C CA  . GLN A 1 298 ? 264.132 -36.653 240.904 1.0 45.58629  ? 298 GLN A CA  298 GLN A CA  1 
ATOM 2271  C C   . GLN A 1 298 ? 263.795 -35.413 240.086 1.0 45.58629  ? 298 GLN A C   298 GLN A C   1 
ATOM 2272  O O   . GLN A 1 298 ? 264.280 -35.278 238.958 1.0 45.58629  ? 298 GLN A O   298 GLN A O   1 
ATOM 2273  C CB  . GLN A 1 298 ? 263.848 -37.921 240.094 1.0 45.58629  ? 298 GLN A CB  298 GLN A CB  1 
ATOM 2274  C CG  . GLN A 1 298 ? 264.405 -39.160 240.767 1.0 45.58629  ? 298 GLN A CG  298 GLN A CG  1 
ATOM 2275  C CD  . GLN A 1 298 ? 265.915 -39.138 240.859 1.0 45.58629  ? 298 GLN A CD  298 GLN A CD  1 
ATOM 2276  O OE1 . GLN A 1 298 ? 266.596 -38.771 239.908 1.0 45.58629  ? 298 GLN A OE1 298 GLN A OE1 1 
ATOM 2277  N NE2 . GLN A 1 298 ? 266.445 -39.518 242.012 1.0 45.58629  ? 298 GLN A NE2 298 GLN A NE2 1 
ATOM 2278  N N   . THR A 1 299 ? 262.957 -34.524 240.611 1.0 45.70577  ? 299 THR A N   299 THR A N   1 
ATOM 2279  C CA  . THR A 1 299 ? 263.057 -33.100 240.313 1.0 45.70577  ? 299 THR A CA  299 THR A CA  1 
ATOM 2280  C C   . THR A 1 299 ? 264.162 -32.619 241.237 1.0 45.70577  ? 299 THR A C   299 THR A C   1 
ATOM 2281  O O   . THR A 1 299 ? 263.908 -32.271 242.392 1.0 45.70577  ? 299 THR A O   299 THR A O   1 
ATOM 2282  C CB  . THR A 1 299 ? 261.740 -32.380 240.564 1.0 45.70577  ? 299 THR A CB  299 THR A CB  1 
ATOM 2283  O OG1 . THR A 1 299 ? 261.386 -32.508 241.944 1.0 45.70577  ? 299 THR A OG1 299 THR A OG1 1 
ATOM 2284  C CG2 . THR A 1 299 ? 260.645 -32.987 239.715 1.0 45.70577  ? 299 THR A CG2 299 THR A CG2 1 
ATOM 2285  N N   . GLN A 1 300 ? 265.391 -32.618 240.710 1.0 48.60827  ? 300 GLN A N   300 GLN A N   1 
ATOM 2286  C CA  . GLN A 1 300 ? 266.598 -32.770 241.522 1.0 48.60827  ? 300 GLN A CA  300 GLN A CA  1 
ATOM 2287  C C   . GLN A 1 300 ? 266.805 -31.608 242.472 1.0 48.60827  ? 300 GLN A C   300 GLN A C   1 
ATOM 2288  O O   . GLN A 1 300 ? 267.302 -31.784 243.589 1.0 48.60827  ? 300 GLN A O   300 GLN A O   1 
ATOM 2289  C CB  . GLN A 1 300 ? 267.809 -32.890 240.607 1.0 48.60827  ? 300 GLN A CB  300 GLN A CB  1 
ATOM 2290  C CG  . GLN A 1 300 ? 267.854 -34.157 239.820 1.0 48.60827  ? 300 GLN A CG  300 GLN A CG  1 
ATOM 2291  C CD  . GLN A 1 300 ? 268.182 -35.337 240.690 1.0 48.60827  ? 300 GLN A CD  300 GLN A CD  1 
ATOM 2292  O OE1 . GLN A 1 300 ? 267.360 -36.222 240.894 1.0 48.60827  ? 300 GLN A OE1 300 GLN A OE1 1 
ATOM 2293  N NE2 . GLN A 1 300 ? 269.391 -35.349 241.228 1.0 48.60827  ? 300 GLN A NE2 300 GLN A NE2 1 
ATOM 2294  N N   . GLN A 1 301 ? 266.404 -30.418 242.052 1.0 54.49182  ? 301 GLN A N   301 GLN A N   1 
ATOM 2295  C CA  . GLN A 1 301 ? 266.839 -29.213 242.737 1.0 54.49182  ? 301 GLN A CA  301 GLN A CA  1 
ATOM 2296  C C   . GLN A 1 301 ? 266.032 -28.982 244.007 1.0 54.49182  ? 301 GLN A C   301 GLN A C   1 
ATOM 2297  O O   . GLN A 1 301 ? 266.482 -28.287 244.926 1.0 54.49182  ? 301 GLN A O   301 GLN A O   1 
ATOM 2298  C CB  . GLN A 1 301 ? 266.699 -28.039 241.781 1.0 54.49182  ? 301 GLN A CB  301 GLN A CB  1 
ATOM 2299  C CG  . GLN A 1 301 ? 267.351 -26.768 242.194 1.0 54.49182  ? 301 GLN A CG  301 GLN A CG  1 
ATOM 2300  C CD  . GLN A 1 301 ? 267.068 -25.683 241.195 1.0 54.49182  ? 301 GLN A CD  301 GLN A CD  1 
ATOM 2301  O OE1 . GLN A 1 301 ? 266.373 -25.915 240.206 1.0 54.49182  ? 301 GLN A OE1 301 GLN A OE1 1 
ATOM 2302  N NE2 . GLN A 1 301 ? 267.586 -24.487 241.444 1.0 54.49182  ? 301 GLN A NE2 301 GLN A NE2 1 
ATOM 2303  N N   . LEU A 1 302 ? 264.843 -29.567 244.078 1.0 48.44773  ? 302 LEU A N   302 LEU A N   1 
ATOM 2304  C CA  . LEU A 1 302 ? 263.975 -29.341 245.219 1.0 48.44773  ? 302 LEU A CA  302 LEU A CA  1 
ATOM 2305  C C   . LEU A 1 302 ? 264.485 -30.103 246.433 1.0 48.44773  ? 302 LEU A C   302 LEU A C   1 
ATOM 2306  O O   . LEU A 1 302 ? 264.215 -31.294 246.600 1.0 48.44773  ? 302 LEU A O   302 LEU A O   1 
ATOM 2307  C CB  . LEU A 1 302 ? 262.551 -29.753 244.864 1.0 48.44773  ? 302 LEU A CB  302 LEU A CB  1 
ATOM 2308  C CG  . LEU A 1 302 ? 261.979 -28.847 243.769 1.0 48.44773  ? 302 LEU A CG  302 LEU A CG  1 
ATOM 2309  C CD1 . LEU A 1 302 ? 260.674 -29.382 243.208 1.0 48.44773  ? 302 LEU A CD1 302 LEU A CD1 1 
ATOM 2310  C CD2 . LEU A 1 302 ? 261.786 -27.431 244.296 1.0 48.44773  ? 302 LEU A CD2 302 LEU A CD2 1 
ATOM 2311  N N   . ASN A 1 303 ? 265.240 -29.399 247.272 1.0 45.25912  ? 303 ASN A N   303 ASN A N   1 
ATOM 2312  C CA  . ASN A 1 303 ? 265.815 -29.940 248.502 1.0 45.25912  ? 303 ASN A CA  303 ASN A CA  1 
ATOM 2313  C C   . ASN A 1 303 ? 264.893 -29.495 249.630 1.0 45.25912  ? 303 ASN A C   303 ASN A C   1 
ATOM 2314  O O   . ASN A 1 303 ? 264.839 -28.307 249.958 1.0 45.25912  ? 303 ASN A O   303 ASN A O   1 
ATOM 2315  C CB  . ASN A 1 303 ? 267.233 -29.426 248.709 1.0 45.25912  ? 303 ASN A CB  303 ASN A CB  1 
ATOM 2316  C CG  . ASN A 1 303 ? 268.041 -30.278 249.661 1.0 45.25912  ? 303 ASN A CG  303 ASN A CG  1 
ATOM 2317  O OD1 . ASN A 1 303 ? 269.258 -30.138 249.743 1.0 45.25912  ? 303 ASN A OD1 303 ASN A OD1 1 
ATOM 2318  N ND2 . ASN A 1 303 ? 267.380 -31.176 250.370 1.0 45.25912  ? 303 ASN A ND2 303 ASN A ND2 1 
ATOM 2319  N N   . ILE A 1 304 ? 264.178 -30.446 250.231 1.0 41.20191  ? 304 ILE A N   304 ILE A N   1 
ATOM 2320  C CA  . ILE A 1 304 ? 263.167 -30.061 251.204 1.0 41.20191  ? 304 ILE A CA  304 ILE A CA  1 
ATOM 2321  C C   . ILE A 1 304 ? 263.701 -29.986 252.622 1.0 41.20191  ? 304 ILE A C   304 ILE A C   1 
ATOM 2322  O O   . ILE A 1 304 ? 262.941 -29.660 253.536 1.0 41.20191  ? 304 ILE A O   304 ILE A O   1 
ATOM 2323  C CB  . ILE A 1 304 ? 261.958 -31.011 251.175 1.0 41.20191  ? 304 ILE A CB  304 ILE A CB  1 
ATOM 2324  C CG1 . ILE A 1 304 ? 262.296 -32.365 251.770 1.0 41.20191  ? 304 ILE A CG1 304 ILE A CG1 1 
ATOM 2325  C CG2 . ILE A 1 304 ? 261.475 -31.195 249.759 1.0 41.20191  ? 304 ILE A CG2 304 ILE A CG2 1 
ATOM 2326  C CD1 . ILE A 1 304 ? 261.065 -33.152 252.085 1.0 41.20191  ? 304 ILE A CD1 304 ILE A CD1 1 
ATOM 2327  N N   . VAL A 1 305 ? 264.982 -30.270 252.839 1.0 45.28623  ? 305 VAL A N   305 VAL A N   1 
ATOM 2328  C CA  . VAL A 1 305 ? 265.581 -30.119 254.164 1.0 45.28623  ? 305 VAL A CA  305 VAL A CA  1 
ATOM 2329  C C   . VAL A 1 305 ? 266.422 -28.848 254.106 1.0 45.28623  ? 305 VAL A C   305 VAL A C   1 
ATOM 2330  O O   . VAL A 1 305 ? 267.578 -28.852 253.681 1.0 45.28623  ? 305 VAL A O   305 VAL A O   1 
ATOM 2331  C CB  . VAL A 1 305 ? 266.388 -31.346 254.575 1.0 45.28623  ? 305 VAL A CB  305 VAL A CB  1 
ATOM 2332  C CG1 . VAL A 1 305 ? 267.007 -31.141 255.943 1.0 45.28623  ? 305 VAL A CG1 305 VAL A CG1 1 
ATOM 2333  C CG2 . VAL A 1 305 ? 265.498 -32.568 254.587 1.0 45.28623  ? 305 VAL A CG2 305 VAL A CG2 1 
ATOM 2334  N N   . LEU A 1 306 ? 265.814 -27.737 254.511 1.0 50.13365  ? 306 LEU A N   306 LEU A N   1 
ATOM 2335  C CA  . LEU A 1 306 ? 266.503 -26.463 254.654 1.0 50.13365  ? 306 LEU A CA  306 LEU A CA  1 
ATOM 2336  C C   . LEU A 1 306 ? 266.815 -26.261 256.127 1.0 50.13365  ? 306 LEU A C   306 LEU A C   1 
ATOM 2337  O O   . LEU A 1 306 ? 265.902 -26.170 256.951 1.0 50.13365  ? 306 LEU A O   306 LEU A O   1 
ATOM 2338  C CB  . LEU A 1 306 ? 265.658 -25.309 254.122 1.0 50.13365  ? 306 LEU A CB  306 LEU A CB  1 
ATOM 2339  C CG  . LEU A 1 306 ? 266.324 -23.936 254.192 1.0 50.13365  ? 306 LEU A CG  306 LEU A CG  1 
ATOM 2340  C CD1 . LEU A 1 306 ? 267.583 -23.899 253.334 1.0 50.13365  ? 306 LEU A CD1 306 LEU A CD1 1 
ATOM 2341  C CD2 . LEU A 1 306 ? 265.350 -22.872 253.752 1.0 50.13365  ? 306 LEU A CD2 306 LEU A CD2 1 
ATOM 2342  N N   . ASP A 1 307 ? 268.097 -26.181 256.452 1.0 57.16637  ? 307 ASP A N   307 ASP A N   1 
ATOM 2343  C CA  . ASP A 1 307 ? 268.558 -26.305 257.824 1.0 57.16637  ? 307 ASP A CA  307 ASP A CA  1 
ATOM 2344  C C   . ASP A 1 307 ? 269.030 -24.943 258.315 1.0 57.16637  ? 307 ASP A C   307 ASP A C   1 
ATOM 2345  O O   . ASP A 1 307 ? 269.867 -24.302 257.670 1.0 57.16637  ? 307 ASP A O   307 ASP A O   1 
ATOM 2346  C CB  . ASP A 1 307 ? 269.677 -27.340 257.904 1.0 57.16637  ? 307 ASP A CB  307 ASP A CB  1 
ATOM 2347  C CG  . ASP A 1 307 ? 269.833 -27.920 259.283 1.0 57.16637  ? 307 ASP A CG  307 ASP A CG  1 
ATOM 2348  O OD1 . ASP A 1 307 ? 269.071 -27.508 260.184 1.0 57.16637  ? 307 ASP A OD1 307 ASP A OD1 1 
ATOM 2349  O OD2 . ASP A 1 307 ? 270.704 -28.799 259.460 1.0 57.16637  ? 307 ASP A OD2 307 ASP A OD2 1 
ATOM 2350  N N   . LEU A 1 308 ? 268.489 -24.502 259.445 1.0 55.38732  ? 308 LEU A N   308 LEU A N   1 
ATOM 2351  C CA  . LEU A 1 308 ? 268.824 -23.213 260.031 1.0 55.38732  ? 308 LEU A CA  308 LEU A CA  1 
ATOM 2352  C C   . LEU A 1 308 ? 269.739 -23.406 261.232 1.0 55.38732  ? 308 LEU A C   308 LEU A C   1 
ATOM 2353  O O   . LEU A 1 308 ? 269.849 -24.499 261.788 1.0 55.38732  ? 308 LEU A O   308 LEU A O   1 
ATOM 2354  C CB  . LEU A 1 308 ? 267.565 -22.452 260.458 1.0 55.38732  ? 308 LEU A CB  308 LEU A CB  1 
ATOM 2355  C CG  . LEU A 1 308 ? 266.733 -21.681 259.428 1.0 55.38732  ? 308 LEU A CG  308 LEU A CG  1 
ATOM 2356  C CD1 . LEU A 1 308 ? 265.894 -22.593 258.547 1.0 55.38732  ? 308 LEU A CD1 308 LEU A CD1 1 
ATOM 2357  C CD2 . LEU A 1 308 ? 265.851 -20.667 260.132 1.0 55.38732  ? 308 LEU A CD2 308 LEU A CD2 1 
ATOM 2358  N N   . ASN A 1 309 ? 270.399 -22.320 261.630 1.0 55.93984  ? 309 ASN A N   309 ASN A N   1 
ATOM 2359  C CA  . ASN A 1 309 ? 271.289 -22.352 262.782 1.0 55.93984  ? 309 ASN A CA  309 ASN A CA  1 
ATOM 2360  C C   . ASN A 1 309 ? 270.609 -21.930 264.073 1.0 55.93984  ? 309 ASN A C   309 ASN A C   1 
ATOM 2361  O O   . ASN A 1 309 ? 271.097 -22.275 265.154 1.0 55.93984  ? 309 ASN A O   309 ASN A O   1 
ATOM 2362  C CB  . ASN A 1 309 ? 272.501 -21.453 262.540 1.0 55.93984  ? 309 ASN A CB  309 ASN A CB  1 
ATOM 2363  C CG  . ASN A 1 309 ? 273.342 -21.923 261.383 1.0 55.93984  ? 309 ASN A CG  309 ASN A CG  1 
ATOM 2364  O OD1 . ASN A 1 309 ? 273.456 -21.240 260.367 1.0 55.93984  ? 309 ASN A OD1 309 ASN A OD1 1 
ATOM 2365  N ND2 . ASN A 1 309 ? 273.930 -23.103 261.523 1.0 55.93984  ? 309 ASN A ND2 309 ASN A ND2 1 
ATOM 2366  N N   . ASP A 1 310 ? 269.499 -21.199 263.989 1.0 54.72259  ? 310 ASP A N   310 ASP A N   1 
ATOM 2367  C CA  . ASP A 1 310 ? 268.744 -20.798 265.167 1.0 54.72259  ? 310 ASP A CA  310 ASP A CA  1 
ATOM 2368  C C   . ASP A 1 310 ? 267.880 -21.915 265.725 1.0 54.72259  ? 310 ASP A C   310 ASP A C   1 
ATOM 2369  O O   . ASP A 1 310 ? 267.250 -21.727 266.768 1.0 54.72259  ? 310 ASP A O   310 ASP A O   1 
ATOM 2370  C CB  . ASP A 1 310 ? 267.852 -19.607 264.834 1.0 54.72259  ? 310 ASP A CB  310 ASP A CB  1 
ATOM 2371  C CG  . ASP A 1 310 ? 268.639 -18.354 264.553 1.0 54.72259  ? 310 ASP A CG  310 ASP A CG  1 
ATOM 2372  O OD1 . ASP A 1 310 ? 269.749 -18.210 265.107 1.0 54.72259  ? 310 ASP A OD1 310 ASP A OD1 1 
ATOM 2373  O OD2 . ASP A 1 310 ? 268.145 -17.510 263.779 1.0 54.72259  ? 310 ASP A OD2 310 ASP A OD2 1 
ATOM 2374  N N   . ARG A 1 311 ? 267.820 -23.050 265.049 1.0 50.46413  ? 311 ARG A N   311 ARG A N   1 
ATOM 2375  C CA  . ARG A 1 311 ? 266.990 -24.178 265.428 1.0 50.46413  ? 311 ARG A CA  311 ARG A CA  1 
ATOM 2376  C C   . ARG A 1 311 ? 267.843 -25.184 266.190 1.0 50.46413  ? 311 ARG A C   311 ARG A C   1 
ATOM 2377  O O   . ARG A 1 311 ? 269.062 -25.233 266.022 1.0 50.46413  ? 311 ARG A O   311 ARG A O   1 
ATOM 2378  C CB  . ARG A 1 311 ? 266.388 -24.801 264.167 1.0 50.46413  ? 311 ARG A CB  311 ARG A CB  1 
ATOM 2379  C CG  . ARG A 1 311 ? 265.344 -25.871 264.348 1.0 50.46413  ? 311 ARG A CG  311 ARG A CG  1 
ATOM 2380  C CD  . ARG A 1 311 ? 264.845 -26.290 262.991 1.0 50.46413  ? 311 ARG A CD  311 ARG A CD  1 
ATOM 2381  N NE  . ARG A 1 311 ? 264.093 -25.219 262.353 1.0 50.46413  ? 311 ARG A NE  311 ARG A NE  1 
ATOM 2382  C CZ  . ARG A 1 311 ? 263.743 -25.215 261.074 1.0 50.46413  ? 311 ARG A CZ  311 ARG A CZ  1 
ATOM 2383  N NH1 . ARG A 1 311 ? 264.092 -26.222 260.290 1.0 50.46413  ? 311 ARG A NH1 311 ARG A NH1 1 
ATOM 2384  N NH2 . ARG A 1 311 ? 263.052 -24.202 260.575 1.0 50.46413  ? 311 ARG A NH2 311 ARG A NH2 1 
ATOM 2385  N N   . ASN A 1 312 ? 267.204 -25.961 267.063 1.0 50.60853  ? 312 ASN A N   312 ASN A N   1 
ATOM 2386  C CA  . ASN A 1 312 ? 267.873 -27.050 267.771 1.0 50.60853  ? 312 ASN A CA  312 ASN A CA  1 
ATOM 2387  C C   . ASN A 1 312 ? 267.001 -28.290 267.621 1.0 50.60853  ? 312 ASN A C   312 ASN A C   1 
ATOM 2388  O O   . ASN A 1 312 ? 266.064 -28.492 268.396 1.0 50.60853  ? 312 ASN A O   312 ASN A O   1 
ATOM 2389  C CB  . ASN A 1 312 ? 268.100 -26.709 269.237 1.0 50.60853  ? 312 ASN A CB  312 ASN A CB  1 
ATOM 2390  C CG  . ASN A 1 312 ? 269.118 -27.606 269.889 1.0 50.60853  ? 312 ASN A CG  312 ASN A CG  1 
ATOM 2391  O OD1 . ASN A 1 312 ? 269.641 -28.525 269.266 1.0 50.60853  ? 312 ASN A OD1 312 ASN A OD1 1 
ATOM 2392  N ND2 . ASN A 1 312 ? 269.426 -27.330 271.147 1.0 50.60853  ? 312 ASN A ND2 312 ASN A ND2 1 
ATOM 2393  N N   . SER A 1 313 ? 267.310 -29.118 266.625 1.0 50.54194  ? 313 SER A N   313 SER A N   1 
ATOM 2394  C CA  . SER A 1 313 ? 266.577 -30.360 266.430 1.0 50.54194  ? 313 SER A CA  313 SER A CA  1 
ATOM 2395  C C   . SER A 1 313 ? 266.963 -31.427 267.442 1.0 50.54194  ? 313 SER A C   313 SER A C   1 
ATOM 2396  O O   . SER A 1 313 ? 266.253 -32.428 267.567 1.0 50.54194  ? 313 SER A O   313 SER A O   1 
ATOM 2397  C CB  . SER A 1 313 ? 266.803 -30.883 265.012 1.0 50.54194  ? 313 SER A CB  313 SER A CB  1 
ATOM 2398  O OG  . SER A 1 313 ? 266.286 -29.979 264.053 1.0 50.54194  ? 313 SER A OG  313 SER A OG  1 
ATOM 2399  N N   . GLU A 1 314 ? 268.068 -31.239 268.160 1.0 49.84262  ? 314 GLU A N   314 GLU A N   1 
ATOM 2400  C CA  . GLU A 1 314 ? 268.463 -32.190 269.190 1.0 49.84262  ? 314 GLU A CA  314 GLU A CA  1 
ATOM 2401  C C   . GLU A 1 314 ? 267.627 -32.015 270.449 1.0 49.84262  ? 314 GLU A C   314 GLU A C   1 
ATOM 2402  O O   . GLU A 1 314 ? 267.080 -32.986 270.979 1.0 49.84262  ? 314 GLU A O   314 GLU A O   1 
ATOM 2403  C CB  . GLU A 1 314 ? 269.939 -32.014 269.524 1.0 49.84262  ? 314 GLU A CB  314 GLU A CB  1 
ATOM 2404  C CG  . GLU A 1 314 ? 270.923 -32.285 268.400 1.0 49.84262  ? 314 GLU A CG  314 GLU A CG  1 
ATOM 2405  C CD  . GLU A 1 314 ? 271.042 -33.746 268.046 1.0 49.84262  ? 314 GLU A CD  314 GLU A CD  1 
ATOM 2406  O OE1 . GLU A 1 314 ? 270.679 -34.597 268.872 1.0 49.84262  ? 314 GLU A OE1 314 GLU A OE1 1 
ATOM 2407  O OE2 . GLU A 1 314 ? 271.580 -34.052 266.968 1.0 49.84262  ? 314 GLU A OE2 314 GLU A OE2 1 
ATOM 2408  N N   . LEU A 1 315 ? 267.528 -30.781 270.946 1.0 47.45953  ? 315 LEU A N   315 LEU A N   1 
ATOM 2409  C CA  . LEU A 1 315 ? 266.773 -30.533 272.169 1.0 47.45953  ? 315 LEU A CA  315 LEU A CA  1 
ATOM 2410  C C   . LEU A 1 315 ? 265.275 -30.619 271.925 1.0 47.45953  ? 315 LEU A C   315 LEU A C   1 
ATOM 2411  O O   . LEU A 1 315 ? 264.521 -30.966 272.839 1.0 47.45953  ? 315 LEU A O   315 LEU A O   1 
ATOM 2412  C CB  . LEU A 1 315 ? 267.147 -29.169 272.748 1.0 47.45953  ? 315 LEU A CB  315 LEU A CB  1 
ATOM 2413  C CG  . LEU A 1 315 ? 266.549 -28.762 274.093 1.0 47.45953  ? 315 LEU A CG  315 LEU A CG  1 
ATOM 2414  C CD1 . LEU A 1 315 ? 266.967 -29.732 275.168 1.0 47.45953  ? 315 LEU A CD1 315 LEU A CD1 1 
ATOM 2415  C CD2 . LEU A 1 315 ? 266.960 -27.366 274.463 1.0 47.45953  ? 315 LEU A CD2 315 LEU A CD2 1 
ATOM 2416  N N   . SER A 1 316 ? 264.830 -30.336 270.700 1.0 45.6949   ? 316 SER A N   316 SER A N   1 
ATOM 2417  C CA  . SER A 1 316 ? 263.417 -30.480 270.376 1.0 45.6949   ? 316 SER A CA  316 SER A CA  1 
ATOM 2418  C C   . SER A 1 316 ? 262.979 -31.934 270.411 1.0 45.6949   ? 316 SER A C   316 SER A C   1 
ATOM 2419  O O   . SER A 1 316 ? 261.815 -32.224 270.695 1.0 45.6949   ? 316 SER A O   316 SER A O   1 
ATOM 2420  C CB  . SER A 1 316 ? 263.127 -29.884 269.003 1.0 45.6949   ? 316 SER A CB  316 SER A CB  1 
ATOM 2421  O OG  . SER A 1 316 ? 261.767 -30.067 268.656 1.0 45.6949   ? 316 SER A OG  316 SER A OG  1 
ATOM 2422  N N   . TYR A 1 317 ? 263.893 -32.860 270.126 1.0 46.4796   ? 317 TYR A N   317 TYR A N   1 
ATOM 2423  C CA  . TYR A 1 317 ? 263.575 -34.271 270.278 1.0 46.4796   ? 317 TYR A CA  317 TYR A CA  1 
ATOM 2424  C C   . TYR A 1 317 ? 263.565 -34.679 271.742 1.0 46.4796   ? 317 TYR A C   317 TYR A C   1 
ATOM 2425  O O   . TYR A 1 317 ? 262.825 -35.590 272.124 1.0 46.4796   ? 317 TYR A O   317 TYR A O   1 
ATOM 2426  C CB  . TYR A 1 317 ? 264.578 -35.114 269.498 1.0 46.4796   ? 317 TYR A CB  317 TYR A CB  1 
ATOM 2427  C CG  . TYR A 1 317 ? 264.301 -36.595 269.516 1.0 46.4796   ? 317 TYR A CG  317 TYR A CG  1 
ATOM 2428  C CD1 . TYR A 1 317 ? 263.296 -37.143 268.733 1.0 46.4796   ? 317 TYR A CD1 317 TYR A CD1 1 
ATOM 2429  C CD2 . TYR A 1 317 ? 265.051 -37.446 270.310 1.0 46.4796   ? 317 TYR A CD2 317 TYR A CD2 1 
ATOM 2430  C CE1 . TYR A 1 317 ? 263.045 -38.497 268.743 1.0 46.4796   ? 317 TYR A CE1 317 TYR A CE1 1 
ATOM 2431  C CE2 . TYR A 1 317 ? 264.807 -38.801 270.327 1.0 46.4796   ? 317 TYR A CE2 317 TYR A CE2 1 
ATOM 2432  C CZ  . TYR A 1 317 ? 263.805 -39.319 269.542 1.0 46.4796   ? 317 TYR A CZ  317 TYR A CZ  1 
ATOM 2433  O OH  . TYR A 1 317 ? 263.565 -40.671 269.563 1.0 46.4796   ? 317 TYR A OH  317 TYR A OH  1 
ATOM 2434  N N   . GLN A 1 318 ? 264.368 -34.018 272.573 1.0 45.858    ? 318 GLN A N   318 GLN A N   1 
ATOM 2435  C CA  . GLN A 1 318 ? 264.441 -34.382 273.981 1.0 45.858    ? 318 GLN A CA  318 GLN A CA  1 
ATOM 2436  C C   . GLN A 1 318 ? 263.227 -33.909 274.759 1.0 45.858    ? 318 GLN A C   318 GLN A C   1 
ATOM 2437  O O   . GLN A 1 318 ? 262.858 -34.534 275.757 1.0 45.858    ? 318 GLN A O   318 GLN A O   1 
ATOM 2438  C CB  . GLN A 1 318 ? 265.717 -33.820 274.596 1.0 45.858    ? 318 GLN A CB  318 GLN A CB  1 
ATOM 2439  C CG  . GLN A 1 318 ? 266.956 -34.441 274.009 1.0 45.858    ? 318 GLN A CG  318 GLN A CG  1 
ATOM 2440  C CD  . GLN A 1 318 ? 267.083 -35.892 274.386 1.0 45.858    ? 318 GLN A CD  318 GLN A CD  1 
ATOM 2441  O OE1 . GLN A 1 318 ? 266.876 -36.261 275.538 1.0 45.858    ? 318 GLN A OE1 318 GLN A OE1 1 
ATOM 2442  N NE2 . GLN A 1 318 ? 267.382 -36.735 273.410 1.0 45.858    ? 318 GLN A NE2 318 GLN A NE2 1 
ATOM 2443  N N   . TYR A 1 319 ? 262.598 -32.818 274.331 1.0 45.2511   ? 319 TYR A N   319 TYR A N   1 
ATOM 2444  C CA  . TYR A 1 319 ? 261.361 -32.396 274.972 1.0 45.2511   ? 319 TYR A CA  319 TYR A CA  1 
ATOM 2445  C C   . TYR A 1 319 ? 260.156 -33.114 274.387 1.0 45.2511   ? 319 TYR A C   319 TYR A C   1 
ATOM 2446  O O   . TYR A 1 319 ? 259.128 -33.234 275.059 1.0 45.2511   ? 319 TYR A O   319 TYR A O   1 
ATOM 2447  C CB  . TYR A 1 319 ? 261.185 -30.883 274.851 1.0 45.2511   ? 319 TYR A CB  319 TYR A CB  1 
ATOM 2448  C CG  . TYR A 1 319 ? 262.109 -30.067 275.727 1.0 45.2511   ? 319 TYR A CG  319 TYR A CG  1 
ATOM 2449  C CD1 . TYR A 1 319 ? 262.823 -30.652 276.759 1.0 45.2511   ? 319 TYR A CD1 319 TYR A CD1 1 
ATOM 2450  C CD2 . TYR A 1 319 ? 262.245 -28.704 275.532 1.0 45.2511   ? 319 TYR A CD2 319 TYR A CD2 1 
ATOM 2451  C CE1 . TYR A 1 319 ? 263.659 -29.906 277.559 1.0 45.2511   ? 319 TYR A CE1 319 TYR A CE1 1 
ATOM 2452  C CE2 . TYR A 1 319 ? 263.078 -27.949 276.329 1.0 45.2511   ? 319 TYR A CE2 319 TYR A CE2 1 
ATOM 2453  C CZ  . TYR A 1 319 ? 263.780 -28.555 277.340 1.0 45.2511   ? 319 TYR A CZ  319 TYR A CZ  1 
ATOM 2454  O OH  . TYR A 1 319 ? 264.613 -27.809 278.137 1.0 45.2511   ? 319 TYR A OH  319 TYR A OH  1 
ATOM 2455  N N   . LEU A 1 320 ? 260.266 -33.598 273.149 1.0 43.81519  ? 320 LEU A N   320 LEU A N   1 
ATOM 2456  C CA  . LEU A 1 320 ? 259.179 -34.358 272.545 1.0 43.81519  ? 320 LEU A CA  320 LEU A CA  1 
ATOM 2457  C C   . LEU A 1 320 ? 259.042 -35.725 273.192 1.0 43.81519  ? 320 LEU A C   320 LEU A C   1 
ATOM 2458  O O   . LEU A 1 320 ? 257.929 -36.232 273.362 1.0 43.81519  ? 320 LEU A O   320 LEU A O   1 
ATOM 2459  C CB  . LEU A 1 320 ? 259.416 -34.507 271.046 1.0 43.81519  ? 320 LEU A CB  320 LEU A CB  1 
ATOM 2460  C CG  . LEU A 1 320 ? 258.334 -35.224 270.245 1.0 43.81519  ? 320 LEU A CG  320 LEU A CG  1 
ATOM 2461  C CD1 . LEU A 1 320 ? 257.061 -34.416 270.269 1.0 43.81519  ? 320 LEU A CD1 320 LEU A CD1 1 
ATOM 2462  C CD2 . LEU A 1 320 ? 258.785 -35.471 268.827 1.0 43.81519  ? 320 LEU A CD2 320 LEU A CD2 1 
ATOM 2463  N N   . LEU A 1 321 ? 260.166 -36.330 273.566 1.0 45.80658  ? 321 LEU A N   321 LEU A N   1 
ATOM 2464  C CA  . LEU A 1 321 ? 260.125 -37.657 274.160 1.0 45.80658  ? 321 LEU A CA  321 LEU A CA  1 
ATOM 2465  C C   . LEU A 1 321 ? 259.619 -37.611 275.596 1.0 45.80658  ? 321 LEU A C   321 LEU A C   1 
ATOM 2466  O O   . LEU A 1 321 ? 259.000 -38.573 276.061 1.0 45.80658  ? 321 LEU A O   321 LEU A O   1 
ATOM 2467  C CB  . LEU A 1 321 ? 261.515 -38.281 274.062 1.0 45.80658  ? 321 LEU A CB  321 LEU A CB  1 
ATOM 2468  C CG  . LEU A 1 321 ? 261.783 -39.733 274.437 1.0 45.80658  ? 321 LEU A CG  321 LEU A CG  1 
ATOM 2469  C CD1 . LEU A 1 321 ? 262.854 -40.261 273.523 1.0 45.80658  ? 321 LEU A CD1 321 LEU A CD1 1 
ATOM 2470  C CD2 . LEU A 1 321 ? 262.263 -39.812 275.866 1.0 45.80658  ? 321 LEU A CD2 321 LEU A CD2 1 
ATOM 2471  N N   . ALA A 1 322 ? 259.862 -36.511 276.309 1.0 46.94513  ? 322 ALA A N   322 ALA A N   1 
ATOM 2472  C CA  . ALA A 1 322 ? 259.313 -36.363 277.650 1.0 46.94513  ? 322 ALA A CA  322 ALA A CA  1 
ATOM 2473  C C   . ALA A 1 322 ? 257.815 -36.096 277.629 1.0 46.94513  ? 322 ALA A C   322 ALA A C   1 
ATOM 2474  O O   . ALA A 1 322 ? 257.147 -36.294 278.648 1.0 46.94513  ? 322 ALA A O   322 ALA A O   1 
ATOM 2475  C CB  . ALA A 1 322 ? 260.034 -35.240 278.392 1.0 46.94513  ? 322 ALA A CB  322 ALA A CB  1 
ATOM 2476  N N   . ASP A 1 323 ? 257.277 -35.653 276.494 1.0 49.48475  ? 323 ASP A N   323 ASP A N   1 
ATOM 2477  C CA  . ASP A 1 323 ? 255.842 -35.435 276.370 1.0 49.48475  ? 323 ASP A CA  323 ASP A CA  1 
ATOM 2478  C C   . ASP A 1 323 ? 255.113 -36.743 276.085 1.0 49.48475  ? 323 ASP A C   323 ASP A C   1 
ATOM 2479  O O   . ASP A 1 323 ? 254.109 -37.054 276.735 1.0 49.48475  ? 323 ASP A O   323 ASP A O   1 
ATOM 2480  C CB  . ASP A 1 323 ? 255.567 -34.417 275.261 1.0 49.48475  ? 323 ASP A CB  323 ASP A CB  1 
ATOM 2481  C CG  . ASP A 1 323 ? 254.140 -33.890 275.277 1.0 49.48475  ? 323 ASP A CG  323 ASP A CG  1 
ATOM 2482  O OD1 . ASP A 1 323 ? 253.360 -34.245 276.185 1.0 49.48475  ? 323 ASP A OD1 323 ASP A OD1 1 
ATOM 2483  O OD2 . ASP A 1 323 ? 253.789 -33.124 274.358 1.0 49.48475  ? 323 ASP A OD2 323 ASP A OD2 1 
ATOM 2484  N N   . LEU A 1 324 ? 255.601 -37.514 275.112 1.0 49.38555  ? 324 LEU A N   324 LEU A N   1 
ATOM 2485  C CA  . LEU A 1 324 ? 254.893 -38.713 274.675 1.0 49.38555  ? 324 LEU A CA  324 LEU A CA  1 
ATOM 2486  C C   . LEU A 1 324 ? 255.014 -39.832 275.696 1.0 49.38555  ? 324 LEU A C   324 LEU A C   1 
ATOM 2487  O O   . LEU A 1 324 ? 254.016 -40.270 276.279 1.0 49.38555  ? 324 LEU A O   324 LEU A O   1 
ATOM 2488  C CB  . LEU A 1 324 ? 255.428 -39.176 273.320 1.0 49.38555  ? 324 LEU A CB  324 LEU A CB  1 
ATOM 2489  C CG  . LEU A 1 324 ? 254.816 -38.630 272.031 1.0 49.38555  ? 324 LEU A CG  324 LEU A CG  1 
ATOM 2490  C CD1 . LEU A 1 324 ? 255.102 -37.165 271.830 1.0 49.38555  ? 324 LEU A CD1 324 LEU A CD1 1 
ATOM 2491  C CD2 . LEU A 1 324 ? 255.340 -39.436 270.846 1.0 49.38555  ? 324 LEU A CD2 324 LEU A CD2 1 
ATOM 2492  N N   . THR A 1 325 ? 256.227 -40.301 275.934 1.0 50.94935  ? 325 THR A N   325 THR A N   1 
ATOM 2493  C CA  . THR A 1 325 ? 256.434 -41.455 276.789 1.0 50.94935  ? 325 THR A CA  325 THR A CA  1 
ATOM 2494  C C   . THR A 1 325 ? 257.006 -41.027 278.130 1.0 50.94935  ? 325 THR A C   325 THR A C   1 
ATOM 2495  O O   . THR A 1 325 ? 257.410 -39.882 278.332 1.0 50.94935  ? 325 THR A O   325 THR A O   1 
ATOM 2496  C CB  . THR A 1 325 ? 257.363 -42.470 276.118 1.0 50.94935  ? 325 THR A CB  325 THR A CB  1 
ATOM 2497  O OG1 . THR A 1 325 ? 257.395 -43.671 276.897 1.0 50.94935  ? 325 THR A OG1 325 THR A OG1 1 
ATOM 2498  C CG2 . THR A 1 325 ? 258.767 -41.914 276.015 1.0 50.94935  ? 325 THR A CG2 325 THR A CG2 1 
ATOM 2499  N N   . SER A 1 326 ? 257.023 -41.972 279.059 1.0 51.93431  ? 326 SER A N   326 SER A N   1 
ATOM 2500  C CA  . SER A 1 326 ? 257.687 -41.741 280.324 1.0 51.93431  ? 326 SER A CA  326 SER A CA  1 
ATOM 2501  C C   . SER A 1 326 ? 259.191 -41.828 280.133 1.0 51.93431  ? 326 SER A C   326 SER A C   1 
ATOM 2502  O O   . SER A 1 326 ? 259.688 -42.492 279.221 1.0 51.93431  ? 326 SER A O   326 SER A O   1 
ATOM 2503  C CB  . SER A 1 326 ? 257.239 -42.750 281.376 1.0 51.93431  ? 326 SER A CB  326 SER A CB  1 
ATOM 2504  O OG  . SER A 1 326 ? 257.901 -42.508 282.604 1.0 51.93431  ? 326 SER A OG  326 SER A OG  1 
ATOM 2505  N N   . ARG A 1 327 ? 259.913 -41.141 281.005 1.0 52.96231  ? 327 ARG A N   327 ARG A N   1 
ATOM 2506  C CA  . ARG A 1 327 ? 261.353 -41.012 280.896 1.0 52.96231  ? 327 ARG A CA  327 ARG A CA  1 
ATOM 2507  C C   . ARG A 1 327 ? 262.083 -42.008 281.790 1.0 52.96231  ? 327 ARG A C   327 ARG A C   1 
ATOM 2508  O O   . ARG A 1 327 ? 263.288 -42.223 281.619 1.0 52.96231  ? 327 ARG A O   327 ARG A O   1 
ATOM 2509  C CB  . ARG A 1 327 ? 261.723 -39.559 281.228 1.0 52.96231  ? 327 ARG A CB  327 ARG A CB  1 
ATOM 2510  C CG  . ARG A 1 327 ? 263.139 -39.127 280.992 1.0 52.96231  ? 327 ARG A CG  327 ARG A CG  1 
ATOM 2511  C CD  . ARG A 1 327 ? 263.547 -39.286 279.540 1.0 52.96231  ? 327 ARG A CD  327 ARG A CD  1 
ATOM 2512  N NE  . ARG A 1 327 ? 264.877 -38.695 279.363 1.0 52.96231  ? 327 ARG A NE  327 ARG A NE  1 
ATOM 2513  C CZ  . ARG A 1 327 ? 265.646 -38.841 278.293 1.0 52.96231  ? 327 ARG A CZ  327 ARG A CZ  1 
ATOM 2514  N NH1 . ARG A 1 327 ? 265.257 -39.584 277.273 1.0 52.96231  ? 327 ARG A NH1 327 ARG A NH1 1 
ATOM 2515  N NH2 . ARG A 1 327 ? 266.828 -38.248 278.267 1.0 52.96231  ? 327 ARG A NH2 327 ARG A NH2 1 
ATOM 2516  N N   . TRP A 1 328 ? 261.355 -42.667 282.693 1.0 57.10892  ? 328 TRP A N   328 TRP A N   1 
ATOM 2517  C CA  . TRP A 1 328 ? 261.955 -43.604 283.634 1.0 57.10892  ? 328 TRP A CA  328 TRP A CA  1 
ATOM 2518  C C   . TRP A 1 328 ? 262.463 -44.868 282.953 1.0 57.10892  ? 328 TRP A C   328 TRP A C   1 
ATOM 2519  O O   . TRP A 1 328 ? 263.465 -45.440 283.391 1.0 57.10892  ? 328 TRP A O   328 TRP A O   1 
ATOM 2520  C CB  . TRP A 1 328 ? 260.932 -43.965 284.708 1.0 57.10892  ? 328 TRP A CB  328 TRP A CB  1 
ATOM 2521  C CG  . TRP A 1 328 ? 261.446 -44.875 285.771 1.0 57.10892  ? 328 TRP A CG  328 TRP A CG  1 
ATOM 2522  C CD1 . TRP A 1 328 ? 261.228 -46.218 285.877 1.0 57.10892  ? 328 TRP A CD1 328 TRP A CD1 1 
ATOM 2523  C CD2 . TRP A 1 328 ? 262.247 -44.509 286.899 1.0 57.10892  ? 328 TRP A CD2 328 TRP A CD2 1 
ATOM 2524  N NE1 . TRP A 1 328 ? 261.853 -46.713 286.995 1.0 57.10892  ? 328 TRP A NE1 328 TRP A NE1 1 
ATOM 2525  C CE2 . TRP A 1 328 ? 262.486 -45.683 287.640 1.0 57.10892  ? 328 TRP A CE2 328 TRP A CE2 1 
ATOM 2526  C CE3 . TRP A 1 328 ? 262.790 -43.303 287.352 1.0 57.10892  ? 328 TRP A CE3 328 TRP A CE3 1 
ATOM 2527  C CZ2 . TRP A 1 328 ? 263.244 -45.687 288.808 1.0 57.10892  ? 328 TRP A CZ2 328 TRP A CZ2 1 
ATOM 2528  C CZ3 . TRP A 1 328 ? 263.543 -43.309 288.512 1.0 57.10892  ? 328 TRP A CZ3 328 TRP A CZ3 1 
ATOM 2529  C CH2 . TRP A 1 328 ? 263.763 -44.493 289.226 1.0 57.10892  ? 328 TRP A CH2 328 TRP A CH2 1 
ATOM 2530  N N   . HIS A 1 329 ? 261.805 -45.314 281.888 1.0 53.46773  ? 329 HIS A N   329 HIS A N   1 
ATOM 2531  C CA  . HIS A 1 329 ? 262.130 -46.607 281.307 1.0 53.46773  ? 329 HIS A CA  329 HIS A CA  1 
ATOM 2532  C C   . HIS A 1 329 ? 263.323 -46.518 280.365 1.0 53.46773  ? 329 HIS A C   329 HIS A C   1 
ATOM 2533  O O   . HIS A 1 329 ? 263.644 -45.456 279.826 1.0 53.46773  ? 329 HIS A O   329 HIS A O   1 
ATOM 2534  C CB  . HIS A 1 329 ? 260.932 -47.181 280.557 1.0 53.46773  ? 329 HIS A CB  329 HIS A CB  1 
ATOM 2535  C CG  . HIS A 1 329 ? 259.754 -47.463 281.433 1.0 53.46773  ? 329 HIS A CG  329 HIS A CG  1 
ATOM 2536  N ND1 . HIS A 1 329 ? 258.699 -46.588 281.565 1.0 53.46773  ? 329 HIS A ND1 329 HIS A ND1 1 
ATOM 2537  C CD2 . HIS A 1 329 ? 259.486 -48.504 282.256 1.0 53.46773  ? 329 HIS A CD2 329 HIS A CD2 1 
ATOM 2538  C CE1 . HIS A 1 329 ? 257.816 -47.092 282.407 1.0 53.46773  ? 329 HIS A CE1 329 HIS A CE1 1 
ATOM 2539  N NE2 . HIS A 1 329 ? 258.270 -48.254 282.842 1.0 53.46773  ? 329 HIS A NE2 329 HIS A NE2 1 
ATOM 2540  N N   . TYR A 1 330 ? 263.973 -47.662 280.167 1.0 53.3202   ? 330 TYR A N   330 TYR A N   1 
ATOM 2541  C CA  . TYR A 1 330 ? 265.157 -47.792 279.327 1.0 53.3202   ? 330 TYR A CA  330 TYR A CA  1 
ATOM 2542  C C   . TYR A 1 330 ? 264.790 -48.604 278.094 1.0 53.3202   ? 330 TYR A C   330 TYR A C   1 
ATOM 2543  O O   . TYR A 1 330 ? 264.418 -49.775 278.208 1.0 53.3202   ? 330 TYR A O   330 TYR A O   1 
ATOM 2544  C CB  . TYR A 1 330 ? 266.294 -48.472 280.088 1.0 53.3202   ? 330 TYR A CB  330 TYR A CB  1 
ATOM 2545  C CG  . TYR A 1 330 ? 266.904 -47.641 281.194 1.0 53.3202   ? 330 TYR A CG  330 TYR A CG  1 
ATOM 2546  C CD1 . TYR A 1 330 ? 266.719 -46.267 281.244 1.0 53.3202   ? 330 TYR A CD1 330 TYR A CD1 1 
ATOM 2547  C CD2 . TYR A 1 330 ? 267.664 -48.235 282.193 1.0 53.3202   ? 330 TYR A CD2 330 TYR A CD2 1 
ATOM 2548  C CE1 . TYR A 1 330 ? 267.274 -45.510 282.254 1.0 53.3202   ? 330 TYR A CE1 330 TYR A CE1 1 
ATOM 2549  C CE2 . TYR A 1 330 ? 268.221 -47.485 283.206 1.0 53.3202   ? 330 TYR A CE2 330 TYR A CE2 1 
ATOM 2550  C CZ  . TYR A 1 330 ? 268.021 -46.124 283.229 1.0 53.3202   ? 330 TYR A CZ  330 TYR A CZ  1 
ATOM 2551  O OH  . TYR A 1 330 ? 268.572 -45.372 284.234 1.0 53.3202   ? 330 TYR A OH  330 TYR A OH  1 
ATOM 2552  N N   . PHE A 1 331 ? 264.904 -47.989 276.925 1.0 49.268    ? 331 PHE A N   331 PHE A N   1 
ATOM 2553  C CA  . PHE A 1 331 ? 264.531 -48.614 275.659 1.0 49.268    ? 331 PHE A CA  331 PHE A CA  1 
ATOM 2554  C C   . PHE A 1 331 ? 265.794 -48.681 274.813 1.0 49.268    ? 331 PHE A C   331 PHE A C   1 
ATOM 2555  O O   . PHE A 1 331 ? 266.194 -47.685 274.206 1.0 49.268    ? 331 PHE A O   331 PHE A O   1 
ATOM 2556  C CB  . PHE A 1 331 ? 263.419 -47.820 274.985 1.0 49.268    ? 331 PHE A CB  331 PHE A CB  1 
ATOM 2557  C CG  . PHE A 1 331 ? 262.894 -48.438 273.728 1.0 49.268    ? 331 PHE A CG  331 PHE A CG  1 
ATOM 2558  C CD1 . PHE A 1 331 ? 262.148 -49.597 273.770 1.0 49.268    ? 331 PHE A CD1 331 PHE A CD1 1 
ATOM 2559  C CD2 . PHE A 1 331 ? 263.089 -47.822 272.509 1.0 49.268    ? 331 PHE A CD2 331 PHE A CD2 1 
ATOM 2560  C CE1 . PHE A 1 331 ? 261.646 -50.149 272.610 1.0 49.268    ? 331 PHE A CE1 331 PHE A CE1 1 
ATOM 2561  C CE2 . PHE A 1 331 ? 262.578 -48.370 271.353 1.0 49.268    ? 331 PHE A CE2 331 PHE A CE2 1 
ATOM 2562  C CZ  . PHE A 1 331 ? 261.862 -49.536 271.406 1.0 49.268    ? 331 PHE A CZ  331 PHE A CZ  1 
ATOM 2563  N N   . ALA A 1 332 ? 266.415 -49.859 274.766 1.0 49.90843  ? 332 ALA A N   332 ALA A N   1 
ATOM 2564  C CA  . ALA A 1 332 ? 267.765 -50.016 274.240 1.0 49.90843  ? 332 ALA A CA  332 ALA A CA  1 
ATOM 2565  C C   . ALA A 1 332 ? 267.863 -49.895 272.730 1.0 49.90843  ? 332 ALA A C   332 ALA A C   1 
ATOM 2566  O O   . ALA A 1 332 ? 268.981 -49.974 272.213 1.0 49.90843  ? 332 ALA A O   332 ALA A O   1 
ATOM 2567  C CB  . ALA A 1 332 ? 268.336 -51.366 274.665 1.0 49.90843  ? 332 ALA A CB  332 ALA A CB  1 
ATOM 2568  N N   . LEU A 1 333 ? 266.760 -49.727 272.000 1.0 47.53647  ? 333 LEU A N   333 LEU A N   1 
ATOM 2569  C CA  . LEU A 1 333 ? 266.872 -49.562 270.555 1.0 47.53647  ? 333 LEU A CA  333 LEU A CA  1 
ATOM 2570  C C   . LEU A 1 333 ? 267.400 -48.176 270.222 1.0 47.53647  ? 333 LEU A C   333 LEU A C   1 
ATOM 2571  O O   . LEU A 1 333 ? 268.458 -48.037 269.602 1.0 47.53647  ? 333 LEU A O   333 LEU A O   1 
ATOM 2572  C CB  . LEU A 1 333 ? 265.522 -49.811 269.881 1.0 47.53647  ? 333 LEU A CB  333 LEU A CB  1 
ATOM 2573  C CG  . LEU A 1 333 ? 265.469 -50.069 268.369 1.0 47.53647  ? 333 LEU A CG  333 LEU A CG  1 
ATOM 2574  C CD1 . LEU A 1 333 ? 264.332 -50.994 268.075 1.0 47.53647  ? 333 LEU A CD1 333 LEU A CD1 1 
ATOM 2575  C CD2 . LEU A 1 333 ? 265.290 -48.817 267.528 1.0 47.53647  ? 333 LEU A CD2 333 LEU A CD2 1 
ATOM 2576  N N   . TRP A 1 334 ? 266.695 -47.132 270.664 1.0 47.38003  ? 334 TRP A N   334 TRP A N   1 
ATOM 2577  C CA  . TRP A 1 334 ? 267.100 -45.765 270.383 1.0 47.38003  ? 334 TRP A CA  334 TRP A CA  1 
ATOM 2578  C C   . TRP A 1 334 ? 268.108 -45.227 271.376 1.0 47.38003  ? 334 TRP A C   334 TRP A C   1 
ATOM 2579  O O   . TRP A 1 334 ? 268.316 -44.011 271.399 1.0 47.38003  ? 334 TRP A O   334 TRP A O   1 
ATOM 2580  C CB  . TRP A 1 334 ? 265.894 -44.827 270.361 1.0 47.38003  ? 334 TRP A CB  334 TRP A CB  1 
ATOM 2581  C CG  . TRP A 1 334 ? 264.848 -45.200 269.367 1.0 47.38003  ? 334 TRP A CG  334 TRP A CG  1 
ATOM 2582  C CD1 . TRP A 1 334 ? 263.607 -45.630 269.649 1.0 47.38003  ? 334 TRP A CD1 334 TRP A CD1 1 
ATOM 2583  C CD2 . TRP A 1 334 ? 264.977 -45.241 267.949 1.0 47.38003  ? 334 TRP A CD2 334 TRP A CD2 1 
ATOM 2584  N NE1 . TRP A 1 334 ? 262.925 -45.907 268.511 1.0 47.38003  ? 334 TRP A NE1 334 TRP A NE1 1 
ATOM 2585  C CE2 . TRP A 1 334 ? 263.745 -45.679 267.442 1.0 47.38003  ? 334 TRP A CE2 334 TRP A CE2 1 
ATOM 2586  C CE3 . TRP A 1 334 ? 266.007 -44.943 267.055 1.0 47.38003  ? 334 TRP A CE3 334 TRP A CE3 1 
ATOM 2587  C CZ2 . TRP A 1 334 ? 263.509 -45.828 266.079 1.0 47.38003  ? 334 TRP A CZ2 334 TRP A CZ2 1 
ATOM 2588  C CZ3 . TRP A 1 334 ? 265.782 -45.096 265.703 1.0 47.38003  ? 334 TRP A CZ3 334 TRP A CZ3 1 
ATOM 2589  C CH2 . TRP A 1 334 ? 264.534 -45.522 265.227 1.0 47.38003  ? 334 TRP A CH2 334 TRP A CH2 1 
ATOM 2590  N N   . ASN A 1 335 ? 268.734 -46.101 272.172 1.0 47.75403  ? 335 ASN A N   335 ASN A N   1 
ATOM 2591  C CA  . ASN A 1 335 ? 269.643 -45.737 273.264 1.0 47.75403  ? 335 ASN A CA  335 ASN A CA  1 
ATOM 2592  C C   . ASN A 1 335 ? 268.955 -44.765 274.218 1.0 47.75403  ? 335 ASN A C   335 ASN A C   1 
ATOM 2593  O O   . ASN A 1 335 ? 269.507 -43.742 274.621 1.0 47.75403  ? 335 ASN A O   335 ASN A O   1 
ATOM 2594  C CB  . ASN A 1 335 ? 270.955 -45.160 272.736 1.0 47.75403  ? 335 ASN A CB  335 ASN A CB  1 
ATOM 2595  C CG  . ASN A 1 335 ? 272.130 -45.506 273.606 1.0 47.75403  ? 335 ASN A CG  335 ASN A CG  1 
ATOM 2596  O OD1 . ASN A 1 335 ? 273.278 -45.222 273.276 1.0 47.75403  ? 335 ASN A OD1 335 ASN A OD1 1 
ATOM 2597  N ND2 . ASN A 1 335 ? 271.857 -46.200 274.689 1.0 47.75403  ? 335 ASN A ND2 335 ASN A ND2 1 
ATOM 2598  N N   . GLN A 1 336 ? 267.712 -45.087 274.547 1.0 49.53777  ? 336 GLN A N   336 GLN A N   1 
ATOM 2599  C CA  . GLN A 1 336 ? 266.824 -44.189 275.275 1.0 49.53777  ? 336 GLN A CA  336 GLN A CA  1 
ATOM 2600  C C   . GLN A 1 336 ? 267.056 -44.418 276.762 1.0 49.53777  ? 336 GLN A C   336 GLN A C   1 
ATOM 2601  O O   . GLN A 1 336 ? 266.396 -45.237 277.399 1.0 49.53777  ? 336 GLN A O   336 GLN A O   1 
ATOM 2602  C CB  . GLN A 1 336 ? 265.386 -44.447 274.848 1.0 49.53777  ? 336 GLN A CB  336 GLN A CB  1 
ATOM 2603  C CG  . GLN A 1 336 ? 264.335 -43.562 275.468 1.0 49.53777  ? 336 GLN A CG  336 GLN A CG  1 
ATOM 2604  C CD  . GLN A 1 336 ? 262.966 -43.820 274.873 1.0 49.53777  ? 336 GLN A CD  336 GLN A CD  1 
ATOM 2605  O OE1 . GLN A 1 336 ? 262.820 -44.624 273.956 1.0 49.53777  ? 336 GLN A OE1 336 GLN A OE1 1 
ATOM 2606  N NE2 . GLN A 1 336 ? 261.952 -43.160 275.411 1.0 49.53777  ? 336 GLN A NE2 336 GLN A NE2 1 
ATOM 2607  N N   . ALA A 1 337 ? 268.024 -43.695 277.319 1.0 51.18819  ? 337 ALA A N   337 ALA A N   1 
ATOM 2608  C CA  . ALA A 1 337 ? 268.367 -43.808 278.732 1.0 51.18819  ? 337 ALA A CA  337 ALA A CA  1 
ATOM 2609  C C   . ALA A 1 337 ? 268.560 -42.411 279.296 1.0 51.18819  ? 337 ALA A C   337 ALA A C   1 
ATOM 2610  O O   . ALA A 1 337 ? 269.365 -41.641 278.770 1.0 51.18819  ? 337 ALA A O   337 ALA A O   1 
ATOM 2611  C CB  . ALA A 1 337 ? 269.631 -44.647 278.923 1.0 51.18819  ? 337 ALA A CB  337 ALA A CB  1 
ATOM 2612  N N   . VAL A 1 338 ? 267.843 -42.090 280.365 1.0 54.65828  ? 338 VAL A N   338 VAL A N   1 
ATOM 2613  C CA  . VAL A 1 338 ? 267.808 -40.728 280.890 1.0 54.65828  ? 338 VAL A CA  338 VAL A CA  1 
ATOM 2614  C C   . VAL A 1 338 ? 269.091 -40.413 281.654 1.0 54.65828  ? 338 VAL A C   338 VAL A C   1 
ATOM 2615  O O   . VAL A 1 338 ? 269.584 -41.220 282.451 1.0 54.65828  ? 338 VAL A O   338 VAL A O   1 
ATOM 2616  C CB  . VAL A 1 338 ? 266.544 -40.525 281.755 1.0 54.65828  ? 338 VAL A CB  338 VAL A CB  1 
ATOM 2617  C CG1 . VAL A 1 338 ? 266.418 -41.592 282.835 1.0 54.65828  ? 338 VAL A CG1 338 VAL A CG1 1 
ATOM 2618  C CG2 . VAL A 1 338 ? 266.534 -39.142 282.394 1.0 54.65828  ? 338 VAL A CG2 338 VAL A CG2 1 
ATOM 2619  N N   . ASP A 1 339 ? 269.664 -39.244 281.375 1.0 57.16712  ? 339 ASP A N   339 ASP A N   1 
ATOM 2620  C CA  . ASP A 1 339 ? 270.742 -38.702 282.194 1.0 57.16712  ? 339 ASP A CA  339 ASP A CA  1 
ATOM 2621  C C   . ASP A 1 339 ? 270.172 -38.244 283.527 1.0 57.16712  ? 339 ASP A C   339 ASP A C   1 
ATOM 2622  O O   . ASP A 1 339 ? 269.419 -37.269 283.581 1.0 57.16712  ? 339 ASP A O   339 ASP A O   1 
ATOM 2623  C CB  . ASP A 1 339 ? 271.413 -37.534 281.483 1.0 57.16712  ? 339 ASP A CB  339 ASP A CB  1 
ATOM 2624  C CG  . ASP A 1 339 ? 272.213 -37.962 280.282 1.0 57.16712  ? 339 ASP A CG  339 ASP A CG  1 
ATOM 2625  O OD1 . ASP A 1 339 ? 272.767 -39.079 280.297 1.0 57.16712  ? 339 ASP A OD1 339 ASP A OD1 1 
ATOM 2626  O OD2 . ASP A 1 339 ? 272.283 -37.178 279.315 1.0 57.16712  ? 339 ASP A OD2 339 ASP A OD2 1 
ATOM 2627  N N   . ASP A 1 340 ? 270.518 -38.934 284.606 1.0 57.96684  ? 340 ASP A N   340 ASP A N   1 
ATOM 2628  C CA  . ASP A 1 340 ? 270.079 -38.517 285.925 1.0 57.96684  ? 340 ASP A CA  340 ASP A CA  1 
ATOM 2629  C C   . ASP A 1 340 ? 271.279 -38.413 286.855 1.0 57.96684  ? 340 ASP A C   340 ASP A C   1 
ATOM 2630  O O   . ASP A 1 340 ? 272.432 -38.570 286.449 1.0 57.96684  ? 340 ASP A O   340 ASP A O   1 
ATOM 2631  C CB  . ASP A 1 340 ? 269.015 -39.468 286.493 1.0 57.96684  ? 340 ASP A CB  340 ASP A CB  1 
ATOM 2632  C CG  . ASP A 1 340 ? 269.467 -40.915 286.526 1.0 57.96684  ? 340 ASP A CG  340 ASP A CG  1 
ATOM 2633  O OD1 . ASP A 1 340 ? 270.531 -41.237 285.959 1.0 57.96684  ? 340 ASP A OD1 340 ASP A OD1 1 
ATOM 2634  O OD2 . ASP A 1 340 ? 268.757 -41.739 287.138 1.0 57.96684  ? 340 ASP A OD2 340 ASP A OD2 1 
ATOM 2635  N N   . TYR A 1 341 ? 270.990 -38.127 288.115 1.0 59.10236  ? 341 TYR A N   341 TYR A N   1 
ATOM 2636  C CA  . TYR A 1 341 ? 271.990 -38.081 289.159 1.0 59.10236  ? 341 TYR A CA  341 TYR A CA  1 
ATOM 2637  C C   . TYR A 1 341 ? 271.408 -38.785 290.371 1.0 59.10236  ? 341 TYR A C   341 TYR A C   1 
ATOM 2638  O O   . TYR A 1 341 ? 270.315 -39.355 290.317 1.0 59.10236  ? 341 TYR A O   341 TYR A O   1 
ATOM 2639  C CB  . TYR A 1 341 ? 272.419 -36.637 289.453 1.0 59.10236  ? 341 TYR A CB  341 TYR A CB  1 
ATOM 2640  C CG  . TYR A 1 341 ? 271.304 -35.708 289.887 1.0 59.10236  ? 341 TYR A CG  341 TYR A CG  1 
ATOM 2641  C CD1 . TYR A 1 341 ? 270.562 -35.000 288.955 1.0 59.10236  ? 341 TYR A CD1 341 TYR A CD1 1 
ATOM 2642  C CD2 . TYR A 1 341 ? 271.019 -35.515 291.228 1.0 59.10236  ? 341 TYR A CD2 341 TYR A CD2 1 
ATOM 2643  C CE1 . TYR A 1 341 ? 269.553 -34.147 289.348 1.0 59.10236  ? 341 TYR A CE1 341 TYR A CE1 1 
ATOM 2644  C CE2 . TYR A 1 341 ? 270.012 -34.663 291.630 1.0 59.10236  ? 341 TYR A CE2 341 TYR A CE2 1 
ATOM 2645  C CZ  . TYR A 1 341 ? 269.285 -33.982 290.687 1.0 59.10236  ? 341 TYR A CZ  341 TYR A CZ  1 
ATOM 2646  O OH  . TYR A 1 341 ? 268.282 -33.132 291.089 1.0 59.10236  ? 341 TYR A OH  341 TYR A OH  1 
ATOM 2647  N N   . ASP A 1 342 ? 272.146 -38.763 291.466 1.0 63.88859  ? 342 ASP A N   342 ASP A N   1 
ATOM 2648  C CA  . ASP A 1 342 ? 271.658 -39.339 292.702 1.0 63.88859  ? 342 ASP A CA  342 ASP A CA  1 
ATOM 2649  C C   . ASP A 1 342 ? 271.090 -38.220 293.560 1.0 63.88859  ? 342 ASP A C   342 ASP A C   1 
ATOM 2650  O O   . ASP A 1 342 ? 271.775 -37.229 293.833 1.0 63.88859  ? 342 ASP A O   342 ASP A O   1 
ATOM 2651  C CB  . ASP A 1 342 ? 272.773 -40.074 293.436 1.0 63.88859  ? 342 ASP A CB  342 ASP A CB  1 
ATOM 2652  C CG  . ASP A 1 342 ? 272.248 -41.036 294.480 1.0 63.88859  ? 342 ASP A CG  342 ASP A CG  1 
ATOM 2653  O OD1 . ASP A 1 342 ? 271.013 -41.140 294.624 1.0 63.88859  ? 342 ASP A OD1 342 ASP A OD1 1 
ATOM 2654  O OD2 . ASP A 1 342 ? 273.069 -41.695 295.153 1.0 63.88859  ? 342 ASP A OD2 342 ASP A OD2 1 
ATOM 2655  N N   . HIS A 1 343 ? 269.836 -38.385 293.973 1.0 66.9823   ? 343 HIS A N   343 HIS A N   1 
ATOM 2656  C CA  . HIS A 1 343 ? 269.144 -37.382 294.768 1.0 66.9823   ? 343 HIS A CA  343 HIS A CA  1 
ATOM 2657  C C   . HIS A 1 343 ? 269.764 -37.205 296.148 1.0 66.9823   ? 343 HIS A C   343 HIS A C   1 
ATOM 2658  O O   . HIS A 1 343 ? 269.639 -36.128 296.738 1.0 66.9823   ? 343 HIS A O   343 HIS A O   1 
ATOM 2659  C CB  . HIS A 1 343 ? 267.673 -37.783 294.880 1.0 66.9823   ? 343 HIS A CB  343 HIS A CB  1 
ATOM 2660  C CG  . HIS A 1 343 ? 266.829 -36.806 295.632 1.0 66.9823   ? 343 HIS A CG  343 HIS A CG  1 
ATOM 2661  N ND1 . HIS A 1 343 ? 266.434 -35.599 295.101 1.0 66.9823   ? 343 HIS A ND1 343 HIS A ND1 1 
ATOM 2662  C CD2 . HIS A 1 343 ? 266.299 -36.863 296.876 1.0 66.9823   ? 343 HIS A CD2 343 HIS A CD2 1 
ATOM 2663  C CE1 . HIS A 1 343 ? 265.697 -34.952 295.986 1.0 66.9823   ? 343 HIS A CE1 343 HIS A CE1 1 
ATOM 2664  N NE2 . HIS A 1 343 ? 265.601 -35.697 297.072 1.0 66.9823   ? 343 HIS A NE2 343 HIS A NE2 1 
ATOM 2665  N N   . HIS A 1 344 ? 270.449 -38.222 296.664 1.0 65.70298  ? 344 HIS A N   344 HIS A N   1 
ATOM 2666  C CA  . HIS A 1 344 ? 271.096 -38.148 297.964 1.0 65.70298  ? 344 HIS A CA  344 HIS A CA  1 
ATOM 2667  C C   . HIS A 1 344 ? 272.574 -37.803 297.871 1.0 65.70298  ? 344 HIS A C   344 HIS A C   1 
ATOM 2668  O O   . HIS A 1 344 ? 273.286 -37.922 298.869 1.0 65.70298  ? 344 HIS A O   344 HIS A O   1 
ATOM 2669  C CB  . HIS A 1 344 ? 270.919 -39.468 298.710 1.0 65.70298  ? 344 HIS A CB  344 HIS A CB  1 
ATOM 2670  C CG  . HIS A 1 344 ? 269.492 -39.797 299.009 1.0 65.70298  ? 344 HIS A CG  344 HIS A CG  1 
ATOM 2671  N ND1 . HIS A 1 344 ? 268.776 -39.162 299.999 1.0 65.70298  ? 344 HIS A ND1 344 HIS A ND1 1 
ATOM 2672  C CD2 . HIS A 1 344 ? 268.643 -40.682 298.438 1.0 65.70298  ? 344 HIS A CD2 344 HIS A CD2 1 
ATOM 2673  C CE1 . HIS A 1 344 ? 267.548 -39.647 300.030 1.0 65.70298  ? 344 HIS A CE1 344 HIS A CE1 1 
ATOM 2674  N NE2 . HIS A 1 344 ? 267.441 -40.571 299.093 1.0 65.70298  ? 344 HIS A NE2 344 HIS A NE2 1 
ATOM 2675  N N   . VAL A 1 345 ? 273.054 -37.388 296.704 1.0 61.56938  ? 345 VAL A N   345 VAL A N   1 
ATOM 2676  C CA  . VAL A 1 345 ? 274.442 -36.982 296.518 1.0 61.56938  ? 345 VAL A CA  345 VAL A CA  1 
ATOM 2677  C C   . VAL A 1 345 ? 274.543 -35.505 296.164 1.0 61.56938  ? 345 VAL A C   345 VAL A C   1 
ATOM 2678  O O   . VAL A 1 345 ? 275.299 -34.759 296.789 1.0 61.56938  ? 345 VAL A O   345 VAL A O   1 
ATOM 2679  C CB  . VAL A 1 345 ? 275.136 -37.857 295.452 1.0 61.56938  ? 345 VAL A CB  345 VAL A CB  1 
ATOM 2680  C CG1 . VAL A 1 345 ? 276.494 -37.293 295.100 1.0 61.56938  ? 345 VAL A CG1 345 VAL A CG1 1 
ATOM 2681  C CG2 . VAL A 1 345 ? 275.298 -39.260 295.970 1.0 61.56938  ? 345 VAL A CG2 345 VAL A CG2 1 
ATOM 2682  N N   . ARG A 1 346 ? 273.785 -35.071 295.156 1.0 60.81076  ? 346 ARG A N   346 ARG A N   1 
ATOM 2683  C CA  . ARG A 1 346 ? 273.761 -33.667 294.761 1.0 60.81076  ? 346 ARG A CA  346 ARG A CA  1 
ATOM 2684  C C   . ARG A 1 346 ? 273.211 -32.787 295.871 1.0 60.81076  ? 346 ARG A C   346 ARG A C   1 
ATOM 2685  O O   . ARG A 1 346 ? 273.804 -31.765 296.225 1.0 60.81076  ? 346 ARG A O   346 ARG A O   1 
ATOM 2686  C CB  . ARG A 1 346 ? 272.913 -33.510 293.507 1.0 60.81076  ? 346 ARG A CB  346 ARG A CB  1 
ATOM 2687  C CG  . ARG A 1 346 ? 272.732 -32.093 293.032 1.0 60.81076  ? 346 ARG A CG  346 ARG A CG  1 
ATOM 2688  C CD  . ARG A 1 346 ? 274.031 -31.528 292.545 1.0 60.81076  ? 346 ARG A CD  346 ARG A CD  1 
ATOM 2689  N NE  . ARG A 1 346 ? 273.849 -30.235 291.902 1.0 60.81076  ? 346 ARG A NE  346 ARG A NE  1 
ATOM 2690  C CZ  . ARG A 1 346 ? 274.852 -29.488 291.467 1.0 60.81076  ? 346 ARG A CZ  346 ARG A CZ  1 
ATOM 2691  N NH1 . ARG A 1 346 ? 276.096 -29.922 291.601 1.0 60.81076  ? 346 ARG A NH1 346 ARG A NH1 1 
ATOM 2692  N NH2 . ARG A 1 346 ? 274.618 -28.318 290.893 1.0 60.81076  ? 346 ARG A NH2 346 ARG A NH2 1 
ATOM 2693  N N   . ILE A 1 347 ? 272.091 -33.198 296.455 1.0 60.36281  ? 347 ILE A N   347 ILE A N   1 
ATOM 2694  C CA  . ILE A 1 347 ? 271.338 -32.424 297.432 1.0 60.36281  ? 347 ILE A CA  347 ILE A CA  1 
ATOM 2695  C C   . ILE A 1 347 ? 271.438 -33.217 298.730 1.0 60.36281  ? 347 ILE A C   347 ILE A C   1 
ATOM 2696  O O   . ILE A 1 347 ? 270.438 -33.439 299.421 1.0 60.36281  ? 347 ILE A O   347 ILE A O   1 
ATOM 2697  C CB  . ILE A 1 347 ? 269.884 -32.195 296.972 1.0 60.36281  ? 347 ILE A CB  347 ILE A CB  1 
ATOM 2698  C CG1 . ILE A 1 347 ? 269.864 -31.753 295.512 1.0 60.36281  ? 347 ILE A CG1 347 ILE A CG1 1 
ATOM 2699  C CG2 . ILE A 1 347 ? 269.235 -31.040 297.734 1.0 60.36281  ? 347 ILE A CG2 347 ILE A CG2 1 
ATOM 2700  C CD1 . ILE A 1 347 ? 268.492 -31.766 294.886 1.0 60.36281  ? 347 ILE A CD1 347 ILE A CD1 1 
ATOM 2701  N N   . LEU A 1 348 ? 272.639 -33.746 298.982 1.0 62.0582   ? 348 LEU A N   348 LEU A N   1 
ATOM 2702  C CA  . LEU A 1 348 ? 272.910 -34.700 300.054 1.0 62.0582   ? 348 LEU A CA  348 LEU A CA  1 
ATOM 2703  C C   . LEU A 1 348 ? 272.468 -34.196 301.423 1.0 62.0582   ? 348 LEU A C   348 LEU A C   1 
ATOM 2704  O O   . LEU A 1 348 ? 272.477 -32.997 301.711 1.0 62.0582   ? 348 LEU A O   348 LEU A O   1 
ATOM 2705  C CB  . LEU A 1 348 ? 274.404 -35.034 300.109 1.0 62.0582   ? 348 LEU A CB  348 LEU A CB  1 
ATOM 2706  C CG  . LEU A 1 348 ? 275.416 -34.045 300.698 1.0 62.0582   ? 348 LEU A CG  348 LEU A CG  1 
ATOM 2707  C CD1 . LEU A 1 348 ? 276.655 -34.801 301.095 1.0 62.0582   ? 348 LEU A CD1 348 LEU A CD1 1 
ATOM 2708  C CD2 . LEU A 1 348 ? 275.790 -32.941 299.726 1.0 62.0582   ? 348 LEU A CD2 348 LEU A CD2 1 
ATOM 2709  N N   . GLU A 1 349 ? 272.056 -35.142 302.258 1.0 63.84347  ? 349 GLU A N   349 GLU A N   1 
ATOM 2710  C CA  . GLU A 1 349 ? 271.491 -34.875 303.573 1.0 63.84347  ? 349 GLU A CA  349 GLU A CA  1 
ATOM 2711  C C   . GLU A 1 349 ? 272.329 -35.613 304.604 1.0 63.84347  ? 349 GLU A C   349 GLU A C   1 
ATOM 2712  O O   . GLU A 1 349 ? 272.357 -36.847 304.620 1.0 63.84347  ? 349 GLU A O   349 GLU A O   1 
ATOM 2713  C CB  . GLU A 1 349 ? 270.035 -35.319 303.630 1.0 63.84347  ? 349 GLU A CB  349 GLU A CB  1 
ATOM 2714  C CG  . GLU A 1 349 ? 269.383 -35.092 304.964 1.0 63.84347  ? 349 GLU A CG  349 GLU A CG  1 
ATOM 2715  C CD  . GLU A 1 349 ? 267.931 -35.516 304.978 1.0 63.84347  ? 349 GLU A CD  349 GLU A CD  1 
ATOM 2716  O OE1 . GLU A 1 349 ? 267.438 -36.000 303.938 1.0 63.84347  ? 349 GLU A OE1 349 GLU A OE1 1 
ATOM 2717  O OE2 . GLU A 1 349 ? 267.284 -35.364 306.035 1.0 63.84347  ? 349 GLU A OE2 349 GLU A OE2 1 
ATOM 2718  N N   . ASN A 1 350 ? 273.014 -34.863 305.458 1.0 64.62359  ? 350 ASN A N   350 ASN A N   1 
ATOM 2719  C CA  . ASN A 1 350 ? 273.897 -35.446 306.456 1.0 64.62359  ? 350 ASN A CA  350 ASN A CA  1 
ATOM 2720  C C   . ASN A 1 350 ? 273.075 -35.730 307.706 1.0 64.62359  ? 350 ASN A C   350 ASN A C   1 
ATOM 2721  O O   . ASN A 1 350 ? 272.722 -34.811 308.448 1.0 64.62359  ? 350 ASN A O   350 ASN A O   1 
ATOM 2722  C CB  . ASN A 1 350 ? 275.063 -34.509 306.749 1.0 64.62359  ? 350 ASN A CB  350 ASN A CB  1 
ATOM 2723  C CG  . ASN A 1 350 ? 276.169 -35.179 307.531 1.0 64.62359  ? 350 ASN A CG  350 ASN A CG  1 
ATOM 2724  O OD1 . ASN A 1 350 ? 276.083 -36.356 307.875 1.0 64.62359  ? 350 ASN A OD1 350 ASN A OD1 1 
ATOM 2725  N ND2 . ASN A 1 350 ? 277.224 -34.430 307.814 1.0 64.62359  ? 350 ASN A ND2 350 ASN A ND2 1 
ATOM 2726  N N   . ASP A 1 351 ? 272.764 -37.003 307.933 1.0 63.91691  ? 351 ASP A N   351 ASP A N   1 
ATOM 2727  C CA  . ASP A 1 351 ? 271.999 -37.428 309.095 1.0 63.91691  ? 351 ASP A CA  351 ASP A CA  1 
ATOM 2728  C C   . ASP A 1 351 ? 272.835 -38.223 310.082 1.0 63.91691  ? 351 ASP A C   351 ASP A C   1 
ATOM 2729  O O   . ASP A 1 351 ? 272.277 -38.850 310.987 1.0 63.91691  ? 351 ASP A O   351 ASP A O   1 
ATOM 2730  C CB  . ASP A 1 351 ? 270.792 -38.256 308.661 1.0 63.91691  ? 351 ASP A CB  351 ASP A CB  1 
ATOM 2731  C CG  . ASP A 1 351 ? 269.742 -37.427 307.969 1.0 63.91691  ? 351 ASP A CG  351 ASP A CG  1 
ATOM 2732  O OD1 . ASP A 1 351 ? 269.637 -36.225 308.286 1.0 63.91691  ? 351 ASP A OD1 351 ASP A OD1 1 
ATOM 2733  O OD2 . ASP A 1 351 ? 269.022 -37.975 307.109 1.0 63.91691  ? 351 ASP A OD2 351 ASP A OD2 1 
ATOM 2734  N N   . GLY A 1 352 ? 274.149 -38.217 309.934 1.0 65.51854  ? 352 GLY A N   352 GLY A N   1 
ATOM 2735  C CA  . GLY A 1 352 ? 274.988 -38.988 310.832 1.0 65.51854  ? 352 GLY A CA  352 GLY A CA  1 
ATOM 2736  C C   . GLY A 1 352 ? 274.937 -40.452 310.476 1.0 65.51854  ? 352 GLY A C   352 GLY A C   1 
ATOM 2737  O O   . GLY A 1 352 ? 275.177 -40.832 309.329 1.0 65.51854  ? 352 GLY A O   352 GLY A O   1 
ATOM 2738  N N   . TYR A 1 353 ? 274.603 -41.282 311.460 1.0 65.85073  ? 353 TYR A N   353 TYR A N   1 
ATOM 2739  C CA  . TYR A 1 353 ? 274.593 -42.725 311.280 1.0 65.85073  ? 353 TYR A CA  353 TYR A CA  1 
ATOM 2740  C C   . TYR A 1 353 ? 273.741 -43.350 312.372 1.0 65.85073  ? 353 TYR A C   353 TYR A C   1 
ATOM 2741  O O   . TYR A 1 353 ? 273.638 -42.815 313.477 1.0 65.85073  ? 353 TYR A O   353 TYR A O   1 
ATOM 2742  C CB  . TYR A 1 353 ? 276.016 -43.302 311.303 1.0 65.85073  ? 353 TYR A CB  353 TYR A CB  1 
ATOM 2743  C CG  . TYR A 1 353 ? 276.772 -43.076 312.595 1.0 65.85073  ? 353 TYR A CG  353 TYR A CG  1 
ATOM 2744  C CD1 . TYR A 1 353 ? 277.497 -41.910 312.802 1.0 65.85073  ? 353 TYR A CD1 353 TYR A CD1 1 
ATOM 2745  C CD2 . TYR A 1 353 ? 276.792 -44.044 313.591 1.0 65.85073  ? 353 TYR A CD2 353 TYR A CD2 1 
ATOM 2746  C CE1 . TYR A 1 353 ? 278.191 -41.702 313.973 1.0 65.85073  ? 353 TYR A CE1 353 TYR A CE1 1 
ATOM 2747  C CE2 . TYR A 1 353 ? 277.483 -43.844 314.765 1.0 65.85073  ? 353 TYR A CE2 353 TYR A CE2 1 
ATOM 2748  C CZ  . TYR A 1 353 ? 278.180 -42.673 314.950 1.0 65.85073  ? 353 TYR A CZ  353 TYR A CZ  1 
ATOM 2749  O OH  . TYR A 1 353 ? 278.872 -42.479 316.121 1.0 65.85073  ? 353 TYR A OH  353 TYR A OH  1 
ATOM 2750  N N   . GLU A 1 354 ? 273.138 -44.491 312.053 1.0 66.96497  ? 354 GLU A N   354 GLU A N   1 
ATOM 2751  C CA  . GLU A 1 354 ? 272.384 -45.257 313.036 1.0 66.96497  ? 354 GLU A CA  354 GLU A CA  1 
ATOM 2752  C C   . GLU A 1 354 ? 273.369 -46.034 313.896 1.0 66.96497  ? 354 GLU A C   354 GLU A C   1 
ATOM 2753  O O   . GLU A 1 354 ? 273.973 -47.006 313.434 1.0 66.96497  ? 354 GLU A O   354 GLU A O   1 
ATOM 2754  C CB  . GLU A 1 354 ? 271.403 -46.198 312.345 1.0 66.96497  ? 354 GLU A CB  354 GLU A CB  1 
ATOM 2755  C CG  . GLU A 1 354 ? 270.285 -45.494 311.604 1.0 66.96497  ? 354 GLU A CG  354 GLU A CG  1 
ATOM 2756  C CD  . GLU A 1 354 ? 269.360 -46.460 310.895 1.0 66.96497  ? 354 GLU A CD  354 GLU A CD  1 
ATOM 2757  O OE1 . GLU A 1 354 ? 269.664 -47.671 310.872 1.0 66.96497  ? 354 GLU A OE1 354 GLU A OE1 1 
ATOM 2758  O OE2 . GLU A 1 354 ? 268.329 -46.009 310.357 1.0 66.96497  ? 354 GLU A OE2 354 GLU A OE2 1 
ATOM 2759  N N   . GLU A 1 355 ? 273.546 -45.608 315.139 1.0 70.55401  ? 355 GLU A N   355 GLU A N   1 
ATOM 2760  C CA  . GLU A 1 355 ? 274.466 -46.292 316.033 1.0 70.55401  ? 355 GLU A CA  355 GLU A CA  1 
ATOM 2761  C C   . GLU A 1 355 ? 273.763 -47.439 316.744 1.0 70.55401  ? 355 GLU A C   355 GLU A C   1 
ATOM 2762  O O   . GLU A 1 355 ? 272.534 -47.498 316.822 1.0 70.55401  ? 355 GLU A O   355 GLU A O   1 
ATOM 2763  C CB  . GLU A 1 355 ? 275.050 -45.325 317.059 1.0 70.55401  ? 355 GLU A CB  355 GLU A CB  1 
ATOM 2764  C CG  . GLU A 1 355 ? 274.032 -44.771 318.029 1.0 70.55401  ? 355 GLU A CG  355 GLU A CG  1 
ATOM 2765  C CD  . GLU A 1 355 ? 274.645 -43.801 319.014 1.0 70.55401  ? 355 GLU A CD  355 GLU A CD  1 
ATOM 2766  O OE1 . GLU A 1 355 ? 275.867 -43.558 318.928 1.0 70.55401  ? 355 GLU A OE1 355 GLU A OE1 1 
ATOM 2767  O OE2 . GLU A 1 355 ? 273.906 -43.279 319.873 1.0 70.55401  ? 355 GLU A OE2 355 GLU A OE2 1 
ATOM 2768  N N   . GLY A 1 356 ? 274.565 -48.356 317.274 1.0 69.76438  ? 356 GLY A N   356 GLY A N   1 
ATOM 2769  C CA  . GLY A 1 356 ? 274.038 -49.512 317.953 1.0 69.76438  ? 356 GLY A CA  356 GLY A CA  1 
ATOM 2770  C C   . GLY A 1 356 ? 275.074 -50.224 318.796 1.0 69.76438  ? 356 GLY A C   356 GLY A C   1 
ATOM 2771  O O   . GLY A 1 356 ? 275.927 -49.598 319.431 1.0 69.76438  ? 356 GLY A O   356 GLY A O   1 
ATOM 2772  N N   . PRO A 1 357 ? 275.007 -51.552 318.825 1.0 68.40719  ? 357 PRO A N   357 PRO A N   1 
ATOM 2773  C CA  . PRO A 1 357 ? 275.974 -52.343 319.592 1.0 68.40719  ? 357 PRO A CA  357 PRO A CA  1 
ATOM 2774  C C   . PRO A 1 357 ? 277.356 -52.264 318.968 1.0 68.40719  ? 357 PRO A C   357 PRO A C   1 
ATOM 2775  O O   . PRO A 1 357 ? 277.483 -51.911 317.786 1.0 68.40719  ? 357 PRO A O   357 PRO A O   1 
ATOM 2776  C CB  . PRO A 1 357 ? 275.402 -53.768 319.504 1.0 68.40719  ? 357 PRO A CB  357 PRO A CB  1 
ATOM 2777  C CG  . PRO A 1 357 ? 273.966 -53.583 319.196 1.0 68.40719  ? 357 PRO A CG  357 PRO A CG  1 
ATOM 2778  C CD  . PRO A 1 357 ? 273.914 -52.389 318.306 1.0 68.40719  ? 357 PRO A CD  357 PRO A CD  1 
ATOM 2779  N N   . PRO A 1 358 ? 278.414 -52.557 319.726 1.0 68.92813  ? 358 PRO A N   358 PRO A N   1 
ATOM 2780  C CA  . PRO A 1 358 ? 279.759 -52.535 319.141 1.0 68.92813  ? 358 PRO A CA  358 PRO A CA  1 
ATOM 2781  C C   . PRO A 1 358 ? 279.956 -53.654 318.133 1.0 68.92813  ? 358 PRO A C   358 PRO A C   1 
ATOM 2782  O O   . PRO A 1 358 ? 279.591 -54.806 318.371 1.0 68.92813  ? 358 PRO A O   358 PRO A O   1 
ATOM 2783  C CB  . PRO A 1 358 ? 280.677 -52.710 320.355 1.0 68.92813  ? 358 PRO A CB  358 PRO A CB  1 
ATOM 2784  C CG  . PRO A 1 358 ? 279.838 -53.372 321.369 1.0 68.92813  ? 358 PRO A CG  358 PRO A CG  1 
ATOM 2785  C CD  . PRO A 1 358 ? 278.461 -52.828 321.173 1.0 68.92813  ? 358 PRO A CD  358 PRO A CD  1 
ATOM 2786  N N   . ASN A 1 359 ? 280.531 -53.292 316.987 1.0 69.6406   ? 359 ASN A N   359 ASN A N   1 
ATOM 2787  C CA  . ASN A 1 359 ? 280.739 -54.230 315.887 1.0 69.6406   ? 359 ASN A CA  359 ASN A CA  1 
ATOM 2788  C C   . ASN A 1 359 ? 282.095 -54.897 316.085 1.0 69.6406   ? 359 ASN A C   359 ASN A C   1 
ATOM 2789  O O   . ASN A 1 359 ? 283.098 -54.550 315.460 1.0 69.6406   ? 359 ASN A O   359 ASN A O   1 
ATOM 2790  C CB  . ASN A 1 359 ? 280.643 -53.508 314.552 1.0 69.6406   ? 359 ASN A CB  359 ASN A CB  1 
ATOM 2791  C CG  . ASN A 1 359 ? 279.293 -52.863 314.341 1.0 69.6406   ? 359 ASN A CG  359 ASN A CG  1 
ATOM 2792  O OD1 . ASN A 1 359 ? 279.179 -51.641 314.284 1.0 69.6406   ? 359 ASN A OD1 359 ASN A OD1 1 
ATOM 2793  N ND2 . ASN A 1 359 ? 278.257 -53.682 314.236 1.0 69.6406   ? 359 ASN A ND2 359 ASN A ND2 1 
ATOM 2794  N N   . LEU A 1 360 ? 282.116 -55.879 316.977 1.0 70.79628  ? 360 LEU A N   360 LEU A N   1 
ATOM 2795  C CA  . LEU A 1 360 ? 283.362 -56.515 317.367 1.0 70.79628  ? 360 LEU A CA  360 LEU A CA  1 
ATOM 2796  C C   . LEU A 1 360 ? 283.813 -57.527 316.322 1.0 70.79628  ? 360 LEU A C   360 LEU A C   1 
ATOM 2797  O O   . LEU A 1 360 ? 283.000 -58.145 315.631 1.0 70.79628  ? 360 LEU A O   360 LEU A O   1 
ATOM 2798  C CB  . LEU A 1 360 ? 283.206 -57.200 318.723 1.0 70.79628  ? 360 LEU A CB  360 LEU A CB  1 
ATOM 2799  C CG  . LEU A 1 360 ? 282.933 -56.253 319.891 1.0 70.79628  ? 360 LEU A CG  360 LEU A CG  1 
ATOM 2800  C CD1 . LEU A 1 360 ? 282.667 -57.034 321.159 1.0 70.79628  ? 360 LEU A CD1 360 LEU A CD1 1 
ATOM 2801  C CD2 . LEU A 1 360 ? 284.094 -55.299 320.086 1.0 70.79628  ? 360 LEU A CD2 360 LEU A CD2 1 
ATOM 2802  N N   . ALA A 1 361 ? 285.130 -57.687 316.210 1.0 70.82573  ? 361 ALA A N   361 ALA A N   1 
ATOM 2803  C CA  . ALA A 1 361 ? 285.745 -58.669 315.328 1.0 70.82573  ? 361 ALA A CA  361 ALA A CA  1 
ATOM 2804  C C   . ALA A 1 361 ? 286.692 -59.536 316.143 1.0 70.82573  ? 361 ALA A C   361 ALA A C   1 
ATOM 2805  O O   . ALA A 1 361 ? 287.455 -59.020 316.963 1.0 70.82573  ? 361 ALA A O   361 ALA A O   1 
ATOM 2806  C CB  . ALA A 1 361 ? 286.494 -57.993 314.180 1.0 70.82573  ? 361 ALA A CB  361 ALA A CB  1 
ATOM 2807  N N   . PHE A 1 362 ? 286.653 -60.840 315.907 1.0 73.45501  ? 362 PHE A N   362 PHE A N   1 
ATOM 2808  C CA  . PHE A 1 362 ? 287.299 -61.841 316.739 1.0 73.45501  ? 362 PHE A CA  362 PHE A CA  1 
ATOM 2809  C C   . PHE A 1 362 ? 288.286 -62.657 315.914 1.0 73.45501  ? 362 PHE A C   362 PHE A C   1 
ATOM 2810  O O   . PHE A 1 362 ? 288.184 -62.694 314.686 1.0 73.45501  ? 362 PHE A O   362 PHE A O   1 
ATOM 2811  C CB  . PHE A 1 362 ? 286.234 -62.762 317.353 1.0 73.45501  ? 362 PHE A CB  362 PHE A CB  1 
ATOM 2812  C CG  . PHE A 1 362 ? 285.318 -62.064 318.311 1.0 73.45501  ? 362 PHE A CG  362 PHE A CG  1 
ATOM 2813  C CD1 . PHE A 1 362 ? 285.679 -61.898 319.635 1.0 73.45501  ? 362 PHE A CD1 362 PHE A CD1 1 
ATOM 2814  C CD2 . PHE A 1 362 ? 284.105 -61.550 317.881 1.0 73.45501  ? 362 PHE A CD2 362 PHE A CD2 1 
ATOM 2815  C CE1 . PHE A 1 362 ? 284.839 -61.249 320.520 1.0 73.45501  ? 362 PHE A CE1 362 PHE A CE1 1 
ATOM 2816  C CE2 . PHE A 1 362 ? 283.264 -60.892 318.759 1.0 73.45501  ? 362 PHE A CE2 362 PHE A CE2 1 
ATOM 2817  C CZ  . PHE A 1 362 ? 283.630 -60.745 320.080 1.0 73.45501  ? 362 PHE A CZ  362 PHE A CZ  1 
ATOM 2818  N N   . PRO A 1 363 ? 289.271 -63.304 316.545 1.0 75.97855  ? 363 PRO A N   363 PRO A N   1 
ATOM 2819  C CA  . PRO A 1 363 ? 290.147 -64.198 315.790 1.0 75.97855  ? 363 PRO A CA  363 PRO A CA  1 
ATOM 2820  C C   . PRO A 1 363 ? 289.395 -65.439 315.344 1.0 75.97855  ? 363 PRO A C   363 PRO A C   1 
ATOM 2821  O O   . PRO A 1 363 ? 288.359 -65.794 315.932 1.0 75.97855  ? 363 PRO A O   363 PRO A O   1 
ATOM 2822  C CB  . PRO A 1 363 ? 291.256 -64.542 316.800 1.0 75.97855  ? 363 PRO A CB  363 PRO A CB  1 
ATOM 2823  C CG  . PRO A 1 363 ? 291.246 -63.425 317.754 1.0 75.97855  ? 363 PRO A CG  363 PRO A CG  1 
ATOM 2824  C CD  . PRO A 1 363 ? 289.813 -63.031 317.886 1.0 75.97855  ? 363 PRO A CD  363 PRO A CD  1 
ATOM 2825  N N   . PRO A 1 364 ? 289.857 -66.114 314.280 1.0 76.89196  ? 364 PRO A N   364 PRO A N   1 
ATOM 2826  C CA  . PRO A 1 364 ? 289.138 -67.312 313.803 1.0 76.89196  ? 364 PRO A CA  364 PRO A CA  1 
ATOM 2827  C C   . PRO A 1 364 ? 289.169 -68.466 314.787 1.0 76.89196  ? 364 PRO A C   364 PRO A C   1 
ATOM 2828  O O   . PRO A 1 364 ? 288.120 -69.050 315.081 1.0 76.89196  ? 364 PRO A O   364 PRO A O   1 
ATOM 2829  C CB  . PRO A 1 364 ? 289.868 -67.659 312.500 1.0 76.89196  ? 364 PRO A CB  364 PRO A CB  1 
ATOM 2830  C CG  . PRO A 1 364 ? 290.520 -66.393 312.079 1.0 76.89196  ? 364 PRO A CG  364 PRO A CG  1 
ATOM 2831  C CD  . PRO A 1 364 ? 290.922 -65.715 313.346 1.0 76.89196  ? 364 PRO A CD  364 PRO A CD  1 
ATOM 2832  N N   . HIS A 1 365 ? 290.347 -68.823 315.291 1.0 81.2386   ? 365 HIS A N   365 HIS A N   1 
ATOM 2833  C CA  . HIS A 1 365 ? 290.454 -69.606 316.518 1.0 81.2386   ? 365 HIS A CA  365 HIS A CA  1 
ATOM 2834  C C   . HIS A 1 365 ? 289.893 -68.698 317.603 1.0 81.2386   ? 365 HIS A C   365 HIS A C   1 
ATOM 2835  O O   . HIS A 1 365 ? 290.184 -67.504 317.652 1.0 81.2386   ? 365 HIS A O   365 HIS A O   1 
ATOM 2836  C CB  . HIS A 1 365 ? 291.899 -70.009 316.780 1.0 81.2386   ? 365 HIS A CB  365 HIS A CB  1 
ATOM 2837  C CG  . HIS A 1 365 ? 292.802 -68.842 317.024 1.0 81.2386   ? 365 HIS A CG  365 HIS A CG  1 
ATOM 2838  N ND1 . HIS A 1 365 ? 293.303 -68.064 316.003 1.0 81.2386   ? 365 HIS A ND1 365 HIS A ND1 1 
ATOM 2839  C CD2 . HIS A 1 365 ? 293.248 -68.287 318.175 1.0 81.2386   ? 365 HIS A CD2 365 HIS A CD2 1 
ATOM 2840  C CE1 . HIS A 1 365 ? 294.036 -67.091 316.515 1.0 81.2386   ? 365 HIS A CE1 365 HIS A CE1 1 
ATOM 2841  N NE2 . HIS A 1 365 ? 294.020 -67.205 317.830 1.0 81.2386   ? 365 HIS A NE2 365 HIS A NE2 1 
ATOM 2842  N N   . VAL A 1 366 ? 289.028 -69.234 318.458 1.0 79.90809  ? 366 VAL A N   366 VAL A N   1 
ATOM 2843  C CA  . VAL A 1 366 ? 288.362 -68.343 319.399 1.0 79.90809  ? 366 VAL A CA  366 VAL A CA  1 
ATOM 2844  C C   . VAL A 1 366 ? 289.104 -68.317 320.730 1.0 79.90809  ? 366 VAL A C   366 VAL A C   1 
ATOM 2845  O O   . VAL A 1 366 ? 289.105 -67.300 321.434 1.0 79.90809  ? 366 VAL A O   366 VAL A O   1 
ATOM 2846  C CB  . VAL A 1 366 ? 286.875 -68.722 319.548 1.0 79.90809  ? 366 VAL A CB  366 VAL A CB  1 
ATOM 2847  C CG1 . VAL A 1 366 ? 286.679 -70.062 320.259 1.0 79.90809  ? 366 VAL A CG1 366 VAL A CG1 1 
ATOM 2848  C CG2 . VAL A 1 366 ? 286.103 -67.603 320.224 1.0 79.90809  ? 366 VAL A CG2 366 VAL A CG2 1 
ATOM 2849  N N   . ILE A 1 367 ? 289.792 -69.401 321.075 1.0 82.72097  ? 367 ILE A N   367 ILE A N   1 
ATOM 2850  C CA  . ILE A 1 367 ? 290.496 -69.456 322.350 1.0 82.72097  ? 367 ILE A CA  367 ILE A CA  1 
ATOM 2851  C C   . ILE A 1 367 ? 291.942 -69.019 322.126 1.0 82.72097  ? 367 ILE A C   367 ILE A C   1 
ATOM 2852  O O   . ILE A 1 367 ? 292.603 -69.463 321.183 1.0 82.72097  ? 367 ILE A O   367 ILE A O   1 
ATOM 2853  C CB  . ILE A 1 367 ? 290.397 -70.842 323.001 1.0 82.72097  ? 367 ILE A CB  367 ILE A CB  1 
ATOM 2854  C CG1 . ILE A 1 367 ? 290.908 -71.959 322.097 1.0 82.72097  ? 367 ILE A CG1 367 ILE A CG1 1 
ATOM 2855  C CG2 . ILE A 1 367 ? 288.958 -71.148 323.351 1.0 82.72097  ? 367 ILE A CG2 367 ILE A CG2 1 
ATOM 2856  C CD1 . ILE A 1 367 ? 291.098 -73.243 322.822 1.0 82.72097  ? 367 ILE A CD1 367 ILE A CD1 1 
ATOM 2857  N N   . SER A 1 368 ? 292.410 -68.102 322.970 1.0 85.01443  ? 368 SER A N   368 SER A N   1 
ATOM 2858  C CA  . SER A 1 368 ? 293.749 -67.529 322.905 1.0 85.01443  ? 368 SER A CA  368 SER A CA  1 
ATOM 2859  C C   . SER A 1 368 ? 293.985 -66.711 324.161 1.0 85.01443  ? 368 SER A C   368 SER A C   1 
ATOM 2860  O O   . SER A 1 368 ? 293.055 -66.139 324.735 1.0 85.01443  ? 368 SER A O   368 SER A O   1 
ATOM 2861  C CB  . SER A 1 368 ? 293.941 -66.629 321.676 1.0 85.01443  ? 368 SER A CB  368 SER A CB  1 
ATOM 2862  O OG  . SER A 1 368 ? 293.123 -65.477 321.763 1.0 85.01443  ? 368 SER A OG  368 SER A OG  1 
ATOM 2863  N N   . ASN A 1 369 ? 295.232 -66.660 324.572 1.0 86.02251  ? 369 ASN A N   369 ASN A N   1 
ATOM 2864  C CA  . ASN A 1 369 ? 295.634 -65.575 325.441 1.0 86.02251  ? 369 ASN A CA  369 ASN A CA  1 
ATOM 2865  C C   . ASN A 1 369 ? 295.719 -64.296 324.609 1.0 86.02251  ? 369 ASN A C   369 ASN A C   1 
ATOM 2866  O O   . ASN A 1 369 ? 296.020 -64.354 323.415 1.0 86.02251  ? 369 ASN A O   369 ASN A O   1 
ATOM 2867  C CB  . ASN A 1 369 ? 296.979 -65.885 326.084 1.0 86.02251  ? 369 ASN A CB  369 ASN A CB  1 
ATOM 2868  C CG  . ASN A 1 369 ? 296.915 -67.082 327.001 1.0 86.02251  ? 369 ASN A CG  369 ASN A CG  1 
ATOM 2869  O OD1 . ASN A 1 369 ? 297.508 -68.122 326.724 1.0 86.02251  ? 369 ASN A OD1 369 ASN A OD1 1 
ATOM 2870  N ND2 . ASN A 1 369 ? 296.193 -66.942 328.104 1.0 86.02251  ? 369 ASN A ND2 369 ASN A ND2 1 
ATOM 2871  N N   . PRO A 1 370 ? 295.433 -63.130 325.200 1.0 83.52041  ? 370 PRO A N   370 PRO A N   1 
ATOM 2872  C CA  . PRO A 1 370 ? 295.387 -61.897 324.397 1.0 83.52041  ? 370 PRO A CA  370 PRO A CA  1 
ATOM 2873  C C   . PRO A 1 370 ? 296.740 -61.411 323.892 1.0 83.52041  ? 370 PRO A C   370 PRO A C   1 
ATOM 2874  O O   . PRO A 1 370 ? 296.765 -60.536 323.020 1.0 83.52041  ? 370 PRO A O   370 PRO A O   1 
ATOM 2875  C CB  . PRO A 1 370 ? 294.755 -60.880 325.353 1.0 83.52041  ? 370 PRO A CB  370 PRO A CB  1 
ATOM 2876  C CG  . PRO A 1 370 ? 295.042 -61.404 326.704 1.0 83.52041  ? 370 PRO A CG  370 PRO A CG  1 
ATOM 2877  C CD  . PRO A 1 370 ? 294.997 -62.892 326.587 1.0 83.52041  ? 370 PRO A CD  370 PRO A CD  1 
ATOM 2878  N N   . PHE A 1 371 ? 297.858 -61.939 324.397 1.0 84.84217  ? 371 PHE A N   371 PHE A N   1 
ATOM 2879  C CA  . PHE A 1 371 ? 299.167 -61.573 323.866 1.0 84.84217  ? 371 PHE A CA  371 PHE A CA  1 
ATOM 2880  C C   . PHE A 1 371 ? 300.091 -62.778 323.772 1.0 84.84217  ? 371 PHE A C   371 PHE A C   1 
ATOM 2881  O O   . PHE A 1 371 ? 301.313 -62.637 323.886 1.0 84.84217  ? 371 PHE A O   371 PHE A O   1 
ATOM 2882  C CB  . PHE A 1 371 ? 299.826 -60.488 324.714 1.0 84.84217  ? 371 PHE A CB  371 PHE A CB  1 
ATOM 2883  C CG  . PHE A 1 371 ? 299.116 -59.176 324.663 1.0 84.84217  ? 371 PHE A CG  371 PHE A CG  1 
ATOM 2884  C CD1 . PHE A 1 371 ? 299.271 -58.335 323.574 1.0 84.84217  ? 371 PHE A CD1 371 PHE A CD1 1 
ATOM 2885  C CD2 . PHE A 1 371 ? 298.288 -58.784 325.700 1.0 84.84217  ? 371 PHE A CD2 371 PHE A CD2 1 
ATOM 2886  C CE1 . PHE A 1 371 ? 298.613 -57.122 323.520 1.0 84.84217  ? 371 PHE A CE1 371 PHE A CE1 1 
ATOM 2887  C CE2 . PHE A 1 371 ? 297.629 -57.573 325.656 1.0 84.84217  ? 371 PHE A CE2 371 PHE A CE2 1 
ATOM 2888  C CZ  . PHE A 1 371 ? 297.791 -56.741 324.564 1.0 84.84217  ? 371 PHE A CZ  371 PHE A CZ  1 
ATOM 2889  N N   . ALA A 1 372 ? 299.530 -63.961 323.552 1.0 86.41094  ? 372 ALA A N   372 ALA A N   1 
ATOM 2890  C CA  . ALA A 1 372 ? 300.292 -65.199 323.570 1.0 86.41094  ? 372 ALA A CA  372 ALA A CA  1 
ATOM 2891  C C   . ALA A 1 372 ? 299.501 -66.253 322.811 1.0 86.41094  ? 372 ALA A C   372 ALA A C   1 
ATOM 2892  O O   . ALA A 1 372 ? 298.293 -66.091 322.604 1.0 86.41094  ? 372 ALA A O   372 ALA A O   1 
ATOM 2893  C CB  . ALA A 1 372 ? 300.566 -65.657 325.014 1.0 86.41094  ? 372 ALA A CB  372 ALA A CB  1 
ATOM 2894  N N   . PRO A 1 373 ? 300.147 -67.331 322.368 1.0 88.51444  ? 373 PRO A N   373 PRO A N   1 
ATOM 2895  C CA  . PRO A 1 373 ? 299.391 -68.482 321.861 1.0 88.51444  ? 373 PRO A CA  373 PRO A CA  1 
ATOM 2896  C C   . PRO A 1 373 ? 298.615 -69.172 322.973 1.0 88.51444  ? 373 PRO A C   373 PRO A C   1 
ATOM 2897  O O   . PRO A 1 373 ? 298.769 -68.883 324.162 1.0 88.51444  ? 373 PRO A O   373 PRO A O   1 
ATOM 2898  C CB  . PRO A 1 373 ? 300.474 -69.398 321.286 1.0 88.51444  ? 373 PRO A CB  373 PRO A CB  1 
ATOM 2899  C CG  . PRO A 1 373 ? 301.596 -68.486 320.959 1.0 88.51444  ? 373 PRO A CG  373 PRO A CG  1 
ATOM 2900  C CD  . PRO A 1 373 ? 301.578 -67.436 322.026 1.0 88.51444  ? 373 PRO A CD  373 PRO A CD  1 
ATOM 2901  N N   . ALA A 1 374 ? 297.762 -70.107 322.556 1.0 88.48094  ? 374 ALA A N   374 ALA A N   1 
ATOM 2902  C CA  . ALA A 1 374 ? 296.924 -70.852 323.489 1.0 88.48094  ? 374 ALA A CA  374 ALA A CA  1 
ATOM 2903  C C   . ALA A 1 374 ? 297.791 -71.737 324.373 1.0 88.48094  ? 374 ALA A C   374 ALA A C   1 
ATOM 2904  O O   . ALA A 1 374 ? 298.512 -72.608 323.877 1.0 88.48094  ? 374 ALA A O   374 ALA A O   1 
ATOM 2905  C CB  . ALA A 1 374 ? 295.900 -71.688 322.727 1.0 88.48094  ? 374 ALA A CB  374 ALA A CB  1 
ATOM 2906  N N   . ALA A 1 375 ? 297.732 -71.495 325.679 1.0 90.0969   ? 375 ALA A N   375 ALA A N   1 
ATOM 2907  C CA  . ALA A 1 375 ? 298.629 -72.152 326.619 1.0 90.0969   ? 375 ALA A CA  375 ALA A CA  1 
ATOM 2908  C C   . ALA A 1 375 ? 298.237 -73.613 326.790 1.0 90.0969   ? 375 ALA A C   375 ALA A C   1 
ATOM 2909  O O   . ALA A 1 375 ? 297.125 -73.918 327.232 1.0 90.0969   ? 375 ALA A O   375 ALA A O   1 
ATOM 2910  C CB  . ALA A 1 375 ? 298.602 -71.427 327.960 1.0 90.0969   ? 375 ALA A CB  375 ALA A CB  1 
ATOM 2911  N N   . VAL A 1 376 ? 299.153 -74.515 326.440 1.0 91.2356   ? 376 VAL A N   376 VAL A N   1 
ATOM 2912  C CA  . VAL A 1 376 ? 298.920 -75.949 326.569 1.0 91.2356   ? 376 VAL A CA  376 VAL A CA  1 
ATOM 2913  C C   . VAL A 1 376 ? 299.030 -76.346 328.032 1.0 91.2356   ? 376 VAL A C   376 VAL A C   1 
ATOM 2914  O O   . VAL A 1 376 ? 299.506 -75.568 328.866 1.0 91.2356   ? 376 VAL A O   376 VAL A O   1 
ATOM 2915  C CB  . VAL A 1 376 ? 299.909 -76.758 325.714 1.0 91.2356   ? 376 VAL A CB  376 VAL A CB  1 
ATOM 2916  C CG1 . VAL A 1 376 ? 299.753 -76.400 324.247 1.0 91.2356   ? 376 VAL A CG1 376 VAL A CG1 1 
ATOM 2917  C CG2 . VAL A 1 376 ? 301.332 -76.517 326.188 1.0 91.2356   ? 376 VAL A CG2 376 VAL A CG2 1 
ATOM 2918  N N   . GLY A 1 377 ? 298.594 -77.555 328.353 1.0 91.80875  ? 377 GLY A N   377 GLY A N   1 
ATOM 2919  C CA  . GLY A 1 377 ? 298.694 -78.021 329.718 1.0 91.80875  ? 377 GLY A CA  377 GLY A CA  1 
ATOM 2920  C C   . GLY A 1 377 ? 298.251 -79.457 329.848 1.0 91.80875  ? 377 GLY A C   377 GLY A C   1 
ATOM 2921  O O   . GLY A 1 377 ? 298.316 -80.232 328.894 1.0 91.80875  ? 377 GLY A O   377 GLY A O   1 
ATOM 2922  N N   . THR A 1 378 ? 297.804 -79.807 331.052 1.0 94.7314   ? 378 THR A N   378 THR A N   1 
ATOM 2923  C CA  . THR A 1 378 ? 297.428 -81.173 331.380 1.0 94.7314   ? 378 THR A CA  378 THR A CA  1 
ATOM 2924  C C   . THR A 1 378 ? 296.226 -81.124 332.312 1.0 94.7314   ? 378 THR A C   378 THR A C   1 
ATOM 2925  O O   . THR A 1 378 ? 296.121 -80.218 333.141 1.0 94.7314   ? 378 THR A O   378 THR A O   1 
ATOM 2926  C CB  . THR A 1 378 ? 298.603 -81.922 332.045 1.0 94.7314   ? 378 THR A CB  378 THR A CB  1 
ATOM 2927  O OG1 . THR A 1 378 ? 299.778 -81.784 331.238 1.0 94.7314   ? 378 THR A OG1 378 THR A OG1 1 
ATOM 2928  C CG2 . THR A 1 378 ? 298.314 -83.408 332.178 1.0 94.7314   ? 378 THR A CG2 378 THR A CG2 1 
ATOM 2929  N N   . GLY A 1 379 ? 295.310 -82.078 332.158 1.0 95.60198  ? 379 GLY A N   379 GLY A N   1 
ATOM 2930  C CA  . GLY A 1 379 ? 294.225 -82.214 333.109 1.0 95.60198  ? 379 GLY A CA  379 GLY A CA  1 
ATOM 2931  C C   . GLY A 1 379 ? 294.718 -82.657 334.473 1.0 95.60198  ? 379 GLY A C   379 GLY A C   1 
ATOM 2932  O O   . GLY A 1 379 ? 295.828 -83.163 334.630 1.0 95.60198  ? 379 GLY A O   379 GLY A O   1 
ATOM 2933  N N   . MET A 1 380 ? 293.880 -82.448 335.483 1.0 98.07138  ? 380 MET A N   380 MET A N   1 
ATOM 2934  C CA  . MET A 1 380 ? 294.228 -82.794 336.852 1.0 98.07138  ? 380 MET A CA  380 MET A CA  1 
ATOM 2935  C C   . MET A 1 380 ? 293.095 -83.580 337.492 1.0 98.07138  ? 380 MET A C   380 MET A C   1 
ATOM 2936  O O   . MET A 1 380 ? 291.921 -83.239 337.325 1.0 98.07138  ? 380 MET A O   380 MET A O   1 
ATOM 2937  C CB  . MET A 1 380 ? 294.516 -81.546 337.690 1.0 98.07138  ? 380 MET A CB  380 MET A CB  1 
ATOM 2938  C CG  . MET A 1 380 ? 295.716 -80.746 337.236 1.0 98.07138  ? 380 MET A CG  380 MET A CG  1 
ATOM 2939  S SD  . MET A 1 380 ? 297.231 -81.705 337.282 1.0 98.07138  ? 380 MET A SD  380 MET A SD  1 
ATOM 2940  C CE  . MET A 1 380 ? 297.406 -81.891 339.047 1.0 98.07138  ? 380 MET A CE  380 MET A CE  1 
ATOM 2941  N N   . THR A 1 381 ? 293.452 -84.632 338.220 1.0 101.10339 ? 381 THR A N   381 THR A N   1 
ATOM 2942  C CA  . THR A 1 381 ? 292.520 -85.345 339.082 1.0 101.10339 ? 381 THR A CA  381 THR A CA  1 
ATOM 2943  C C   . THR A 1 381 ? 292.844 -84.976 340.523 1.0 101.10339 ? 381 THR A C   381 THR A C   1 
ATOM 2944  O O   . THR A 1 381 ? 293.978 -84.593 340.830 1.0 101.10339 ? 381 THR A O   381 THR A O   1 
ATOM 2945  C CB  . THR A 1 381 ? 292.580 -86.859 338.857 1.0 101.10339 ? 381 THR A CB  381 THR A CB  1 
ATOM 2946  O OG1 . THR A 1 381 ? 291.589 -87.508 339.665 1.0 101.10339 ? 381 THR A OG1 381 THR A OG1 1 
ATOM 2947  C CG2 . THR A 1 381 ? 293.951 -87.421 339.182 1.0 101.10339 ? 381 THR A CG2 381 THR A CG2 1 
ATOM 2948  N N   . VAL A 1 382 ? 291.845 -85.044 341.391 1.0 105.17876 ? 382 VAL A N   382 VAL A N   1 
ATOM 2949  C CA  . VAL A 1 382 ? 291.954 -84.509 342.741 1.0 105.17876 ? 382 VAL A CA  382 VAL A CA  1 
ATOM 2950  C C   . VAL A 1 382 ? 291.589 -85.605 343.735 1.0 105.17876 ? 382 VAL A C   382 VAL A C   1 
ATOM 2951  O O   . VAL A 1 382 ? 290.801 -86.508 343.424 1.0 105.17876 ? 382 VAL A O   382 VAL A O   1 
ATOM 2952  C CB  . VAL A 1 382 ? 291.071 -83.253 342.900 1.0 105.17876 ? 382 VAL A CB  382 VAL A CB  1 
ATOM 2953  C CG1 . VAL A 1 382 ? 289.581 -83.586 342.829 1.0 105.17876 ? 382 VAL A CG1 382 VAL A CG1 1 
ATOM 2954  C CG2 . VAL A 1 382 ? 291.414 -82.459 344.155 1.0 105.17876 ? 382 VAL A CG2 382 VAL A CG2 1 
ATOM 2955  N N   . ASN A 1 383 ? 292.219 -85.569 344.904 1.0 111.30985 ? 383 ASN A N   383 ASN A N   1 
ATOM 2956  C CA  . ASN A 1 383 ? 291.864 -86.423 346.025 1.0 111.30985 ? 383 ASN A CA  383 ASN A CA  1 
ATOM 2957  C C   . ASN A 1 383 ? 291.229 -85.545 347.093 1.0 111.30985 ? 383 ASN A C   383 ASN A C   1 
ATOM 2958  O O   . ASN A 1 383 ? 291.719 -84.446 347.366 1.0 111.30985 ? 383 ASN A O   383 ASN A O   1 
ATOM 2959  C CB  . ASN A 1 383 ? 293.104 -87.129 346.578 1.0 111.30985 ? 383 ASN A CB  383 ASN A CB  1 
ATOM 2960  C CG  . ASN A 1 383 ? 292.783 -88.446 347.265 1.0 111.30985 ? 383 ASN A CG  383 ASN A CG  1 
ATOM 2961  O OD1 . ASN A 1 383 ? 293.680 -89.240 347.545 1.0 111.30985 ? 383 ASN A OD1 383 ASN A OD1 1 
ATOM 2962  N ND2 . ASN A 1 383 ? 291.507 -88.698 347.517 1.0 111.30985 ? 383 ASN A ND2 383 ASN A ND2 1 
ATOM 2963  N N   . GLU A 1 384 ? 290.124 -86.004 347.664 1.0 112.76349 ? 384 GLU A N   384 GLU A N   1 
ATOM 2964  C CA  . GLU A 1 384 ? 289.617 -85.344 348.851 1.0 112.76349 ? 384 GLU A CA  384 GLU A CA  1 
ATOM 2965  C C   . GLU A 1 384 ? 290.241 -85.980 350.088 1.0 112.76349 ? 384 GLU A C   384 GLU A C   1 
ATOM 2966  O O   . GLU A 1 384 ? 290.923 -87.006 350.003 1.0 112.76349 ? 384 GLU A O   384 GLU A O   1 
ATOM 2967  C CB  . GLU A 1 384 ? 288.092 -85.416 348.904 1.0 112.76349 ? 384 GLU A CB  384 GLU A CB  1 
ATOM 2968  C CG  . GLU A 1 384 ? 287.409 -84.660 347.771 1.0 112.76349 ? 384 GLU A CG  384 GLU A CG  1 
ATOM 2969  C CD  . GLU A 1 384 ? 287.614 -83.159 347.855 1.0 112.76349 ? 384 GLU A CD  384 GLU A CD  1 
ATOM 2970  O OE1 . GLU A 1 384 ? 287.690 -82.627 348.982 1.0 112.76349 ? 384 GLU A OE1 384 GLU A OE1 1 
ATOM 2971  O OE2 . GLU A 1 384 ? 287.702 -82.510 346.792 1.0 112.76349 ? 384 GLU A OE2 384 GLU A OE2 1 
ATOM 2972  N N   . GLN A 1 385 ? 290.055 -85.312 351.230 1.0 115.61263 ? 385 GLN A N   385 GLN A N   1 
ATOM 2973  C CA  . GLN A 1 385 ? 290.556 -85.600 352.586 1.0 115.61263 ? 385 GLN A CA  385 GLN A CA  1 
ATOM 2974  C C   . GLN A 1 385 ? 292.060 -85.351 352.718 1.0 115.61263 ? 385 GLN A C   385 GLN A C   1 
ATOM 2975  O O   . GLN A 1 385 ? 292.584 -85.432 353.837 1.0 115.61263 ? 385 GLN A O   385 GLN A O   1 
ATOM 2976  C CB  . GLN A 1 385 ? 290.241 -87.023 353.082 1.0 115.61263 ? 385 GLN A CB  385 GLN A CB  1 
ATOM 2977  C CG  . GLN A 1 385 ? 288.762 -87.295 353.291 1.0 115.61263 ? 385 GLN A CG  385 GLN A CG  1 
ATOM 2978  C CD  . GLN A 1 385 ? 288.495 -88.711 353.760 1.0 115.61263 ? 385 GLN A CD  385 GLN A CD  1 
ATOM 2979  O OE1 . GLN A 1 385 ? 289.415 -89.522 353.873 1.0 115.61263 ? 385 GLN A OE1 385 GLN A OE1 1 
ATOM 2980  N NE2 . GLN A 1 385 ? 287.232 -89.017 354.035 1.0 115.61263 ? 385 GLN A NE2 385 GLN A NE2 1 
ATOM 2981  N N   . GLN A 1 386 ? 292.765 -85.050 351.630 1.0 113.95994 ? 386 GLN A N   386 GLN A N   1 
ATOM 2982  C CA  . GLN A 1 386 ? 294.122 -84.524 351.649 1.0 113.95994 ? 386 GLN A CA  386 GLN A CA  1 
ATOM 2983  C C   . GLN A 1 386 ? 294.312 -83.718 350.374 1.0 113.95994 ? 386 GLN A C   386 GLN A C   1 
ATOM 2984  O O   . GLN A 1 386 ? 293.762 -84.066 349.328 1.0 113.95994 ? 386 GLN A O   386 GLN A O   1 
ATOM 2985  C CB  . GLN A 1 386 ? 295.181 -85.636 351.776 1.0 113.95994 ? 386 GLN A CB  386 GLN A CB  1 
ATOM 2986  C CG  . GLN A 1 386 ? 295.366 -86.559 350.576 1.0 113.95994 ? 386 GLN A CG  386 GLN A CG  1 
ATOM 2987  C CD  . GLN A 1 386 ? 294.449 -87.765 350.603 1.0 113.95994 ? 386 GLN A CD  386 GLN A CD  1 
ATOM 2988  O OE1 . GLN A 1 386 ? 293.452 -87.789 351.321 1.0 113.95994 ? 386 GLN A OE1 386 GLN A OE1 1 
ATOM 2989  N NE2 . GLN A 1 386 ? 294.792 -88.782 349.824 1.0 113.95994 ? 386 GLN A NE2 386 GLN A NE2 1 
ATOM 2990  N N   . GLN A 1 387 ? 295.064 -82.623 350.472 1.0 112.52357 ? 387 GLN A N   387 GLN A N   1 
ATOM 2991  C CA  . GLN A 1 387 ? 295.139 -81.643 349.387 1.0 112.52357 ? 387 GLN A CA  387 GLN A CA  1 
ATOM 2992  C C   . GLN A 1 387 ? 296.220 -82.060 348.389 1.0 112.52357 ? 387 GLN A C   387 GLN A C   1 
ATOM 2993  O O   . GLN A 1 387 ? 297.250 -81.405 348.212 1.0 112.52357 ? 387 GLN A O   387 GLN A O   1 
ATOM 2994  C CB  . GLN A 1 387 ? 295.392 -80.246 349.942 1.0 112.52357 ? 387 GLN A CB  387 GLN A CB  1 
ATOM 2995  C CG  . GLN A 1 387 ? 294.175 -79.568 350.575 1.0 112.52357 ? 387 GLN A CG  387 GLN A CG  1 
ATOM 2996  C CD  . GLN A 1 387 ? 293.778 -80.162 351.917 1.0 112.52357 ? 387 GLN A CD  387 GLN A CD  1 
ATOM 2997  O OE1 . GLN A 1 387 ? 292.672 -80.678 352.076 1.0 112.52357 ? 387 GLN A OE1 387 GLN A OE1 1 
ATOM 2998  N NE2 . GLN A 1 387 ? 294.684 -80.096 352.888 1.0 112.52357 ? 387 GLN A NE2 387 GLN A NE2 1 
ATOM 2999  N N   . THR A 1 388 ? 295.959 -83.176 347.717 1.0 109.67712 ? 388 THR A N   388 THR A N   1 
ATOM 3000  C CA  . THR A 1 388 ? 296.874 -83.745 346.738 1.0 109.67712 ? 388 THR A CA  388 THR A CA  1 
ATOM 3001  C C   . THR A 1 388 ? 296.263 -83.605 345.352 1.0 109.67712 ? 388 THR A C   388 THR A C   1 
ATOM 3002  O O   . THR A 1 388 ? 295.189 -84.155 345.085 1.0 109.67712 ? 388 THR A O   388 THR A O   1 
ATOM 3003  C CB  . THR A 1 388 ? 297.168 -85.214 347.043 1.0 109.67712 ? 388 THR A CB  388 THR A CB  1 
ATOM 3004  O OG1 . THR A 1 388 ? 297.788 -85.324 348.331 1.0 109.67712 ? 388 THR A OG1 388 THR A OG1 1 
ATOM 3005  C CG2 . THR A 1 388 ? 298.092 -85.797 345.989 1.0 109.67712 ? 388 THR A CG2 388 THR A CG2 1 
ATOM 3006  N N   . ALA A 1 389 ? 296.945 -82.874 344.479 1.0 103.87481 ? 389 ALA A N   389 ALA A N   1 
ATOM 3007  C CA  . ALA A 1 389 ? 296.503 -82.669 343.104 1.0 103.87481 ? 389 ALA A CA  389 ALA A CA  1 
ATOM 3008  C C   . ALA A 1 389 ? 297.342 -83.572 342.210 1.0 103.87481 ? 389 ALA A C   389 ALA A C   1 
ATOM 3009  O O   . ALA A 1 389 ? 298.497 -83.264 341.906 1.0 103.87481 ? 389 ALA A O   389 ALA A O   1 
ATOM 3010  C CB  . ALA A 1 389 ? 296.634 -81.204 342.708 1.0 103.87481 ? 389 ALA A CB  389 ALA A CB  1 
ATOM 3011  N N   . ALA A 1 390 ? 296.763 -84.692 341.793 1.0 101.99693 ? 390 ALA A N   390 ALA A N   1 
ATOM 3012  C CA  . ALA A 1 390 ? 297.485 -85.679 341.007 1.0 101.99693 ? 390 ALA A CA  390 ALA A CA  1 
ATOM 3013  C C   . ALA A 1 390 ? 297.317 -85.410 339.518 1.0 101.99693 ? 390 ALA A C   390 ALA A C   1 
ATOM 3014  O O   . ALA A 1 390 ? 296.244 -85.006 339.063 1.0 101.99693 ? 390 ALA A O   390 ALA A O   1 
ATOM 3015  C CB  . ALA A 1 390 ? 297.002 -87.090 341.343 1.0 101.99693 ? 390 ALA A CB  390 ALA A CB  1 
ATOM 3016  N N   . VAL A 1 391 ? 298.391 -85.634 338.762 1.0 100.48147 ? 391 VAL A N   391 VAL A N   1 
ATOM 3017  C CA  . VAL A 1 391 ? 298.333 -85.486 337.314 1.0 100.48147 ? 391 VAL A CA  391 VAL A CA  1 
ATOM 3018  C C   . VAL A 1 391 ? 297.592 -86.681 336.716 1.0 100.48147 ? 391 VAL A C   391 VAL A C   1 
ATOM 3019  O O   . VAL A 1 391 ? 297.671 -87.807 337.227 1.0 100.48147 ? 391 VAL A O   391 VAL A O   1 
ATOM 3020  C CB  . VAL A 1 391 ? 299.759 -85.314 336.751 1.0 100.48147 ? 391 VAL A CB  391 VAL A CB  1 
ATOM 3021  C CG1 . VAL A 1 391 ? 300.630 -86.547 337.001 1.0 100.48147 ? 391 VAL A CG1 391 VAL A CG1 1 
ATOM 3022  C CG2 . VAL A 1 391 ? 299.747 -84.934 335.275 1.0 100.48147 ? 391 VAL A CG2 391 VAL A CG2 1 
ATOM 3023  N N   . THR A 1 392 ? 296.812 -86.430 335.668 1.0 98.18292  ? 392 THR A N   392 THR A N   1 
ATOM 3024  C CA  . THR A 1 392 ? 296.036 -87.487 335.039 1.0 98.18292  ? 392 THR A CA  392 THR A CA  1 
ATOM 3025  C C   . THR A 1 392 ? 296.873 -88.208 333.982 1.0 98.18292  ? 392 THR A C   392 THR A C   1 
ATOM 3026  O O   . THR A 1 392 ? 298.019 -87.850 333.706 1.0 98.18292  ? 392 THR A O   392 THR A O   1 
ATOM 3027  C CB  . THR A 1 392 ? 294.755 -86.926 334.426 1.0 98.18292  ? 392 THR A CB  392 THR A CB  1 
ATOM 3028  O OG1 . THR A 1 392 ? 293.921 -88.007 333.994 1.0 98.18292  ? 392 THR A OG1 392 THR A OG1 1 
ATOM 3029  C CG2 . THR A 1 392 ? 295.079 -86.054 333.242 1.0 98.18292  ? 392 THR A CG2 392 THR A CG2 1 
ATOM 3030  N N   . ALA A 1 393 ? 296.275 -89.239 333.381 1.0 97.96158  ? 393 ALA A N   393 ALA A N   1 
ATOM 3031  C CA  . ALA A 1 393 ? 297.051 -90.191 332.585 1.0 97.96158  ? 393 ALA A CA  393 ALA A CA  1 
ATOM 3032  C C   . ALA A 1 393 ? 297.328 -89.685 331.171 1.0 97.96158  ? 393 ALA A C   393 ALA A C   1 
ATOM 3033  O O   . ALA A 1 393 ? 298.480 -89.436 330.803 1.0 97.96158  ? 393 ALA A O   393 ALA A O   1 
ATOM 3034  C CB  . ALA A 1 393 ? 296.325 -91.539 332.543 1.0 97.96158  ? 393 ALA A CB  393 ALA A CB  1 
ATOM 3035  N N   . ASN A 1 394 ? 296.281 -89.519 330.366 1.0 96.73912  ? 394 ASN A N   394 ASN A N   1 
ATOM 3036  C CA  . ASN A 1 394 ? 296.424 -89.244 328.935 1.0 96.73912  ? 394 ASN A CA  394 ASN A CA  1 
ATOM 3037  C C   . ASN A 1 394 ? 295.617 -87.996 328.603 1.0 96.73912  ? 394 ASN A C   394 ASN A C   1 
ATOM 3038  O O   . ASN A 1 394 ? 294.443 -88.095 328.240 1.0 96.73912  ? 394 ASN A O   394 ASN A O   1 
ATOM 3039  C CB  . ASN A 1 394 ? 295.967 -90.438 328.110 1.0 96.73912  ? 394 ASN A CB  394 ASN A CB  1 
ATOM 3040  C CG  . ASN A 1 394 ? 296.803 -91.668 328.357 1.0 96.73912  ? 394 ASN A CG  394 ASN A CG  1 
ATOM 3041  O OD1 . ASN A 1 394 ? 296.316 -92.666 328.886 1.0 96.73912  ? 394 ASN A OD1 394 ASN A OD1 1 
ATOM 3042  N ND2 . ASN A 1 394 ? 298.072 -91.607 327.974 1.0 96.73912  ? 394 ASN A ND2 394 ASN A ND2 1 
ATOM 3043  N N   . THR A 1 395 ? 296.243 -86.826 328.731 1.0 93.86778  ? 395 THR A N   395 THR A N   1 
ATOM 3044  C CA  . THR A 1 395 ? 295.560 -85.563 328.478 1.0 93.86778  ? 395 THR A CA  395 THR A CA  1 
ATOM 3045  C C   . THR A 1 395 ? 296.578 -84.474 328.182 1.0 93.86778  ? 395 THR A C   395 THR A C   1 
ATOM 3046  O O   . THR A 1 395 ? 297.492 -84.248 328.980 1.0 93.86778  ? 395 THR A O   395 THR A O   1 
ATOM 3047  C CB  . THR A 1 395 ? 294.703 -85.134 329.676 1.0 93.86778  ? 395 THR A CB  395 THR A CB  1 
ATOM 3048  O OG1 . THR A 1 395 ? 293.641 -86.070 329.894 1.0 93.86778  ? 395 THR A OG1 395 THR A OG1 1 
ATOM 3049  C CG2 . THR A 1 395 ? 294.122 -83.762 329.450 1.0 93.86778  ? 395 THR A CG2 395 THR A CG2 1 
ATOM 3050  N N   . VAL A 1 396 ? 296.418 -83.806 327.042 1.0 92.18253  ? 396 VAL A N   396 VAL A N   1 
ATOM 3051  C CA  . VAL A 1 396 ? 296.978 -82.480 326.823 1.0 92.18253  ? 396 VAL A CA  396 VAL A CA  1 
ATOM 3052  C C   . VAL A 1 396 ? 295.803 -81.533 326.600 1.0 92.18253  ? 396 VAL A C   396 VAL A C   1 
ATOM 3053  O O   . VAL A 1 396 ? 294.791 -81.916 326.003 1.0 92.18253  ? 396 VAL A O   396 VAL A O   1 
ATOM 3054  C CB  . VAL A 1 396 ? 298.000 -82.463 325.658 1.0 92.18253  ? 396 VAL A CB  396 VAL A CB  1 
ATOM 3055  C CG1 . VAL A 1 396 ? 297.370 -82.817 324.317 1.0 92.18253  ? 396 VAL A CG1 396 VAL A CG1 1 
ATOM 3056  C CG2 . VAL A 1 396 ? 298.747 -81.131 325.590 1.0 92.18253  ? 396 VAL A CG2 396 VAL A CG2 1 
ATOM 3057  N N   . ALA A 1 397 ? 295.899 -80.325 327.150 1.0 90.25029  ? 397 ALA A N   397 ALA A N   1 
ATOM 3058  C CA  . ALA A 1 397 ? 294.754 -79.425 327.204 1.0 90.25029  ? 397 ALA A CA  397 ALA A CA  1 
ATOM 3059  C C   . ALA A 1 397 ? 295.173 -78.029 326.782 1.0 90.25029  ? 397 ALA A C   397 ALA A C   1 
ATOM 3060  O O   . ALA A 1 397 ? 296.034 -77.419 327.421 1.0 90.25029  ? 397 ALA A O   397 ALA A O   1 
ATOM 3061  C CB  . ALA A 1 397 ? 294.148 -79.394 328.609 1.0 90.25029  ? 397 ALA A CB  397 ALA A CB  1 
ATOM 3062  N N   . LEU A 1 398 ? 294.557 -77.524 325.716 1.0 89.16045  ? 398 LEU A N   398 LEU A N   1 
ATOM 3063  C CA  . LEU A 1 398 ? 294.772 -76.155 325.266 1.0 89.16045  ? 398 LEU A CA  398 LEU A CA  1 
ATOM 3064  C C   . LEU A 1 398 ? 293.826 -75.240 326.030 1.0 89.16045  ? 398 LEU A C   398 LEU A C   1 
ATOM 3065  O O   . LEU A 1 398 ? 292.607 -75.303 325.841 1.0 89.16045  ? 398 LEU A O   398 LEU A O   1 
ATOM 3066  C CB  . LEU A 1 398 ? 294.540 -76.021 323.761 1.0 89.16045  ? 398 LEU A CB  398 LEU A CB  1 
ATOM 3067  C CG  . LEU A 1 398 ? 295.642 -76.450 322.784 1.0 89.16045  ? 398 LEU A CG  398 LEU A CG  1 
ATOM 3068  C CD1 . LEU A 1 398 ? 295.749 -77.968 322.628 1.0 89.16045  ? 398 LEU A CD1 398 LEU A CD1 1 
ATOM 3069  C CD2 . LEU A 1 398 ? 295.441 -75.782 321.430 1.0 89.16045  ? 398 LEU A CD2 398 LEU A CD2 1 
ATOM 3070  N N   . ILE A 1 399 ? 294.383 -74.389 326.884 1.0 87.91373  ? 399 ILE A N   399 ILE A N   1 
ATOM 3071  C CA  . ILE A 1 399 ? 293.596 -73.563 327.788 1.0 87.91373  ? 399 ILE A CA  399 ILE A CA  1 
ATOM 3072  C C   . ILE A 1 399 ? 293.755 -72.113 327.365 1.0 87.91373  ? 399 ILE A C   399 ILE A C   1 
ATOM 3073  O O   . ILE A 1 399 ? 294.881 -71.629 327.200 1.0 87.91373  ? 399 ILE A O   399 ILE A O   1 
ATOM 3074  C CB  . ILE A 1 399 ? 294.024 -73.754 329.249 1.0 87.91373  ? 399 ILE A CB  399 ILE A CB  1 
ATOM 3075  C CG1 . ILE A 1 399 ? 294.011 -75.238 329.613 1.0 87.91373  ? 399 ILE A CG1 399 ILE A CG1 1 
ATOM 3076  C CG2 . ILE A 1 399 ? 293.109 -72.979 330.171 1.0 87.91373  ? 399 ILE A CG2 399 ILE A CG2 1 
ATOM 3077  C CD1 . ILE A 1 399 ? 292.668 -75.895 329.456 1.0 87.91373  ? 399 ILE A CD1 399 ILE A CD1 1 
ATOM 3078  N N   . GLY A 1 400 ? 292.632 -71.425 327.179 1.0 86.16856  ? 400 GLY A N   400 GLY A N   1 
ATOM 3079  C CA  . GLY A 1 400 ? 292.633 -69.996 326.938 1.0 86.16856  ? 400 GLY A CA  400 GLY A CA  1 
ATOM 3080  C C   . GLY A 1 400 ? 292.185 -69.268 328.191 1.0 86.16856  ? 400 GLY A C   400 GLY A C   1 
ATOM 3081  O O   . GLY A 1 400 ? 291.159 -69.604 328.785 1.0 86.16856  ? 400 GLY A O   400 GLY A O   1 
ATOM 3082  N N   . TYR A 1 401 ? 292.966 -68.271 328.584 1.0 87.84305  ? 401 TYR A N   401 TYR A N   1 
ATOM 3083  C CA  . TYR A 1 401 ? 292.707 -67.532 329.807 1.0 87.84305  ? 401 TYR A CA  401 TYR A CA  1 
ATOM 3084  C C   . TYR A 1 401 ? 292.182 -66.140 329.501 1.0 87.84305  ? 401 TYR A C   401 TYR A C   1 
ATOM 3085  O O   . TYR A 1 401 ? 292.369 -65.602 328.407 1.0 87.84305  ? 401 TYR A O   401 TYR A O   1 
ATOM 3086  C CB  . TYR A 1 401 ? 293.969 -67.422 330.662 1.0 87.84305  ? 401 TYR A CB  401 TYR A CB  1 
ATOM 3087  C CG  . TYR A 1 401 ? 294.388 -68.719 331.292 1.0 87.84305  ? 401 TYR A CG  401 TYR A CG  1 
ATOM 3088  C CD1 . TYR A 1 401 ? 293.759 -69.185 332.436 1.0 87.84305  ? 401 TYR A CD1 401 TYR A CD1 1 
ATOM 3089  C CD2 . TYR A 1 401 ? 295.414 -69.476 330.747 1.0 87.84305  ? 401 TYR A CD2 401 TYR A CD2 1 
ATOM 3090  C CE1 . TYR A 1 401 ? 294.137 -70.370 333.019 1.0 87.84305  ? 401 TYR A CE1 401 TYR A CE1 1 
ATOM 3091  C CE2 . TYR A 1 401 ? 295.802 -70.665 331.325 1.0 87.84305  ? 401 TYR A CE2 401 TYR A CE2 1 
ATOM 3092  C CZ  . TYR A 1 401 ? 295.158 -71.104 332.462 1.0 87.84305  ? 401 TYR A CZ  401 TYR A CZ  1 
ATOM 3093  O OH  . TYR A 1 401 ? 295.531 -72.287 333.049 1.0 87.84305  ? 401 TYR A OH  401 TYR A OH  1 
ATOM 3094  N N   . GLY A 1 402 ? 291.531 -65.561 330.500 1.0 83.99095  ? 402 GLY A N   402 GLY A N   1 
ATOM 3095  C CA  . GLY A 1 402 ? 290.975 -64.241 330.360 1.0 83.99095  ? 402 GLY A CA  402 GLY A CA  1 
ATOM 3096  C C   . GLY A 1 402 ? 289.774 -64.234 329.433 1.0 83.99095  ? 402 GLY A C   402 GLY A C   1 
ATOM 3097  O O   . GLY A 1 402 ? 289.137 -65.251 329.171 1.0 83.99095  ? 402 GLY A O   402 GLY A O   1 
ATOM 3098  N N   . ASN A 1 403 ? 289.480 -63.043 328.930 1.0 81.61181  ? 403 ASN A N   403 ASN A N   1 
ATOM 3099  C CA  . ASN A 1 403 ? 288.376 -62.872 328.006 1.0 81.61181  ? 403 ASN A CA  403 ASN A CA  1 
ATOM 3100  C C   . ASN A 1 403 ? 288.909 -62.849 326.576 1.0 81.61181  ? 403 ASN A C   403 ASN A C   1 
ATOM 3101  O O   . ASN A 1 403 ? 290.106 -62.667 326.338 1.0 81.61181  ? 403 ASN A O   403 ASN A O   1 
ATOM 3102  C CB  . ASN A 1 403 ? 287.619 -61.587 328.338 1.0 81.61181  ? 403 ASN A CB  403 ASN A CB  1 
ATOM 3103  C CG  . ASN A 1 403 ? 286.206 -61.588 327.810 1.0 81.61181  ? 403 ASN A CG  403 ASN A CG  1 
ATOM 3104  O OD1 . ASN A 1 403 ? 285.782 -62.533 327.144 1.0 81.61181  ? 403 ASN A OD1 403 ASN A OD1 1 
ATOM 3105  N ND2 . ASN A 1 403 ? 285.455 -60.546 328.131 1.0 81.61181  ? 403 ASN A ND2 403 ASN A ND2 1 
ATOM 3106  N N   . ILE A 1 404 ? 288.006 -63.047 325.623 1.0 78.24447  ? 404 ILE A N   404 ILE A N   1 
ATOM 3107  C CA  . ILE A 1 404 ? 288.398 -63.218 324.218 1.0 78.24447  ? 404 ILE A CA  404 ILE A CA  1 
ATOM 3108  C C   . ILE A 1 404 ? 288.863 -61.880 323.655 1.0 78.24447  ? 404 ILE A C   404 ILE A C   1 
ATOM 3109  O O   . ILE A 1 404 ? 288.128 -60.883 323.757 1.0 78.24447  ? 404 ILE A O   404 ILE A O   1 
ATOM 3110  C CB  . ILE A 1 404 ? 287.229 -63.769 323.409 1.0 78.24447  ? 404 ILE A CB  404 ILE A CB  1 
ATOM 3111  C CG1 . ILE A 1 404 ? 286.747 -65.084 324.002 1.0 78.24447  ? 404 ILE A CG1 404 ILE A CG1 1 
ATOM 3112  C CG2 . ILE A 1 404 ? 287.632 -63.996 321.967 1.0 78.24447  ? 404 ILE A CG2 404 ILE A CG2 1 
ATOM 3113  C CD1 . ILE A 1 404 ? 285.465 -65.547 323.395 1.0 78.24447  ? 404 ILE A CD1 404 ILE A CD1 1 
ATOM 3114  N N   . PRO A 1 405 ? 290.052 -61.801 323.061 1.0 77.0145   ? 405 PRO A N   405 PRO A N   1 
ATOM 3115  C CA  . PRO A 1 405 ? 290.515 -60.528 322.498 1.0 77.0145   ? 405 PRO A CA  405 PRO A CA  1 
ATOM 3116  C C   . PRO A 1 405 ? 289.747 -60.165 321.239 1.0 77.0145   ? 405 PRO A C   405 PRO A C   1 
ATOM 3117  O O   . PRO A 1 405 ? 289.358 -61.027 320.450 1.0 77.0145   ? 405 PRO A O   405 PRO A O   1 
ATOM 3118  C CB  . PRO A 1 405 ? 291.990 -60.796 322.188 1.0 77.0145   ? 405 PRO A CB  405 PRO A CB  1 
ATOM 3119  C CG  . PRO A 1 405 ? 292.055 -62.269 321.966 1.0 77.0145   ? 405 PRO A CG  405 PRO A CG  1 
ATOM 3120  C CD  . PRO A 1 405 ? 291.048 -62.873 322.900 1.0 77.0145   ? 405 PRO A CD  405 PRO A CD  1 
ATOM 3121  N N   . ALA A 1 406 ? 289.525 -58.867 321.057 1.0 73.13889  ? 406 ALA A N   406 ALA A N   1 
ATOM 3122  C CA  . ALA A 1 406 ? 288.686 -58.412 319.959 1.0 73.13889  ? 406 ALA A CA  406 ALA A CA  1 
ATOM 3123  C C   . ALA A 1 406 ? 289.076 -56.996 319.573 1.0 73.13889  ? 406 ALA A C   406 ALA A C   1 
ATOM 3124  O O   . ALA A 1 406 ? 289.817 -56.314 320.283 1.0 73.13889  ? 406 ALA A O   406 ALA A O   1 
ATOM 3125  C CB  . ALA A 1 406 ? 287.202 -58.477 320.328 1.0 73.13889  ? 406 ALA A CB  406 ALA A CB  1 
ATOM 3126  N N   . VAL A 1 407 ? 288.568 -56.568 318.421 1.0 70.95506  ? 407 VAL A N   407 VAL A N   1 
ATOM 3127  C CA  . VAL A 1 407 ? 288.695 -55.195 317.956 1.0 70.95506  ? 407 VAL A CA  407 VAL A CA  1 
ATOM 3128  C C   . VAL A 1 407 ? 287.315 -54.682 317.571 1.0 70.95506  ? 407 VAL A C   407 VAL A C   1 
ATOM 3129  O O   . VAL A 1 407 ? 286.471 -55.429 317.068 1.0 70.95506  ? 407 VAL A O   407 VAL A O   1 
ATOM 3130  C CB  . VAL A 1 407 ? 289.690 -55.069 316.780 1.0 70.95506  ? 407 VAL A CB  407 VAL A CB  1 
ATOM 3131  C CG1 . VAL A 1 407 ? 291.107 -55.291 317.263 1.0 70.95506  ? 407 VAL A CG1 407 VAL A CG1 1 
ATOM 3132  C CG2 . VAL A 1 407 ? 289.367 -56.080 315.700 1.0 70.95506  ? 407 VAL A CG2 407 VAL A CG2 1 
ATOM 3133  N N   . GLU A 1 408 ? 287.079 -53.402 317.836 1.0 73.0749   ? 408 GLU A N   408 GLU A N   1 
ATOM 3134  C CA  . GLU A 1 408 ? 285.799 -52.753 317.588 1.0 73.0749   ? 408 GLU A CA  408 GLU A CA  1 
ATOM 3135  C C   . GLU A 1 408 ? 285.930 -51.837 316.379 1.0 73.0749   ? 408 GLU A C   408 GLU A C   1 
ATOM 3136  O O   . GLU A 1 408 ? 286.967 -51.198 316.186 1.0 73.0749   ? 408 GLU A O   408 GLU A O   1 
ATOM 3137  C CB  . GLU A 1 408 ? 285.352 -51.965 318.824 1.0 73.0749   ? 408 GLU A CB  408 GLU A CB  1 
ATOM 3138  C CG  . GLU A 1 408 ? 283.991 -51.297 318.711 1.0 73.0749   ? 408 GLU A CG  408 GLU A CG  1 
ATOM 3139  C CD  . GLU A 1 408 ? 283.559 -50.620 319.995 1.0 73.0749   ? 408 GLU A CD  408 GLU A CD  1 
ATOM 3140  O OE1 . GLU A 1 408 ? 284.295 -50.715 320.998 1.0 73.0749   ? 408 GLU A OE1 408 GLU A OE1 1 
ATOM 3141  O OE2 . GLU A 1 408 ? 282.490 -49.976 319.996 1.0 73.0749   ? 408 GLU A OE2 408 GLU A OE2 1 
ATOM 3142  N N   . MET A 1 409 ? 284.875 -51.773 315.564 1.0 71.45677  ? 409 MET A N   409 MET A N   1 
ATOM 3143  C CA  . MET A 1 409 ? 284.943 -51.130 314.263 1.0 71.45677  ? 409 MET A CA  409 MET A CA  1 
ATOM 3144  C C   . MET A 1 409 ? 284.249 -49.775 314.175 1.0 71.45677  ? 409 MET A C   409 MET A C   1 
ATOM 3145  O O   . MET A 1 409 ? 284.797 -48.876 313.526 1.0 71.45677  ? 409 MET A O   409 MET A O   1 
ATOM 3146  C CB  . MET A 1 409 ? 284.347 -52.057 313.191 1.0 71.45677  ? 409 MET A CB  409 MET A CB  1 
ATOM 3147  C CG  . MET A 1 409 ? 284.517 -51.571 311.770 1.0 71.45677  ? 409 MET A CG  409 MET A CG  1 
ATOM 3148  S SD  . MET A 1 409 ? 283.898 -52.718 310.537 1.0 71.45677  ? 409 MET A SD  409 MET A SD  1 
ATOM 3149  C CE  . MET A 1 409 ? 284.225 -51.771 309.059 1.0 71.45677  ? 409 MET A CE  409 MET A CE  1 
ATOM 3150  N N   . ASN A 1 410 ? 283.105 -49.591 314.845 1.0 67.35373  ? 410 ASN A N   410 ASN A N   1 
ATOM 3151  C CA  . ASN A 1 410 ? 282.122 -48.537 314.553 1.0 67.35373  ? 410 ASN A CA  410 ASN A CA  1 
ATOM 3152  C C   . ASN A 1 410 ? 281.766 -48.557 313.066 1.0 67.35373  ? 410 ASN A C   410 ASN A C   1 
ATOM 3153  O O   . ASN A 1 410 ? 282.075 -47.645 312.301 1.0 67.35373  ? 410 ASN A O   410 ASN A O   1 
ATOM 3154  C CB  . ASN A 1 410 ? 282.590 -47.146 315.005 1.0 67.35373  ? 410 ASN A CB  410 ASN A CB  1 
ATOM 3155  C CG  . ASN A 1 410 ? 281.466 -46.107 314.986 1.0 67.35373  ? 410 ASN A CG  410 ASN A CG  1 
ATOM 3156  O OD1 . ASN A 1 410 ? 280.315 -46.414 314.681 1.0 67.35373  ? 410 ASN A OD1 410 ASN A OD1 1 
ATOM 3157  N ND2 . ASN A 1 410 ? 281.808 -44.868 315.302 1.0 67.35373  ? 410 ASN A ND2 410 ASN A ND2 1 
ATOM 3158  N N   . LEU A 1 411 ? 281.110 -49.650 312.682 1.0 65.98929  ? 411 LEU A N   411 LEU A N   1 
ATOM 3159  C CA  . LEU A 1 411 ? 280.807 -49.915 311.277 1.0 65.98929  ? 411 LEU A CA  411 LEU A CA  1 
ATOM 3160  C C   . LEU A 1 411 ? 279.877 -48.913 310.581 1.0 65.98929  ? 411 LEU A C   411 LEU A C   1 
ATOM 3161  O O   . LEU A 1 411 ? 280.179 -48.572 309.424 1.0 65.98929  ? 411 LEU A O   411 LEU A O   1 
ATOM 3162  C CB  . LEU A 1 411 ? 280.277 -51.353 311.163 1.0 65.98929  ? 411 LEU A CB  411 LEU A CB  1 
ATOM 3163  C CG  . LEU A 1 411 ? 279.942 -51.997 309.826 1.0 65.98929  ? 411 LEU A CG  411 LEU A CG  1 
ATOM 3164  C CD1 . LEU A 1 411 ? 280.295 -53.455 309.917 1.0 65.98929  ? 411 LEU A CD1 411 LEU A CD1 1 
ATOM 3165  C CD2 . LEU A 1 411 ? 278.459 -51.866 309.550 1.0 65.98929  ? 411 LEU A CD2 411 LEU A CD2 1 
ATOM 3166  N N   . PRO A 1 412 ? 278.747 -48.440 311.152 1.0 65.07565  ? 412 PRO A N   412 PRO A N   1 
ATOM 3167  C CA  . PRO A 1 412 ? 277.912 -47.509 310.365 1.0 65.07565  ? 412 PRO A CA  412 PRO A CA  1 
ATOM 3168  C C   . PRO A 1 412 ? 278.544 -46.145 310.150 1.0 65.07565  ? 412 PRO A C   412 PRO A C   1 
ATOM 3169  O O   . PRO A 1 412 ? 278.136 -45.416 309.239 1.0 65.07565  ? 412 PRO A O   412 PRO A O   1 
ATOM 3170  C CB  . PRO A 1 412 ? 276.623 -47.404 311.190 1.0 65.07565  ? 412 PRO A CB  412 PRO A CB  1 
ATOM 3171  C CG  . PRO A 1 412 ? 276.605 -48.600 312.029 1.0 65.07565  ? 412 PRO A CG  412 PRO A CG  1 
ATOM 3172  C CD  . PRO A 1 412 ? 278.026 -48.831 312.381 1.0 65.07565  ? 412 PRO A CD  412 PRO A CD  1 
ATOM 3173  N N   . ALA A 1 413 ? 279.536 -45.778 310.962 1.0 65.35924  ? 413 ALA A N   413 ALA A N   1 
ATOM 3174  C CA  . ALA A 1 413 ? 280.291 -44.560 310.694 1.0 65.35924  ? 413 ALA A CA  413 ALA A CA  1 
ATOM 3175  C C   . ALA A 1 413 ? 281.234 -44.754 309.517 1.0 65.35924  ? 413 ALA A C   413 ALA A C   1 
ATOM 3176  O O   . ALA A 1 413 ? 281.581 -43.793 308.823 1.0 65.35924  ? 413 ALA A O   413 ALA A O   1 
ATOM 3177  C CB  . ALA A 1 413 ? 281.067 -44.139 311.939 1.0 65.35924  ? 413 ALA A CB  413 ALA A CB  1 
ATOM 3178  N N   . ASN A 1 414 ? 281.658 -45.995 309.274 1.0 65.39112  ? 414 ASN A N   414 ASN A N   1 
ATOM 3179  C CA  . ASN A 1 414 ? 282.573 -46.259 308.170 1.0 65.39112  ? 414 ASN A CA  414 ASN A CA  1 
ATOM 3180  C C   . ASN A 1 414 ? 281.834 -46.316 306.841 1.0 65.39112  ? 414 ASN A C   414 ASN A C   1 
ATOM 3181  O O   . ASN A 1 414 ? 282.409 -46.004 305.793 1.0 65.39112  ? 414 ASN A O   414 ASN A O   1 
ATOM 3182  C CB  . ASN A 1 414 ? 283.333 -47.558 308.419 1.0 65.39112  ? 414 ASN A CB  414 ASN A CB  1 
ATOM 3183  C CG  . ASN A 1 414 ? 284.350 -47.426 309.526 1.0 65.39112  ? 414 ASN A CG  414 ASN A CG  1 
ATOM 3184  O OD1 . ASN A 1 414 ? 285.057 -46.426 309.615 1.0 65.39112  ? 414 ASN A OD1 414 ASN A OD1 1 
ATOM 3185  N ND2 . ASN A 1 414 ? 284.429 -48.436 310.381 1.0 65.39112  ? 414 ASN A ND2 414 ASN A ND2 1 
ATOM 3186  N N   . LEU A 1 415 ? 280.562 -46.722 306.859 1.0 63.59951  ? 415 LEU A N   415 LEU A N   1 
ATOM 3187  C CA  . LEU A 1 415 ? 279.768 -46.699 305.634 1.0 63.59951  ? 415 LEU A CA  415 LEU A CA  1 
ATOM 3188  C C   . LEU A 1 415 ? 279.463 -45.275 305.196 1.0 63.59951  ? 415 LEU A C   415 LEU A C   1 
ATOM 3189  O O   . LEU A 1 415 ? 279.286 -45.017 304.001 1.0 63.59951  ? 415 LEU A O   415 LEU A O   1 
ATOM 3190  C CB  . LEU A 1 415 ? 278.460 -47.468 305.816 1.0 63.59951  ? 415 LEU A CB  415 LEU A CB  1 
ATOM 3191  C CG  . LEU A 1 415 ? 278.399 -48.970 305.527 1.0 63.59951  ? 415 LEU A CG  415 LEU A CG  1 
ATOM 3192  C CD1 . LEU A 1 415 ? 278.804 -49.250 304.087 1.0 63.59951  ? 415 LEU A CD1 415 LEU A CD1 1 
ATOM 3193  C CD2 . LEU A 1 415 ? 279.214 -49.798 306.496 1.0 63.59951  ? 415 LEU A CD2 415 LEU A CD2 1 
ATOM 3194  N N   . LYS A 1 416 ? 279.387 -44.344 306.145 1.0 63.9214   ? 416 LYS A N   416 LYS A N   1 
ATOM 3195  C CA  . LYS A 1 416 ? 279.135 -42.954 305.795 1.0 63.9214   ? 416 LYS A CA  416 LYS A CA  1 
ATOM 3196  C C   . LYS A 1 416 ? 280.379 -42.304 305.205 1.0 63.9214   ? 416 LYS A C   416 LYS A C   1 
ATOM 3197  O O   . LYS A 1 416 ? 280.281 -41.494 304.278 1.0 63.9214   ? 416 LYS A O   416 LYS A O   1 
ATOM 3198  C CB  . LYS A 1 416 ? 278.656 -42.191 307.028 1.0 63.9214   ? 416 LYS A CB  416 LYS A CB  1 
ATOM 3199  C CG  . LYS A 1 416 ? 278.232 -40.763 306.765 1.0 63.9214   ? 416 LYS A CG  416 LYS A CG  1 
ATOM 3200  C CD  . LYS A 1 416 ? 276.949 -40.717 305.963 1.0 63.9214   ? 416 LYS A CD  416 LYS A CD  1 
ATOM 3201  C CE  . LYS A 1 416 ? 276.524 -39.288 305.695 1.0 63.9214   ? 416 LYS A CE  416 LYS A CE  1 
ATOM 3202  N NZ  . LYS A 1 416 ? 276.160 -38.586 306.950 1.0 63.9214   ? 416 LYS A NZ  416 LYS A NZ  1 
ATOM 3203  N N   . ARG A 1 417 ? 281.560 -42.652 305.723 1.0 65.63885  ? 417 ARG A N   417 ARG A N   1 
ATOM 3204  C CA  . ARG A 1 417 ? 282.795 -42.066 305.211 1.0 65.63885  ? 417 ARG A CA  417 ARG A CA  1 
ATOM 3205  C C   . ARG A 1 417 ? 283.134 -42.584 303.825 1.0 65.63885  ? 417 ARG A C   417 ARG A C   1 
ATOM 3206  O O   . ARG A 1 417 ? 283.736 -41.859 303.026 1.0 65.63885  ? 417 ARG A O   417 ARG A O   1 
ATOM 3207  C CB  . ARG A 1 417 ? 283.951 -42.358 306.158 1.0 65.63885  ? 417 ARG A CB  417 ARG A CB  1 
ATOM 3208  C CG  . ARG A 1 417 ? 283.845 -41.677 307.493 1.0 65.63885  ? 417 ARG A CG  417 ARG A CG  1 
ATOM 3209  C CD  . ARG A 1 417 ? 285.004 -42.080 308.373 1.0 65.63885  ? 417 ARG A CD  417 ARG A CD  1 
ATOM 3210  N NE  . ARG A 1 417 ? 286.278 -41.638 307.822 1.0 65.63885  ? 417 ARG A NE  417 ARG A NE  1 
ATOM 3211  C CZ  . ARG A 1 417 ? 286.808 -40.443 308.049 1.0 65.63885  ? 417 ARG A CZ  417 ARG A CZ  1 
ATOM 3212  N NH1 . ARG A 1 417 ? 286.173 -39.571 308.818 1.0 65.63885  ? 417 ARG A NH1 417 ARG A NH1 1 
ATOM 3213  N NH2 . ARG A 1 417 ? 287.973 -40.118 307.509 1.0 65.63885  ? 417 ARG A NH2 417 ARG A NH2 1 
ATOM 3214  N N   . THR A 1 418 ? 282.779 -43.833 303.531 1.0 63.43409  ? 418 THR A N   418 THR A N   1 
ATOM 3215  C CA  . THR A 1 418 ? 282.999 -44.374 302.197 1.0 63.43409  ? 418 THR A CA  418 THR A CA  1 
ATOM 3216  C C   . THR A 1 418 ? 282.049 -43.739 301.192 1.0 63.43409  ? 418 THR A C   418 THR A C   1 
ATOM 3217  O O   . THR A 1 418 ? 282.445 -43.426 300.062 1.0 63.43409  ? 418 THR A O   418 THR A O   1 
ATOM 3218  C CB  . THR A 1 418 ? 282.831 -45.892 302.230 1.0 63.43409  ? 418 THR A CB  418 THR A CB  1 
ATOM 3219  O OG1 . THR A 1 418 ? 283.770 -46.452 303.155 1.0 63.43409  ? 418 THR A OG1 418 THR A OG1 1 
ATOM 3220  C CG2 . THR A 1 418 ? 283.075 -46.493 300.871 1.0 63.43409  ? 418 THR A CG2 418 THR A CG2 1 
ATOM 3221  N N   . PHE A 1 419 ? 280.801 -43.509 301.603 1.0 60.94662  ? 419 PHE A N   419 PHE A N   1 
ATOM 3222  C CA  . PHE A 1 419 ? 279.818 -42.889 300.723 1.0 60.94662  ? 419 PHE A CA  419 PHE A CA  1 
ATOM 3223  C C   . PHE A 1 419 ? 280.166 -41.437 300.427 1.0 60.94662  ? 419 PHE A C   419 PHE A C   1 
ATOM 3224  O O   . PHE A 1 419 ? 279.955 -40.963 299.308 1.0 60.94662  ? 419 PHE A O   419 PHE A O   1 
ATOM 3225  C CB  . PHE A 1 419 ? 278.431 -42.983 301.352 1.0 60.94662  ? 419 PHE A CB  419 PHE A CB  1 
ATOM 3226  C CG  . PHE A 1 419 ? 277.344 -42.378 300.518 1.0 60.94662  ? 419 PHE A CG  419 PHE A CG  1 
ATOM 3227  C CD1 . PHE A 1 419 ? 276.860 -43.041 299.406 1.0 60.94662  ? 419 PHE A CD1 419 PHE A CD1 1 
ATOM 3228  C CD2 . PHE A 1 419 ? 276.797 -41.149 300.852 1.0 60.94662  ? 419 PHE A CD2 419 PHE A CD2 1 
ATOM 3229  C CE1 . PHE A 1 419 ? 275.854 -42.488 298.638 1.0 60.94662  ? 419 PHE A CE1 419 PHE A CE1 1 
ATOM 3230  C CE2 . PHE A 1 419 ? 275.793 -40.590 300.087 1.0 60.94662  ? 419 PHE A CE2 419 PHE A CE2 1 
ATOM 3231  C CZ  . PHE A 1 419 ? 275.321 -41.262 298.982 1.0 60.94662  ? 419 PHE A CZ  419 PHE A CZ  1 
ATOM 3232  N N   . LEU A 1 420 ? 280.703 -40.717 301.407 1.0 62.88013  ? 420 LEU A N   420 LEU A N   1 
ATOM 3233  C CA  . LEU A 1 420 ? 281.015 -39.313 301.186 1.0 62.88013  ? 420 LEU A CA  420 LEU A CA  1 
ATOM 3234  C C   . LEU A 1 420 ? 282.324 -39.103 300.445 1.0 62.88013  ? 420 LEU A C   420 LEU A C   1 
ATOM 3235  O O   . LEU A 1 420 ? 282.487 -38.068 299.794 1.0 62.88013  ? 420 LEU A O   420 LEU A O   1 
ATOM 3236  C CB  . LEU A 1 420 ? 281.055 -38.564 302.514 1.0 62.88013  ? 420 LEU A CB  420 LEU A CB  1 
ATOM 3237  C CG  . LEU A 1 420 ? 279.690 -38.435 303.177 1.0 62.88013  ? 420 LEU A CG  420 LEU A CG  1 
ATOM 3238  C CD1 . LEU A 1 420 ? 279.829 -37.804 304.538 1.0 62.88013  ? 420 LEU A CD1 420 LEU A CD1 1 
ATOM 3239  C CD2 . LEU A 1 420 ? 278.765 -37.627 302.302 1.0 62.88013  ? 420 LEU A CD2 420 LEU A CD2 1 
ATOM 3240  N N   . TYR A 1 421 ? 283.256 -40.048 300.518 1.0 64.89655  ? 421 TYR A N   421 TYR A N   1 
ATOM 3241  C CA  . TYR A 1 421 ? 284.523 -39.849 299.827 1.0 64.89655  ? 421 TYR A CA  421 TYR A CA  1 
ATOM 3242  C C   . TYR A 1 421 ? 284.403 -40.139 298.340 1.0 64.89655  ? 421 TYR A C   421 TYR A C   1 
ATOM 3243  O O   . TYR A 1 421 ? 284.918 -39.378 297.515 1.0 64.89655  ? 421 TYR A O   421 TYR A O   1 
ATOM 3244  C CB  . TYR A 1 421 ? 285.613 -40.721 300.441 1.0 64.89655  ? 421 TYR A CB  421 TYR A CB  1 
ATOM 3245  C CG  . TYR A 1 421 ? 286.966 -40.510 299.805 1.0 64.89655  ? 421 TYR A CG  421 TYR A CG  1 
ATOM 3246  C CD1 . TYR A 1 421 ? 287.715 -39.379 300.092 1.0 64.89655  ? 421 TYR A CD1 421 TYR A CD1 1 
ATOM 3247  C CD2 . TYR A 1 421 ? 287.492 -41.436 298.916 1.0 64.89655  ? 421 TYR A CD2 421 TYR A CD2 1 
ATOM 3248  C CE1 . TYR A 1 421 ? 288.949 -39.177 299.514 1.0 64.89655  ? 421 TYR A CE1 421 TYR A CE1 1 
ATOM 3249  C CE2 . TYR A 1 421 ? 288.726 -41.243 298.335 1.0 64.89655  ? 421 TYR A CE2 421 TYR A CE2 1 
ATOM 3250  C CZ  . TYR A 1 421 ? 289.448 -40.111 298.636 1.0 64.89655  ? 421 TYR A CZ  421 TYR A CZ  1 
ATOM 3251  O OH  . TYR A 1 421 ? 290.679 -39.912 298.060 1.0 64.89655  ? 421 TYR A OH  421 TYR A OH  1 
ATOM 3252  N N   . SER A 1 422 ? 283.735 -41.231 297.976 1.0 62.84779  ? 422 SER A N   422 SER A N   1 
ATOM 3253  C CA  . SER A 1 422 ? 283.690 -41.630 296.578 1.0 62.84779  ? 422 SER A CA  422 SER A CA  1 
ATOM 3254  C C   . SER A 1 422 ? 282.680 -40.823 295.778 1.0 62.84779  ? 422 SER A C   422 SER A C   1 
ATOM 3255  O O   . SER A 1 422 ? 282.880 -40.611 294.579 1.0 62.84779  ? 422 SER A O   422 SER A O   1 
ATOM 3256  C CB  . SER A 1 422 ? 283.366 -43.117 296.469 1.0 62.84779  ? 422 SER A CB  422 SER A CB  1 
ATOM 3257  O OG  . SER A 1 422 ? 282.060 -43.383 296.943 1.0 62.84779  ? 422 SER A OG  422 SER A OG  1 
ATOM 3258  N N   . ASN A 1 423 ? 281.603 -40.365 296.410 1.0 60.3656   ? 423 ASN A N   423 ASN A N   1 
ATOM 3259  C CA  . ASN A 1 423 ? 280.528 -39.696 295.693 1.0 60.3656   ? 423 ASN A CA  423 ASN A CA  1 
ATOM 3260  C C   . ASN A 1 423 ? 280.584 -38.182 295.780 1.0 60.3656   ? 423 ASN A C   423 ASN A C   1 
ATOM 3261  O O   . ASN A 1 423 ? 280.148 -37.508 294.843 1.0 60.3656   ? 423 ASN A O   423 ASN A O   1 
ATOM 3262  C CB  . ASN A 1 423 ? 279.173 -40.163 296.221 1.0 60.3656   ? 423 ASN A CB  423 ASN A CB  1 
ATOM 3263  C CG  . ASN A 1 423 ? 278.956 -41.637 296.020 1.0 60.3656   ? 423 ASN A CG  423 ASN A CG  1 
ATOM 3264  O OD1 . ASN A 1 423 ? 278.880 -42.398 296.978 1.0 60.3656   ? 423 ASN A OD1 423 ASN A OD1 1 
ATOM 3265  N ND2 . ASN A 1 423 ? 278.855 -42.054 294.770 1.0 60.3656   ? 423 ASN A ND2 423 ASN A ND2 1 
ATOM 3266  N N   . VAL A 1 424 ? 281.099 -37.626 296.870 1.0 59.82769  ? 424 VAL A N   424 VAL A N   1 
ATOM 3267  C CA  . VAL A 1 424 ? 281.111 -36.187 297.091 1.0 59.82769  ? 424 VAL A CA  424 VAL A CA  1 
ATOM 3268  C C   . VAL A 1 424 ? 282.530 -35.628 297.064 1.0 59.82769  ? 424 VAL A C   424 VAL A C   1 
ATOM 3269  O O   . VAL A 1 424 ? 282.803 -34.643 296.379 1.0 59.82769  ? 424 VAL A O   424 VAL A O   1 
ATOM 3270  C CB  . VAL A 1 424 ? 280.396 -35.825 298.411 1.0 59.82769  ? 424 VAL A CB  424 VAL A CB  1 
ATOM 3271  C CG1 . VAL A 1 424 ? 280.489 -34.341 298.680 1.0 59.82769  ? 424 VAL A CG1 424 VAL A CG1 1 
ATOM 3272  C CG2 . VAL A 1 424 ? 278.946 -36.260 298.359 1.0 59.82769  ? 424 VAL A CG2 424 VAL A CG2 1 
ATOM 3273  N N   . ALA A 1 425 ? 283.452 -36.255 297.796 1.0 62.38287  ? 425 ALA A N   425 ALA A N   1 
ATOM 3274  C CA  . ALA A 1 425 ? 284.802 -35.713 297.901 1.0 62.38287  ? 425 ALA A CA  425 ALA A CA  1 
ATOM 3275  C C   . ALA A 1 425 ? 285.602 -35.941 296.632 1.0 62.38287  ? 425 ALA A C   425 ALA A C   1 
ATOM 3276  O O   . ALA A 1 425 ? 286.496 -35.154 296.313 1.0 62.38287  ? 425 ALA A O   425 ALA A O   1 
ATOM 3277  C CB  . ALA A 1 425 ? 285.528 -36.330 299.094 1.0 62.38287  ? 425 ALA A CB  425 ALA A CB  1 
ATOM 3278  N N   . MET A 1 426 ? 285.283 -36.998 295.896 1.0 63.78727  ? 426 MET A N   426 MET A N   1 
ATOM 3279  C CA  . MET A 1 426 ? 286.039 -37.339 294.703 1.0 63.78727  ? 426 MET A CA  426 MET A CA  1 
ATOM 3280  C C   . MET A 1 426 ? 285.767 -36.365 293.566 1.0 63.78727  ? 426 MET A C   426 MET A C   1 
ATOM 3281  O O   . MET A 1 426 ? 286.656 -36.104 292.749 1.0 63.78727  ? 426 MET A O   426 MET A O   1 
ATOM 3282  C CB  . MET A 1 426 ? 285.691 -38.773 294.307 1.0 63.78727  ? 426 MET A CB  426 MET A CB  1 
ATOM 3283  C CG  . MET A 1 426 ? 286.538 -39.345 293.212 1.0 63.78727  ? 426 MET A CG  426 MET A CG  1 
ATOM 3284  S SD  . MET A 1 426 ? 288.277 -39.416 293.678 1.0 63.78727  ? 426 MET A SD  426 MET A SD  1 
ATOM 3285  C CE  . MET A 1 426 ? 288.262 -40.820 294.787 1.0 63.78727  ? 426 MET A CE  426 MET A CE  1 
ATOM 3286  N N   . TYR A 1 427 ? 284.569 -35.787 293.526 1.0 62.75956  ? 427 TYR A N   427 TYR A N   1 
ATOM 3287  C CA  . TYR A 1 427 ? 284.116 -34.961 292.408 1.0 62.75956  ? 427 TYR A CA  427 TYR A CA  1 
ATOM 3288  C C   . TYR A 1 427 ? 284.226 -33.472 292.704 1.0 62.75956  ? 427 TYR A C   427 TYR A C   1 
ATOM 3289  O O   . TYR A 1 427 ? 283.405 -32.687 292.237 1.0 62.75956  ? 427 TYR A O   427 TYR A O   1 
ATOM 3290  C CB  . TYR A 1 427 ? 282.682 -35.332 292.028 1.0 62.75956  ? 427 TYR A CB  427 TYR A CB  1 
ATOM 3291  C CG  . TYR A 1 427 ? 282.558 -36.721 291.426 1.0 62.75956  ? 427 TYR A CG  427 TYR A CG  1 
ATOM 3292  C CD1 . TYR A 1 427 ? 283.662 -37.345 290.870 1.0 62.75956  ? 427 TYR A CD1 427 TYR A CD1 1 
ATOM 3293  C CD2 . TYR A 1 427 ? 281.362 -37.412 291.435 1.0 62.75956  ? 427 TYR A CD2 427 TYR A CD2 1 
ATOM 3294  C CE1 . TYR A 1 427 ? 283.581 -38.605 290.335 1.0 62.75956  ? 427 TYR A CE1 427 TYR A CE1 1 
ATOM 3295  C CE2 . TYR A 1 427 ? 281.270 -38.691 290.893 1.0 62.75956  ? 427 TYR A CE2 427 TYR A CE2 1 
ATOM 3296  C CZ  . TYR A 1 427 ? 282.381 -39.275 290.346 1.0 62.75956  ? 427 TYR A CZ  427 TYR A CZ  1 
ATOM 3297  O OH  . TYR A 1 427 ? 282.320 -40.535 289.804 1.0 62.75956  ? 427 TYR A OH  427 TYR A OH  1 
ATOM 3298  N N   . LEU A 1 428 ? 285.231 -33.049 293.461 1.0 65.54462  ? 428 LEU A N   428 LEU A N   1 
ATOM 3299  C CA  . LEU A 1 428 ? 285.450 -31.633 293.707 1.0 65.54462  ? 428 LEU A CA  428 LEU A CA  1 
ATOM 3300  C C   . LEU A 1 428 ? 285.987 -30.937 292.462 1.0 65.54462  ? 428 LEU A C   428 LEU A C   1 
ATOM 3301  O O   . LEU A 1 428 ? 286.481 -31.591 291.542 1.0 65.54462  ? 428 LEU A O   428 LEU A O   1 
ATOM 3302  C CB  . LEU A 1 428 ? 286.451 -31.442 294.833 1.0 65.54462  ? 428 LEU A CB  428 LEU A CB  1 
ATOM 3303  C CG  . LEU A 1 428 ? 286.085 -31.829 296.247 1.0 65.54462  ? 428 LEU A CG  428 LEU A CG  1 
ATOM 3304  C CD1 . LEU A 1 428 ? 287.331 -31.583 297.029 1.0 65.54462  ? 428 LEU A CD1 428 LEU A CD1 1 
ATOM 3305  C CD2 . LEU A 1 428 ? 284.944 -30.984 296.757 1.0 65.54462  ? 428 LEU A CD2 428 LEU A CD2 1 
ATOM 3306  N N   . PRO A 1 429 ? 285.920 -29.592 292.411 1.0 65.95549  ? 429 PRO A N   429 PRO A N   1 
ATOM 3307  C CA  . PRO A 1 429 ? 286.702 -28.870 291.398 1.0 65.95549  ? 429 PRO A CA  429 PRO A CA  1 
ATOM 3308  C C   . PRO A 1 429 ? 288.200 -28.889 291.672 1.0 65.95549  ? 429 PRO A C   429 PRO A C   1 
ATOM 3309  O O   . PRO A 1 429 ? 288.653 -29.412 292.694 1.0 65.95549  ? 429 PRO A O   429 PRO A O   1 
ATOM 3310  C CB  . PRO A 1 429 ? 286.136 -27.446 291.465 1.0 65.95549  ? 429 PRO A CB  429 PRO A CB  1 
ATOM 3311  C CG  . PRO A 1 429 ? 285.509 -27.339 292.796 1.0 65.95549  ? 429 PRO A CG  429 PRO A CG  1 
ATOM 3312  C CD  . PRO A 1 429 ? 284.963 -28.696 293.087 1.0 65.95549  ? 429 PRO A CD  429 PRO A CD  1 
ATOM 3313  N N   . ASP A 1 430 ? 288.973 -28.306 290.757 1.0 71.16466  ? 430 ASP A N   430 ASP A N   1 
ATOM 3314  C CA  . ASP A 1 430 ? 290.429 -28.341 290.802 1.0 71.16466  ? 430 ASP A CA  430 ASP A CA  1 
ATOM 3315  C C   . ASP A 1 430 ? 291.020 -27.540 291.957 1.0 71.16466  ? 430 ASP A C   430 ASP A C   1 
ATOM 3316  O O   . ASP A 1 430 ? 292.129 -27.851 292.401 1.0 71.16466  ? 430 ASP A O   430 ASP A O   1 
ATOM 3317  C CB  . ASP A 1 430 ? 290.985 -27.822 289.471 1.0 71.16466  ? 430 ASP A CB  430 ASP A CB  1 
ATOM 3318  C CG  . ASP A 1 430 ? 292.488 -27.987 289.352 1.0 71.16466  ? 430 ASP A CG  430 ASP A CG  1 
ATOM 3319  O OD1 . ASP A 1 430 ? 292.949 -29.129 289.144 1.0 71.16466  ? 430 ASP A OD1 430 ASP A OD1 1 
ATOM 3320  O OD2 . ASP A 1 430 ? 293.206 -26.972 289.468 1.0 71.16466  ? 430 ASP A OD2 430 ASP A OD2 1 
ATOM 3321  N N   . THR A 1 431 ? 290.306 -26.539 292.468 1.0 71.16713  ? 431 THR A N   431 THR A N   1 
ATOM 3322  C CA  . THR A 1 431 ? 290.871 -25.660 293.484 1.0 71.16713  ? 431 THR A CA  431 THR A CA  1 
ATOM 3323  C C   . THR A 1 431 ? 290.970 -26.312 294.855 1.0 71.16713  ? 431 THR A C   431 THR A C   1 
ATOM 3324  O O   . THR A 1 431 ? 291.758 -25.850 295.686 1.0 71.16713  ? 431 THR A O   431 THR A O   1 
ATOM 3325  C CB  . THR A 1 431 ? 290.039 -24.385 293.598 1.0 71.16713  ? 431 THR A CB  431 THR A CB  1 
ATOM 3326  O OG1 . THR A 1 431 ? 288.713 -24.720 294.026 1.0 71.16713  ? 431 THR A OG1 431 THR A OG1 1 
ATOM 3327  C CG2 . THR A 1 431 ? 289.967 -23.684 292.256 1.0 71.16713  ? 431 THR A CG2 431 THR A CG2 1 
ATOM 3328  N N   . TYR A 1 432 ? 290.197 -27.366 295.113 1.0 70.03794  ? 432 TYR A N   432 TYR A N   1 
ATOM 3329  C CA  . TYR A 1 432 ? 290.162 -27.995 296.427 1.0 70.03794  ? 432 TYR A CA  432 TYR A CA  1 
ATOM 3330  C C   . TYR A 1 432 ? 290.821 -29.367 296.433 1.0 70.03794  ? 432 TYR A C   432 TYR A C   1 
ATOM 3331  O O   . TYR A 1 432 ? 290.593 -30.155 297.354 1.0 70.03794  ? 432 TYR A O   432 TYR A O   1 
ATOM 3332  C CB  . TYR A 1 432 ? 288.724 -28.100 296.929 1.0 70.03794  ? 432 TYR A CB  432 TYR A CB  1 
ATOM 3333  C CG  . TYR A 1 432 ? 288.097 -26.778 297.300 1.0 70.03794  ? 432 TYR A CG  432 TYR A CG  1 
ATOM 3334  C CD1 . TYR A 1 432 ? 288.878 -25.649 297.521 1.0 70.03794  ? 432 TYR A CD1 432 TYR A CD1 1 
ATOM 3335  C CD2 . TYR A 1 432 ? 286.723 -26.657 297.423 1.0 70.03794  ? 432 TYR A CD2 432 TYR A CD2 1 
ATOM 3336  C CE1 . TYR A 1 432 ? 288.305 -24.440 297.854 1.0 70.03794  ? 432 TYR A CE1 432 TYR A CE1 1 
ATOM 3337  C CE2 . TYR A 1 432 ? 286.145 -25.456 297.758 1.0 70.03794  ? 432 TYR A CE2 432 TYR A CE2 1 
ATOM 3338  C CZ  . TYR A 1 432 ? 286.938 -24.351 297.971 1.0 70.03794  ? 432 TYR A CZ  432 TYR A CZ  1 
ATOM 3339  O OH  . TYR A 1 432 ? 286.359 -23.150 298.304 1.0 70.03794  ? 432 TYR A OH  432 TYR A OH  1 
ATOM 3340  N N   . LYS A 1 433 ? 291.623 -29.671 295.424 1.0 68.83261  ? 433 LYS A N   433 LYS A N   1 
ATOM 3341  C CA  . LYS A 1 433 ? 292.374 -30.913 295.369 1.0 68.83261  ? 433 LYS A CA  433 LYS A CA  1 
ATOM 3342  C C   . LYS A 1 433 ? 293.862 -30.613 295.477 1.0 68.83261  ? 433 LYS A C   433 LYS A C   1 
ATOM 3343  O O   . LYS A 1 433 ? 294.295 -29.463 295.396 1.0 68.83261  ? 433 LYS A O   433 LYS A O   1 
ATOM 3344  C CB  . LYS A 1 433 ? 292.074 -31.677 294.077 1.0 68.83261  ? 433 LYS A CB  433 LYS A CB  1 
ATOM 3345  C CG  . LYS A 1 433 ? 290.662 -32.214 293.988 1.0 68.83261  ? 433 LYS A CG  433 LYS A CG  1 
ATOM 3346  C CD  . LYS A 1 433 ? 290.465 -33.018 292.720 1.0 68.83261  ? 433 LYS A CD  433 LYS A CD  1 
ATOM 3347  C CE  . LYS A 1 433 ? 289.052 -33.556 292.626 1.0 68.83261  ? 433 LYS A CE  433 LYS A CE  1 
ATOM 3348  N NZ  . LYS A 1 433 ? 288.847 -34.356 291.392 1.0 68.83261  ? 433 LYS A NZ  433 LYS A NZ  1 
ATOM 3349  N N   . PHE A 1 434 ? 294.649 -31.669 295.656 1.0 74.35911  ? 434 PHE A N   434 PHE A N   1 
ATOM 3350  C CA  . PHE A 1 434 ? 296.096 -31.536 295.696 1.0 74.35911  ? 434 PHE A CA  434 PHE A CA  1 
ATOM 3351  C C   . PHE A 1 434 ? 296.726 -32.713 294.972 1.0 74.35911  ? 434 PHE A C   434 PHE A C   1 
ATOM 3352  O O   . PHE A 1 434 ? 296.200 -33.827 294.991 1.0 74.35911  ? 434 PHE A O   434 PHE A O   1 
ATOM 3353  C CB  . PHE A 1 434 ? 296.630 -31.448 297.140 1.0 74.35911  ? 434 PHE A CB  434 PHE A CB  1 
ATOM 3354  C CG  . PHE A 1 434 ? 296.445 -32.708 297.947 1.0 74.35911  ? 434 PHE A CG  434 PHE A CG  1 
ATOM 3355  C CD1 . PHE A 1 434 ? 295.257 -32.947 298.614 1.0 74.35911  ? 434 PHE A CD1 434 PHE A CD1 1 
ATOM 3356  C CD2 . PHE A 1 434 ? 297.478 -33.629 298.081 1.0 74.35911  ? 434 PHE A CD2 434 PHE A CD2 1 
ATOM 3357  C CE1 . PHE A 1 434 ? 295.086 -34.093 299.362 1.0 74.35911  ? 434 PHE A CE1 434 PHE A CE1 1 
ATOM 3358  C CE2 . PHE A 1 434 ? 297.309 -34.778 298.823 1.0 74.35911  ? 434 PHE A CE2 434 PHE A CE2 1 
ATOM 3359  C CZ  . PHE A 1 434 ? 296.112 -35.009 299.466 1.0 74.35911  ? 434 PHE A CZ  434 PHE A CZ  1 
ATOM 3360  N N   . THR A 1 435 ? 297.853 -32.456 294.337 1.0 78.1299   ? 435 THR A N   435 THR A N   1 
ATOM 3361  C CA  . THR A 1 435 ? 298.635 -33.559 293.817 1.0 78.1299   ? 435 THR A CA  435 THR A CA  1 
ATOM 3362  C C   . THR A 1 435 ? 299.477 -34.171 294.936 1.0 78.1299   ? 435 THR A C   435 THR A C   1 
ATOM 3363  O O   . THR A 1 435 ? 299.884 -33.475 295.870 1.0 78.1299   ? 435 THR A O   435 THR A O   1 
ATOM 3364  C CB  . THR A 1 435 ? 299.524 -33.093 292.661 1.0 78.1299   ? 435 THR A CB  435 THR A CB  1 
ATOM 3365  O OG1 . THR A 1 435 ? 300.282 -34.197 292.152 1.0 78.1299   ? 435 THR A OG1 435 THR A OG1 1 
ATOM 3366  C CG2 . THR A 1 435 ? 300.459 -31.962 293.078 1.0 78.1299   ? 435 THR A CG2 435 THR A CG2 1 
ATOM 3367  N N   . PRO A 1 436 ? 299.693 -35.482 294.908 1.0 80.51018  ? 436 PRO A N   436 PRO A N   1 
ATOM 3368  C CA  . PRO A 1 436 ? 300.534 -36.109 295.930 1.0 80.51018  ? 436 PRO A CA  436 PRO A CA  1 
ATOM 3369  C C   . PRO A 1 436 ? 302.001 -35.776 295.712 1.0 80.51018  ? 436 PRO A C   436 PRO A C   1 
ATOM 3370  O O   . PRO A 1 436 ? 302.405 -35.218 294.691 1.0 80.51018  ? 436 PRO A O   436 PRO A O   1 
ATOM 3371  C CB  . PRO A 1 436 ? 300.270 -37.604 295.742 1.0 80.51018  ? 436 PRO A CB  436 PRO A CB  1 
ATOM 3372  C CG  . PRO A 1 436 ? 298.959 -37.672 295.053 1.0 80.51018  ? 436 PRO A CG  436 PRO A CG  1 
ATOM 3373  C CD  . PRO A 1 436 ? 298.932 -36.484 294.149 1.0 80.51018  ? 436 PRO A CD  436 PRO A CD  1 
ATOM 3374  N N   . ALA A 1 437 ? 302.805 -36.123 296.707 1.0 83.71744  ? 437 ALA A N   437 ALA A N   1 
ATOM 3375  C CA  . ALA A 1 437 ? 304.242 -35.951 296.588 1.0 83.71744  ? 437 ALA A CA  437 ALA A CA  1 
ATOM 3376  C C   . ALA A 1 437 ? 304.833 -37.056 295.725 1.0 83.71744  ? 437 ALA A C   437 ALA A C   1 
ATOM 3377  O O   . ALA A 1 437 ? 304.302 -38.169 295.662 1.0 83.71744  ? 437 ALA A O   437 ALA A O   1 
ATOM 3378  C CB  . ALA A 1 437 ? 304.901 -35.952 297.966 1.0 83.71744  ? 437 ALA A CB  437 ALA A CB  1 
ATOM 3379  N N   . ASN A 1 438 ? 305.922 -36.716 295.029 1.0 85.30376  ? 438 ASN A N   438 ASN A N   1 
ATOM 3380  C CA  . ASN A 1 438 ? 306.758 -37.632 294.249 1.0 85.30376  ? 438 ASN A CA  438 ASN A CA  1 
ATOM 3381  C C   . ASN A 1 438 ? 306.008 -38.324 293.114 1.0 85.30376  ? 438 ASN A C   438 ASN A C   1 
ATOM 3382  O O   . ASN A 1 438 ? 306.395 -39.416 292.691 1.0 85.30376  ? 438 ASN A O   438 ASN A O   1 
ATOM 3383  C CB  . ASN A 1 438 ? 307.425 -38.681 295.146 1.0 85.30376  ? 438 ASN A CB  438 ASN A CB  1 
ATOM 3384  C CG  . ASN A 1 438 ? 308.368 -38.067 296.149 1.0 85.30376  ? 438 ASN A CG  438 ASN A CG  1 
ATOM 3385  O OD1 . ASN A 1 438 ? 308.121 -38.103 297.352 1.0 85.30376  ? 438 ASN A OD1 438 ASN A OD1 1 
ATOM 3386  N ND2 . ASN A 1 438 ? 309.464 -37.503 295.660 1.0 85.30376  ? 438 ASN A ND2 438 ASN A ND2 1 
ATOM 3387  N N   . VAL A 1 439 ? 304.937 -37.719 292.605 1.0 84.13173  ? 439 VAL A N   439 VAL A N   1 
ATOM 3388  C CA  . VAL A 1 439 ? 304.236 -38.247 291.443 1.0 84.13173  ? 439 VAL A CA  439 VAL A CA  1 
ATOM 3389  C C   . VAL A 1 439 ? 304.283 -37.199 290.340 1.0 84.13173  ? 439 VAL A C   439 VAL A C   1 
ATOM 3390  O O   . VAL A 1 439 ? 304.474 -36.006 290.585 1.0 84.13173  ? 439 VAL A O   439 VAL A O   1 
ATOM 3391  C CB  . VAL A 1 439 ? 302.781 -38.650 291.754 1.0 84.13173  ? 439 VAL A CB  439 VAL A CB  1 
ATOM 3392  C CG1 . VAL A 1 439 ? 302.747 -39.757 292.792 1.0 84.13173  ? 439 VAL A CG1 439 VAL A CG1 1 
ATOM 3393  C CG2 . VAL A 1 439 ? 301.989 -37.452 292.223 1.0 84.13173  ? 439 VAL A CG2 439 VAL A CG2 1 
ATOM 3394  N N   . ASP A 1 440 ? 304.112 -37.664 289.107 1.0 85.7808   ? 440 ASP A N   440 ASP A N   1 
ATOM 3395  C CA  . ASP A 1 440 ? 304.242 -36.817 287.929 1.0 85.7808   ? 440 ASP A CA  440 ASP A CA  1 
ATOM 3396  C C   . ASP A 1 440 ? 302.969 -36.902 287.104 1.0 85.7808   ? 440 ASP A C   440 ASP A C   1 
ATOM 3397  O O   . ASP A 1 440 ? 302.614 -37.977 286.609 1.0 85.7808   ? 440 ASP A O   440 ASP A O   1 
ATOM 3398  C CB  . ASP A 1 440 ? 305.456 -37.227 287.098 1.0 85.7808   ? 440 ASP A CB  440 ASP A CB  1 
ATOM 3399  C CG  . ASP A 1 440 ? 306.759 -36.939 287.806 1.0 85.7808   ? 440 ASP A CG  440 ASP A CG  1 
ATOM 3400  O OD1 . ASP A 1 440 ? 306.791 -35.991 288.619 1.0 85.7808   ? 440 ASP A OD1 440 ASP A OD1 1 
ATOM 3401  O OD2 . ASP A 1 440 ? 307.749 -37.658 287.554 1.0 85.7808   ? 440 ASP A OD2 440 ASP A OD2 1 
ATOM 3402  N N   . LEU A 1 441 ? 302.310 -35.798 286.958 1.0 83.53561  ? 441 LEU A N   441 LEU A N   1 
ATOM 3403  C CA  . LEU A 1 441 ? 301.078 -35.619 286.219 1.0 83.53561  ? 441 LEU A CA  441 LEU A CA  1 
ATOM 3404  C C   . LEU A 1 441 ? 301.367 -35.045 284.837 1.0 83.53561  ? 441 LEU A C   441 LEU A C   1 
ATOM 3405  O O   . LEU A 1 441 ? 302.390 -34.381 284.641 1.0 83.53561  ? 441 LEU A O   441 LEU A O   1 
ATOM 3406  C CB  . LEU A 1 441 ? 300.137 -34.681 286.982 1.0 83.53561  ? 441 LEU A CB  441 LEU A CB  1 
ATOM 3407  C CG  . LEU A 1 441 ? 299.683 -35.220 288.337 1.0 83.53561  ? 441 LEU A CG  441 LEU A CG  1 
ATOM 3408  C CD1 . LEU A 1 441 ? 298.793 -34.223 289.063 1.0 83.53561  ? 441 LEU A CD1 441 LEU A CD1 1 
ATOM 3409  C CD2 . LEU A 1 441 ? 298.986 -36.550 288.165 1.0 83.53561  ? 441 LEU A CD2 441 LEU A CD2 1 
ATOM 3410  N N   . PRO A 1 442 ? 300.510 -35.301 283.849 1.0 83.80519  ? 442 PRO A N   442 PRO A N   1 
ATOM 3411  C CA  . PRO A 1 442 ? 300.665 -34.637 282.551 1.0 83.80519  ? 442 PRO A CA  442 PRO A CA  1 
ATOM 3412  C C   . PRO A 1 442 ? 300.401 -33.142 282.650 1.0 83.80519  ? 442 PRO A C   442 PRO A C   1 
ATOM 3413  O O   . PRO A 1 442 ? 299.783 -32.647 283.594 1.0 83.80519  ? 442 PRO A O   442 PRO A O   1 
ATOM 3414  C CB  . PRO A 1 442 ? 299.628 -35.334 281.665 1.0 83.80519  ? 442 PRO A CB  442 PRO A CB  1 
ATOM 3415  C CG  . PRO A 1 442 ? 298.643 -35.907 282.611 1.0 83.80519  ? 442 PRO A CG  442 PRO A CG  1 
ATOM 3416  C CD  . PRO A 1 442 ? 299.426 -36.299 283.820 1.0 83.80519  ? 442 PRO A CD  442 PRO A CD  1 
ATOM 3417  N N   . GLU A 1 443 ? 300.896 -32.420 281.645 1.0 86.77898  ? 443 GLU A N   443 GLU A N   1 
ATOM 3418  C CA  . GLU A 1 443 ? 300.970 -30.967 281.737 1.0 86.77898  ? 443 GLU A CA  443 GLU A CA  1 
ATOM 3419  C C   . GLU A 1 443 ? 299.610 -30.307 281.563 1.0 86.77898  ? 443 GLU A C   443 GLU A C   1 
ATOM 3420  O O   . GLU A 1 443 ? 299.317 -29.308 282.228 1.0 86.77898  ? 443 GLU A O   443 GLU A O   1 
ATOM 3421  C CB  . GLU A 1 443 ? 301.954 -30.429 280.701 1.0 86.77898  ? 443 GLU A CB  443 GLU A CB  1 
ATOM 3422  C CG  . GLU A 1 443 ? 303.397 -30.810 280.970 1.0 86.77898  ? 443 GLU A CG  443 GLU A CG  1 
ATOM 3423  C CD  . GLU A 1 443 ? 304.345 -30.258 279.928 1.0 86.77898  ? 443 GLU A CD  443 GLU A CD  1 
ATOM 3424  O OE1 . GLU A 1 443 ? 303.861 -29.700 278.920 1.0 86.77898  ? 443 GLU A OE1 443 GLU A OE1 1 
ATOM 3425  O OE2 . GLU A 1 443 ? 305.573 -30.374 280.120 1.0 86.77898  ? 443 GLU A OE2 443 GLU A OE2 1 
ATOM 3426  N N   . ASN A 1 444 ? 298.772 -30.840 280.682 1.0 83.81501  ? 444 ASN A N   444 ASN A N   1 
ATOM 3427  C CA  . ASN A 1 444 ? 297.494 -30.206 280.411 1.0 83.81501  ? 444 ASN A CA  444 ASN A CA  1 
ATOM 3428  C C   . ASN A 1 444 ? 296.446 -30.600 281.441 1.0 83.81501  ? 444 ASN A C   444 ASN A C   1 
ATOM 3429  O O   . ASN A 1 444 ? 296.518 -31.658 282.070 1.0 83.81501  ? 444 ASN A O   444 ASN A O   1 
ATOM 3430  C CB  . ASN A 1 444 ? 296.995 -30.544 279.001 1.0 83.81501  ? 444 ASN A CB  444 ASN A CB  1 
ATOM 3431  C CG  . ASN A 1 444 ? 296.910 -32.040 278.732 1.0 83.81501  ? 444 ASN A CG  444 ASN A CG  1 
ATOM 3432  O OD1 . ASN A 1 444 ? 297.271 -32.870 279.566 1.0 83.81501  ? 444 ASN A OD1 444 ASN A OD1 1 
ATOM 3433  N ND2 . ASN A 1 444 ? 296.396 -32.389 277.558 1.0 83.81501  ? 444 ASN A ND2 444 ASN A ND2 1 
ATOM 3434  N N   . HIS A 1 445 ? 295.465 -29.724 281.610 1.0 79.35329  ? 445 HIS A N   445 HIS A N   1 
ATOM 3435  C CA  . HIS A 1 445 ? 294.245 -30.073 282.310 1.0 79.35329  ? 445 HIS A CA  445 HIS A CA  1 
ATOM 3436  C C   . HIS A 1 445 ? 293.332 -30.821 281.345 1.0 79.35329  ? 445 HIS A C   445 HIS A C   1 
ATOM 3437  O O   . HIS A 1 445 ? 293.681 -31.048 280.182 1.0 79.35329  ? 445 HIS A O   445 HIS A O   1 
ATOM 3438  C CB  . HIS A 1 445 ? 293.579 -28.813 282.850 1.0 79.35329  ? 445 HIS A CB  445 HIS A CB  1 
ATOM 3439  C CG  . HIS A 1 445 ? 294.452 -28.027 283.775 1.0 79.35329  ? 445 HIS A CG  445 HIS A CG  1 
ATOM 3440  N ND1 . HIS A 1 445 ? 294.643 -28.374 285.093 1.0 79.35329  ? 445 HIS A ND1 445 HIS A ND1 1 
ATOM 3441  C CD2 . HIS A 1 445 ? 295.210 -26.926 283.564 1.0 79.35329  ? 445 HIS A CD2 445 HIS A CD2 1 
ATOM 3442  C CE1 . HIS A 1 445 ? 295.468 -27.514 285.659 1.0 79.35329  ? 445 HIS A CE1 445 HIS A CE1 1 
ATOM 3443  N NE2 . HIS A 1 445 ? 295.829 -26.625 284.752 1.0 79.35329  ? 445 HIS A NE2 445 HIS A NE2 1 
ATOM 3444  N N   . LEU A 1 446 ? 292.152 -31.212 281.840 1.0 75.22577  ? 446 LEU A N   446 LEU A N   1 
ATOM 3445  C CA  . LEU A 1 446 ? 291.080 -31.837 281.048 1.0 75.22577  ? 446 LEU A CA  446 LEU A CA  1 
ATOM 3446  C C   . LEU A 1 446 ? 291.530 -33.137 280.382 1.0 75.22577  ? 446 LEU A C   446 LEU A C   1 
ATOM 3447  O O   . LEU A 1 446 ? 291.066 -33.482 279.294 1.0 75.22577  ? 446 LEU A O   446 LEU A O   1 
ATOM 3448  C CB  . LEU A 1 446 ? 290.505 -30.874 279.996 1.0 75.22577  ? 446 LEU A CB  446 LEU A CB  1 
ATOM 3449  C CG  . LEU A 1 446 ? 289.508 -29.785 280.410 1.0 75.22577  ? 446 LEU A CG  446 LEU A CG  1 
ATOM 3450  C CD1 . LEU A 1 446 ? 290.176 -28.620 281.128 1.0 75.22577  ? 446 LEU A CD1 446 LEU A CD1 1 
ATOM 3451  C CD2 . LEU A 1 446 ? 288.741 -29.283 279.204 1.0 75.22577  ? 446 LEU A CD2 446 LEU A CD2 1 
ATOM 3452  N N   . SER A 1 447 ? 292.446 -33.857 281.017 1.0 73.68457  ? 447 SER A N   447 SER A N   1 
ATOM 3453  C CA  . SER A 1 447 ? 292.920 -35.144 280.540 1.0 73.68457  ? 447 SER A CA  447 SER A CA  1 
ATOM 3454  C C   . SER A 1 447 ? 292.681 -36.186 281.620 1.0 73.68457  ? 447 SER A C   447 SER A C   1 
ATOM 3455  O O   . SER A 1 447 ? 292.346 -35.863 282.759 1.0 73.68457  ? 447 SER A O   447 SER A O   1 
ATOM 3456  C CB  . SER A 1 447 ? 294.404 -35.090 280.170 1.0 73.68457  ? 447 SER A CB  447 SER A CB  1 
ATOM 3457  O OG  . SER A 1 447 ? 295.196 -34.877 281.320 1.0 73.68457  ? 447 SER A OG  447 SER A OG  1 
ATOM 3458  N N   . TYR A 1 448 ? 292.859 -37.453 281.260 1.0 68.59596  ? 448 TYR A N   448 TYR A N   1 
ATOM 3459  C CA  . TYR A 1 448 ? 292.596 -38.501 282.236 1.0 68.59596  ? 448 TYR A CA  448 TYR A CA  1 
ATOM 3460  C C   . TYR A 1 448 ? 293.732 -38.662 283.227 1.0 68.59596  ? 448 TYR A C   448 TYR A C   1 
ATOM 3461  O O   . TYR A 1 448 ? 293.476 -38.912 284.406 1.0 68.59596  ? 448 TYR A O   448 TYR A O   1 
ATOM 3462  C CB  . TYR A 1 448 ? 292.339 -39.830 281.545 1.0 68.59596  ? 448 TYR A CB  448 TYR A CB  1 
ATOM 3463  C CG  . TYR A 1 448 ? 291.987 -40.939 282.507 1.0 68.59596  ? 448 TYR A CG  448 TYR A CG  1 
ATOM 3464  C CD1 . TYR A 1 448 ? 290.758 -40.958 283.150 1.0 68.59596  ? 448 TYR A CD1 448 TYR A CD1 1 
ATOM 3465  C CD2 . TYR A 1 448 ? 292.876 -41.974 282.759 1.0 68.59596  ? 448 TYR A CD2 448 TYR A CD2 1 
ATOM 3466  C CE1 . TYR A 1 448 ? 290.428 -41.968 284.025 1.0 68.59596  ? 448 TYR A CE1 448 TYR A CE1 1 
ATOM 3467  C CE2 . TYR A 1 448 ? 292.553 -42.990 283.632 1.0 68.59596  ? 448 TYR A CE2 448 TYR A CE2 1 
ATOM 3468  C CZ  . TYR A 1 448 ? 291.328 -42.979 284.259 1.0 68.59596  ? 448 TYR A CZ  448 TYR A CZ  1 
ATOM 3469  O OH  . TYR A 1 448 ? 291.002 -43.988 285.129 1.0 68.59596  ? 448 TYR A OH  448 TYR A OH  1 
ATOM 3470  N N   . GLY A 1 449 ? 294.980 -38.514 282.780 1.0 72.49397  ? 449 GLY A N   449 GLY A N   1 
ATOM 3471  C CA  . GLY A 1 449 ? 296.116 -38.675 283.670 1.0 72.49397  ? 449 GLY A CA  449 GLY A CA  1 
ATOM 3472  C C   . GLY A 1 449 ? 296.235 -37.596 284.723 1.0 72.49397  ? 449 GLY A C   449 GLY A C   1 
ATOM 3473  O O   . GLY A 1 449 ? 296.921 -37.800 285.729 1.0 72.49397  ? 449 GLY A O   449 GLY A O   1 
ATOM 3474  N N   . TYR A 1 450 ? 295.578 -36.459 284.520 1.0 73.93564  ? 450 TYR A N   450 TYR A N   1 
ATOM 3475  C CA  . TYR A 1 450 ? 295.586 -35.372 285.484 1.0 73.93564  ? 450 TYR A CA  450 TYR A CA  1 
ATOM 3476  C C   . TYR A 1 450 ? 294.465 -35.495 286.509 1.0 73.93564  ? 450 TYR A C   450 TYR A C   1 
ATOM 3477  O O   . TYR A 1 450 ? 294.698 -35.289 287.703 1.0 73.93564  ? 450 TYR A O   450 TYR A O   1 
ATOM 3478  C CB  . TYR A 1 450 ? 295.475 -34.036 284.751 1.0 73.93564  ? 450 TYR A CB  450 TYR A CB  1 
ATOM 3479  C CG  . TYR A 1 450 ? 295.523 -32.834 285.654 1.0 73.93564  ? 450 TYR A CG  450 TYR A CG  1 
ATOM 3480  C CD1 . TYR A 1 450 ? 296.727 -32.382 286.170 1.0 73.93564  ? 450 TYR A CD1 450 TYR A CD1 1 
ATOM 3481  C CD2 . TYR A 1 450 ? 294.365 -32.149 285.986 1.0 73.93564  ? 450 TYR A CD2 450 TYR A CD2 1 
ATOM 3482  C CE1 . TYR A 1 450 ? 296.778 -31.283 286.994 1.0 73.93564  ? 450 TYR A CE1 450 TYR A CE1 1 
ATOM 3483  C CE2 . TYR A 1 450 ? 294.403 -31.058 286.815 1.0 73.93564  ? 450 TYR A CE2 450 TYR A CE2 1 
ATOM 3484  C CZ  . TYR A 1 450 ? 295.614 -30.623 287.311 1.0 73.93564  ? 450 TYR A CZ  450 TYR A CZ  1 
ATOM 3485  O OH  . TYR A 1 450 ? 295.662 -29.529 288.139 1.0 73.93564  ? 450 TYR A OH  450 TYR A OH  1 
ATOM 3486  N N   . ILE A 1 451 ? 293.246 -35.807 286.062 1.0 69.46721  ? 451 ILE A N   451 ILE A N   1 
ATOM 3487  C CA  . ILE A 1 451 ? 292.112 -35.897 286.977 1.0 69.46721  ? 451 ILE A CA  451 ILE A CA  1 
ATOM 3488  C C   . ILE A 1 451 ? 292.232 -37.137 287.851 1.0 69.46721  ? 451 ILE A C   451 ILE A C   1 
ATOM 3489  O O   . ILE A 1 451 ? 291.836 -37.124 289.024 1.0 69.46721  ? 451 ILE A O   451 ILE A O   1 
ATOM 3490  C CB  . ILE A 1 451 ? 290.797 -35.880 286.177 1.0 69.46721  ? 451 ILE A CB  451 ILE A CB  1 
ATOM 3491  C CG1 . ILE A 1 451 ? 290.722 -34.625 285.320 1.0 69.46721  ? 451 ILE A CG1 451 ILE A CG1 1 
ATOM 3492  C CG2 . ILE A 1 451 ? 289.592 -35.858 287.092 1.0 69.46721  ? 451 ILE A CG2 451 ILE A CG2 1 
ATOM 3493  C CD1 . ILE A 1 451 ? 289.618 -34.671 284.300 1.0 69.46721  ? 451 ILE A CD1 451 ILE A CD1 1 
ATOM 3494  N N   . ASN A 1 452 ? 292.807 -38.213 287.312 1.0 69.88401  ? 452 ASN A N   452 ASN A N   1 
ATOM 3495  C CA  . ASN A 1 452 ? 293.012 -39.423 288.097 1.0 69.88401  ? 452 ASN A CA  452 ASN A CA  1 
ATOM 3496  C C   . ASN A 1 452 ? 294.054 -39.211 289.183 1.0 69.88401  ? 452 ASN A C   452 ASN A C   1 
ATOM 3497  O O   . ASN A 1 452 ? 293.943 -39.791 290.266 1.0 69.88401  ? 452 ASN A O   452 ASN A O   1 
ATOM 3498  C CB  . ASN A 1 452 ? 293.446 -40.559 287.182 1.0 69.88401  ? 452 ASN A CB  452 ASN A CB  1 
ATOM 3499  C CG  . ASN A 1 452 ? 293.044 -41.913 287.689 1.0 69.88401  ? 452 ASN A CG  452 ASN A CG  1 
ATOM 3500  O OD1 . ASN A 1 452 ? 293.097 -42.877 286.941 1.0 69.88401  ? 452 ASN A OD1 452 ASN A OD1 1 
ATOM 3501  N ND2 . ASN A 1 452 ? 292.605 -41.997 288.941 1.0 69.88401  ? 452 ASN A ND2 452 ASN A ND2 1 
ATOM 3502  N N   . GLY A 1 453 ? 295.059 -38.376 288.920 1.0 72.45479  ? 453 GLY A N   453 GLY A N   1 
ATOM 3503  C CA  . GLY A 1 453 ? 296.168 -38.248 289.843 1.0 72.45479  ? 453 GLY A CA  453 GLY A CA  1 
ATOM 3504  C C   . GLY A 1 453 ? 295.904 -37.374 291.045 1.0 72.45479  ? 453 GLY A C   453 GLY A C   1 
ATOM 3505  O O   . GLY A 1 453 ? 296.636 -37.472 292.032 1.0 72.45479  ? 453 GLY A O   453 GLY A O   1 
ATOM 3506  N N   . ARG A 1 454 ? 294.886 -36.524 290.993 1.0 71.41138  ? 454 ARG A N   454 ARG A N   1 
ATOM 3507  C CA  . ARG A 1 454 ? 294.642 -35.577 292.069 1.0 71.41138  ? 454 ARG A CA  454 ARG A CA  1 
ATOM 3508  C C   . ARG A 1 454 ? 293.697 -36.158 293.109 1.0 71.41138  ? 454 ARG A C   454 ARG A C   1 
ATOM 3509  O O   . ARG A 1 454 ? 292.817 -36.964 292.801 1.0 71.41138  ? 454 ARG A O   454 ARG A O   1 
ATOM 3510  C CB  . ARG A 1 454 ? 294.074 -34.271 291.523 1.0 71.41138  ? 454 ARG A CB  454 ARG A CB  1 
ATOM 3511  C CG  . ARG A 1 454 ? 295.055 -33.495 290.679 1.0 71.41138  ? 454 ARG A CG  454 ARG A CG  1 
ATOM 3512  C CD  . ARG A 1 454 ? 294.438 -32.216 290.174 1.0 71.41138  ? 454 ARG A CD  454 ARG A CD  1 
ATOM 3513  N NE  . ARG A 1 454 ? 294.159 -31.252 291.231 1.0 71.41138  ? 454 ARG A NE  454 ARG A NE  1 
ATOM 3514  C CZ  . ARG A 1 454 ? 295.030 -30.345 291.656 1.0 71.41138  ? 454 ARG A CZ  454 ARG A CZ  1 
ATOM 3515  N NH1 . ARG A 1 454 ? 296.236 -30.285 291.119 1.0 71.41138  ? 454 ARG A NH1 454 ARG A NH1 1 
ATOM 3516  N NH2 . ARG A 1 454 ? 294.694 -29.498 292.616 1.0 71.41138  ? 454 ARG A NH2 454 ARG A NH2 1 
ATOM 3517  N N   . LEU A 1 455 ? 293.896 -35.744 294.354 1.0 71.84446  ? 455 LEU A N   455 LEU A N   1 
ATOM 3518  C CA  . LEU A 1 455 ? 293.146 -36.254 295.487 1.0 71.84446  ? 455 LEU A CA  455 LEU A CA  1 
ATOM 3519  C C   . LEU A 1 455 ? 292.595 -35.091 296.297 1.0 71.84446  ? 455 LEU A C   455 LEU A C   1 
ATOM 3520  O O   . LEU A 1 455 ? 293.223 -34.032 296.368 1.0 71.84446  ? 455 LEU A O   455 LEU A O   1 
ATOM 3521  C CB  . LEU A 1 455 ? 294.024 -37.148 296.378 1.0 71.84446  ? 455 LEU A CB  455 LEU A CB  1 
ATOM 3522  C CG  . LEU A 1 455 ? 294.250 -38.586 295.891 1.0 71.84446  ? 455 LEU A CG  455 LEU A CG  1 
ATOM 3523  C CD1 . LEU A 1 455 ? 295.361 -38.723 294.858 1.0 71.84446  ? 455 LEU A CD1 455 LEU A CD1 1 
ATOM 3524  C CD2 . LEU A 1 455 ? 294.483 -39.527 297.045 1.0 71.84446  ? 455 LEU A CD2 455 LEU A CD2 1 
ATOM 3525  N N   . PRO A 1 456 ? 291.422 -35.248 296.905 1.0 68.90496  ? 456 PRO A N   456 PRO A N   1 
ATOM 3526  C CA  . PRO A 1 456 ? 290.800 -34.124 297.608 1.0 68.90496  ? 456 PRO A CA  456 PRO A CA  1 
ATOM 3527  C C   . PRO A 1 456 ? 291.400 -33.874 298.982 1.0 68.90496  ? 456 PRO A C   456 PRO A C   1 
ATOM 3528  O O   . PRO A 1 456 ? 291.976 -34.758 299.617 1.0 68.90496  ? 456 PRO A O   456 PRO A O   1 
ATOM 3529  C CB  . PRO A 1 456 ? 289.343 -34.563 297.740 1.0 68.90496  ? 456 PRO A CB  456 PRO A CB  1 
ATOM 3530  C CG  . PRO A 1 456 ? 289.401 -36.023 297.750 1.0 68.90496  ? 456 PRO A CG  456 PRO A CG  1 
ATOM 3531  C CD  . PRO A 1 456 ? 290.513 -36.405 296.832 1.0 68.90496  ? 456 PRO A CD  456 PRO A CD  1 
ATOM 3532  N N   . LEU A 1 457 ? 291.230 -32.633 299.436 1.0 71.60904  ? 457 LEU A N   457 LEU A N   1 
ATOM 3533  C CA  . LEU A 1 457 ? 291.634 -32.246 300.776 1.0 71.60904  ? 457 LEU A CA  457 LEU A CA  1 
ATOM 3534  C C   . LEU A 1 457 ? 290.765 -32.955 301.814 1.0 71.60904  ? 457 LEU A C   457 LEU A C   1 
ATOM 3535  O O   . LEU A 1 457 ? 289.598 -33.253 301.553 1.0 71.60904  ? 457 LEU A O   457 LEU A O   1 
ATOM 3536  C CB  . LEU A 1 457 ? 291.521 -30.734 300.942 1.0 71.60904  ? 457 LEU A CB  457 LEU A CB  1 
ATOM 3537  C CG  . LEU A 1 457 ? 292.494 -29.891 300.122 1.0 71.60904  ? 457 LEU A CG  457 LEU A CG  1 
ATOM 3538  C CD1 . LEU A 1 457 ? 292.155 -28.419 300.255 1.0 71.60904  ? 457 LEU A CD1 457 LEU A CD1 1 
ATOM 3539  C CD2 . LEU A 1 457 ? 293.918 -30.149 300.564 1.0 71.60904  ? 457 LEU A CD2 457 LEU A CD2 1 
ATOM 3540  N N   . PRO A 1 458 ? 291.318 -33.258 302.994 1.0 72.60886  ? 458 PRO A N   458 PRO A N   1 
ATOM 3541  C CA  . PRO A 1 458 ? 290.560 -34.085 303.947 1.0 72.60886  ? 458 PRO A CA  458 PRO A CA  1 
ATOM 3542  C C   . PRO A 1 458 ? 289.411 -33.367 304.637 1.0 72.60886  ? 458 PRO A C   458 PRO A C   1 
ATOM 3543  O O   . PRO A 1 458 ? 288.328 -33.949 304.768 1.0 72.60886  ? 458 PRO A O   458 PRO A O   1 
ATOM 3544  C CB  . PRO A 1 458 ? 291.633 -34.522 304.952 1.0 72.60886  ? 458 PRO A CB  458 PRO A CB  1 
ATOM 3545  C CG  . PRO A 1 458 ? 292.921 -34.378 304.223 1.0 72.60886  ? 458 PRO A CG  458 PRO A CG  1 
ATOM 3546  C CD  . PRO A 1 458 ? 292.741 -33.180 303.358 1.0 72.60886  ? 458 PRO A CD  458 PRO A CD  1 
ATOM 3547  N N   . ASN A 1 459 ? 289.600 -32.131 305.089 1.0 73.64962  ? 459 ASN A N   459 ASN A N   1 
ATOM 3548  C CA  . ASN A 1 459 ? 288.625 -31.505 305.975 1.0 73.64962  ? 459 ASN A CA  459 ASN A CA  1 
ATOM 3549  C C   . ASN A 1 459 ? 287.490 -30.795 305.255 1.0 73.64962  ? 459 ASN A C   459 ASN A C   1 
ATOM 3550  O O   . ASN A 1 459 ? 286.707 -30.108 305.918 1.0 73.64962  ? 459 ASN A O   459 ASN A O   1 
ATOM 3551  C CB  . ASN A 1 459 ? 289.300 -30.497 306.906 1.0 73.64962  ? 459 ASN A CB  459 ASN A CB  1 
ATOM 3552  C CG  . ASN A 1 459 ? 290.103 -31.156 307.996 1.0 73.64962  ? 459 ASN A CG  459 ASN A CG  1 
ATOM 3553  O OD1 . ASN A 1 459 ? 289.719 -32.197 308.525 1.0 73.64962  ? 459 ASN A OD1 459 ASN A OD1 1 
ATOM 3554  N ND2 . ASN A 1 459 ? 291.207 -30.526 308.372 1.0 73.64962  ? 459 ASN A ND2 459 ASN A ND2 1 
ATOM 3555  N N   . ILE A 1 460 ? 287.375 -30.915 303.933 1.0 72.47856  ? 460 ILE A N   460 ILE A N   1 
ATOM 3556  C CA  . ILE A 1 460 ? 286.288 -30.198 303.277 1.0 72.47856  ? 460 ILE A CA  460 ILE A CA  1 
ATOM 3557  C C   . ILE A 1 460 ? 284.960 -30.917 303.488 1.0 72.47856  ? 460 ILE A C   460 ILE A C   1 
ATOM 3558  O O   . ILE A 1 460 ? 283.919 -30.266 303.628 1.0 72.47856  ? 460 ILE A O   460 ILE A O   1 
ATOM 3559  C CB  . ILE A 1 460 ? 286.608 -29.950 301.788 1.0 72.47856  ? 460 ILE A CB  460 ILE A CB  1 
ATOM 3560  C CG1 . ILE A 1 460 ? 286.984 -31.235 301.045 1.0 72.47856  ? 460 ILE A CG1 460 ILE A CG1 1 
ATOM 3561  C CG2 . ILE A 1 460 ? 287.713 -28.916 301.638 1.0 72.47856  ? 460 ILE A CG2 460 ILE A CG2 1 
ATOM 3562  C CD1 . ILE A 1 460 ? 285.836 -31.906 300.317 1.0 72.47856  ? 460 ILE A CD1 460 ILE A CD1 1 
ATOM 3563  N N   . VAL A 1 461 ? 284.962 -32.252 303.513 1.0 71.10738  ? 461 VAL A N   461 VAL A N   1 
ATOM 3564  C CA  . VAL A 1 461 ? 283.796 -33.037 303.899 1.0 71.10738  ? 461 VAL A CA  461 VAL A CA  1 
ATOM 3565  C C   . VAL A 1 461 ? 284.247 -34.143 304.840 1.0 71.10738  ? 461 VAL A C   461 VAL A C   1 
ATOM 3566  O O   . VAL A 1 461 ? 285.397 -34.593 304.800 1.0 71.10738  ? 461 VAL A O   461 VAL A O   1 
ATOM 3567  C CB  . VAL A 1 461 ? 283.010 -33.658 302.708 1.0 71.10738  ? 461 VAL A CB  461 VAL A CB  1 
ATOM 3568  C CG1 . VAL A 1 461 ? 282.425 -32.601 301.797 1.0 71.10738  ? 461 VAL A CG1 461 VAL A CG1 1 
ATOM 3569  C CG2 . VAL A 1 461 ? 283.860 -34.626 301.924 1.0 71.10738  ? 461 VAL A CG2 461 VAL A CG2 1 
ATOM 3570  N N   . ASP A 1 462 ? 283.325 -34.559 305.699 1.0 71.46771  ? 462 ASP A N   462 ASP A N   1 
ATOM 3571  C CA  . ASP A 1 462 ? 283.465 -35.695 306.600 1.0 71.46771  ? 462 ASP A CA  462 ASP A CA  1 
ATOM 3572  C C   . ASP A 1 462 ? 282.048 -36.027 307.056 1.0 71.46771  ? 462 ASP A C   462 ASP A C   1 
ATOM 3573  O O   . ASP A 1 462 ? 281.077 -35.485 306.524 1.0 71.46771  ? 462 ASP A O   462 ASP A O   1 
ATOM 3574  C CB  . ASP A 1 462 ? 284.423 -35.360 307.751 1.0 71.46771  ? 462 ASP A CB  462 ASP A CB  1 
ATOM 3575  C CG  . ASP A 1 462 ? 284.957 -36.588 308.462 1.0 71.46771  ? 462 ASP A CG  462 ASP A CG  1 
ATOM 3576  O OD1 . ASP A 1 462 ? 284.568 -37.712 308.084 1.0 71.46771  ? 462 ASP A OD1 462 ASP A OD1 1 
ATOM 3577  O OD2 . ASP A 1 462 ? 285.760 -36.420 309.405 1.0 71.46771  ? 462 ASP A OD2 462 ASP A OD2 1 
ATOM 3578  N N   . THR A 1 463 ? 281.908 -36.889 308.056 1.0 68.98503  ? 463 THR A N   463 THR A N   1 
ATOM 3579  C CA  . THR A 1 463 ? 280.574 -37.187 308.558 1.0 68.98503  ? 463 THR A CA  463 THR A CA  1 
ATOM 3580  C C   . THR A 1 463 ? 280.010 -36.096 309.466 1.0 68.98503  ? 463 THR A C   463 THR A C   1 
ATOM 3581  O O   . THR A 1 463 ? 278.888 -36.251 309.959 1.0 68.98503  ? 463 THR A O   463 THR A O   1 
ATOM 3582  C CB  . THR A 1 463 ? 280.580 -38.530 309.289 1.0 68.98503  ? 463 THR A CB  463 THR A CB  1 
ATOM 3583  O OG1 . THR A 1 463 ? 279.248 -38.867 309.691 1.0 68.98503  ? 463 THR A OG1 463 THR A OG1 1 
ATOM 3584  C CG2 . THR A 1 463 ? 281.465 -38.466 310.496 1.0 68.98503  ? 463 THR A CG2 463 THR A CG2 1 
ATOM 3585  N N   . TRP A 1 464 ? 280.734 -34.994 309.686 1.0 67.27778  ? 464 TRP A N   464 TRP A N   1 
ATOM 3586  C CA  . TRP A 1 464 ? 280.242 -33.888 310.493 1.0 67.27778  ? 464 TRP A CA  464 TRP A CA  1 
ATOM 3587  C C   . TRP A 1 464 ? 279.807 -32.667 309.697 1.0 67.27778  ? 464 TRP A C   464 TRP A C   1 
ATOM 3588  O O   . TRP A 1 464 ? 279.265 -31.734 310.298 1.0 67.27778  ? 464 TRP A O   464 TRP A O   1 
ATOM 3589  C CB  . TRP A 1 464 ? 281.304 -33.434 311.509 1.0 67.27778  ? 464 TRP A CB  464 TRP A CB  1 
ATOM 3590  C CG  . TRP A 1 464 ? 282.623 -33.017 310.905 1.0 67.27778  ? 464 TRP A CG  464 TRP A CG  1 
ATOM 3591  C CD1 . TRP A 1 464 ? 283.715 -33.798 310.754 1.0 67.27778  ? 464 TRP A CD1 464 TRP A CD1 1 
ATOM 3592  C CD2 . TRP A 1 464 ? 282.979 -31.727 310.369 1.0 67.27778  ? 464 TRP A CD2 464 TRP A CD2 1 
ATOM 3593  N NE1 . TRP A 1 464 ? 284.734 -33.086 310.169 1.0 67.27778  ? 464 TRP A NE1 464 TRP A NE1 1 
ATOM 3594  C CE2 . TRP A 1 464 ? 284.303 -31.814 309.919 1.0 67.27778  ? 464 TRP A CE2 464 TRP A CE2 1 
ATOM 3595  C CE3 . TRP A 1 464 ? 282.304 -30.511 310.233 1.0 67.27778  ? 464 TRP A CE3 464 TRP A CE3 1 
ATOM 3596  C CZ2 . TRP A 1 464 ? 284.966 -30.740 309.340 1.0 67.27778  ? 464 TRP A CZ2 464 TRP A CZ2 1 
ATOM 3597  C CZ3 . TRP A 1 464 ? 282.963 -29.448 309.655 1.0 67.27778  ? 464 TRP A CZ3 464 TRP A CZ3 1 
ATOM 3598  C CH2 . TRP A 1 464 ? 284.275 -29.573 309.207 1.0 67.27778  ? 464 TRP A CH2 464 TRP A CH2 1 
ATOM 3599  N N   . THR A 1 465 ? 280.060 -32.608 308.390 1.0 66.00146  ? 465 THR A N   465 THR A N   1 
ATOM 3600  C CA  . THR A 1 465 ? 279.907 -31.341 307.684 1.0 66.00146  ? 465 THR A CA  465 THR A CA  1 
ATOM 3601  C C   . THR A 1 465 ? 278.437 -31.030 307.411 1.0 66.00146  ? 465 THR A C   465 THR A C   1 
ATOM 3602  O O   . THR A 1 465 ? 277.709 -31.838 306.819 1.0 66.00146  ? 465 THR A O   465 THR A O   1 
ATOM 3603  C CB  . THR A 1 465 ? 280.752 -31.308 306.401 1.0 66.00146  ? 465 THR A CB  465 THR A CB  1 
ATOM 3604  O OG1 . THR A 1 465 ? 280.555 -30.059 305.727 1.0 66.00146  ? 465 THR A OG1 465 THR A OG1 1 
ATOM 3605  C CG2 . THR A 1 465 ? 280.482 -32.469 305.460 1.0 66.00146  ? 465 THR A CG2 465 THR A CG2 1 
ATOM 3606  N N   . ASP A 1 466 ? 278.015 -29.850 307.884 1.0 63.98846  ? 466 ASP A N   466 ASP A N   1 
ATOM 3607  C CA  . ASP A 1 466 ? 276.618 -29.409 307.924 1.0 63.98846  ? 466 ASP A CA  466 ASP A CA  1 
ATOM 3608  C C   . ASP A 1 466 ? 275.728 -30.479 308.545 1.0 63.98846  ? 466 ASP A C   466 ASP A C   1 
ATOM 3609  O O   . ASP A 1 466 ? 274.799 -30.991 307.918 1.0 63.98846  ? 466 ASP A O   466 ASP A O   1 
ATOM 3610  C CB  . ASP A 1 466 ? 276.126 -29.011 306.534 1.0 63.98846  ? 466 ASP A CB  466 ASP A CB  1 
ATOM 3611  C CG  . ASP A 1 466 ? 276.795 -27.751 306.026 1.0 63.98846  ? 466 ASP A CG  466 ASP A CG  1 
ATOM 3612  O OD1 . ASP A 1 466 ? 277.171 -26.904 306.863 1.0 63.98846  ? 466 ASP A OD1 466 ASP A OD1 1 
ATOM 3613  O OD2 . ASP A 1 466 ? 276.955 -27.611 304.796 1.0 63.98846  ? 466 ASP A OD2 466 ASP A OD2 1 
ATOM 3614  N N   . ILE A 1 467 ? 276.060 -30.849 309.783 1.0 62.77293  ? 467 ILE A N   467 ILE A N   1 
ATOM 3615  C CA  . ILE A 1 467 ? 275.464 -32.027 310.394 1.0 62.77293  ? 467 ILE A CA  467 ILE A CA  1 
ATOM 3616  C C   . ILE A 1 467 ? 274.015 -31.738 310.757 1.0 62.77293  ? 467 ILE A C   467 ILE A C   1 
ATOM 3617  O O   . ILE A 1 467 ? 273.674 -30.658 311.256 1.0 62.77293  ? 467 ILE A O   467 ILE A O   1 
ATOM 3618  C CB  . ILE A 1 467 ? 276.315 -32.494 311.589 1.0 62.77293  ? 467 ILE A CB  467 ILE A CB  1 
ATOM 3619  C CG1 . ILE A 1 467 ? 275.812 -33.828 312.131 1.0 62.77293  ? 467 ILE A CG1 467 ILE A CG1 1 
ATOM 3620  C CG2 . ILE A 1 467 ? 276.444 -31.427 312.672 1.0 62.77293  ? 467 ILE A CG2 467 ILE A CG2 1 
ATOM 3621  C CD1 . ILE A 1 467 ? 275.957 -34.960 311.158 1.0 62.77293  ? 467 ILE A CD1 467 ILE A CD1 1 
ATOM 3622  N N   . GLY A 1 468 ? 273.139 -32.675 310.416 1.0 62.0846   ? 468 GLY A N   468 GLY A N   1 
ATOM 3623  C CA  . GLY A 1 468 ? 271.718 -32.483 310.566 1.0 62.0846   ? 468 GLY A CA  468 GLY A CA  1 
ATOM 3624  C C   . GLY A 1 468 ? 271.071 -31.616 309.513 1.0 62.0846   ? 468 GLY A C   468 GLY A C   1 
ATOM 3625  O O   . GLY A 1 468 ? 269.859 -31.385 309.591 1.0 62.0846   ? 468 GLY A O   468 GLY A O   1 
ATOM 3626  N N   . ALA A 1 469 ? 271.825 -31.133 308.531 1.0 61.15503  ? 469 ALA A N   469 ALA A N   1 
ATOM 3627  C CA  . ALA A 1 469 ? 271.326 -30.178 307.554 1.0 61.15503  ? 469 ALA A CA  469 ALA A CA  1 
ATOM 3628  C C   . ALA A 1 469 ? 271.268 -30.817 306.178 1.0 61.15503  ? 469 ALA A C   469 ALA A C   1 
ATOM 3629  O O   . ALA A 1 469 ? 272.267 -31.361 305.699 1.0 61.15503  ? 469 ALA A O   469 ALA A O   1 
ATOM 3630  C CB  . ALA A 1 469 ? 272.203 -28.927 307.502 1.0 61.15503  ? 469 ALA A CB  469 ALA A CB  1 
ATOM 3631  N N   . ARG A 1 470 ? 270.099 -30.746 305.547 1.0 60.40916  ? 470 ARG A N   470 ARG A N   1 
ATOM 3632  C CA  . ARG A 1 470 ? 269.959 -31.086 304.134 1.0 60.40916  ? 470 ARG A CA  470 ARG A CA  1 
ATOM 3633  C C   . ARG A 1 470 ? 270.425 -29.870 303.349 1.0 60.40916  ? 470 ARG A C   470 ARG A C   1 
ATOM 3634  O O   . ARG A 1 470 ? 269.710 -28.884 303.176 1.0 60.40916  ? 470 ARG A O   470 ARG A O   1 
ATOM 3635  C CB  . ARG A 1 470 ? 268.523 -31.486 303.821 1.0 60.40916  ? 470 ARG A CB  470 ARG A CB  1 
ATOM 3636  C CG  . ARG A 1 470 ? 268.217 -31.825 302.378 1.0 60.40916  ? 470 ARG A CG  470 ARG A CG  1 
ATOM 3637  C CD  . ARG A 1 470 ? 267.447 -30.705 301.716 1.0 60.40916  ? 470 ARG A CD  470 ARG A CD  1 
ATOM 3638  N NE  . ARG A 1 470 ? 267.085 -31.021 300.336 1.0 60.40916  ? 470 ARG A NE  470 ARG A NE  1 
ATOM 3639  C CZ  . ARG A 1 470 ? 265.990 -31.686 299.992 1.0 60.40916  ? 470 ARG A CZ  470 ARG A CZ  1 
ATOM 3640  N NH1 . ARG A 1 470 ? 265.155 -32.116 300.921 1.0 60.40916  ? 470 ARG A NH1 470 ARG A NH1 1 
ATOM 3641  N NH2 . ARG A 1 470 ? 265.735 -31.926 298.717 1.0 60.40916  ? 470 ARG A NH2 470 ARG A NH2 1 
ATOM 3642  N N   . TRP A 1 471 ? 271.671 -29.932 302.900 1.0 59.83612  ? 471 TRP A N   471 TRP A N   1 
ATOM 3643  C CA  . TRP A 1 471 ? 272.331 -28.774 302.321 1.0 59.83612  ? 471 TRP A CA  471 TRP A CA  1 
ATOM 3644  C C   . TRP A 1 471 ? 273.381 -29.224 301.322 1.0 59.83612  ? 471 TRP A C   471 TRP A C   1 
ATOM 3645  O O   . TRP A 1 471 ? 274.333 -29.920 301.687 1.0 59.83612  ? 471 TRP A O   471 TRP A O   1 
ATOM 3646  C CB  . TRP A 1 471 ? 272.976 -27.921 303.411 1.0 59.83612  ? 471 TRP A CB  471 TRP A CB  1 
ATOM 3647  C CG  . TRP A 1 471 ? 273.611 -26.686 302.890 1.0 59.83612  ? 471 TRP A CG  471 TRP A CG  1 
ATOM 3648  C CD1 . TRP A 1 471 ? 274.929 -26.499 302.633 1.0 59.83612  ? 471 TRP A CD1 471 TRP A CD1 1 
ATOM 3649  C CD2 . TRP A 1 471 ? 272.960 -25.450 302.577 1.0 59.83612  ? 471 TRP A CD2 471 TRP A CD2 1 
ATOM 3650  N NE1 . TRP A 1 471 ? 275.143 -25.231 302.159 1.0 59.83612  ? 471 TRP A NE1 471 TRP A NE1 1 
ATOM 3651  C CE2 . TRP A 1 471 ? 273.947 -24.569 302.109 1.0 59.83612  ? 471 TRP A CE2 471 TRP A CE2 1 
ATOM 3652  C CE3 . TRP A 1 471 ? 271.641 -25.005 302.649 1.0 59.83612  ? 471 TRP A CE3 471 TRP A CE3 1 
ATOM 3653  C CZ2 . TRP A 1 471 ? 273.662 -23.264 301.737 1.0 59.83612  ? 471 TRP A CZ2 471 TRP A CZ2 1 
ATOM 3654  C CZ3 . TRP A 1 471 ? 271.358 -23.719 302.258 1.0 59.83612  ? 471 TRP A CZ3 471 TRP A CZ3 1 
ATOM 3655  C CH2 . TRP A 1 471 ? 272.364 -22.860 301.816 1.0 59.83612  ? 471 TRP A CH2 471 TRP A CH2 1 
ATOM 3656  N N   . SER A 1 472 ? 273.206 -28.826 300.069 1.0 61.64656  ? 472 SER A N   472 SER A N   1 
ATOM 3657  C CA  . SER A 1 472 ? 274.221 -29.064 299.059 1.0 61.64656  ? 472 SER A CA  472 SER A CA  1 
ATOM 3658  C C   . SER A 1 472 ? 275.383 -28.103 299.248 1.0 61.64656  ? 472 SER A C   472 SER A C   1 
ATOM 3659  O O   . SER A 1 472 ? 275.198 -26.953 299.646 1.0 61.64656  ? 472 SER A O   472 SER A O   1 
ATOM 3660  C CB  . SER A 1 472 ? 273.640 -28.874 297.668 1.0 61.64656  ? 472 SER A CB  472 SER A CB  1 
ATOM 3661  O OG  . SER A 1 472 ? 273.324 -27.514 297.449 1.0 61.64656  ? 472 SER A OG  472 SER A OG  1 
ATOM 3662  N N   . LEU A 1 473 ? 276.585 -28.582 298.930 1.0 64.08096  ? 473 LEU A N   473 LEU A N   1 
ATOM 3663  C CA  . LEU A 1 473 ? 277.799 -27.805 299.146 1.0 64.08096  ? 473 LEU A CA  473 LEU A CA  1 
ATOM 3664  C C   . LEU A 1 473 ? 277.828 -26.563 298.265 1.0 64.08096  ? 473 LEU A C   473 LEU A C   1 
ATOM 3665  O O   . LEU A 1 473 ? 277.395 -26.590 297.111 1.0 64.08096  ? 473 LEU A O   473 LEU A O   1 
ATOM 3666  C CB  . LEU A 1 473 ? 279.029 -28.659 298.868 1.0 64.08096  ? 473 LEU A CB  473 LEU A CB  1 
ATOM 3667  C CG  . LEU A 1 473 ? 279.296 -29.808 299.830 1.0 64.08096  ? 473 LEU A CG  473 LEU A CG  1 
ATOM 3668  C CD1 . LEU A 1 473 ? 280.483 -30.602 299.337 1.0 64.08096  ? 473 LEU A CD1 473 LEU A CD1 1 
ATOM 3669  C CD2 . LEU A 1 473 ? 279.544 -29.266 301.220 1.0 64.08096  ? 473 LEU A CD2 473 LEU A CD2 1 
ATOM 3670  N N   . ASP A 1 474 ? 278.343 -25.468 298.829 1.0 67.62441  ? 474 ASP A N   474 ASP A N   1 
ATOM 3671  C CA  . ASP A 1 474 ? 278.315 -24.175 298.156 1.0 67.62441  ? 474 ASP A CA  474 ASP A CA  1 
ATOM 3672  C C   . ASP A 1 474 ? 279.229 -24.124 296.943 1.0 67.62441  ? 474 ASP A C   474 ASP A C   1 
ATOM 3673  O O   . ASP A 1 474 ? 279.018 -23.287 296.060 1.0 67.62441  ? 474 ASP A O   474 ASP A O   1 
ATOM 3674  C CB  . ASP A 1 474 ? 278.702 -23.070 299.137 1.0 67.62441  ? 474 ASP A CB  474 ASP A CB  1 
ATOM 3675  C CG  . ASP A 1 474 ? 277.651 -22.843 300.199 1.0 67.62441  ? 474 ASP A CG  474 ASP A CG  1 
ATOM 3676  O OD1 . ASP A 1 474 ? 276.458 -23.071 299.912 1.0 67.62441  ? 474 ASP A OD1 474 ASP A OD1 1 
ATOM 3677  O OD2 . ASP A 1 474 ? 278.016 -22.439 301.323 1.0 67.62441  ? 474 ASP A OD2 474 ASP A OD2 1 
ATOM 3678  N N   . VAL A 1 475 ? 280.227 -24.999 296.876 1.0 65.37244  ? 475 VAL A N   475 VAL A N   1 
ATOM 3679  C CA  . VAL A 1 475 ? 281.129 -25.037 295.735 1.0 65.37244  ? 475 VAL A CA  475 VAL A CA  1 
ATOM 3680  C C   . VAL A 1 475 ? 280.780 -26.142 294.746 1.0 65.37244  ? 475 VAL A C   475 VAL A C   1 
ATOM 3681  O O   . VAL A 1 475 ? 281.248 -26.098 293.598 1.0 65.37244  ? 475 VAL A O   475 VAL A O   1 
ATOM 3682  C CB  . VAL A 1 475 ? 282.584 -25.177 296.215 1.0 65.37244  ? 475 VAL A CB  475 VAL A CB  1 
ATOM 3683  C CG1 . VAL A 1 475 ? 282.952 -23.964 297.042 1.0 65.37244  ? 475 VAL A CG1 475 VAL A CG1 1 
ATOM 3684  C CG2 . VAL A 1 475 ? 282.737 -26.441 297.031 1.0 65.37244  ? 475 VAL A CG2 475 VAL A CG2 1 
ATOM 3685  N N   . MET A 1 476 ? 279.974 -27.119 295.146 1.0 64.84229  ? 476 MET A N   476 MET A N   1 
ATOM 3686  C CA  . MET A 1 476 ? 279.483 -28.152 294.247 1.0 64.84229  ? 476 MET A CA  476 MET A CA  1 
ATOM 3687  C C   . MET A 1 476 ? 278.228 -27.736 293.498 1.0 64.84229  ? 476 MET A C   476 MET A C   1 
ATOM 3688  O O   . MET A 1 476 ? 277.672 -28.553 292.760 1.0 64.84229  ? 476 MET A O   476 MET A O   1 
ATOM 3689  C CB  . MET A 1 476 ? 279.191 -29.434 295.028 1.0 64.84229  ? 476 MET A CB  476 MET A CB  1 
ATOM 3690  C CG  . MET A 1 476 ? 280.412 -30.110 295.593 1.0 64.84229  ? 476 MET A CG  476 MET A CG  1 
ATOM 3691  S SD  . MET A 1 476 ? 281.486 -30.675 294.275 1.0 64.84229  ? 476 MET A SD  476 MET A SD  1 
ATOM 3692  C CE  . MET A 1 476 ? 280.466 -31.974 293.594 1.0 64.84229  ? 476 MET A CE  476 MET A CE  1 
ATOM 3693  N N   . ASP A 1 477 ? 277.758 -26.502 293.684 1.0 64.68665  ? 477 ASP A N   477 ASP A N   1 
ATOM 3694  C CA  . ASP A 1 477 ? 276.528 -26.072 293.027 1.0 64.68665  ? 477 ASP A CA  477 ASP A CA  1 
ATOM 3695  C C   . ASP A 1 477 ? 276.750 -25.844 291.542 1.0 64.68665  ? 477 ASP A C   477 ASP A C   1 
ATOM 3696  O O   . ASP A 1 477 ? 275.983 -26.334 290.707 1.0 64.68665  ? 477 ASP A O   477 ASP A O   1 
ATOM 3697  C CB  . ASP A 1 477 ? 276.000 -24.804 293.686 1.0 64.68665  ? 477 ASP A CB  477 ASP A CB  1 
ATOM 3698  C CG  . ASP A 1 477 ? 275.484 -25.054 295.072 1.0 64.68665  ? 477 ASP A CG  477 ASP A CG  1 
ATOM 3699  O OD1 . ASP A 1 477 ? 274.996 -26.176 295.319 1.0 64.68665  ? 477 ASP A OD1 477 ASP A OD1 1 
ATOM 3700  O OD2 . ASP A 1 477 ? 275.577 -24.139 295.915 1.0 64.68665  ? 477 ASP A OD2 477 ASP A OD2 1 
ATOM 3701  N N   . THR A 1 478 ? 277.793 -25.102 291.193 1.0 62.94657  ? 478 THR A N   478 THR A N   1 
ATOM 3702  C CA  . THR A 1 478 ? 278.155 -24.884 289.796 1.0 62.94657  ? 478 THR A CA  478 THR A CA  1 
ATOM 3703  C C   . THR A 1 478 ? 279.149 -25.928 289.295 1.0 62.94657  ? 478 THR A C   478 THR A C   1 
ATOM 3704  O O   . THR A 1 478 ? 280.149 -25.635 288.644 1.0 62.94657  ? 478 THR A O   478 THR A O   1 
ATOM 3705  C CB  . THR A 1 478 ? 278.695 -23.471 289.635 1.0 62.94657  ? 478 THR A CB  478 THR A CB  1 
ATOM 3706  O OG1 . THR A 1 478 ? 279.216 -23.309 288.309 1.0 62.94657  ? 478 THR A OG1 478 THR A OG1 1 
ATOM 3707  C CG2 . THR A 1 478 ? 279.765 -23.162 290.684 1.0 62.94657  ? 478 THR A CG2 478 THR A CG2 1 
ATOM 3708  N N   . VAL A 1 479 ? 278.842 -27.186 289.587 1.0 59.19045  ? 479 VAL A N   479 VAL A N   1 
ATOM 3709  C CA  . VAL A 1 479 ? 279.570 -28.337 289.074 1.0 59.19045  ? 479 VAL A CA  479 VAL A CA  1 
ATOM 3710  C C   . VAL A 1 479 ? 278.525 -29.315 288.567 1.0 59.19045  ? 479 VAL A C   479 VAL A C   1 
ATOM 3711  O O   . VAL A 1 479 ? 277.559 -29.607 289.279 1.0 59.19045  ? 479 VAL A O   479 VAL A O   1 
ATOM 3712  C CB  . VAL A 1 479 ? 280.466 -28.986 290.148 1.0 59.19045  ? 479 VAL A CB  479 VAL A CB  1 
ATOM 3713  C CG1 . VAL A 1 479 ? 281.060 -30.284 289.647 1.0 59.19045  ? 479 VAL A CG1 479 VAL A CG1 1 
ATOM 3714  C CG2 . VAL A 1 479 ? 281.587 -28.045 290.549 1.0 59.19045  ? 479 VAL A CG2 479 VAL A CG2 1 
ATOM 3715  N N   . ASN A 1 480 ? 278.700 -29.782 287.329 1.0 56.22112  ? 480 ASN A N   480 ASN A N   1 
ATOM 3716  C CA  . ASN A 1 480 ? 277.766 -30.619 286.586 1.0 56.22112  ? 480 ASN A CA  480 ASN A CA  1 
ATOM 3717  C C   . ASN A 1 480 ? 277.456 -31.903 287.346 1.0 56.22112  ? 480 ASN A C   480 ASN A C   1 
ATOM 3718  O O   . ASN A 1 480 ? 278.342 -32.745 287.531 1.0 56.22112  ? 480 ASN A O   480 ASN A O   1 
ATOM 3719  C CB  . ASN A 1 480 ? 278.350 -30.938 285.211 1.0 56.22112  ? 480 ASN A CB  480 ASN A CB  1 
ATOM 3720  C CG  . ASN A 1 480 ? 277.323 -31.493 284.249 1.0 56.22112  ? 480 ASN A CG  480 ASN A CG  1 
ATOM 3721  O OD1 . ASN A 1 480 ? 276.144 -31.604 284.571 1.0 56.22112  ? 480 ASN A OD1 480 ASN A OD1 1 
ATOM 3722  N ND2 . ASN A 1 480 ? 277.773 -31.858 283.056 1.0 56.22112  ? 480 ASN A ND2 480 ASN A ND2 1 
ATOM 3723  N N   . PRO A 1 481 ? 276.218 -32.079 287.815 1.0 55.17162  ? 481 PRO A N   481 PRO A N   1 
ATOM 3724  C CA  . PRO A 1 481 ? 275.880 -33.275 288.595 1.0 55.17162  ? 481 PRO A CA  481 PRO A CA  1 
ATOM 3725  C C   . PRO A 1 481 ? 275.722 -34.530 287.770 1.0 55.17162  ? 481 PRO A C   481 PRO A C   1 
ATOM 3726  O O   . PRO A 1 481 ? 275.630 -35.620 288.349 1.0 55.17162  ? 481 PRO A O   481 PRO A O   1 
ATOM 3727  C CB  . PRO A 1 481 ? 274.546 -32.901 289.233 1.0 55.17162  ? 481 PRO A CB  481 PRO A CB  1 
ATOM 3728  C CG  . PRO A 1 481 ? 273.953 -31.936 288.298 1.0 55.17162  ? 481 PRO A CG  481 PRO A CG  1 
ATOM 3729  C CD  . PRO A 1 481 ? 275.086 -31.147 287.728 1.0 55.17162  ? 481 PRO A CD  481 PRO A CD  1 
ATOM 3730  N N   . PHE A 1 482 ? 275.658 -34.414 286.452 1.0 54.49868  ? 482 PHE A N   482 PHE A N   1 
ATOM 3731  C CA  . PHE A 1 482 ? 275.496 -35.564 285.581 1.0 54.49868  ? 482 PHE A CA  482 PHE A CA  1 
ATOM 3732  C C   . PHE A 1 482 ? 276.824 -36.213 285.231 1.0 54.49868  ? 482 PHE A C   482 PHE A C   1 
ATOM 3733  O O   . PHE A 1 482 ? 276.844 -37.190 284.477 1.0 54.49868  ? 482 PHE A O   482 PHE A O   1 
ATOM 3734  C CB  . PHE A 1 482 ? 274.760 -35.144 284.312 1.0 54.49868  ? 482 PHE A CB  482 PHE A CB  1 
ATOM 3735  C CG  . PHE A 1 482 ? 273.389 -34.609 284.573 1.0 54.49868  ? 482 PHE A CG  482 PHE A CG  1 
ATOM 3736  C CD1 . PHE A 1 482 ? 272.328 -35.463 284.786 1.0 54.49868  ? 482 PHE A CD1 482 PHE A CD1 1 
ATOM 3737  C CD2 . PHE A 1 482 ? 273.167 -33.247 284.627 1.0 54.49868  ? 482 PHE A CD2 482 PHE A CD2 1 
ATOM 3738  C CE1 . PHE A 1 482 ? 271.069 -34.969 285.042 1.0 54.49868  ? 482 PHE A CE1 482 PHE A CE1 1 
ATOM 3739  C CE2 . PHE A 1 482 ? 271.911 -32.751 284.879 1.0 54.49868  ? 482 PHE A CE2 482 PHE A CE2 1 
ATOM 3740  C CZ  . PHE A 1 482 ? 270.863 -33.611 285.081 1.0 54.49868  ? 482 PHE A CZ  482 PHE A CZ  1 
ATOM 3741  N N   . ASN A 1 483 ? 277.928 -35.685 285.755 1.0 57.02009  ? 483 ASN A N   483 ASN A N   1 
ATOM 3742  C CA  . ASN A 1 483 ? 279.242 -36.302 285.608 1.0 57.02009  ? 483 ASN A CA  483 ASN A CA  1 
ATOM 3743  C C   . ASN A 1 483 ? 279.517 -37.118 286.862 1.0 57.02009  ? 483 ASN A C   483 ASN A C   1 
ATOM 3744  O O   . ASN A 1 483 ? 280.376 -36.799 287.687 1.0 57.02009  ? 483 ASN A O   483 ASN A O   1 
ATOM 3745  C CB  . ASN A 1 483 ? 280.300 -35.239 285.367 1.0 57.02009  ? 483 ASN A CB  483 ASN A CB  1 
ATOM 3746  C CG  . ASN A 1 483 ? 280.154 -34.594 284.018 1.0 57.02009  ? 483 ASN A CG  483 ASN A CG  1 
ATOM 3747  O OD1 . ASN A 1 483 ? 279.804 -35.255 283.046 1.0 57.02009  ? 483 ASN A OD1 483 ASN A OD1 1 
ATOM 3748  N ND2 . ASN A 1 483 ? 280.443 -33.304 283.938 1.0 57.02009  ? 483 ASN A ND2 483 ASN A ND2 1 
ATOM 3749  N N   . HIS A 1 484 ? 278.769 -38.206 286.991 1.0 61.0087   ? 484 HIS A N   484 HIS A N   1 
ATOM 3750  C CA  . HIS A 1 484 ? 278.771 -39.005 288.197 1.0 61.0087   ? 484 HIS A CA  484 HIS A CA  1 
ATOM 3751  C C   . HIS A 1 484 ? 278.758 -40.461 287.759 1.0 61.0087   ? 484 HIS A C   484 HIS A C   1 
ATOM 3752  O O   . HIS A 1 484 ? 278.426 -40.770 286.612 1.0 61.0087   ? 484 HIS A O   484 HIS A O   1 
ATOM 3753  C CB  . HIS A 1 484 ? 277.553 -38.653 289.059 1.0 61.0087   ? 484 HIS A CB  484 HIS A CB  1 
ATOM 3754  C CG  . HIS A 1 484 ? 277.728 -38.965 290.508 1.0 61.0087   ? 484 HIS A CG  484 HIS A CG  1 
ATOM 3755  N ND1 . HIS A 1 484 ? 277.549 -40.231 291.021 1.0 61.0087   ? 484 HIS A ND1 484 HIS A ND1 1 
ATOM 3756  C CD2 . HIS A 1 484 ? 278.046 -38.167 291.556 1.0 61.0087   ? 484 HIS A CD2 484 HIS A CD2 1 
ATOM 3757  C CE1 . HIS A 1 484 ? 277.783 -40.207 292.320 1.0 61.0087   ? 484 HIS A CE1 484 HIS A CE1 1 
ATOM 3758  N NE2 . HIS A 1 484 ? 278.078 -38.968 292.669 1.0 61.0087   ? 484 HIS A NE2 484 HIS A NE2 1 
ATOM 3759  N N   . HIS A 1 485 ? 279.139 -41.362 288.656 1.0 62.21988  ? 485 HIS A N   485 HIS A N   1 
ATOM 3760  C CA  . HIS A 1 485 ? 279.058 -42.764 288.273 1.0 62.21988  ? 485 HIS A CA  485 HIS A CA  1 
ATOM 3761  C C   . HIS A 1 485 ? 277.762 -43.418 288.727 1.0 62.21988  ? 485 HIS A C   485 HIS A C   1 
ATOM 3762  O O   . HIS A 1 485 ? 277.511 -44.576 288.375 1.0 62.21988  ? 485 HIS A O   485 HIS A O   1 
ATOM 3763  C CB  . HIS A 1 485 ? 280.243 -43.557 288.811 1.0 62.21988  ? 485 HIS A CB  485 HIS A CB  1 
ATOM 3764  C CG  . HIS A 1 485 ? 280.329 -43.571 290.300 1.0 62.21988  ? 485 HIS A CG  485 HIS A CG  1 
ATOM 3765  N ND1 . HIS A 1 485 ? 280.865 -42.527 291.018 1.0 62.21988  ? 485 HIS A ND1 485 HIS A ND1 1 
ATOM 3766  C CD2 . HIS A 1 485 ? 279.975 -44.511 291.207 1.0 62.21988  ? 485 HIS A CD2 485 HIS A CD2 1 
ATOM 3767  C CE1 . HIS A 1 485 ? 280.826 -42.816 292.306 1.0 62.21988  ? 485 HIS A CE1 485 HIS A CE1 1 
ATOM 3768  N NE2 . HIS A 1 485 ? 280.290 -44.014 292.448 1.0 62.21988  ? 485 HIS A NE2 485 HIS A NE2 1 
ATOM 3769  N N   . ARG A 1 486 ? 276.940 -42.712 289.496 1.0 63.83432  ? 486 ARG A N   486 ARG A N   1 
ATOM 3770  C CA  . ARG A 1 486 ? 275.562 -43.085 289.762 1.0 63.83432  ? 486 ARG A CA  486 ARG A CA  1 
ATOM 3771  C C   . ARG A 1 486 ? 274.638 -42.545 288.670 1.0 63.83432  ? 486 ARG A C   486 ARG A C   1 
ATOM 3772  O O   . ARG A 1 486 ? 273.420 -42.747 288.724 1.0 63.83432  ? 486 ARG A O   486 ARG A O   1 
ATOM 3773  C CB  . ARG A 1 486 ? 275.166 -42.593 291.174 1.0 63.83432  ? 486 ARG A CB  486 ARG A CB  1 
ATOM 3774  C CG  . ARG A 1 486 ? 273.865 -43.132 291.786 1.0 63.83432  ? 486 ARG A CG  486 ARG A CG  1 
ATOM 3775  C CD  . ARG A 1 486 ? 273.856 -44.638 292.035 1.0 63.83432  ? 486 ARG A CD  486 ARG A CD  1 
ATOM 3776  N NE  . ARG A 1 486 ? 274.780 -45.061 293.085 1.0 63.83432  ? 486 ARG A NE  486 ARG A NE  1 
ATOM 3777  C CZ  . ARG A 1 486 ? 274.506 -45.002 294.386 1.0 63.83432  ? 486 ARG A CZ  486 ARG A CZ  1 
ATOM 3778  N NH1 . ARG A 1 486 ? 273.341 -44.528 294.806 1.0 63.83432  ? 486 ARG A NH1 486 ARG A NH1 1 
ATOM 3779  N NH2 . ARG A 1 486 ? 275.397 -45.415 295.275 1.0 63.83432  ? 486 ARG A NH2 486 ARG A NH2 1 
ATOM 3780  N N   . ASN A 1 487 ? 275.204 -41.906 287.645 1.0 57.68922  ? 487 ASN A N   487 ASN A N   1 
ATOM 3781  C CA  . ASN A 1 487 ? 274.443 -41.530 286.463 1.0 57.68922  ? 487 ASN A CA  487 ASN A CA  1 
ATOM 3782  C C   . ASN A 1 487 ? 274.039 -42.813 285.758 1.0 57.68922  ? 487 ASN A C   487 ASN A C   1 
ATOM 3783  O O   . ASN A 1 487 ? 274.799 -43.369 284.960 1.0 57.68922  ? 487 ASN A O   487 ASN A O   1 
ATOM 3784  C CB  . ASN A 1 487 ? 275.281 -40.637 285.549 1.0 57.68922  ? 487 ASN A CB  487 ASN A CB  1 
ATOM 3785  C CG  . ASN A 1 487 ? 274.482 -40.033 284.415 1.0 57.68922  ? 487 ASN A CG  487 ASN A CG  1 
ATOM 3786  O OD1 . ASN A 1 487 ? 273.282 -40.261 284.287 1.0 57.68922  ? 487 ASN A OD1 487 ASN A OD1 1 
ATOM 3787  N ND2 . ASN A 1 487 ? 275.152 -39.254 283.577 1.0 57.68922  ? 487 ASN A ND2 487 ASN A ND2 1 
ATOM 3788  N N   . THR A 1 488 ? 272.819 -43.264 286.048 1.0 56.26154  ? 488 THR A N   488 THR A N   1 
ATOM 3789  C CA  . THR A 1 488 ? 272.396 -44.612 285.705 1.0 56.26154  ? 488 THR A CA  488 THR A CA  1 
ATOM 3790  C C   . THR A 1 488 ? 272.172 -44.750 284.210 1.0 56.26154  ? 488 THR A C   488 THR A C   1 
ATOM 3791  O O   . THR A 1 488 ? 272.306 -45.847 283.664 1.0 56.26154  ? 488 THR A O   488 THR A O   1 
ATOM 3792  C CB  . THR A 1 488 ? 271.126 -44.952 286.485 1.0 56.26154  ? 488 THR A CB  488 THR A CB  1 
ATOM 3793  O OG1 . THR A 1 488 ? 271.314 -44.580 287.853 1.0 56.26154  ? 488 THR A OG1 488 THR A OG1 1 
ATOM 3794  C CG2 . THR A 1 488 ? 270.851 -46.443 286.468 1.0 56.26154  ? 488 THR A CG2 488 THR A CG2 1 
ATOM 3795  N N   . GLY A 1 489 ? 271.877 -43.643 283.532 1.0 55.32815  ? 489 GLY A N   489 GLY A N   1 
ATOM 3796  C CA  . GLY A 1 489 ? 271.764 -43.686 282.087 1.0 55.32815  ? 489 GLY A CA  489 GLY A CA  1 
ATOM 3797  C C   . GLY A 1 489 ? 273.105 -43.892 281.413 1.0 55.32815  ? 489 GLY A C   489 GLY A C   1 
ATOM 3798  O O   . GLY A 1 489 ? 273.245 -44.757 280.549 1.0 55.32815  ? 489 GLY A O   489 GLY A O   1 
ATOM 3799  N N   . LEU A 1 490 ? 274.115 -43.117 281.818 1.0 53.8178   ? 490 LEU A N   490 LEU A N   1 
ATOM 3800  C CA  . LEU A 1 490 ? 275.443 -43.253 281.227 1.0 53.8178   ? 490 LEU A CA  490 LEU A CA  1 
ATOM 3801  C C   . LEU A 1 490 ? 276.093 -44.576 281.598 1.0 53.8178   ? 490 LEU A C   490 LEU A C   1 
ATOM 3802  O O   . LEU A 1 490 ? 276.833 -45.149 280.792 1.0 53.8178   ? 490 LEU A O   490 LEU A O   1 
ATOM 3803  C CB  . LEU A 1 490 ? 276.327 -42.086 281.657 1.0 53.8178   ? 490 LEU A CB  490 LEU A CB  1 
ATOM 3804  C CG  . LEU A 1 490 ? 277.752 -42.042 281.115 1.0 53.8178   ? 490 LEU A CG  490 LEU A CG  1 
ATOM 3805  C CD1 . LEU A 1 490 ? 277.724 -41.993 279.610 1.0 53.8178   ? 490 LEU A CD1 490 LEU A CD1 1 
ATOM 3806  C CD2 . LEU A 1 490 ? 278.481 -40.844 281.673 1.0 53.8178   ? 490 LEU A CD2 490 LEU A CD2 1 
ATOM 3807  N N   . LYS A 1 491 ? 275.814 -45.085 282.796 1.0 54.53951  ? 491 LYS A N   491 LYS A N   1 
ATOM 3808  C CA  . LYS A 1 491 ? 276.281 -46.416 283.153 1.0 54.53951  ? 491 LYS A CA  491 LYS A CA  1 
ATOM 3809  C C   . LYS A 1 491 ? 275.562 -47.487 282.346 1.0 54.53951  ? 491 LYS A C   491 LYS A C   1 
ATOM 3810  O O   . LYS A 1 491 ? 276.165 -48.503 281.990 1.0 54.53951  ? 491 LYS A O   491 LYS A O   1 
ATOM 3811  C CB  . LYS A 1 491 ? 276.090 -46.642 284.651 1.0 54.53951  ? 491 LYS A CB  491 LYS A CB  1 
ATOM 3812  C CG  . LYS A 1 491 ? 276.624 -47.953 285.173 1.0 54.53951  ? 491 LYS A CG  491 LYS A CG  1 
ATOM 3813  C CD  . LYS A 1 491 ? 276.526 -47.997 286.679 1.0 54.53951  ? 491 LYS A CD  491 LYS A CD  1 
ATOM 3814  C CE  . LYS A 1 491 ? 275.084 -48.113 287.117 1.0 54.53951  ? 491 LYS A CE  491 LYS A CE  1 
ATOM 3815  N NZ  . LYS A 1 491 ? 274.503 -49.425 286.735 1.0 54.53951  ? 491 LYS A NZ  491 LYS A NZ  1 
ATOM 3816  N N   . TYR A 1 492 ? 274.289 -47.268 282.018 1.0 53.43096  ? 492 TYR A N   492 TYR A N   1 
ATOM 3817  C CA  . TYR A 1 492 ? 273.576 -48.225 281.181 1.0 53.43096  ? 492 TYR A CA  492 TYR A CA  1 
ATOM 3818  C C   . TYR A 1 492 ? 273.956 -48.075 279.717 1.0 53.43096  ? 492 TYR A C   492 TYR A C   1 
ATOM 3819  O O   . TYR A 1 492 ? 274.006 -49.070 278.993 1.0 53.43096  ? 492 TYR A O   492 TYR A O   1 
ATOM 3820  C CB  . TYR A 1 492 ? 272.069 -48.069 281.356 1.0 53.43096  ? 492 TYR A CB  492 TYR A CB  1 
ATOM 3821  C CG  . TYR A 1 492 ? 271.235 -49.040 280.560 1.0 53.43096  ? 492 TYR A CG  492 TYR A CG  1 
ATOM 3822  C CD1 . TYR A 1 492 ? 271.125 -50.368 280.943 1.0 53.43096  ? 492 TYR A CD1 492 TYR A CD1 1 
ATOM 3823  C CD2 . TYR A 1 492 ? 270.537 -48.620 279.437 1.0 53.43096  ? 492 TYR A CD2 492 TYR A CD2 1 
ATOM 3824  C CE1 . TYR A 1 492 ? 270.353 -51.256 280.218 1.0 53.43096  ? 492 TYR A CE1 492 TYR A CE1 1 
ATOM 3825  C CE2 . TYR A 1 492 ? 269.764 -49.499 278.707 1.0 53.43096  ? 492 TYR A CE2 492 TYR A CE2 1 
ATOM 3826  C CZ  . TYR A 1 492 ? 269.676 -50.814 279.102 1.0 53.43096  ? 492 TYR A CZ  492 TYR A CZ  1 
ATOM 3827  O OH  . TYR A 1 492 ? 268.907 -51.695 278.379 1.0 53.43096  ? 492 TYR A OH  492 TYR A OH  1 
ATOM 3828  N N   . ARG A 1 493 ? 274.231 -46.852 279.258 1.0 51.64722  ? 493 ARG A N   493 ARG A N   1 
ATOM 3829  C CA  . ARG A 1 493 ? 274.624 -46.666 277.865 1.0 51.64722  ? 493 ARG A CA  493 ARG A CA  1 
ATOM 3830  C C   . ARG A 1 493 ? 276.045 -47.130 277.599 1.0 51.64722  ? 493 ARG A C   493 ARG A C   1 
ATOM 3831  O O   . ARG A 1 493 ? 276.388 -47.391 276.444 1.0 51.64722  ? 493 ARG A O   493 ARG A O   1 
ATOM 3832  C CB  . ARG A 1 493 ? 274.495 -45.203 277.446 1.0 51.64722  ? 493 ARG A CB  493 ARG A CB  1 
ATOM 3833  C CG  . ARG A 1 493 ? 273.080 -44.693 277.354 1.0 51.64722  ? 493 ARG A CG  493 ARG A CG  1 
ATOM 3834  C CD  . ARG A 1 493 ? 273.041 -43.339 276.696 1.0 51.64722  ? 493 ARG A CD  493 ARG A CD  1 
ATOM 3835  N NE  . ARG A 1 493 ? 273.822 -42.350 277.431 1.0 51.64722  ? 493 ARG A NE  493 ARG A NE  1 
ATOM 3836  C CZ  . ARG A 1 493 ? 273.342 -41.602 278.414 1.0 51.64722  ? 493 ARG A CZ  493 ARG A CZ  1 
ATOM 3837  N NH1 . ARG A 1 493 ? 272.077 -41.724 278.786 1.0 51.64722  ? 493 ARG A NH1 493 ARG A NH1 1 
ATOM 3838  N NH2 . ARG A 1 493 ? 274.129 -40.734 279.024 1.0 51.64722  ? 493 ARG A NH2 493 ARG A NH2 1 
ATOM 3839  N N   . SER A 1 494 ? 276.880 -47.228 278.627 1.0 54.02455  ? 494 SER A N   494 SER A N   1 
ATOM 3840  C CA  . SER A 1 494 ? 278.234 -47.723 278.435 1.0 54.02455  ? 494 SER A CA  494 SER A CA  1 
ATOM 3841  C C   . SER A 1 494 ? 278.309 -49.236 278.533 1.0 54.02455  ? 494 SER A C   494 SER A C   1 
ATOM 3842  O O   . SER A 1 494 ? 279.033 -49.870 277.761 1.0 54.02455  ? 494 SER A O   494 SER A O   1 
ATOM 3843  C CB  . SER A 1 494 ? 279.177 -47.099 279.458 1.0 54.02455  ? 494 SER A CB  494 SER A CB  1 
ATOM 3844  O OG  . SER A 1 494 ? 280.479 -47.625 279.307 1.0 54.02455  ? 494 SER A OG  494 SER A OG  1 
ATOM 3845  N N   . GLN A 1 495 ? 277.567 -49.828 279.467 1.0 55.57343  ? 495 GLN A N   495 GLN A N   1 
ATOM 3846  C CA  . GLN A 1 495 ? 277.541 -51.276 279.607 1.0 55.57343  ? 495 GLN A CA  495 GLN A CA  1 
ATOM 3847  C C   . GLN A 1 495 ? 276.715 -51.957 278.531 1.0 55.57343  ? 495 GLN A C   495 GLN A C   1 
ATOM 3848  O O   . GLN A 1 495 ? 276.800 -53.180 278.393 1.0 55.57343  ? 495 GLN A O   495 GLN A O   1 
ATOM 3849  C CB  . GLN A 1 495 ? 277.003 -51.655 280.982 1.0 55.57343  ? 495 GLN A CB  495 GLN A CB  1 
ATOM 3850  C CG  . GLN A 1 495 ? 277.926 -51.277 282.108 1.0 55.57343  ? 495 GLN A CG  495 GLN A CG  1 
ATOM 3851  C CD  . GLN A 1 495 ? 277.352 -51.612 283.455 1.0 55.57343  ? 495 GLN A CD  495 GLN A CD  1 
ATOM 3852  O OE1 . GLN A 1 495 ? 276.221 -52.080 283.560 1.0 55.57343  ? 495 GLN A OE1 495 GLN A OE1 1 
ATOM 3853  N NE2 . GLN A 1 495 ? 278.127 -51.372 284.500 1.0 55.57343  ? 495 GLN A NE2 495 GLN A NE2 1 
ATOM 3854  N N   . LEU A 1 496 ? 275.921 -51.200 277.776 1.0 53.38728  ? 496 LEU A N   496 LEU A N   1 
ATOM 3855  C CA  . LEU A 1 496 ? 275.133 -51.791 276.704 1.0 53.38728  ? 496 LEU A CA  496 LEU A CA  1 
ATOM 3856  C C   . LEU A 1 496 ? 276.008 -52.145 275.512 1.0 53.38728  ? 496 LEU A C   496 LEU A C   1 
ATOM 3857  O O   . LEU A 1 496 ? 275.666 -53.042 274.735 1.0 53.38728  ? 496 LEU A O   496 LEU A O   1 
ATOM 3858  C CB  . LEU A 1 496 ? 274.030 -50.823 276.293 1.0 53.38728  ? 496 LEU A CB  496 LEU A CB  1 
ATOM 3859  C CG  . LEU A 1 496 ? 272.902 -51.283 275.387 1.0 53.38728  ? 496 LEU A CG  496 LEU A CG  1 
ATOM 3860  C CD1 . LEU A 1 496 ? 272.094 -52.353 276.083 1.0 53.38728  ? 496 LEU A CD1 496 LEU A CD1 1 
ATOM 3861  C CD2 . LEU A 1 496 ? 272.031 -50.098 275.036 1.0 53.38728  ? 496 LEU A CD2 496 LEU A CD2 1 
ATOM 3862  N N   . LEU A 1 497 ? 277.139 -51.465 275.360 1.0 54.52338  ? 497 LEU A N   497 LEU A N   1 
ATOM 3863  C CA  . LEU A 1 497 ? 278.093 -51.766 274.302 1.0 54.52338  ? 497 LEU A CA  497 LEU A CA  1 
ATOM 3864  C C   . LEU A 1 497 ? 279.046 -52.887 274.683 1.0 54.52338  ? 497 LEU A C   497 LEU A C   1 
ATOM 3865  O O   . LEU A 1 497 ? 279.365 -53.738 273.847 1.0 54.52338  ? 497 LEU A O   497 LEU A O   1 
ATOM 3866  C CB  . LEU A 1 497 ? 278.906 -50.525 273.952 1.0 54.52338  ? 497 LEU A CB  497 LEU A CB  1 
ATOM 3867  C CG  . LEU A 1 497 ? 278.411 -49.494 272.950 1.0 54.52338  ? 497 LEU A CG  497 LEU A CG  1 
ATOM 3868  C CD1 . LEU A 1 497 ? 277.246 -48.675 273.461 1.0 54.52338  ? 497 LEU A CD1 497 LEU A CD1 1 
ATOM 3869  C CD2 . LEU A 1 497 ? 279.577 -48.604 272.646 1.0 54.52338  ? 497 LEU A CD2 497 LEU A CD2 1 
ATOM 3870  N N   . GLY A 1 498 ? 279.514 -52.890 275.919 1.0 56.23823  ? 498 GLY A N   498 GLY A N   1 
ATOM 3871  C CA  . GLY A 1 498 ? 280.456 -53.891 276.371 1.0 56.23823  ? 498 GLY A CA  498 GLY A CA  1 
ATOM 3872  C C   . GLY A 1 498 ? 281.226 -53.392 277.573 1.0 56.23823  ? 498 GLY A C   498 GLY A C   1 
ATOM 3873  O O   . GLY A 1 498 ? 280.911 -52.359 278.159 1.0 56.23823  ? 498 GLY A O   498 GLY A O   1 
ATOM 3874  N N   . ASN A 1 499 ? 282.259 -54.162 277.924 1.0 59.0594   ? 499 ASN A N   499 ASN A N   1 
ATOM 3875  C CA  . ASN A 1 499 ? 283.117 -53.855 279.057 1.0 59.0594   ? 499 ASN A CA  499 ASN A CA  1 
ATOM 3876  C C   . ASN A 1 499 ? 284.559 -53.553 278.687 1.0 59.0594   ? 499 ASN A C   499 ASN A C   1 
ATOM 3877  O O   . ASN A 1 499 ? 285.242 -52.862 279.447 1.0 59.0594   ? 499 ASN A O   499 ASN A O   1 
ATOM 3878  C CB  . ASN A 1 499 ? 283.106 -55.013 280.061 1.0 59.0594   ? 499 ASN A CB  499 ASN A CB  1 
ATOM 3879  C CG  . ASN A 1 499 ? 283.515 -56.336 279.444 1.0 59.0594   ? 499 ASN A CG  499 ASN A CG  1 
ATOM 3880  O OD1 . ASN A 1 499 ? 283.775 -56.433 278.247 1.0 59.0594   ? 499 ASN A OD1 499 ASN A OD1 1 
ATOM 3881  N ND2 . ASN A 1 499 ? 283.593 -57.366 280.272 1.0 59.0594   ? 499 ASN A ND2 499 ASN A ND2 1 
ATOM 3882  N N   . GLY A 1 500 ? 285.044 -54.073 277.566 1.0 59.20993  ? 500 GLY A N   500 GLY A N   1 
ATOM 3883  C CA  . GLY A 1 500 ? 286.408 -53.855 277.146 1.0 59.20993  ? 500 GLY A CA  500 GLY A CA  1 
ATOM 3884  C C   . GLY A 1 500 ? 286.602 -52.521 276.458 1.0 59.20993  ? 500 GLY A C   500 GLY A C   1 
ATOM 3885  O O   . GLY A 1 500 ? 285.715 -51.669 276.394 1.0 59.20993  ? 500 GLY A O   500 GLY A O   1 
ATOM 3886  N N   . ARG A 1 501 ? 287.808 -52.350 275.929 1.0 62.65931  ? 501 ARG A N   501 ARG A N   1 
ATOM 3887  C CA  . ARG A 1 501 ? 288.209 -51.130 275.247 1.0 62.65931  ? 501 ARG A CA  501 ARG A CA  1 
ATOM 3888  C C   . ARG A 1 501 ? 287.859 -51.189 273.764 1.0 62.65931  ? 501 ARG A C   501 ARG A C   1 
ATOM 3889  O O   . ARG A 1 501 ? 287.073 -50.373 273.276 1.0 62.65931  ? 501 ARG A O   501 ARG A O   1 
ATOM 3890  C CB  . ARG A 1 501 ? 289.710 -50.906 275.478 1.0 62.65931  ? 501 ARG A CB  501 ARG A CB  1 
ATOM 3891  C CG  . ARG A 1 501 ? 290.267 -49.576 275.033 1.0 62.65931  ? 501 ARG A CG  501 ARG A CG  1 
ATOM 3892  C CD  . ARG A 1 501 ? 290.956 -49.646 273.704 1.0 62.65931  ? 501 ARG A CD  501 ARG A CD  1 
ATOM 3893  N NE  . ARG A 1 501 ? 292.091 -50.571 273.721 1.0 62.65931  ? 501 ARG A NE  501 ARG A NE  1 
ATOM 3894  C CZ  . ARG A 1 501 ? 293.308 -50.259 274.151 1.0 62.65931  ? 501 ARG A CZ  501 ARG A CZ  1 
ATOM 3895  N NH1 . ARG A 1 501 ? 293.551 -49.045 274.622 1.0 62.65931  ? 501 ARG A NH1 501 ARG A NH1 1 
ATOM 3896  N NH2 . ARG A 1 501 ? 294.281 -51.151 274.112 1.0 62.65931  ? 501 ARG A NH2 501 ARG A NH2 1 
ATOM 3897  N N   . TYR A 1 502 ? 288.411 -52.161 273.045 1.0 61.99967  ? 502 TYR A N   502 TYR A N   1 
ATOM 3898  C CA  . TYR A 1 502 ? 288.079 -52.369 271.639 1.0 61.99967  ? 502 TYR A CA  502 TYR A CA  1 
ATOM 3899  C C   . TYR A 1 502 ? 286.750 -53.104 271.580 1.0 61.99967  ? 502 TYR A C   502 TYR A C   1 
ATOM 3900  O O   . TYR A 1 502 ? 286.662 -54.277 271.946 1.0 61.99967  ? 502 TYR A O   502 TYR A O   1 
ATOM 3901  C CB  . TYR A 1 502 ? 289.154 -53.175 270.924 1.0 61.99967  ? 502 TYR A CB  502 TYR A CB  1 
ATOM 3902  C CG  . TYR A 1 502 ? 290.491 -52.512 270.773 1.0 61.99967  ? 502 TYR A CG  502 TYR A CG  1 
ATOM 3903  C CD1 . TYR A 1 502 ? 290.675 -51.470 269.876 1.0 61.99967  ? 502 TYR A CD1 502 TYR A CD1 1 
ATOM 3904  C CD2 . TYR A 1 502 ? 291.602 -52.976 271.472 1.0 61.99967  ? 502 TYR A CD2 502 TYR A CD2 1 
ATOM 3905  C CE1 . TYR A 1 502 ? 291.917 -50.883 269.724 1.0 61.99967  ? 502 TYR A CE1 502 TYR A CE1 1 
ATOM 3906  C CE2 . TYR A 1 502 ? 292.839 -52.396 271.312 1.0 61.99967  ? 502 TYR A CE2 502 TYR A CE2 1 
ATOM 3907  C CZ  . TYR A 1 502 ? 292.984 -51.345 270.444 1.0 61.99967  ? 502 TYR A CZ  502 TYR A CZ  1 
ATOM 3908  O OH  . TYR A 1 502 ? 294.219 -50.768 270.288 1.0 61.99967  ? 502 TYR A OH  502 TYR A OH  1 
ATOM 3909  N N   . CYS A 1 503 ? 285.716 -52.433 271.089 1.0 57.94093  ? 503 CYS A N   503 CYS A N   1 
ATOM 3910  C CA  . CYS A 1 503 ? 284.404 -53.042 270.952 1.0 57.94093  ? 503 CYS A CA  503 CYS A CA  1 
ATOM 3911  C C   . CYS A 1 503 ? 283.846 -52.798 269.558 1.0 57.94093  ? 503 CYS A C   503 CYS A C   1 
ATOM 3912  O O   . CYS A 1 503 ? 284.092 -51.752 268.950 1.0 57.94093  ? 503 CYS A O   503 CYS A O   1 
ATOM 3913  C CB  . CYS A 1 503 ? 283.432 -52.500 271.999 1.0 57.94093  ? 503 CYS A CB  503 CYS A CB  1 
ATOM 3914  S SG  . CYS A 1 503 ? 283.002 -50.762 271.817 1.0 57.94093  ? 503 CYS A SG  503 CYS A SG  1 
ATOM 3915  N N   . ASP A 1 504 ? 283.119 -53.783 269.048 1.0 58.36841  ? 504 ASP A N   504 ASP A N   1 
ATOM 3916  C CA  . ASP A 1 504 ? 282.256 -53.548 267.909 1.0 58.36841  ? 504 ASP A CA  504 ASP A CA  1 
ATOM 3917  C C   . ASP A 1 504 ? 280.905 -53.052 268.400 1.0 58.36841  ? 504 ASP A C   504 ASP A C   1 
ATOM 3918  O O   . ASP A 1 504 ? 280.487 -53.324 269.526 1.0 58.36841  ? 504 ASP A O   504 ASP A O   1 
ATOM 3919  C CB  . ASP A 1 504 ? 282.069 -54.820 267.088 1.0 58.36841  ? 504 ASP A CB  504 ASP A CB  1 
ATOM 3920  C CG  . ASP A 1 504 ? 283.344 -55.276 266.422 1.0 58.36841  ? 504 ASP A CG  504 ASP A CG  1 
ATOM 3921  O OD1 . ASP A 1 504 ? 284.213 -54.423 266.155 1.0 58.36841  ? 504 ASP A OD1 504 ASP A OD1 1 
ATOM 3922  O OD2 . ASP A 1 504 ? 283.474 -56.488 266.150 1.0 58.36841  ? 504 ASP A OD2 504 ASP A OD2 1 
ATOM 3923  N N   . PHE A 1 505 ? 280.214 -52.317 267.540 1.0 51.13747  ? 505 PHE A N   505 PHE A N   1 
ATOM 3924  C CA  . PHE A 1 505 ? 278.903 -51.808 267.892 1.0 51.13747  ? 505 PHE A CA  505 PHE A CA  1 
ATOM 3925  C C   . PHE A 1 505 ? 277.978 -51.992 266.704 1.0 51.13747  ? 505 PHE A C   505 PHE A C   1 
ATOM 3926  O O   . PHE A 1 505 ? 278.416 -52.153 265.565 1.0 51.13747  ? 505 PHE A O   505 PHE A O   1 
ATOM 3927  C CB  . PHE A 1 505 ? 278.964 -50.338 268.344 1.0 51.13747  ? 505 PHE A CB  505 PHE A CB  1 
ATOM 3928  C CG  . PHE A 1 505 ? 279.396 -49.379 267.275 1.0 51.13747  ? 505 PHE A CG  505 PHE A CG  1 
ATOM 3929  C CD1 . PHE A 1 505 ? 280.735 -49.141 267.046 1.0 51.13747  ? 505 PHE A CD1 505 PHE A CD1 1 
ATOM 3930  C CD2 . PHE A 1 505 ? 278.461 -48.675 266.533 1.0 51.13747  ? 505 PHE A CD2 505 PHE A CD2 1 
ATOM 3931  C CE1 . PHE A 1 505 ? 281.130 -48.258 266.074 1.0 51.13747  ? 505 PHE A CE1 505 PHE A CE1 1 
ATOM 3932  C CE2 . PHE A 1 505 ? 278.854 -47.789 265.559 1.0 51.13747  ? 505 PHE A CE2 505 PHE A CE2 1 
ATOM 3933  C CZ  . PHE A 1 505 ? 280.187 -47.580 265.330 1.0 51.13747  ? 505 PHE A CZ  505 PHE A CZ  1 
ATOM 3934  N N   . HIS A 1 506 ? 276.684 -51.986 266.992 1.0 48.11318  ? 506 HIS A N   506 HIS A N   1 
ATOM 3935  C CA  . HIS A 1 506 ? 275.673 -52.169 265.961 1.0 48.11318  ? 506 HIS A CA  506 HIS A CA  1 
ATOM 3936  C C   . HIS A 1 506 ? 274.439 -51.416 266.441 1.0 48.11318  ? 506 HIS A C   506 HIS A C   1 
ATOM 3937  O O   . HIS A 1 506 ? 273.653 -51.950 267.224 1.0 48.11318  ? 506 HIS A O   506 HIS A O   1 
ATOM 3938  C CB  . HIS A 1 506 ? 275.384 -53.641 265.737 1.0 48.11318  ? 506 HIS A CB  506 HIS A CB  1 
ATOM 3939  C CG  . HIS A 1 506 ? 274.386 -53.899 264.658 1.0 48.11318  ? 506 HIS A CG  506 HIS A CG  1 
ATOM 3940  N ND1 . HIS A 1 506 ? 274.685 -53.762 263.322 1.0 48.11318  ? 506 HIS A ND1 506 HIS A ND1 1 
ATOM 3941  C CD2 . HIS A 1 506 ? 273.091 -54.277 264.718 1.0 48.11318  ? 506 HIS A CD2 506 HIS A CD2 1 
ATOM 3942  C CE1 . HIS A 1 506 ? 273.616 -54.048 262.604 1.0 48.11318  ? 506 HIS A CE1 506 HIS A CE1 1 
ATOM 3943  N NE2 . HIS A 1 506 ? 272.634 -54.364 263.426 1.0 48.11318  ? 506 HIS A NE2 506 HIS A NE2 1 
ATOM 3944  N N   . ILE A 1 507 ? 274.277 -50.186 265.970 1.0 45.30572  ? 507 ILE A N   507 ILE A N   1 
ATOM 3945  C CA  . ILE A 1 507 ? 273.352 -49.247 266.576 1.0 45.30572  ? 507 ILE A CA  507 ILE A CA  1 
ATOM 3946  C C   . ILE A 1 507 ? 272.278 -48.863 265.564 1.0 45.30572  ? 507 ILE A C   507 ILE A C   1 
ATOM 3947  O O   . ILE A 1 507 ? 272.364 -49.183 264.382 1.0 45.30572  ? 507 ILE A O   507 ILE A O   1 
ATOM 3948  C CB  . ILE A 1 507 ? 274.077 -48.003 267.102 1.0 45.30572  ? 507 ILE A CB  507 ILE A CB  1 
ATOM 3949  C CG1 . ILE A 1 507 ? 274.765 -47.278 265.959 1.0 45.30572  ? 507 ILE A CG1 507 ILE A CG1 1 
ATOM 3950  C CG2 . ILE A 1 507 ? 275.105 -48.390 268.139 1.0 45.30572  ? 507 ILE A CG2 507 ILE A CG2 1 
ATOM 3951  C CD1 . ILE A 1 507 ? 275.323 -45.963 266.354 1.0 45.30572  ? 507 ILE A CD1 507 ILE A CD1 1 
ATOM 3952  N N   . GLN A 1 508 ? 271.250 -48.173 266.059 1.0 45.51769  ? 508 GLN A N   508 GLN A N   1 
ATOM 3953  C CA  . GLN A 1 508 ? 270.132 -47.693 265.251 1.0 45.51769  ? 508 GLN A CA  508 GLN A CA  1 
ATOM 3954  C C   . GLN A 1 508 ? 269.863 -46.249 265.652 1.0 45.51769  ? 508 GLN A C   508 GLN A C   1 
ATOM 3955  O O   . GLN A 1 508 ? 269.476 -45.988 266.793 1.0 45.51769  ? 508 GLN A O   508 GLN A O   1 
ATOM 3956  C CB  . GLN A 1 508 ? 268.878 -48.542 265.461 1.0 45.51769  ? 508 GLN A CB  508 GLN A CB  1 
ATOM 3957  C CG  . GLN A 1 508 ? 268.960 -49.976 264.974 1.0 45.51769  ? 508 GLN A CG  508 GLN A CG  1 
ATOM 3958  C CD  . GLN A 1 508 ? 269.636 -50.890 265.965 1.0 45.51769  ? 508 GLN A CD  508 GLN A CD  1 
ATOM 3959  O OE1 . GLN A 1 508 ? 269.792 -50.549 267.134 1.0 45.51769  ? 508 GLN A OE1 508 GLN A OE1 1 
ATOM 3960  N NE2 . GLN A 1 508 ? 270.059 -52.054 265.499 1.0 45.51769  ? 508 GLN A NE2 508 GLN A NE2 1 
ATOM 3961  N N   . VAL A 1 509 ? 270.059 -45.315 264.729 1.0 45.16515  ? 509 VAL A N   509 VAL A N   1 
ATOM 3962  C CA  . VAL A 1 509 ? 269.922 -43.901 265.064 1.0 45.16515  ? 509 VAL A CA  509 VAL A CA  1 
ATOM 3963  C C   . VAL A 1 509 ? 268.669 -43.343 264.396 1.0 45.16515  ? 509 VAL A C   509 VAL A C   1 
ATOM 3964  O O   . VAL A 1 509 ? 268.267 -43.831 263.326 1.0 45.16515  ? 509 VAL A O   509 VAL A O   1 
ATOM 3965  C CB  . VAL A 1 509 ? 271.186 -43.114 264.680 1.0 45.16515  ? 509 VAL A CB  509 VAL A CB  1 
ATOM 3966  C CG1 . VAL A 1 509 ? 272.394 -43.686 265.394 1.0 45.16515  ? 509 VAL A CG1 509 VAL A CG1 1 
ATOM 3967  C CG2 . VAL A 1 509 ? 271.421 -43.155 263.208 1.0 45.16515  ? 509 VAL A CG2 509 VAL A CG2 1 
ATOM 3968  N N   . PRO A 1 510 ? 267.988 -42.357 264.999 1.0 46.98944  ? 510 PRO A N   510 PRO A N   1 
ATOM 3969  C CA  . PRO A 1 510 ? 266.751 -41.860 264.393 1.0 46.98944  ? 510 PRO A CA  510 PRO A CA  1 
ATOM 3970  C C   . PRO A 1 510 ? 266.967 -40.741 263.396 1.0 46.98944  ? 510 PRO A C   510 PRO A C   1 
ATOM 3971  O O   . PRO A 1 510 ? 268.108 -40.355 263.141 1.0 46.98944  ? 510 PRO A O   510 PRO A O   1 
ATOM 3972  C CB  . PRO A 1 510 ? 265.948 -41.399 265.612 1.0 46.98944  ? 510 PRO A CB  510 PRO A CB  1 
ATOM 3973  C CG  . PRO A 1 510 ? 266.988 -40.903 266.540 1.0 46.98944  ? 510 PRO A CG  510 PRO A CG  1 
ATOM 3974  C CD  . PRO A 1 510 ? 268.183 -41.798 266.343 1.0 46.98944  ? 510 PRO A CD  510 PRO A CD  1 
ATOM 3975  N N   . GLN A 1 511 ? 265.884 -40.198 262.853 1.0 47.69786  ? 511 GLN A N   511 GLN A N   1 
ATOM 3976  C CA  . GLN A 1 511 ? 265.909 -38.964 262.078 1.0 47.69786  ? 511 GLN A CA  511 GLN A CA  1 
ATOM 3977  C C   . GLN A 1 511 ? 265.123 -37.907 262.841 1.0 47.69786  ? 511 GLN A C   511 GLN A C   1 
ATOM 3978  O O   . GLN A 1 511 ? 263.889 -37.942 262.880 1.0 47.69786  ? 511 GLN A O   511 GLN A O   1 
ATOM 3979  C CB  . GLN A 1 511 ? 265.336 -39.173 260.680 1.0 47.69786  ? 511 GLN A CB  511 GLN A CB  1 
ATOM 3980  C CG  . GLN A 1 511 ? 265.275 -37.929 259.810 1.0 47.69786  ? 511 GLN A CG  511 GLN A CG  1 
ATOM 3981  C CD  . GLN A 1 511 ? 266.629 -37.336 259.483 1.0 47.69786  ? 511 GLN A CD  511 GLN A CD  1 
ATOM 3982  O OE1 . GLN A 1 511 ? 266.986 -36.266 259.973 1.0 47.69786  ? 511 GLN A OE1 511 GLN A OE1 1 
ATOM 3983  N NE2 . GLN A 1 511 ? 267.385 -38.021 258.639 1.0 47.69786  ? 511 GLN A NE2 511 GLN A NE2 1 
ATOM 3984  N N   . LYS A 1 512 ? 265.836 -36.956 263.445 1.0 47.25807  ? 512 LYS A N   512 LYS A N   1 
ATOM 3985  C CA  . LYS A 1 512 ? 265.233 -36.038 264.395 1.0 47.25807  ? 512 LYS A CA  512 LYS A CA  1 
ATOM 3986  C C   . LYS A 1 512 ? 264.832 -34.706 263.782 1.0 47.25807  ? 512 LYS A C   512 LYS A C   1 
ATOM 3987  O O   . LYS A 1 512 ? 264.312 -33.848 264.498 1.0 47.25807  ? 512 LYS A O   512 LYS A O   1 
ATOM 3988  C CB  . LYS A 1 512 ? 266.194 -35.823 265.561 1.0 47.25807  ? 512 LYS A CB  512 LYS A CB  1 
ATOM 3989  C CG  . LYS A 1 512 ? 266.423 -37.082 266.374 1.0 47.25807  ? 512 LYS A CG  512 LYS A CG  1 
ATOM 3990  C CD  . LYS A 1 512 ? 267.325 -36.832 267.565 1.0 47.25807  ? 512 LYS A CD  512 LYS A CD  1 
ATOM 3991  C CE  . LYS A 1 512 ? 268.756 -36.666 267.130 1.0 47.25807  ? 512 LYS A CE  512 LYS A CE  1 
ATOM 3992  N NZ  . LYS A 1 512 ? 269.258 -37.935 266.546 1.0 47.25807  ? 512 LYS A NZ  512 LYS A NZ  1 
ATOM 3993  N N   . PHE A 1 513 ? 265.051 -34.507 262.486 1.0 46.10255  ? 513 PHE A N   513 PHE A N   1 
ATOM 3994  C CA  . PHE A 1 513 ? 264.583 -33.297 261.828 1.0 46.10255  ? 513 PHE A CA  513 PHE A CA  1 
ATOM 3995  C C   . PHE A 1 513 ? 263.086 -33.422 261.594 1.0 46.10255  ? 513 PHE A C   513 PHE A C   1 
ATOM 3996  O O   . PHE A 1 513 ? 262.619 -34.427 261.053 1.0 46.10255  ? 513 PHE A O   513 PHE A O   1 
ATOM 3997  C CB  . PHE A 1 513 ? 265.333 -33.070 260.518 1.0 46.10255  ? 513 PHE A CB  513 PHE A CB  1 
ATOM 3998  C CG  . PHE A 1 513 ? 264.984 -31.784 259.831 1.0 46.10255  ? 513 PHE A CG  513 PHE A CG  1 
ATOM 3999  C CD1 . PHE A 1 513 ? 265.422 -30.573 260.337 1.0 46.10255  ? 513 PHE A CD1 513 PHE A CD1 1 
ATOM 4000  C CD2 . PHE A 1 513 ? 264.237 -31.785 258.671 1.0 46.10255  ? 513 PHE A CD2 513 PHE A CD2 1 
ATOM 4001  C CE1 . PHE A 1 513 ? 265.103 -29.384 259.703 1.0 46.10255  ? 513 PHE A CE1 513 PHE A CE1 1 
ATOM 4002  C CE2 . PHE A 1 513 ? 263.922 -30.601 258.031 1.0 46.10255  ? 513 PHE A CE2 513 PHE A CE2 1 
ATOM 4003  C CZ  . PHE A 1 513 ? 264.352 -29.401 258.551 1.0 46.10255  ? 513 PHE A CZ  513 PHE A CZ  1 
ATOM 4004  N N   . PHE A 1 514 ? 262.337 -32.397 262.003 1.0 44.73396  ? 514 PHE A N   514 PHE A N   1 
ATOM 4005  C CA  . PHE A 1 514 ? 260.897 -32.529 262.199 1.0 44.73396  ? 514 PHE A CA  514 PHE A CA  1 
ATOM 4006  C C   . PHE A 1 514 ? 260.106 -32.628 260.904 1.0 44.73396  ? 514 PHE A C   514 PHE A C   1 
ATOM 4007  O O   . PHE A 1 514 ? 259.002 -33.179 260.921 1.0 44.73396  ? 514 PHE A O   514 PHE A O   1 
ATOM 4008  C CB  . PHE A 1 514 ? 260.371 -31.360 263.036 1.0 44.73396  ? 514 PHE A CB  514 PHE A CB  1 
ATOM 4009  C CG  . PHE A 1 514 ? 260.536 -30.010 262.391 1.0 44.73396  ? 514 PHE A CG  514 PHE A CG  1 
ATOM 4010  C CD1 . PHE A 1 514 ? 261.711 -29.295 262.542 1.0 44.73396  ? 514 PHE A CD1 514 PHE A CD1 1 
ATOM 4011  C CD2 . PHE A 1 514 ? 259.496 -29.426 261.689 1.0 44.73396  ? 514 PHE A CD2 514 PHE A CD2 1 
ATOM 4012  C CE1 . PHE A 1 514 ? 261.859 -28.056 261.966 1.0 44.73396  ? 514 PHE A CE1 514 PHE A CE1 1 
ATOM 4013  C CE2 . PHE A 1 514 ? 259.645 -28.187 261.119 1.0 44.73396  ? 514 PHE A CE2 514 PHE A CE2 1 
ATOM 4014  C CZ  . PHE A 1 514 ? 260.824 -27.503 261.254 1.0 44.73396  ? 514 PHE A CZ  514 PHE A CZ  1 
ATOM 4015  N N   . ALA A 1 515 ? 260.617 -32.100 259.792 1.0 43.75085  ? 515 ALA A N   515 ALA A N   1 
ATOM 4016  C CA  . ALA A 1 515 ? 259.857 -32.171 258.547 1.0 43.75085  ? 515 ALA A CA  515 ALA A CA  1 
ATOM 4017  C C   . ALA A 1 515 ? 259.868 -33.579 257.968 1.0 43.75085  ? 515 ALA A C   515 ALA A C   1 
ATOM 4018  O O   . ALA A 1 515 ? 258.867 -34.030 257.402 1.0 43.75085  ? 515 ALA A O   515 ALA A O   1 
ATOM 4019  C CB  . ALA A 1 515 ? 260.406 -31.176 257.530 1.0 43.75085  ? 515 ALA A CB  515 ALA A CB  1 
ATOM 4020  N N   . ILE A 1 516 ? 260.983 -34.285 258.097 1.0 44.09341  ? 516 ILE A N   516 ILE A N   1 
ATOM 4021  C CA  . ILE A 1 516 ? 261.099 -35.647 257.606 1.0 44.09341  ? 516 ILE A CA  516 ILE A CA  1 
ATOM 4022  C C   . ILE A 1 516 ? 261.150 -36.645 258.760 1.0 44.09341  ? 516 ILE A C   516 ILE A C   1 
ATOM 4023  O O   . ILE A 1 516 ? 261.633 -37.762 258.594 1.0 44.09341  ? 516 ILE A O   516 ILE A O   1 
ATOM 4024  C CB  . ILE A 1 516 ? 262.309 -35.796 256.673 1.0 44.09341  ? 516 ILE A CB  516 ILE A CB  1 
ATOM 4025  C CG1 . ILE A 1 516 ? 263.590 -35.400 257.397 1.0 44.09341  ? 516 ILE A CG1 516 ILE A CG1 1 
ATOM 4026  C CG2 . ILE A 1 516 ? 262.131 -34.942 255.441 1.0 44.09341  ? 516 ILE A CG2 516 ILE A CG2 1 
ATOM 4027  C CD1 . ILE A 1 516 ? 264.834 -35.712 256.617 1.0 44.09341  ? 516 ILE A CD1 516 ILE A CD1 1 
ATOM 4028  N N   . LYS A 1 517 ? 260.658 -36.246 259.933 1.0 44.28421  ? 517 LYS A N   517 LYS A N   1 
ATOM 4029  C CA  . LYS A 1 517 ? 260.621 -37.152 261.075 1.0 44.28421  ? 517 LYS A CA  517 LYS A CA  1 
ATOM 4030  C C   . LYS A 1 517 ? 259.584 -38.242 260.867 1.0 44.28421  ? 517 LYS A C   517 LYS A C   1 
ATOM 4031  O O   . LYS A 1 517 ? 259.889 -39.433 260.987 1.0 44.28421  ? 517 LYS A O   517 LYS A O   1 
ATOM 4032  C CB  . LYS A 1 517 ? 260.328 -36.367 262.351 1.0 44.28421  ? 517 LYS A CB  517 LYS A CB  1 
ATOM 4033  C CG  . LYS A 1 517 ? 260.393 -37.181 263.622 1.0 44.28421  ? 517 LYS A CG  517 LYS A CG  1 
ATOM 4034  C CD  . LYS A 1 517 ? 260.036 -36.317 264.811 1.0 44.28421  ? 517 LYS A CD  517 LYS A CD  1 
ATOM 4035  C CE  . LYS A 1 517 ? 261.148 -35.331 265.095 1.0 44.28421  ? 517 LYS A CE  517 LYS A CE  1 
ATOM 4036  N NZ  . LYS A 1 517 ? 260.901 -34.526 266.317 1.0 44.28421  ? 517 LYS A NZ  517 LYS A NZ  1 
ATOM 4037  N N   . ASN A 1 518 ? 258.352 -37.852 260.557 1.0 42.06646  ? 518 ASN A N   518 ASN A N   1 
ATOM 4038  C CA  . ASN A 1 518 ? 257.274 -38.790 260.276 1.0 42.06646  ? 518 ASN A CA  518 ASN A CA  1 
ATOM 4039  C C   . ASN A 1 518 ? 256.493 -38.338 259.046 1.0 42.06646  ? 518 ASN A C   518 ASN A C   1 
ATOM 4040  O O   . ASN A 1 518 ? 255.266 -38.256 259.047 1.0 42.06646  ? 518 ASN A O   518 ASN A O   1 
ATOM 4041  C CB  . ASN A 1 518 ? 256.388 -38.982 261.508 1.0 42.06646  ? 518 ASN A CB  518 ASN A CB  1 
ATOM 4042  C CG  . ASN A 1 518 ? 255.912 -37.680 262.100 1.0 42.06646  ? 518 ASN A CG  518 ASN A CG  1 
ATOM 4043  O OD1 . ASN A 1 518 ? 256.205 -36.607 261.583 1.0 42.06646  ? 518 ASN A OD1 518 ASN A OD1 1 
ATOM 4044  N ND2 . ASN A 1 518 ? 255.169 -37.767 263.193 1.0 42.06646  ? 518 ASN A ND2 518 ASN A ND2 1 
ATOM 4045  N N   . LEU A 1 519 ? 257.216 -38.016 257.982 1.0 40.17601  ? 519 LEU A N   519 LEU A N   1 
ATOM 4046  C CA  . LEU A 1 519 ? 256.595 -37.713 256.703 1.0 40.17601  ? 519 LEU A CA  519 LEU A CA  1 
ATOM 4047  C C   . LEU A 1 519 ? 256.071 -38.985 256.047 1.0 40.17601  ? 519 LEU A C   519 LEU A C   1 
ATOM 4048  O O   . LEU A 1 519 ? 256.709 -40.036 256.106 1.0 40.17601  ? 519 LEU A O   519 LEU A O   1 
ATOM 4049  C CB  . LEU A 1 519 ? 257.615 -37.035 255.790 1.0 40.17601  ? 519 LEU A CB  519 LEU A CB  1 
ATOM 4050  C CG  . LEU A 1 519 ? 257.193 -36.645 254.379 1.0 40.17601  ? 519 LEU A CG  519 LEU A CG  1 
ATOM 4051  C CD1 . LEU A 1 519 ? 256.105 -35.606 254.427 1.0 40.17601  ? 519 LEU A CD1 519 LEU A CD1 1 
ATOM 4052  C CD2 . LEU A 1 519 ? 258.386 -36.154 253.596 1.0 40.17601  ? 519 LEU A CD2 519 LEU A CD2 1 
ATOM 4053  N N   . LEU A 1 520 ? 254.903 -38.892 255.418 1.0 39.24719  ? 520 LEU A N   520 LEU A N   1 
ATOM 4054  C CA  . LEU A 1 520 ? 254.332 -39.999 254.662 1.0 39.24719  ? 520 LEU A CA  520 LEU A CA  1 
ATOM 4055  C C   . LEU A 1 520 ? 254.620 -39.787 253.181 1.0 39.24719  ? 520 LEU A C   520 LEU A C   1 
ATOM 4056  O O   . LEU A 1 520 ? 254.246 -38.754 252.618 1.0 39.24719  ? 520 LEU A O   520 LEU A O   1 
ATOM 4057  C CB  . LEU A 1 520 ? 252.830 -40.107 254.904 1.0 39.24719  ? 520 LEU A CB  520 LEU A CB  1 
ATOM 4058  C CG  . LEU A 1 520 ? 252.145 -41.276 254.206 1.0 39.24719  ? 520 LEU A CG  520 LEU A CG  1 
ATOM 4059  C CD1 . LEU A 1 520 ? 252.619 -42.596 254.771 1.0 39.24719  ? 520 LEU A CD1 520 LEU A CD1 1 
ATOM 4060  C CD2 . LEU A 1 520 ? 250.648 -41.152 254.319 1.0 39.24719  ? 520 LEU A CD2 520 LEU A CD2 1 
ATOM 4061  N N   . LEU A 1 521 ? 255.275 -40.757 252.554 1.0 39.08383  ? 521 LEU A N   521 LEU A N   1 
ATOM 4062  C CA  . LEU A 1 521 ? 255.689 -40.600 251.168 1.0 39.08383  ? 521 LEU A CA  521 LEU A CA  1 
ATOM 4063  C C   . LEU A 1 521 ? 254.725 -41.286 250.211 1.0 39.08383  ? 521 LEU A C   521 LEU A C   1 
ATOM 4064  O O   . LEU A 1 521 ? 254.182 -42.356 250.483 1.0 39.08383  ? 521 LEU A O   521 LEU A O   1 
ATOM 4065  C CB  . LEU A 1 521 ? 257.093 -41.154 250.934 1.0 39.08383  ? 521 LEU A CB  521 LEU A CB  1 
ATOM 4066  C CG  . LEU A 1 521 ? 258.292 -40.231 251.114 1.0 39.08383  ? 521 LEU A CG  521 LEU A CG  1 
ATOM 4067  C CD1 . LEU A 1 521 ? 258.149 -39.038 250.204 1.0 39.08383  ? 521 LEU A CD1 521 LEU A CD1 1 
ATOM 4068  C CD2 . LEU A 1 521 ? 258.457 -39.793 252.531 1.0 39.08383  ? 521 LEU A CD2 521 LEU A CD2 1 
ATOM 4069  N N   . LEU A 1 522 ? 254.539 -40.655 249.070 1.0 41.41396  ? 522 LEU A N   522 LEU A N   1 
ATOM 4070  C CA  . LEU A 1 522 ? 253.833 -41.186 247.923 1.0 41.41396  ? 522 LEU A CA  522 LEU A CA  1 
ATOM 4071  C C   . LEU A 1 522 ? 254.858 -41.769 246.950 1.0 41.41396  ? 522 LEU A C   522 LEU A C   1 
ATOM 4072  O O   . LEU A 1 522 ? 256.064 -41.575 247.133 1.0 41.41396  ? 522 LEU A O   522 LEU A O   1 
ATOM 4073  C CB  . LEU A 1 522 ? 253.004 -40.064 247.285 1.0 41.41396  ? 522 LEU A CB  522 LEU A CB  1 
ATOM 4074  C CG  . LEU A 1 522 ? 251.867 -39.594 248.196 1.0 41.41396  ? 522 LEU A CG  522 LEU A CG  1 
ATOM 4075  C CD1 . LEU A 1 522 ? 251.142 -38.432 247.565 1.0 41.41396  ? 522 LEU A CD1 522 LEU A CD1 1 
ATOM 4076  C CD2 . LEU A 1 522 ? 250.916 -40.719 248.515 1.0 41.41396  ? 522 LEU A CD2 522 LEU A CD2 1 
ATOM 4077  N N   . PRO A 1 523 ? 254.424 -42.556 245.947 1.0 41.84558  ? 523 PRO A N   523 PRO A N   1 
ATOM 4078  C CA  . PRO A 1 523 ? 255.379 -43.126 244.986 1.0 41.84558  ? 523 PRO A CA  523 PRO A CA  1 
ATOM 4079  C C   . PRO A 1 523 ? 256.242 -42.115 244.242 1.0 41.84558  ? 523 PRO A C   523 PRO A C   1 
ATOM 4080  O O   . PRO A 1 523 ? 255.831 -40.989 243.964 1.0 41.84558  ? 523 PRO A O   523 PRO A O   1 
ATOM 4081  C CB  . PRO A 1 523 ? 254.473 -43.882 244.017 1.0 41.84558  ? 523 PRO A CB  523 PRO A CB  1 
ATOM 4082  C CG  . PRO A 1 523 ? 253.390 -44.346 244.868 1.0 41.84558  ? 523 PRO A CG  523 PRO A CG  1 
ATOM 4083  C CD  . PRO A 1 523 ? 253.130 -43.259 245.848 1.0 41.84558  ? 523 PRO A CD  523 PRO A CD  1 
ATOM 4084  N N   . GLY A 1 524 ? 257.455 -42.543 243.944 1.0 43.08241  ? 524 GLY A N   524 GLY A N   1 
ATOM 4085  C CA  . GLY A 1 524 ? 258.475 -41.732 243.311 1.0 43.08241  ? 524 GLY A CA  524 GLY A CA  1 
ATOM 4086  C C   . GLY A 1 524 ? 259.850 -42.155 243.787 1.0 43.08241  ? 524 GLY A C   524 GLY A C   1 
ATOM 4087  O O   . GLY A 1 524 ? 260.027 -42.719 244.860 1.0 43.08241  ? 524 GLY A O   524 GLY A O   1 
ATOM 4088  N N   . THR A 1 525 ? 260.853 -41.881 242.959 1.0 42.49625  ? 525 THR A N   525 THR A N   1 
ATOM 4089  C CA  . THR A 1 525 ? 262.241 -42.173 243.305 1.0 42.49625  ? 525 THR A CA  525 THR A CA  1 
ATOM 4090  C C   . THR A 1 525 ? 262.800 -40.991 244.084 1.0 42.49625  ? 525 THR A C   525 THR A C   1 
ATOM 4091  O O   . THR A 1 525 ? 262.790 -39.861 243.592 1.0 42.49625  ? 525 THR A O   525 THR A O   1 
ATOM 4092  C CB  . THR A 1 525 ? 263.075 -42.440 242.058 1.0 42.49625  ? 525 THR A CB  525 THR A CB  1 
ATOM 4093  O OG1 . THR A 1 525 ? 262.559 -43.585 241.371 1.0 42.49625  ? 525 THR A OG1 525 THR A OG1 1 
ATOM 4094  C CG2 . THR A 1 525 ? 264.520 -42.695 242.437 1.0 42.49625  ? 525 THR A CG2 525 THR A CG2 1 
ATOM 4095  N N   . TYR A 1 526 ? 263.291 -41.244 245.292 1.0 40.46252  ? 526 TYR A N   526 TYR A N   1 
ATOM 4096  C CA  . TYR A 1 526 ? 263.761 -40.182 246.166 1.0 40.46252  ? 526 TYR A CA  526 TYR A CA  1 
ATOM 4097  C C   . TYR A 1 526 ? 265.242 -40.341 246.476 1.0 40.46252  ? 526 TYR A C   526 TYR A C   1 
ATOM 4098  O O   . TYR A 1 526 ? 265.816 -41.424 246.356 1.0 40.46252  ? 526 TYR A O   526 TYR A O   1 
ATOM 4099  C CB  . TYR A 1 526 ? 262.946 -40.143 247.459 1.0 40.46252  ? 526 TYR A CB  526 TYR A CB  1 
ATOM 4100  C CG  . TYR A 1 526 ? 261.515 -39.755 247.212 1.0 40.46252  ? 526 TYR A CG  526 TYR A CG  1 
ATOM 4101  C CD1 . TYR A 1 526 ? 261.174 -38.439 246.964 1.0 40.46252  ? 526 TYR A CD1 526 TYR A CD1 1 
ATOM 4102  C CD2 . TYR A 1 526 ? 260.509 -40.702 247.220 1.0 40.46252  ? 526 TYR A CD2 526 TYR A CD2 1 
ATOM 4103  C CE1 . TYR A 1 526 ? 259.872 -38.078 246.725 1.0 40.46252  ? 526 TYR A CE1 526 TYR A CE1 1 
ATOM 4104  C CE2 . TYR A 1 526 ? 259.203 -40.351 246.980 1.0 40.46252  ? 526 TYR A CE2 526 TYR A CE2 1 
ATOM 4105  C CZ  . TYR A 1 526 ? 258.892 -39.037 246.735 1.0 40.46252  ? 526 TYR A CZ  526 TYR A CZ  1 
ATOM 4106  O OH  . TYR A 1 526 ? 257.589 -38.676 246.501 1.0 40.46252  ? 526 TYR A OH  526 TYR A OH  1 
ATOM 4107  N N   . ASN A 1 527 ? 265.850 -39.232 246.887 1.0 41.85954  ? 527 ASN A N   527 ASN A N   1 
ATOM 4108  C CA  . ASN A 1 527 ? 267.291 -39.119 247.070 1.0 41.85954  ? 527 ASN A CA  527 ASN A CA  1 
ATOM 4109  C C   . ASN A 1 527 ? 267.535 -38.610 248.481 1.0 41.85954  ? 527 ASN A C   527 ASN A C   1 
ATOM 4110  O O   . ASN A 1 527 ? 267.146 -37.486 248.803 1.0 41.85954  ? 527 ASN A O   527 ASN A O   1 
ATOM 4111  C CB  . ASN A 1 527 ? 267.877 -38.154 246.037 1.0 41.85954  ? 527 ASN A CB  527 ASN A CB  1 
ATOM 4112  C CG  . ASN A 1 527 ? 269.323 -38.426 245.727 1.0 41.85954  ? 527 ASN A CG  527 ASN A CG  1 
ATOM 4113  O OD1 . ASN A 1 527 ? 269.861 -37.902 244.756 1.0 41.85954  ? 527 ASN A OD1 527 ASN A OD1 1 
ATOM 4114  N ND2 . ASN A 1 527 ? 269.959 -39.264 246.529 1.0 41.85954  ? 527 ASN A ND2 527 ASN A ND2 1 
ATOM 4115  N N   . TYR A 1 528 ? 268.185 -39.417 249.316 1.0 42.98176  ? 528 TYR A N   528 TYR A N   1 
ATOM 4116  C CA  . TYR A 1 528 ? 268.211 -39.160 250.758 1.0 42.98176  ? 528 TYR A CA  528 TYR A CA  1 
ATOM 4117  C C   . TYR A 1 528 ? 269.623 -39.352 251.302 1.0 42.98176  ? 528 TYR A C   528 TYR A C   1 
ATOM 4118  O O   . TYR A 1 528 ? 269.994 -40.461 251.694 1.0 42.98176  ? 528 TYR A O   528 TYR A O   1 
ATOM 4119  C CB  . TYR A 1 528 ? 267.200 -40.065 251.449 1.0 42.98176  ? 528 TYR A CB  528 TYR A CB  1 
ATOM 4120  C CG  . TYR A 1 528 ? 267.080 -39.934 252.946 1.0 42.98176  ? 528 TYR A CG  528 TYR A CG  1 
ATOM 4121  C CD1 . TYR A 1 528 ? 266.652 -38.755 253.532 1.0 42.98176  ? 528 TYR A CD1 528 TYR A CD1 1 
ATOM 4122  C CD2 . TYR A 1 528 ? 267.292 -41.024 253.763 1.0 42.98176  ? 528 TYR A CD2 528 TYR A CD2 1 
ATOM 4123  C CE1 . TYR A 1 528 ? 266.506 -38.650 254.893 1.0 42.98176  ? 528 TYR A CE1 528 TYR A CE1 1 
ATOM 4124  C CE2 . TYR A 1 528 ? 267.141 -40.932 255.122 1.0 42.98176  ? 528 TYR A CE2 528 TYR A CE2 1 
ATOM 4125  C CZ  . TYR A 1 528 ? 266.751 -39.743 255.682 1.0 42.98176  ? 528 TYR A CZ  528 TYR A CZ  1 
ATOM 4126  O OH  . TYR A 1 528 ? 266.604 -39.653 257.042 1.0 42.98176  ? 528 TYR A OH  528 TYR A OH  1 
ATOM 4127  N N   . GLU A 1 529 ? 270.395 -38.267 251.345 1.0 48.26932  ? 529 GLU A N   529 GLU A N   1 
ATOM 4128  C CA  . GLU A 1 529 ? 271.762 -38.281 251.844 1.0 48.26932  ? 529 GLU A CA  529 GLU A CA  1 
ATOM 4129  C C   . GLU A 1 529 ? 271.856 -37.529 253.163 1.0 48.26932  ? 529 GLU A C   529 GLU A C   1 
ATOM 4130  O O   . GLU A 1 529 ? 271.014 -36.684 253.480 1.0 48.26932  ? 529 GLU A O   529 GLU A O   1 
ATOM 4131  C CB  . GLU A 1 529 ? 272.742 -37.655 250.848 1.0 48.26932  ? 529 GLU A CB  529 GLU A CB  1 
ATOM 4132  C CG  . GLU A 1 529 ? 272.568 -36.167 250.628 1.0 48.26932  ? 529 GLU A CG  529 GLU A CG  1 
ATOM 4133  C CD  . GLU A 1 529 ? 273.581 -35.607 249.651 1.0 48.26932  ? 529 GLU A CD  529 GLU A CD  1 
ATOM 4134  O OE1 . GLU A 1 529 ? 274.418 -36.386 249.151 1.0 48.26932  ? 529 GLU A OE1 529 GLU A OE1 1 
ATOM 4135  O OE2 . GLU A 1 529 ? 273.543 -34.388 249.383 1.0 48.26932  ? 529 GLU A OE2 529 GLU A OE2 1 
ATOM 4136  N N   . TRP A 1 530 ? 272.915 -37.825 253.914 1.0 49.67911  ? 530 TRP A N   530 TRP A N   1 
ATOM 4137  C CA  . TRP A 1 530 ? 273.091 -37.277 255.250 1.0 49.67911  ? 530 TRP A CA  530 TRP A CA  1 
ATOM 4138  C C   . TRP A 1 530 ? 274.539 -37.474 255.685 1.0 49.67911  ? 530 TRP A C   530 TRP A C   1 
ATOM 4139  O O   . TRP A 1 530 ? 275.177 -38.455 255.301 1.0 49.67911  ? 530 TRP A O   530 TRP A O   1 
ATOM 4140  C CB  . TRP A 1 530 ? 272.143 -37.951 256.244 1.0 49.67911  ? 530 TRP A CB  530 TRP A CB  1 
ATOM 4141  C CG  . TRP A 1 530 ? 272.175 -37.295 257.545 1.0 49.67911  ? 530 TRP A CG  530 TRP A CG  1 
ATOM 4142  C CD1 . TRP A 1 530 ? 272.956 -37.633 258.585 1.0 49.67911  ? 530 TRP A CD1 530 TRP A CD1 1 
ATOM 4143  C CD2 . TRP A 1 530 ? 271.386 -36.185 257.973 1.0 49.67911  ? 530 TRP A CD2 530 TRP A CD2 1 
ATOM 4144  N NE1 . TRP A 1 530 ? 272.744 -36.785 259.628 1.0 49.67911  ? 530 TRP A NE1 530 TRP A NE1 1 
ATOM 4145  C CE2 . TRP A 1 530 ? 271.765 -35.895 259.287 1.0 49.67911  ? 530 TRP A CE2 530 TRP A CE2 1 
ATOM 4146  C CE3 . TRP A 1 530 ? 270.395 -35.412 257.374 1.0 49.67911  ? 530 TRP A CE3 530 TRP A CE3 1 
ATOM 4147  C CZ2 . TRP A 1 530 ? 271.194 -34.867 260.016 1.0 49.67911  ? 530 TRP A CZ2 530 TRP A CZ2 1 
ATOM 4148  C CZ3 . TRP A 1 530 ? 269.835 -34.382 258.093 1.0 49.67911  ? 530 TRP A CZ3 530 TRP A CZ3 1 
ATOM 4149  C CH2 . TRP A 1 530 ? 270.232 -34.121 259.401 1.0 49.67911  ? 530 TRP A CH2 530 TRP A CH2 1 
ATOM 4150  N N   . TYR A 1 531 ? 275.050 -36.545 256.502 1.0 51.49314  ? 531 TYR A N   531 TYR A N   1 
ATOM 4151  C CA  . TYR A 1 531 ? 276.428 -36.585 256.986 1.0 51.49314  ? 531 TYR A CA  531 TYR A CA  1 
ATOM 4152  C C   . TYR A 1 531 ? 276.483 -37.019 258.445 1.0 51.49314  ? 531 TYR A C   531 TYR A C   1 
ATOM 4153  O O   . TYR A 1 531 ? 275.752 -36.489 259.283 1.0 51.49314  ? 531 TYR A O   531 TYR A O   1 
ATOM 4154  C CB  . TYR A 1 531 ? 277.117 -35.221 256.890 1.0 51.49314  ? 531 TYR A CB  531 TYR A CB  1 
ATOM 4155  C CG  . TYR A 1 531 ? 277.365 -34.666 255.511 1.0 51.49314  ? 531 TYR A CG  531 TYR A CG  1 
ATOM 4156  C CD1 . TYR A 1 531 ? 277.123 -35.403 254.369 1.0 51.49314  ? 531 TYR A CD1 531 TYR A CD1 1 
ATOM 4157  C CD2 . TYR A 1 531 ? 277.897 -33.404 255.361 1.0 51.49314  ? 531 TYR A CD2 531 TYR A CD2 1 
ATOM 4158  C CE1 . TYR A 1 531 ? 277.357 -34.870 253.127 1.0 51.49314  ? 531 TYR A CE1 531 TYR A CE1 1 
ATOM 4159  C CE2 . TYR A 1 531 ? 278.144 -32.873 254.129 1.0 51.49314  ? 531 TYR A CE2 531 TYR A CE2 1 
ATOM 4160  C CZ  . TYR A 1 531 ? 277.878 -33.609 253.015 1.0 51.49314  ? 531 TYR A CZ  531 TYR A CZ  1 
ATOM 4161  O OH  . TYR A 1 531 ? 278.129 -33.071 251.778 1.0 51.49314  ? 531 TYR A OH  531 TYR A OH  1 
ATOM 4162  N N   . PHE A 1 532 ? 277.394 -37.938 258.757 1.0 48.91003  ? 532 PHE A N   532 PHE A N   1 
ATOM 4163  C CA  . PHE A 1 532 ? 277.609 -38.416 260.116 1.0 48.91003  ? 532 PHE A CA  532 PHE A CA  1 
ATOM 4164  C C   . PHE A 1 532 ? 278.872 -37.809 260.711 1.0 48.91003  ? 532 PHE A C   532 PHE A C   1 
ATOM 4165  O O   . PHE A 1 532 ? 279.803 -37.446 259.994 1.0 48.91003  ? 532 PHE A O   532 PHE A O   1 
ATOM 4166  C CB  . PHE A 1 532 ? 277.725 -39.939 260.150 1.0 48.91003  ? 532 PHE A CB  532 PHE A CB  1 
ATOM 4167  C CG  . PHE A 1 532 ? 276.441 -40.652 259.891 1.0 48.91003  ? 532 PHE A CG  532 PHE A CG  1 
ATOM 4168  C CD1 . PHE A 1 532 ? 275.230 -40.001 259.989 1.0 48.91003  ? 532 PHE A CD1 532 PHE A CD1 1 
ATOM 4169  C CD2 . PHE A 1 532 ? 276.447 -41.981 259.550 1.0 48.91003  ? 532 PHE A CD2 532 PHE A CD2 1 
ATOM 4170  C CE1 . PHE A 1 532 ? 274.053 -40.667 259.751 1.0 48.91003  ? 532 PHE A CE1 532 PHE A CE1 1 
ATOM 4171  C CE2 . PHE A 1 532 ? 275.276 -42.643 259.320 1.0 48.91003  ? 532 PHE A CE2 532 PHE A CE2 1 
ATOM 4172  C CZ  . PHE A 1 532 ? 274.080 -41.985 259.412 1.0 48.91003  ? 532 PHE A CZ  532 PHE A CZ  1 
ATOM 4173  N N   . ARG A 1 533 ? 278.911 -37.731 262.037 1.0 51.80318  ? 533 ARG A N   533 ARG A N   1 
ATOM 4174  C CA  . ARG A 1 533 ? 280.045 -37.147 262.740 1.0 51.80318  ? 533 ARG A CA  533 ARG A CA  1 
ATOM 4175  C C   . ARG A 1 533 ? 281.095 -38.199 263.072 1.0 51.80318  ? 533 ARG A C   533 ARG A C   1 
ATOM 4176  O O   . ARG A 1 533 ? 280.821 -39.399 263.120 1.0 51.80318  ? 533 ARG A O   533 ARG A O   1 
ATOM 4177  C CB  . ARG A 1 533 ? 279.598 -36.452 264.028 1.0 51.80318  ? 533 ARG A CB  533 ARG A CB  1 
ATOM 4178  C CG  . ARG A 1 533 ? 278.841 -35.172 263.783 1.0 51.80318  ? 533 ARG A CG  533 ARG A CG  1 
ATOM 4179  C CD  . ARG A 1 533 ? 278.371 -34.458 265.028 1.0 51.80318  ? 533 ARG A CD  533 ARG A CD  1 
ATOM 4180  N NE  . ARG A 1 533 ? 277.636 -33.263 264.636 1.0 51.80318  ? 533 ARG A NE  533 ARG A NE  1 
ATOM 4181  C CZ  . ARG A 1 533 ? 276.935 -32.498 265.460 1.0 51.80318  ? 533 ARG A CZ  533 ARG A CZ  1 
ATOM 4182  N NH1 . ARG A 1 533 ? 276.844 -32.802 266.743 1.0 51.80318  ? 533 ARG A NH1 533 ARG A NH1 1 
ATOM 4183  N NH2 . ARG A 1 533 ? 276.305 -31.435 264.991 1.0 51.80318  ? 533 ARG A NH2 533 ARG A NH2 1 
ATOM 4184  N N   . LYS A 1 534 ? 282.318 -37.721 263.302 1.0 53.65835  ? 534 LYS A N   534 LYS A N   1 
ATOM 4185  C CA  . LYS A 1 534 ? 283.410 -38.553 263.781 1.0 53.65835  ? 534 LYS A CA  534 LYS A CA  1 
ATOM 4186  C C   . LYS A 1 534 ? 284.135 -37.967 264.980 1.0 53.65835  ? 534 LYS A C   534 LYS A C   1 
ATOM 4187  O O   . LYS A 1 534 ? 285.176 -38.503 265.370 1.0 53.65835  ? 534 LYS A O   534 LYS A O   1 
ATOM 4188  C CB  . LYS A 1 534 ? 284.441 -38.801 262.676 1.0 53.65835  ? 534 LYS A CB  534 LYS A CB  1 
ATOM 4189  C CG  . LYS A 1 534 ? 283.996 -39.740 261.598 1.0 53.65835  ? 534 LYS A CG  534 LYS A CG  1 
ATOM 4190  C CD  . LYS A 1 534 ? 285.128 -39.960 260.629 1.0 53.65835  ? 534 LYS A CD  534 LYS A CD  1 
ATOM 4191  C CE  . LYS A 1 534 ? 284.701 -40.860 259.512 1.0 53.65835  ? 534 LYS A CE  534 LYS A CE  1 
ATOM 4192  N NZ  . LYS A 1 534 ? 284.472 -42.235 259.992 1.0 53.65835  ? 534 LYS A NZ  534 LYS A NZ  1 
ATOM 4193  N N   . ASP A 1 535 ? 283.637 -36.888 265.557 1.0 59.79246  ? 535 ASP A N   535 ASP A N   1 
ATOM 4194  C CA  . ASP A 1 535 ? 284.312 -36.241 266.672 1.0 59.79246  ? 535 ASP A CA  535 ASP A CA  1 
ATOM 4195  C C   . ASP A 1 535 ? 284.122 -37.059 267.942 1.0 59.79246  ? 535 ASP A C   535 ASP A C   1 
ATOM 4196  O O   . ASP A 1 535 ? 282.977 -37.300 268.342 1.0 59.79246  ? 535 ASP A O   535 ASP A O   1 
ATOM 4197  C CB  . ASP A 1 535 ? 283.762 -34.834 266.855 1.0 59.79246  ? 535 ASP A CB  535 ASP A CB  1 
ATOM 4198  C CG  . ASP A 1 535 ? 284.520 -34.047 267.890 1.0 59.79246  ? 535 ASP A CG  535 ASP A CG  1 
ATOM 4199  O OD1 . ASP A 1 535 ? 285.658 -33.631 267.599 1.0 59.79246  ? 535 ASP A OD1 535 ASP A OD1 1 
ATOM 4200  O OD2 . ASP A 1 535 ? 283.978 -33.838 268.993 1.0 59.79246  ? 535 ASP A OD2 535 ASP A OD2 1 
ATOM 4201  N N   . PRO A 1 536 ? 285.196 -37.513 268.596 1.0 58.66055  ? 536 PRO A N   536 PRO A N   1 
ATOM 4202  C CA  . PRO A 1 536 ? 285.017 -38.360 269.784 1.0 58.66055  ? 536 PRO A CA  536 PRO A CA  1 
ATOM 4203  C C   . PRO A 1 536 ? 284.476 -37.611 270.987 1.0 58.66055  ? 536 PRO A C   536 PRO A C   1 
ATOM 4204  O O   . PRO A 1 536 ? 283.845 -38.234 271.849 1.0 58.66055  ? 536 PRO A O   536 PRO A O   1 
ATOM 4205  C CB  . PRO A 1 536 ? 286.431 -38.892 270.047 1.0 58.66055  ? 536 PRO A CB  536 PRO A CB  1 
ATOM 4206  C CG  . PRO A 1 536 ? 287.153 -38.723 268.759 1.0 58.66055  ? 536 PRO A CG  536 PRO A CG  1 
ATOM 4207  C CD  . PRO A 1 536 ? 286.600 -37.472 268.166 1.0 58.66055  ? 536 PRO A CD  536 PRO A CD  1 
ATOM 4208  N N   . ASN A 1 537 ? 284.705 -36.299 271.076 1.0 60.21272  ? 537 ASN A N   537 ASN A N   1 
ATOM 4209  C CA  . ASN A 1 537 ? 284.121 -35.517 272.160 1.0 60.21272  ? 537 ASN A CA  537 ASN A CA  1 
ATOM 4210  C C   . ASN A 1 537 ? 282.613 -35.402 272.016 1.0 60.21272  ? 537 ASN A C   537 ASN A C   1 
ATOM 4211  O O   . ASN A 1 537 ? 281.895 -35.351 273.019 1.0 60.21272  ? 537 ASN A O   537 ASN A O   1 
ATOM 4212  C CB  . ASN A 1 537 ? 284.734 -34.122 272.194 1.0 60.21272  ? 537 ASN A CB  537 ASN A CB  1 
ATOM 4213  C CG  . ASN A 1 537 ? 286.199 -34.142 272.512 1.0 60.21272  ? 537 ASN A CG  537 ASN A CG  1 
ATOM 4214  O OD1 . ASN A 1 537 ? 287.034 -33.827 271.668 1.0 60.21272  ? 537 ASN A OD1 537 ASN A OD1 1 
ATOM 4215  N ND2 . ASN A 1 537 ? 286.525 -34.494 273.743 1.0 60.21272  ? 537 ASN A ND2 537 ASN A ND2 1 
ATOM 4216  N N   . MET A 1 538 ? 282.120 -35.366 270.785 1.0 56.58329  ? 538 MET A N   538 MET A N   1 
ATOM 4217  C CA  . MET A 1 538 ? 280.707 -35.154 270.520 1.0 56.58329  ? 538 MET A CA  538 MET A CA  1 
ATOM 4218  C C   . MET A 1 538 ? 279.918 -36.457 270.542 1.0 56.58329  ? 538 MET A C   538 MET A C   1 
ATOM 4219  O O   . MET A 1 538 ? 278.839 -36.523 271.137 1.0 56.58329  ? 538 MET A O   538 MET A O   1 
ATOM 4220  C CB  . MET A 1 538 ? 280.541 -34.467 269.167 1.0 56.58329  ? 538 MET A CB  538 MET A CB  1 
ATOM 4221  C CG  . MET A 1 538 ? 279.128 -34.068 268.857 1.0 56.58329  ? 538 MET A CG  538 MET A CG  1 
ATOM 4222  S SD  . MET A 1 538 ? 278.545 -32.764 269.940 1.0 56.58329  ? 538 MET A SD  538 MET A SD  1 
ATOM 4223  C CE  . MET A 1 538 ? 279.473 -31.393 269.273 1.0 56.58329  ? 538 MET A CE  538 MET A CE  1 
ATOM 4224  N N   . VAL A 1 539 ? 280.450 -37.497 269.901 1.0 53.16008  ? 539 VAL A N   539 VAL A N   1 
ATOM 4225  C CA  . VAL A 1 539 ? 279.725 -38.756 269.769 1.0 53.16008  ? 539 VAL A CA  539 VAL A CA  1 
ATOM 4226  C C   . VAL A 1 539 ? 279.685 -39.498 271.100 1.0 53.16008  ? 539 VAL A C   539 VAL A C   1 
ATOM 4227  O O   . VAL A 1 539 ? 278.621 -39.935 271.552 1.0 53.16008  ? 539 VAL A O   539 VAL A O   1 
ATOM 4228  C CB  . VAL A 1 539 ? 280.360 -39.613 268.662 1.0 53.16008  ? 539 VAL A CB  539 VAL A CB  1 
ATOM 4229  C CG1 . VAL A 1 539 ? 279.706 -40.963 268.600 1.0 53.16008  ? 539 VAL A CG1 539 VAL A CG1 1 
ATOM 4230  C CG2 . VAL A 1 539 ? 280.238 -38.917 267.328 1.0 53.16008  ? 539 VAL A CG2 539 VAL A CG2 1 
ATOM 4231  N N   . LEU A 1 540 ? 280.833 -39.638 271.751 1.0 52.52366  ? 540 LEU A N   540 LEU A N   1 
ATOM 4232  C CA  . LEU A 1 540 ? 280.945 -40.394 272.988 1.0 52.52366  ? 540 LEU A CA  540 LEU A CA  1 
ATOM 4233  C C   . LEU A 1 540 ? 280.820 -39.475 274.197 1.0 52.52366  ? 540 LEU A C   540 LEU A C   1 
ATOM 4234  O O   . LEU A 1 540 ? 281.205 -38.306 274.154 1.0 52.52366  ? 540 LEU A O   540 LEU A O   1 
ATOM 4235  C CB  . LEU A 1 540 ? 282.276 -41.139 273.046 1.0 52.52366  ? 540 LEU A CB  540 LEU A CB  1 
ATOM 4236  C CG  . LEU A 1 540 ? 282.490 -42.213 271.985 1.0 52.52366  ? 540 LEU A CG  540 LEU A CG  1 
ATOM 4237  C CD1 . LEU A 1 540 ? 283.893 -42.770 272.078 1.0 52.52366  ? 540 LEU A CD1 540 LEU A CD1 1 
ATOM 4238  C CD2 . LEU A 1 540 ? 281.464 -43.312 272.138 1.0 52.52366  ? 540 LEU A CD2 540 LEU A CD2 1 
ATOM 4239  N N   . GLN A 1 541 ? 280.274 -40.020 275.277 1.0 52.25402  ? 541 GLN A N   541 GLN A N   1 
ATOM 4240  C CA  . GLN A 1 541 ? 280.127 -39.315 276.541 1.0 52.25402  ? 541 GLN A CA  541 GLN A CA  1 
ATOM 4241  C C   . GLN A 1 541 ? 280.991 -39.982 277.595 1.0 52.25402  ? 541 GLN A C   541 GLN A C   1 
ATOM 4242  O O   . GLN A 1 541 ? 280.948 -41.202 277.756 1.0 52.25402  ? 541 GLN A O   541 GLN A O   1 
ATOM 4243  C CB  . GLN A 1 541 ? 278.675 -39.324 277.008 1.0 52.25402  ? 541 GLN A CB  541 GLN A CB  1 
ATOM 4244  C CG  . GLN A 1 541 ? 278.410 -38.520 278.257 1.0 52.25402  ? 541 GLN A CG  541 GLN A CG  1 
ATOM 4245  C CD  . GLN A 1 541 ? 276.948 -38.520 278.639 1.0 52.25402  ? 541 GLN A CD  541 GLN A CD  1 
ATOM 4246  O OE1 . GLN A 1 541 ? 276.130 -39.176 278.001 1.0 52.25402  ? 541 GLN A OE1 541 GLN A OE1 1 
ATOM 4247  N NE2 . GLN A 1 541 ? 276.610 -37.777 279.683 1.0 52.25402  ? 541 GLN A NE2 541 GLN A NE2 1 
ATOM 4248  N N   . SER A 1 542 ? 281.760 -39.187 278.324 1.0 55.60347  ? 542 SER A N   542 SER A N   1 
ATOM 4249  C CA  . SER A 1 542 ? 282.598 -39.706 279.389 1.0 55.60347  ? 542 SER A CA  542 SER A CA  1 
ATOM 4250  C C   . SER A 1 542 ? 282.039 -39.291 280.741 1.0 55.60347  ? 542 SER A C   542 SER A C   1 
ATOM 4251  O O   . SER A 1 542 ? 281.360 -38.271 280.863 1.0 55.60347  ? 542 SER A O   542 SER A O   1 
ATOM 4252  C CB  . SER A 1 542 ? 284.036 -39.211 279.251 1.0 55.60347  ? 542 SER A CB  542 SER A CB  1 
ATOM 4253  O OG  . SER A 1 542 ? 284.841 -39.715 280.299 1.0 55.60347  ? 542 SER A OG  542 SER A OG  1 
ATOM 4254  N N   . THR A 1 543 ? 282.327 -40.100 281.758 1.0 55.85945  ? 543 THR A N   543 THR A N   1 
ATOM 4255  C CA  . THR A 1 543 ? 281.882 -39.770 283.106 1.0 55.85945  ? 543 THR A CA  543 THR A CA  1 
ATOM 4256  C C   . THR A 1 543 ? 282.694 -38.616 283.677 1.0 55.85945  ? 543 THR A C   543 THR A C   1 
ATOM 4257  O O   . THR A 1 543 ? 282.135 -37.660 284.220 1.0 55.85945  ? 543 THR A O   543 THR A O   1 
ATOM 4258  C CB  . THR A 1 543 ? 281.979 -40.998 284.005 1.0 55.85945  ? 543 THR A CB  543 THR A CB  1 
ATOM 4259  O OG1 . THR A 1 543 ? 281.158 -42.042 283.473 1.0 55.85945  ? 543 THR A OG1 543 THR A OG1 1 
ATOM 4260  C CG2 . THR A 1 543 ? 281.505 -40.672 285.399 1.0 55.85945  ? 543 THR A CG2 543 THR A CG2 1 
ATOM 4261  N N   . LEU A 1 544 ? 284.017 -38.681 283.550 1.0 60.31032  ? 544 LEU A N   544 LEU A N   1 
ATOM 4262  C CA  . LEU A 1 544 ? 284.863 -37.598 284.031 1.0 60.31032  ? 544 LEU A CA  544 LEU A CA  1 
ATOM 4263  C C   . LEU A 1 544 ? 284.793 -36.368 283.140 1.0 60.31032  ? 544 LEU A C   544 LEU A C   1 
ATOM 4264  O O   . LEU A 1 544 ? 285.094 -35.266 283.607 1.0 60.31032  ? 544 LEU A O   544 LEU A O   1 
ATOM 4265  C CB  . LEU A 1 544 ? 286.313 -38.063 284.145 1.0 60.31032  ? 544 LEU A CB  544 LEU A CB  1 
ATOM 4266  C CG  . LEU A 1 544 ? 286.803 -38.770 285.409 1.0 60.31032  ? 544 LEU A CG  544 LEU A CG  1 
ATOM 4267  C CD1 . LEU A 1 544 ? 286.205 -40.148 285.584 1.0 60.31032  ? 544 LEU A CD1 544 LEU A CD1 1 
ATOM 4268  C CD2 . LEU A 1 544 ? 288.309 -38.877 285.345 1.0 60.31032  ? 544 LEU A CD2 544 LEU A CD2 1 
ATOM 4269  N N   . GLY A 1 545 ? 284.405 -36.525 281.879 1.0 60.91892  ? 545 GLY A N   545 GLY A N   1 
ATOM 4270  C CA  . GLY A 1 545 ? 284.300 -35.382 280.995 1.0 60.91892  ? 545 GLY A CA  545 GLY A CA  1 
ATOM 4271  C C   . GLY A 1 545 ? 285.628 -34.834 280.538 1.0 60.91892  ? 545 GLY A C   545 GLY A C   1 
ATOM 4272  O O   . GLY A 1 545 ? 285.772 -33.619 280.389 1.0 60.91892  ? 545 GLY A O   545 GLY A O   1 
ATOM 4273  N N   . ASN A 1 546 ? 286.608 -35.702 280.313 1.0 63.49364  ? 546 ASN A N   546 ASN A N   1 
ATOM 4274  C CA  . ASN A 1 546 ? 287.931 -35.290 279.871 1.0 63.49364  ? 546 ASN A CA  546 ASN A CA  1 
ATOM 4275  C C   . ASN A 1 546 ? 287.931 -35.036 278.365 1.0 63.49364  ? 546 ASN A C   546 ASN A C   1 
ATOM 4276  O O   . ASN A 1 546 ? 286.885 -34.942 277.720 1.0 63.49364  ? 546 ASN A O   546 ASN A O   1 
ATOM 4277  C CB  . ASN A 1 546 ? 288.962 -36.336 280.277 1.0 63.49364  ? 546 ASN A CB  546 ASN A CB  1 
ATOM 4278  C CG  . ASN A 1 546 ? 288.592 -37.733 279.822 1.0 63.49364  ? 546 ASN A CG  546 ASN A CG  1 
ATOM 4279  O OD1 . ASN A 1 546 ? 287.550 -37.949 279.207 1.0 63.49364  ? 546 ASN A OD1 546 ASN A OD1 1 
ATOM 4280  N ND2 . ASN A 1 546 ? 289.457 -38.690 280.111 1.0 63.49364  ? 546 ASN A ND2 546 ASN A ND2 1 
ATOM 4281  N N   . ASP A 1 547 ? 289.118 -34.911 277.785 1.0 66.65998  ? 547 ASP A N   547 ASP A N   1 
ATOM 4282  C CA  . ASP A 1 547 ? 289.260 -34.776 276.342 1.0 66.65998  ? 547 ASP A CA  547 ASP A CA  1 
ATOM 4283  C C   . ASP A 1 547 ? 289.385 -36.173 275.749 1.0 66.65998  ? 547 ASP A C   547 ASP A C   1 
ATOM 4284  O O   . ASP A 1 547 ? 290.370 -36.875 275.996 1.0 66.65998  ? 547 ASP A O   547 ASP A O   1 
ATOM 4285  C CB  . ASP A 1 547 ? 290.478 -33.929 275.992 1.0 66.65998  ? 547 ASP A CB  547 ASP A CB  1 
ATOM 4286  C CG  . ASP A 1 547 ? 290.490 -33.506 274.541 1.0 66.65998  ? 547 ASP A CG  547 ASP A CG  1 
ATOM 4287  O OD1 . ASP A 1 547 ? 289.488 -33.744 273.840 1.0 66.65998  ? 547 ASP A OD1 547 ASP A OD1 1 
ATOM 4288  O OD2 . ASP A 1 547 ? 291.519 -32.972 274.083 1.0 66.65998  ? 547 ASP A OD2 547 ASP A OD2 1 
ATOM 4289  N N   . LEU A 1 548 ? 288.386 -36.580 274.971 1.0 63.67684  ? 548 LEU A N   548 LEU A N   1 
ATOM 4290  C CA  . LEU A 1 548 ? 288.496 -37.827 274.232 1.0 63.67684  ? 548 LEU A CA  548 LEU A CA  1 
ATOM 4291  C C   . LEU A 1 548 ? 289.268 -37.661 272.933 1.0 63.67684  ? 548 LEU A C   548 LEU A C   1 
ATOM 4292  O O   . LEU A 1 548 ? 289.679 -38.661 272.339 1.0 63.67684  ? 548 LEU A O   548 LEU A O   1 
ATOM 4293  C CB  . LEU A 1 548 ? 287.111 -38.405 273.953 1.0 63.67684  ? 548 LEU A CB  548 LEU A CB  1 
ATOM 4294  C CG  . LEU A 1 548 ? 286.381 -38.879 275.206 1.0 63.67684  ? 548 LEU A CG  548 LEU A CG  1 
ATOM 4295  C CD1 . LEU A 1 548 ? 284.983 -39.332 274.868 1.0 63.67684  ? 548 LEU A CD1 548 LEU A CD1 1 
ATOM 4296  C CD2 . LEU A 1 548 ? 287.154 -39.997 275.868 1.0 63.67684  ? 548 LEU A CD2 548 LEU A CD2 1 
ATOM 4297  N N   . ARG A 1 549 ? 289.479 -36.426 272.478 1.0 66.63226  ? 549 ARG A N   549 ARG A N   1 
ATOM 4298  C CA  . ARG A 1 549 ? 290.326 -36.214 271.312 1.0 66.63226  ? 549 ARG A CA  549 ARG A CA  1 
ATOM 4299  C C   . ARG A 1 549 ? 291.799 -36.368 271.668 1.0 66.63226  ? 549 ARG A C   549 ARG A C   1 
ATOM 4300  O O   . ARG A 1 549 ? 292.608 -36.741 270.811 1.0 66.63226  ? 549 ARG A O   549 ARG A O   1 
ATOM 4301  C CB  . ARG A 1 549 ? 290.052 -34.831 270.714 1.0 66.63226  ? 549 ARG A CB  549 ARG A CB  1 
ATOM 4302  C CG  . ARG A 1 549 ? 290.709 -34.565 269.364 1.0 66.63226  ? 549 ARG A CG  549 ARG A CG  1 
ATOM 4303  C CD  . ARG A 1 549 ? 290.399 -33.172 268.849 1.0 66.63226  ? 549 ARG A CD  549 ARG A CD  1 
ATOM 4304  N NE  . ARG A 1 549 ? 288.979 -32.981 268.573 1.0 66.63226  ? 549 ARG A NE  549 ARG A NE  1 
ATOM 4305  C CZ  . ARG A 1 549 ? 288.195 -32.152 269.253 1.0 66.63226  ? 549 ARG A CZ  549 ARG A CZ  1 
ATOM 4306  N NH1 . ARG A 1 549 ? 288.688 -31.441 270.253 1.0 66.63226  ? 549 ARG A NH1 549 ARG A NH1 1 
ATOM 4307  N NH2 . ARG A 1 549 ? 286.915 -32.034 268.936 1.0 66.63226  ? 549 ARG A NH2 549 ARG A NH2 1 
ATOM 4308  N N   . ALA A 1 550 ? 292.158 -36.114 272.930 1.0 67.1975   ? 550 ALA A N   550 ALA A N   1 
ATOM 4309  C CA  . ALA A 1 550 ? 293.561 -36.133 273.333 1.0 67.1975   ? 550 ALA A CA  550 ALA A CA  1 
ATOM 4310  C C   . ALA A 1 550 ? 294.116 -37.551 273.358 1.0 67.1975   ? 550 ALA A C   550 ALA A C   1 
ATOM 4311  O O   . ALA A 1 550 ? 295.157 -37.830 272.753 1.0 67.1975   ? 550 ALA A O   550 ALA A O   1 
ATOM 4312  C CB  . ALA A 1 550 ? 293.720 -35.472 274.700 1.0 67.1975   ? 550 ALA A CB  550 ALA A CB  1 
ATOM 4313  N N   . ASP A 1 551 ? 293.434 -38.462 274.047 1.0 67.8711   ? 551 ASP A N   551 ASP A N   1 
ATOM 4314  C CA  . ASP A 1 551 ? 293.854 -39.853 274.091 1.0 67.8711   ? 551 ASP A CA  551 ASP A CA  1 
ATOM 4315  C C   . ASP A 1 551 ? 293.438 -40.583 272.813 1.0 67.8711   ? 551 ASP A C   551 ASP A C   1 
ATOM 4316  O O   . ASP A 1 551 ? 292.913 -39.994 271.865 1.0 67.8711   ? 551 ASP A O   551 ASP A O   1 
ATOM 4317  C CB  . ASP A 1 551 ? 293.289 -40.535 275.335 1.0 67.8711   ? 551 ASP A CB  551 ASP A CB  1 
ATOM 4318  C CG  . ASP A 1 551 ? 291.786 -40.390 275.449 1.0 67.8711   ? 551 ASP A CG  551 ASP A CG  1 
ATOM 4319  O OD1 . ASP A 1 551 ? 291.205 -39.619 274.667 1.0 67.8711   ? 551 ASP A OD1 551 ASP A OD1 1 
ATOM 4320  O OD2 . ASP A 1 551 ? 291.177 -41.058 276.306 1.0 67.8711   ? 551 ASP A OD2 551 ASP A OD2 1 
ATOM 4321  N N   . GLY A 1 552 ? 293.659 -41.895 272.795 1.0 66.23646  ? 552 GLY A N   552 GLY A N   1 
ATOM 4322  C CA  . GLY A 1 552 ? 293.397 -42.687 271.610 1.0 66.23646  ? 552 GLY A CA  552 GLY A CA  1 
ATOM 4323  C C   . GLY A 1 552 ? 291.968 -43.164 271.467 1.0 66.23646  ? 552 GLY A C   552 GLY A C   1 
ATOM 4324  O O   . GLY A 1 552 ? 291.728 -44.353 271.239 1.0 66.23646  ? 552 GLY A O   552 GLY A O   1 
ATOM 4325  N N   . ALA A 1 553 ? 291.008 -42.254 271.595 1.0 61.82297  ? 553 ALA A N   553 ALA A N   1 
ATOM 4326  C CA  . ALA A 1 553 ? 289.610 -42.576 271.361 1.0 61.82297  ? 553 ALA A CA  553 ALA A CA  1 
ATOM 4327  C C   . ALA A 1 553 ? 289.250 -42.215 269.930 1.0 61.82297  ? 553 ALA A C   553 ALA A C   1 
ATOM 4328  O O   . ALA A 1 553 ? 289.511 -41.095 269.484 1.0 61.82297  ? 553 ALA A O   553 ALA A O   1 
ATOM 4329  C CB  . ALA A 1 553 ? 288.702 -41.833 272.338 1.0 61.82297  ? 553 ALA A CB  553 ALA A CB  1 
ATOM 4330  N N   . SER A 1 554 ? 288.655 -43.162 269.213 1.0 58.38918  ? 554 SER A N   554 SER A N   1 
ATOM 4331  C CA  . SER A 1 554 ? 288.369 -42.949 267.804 1.0 58.38918  ? 554 SER A CA  554 SER A CA  1 
ATOM 4332  C C   . SER A 1 554 ? 287.172 -43.785 267.394 1.0 58.38918  ? 554 SER A C   554 SER A C   1 
ATOM 4333  O O   . SER A 1 554 ? 287.066 -44.953 267.773 1.0 58.38918  ? 554 SER A O   554 SER A O   1 
ATOM 4334  C CB  . SER A 1 554 ? 289.578 -43.306 266.938 1.0 58.38918  ? 554 SER A CB  554 SER A CB  1 
ATOM 4335  O OG  . SER A 1 554 ? 289.818 -44.699 266.960 1.0 58.38918  ? 554 SER A OG  554 SER A OG  1 
ATOM 4336  N N   . ILE A 1 555 ? 286.284 -43.175 266.624 1.0 54.10469  ? 555 ILE A N   555 ILE A N   1 
ATOM 4337  C CA  . ILE A 1 555 ? 285.116 -43.827 266.050 1.0 54.10469  ? 555 ILE A CA  555 ILE A CA  1 
ATOM 4338  C C   . ILE A 1 555 ? 285.347 -43.996 264.553 1.0 54.10469  ? 555 ILE A C   555 ILE A C   1 
ATOM 4339  O O   . ILE A 1 555 ? 285.961 -43.137 263.906 1.0 54.10469  ? 555 ILE A O   555 ILE A O   1 
ATOM 4340  C CB  . ILE A 1 555 ? 283.841 -43.012 266.370 1.0 54.10469  ? 555 ILE A CB  555 ILE A CB  1 
ATOM 4341  C CG1 . ILE A 1 555 ? 282.579 -43.690 265.852 1.0 54.10469  ? 555 ILE A CG1 555 ILE A CG1 1 
ATOM 4342  C CG2 . ILE A 1 555 ? 283.934 -41.594 265.877 1.0 54.10469  ? 555 ILE A CG2 555 ILE A CG2 1 
ATOM 4343  C CD1 . ILE A 1 555 ? 282.238 -44.919 266.567 1.0 54.10469  ? 555 ILE A CD1 555 ILE A CD1 1 
ATOM 4344  N N   . THR A 1 556 ? 284.926 -45.137 264.007 1.0 51.94419  ? 556 THR A N   556 THR A N   1 
ATOM 4345  C CA  . THR A 1 556 ? 284.997 -45.345 262.568 1.0 51.94419  ? 556 THR A CA  556 THR A CA  1 
ATOM 4346  C C   . THR A 1 556 ? 283.855 -46.245 262.122 1.0 51.94419  ? 556 THR A C   556 THR A C   1 
ATOM 4347  O O   . THR A 1 556 ? 283.334 -47.052 262.895 1.0 51.94419  ? 556 THR A O   556 THR A O   1 
ATOM 4348  C CB  . THR A 1 556 ? 286.345 -45.928 262.126 1.0 51.94419  ? 556 THR A CB  556 THR A CB  1 
ATOM 4349  O OG1 . THR A 1 556 ? 286.364 -46.061 260.699 1.0 51.94419  ? 556 THR A OG1 556 THR A OG1 1 
ATOM 4350  C CG2 . THR A 1 556 ? 286.597 -47.265 262.762 1.0 51.94419  ? 556 THR A CG2 556 THR A CG2 1 
ATOM 4351  N N   . TYR A 1 557 ? 283.469 -46.086 260.863 1.0 50.11437  ? 557 TYR A N   557 TYR A N   1 
ATOM 4352  C CA  . TYR A 1 557 ? 282.266 -46.693 260.317 1.0 50.11437  ? 557 TYR A CA  557 TYR A CA  1 
ATOM 4353  C C   . TYR A 1 557 ? 282.664 -47.662 259.214 1.0 50.11437  ? 557 TYR A C   557 TYR A C   1 
ATOM 4354  O O   . TYR A 1 557 ? 283.366 -47.274 258.275 1.0 50.11437  ? 557 TYR A O   557 TYR A O   1 
ATOM 4355  C CB  . TYR A 1 557 ? 281.335 -45.616 259.768 1.0 50.11437  ? 557 TYR A CB  557 TYR A CB  1 
ATOM 4356  C CG  . TYR A 1 557 ? 280.859 -44.624 260.799 1.0 50.11437  ? 557 TYR A CG  557 TYR A CG  1 
ATOM 4357  C CD1 . TYR A 1 557 ? 279.829 -44.939 261.656 1.0 50.11437  ? 557 TYR A CD1 557 TYR A CD1 1 
ATOM 4358  C CD2 . TYR A 1 557 ? 281.433 -43.369 260.904 1.0 50.11437  ? 557 TYR A CD2 557 TYR A CD2 1 
ATOM 4359  C CE1 . TYR A 1 557 ? 279.379 -44.040 262.598 1.0 50.11437  ? 557 TYR A CE1 557 TYR A CE1 1 
ATOM 4360  C CE2 . TYR A 1 557 ? 280.988 -42.460 261.846 1.0 50.11437  ? 557 TYR A CE2 557 TYR A CE2 1 
ATOM 4361  C CZ  . TYR A 1 557 ? 279.962 -42.805 262.687 1.0 50.11437  ? 557 TYR A CZ  557 TYR A CZ  1 
ATOM 4362  O OH  . TYR A 1 557 ? 279.508 -41.916 263.627 1.0 50.11437  ? 557 TYR A OH  557 TYR A OH  1 
ATOM 4363  N N   . THR A 1 558 ? 282.219 -48.915 259.319 1.0 50.41303  ? 558 THR A N   558 THR A N   1 
ATOM 4364  C CA  . THR A 1 558 ? 282.574 -49.870 258.277 1.0 50.41303  ? 558 THR A CA  558 THR A CA  1 
ATOM 4365  C C   . THR A 1 558 ? 281.496 -50.002 257.200 1.0 50.41303  ? 558 THR A C   558 THR A C   1 
ATOM 4366  O O   . THR A 1 558 ? 281.837 -50.117 256.018 1.0 50.41303  ? 558 THR A O   558 THR A O   1 
ATOM 4367  C CB  . THR A 1 558 ? 282.928 -51.235 258.891 1.0 50.41303  ? 558 THR A CB  558 THR A CB  1 
ATOM 4368  O OG1 . THR A 1 558 ? 283.290 -52.153 257.852 1.0 50.41303  ? 558 THR A OG1 558 THR A OG1 1 
ATOM 4369  C CG2 . THR A 1 558 ? 281.806 -51.822 259.730 1.0 50.41303  ? 558 THR A CG2 558 THR A CG2 1 
ATOM 4370  N N   . GLN A 1 559 ? 280.213 -49.950 257.568 1.0 49.99098  ? 559 GLN A N   559 GLN A N   1 
ATOM 4371  C CA  . GLN A 1 559 ? 279.100 -49.950 256.625 1.0 49.99098  ? 559 GLN A CA  559 GLN A CA  1 
ATOM 4372  C C   . GLN A 1 559 ? 277.851 -49.504 257.365 1.0 49.99098  ? 559 GLN A C   559 GLN A C   1 
ATOM 4373  O O   . GLN A 1 559 ? 277.685 -49.802 258.548 1.0 49.99098  ? 559 GLN A O   559 GLN A O   1 
ATOM 4374  C CB  . GLN A 1 559 ? 278.865 -51.327 255.971 1.0 49.99098  ? 559 GLN A CB  559 GLN A CB  1 
ATOM 4375  C CG  . GLN A 1 559 ? 278.441 -52.457 256.903 1.0 49.99098  ? 559 GLN A CG  559 GLN A CG  1 
ATOM 4376  C CD  . GLN A 1 559 ? 278.266 -53.781 256.182 1.0 49.99098  ? 559 GLN A CD  559 GLN A CD  1 
ATOM 4377  O OE1 . GLN A 1 559 ? 278.418 -53.862 254.965 1.0 49.99098  ? 559 GLN A OE1 559 GLN A OE1 1 
ATOM 4378  N NE2 . GLN A 1 559 ? 277.940 -54.825 256.933 1.0 49.99098  ? 559 GLN A NE2 559 GLN A NE2 1 
ATOM 4379  N N   . ILE A 1 560 ? 277.000 -48.743 256.682 1.0 46.06086  ? 560 ILE A N   560 ILE A N   1 
ATOM 4380  C CA  . ILE A 1 560 ? 275.674 -48.417 257.184 1.0 46.06086  ? 560 ILE A CA  560 ILE A CA  1 
ATOM 4381  C C   . ILE A 1 560 ? 274.664 -48.792 256.105 1.0 46.06086  ? 560 ILE A C   560 ILE A C   1 
ATOM 4382  O O   . ILE A 1 560 ? 275.031 -49.134 254.981 1.0 46.06086  ? 560 ILE A O   560 ILE A O   1 
ATOM 4383  C CB  . ILE A 1 560 ? 275.513 -46.935 257.559 1.0 46.06086  ? 560 ILE A CB  560 ILE A CB  1 
ATOM 4384  C CG1 . ILE A 1 560 ? 275.497 -46.095 256.306 1.0 46.06086  ? 560 ILE A CG1 560 ILE A CG1 1 
ATOM 4385  C CG2 . ILE A 1 560 ? 276.647 -46.444 258.436 1.0 46.06086  ? 560 ILE A CG2 560 ILE A CG2 1 
ATOM 4386  C CD1 . ILE A 1 560 ? 274.956 -44.782 256.565 1.0 46.06086  ? 560 ILE A CD1 560 ILE A CD1 1 
ATOM 4387  N N   . ASN A 1 561 ? 273.382 -48.705 256.464 1.0 44.60668  ? 561 ASN A N   561 ASN A N   1 
ATOM 4388  C CA  . ASN A 1 561 ? 272.272 -48.913 255.544 1.0 44.60668  ? 561 ASN A CA  561 ASN A CA  1 
ATOM 4389  C C   . ASN A 1 561 ? 270.988 -48.389 256.169 1.0 44.60668  ? 561 ASN A C   561 ASN A C   1 
ATOM 4390  O O   . ASN A 1 561 ? 270.849 -48.371 257.391 1.0 44.60668  ? 561 ASN A O   561 ASN A O   1 
ATOM 4391  C CB  . ASN A 1 561 ? 272.124 -50.389 255.150 1.0 44.60668  ? 561 ASN A CB  561 ASN A CB  1 
ATOM 4392  C CG  . ASN A 1 561 ? 272.181 -51.318 256.333 1.0 44.60668  ? 561 ASN A CG  561 ASN A CG  1 
ATOM 4393  O OD1 . ASN A 1 561 ? 272.326 -50.886 257.474 1.0 44.60668  ? 561 ASN A OD1 561 ASN A OD1 1 
ATOM 4394  N ND2 . ASN A 1 561 ? 272.061 -52.611 256.069 1.0 44.60668  ? 561 ASN A ND2 561 ASN A ND2 1 
ATOM 4395  N N   . LEU A 1 562 ? 270.062 -47.961 255.319 1.0 42.28179  ? 562 LEU A N   562 LEU A N   1 
ATOM 4396  C CA  . LEU A 1 562 ? 268.793 -47.397 255.748 1.0 42.28179  ? 562 LEU A CA  562 LEU A CA  1 
ATOM 4397  C C   . LEU A 1 562 ? 267.707 -48.459 255.698 1.0 42.28179  ? 562 LEU A C   562 LEU A C   1 
ATOM 4398  O O   . LEU A 1 562 ? 267.630 -49.236 254.746 1.0 42.28179  ? 562 LEU A O   562 LEU A O   1 
ATOM 4399  C CB  . LEU A 1 562 ? 268.401 -46.231 254.847 1.0 42.28179  ? 562 LEU A CB  562 LEU A CB  1 
ATOM 4400  C CG  . LEU A 1 562 ? 267.098 -45.505 255.159 1.0 42.28179  ? 562 LEU A CG  562 LEU A CG  1 
ATOM 4401  C CD1 . LEU A 1 562 ? 267.209 -44.765 256.464 1.0 42.28179  ? 562 LEU A CD1 562 LEU A CD1 1 
ATOM 4402  C CD2 . LEU A 1 562 ? 266.747 -44.574 254.032 1.0 42.28179  ? 562 LEU A CD2 562 LEU A CD2 1 
ATOM 4403  N N   . TYR A 1 563 ? 266.864 -48.493 256.721 1.0 44.23863  ? 563 TYR A N   563 TYR A N   1 
ATOM 4404  C CA  . TYR A 1 563 ? 265.767 -49.447 256.781 1.0 44.23863  ? 563 TYR A CA  563 TYR A CA  1 
ATOM 4405  C C   . TYR A 1 563 ? 264.448 -48.693 256.755 1.0 44.23863  ? 563 TYR A C   563 TYR A C   1 
ATOM 4406  O O   . TYR A 1 563 ? 264.275 -47.726 257.497 1.0 44.23863  ? 563 TYR A O   563 TYR A O   1 
ATOM 4407  C CB  . TYR A 1 563 ? 265.847 -50.307 258.037 1.0 44.23863  ? 563 TYR A CB  563 TYR A CB  1 
ATOM 4408  C CG  . TYR A 1 563 ? 266.988 -51.286 258.081 1.0 44.23863  ? 563 TYR A CG  563 TYR A CG  1 
ATOM 4409  C CD1 . TYR A 1 563 ? 267.754 -51.578 256.961 1.0 44.23863  ? 563 TYR A CD1 563 TYR A CD1 1 
ATOM 4410  C CD2 . TYR A 1 563 ? 267.279 -51.954 259.246 1.0 44.23863  ? 563 TYR A CD2 563 TYR A CD2 1 
ATOM 4411  C CE1 . TYR A 1 563 ? 268.790 -52.483 257.031 1.0 44.23863  ? 563 TYR A CE1 563 TYR A CE1 1 
ATOM 4412  C CE2 . TYR A 1 563 ? 268.297 -52.859 259.303 1.0 44.23863  ? 563 TYR A CE2 563 TYR A CE2 1 
ATOM 4413  C CZ  . TYR A 1 563 ? 269.052 -53.118 258.197 1.0 44.23863  ? 563 TYR A CZ  563 TYR A CZ  1 
ATOM 4414  O OH  . TYR A 1 563 ? 270.074 -54.031 258.281 1.0 44.23863  ? 563 TYR A OH  563 TYR A OH  1 
ATOM 4415  N N   . VAL A 1 564 ? 263.522 -49.129 255.902 1.0 44.1336   ? 564 VAL A N   564 VAL A N   1 
ATOM 4416  C CA  . VAL A 1 564 ? 262.167 -48.598 255.870 1.0 44.1336   ? 564 VAL A CA  564 VAL A CA  1 
ATOM 4417  C C   . VAL A 1 564 ? 261.186 -49.756 255.982 1.0 44.1336   ? 564 VAL A C   564 VAL A C   1 
ATOM 4418  O O   . VAL A 1 564 ? 261.554 -50.925 255.877 1.0 44.1336   ? 564 VAL A O   564 VAL A O   1 
ATOM 4419  C CB  . VAL A 1 564 ? 261.875 -47.779 254.601 1.0 44.1336   ? 564 VAL A CB  564 VAL A CB  1 
ATOM 4420  C CG1 . VAL A 1 564 ? 262.716 -46.523 254.569 1.0 44.1336   ? 564 VAL A CG1 564 VAL A CG1 1 
ATOM 4421  C CG2 . VAL A 1 564 ? 262.130 -48.620 253.382 1.0 44.1336   ? 564 VAL A CG2 564 VAL A CG2 1 
ATOM 4422  N N   . SER A 1 565 ? 259.919 -49.413 256.192 1.0 45.63892  ? 565 SER A N   565 SER A N   1 
ATOM 4423  C CA  . SER A 1 565 ? 258.863 -50.398 256.367 1.0 45.63892  ? 565 SER A CA  565 SER A CA  1 
ATOM 4424  C C   . SER A 1 565 ? 257.697 -50.028 255.472 1.0 45.63892  ? 565 SER A C   565 SER A C   1 
ATOM 4425  O O   . SER A 1 565 ? 256.946 -49.097 255.779 1.0 45.63892  ? 565 SER A O   565 SER A O   1 
ATOM 4426  C CB  . SER A 1 565 ? 258.407 -50.468 257.819 1.0 45.63892  ? 565 SER A CB  565 SER A CB  1 
ATOM 4427  O OG  . SER A 1 565 ? 259.452 -50.932 258.645 1.0 45.63892  ? 565 SER A OG  565 SER A OG  1 
ATOM 4428  N N   . PHE A 1 566 ? 257.538 -50.762 254.382 1.0 46.78176  ? 566 PHE A N   566 PHE A N   1 
ATOM 4429  C CA  . PHE A 1 566 ? 256.453 -50.536 253.444 1.0 46.78176  ? 566 PHE A CA  566 PHE A CA  1 
ATOM 4430  C C   . PHE A 1 566 ? 255.221 -51.247 253.973 1.0 46.78176  ? 566 PHE A C   566 PHE A C   1 
ATOM 4431  O O   . PHE A 1 566 ? 255.280 -52.443 254.288 1.0 46.78176  ? 566 PHE A O   566 PHE A O   1 
ATOM 4432  C CB  . PHE A 1 566 ? 256.839 -51.040 252.057 1.0 46.78176  ? 566 PHE A CB  566 PHE A CB  1 
ATOM 4433  C CG  . PHE A 1 566 ? 257.924 -50.237 251.419 1.0 46.78176  ? 566 PHE A CG  566 PHE A CG  1 
ATOM 4434  C CD1 . PHE A 1 566 ? 258.133 -48.925 251.792 1.0 46.78176  ? 566 PHE A CD1 566 PHE A CD1 1 
ATOM 4435  C CD2 . PHE A 1 566 ? 258.766 -50.802 250.488 1.0 46.78176  ? 566 PHE A CD2 566 PHE A CD2 1 
ATOM 4436  C CE1 . PHE A 1 566 ? 259.133 -48.188 251.226 1.0 46.78176  ? 566 PHE A CE1 566 PHE A CE1 1 
ATOM 4437  C CE2 . PHE A 1 566 ? 259.773 -50.059 249.913 1.0 46.78176  ? 566 PHE A CE2 566 PHE A CE2 1 
ATOM 4438  C CZ  . PHE A 1 566 ? 259.957 -48.751 250.289 1.0 46.78176  ? 566 PHE A CZ  566 PHE A CZ  1 
ATOM 4439  N N   . PHE A 1 567 ? 254.122 -50.514 254.116 1.0 49.0939   ? 567 PHE A N   567 PHE A N   1 
ATOM 4440  C CA  . PHE A 1 567 ? 252.885 -51.130 254.571 1.0 49.0939   ? 567 PHE A CA  567 PHE A CA  1 
ATOM 4441  C C   . PHE A 1 567 ? 252.238 -51.867 253.400 1.0 49.0939   ? 567 PHE A C   567 PHE A C   1 
ATOM 4442  O O   . PHE A 1 567 ? 252.068 -51.279 252.322 1.0 49.0939   ? 567 PHE A O   567 PHE A O   1 
ATOM 4443  C CB  . PHE A 1 567 ? 251.940 -50.078 255.135 1.0 49.0939   ? 567 PHE A CB  567 PHE A CB  1 
ATOM 4444  C CG  . PHE A 1 567 ? 250.654 -50.638 255.665 1.0 49.0939   ? 567 PHE A CG  567 PHE A CG  1 
ATOM 4445  C CD1 . PHE A 1 567 ? 250.594 -51.231 256.918 1.0 49.0939   ? 567 PHE A CD1 567 PHE A CD1 1 
ATOM 4446  C CD2 . PHE A 1 567 ? 249.503 -50.571 254.917 1.0 49.0939   ? 567 PHE A CD2 567 PHE A CD2 1 
ATOM 4447  C CE1 . PHE A 1 567 ? 249.398 -51.732 257.403 1.0 49.0939   ? 567 PHE A CE1 567 PHE A CE1 1 
ATOM 4448  C CE2 . PHE A 1 567 ? 248.309 -51.075 255.389 1.0 49.0939   ? 567 PHE A CE2 567 PHE A CE2 1 
ATOM 4449  C CZ  . PHE A 1 567 ? 248.255 -51.657 256.635 1.0 49.0939   ? 567 PHE A CZ  567 PHE A CZ  1 
ATOM 4450  N N   . PRO A 1 568 ? 251.871 -53.127 253.559 1.0 49.46538  ? 568 PRO A N   568 PRO A N   1 
ATOM 4451  C CA  . PRO A 1 568 ? 251.329 -53.913 252.437 1.0 49.46538  ? 568 PRO A CA  568 PRO A CA  1 
ATOM 4452  C C   . PRO A 1 568 ? 249.873 -53.575 252.129 1.0 49.46538  ? 568 PRO A C   568 PRO A C   1 
ATOM 4453  O O   . PRO A 1 568 ? 248.988 -54.416 252.227 1.0 49.46538  ? 568 PRO A O   568 PRO A O   1 
ATOM 4454  C CB  . PRO A 1 568 ? 251.485 -55.343 252.955 1.0 49.46538  ? 568 PRO A CB  568 PRO A CB  1 
ATOM 4455  C CG  . PRO A 1 568 ? 251.335 -55.216 254.409 1.0 49.46538  ? 568 PRO A CG  568 PRO A CG  1 
ATOM 4456  C CD  . PRO A 1 568 ? 251.997 -53.934 254.784 1.0 49.46538  ? 568 PRO A CD  568 PRO A CD  1 
ATOM 4457  N N   . MET A 1 569 ? 249.627 -52.336 251.728 1.0 51.43397  ? 569 MET A N   569 MET A N   1 
ATOM 4458  C CA  . MET A 1 569 ? 248.266 -51.904 251.455 1.0 51.43397  ? 569 MET A CA  569 MET A CA  1 
ATOM 4459  C C   . MET A 1 569 ? 247.784 -52.503 250.136 1.0 51.43397  ? 569 MET A C   569 MET A C   1 
ATOM 4460  O O   . MET A 1 569 ? 248.583 -52.830 249.255 1.0 51.43397  ? 569 MET A O   569 MET A O   1 
ATOM 4461  C CB  . MET A 1 569 ? 248.207 -50.375 251.427 1.0 51.43397  ? 569 MET A CB  569 MET A CB  1 
ATOM 4462  C CG  . MET A 1 569 ? 246.815 -49.773 251.438 1.0 51.43397  ? 569 MET A CG  569 MET A CG  1 
ATOM 4463  S SD  . MET A 1 569 ? 246.834 -47.984 251.541 1.0 51.43397  ? 569 MET A SD  569 MET A SD  1 
ATOM 4464  C CE  . MET A 1 569 ? 247.368 -47.782 253.233 1.0 51.43397  ? 569 MET A CE  569 MET A CE  1 
ATOM 4465  N N   . ASN A 1 570 ? 246.469 -52.701 250.041 1.0 51.49832  ? 570 ASN A N   570 ASN A N   1 
ATOM 4466  C CA  . ASN A 1 570 ? 245.834 -53.177 248.820 1.0 51.49832  ? 570 ASN A CA  570 ASN A CA  1 
ATOM 4467  C C   . ASN A 1 570 ? 246.091 -52.205 247.676 1.0 51.49832  ? 570 ASN A C   570 ASN A C   1 
ATOM 4468  O O   . ASN A 1 570 ? 246.113 -50.987 247.870 1.0 51.49832  ? 570 ASN A O   570 ASN A O   1 
ATOM 4469  C CB  . ASN A 1 570 ? 244.333 -53.330 249.060 1.0 51.49832  ? 570 ASN A CB  570 ASN A CB  1 
ATOM 4470  C CG  . ASN A 1 570 ? 243.645 -54.154 248.001 1.0 51.49832  ? 570 ASN A CG  570 ASN A CG  1 
ATOM 4471  O OD1 . ASN A 1 570 ? 244.267 -54.626 247.053 1.0 51.49832  ? 570 ASN A OD1 570 ASN A OD1 1 
ATOM 4472  N ND2 . ASN A 1 570 ? 242.347 -54.345 248.166 1.0 51.49832  ? 570 ASN A ND2 570 ASN A ND2 1 
ATOM 4473  N N   . TYR A 1 571 ? 246.287 -52.750 246.475 1.0 50.58362  ? 571 TYR A N   571 TYR A N   1 
ATOM 4474  C CA  . TYR A 1 571 ? 246.732 -51.924 245.357 1.0 50.58362  ? 571 TYR A CA  571 TYR A CA  1 
ATOM 4475  C C   . TYR A 1 571 ? 245.631 -51.018 244.829 1.0 50.58362  ? 571 TYR A C   571 TYR A C   1 
ATOM 4476  O O   . TYR A 1 571 ? 245.928 -50.053 244.121 1.0 50.58362  ? 571 TYR A O   571 TYR A O   1 
ATOM 4477  C CB  . TYR A 1 571 ? 247.270 -52.791 244.218 1.0 50.58362  ? 571 TYR A CB  571 TYR A CB  1 
ATOM 4478  C CG  . TYR A 1 571 ? 248.586 -53.487 244.498 1.0 50.58362  ? 571 TYR A CG  571 TYR A CG  1 
ATOM 4479  C CD1 . TYR A 1 571 ? 249.336 -53.189 245.627 1.0 50.58362  ? 571 TYR A CD1 571 TYR A CD1 1 
ATOM 4480  C CD2 . TYR A 1 571 ? 249.093 -54.420 243.609 1.0 50.58362  ? 571 TYR A CD2 571 TYR A CD2 1 
ATOM 4481  C CE1 . TYR A 1 571 ? 250.533 -53.818 245.874 1.0 50.58362  ? 571 TYR A CE1 571 TYR A CE1 1 
ATOM 4482  C CE2 . TYR A 1 571 ? 250.294 -55.050 243.846 1.0 50.58362  ? 571 TYR A CE2 571 TYR A CE2 1 
ATOM 4483  C CZ  . TYR A 1 571 ? 251.006 -54.746 244.979 1.0 50.58362  ? 571 TYR A CZ  571 TYR A CZ  1 
ATOM 4484  O OH  . TYR A 1 571 ? 252.202 -55.375 245.217 1.0 50.58362  ? 571 TYR A OH  571 TYR A OH  1 
ATOM 4485  N N   . ASP A 1 572 ? 244.376 -51.301 245.158 1.0 54.6017   ? 572 ASP A N   572 ASP A N   1 
ATOM 4486  C CA  . ASP A 1 572 ? 243.282 -50.414 244.803 1.0 54.6017   ? 572 ASP A CA  572 ASP A CA  1 
ATOM 4487  C C   . ASP A 1 572 ? 242.796 -49.580 245.975 1.0 54.6017   ? 572 ASP A C   572 ASP A C   1 
ATOM 4488  O O   . ASP A 1 572 ? 242.033 -48.633 245.766 1.0 54.6017   ? 572 ASP A O   572 ASP A O   1 
ATOM 4489  C CB  . ASP A 1 572 ? 242.122 -51.225 244.226 1.0 54.6017   ? 572 ASP A CB  572 ASP A CB  1 
ATOM 4490  C CG  . ASP A 1 572 ? 242.475 -51.871 242.905 1.0 54.6017   ? 572 ASP A CG  572 ASP A CG  1 
ATOM 4491  O OD1 . ASP A 1 572 ? 243.275 -51.285 242.147 1.0 54.6017   ? 572 ASP A OD1 572 ASP A OD1 1 
ATOM 4492  O OD2 . ASP A 1 572 ? 241.975 -52.979 242.632 1.0 54.6017   ? 572 ASP A OD2 572 ASP A OD2 1 
ATOM 4493  N N   . THR A 1 573 ? 243.208 -49.916 247.196 1.0 51.04954  ? 573 THR A N   573 THR A N   1 
ATOM 4494  C CA  . THR A 1 573 ? 243.015 -49.016 248.325 1.0 51.04954  ? 573 THR A CA  573 THR A CA  1 
ATOM 4495  C C   . THR A 1 573 ? 244.077 -47.925 248.325 1.0 51.04954  ? 573 THR A C   573 THR A C   1 
ATOM 4496  O O   . THR A 1 573 ? 243.780 -46.761 248.613 1.0 51.04954  ? 573 THR A O   573 THR A O   1 
ATOM 4497  C CB  . THR A 1 573 ? 243.049 -49.807 249.631 1.0 51.04954  ? 573 THR A CB  573 THR A CB  1 
ATOM 4498  O OG1 . THR A 1 573 ? 242.053 -50.834 249.587 1.0 51.04954  ? 573 THR A OG1 573 THR A OG1 1 
ATOM 4499  C CG2 . THR A 1 573 ? 242.764 -48.914 250.818 1.0 51.04954  ? 573 THR A CG2 573 THR A CG2 1 
ATOM 4500  N N   . GLN A 1 574 ? 245.316 -48.289 247.983 1.0 49.62773  ? 574 GLN A N   574 GLN A N   1 
ATOM 4501  C CA  . GLN A 1 574 ? 246.379 -47.305 247.813 1.0 49.62773  ? 574 GLN A CA  574 GLN A CA  1 
ATOM 4502  C C   . GLN A 1 574 ? 246.089 -46.374 246.648 1.0 49.62773  ? 574 GLN A C   574 GLN A C   1 
ATOM 4503  O O   . GLN A 1 574 ? 246.466 -45.199 246.688 1.0 49.62773  ? 574 GLN A O   574 GLN A O   1 
ATOM 4504  C CB  . GLN A 1 574 ? 247.713 -48.019 247.602 1.0 49.62773  ? 574 GLN A CB  574 GLN A CB  1 
ATOM 4505  C CG  . GLN A 1 574 ? 248.963 -47.148 247.667 1.0 49.62773  ? 574 GLN A CG  574 GLN A CG  1 
ATOM 4506  C CD  . GLN A 1 574 ? 249.314 -46.501 246.341 1.0 49.62773  ? 574 GLN A CD  574 GLN A CD  1 
ATOM 4507  O OE1 . GLN A 1 574 ? 248.920 -46.982 245.281 1.0 49.62773  ? 574 GLN A OE1 574 GLN A OE1 1 
ATOM 4508  N NE2 . GLN A 1 574 ? 250.062 -45.408 246.395 1.0 49.62773  ? 574 GLN A NE2 574 GLN A NE2 1 
ATOM 4509  N N   . SER A 1 575 ? 245.422 -46.875 245.608 1.0 50.32896  ? 575 SER A N   575 SER A N   1 
ATOM 4510  C CA  . SER A 1 575 ? 245.080 -46.046 244.461 1.0 50.32896  ? 575 SER A CA  575 SER A CA  1 
ATOM 4511  C C   . SER A 1 575 ? 244.025 -45.004 244.789 1.0 50.32896  ? 575 SER A C   575 SER A C   1 
ATOM 4512  O O   . SER A 1 575 ? 243.864 -44.047 244.029 1.0 50.32896  ? 575 SER A O   575 SER A O   1 
ATOM 4513  C CB  . SER A 1 575 ? 244.597 -46.923 243.311 1.0 50.32896  ? 575 SER A CB  575 SER A CB  1 
ATOM 4514  O OG  . SER A 1 575 ? 244.193 -46.131 242.212 1.0 50.32896  ? 575 SER A OG  575 SER A OG  1 
ATOM 4515  N N   . GLU A 1 576 ? 243.296 -45.170 245.889 1.0 52.5319   ? 576 GLU A N   576 GLU A N   1 
ATOM 4516  C CA  . GLU A 1 576 ? 242.397 -44.136 246.374 1.0 52.5319   ? 576 GLU A CA  576 GLU A CA  1 
ATOM 4517  C C   . GLU A 1 576 ? 243.088 -43.215 247.367 1.0 52.5319   ? 576 GLU A C   576 GLU A C   1 
ATOM 4518  O O   . GLU A 1 576 ? 242.804 -42.014 247.397 1.0 52.5319   ? 576 GLU A O   576 GLU A O   1 
ATOM 4519  C CB  . GLU A 1 576 ? 241.167 -44.770 247.022 1.0 52.5319   ? 576 GLU A CB  576 GLU A CB  1 
ATOM 4520  C CG  . GLU A 1 576 ? 240.294 -45.541 246.059 1.0 52.5319   ? 576 GLU A CG  576 GLU A CG  1 
ATOM 4521  C CD  . GLU A 1 576 ? 239.127 -46.207 246.749 1.0 52.5319   ? 576 GLU A CD  576 GLU A CD  1 
ATOM 4522  O OE1 . GLU A 1 576 ? 239.067 -46.157 247.995 1.0 52.5319   ? 576 GLU A OE1 576 GLU A OE1 1 
ATOM 4523  O OE2 . GLU A 1 576 ? 238.272 -46.786 246.048 1.0 52.5319   ? 576 GLU A OE2 576 GLU A OE2 1 
ATOM 4524  N N   . LEU A 1 577 ? 244.002 -43.753 248.174 1.0 46.21807  ? 577 LEU A N   577 LEU A N   1 
ATOM 4525  C CA  . LEU A 1 577 ? 244.699 -42.945 249.163 1.0 46.21807  ? 577 LEU A CA  577 LEU A CA  1 
ATOM 4526  C C   . LEU A 1 577 ? 245.809 -42.114 248.546 1.0 46.21807  ? 577 LEU A C   577 LEU A C   1 
ATOM 4527  O O   . LEU A 1 577 ? 246.153 -41.065 249.096 1.0 46.21807  ? 577 LEU A O   577 LEU A O   1 
ATOM 4528  C CB  . LEU A 1 577 ? 245.235 -43.844 250.283 1.0 46.21807  ? 577 LEU A CB  577 LEU A CB  1 
ATOM 4529  C CG  . LEU A 1 577 ? 245.740 -43.280 251.618 1.0 46.21807  ? 577 LEU A CG  577 LEU A CG  1 
ATOM 4530  C CD1 . LEU A 1 577 ? 247.208 -42.945 251.621 1.0 46.21807  ? 577 LEU A CD1 577 LEU A CD1 1 
ATOM 4531  C CD2 . LEU A 1 577 ? 244.946 -42.040 252.000 1.0 46.21807  ? 577 LEU A CD2 577 LEU A CD2 1 
ATOM 4532  N N   . GLU A 1 578 ? 246.373 -42.544 247.420 1.0 46.83633  ? 578 GLU A N   578 GLU A N   1 
ATOM 4533  C CA  . GLU A 1 578 ? 247.334 -41.695 246.731 1.0 46.83633  ? 578 GLU A CA  578 GLU A CA  1 
ATOM 4534  C C   . GLU A 1 578 ? 246.645 -40.478 246.135 1.0 46.83633  ? 578 GLU A C   578 GLU A C   1 
ATOM 4535  O O   . GLU A 1 578 ? 247.134 -39.354 246.276 1.0 46.83633  ? 578 GLU A O   578 GLU A O   1 
ATOM 4536  C CB  . GLU A 1 578 ? 248.068 -42.479 245.649 1.0 46.83633  ? 578 GLU A CB  578 GLU A CB  1 
ATOM 4537  C CG  . GLU A 1 578 ? 249.130 -41.655 244.962 1.0 46.83633  ? 578 GLU A CG  578 GLU A CG  1 
ATOM 4538  C CD  . GLU A 1 578 ? 249.892 -42.422 243.909 1.0 46.83633  ? 578 GLU A CD  578 GLU A CD  1 
ATOM 4539  O OE1 . GLU A 1 578 ? 249.587 -43.613 243.697 1.0 46.83633  ? 578 GLU A OE1 578 GLU A OE1 1 
ATOM 4540  O OE2 . GLU A 1 578 ? 250.797 -41.823 243.291 1.0 46.83633  ? 578 GLU A OE2 578 GLU A OE2 1 
ATOM 4541  N N   . LEU A 1 579 ? 245.481 -40.683 245.505 1.0 46.66756  ? 579 LEU A N   579 LEU A N   1 
ATOM 4542  C CA  . LEU A 1 579 ? 244.731 -39.587 244.892 1.0 46.66756  ? 579 LEU A CA  579 LEU A CA  1 
ATOM 4543  C C   . LEU A 1 579 ? 244.261 -38.563 245.914 1.0 46.66756  ? 579 LEU A C   579 LEU A C   1 
ATOM 4544  O O   . LEU A 1 579 ? 244.148 -37.377 245.592 1.0 46.66756  ? 579 LEU A O   579 LEU A O   1 
ATOM 4545  C CB  . LEU A 1 579 ? 243.525 -40.133 244.135 1.0 46.66756  ? 579 LEU A CB  579 LEU A CB  1 
ATOM 4546  C CG  . LEU A 1 579 ? 243.768 -40.899 242.845 1.0 46.66756  ? 579 LEU A CG  579 LEU A CG  1 
ATOM 4547  C CD1 . LEU A 1 579 ? 242.476 -41.498 242.342 1.0 46.66756  ? 579 LEU A CD1 579 LEU A CD1 1 
ATOM 4548  C CD2 . LEU A 1 579 ? 244.308 -39.950 241.831 1.0 46.66756  ? 579 LEU A CD2 579 LEU A CD2 1 
ATOM 4549  N N   . MET A 1 580 ? 243.981 -38.991 247.140 1.0 45.12662  ? 580 MET A N   580 MET A N   1 
ATOM 4550  C CA  . MET A 1 580 ? 243.609 -38.040 248.174 1.0 45.12662  ? 580 MET A CA  580 MET A CA  1 
ATOM 4551  C C   . MET A 1 580 ? 244.797 -37.249 248.692 1.0 45.12662  ? 580 MET A C   580 MET A C   1 
ATOM 4552  O O   . MET A 1 580 ? 244.606 -36.142 249.200 1.0 45.12662  ? 580 MET A O   580 MET A O   1 
ATOM 4553  C CB  . MET A 1 580 ? 242.921 -38.756 249.332 1.0 45.12662  ? 580 MET A CB  580 MET A CB  1 
ATOM 4554  C CG  . MET A 1 580 ? 241.553 -39.285 248.981 1.0 45.12662  ? 580 MET A CG  580 MET A CG  1 
ATOM 4555  S SD  . MET A 1 580 ? 240.698 -40.023 250.378 1.0 45.12662  ? 580 MET A SD  580 MET A SD  1 
ATOM 4556  C CE  . MET A 1 580 ? 241.516 -41.600 250.491 1.0 45.12662  ? 580 MET A CE  580 MET A CE  1 
ATOM 4557  N N   . LEU A 1 581 ? 246.011 -37.774 248.572 1.0 41.26822  ? 581 LEU A N   581 LEU A N   1 
ATOM 4558  C CA  . LEU A 1 581 ? 247.187 -37.053 249.032 1.0 41.26822  ? 581 LEU A CA  581 LEU A CA  1 
ATOM 4559  C C   . LEU A 1 581 ? 247.942 -36.345 247.917 1.0 41.26822  ? 581 LEU A C   581 LEU A C   1 
ATOM 4560  O O   . LEU A 1 581 ? 248.806 -35.517 248.214 1.0 41.26822  ? 581 LEU A O   581 LEU A O   1 
ATOM 4561  C CB  . LEU A 1 581 ? 248.138 -37.994 249.768 1.0 41.26822  ? 581 LEU A CB  581 LEU A CB  1 
ATOM 4562  C CG  . LEU A 1 581 ? 247.619 -38.512 251.101 1.0 41.26822  ? 581 LEU A CG  581 LEU A CG  1 
ATOM 4563  C CD1 . LEU A 1 581 ? 248.605 -39.493 251.662 1.0 41.26822  ? 581 LEU A CD1 581 LEU A CD1 1 
ATOM 4564  C CD2 . LEU A 1 581 ? 247.409 -37.364 252.061 1.0 41.26822  ? 581 LEU A CD2 581 LEU A CD2 1 
ATOM 4565  N N   . ARG A 1 582 ? 247.644 -36.638 246.649 1.0 42.74216  ? 582 ARG A N   582 ARG A N   1 
ATOM 4566  C CA  . ARG A 1 582 ? 248.133 -35.786 245.573 1.0 42.74216  ? 582 ARG A CA  582 ARG A CA  1 
ATOM 4567  C C   . ARG A 1 582 ? 247.389 -34.461 245.511 1.0 42.74216  ? 582 ARG A C   582 ARG A C   1 
ATOM 4568  O O   . ARG A 1 582 ? 247.835 -33.553 244.803 1.0 42.74216  ? 582 ARG A O   582 ARG A O   1 
ATOM 4569  C CB  . ARG A 1 582 ? 248.005 -36.475 244.211 1.0 42.74216  ? 582 ARG A CB  582 ARG A CB  1 
ATOM 4570  C CG  . ARG A 1 582 ? 248.772 -37.770 244.035 1.0 42.74216  ? 582 ARG A CG  582 ARG A CG  1 
ATOM 4571  C CD  . ARG A 1 582 ? 250.248 -37.563 244.034 1.0 42.74216  ? 582 ARG A CD  582 ARG A CD  1 
ATOM 4572  N NE  . ARG A 1 582 ? 250.978 -38.803 243.833 1.0 42.74216  ? 582 ARG A NE  582 ARG A NE  1 
ATOM 4573  C CZ  . ARG A 1 582 ? 252.296 -38.901 243.922 1.0 42.74216  ? 582 ARG A CZ  582 ARG A CZ  1 
ATOM 4574  N NH1 . ARG A 1 582 ? 253.020 -37.834 244.216 1.0 42.74216  ? 582 ARG A NH1 582 ARG A NH1 1 
ATOM 4575  N NH2 . ARG A 1 582 ? 252.890 -40.064 243.722 1.0 42.74216  ? 582 ARG A NH2 582 ARG A NH2 1 
ATOM 4576  N N   . ASN A 1 583 ? 246.269 -34.341 246.218 1.0 43.04828  ? 583 ASN A N   583 ASN A N   1 
ATOM 4577  C CA  . ASN A 1 583 ? 245.456 -33.138 246.194 1.0 43.04828  ? 583 ASN A CA  583 ASN A CA  1 
ATOM 4578  C C   . ASN A 1 583 ? 246.168 -32.005 246.924 1.0 43.04828  ? 583 ASN A C   583 ASN A C   1 
ATOM 4579  O O   . ASN A 1 583 ? 246.971 -32.228 247.831 1.0 43.04828  ? 583 ASN A O   583 ASN A O   1 
ATOM 4580  C CB  . ASN A 1 583 ? 244.101 -33.422 246.836 1.0 43.04828  ? 583 ASN A CB  583 ASN A CB  1 
ATOM 4581  C CG  . ASN A 1 583 ? 243.063 -32.389 246.490 1.0 43.04828  ? 583 ASN A CG  583 ASN A CG  1 
ATOM 4582  O OD1 . ASN A 1 583 ? 243.339 -31.428 245.778 1.0 43.04828  ? 583 ASN A OD1 583 ASN A OD1 1 
ATOM 4583  N ND2 . ASN A 1 583 ? 241.850 -32.587 246.984 1.0 43.04828  ? 583 ASN A ND2 583 ASN A ND2 1 
ATOM 4584  N N   . ALA A 1 584 ? 245.873 -30.775 246.508 1.0 40.78429  ? 584 ALA A N   584 ALA A N   1 
ATOM 4585  C CA  . ALA A 1 584 ? 246.558 -29.618 247.067 1.0 40.78429  ? 584 ALA A CA  584 ALA A CA  1 
ATOM 4586  C C   . ALA A 1 584 ? 246.014 -29.208 248.426 1.0 40.78429  ? 584 ALA A C   584 ALA A C   1 
ATOM 4587  O O   . ALA A 1 584 ? 246.725 -28.543 249.184 1.0 40.78429  ? 584 ALA A O   584 ALA A O   1 
ATOM 4588  C CB  . ALA A 1 584 ? 246.466 -28.436 246.103 1.0 40.78429  ? 584 ALA A CB  584 ALA A CB  1 
ATOM 4589  N N   . THR A 1 585 ? 244.781 -29.578 248.750 1.0 40.82644  ? 585 THR A N   585 THR A N   1 
ATOM 4590  C CA  . THR A 1 585 ? 244.181 -29.210 250.023 1.0 40.82644  ? 585 THR A CA  585 THR A CA  1 
ATOM 4591  C C   . THR A 1 585 ? 244.465 -30.215 251.126 1.0 40.82644  ? 585 THR A C   585 THR A C   1 
ATOM 4592  O O   . THR A 1 585 ? 244.029 -30.003 252.260 1.0 40.82644  ? 585 THR A O   585 THR A O   1 
ATOM 4593  C CB  . THR A 1 585 ? 242.670 -29.045 249.872 1.0 40.82644  ? 585 THR A CB  585 THR A CB  1 
ATOM 4594  O OG1 . THR A 1 585 ? 242.124 -28.551 251.099 1.0 40.82644  ? 585 THR A OG1 585 THR A OG1 1 
ATOM 4595  C CG2 . THR A 1 585 ? 242.027 -30.370 249.549 1.0 40.82644  ? 585 THR A CG2 585 THR A CG2 1 
ATOM 4596  N N   . ASN A 1 586 ? 245.178 -31.294 250.826 1.0 40.53935  ? 586 ASN A N   586 ASN A N   1 
ATOM 4597  C CA  . ASN A 1 586 ? 245.532 -32.312 251.806 1.0 40.53935  ? 586 ASN A CA  586 ASN A CA  1 
ATOM 4598  C C   . ASN A 1 586 ? 247.033 -32.330 252.067 1.0 40.53935  ? 586 ASN A C   586 ASN A C   1 
ATOM 4599  O O   . ASN A 1 586 ? 247.633 -33.391 252.241 1.0 40.53935  ? 586 ASN A O   586 ASN A O   1 
ATOM 4600  C CB  . ASN A 1 586 ? 245.065 -33.687 251.349 1.0 40.53935  ? 586 ASN A CB  586 ASN A CB  1 
ATOM 4601  C CG  . ASN A 1 586 ? 243.571 -33.835 251.389 1.0 40.53935  ? 586 ASN A CG  586 ASN A CG  1 
ATOM 4602  O OD1 . ASN A 1 586 ? 242.921 -33.399 252.331 1.0 40.53935  ? 586 ASN A OD1 586 ASN A OD1 1 
ATOM 4603  N ND2 . ASN A 1 586 ? 243.012 -34.465 250.368 1.0 40.53935  ? 586 ASN A ND2 586 ASN A ND2 1 
ATOM 4604  N N   . ASP A 1 587 ? 247.657 -31.157 252.085 1.0 41.01273  ? 587 ASP A N   587 ASP A N   1 
ATOM 4605  C CA  . ASP A 1 587 ? 249.090 -31.085 252.320 1.0 41.01273  ? 587 ASP A CA  587 ASP A CA  1 
ATOM 4606  C C   . ASP A 1 587 ? 249.394 -31.337 253.786 1.0 41.01273  ? 587 ASP A C   587 ASP A C   1 
ATOM 4607  O O   . ASP A 1 587 ? 248.694 -30.848 254.674 1.0 41.01273  ? 587 ASP A O   587 ASP A O   1 
ATOM 4608  C CB  . ASP A 1 587 ? 249.636 -29.726 251.903 1.0 41.01273  ? 587 ASP A CB  587 ASP A CB  1 
ATOM 4609  C CG  . ASP A 1 587 ? 249.525 -29.497 250.423 1.0 41.01273  ? 587 ASP A CG  587 ASP A CG  1 
ATOM 4610  O OD1 . ASP A 1 587 ? 249.446 -30.500 249.687 1.0 41.01273  ? 587 ASP A OD1 587 ASP A OD1 1 
ATOM 4611  O OD2 . ASP A 1 587 ? 249.529 -28.324 249.993 1.0 41.01273  ? 587 ASP A OD2 587 ASP A OD2 1 
ATOM 4612  N N   . GLN A 1 588 ? 250.447 -32.103 254.035 1.0 38.23395  ? 588 GLN A N   588 GLN A N   1 
ATOM 4613  C CA  . GLN A 1 588 ? 250.779 -32.511 255.388 1.0 38.23395  ? 588 GLN A CA  588 GLN A CA  1 
ATOM 4614  C C   . GLN A 1 588 ? 251.493 -31.382 256.111 1.0 38.23395  ? 588 GLN A C   588 GLN A C   1 
ATOM 4615  O O   . GLN A 1 588 ? 252.445 -30.801 255.591 1.0 38.23395  ? 588 GLN A O   588 GLN A O   1 
ATOM 4616  C CB  . GLN A 1 588 ? 251.642 -33.765 255.357 1.0 38.23395  ? 588 GLN A CB  588 GLN A CB  1 
ATOM 4617  C CG  . GLN A 1 588 ? 250.914 -34.934 254.750 1.0 38.23395  ? 588 GLN A CG  588 GLN A CG  1 
ATOM 4618  C CD  . GLN A 1 588 ? 251.753 -36.178 254.669 1.0 38.23395  ? 588 GLN A CD  588 GLN A CD  1 
ATOM 4619  O OE1 . GLN A 1 588 ? 252.922 -36.177 255.032 1.0 38.23395  ? 588 GLN A OE1 588 GLN A OE1 1 
ATOM 4620  N NE2 . GLN A 1 588 ? 251.159 -37.253 254.182 1.0 38.23395  ? 588 GLN A NE2 588 GLN A NE2 1 
ATOM 4621  N N   . ASN A 1 589 ? 251.023 -31.062 257.303 1.0 39.4209   ? 589 ASN A N   589 ASN A N   1 
ATOM 4622  C CA  . ASN A 1 589 ? 251.615 -30.015 258.113 1.0 39.4209   ? 589 ASN A CA  589 ASN A CA  1 
ATOM 4623  C C   . ASN A 1 589 ? 252.433 -30.650 259.223 1.0 39.4209   ? 589 ASN A C   589 ASN A C   1 
ATOM 4624  O O   . ASN A 1 589 ? 252.020 -31.652 259.810 1.0 39.4209   ? 589 ASN A O   589 ASN A O   1 
ATOM 4625  C CB  . ASN A 1 589 ? 250.529 -29.132 258.711 1.0 39.4209   ? 589 ASN A CB  589 ASN A CB  1 
ATOM 4626  C CG  . ASN A 1 589 ? 249.732 -28.412 257.666 1.0 39.4209   ? 589 ASN A CG  589 ASN A CG  1 
ATOM 4627  O OD1 . ASN A 1 589 ? 250.286 -27.884 256.713 1.0 39.4209   ? 589 ASN A OD1 589 ASN A OD1 1 
ATOM 4628  N ND2 . ASN A 1 589 ? 248.420 -28.404 257.824 1.0 39.4209   ? 589 ASN A ND2 589 ASN A ND2 1 
ATOM 4629  N N   . PHE A 1 590 ? 253.599 -30.080 259.502 1.0 39.91527  ? 590 PHE A N   590 PHE A N   1 
ATOM 4630  C CA  . PHE A 1 590 ? 254.402 -30.525 260.627 1.0 39.91527  ? 590 PHE A CA  590 PHE A CA  1 
ATOM 4631  C C   . PHE A 1 590 ? 254.967 -29.304 261.327 1.0 39.91527  ? 590 PHE A C   590 PHE A C   1 
ATOM 4632  O O   . PHE A 1 590 ? 255.124 -28.239 260.730 1.0 39.91527  ? 590 PHE A O   590 PHE A O   1 
ATOM 4633  C CB  . PHE A 1 590 ? 255.539 -31.460 260.204 1.0 39.91527  ? 590 PHE A CB  590 PHE A CB  1 
ATOM 4634  C CG  . PHE A 1 590 ? 255.071 -32.740 259.597 1.0 39.91527  ? 590 PHE A CG  590 PHE A CG  1 
ATOM 4635  C CD1 . PHE A 1 590 ? 254.573 -33.748 260.390 1.0 39.91527  ? 590 PHE A CD1 590 PHE A CD1 1 
ATOM 4636  C CD2 . PHE A 1 590 ? 255.141 -32.935 258.233 1.0 39.91527  ? 590 PHE A CD2 590 PHE A CD2 1 
ATOM 4637  C CE1 . PHE A 1 590 ? 254.128 -34.928 259.838 1.0 39.91527  ? 590 PHE A CE1 590 PHE A CE1 1 
ATOM 4638  C CE2 . PHE A 1 590 ? 254.713 -34.118 257.670 1.0 39.91527  ? 590 PHE A CE2 590 PHE A CE2 1 
ATOM 4639  C CZ  . PHE A 1 590 ? 254.213 -35.115 258.478 1.0 39.91527  ? 590 PHE A CZ  590 PHE A CZ  1 
ATOM 4640  N N   . SER A 1 591 ? 255.272 -29.470 262.606 1.0 43.31619  ? 591 SER A N   591 SER A N   1 
ATOM 4641  C CA  . SER A 1 591 ? 255.783 -28.383 263.417 1.0 43.31619  ? 591 SER A CA  591 SER A CA  1 
ATOM 4642  C C   . SER A 1 591 ? 256.864 -28.913 264.339 1.0 43.31619  ? 591 SER A C   591 SER A C   1 
ATOM 4643  O O   . SER A 1 591 ? 256.792 -30.049 264.811 1.0 43.31619  ? 591 SER A O   591 SER A O   1 
ATOM 4644  C CB  . SER A 1 591 ? 254.677 -27.734 264.247 1.0 43.31619  ? 591 SER A CB  591 SER A CB  1 
ATOM 4645  O OG  . SER A 1 591 ? 255.199 -26.687 265.044 1.0 43.31619  ? 591 SER A OG  591 SER A OG  1 
ATOM 4646  N N   . ASP A 1 592 ? 257.873 -28.084 264.582 1.0 46.16328  ? 592 ASP A N   592 ASP A N   1 
ATOM 4647  C CA  . ASP A 1 592 ? 258.872 -28.414 265.582 1.0 46.16328  ? 592 ASP A CA  592 ASP A CA  1 
ATOM 4648  C C   . ASP A 1 592 ? 258.238 -28.341 266.962 1.0 46.16328  ? 592 ASP A C   592 ASP A C   1 
ATOM 4649  O O   . ASP A 1 592 ? 257.437 -27.446 267.240 1.0 46.16328  ? 592 ASP A O   592 ASP A O   1 
ATOM 4650  C CB  . ASP A 1 592 ? 260.057 -27.460 265.486 1.0 46.16328  ? 592 ASP A CB  592 ASP A CB  1 
ATOM 4651  C CG  . ASP A 1 592 ? 261.207 -27.868 266.377 1.0 46.16328  ? 592 ASP A CG  592 ASP A CG  1 
ATOM 4652  O OD1 . ASP A 1 592 ? 261.900 -28.849 266.037 1.0 46.16328  ? 592 ASP A OD1 592 ASP A OD1 1 
ATOM 4653  O OD2 . ASP A 1 592 ? 261.424 -27.208 267.413 1.0 46.16328  ? 592 ASP A OD2 592 ASP A OD2 1 
ATOM 4654  N N   . TYR A 1 593 ? 258.571 -29.307 267.819 1.0 42.77267  ? 593 TYR A N   593 TYR A N   1 
ATOM 4655  C CA  . TYR A 1 593 ? 257.932 -29.358 269.128 1.0 42.77267  ? 593 TYR A CA  593 TYR A CA  1 
ATOM 4656  C C   . TYR A 1 593 ? 258.441 -28.250 270.035 1.0 42.77267  ? 593 TYR A C   593 TYR A C   1 
ATOM 4657  O O   . TYR A 1 593 ? 257.679 -27.702 270.838 1.0 42.77267  ? 593 TYR A O   593 TYR A O   1 
ATOM 4658  C CB  . TYR A 1 593 ? 258.150 -30.717 269.786 1.0 42.77267  ? 593 TYR A CB  593 TYR A CB  1 
ATOM 4659  C CG  . TYR A 1 593 ? 257.488 -30.808 271.137 1.0 42.77267  ? 593 TYR A CG  593 TYR A CG  1 
ATOM 4660  C CD1 . TYR A 1 593 ? 256.113 -30.939 271.243 1.0 42.77267  ? 593 TYR A CD1 593 TYR A CD1 1 
ATOM 4661  C CD2 . TYR A 1 593 ? 258.233 -30.743 272.305 1.0 42.77267  ? 593 TYR A CD2 593 TYR A CD2 1 
ATOM 4662  C CE1 . TYR A 1 593 ? 255.498 -31.010 272.473 1.0 42.77267  ? 593 TYR A CE1 593 TYR A CE1 1 
ATOM 4663  C CE2 . TYR A 1 593 ? 257.627 -30.809 273.538 1.0 42.77267  ? 593 TYR A CE2 593 TYR A CE2 1 
ATOM 4664  C CZ  . TYR A 1 593 ? 256.261 -30.944 273.616 1.0 42.77267  ? 593 TYR A CZ  593 TYR A CZ  1 
ATOM 4665  O OH  . TYR A 1 593 ? 255.654 -31.017 274.845 1.0 42.77267  ? 593 TYR A OH  593 TYR A OH  1 
ATOM 4666  N N   . LEU A 1 594 ? 259.725 -27.917 269.930 1.0 42.58692  ? 594 LEU A N   594 LEU A N   1 
ATOM 4667  C CA  . LEU A 1 594 ? 260.277 -26.855 270.760 1.0 42.58692  ? 594 LEU A CA  594 LEU A CA  1 
ATOM 4668  C C   . LEU A 1 594 ? 259.760 -25.496 270.314 1.0 42.58692  ? 594 LEU A C   594 LEU A C   1 
ATOM 4669  O O   . LEU A 1 594 ? 259.182 -24.750 271.112 1.0 42.58692  ? 594 LEU A O   594 LEU A O   1 
ATOM 4670  C CB  . LEU A 1 594 ? 261.800 -26.903 270.714 1.0 42.58692  ? 594 LEU A CB  594 LEU A CB  1 
ATOM 4671  C CG  . LEU A 1 594 ? 262.535 -25.896 271.586 1.0 42.58692  ? 594 LEU A CG  594 LEU A CG  1 
ATOM 4672  C CD1 . LEU A 1 594 ? 262.193 -26.117 273.036 1.0 42.58692  ? 594 LEU A CD1 594 LEU A CD1 1 
ATOM 4673  C CD2 . LEU A 1 594 ? 264.027 -26.001 271.361 1.0 42.58692  ? 594 LEU A CD2 594 LEU A CD2 1 
ATOM 4674  N N   . GLY A 1 595 ? 259.931 -25.174 269.035 1.0 43.0962   ? 595 GLY A N   595 GLY A N   1 
ATOM 4675  C CA  . GLY A 1 595 ? 259.480 -23.910 268.489 1.0 43.0962   ? 595 GLY A CA  595 GLY A CA  1 
ATOM 4676  C C   . GLY A 1 595 ? 260.228 -22.736 269.077 1.0 43.0962   ? 595 GLY A C   595 GLY A C   1 
ATOM 4677  O O   . GLY A 1 595 ? 259.617 -21.809 269.614 1.0 43.0962   ? 595 GLY A O   595 GLY A O   1 
ATOM 4678  N N   . ALA A 1 596 ? 261.552 -22.770 269.001 1.0 44.47301  ? 596 ALA A N   596 ALA A N   1 
ATOM 4679  C CA  . ALA A 1 596 ? 262.360 -21.758 269.652 1.0 44.47301  ? 596 ALA A CA  596 ALA A CA  1 
ATOM 4680  C C   . ALA A 1 596 ? 263.447 -21.279 268.709 1.0 44.47301  ? 596 ALA A C   596 ALA A C   1 
ATOM 4681  O O   . ALA A 1 596 ? 263.735 -21.895 267.682 1.0 44.47301  ? 596 ALA A O   596 ALA A O   1 
ATOM 4682  C CB  . ALA A 1 596 ? 262.979 -22.275 270.951 1.0 44.47301  ? 596 ALA A CB  596 ALA A CB  1 
ATOM 4683  N N   . VAL A 1 597 ? 264.044 -20.154 269.078 1.0 48.20414  ? 597 VAL A N   597 VAL A N   1 
ATOM 4684  C CA  . VAL A 1 597 ? 265.156 -19.560 268.358 1.0 48.20414  ? 597 VAL A CA  597 VAL A CA  1 
ATOM 4685  C C   . VAL A 1 597 ? 266.330 -19.524 269.323 1.0 48.20414  ? 597 VAL A C   597 VAL A C   1 
ATOM 4686  O O   . VAL A 1 597 ? 266.300 -18.793 270.321 1.0 48.20414  ? 597 VAL A O   597 VAL A O   1 
ATOM 4687  C CB  . VAL A 1 597 ? 264.815 -18.161 267.833 1.0 48.20414  ? 597 VAL A CB  597 VAL A CB  1 
ATOM 4688  C CG1 . VAL A 1 597 ? 266.041 -17.492 267.266 1.0 48.20414  ? 597 VAL A CG1 597 VAL A CG1 1 
ATOM 4689  C CG2 . VAL A 1 597 ? 263.746 -18.259 266.771 1.0 48.20414  ? 597 VAL A CG2 597 VAL A CG2 1 
ATOM 4690  N N   . ASN A 1 598 ? 267.347 -20.330 269.045 1.0 52.54028  ? 598 ASN A N   598 ASN A N   1 
ATOM 4691  C CA  . ASN A 1 598 ? 268.518 -20.391 269.906 1.0 52.54028  ? 598 ASN A CA  598 ASN A CA  1 
ATOM 4692  C C   . ASN A 1 598 ? 269.361 -19.137 269.748 1.0 52.54028  ? 598 ASN A C   598 ASN A C   1 
ATOM 4693  O O   . ASN A 1 598 ? 269.679 -18.724 268.630 1.0 52.54028  ? 598 ASN A O   598 ASN A O   1 
ATOM 4694  C CB  . ASN A 1 598 ? 269.351 -21.616 269.563 1.0 52.54028  ? 598 ASN A CB  598 ASN A CB  1 
ATOM 4695  C CG  . ASN A 1 598 ? 268.604 -22.897 269.788 1.0 52.54028  ? 598 ASN A CG  598 ASN A CG  1 
ATOM 4696  O OD1 . ASN A 1 598 ? 268.157 -23.526 268.838 1.0 52.54028  ? 598 ASN A OD1 598 ASN A OD1 1 
ATOM 4697  N ND2 . ASN A 1 598 ? 268.506 -23.321 271.036 1.0 52.54028  ? 598 ASN A ND2 598 ASN A ND2 1 
ATOM 4698  N N   . ASN A 1 599 ? 269.719 -18.528 270.870 1.0 53.24972  ? 599 ASN A N   599 ASN A N   1 
ATOM 4699  C CA  . ASN A 1 599 ? 270.633 -17.400 270.877 1.0 53.24972  ? 599 ASN A CA  599 ASN A CA  1 
ATOM 4700  C C   . ASN A 1 599 ? 271.549 -17.547 272.076 1.0 53.24972  ? 599 ASN A C   599 ASN A C   1 
ATOM 4701  O O   . ASN A 1 599 ? 271.076 -17.661 273.209 1.0 53.24972  ? 599 ASN A O   599 ASN A O   1 
ATOM 4702  C CB  . ASN A 1 599 ? 269.882 -16.068 270.936 1.0 53.24972  ? 599 ASN A CB  599 ASN A CB  1 
ATOM 4703  C CG  . ASN A 1 599 ? 269.058 -15.810 269.698 1.0 53.24972  ? 599 ASN A CG  599 ASN A CG  1 
ATOM 4704  O OD1 . ASN A 1 599 ? 267.832 -15.739 269.758 1.0 53.24972  ? 599 ASN A OD1 599 ASN A OD1 1 
ATOM 4705  N ND2 . ASN A 1 599 ? 269.727 -15.677 268.561 1.0 53.24972  ? 599 ASN A ND2 599 ASN A ND2 1 
ATOM 4706  N N   . LEU A 1 600 ? 272.849 -17.551 271.828 1.0 54.42589  ? 600 LEU A N   600 LEU A N   1 
ATOM 4707  C CA  . LEU A 1 600 ? 273.845 -17.777 272.867 1.0 54.42589  ? 600 LEU A CA  600 LEU A CA  1 
ATOM 4708  C C   . LEU A 1 600 ? 274.585 -16.466 273.105 1.0 54.42589  ? 600 LEU A C   600 LEU A C   1 
ATOM 4709  O O   . LEU A 1 600 ? 275.623 -16.202 272.497 1.0 54.42589  ? 600 LEU A O   600 LEU A O   1 
ATOM 4710  C CB  . LEU A 1 600 ? 274.797 -18.891 272.464 1.0 54.42589  ? 600 LEU A CB  600 LEU A CB  1 
ATOM 4711  C CG  . LEU A 1 600 ? 274.172 -20.275 272.318 1.0 54.42589  ? 600 LEU A CG  600 LEU A CG  1 
ATOM 4712  C CD1 . LEU A 1 600 ? 275.188 -21.259 271.773 1.0 54.42589  ? 600 LEU A CD1 600 LEU A CD1 1 
ATOM 4713  C CD2 . LEU A 1 600 ? 273.630 -20.745 273.650 1.0 54.42589  ? 600 LEU A CD2 600 LEU A CD2 1 
ATOM 4714  N N   . TYR A 1 601 ? 274.043 -15.641 273.992 1.0 54.35137  ? 601 TYR A N   601 TYR A N   1 
ATOM 4715  C CA  . TYR A 1 601 ? 274.727 -14.427 274.400 1.0 54.35137  ? 601 TYR A CA  601 TYR A CA  1 
ATOM 4716  C C   . TYR A 1 601 ? 275.740 -14.755 275.483 1.0 54.35137  ? 601 TYR A C   601 TYR A C   1 
ATOM 4717  O O   . TYR A 1 601 ? 275.485 -15.585 276.358 1.0 54.35137  ? 601 TYR A O   601 TYR A O   1 
ATOM 4718  C CB  . TYR A 1 601 ? 273.723 -13.395 274.897 1.0 54.35137  ? 601 TYR A CB  601 TYR A CB  1 
ATOM 4719  C CG  . TYR A 1 601 ? 272.799 -12.927 273.808 1.0 54.35137  ? 601 TYR A CG  601 TYR A CG  1 
ATOM 4720  C CD1 . TYR A 1 601 ? 273.212 -11.972 272.891 1.0 54.35137  ? 601 TYR A CD1 601 TYR A CD1 1 
ATOM 4721  C CD2 . TYR A 1 601 ? 271.524 -13.457 273.678 1.0 54.35137  ? 601 TYR A CD2 601 TYR A CD2 1 
ATOM 4722  C CE1 . TYR A 1 601 ? 272.374 -11.545 271.885 1.0 54.35137  ? 601 TYR A CE1 601 TYR A CE1 1 
ATOM 4723  C CE2 . TYR A 1 601 ? 270.675 -13.030 272.681 1.0 54.35137  ? 601 TYR A CE2 601 TYR A CE2 1 
ATOM 4724  C CZ  . TYR A 1 601 ? 271.108 -12.079 271.786 1.0 54.35137  ? 601 TYR A CZ  601 TYR A CZ  1 
ATOM 4725  O OH  . TYR A 1 601 ? 270.269 -11.656 270.784 1.0 54.35137  ? 601 TYR A OH  601 TYR A OH  1 
ATOM 4726  N N   . GLN A 1 602 ? 276.893 -14.105 275.421 1.0 59.12387  ? 602 GLN A N   602 GLN A N   1 
ATOM 4727  C CA  . GLN A 1 602 ? 278.037 -14.482 276.236 1.0 59.12387  ? 602 GLN A CA  602 GLN A CA  1 
ATOM 4728  C C   . GLN A 1 602 ? 278.134 -13.598 277.470 1.0 59.12387  ? 602 GLN A C   602 GLN A C   1 
ATOM 4729  O O   . GLN A 1 602 ? 278.060 -12.370 277.368 1.0 59.12387  ? 602 GLN A O   602 GLN A O   1 
ATOM 4730  C CB  . GLN A 1 602 ? 279.329 -14.390 275.428 1.0 59.12387  ? 602 GLN A CB  602 GLN A CB  1 
ATOM 4731  C CG  . GLN A 1 602 ? 280.547 -14.880 276.179 1.0 59.12387  ? 602 GLN A CG  602 GLN A CG  1 
ATOM 4732  C CD  . GLN A 1 602 ? 281.802 -14.826 275.347 1.0 59.12387  ? 602 GLN A CD  602 GLN A CD  1 
ATOM 4733  O OE1 . GLN A 1 602 ? 281.783 -14.368 274.205 1.0 59.12387  ? 602 GLN A OE1 602 GLN A OE1 1 
ATOM 4734  N NE2 . GLN A 1 602 ? 282.907 -15.297 275.912 1.0 59.12387  ? 602 GLN A NE2 602 GLN A NE2 1 
ATOM 4735  N N   . ILE A 1 603 ? 278.299 -14.225 278.624 1.0 60.30988  ? 603 ILE A N   603 ILE A N   1 
ATOM 4736  C CA  . ILE A 1 603 ? 278.638 -13.536 279.865 1.0 60.30988  ? 603 ILE A CA  603 ILE A CA  1 
ATOM 4737  C C   . ILE A 1 603 ? 280.148 -13.627 280.032 1.0 60.30988  ? 603 ILE A C   603 ILE A C   1 
ATOM 4738  O O   . ILE A 1 603 ? 280.698 -14.733 279.946 1.0 60.30988  ? 603 ILE A O   603 ILE A O   1 
ATOM 4739  C CB  . ILE A 1 603 ? 277.934 -14.167 281.078 1.0 60.30988  ? 603 ILE A CB  603 ILE A CB  1 
ATOM 4740  C CG1 . ILE A 1 603 ? 276.433 -14.274 280.840 1.0 60.30988  ? 603 ILE A CG1 603 ILE A CG1 1 
ATOM 4741  C CG2 . ILE A 1 603 ? 278.213 -13.356 282.326 1.0 60.30988  ? 603 ILE A CG2 603 ILE A CG2 1 
ATOM 4742  C CD1 . ILE A 1 603 ? 275.726 -15.119 281.850 1.0 60.30988  ? 603 ILE A CD1 603 ILE A CD1 1 
ATOM 4743  N N   . PRO A 1 604 ? 280.846 -12.521 280.253 1.0 63.74633  ? 604 PRO A N   604 PRO A N   1 
ATOM 4744  C CA  . PRO A 1 604 ? 282.281 -12.603 280.532 1.0 63.74633  ? 604 PRO A CA  604 PRO A CA  1 
ATOM 4745  C C   . PRO A 1 604 ? 282.540 -13.206 281.903 1.0 63.74633  ? 604 PRO A C   604 PRO A C   1 
ATOM 4746  O O   . PRO A 1 604 ? 281.654 -13.292 282.755 1.0 63.74633  ? 604 PRO A O   604 PRO A O   1 
ATOM 4747  C CB  . PRO A 1 604 ? 282.740 -11.143 280.471 1.0 63.74633  ? 604 PRO A CB  604 PRO A CB  1 
ATOM 4748  C CG  . PRO A 1 604 ? 281.697 -10.454 279.658 1.0 63.74633  ? 604 PRO A CG  604 PRO A CG  1 
ATOM 4749  C CD  . PRO A 1 604 ? 280.414 -11.137 280.011 1.0 63.74633  ? 604 PRO A CD  604 PRO A CD  1 
ATOM 4750  N N   . ALA A 1 605 ? 283.783 -13.634 282.105 1.0 66.3427   ? 605 ALA A N   605 ALA A N   1 
ATOM 4751  C CA  . ALA A 1 605 ? 284.160 -14.295 283.348 1.0 66.3427   ? 605 ALA A CA  605 ALA A CA  1 
ATOM 4752  C C   . ALA A 1 605 ? 284.226 -13.283 284.483 1.0 66.3427   ? 605 ALA A C   605 ALA A C   1 
ATOM 4753  O O   . ALA A 1 605 ? 285.027 -12.345 284.444 1.0 66.3427   ? 605 ALA A O   605 ALA A O   1 
ATOM 4754  C CB  . ALA A 1 605 ? 285.500 -15.004 283.184 1.0 66.3427   ? 605 ALA A CB  605 ALA A CB  1 
ATOM 4755  N N   . GLY A 1 606 ? 283.385 -13.475 285.494 1.0 66.41127  ? 606 GLY A N   606 GLY A N   1 
ATOM 4756  C CA  . GLY A 1 606 ? 283.335 -12.583 286.631 1.0 66.41127  ? 606 GLY A CA  606 GLY A CA  1 
ATOM 4757  C C   . GLY A 1 606 ? 282.386 -11.417 286.496 1.0 66.41127  ? 606 GLY A C   606 GLY A C   1 
ATOM 4758  O O   . GLY A 1 606 ? 282.403 -10.527 287.354 1.0 66.41127  ? 606 GLY A O   606 GLY A O   1 
ATOM 4759  N N   . SER A 1 607 ? 281.563 -11.389 285.455 1.0 65.50013  ? 607 SER A N   607 SER A N   1 
ATOM 4760  C CA  . SER A 1 607 ? 280.607 -10.316 285.236 1.0 65.50013  ? 607 SER A CA  607 SER A CA  1 
ATOM 4761  C C   . SER A 1 607 ? 279.219 -10.752 285.688 1.0 65.50013  ? 607 SER A C   607 SER A C   1 
ATOM 4762  O O   . SER A 1 607 ? 278.972 -11.923 285.979 1.0 65.50013  ? 607 SER A O   607 SER A O   1 
ATOM 4763  C CB  . SER A 1 607 ? 280.590 -9.906  283.762 1.0 65.50013  ? 607 SER A CB  607 SER A CB  1 
ATOM 4764  O OG  . SER A 1 607 ? 279.657 -8.867  283.536 1.0 65.50013  ? 607 SER A OG  607 SER A OG  1 
ATOM 4765  N N   . SER A 1 608 ? 278.304 -9.787  285.751 1.0 63.42487  ? 608 SER A N   608 SER A N   1 
ATOM 4766  C CA  . SER A 1 608 ? 276.961 -10.051 286.247 1.0 63.42487  ? 608 SER A CA  608 SER A CA  1 
ATOM 4767  C C   . SER A 1 608 ? 275.839 -9.536  285.362 1.0 63.42487  ? 608 SER A C   608 SER A C   1 
ATOM 4768  O O   . SER A 1 608 ? 274.758 -10.133 285.377 1.0 63.42487  ? 608 SER A O   608 SER A O   1 
ATOM 4769  C CB  . SER A 1 608 ? 276.781 -9.448  287.647 1.0 63.42487  ? 608 SER A CB  608 SER A CB  1 
ATOM 4770  O OG  . SER A 1 608 ? 276.825 -8.034  287.597 1.0 63.42487  ? 608 SER A OG  608 SER A OG  1 
ATOM 4771  N N   . THR A 1 609 ? 276.044 -8.470  284.596 1.0 63.95773  ? 609 THR A N   609 THR A N   1 
ATOM 4772  C CA  . THR A 1 609 ? 274.976 -7.837  283.834 1.0 63.95773  ? 609 THR A CA  609 THR A CA  1 
ATOM 4773  C C   . THR A 1 609 ? 275.223 -8.036  282.348 1.0 63.95773  ? 609 THR A C   609 THR A C   1 
ATOM 4774  O O   . THR A 1 609 ? 276.305 -7.715  281.846 1.0 63.95773  ? 609 THR A O   609 THR A O   1 
ATOM 4775  C CB  . THR A 1 609 ? 274.882 -6.344  284.157 1.0 63.95773  ? 609 THR A CB  609 THR A CB  1 
ATOM 4776  O OG1 . THR A 1 609 ? 274.655 -6.173  285.560 1.0 63.95773  ? 609 THR A OG1 609 THR A OG1 1 
ATOM 4777  C CG2 . THR A 1 609 ? 273.733 -5.698  283.393 1.0 63.95773  ? 609 THR A CG2 609 THR A CG2 1 
ATOM 4778  N N   . VAL A 1 610 ? 274.224 -8.570  281.650 1.0 60.79034  ? 610 VAL A N   610 VAL A N   1 
ATOM 4779  C CA  . VAL A 1 610 ? 274.290 -8.789  280.210 1.0 60.79034  ? 610 VAL A CA  610 VAL A CA  1 
ATOM 4780  C C   . VAL A 1 610 ? 273.046 -8.195  279.573 1.0 60.79034  ? 610 VAL A C   610 VAL A C   1 
ATOM 4781  O O   . VAL A 1 610 ? 271.923 -8.573  279.926 1.0 60.79034  ? 610 VAL A O   610 VAL A O   1 
ATOM 4782  C CB  . VAL A 1 610 ? 274.422 -10.277 279.860 1.0 60.79034  ? 610 VAL A CB  610 VAL A CB  1 
ATOM 4783  C CG1 . VAL A 1 610 ? 274.176 -10.501 278.382 1.0 60.79034  ? 610 VAL A CG1 610 VAL A CG1 1 
ATOM 4784  C CG2 . VAL A 1 610 ? 275.807 -10.740 280.209 1.0 60.79034  ? 610 VAL A CG2 610 VAL A CG2 1 
ATOM 4785  N N   . VAL A 1 611 ? 273.247 -7.272  278.640 1.0 58.31554  ? 611 VAL A N   611 VAL A N   1 
ATOM 4786  C CA  . VAL A 1 611 ? 272.167 -6.623  277.912 1.0 58.31554  ? 611 VAL A CA  611 VAL A CA  1 
ATOM 4787  C C   . VAL A 1 611 ? 272.055 -7.278  276.546 1.0 58.31554  ? 611 VAL A C   611 VAL A C   1 
ATOM 4788  O O   . VAL A 1 611 ? 273.059 -7.419  275.838 1.0 58.31554  ? 611 VAL A O   611 VAL A O   1 
ATOM 4789  C CB  . VAL A 1 611 ? 272.428 -5.114  277.773 1.0 58.31554  ? 611 VAL A CB  611 VAL A CB  1 
ATOM 4790  C CG1 . VAL A 1 611 ? 271.322 -4.442  276.977 1.0 58.31554  ? 611 VAL A CG1 611 VAL A CG1 1 
ATOM 4791  C CG2 . VAL A 1 611 ? 272.589 -4.476  279.140 1.0 58.31554  ? 611 VAL A CG2 611 VAL A CG2 1 
ATOM 4792  N N   . VAL A 1 612 ? 270.848 -7.685  276.172 1.0 55.72533  ? 612 VAL A N   612 VAL A N   1 
ATOM 4793  C CA  . VAL A 1 612 ? 270.593 -8.133  274.811 1.0 55.72533  ? 612 VAL A CA  612 VAL A CA  1 
ATOM 4794  C C   . VAL A 1 612 ? 269.710 -7.090  274.141 1.0 55.72533  ? 612 VAL A C   612 VAL A C   1 
ATOM 4795  O O   . VAL A 1 612 ? 268.950 -6.371  274.799 1.0 55.72533  ? 612 VAL A O   612 VAL A O   1 
ATOM 4796  C CB  . VAL A 1 612 ? 269.965 -9.543  274.749 1.0 55.72533  ? 612 VAL A CB  612 VAL A CB  1 
ATOM 4797  C CG1 . VAL A 1 612 ? 270.777 -10.509 275.585 1.0 55.72533  ? 612 VAL A CG1 612 VAL A CG1 1 
ATOM 4798  C CG2 . VAL A 1 612 ? 268.505 -9.554  275.152 1.0 55.72533  ? 612 VAL A CG2 612 VAL A CG2 1 
ATOM 4799  N N   . ASN A 1 613 ? 269.852 -6.971  272.826 1.0 53.99924  ? 613 ASN A N   613 ASN A N   1 
ATOM 4800  C CA  . ASN A 1 613 ? 269.175 -5.920  272.073 1.0 53.99924  ? 613 ASN A CA  613 ASN A CA  1 
ATOM 4801  C C   . ASN A 1 613 ? 268.669 -6.511  270.768 1.0 53.99924  ? 613 ASN A C   613 ASN A C   1 
ATOM 4802  O O   . ASN A 1 613 ? 269.458 -7.019  269.967 1.0 53.99924  ? 613 ASN A O   613 ASN A O   1 
ATOM 4803  C CB  . ASN A 1 613 ? 270.108 -4.743  271.803 1.0 53.99924  ? 613 ASN A CB  613 ASN A CB  1 
ATOM 4804  C CG  . ASN A 1 613 ? 270.437 -3.966  273.052 1.0 53.99924  ? 613 ASN A CG  613 ASN A CG  1 
ATOM 4805  O OD1 . ASN A 1 613 ? 269.570 -3.703  273.880 1.0 53.99924  ? 613 ASN A OD1 613 ASN A OD1 1 
ATOM 4806  N ND2 . ASN A 1 613 ? 271.700 -3.590  273.196 1.0 53.99924  ? 613 ASN A ND2 613 ASN A ND2 1 
ATOM 4807  N N   . ILE A 1 614 ? 267.363 -6.446  270.561 1.0 50.53913  ? 614 ILE A N   614 ILE A N   1 
ATOM 4808  C CA  . ILE A 1 614 ? 266.723 -6.880  269.326 1.0 50.53913  ? 614 ILE A CA  614 ILE A CA  1 
ATOM 4809  C C   . ILE A 1 614 ? 266.182 -5.636  268.631 1.0 50.53913  ? 614 ILE A C   614 ILE A C   1 
ATOM 4810  O O   . ILE A 1 614 ? 265.413 -4.885  269.243 1.0 50.53913  ? 614 ILE A O   614 ILE A O   1 
ATOM 4811  C CB  . ILE A 1 614 ? 265.597 -7.888  269.594 1.0 50.53913  ? 614 ILE A CB  614 ILE A CB  1 
ATOM 4812  C CG1 . ILE A 1 614 ? 266.125 -9.082  270.385 1.0 50.53913  ? 614 ILE A CG1 614 ILE A CG1 1 
ATOM 4813  C CG2 . ILE A 1 614 ? 264.987 -8.353  268.293 1.0 50.53913  ? 614 ILE A CG2 614 ILE A CG2 1 
ATOM 4814  C CD1 . ILE A 1 614 ? 267.200 -9.851  269.675 1.0 50.53913  ? 614 ILE A CD1 614 ILE A CD1 1 
ATOM 4815  N N   . PRO A 1 615 ? 266.558 -5.367  267.384 1.0 50.79561  ? 615 PRO A N   615 PRO A N   1 
ATOM 4816  C CA  . PRO A 1 615 ? 265.933 -4.268  266.640 1.0 50.79561  ? 615 PRO A CA  615 PRO A CA  1 
ATOM 4817  C C   . PRO A 1 615 ? 264.486 -4.597  266.305 1.0 50.79561  ? 615 PRO A C   615 PRO A C   1 
ATOM 4818  O O   . PRO A 1 615 ? 264.033 -5.732  266.455 1.0 50.79561  ? 615 PRO A O   615 PRO A O   1 
ATOM 4819  C CB  . PRO A 1 615 ? 266.794 -4.160  265.384 1.0 50.79561  ? 615 PRO A CB  615 PRO A CB  1 
ATOM 4820  C CG  . PRO A 1 615 ? 267.364 -5.516  265.215 1.0 50.79561  ? 615 PRO A CG  615 PRO A CG  1 
ATOM 4821  C CD  . PRO A 1 615 ? 267.593 -6.048  266.592 1.0 50.79561  ? 615 PRO A CD  615 PRO A CD  1 
ATOM 4822  N N   . ASP A 1 616 ? 263.761 -3.579  265.836 1.0 51.01936  ? 616 ASP A N   616 ASP A N   1 
ATOM 4823  C CA  . ASP A 1 616 ? 262.304 -3.660  265.775 1.0 51.01936  ? 616 ASP A CA  616 ASP A CA  1 
ATOM 4824  C C   . ASP A 1 616 ? 261.817 -4.662  264.733 1.0 51.01936  ? 616 ASP A C   616 ASP A C   1 
ATOM 4825  O O   . ASP A 1 616 ? 262.206 -4.614  263.565 1.0 51.01936  ? 616 ASP A O   616 ASP A O   1 
ATOM 4826  C CB  . ASP A 1 616 ? 261.698 -2.278  265.528 1.0 51.01936  ? 616 ASP A CB  616 ASP A CB  1 
ATOM 4827  C CG  . ASP A 1 616 ? 262.341 -1.549  264.374 1.0 51.01936  ? 616 ASP A CG  616 ASP A CG  1 
ATOM 4828  O OD1 . ASP A 1 616 ? 263.391 -2.005  263.888 1.0 51.01936  ? 616 ASP A OD1 616 ASP A OD1 1 
ATOM 4829  O OD2 . ASP A 1 616 ? 261.783 -0.524  263.936 1.0 51.01936  ? 616 ASP A OD2 616 ASP A OD2 1 
ATOM 4830  N N   . ARG A 1 617 ? 260.975 -5.591  265.182 1.0 48.40895  ? 617 ARG A N   617 ARG A N   1 
ATOM 4831  C CA  . ARG A 1 617 ? 260.493 -6.686  264.352 1.0 48.40895  ? 617 ARG A CA  617 ARG A CA  1 
ATOM 4832  C C   . ARG A 1 617 ? 258.976 -6.749  264.365 1.0 48.40895  ? 617 ARG A C   617 ARG A C   1 
ATOM 4833  O O   . ARG A 1 617 ? 258.313 -5.808  264.803 1.0 48.40895  ? 617 ARG A O   617 ARG A O   1 
ATOM 4834  C CB  . ARG A 1 617 ? 261.054 -8.021  264.827 1.0 48.40895  ? 617 ARG A CB  617 ARG A CB  1 
ATOM 4835  C CG  . ARG A 1 617 ? 262.547 -8.111  264.743 1.0 48.40895  ? 617 ARG A CG  617 ARG A CG  1 
ATOM 4836  C CD  . ARG A 1 617 ? 263.003 -9.479  265.123 1.0 48.40895  ? 617 ARG A CD  617 ARG A CD  1 
ATOM 4837  N NE  . ARG A 1 617 ? 262.497 -10.440 264.159 1.0 48.40895  ? 617 ARG A NE  617 ARG A NE  1 
ATOM 4838  C CZ  . ARG A 1 617 ? 263.116 -10.750 263.029 1.0 48.40895  ? 617 ARG A CZ  617 ARG A CZ  1 
ATOM 4839  N NH1 . ARG A 1 617 ? 264.268 -10.178 262.717 1.0 48.40895  ? 617 ARG A NH1 617 ARG A NH1 1 
ATOM 4840  N NH2 . ARG A 1 617 ? 262.582 -11.636 262.206 1.0 48.40895  ? 617 ARG A NH2 617 ARG A NH2 1 
ATOM 4841  N N   . SER A 1 618 ? 258.421 -7.855  263.873 1.0 47.56486  ? 618 SER A N   618 SER A N   1 
ATOM 4842  C CA  . SER A 1 618 ? 256.974 -8.014  263.816 1.0 47.56486  ? 618 SER A CA  618 SER A CA  1 
ATOM 4843  C C   . SER A 1 618 ? 256.379 -8.237  265.196 1.0 47.56486  ? 618 SER A C   618 SER A C   1 
ATOM 4844  O O   . SER A 1 618 ? 255.440 -7.540  265.585 1.0 47.56486  ? 618 SER A O   618 SER A O   1 
ATOM 4845  C CB  . SER A 1 618 ? 256.609 -9.184  262.907 1.0 47.56486  ? 618 SER A CB  618 SER A CB  1 
ATOM 4846  O OG  . SER A 1 618 ? 255.208 -9.357  262.847 1.0 47.56486  ? 618 SER A OG  618 SER A OG  1 
ATOM 4847  N N   . TRP A 1 619 ? 256.898 -9.233  265.923 1.0 45.97094  ? 619 TRP A N   619 TRP A N   1 
ATOM 4848  C CA  . TRP A 1 619 ? 256.413 -9.704  267.224 1.0 45.97094  ? 619 TRP A CA  619 TRP A CA  1 
ATOM 4849  C C   . TRP A 1 619 ? 254.962 -10.172 267.185 1.0 45.97094  ? 619 TRP A C   619 TRP A C   1 
ATOM 4850  O O   . TRP A 1 619 ? 254.293 -10.198 268.218 1.0 45.97094  ? 619 TRP A O   619 TRP A O   1 
ATOM 4851  C CB  . TRP A 1 619 ? 256.601 -8.649  268.322 1.0 45.97094  ? 619 TRP A CB  619 TRP A CB  1 
ATOM 4852  C CG  . TRP A 1 619 ? 258.025 -8.364  268.578 1.0 45.97094  ? 619 TRP A CG  619 TRP A CG  1 
ATOM 4853  C CD1 . TRP A 1 619 ? 258.744 -7.313  268.109 1.0 45.97094  ? 619 TRP A CD1 619 TRP A CD1 1 
ATOM 4854  C CD2 . TRP A 1 619 ? 258.928 -9.163  269.335 1.0 45.97094  ? 619 TRP A CD2 619 TRP A CD2 1 
ATOM 4855  N NE1 . TRP A 1 619 ? 260.040 -7.397  268.541 1.0 45.97094  ? 619 TRP A NE1 619 TRP A NE1 1 
ATOM 4856  C CE2 . TRP A 1 619 ? 260.179 -8.529  269.296 1.0 45.97094  ? 619 TRP A CE2 619 TRP A CE2 1 
ATOM 4857  C CE3 . TRP A 1 619 ? 258.798 -10.352 270.050 1.0 45.97094  ? 619 TRP A CE3 619 TRP A CE3 1 
ATOM 4858  C CZ2 . TRP A 1 619 ? 261.290 -9.041  269.944 1.0 45.97094  ? 619 TRP A CZ2 619 TRP A CZ2 1 
ATOM 4859  C CZ3 . TRP A 1 619 ? 259.901 -10.858 270.692 1.0 45.97094  ? 619 TRP A CZ3 619 TRP A CZ3 1 
ATOM 4860  C CH2 . TRP A 1 619 ? 261.132 -10.206 270.635 1.0 45.97094  ? 619 TRP A CH2 619 TRP A CH2 1 
ATOM 4861  N N   . GLY A 1 620 ? 254.461 -10.561 266.016 1.0 45.32036  ? 620 GLY A N   620 GLY A N   1 
ATOM 4862  C CA  . GLY A 1 620 ? 253.132 -11.134 265.934 1.0 45.32036  ? 620 GLY A CA  620 GLY A CA  1 
ATOM 4863  C C   . GLY A 1 620 ? 253.196 -12.642 266.103 1.0 45.32036  ? 620 GLY A C   620 GLY A C   1 
ATOM 4864  O O   . GLY A 1 620 ? 254.118 -13.299 265.623 1.0 45.32036  ? 620 GLY A O   620 GLY A O   1 
ATOM 4865  N N   . ALA A 1 621 ? 252.204 -13.176 266.825 1.0 43.39083  ? 621 ALA A N   621 ALA A N   1 
ATOM 4866  C CA  . ALA A 1 621 ? 252.112 -14.588 267.221 1.0 43.39083  ? 621 ALA A CA  621 ALA A CA  1 
ATOM 4867  C C   . ALA A 1 621 ? 253.340 -15.058 267.999 1.0 43.39083  ? 621 ALA A C   621 ALA A C   1 
ATOM 4868  O O   . ALA A 1 621 ? 253.705 -16.232 267.949 1.0 43.39083  ? 621 ALA A O   621 ALA A O   1 
ATOM 4869  C CB  . ALA A 1 621 ? 251.853 -15.507 266.021 1.0 43.39083  ? 621 ALA A CB  621 ALA A CB  1 
ATOM 4870  N N   . PHE A 1 622 ? 253.982 -14.146 268.722 1.0 43.84279  ? 622 PHE A N   622 PHE A N   1 
ATOM 4871  C CA  . PHE A 1 622 ? 255.110 -14.499 269.566 1.0 43.84279  ? 622 PHE A CA  622 PHE A CA  1 
ATOM 4872  C C   . PHE A 1 622 ? 254.615 -15.244 270.795 1.0 43.84279  ? 622 PHE A C   622 PHE A C   1 
ATOM 4873  O O   . PHE A 1 622 ? 253.537 -14.963 271.318 1.0 43.84279  ? 622 PHE A O   622 PHE A O   1 
ATOM 4874  C CB  . PHE A 1 622 ? 255.870 -13.236 269.960 1.0 43.84279  ? 622 PHE A CB  622 PHE A CB  1 
ATOM 4875  C CG  . PHE A 1 622 ? 257.069 -13.486 270.813 1.0 43.84279  ? 622 PHE A CG  622 PHE A CG  1 
ATOM 4876  C CD1 . PHE A 1 622 ? 258.187 -14.100 270.288 1.0 43.84279  ? 622 PHE A CD1 622 PHE A CD1 1 
ATOM 4877  C CD2 . PHE A 1 622 ? 257.095 -13.065 272.127 1.0 43.84279  ? 622 PHE A CD2 622 PHE A CD2 1 
ATOM 4878  C CE1 . PHE A 1 622 ? 259.296 -14.323 271.071 1.0 43.84279  ? 622 PHE A CE1 622 PHE A CE1 1 
ATOM 4879  C CE2 . PHE A 1 622 ? 258.201 -13.280 272.911 1.0 43.84279  ? 622 PHE A CE2 622 PHE A CE2 1 
ATOM 4880  C CZ  . PHE A 1 622 ? 259.302 -13.909 272.384 1.0 43.84279  ? 622 PHE A CZ  622 PHE A CZ  1 
ATOM 4881  N N   . ARG A 1 623 ? 255.402 -16.211 271.254 1.0 44.51416  ? 623 ARG A N   623 ARG A N   1 
ATOM 4882  C CA  . ARG A 1 623 ? 254.929 -17.149 272.264 1.0 44.51416  ? 623 ARG A CA  623 ARG A CA  1 
ATOM 4883  C C   . ARG A 1 623 ? 255.519 -16.923 273.647 1.0 44.51416  ? 623 ARG A C   623 ARG A C   1 
ATOM 4884  O O   . ARG A 1 623 ? 254.782 -16.983 274.631 1.0 44.51416  ? 623 ARG A O   623 ARG A O   1 
ATOM 4885  C CB  . ARG A 1 623 ? 255.204 -18.585 271.808 1.0 44.51416  ? 623 ARG A CB  623 ARG A CB  1 
ATOM 4886  C CG  . ARG A 1 623 ? 254.554 -19.658 272.662 1.0 44.51416  ? 623 ARG A CG  623 ARG A CG  1 
ATOM 4887  C CD  . ARG A 1 623 ? 254.838 -21.038 272.102 1.0 44.51416  ? 623 ARG A CD  623 ARG A CD  1 
ATOM 4888  N NE  . ARG A 1 623 ? 256.256 -21.355 272.167 1.0 44.51416  ? 623 ARG A NE  623 ARG A NE  1 
ATOM 4889  C CZ  . ARG A 1 623 ? 256.813 -22.393 271.559 1.0 44.51416  ? 623 ARG A CZ  623 ARG A CZ  1 
ATOM 4890  N NH1 . ARG A 1 623 ? 256.065 -23.211 270.836 1.0 44.51416  ? 623 ARG A NH1 623 ARG A NH1 1 
ATOM 4891  N NH2 . ARG A 1 623 ? 258.116 -22.609 271.670 1.0 44.51416  ? 623 ARG A NH2 623 ARG A NH2 1 
ATOM 4892  N N   . GLY A 1 624 ? 256.811 -16.661 273.772 1.0 45.039    ? 624 GLY A N   624 GLY A N   1 
ATOM 4893  C CA  . GLY A 1 624 ? 257.377 -16.395 275.080 1.0 45.039    ? 624 GLY A CA  624 GLY A CA  1 
ATOM 4894  C C   . GLY A 1 624 ? 258.884 -16.520 275.080 1.0 45.039    ? 624 GLY A C   624 GLY A C   1 
ATOM 4895  O O   . GLY A 1 624 ? 259.516 -16.712 274.045 1.0 45.039    ? 624 GLY A O   624 GLY A O   1 
ATOM 4896  N N   . TRP A 1 625 ? 259.446 -16.405 276.281 1.0 45.59054  ? 625 TRP A N   625 TRP A N   1 
ATOM 4897  C CA  . TRP A 1 625 ? 260.882 -16.462 276.504 1.0 45.59054  ? 625 TRP A CA  625 TRP A CA  1 
ATOM 4898  C C   . TRP A 1 625 ? 261.262 -17.708 277.291 1.0 45.59054  ? 625 TRP A C   625 TRP A C   1 
ATOM 4899  O O   . TRP A 1 625 ? 260.427 -18.337 277.943 1.0 45.59054  ? 625 TRP A O   625 TRP A O   1 
ATOM 4900  C CB  . TRP A 1 625 ? 261.371 -15.227 277.260 1.0 45.59054  ? 625 TRP A CB  625 TRP A CB  1 
ATOM 4901  C CG  . TRP A 1 625 ? 261.322 -13.970 276.478 1.0 45.59054  ? 625 TRP A CG  625 TRP A CG  1 
ATOM 4902  C CD1 . TRP A 1 625 ? 262.306 -13.467 275.692 1.0 45.59054  ? 625 TRP A CD1 625 TRP A CD1 1 
ATOM 4903  C CD2 . TRP A 1 625 ? 260.239 -13.040 276.410 1.0 45.59054  ? 625 TRP A CD2 625 TRP A CD2 1 
ATOM 4904  N NE1 . TRP A 1 625 ? 261.907 -12.284 275.133 1.0 45.59054  ? 625 TRP A NE1 625 TRP A NE1 1 
ATOM 4905  C CE2 . TRP A 1 625 ? 260.638 -11.999 275.559 1.0 45.59054  ? 625 TRP A CE2 625 TRP A CE2 1 
ATOM 4906  C CE3 . TRP A 1 625 ? 258.970 -12.988 276.985 1.0 45.59054  ? 625 TRP A CE3 625 TRP A CE3 1 
ATOM 4907  C CZ2 . TRP A 1 625 ? 259.813 -10.921 275.267 1.0 45.59054  ? 625 TRP A CZ2 625 TRP A CZ2 1 
ATOM 4908  C CZ3 . TRP A 1 625 ? 258.153 -11.924 276.689 1.0 45.59054  ? 625 TRP A CZ3 625 TRP A CZ3 1 
ATOM 4909  C CH2 . TRP A 1 625 ? 258.578 -10.899 275.847 1.0 45.59054  ? 625 TRP A CH2 625 TRP A CH2 1 
ATOM 4910  N N   . SER A 1 626 ? 262.547 -18.054 277.224 1.0 45.86394  ? 626 SER A N   626 SER A N   1 
ATOM 4911  C CA  . SER A 1 626 ? 263.118 -19.155 277.990 1.0 45.86394  ? 626 SER A CA  626 SER A CA  1 
ATOM 4912  C C   . SER A 1 626 ? 264.624 -18.957 278.073 1.0 45.86394  ? 626 SER A C   626 SER A C   1 
ATOM 4913  O O   . SER A 1 626 ? 265.255 -18.615 277.071 1.0 45.86394  ? 626 SER A O   626 SER A O   1 
ATOM 4914  C CB  . SER A 1 626 ? 262.800 -20.515 277.362 1.0 45.86394  ? 626 SER A CB  626 SER A CB  1 
ATOM 4915  O OG  . SER A 1 626 ? 261.415 -20.796 277.427 1.0 45.86394  ? 626 SER A OG  626 SER A OG  1 
ATOM 4916  N N   . PHE A 1 627 ? 265.201 -19.184 279.255 1.0 47.20417  ? 627 PHE A N   627 PHE A N   1 
ATOM 4917  C CA  . PHE A 1 627 ? 266.610 -18.857 279.429 1.0 47.20417  ? 627 PHE A CA  627 PHE A CA  1 
ATOM 4918  C C   . PHE A 1 627 ? 267.257 -19.666 280.548 1.0 47.20417  ? 627 PHE A C   627 PHE A C   1 
ATOM 4919  O O   . PHE A 1 627 ? 266.642 -19.905 281.588 1.0 47.20417  ? 627 PHE A O   627 PHE A O   1 
ATOM 4920  C CB  . PHE A 1 627 ? 266.796 -17.352 279.678 1.0 47.20417  ? 627 PHE A CB  627 PHE A CB  1 
ATOM 4921  C CG  . PHE A 1 627 ? 266.119 -16.831 280.915 1.0 47.20417  ? 627 PHE A CG  627 PHE A CG  1 
ATOM 4922  C CD1 . PHE A 1 627 ? 264.801 -16.414 280.874 1.0 47.20417  ? 627 PHE A CD1 627 PHE A CD1 1 
ATOM 4923  C CD2 . PHE A 1 627 ? 266.821 -16.693 282.100 1.0 47.20417  ? 627 PHE A CD2 627 PHE A CD2 1 
ATOM 4924  C CE1 . PHE A 1 627 ? 264.183 -15.918 281.997 1.0 47.20417  ? 627 PHE A CE1 627 PHE A CE1 1 
ATOM 4925  C CE2 . PHE A 1 627 ? 266.207 -16.197 283.227 1.0 47.20417  ? 627 PHE A CE2 627 PHE A CE2 1 
ATOM 4926  C CZ  . PHE A 1 627 ? 264.887 -15.808 283.174 1.0 47.20417  ? 627 PHE A CZ  627 PHE A CZ  1 
ATOM 4927  N N   . THR A 1 628 ? 268.503 -20.081 280.311 1.0 52.4599   ? 628 THR A N   628 THR A N   1 
ATOM 4928  C CA  . THR A 1 628 ? 269.407 -20.618 281.328 1.0 52.4599   ? 628 THR A CA  628 THR A CA  1 
ATOM 4929  C C   . THR A 1 628 ? 270.786 -20.007 281.132 1.0 52.4599   ? 628 THR A C   628 THR A C   1 
ATOM 4930  O O   . THR A 1 628 ? 270.956 -19.022 280.410 1.0 52.4599   ? 628 THR A O   628 THR A O   1 
ATOM 4931  C CB  . THR A 1 628 ? 269.538 -22.145 281.295 1.0 52.4599   ? 628 THR A CB  628 THR A CB  1 
ATOM 4932  O OG1 . THR A 1 628 ? 269.717 -22.598 279.948 1.0 52.4599   ? 628 THR A OG1 628 THR A OG1 1 
ATOM 4933  C CG2 . THR A 1 628 ? 268.390 -22.817 281.961 1.0 52.4599   ? 628 THR A CG2 628 THR A CG2 1 
ATOM 4934  N N   . ARG A 1 629 ? 271.768 -20.591 281.810 1.0 54.09549  ? 629 ARG A N   629 ARG A N   1 
ATOM 4935  C CA  . ARG A 1 629 ? 273.177 -20.325 281.577 1.0 54.09549  ? 629 ARG A CA  629 ARG A CA  1 
ATOM 4936  C C   . ARG A 1 629 ? 273.866 -21.611 281.151 1.0 54.09549  ? 629 ARG A C   629 ARG A C   1 
ATOM 4937  O O   . ARG A 1 629 ? 273.512 -22.702 281.601 1.0 54.09549  ? 629 ARG A O   629 ARG A O   1 
ATOM 4938  C CB  . ARG A 1 629 ? 273.865 -19.772 282.825 1.0 54.09549  ? 629 ARG A CB  629 ARG A CB  1 
ATOM 4939  C CG  . ARG A 1 629 ? 273.396 -18.406 283.227 1.0 54.09549  ? 629 ARG A CG  629 ARG A CG  1 
ATOM 4940  C CD  . ARG A 1 629 ? 274.082 -17.917 284.483 1.0 54.09549  ? 629 ARG A CD  629 ARG A CD  1 
ATOM 4941  N NE  . ARG A 1 629 ? 275.479 -17.590 284.242 1.0 54.09549  ? 629 ARG A NE  629 ARG A NE  1 
ATOM 4942  C CZ  . ARG A 1 629 ? 276.340 -17.253 285.193 1.0 54.09549  ? 629 ARG A CZ  629 ARG A CZ  1 
ATOM 4943  N NH1 . ARG A 1 629 ? 275.949 -17.201 286.455 1.0 54.09549  ? 629 ARG A NH1 629 ARG A NH1 1 
ATOM 4944  N NH2 . ARG A 1 629 ? 277.593 -16.966 284.879 1.0 54.09549  ? 629 ARG A NH2 629 ARG A NH2 1 
ATOM 4945  N N   . LEU A 1 630 ? 274.859 -21.475 280.280 1.0 55.00027  ? 630 LEU A N   630 LEU A N   1 
ATOM 4946  C CA  . LEU A 1 630 ? 275.616 -22.618 279.798 1.0 55.00027  ? 630 LEU A CA  630 LEU A CA  1 
ATOM 4947  C C   . LEU A 1 630 ? 277.089 -22.261 279.836 1.0 55.00027  ? 630 LEU A C   630 LEU A C   1 
ATOM 4948  O O   . LEU A 1 630 ? 277.468 -21.176 279.392 1.0 55.00027  ? 630 LEU A O   630 LEU A O   1 
ATOM 4949  C CB  . LEU A 1 630 ? 275.218 -22.991 278.370 1.0 55.00027  ? 630 LEU A CB  630 LEU A CB  1 
ATOM 4950  C CG  . LEU A 1 630 ? 273.779 -23.390 278.060 1.0 55.00027  ? 630 LEU A CG  630 LEU A CG  1 
ATOM 4951  C CD1 . LEU A 1 630 ? 273.644 -23.643 276.573 1.0 55.00027  ? 630 LEU A CD1 630 LEU A CD1 1 
ATOM 4952  C CD2 . LEU A 1 630 ? 273.356 -24.596 278.853 1.0 55.00027  ? 630 LEU A CD2 630 LEU A CD2 1 
ATOM 4953  N N   . LYS A 1 631 ? 277.912 -23.164 280.359 1.0 59.06788  ? 631 LYS A N   631 LYS A N   1 
ATOM 4954  C CA  . LYS A 1 631 ? 279.353 -22.954 280.342 1.0 59.06788  ? 631 LYS A CA  631 LYS A CA  1 
ATOM 4955  C C   . LYS A 1 631 ? 279.873 -22.965 278.910 1.0 59.06788  ? 631 LYS A C   631 LYS A C   1 
ATOM 4956  O O   . LYS A 1 631 ? 279.373 -23.707 278.062 1.0 59.06788  ? 631 LYS A O   631 LYS A O   1 
ATOM 4957  C CB  . LYS A 1 631 ? 280.055 -24.032 281.161 1.0 59.06788  ? 631 LYS A CB  631 LYS A CB  1 
ATOM 4958  C CG  . LYS A 1 631 ? 279.811 -23.964 282.655 1.0 59.06788  ? 631 LYS A CG  631 LYS A CG  1 
ATOM 4959  C CD  . LYS A 1 631 ? 280.535 -25.101 283.354 1.0 59.06788  ? 631 LYS A CD  631 LYS A CD  1 
ATOM 4960  C CE  . LYS A 1 631 ? 280.457 -24.983 284.858 1.0 59.06788  ? 631 LYS A CE  631 LYS A CE  1 
ATOM 4961  N NZ  . LYS A 1 631 ? 279.073 -25.094 285.341 1.0 59.06788  ? 631 LYS A NZ  631 LYS A NZ  1 
ATOM 4962  N N   . VAL A 1 632 ? 280.863 -22.113 278.636 1.0 60.60734  ? 632 VAL A N   632 VAL A N   1 
ATOM 4963  C CA  . VAL A 1 632 ? 281.437 -22.042 277.294 1.0 60.60734  ? 632 VAL A CA  632 VAL A CA  1 
ATOM 4964  C C   . VAL A 1 632 ? 282.232 -23.304 276.991 1.0 60.60734  ? 632 VAL A C   632 VAL A C   1 
ATOM 4965  O O   . VAL A 1 632 ? 282.174 -23.841 275.877 1.0 60.60734  ? 632 VAL A O   632 VAL A O   1 
ATOM 4966  C CB  . VAL A 1 632 ? 282.296 -20.771 277.153 1.0 60.60734  ? 632 VAL A CB  632 VAL A CB  1 
ATOM 4967  C CG1 . VAL A 1 632 ? 283.028 -20.733 275.820 1.0 60.60734  ? 632 VAL A CG1 632 VAL A CG1 1 
ATOM 4968  C CG2 . VAL A 1 632 ? 281.428 -19.545 277.280 1.0 60.60734  ? 632 VAL A CG2 632 VAL A CG2 1 
ATOM 4969  N N   . SER A 1 633 ? 282.950 -23.822 277.989 1.0 62.6699   ? 633 SER A N   633 SER A N   1 
ATOM 4970  C CA  . SER A 1 633 ? 283.727 -25.040 277.811 1.0 62.6699   ? 633 SER A CA  633 SER A CA  1 
ATOM 4971  C C   . SER A 1 633 ? 282.854 -26.266 277.593 1.0 62.6699   ? 633 SER A C   633 SER A C   1 
ATOM 4972  O O   . SER A 1 633 ? 283.305 -27.223 276.960 1.0 62.6699   ? 633 SER A O   633 SER A O   1 
ATOM 4973  C CB  . SER A 1 633 ? 284.628 -25.265 279.022 1.0 62.6699   ? 633 SER A CB  633 SER A CB  1 
ATOM 4974  O OG  . SER A 1 633 ? 283.858 -25.543 280.176 1.0 62.6699   ? 633 SER A OG  633 SER A OG  1 
ATOM 4975  N N   . GLU A 1 634 ? 281.617 -26.253 278.081 1.0 61.76269  ? 634 GLU A N   634 GLU A N   1 
ATOM 4976  C CA  . GLU A 1 634 ? 280.715 -27.387 277.946 1.0 61.76269  ? 634 GLU A CA  634 GLU A CA  1 
ATOM 4977  C C   . GLU A 1 634 ? 279.749 -27.251 276.781 1.0 61.76269  ? 634 GLU A C   634 GLU A C   1 
ATOM 4978  O O   . GLU A 1 634 ? 278.950 -28.162 276.552 1.0 61.76269  ? 634 GLU A O   634 GLU A O   1 
ATOM 4979  C CB  . GLU A 1 634 ? 279.924 -27.588 279.240 1.0 61.76269  ? 634 GLU A CB  634 GLU A CB  1 
ATOM 4980  C CG  . GLU A 1 634 ? 280.770 -28.011 280.423 1.0 61.76269  ? 634 GLU A CG  634 GLU A CG  1 
ATOM 4981  C CD  . GLU A 1 634 ? 279.949 -28.240 281.674 1.0 61.76269  ? 634 GLU A CD  634 GLU A CD  1 
ATOM 4982  O OE1 . GLU A 1 634 ? 278.734 -27.956 281.651 1.0 61.76269  ? 634 GLU A OE1 634 GLU A OE1 1 
ATOM 4983  O OE2 . GLU A 1 634 ? 280.520 -28.705 282.682 1.0 61.76269  ? 634 GLU A OE2 634 GLU A OE2 1 
ATOM 4984  N N   . THR A 1 635 ? 279.792 -26.146 276.044 1.0 63.26515  ? 635 THR A N   635 THR A N   1 
ATOM 4985  C CA  . THR A 1 635 ? 278.889 -25.928 274.920 1.0 63.26515  ? 635 THR A CA  635 THR A CA  1 
ATOM 4986  C C   . THR A 1 635 ? 279.695 -25.827 273.634 1.0 63.26515  ? 635 THR A C   635 THR A C   1 
ATOM 4987  O O   . THR A 1 635 ? 280.564 -24.946 273.521 1.0 63.26515  ? 635 THR A O   635 THR A O   1 
ATOM 4988  C CB  . THR A 1 635 ? 278.054 -24.664 275.120 1.0 63.26515  ? 635 THR A CB  635 THR A CB  1 
ATOM 4989  O OG1 . THR A 1 635 ? 277.230 -24.816 276.279 1.0 63.26515  ? 635 THR A OG1 635 THR A OG1 1 
ATOM 4990  C CG2 . THR A 1 635 ? 277.175 -24.415 273.911 1.0 63.26515  ? 635 THR A CG2 635 THR A CG2 1 
ATOM 4991  N N   . PRO A 1 636 ? 279.446 -26.675 272.648 1.0 65.49697  ? 636 PRO A N   636 PRO A N   1 
ATOM 4992  C CA  . PRO A 1 636 ? 280.235 -26.658 271.418 1.0 65.49697  ? 636 PRO A CA  636 PRO A CA  1 
ATOM 4993  C C   . PRO A 1 636 ? 279.740 -25.567 270.478 1.0 65.49697  ? 636 PRO A C   636 PRO A C   1 
ATOM 4994  O O   . PRO A 1 636 ? 278.860 -24.774 270.803 1.0 65.49697  ? 636 PRO A O   636 PRO A O   1 
ATOM 4995  C CB  . PRO A 1 636 ? 279.980 -28.040 270.834 1.0 65.49697  ? 636 PRO A CB  636 PRO A CB  1 
ATOM 4996  C CG  . PRO A 1 636 ? 278.592 -28.341 271.260 1.0 65.49697  ? 636 PRO A CG  636 PRO A CG  1 
ATOM 4997  C CD  . PRO A 1 636 ? 278.436 -27.744 272.628 1.0 65.49697  ? 636 PRO A CD  636 PRO A CD  1 
ATOM 4998  N N   . ARG A 1 637 ? 280.320 -25.548 269.286 1.0 70.51936  ? 637 ARG A N   637 ARG A N   1 
ATOM 4999  C CA  . ARG A 1 637 ? 279.834 -24.727 268.187 1.0 70.51936  ? 637 ARG A CA  637 ARG A CA  1 
ATOM 5000  C C   . ARG A 1 637 ? 279.403 -25.673 267.076 1.0 70.51936  ? 637 ARG A C   637 ARG A C   1 
ATOM 5001  O O   . ARG A 1 637 ? 280.243 -26.302 266.425 1.0 70.51936  ? 637 ARG A O   637 ARG A O   1 
ATOM 5002  C CB  . ARG A 1 637 ? 280.900 -23.748 267.708 1.0 70.51936  ? 637 ARG A CB  637 ARG A CB  1 
ATOM 5003  C CG  . ARG A 1 637 ? 280.469 -22.862 266.545 1.0 70.51936  ? 637 ARG A CG  637 ARG A CG  1 
ATOM 5004  C CD  . ARG A 1 637 ? 279.445 -21.806 266.960 1.0 70.51936  ? 637 ARG A CD  637 ARG A CD  1 
ATOM 5005  N NE  . ARG A 1 637 ? 278.062 -22.251 266.796 1.0 70.51936  ? 637 ARG A NE  637 ARG A NE  1 
ATOM 5006  C CZ  . ARG A 1 637 ? 277.004 -21.591 267.257 1.0 70.51936  ? 637 ARG A CZ  637 ARG A CZ  1 
ATOM 5007  N NH1 . ARG A 1 637 ? 277.167 -20.455 267.920 1.0 70.51936  ? 637 ARG A NH1 637 ARG A NH1 1 
ATOM 5008  N NH2 . ARG A 1 637 ? 275.783 -22.070 267.061 1.0 70.51936  ? 637 ARG A NH2 637 ARG A NH2 1 
ATOM 5009  N N   . ILE A 1 638 ? 278.095 -25.776 266.868 1.0 67.00025  ? 638 ILE A N   638 ILE A N   1 
ATOM 5010  C CA  . ILE A 1 638 ? 277.553 -26.760 265.942 1.0 67.00025  ? 638 ILE A CA  638 ILE A CA  1 
ATOM 5011  C C   . ILE A 1 638 ? 277.591 -26.266 264.495 1.0 67.00025  ? 638 ILE A C   638 ILE A C   1 
ATOM 5012  O O   . ILE A 1 638 ? 277.755 -27.070 263.572 1.0 67.00025  ? 638 ILE A O   638 ILE A O   1 
ATOM 5013  C CB  . ILE A 1 638 ? 276.129 -27.120 266.398 1.0 67.00025  ? 638 ILE A CB  638 ILE A CB  1 
ATOM 5014  C CG1 . ILE A 1 638 ? 276.182 -27.655 267.821 1.0 67.00025  ? 638 ILE A CG1 638 ILE A CG1 1 
ATOM 5015  C CG2 . ILE A 1 638 ? 275.495 -28.189 265.533 1.0 67.00025  ? 638 ILE A CG2 638 ILE A CG2 1 
ATOM 5016  C CD1 . ILE A 1 638 ? 274.836 -27.823 268.428 1.0 67.00025  ? 638 ILE A CD1 638 ILE A CD1 1 
ATOM 5017  N N   . GLY A 1 639 ? 277.514 -24.950 264.281 1.0 67.77621  ? 639 GLY A N   639 GLY A N   1 
ATOM 5018  C CA  . GLY A 1 639 ? 277.491 -24.369 262.944 1.0 67.77621  ? 639 GLY A CA  639 GLY A CA  1 
ATOM 5019  C C   . GLY A 1 639 ? 278.753 -24.585 262.125 1.0 67.77621  ? 639 GLY A C   639 GLY A C   1 
ATOM 5020  O O   . GLY A 1 639 ? 278.717 -24.385 260.906 1.0 67.77621  ? 639 GLY A O   639 GLY A O   1 
ATOM 5021  N N   . ALA A 1 640 ? 279.854 -24.982 262.753 1.0 67.84333  ? 640 ALA A N   640 ALA A N   1 
ATOM 5022  C CA  . ALA A 1 640 ? 281.056 -25.362 262.032 1.0 67.84333  ? 640 ALA A CA  640 ALA A CA  1 
ATOM 5023  C C   . ALA A 1 640 ? 281.098 -26.875 261.839 1.0 67.84333  ? 640 ALA A C   640 ALA A C   1 
ATOM 5024  O O   . ALA A 1 640 ? 280.372 -27.633 262.484 1.0 67.84333  ? 640 ALA A O   640 ALA A O   1 
ATOM 5025  C CB  . ALA A 1 640 ? 282.301 -24.880 262.775 1.0 67.84333  ? 640 ALA A CB  640 ALA A CB  1 
ATOM 5026  N N   . THR A 1 641 ? 281.971 -27.315 260.933 1.0 68.35653  ? 641 THR A N   641 THR A N   1 
ATOM 5027  C CA  . THR A 1 641 ? 282.142 -28.742 260.690 1.0 68.35653  ? 641 THR A CA  641 THR A CA  1 
ATOM 5028  C C   . THR A 1 641 ? 282.911 -29.439 261.802 1.0 68.35653  ? 641 THR A C   641 THR A C   1 
ATOM 5029  O O   . THR A 1 641 ? 282.819 -30.665 261.921 1.0 68.35653  ? 641 THR A O   641 THR A O   1 
ATOM 5030  C CB  . THR A 1 641 ? 282.843 -28.973 259.348 1.0 68.35653  ? 641 THR A CB  641 THR A CB  1 
ATOM 5031  O OG1 . THR A 1 641 ? 282.941 -30.379 259.094 1.0 68.35653  ? 641 THR A OG1 641 THR A OG1 1 
ATOM 5032  C CG2 . THR A 1 641 ? 284.232 -28.355 259.337 1.0 68.35653  ? 641 THR A CG2 641 THR A CG2 1 
ATOM 5033  N N   . GLN A 1 642 ? 283.643 -28.686 262.621 1.0 72.22325  ? 642 GLN A N   642 GLN A N   1 
ATOM 5034  C CA  . GLN A 1 642 ? 284.419 -29.224 263.727 1.0 72.22325  ? 642 GLN A CA  642 GLN A CA  1 
ATOM 5035  C C   . GLN A 1 642 ? 284.775 -28.064 264.641 1.0 72.22325  ? 642 GLN A C   642 GLN A C   1 
ATOM 5036  O O   . GLN A 1 642 ? 285.069 -26.965 264.165 1.0 72.22325  ? 642 GLN A O   642 GLN A O   1 
ATOM 5037  C CB  . GLN A 1 642 ? 285.683 -29.939 263.230 1.0 72.22325  ? 642 GLN A CB  642 GLN A CB  1 
ATOM 5038  C CG  . GLN A 1 642 ? 286.419 -30.760 264.274 1.0 72.22325  ? 642 GLN A CG  642 GLN A CG  1 
ATOM 5039  C CD  . GLN A 1 642 ? 287.479 -29.965 265.001 1.0 72.22325  ? 642 GLN A CD  642 GLN A CD  1 
ATOM 5040  O OE1 . GLN A 1 642 ? 288.049 -29.025 264.451 1.0 72.22325  ? 642 GLN A OE1 642 GLN A OE1 1 
ATOM 5041  N NE2 . GLN A 1 642 ? 287.750 -30.338 266.244 1.0 72.22325  ? 642 GLN A NE2 642 GLN A NE2 1 
ATOM 5042  N N   . ASP A 1 643 ? 284.738 -28.308 265.945 1.0 73.29205  ? 643 ASP A N   643 ASP A N   1 
ATOM 5043  C CA  . ASP A 1 643 ? 285.054 -27.266 266.912 1.0 73.29205  ? 643 ASP A CA  643 ASP A CA  1 
ATOM 5044  C C   . ASP A 1 643 ? 286.412 -27.564 267.529 1.0 73.29205  ? 643 ASP A C   643 ASP A C   1 
ATOM 5045  O O   . ASP A 1 643 ? 286.523 -28.490 268.348 1.0 73.29205  ? 643 ASP A O   643 ASP A O   1 
ATOM 5046  C CB  . ASP A 1 643 ? 283.976 -27.189 267.994 1.0 73.29205  ? 643 ASP A CB  643 ASP A CB  1 
ATOM 5047  C CG  . ASP A 1 643 ? 284.040 -25.901 268.798 1.0 73.29205  ? 643 ASP A CG  643 ASP A CG  1 
ATOM 5048  O OD1 . ASP A 1 643 ? 284.893 -25.039 268.497 1.0 73.29205  ? 643 ASP A OD1 643 ASP A OD1 1 
ATOM 5049  O OD2 . ASP A 1 643 ? 283.233 -25.751 269.741 1.0 73.29205  ? 643 ASP A OD2 643 ASP A OD2 1 
ATOM 5050  N N   . PRO A 1 644 ? 287.467 -26.827 267.171 1.0 72.44485  ? 644 PRO A N   644 PRO A N   1 
ATOM 5051  C CA  . PRO A 1 644 ? 288.786 -27.108 267.753 1.0 72.44485  ? 644 PRO A CA  644 PRO A CA  1 
ATOM 5052  C C   . PRO A 1 644 ? 288.947 -26.600 269.171 1.0 72.44485  ? 644 PRO A C   644 PRO A C   1 
ATOM 5053  O O   . PRO A 1 644 ? 289.880 -27.031 269.859 1.0 72.44485  ? 644 PRO A O   644 PRO A O   1 
ATOM 5054  C CB  . PRO A 1 644 ? 289.746 -26.388 266.801 1.0 72.44485  ? 644 PRO A CB  644 PRO A CB  1 
ATOM 5055  C CG  . PRO A 1 644 ? 288.939 -25.263 266.264 1.0 72.44485  ? 644 PRO A CG  644 PRO A CG  1 
ATOM 5056  C CD  . PRO A 1 644 ? 287.529 -25.769 266.149 1.0 72.44485  ? 644 PRO A CD  644 PRO A CD  1 
ATOM 5057  N N   . ASN A 1 645 ? 288.083 -25.700 269.627 1.0 72.84891  ? 645 ASN A N   645 ASN A N   1 
ATOM 5058  C CA  . ASN A 1 645 ? 288.124 -25.206 270.994 1.0 72.84891  ? 645 ASN A CA  645 ASN A CA  1 
ATOM 5059  C C   . ASN A 1 645 ? 287.255 -26.020 271.936 1.0 72.84891  ? 645 ASN A C   645 ASN A C   1 
ATOM 5060  O O   . ASN A 1 645 ? 287.041 -25.600 273.077 1.0 72.84891  ? 645 ASN A O   645 ASN A O   1 
ATOM 5061  C CB  . ASN A 1 645 ? 287.684 -23.744 271.041 1.0 72.84891  ? 645 ASN A CB  645 ASN A CB  1 
ATOM 5062  C CG  . ASN A 1 645 ? 288.669 -22.822 270.366 1.0 72.84891  ? 645 ASN A CG  645 ASN A CG  1 
ATOM 5063  O OD1 . ASN A 1 645 ? 289.881 -22.975 270.514 1.0 72.84891  ? 645 ASN A OD1 645 ASN A OD1 1 
ATOM 5064  N ND2 . ASN A 1 645 ? 288.154 -21.856 269.617 1.0 72.84891  ? 645 ASN A ND2 645 ASN A ND2 1 
ATOM 5065  N N   . PHE A 1 646 ? 286.743 -27.158 271.489 1.0 66.33803  ? 646 PHE A N   646 PHE A N   1 
ATOM 5066  C CA  . PHE A 1 646 ? 285.830 -27.979 272.275 1.0 66.33803  ? 646 PHE A CA  646 PHE A CA  1 
ATOM 5067  C C   . PHE A 1 646 ? 286.634 -29.123 272.878 1.0 66.33803  ? 646 PHE A C   646 PHE A C   1 
ATOM 5068  O O   . PHE A 1 646 ? 286.961 -30.097 272.197 1.0 66.33803  ? 646 PHE A O   646 PHE A O   1 
ATOM 5069  C CB  . PHE A 1 646 ? 284.684 -28.469 271.402 1.0 66.33803  ? 646 PHE A CB  646 PHE A CB  1 
ATOM 5070  C CG  . PHE A 1 646 ? 283.648 -29.247 272.140 1.0 66.33803  ? 646 PHE A CG  646 PHE A CG  1 
ATOM 5071  C CD1 . PHE A 1 646 ? 282.860 -28.633 273.095 1.0 66.33803  ? 646 PHE A CD1 646 PHE A CD1 1 
ATOM 5072  C CD2 . PHE A 1 646 ? 283.416 -30.574 271.834 1.0 66.33803  ? 646 PHE A CD2 646 PHE A CD2 1 
ATOM 5073  C CE1 . PHE A 1 646 ? 281.890 -29.341 273.764 1.0 66.33803  ? 646 PHE A CE1 646 PHE A CE1 1 
ATOM 5074  C CE2 . PHE A 1 646 ? 282.440 -31.283 272.491 1.0 66.33803  ? 646 PHE A CE2 646 PHE A CE2 1 
ATOM 5075  C CZ  . PHE A 1 646 ? 281.681 -30.667 273.462 1.0 66.33803  ? 646 PHE A CZ  646 PHE A CZ  1 
ATOM 5076  N N   . GLN A 1 647 ? 286.950 -29.000 274.165 1.0 66.62169  ? 647 GLN A N   647 GLN A N   1 
ATOM 5077  C CA  . GLN A 1 647 ? 287.850 -29.913 274.851 1.0 66.62169  ? 647 GLN A CA  647 GLN A CA  1 
ATOM 5078  C C   . GLN A 1 647 ? 287.132 -30.745 275.907 1.0 66.62169  ? 647 GLN A C   647 GLN A C   1 
ATOM 5079  O O   . GLN A 1 647 ? 287.781 -31.342 276.769 1.0 66.62169  ? 647 GLN A O   647 GLN A O   1 
ATOM 5080  C CB  . GLN A 1 647 ? 288.991 -29.118 275.483 1.0 66.62169  ? 647 GLN A CB  647 GLN A CB  1 
ATOM 5081  C CG  . GLN A 1 647 ? 289.794 -28.298 274.486 1.0 66.62169  ? 647 GLN A CG  647 GLN A CG  1 
ATOM 5082  C CD  . GLN A 1 647 ? 290.634 -29.153 273.573 1.0 66.62169  ? 647 GLN A CD  647 GLN A CD  1 
ATOM 5083  O OE1 . GLN A 1 647 ? 291.238 -30.126 274.012 1.0 66.62169  ? 647 GLN A OE1 647 GLN A OE1 1 
ATOM 5084  N NE2 . GLN A 1 647 ? 290.679 -28.798 272.297 1.0 66.62169  ? 647 GLN A NE2 647 GLN A NE2 1 
ATOM 5085  N N   . TYR A 1 648 ? 285.807 -30.807 275.851 1.0 61.79309  ? 648 TYR A N   648 TYR A N   1 
ATOM 5086  C CA  . TYR A 1 648 ? 284.993 -31.429 276.882 1.0 61.79309  ? 648 TYR A CA  648 TYR A CA  1 
ATOM 5087  C C   . TYR A 1 648 ? 284.189 -32.571 276.279 1.0 61.79309  ? 648 TYR A C   648 TYR A C   1 
ATOM 5088  O O   . TYR A 1 648 ? 283.775 -32.509 275.121 1.0 61.79309  ? 648 TYR A O   648 TYR A O   1 
ATOM 5089  C CB  . TYR A 1 648 ? 284.064 -30.392 277.515 1.0 61.79309  ? 648 TYR A CB  648 TYR A CB  1 
ATOM 5090  C CG  . TYR A 1 648 ? 283.166 -30.895 278.615 1.0 61.79309  ? 648 TYR A CG  648 TYR A CG  1 
ATOM 5091  C CD1 . TYR A 1 648 ? 283.672 -31.188 279.871 1.0 61.79309  ? 648 TYR A CD1 648 TYR A CD1 1 
ATOM 5092  C CD2 . TYR A 1 648 ? 281.801 -31.035 278.408 1.0 61.79309  ? 648 TYR A CD2 648 TYR A CD2 1 
ATOM 5093  C CE1 . TYR A 1 648 ? 282.848 -31.635 280.884 1.0 61.79309  ? 648 TYR A CE1 648 TYR A CE1 1 
ATOM 5094  C CE2 . TYR A 1 648 ? 280.968 -31.474 279.413 1.0 61.79309  ? 648 TYR A CE2 648 TYR A CE2 1 
ATOM 5095  C CZ  . TYR A 1 648 ? 281.496 -31.776 280.648 1.0 61.79309  ? 648 TYR A CZ  648 TYR A CZ  1 
ATOM 5096  O OH  . TYR A 1 648 ? 280.669 -32.220 281.654 1.0 61.79309  ? 648 TYR A OH  648 TYR A OH  1 
ATOM 5097  N N   . SER A 1 649 ? 283.983 -33.629 277.064 1.0 59.70234  ? 649 SER A N   649 SER A N   1 
ATOM 5098  C CA  . SER A 1 649 ? 283.258 -34.787 276.556 1.0 59.70234  ? 649 SER A CA  649 SER A CA  1 
ATOM 5099  C C   . SER A 1 649 ? 282.323 -35.382 277.597 1.0 59.70234  ? 649 SER A C   649 SER A C   1 
ATOM 5100  O O   . SER A 1 649 ? 282.104 -36.596 277.612 1.0 59.70234  ? 649 SER A O   649 SER A O   1 
ATOM 5101  C CB  . SER A 1 649 ? 284.214 -35.869 276.072 1.0 59.70234  ? 649 SER A CB  649 SER A CB  1 
ATOM 5102  O OG  . SER A 1 649 ? 284.919 -36.426 277.165 1.0 59.70234  ? 649 SER A OG  649 SER A OG  1 
ATOM 5103  N N   . GLY A 1 650 ? 281.778 -34.557 278.481 1.0 57.51559  ? 650 GLY A N   650 GLY A N   1 
ATOM 5104  C CA  . GLY A 1 650 ? 280.773 -35.032 279.408 1.0 57.51559  ? 650 GLY A CA  650 GLY A CA  1 
ATOM 5105  C C   . GLY A 1 650 ? 279.393 -34.839 278.825 1.0 57.51559  ? 650 GLY A C   650 GLY A C   1 
ATOM 5106  O O   . GLY A 1 650 ? 279.195 -35.035 277.624 1.0 57.51559  ? 650 GLY A O   650 GLY A O   1 
ATOM 5107  N N   . SER A 1 651 ? 278.431 -34.446 279.650 1.0 57.89866  ? 651 SER A N   651 SER A N   1 
ATOM 5108  C CA  . SER A 1 651 ? 277.083 -34.178 279.173 1.0 57.89866  ? 651 SER A CA  651 SER A CA  1 
ATOM 5109  C C   . SER A 1 651 ? 277.011 -32.735 278.698 1.0 57.89866  ? 651 SER A C   651 SER A C   1 
ATOM 5110  O O   . SER A 1 651 ? 277.390 -31.818 279.433 1.0 57.89866  ? 651 SER A O   651 SER A O   1 
ATOM 5111  C CB  . SER A 1 651 ? 276.054 -34.432 280.270 1.0 57.89866  ? 651 SER A CB  651 SER A CB  1 
ATOM 5112  O OG  . SER A 1 651 ? 276.188 -33.477 281.303 1.0 57.89866  ? 651 SER A OG  651 SER A OG  1 
ATOM 5113  N N   . ILE A 1 652 ? 276.539 -32.536 277.474 1.0 55.1137   ? 652 ILE A N   652 ILE A N   1 
ATOM 5114  C CA  . ILE A 1 652 ? 276.359 -31.203 276.910 1.0 55.1137   ? 652 ILE A CA  652 ILE A CA  1 
ATOM 5115  C C   . ILE A 1 652 ? 274.950 -30.734 277.255 1.0 55.1137   ? 652 ILE A C   652 ILE A C   1 
ATOM 5116  O O   . ILE A 1 652 ? 273.980 -31.329 276.766 1.0 55.1137   ? 652 ILE A O   652 ILE A O   1 
ATOM 5117  C CB  . ILE A 1 652 ? 276.577 -31.194 275.395 1.0 55.1137   ? 652 ILE A CB  652 ILE A CB  1 
ATOM 5118  C CG1 . ILE A 1 652 ? 278.021 -31.549 275.060 1.0 55.1137   ? 652 ILE A CG1 652 ILE A CG1 1 
ATOM 5119  C CG2 . ILE A 1 652 ? 276.223 -29.837 274.825 1.0 55.1137   ? 652 ILE A CG2 652 ILE A CG2 1 
ATOM 5120  C CD1 . ILE A 1 652 ? 278.247 -31.768 273.595 1.0 55.1137   ? 652 ILE A CD1 652 ILE A CD1 1 
ATOM 5121  N N   . PRO A 1 653 ? 274.792 -29.689 278.068 1.0 53.9685   ? 653 PRO A N   653 PRO A N   1 
ATOM 5122  C CA  . PRO A 1 653 ? 273.441 -29.230 278.409 1.0 53.9685   ? 653 PRO A CA  653 PRO A CA  1 
ATOM 5123  C C   . PRO A 1 653 ? 272.741 -28.502 277.280 1.0 53.9685   ? 653 PRO A C   653 PRO A C   1 
ATOM 5124  O O   . PRO A 1 653 ? 271.518 -28.337 277.339 1.0 53.9685   ? 653 PRO A O   653 PRO A O   1 
ATOM 5125  C CB  . PRO A 1 653 ? 273.680 -28.312 279.611 1.0 53.9685   ? 653 PRO A CB  653 PRO A CB  1 
ATOM 5126  C CG  . PRO A 1 653 ? 275.067 -27.833 279.434 1.0 53.9685   ? 653 PRO A CG  653 PRO A CG  1 
ATOM 5127  C CD  . PRO A 1 653 ? 275.831 -28.946 278.795 1.0 53.9685   ? 653 PRO A CD  653 PRO A CD  1 
ATOM 5128  N N   . TYR A 1 654 ? 273.466 -28.071 276.252 1.0 53.87922  ? 654 TYR A N   654 TYR A N   1 
ATOM 5129  C CA  . TYR A 1 654 ? 272.828 -27.442 275.105 1.0 53.87922  ? 654 TYR A CA  654 TYR A CA  1 
ATOM 5130  C C   . TYR A 1 654 ? 272.129 -28.464 274.222 1.0 53.87922  ? 654 TYR A C   654 TYR A C   1 
ATOM 5131  O O   . TYR A 1 654 ? 271.141 -28.133 273.560 1.0 53.87922  ? 654 TYR A O   654 TYR A O   1 
ATOM 5132  C CB  . TYR A 1 654 ? 273.869 -26.659 274.307 1.0 53.87922  ? 654 TYR A CB  654 TYR A CB  1 
ATOM 5133  C CG  . TYR A 1 654 ? 273.327 -25.916 273.113 1.0 53.87922  ? 654 TYR A CG  654 TYR A CG  1 
ATOM 5134  C CD1 . TYR A 1 654 ? 272.566 -24.769 273.273 1.0 53.87922  ? 654 TYR A CD1 654 TYR A CD1 1 
ATOM 5135  C CD2 . TYR A 1 654 ? 273.603 -26.345 271.825 1.0 53.87922  ? 654 TYR A CD2 654 TYR A CD2 1 
ATOM 5136  C CE1 . TYR A 1 654 ? 272.077 -24.081 272.182 1.0 53.87922  ? 654 TYR A CE1 654 TYR A CE1 1 
ATOM 5137  C CE2 . TYR A 1 654 ? 273.119 -25.665 270.731 1.0 53.87922  ? 654 TYR A CE2 654 TYR A CE2 1 
ATOM 5138  C CZ  . TYR A 1 654 ? 272.359 -24.535 270.914 1.0 53.87922  ? 654 TYR A CZ  654 TYR A CZ  1 
ATOM 5139  O OH  . TYR A 1 654 ? 271.880 -23.860 269.817 1.0 53.87922  ? 654 TYR A OH  654 TYR A OH  1 
ATOM 5140  N N   . LEU A 1 655 ? 272.608 -29.706 274.216 1.0 52.42525  ? 655 LEU A N   655 LEU A N   1 
ATOM 5141  C CA  . LEU A 1 655 ? 272.051 -30.765 273.384 1.0 52.42525  ? 655 LEU A CA  655 LEU A CA  1 
ATOM 5142  C C   . LEU A 1 655 ? 271.201 -31.748 274.176 1.0 52.42525  ? 655 LEU A C   655 LEU A C   1 
ATOM 5143  O O   . LEU A 1 655 ? 270.082 -32.065 273.771 1.0 52.42525  ? 655 LEU A O   655 LEU A O   1 
ATOM 5144  C CB  . LEU A 1 655 ? 273.177 -31.511 272.675 1.0 52.42525  ? 655 LEU A CB  655 LEU A CB  1 
ATOM 5145  C CG  . LEU A 1 655 ? 273.969 -30.713 271.653 1.0 52.42525  ? 655 LEU A CG  655 LEU A CG  1 
ATOM 5146  C CD1 . LEU A 1 655 ? 275.062 -31.573 271.051 1.0 52.42525  ? 655 LEU A CD1 655 LEU A CD1 1 
ATOM 5147  C CD2 . LEU A 1 655 ? 273.035 -30.204 270.597 1.0 52.42525  ? 655 LEU A CD2 655 LEU A CD2 1 
ATOM 5148  N N   . ASP A 1 656 ? 271.708 -32.233 275.307 1.0 53.75793  ? 656 ASP A N   656 ASP A N   1 
ATOM 5149  C CA  . ASP A 1 656 ? 270.889 -32.984 276.245 1.0 53.75793  ? 656 ASP A CA  656 ASP A CA  1 
ATOM 5150  C C   . ASP A 1 656 ? 269.929 -32.030 276.953 1.0 53.75793  ? 656 ASP A C   656 ASP A C   1 
ATOM 5151  O O   . ASP A 1 656 ? 269.952 -30.813 276.747 1.0 53.75793  ? 656 ASP A O   656 ASP A O   1 
ATOM 5152  C CB  . ASP A 1 656 ? 271.768 -33.705 277.265 1.0 53.75793  ? 656 ASP A CB  656 ASP A CB  1 
ATOM 5153  C CG  . ASP A 1 656 ? 272.637 -34.784 276.648 1.0 53.75793  ? 656 ASP A CG  656 ASP A CG  1 
ATOM 5154  O OD1 . ASP A 1 656 ? 272.221 -35.396 275.653 1.0 53.75793  ? 656 ASP A OD1 656 ASP A OD1 1 
ATOM 5155  O OD2 . ASP A 1 656 ? 273.749 -35.024 277.162 1.0 53.75793  ? 656 ASP A OD2 656 ASP A OD2 1 
ATOM 5156  N N   . GLY A 1 657 ? 269.065 -32.572 277.803 1.0 53.91562  ? 657 GLY A N   657 GLY A N   1 
ATOM 5157  C CA  . GLY A 1 657 ? 268.282 -31.663 278.614 1.0 53.91562  ? 657 GLY A CA  657 GLY A CA  1 
ATOM 5158  C C   . GLY A 1 657 ? 269.140 -31.010 279.677 1.0 53.91562  ? 657 GLY A C   657 GLY A C   1 
ATOM 5159  O O   . GLY A 1 657 ? 269.508 -29.845 279.523 1.0 53.91562  ? 657 GLY A O   657 GLY A O   1 
ATOM 5160  N N   . THR A 1 658 ? 269.453 -31.766 280.738 1.0 54.14437  ? 658 THR A N   658 THR A N   1 
ATOM 5161  C CA  . THR A 1 658 ? 270.557 -31.615 281.692 1.0 54.14437  ? 658 THR A CA  658 THR A CA  1 
ATOM 5162  C C   . THR A 1 658 ? 270.993 -30.197 282.050 1.0 54.14437  ? 658 THR A C   658 THR A C   1 
ATOM 5163  O O   . THR A 1 658 ? 272.193 -29.935 282.166 1.0 54.14437  ? 658 THR A O   658 THR A O   1 
ATOM 5164  C CB  . THR A 1 658 ? 271.778 -32.388 281.193 1.0 54.14437  ? 658 THR A CB  658 THR A CB  1 
ATOM 5165  O OG1 . THR A 1 658 ? 272.216 -31.845 279.948 1.0 54.14437  ? 658 THR A OG1 658 THR A OG1 1 
ATOM 5166  C CG2 . THR A 1 658 ? 271.430 -33.841 280.998 1.0 54.14437  ? 658 THR A CG2 658 THR A CG2 1 
ATOM 5167  N N   . PHE A 1 659 ? 270.054 -29.275 282.223 1.0 53.18791  ? 659 PHE A N   659 PHE A N   1 
ATOM 5168  C CA  . PHE A 1 659 ? 270.416 -27.951 282.701 1.0 53.18791  ? 659 PHE A CA  659 PHE A CA  1 
ATOM 5169  C C   . PHE A 1 659 ? 270.635 -28.013 284.201 1.0 53.18791  ? 659 PHE A C   659 PHE A C   1 
ATOM 5170  O O   . PHE A 1 659 ? 269.885 -28.674 284.920 1.0 53.18791  ? 659 PHE A O   659 PHE A O   1 
ATOM 5171  C CB  . PHE A 1 659 ? 269.331 -26.926 282.377 1.0 53.18791  ? 659 PHE A CB  659 PHE A CB  1 
ATOM 5172  C CG  . PHE A 1 659 ? 269.147 -26.679 280.912 1.0 53.18791  ? 659 PHE A CG  659 PHE A CG  1 
ATOM 5173  C CD1 . PHE A 1 659 ? 270.062 -25.919 280.209 1.0 53.18791  ? 659 PHE A CD1 659 PHE A CD1 1 
ATOM 5174  C CD2 . PHE A 1 659 ? 268.038 -27.172 280.248 1.0 53.18791  ? 659 PHE A CD2 659 PHE A CD2 1 
ATOM 5175  C CE1 . PHE A 1 659 ? 269.893 -25.683 278.862 1.0 53.18791  ? 659 PHE A CE1 659 PHE A CE1 1 
ATOM 5176  C CE2 . PHE A 1 659 ? 267.865 -26.943 278.901 1.0 53.18791  ? 659 PHE A CE2 659 PHE A CE2 1 
ATOM 5177  C CZ  . PHE A 1 659 ? 268.793 -26.195 278.208 1.0 53.18791  ? 659 PHE A CZ  659 PHE A CZ  1 
ATOM 5178  N N   . TYR A 1 660 ? 271.679 -27.343 284.675 1.0 54.95389  ? 660 TYR A N   660 TYR A N   1 
ATOM 5179  C CA  . TYR A 1 660 ? 271.931 -27.322 286.109 1.0 54.95389  ? 660 TYR A CA  660 TYR A CA  1 
ATOM 5180  C C   . TYR A 1 660 ? 272.275 -25.948 286.652 1.0 54.95389  ? 660 TYR A C   660 TYR A C   1 
ATOM 5181  O O   . TYR A 1 660 ? 272.349 -25.797 287.874 1.0 54.95389  ? 660 TYR A O   660 TYR A O   1 
ATOM 5182  C CB  . TYR A 1 660 ? 273.046 -28.313 286.475 1.0 54.95389  ? 660 TYR A CB  660 TYR A CB  1 
ATOM 5183  C CG  . TYR A 1 660 ? 274.388 -28.025 285.855 1.0 54.95389  ? 660 TYR A CG  660 TYR A CG  1 
ATOM 5184  C CD1 . TYR A 1 660 ? 274.715 -28.520 284.601 1.0 54.95389  ? 660 TYR A CD1 660 TYR A CD1 1 
ATOM 5185  C CD2 . TYR A 1 660 ? 275.346 -27.294 286.538 1.0 54.95389  ? 660 TYR A CD2 660 TYR A CD2 1 
ATOM 5186  C CE1 . TYR A 1 660 ? 275.946 -28.267 284.032 1.0 54.95389  ? 660 TYR A CE1 660 TYR A CE1 1 
ATOM 5187  C CE2 . TYR A 1 660 ? 276.571 -27.039 285.981 1.0 54.95389  ? 660 TYR A CE2 660 TYR A CE2 1 
ATOM 5188  C CZ  . TYR A 1 660 ? 276.869 -27.526 284.729 1.0 54.95389  ? 660 TYR A CZ  660 TYR A CZ  1 
ATOM 5189  O OH  . TYR A 1 660 ? 278.099 -27.272 284.176 1.0 54.95389  ? 660 TYR A OH  660 TYR A OH  1 
ATOM 5190  N N   . LEU A 1 661 ? 272.486 -24.947 285.802 1.0 53.13995  ? 661 LEU A N   661 LEU A N   1 
ATOM 5191  C CA  . LEU A 1 661 ? 272.694 -23.576 286.234 1.0 53.13995  ? 661 LEU A CA  661 LEU A CA  1 
ATOM 5192  C C   . LEU A 1 661 ? 271.421 -22.755 286.140 1.0 53.13995  ? 661 LEU A C   661 LEU A C   1 
ATOM 5193  O O   . LEU A 1 661 ? 271.472 -21.580 285.771 1.0 53.13995  ? 661 LEU A O   661 LEU A O   1 
ATOM 5194  C CB  . LEU A 1 661 ? 273.799 -22.918 285.414 1.0 53.13995  ? 661 LEU A CB  661 LEU A CB  1 
ATOM 5195  C CG  . LEU A 1 661 ? 275.196 -23.484 285.609 1.0 53.13995  ? 661 LEU A CG  661 LEU A CG  1 
ATOM 5196  C CD1 . LEU A 1 661 ? 276.159 -22.792 284.676 1.0 53.13995  ? 661 LEU A CD1 661 LEU A CD1 1 
ATOM 5197  C CD2 . LEU A 1 661 ? 275.618 -23.303 287.042 1.0 53.13995  ? 661 LEU A CD2 661 LEU A CD2 1 
ATOM 5198  N N   . SER A 1 662 ? 270.274 -23.360 286.446 1.0 54.42273  ? 662 SER A N   662 SER A N   1 
ATOM 5199  C CA  . SER A 1 662 ? 269.015 -22.631 286.364 1.0 54.42273  ? 662 SER A CA  662 SER A CA  1 
ATOM 5200  C C   . SER A 1 662 ? 268.832 -21.702 287.556 1.0 54.42273  ? 662 SER A C   662 SER A C   1 
ATOM 5201  O O   . SER A 1 662 ? 267.925 -20.870 287.561 1.0 54.42273  ? 662 SER A O   662 SER A O   1 
ATOM 5202  C CB  . SER A 1 662 ? 267.847 -23.607 286.264 1.0 54.42273  ? 662 SER A CB  662 SER A CB  1 
ATOM 5203  O OG  . SER A 1 662 ? 267.902 -24.348 285.061 1.0 54.42273  ? 662 SER A OG  662 SER A OG  1 
ATOM 5204  N N   . HIS A 1 663 ? 269.655 -21.839 288.587 1.0 55.22647  ? 663 HIS A N   663 HIS A N   1 
ATOM 5205  C CA  . HIS A 1 663 ? 269.740 -20.775 289.572 1.0 55.22647  ? 663 HIS A CA  663 HIS A CA  1 
ATOM 5206  C C   . HIS A 1 663 ? 270.759 -19.743 289.099 1.0 55.22647  ? 663 HIS A C   663 HIS A C   1 
ATOM 5207  O O   . HIS A 1 663 ? 271.177 -19.762 287.939 1.0 55.22647  ? 663 HIS A O   663 HIS A O   1 
ATOM 5208  C CB  . HIS A 1 663 ? 270.053 -21.350 290.955 1.0 55.22647  ? 663 HIS A CB  663 HIS A CB  1 
ATOM 5209  C CG  . HIS A 1 663 ? 271.294 -22.184 291.016 1.0 55.22647  ? 663 HIS A CG  663 HIS A CG  1 
ATOM 5210  N ND1 . HIS A 1 663 ? 272.512 -21.679 291.414 1.0 55.22647  ? 663 HIS A ND1 663 HIS A ND1 1 
ATOM 5211  C CD2 . HIS A 1 663 ? 271.504 -23.492 290.738 1.0 55.22647  ? 663 HIS A CD2 663 HIS A CD2 1 
ATOM 5212  C CE1 . HIS A 1 663 ? 273.418 -22.638 291.376 1.0 55.22647  ? 663 HIS A CE1 663 HIS A CE1 1 
ATOM 5213  N NE2 . HIS A 1 663 ? 272.833 -23.749 290.967 1.0 55.22647  ? 663 HIS A NE2 663 HIS A NE2 1 
ATOM 5214  N N   . THR A 1 664 ? 271.144 -18.830 289.998 1.0 56.47361  ? 664 THR A N   664 THR A N   1 
ATOM 5215  C CA  . THR A 1 664 ? 271.958 -17.643 289.704 1.0 56.47361  ? 664 THR A CA  664 THR A CA  1 
ATOM 5216  C C   . THR A 1 664 ? 271.325 -16.766 288.625 1.0 56.47361  ? 664 THR A C   664 THR A C   1 
ATOM 5217  O O   . THR A 1 664 ? 271.886 -16.627 287.534 1.0 56.47361  ? 664 THR A O   664 THR A O   1 
ATOM 5218  C CB  . THR A 1 664 ? 273.399 -18.003 289.281 1.0 56.47361  ? 664 THR A CB  664 THR A CB  1 
ATOM 5219  O OG1 . THR A 1 664 ? 273.388 -18.671 288.015 1.0 56.47361  ? 664 THR A OG1 664 THR A OG1 1 
ATOM 5220  C CG2 . THR A 1 664 ? 274.056 -18.903 290.302 1.0 56.47361  ? 664 THR A CG2 664 THR A CG2 1 
ATOM 5221  N N   . PHE A 1 665 ? 270.151 -16.199 288.896 1.0 54.85219  ? 665 PHE A N   665 PHE A N   1 
ATOM 5222  C CA  . PHE A 1 665 ? 269.471 -15.303 287.959 1.0 54.85219  ? 665 PHE A CA  665 PHE A CA  1 
ATOM 5223  C C   . PHE A 1 665 ? 268.820 -14.122 288.663 1.0 54.85219  ? 665 PHE A C   665 PHE A C   1 
ATOM 5224  O O   . PHE A 1 665 ? 267.632 -13.872 288.466 1.0 54.85219  ? 665 PHE A O   665 PHE A O   1 
ATOM 5225  C CB  . PHE A 1 665 ? 268.409 -16.018 287.136 1.0 54.85219  ? 665 PHE A CB  665 PHE A CB  1 
ATOM 5226  C CG  . PHE A 1 665 ? 268.962 -16.872 286.067 1.0 54.85219  ? 665 PHE A CG  665 PHE A CG  1 
ATOM 5227  C CD1 . PHE A 1 665 ? 269.457 -16.313 284.907 1.0 54.85219  ? 665 PHE A CD1 665 PHE A CD1 1 
ATOM 5228  C CD2 . PHE A 1 665 ? 268.962 -18.236 286.206 1.0 54.85219  ? 665 PHE A CD2 665 PHE A CD2 1 
ATOM 5229  C CE1 . PHE A 1 665 ? 269.966 -17.109 283.918 1.0 54.85219  ? 665 PHE A CE1 665 PHE A CE1 1 
ATOM 5230  C CE2 . PHE A 1 665 ? 269.462 -19.040 285.223 1.0 54.85219  ? 665 PHE A CE2 665 PHE A CE2 1 
ATOM 5231  C CZ  . PHE A 1 665 ? 269.965 -18.471 284.084 1.0 54.85219  ? 665 PHE A CZ  665 PHE A CZ  1 
ATOM 5232  N N   . GLN A 1 666 ? 269.603 -13.396 289.479 1.0 58.22023  ? 666 GLN A N   666 GLN A N   1 
ATOM 5233  C CA  . GLN A 1 666 ? 269.139 -12.370 290.426 1.0 58.22023  ? 666 GLN A CA  666 GLN A CA  1 
ATOM 5234  C C   . GLN A 1 666 ? 268.019 -11.440 289.951 1.0 58.22023  ? 666 GLN A C   666 GLN A C   1 
ATOM 5235  O O   . GLN A 1 666 ? 267.023 -11.253 290.654 1.0 58.22023  ? 666 GLN A O   666 GLN A O   1 
ATOM 5236  C CB  . GLN A 1 666 ? 270.333 -11.516 290.848 1.0 58.22023  ? 666 GLN A CB  666 GLN A CB  1 
ATOM 5237  C CG  . GLN A 1 666 ? 271.341 -12.220 291.714 1.0 58.22023  ? 666 GLN A CG  666 GLN A CG  1 
ATOM 5238  C CD  . GLN A 1 666 ? 272.492 -11.315 292.066 1.0 58.22023  ? 666 GLN A CD  666 GLN A CD  1 
ATOM 5239  O OE1 . GLN A 1 666 ? 272.565 -10.183 291.594 1.0 58.22023  ? 666 GLN A OE1 666 GLN A OE1 1 
ATOM 5240  N NE2 . GLN A 1 666 ? 273.400 -11.803 292.901 1.0 58.22023  ? 666 GLN A NE2 666 GLN A NE2 1 
ATOM 5241  N N   . ARG A 1 667 ? 268.146 -10.869 288.754 1.0 58.87877  ? 667 ARG A N   667 ARG A N   1 
ATOM 5242  C CA  . ARG A 1 667 ? 267.114 -9.988  288.219 1.0 58.87877  ? 667 ARG A CA  667 ARG A CA  1 
ATOM 5243  C C   . ARG A 1 667 ? 266.902 -10.271 286.740 1.0 58.87877  ? 667 ARG A C   667 ARG A C   1 
ATOM 5244  O O   . ARG A 1 667 ? 267.661 -11.009 286.109 1.0 58.87877  ? 667 ARG A O   667 ARG A O   1 
ATOM 5245  C CB  . ARG A 1 667 ? 267.458 -8.504  288.418 1.0 58.87877  ? 667 ARG A CB  667 ARG A CB  1 
ATOM 5246  C CG  . ARG A 1 667 ? 267.431 -8.031  289.862 1.0 58.87877  ? 667 ARG A CG  667 ARG A CG  1 
ATOM 5247  C CD  . ARG A 1 667 ? 267.850 -6.583  290.004 1.0 58.87877  ? 667 ARG A CD  667 ARG A CD  1 
ATOM 5248  N NE  . ARG A 1 667 ? 266.877 -5.659  289.435 1.0 58.87877  ? 667 ARG A NE  667 ARG A NE  1 
ATOM 5249  C CZ  . ARG A 1 667 ? 267.081 -4.953  288.329 1.0 58.87877  ? 667 ARG A CZ  667 ARG A CZ  1 
ATOM 5250  N NH1 . ARG A 1 667 ? 268.222 -5.073  287.666 1.0 58.87877  ? 667 ARG A NH1 667 ARG A NH1 1 
ATOM 5251  N NH2 . ARG A 1 667 ? 266.146 -4.128  287.883 1.0 58.87877  ? 667 ARG A NH2 667 ARG A NH2 1 
ATOM 5252  N N   . CYS A 1 668 ? 265.853 -9.653  286.196 1.0 57.36978  ? 668 CYS A N   668 CYS A N   1 
ATOM 5253  C CA  . CYS A 1 668 ? 265.475 -9.739  284.788 1.0 57.36978  ? 668 CYS A CA  668 CYS A CA  1 
ATOM 5254  C C   . CYS A 1 668 ? 264.477 -8.639  284.451 1.0 57.36978  ? 668 CYS A C   668 CYS A C   1 
ATOM 5255  O O   . CYS A 1 668 ? 263.470 -8.493  285.147 1.0 57.36978  ? 668 CYS A O   668 CYS A O   1 
ATOM 5256  C CB  . CYS A 1 668 ? 264.863 -11.102 284.469 1.0 57.36978  ? 668 CYS A CB  668 CYS A CB  1 
ATOM 5257  S SG  . CYS A 1 668 ? 264.236 -11.247 282.794 1.0 57.36978  ? 668 CYS A SG  668 CYS A SG  1 
ATOM 5258  N N   . SER A 1 669 ? 264.720 -7.868  283.393 1.0 54.01807  ? 669 SER A N   669 SER A N   1 
ATOM 5259  C CA  . SER A 1 669 ? 263.814 -6.780  283.043 1.0 54.01807  ? 669 SER A CA  669 SER A CA  1 
ATOM 5260  C C   . SER A 1 669 ? 263.612 -6.735  281.538 1.0 54.01807  ? 669 SER A C   669 SER A C   1 
ATOM 5261  O O   . SER A 1 669 ? 264.582 -6.752  280.780 1.0 54.01807  ? 669 SER A O   669 SER A O   1 
ATOM 5262  C CB  . SER A 1 669 ? 264.345 -5.431  283.536 1.0 54.01807  ? 669 SER A CB  669 SER A CB  1 
ATOM 5263  O OG  . SER A 1 669 ? 265.503 -5.047  282.824 1.0 54.01807  ? 669 SER A OG  669 SER A OG  1 
ATOM 5264  N N   . ILE A 1 670 ? 262.355 -6.661  281.114 1.0 51.71754  ? 670 ILE A N   670 ILE A N   1 
ATOM 5265  C CA  . ILE A 1 670 ? 261.989 -6.616  279.705 1.0 51.71754  ? 670 ILE A CA  670 ILE A CA  1 
ATOM 5266  C C   . ILE A 1 670 ? 261.420 -5.238  279.405 1.0 51.71754  ? 670 ILE A C   670 ILE A C   1 
ATOM 5267  O O   . ILE A 1 670 ? 260.580 -4.726  280.153 1.0 51.71754  ? 670 ILE A O   670 ILE A O   1 
ATOM 5268  C CB  . ILE A 1 670 ? 260.978 -7.728  279.368 1.0 51.71754  ? 670 ILE A CB  670 ILE A CB  1 
ATOM 5269  C CG1 . ILE A 1 670 ? 261.574 -9.086  279.717 1.0 51.71754  ? 670 ILE A CG1 670 ILE A CG1 1 
ATOM 5270  C CG2 . ILE A 1 670 ? 260.609 -7.708  277.901 1.0 51.71754  ? 670 ILE A CG2 670 ILE A CG2 1 
ATOM 5271  C CD1 . ILE A 1 670 ? 260.592 -10.210 279.656 1.0 51.71754  ? 670 ILE A CD1 670 ILE A CD1 1 
ATOM 5272  N N   . GLN A 1 671 ? 261.867 -4.644  278.302 1.0 54.64598  ? 671 GLN A N   671 GLN A N   1 
ATOM 5273  C CA  . GLN A 1 671 ? 261.608 -3.242  278.015 1.0 54.64598  ? 671 GLN A CA  671 GLN A CA  1 
ATOM 5274  C C   . GLN A 1 671 ? 261.567 -3.076  276.505 1.0 54.64598  ? 671 GLN A C   671 GLN A C   1 
ATOM 5275  O O   . GLN A 1 671 ? 262.501 -3.499  275.821 1.0 54.64598  ? 671 GLN A O   671 GLN A O   1 
ATOM 5276  C CB  . GLN A 1 671 ? 262.710 -2.389  278.642 1.0 54.64598  ? 671 GLN A CB  671 GLN A CB  1 
ATOM 5277  C CG  . GLN A 1 671 ? 262.513 -0.905  278.620 1.0 54.64598  ? 671 GLN A CG  671 GLN A CG  1 
ATOM 5278  C CD  . GLN A 1 671 ? 263.645 -0.202  279.338 1.0 54.64598  ? 671 GLN A CD  671 GLN A CD  1 
ATOM 5279  O OE1 . GLN A 1 671 ? 264.593 -0.843  279.789 1.0 54.64598  ? 671 GLN A OE1 671 GLN A OE1 1 
ATOM 5280  N NE2 . GLN A 1 671 ? 263.550 1.114   279.457 1.0 54.64598  ? 671 GLN A NE2 671 GLN A NE2 1 
ATOM 5281  N N   . TRP A 1 672 ? 260.498 -2.473  275.981 1.0 53.05395  ? 672 TRP A N   672 TRP A N   1 
ATOM 5282  C CA  . TRP A 1 672 ? 260.269 -2.560  274.540 1.0 53.05395  ? 672 TRP A CA  672 TRP A CA  1 
ATOM 5283  C C   . TRP A 1 672 ? 261.114 -1.566  273.750 1.0 53.05395  ? 672 TRP A C   672 TRP A C   1 
ATOM 5284  O O   . TRP A 1 672 ? 262.005 -1.961  272.995 1.0 53.05395  ? 672 TRP A O   672 TRP A O   1 
ATOM 5285  C CB  . TRP A 1 672 ? 258.788 -2.363  274.217 1.0 53.05395  ? 672 TRP A CB  672 TRP A CB  1 
ATOM 5286  C CG  . TRP A 1 672 ? 257.931 -3.500  274.648 1.0 53.05395  ? 672 TRP A CG  672 TRP A CG  1 
ATOM 5287  C CD1 . TRP A 1 672 ? 257.115 -3.539  275.732 1.0 53.05395  ? 672 TRP A CD1 672 TRP A CD1 1 
ATOM 5288  C CD2 . TRP A 1 672 ? 257.827 -4.782  274.021 1.0 53.05395  ? 672 TRP A CD2 672 TRP A CD2 1 
ATOM 5289  N NE1 . TRP A 1 672 ? 256.492 -4.758  275.814 1.0 53.05395  ? 672 TRP A NE1 672 TRP A NE1 1 
ATOM 5290  C CE2 . TRP A 1 672 ? 256.917 -5.540  274.775 1.0 53.05395  ? 672 TRP A CE2 672 TRP A CE2 1 
ATOM 5291  C CE3 . TRP A 1 672 ? 258.412 -5.359  272.894 1.0 53.05395  ? 672 TRP A CE3 672 TRP A CE3 1 
ATOM 5292  C CZ2 . TRP A 1 672 ? 256.577 -6.845  274.438 1.0 53.05395  ? 672 TRP A CZ2 672 TRP A CZ2 1 
ATOM 5293  C CZ3 . TRP A 1 672 ? 258.073 -6.654  272.561 1.0 53.05395  ? 672 TRP A CZ3 672 TRP A CZ3 1 
ATOM 5294  C CH2 . TRP A 1 672 ? 257.165 -7.382  273.330 1.0 53.05395  ? 672 TRP A CH2 672 TRP A CH2 1 
ATOM 5295  N N   . ASP A 1 673 ? 260.874 -0.275  273.916 1.0 55.58705  ? 673 ASP A N   673 ASP A N   1 
ATOM 5296  C CA  . ASP A 1 673 ? 261.519 0.726   273.074 1.0 55.58705  ? 673 ASP A CA  673 ASP A CA  1 
ATOM 5297  C C   . ASP A 1 673 ? 262.408 1.646   273.894 1.0 55.58705  ? 673 ASP A C   673 ASP A C   1 
ATOM 5298  O O   . ASP A 1 673 ? 262.400 2.865   273.705 1.0 55.58705  ? 673 ASP A O   673 ASP A O   1 
ATOM 5299  C CB  . ASP A 1 673 ? 260.482 1.533   272.301 1.0 55.58705  ? 673 ASP A CB  673 ASP A CB  1 
ATOM 5300  C CG  . ASP A 1 673 ? 259.789 0.716   271.236 1.0 55.58705  ? 673 ASP A CG  673 ASP A CG  1 
ATOM 5301  O OD1 . ASP A 1 673 ? 260.413 -0.231  270.713 1.0 55.58705  ? 673 ASP A OD1 673 ASP A OD1 1 
ATOM 5302  O OD2 . ASP A 1 673 ? 258.620 1.020   270.919 1.0 55.58705  ? 673 ASP A OD2 673 ASP A OD2 1 
ATOM 5303  N N   . SER A 1 674 ? 263.189 1.052   274.808 1.0 57.55517  ? 674 SER A N   674 SER A N   1 
ATOM 5304  C CA  . SER A 1 674 ? 263.889 1.753   275.897 1.0 57.55517  ? 674 SER A CA  674 SER A CA  1 
ATOM 5305  C C   . SER A 1 674 ? 262.917 2.612   276.705 1.0 57.55517  ? 674 SER A C   674 SER A C   1 
ATOM 5306  O O   . SER A 1 674 ? 263.250 3.699   277.181 1.0 57.55517  ? 674 SER A O   674 SER A O   1 
ATOM 5307  C CB  . SER A 1 674 ? 265.079 2.576   275.388 1.0 57.55517  ? 674 SER A CB  674 SER A CB  1 
ATOM 5308  O OG  . SER A 1 674 ? 264.660 3.674   274.596 1.0 57.55517  ? 674 SER A OG  674 SER A OG  1 
ATOM 5309  N N   . SER A 1 675 ? 261.711 2.082   276.873 1.0 56.28418  ? 675 SER A N   675 SER A N   1 
ATOM 5310  C CA  . SER A 1 675 ? 260.538 2.663   277.507 1.0 56.28418  ? 675 SER A CA  675 SER A CA  1 
ATOM 5311  C C   . SER A 1 675 ? 259.488 1.567   277.435 1.0 56.28418  ? 675 SER A C   675 SER A C   1 
ATOM 5312  O O   . SER A 1 675 ? 259.671 0.572   276.726 1.0 56.28418  ? 675 SER A O   675 SER A O   1 
ATOM 5313  C CB  . SER A 1 675 ? 260.039 3.934   276.819 1.0 56.28418  ? 675 SER A CB  675 SER A CB  1 
ATOM 5314  O OG  . SER A 1 675 ? 258.862 4.422   277.440 1.0 56.28418  ? 675 SER A OG  675 SER A OG  1 
ATOM 5315  N N   . VAL A 1 676 ? 258.383 1.776   278.151 1.0 54.42705  ? 676 VAL A N   676 VAL A N   1 
ATOM 5316  C CA  . VAL A 1 676 ? 257.236 0.865   278.244 1.0 54.42705  ? 676 VAL A CA  676 VAL A CA  1 
ATOM 5317  C C   . VAL A 1 676 ? 257.724 -0.491  278.744 1.0 54.42705  ? 676 VAL A C   676 VAL A C   1 
ATOM 5318  O O   . VAL A 1 676 ? 257.943 -1.401  277.931 1.0 54.42705  ? 676 VAL A O   676 VAL A O   1 
ATOM 5319  C CB  . VAL A 1 676 ? 256.473 0.745   276.907 1.0 54.42705  ? 676 VAL A CB  676 VAL A CB  1 
ATOM 5320  C CG1 . VAL A 1 676 ? 255.172 -0.053  277.079 1.0 54.42705  ? 676 VAL A CG1 676 VAL A CG1 1 
ATOM 5321  C CG2 . VAL A 1 676 ? 256.184 2.110   276.313 1.0 54.42705  ? 676 VAL A CG2 676 VAL A CG2 1 
ATOM 5322  N N   . PRO A 1 677 ? 258.024 -0.642  280.031 1.0 54.18859  ? 677 PRO A N   677 PRO A N   1 
ATOM 5323  C CA  . PRO A 1 677 ? 258.458 -1.949  280.527 1.0 54.18859  ? 677 PRO A CA  677 PRO A CA  1 
ATOM 5324  C C   . PRO A 1 677 ? 257.332 -2.964  280.449 1.0 54.18859  ? 677 PRO A C   677 PRO A C   1 
ATOM 5325  O O   . PRO A 1 677 ? 256.150 -2.621  280.500 1.0 54.18859  ? 677 PRO A O   677 PRO A O   1 
ATOM 5326  C CB  . PRO A 1 677 ? 258.850 -1.665  281.978 1.0 54.18859  ? 677 PRO A CB  677 PRO A CB  1 
ATOM 5327  C CG  . PRO A 1 677 ? 258.014 -0.513  282.356 1.0 54.18859  ? 677 PRO A CG  677 PRO A CG  1 
ATOM 5328  C CD  . PRO A 1 677 ? 257.886 0.333   281.124 1.0 54.18859  ? 677 PRO A CD  677 PRO A CD  1 
ATOM 5329  N N   . TRP A 1 678 ? 257.712 -4.222  280.289 1.0 52.6415   ? 678 TRP A N   678 TRP A N   1 
ATOM 5330  C CA  . TRP A 1 678 ? 256.732 -5.282  280.170 1.0 52.6415   ? 678 TRP A CA  678 TRP A CA  1 
ATOM 5331  C C   . TRP A 1 678 ? 256.741 -6.126  281.431 1.0 52.6415   ? 678 TRP A C   678 TRP A C   1 
ATOM 5332  O O   . TRP A 1 678 ? 257.825 -6.498  281.897 1.0 52.6415   ? 678 TRP A O   678 TRP A O   1 
ATOM 5333  C CB  . TRP A 1 678 ? 257.029 -6.161  278.961 1.0 52.6415   ? 678 TRP A CB  678 TRP A CB  1 
ATOM 5334  C CG  . TRP A 1 678 ? 255.996 -7.198  278.750 1.0 52.6415   ? 678 TRP A CG  678 TRP A CG  1 
ATOM 5335  C CD1 . TRP A 1 678 ? 254.757 -7.024  278.222 1.0 52.6415   ? 678 TRP A CD1 678 TRP A CD1 1 
ATOM 5336  C CD2 . TRP A 1 678 ? 256.077 -8.566  279.141 1.0 52.6415   ? 678 TRP A CD2 678 TRP A CD2 1 
ATOM 5337  N NE1 . TRP A 1 678 ? 254.074 -8.213  278.217 1.0 52.6415   ? 678 TRP A NE1 678 TRP A NE1 1 
ATOM 5338  C CE2 . TRP A 1 678 ? 254.865 -9.177  278.781 1.0 52.6415   ? 678 TRP A CE2 678 TRP A CE2 1 
ATOM 5339  C CE3 . TRP A 1 678 ? 257.068 -9.339  279.742 1.0 52.6415   ? 678 TRP A CE3 678 TRP A CE3 1 
ATOM 5340  C CZ2 . TRP A 1 678 ? 254.619 -10.525 279.004 1.0 52.6415   ? 678 TRP A CZ2 678 TRP A CZ2 1 
ATOM 5341  C CZ3 . TRP A 1 678 ? 256.823 -10.669 279.963 1.0 52.6415   ? 678 TRP A CZ3 678 TRP A CZ3 1 
ATOM 5342  C CH2 . TRP A 1 678 ? 255.610 -11.252 279.597 1.0 52.6415   ? 678 TRP A CH2 678 TRP A CH2 1 
ATOM 5343  N N   . PRO A 1 679 ? 255.581 -6.460  282.022 1.0 54.44681  ? 679 PRO A N   679 PRO A N   1 
ATOM 5344  C CA  . PRO A 1 679 ? 254.208 -6.106  281.644 1.0 54.44681  ? 679 PRO A CA  679 PRO A CA  1 
ATOM 5345  C C   . PRO A 1 679 ? 253.847 -4.662  281.979 1.0 54.44681  ? 679 PRO A C   679 PRO A C   1 
ATOM 5346  O O   . PRO A 1 679 ? 253.040 -4.059  281.276 1.0 54.44681  ? 679 PRO A O   679 PRO A O   1 
ATOM 5347  C CB  . PRO A 1 679 ? 253.362 -7.084  282.459 1.0 54.44681  ? 679 PRO A CB  679 PRO A CB  1 
ATOM 5348  C CG  . PRO A 1 679 ? 254.190 -7.406  283.633 1.0 54.44681  ? 679 PRO A CG  679 PRO A CG  1 
ATOM 5349  C CD  . PRO A 1 679 ? 255.608 -7.388  283.163 1.0 54.44681  ? 679 PRO A CD  679 PRO A CD  1 
ATOM 5350  N N   . GLY A 1 680 ? 254.436 -4.124  283.045 1.0 57.5261   ? 680 GLY A N   680 GLY A N   1 
ATOM 5351  C CA  . GLY A 1 680 ? 254.421 -2.701  283.312 1.0 57.5261   ? 680 GLY A CA  680 GLY A CA  1 
ATOM 5352  C C   . GLY A 1 680 ? 253.092 -2.094  283.697 1.0 57.5261   ? 680 GLY A C   680 GLY A C   1 
ATOM 5353  O O   . GLY A 1 680 ? 253.036 -0.882  283.926 1.0 57.5261   ? 680 GLY A O   680 GLY A O   1 
ATOM 5354  N N   . ASN A 1 681 ? 252.022 -2.880  283.787 1.0 57.24112  ? 681 ASN A N   681 ASN A N   1 
ATOM 5355  C CA  . ASN A 1 681 ? 250.731 -2.374  284.229 1.0 57.24112  ? 681 ASN A CA  681 ASN A CA  1 
ATOM 5356  C C   . ASN A 1 681 ? 250.519 -2.588  285.714 1.0 57.24112  ? 681 ASN A C   681 ASN A C   1 
ATOM 5357  O O   . ASN A 1 681 ? 249.385 -2.846  286.138 1.0 57.24112  ? 681 ASN A O   681 ASN A O   1 
ATOM 5358  C CB  . ASN A 1 681 ? 249.605 -3.025  283.428 1.0 57.24112  ? 681 ASN A CB  681 ASN A CB  1 
ATOM 5359  C CG  . ASN A 1 681 ? 249.569 -2.556  281.994 1.0 57.24112  ? 681 ASN A CG  681 ASN A CG  1 
ATOM 5360  O OD1 . ASN A 1 681 ? 249.761 -1.377  281.712 1.0 57.24112  ? 681 ASN A OD1 681 ASN A OD1 1 
ATOM 5361  N ND2 . ASN A 1 681 ? 249.311 -3.477  281.077 1.0 57.24112  ? 681 ASN A ND2 681 ASN A ND2 1 
ATOM 5362  N N   . ASP A 1 682 ? 251.596 -2.490  286.498 1.0 60.31973  ? 682 ASP A N   682 ASP A N   1 
ATOM 5363  C CA  . ASP A 1 682 ? 251.640 -2.829  287.920 1.0 60.31973  ? 682 ASP A CA  682 ASP A CA  1 
ATOM 5364  C C   . ASP A 1 682 ? 251.140 -4.249  288.164 1.0 60.31973  ? 682 ASP A C   682 ASP A C   1 
ATOM 5365  O O   . ASP A 1 682 ? 250.348 -4.505  289.065 1.0 60.31973  ? 682 ASP A O   682 ASP A O   1 
ATOM 5366  C CB  . ASP A 1 682 ? 250.865 -1.817  288.768 1.0 60.31973  ? 682 ASP A CB  682 ASP A CB  1 
ATOM 5367  C CG  . ASP A 1 682 ? 251.558 -0.475  288.847 1.0 60.31973  ? 682 ASP A CG  682 ASP A CG  1 
ATOM 5368  O OD1 . ASP A 1 682 ? 252.801 -0.445  288.748 1.0 60.31973  ? 682 ASP A OD1 682 ASP A OD1 1 
ATOM 5369  O OD2 . ASP A 1 682 ? 250.863 0.551   289.011 1.0 60.31973  ? 682 ASP A OD2 682 ASP A OD2 1 
ATOM 5370  N N   . ARG A 1 683 ? 251.616 -5.183  287.346 1.0 56.58333  ? 683 ARG A N   683 ARG A N   1 
ATOM 5371  C CA  . ARG A 1 683 ? 251.179 -6.566  287.478 1.0 56.58333  ? 683 ARG A CA  683 ARG A CA  1 
ATOM 5372  C C   . ARG A 1 683 ? 251.922 -7.308  288.577 1.0 56.58333  ? 683 ARG A C   683 ARG A C   1 
ATOM 5373  O O   . ARG A 1 683 ? 251.303 -8.034  289.360 1.0 56.58333  ? 683 ARG A O   683 ARG A O   1 
ATOM 5374  C CB  . ARG A 1 683 ? 251.361 -7.310  286.156 1.0 56.58333  ? 683 ARG A CB  683 ARG A CB  1 
ATOM 5375  C CG  . ARG A 1 683 ? 250.567 -6.741  285.012 1.0 56.58333  ? 683 ARG A CG  683 ARG A CG  1 
ATOM 5376  C CD  . ARG A 1 683 ? 249.091 -6.922  285.231 1.0 56.58333  ? 683 ARG A CD  683 ARG A CD  1 
ATOM 5377  N NE  . ARG A 1 683 ? 248.330 -6.468  284.078 1.0 56.58333  ? 683 ARG A NE  683 ARG A NE  1 
ATOM 5378  C CZ  . ARG A 1 683 ? 247.008 -6.404  284.045 1.0 56.58333  ? 683 ARG A CZ  683 ARG A CZ  1 
ATOM 5379  N NH1 . ARG A 1 683 ? 246.307 -6.758  285.109 1.0 56.58333  ? 683 ARG A NH1 683 ARG A NH1 1 
ATOM 5380  N NH2 . ARG A 1 683 ? 246.387 -5.983  282.955 1.0 56.58333  ? 683 ARG A NH2 683 ARG A NH2 1 
ATOM 5381  N N   . MET A 1 684 ? 253.238 -7.141  288.650 1.0 61.27138  ? 684 MET A N   684 MET A N   1 
ATOM 5382  C CA  . MET A 1 684 ? 254.070 -7.904  289.563 1.0 61.27138  ? 684 MET A CA  684 MET A CA  1 
ATOM 5383  C C   . MET A 1 684 ? 254.109 -7.212  290.924 1.0 61.27138  ? 684 MET A C   684 MET A C   1 
ATOM 5384  O O   . MET A 1 684 ? 253.506 -6.157  291.127 1.0 61.27138  ? 684 MET A O   684 MET A O   1 
ATOM 5385  C CB  . MET A 1 684 ? 255.472 -8.052  288.979 1.0 61.27138  ? 684 MET A CB  684 MET A CB  1 
ATOM 5386  C CG  . MET A 1 684 ? 255.488 -8.637  287.574 1.0 61.27138  ? 684 MET A CG  684 MET A CG  1 
ATOM 5387  S SD  . MET A 1 684 ? 254.891 -10.328 287.451 1.0 61.27138  ? 684 MET A SD  684 MET A SD  1 
ATOM 5388  C CE  . MET A 1 684 ? 256.280 -11.191 288.139 1.0 61.27138  ? 684 MET A CE  684 MET A CE  1 
ATOM 5389  N N   . LEU A 1 685 ? 254.827 -7.811  291.875 1.0 61.48445  ? 685 LEU A N   685 LEU A N   1 
ATOM 5390  C CA  . LEU A 1 685 ? 255.048 -7.151  293.159 1.0 61.48445  ? 685 LEU A CA  685 LEU A CA  1 
ATOM 5391  C C   . LEU A 1 685 ? 255.998 -5.971  293.001 1.0 61.48445  ? 685 LEU A C   685 LEU A C   1 
ATOM 5392  O O   . LEU A 1 685 ? 255.684 -4.844  293.399 1.0 61.48445  ? 685 LEU A O   685 LEU A O   1 
ATOM 5393  C CB  . LEU A 1 685 ? 255.590 -8.144  294.187 1.0 61.48445  ? 685 LEU A CB  685 LEU A CB  1 
ATOM 5394  C CG  . LEU A 1 685 ? 254.611 -8.927  295.069 1.0 61.48445  ? 685 LEU A CG  685 LEU A CG  1 
ATOM 5395  C CD1 . LEU A 1 685 ? 253.769 -7.967  295.900 1.0 61.48445  ? 685 LEU A CD1 685 LEU A CD1 1 
ATOM 5396  C CD2 . LEU A 1 685 ? 253.741 -9.899  294.291 1.0 61.48445  ? 685 LEU A CD2 685 LEU A CD2 1 
ATOM 5397  N N   . THR A 1 686 ? 257.179 -6.218  292.436 1.0 64.92447  ? 686 THR A N   686 THR A N   1 
ATOM 5398  C CA  . THR A 1 686 ? 258.053 -5.158  291.959 1.0 64.92447  ? 686 THR A CA  686 THR A CA  1 
ATOM 5399  C C   . THR A 1 686 ? 257.750 -4.970  290.483 1.0 64.92447  ? 686 THR A C   686 THR A C   1 
ATOM 5400  O O   . THR A 1 686 ? 258.216 -5.765  289.655 1.0 64.92447  ? 686 THR A O   686 THR A O   1 
ATOM 5401  C CB  . THR A 1 686 ? 259.524 -5.518  292.169 1.0 64.92447  ? 686 THR A CB  686 THR A CB  1 
ATOM 5402  O OG1 . THR A 1 686 ? 259.829 -6.711  291.439 1.0 64.92447  ? 686 THR A OG1 686 THR A OG1 1 
ATOM 5403  C CG2 . THR A 1 686 ? 259.805 -5.751  293.640 1.0 64.92447  ? 686 THR A CG2 686 THR A CG2 1 
ATOM 5404  N N   . PRO A 1 687 ? 256.982 -3.947  290.097 1.0 65.71325  ? 687 PRO A N   687 PRO A N   1 
ATOM 5405  C CA  . PRO A 1 687 ? 256.325 -3.964  288.782 1.0 65.71325  ? 687 PRO A CA  687 PRO A CA  1 
ATOM 5406  C C   . PRO A 1 687 ? 257.223 -3.649  287.600 1.0 65.71325  ? 687 PRO A C   687 PRO A C   1 
ATOM 5407  O O   . PRO A 1 687 ? 256.761 -3.765  286.458 1.0 65.71325  ? 687 PRO A O   687 PRO A O   1 
ATOM 5408  C CB  . PRO A 1 687 ? 255.240 -2.893  288.930 1.0 65.71325  ? 687 PRO A CB  687 PRO A CB  1 
ATOM 5409  C CG  . PRO A 1 687 ? 255.790 -1.952  289.928 1.0 65.71325  ? 687 PRO A CG  687 PRO A CG  1 
ATOM 5410  C CD  . PRO A 1 687 ? 256.586 -2.778  290.898 1.0 65.71325  ? 687 PRO A CD  687 PRO A CD  1 
ATOM 5411  N N   . ASN A 1 688 ? 258.475 -3.260  287.819 1.0 65.36901  ? 688 ASN A N   688 ASN A N   1 
ATOM 5412  C CA  . ASN A 1 688 ? 259.329 -2.911  286.693 1.0 65.36901  ? 688 ASN A CA  688 ASN A CA  1 
ATOM 5413  C C   . ASN A 1 688 ? 260.105 -4.104  286.152 1.0 65.36901  ? 688 ASN A C   688 ASN A C   1 
ATOM 5414  O O   . ASN A 1 688 ? 260.197 -4.276  284.933 1.0 65.36901  ? 688 ASN A O   688 ASN A O   1 
ATOM 5415  C CB  . ASN A 1 688 ? 260.296 -1.799  287.095 1.0 65.36901  ? 688 ASN A CB  688 ASN A CB  1 
ATOM 5416  C CG  . ASN A 1 688 ? 259.586 -0.513  287.440 1.0 65.36901  ? 688 ASN A CG  688 ASN A CG  1 
ATOM 5417  O OD1 . ASN A 1 688 ? 259.603 -0.069  288.587 1.0 65.36901  ? 688 ASN A OD1 688 ASN A OD1 1 
ATOM 5418  N ND2 . ASN A 1 688 ? 258.955 0.097   286.445 1.0 65.36901  ? 688 ASN A ND2 688 ASN A ND2 1 
ATOM 5419  N N   . TRP A 1 689 ? 260.663 -4.937  287.026 1.0 61.59695  ? 689 TRP A N   689 TRP A N   1 
ATOM 5420  C CA  . TRP A 1 689 ? 261.509 -6.042  286.606 1.0 61.59695  ? 689 TRP A CA  689 TRP A CA  1 
ATOM 5421  C C   . TRP A 1 689 ? 261.008 -7.347  287.207 1.0 61.59695  ? 689 TRP A C   689 TRP A C   1 
ATOM 5422  O O   . TRP A 1 689 ? 260.255 -7.360  288.181 1.0 61.59695  ? 689 TRP A O   689 TRP A O   1 
ATOM 5423  C CB  . TRP A 1 689 ? 262.973 -5.804  287.002 1.0 61.59695  ? 689 TRP A CB  689 TRP A CB  1 
ATOM 5424  C CG  . TRP A 1 689 ? 263.196 -5.658  288.468 1.0 61.59695  ? 689 TRP A CG  689 TRP A CG  1 
ATOM 5425  C CD1 . TRP A 1 689 ? 263.420 -6.656  289.364 1.0 61.59695  ? 689 TRP A CD1 689 TRP A CD1 1 
ATOM 5426  C CD2 . TRP A 1 689 ? 263.235 -4.438  289.210 1.0 61.59695  ? 689 TRP A CD2 689 TRP A CD2 1 
ATOM 5427  N NE1 . TRP A 1 689 ? 263.584 -6.136  290.622 1.0 61.59695  ? 689 TRP A NE1 689 TRP A NE1 1 
ATOM 5428  C CE2 . TRP A 1 689 ? 263.478 -4.774  290.554 1.0 61.59695  ? 689 TRP A CE2 689 TRP A CE2 1 
ATOM 5429  C CE3 . TRP A 1 689 ? 263.092 -3.093  288.868 1.0 61.59695  ? 689 TRP A CE3 689 TRP A CE3 1 
ATOM 5430  C CZ2 . TRP A 1 689 ? 263.573 -3.815  291.556 1.0 61.59695  ? 689 TRP A CZ2 689 TRP A CZ2 1 
ATOM 5431  C CZ3 . TRP A 1 689 ? 263.183 -2.143  289.863 1.0 61.59695  ? 689 TRP A CZ3 689 TRP A CZ3 1 
ATOM 5432  C CH2 . TRP A 1 689 ? 263.424 -2.507  291.191 1.0 61.59695  ? 689 TRP A CH2 689 TRP A CH2 1 
ATOM 5433  N N   . PHE A 1 690 ? 261.436 -8.454  286.604 1.0 57.28405  ? 690 PHE A N   690 PHE A N   1 
ATOM 5434  C CA  . PHE A 1 690 ? 261.151 -9.792  287.119 1.0 57.28405  ? 690 PHE A CA  690 PHE A CA  1 
ATOM 5435  C C   . PHE A 1 690 ? 262.262 -10.157 288.088 1.0 57.28405  ? 690 PHE A C   690 PHE A C   1 
ATOM 5436  O O   . PHE A 1 690 ? 263.281 -10.726 287.705 1.0 57.28405  ? 690 PHE A O   690 PHE A O   1 
ATOM 5437  C CB  . PHE A 1 690 ? 261.073 -10.809 285.989 1.0 57.28405  ? 690 PHE A CB  690 PHE A CB  1 
ATOM 5438  C CG  . PHE A 1 690 ? 259.900 -10.629 285.083 1.0 57.28405  ? 690 PHE A CG  690 PHE A CG  1 
ATOM 5439  C CD1 . PHE A 1 690 ? 258.669 -11.159 285.414 1.0 57.28405  ? 690 PHE A CD1 690 PHE A CD1 1 
ATOM 5440  C CD2 . PHE A 1 690 ? 260.032 -9.936  283.893 1.0 57.28405  ? 690 PHE A CD2 690 PHE A CD2 1 
ATOM 5441  C CE1 . PHE A 1 690 ? 257.588 -10.999 284.578 1.0 57.28405  ? 690 PHE A CE1 690 PHE A CE1 1 
ATOM 5442  C CE2 . PHE A 1 690 ? 258.955 -9.770  283.052 1.0 57.28405  ? 690 PHE A CE2 690 PHE A CE2 1 
ATOM 5443  C CZ  . PHE A 1 690 ? 257.732 -10.304 283.395 1.0 57.28405  ? 690 PHE A CZ  690 PHE A CZ  1 
ATOM 5444  N N   . GLU A 1 691 ? 262.075 -9.830  289.359 1.0 59.72424  ? 691 GLU A N   691 GLU A N   1 
ATOM 5445  C CA  . GLU A 1 691 ? 263.058 -10.204 290.365 1.0 59.72424  ? 691 GLU A CA  691 GLU A CA  1 
ATOM 5446  C C   . GLU A 1 691 ? 262.901 -11.687 290.670 1.0 59.72424  ? 691 GLU A C   691 GLU A C   1 
ATOM 5447  O O   . GLU A 1 691 ? 261.805 -12.140 291.012 1.0 59.72424  ? 691 GLU A O   691 GLU A O   1 
ATOM 5448  C CB  . GLU A 1 691 ? 262.885 -9.365  291.626 1.0 59.72424  ? 691 GLU A CB  691 GLU A CB  1 
ATOM 5449  C CG  . GLU A 1 691 ? 263.986 -9.568  292.638 1.0 59.72424  ? 691 GLU A CG  691 GLU A CG  1 
ATOM 5450  C CD  . GLU A 1 691 ? 263.835 -8.672  293.845 1.0 59.72424  ? 691 GLU A CD  691 GLU A CD  1 
ATOM 5451  O OE1 . GLU A 1 691 ? 262.842 -7.919  293.908 1.0 59.72424  ? 691 GLU A OE1 691 GLU A OE1 1 
ATOM 5452  O OE2 . GLU A 1 691 ? 264.713 -8.716  294.732 1.0 59.72424  ? 691 GLU A OE2 691 GLU A OE2 1 
ATOM 5453  N N   . ILE A 1 692 ? 263.985 -12.448 290.534 1.0 55.47014  ? 692 ILE A N   692 ILE A N   1 
ATOM 5454  C CA  . ILE A 1 692 ? 263.900 -13.897 290.676 1.0 55.47014  ? 692 ILE A CA  692 ILE A CA  1 
ATOM 5455  C C   . ILE A 1 692 ? 264.405 -14.335 292.044 1.0 55.47014  ? 692 ILE A C   692 ILE A C   1 
ATOM 5456  O O   . ILE A 1 692 ? 263.686 -15.009 292.788 1.0 55.47014  ? 692 ILE A O   692 ILE A O   1 
ATOM 5457  C CB  . ILE A 1 692 ? 264.663 -14.607 289.548 1.0 55.47014  ? 692 ILE A CB  692 ILE A CB  1 
ATOM 5458  C CG1 . ILE A 1 692 ? 264.019 -14.263 288.204 1.0 55.47014  ? 692 ILE A CG1 692 ILE A CG1 1 
ATOM 5459  C CG2 . ILE A 1 692 ? 264.695 -16.102 289.792 1.0 55.47014  ? 692 ILE A CG2 692 ILE A CG2 1 
ATOM 5460  C CD1 . ILE A 1 692 ? 264.798 -14.704 286.987 1.0 55.47014  ? 692 ILE A CD1 692 ILE A CD1 1 
ATOM 5461  N N   . LYS A 1 693 ? 265.636 -13.975 292.386 1.0 56.95223  ? 693 LYS A N   693 LYS A N   1 
ATOM 5462  C CA  . LYS A 1 693 ? 266.165 -14.239 293.714 1.0 56.95223  ? 693 LYS A CA  693 LYS A CA  1 
ATOM 5463  C C   . LYS A 1 693 ? 266.291 -12.942 294.495 1.0 56.95223  ? 693 LYS A C   693 LYS A C   1 
ATOM 5464  O O   . LYS A 1 693 ? 266.673 -11.904 293.950 1.0 56.95223  ? 693 LYS A O   693 LYS A O   1 
ATOM 5465  C CB  . LYS A 1 693 ? 267.543 -14.899 293.671 1.0 56.95223  ? 693 LYS A CB  693 LYS A CB  1 
ATOM 5466  C CG  . LYS A 1 693 ? 267.609 -16.259 293.040 1.0 56.95223  ? 693 LYS A CG  693 LYS A CG  1 
ATOM 5467  C CD  . LYS A 1 693 ? 268.934 -16.900 293.393 1.0 56.95223  ? 693 LYS A CD  693 LYS A CD  1 
ATOM 5468  C CE  . LYS A 1 693 ? 270.092 -16.188 292.734 1.0 56.95223  ? 693 LYS A CE  693 LYS A CE  1 
ATOM 5469  N NZ  . LYS A 1 693 ? 271.366 -16.892 293.022 1.0 56.95223  ? 693 LYS A NZ  693 LYS A NZ  1 
ATOM 5470  N N   . ARG A 1 694 ? 265.980 -13.012 295.776 1.0 64.23968  ? 694 ARG A N   694 ARG A N   1 
ATOM 5471  C CA  . ARG A 1 694 ? 266.352 -11.948 296.693 1.0 64.23968  ? 694 ARG A CA  694 ARG A CA  1 
ATOM 5472  C C   . ARG A 1 694 ? 266.992 -12.608 297.904 1.0 64.23968  ? 694 ARG A C   694 ARG A C   1 
ATOM 5473  O O   . ARG A 1 694 ? 266.323 -13.375 298.607 1.0 64.23968  ? 694 ARG A O   694 ARG A O   1 
ATOM 5474  C CB  . ARG A 1 694 ? 265.148 -11.100 297.099 1.0 64.23968  ? 694 ARG A CB  694 ARG A CB  1 
ATOM 5475  C CG  . ARG A 1 694 ? 265.514 -9.925  297.984 1.0 64.23968  ? 694 ARG A CG  694 ARG A CG  1 
ATOM 5476  C CD  . ARG A 1 694 ? 264.310 -9.071  298.322 1.0 64.23968  ? 694 ARG A CD  694 ARG A CD  1 
ATOM 5477  N NE  . ARG A 1 694 ? 263.803 -8.332  297.173 1.0 64.23968  ? 694 ARG A NE  694 ARG A NE  1 
ATOM 5478  C CZ  . ARG A 1 694 ? 262.662 -7.653  297.178 1.0 64.23968  ? 694 ARG A CZ  694 ARG A CZ  1 
ATOM 5479  N NH1 . ARG A 1 694 ? 261.914 -7.626  298.272 1.0 64.23968  ? 694 ARG A NH1 694 ARG A NH1 1 
ATOM 5480  N NH2 . ARG A 1 694 ? 262.264 -7.002  296.095 1.0 64.23968  ? 694 ARG A NH2 694 ARG A NH2 1 
ATOM 5481  N N   . PRO A 1 695 ? 268.278 -12.368 298.162 1.0 68.67259  ? 695 PRO A N   695 PRO A N   1 
ATOM 5482  C CA  . PRO A 1 695 ? 268.950 -13.068 299.264 1.0 68.67259  ? 695 PRO A CA  695 PRO A CA  1 
ATOM 5483  C C   . PRO A 1 695 ? 268.447 -12.586 300.616 1.0 68.67259  ? 695 PRO A C   695 PRO A C   1 
ATOM 5484  O O   . PRO A 1 695 ? 268.360 -11.386 300.874 1.0 68.67259  ? 695 PRO A O   695 PRO A O   1 
ATOM 5485  C CB  . PRO A 1 695 ? 270.428 -12.727 299.053 1.0 68.67259  ? 695 PRO A CB  695 PRO A CB  1 
ATOM 5486  C CG  . PRO A 1 695 ? 270.412 -11.449 298.307 1.0 68.67259  ? 695 PRO A CG  695 PRO A CG  1 
ATOM 5487  C CD  . PRO A 1 695 ? 269.202 -11.493 297.422 1.0 68.67259  ? 695 PRO A CD  695 PRO A CD  1 
ATOM 5488  N N   . ILE A 1 696 ? 268.089 -13.533 301.459 1.0 70.42852  ? 696 ILE A N   696 ILE A N   1 
ATOM 5489  C CA  . ILE A 1 696 ? 267.566 -13.234 302.783 1.0 70.42852  ? 696 ILE A CA  696 ILE A CA  1 
ATOM 5490  C C   . ILE A 1 696 ? 268.722 -12.794 303.668 1.0 70.42852  ? 696 ILE A C   696 ILE A C   1 
ATOM 5491  O O   . ILE A 1 696 ? 269.774 -13.442 303.674 1.0 70.42852  ? 696 ILE A O   696 ILE A O   1 
ATOM 5492  C CB  . ILE A 1 696 ? 266.841 -14.474 303.333 1.0 70.42852  ? 696 ILE A CB  696 ILE A CB  1 
ATOM 5493  C CG1 . ILE A 1 696 ? 265.749 -14.871 302.346 1.0 70.42852  ? 696 ILE A CG1 696 ILE A CG1 1 
ATOM 5494  C CG2 . ILE A 1 696 ? 266.208 -14.211 304.689 1.0 70.42852  ? 696 ILE A CG2 696 ILE A CG2 1 
ATOM 5495  C CD1 . ILE A 1 696 ? 265.171 -16.228 302.579 1.0 70.42852  ? 696 ILE A CD1 696 ILE A CD1 1 
ATOM 5496  N N   . ASN A 1 697 ? 268.451 -11.802 304.529 1.0 74.41214  ? 697 ASN A N   697 ASN A N   1 
ATOM 5497  C CA  . ASN A 1 697 ? 269.236 -10.715 305.174 1.0 74.41214  ? 697 ASN A CA  697 ASN A CA  1 
ATOM 5498  C C   . ASN A 1 697 ? 269.305 -9.455  304.311 1.0 74.41214  ? 697 ASN A C   697 ASN A C   1 
ATOM 5499  O O   . ASN A 1 697 ? 269.916 -8.473  304.741 1.0 74.41214  ? 697 ASN A O   697 ASN A O   1 
ATOM 5500  C CB  . ASN A 1 697 ? 270.668 -11.088 305.642 1.0 74.41214  ? 697 ASN A CB  697 ASN A CB  1 
ATOM 5501  C CG  . ASN A 1 697 ? 271.708 -11.316 304.502 1.0 74.41214  ? 697 ASN A CG  697 ASN A CG  1 
ATOM 5502  O OD1 . ASN A 1 697 ? 271.447 -11.199 303.302 1.0 74.41214  ? 697 ASN A OD1 697 ASN A OD1 1 
ATOM 5503  N ND2 . ASN A 1 697 ? 272.922 -11.647 304.925 1.0 74.41214  ? 697 ASN A ND2 697 ASN A ND2 1 
ATOM 5504  N N   . GLN A 1 698 ? 268.712 -9.451  303.120 1.0 75.37626  ? 698 GLN A N   698 GLN A N   1 
ATOM 5505  C CA  . GLN A 1 698 ? 268.442 -8.228  302.373 1.0 75.37626  ? 698 GLN A CA  698 GLN A CA  1 
ATOM 5506  C C   . GLN A 1 698 ? 266.955 -8.007  302.158 1.0 75.37626  ? 698 GLN A C   698 GLN A C   1 
ATOM 5507  O O   . GLN A 1 698 ? 266.510 -6.861  302.062 1.0 75.37626  ? 698 GLN A O   698 GLN A O   1 
ATOM 5508  C CB  . GLN A 1 698 ? 269.162 -8.263  301.017 1.0 75.37626  ? 698 GLN A CB  698 GLN A CB  1 
ATOM 5509  C CG  . GLN A 1 698 ? 269.079 -6.999  300.184 1.0 75.37626  ? 698 GLN A CG  698 GLN A CG  1 
ATOM 5510  C CD  . GLN A 1 698 ? 269.825 -7.123  298.882 1.0 75.37626  ? 698 GLN A CD  698 GLN A CD  1 
ATOM 5511  O OE1 . GLN A 1 698 ? 270.409 -8.164  298.589 1.0 75.37626  ? 698 GLN A OE1 698 GLN A OE1 1 
ATOM 5512  N NE2 . GLN A 1 698 ? 269.803 -6.064  298.084 1.0 75.37626  ? 698 GLN A NE2 698 GLN A NE2 1 
ATOM 5513  N N   . ASP A 1 699 ? 266.184 -9.090  302.120 1.0 70.38606  ? 699 ASP A N   699 ASP A N   1 
ATOM 5514  C CA  . ASP A 1 699 ? 264.735 -9.014  302.018 1.0 70.38606  ? 699 ASP A CA  699 ASP A CA  1 
ATOM 5515  C C   . ASP A 1 699 ? 264.118 -8.348  303.242 1.0 70.38606  ? 699 ASP A C   699 ASP A C   1 
ATOM 5516  O O   . ASP A 1 699 ? 264.556 -8.559  304.376 1.0 70.38606  ? 699 ASP A O   699 ASP A O   1 
ATOM 5517  C CB  . ASP A 1 699 ? 264.167 -10.419 301.857 1.0 70.38606  ? 699 ASP A CB  699 ASP A CB  1 
ATOM 5518  C CG  . ASP A 1 699 ? 262.672 -10.427 301.793 1.0 70.38606  ? 699 ASP A CG  699 ASP A CG  1 
ATOM 5519  O OD1 . ASP A 1 699 ? 262.114 -10.124 300.719 1.0 70.38606  ? 699 ASP A OD1 699 ASP A OD1 1 
ATOM 5520  O OD2 . ASP A 1 699 ? 262.057 -10.693 302.845 1.0 70.38606  ? 699 ASP A OD2 699 ASP A OD2 1 
ATOM 5521  N N   . ALA A 1 700 ? 263.082 -7.547  303.003 1.0 71.54806  ? 700 ALA A N   700 ALA A N   1 
ATOM 5522  C CA  . ALA A 1 700 ? 262.367 -6.861  304.065 1.0 71.54806  ? 700 ALA A CA  700 ALA A CA  1 
ATOM 5523  C C   . ALA A 1 700 ? 260.930 -7.326  304.248 1.0 71.54806  ? 700 ALA A C   700 ALA A C   1 
ATOM 5524  O O   . ALA A 1 700 ? 260.510 -7.521  305.389 1.0 71.54806  ? 700 ALA A O   700 ALA A O   1 
ATOM 5525  C CB  . ALA A 1 700 ? 262.372 -5.346  303.812 1.0 71.54806  ? 700 ALA A CB  700 ALA A CB  1 
ATOM 5526  N N   . GLU A 1 701 ? 260.171 -7.532  303.166 1.0 69.69089  ? 701 GLU A N   701 GLU A N   1 
ATOM 5527  C CA  . GLU A 1 701 ? 258.727 -7.768  303.285 1.0 69.69089  ? 701 GLU A CA  701 GLU A CA  1 
ATOM 5528  C C   . GLU A 1 701 ? 258.307 -8.971  302.426 1.0 69.69089  ? 701 GLU A C   701 GLU A C   1 
ATOM 5529  O O   . GLU A 1 701 ? 257.841 -8.826  301.294 1.0 69.69089  ? 701 GLU A O   701 GLU A O   1 
ATOM 5530  C CB  . GLU A 1 701 ? 257.957 -6.493  302.944 1.0 69.69089  ? 701 GLU A CB  701 GLU A CB  1 
ATOM 5531  C CG  . GLU A 1 701 ? 258.411 -5.739  301.673 1.0 69.69089  ? 701 GLU A CG  701 GLU A CG  1 
ATOM 5532  C CD  . GLU A 1 701 ? 257.620 -4.463  301.427 1.0 69.69089  ? 701 GLU A CD  701 GLU A CD  1 
ATOM 5533  O OE1 . GLU A 1 701 ? 256.730 -4.157  302.241 1.0 69.69089  ? 701 GLU A OE1 701 GLU A OE1 1 
ATOM 5534  O OE2 . GLU A 1 701 ? 257.890 -3.772  300.420 1.0 69.69089  ? 701 GLU A OE2 701 GLU A OE2 1 
ATOM 5535  N N   . GLY A 1 702 ? 258.417 -10.160 303.007 1.0 64.65431  ? 702 GLY A N   702 GLY A N   1 
ATOM 5536  C CA  . GLY A 1 702 ? 257.928 -11.342 302.316 1.0 64.65431  ? 702 GLY A CA  702 GLY A CA  1 
ATOM 5537  C C   . GLY A 1 702 ? 258.849 -11.731 301.181 1.0 64.65431  ? 702 GLY A C   702 GLY A C   1 
ATOM 5538  O O   . GLY A 1 702 ? 260.035 -11.990 301.393 1.0 64.65431  ? 702 GLY A O   702 GLY A O   1 
ATOM 5539  N N   . ASN A 1 703 ? 258.282 -11.805 299.970 1.0 62.55209  ? 703 ASN A N   703 ASN A N   1 
ATOM 5540  C CA  . ASN A 1 703 ? 259.011 -11.981 298.705 1.0 62.55209  ? 703 ASN A CA  703 ASN A CA  1 
ATOM 5541  C C   . ASN A 1 703 ? 259.907 -13.218 298.689 1.0 62.55209  ? 703 ASN A C   703 ASN A C   1 
ATOM 5542  O O   . ASN A 1 703 ? 260.947 -13.225 298.033 1.0 62.55209  ? 703 ASN A O   703 ASN A O   1 
ATOM 5543  C CB  . ASN A 1 703 ? 259.829 -10.737 298.354 1.0 62.55209  ? 703 ASN A CB  703 ASN A CB  1 
ATOM 5544  C CG  . ASN A 1 703 ? 258.957 -9.537  298.050 1.0 62.55209  ? 703 ASN A CG  703 ASN A CG  1 
ATOM 5545  O OD1 . ASN A 1 703 ? 259.045 -8.504  298.711 1.0 62.55209  ? 703 ASN A OD1 703 ASN A OD1 1 
ATOM 5546  N ND2 . ASN A 1 703 ? 258.093 -9.675  297.054 1.0 62.55209  ? 703 ASN A ND2 703 ASN A ND2 1 
ATOM 5547  N N   . ASP A 1 704 ? 259.517 -14.270 299.409 1.0 61.17042  ? 704 ASP A N   704 ASP A N   1 
ATOM 5548  C CA  . ASP A 1 704 ? 260.365 -15.449 299.574 1.0 61.17042  ? 704 ASP A CA  704 ASP A CA  1 
ATOM 5549  C C   . ASP A 1 704 ? 259.447 -16.662 299.687 1.0 61.17042  ? 704 ASP A C   704 ASP A C   1 
ATOM 5550  O O   . ASP A 1 704 ? 258.953 -16.964 300.775 1.0 61.17042  ? 704 ASP A O   704 ASP A O   1 
ATOM 5551  C CB  . ASP A 1 704 ? 261.249 -15.312 300.807 1.0 61.17042  ? 704 ASP A CB  704 ASP A CB  1 
ATOM 5552  C CG  . ASP A 1 704 ? 262.427 -14.380 300.596 1.0 61.17042  ? 704 ASP A CG  704 ASP A CG  1 
ATOM 5553  O OD1 . ASP A 1 704 ? 263.042 -14.410 299.512 1.0 61.17042  ? 704 ASP A OD1 704 ASP A OD1 1 
ATOM 5554  O OD2 . ASP A 1 704 ? 262.730 -13.599 301.521 1.0 61.17042  ? 704 ASP A OD2 704 ASP A OD2 1 
ATOM 5555  N N   . THR A 1 705 ? 259.225 -17.349 298.573 1.0 57.42552  ? 705 THR A N   705 THR A N   1 
ATOM 5556  C CA  . THR A 1 705 ? 258.427 -18.561 298.617 1.0 57.42552  ? 705 THR A CA  705 THR A CA  1 
ATOM 5557  C C   . THR A 1 705 ? 259.256 -19.737 299.106 1.0 57.42552  ? 705 THR A C   705 THR A C   1 
ATOM 5558  O O   . THR A 1 705 ? 260.483 -19.667 299.220 1.0 57.42552  ? 705 THR A O   705 THR A O   1 
ATOM 5559  C CB  . THR A 1 705 ? 257.879 -18.927 297.244 1.0 57.42552  ? 705 THR A CB  705 THR A CB  1 
ATOM 5560  O OG1 . THR A 1 705 ? 258.971 -19.171 296.351 1.0 57.42552  ? 705 THR A OG1 705 THR A OG1 1 
ATOM 5561  C CG2 . THR A 1 705 ? 257.034 -17.840 296.701 1.0 57.42552  ? 705 THR A CG2 705 THR A CG2 1 
ATOM 5562  N N   . MET A 1 706 ? 258.547 -20.822 299.425 1.0 55.80728  ? 706 MET A N   706 MET A N   1 
ATOM 5563  C CA  . MET A 1 706 ? 259.066 -22.189 299.442 1.0 55.80728  ? 706 MET A CA  706 MET A CA  1 
ATOM 5564  C C   . MET A 1 706 ? 260.165 -22.423 300.474 1.0 55.80728  ? 706 MET A C   706 MET A C   1 
ATOM 5565  O O   . MET A 1 706 ? 260.861 -23.439 300.389 1.0 55.80728  ? 706 MET A O   706 MET A O   1 
ATOM 5566  C CB  . MET A 1 706 ? 259.583 -22.583 298.057 1.0 55.80728  ? 706 MET A CB  706 MET A CB  1 
ATOM 5567  C CG  . MET A 1 706 ? 258.539 -22.622 296.960 1.0 55.80728  ? 706 MET A CG  706 MET A CG  1 
ATOM 5568  S SD  . MET A 1 706 ? 257.304 -23.910 297.148 1.0 55.80728  ? 706 MET A SD  706 MET A SD  1 
ATOM 5569  C CE  . MET A 1 706 ? 258.259 -25.381 296.798 1.0 55.80728  ? 706 MET A CE  706 MET A CE  1 
ATOM 5570  N N   . GLN A 1 707 ? 260.313 -21.512 301.441 1.0 56.22971  ? 707 GLN A N   707 GLN A N   1 
ATOM 5571  C CA  . GLN A 1 707 ? 261.461 -21.446 302.350 1.0 56.22971  ? 707 GLN A CA  707 GLN A CA  1 
ATOM 5572  C C   . GLN A 1 707 ? 262.773 -21.418 301.564 1.0 56.22971  ? 707 GLN A C   707 GLN A C   1 
ATOM 5573  O O   . GLN A 1 707 ? 263.677 -22.225 301.783 1.0 56.22971  ? 707 GLN A O   707 GLN A O   1 
ATOM 5574  C CB  . GLN A 1 707 ? 261.452 -22.590 303.375 1.0 56.22971  ? 707 GLN A CB  707 GLN A CB  1 
ATOM 5575  C CG  . GLN A 1 707 ? 260.383 -22.495 304.462 1.0 56.22971  ? 707 GLN A CG  707 GLN A CG  1 
ATOM 5576  C CD  . GLN A 1 707 ? 258.997 -22.845 303.961 1.0 56.22971  ? 707 GLN A CD  707 GLN A CD  1 
ATOM 5577  O OE1 . GLN A 1 707 ? 258.094 -22.014 303.979 1.0 56.22971  ? 707 GLN A OE1 707 GLN A OE1 1 
ATOM 5578  N NE2 . GLN A 1 707 ? 258.823 -24.075 303.508 1.0 56.22971  ? 707 GLN A NE2 707 GLN A NE2 1 
ATOM 5579  N N   . SER A 1 708 ? 262.862 -20.479 300.625 1.0 56.97209  ? 708 SER A N   708 SER A N   1 
ATOM 5580  C CA  . SER A 1 708 ? 264.019 -20.360 299.747 1.0 56.97209  ? 708 SER A CA  708 SER A CA  1 
ATOM 5581  C C   . SER A 1 708 ? 264.150 -18.906 299.307 1.0 56.97209  ? 708 SER A C   708 SER A C   1 
ATOM 5582  O O   . SER A 1 708 ? 263.507 -18.012 299.861 1.0 56.97209  ? 708 SER A O   708 SER A O   1 
ATOM 5583  C CB  . SER A 1 708 ? 263.882 -21.303 298.550 1.0 56.97209  ? 708 SER A CB  708 SER A CB  1 
ATOM 5584  O OG  . SER A 1 708 ? 262.812 -20.891 297.725 1.0 56.97209  ? 708 SER A OG  708 SER A OG  1 
ATOM 5585  N N   . ASN A 1 709 ? 264.991 -18.670 298.300 1.0 57.14788  ? 709 ASN A N   709 ASN A N   1 
ATOM 5586  C CA  . ASN A 1 709 ? 265.226 -17.330 297.779 1.0 57.14788  ? 709 ASN A CA  709 ASN A CA  1 
ATOM 5587  C C   . ASN A 1 709 ? 264.265 -16.934 296.669 1.0 57.14788  ? 709 ASN A C   709 ASN A C   1 
ATOM 5588  O O   . ASN A 1 709 ? 264.273 -15.768 296.261 1.0 57.14788  ? 709 ASN A O   709 ASN A O   1 
ATOM 5589  C CB  . ASN A 1 709 ? 266.653 -17.205 297.246 1.0 57.14788  ? 709 ASN A CB  709 ASN A CB  1 
ATOM 5590  C CG  . ASN A 1 709 ? 267.683 -17.233 298.337 1.0 57.14788  ? 709 ASN A CG  709 ASN A CG  1 
ATOM 5591  O OD1 . ASN A 1 709 ? 267.484 -16.665 299.407 1.0 57.14788  ? 709 ASN A OD1 709 ASN A OD1 1 
ATOM 5592  N ND2 . ASN A 1 709 ? 268.806 -17.881 298.069 1.0 57.14788  ? 709 ASN A ND2 709 ASN A ND2 1 
ATOM 5593  N N   . LEU A 1 710 ? 263.461 -17.865 296.163 1.0 54.50582  ? 710 LEU A N   710 LEU A N   1 
ATOM 5594  C CA  . LEU A 1 710 ? 262.589 -17.578 295.034 1.0 54.50582  ? 710 LEU A CA  710 LEU A CA  1 
ATOM 5595  C C   . LEU A 1 710 ? 261.437 -16.691 295.482 1.0 54.50582  ? 710 LEU A C   710 LEU A C   1 
ATOM 5596  O O   . LEU A 1 710 ? 260.829 -16.927 296.531 1.0 54.50582  ? 710 LEU A O   710 LEU A O   1 
ATOM 5597  C CB  . LEU A 1 710 ? 262.070 -18.879 294.433 1.0 54.50582  ? 710 LEU A CB  710 LEU A CB  1 
ATOM 5598  C CG  . LEU A 1 710 ? 261.291 -18.816 293.125 1.0 54.50582  ? 710 LEU A CG  710 LEU A CG  1 
ATOM 5599  C CD1 . LEU A 1 710 ? 262.168 -18.270 292.026 1.0 54.50582  ? 710 LEU A CD1 710 LEU A CD1 1 
ATOM 5600  C CD2 . LEU A 1 710 ? 260.794 -20.194 292.758 1.0 54.50582  ? 710 LEU A CD2 710 LEU A CD2 1 
ATOM 5601  N N   . THR A 1 711 ? 261.143 -15.666 294.689 1.0 55.44396  ? 711 THR A N   711 THR A N   1 
ATOM 5602  C CA  . THR A 1 711 ? 260.256 -14.604 295.129 1.0 55.44396  ? 711 THR A CA  711 THR A CA  1 
ATOM 5603  C C   . THR A 1 711 ? 258.792 -14.963 294.889 1.0 55.44396  ? 711 THR A C   711 THR A C   1 
ATOM 5604  O O   . THR A 1 711 ? 258.462 -15.905 294.172 1.0 55.44396  ? 711 THR A O   711 THR A O   1 
ATOM 5605  C CB  . THR A 1 711 ? 260.607 -13.300 294.426 1.0 55.44396  ? 711 THR A CB  711 THR A CB  1 
ATOM 5606  O OG1 . THR A 1 711 ? 260.474 -13.474 293.013 1.0 55.44396  ? 711 THR A OG1 711 THR A OG1 1 
ATOM 5607  C CG2 . THR A 1 711 ? 262.031 -12.900 294.738 1.0 55.44396  ? 711 THR A CG2 711 THR A CG2 1 
ATOM 5608  N N   . LYS A 1 712 ? 257.909 -14.181 295.513 1.0 56.469    ? 712 LYS A N   712 LYS A N   1 
ATOM 5609  C CA  . LYS A 1 712 ? 256.476 -14.441 295.447 1.0 56.469    ? 712 LYS A CA  712 LYS A CA  1 
ATOM 5610  C C   . LYS A 1 712 ? 255.919 -14.143 294.067 1.0 56.469    ? 712 LYS A C   712 LYS A C   1 
ATOM 5611  O O   . LYS A 1 712 ? 255.041 -14.861 293.579 1.0 56.469    ? 712 LYS A O   712 LYS A O   1 
ATOM 5612  C CB  . LYS A 1 712 ? 255.762 -13.610 296.507 1.0 56.469    ? 712 LYS A CB  712 LYS A CB  1 
ATOM 5613  C CG  . LYS A 1 712 ? 256.088 -14.029 297.914 1.0 56.469    ? 712 LYS A CG  712 LYS A CG  1 
ATOM 5614  C CD  . LYS A 1 712 ? 255.249 -15.186 298.393 1.0 56.469    ? 712 LYS A CD  712 LYS A CD  1 
ATOM 5615  C CE  . LYS A 1 712 ? 255.808 -15.729 299.688 1.0 56.469    ? 712 LYS A CE  712 LYS A CE  1 
ATOM 5616  N NZ  . LYS A 1 712 ? 255.905 -14.713 300.745 1.0 56.469    ? 712 LYS A NZ  712 LYS A NZ  1 
ATOM 5617  N N   . ASP A 1 713 ? 256.418 -13.086 293.429 1.0 58.85775  ? 713 ASP A N   713 ASP A N   1 
ATOM 5618  C CA  . ASP A 1 713 ? 255.895 -12.690 292.131 1.0 58.85775  ? 713 ASP A CA  713 ASP A CA  1 
ATOM 5619  C C   . ASP A 1 713 ? 256.369 -13.621 291.024 1.0 58.85775  ? 713 ASP A C   713 ASP A C   1 
ATOM 5620  O O   . ASP A 1 713 ? 255.618 -13.889 290.078 1.0 58.85775  ? 713 ASP A O   713 ASP A O   1 
ATOM 5621  C CB  . ASP A 1 713 ? 256.279 -11.232 291.840 1.0 58.85775  ? 713 ASP A CB  713 ASP A CB  1 
ATOM 5622  C CG  . ASP A 1 713 ? 257.777 -10.979 291.915 1.0 58.85775  ? 713 ASP A CG  713 ASP A CG  1 
ATOM 5623  O OD1 . ASP A 1 713 ? 258.521 -11.895 292.317 1.0 58.85775  ? 713 ASP A OD1 713 ASP A OD1 1 
ATOM 5624  O OD2 . ASP A 1 713 ? 258.223 -9.860  291.575 1.0 58.85775  ? 713 ASP A OD2 713 ASP A OD2 1 
ATOM 5625  N N   . PHE A 1 714 ? 257.586 -14.147 291.139 1.0 53.04983  ? 714 PHE A N   714 PHE A N   1 
ATOM 5626  C CA  . PHE A 1 714 ? 258.161 -14.954 290.079 1.0 53.04983  ? 714 PHE A CA  714 PHE A CA  1 
ATOM 5627  C C   . PHE A 1 714 ? 257.865 -16.436 290.233 1.0 53.04983  ? 714 PHE A C   714 PHE A C   1 
ATOM 5628  O O   . PHE A 1 714 ? 257.896 -17.163 289.238 1.0 53.04983  ? 714 PHE A O   714 PHE A O   1 
ATOM 5629  C CB  . PHE A 1 714 ? 259.665 -14.723 290.036 1.0 53.04983  ? 714 PHE A CB  714 PHE A CB  1 
ATOM 5630  C CG  . PHE A 1 714 ? 260.336 -15.314 288.852 1.0 53.04983  ? 714 PHE A CG  714 PHE A CG  1 
ATOM 5631  C CD1 . PHE A 1 714 ? 260.228 -14.719 287.612 1.0 53.04983  ? 714 PHE A CD1 714 PHE A CD1 1 
ATOM 5632  C CD2 . PHE A 1 714 ? 261.087 -16.449 288.983 1.0 53.04983  ? 714 PHE A CD2 714 PHE A CD2 1 
ATOM 5633  C CE1 . PHE A 1 714 ? 260.870 -15.264 286.514 1.0 53.04983  ? 714 PHE A CE1 714 PHE A CE1 1 
ATOM 5634  C CE2 . PHE A 1 714 ? 261.716 -16.990 287.902 1.0 53.04983  ? 714 PHE A CE2 714 PHE A CE2 1 
ATOM 5635  C CZ  . PHE A 1 714 ? 261.604 -16.406 286.672 1.0 53.04983  ? 714 PHE A CZ  714 PHE A CZ  1 
ATOM 5636  N N   . PHE A 1 715 ? 257.576 -16.902 291.449 1.0 52.59697  ? 715 PHE A N   715 PHE A N   1 
ATOM 5637  C CA  . PHE A 1 715 ? 257.071 -18.261 291.618 1.0 52.59697  ? 715 PHE A CA  715 PHE A CA  1 
ATOM 5638  C C   . PHE A 1 715 ? 255.691 -18.415 290.997 1.0 52.59697  ? 715 PHE A C   715 PHE A C   1 
ATOM 5639  O O   . PHE A 1 715 ? 255.320 -19.512 290.568 1.0 52.59697  ? 715 PHE A O   715 PHE A O   1 
ATOM 5640  C CB  . PHE A 1 715 ? 257.032 -18.622 293.103 1.0 52.59697  ? 715 PHE A CB  715 PHE A CB  1 
ATOM 5641  C CG  . PHE A 1 715 ? 256.509 -19.995 293.393 1.0 52.59697  ? 715 PHE A CG  715 PHE A CG  1 
ATOM 5642  C CD1 . PHE A 1 715 ? 257.307 -21.106 293.214 1.0 52.59697  ? 715 PHE A CD1 715 PHE A CD1 1 
ATOM 5643  C CD2 . PHE A 1 715 ? 255.216 -20.173 293.852 1.0 52.59697  ? 715 PHE A CD2 715 PHE A CD2 1 
ATOM 5644  C CE1 . PHE A 1 715 ? 256.823 -22.373 293.484 1.0 52.59697  ? 715 PHE A CE1 715 PHE A CE1 1 
ATOM 5645  C CE2 . PHE A 1 715 ? 254.727 -21.435 294.113 1.0 52.59697  ? 715 PHE A CE2 715 PHE A CE2 1 
ATOM 5646  C CZ  . PHE A 1 715 ? 255.532 -22.536 293.932 1.0 52.59697  ? 715 PHE A CZ  715 PHE A CZ  1 
ATOM 5647  N N   . MET A 1 716 ? 254.925 -17.325 290.938 1.0 53.90414  ? 716 MET A N   716 MET A N   1 
ATOM 5648  C CA  . MET A 1 716 ? 253.606 -17.364 290.323 1.0 53.90414  ? 716 MET A CA  716 MET A CA  1 
ATOM 5649  C C   . MET A 1 716 ? 253.699 -17.576 288.820 1.0 53.90414  ? 716 MET A C   716 MET A C   1 
ATOM 5650  O O   . MET A 1 716 ? 253.029 -18.455 288.270 1.0 53.90414  ? 716 MET A O   716 MET A O   1 
ATOM 5651  C CB  . MET A 1 716 ? 252.854 -16.075 290.621 1.0 53.90414  ? 716 MET A CB  716 MET A CB  1 
ATOM 5652  C CG  . MET A 1 716 ? 251.461 -16.078 290.059 1.0 53.90414  ? 716 MET A CG  716 MET A CG  1 
ATOM 5653  S SD  . MET A 1 716 ? 250.547 -14.583 290.418 1.0 53.90414  ? 716 MET A SD  716 MET A SD  1 
ATOM 5654  C CE  . MET A 1 716 ? 249.040 -14.965 289.550 1.0 53.90414  ? 716 MET A CE  716 MET A CE  1 
ATOM 5655  N N   . VAL A 1 717 ? 254.547 -16.800 288.137 1.0 50.69058  ? 717 VAL A N   717 VAL A N   1 
ATOM 5656  C CA  . VAL A 1 717 ? 254.617 -16.869 286.680 1.0 50.69058  ? 717 VAL A CA  717 VAL A CA  1 
ATOM 5657  C C   . VAL A 1 717 ? 255.306 -18.121 286.169 1.0 50.69058  ? 717 VAL A C   717 VAL A C   1 
ATOM 5658  O O   . VAL A 1 717 ? 255.365 -18.325 284.954 1.0 50.69058  ? 717 VAL A O   717 VAL A O   1 
ATOM 5659  C CB  . VAL A 1 717 ? 255.343 -15.649 286.081 1.0 50.69058  ? 717 VAL A CB  717 VAL A CB  1 
ATOM 5660  C CG1 . VAL A 1 717 ? 254.649 -14.370 286.492 1.0 50.69058  ? 717 VAL A CG1 717 VAL A CG1 1 
ATOM 5661  C CG2 . VAL A 1 717 ? 256.793 -15.640 286.489 1.0 50.69058  ? 717 VAL A CG2 717 VAL A CG2 1 
ATOM 5662  N N   . GLN A 1 718 ? 255.846 -18.955 287.054 1.0 48.74365  ? 718 GLN A N   718 GLN A N   1 
ATOM 5663  C CA  . GLN A 1 718 ? 256.317 -20.270 286.654 1.0 48.74365  ? 718 GLN A CA  718 GLN A CA  1 
ATOM 5664  C C   . GLN A 1 718 ? 255.249 -21.333 286.855 1.0 48.74365  ? 718 GLN A C   718 GLN A C   1 
ATOM 5665  O O   . GLN A 1 718 ? 255.149 -22.268 286.056 1.0 48.74365  ? 718 GLN A O   718 GLN A O   1 
ATOM 5666  C CB  . GLN A 1 718 ? 257.576 -20.640 287.432 1.0 48.74365  ? 718 GLN A CB  718 GLN A CB  1 
ATOM 5667  C CG  . GLN A 1 718 ? 258.710 -19.683 287.206 1.0 48.74365  ? 718 GLN A CG  718 GLN A CG  1 
ATOM 5668  C CD  . GLN A 1 718 ? 259.162 -19.670 285.774 1.0 48.74365  ? 718 GLN A CD  718 GLN A CD  1 
ATOM 5669  O OE1 . GLN A 1 718 ? 259.238 -20.708 285.128 1.0 48.74365  ? 718 GLN A OE1 718 GLN A OE1 1 
ATOM 5670  N NE2 . GLN A 1 718 ? 259.454 -18.487 285.259 1.0 48.74365  ? 718 GLN A NE2 718 GLN A NE2 1 
ATOM 5671  N N   . MET A 1 719 ? 254.449 -21.211 287.915 1.0 49.81459  ? 719 MET A N   719 MET A N   1 
ATOM 5672  C CA  . MET A 1 719 ? 253.339 -22.137 288.095 1.0 49.81459  ? 719 MET A CA  719 MET A CA  1 
ATOM 5673  C C   . MET A 1 719 ? 252.197 -21.817 287.147 1.0 49.81459  ? 719 MET A C   719 MET A C   1 
ATOM 5674  O O   . MET A 1 719 ? 251.454 -22.719 286.748 1.0 49.81459  ? 719 MET A O   719 MET A O   1 
ATOM 5675  C CB  . MET A 1 719 ? 252.852 -22.107 289.541 1.0 49.81459  ? 719 MET A CB  719 MET A CB  1 
ATOM 5676  C CG  . MET A 1 719 ? 253.859 -22.637 290.532 1.0 49.81459  ? 719 MET A CG  719 MET A CG  1 
ATOM 5677  S SD  . MET A 1 719 ? 254.279 -24.360 290.249 1.0 49.81459  ? 719 MET A SD  719 MET A SD  1 
ATOM 5678  C CE  . MET A 1 719 ? 252.780 -25.163 290.789 1.0 49.81459  ? 719 MET A CE  719 MET A CE  1 
ATOM 5679  N N   . ALA A 1 720 ? 252.049 -20.550 286.770 1.0 48.85468  ? 720 ALA A N   720 ALA A N   1 
ATOM 5680  C CA  . ALA A 1 720 ? 251.008 -20.174 285.826 1.0 48.85468  ? 720 ALA A CA  720 ALA A CA  1 
ATOM 5681  C C   . ALA A 1 720 ? 251.375 -20.551 284.403 1.0 48.85468  ? 720 ALA A C   720 ALA A C   1 
ATOM 5682  O O   . ALA A 1 720 ? 250.491 -20.871 283.603 1.0 48.85468  ? 720 ALA A O   720 ALA A O   1 
ATOM 5683  C CB  . ALA A 1 720 ? 250.731 -18.676 285.921 1.0 48.85468  ? 720 ALA A CB  720 ALA A CB  1 
ATOM 5684  N N   . ALA A 1 721 ? 252.661 -20.520 284.068 1.0 48.54821  ? 721 ALA A N   721 ALA A N   1 
ATOM 5685  C CA  . ALA A 1 721 ? 253.081 -20.926 282.735 1.0 48.54821  ? 721 ALA A CA  721 ALA A CA  1 
ATOM 5686  C C   . ALA A 1 721 ? 253.027 -22.438 282.586 1.0 48.54821  ? 721 ALA A C   721 ALA A C   1 
ATOM 5687  O O   . ALA A 1 721 ? 252.468 -22.958 281.615 1.0 48.54821  ? 721 ALA A O   721 ALA A O   1 
ATOM 5688  C CB  . ALA A 1 721 ? 254.489 -20.411 282.450 1.0 48.54821  ? 721 ALA A CB  721 ALA A CB  1 
ATOM 5689  N N   . SER A 1 722 ? 253.590 -23.161 283.551 1.0 48.11952  ? 722 SER A N   722 SER A N   1 
ATOM 5690  C CA  . SER A 1 722 ? 253.718 -24.605 283.413 1.0 48.11952  ? 722 SER A CA  722 SER A CA  1 
ATOM 5691  C C   . SER A 1 722 ? 252.429 -25.327 283.777 1.0 48.11952  ? 722 SER A C   722 SER A C   1 
ATOM 5692  O O   . SER A 1 722 ? 251.979 -26.211 283.042 1.0 48.11952  ? 722 SER A O   722 SER A O   1 
ATOM 5693  C CB  . SER A 1 722 ? 254.870 -25.113 284.279 1.0 48.11952  ? 722 SER A CB  722 SER A CB  1 
ATOM 5694  O OG  . SER A 1 722 ? 256.110 -24.604 283.829 1.0 48.11952  ? 722 SER A OG  722 SER A OG  1 
ATOM 5695  N N   . TYR A 1 723 ? 251.821 -24.973 284.907 1.0 49.28324  ? 723 TYR A N   723 TYR A N   1 
ATOM 5696  C CA  . TYR A 1 723 ? 250.763 -25.795 285.476 1.0 49.28324  ? 723 TYR A CA  723 TYR A CA  1 
ATOM 5697  C C   . TYR A 1 723 ? 249.433 -25.075 285.635 1.0 49.28324  ? 723 TYR A C   723 TYR A C   1 
ATOM 5698  O O   . TYR A 1 723 ? 248.553 -25.604 286.324 1.0 49.28324  ? 723 TYR A O   723 TYR A O   1 
ATOM 5699  C CB  . TYR A 1 723 ? 251.207 -26.362 286.824 1.0 49.28324  ? 723 TYR A CB  723 TYR A CB  1 
ATOM 5700  C CG  . TYR A 1 723 ? 252.379 -27.293 286.691 1.0 49.28324  ? 723 TYR A CG  723 TYR A CG  1 
ATOM 5701  C CD1 . TYR A 1 723 ? 252.223 -28.536 286.105 1.0 49.28324  ? 723 TYR A CD1 723 TYR A CD1 1 
ATOM 5702  C CD2 . TYR A 1 723 ? 253.634 -26.941 287.162 1.0 49.28324  ? 723 TYR A CD2 723 TYR A CD2 1 
ATOM 5703  C CE1 . TYR A 1 723 ? 253.286 -29.401 285.970 1.0 49.28324  ? 723 TYR A CE1 723 TYR A CE1 1 
ATOM 5704  C CE2 . TYR A 1 723 ? 254.708 -27.802 287.034 1.0 49.28324  ? 723 TYR A CE2 723 TYR A CE2 1 
ATOM 5705  C CZ  . TYR A 1 723 ? 254.523 -29.031 286.438 1.0 49.28324  ? 723 TYR A CZ  723 TYR A CZ  1 
ATOM 5706  O OH  . TYR A 1 723 ? 255.576 -29.902 286.305 1.0 49.28324  ? 723 TYR A OH  723 TYR A OH  1 
ATOM 5707  N N   . ASN A 1 724 ? 249.279 -23.885 285.041 1.0 48.55713  ? 724 ASN A N   724 ASN A N   1 
ATOM 5708  C CA  . ASN A 1 724 ? 247.994 -23.186 284.899 1.0 48.55713  ? 724 ASN A CA  724 ASN A CA  1 
ATOM 5709  C C   . ASN A 1 724 ? 247.369 -22.849 286.255 1.0 48.55713  ? 724 ASN A C   724 ASN A C   1 
ATOM 5710  O O   . ASN A 1 724 ? 246.147 -22.858 286.405 1.0 48.55713  ? 724 ASN A O   724 ASN A O   1 
ATOM 5711  C CB  . ASN A 1 724 ? 247.030 -24.005 284.030 1.0 48.55713  ? 724 ASN A CB  724 ASN A CB  1 
ATOM 5712  C CG  . ASN A 1 724 ? 246.036 -23.155 283.260 1.0 48.55713  ? 724 ASN A CG  724 ASN A CG  1 
ATOM 5713  O OD1 . ASN A 1 724 ? 245.411 -23.635 282.315 1.0 48.55713  ? 724 ASN A OD1 724 ASN A OD1 1 
ATOM 5714  N ND2 . ASN A 1 724 ? 245.883 -21.903 283.651 1.0 48.55713  ? 724 ASN A ND2 724 ASN A ND2 1 
ATOM 5715  N N   . GLN A 1 725 ? 248.200 -22.558 287.253 1.0 49.56842  ? 725 GLN A N   725 GLN A N   1 
ATOM 5716  C CA  . GLN A 1 725 ? 247.763 -22.242 288.604 1.0 49.56842  ? 725 GLN A CA  725 GLN A CA  1 
ATOM 5717  C C   . GLN A 1 725 ? 248.112 -20.795 288.929 1.0 49.56842  ? 725 GLN A C   725 GLN A C   1 
ATOM 5718  O O   . GLN A 1 725 ? 248.589 -20.043 288.079 1.0 49.56842  ? 725 GLN A O   725 GLN A O   1 
ATOM 5719  C CB  . GLN A 1 725 ? 248.398 -23.207 289.602 1.0 49.56842  ? 725 GLN A CB  725 GLN A CB  1 
ATOM 5720  C CG  . GLN A 1 725 ? 247.925 -24.628 289.455 1.0 49.56842  ? 725 GLN A CG  725 GLN A CG  1 
ATOM 5721  C CD  . GLN A 1 725 ? 248.589 -25.566 290.427 1.0 49.56842  ? 725 GLN A CD  725 GLN A CD  1 
ATOM 5722  O OE1 . GLN A 1 725 ? 249.482 -25.179 291.175 1.0 49.56842  ? 725 GLN A OE1 725 GLN A OE1 1 
ATOM 5723  N NE2 . GLN A 1 725 ? 248.146 -26.813 290.431 1.0 49.56842  ? 725 GLN A NE2 725 GLN A NE2 1 
ATOM 5724  N N   . GLY A 1 726 ? 247.864 -20.395 290.177 1.0 51.38902  ? 726 GLY A N   726 GLY A N   1 
ATOM 5725  C CA  . GLY A 1 726 ? 248.253 -19.089 290.677 1.0 51.38902  ? 726 GLY A CA  726 GLY A CA  1 
ATOM 5726  C C   . GLY A 1 726 ? 247.087 -18.229 291.119 1.0 51.38902  ? 726 GLY A C   726 GLY A C   1 
ATOM 5727  O O   . GLY A 1 726 ? 247.223 -17.452 292.069 1.0 51.38902  ? 726 GLY A O   726 GLY A O   1 
ATOM 5728  N N   . TYR A 1 727 ? 245.946 -18.351 290.450 1.0 51.14158  ? 727 TYR A N   727 TYR A N   1 
ATOM 5729  C CA  . TYR A 1 727 ? 244.801 -17.507 290.748 1.0 51.14158  ? 727 TYR A CA  727 TYR A CA  1 
ATOM 5730  C C   . TYR A 1 727 ? 243.779 -18.175 291.652 1.0 51.14158  ? 727 TYR A C   727 TYR A C   1 
ATOM 5731  O O   . TYR A 1 727 ? 242.918 -17.482 292.199 1.0 51.14158  ? 727 TYR A O   727 TYR A O   1 
ATOM 5732  C CB  . TYR A 1 727 ? 244.117 -17.074 289.451 1.0 51.14158  ? 727 TYR A CB  727 TYR A CB  1 
ATOM 5733  C CG  . TYR A 1 727 ? 244.984 -16.203 288.584 1.0 51.14158  ? 727 TYR A CG  727 TYR A CG  1 
ATOM 5734  C CD1 . TYR A 1 727 ? 245.109 -14.848 288.835 1.0 51.14158  ? 727 TYR A CD1 727 TYR A CD1 1 
ATOM 5735  C CD2 . TYR A 1 727 ? 245.685 -16.739 287.519 1.0 51.14158  ? 727 TYR A CD2 727 TYR A CD2 1 
ATOM 5736  C CE1 . TYR A 1 727 ? 245.902 -14.052 288.046 1.0 51.14158  ? 727 TYR A CE1 727 TYR A CE1 1 
ATOM 5737  C CE2 . TYR A 1 727 ? 246.482 -15.951 286.724 1.0 51.14158  ? 727 TYR A CE2 727 TYR A CE2 1 
ATOM 5738  C CZ  . TYR A 1 727 ? 246.586 -14.610 286.991 1.0 51.14158  ? 727 TYR A CZ  727 TYR A CZ  1 
ATOM 5739  O OH  . TYR A 1 727 ? 247.384 -13.828 286.195 1.0 51.14158  ? 727 TYR A OH  727 TYR A OH  1 
ATOM 5740  N N   . GLN A 1 728 ? 243.842 -19.494 291.817 1.0 49.88726  ? 728 GLN A N   728 GLN A N   1 
ATOM 5741  C CA  . GLN A 1 728 ? 242.866 -20.215 292.624 1.0 49.88726  ? 728 GLN A CA  728 GLN A CA  1 
ATOM 5742  C C   . GLN A 1 728 ? 243.548 -21.121 293.637 1.0 49.88726  ? 728 GLN A C   728 GLN A C   1 
ATOM 5743  O O   . GLN A 1 728 ? 242.985 -22.138 294.044 1.0 49.88726  ? 728 GLN A O   728 GLN A O   1 
ATOM 5744  C CB  . GLN A 1 728 ? 241.918 -21.022 291.742 1.0 49.88726  ? 728 GLN A CB  728 GLN A CB  1 
ATOM 5745  C CG  . GLN A 1 728 ? 241.014 -20.163 290.886 1.0 49.88726  ? 728 GLN A CG  728 GLN A CG  1 
ATOM 5746  C CD  . GLN A 1 728 ? 240.070 -20.970 290.036 1.0 49.88726  ? 728 GLN A CD  728 GLN A CD  1 
ATOM 5747  O OE1 . GLN A 1 728 ? 240.134 -22.197 290.005 1.0 49.88726  ? 728 GLN A OE1 728 GLN A OE1 1 
ATOM 5748  N NE2 . GLN A 1 728 ? 239.174 -20.283 289.344 1.0 49.88726  ? 728 GLN A NE2 728 GLN A NE2 1 
ATOM 5749  N N   . GLY A 1 729 ? 244.758 -20.770 294.052 1.0 50.71907  ? 729 GLY A N   729 GLY A N   1 
ATOM 5750  C CA  . GLY A 1 729 ? 245.454 -21.552 295.050 1.0 50.71907  ? 729 GLY A CA  729 GLY A CA  1 
ATOM 5751  C C   . GLY A 1 729 ? 246.392 -22.573 294.448 1.0 50.71907  ? 729 GLY A C   729 GLY A C   1 
ATOM 5752  O O   . GLY A 1 729 ? 246.080 -23.183 293.422 1.0 50.71907  ? 729 GLY A O   729 GLY A O   1 
ATOM 5753  N N   . PHE A 1 730 ? 247.543 -22.768 295.079 1.0 52.2028   ? 730 PHE A N   730 PHE A N   1 
ATOM 5754  C CA  . PHE A 1 730 ? 248.540 -23.705 294.593 1.0 52.2028   ? 730 PHE A CA  730 PHE A CA  1 
ATOM 5755  C C   . PHE A 1 730 ? 248.331 -25.077 295.213 1.0 52.2028   ? 730 PHE A C   730 PHE A C   1 
ATOM 5756  O O   . PHE A 1 730 ? 247.888 -25.205 296.356 1.0 52.2028   ? 730 PHE A O   730 PHE A O   1 
ATOM 5757  C CB  . PHE A 1 730 ? 249.949 -23.218 294.918 1.0 52.2028   ? 730 PHE A CB  730 PHE A CB  1 
ATOM 5758  C CG  . PHE A 1 730 ? 250.305 -21.918 294.272 1.0 52.2028   ? 730 PHE A CG  730 PHE A CG  1 
ATOM 5759  C CD1 . PHE A 1 730 ? 250.703 -21.868 292.950 1.0 52.2028   ? 730 PHE A CD1 730 PHE A CD1 1 
ATOM 5760  C CD2 . PHE A 1 730 ? 250.247 -20.742 294.995 1.0 52.2028   ? 730 PHE A CD2 730 PHE A CD2 1 
ATOM 5761  C CE1 . PHE A 1 730 ? 251.033 -20.665 292.361 1.0 52.2028   ? 730 PHE A CE1 730 PHE A CE1 1 
ATOM 5762  C CE2 . PHE A 1 730 ? 250.575 -19.538 294.413 1.0 52.2028   ? 730 PHE A CE2 730 PHE A CE2 1 
ATOM 5763  C CZ  . PHE A 1 730 ? 250.968 -19.499 293.095 1.0 52.2028   ? 730 PHE A CZ  730 PHE A CZ  1 
ATOM 5764  N N   . ASN A 1 731 ? 248.657 -26.105 294.439 1.0 52.76093  ? 731 ASN A N   731 ASN A N   1 
ATOM 5765  C CA  . ASN A 1 731 ? 248.700 -27.472 294.925 1.0 52.76093  ? 731 ASN A CA  731 ASN A CA  1 
ATOM 5766  C C   . ASN A 1 731 ? 249.682 -28.247 294.063 1.0 52.76093  ? 731 ASN A C   731 ASN A C   1 
ATOM 5767  O O   . ASN A 1 731 ? 250.226 -27.726 293.089 1.0 52.76093  ? 731 ASN A O   731 ASN A O   1 
ATOM 5768  C CB  . ASN A 1 731 ? 247.308 -28.123 294.925 1.0 52.76093  ? 731 ASN A CB  731 ASN A CB  1 
ATOM 5769  C CG  . ASN A 1 731 ? 246.614 -28.053 293.572 1.0 52.76093  ? 731 ASN A CG  731 ASN A CG  1 
ATOM 5770  O OD1 . ASN A 1 731 ? 247.138 -27.501 292.605 1.0 52.76093  ? 731 ASN A OD1 731 ASN A OD1 1 
ATOM 5771  N ND2 . ASN A 1 731 ? 245.426 -28.637 293.498 1.0 52.76093  ? 731 ASN A ND2 731 ASN A ND2 1 
ATOM 5772  N N   . TRP A 1 732 ? 249.906 -29.494 294.433 1.0 51.98048  ? 732 TRP A N   732 TRP A N   1 
ATOM 5773  C CA  . TRP A 1 732 ? 250.703 -30.374 293.597 1.0 51.98048  ? 732 TRP A CA  732 TRP A CA  1 
ATOM 5774  C C   . TRP A 1 732 ? 249.899 -30.729 292.355 1.0 51.98048  ? 732 TRP A C   732 TRP A C   1 
ATOM 5775  O O   . TRP A 1 732 ? 248.760 -31.191 292.480 1.0 51.98048  ? 732 TRP A O   732 TRP A O   1 
ATOM 5776  C CB  . TRP A 1 732 ? 251.091 -31.629 294.359 1.0 51.98048  ? 732 TRP A CB  732 TRP A CB  1 
ATOM 5777  C CG  . TRP A 1 732 ? 251.960 -32.516 293.568 1.0 51.98048  ? 732 TRP A CG  732 TRP A CG  1 
ATOM 5778  C CD1 . TRP A 1 732 ? 251.578 -33.610 292.865 1.0 51.98048  ? 732 TRP A CD1 732 TRP A CD1 1 
ATOM 5779  C CD2 . TRP A 1 732 ? 253.370 -32.398 293.396 1.0 51.98048  ? 732 TRP A CD2 732 TRP A CD2 1 
ATOM 5780  N NE1 . TRP A 1 732 ? 252.659 -34.180 292.250 1.0 51.98048  ? 732 TRP A NE1 732 TRP A NE1 1 
ATOM 5781  C CE2 . TRP A 1 732 ? 253.776 -33.454 292.566 1.0 51.98048  ? 732 TRP A CE2 732 TRP A CE2 1 
ATOM 5782  C CE3 . TRP A 1 732 ? 254.330 -31.502 293.863 1.0 51.98048  ? 732 TRP A CE3 732 TRP A CE3 1 
ATOM 5783  C CZ2 . TRP A 1 732 ? 255.098 -33.639 292.191 1.0 51.98048  ? 732 TRP A CZ2 732 TRP A CZ2 1 
ATOM 5784  C CZ3 . TRP A 1 732 ? 255.641 -31.693 293.498 1.0 51.98048  ? 732 TRP A CZ3 732 TRP A CZ3 1 
ATOM 5785  C CH2 . TRP A 1 732 ? 256.015 -32.748 292.667 1.0 51.98048  ? 732 TRP A CH2 732 TRP A CH2 1 
ATOM 5786  N N   . PRO A 1 733 ? 250.430 -30.521 291.155 1.0 52.55954  ? 733 PRO A N   733 PRO A N   1 
ATOM 5787  C CA  . PRO A 1 733 ? 249.641 -30.759 289.944 1.0 52.55954  ? 733 PRO A CA  733 PRO A CA  1 
ATOM 5788  C C   . PRO A 1 733 ? 249.512 -32.239 289.627 1.0 52.55954  ? 733 PRO A C   733 PRO A C   1 
ATOM 5789  O O   . PRO A 1 733 ? 250.260 -33.080 290.123 1.0 52.55954  ? 733 PRO A O   733 PRO A O   1 
ATOM 5790  C CB  . PRO A 1 733 ? 250.439 -30.034 288.861 1.0 52.55954  ? 733 PRO A CB  733 PRO A CB  1 
ATOM 5791  C CG  . PRO A 1 733 ? 251.828 -30.056 289.367 1.0 52.55954  ? 733 PRO A CG  733 PRO A CG  1 
ATOM 5792  C CD  . PRO A 1 733 ? 251.743 -29.936 290.850 1.0 52.55954  ? 733 PRO A CD  733 PRO A CD  1 
ATOM 5793  N N   . ASN A 1 734 ? 248.539 -32.546 288.771 1.0 57.29812  ? 734 ASN A N   734 ASN A N   1 
ATOM 5794  C CA  . ASN A 1 734 ? 248.262 -33.935 288.423 1.0 57.29812  ? 734 ASN A CA  734 ASN A CA  1 
ATOM 5795  C C   . ASN A 1 734 ? 249.319 -34.488 287.477 1.0 57.29812  ? 734 ASN A C   734 ASN A C   1 
ATOM 5796  O O   . ASN A 1 734 ? 250.031 -35.443 287.807 1.0 57.29812  ? 734 ASN A O   734 ASN A O   1 
ATOM 5797  C CB  . ASN A 1 734 ? 246.873 -34.044 287.797 1.0 57.29812  ? 734 ASN A CB  734 ASN A CB  1 
ATOM 5798  C CG  . ASN A 1 734 ? 245.769 -33.811 288.797 1.0 57.29812  ? 734 ASN A CG  734 ASN A CG  1 
ATOM 5799  O OD1 . ASN A 1 734 ? 245.823 -34.307 289.921 1.0 57.29812  ? 734 ASN A OD1 734 ASN A OD1 1 
ATOM 5800  N ND2 . ASN A 1 734 ? 244.760 -33.044 288.399 1.0 57.29812  ? 734 ASN A ND2 734 ASN A ND2 1 
ATOM 5801  N N   . CYS A 1 735 ? 249.435 -33.897 286.293 1.0 56.23638  ? 735 CYS A N   735 CYS A N   1 
ATOM 5802  C CA  . CYS A 1 735 ? 250.349 -34.369 285.260 1.0 56.23638  ? 735 CYS A CA  735 CYS A CA  1 
ATOM 5803  C C   . CYS A 1 735 ? 251.622 -33.539 285.334 1.0 56.23638  ? 735 CYS A C   735 CYS A C   1 
ATOM 5804  O O   . CYS A 1 735 ? 251.598 -32.329 285.089 1.0 56.23638  ? 735 CYS A O   735 CYS A O   1 
ATOM 5805  C CB  . CYS A 1 735 ? 249.703 -34.270 283.880 1.0 56.23638  ? 735 CYS A CB  735 CYS A CB  1 
ATOM 5806  S SG  . CYS A 1 735 ? 250.713 -34.907 282.527 1.0 56.23638  ? 735 CYS A SG  735 CYS A SG  1 
ATOM 5807  N N   . THR A 1 736 ? 252.729 -34.190 285.675 1.0 53.35916  ? 736 THR A N   736 THR A N   1 
ATOM 5808  C CA  . THR A 1 736 ? 254.020 -33.536 285.839 1.0 53.35916  ? 736 THR A CA  736 THR A CA  1 
ATOM 5809  C C   . THR A 1 736 ? 255.001 -34.132 284.842 1.0 53.35916  ? 736 THR A C   736 THR A C   1 
ATOM 5810  O O   . THR A 1 736 ? 255.206 -35.349 284.824 1.0 53.35916  ? 736 THR A O   736 THR A O   1 
ATOM 5811  C CB  . THR A 1 736 ? 254.545 -33.711 287.260 1.0 53.35916  ? 736 THR A CB  736 THR A CB  1 
ATOM 5812  O OG1 . THR A 1 736 ? 254.751 -35.104 287.520 1.0 53.35916  ? 736 THR A OG1 736 THR A OG1 1 
ATOM 5813  C CG2 . THR A 1 736 ? 253.564 -33.160 288.269 1.0 53.35916  ? 736 THR A CG2 736 THR A CG2 1 
ATOM 5814  N N   . LYS A 1 737 ? 255.611 -33.278 284.027 1.0 50.57248  ? 737 LYS A N   737 LYS A N   1 
ATOM 5815  C CA  . LYS A 1 737 ? 256.539 -33.737 283.008 1.0 50.57248  ? 737 LYS A CA  737 LYS A CA  1 
ATOM 5816  C C   . LYS A 1 737 ? 257.929 -33.934 283.607 1.0 50.57248  ? 737 LYS A C   737 LYS A C   1 
ATOM 5817  O O   . LYS A 1 737 ? 258.172 -33.667 284.785 1.0 50.57248  ? 737 LYS A O   737 LYS A O   1 
ATOM 5818  C CB  . LYS A 1 737 ? 256.566 -32.755 281.843 1.0 50.57248  ? 737 LYS A CB  737 LYS A CB  1 
ATOM 5819  C CG  . LYS A 1 737 ? 255.215 -32.581 281.180 1.0 50.57248  ? 737 LYS A CG  737 LYS A CG  1 
ATOM 5820  C CD  . LYS A 1 737 ? 254.759 -33.882 280.545 1.0 50.57248  ? 737 LYS A CD  737 LYS A CD  1 
ATOM 5821  C CE  . LYS A 1 737 ? 253.483 -33.697 279.748 1.0 50.57248  ? 737 LYS A CE  737 LYS A CE  1 
ATOM 5822  N NZ  . LYS A 1 737 ? 252.315 -33.440 280.631 1.0 50.57248  ? 737 LYS A NZ  737 LYS A NZ  1 
ATOM 5823  N N   . HIS A 1 738 ? 258.857 -34.417 282.780 1.0 47.32096  ? 738 HIS A N   738 HIS A N   1 
ATOM 5824  C CA  . HIS A 1 738 ? 260.208 -34.687 283.257 1.0 47.32096  ? 738 HIS A CA  738 HIS A CA  1 
ATOM 5825  C C   . HIS A 1 738 ? 261.026 -33.415 283.410 1.0 47.32096  ? 738 HIS A C   738 HIS A C   1 
ATOM 5826  O O   . HIS A 1 738 ? 261.867 -33.329 284.310 1.0 47.32096  ? 738 HIS A O   738 HIS A O   1 
ATOM 5827  C CB  . HIS A 1 738 ? 260.916 -35.650 282.307 1.0 47.32096  ? 738 HIS A CB  738 HIS A CB  1 
ATOM 5828  C CG  . HIS A 1 738 ? 262.304 -36.004 282.735 1.0 47.32096  ? 738 HIS A CG  738 HIS A CG  1 
ATOM 5829  N ND1 . HIS A 1 738 ? 262.563 -36.836 283.801 1.0 47.32096  ? 738 HIS A ND1 738 HIS A ND1 1 
ATOM 5830  C CD2 . HIS A 1 738 ? 263.509 -35.641 282.239 1.0 47.32096  ? 738 HIS A CD2 738 HIS A CD2 1 
ATOM 5831  C CE1 . HIS A 1 738 ? 263.869 -36.968 283.946 1.0 47.32096  ? 738 HIS A CE1 738 HIS A CE1 1 
ATOM 5832  N NE2 . HIS A 1 738 ? 264.466 -36.254 283.010 1.0 47.32096  ? 738 HIS A NE2 738 HIS A NE2 1 
ATOM 5833  N N   . TYR A 1 739 ? 260.799 -32.427 282.550 1.0 46.27166  ? 739 TYR A N   739 TYR A N   1 
ATOM 5834  C CA  . TYR A 1 739 ? 261.468 -31.138 282.637 1.0 46.27166  ? 739 TYR A CA  739 TYR A CA  1 
ATOM 5835  C C   . TYR A 1 739 ? 260.594 -30.088 283.308 1.0 46.27166  ? 739 TYR A C   739 TYR A C   1 
ATOM 5836  O O   . TYR A 1 739 ? 260.745 -28.892 283.042 1.0 46.27166  ? 739 TYR A O   739 TYR A O   1 
ATOM 5837  C CB  . TYR A 1 739 ? 261.884 -30.672 281.246 1.0 46.27166  ? 739 TYR A CB  739 TYR A CB  1 
ATOM 5838  C CG  . TYR A 1 739 ? 262.917 -31.565 280.618 1.0 46.27166  ? 739 TYR A CG  739 TYR A CG  1 
ATOM 5839  C CD1 . TYR A 1 739 ? 264.253 -31.435 280.942 1.0 46.27166  ? 739 TYR A CD1 739 TYR A CD1 1 
ATOM 5840  C CD2 . TYR A 1 739 ? 262.554 -32.552 279.719 1.0 46.27166  ? 739 TYR A CD2 739 TYR A CD2 1 
ATOM 5841  C CE1 . TYR A 1 739 ? 265.201 -32.248 280.385 1.0 46.27166  ? 739 TYR A CE1 739 TYR A CE1 1 
ATOM 5842  C CE2 . TYR A 1 739 ? 263.499 -33.373 279.152 1.0 46.27166  ? 739 TYR A CE2 739 TYR A CE2 1 
ATOM 5843  C CZ  . TYR A 1 739 ? 264.820 -33.214 279.491 1.0 46.27166  ? 739 TYR A CZ  739 TYR A CZ  1 
ATOM 5844  O OH  . TYR A 1 739 ? 265.772 -34.028 278.937 1.0 46.27166  ? 739 TYR A OH  739 TYR A OH  1 
ATOM 5845  N N   . GLY A 1 740 ? 259.686 -30.514 284.178 1.0 49.84036  ? 740 GLY A N   740 GLY A N   1 
ATOM 5846  C CA  . GLY A 1 740 ? 258.774 -29.607 284.840 1.0 49.84036  ? 740 GLY A CA  740 GLY A CA  1 
ATOM 5847  C C   . GLY A 1 740 ? 259.452 -28.798 285.930 1.0 49.84036  ? 740 GLY A C   740 GLY A C   1 
ATOM 5848  O O   . GLY A 1 740 ? 260.662 -28.860 286.146 1.0 49.84036  ? 740 GLY A O   740 GLY A O   1 
ATOM 5849  N N   . PHE A 1 741 ? 258.639 -28.018 286.640 1.0 49.48529  ? 741 PHE A N   741 PHE A N   1 
ATOM 5850  C CA  . PHE A 1 741 ? 259.175 -27.106 287.645 1.0 49.48529  ? 741 PHE A CA  741 PHE A CA  1 
ATOM 5851  C C   . PHE A 1 741 ? 259.153 -27.710 289.039 1.0 49.48529  ? 741 PHE A C   741 PHE A C   1 
ATOM 5852  O O   . PHE A 1 741 ? 260.189 -27.814 289.701 1.0 49.48529  ? 741 PHE A O   741 PHE A O   1 
ATOM 5853  C CB  . PHE A 1 741 ? 258.394 -25.793 287.648 1.0 49.48529  ? 741 PHE A CB  741 PHE A CB  1 
ATOM 5854  C CG  . PHE A 1 741 ? 258.877 -24.819 288.676 1.0 49.48529  ? 741 PHE A CG  741 PHE A CG  1 
ATOM 5855  C CD1 . PHE A 1 741 ? 260.131 -24.239 288.567 1.0 49.48529  ? 741 PHE A CD1 741 PHE A CD1 1 
ATOM 5856  C CD2 . PHE A 1 741 ? 258.070 -24.459 289.733 1.0 49.48529  ? 741 PHE A CD2 741 PHE A CD2 1 
ATOM 5857  C CE1 . PHE A 1 741 ? 260.571 -23.340 289.509 1.0 49.48529  ? 741 PHE A CE1 741 PHE A CE1 1 
ATOM 5858  C CE2 . PHE A 1 741 ? 258.505 -23.557 290.675 1.0 49.48529  ? 741 PHE A CE2 741 PHE A CE2 1 
ATOM 5859  C CZ  . PHE A 1 741 ? 259.756 -22.997 290.562 1.0 49.48529  ? 741 PHE A CZ  741 PHE A CZ  1 
ATOM 5860  N N   . ILE A 1 742 ? 257.968 -28.106 289.510 1.0 51.44762  ? 742 ILE A N   742 ILE A N   1 
ATOM 5861  C CA  . ILE A 1 742 ? 257.820 -28.501 290.903 1.0 51.44762  ? 742 ILE A CA  742 ILE A CA  1 
ATOM 5862  C C   . ILE A 1 742 ? 258.332 -29.910 291.154 1.0 51.44762  ? 742 ILE A C   742 ILE A C   1 
ATOM 5863  O O   . ILE A 1 742 ? 258.420 -30.333 292.311 1.0 51.44762  ? 742 ILE A O   742 ILE A O   1 
ATOM 5864  C CB  . ILE A 1 742 ? 256.338 -28.288 291.264 1.0 51.44762  ? 742 ILE A CB  742 ILE A CB  1 
ATOM 5865  C CG1 . ILE A 1 742 ? 256.165 -28.104 292.769 1.0 51.44762  ? 742 ILE A CG1 742 ILE A CG1 1 
ATOM 5866  C CG2 . ILE A 1 742 ? 255.500 -29.425 290.734 1.0 51.44762  ? 742 ILE A CG2 742 ILE A CG2 1 
ATOM 5867  C CD1 . ILE A 1 742 ? 256.854 -26.865 293.291 1.0 51.44762  ? 742 ILE A CD1 742 ILE A CD1 1 
ATOM 5868  N N   . ASN A 1 743 ? 258.706 -30.643 290.099 1.0 53.27525  ? 743 ASN A N   743 ASN A N   1 
ATOM 5869  C CA  . ASN A 1 743 ? 259.312 -31.957 290.282 1.0 53.27525  ? 743 ASN A CA  743 ASN A CA  1 
ATOM 5870  C C   . ASN A 1 743 ? 260.705 -31.850 290.880 1.0 53.27525  ? 743 ASN A C   743 ASN A C   1 
ATOM 5871  O O   . ASN A 1 743 ? 261.063 -32.616 291.778 1.0 53.27525  ? 743 ASN A O   743 ASN A O   1 
ATOM 5872  C CB  . ASN A 1 743 ? 259.390 -32.689 288.950 1.0 53.27525  ? 743 ASN A CB  743 ASN A CB  1 
ATOM 5873  C CG  . ASN A 1 743 ? 258.044 -33.036 288.409 1.0 53.27525  ? 743 ASN A CG  743 ASN A CG  1 
ATOM 5874  O OD1 . ASN A 1 743 ? 257.612 -32.490 287.399 1.0 53.27525  ? 743 ASN A OD1 743 ASN A OD1 1 
ATOM 5875  N ND2 . ASN A 1 743 ? 257.367 -33.964 289.070 1.0 53.27525  ? 743 ASN A ND2 743 ASN A ND2 1 
ATOM 5876  N N   . ASN A 1 744 ? 261.502 -30.905 290.390 1.0 54.65914  ? 744 ASN A N   744 ASN A N   1 
ATOM 5877  C CA  . ASN A 1 744 ? 262.922 -30.838 290.699 1.0 54.65914  ? 744 ASN A CA  744 ASN A CA  1 
ATOM 5878  C C   . ASN A 1 744 ? 263.328 -29.548 291.404 1.0 54.65914  ? 744 ASN A C   744 ASN A C   1 
ATOM 5879  O O   . ASN A 1 744 ? 264.519 -29.346 291.661 1.0 54.65914  ? 744 ASN A O   744 ASN A O   1 
ATOM 5880  C CB  . ASN A 1 744 ? 263.713 -31.047 289.407 1.0 54.65914  ? 744 ASN A CB  744 ASN A CB  1 
ATOM 5881  C CG  . ASN A 1 744 ? 263.195 -30.197 288.274 1.0 54.65914  ? 744 ASN A CG  744 ASN A CG  1 
ATOM 5882  O OD1 . ASN A 1 744 ? 262.351 -29.332 288.476 1.0 54.65914  ? 744 ASN A OD1 744 ASN A OD1 1 
ATOM 5883  N ND2 . ASN A 1 744 ? 263.665 -30.466 287.066 1.0 54.65914  ? 744 ASN A ND2 744 ASN A ND2 1 
ATOM 5884  N N   . PHE A 1 745 ? 262.375 -28.682 291.735 1.0 54.36562  ? 745 PHE A N   745 PHE A N   1 
ATOM 5885  C CA  . PHE A 1 745 ? 262.653 -27.552 292.610 1.0 54.36562  ? 745 PHE A CA  745 PHE A CA  1 
ATOM 5886  C C   . PHE A 1 745 ? 262.882 -28.062 294.028 1.0 54.36562  ? 745 PHE A C   745 PHE A C   1 
ATOM 5887  O O   . PHE A 1 745 ? 261.977 -28.643 294.633 1.0 54.36562  ? 745 PHE A O   745 PHE A O   1 
ATOM 5888  C CB  . PHE A 1 745 ? 261.489 -26.566 292.577 1.0 54.36562  ? 745 PHE A CB  745 PHE A CB  1 
ATOM 5889  C CG  . PHE A 1 745 ? 261.715 -25.335 293.396 1.0 54.36562  ? 745 PHE A CG  745 PHE A CG  1 
ATOM 5890  C CD1 . PHE A 1 745 ? 262.472 -24.296 292.905 1.0 54.36562  ? 745 PHE A CD1 745 PHE A CD1 1 
ATOM 5891  C CD2 . PHE A 1 745 ? 261.181 -25.225 294.661 1.0 54.36562  ? 745 PHE A CD2 745 PHE A CD2 1 
ATOM 5892  C CE1 . PHE A 1 745 ? 262.691 -23.169 293.658 1.0 54.36562  ? 745 PHE A CE1 745 PHE A CE1 1 
ATOM 5893  C CE2 . PHE A 1 745 ? 261.403 -24.107 295.417 1.0 54.36562  ? 745 PHE A CE2 745 PHE A CE2 1 
ATOM 5894  C CZ  . PHE A 1 745 ? 262.152 -23.074 294.915 1.0 54.36562  ? 745 PHE A CZ  745 PHE A CZ  1 
ATOM 5895  N N   . GLU A 1 746 ? 264.081 -27.845 294.564 1.0 58.66917  ? 746 GLU A N   746 GLU A N   1 
ATOM 5896  C CA  . GLU A 1 746 ? 264.448 -28.357 295.884 1.0 58.66917  ? 746 GLU A CA  746 GLU A CA  1 
ATOM 5897  C C   . GLU A 1 746 ? 265.011 -27.243 296.758 1.0 58.66917  ? 746 GLU A C   746 GLU A C   1 
ATOM 5898  O O   . GLU A 1 746 ? 266.180 -26.855 296.594 1.0 58.66917  ? 746 GLU A O   746 GLU A O   1 
ATOM 5899  C CB  . GLU A 1 746 ? 265.455 -29.492 295.762 1.0 58.66917  ? 746 GLU A CB  746 GLU A CB  1 
ATOM 5900  C CG  . GLU A 1 746 ? 264.909 -30.743 295.099 1.0 58.66917  ? 746 GLU A CG  746 GLU A CG  1 
ATOM 5901  C CD  . GLU A 1 746 ? 263.871 -31.450 295.945 1.0 58.66917  ? 746 GLU A CD  746 GLU A CD  1 
ATOM 5902  O OE1 . GLU A 1 746 ? 263.979 -31.400 297.188 1.0 58.66917  ? 746 GLU A OE1 746 GLU A OE1 1 
ATOM 5903  O OE2 . GLU A 1 746 ? 262.947 -32.060 295.367 1.0 58.66917  ? 746 GLU A OE2 746 GLU A OE2 1 
ATOM 5904  N N   . PRO A 1 747 ? 264.228 -26.713 297.691 1.0 55.88074  ? 747 PRO A N   747 PRO A N   1 
ATOM 5905  C CA  . PRO A 1 747 ? 264.756 -25.717 298.626 1.0 55.88074  ? 747 PRO A CA  747 PRO A CA  1 
ATOM 5906  C C   . PRO A 1 747 ? 265.509 -26.370 299.776 1.0 55.88074  ? 747 PRO A C   747 PRO A C   1 
ATOM 5907  O O   . PRO A 1 747 ? 265.383 -27.567 300.036 1.0 55.88074  ? 747 PRO A O   747 PRO A O   1 
ATOM 5908  C CB  . PRO A 1 747 ? 263.495 -25.015 299.130 1.0 55.88074  ? 747 PRO A CB  747 PRO A CB  1 
ATOM 5909  C CG  . PRO A 1 747 ? 262.449 -26.056 299.035 1.0 55.88074  ? 747 PRO A CG  747 PRO A CG  1 
ATOM 5910  C CD  . PRO A 1 747 ? 262.772 -26.872 297.823 1.0 55.88074  ? 747 PRO A CD  747 PRO A CD  1 
ATOM 5911  N N   . MET A 1 748 ? 266.285 -25.548 300.484 1.0 58.97103  ? 748 MET A N   748 MET A N   1 
ATOM 5912  C CA  . MET A 1 748 ? 267.168 -26.042 301.534 1.0 58.97103  ? 748 MET A CA  748 MET A CA  1 
ATOM 5913  C C   . MET A 1 748 ? 267.562 -24.893 302.452 1.0 58.97103  ? 748 MET A C   748 MET A C   1 
ATOM 5914  O O   . MET A 1 748 ? 267.453 -23.722 302.087 1.0 58.97103  ? 748 MET A O   748 MET A O   1 
ATOM 5915  C CB  . MET A 1 748 ? 268.407 -26.701 300.933 1.0 58.97103  ? 748 MET A CB  748 MET A CB  1 
ATOM 5916  C CG  . MET A 1 748 ? 269.233 -25.754 300.108 1.0 58.97103  ? 748 MET A CG  748 MET A CG  1 
ATOM 5917  S SD  . MET A 1 748 ? 270.556 -26.601 299.244 1.0 58.97103  ? 748 MET A SD  748 MET A SD  1 
ATOM 5918  C CE  . MET A 1 748 ? 269.613 -27.368 297.940 1.0 58.97103  ? 748 MET A CE  748 MET A CE  1 
ATOM 5919  N N   . SER A 1 749 ? 268.031 -25.243 303.650 1.0 58.38007  ? 749 SER A N   749 SER A N   1 
ATOM 5920  C CA  . SER A 1 749 ? 268.371 -24.246 304.659 1.0 58.38007  ? 749 SER A CA  749 SER A CA  1 
ATOM 5921  C C   . SER A 1 749 ? 269.374 -24.836 305.640 1.0 58.38007  ? 749 SER A C   749 SER A C   1 
ATOM 5922  O O   . SER A 1 749 ? 269.472 -26.054 305.792 1.0 58.38007  ? 749 SER A O   749 SER A O   1 
ATOM 5923  C CB  . SER A 1 749 ? 267.129 -23.762 305.414 1.0 58.38007  ? 749 SER A CB  749 SER A CB  1 
ATOM 5924  O OG  . SER A 1 749 ? 266.233 -23.075 304.563 1.0 58.38007  ? 749 SER A OG  749 SER A OG  1 
ATOM 5925  N N   . ARG A 1 750 ? 270.113 -23.951 306.312 1.0 59.52597  ? 750 ARG A N   750 ARG A N   1 
ATOM 5926  C CA  . ARG A 1 750 ? 271.041 -24.350 307.366 1.0 59.52597  ? 750 ARG A CA  750 ARG A CA  1 
ATOM 5927  C C   . ARG A 1 750 ? 271.280 -23.153 308.278 1.0 59.52597  ? 750 ARG A C   750 ARG A C   1 
ATOM 5928  O O   . ARG A 1 750 ? 270.728 -22.071 308.071 1.0 59.52597  ? 750 ARG A O   750 ARG A O   1 
ATOM 5929  C CB  . ARG A 1 750 ? 272.365 -24.873 306.794 1.0 59.52597  ? 750 ARG A CB  750 ARG A CB  1 
ATOM 5930  C CG  . ARG A 1 750 ? 273.255 -23.811 306.175 1.0 59.52597  ? 750 ARG A CG  750 ARG A CG  1 
ATOM 5931  C CD  . ARG A 1 750 ? 274.465 -24.415 305.493 1.0 59.52597  ? 750 ARG A CD  750 ARG A CD  1 
ATOM 5932  N NE  . ARG A 1 750 ? 275.176 -23.403 304.717 1.0 59.52597  ? 750 ARG A NE  750 ARG A NE  1 
ATOM 5933  C CZ  . ARG A 1 750 ? 276.378 -22.932 305.012 1.0 59.52597  ? 750 ARG A CZ  750 ARG A CZ  1 
ATOM 5934  N NH1 . ARG A 1 750 ? 276.935 -21.994 304.263 1.0 59.52597  ? 750 ARG A NH1 750 ARG A NH1 1 
ATOM 5935  N NH2 . ARG A 1 750 ? 277.062 -23.484 305.998 1.0 59.52597  ? 750 ARG A NH2 750 ARG A NH2 1 
ATOM 5936  N N   . GLN A 1 751 ? 272.104 -23.354 309.304 1.0 61.07622  ? 751 GLN A N   751 GLN A N   1 
ATOM 5937  C CA  . GLN A 1 751 ? 272.552 -22.267 310.160 1.0 61.07622  ? 751 GLN A CA  751 GLN A CA  1 
ATOM 5938  C C   . GLN A 1 751 ? 274.059 -22.337 310.322 1.0 61.07622  ? 751 GLN A C   751 GLN A C   1 
ATOM 5939  O O   . GLN A 1 751 ? 274.652 -23.415 310.248 1.0 61.07622  ? 751 GLN A O   751 GLN A O   1 
ATOM 5940  C CB  . GLN A 1 751 ? 271.891 -22.294 311.540 1.0 61.07622  ? 751 GLN A CB  751 GLN A CB  1 
ATOM 5941  C CG  . GLN A 1 751 ? 270.435 -21.908 311.543 1.0 61.07622  ? 751 GLN A CG  751 GLN A CG  1 
ATOM 5942  C CD  . GLN A 1 751 ? 269.546 -23.064 311.188 1.0 61.07622  ? 751 GLN A CD  751 GLN A CD  1 
ATOM 5943  O OE1 . GLN A 1 751 ? 269.955 -24.219 311.275 1.0 61.07622  ? 751 GLN A OE1 751 GLN A OE1 1 
ATOM 5944  N NE2 . GLN A 1 751 ? 268.330 -22.766 310.762 1.0 61.07622  ? 751 GLN A NE2 751 GLN A NE2 1 
ATOM 5945  N N   . VAL A 1 752 ? 274.671 -21.176 310.512 1.0 64.64546  ? 752 VAL A N   752 VAL A N   1 
ATOM 5946  C CA  . VAL A 1 752 ? 276.096 -21.067 310.808 1.0 64.64546  ? 752 VAL A CA  752 VAL A CA  1 
ATOM 5947  C C   . VAL A 1 752 ? 276.279 -20.177 312.024 1.0 64.64546  ? 752 VAL A C   752 VAL A C   1 
ATOM 5948  O O   . VAL A 1 752 ? 275.507 -19.229 312.217 1.0 64.64546  ? 752 VAL A O   752 VAL A O   1 
ATOM 5949  C CB  . VAL A 1 752 ? 276.892 -20.507 309.623 1.0 64.64546  ? 752 VAL A CB  752 VAL A CB  1 
ATOM 5950  C CG1 . VAL A 1 752 ? 277.018 -21.529 308.596 1.0 64.64546  ? 752 VAL A CG1 752 VAL A CG1 1 
ATOM 5951  C CG2 . VAL A 1 752 ? 276.195 -19.302 309.023 1.0 64.64546  ? 752 VAL A CG2 752 VAL A CG2 1 
ATOM 5952  N N   . PRO A 1 753 ? 277.264 -20.438 312.869 1.0 67.64872  ? 753 PRO A N   753 PRO A N   1 
ATOM 5953  C CA  . PRO A 1 753 ? 277.538 -19.498 313.951 1.0 67.64872  ? 753 PRO A CA  753 PRO A CA  1 
ATOM 5954  C C   . PRO A 1 753 ? 278.203 -18.253 313.394 1.0 67.64872  ? 753 PRO A C   753 PRO A C   1 
ATOM 5955  O O   . PRO A 1 753 ? 278.838 -18.288 312.338 1.0 67.64872  ? 753 PRO A O   753 PRO A O   1 
ATOM 5956  C CB  . PRO A 1 753 ? 278.470 -20.283 314.873 1.0 67.64872  ? 753 PRO A CB  753 PRO A CB  1 
ATOM 5957  C CG  . PRO A 1 753 ? 279.146 -21.243 313.967 1.0 67.64872  ? 753 PRO A CG  753 PRO A CG  1 
ATOM 5958  C CD  . PRO A 1 753 ? 278.144 -21.618 312.927 1.0 67.64872  ? 753 PRO A CD  753 PRO A CD  1 
ATOM 5959  N N   . GLU A 1 754 ? 278.013 -17.139 314.092 1.0 73.80109  ? 754 GLU A N   754 GLU A N   1 
ATOM 5960  C CA  . GLU A 1 754 ? 278.716 -15.915 313.740 1.0 73.80109  ? 754 GLU A CA  754 GLU A CA  1 
ATOM 5961  C C   . GLU A 1 754 ? 280.209 -16.106 313.969 1.0 73.80109  ? 754 GLU A C   754 GLU A C   1 
ATOM 5962  O O   . GLU A 1 754 ? 280.622 -16.854 314.859 1.0 73.80109  ? 754 GLU A O   754 GLU A O   1 
ATOM 5963  C CB  . GLU A 1 754 ? 278.166 -14.742 314.557 1.0 73.80109  ? 754 GLU A CB  754 GLU A CB  1 
ATOM 5964  C CG  . GLU A 1 754 ? 278.466 -14.766 316.059 1.0 73.80109  ? 754 GLU A CG  754 GLU A CG  1 
ATOM 5965  C CD  . GLU A 1 754 ? 277.472 -15.586 316.878 1.0 73.80109  ? 754 GLU A CD  754 GLU A CD  1 
ATOM 5966  O OE1 . GLU A 1 754 ? 276.721 -16.399 316.301 1.0 73.80109  ? 754 GLU A OE1 754 GLU A OE1 1 
ATOM 5967  O OE2 . GLU A 1 754 ? 277.448 -15.419 318.115 1.0 73.80109  ? 754 GLU A OE2 754 GLU A OE2 1 
ATOM 5968  N N   . TYR A 1 755 ? 281.015 -15.491 313.126 1.0 72.70551  ? 755 TYR A N   755 TYR A N   1 
ATOM 5969  C CA  . TYR A 1 755 ? 282.452 -15.704 313.169 1.0 72.70551  ? 755 TYR A CA  755 TYR A CA  1 
ATOM 5970  C C   . TYR A 1 755 ? 283.132 -14.444 313.706 1.0 72.70551  ? 755 TYR A C   755 TYR A C   1 
ATOM 5971  O O   . TYR A 1 755 ? 282.467 -13.478 314.088 1.0 72.70551  ? 755 TYR A O   755 TYR A O   1 
ATOM 5972  C CB  . TYR A 1 755 ? 282.944 -16.109 311.777 1.0 72.70551  ? 755 TYR A CB  755 TYR A CB  1 
ATOM 5973  C CG  . TYR A 1 755 ? 282.552 -17.510 311.357 1.0 72.70551  ? 755 TYR A CG  755 TYR A CG  1 
ATOM 5974  C CD1 . TYR A 1 755 ? 282.206 -18.471 312.297 1.0 72.70551  ? 755 TYR A CD1 755 TYR A CD1 1 
ATOM 5975  C CD2 . TYR A 1 755 ? 282.514 -17.866 310.016 1.0 72.70551  ? 755 TYR A CD2 755 TYR A CD2 1 
ATOM 5976  C CE1 . TYR A 1 755 ? 281.851 -19.752 311.913 1.0 72.70551  ? 755 TYR A CE1 755 TYR A CE1 1 
ATOM 5977  C CE2 . TYR A 1 755 ? 282.153 -19.143 309.624 1.0 72.70551  ? 755 TYR A CE2 755 TYR A CE2 1 
ATOM 5978  C CZ  . TYR A 1 755 ? 281.823 -20.079 310.577 1.0 72.70551  ? 755 TYR A CZ  755 TYR A CZ  1 
ATOM 5979  O OH  . TYR A 1 755 ? 281.465 -21.349 310.193 1.0 72.70551  ? 755 TYR A OH  755 TYR A OH  1 
ATOM 5980  N N   . GLY A 1 756 ? 284.459 -14.443 313.749 1.0 76.64171  ? 756 GLY A N   756 GLY A N   1 
ATOM 5981  C CA  . GLY A 1 756 ? 285.208 -13.246 314.069 1.0 76.64171  ? 756 GLY A CA  756 GLY A CA  1 
ATOM 5982  C C   . GLY A 1 756 ? 285.550 -13.049 315.530 1.0 76.64171  ? 756 GLY A C   756 GLY A C   1 
ATOM 5983  O O   . GLY A 1 756 ? 286.706 -13.222 315.925 1.0 76.64171  ? 756 GLY A O   756 GLY A O   1 
ATOM 5984  N N   . ALA A 1 757 ? 284.563 -12.694 316.348 1.0 80.5371   ? 757 ALA A N   757 ALA A N   1 
ATOM 5985  C CA  . ALA A 1 757 ? 284.791 -12.342 317.745 1.0 80.5371   ? 757 ALA A CA  757 ALA A CA  1 
ATOM 5986  C C   . ALA A 1 757 ? 284.561 -13.572 318.608 1.0 80.5371   ? 757 ALA A C   757 ALA A C   1 
ATOM 5987  O O   . ALA A 1 757 ? 283.423 -14.041 318.728 1.0 80.5371   ? 757 ALA A O   757 ALA A O   1 
ATOM 5988  C CB  . ALA A 1 757 ? 283.874 -11.198 318.180 1.0 80.5371   ? 757 ALA A CB  757 ALA A CB  1 
ATOM 5989  N N   . ASN A 1 758 ? 285.654 -14.118 319.155 1.0 78.52842  ? 758 ASN A N   758 ASN A N   1 
ATOM 5990  C CA  . ASN A 1 758 ? 285.736 -15.276 320.053 1.0 78.52842  ? 758 ASN A CA  758 ASN A CA  1 
ATOM 5991  C C   . ASN A 1 758 ? 285.333 -16.595 319.402 1.0 78.52842  ? 758 ASN A C   758 ASN A C   1 
ATOM 5992  O O   . ASN A 1 758 ? 285.412 -17.642 320.054 1.0 78.52842  ? 758 ASN A O   758 ASN A O   1 
ATOM 5993  C CB  . ASN A 1 758 ? 284.917 -15.083 321.336 1.0 78.52842  ? 758 ASN A CB  758 ASN A CB  1 
ATOM 5994  C CG  . ASN A 1 758 ? 285.511 -14.039 322.251 1.0 78.52842  ? 758 ASN A CG  758 ASN A CG  1 
ATOM 5995  O OD1 . ASN A 1 758 ? 286.727 -13.965 322.418 1.0 78.52842  ? 758 ASN A OD1 758 ASN A OD1 1 
ATOM 5996  N ND2 . ASN A 1 758 ? 284.655 -13.226 322.856 1.0 78.52842  ? 758 ASN A ND2 758 ASN A ND2 1 
ATOM 5997  N N   . TYR A 1 759 ? 284.929 -16.583 318.134 1.0 74.61891  ? 759 TYR A N   759 TYR A N   1 
ATOM 5998  C CA  . TYR A 1 759 ? 284.542 -17.786 317.400 1.0 74.61891  ? 759 TYR A CA  759 TYR A CA  1 
ATOM 5999  C C   . TYR A 1 759 ? 285.428 -17.873 316.167 1.0 74.61891  ? 759 TYR A C   759 TYR A C   1 
ATOM 6000  O O   . TYR A 1 759 ? 285.048 -17.427 315.080 1.0 74.61891  ? 759 TYR A O   759 TYR A O   1 
ATOM 6001  C CB  . TYR A 1 759 ? 283.064 -17.731 317.006 1.0 74.61891  ? 759 TYR A CB  759 TYR A CB  1 
ATOM 6002  C CG  . TYR A 1 759 ? 282.073 -17.827 318.147 1.0 74.61891  ? 759 TYR A CG  759 TYR A CG  1 
ATOM 6003  C CD1 . TYR A 1 759 ? 282.416 -18.420 319.355 1.0 74.61891  ? 759 TYR A CD1 759 TYR A CD1 1 
ATOM 6004  C CD2 . TYR A 1 759 ? 280.799 -17.292 318.022 1.0 74.61891  ? 759 TYR A CD2 759 TYR A CD2 1 
ATOM 6005  C CE1 . TYR A 1 759 ? 281.508 -18.497 320.397 1.0 74.61891  ? 759 TYR A CE1 759 TYR A CE1 1 
ATOM 6006  C CE2 . TYR A 1 759 ? 279.890 -17.358 319.057 1.0 74.61891  ? 759 TYR A CE2 759 TYR A CE2 1 
ATOM 6007  C CZ  . TYR A 1 759 ? 280.247 -17.965 320.240 1.0 74.61891  ? 759 TYR A CZ  759 TYR A CZ  1 
ATOM 6008  O OH  . TYR A 1 759 ? 279.340 -18.034 321.272 1.0 74.61891  ? 759 TYR A OH  759 TYR A OH  1 
ATOM 6009  N N   . PRO A 1 760 ? 286.636 -18.418 316.307 1.0 72.22569  ? 760 PRO A N   760 PRO A N   1 
ATOM 6010  C CA  . PRO A 1 760 ? 287.562 -18.439 315.168 1.0 72.22569  ? 760 PRO A CA  760 PRO A CA  1 
ATOM 6011  C C   . PRO A 1 760 ? 287.139 -19.450 314.113 1.0 72.22569  ? 760 PRO A C   760 PRO A C   1 
ATOM 6012  O O   . PRO A 1 760 ? 286.924 -20.628 314.402 1.0 72.22569  ? 760 PRO A O   760 PRO A O   1 
ATOM 6013  C CB  . PRO A 1 760 ? 288.903 -18.808 315.810 1.0 72.22569  ? 760 PRO A CB  760 PRO A CB  1 
ATOM 6014  C CG  . PRO A 1 760 ? 288.540 -19.542 317.038 1.0 72.22569  ? 760 PRO A CG  760 PRO A CG  1 
ATOM 6015  C CD  . PRO A 1 760 ? 287.273 -18.923 317.536 1.0 72.22569  ? 760 PRO A CD  760 PRO A CD  1 
ATOM 6016  N N   . ASN A 1 761 ? 287.006 -18.967 312.883 1.0 71.65527  ? 761 ASN A N   761 ASN A N   1 
ATOM 6017  C CA  . ASN A 1 761 ? 286.640 -19.805 311.746 1.0 71.65527  ? 761 ASN A CA  761 ASN A CA  1 
ATOM 6018  C C   . ASN A 1 761 ? 287.848 -20.655 311.386 1.0 71.65527  ? 761 ASN A C   761 ASN A C   1 
ATOM 6019  O O   . ASN A 1 761 ? 288.748 -20.209 310.672 1.0 71.65527  ? 761 ASN A O   761 ASN A O   1 
ATOM 6020  C CB  . ASN A 1 761 ? 286.195 -18.941 310.573 1.0 71.65527  ? 761 ASN A CB  761 ASN A CB  1 
ATOM 6021  C CG  . ASN A 1 761 ? 285.561 -19.741 309.455 1.0 71.65527  ? 761 ASN A CG  761 ASN A CG  1 
ATOM 6022  O OD1 . ASN A 1 761 ? 285.412 -20.958 309.544 1.0 71.65527  ? 761 ASN A OD1 761 ASN A OD1 1 
ATOM 6023  N ND2 . ASN A 1 761 ? 285.192 -19.055 308.383 1.0 71.65527  ? 761 ASN A ND2 761 ASN A ND2 1 
ATOM 6024  N N   . LEU A 1 762 ? 287.870 -21.892 311.880 1.0 70.91823  ? 762 LEU A N   762 LEU A N   1 
ATOM 6025  C CA  . LEU A 1 762 ? 288.991 -22.779 311.605 1.0 70.91823  ? 762 LEU A CA  762 LEU A CA  1 
ATOM 6026  C C   . LEU A 1 762 ? 288.965 -23.314 310.184 1.0 70.91823  ? 762 LEU A C   762 LEU A C   1 
ATOM 6027  O O   . LEU A 1 762 ? 290.007 -23.736 309.675 1.0 70.91823  ? 762 LEU A O   762 LEU A O   1 
ATOM 6028  C CB  . LEU A 1 762 ? 288.990 -23.941 312.593 1.0 70.91823  ? 762 LEU A CB  762 LEU A CB  1 
ATOM 6029  C CG  . LEU A 1 762 ? 289.143 -23.537 314.055 1.0 70.91823  ? 762 LEU A CG  762 LEU A CG  1 
ATOM 6030  C CD1 . LEU A 1 762 ? 289.028 -24.748 314.954 1.0 70.91823  ? 762 LEU A CD1 762 LEU A CD1 1 
ATOM 6031  C CD2 . LEU A 1 762 ? 290.459 -22.828 314.273 1.0 70.91823  ? 762 LEU A CD2 762 LEU A CD2 1 
ATOM 6032  N N   . MET A 1 763 ? 287.801 -23.305 309.533 1.0 73.1154   ? 763 MET A N   763 MET A N   1 
ATOM 6033  C CA  . MET A 1 763 ? 287.708 -23.830 308.177 1.0 73.1154   ? 763 MET A CA  763 MET A CA  1 
ATOM 6034  C C   . MET A 1 763 ? 288.333 -22.874 307.171 1.0 73.1154   ? 763 MET A C   763 MET A C   1 
ATOM 6035  O O   . MET A 1 763 ? 289.000 -23.309 306.226 1.0 73.1154   ? 763 MET A O   763 MET A O   1 
ATOM 6036  C CB  . MET A 1 763 ? 286.249 -24.104 307.824 1.0 73.1154   ? 763 MET A CB  763 MET A CB  1 
ATOM 6037  C CG  . MET A 1 763 ? 286.063 -24.827 306.509 1.0 73.1154   ? 763 MET A CG  763 MET A CG  1 
ATOM 6038  S SD  . MET A 1 763 ? 286.753 -26.487 306.547 1.0 73.1154   ? 763 MET A SD  763 MET A SD  1 
ATOM 6039  C CE  . MET A 1 763 ? 287.032 -26.765 304.804 1.0 73.1154   ? 763 MET A CE  763 MET A CE  1 
ATOM 6040  N N   . ALA A 1 764 ? 288.134 -21.569 307.357 1.0 72.16595  ? 764 ALA A N   764 ALA A N   1 
ATOM 6041  C CA  . ALA A 1 764 ? 288.795 -20.602 306.489 1.0 72.16595  ? 764 ALA A CA  764 ALA A CA  1 
ATOM 6042  C C   . ALA A 1 764 ? 290.280 -20.505 306.797 1.0 72.16595  ? 764 ALA A C   764 ALA A C   1 
ATOM 6043  O O   . ALA A 1 764 ? 291.074 -20.168 305.913 1.0 72.16595  ? 764 ALA A O   764 ALA A O   1 
ATOM 6044  C CB  . ALA A 1 764 ? 288.135 -19.231 306.624 1.0 72.16595  ? 764 ALA A CB  764 ALA A CB  1 
ATOM 6045  N N   . ALA A 1 765 ? 290.674 -20.794 308.038 1.0 73.28165  ? 765 ALA A N   765 ALA A N   1 
ATOM 6046  C CA  . ALA A 1 765 ? 292.093 -20.839 308.363 1.0 73.28165  ? 765 ALA A CA  765 ALA A CA  1 
ATOM 6047  C C   . ALA A 1 765 ? 292.744 -22.103 307.825 1.0 73.28165  ? 765 ALA A C   765 ALA A C   1 
ATOM 6048  O O   . ALA A 1 765 ? 293.954 -22.117 307.576 1.0 73.28165  ? 765 ALA A O   765 ALA A O   1 
ATOM 6049  C CB  . ALA A 1 765 ? 292.291 -20.739 309.874 1.0 73.28165  ? 765 ALA A CB  765 ALA A CB  1 
ATOM 6050  N N   . TYR A 1 766 ? 291.966 -23.169 307.640 1.0 74.57882  ? 766 TYR A N   766 TYR A N   1 
ATOM 6051  C CA  . TYR A 1 766 ? 292.521 -24.394 307.080 1.0 74.57882  ? 766 TYR A CA  766 TYR A CA  1 
ATOM 6052  C C   . TYR A 1 766 ? 292.755 -24.258 305.584 1.0 74.57882  ? 766 TYR A C   766 TYR A C   1 
ATOM 6053  O O   . TYR A 1 766 ? 293.716 -24.819 305.046 1.0 74.57882  ? 766 TYR A O   766 TYR A O   1 
ATOM 6054  C CB  . TYR A 1 766 ? 291.597 -25.573 307.370 1.0 74.57882  ? 766 TYR A CB  766 TYR A CB  1 
ATOM 6055  C CG  . TYR A 1 766 ? 292.110 -26.880 306.824 1.0 74.57882  ? 766 TYR A CG  766 TYR A CG  1 
ATOM 6056  C CD1 . TYR A 1 766 ? 293.186 -27.523 307.416 1.0 74.57882  ? 766 TYR A CD1 766 TYR A CD1 1 
ATOM 6057  C CD2 . TYR A 1 766 ? 291.517 -27.472 305.718 1.0 74.57882  ? 766 TYR A CD2 766 TYR A CD2 1 
ATOM 6058  C CE1 . TYR A 1 766 ? 293.662 -28.716 306.920 1.0 74.57882  ? 766 TYR A CE1 766 TYR A CE1 1 
ATOM 6059  C CE2 . TYR A 1 766 ? 291.985 -28.665 305.214 1.0 74.57882  ? 766 TYR A CE2 766 TYR A CE2 1 
ATOM 6060  C CZ  . TYR A 1 766 ? 293.057 -29.282 305.820 1.0 74.57882  ? 766 TYR A CZ  766 TYR A CZ  1 
ATOM 6061  O OH  . TYR A 1 766 ? 293.526 -30.473 305.321 1.0 74.57882  ? 766 TYR A OH  766 TYR A OH  1 
ATOM 6062  N N   . LEU A 1 767 ? 291.890 -23.516 304.895 1.0 74.63551  ? 767 LEU A N   767 LEU A N   1 
ATOM 6063  C CA  . LEU A 1 767 ? 292.020 -23.353 303.454 1.0 74.63551  ? 767 LEU A CA  767 LEU A CA  1 
ATOM 6064  C C   . LEU A 1 767 ? 293.126 -22.385 303.066 1.0 74.63551  ? 767 LEU A C   767 LEU A C   1 
ATOM 6065  O O   . LEU A 1 767 ? 293.505 -22.348 301.891 1.0 74.63551  ? 767 LEU A O   767 LEU A O   1 
ATOM 6066  C CB  . LEU A 1 767 ? 290.699 -22.878 302.855 1.0 74.63551  ? 767 LEU A CB  767 LEU A CB  1 
ATOM 6067  C CG  . LEU A 1 767 ? 289.549 -23.878 302.932 1.0 74.63551  ? 767 LEU A CG  767 LEU A CG  1 
ATOM 6068  C CD1 . LEU A 1 767 ? 288.265 -23.241 302.439 1.0 74.63551  ? 767 LEU A CD1 767 LEU A CD1 1 
ATOM 6069  C CD2 . LEU A 1 767 ? 289.875 -25.119 302.129 1.0 74.63551  ? 767 LEU A CD2 767 LEU A CD2 1 
ATOM 6070  N N   . ALA A 1 768 ? 293.630 -21.591 304.013 1.0 77.25971  ? 768 ALA A N   768 ALA A N   1 
ATOM 6071  C CA  . ALA A 1 768 ? 294.801 -20.763 303.750 1.0 77.25971  ? 768 ALA A CA  768 ALA A CA  1 
ATOM 6072  C C   . ALA A 1 768 ? 296.021 -21.639 303.484 1.0 77.25971  ? 768 ALA A C   768 ALA A C   1 
ATOM 6073  O O   . ALA A 1 768 ? 296.630 -21.571 302.412 1.0 77.25971  ? 768 ALA A O   768 ALA A O   1 
ATOM 6074  C CB  . ALA A 1 768 ? 295.054 -19.821 304.928 1.0 77.25971  ? 768 ALA A CB  768 ALA A CB  1 
ATOM 6075  N N   . ASN A 1 769 ? 296.385 -22.475 304.449 1.0 79.06329  ? 769 ASN A N   769 ASN A N   1 
ATOM 6076  C CA  . ASN A 1 769 ? 297.388 -23.520 304.251 1.0 79.06329  ? 769 ASN A CA  769 ASN A CA  1 
ATOM 6077  C C   . ASN A 1 769 ? 296.931 -24.795 304.947 1.0 79.06329  ? 769 ASN A C   769 ASN A C   1 
ATOM 6078  O O   . ASN A 1 769 ? 296.750 -24.793 306.181 1.0 79.06329  ? 769 ASN A O   769 ASN A O   1 
ATOM 6079  C CB  . ASN A 1 769 ? 298.778 -23.078 304.720 1.0 79.06329  ? 769 ASN A CB  769 ASN A CB  1 
ATOM 6080  C CG  . ASN A 1 769 ? 298.782 -22.422 306.094 1.0 79.06329  ? 769 ASN A CG  769 ASN A CG  1 
ATOM 6081  O OD1 . ASN A 1 769 ? 297.738 -22.191 306.700 1.0 79.06329  ? 769 ASN A OD1 769 ASN A OD1 1 
ATOM 6082  N ND2 . ASN A 1 769 ? 299.981 -22.133 306.598 1.0 79.06329  ? 769 ASN A ND2 769 ASN A ND2 1 
ATOM 6083  N N   . PRO A 1 770 ? 296.708 -25.894 304.218 1.0 78.75475  ? 770 PRO A N   770 PRO A N   1 
ATOM 6084  C CA  . PRO A 1 770 ? 296.294 -27.135 304.884 1.0 78.75475  ? 770 PRO A CA  770 PRO A CA  1 
ATOM 6085  C C   . PRO A 1 770 ? 297.431 -27.871 305.572 1.0 78.75475  ? 770 PRO A C   770 PRO A C   1 
ATOM 6086  O O   . PRO A 1 770 ? 297.174 -28.890 306.229 1.0 78.75475  ? 770 PRO A O   770 PRO A O   1 
ATOM 6087  C CB  . PRO A 1 770 ? 295.714 -27.969 303.735 1.0 78.75475  ? 770 PRO A CB  770 PRO A CB  1 
ATOM 6088  C CG  . PRO A 1 770 ? 296.457 -27.517 302.542 1.0 78.75475  ? 770 PRO A CG  770 PRO A CG  1 
ATOM 6089  C CD  . PRO A 1 770 ? 296.732 -26.043 302.752 1.0 78.75475  ? 770 PRO A CD  770 PRO A CD  1 
ATOM 6090  N N   . GLN A 1 771 ? 298.669 -27.390 305.448 1.0 81.97377  ? 771 GLN A N   771 GLN A N   1 
ATOM 6091  C CA  . GLN A 1 771 ? 299.800 -28.086 306.048 1.0 81.97377  ? 771 GLN A CA  771 GLN A CA  1 
ATOM 6092  C C   . GLN A 1 771 ? 299.805 -27.929 307.563 1.0 81.97377  ? 771 GLN A C   771 GLN A C   1 
ATOM 6093  O O   . GLN A 1 771 ? 300.325 -28.794 308.276 1.0 81.97377  ? 771 GLN A O   771 GLN A O   1 
ATOM 6094  C CB  . GLN A 1 771 ? 301.104 -27.590 305.419 1.0 81.97377  ? 771 GLN A CB  771 GLN A CB  1 
ATOM 6095  C CG  . GLN A 1 771 ? 301.388 -26.101 305.565 1.0 81.97377  ? 771 GLN A CG  771 GLN A CG  1 
ATOM 6096  C CD  . GLN A 1 771 ? 302.194 -25.778 306.801 1.0 81.97377  ? 771 GLN A CD  771 GLN A CD  1 
ATOM 6097  O OE1 . GLN A 1 771 ? 302.981 -26.600 307.268 1.0 81.97377  ? 771 GLN A OE1 771 GLN A OE1 1 
ATOM 6098  N NE2 . GLN A 1 771 ? 302.007 -24.579 307.338 1.0 81.97377  ? 771 GLN A NE2 771 GLN A NE2 1 
ATOM 6099  N N   . THR A 1 772 ? 299.237 -26.837 308.068 1.0 79.67111  ? 772 THR A N   772 THR A N   1 
ATOM 6100  C CA  . THR A 1 772 ? 298.944 -26.739 309.490 1.0 79.67111  ? 772 THR A CA  772 THR A CA  1 
ATOM 6101  C C   . THR A 1 772 ? 297.544 -27.285 309.751 1.0 79.67111  ? 772 THR A C   772 THR A C   1 
ATOM 6102  O O   . THR A 1 772 ? 296.719 -27.382 308.838 1.0 79.67111  ? 772 THR A O   772 THR A O   1 
ATOM 6103  C CB  . THR A 1 772 ? 299.066 -25.290 309.974 1.0 79.67111  ? 772 THR A CB  772 THR A CB  1 
ATOM 6104  O OG1 . THR A 1 772 ? 298.956 -25.249 311.400 1.0 79.67111  ? 772 THR A OG1 772 THR A OG1 1 
ATOM 6105  C CG2 . THR A 1 772 ? 297.976 -24.420 309.391 1.0 79.67111  ? 772 THR A CG2 772 THR A CG2 1 
ATOM 6106  N N   . MET A 1 773 ? 297.288 -27.692 310.991 1.0 77.95491  ? 773 MET A N   773 MET A N   1 
ATOM 6107  C CA  . MET A 1 773 ? 296.028 -28.353 311.292 1.0 77.95491  ? 773 MET A CA  773 MET A CA  1 
ATOM 6108  C C   . MET A 1 773 ? 295.272 -27.556 312.339 1.0 77.95491  ? 773 MET A C   773 MET A C   1 
ATOM 6109  O O   . MET A 1 773 ? 295.537 -27.725 313.539 1.0 77.95491  ? 773 MET A O   773 MET A O   1 
ATOM 6110  C CB  . MET A 1 773 ? 296.267 -29.774 311.789 1.0 77.95491  ? 773 MET A CB  773 MET A CB  1 
ATOM 6111  C CG  . MET A 1 773 ? 296.914 -30.721 310.792 1.0 77.95491  ? 773 MET A CG  773 MET A CG  1 
ATOM 6112  S SD  . MET A 1 773 ? 298.674 -30.399 310.580 1.0 77.95491  ? 773 MET A SD  773 MET A SD  1 
ATOM 6113  C CE  . MET A 1 773 ? 299.228 -31.952 309.910 1.0 77.95491  ? 773 MET A CE  773 MET A CE  1 
ATOM 6114  N N   . PRO A 1 774 ? 294.348 -26.693 311.959 1.0 74.30056  ? 774 PRO A N   774 PRO A N   1 
ATOM 6115  C CA  . PRO A 1 774 ? 293.507 -26.041 312.966 1.0 74.30056  ? 774 PRO A CA  774 PRO A CA  1 
ATOM 6116  C C   . PRO A 1 774 ? 292.341 -26.916 313.394 1.0 74.30056  ? 774 PRO A C   774 PRO A C   1 
ATOM 6117  O O   . PRO A 1 774 ? 291.813 -26.759 314.498 1.0 74.30056  ? 774 PRO A O   774 PRO A O   1 
ATOM 6118  C CB  . PRO A 1 774 ? 293.029 -24.774 312.250 1.0 74.30056  ? 774 PRO A CB  774 PRO A CB  1 
ATOM 6119  C CG  . PRO A 1 774 ? 293.041 -25.140 310.815 1.0 74.30056  ? 774 PRO A CG  774 PRO A CG  1 
ATOM 6120  C CD  . PRO A 1 774 ? 294.193 -26.082 310.629 1.0 74.30056  ? 774 PRO A CD  774 PRO A CD  1 
ATOM 6121  N N   . ILE A 1 775 ? 291.936 -27.849 312.539 1.0 72.11085  ? 775 ILE A N   775 ILE A N   1 
ATOM 6122  C CA  . ILE A 1 775 ? 290.750 -28.665 312.766 1.0 72.11085  ? 775 ILE A CA  775 ILE A CA  1 
ATOM 6123  C C   . ILE A 1 775 ? 291.190 -29.997 313.348 1.0 72.11085  ? 775 ILE A C   775 ILE A C   1 
ATOM 6124  O O   . ILE A 1 775 ? 291.953 -30.737 312.716 1.0 72.11085  ? 775 ILE A O   775 ILE A O   1 
ATOM 6125  C CB  . ILE A 1 775 ? 289.944 -28.865 311.475 1.0 72.11085  ? 775 ILE A CB  775 ILE A CB  1 
ATOM 6126  C CG1 . ILE A 1 775 ? 289.397 -27.528 310.984 1.0 72.11085  ? 775 ILE A CG1 775 ILE A CG1 1 
ATOM 6127  C CG2 . ILE A 1 775 ? 288.811 -29.838 311.702 1.0 72.11085  ? 775 ILE A CG2 775 ILE A CG2 1 
ATOM 6128  C CD1 . ILE A 1 775 ? 288.792 -27.593 309.610 1.0 72.11085  ? 775 ILE A CD1 775 ILE A CD1 1 
ATOM 6129  N N   . TRP A 1 776 ? 290.717 -30.299 314.551 1.0 72.70844  ? 776 TRP A N   776 TRP A N   1 
ATOM 6130  C CA  . TRP A 1 776 ? 291.011 -31.556 315.232 1.0 72.70844  ? 776 TRP A CA  776 TRP A CA  1 
ATOM 6131  C C   . TRP A 1 776 ? 289.684 -32.282 315.396 1.0 72.70844  ? 776 TRP A C   776 TRP A C   1 
ATOM 6132  O O   . TRP A 1 776 ? 288.842 -31.870 316.193 1.0 72.70844  ? 776 TRP A O   776 TRP A O   1 
ATOM 6133  C CB  . TRP A 1 776 ? 291.674 -31.319 316.586 1.0 72.70844  ? 776 TRP A CB  776 TRP A CB  1 
ATOM 6134  C CG  . TRP A 1 776 ? 292.999 -30.655 316.513 1.0 72.70844  ? 776 TRP A CG  776 TRP A CG  1 
ATOM 6135  C CD1 . TRP A 1 776 ? 293.761 -30.463 315.401 1.0 72.70844  ? 776 TRP A CD1 776 TRP A CD1 1 
ATOM 6136  C CD2 . TRP A 1 776 ? 293.713 -30.056 317.595 1.0 72.70844  ? 776 TRP A CD2 776 TRP A CD2 1 
ATOM 6137  N NE1 . TRP A 1 776 ? 294.910 -29.793 315.724 1.0 72.70844  ? 776 TRP A NE1 776 TRP A NE1 1 
ATOM 6138  C CE2 . TRP A 1 776 ? 294.907 -29.534 317.068 1.0 72.70844  ? 776 TRP A CE2 776 TRP A CE2 1 
ATOM 6139  C CE3 . TRP A 1 776 ? 293.462 -29.917 318.961 1.0 72.70844  ? 776 TRP A CE3 776 TRP A CE3 1 
ATOM 6140  C CZ2 . TRP A 1 776 ? 295.844 -28.879 317.855 1.0 72.70844  ? 776 TRP A CZ2 776 TRP A CZ2 1 
ATOM 6141  C CZ3 . TRP A 1 776 ? 294.396 -29.272 319.742 1.0 72.70844  ? 776 TRP A CZ3 776 TRP A CZ3 1 
ATOM 6142  C CH2 . TRP A 1 776 ? 295.572 -28.760 319.188 1.0 72.70844  ? 776 TRP A CH2 776 TRP A CH2 1 
ATOM 6143  N N   . ASN A 1 777 ? 289.485 -33.341 314.622 1.0 69.31695  ? 777 ASN A N   777 ASN A N   1 
ATOM 6144  C CA  . ASN A 1 777 ? 288.326 -34.203 314.785 1.0 69.31695  ? 777 ASN A CA  777 ASN A CA  1 
ATOM 6145  C C   . ASN A 1 777 ? 288.766 -35.589 314.355 1.0 69.31695  ? 777 ASN A C   777 ASN A C   1 
ATOM 6146  O O   . ASN A 1 777 ? 289.601 -35.706 313.455 1.0 69.31695  ? 777 ASN A O   777 ASN A O   1 
ATOM 6147  C CB  . ASN A 1 777 ? 287.124 -33.710 313.973 1.0 69.31695  ? 777 ASN A CB  777 ASN A CB  1 
ATOM 6148  C CG  . ASN A 1 777 ? 285.829 -34.366 314.396 1.0 69.31695  ? 777 ASN A CG  777 ASN A CG  1 
ATOM 6149  O OD1 . ASN A 1 777 ? 285.812 -35.228 315.269 1.0 69.31695  ? 777 ASN A OD1 777 ASN A OD1 1 
ATOM 6150  N ND2 . ASN A 1 777 ? 284.730 -33.947 313.789 1.0 69.31695  ? 777 ASN A ND2 777 ASN A ND2 1 
ATOM 6151  N N   . ASN A 1 778 ? 288.266 -36.604 315.081 1.0 70.35899  ? 778 ASN A N   778 ASN A N   1 
ATOM 6152  C CA  . ASN A 1 778 ? 288.642 -38.026 315.127 1.0 70.35899  ? 778 ASN A CA  778 ASN A CA  1 
ATOM 6153  C C   . ASN A 1 778 ? 290.124 -38.260 314.860 1.0 70.35899  ? 778 ASN A C   778 ASN A C   1 
ATOM 6154  O O   . ASN A 1 778 ? 290.509 -39.123 314.066 1.0 70.35899  ? 778 ASN A O   778 ASN A O   1 
ATOM 6155  C CB  . ASN A 1 778 ? 287.716 -38.922 314.268 1.0 70.35899  ? 778 ASN A CB  778 ASN A CB  1 
ATOM 6156  C CG  . ASN A 1 778 ? 287.722 -38.630 312.781 1.0 70.35899  ? 778 ASN A CG  778 ASN A CG  1 
ATOM 6157  O OD1 . ASN A 1 778 ? 288.569 -37.939 312.250 1.0 70.35899  ? 778 ASN A OD1 778 ASN A OD1 1 
ATOM 6158  N ND2 . ASN A 1 778 ? 286.729 -39.180 312.096 1.0 70.35899  ? 778 ASN A ND2 778 ASN A ND2 1 
ATOM 6159  N N   . CYS A 1 779 ? 290.954 -37.482 315.546 1.0 71.76393  ? 779 CYS A N   779 CYS A N   1 
ATOM 6160  C CA  . CYS A 1 779 ? 292.391 -37.655 315.469 1.0 71.76393  ? 779 CYS A CA  779 CYS A CA  1 
ATOM 6161  C C   . CYS A 1 779 ? 292.803 -38.843 316.319 1.0 71.76393  ? 779 CYS A C   779 CYS A C   1 
ATOM 6162  O O   . CYS A 1 779 ? 292.201 -39.127 317.357 1.0 71.76393  ? 779 CYS A O   779 CYS A O   1 
ATOM 6163  C CB  . CYS A 1 779 ? 293.096 -36.384 315.928 1.0 71.76393  ? 779 CYS A CB  779 CYS A CB  1 
ATOM 6164  S SG  . CYS A 1 779 ? 292.740 -35.907 317.624 1.0 71.76393  ? 779 CYS A SG  779 CYS A SG  1 
ATOM 6165  N N   . GLY A 1 780 ? 293.819 -39.556 315.861 1.0 73.13988  ? 780 GLY A N   780 GLY A N   1 
ATOM 6166  C CA  . GLY A 1 780 ? 294.211 -40.804 316.456 1.0 73.13988  ? 780 GLY A CA  780 GLY A CA  1 
ATOM 6167  C C   . GLY A 1 780 ? 293.639 -42.013 315.761 1.0 73.13988  ? 780 GLY A C   780 GLY A C   1 
ATOM 6168  O O   . GLY A 1 780 ? 294.177 -43.114 315.908 1.0 73.13988  ? 780 GLY A O   780 GLY A O   1 
ATOM 6169  N N   . PHE A 1 781 ? 292.566 -41.833 315.001 1.0 71.46092  ? 781 PHE A N   781 PHE A N   1 
ATOM 6170  C CA  . PHE A 1 781 ? 291.943 -42.932 314.287 1.0 71.46092  ? 781 PHE A CA  781 PHE A CA  1 
ATOM 6171  C C   . PHE A 1 781 ? 291.915 -42.686 312.783 1.0 71.46092  ? 781 PHE A C   781 PHE A C   1 
ATOM 6172  O O   . PHE A 1 781 ? 291.233 -43.418 312.056 1.0 71.46092  ? 781 PHE A O   781 PHE A O   1 
ATOM 6173  C CB  . PHE A 1 781 ? 290.533 -43.157 314.835 1.0 71.46092  ? 781 PHE A CB  781 PHE A CB  1 
ATOM 6174  C CG  . PHE A 1 781 ? 290.494 -43.441 316.310 1.0 71.46092  ? 781 PHE A CG  781 PHE A CG  1 
ATOM 6175  C CD1 . PHE A 1 781 ? 290.847 -44.690 316.792 1.0 71.46092  ? 781 PHE A CD1 781 PHE A CD1 1 
ATOM 6176  C CD2 . PHE A 1 781 ? 290.097 -42.474 317.215 1.0 71.46092  ? 781 PHE A CD2 781 PHE A CD2 1 
ATOM 6177  C CE1 . PHE A 1 781 ? 290.782 -44.973 318.124 1.0 71.46092  ? 781 PHE A CE1 781 PHE A CE1 1 
ATOM 6178  C CE2 . PHE A 1 781 ? 290.054 -42.764 318.569 1.0 71.46092  ? 781 PHE A CE2 781 PHE A CE2 1 
ATOM 6179  C CZ  . PHE A 1 781 ? 290.406 -44.018 319.023 1.0 71.46092  ? 781 PHE A CZ  781 PHE A CZ  1 
ATOM 6180  N N   . GLN A 1 782 ? 292.624 -41.667 312.305 1.0 72.50002  ? 782 GLN A N   782 GLN A N   1 
ATOM 6181  C CA  . GLN A 1 782 ? 292.851 -41.465 310.880 1.0 72.50002  ? 782 GLN A CA  782 GLN A CA  1 
ATOM 6182  C C   . GLN A 1 782 ? 294.149 -40.684 310.711 1.0 72.50002  ? 782 GLN A C   782 GLN A C   1 
ATOM 6183  O O   . GLN A 1 782 ? 294.794 -40.288 311.686 1.0 72.50002  ? 782 GLN A O   782 GLN A O   1 
ATOM 6184  C CB  . GLN A 1 782 ? 291.688 -40.733 310.211 1.0 72.50002  ? 782 GLN A CB  782 GLN A CB  1 
ATOM 6185  C CG  . GLN A 1 782 ? 291.531 -39.293 310.640 1.0 72.50002  ? 782 GLN A CG  782 GLN A CG  1 
ATOM 6186  C CD  . GLN A 1 782 ? 290.419 -38.604 309.887 1.0 72.50002  ? 782 GLN A CD  782 GLN A CD  1 
ATOM 6187  O OE1 . GLN A 1 782 ? 289.776 -39.202 309.023 1.0 72.50002  ? 782 GLN A OE1 782 GLN A OE1 1 
ATOM 6188  N NE2 . GLN A 1 782 ? 290.191 -37.339 310.199 1.0 72.50002  ? 782 GLN A NE2 782 GLN A NE2 1 
ATOM 6189  N N   . GLN A 1 783 ? 294.521 -40.460 309.456 1.0 76.13702  ? 783 GLN A N   783 GLN A N   1 
ATOM 6190  C CA  . GLN A 1 783 ? 295.714 -39.705 309.115 1.0 76.13702  ? 783 GLN A CA  783 GLN A CA  1 
ATOM 6191  C C   . GLN A 1 783 ? 295.504 -38.226 309.438 1.0 76.13702  ? 783 GLN A C   783 GLN A C   1 
ATOM 6192  O O   . GLN A 1 783 ? 294.373 -37.740 309.541 1.0 76.13702  ? 783 GLN A O   783 GLN A O   1 
ATOM 6193  C CB  . GLN A 1 783 ? 296.034 -39.920 307.632 1.0 76.13702  ? 783 GLN A CB  783 GLN A CB  1 
ATOM 6194  C CG  . GLN A 1 783 ? 297.356 -39.370 307.082 1.0 76.13702  ? 783 GLN A CG  783 GLN A CG  1 
ATOM 6195  C CD  . GLN A 1 783 ? 298.570 -39.898 307.803 1.0 76.13702  ? 783 GLN A CD  783 GLN A CD  1 
ATOM 6196  O OE1 . GLN A 1 783 ? 299.240 -39.167 308.528 1.0 76.13702  ? 783 GLN A OE1 783 GLN A OE1 1 
ATOM 6197  N NE2 . GLN A 1 783 ? 298.858 -41.177 307.614 1.0 76.13702  ? 783 GLN A NE2 783 GLN A NE2 1 
ATOM 6198  N N   . LYS A 1 784 ? 296.617 -37.520 309.637 1.0 76.92224  ? 784 LYS A N   784 LYS A N   1 
ATOM 6199  C CA  . LYS A 1 784 ? 296.600 -36.067 309.725 1.0 76.92224  ? 784 LYS A CA  784 LYS A CA  1 
ATOM 6200  C C   . LYS A 1 784 ? 296.068 -35.450 308.436 1.0 76.92224  ? 784 LYS A C   784 LYS A C   1 
ATOM 6201  O O   . LYS A 1 784 ? 296.141 -36.040 307.356 1.0 76.92224  ? 784 LYS A O   784 LYS A O   1 
ATOM 6202  C CB  . LYS A 1 784 ? 298.004 -35.543 310.011 1.0 76.92224  ? 784 LYS A CB  784 LYS A CB  1 
ATOM 6203  C CG  . LYS A 1 784 ? 299.015 -35.860 308.933 1.0 76.92224  ? 784 LYS A CG  784 LYS A CG  1 
ATOM 6204  C CD  . LYS A 1 784 ? 300.405 -35.444 309.357 1.0 76.92224  ? 784 LYS A CD  784 LYS A CD  1 
ATOM 6205  C CE  . LYS A 1 784 ? 301.409 -35.684 308.248 1.0 76.92224  ? 784 LYS A CE  784 LYS A CE  1 
ATOM 6206  N NZ  . LYS A 1 784 ? 301.582 -37.133 307.954 1.0 76.92224  ? 784 LYS A NZ  784 LYS A NZ  1 
ATOM 6207  N N   . THR A 1 785 ? 295.536 -34.242 308.559 1.0 76.81183  ? 785 THR A N   785 THR A N   1 
ATOM 6208  C CA  . THR A 1 785 ? 294.771 -33.642 307.478 1.0 76.81183  ? 785 THR A CA  785 THR A CA  1 
ATOM 6209  C C   . THR A 1 785 ? 295.618 -32.848 306.494 1.0 76.81183  ? 785 THR A C   785 THR A C   1 
ATOM 6210  O O   . THR A 1 785 ? 295.055 -32.219 305.592 1.0 76.81183  ? 785 THR A O   785 THR A O   1 
ATOM 6211  C CB  . THR A 1 785 ? 293.684 -32.745 308.056 1.0 76.81183  ? 785 THR A CB  785 THR A CB  1 
ATOM 6212  O OG1 . THR A 1 785 ? 294.286 -31.703 308.831 1.0 76.81183  ? 785 THR A OG1 785 THR A OG1 1 
ATOM 6213  C CG2 . THR A 1 785 ? 292.763 -33.553 308.946 1.0 76.81183  ? 785 THR A CG2 785 THR A CG2 1 
ATOM 6214  N N   . ALA A 1 786 ? 296.942 -32.851 306.630 1.0 78.86565  ? 786 ALA A N   786 ALA A N   1 
ATOM 6215  C CA  . ALA A 1 786 ? 297.765 -32.203 305.616 1.0 78.86565  ? 786 ALA A CA  786 ALA A CA  1 
ATOM 6216  C C   . ALA A 1 786 ? 297.955 -33.114 304.412 1.0 78.86565  ? 786 ALA A C   786 ALA A C   1 
ATOM 6217  O O   . ALA A 1 786 ? 297.842 -32.677 303.261 1.0 78.86565  ? 786 ALA A O   786 ALA A O   1 
ATOM 6218  C CB  . ALA A 1 786 ? 299.115 -31.801 306.204 1.0 78.86565  ? 786 ALA A CB  786 ALA A CB  1 
ATOM 6219  N N   . THR A 1 787 ? 298.224 -34.387 304.663 1.0 79.03457  ? 787 THR A N   787 THR A N   1 
ATOM 6220  C CA  . THR A 1 787 ? 298.506 -35.356 303.616 1.0 79.03457  ? 787 THR A CA  787 THR A CA  1 
ATOM 6221  C C   . THR A 1 787 ? 297.205 -36.025 303.172 1.0 79.03457  ? 787 THR A C   787 THR A C   1 
ATOM 6222  O O   . THR A 1 787 ? 296.109 -35.520 303.430 1.0 79.03457  ? 787 THR A O   787 THR A O   1 
ATOM 6223  C CB  . THR A 1 787 ? 299.542 -36.369 304.109 1.0 79.03457  ? 787 THR A CB  787 THR A CB  1 
ATOM 6224  O OG1 . THR A 1 787 ? 299.028 -37.066 305.250 1.0 79.03457  ? 787 THR A OG1 787 THR A OG1 1 
ATOM 6225  C CG2 . THR A 1 787 ? 300.824 -35.663 304.490 1.0 79.03457  ? 787 THR A CG2 787 THR A CG2 1 
ATOM 6226  N N   . ASN A 1 788 ? 297.334 -37.144 302.464 1.0 78.69094  ? 788 ASN A N   788 ASN A N   1 
ATOM 6227  C CA  . ASN A 1 788 ? 296.208 -37.935 301.987 1.0 78.69094  ? 788 ASN A CA  788 ASN A CA  1 
ATOM 6228  C C   . ASN A 1 788 ? 295.365 -38.455 303.150 1.0 78.69094  ? 788 ASN A C   788 ASN A C   1 
ATOM 6229  O O   . ASN A 1 788 ? 295.860 -38.674 304.256 1.0 78.69094  ? 788 ASN A O   788 ASN A O   1 
ATOM 6230  C CB  . ASN A 1 788 ? 296.746 -39.105 301.165 1.0 78.69094  ? 788 ASN A CB  788 ASN A CB  1 
ATOM 6231  C CG  . ASN A 1 788 ? 295.680 -39.820 300.376 1.0 78.69094  ? 788 ASN A CG  788 ASN A CG  1 
ATOM 6232  O OD1 . ASN A 1 788 ? 294.507 -39.448 300.390 1.0 78.69094  ? 788 ASN A OD1 788 ASN A OD1 1 
ATOM 6233  N ND2 . ASN A 1 788 ? 296.087 -40.871 299.677 1.0 78.69094  ? 788 ASN A ND2 788 ASN A ND2 1 
ATOM 6234  N N   . VAL A 1 789 ? 294.071 -38.663 302.884 1.0 75.3164   ? 789 VAL A N   789 VAL A N   1 
ATOM 6235  C CA  . VAL A 1 789 ? 293.154 -39.168 303.900 1.0 75.3164   ? 789 VAL A CA  789 VAL A CA  1 
ATOM 6236  C C   . VAL A 1 789 ? 293.000 -40.683 303.811 1.0 75.3164   ? 789 VAL A C   789 VAL A C   1 
ATOM 6237  O O   . VAL A 1 789 ? 292.190 -41.275 304.539 1.0 75.3164   ? 789 VAL A O   789 VAL A O   1 
ATOM 6238  C CB  . VAL A 1 789 ? 291.804 -38.420 303.761 1.0 75.3164   ? 789 VAL A CB  789 VAL A CB  1 
ATOM 6239  C CG1 . VAL A 1 789 ? 290.960 -38.964 302.594 1.0 75.3164   ? 789 VAL A CG1 789 VAL A CG1 1 
ATOM 6240  C CG2 . VAL A 1 789 ? 291.033 -38.333 305.090 1.0 75.3164   ? 789 VAL A CG2 789 VAL A CG2 1 
ATOM 6241  N N   . LEU A 1 790 ? 293.801 -41.342 302.977 1.0 76.59946  ? 790 LEU A N   790 LEU A N   1 
ATOM 6242  C CA  . LEU A 1 790 ? 293.514 -42.691 302.519 1.0 76.59946  ? 790 LEU A CA  790 LEU A CA  1 
ATOM 6243  C C   . LEU A 1 790 ? 294.432 -43.744 303.150 1.0 76.59946  ? 790 LEU A C   790 LEU A C   1 
ATOM 6244  O O   . LEU A 1 790 ? 294.390 -44.910 302.748 1.0 76.59946  ? 790 LEU A O   790 LEU A O   1 
ATOM 6245  C CB  . LEU A 1 790 ? 293.577 -42.698 300.985 1.0 76.59946  ? 790 LEU A CB  790 LEU A CB  1 
ATOM 6246  C CG  . LEU A 1 790 ? 293.065 -43.759 300.004 1.0 76.59946  ? 790 LEU A CG  790 LEU A CG  1 
ATOM 6247  C CD1 . LEU A 1 790 ? 292.453 -43.051 298.818 1.0 76.59946  ? 790 LEU A CD1 790 LEU A CD1 1 
ATOM 6248  C CD2 . LEU A 1 790 ? 294.191 -44.654 299.508 1.0 76.59946  ? 790 LEU A CD2 790 LEU A CD2 1 
ATOM 6249  N N   . LEU A 1 791 ? 295.194 -43.392 304.187 1.0 79.74487  ? 791 LEU A N   791 LEU A N   1 
ATOM 6250  C CA  . LEU A 1 791 ? 296.132 -44.364 304.739 1.0 79.74487  ? 791 LEU A CA  791 LEU A CA  1 
ATOM 6251  C C   . LEU A 1 791 ? 296.449 -44.086 306.204 1.0 79.74487  ? 791 LEU A C   791 LEU A C   1 
ATOM 6252  O O   . LEU A 1 791 ? 296.597 -42.929 306.596 1.0 79.74487  ? 791 LEU A O   791 LEU A O   1 
ATOM 6253  C CB  . LEU A 1 791 ? 297.426 -44.376 303.908 1.0 79.74487  ? 791 LEU A CB  791 LEU A CB  1 
ATOM 6254  C CG  . LEU A 1 791 ? 298.237 -43.083 303.716 1.0 79.74487  ? 791 LEU A CG  791 LEU A CG  1 
ATOM 6255  C CD1 . LEU A 1 791 ? 299.390 -42.918 304.711 1.0 79.74487  ? 791 LEU A CD1 791 LEU A CD1 1 
ATOM 6256  C CD2 . LEU A 1 791 ? 298.739 -42.973 302.297 1.0 79.74487  ? 791 LEU A CD2 791 LEU A CD2 1 
ATOM 6257  N N   . GLU A 1 792 ? 296.522 -45.161 307.001 1.0 82.27936  ? 792 GLU A N   792 GLU A N   1 
ATOM 6258  C CA  . GLU A 1 792 ? 297.444 -45.262 308.134 1.0 82.27936  ? 792 GLU A CA  792 GLU A CA  1 
ATOM 6259  C C   . GLU A 1 792 ? 297.322 -44.207 309.228 1.0 82.27936  ? 792 GLU A C   792 GLU A C   1 
ATOM 6260  O O   . GLU A 1 792 ? 298.074 -43.227 309.215 1.0 82.27936  ? 792 GLU A O   792 GLU A O   1 
ATOM 6261  C CB  . GLU A 1 792 ? 298.876 -45.299 307.606 1.0 82.27936  ? 792 GLU A CB  792 GLU A CB  1 
ATOM 6262  C CG  . GLU A 1 792 ? 299.157 -46.601 306.882 1.0 82.27936  ? 792 GLU A CG  792 GLU A CG  1 
ATOM 6263  C CD  . GLU A 1 792 ? 300.555 -46.690 306.326 1.0 82.27936  ? 792 GLU A CD  792 GLU A CD  1 
ATOM 6264  O OE1 . GLU A 1 792 ? 301.286 -45.682 306.376 1.0 82.27936  ? 792 GLU A OE1 792 GLU A OE1 1 
ATOM 6265  O OE2 . GLU A 1 792 ? 300.923 -47.777 305.836 1.0 82.27936  ? 792 GLU A OE2 792 GLU A OE2 1 
ATOM 6266  N N   . ARG A 1 793 ? 296.305 -44.356 310.089 1.0 76.51289  ? 793 ARG A N   793 ARG A N   1 
ATOM 6267  C CA  . ARG A 1 793 ? 296.120 -43.596 311.332 1.0 76.51289  ? 793 ARG A CA  793 ARG A CA  1 
ATOM 6268  C C   . ARG A 1 793 ? 297.425 -43.349 312.093 1.0 76.51289  ? 793 ARG A C   793 ARG A C   1 
ATOM 6269  O O   . ARG A 1 793 ? 298.342 -44.178 312.096 1.0 76.51289  ? 793 ARG A O   793 ARG A O   1 
ATOM 6270  C CB  . ARG A 1 793 ? 295.110 -44.329 312.239 1.0 76.51289  ? 793 ARG A CB  793 ARG A CB  1 
ATOM 6271  C CG  . ARG A 1 793 ? 295.657 -45.502 313.087 1.0 76.51289  ? 793 ARG A CG  793 ARG A CG  1 
ATOM 6272  C CD  . ARG A 1 793 ? 295.955 -46.746 312.260 1.0 76.51289  ? 793 ARG A CD  793 ARG A CD  1 
ATOM 6273  N NE  . ARG A 1 793 ? 296.660 -47.774 313.010 1.0 76.51289  ? 793 ARG A NE  793 ARG A NE  1 
ATOM 6274  C CZ  . ARG A 1 793 ? 297.983 -47.860 313.086 1.0 76.51289  ? 793 ARG A CZ  793 ARG A CZ  1 
ATOM 6275  N NH1 . ARG A 1 793 ? 298.548 -48.821 313.792 1.0 76.51289  ? 793 ARG A NH1 793 ARG A NH1 1 
ATOM 6276  N NH2 . ARG A 1 793 ? 298.744 -46.978 312.454 1.0 76.51289  ? 793 ARG A NH2 793 ARG A NH2 1 
ATOM 6277  N N   . CYS A 1 794 ? 297.534 -42.151 312.672 1.0 79.27022  ? 794 CYS A N   794 CYS A N   1 
ATOM 6278  C CA  . CYS A 1 794 ? 298.836 -41.667 313.105 1.0 79.27022  ? 794 CYS A CA  794 CYS A CA  1 
ATOM 6279  C C   . CYS A 1 794 ? 298.880 -40.928 314.438 1.0 79.27022  ? 794 CYS A C   794 CYS A C   1 
ATOM 6280  O O   . CYS A 1 794 ? 299.979 -40.714 314.955 1.0 79.27022  ? 794 CYS A O   794 CYS A O   1 
ATOM 6281  C CB  . CYS A 1 794 ? 299.416 -40.760 312.015 1.0 79.27022  ? 794 CYS A CB  794 CYS A CB  1 
ATOM 6282  S SG  . CYS A 1 794 ? 298.398 -39.322 311.675 1.0 79.27022  ? 794 CYS A SG  794 CYS A SG  1 
ATOM 6283  N N   . GLY A 1 795 ? 297.750 -40.514 315.010 1.0 77.02511  ? 795 GLY A N   795 GLY A N   1 
ATOM 6284  C CA  . GLY A 1 795 ? 297.754 -39.659 316.169 1.0 77.02511  ? 795 GLY A CA  795 GLY A CA  1 
ATOM 6285  C C   . GLY A 1 795 ? 297.504 -40.401 317.466 1.0 77.02511  ? 795 GLY A C   795 GLY A C   1 
ATOM 6286  O O   . GLY A 1 795 ? 297.809 -41.591 317.609 1.0 77.02511  ? 795 GLY A O   795 GLY A O   1 
ATOM 6287  N N   . HIS A 1 796 ? 296.942 -39.679 318.429 1.0 76.10004  ? 796 HIS A N   796 HIS A N   1 
ATOM 6288  C CA  . HIS A 1 796 ? 296.488 -40.208 319.703 1.0 76.10004  ? 796 HIS A CA  796 HIS A CA  1 
ATOM 6289  C C   . HIS A 1 796 ? 295.134 -39.594 320.026 1.0 76.10004  ? 796 HIS A C   796 HIS A C   1 
ATOM 6290  O O   . HIS A 1 796 ? 294.874 -38.453 319.634 1.0 76.10004  ? 796 HIS A O   796 HIS A O   1 
ATOM 6291  C CB  . HIS A 1 796 ? 297.506 -39.909 320.817 1.0 76.10004  ? 796 HIS A CB  796 HIS A CB  1 
ATOM 6292  C CG  . HIS A 1 796 ? 297.702 -38.455 321.105 1.0 76.10004  ? 796 HIS A CG  796 HIS A CG  1 
ATOM 6293  N ND1 . HIS A 1 796 ? 296.916 -37.761 321.997 1.0 76.10004  ? 796 HIS A ND1 796 HIS A ND1 1 
ATOM 6294  C CD2 . HIS A 1 796 ? 298.618 -37.570 320.647 1.0 76.10004  ? 796 HIS A CD2 796 HIS A CD2 1 
ATOM 6295  C CE1 . HIS A 1 796 ? 297.330 -36.510 322.066 1.0 76.10004  ? 796 HIS A CE1 796 HIS A CE1 1 
ATOM 6296  N NE2 . HIS A 1 796 ? 298.364 -36.369 321.259 1.0 76.10004  ? 796 HIS A NE2 796 HIS A NE2 1 
ATOM 6297  N N   . PRO A 1 797 ? 294.241 -40.327 320.705 1.0 74.47793  ? 797 PRO A N   797 PRO A N   1 
ATOM 6298  C CA  . PRO A 1 797 ? 292.845 -39.872 320.815 1.0 74.47793  ? 797 PRO A CA  797 PRO A CA  1 
ATOM 6299  C C   . PRO A 1 797 ? 292.705 -38.659 321.723 1.0 74.47793  ? 797 PRO A C   797 PRO A C   1 
ATOM 6300  O O   . PRO A 1 797 ? 293.247 -38.624 322.828 1.0 74.47793  ? 797 PRO A O   797 PRO A O   1 
ATOM 6301  C CB  . PRO A 1 797 ? 292.119 -41.091 321.392 1.0 74.47793  ? 797 PRO A CB  797 PRO A CB  1 
ATOM 6302  C CG  . PRO A 1 797 ? 293.154 -41.823 322.131 1.0 74.47793  ? 797 PRO A CG  797 PRO A CG  1 
ATOM 6303  C CD  . PRO A 1 797 ? 294.424 -41.636 321.360 1.0 74.47793  ? 797 PRO A CD  797 PRO A CD  1 
ATOM 6304  N N   . TYR A 1 798 ? 291.962 -37.664 321.251 1.0 73.07433  ? 798 TYR A N   798 TYR A N   1 
ATOM 6305  C CA  . TYR A 1 798 ? 291.980 -36.368 321.902 1.0 73.07433  ? 798 TYR A CA  798 TYR A CA  1 
ATOM 6306  C C   . TYR A 1 798 ? 290.652 -35.664 321.657 1.0 73.07433  ? 798 TYR A C   798 TYR A C   1 
ATOM 6307  O O   . TYR A 1 798 ? 289.879 -36.040 320.773 1.0 73.07433  ? 798 TYR A O   798 TYR A O   1 
ATOM 6308  C CB  . TYR A 1 798 ? 293.174 -35.549 321.393 1.0 73.07433  ? 798 TYR A CB  798 TYR A CB  1 
ATOM 6309  C CG  . TYR A 1 798 ? 293.445 -34.257 322.121 1.0 73.07433  ? 798 TYR A CG  798 TYR A CG  1 
ATOM 6310  C CD1 . TYR A 1 798 ? 294.019 -34.255 323.383 1.0 73.07433  ? 798 TYR A CD1 798 TYR A CD1 1 
ATOM 6311  C CD2 . TYR A 1 798 ? 293.132 -33.040 321.539 1.0 73.07433  ? 798 TYR A CD2 798 TYR A CD2 1 
ATOM 6312  C CE1 . TYR A 1 798 ? 294.270 -33.071 324.046 1.0 73.07433  ? 798 TYR A CE1 798 TYR A CE1 1 
ATOM 6313  C CE2 . TYR A 1 798 ? 293.378 -31.854 322.191 1.0 73.07433  ? 798 TYR A CE2 798 TYR A CE2 1 
ATOM 6314  C CZ  . TYR A 1 798 ? 293.950 -31.874 323.442 1.0 73.07433  ? 798 TYR A CZ  798 TYR A CZ  1 
ATOM 6315  O OH  . TYR A 1 798 ? 294.195 -30.685 324.084 1.0 73.07433  ? 798 TYR A OH  798 TYR A OH  1 
ATOM 6316  N N   . VAL A 1 799 ? 290.394 -34.644 322.477 1.0 70.41705  ? 799 VAL A N   799 VAL A N   1 
ATOM 6317  C CA  . VAL A 1 799 ? 289.146 -33.897 322.425 1.0 70.41705  ? 799 VAL A CA  799 VAL A CA  1 
ATOM 6318  C C   . VAL A 1 799 ? 289.076 -33.087 321.139 1.0 70.41705  ? 799 VAL A C   799 VAL A C   1 
ATOM 6319  O O   . VAL A 1 799 ? 290.008 -32.348 320.799 1.0 70.41705  ? 799 VAL A O   799 VAL A O   1 
ATOM 6320  C CB  . VAL A 1 799 ? 289.032 -32.988 323.655 1.0 70.41705  ? 799 VAL A CB  799 VAL A CB  1 
ATOM 6321  C CG1 . VAL A 1 799 ? 287.815 -32.129 323.562 1.0 70.41705  ? 799 VAL A CG1 799 VAL A CG1 1 
ATOM 6322  C CG2 . VAL A 1 799 ? 288.962 -33.820 324.899 1.0 70.41705  ? 799 VAL A CG2 799 VAL A CG2 1 
ATOM 6323  N N   . ALA A 1 800 ? 287.966 -33.224 320.420 1.0 67.74845  ? 800 ALA A N   800 ALA A N   1 
ATOM 6324  C CA  . ALA A 1 800 ? 287.756 -32.477 319.193 1.0 67.74845  ? 800 ALA A CA  800 ALA A CA  1 
ATOM 6325  C C   . ALA A 1 800 ? 287.457 -31.011 319.488 1.0 67.74845  ? 800 ALA A C   800 ALA A C   1 
ATOM 6326  O O   . ALA A 1 800 ? 287.102 -30.632 320.605 1.0 67.74845  ? 800 ALA A O   800 ALA A O   1 
ATOM 6327  C CB  . ALA A 1 800 ? 286.613 -33.088 318.389 1.0 67.74845  ? 800 ALA A CB  800 ALA A CB  1 
ATOM 6328  N N   . ASN A 1 801 ? 287.602 -30.177 318.454 1.0 68.31198  ? 801 ASN A N   801 ASN A N   1 
ATOM 6329  C CA  . ASN A 1 801 ? 287.353 -28.749 318.604 1.0 68.31198  ? 801 ASN A CA  801 ASN A CA  1 
ATOM 6330  C C   . ASN A 1 801 ? 286.597 -28.132 317.435 1.0 68.31198  ? 801 ASN A C   801 ASN A C   1 
ATOM 6331  O O   . ASN A 1 801 ? 286.548 -26.901 317.337 1.0 68.31198  ? 801 ASN A O   801 ASN A O   1 
ATOM 6332  C CB  . ASN A 1 801 ? 288.666 -27.986 318.808 1.0 68.31198  ? 801 ASN A CB  801 ASN A CB  1 
ATOM 6333  C CG  . ASN A 1 801 ? 289.663 -28.218 317.694 1.0 68.31198  ? 801 ASN A CG  801 ASN A CG  1 
ATOM 6334  O OD1 . ASN A 1 801 ? 289.415 -28.974 316.760 1.0 68.31198  ? 801 ASN A OD1 801 ASN A OD1 1 
ATOM 6335  N ND2 . ASN A 1 801 ? 290.796 -27.539 317.775 1.0 68.31198  ? 801 ASN A ND2 801 ASN A ND2 1 
ATOM 6336  N N   . TRP A 1 802 ? 286.023 -28.932 316.543 1.0 67.77315  ? 802 TRP A N   802 TRP A N   1 
ATOM 6337  C CA  . TRP A 1 802 ? 285.408 -28.375 315.353 1.0 67.77315  ? 802 TRP A CA  802 TRP A CA  1 
ATOM 6338  C C   . TRP A 1 802 ? 284.425 -29.406 314.842 1.0 67.77315  ? 802 TRP A C   802 TRP A C   1 
ATOM 6339  O O   . TRP A 1 802 ? 284.759 -30.597 314.829 1.0 67.77315  ? 802 TRP A O   802 TRP A O   1 
ATOM 6340  C CB  . TRP A 1 802 ? 286.463 -28.050 314.292 1.0 67.77315  ? 802 TRP A CB  802 TRP A CB  1 
ATOM 6341  C CG  . TRP A 1 802 ? 285.933 -27.379 313.085 1.0 67.77315  ? 802 TRP A CG  802 TRP A CG  1 
ATOM 6342  C CD1 . TRP A 1 802 ? 285.697 -27.956 311.886 1.0 67.77315  ? 802 TRP A CD1 802 TRP A CD1 1 
ATOM 6343  C CD2 . TRP A 1 802 ? 285.572 -25.999 312.951 1.0 67.77315  ? 802 TRP A CD2 802 TRP A CD2 1 
ATOM 6344  N NE1 . TRP A 1 802 ? 285.210 -27.024 311.002 1.0 67.77315  ? 802 TRP A NE1 802 TRP A NE1 1 
ATOM 6345  C CE2 . TRP A 1 802 ? 285.120 -25.814 311.635 1.0 67.77315  ? 802 TRP A CE2 802 TRP A CE2 1 
ATOM 6346  C CE3 . TRP A 1 802 ? 285.586 -24.906 313.818 1.0 67.77315  ? 802 TRP A CE3 802 TRP A CE3 1 
ATOM 6347  C CZ2 . TRP A 1 802 ? 284.690 -24.586 311.160 1.0 67.77315  ? 802 TRP A CZ2 802 TRP A CZ2 1 
ATOM 6348  C CZ3 . TRP A 1 802 ? 285.159 -23.685 313.345 1.0 67.77315  ? 802 TRP A CZ3 802 TRP A CZ3 1 
ATOM 6349  C CH2 . TRP A 1 802 ? 284.715 -23.535 312.029 1.0 67.77315  ? 802 TRP A CH2 802 TRP A CH2 1 
ATOM 6350  N N   . PRO A 1 803 ? 283.220 -29.010 314.421 1.0 67.90075  ? 803 PRO A N   803 PRO A N   1 
ATOM 6351  C CA  . PRO A 1 803 ? 282.662 -27.659 314.316 1.0 67.90075  ? 803 PRO A CA  803 PRO A CA  1 
ATOM 6352  C C   . PRO A 1 803 ? 282.042 -27.164 315.609 1.0 67.90075  ? 803 PRO A C   803 PRO A C   1 
ATOM 6353  O O   . PRO A 1 803 ? 282.323 -27.708 316.668 1.0 67.90075  ? 803 PRO A O   803 PRO A O   1 
ATOM 6354  C CB  . PRO A 1 803 ? 281.585 -27.821 313.250 1.0 67.90075  ? 803 PRO A CB  803 PRO A CB  1 
ATOM 6355  C CG  . PRO A 1 803 ? 281.127 -29.211 313.428 1.0 67.90075  ? 803 PRO A CG  803 PRO A CG  1 
ATOM 6356  C CD  . PRO A 1 803 ? 282.327 -30.012 313.818 1.0 67.90075  ? 803 PRO A CD  803 PRO A CD  1 
ATOM 6357  N N   . TYR A 1 804 ? 281.233 -26.167 315.516 1.0 67.82982  ? 804 TYR A N   804 TYR A N   1 
ATOM 6358  C CA  . TYR A 1 804 ? 280.548 -25.752 316.725 1.0 67.82982  ? 804 TYR A CA  804 TYR A CA  1 
ATOM 6359  C C   . TYR A 1 804 ? 279.235 -26.509 316.870 1.0 67.82982  ? 804 TYR A C   804 TYR A C   1 
ATOM 6360  O O   . TYR A 1 804 ? 278.619 -26.883 315.870 1.0 67.82982  ? 804 TYR A O   804 TYR A O   1 
ATOM 6361  C CB  . TYR A 1 804 ? 280.272 -24.257 316.691 1.0 67.82982  ? 804 TYR A CB  804 TYR A CB  1 
ATOM 6362  C CG  . TYR A 1 804 ? 281.515 -23.422 316.771 1.0 67.82982  ? 804 TYR A CG  804 TYR A CG  1 
ATOM 6363  C CD1 . TYR A 1 804 ? 282.160 -23.229 317.981 1.0 67.82982  ? 804 TYR A CD1 804 TYR A CD1 1 
ATOM 6364  C CD2 . TYR A 1 804 ? 282.040 -22.820 315.640 1.0 67.82982  ? 804 TYR A CD2 804 TYR A CD2 1 
ATOM 6365  C CE1 . TYR A 1 804 ? 283.296 -22.465 318.063 1.0 67.82982  ? 804 TYR A CE1 804 TYR A CE1 1 
ATOM 6366  C CE2 . TYR A 1 804 ? 283.174 -22.053 315.712 1.0 67.82982  ? 804 TYR A CE2 804 TYR A CE2 1 
ATOM 6367  C CZ  . TYR A 1 804 ? 283.797 -21.881 316.925 1.0 67.82982  ? 804 TYR A CZ  804 TYR A CZ  1 
ATOM 6368  O OH  . TYR A 1 804 ? 284.929 -21.117 317.001 1.0 67.82982  ? 804 TYR A OH  804 TYR A OH  1 
ATOM 6369  N N   . PRO A 1 805 ? 278.785 -26.774 318.096 1.0 67.19759  ? 805 PRO A N   805 PRO A N   1 
ATOM 6370  C CA  . PRO A 1 805 ? 277.471 -27.404 318.275 1.0 67.19759  ? 805 PRO A CA  805 PRO A CA  1 
ATOM 6371  C C   . PRO A 1 805 ? 276.355 -26.428 317.929 1.0 67.19759  ? 805 PRO A C   805 PRO A C   1 
ATOM 6372  O O   . PRO A 1 805 ? 276.186 -25.396 318.579 1.0 67.19759  ? 805 PRO A O   805 PRO A O   1 
ATOM 6373  C CB  . PRO A 1 805 ? 277.459 -27.785 319.759 1.0 67.19759  ? 805 PRO A CB  805 PRO A CB  1 
ATOM 6374  C CG  . PRO A 1 805 ? 278.440 -26.877 320.394 1.0 67.19759  ? 805 PRO A CG  805 PRO A CG  1 
ATOM 6375  C CD  . PRO A 1 805 ? 279.506 -26.641 319.373 1.0 67.19759  ? 805 PRO A CD  805 PRO A CD  1 
ATOM 6376  N N   . LEU A 1 806 ? 275.606 -26.751 316.883 1.0 65.23572  ? 806 LEU A N   806 LEU A N   1 
ATOM 6377  C CA  . LEU A 1 806 ? 274.479 -25.926 316.487 1.0 65.23572  ? 806 LEU A CA  806 LEU A CA  1 
ATOM 6378  C C   . LEU A 1 806 ? 273.203 -26.297 317.221 1.0 65.23572  ? 806 LEU A C   806 LEU A C   1 
ATOM 6379  O O   . LEU A 1 806 ? 272.257 -25.503 317.230 1.0 65.23572  ? 806 LEU A O   806 LEU A O   1 
ATOM 6380  C CB  . LEU A 1 806 ? 274.250 -26.036 314.982 1.0 65.23572  ? 806 LEU A CB  806 LEU A CB  1 
ATOM 6381  C CG  . LEU A 1 806 ? 275.435 -25.563 314.144 1.0 65.23572  ? 806 LEU A CG  806 LEU A CG  1 
ATOM 6382  C CD1 . LEU A 1 806 ? 275.166 -25.776 312.664 1.0 65.23572  ? 806 LEU A CD1 806 LEU A CD1 1 
ATOM 6383  C CD2 . LEU A 1 806 ? 275.771 -24.117 314.441 1.0 65.23572  ? 806 LEU A CD2 806 LEU A CD2 1 
ATOM 6384  N N   . SER A 1 807 ? 273.158 -27.472 317.836 1.0 66.05892  ? 807 SER A N   807 SER A N   1 
ATOM 6385  C CA  . SER A 1 807 ? 271.988 -27.933 318.559 1.0 66.05892  ? 807 SER A CA  807 SER A CA  1 
ATOM 6386  C C   . SER A 1 807 ? 272.451 -28.456 319.910 1.0 66.05892  ? 807 SER A C   807 SER A C   1 
ATOM 6387  O O   . SER A 1 807 ? 273.619 -28.322 320.283 1.0 66.05892  ? 807 SER A O   807 SER A O   1 
ATOM 6388  C CB  . SER A 1 807 ? 271.248 -29.002 317.752 1.0 66.05892  ? 807 SER A CB  807 SER A CB  1 
ATOM 6389  O OG  . SER A 1 807 ? 272.047 -30.163 317.630 1.0 66.05892  ? 807 SER A OG  807 SER A OG  1 
ATOM 6390  N N   . GLY A 1 808 ? 271.533 -29.060 320.647 1.0 68.70391  ? 808 GLY A N   808 GLY A N   1 
ATOM 6391  C CA  . GLY A 1 808 ? 271.880 -29.669 321.910 1.0 68.70391  ? 808 GLY A CA  808 GLY A CA  1 
ATOM 6392  C C   . GLY A 1 808 ? 271.686 -28.736 323.088 1.0 68.70391  ? 808 GLY A C   808 GLY A C   1 
ATOM 6393  O O   . GLY A 1 808 ? 270.998 -27.714 323.022 1.0 68.70391  ? 808 GLY A O   808 GLY A O   1 
ATOM 6394  N N   . ARG A 1 809 ? 272.324 -29.110 324.197 1.0 72.58188  ? 809 ARG A N   809 ARG A N   1 
ATOM 6395  C CA  . ARG A 1 809 ? 272.148 -28.391 325.451 1.0 72.58188  ? 809 ARG A CA  809 ARG A CA  1 
ATOM 6396  C C   . ARG A 1 809 ? 272.985 -27.120 325.500 1.0 72.58188  ? 809 ARG A C   809 ARG A C   1 
ATOM 6397  O O   . ARG A 1 809 ? 272.586 -26.141 326.140 1.0 72.58188  ? 809 ARG A O   809 ARG A O   1 
ATOM 6398  C CB  . ARG A 1 809 ? 272.498 -29.319 326.616 1.0 72.58188  ? 809 ARG A CB  809 ARG A CB  1 
ATOM 6399  C CG  . ARG A 1 809 ? 272.177 -28.779 327.997 1.0 72.58188  ? 809 ARG A CG  809 ARG A CG  1 
ATOM 6400  C CD  . ARG A 1 809 ? 272.484 -29.806 329.073 1.0 72.58188  ? 809 ARG A CD  809 ARG A CD  1 
ATOM 6401  N NE  . ARG A 1 809 ? 273.906 -30.131 329.136 1.0 72.58188  ? 809 ARG A NE  809 ARG A NE  1 
ATOM 6402  C CZ  . ARG A 1 809 ? 274.409 -31.321 328.828 1.0 72.58188  ? 809 ARG A CZ  809 ARG A CZ  1 
ATOM 6403  N NH1 . ARG A 1 809 ? 273.606 -32.296 328.433 1.0 72.58188  ? 809 ARG A NH1 809 ARG A NH1 1 
ATOM 6404  N NH2 . ARG A 1 809 ? 275.714 -31.533 328.912 1.0 72.58188  ? 809 ARG A NH2 809 ARG A NH2 1 
ATOM 6405  N N   . ASN A 1 810 ? 274.117 -27.099 324.804 1.0 70.90378  ? 810 ASN A N   810 ASN A N   1 
ATOM 6406  C CA  . ASN A 1 810 ? 274.998 -25.940 324.809 1.0 70.90378  ? 810 ASN A CA  810 ASN A CA  1 
ATOM 6407  C C   . ASN A 1 810 ? 275.244 -25.431 323.394 1.0 70.90378  ? 810 ASN A C   810 ASN A C   1 
ATOM 6408  O O   . ASN A 1 810 ? 276.392 -25.225 322.990 1.0 70.90378  ? 810 ASN A O   810 ASN A O   1 
ATOM 6409  C CB  . ASN A 1 810 ? 276.308 -26.281 325.522 1.0 70.90378  ? 810 ASN A CB  810 ASN A CB  1 
ATOM 6410  C CG  . ASN A 1 810 ? 276.940 -27.552 325.003 1.0 70.90378  ? 810 ASN A CG  810 ASN A CG  1 
ATOM 6411  O OD1 . ASN A 1 810 ? 276.445 -28.171 324.065 1.0 70.90378  ? 810 ASN A OD1 810 ASN A OD1 1 
ATOM 6412  N ND2 . ASN A 1 810 ? 278.042 -27.954 325.617 1.0 70.90378  ? 810 ASN A ND2 810 ASN A ND2 1 
ATOM 6413  N N   . ALA A 1 811 ? 274.165 -25.249 322.636 1.0 69.80737  ? 811 ALA A N   811 ALA A N   1 
ATOM 6414  C CA  . ALA A 1 811 ? 274.259 -24.764 321.269 1.0 69.80737  ? 811 ALA A CA  811 ALA A CA  1 
ATOM 6415  C C   . ALA A 1 811 ? 274.730 -23.318 321.237 1.0 69.80737  ? 811 ALA A C   811 ALA A C   1 
ATOM 6416  O O   . ALA A 1 811 ? 274.457 -22.530 322.144 1.0 69.80737  ? 811 ALA A O   811 ALA A O   1 
ATOM 6417  C CB  . ALA A 1 811 ? 272.909 -24.881 320.567 1.0 69.80737  ? 811 ALA A CB  811 ALA A CB  1 
ATOM 6418  N N   . VAL A 1 812 ? 275.448 -22.978 320.176 1.0 68.79085  ? 812 VAL A N   812 VAL A N   1 
ATOM 6419  C CA  . VAL A 1 812 ? 276.028 -21.638 320.054 1.0 68.79085  ? 812 VAL A CA  812 VAL A CA  1 
ATOM 6420  C C   . VAL A 1 812 ? 274.921 -20.632 319.739 1.0 68.79085  ? 812 VAL A C   812 VAL A C   1 
ATOM 6421  O O   . VAL A 1 812 ? 274.035 -20.919 318.913 1.0 68.79085  ? 812 VAL A O   812 VAL A O   1 
ATOM 6422  C CB  . VAL A 1 812 ? 277.145 -21.639 318.995 1.0 68.79085  ? 812 VAL A CB  812 VAL A CB  1 
ATOM 6423  C CG1 . VAL A 1 812 ? 276.673 -22.202 317.661 1.0 68.79085  ? 812 VAL A CG1 812 VAL A CG1 1 
ATOM 6424  C CG2 . VAL A 1 812 ? 277.730 -20.254 318.809 1.0 68.79085  ? 812 VAL A CG2 812 VAL A CG2 1 
ATOM 6425  N N   . PRO A 1 813 ? 274.862 -19.494 320.431 1.0 70.29649  ? 813 PRO A N   813 PRO A N   1 
ATOM 6426  C CA  . PRO A 1 813 ? 273.778 -18.539 320.176 1.0 70.29649  ? 813 PRO A CA  813 PRO A CA  1 
ATOM 6427  C C   . PRO A 1 813 ? 274.080 -17.596 319.026 1.0 70.29649  ? 813 PRO A C   813 PRO A C   1 
ATOM 6428  O O   . PRO A 1 813 ? 275.157 -17.666 318.425 1.0 70.29649  ? 813 PRO A O   813 PRO A O   1 
ATOM 6429  C CB  . PRO A 1 813 ? 273.670 -17.780 321.500 1.0 70.29649  ? 813 PRO A CB  813 PRO A CB  1 
ATOM 6430  C CG  . PRO A 1 813 ? 275.045 -17.827 322.049 1.0 70.29649  ? 813 PRO A CG  813 PRO A CG  1 
ATOM 6431  C CD  . PRO A 1 813 ? 275.611 -19.159 321.653 1.0 70.29649  ? 813 PRO A CD  813 PRO A CD  1 
ATOM 6432  N N   . ASN A 1 814 ? 273.107 -16.727 318.719 1.0 73.14904  ? 814 ASN A N   814 ASN A N   1 
ATOM 6433  C CA  . ASN A 1 814 ? 273.218 -15.641 317.735 1.0 73.14904  ? 814 ASN A CA  814 ASN A CA  1 
ATOM 6434  C C   . ASN A 1 814 ? 273.537 -16.145 316.328 1.0 73.14904  ? 814 ASN A C   814 ASN A C   1 
ATOM 6435  O O   . ASN A 1 814 ? 274.139 -15.428 315.527 1.0 73.14904  ? 814 ASN A O   814 ASN A O   1 
ATOM 6436  C CB  . ASN A 1 814 ? 274.247 -14.591 318.171 1.0 73.14904  ? 814 ASN A CB  814 ASN A CB  1 
ATOM 6437  C CG  . ASN A 1 814 ? 273.794 -13.789 319.375 1.0 73.14904  ? 814 ASN A CG  814 ASN A CG  1 
ATOM 6438  O OD1 . ASN A 1 814 ? 272.638 -13.374 319.461 1.0 73.14904  ? 814 ASN A OD1 814 ASN A OD1 1 
ATOM 6439  N ND2 . ASN A 1 814 ? 274.705 -13.570 320.315 1.0 73.14904  ? 814 ASN A ND2 814 ASN A ND2 1 
ATOM 6440  N N   . GLN A 1 815 ? 273.122 -17.363 315.999 1.0 66.56973  ? 815 GLN A N   815 GLN A N   1 
ATOM 6441  C CA  . GLN A 1 815 ? 273.419 -17.944 314.700 1.0 66.56973  ? 815 GLN A CA  815 GLN A CA  1 
ATOM 6442  C C   . GLN A 1 815 ? 272.424 -17.465 313.649 1.0 66.56973  ? 815 GLN A C   815 GLN A C   1 
ATOM 6443  O O   . GLN A 1 815 ? 271.295 -17.081 313.964 1.0 66.56973  ? 815 GLN A O   815 GLN A O   1 
ATOM 6444  C CB  . GLN A 1 815 ? 273.421 -19.467 314.794 1.0 66.56973  ? 815 GLN A CB  815 GLN A CB  1 
ATOM 6445  C CG  . GLN A 1 815 ? 272.105 -20.077 315.204 1.0 66.56973  ? 815 GLN A CG  815 GLN A CG  1 
ATOM 6446  C CD  . GLN A 1 815 ? 272.239 -21.552 315.464 1.0 66.56973  ? 815 GLN A CD  815 GLN A CD  1 
ATOM 6447  O OE1 . GLN A 1 815 ? 273.322 -22.109 315.343 1.0 66.56973  ? 815 GLN A OE1 815 GLN A OE1 1 
ATOM 6448  N NE2 . GLN A 1 815 ? 271.144 -22.195 315.808 1.0 66.56973  ? 815 GLN A NE2 815 GLN A NE2 1 
ATOM 6449  N N   . VAL A 1 816 ? 272.860 -17.483 312.391 1.0 63.15537  ? 816 VAL A N   816 VAL A N   1 
ATOM 6450  C CA  . VAL A 1 816 ? 272.144 -16.853 311.289 1.0 63.15537  ? 816 VAL A CA  816 VAL A CA  1 
ATOM 6451  C C   . VAL A 1 816 ? 271.780 -17.922 310.263 1.0 63.15537  ? 816 VAL A C   816 VAL A C   1 
ATOM 6452  O O   . VAL A 1 816 ? 272.505 -18.909 310.094 1.0 63.15537  ? 816 VAL A O   816 VAL A O   1 
ATOM 6453  C CB  . VAL A 1 816 ? 272.984 -15.700 310.679 1.0 63.15537  ? 816 VAL A CB  816 VAL A CB  1 
ATOM 6454  C CG1 . VAL A 1 816 ? 274.252 -16.200 310.002 1.0 63.15537  ? 816 VAL A CG1 816 VAL A CG1 1 
ATOM 6455  C CG2 . VAL A 1 816 ? 272.165 -14.824 309.735 1.0 63.15537  ? 816 VAL A CG2 816 VAL A CG2 1 
ATOM 6456  N N   . THR A 1 817 ? 270.627 -17.751 309.619 1.0 61.25283  ? 817 THR A N   817 THR A N   1 
ATOM 6457  C CA  . THR A 1 817 ? 270.059 -18.743 308.717 1.0 61.25283  ? 817 THR A CA  817 THR A CA  1 
ATOM 6458  C C   . THR A 1 817 ? 270.366 -18.369 307.270 1.0 61.25283  ? 817 THR A C   817 THR A C   1 
ATOM 6459  O O   . THR A 1 817 ? 270.354 -17.194 306.900 1.0 61.25283  ? 817 THR A O   817 THR A O   1 
ATOM 6460  C CB  . THR A 1 817 ? 268.546 -18.830 308.938 1.0 61.25283  ? 817 THR A CB  817 THR A CB  1 
ATOM 6461  O OG1 . THR A 1 817 ? 268.289 -18.978 310.337 1.0 61.25283  ? 817 THR A OG1 817 THR A OG1 1 
ATOM 6462  C CG2 . THR A 1 817 ? 267.937 -20.029 308.223 1.0 61.25283  ? 817 THR A CG2 817 THR A CG2 1 
ATOM 6463  N N   . GLU A 1 818 ? 270.649 -19.383 306.451 1.0 61.97508  ? 818 GLU A N   818 GLU A N   1 
ATOM 6464  C CA  . GLU A 1 818 ? 271.028 -19.181 305.057 1.0 61.97508  ? 818 GLU A CA  818 GLU A CA  1 
ATOM 6465  C C   . GLU A 1 818 ? 270.176 -20.074 304.167 1.0 61.97508  ? 818 GLU A C   818 GLU A C   1 
ATOM 6466  O O   . GLU A 1 818 ? 270.145 -21.291 304.361 1.0 61.97508  ? 818 GLU A O   818 GLU A O   1 
ATOM 6467  C CB  . GLU A 1 818 ? 272.515 -19.479 304.860 1.0 61.97508  ? 818 GLU A CB  818 GLU A CB  1 
ATOM 6468  C CG  . GLU A 1 818 ? 273.032 -19.234 303.459 1.0 61.97508  ? 818 GLU A CG  818 GLU A CG  1 
ATOM 6469  C CD  . GLU A 1 818 ? 274.528 -19.450 303.361 1.0 61.97508  ? 818 GLU A CD  818 GLU A CD  1 
ATOM 6470  O OE1 . GLU A 1 818 ? 275.144 -19.770 304.398 1.0 61.97508  ? 818 GLU A OE1 818 GLU A OE1 1 
ATOM 6471  O OE2 . GLU A 1 818 ? 275.086 -19.313 302.252 1.0 61.97508  ? 818 GLU A OE2 818 GLU A OE2 1 
ATOM 6472  N N   . ARG A 1 819 ? 269.494 -19.475 303.194 1.0 60.41598  ? 819 ARG A N   819 ARG A N   1 
ATOM 6473  C CA  . ARG A 1 819 ? 268.612 -20.184 302.278 1.0 60.41598  ? 819 ARG A CA  819 ARG A CA  1 
ATOM 6474  C C   . ARG A 1 819 ? 269.162 -20.144 300.860 1.0 60.41598  ? 819 ARG A C   819 ARG A C   1 
ATOM 6475  O O   . ARG A 1 819 ? 269.760 -19.150 300.440 1.0 60.41598  ? 819 ARG A O   819 ARG A O   1 
ATOM 6476  C CB  . ARG A 1 819 ? 267.205 -19.574 302.259 1.0 60.41598  ? 819 ARG A CB  819 ARG A CB  1 
ATOM 6477  C CG  . ARG A 1 819 ? 266.253 -20.024 303.351 1.0 60.41598  ? 819 ARG A CG  819 ARG A CG  1 
ATOM 6478  C CD  . ARG A 1 819 ? 266.509 -19.323 304.667 1.0 60.41598  ? 819 ARG A CD  819 ARG A CD  1 
ATOM 6479  N NE  . ARG A 1 819 ? 265.545 -19.713 305.689 1.0 60.41598  ? 819 ARG A NE  819 ARG A NE  1 
ATOM 6480  C CZ  . ARG A 1 819 ? 264.388 -19.099 305.897 1.0 60.41598  ? 819 ARG A CZ  819 ARG A CZ  1 
ATOM 6481  N NH1 . ARG A 1 819 ? 264.042 -18.058 305.160 1.0 60.41598  ? 819 ARG A NH1 819 ARG A NH1 1 
ATOM 6482  N NH2 . ARG A 1 819 ? 263.576 -19.525 306.850 1.0 60.41598  ? 819 ARG A NH2 819 ARG A NH2 1 
ATOM 6483  N N   . LYS A 1 820 ? 268.940 -21.229 300.121 1.0 57.01947  ? 820 LYS A N   820 LYS A N   1 
ATOM 6484  C CA  . LYS A 1 820 ? 269.117 -21.239 298.673 1.0 57.01947  ? 820 LYS A CA  820 LYS A CA  1 
ATOM 6485  C C   . LYS A 1 820 ? 268.263 -22.360 298.100 1.0 57.01947  ? 820 LYS A C   820 LYS A C   1 
ATOM 6486  O O   . LYS A 1 820 ? 267.607 -23.105 298.831 1.0 57.01947  ? 820 LYS A O   820 LYS A O   1 
ATOM 6487  C CB  . LYS A 1 820 ? 270.582 -21.405 298.263 1.0 57.01947  ? 820 LYS A CB  820 LYS A CB  1 
ATOM 6488  C CG  . LYS A 1 820 ? 271.145 -22.786 298.479 1.0 57.01947  ? 820 LYS A CG  820 LYS A CG  1 
ATOM 6489  C CD  . LYS A 1 820 ? 272.585 -22.860 298.004 1.0 57.01947  ? 820 LYS A CD  820 LYS A CD  1 
ATOM 6490  C CE  . LYS A 1 820 ? 273.170 -24.225 298.263 1.0 57.01947  ? 820 LYS A CE  820 LYS A CE  1 
ATOM 6491  N NZ  . LYS A 1 820 ? 272.456 -25.240 297.463 1.0 57.01947  ? 820 LYS A NZ  820 LYS A NZ  1 
ATOM 6492  N N   . PHE A 1 821 ? 268.275 -22.474 296.776 1.0 53.9076   ? 821 PHE A N   821 PHE A N   1 
ATOM 6493  C CA  . PHE A 1 821 ? 267.503 -23.494 296.088 1.0 53.9076   ? 821 PHE A CA  821 PHE A CA  1 
ATOM 6494  C C   . PHE A 1 821 ? 268.292 -23.968 294.880 1.0 53.9076   ? 821 PHE A C   821 PHE A C   1 
ATOM 6495  O O   . PHE A 1 821 ? 269.009 -23.190 294.249 1.0 53.9076   ? 821 PHE A O   821 PHE A O   1 
ATOM 6496  C CB  . PHE A 1 821 ? 266.121 -22.966 295.671 1.0 53.9076   ? 821 PHE A CB  821 PHE A CB  1 
ATOM 6497  C CG  . PHE A 1 821 ? 266.162 -21.829 294.680 1.0 53.9076   ? 821 PHE A CG  821 PHE A CG  1 
ATOM 6498  C CD1 . PHE A 1 821 ? 266.295 -20.521 295.108 1.0 53.9076   ? 821 PHE A CD1 821 PHE A CD1 1 
ATOM 6499  C CD2 . PHE A 1 821 ? 266.013 -22.065 293.327 1.0 53.9076   ? 821 PHE A CD2 821 PHE A CD2 1 
ATOM 6500  C CE1 . PHE A 1 821 ? 266.319 -19.482 294.202 1.0 53.9076   ? 821 PHE A CE1 821 PHE A CE1 1 
ATOM 6501  C CE2 . PHE A 1 821 ? 266.037 -21.033 292.420 1.0 53.9076   ? 821 PHE A CE2 821 PHE A CE2 1 
ATOM 6502  C CZ  . PHE A 1 821 ? 266.188 -19.742 292.858 1.0 53.9076   ? 821 PHE A CZ  821 PHE A CZ  1 
ATOM 6503  N N   . LEU A 1 822 ? 268.159 -25.251 294.565 1.0 55.49983  ? 822 LEU A N   822 LEU A N   1 
ATOM 6504  C CA  . LEU A 1 822 ? 268.750 -25.827 293.367 1.0 55.49983  ? 822 LEU A CA  822 LEU A CA  1 
ATOM 6505  C C   . LEU A 1 822 ? 267.649 -26.230 292.404 1.0 55.49983  ? 822 LEU A C   822 LEU A C   1 
ATOM 6506  O O   . LEU A 1 822 ? 266.739 -26.977 292.772 1.0 55.49983  ? 822 LEU A O   822 LEU A O   1 
ATOM 6507  C CB  . LEU A 1 822 ? 269.618 -27.041 293.682 1.0 55.49983  ? 822 LEU A CB  822 LEU A CB  1 
ATOM 6508  C CG  . LEU A 1 822 ? 270.910 -26.791 294.441 1.0 55.49983  ? 822 LEU A CG  822 LEU A CG  1 
ATOM 6509  C CD1 . LEU A 1 822 ? 271.597 -28.110 294.674 1.0 55.49983  ? 822 LEU A CD1 822 LEU A CD1 1 
ATOM 6510  C CD2 . LEU A 1 822 ? 271.796 -25.847 293.667 1.0 55.49983  ? 822 LEU A CD2 822 LEU A CD2 1 
ATOM 6511  N N   . VAL A 1 823 ? 267.741 -25.738 291.177 1.0 54.18209  ? 823 VAL A N   823 VAL A N   1 
ATOM 6512  C CA  . VAL A 1 823 ? 266.815 -26.080 290.110 1.0 54.18209  ? 823 VAL A CA  823 VAL A CA  1 
ATOM 6513  C C   . VAL A 1 823 ? 267.617 -26.737 289.001 1.0 54.18209  ? 823 VAL A C   823 VAL A C   1 
ATOM 6514  O O   . VAL A 1 823 ? 268.555 -26.133 288.466 1.0 54.18209  ? 823 VAL A O   823 VAL A O   1 
ATOM 6515  C CB  . VAL A 1 823 ? 266.073 -24.848 289.583 1.0 54.18209  ? 823 VAL A CB  823 VAL A CB  1 
ATOM 6516  C CG1 . VAL A 1 823 ? 265.227 -25.224 288.437 1.0 54.18209  ? 823 VAL A CG1 823 VAL A CG1 1 
ATOM 6517  C CG2 . VAL A 1 823 ? 265.209 -24.275 290.645 1.0 54.18209  ? 823 VAL A CG2 823 VAL A CG2 1 
ATOM 6518  N N   . ASP A 1 824 ? 267.256 -27.966 288.658 1.0 56.63478  ? 824 ASP A N   824 ASP A N   1 
ATOM 6519  C CA  . ASP A 1 824 ? 267.912 -28.690 287.586 1.0 56.63478  ? 824 ASP A CA  824 ASP A CA  1 
ATOM 6520  C C   . ASP A 1 824 ? 266.919 -28.965 286.468 1.0 56.63478  ? 824 ASP A C   824 ASP A C   1 
ATOM 6521  O O   . ASP A 1 824 ? 265.723 -29.138 286.715 1.0 56.63478  ? 824 ASP A O   824 ASP A O   1 
ATOM 6522  C CB  . ASP A 1 824 ? 268.507 -30.001 288.088 1.0 56.63478  ? 824 ASP A CB  824 ASP A CB  1 
ATOM 6523  C CG  . ASP A 1 824 ? 269.653 -29.783 289.044 1.0 56.63478  ? 824 ASP A CG  824 ASP A CG  1 
ATOM 6524  O OD1 . ASP A 1 824 ? 270.303 -28.722 288.948 1.0 56.63478  ? 824 ASP A OD1 824 ASP A OD1 1 
ATOM 6525  O OD2 . ASP A 1 824 ? 269.913 -30.668 289.884 1.0 56.63478  ? 824 ASP A OD2 824 ASP A OD2 1 
ATOM 6526  N N   . ARG A 1 825 ? 267.433 -28.953 285.237 1.0 51.89354  ? 825 ARG A N   825 ARG A N   1 
ATOM 6527  C CA  . ARG A 1 825 ? 266.743 -29.395 284.024 1.0 51.89354  ? 825 ARG A CA  825 ARG A CA  1 
ATOM 6528  C C   . ARG A 1 825 ? 265.506 -28.571 283.682 1.0 51.89354  ? 825 ARG A C   825 ARG A C   1 
ATOM 6529  O O   . ARG A 1 825 ? 264.621 -29.067 282.983 1.0 51.89354  ? 825 ARG A O   825 ARG A O   1 
ATOM 6530  C CB  . ARG A 1 825 ? 266.339 -30.873 284.112 1.0 51.89354  ? 825 ARG A CB  825 ARG A CB  1 
ATOM 6531  C CG  . ARG A 1 825 ? 267.471 -31.865 284.174 1.0 51.89354  ? 825 ARG A CG  825 ARG A CG  1 
ATOM 6532  C CD  . ARG A 1 825 ? 266.916 -33.273 284.068 1.0 51.89354  ? 825 ARG A CD  825 ARG A CD  1 
ATOM 6533  N NE  . ARG A 1 825 ? 266.061 -33.598 285.204 1.0 51.89354  ? 825 ARG A NE  825 ARG A NE  1 
ATOM 6534  C CZ  . ARG A 1 825 ? 266.499 -34.159 286.324 1.0 51.89354  ? 825 ARG A CZ  825 ARG A CZ  1 
ATOM 6535  N NH1 . ARG A 1 825 ? 267.778 -34.466 286.450 1.0 51.89354  ? 825 ARG A NH1 825 ARG A NH1 1 
ATOM 6536  N NH2 . ARG A 1 825 ? 265.659 -34.420 287.313 1.0 51.89354  ? 825 ARG A NH2 825 ARG A NH2 1 
ATOM 6537  N N   . TYR A 1 826 ? 265.385 -27.321 284.131 1.0 49.61901  ? 826 TYR A N   826 TYR A N   1 
ATOM 6538  C CA  . TYR A 1 826 ? 264.077 -26.687 284.007 1.0 49.61901  ? 826 TYR A CA  826 TYR A CA  1 
ATOM 6539  C C   . TYR A 1 826 ? 263.951 -25.684 282.866 1.0 49.61901  ? 826 TYR A C   826 TYR A C   1 
ATOM 6540  O O   . TYR A 1 826 ? 262.923 -25.713 282.177 1.0 49.61901  ? 826 TYR A O   826 TYR A O   1 
ATOM 6541  C CB  . TYR A 1 826 ? 263.653 -26.014 285.308 1.0 49.61901  ? 826 TYR A CB  826 TYR A CB  1 
ATOM 6542  C CG  . TYR A 1 826 ? 262.345 -25.305 285.126 1.0 49.61901  ? 826 TYR A CG  826 TYR A CG  1 
ATOM 6543  C CD1 . TYR A 1 826 ? 261.206 -26.017 284.807 1.0 49.61901  ? 826 TYR A CD1 826 TYR A CD1 1 
ATOM 6544  C CD2 . TYR A 1 826 ? 262.241 -23.938 285.247 1.0 49.61901  ? 826 TYR A CD2 826 TYR A CD2 1 
ATOM 6545  C CE1 . TYR A 1 826 ? 260.014 -25.390 284.585 1.0 49.61901  ? 826 TYR A CE1 826 TYR A CE1 1 
ATOM 6546  C CE2 . TYR A 1 826 ? 261.034 -23.308 285.050 1.0 49.61901  ? 826 TYR A CE2 826 TYR A CE2 1 
ATOM 6547  C CZ  . TYR A 1 826 ? 259.925 -24.040 284.734 1.0 49.61901  ? 826 TYR A CZ  826 TYR A CZ  1 
ATOM 6548  O OH  . TYR A 1 826 ? 258.716 -23.432 284.531 1.0 49.61901  ? 826 TYR A OH  826 TYR A OH  1 
ATOM 6549  N N   . LEU A 1 827 ? 264.943 -24.799 282.670 1.0 48.16682  ? 827 LEU A N   827 LEU A N   1 
ATOM 6550  C CA  . LEU A 1 827 ? 264.898 -23.730 281.665 1.0 48.16682  ? 827 LEU A CA  827 LEU A CA  1 
ATOM 6551  C C   . LEU A 1 827 ? 263.730 -22.775 281.901 1.0 48.16682  ? 827 LEU A C   827 LEU A C   1 
ATOM 6552  O O   . LEU A 1 827 ? 262.664 -22.969 281.307 1.0 48.16682  ? 827 LEU A O   827 LEU A O   1 
ATOM 6553  C CB  . LEU A 1 827 ? 264.890 -24.308 280.242 1.0 48.16682  ? 827 LEU A CB  827 LEU A CB  1 
ATOM 6554  C CG  . LEU A 1 827 ? 264.903 -23.451 278.984 1.0 48.16682  ? 827 LEU A CG  827 LEU A CG  1 
ATOM 6555  C CD1 . LEU A 1 827 ? 266.194 -22.670 278.829 1.0 48.16682  ? 827 LEU A CD1 827 LEU A CD1 1 
ATOM 6556  C CD2 . LEU A 1 827 ? 264.667 -24.369 277.811 1.0 48.16682  ? 827 LEU A CD2 827 LEU A CD2 1 
ATOM 6557  N N   . TRP A 1 828 ? 263.894 -21.870 282.892 1.0 47.70374  ? 828 TRP A N   828 TRP A N   1 
ATOM 6558  C CA  . TRP A 1 828 ? 262.935 -20.824 283.285 1.0 47.70374  ? 828 TRP A CA  828 TRP A CA  1 
ATOM 6559  C C   . TRP A 1 828 ? 262.205 -20.216 282.103 1.0 47.70374  ? 828 TRP A C   828 TRP A C   1 
ATOM 6560  O O   . TRP A 1 828 ? 262.830 -19.789 281.137 1.0 47.70374  ? 828 TRP A O   828 TRP A O   1 
ATOM 6561  C CB  . TRP A 1 828 ? 263.632 -19.655 283.979 1.0 47.70374  ? 828 TRP A CB  828 TRP A CB  1 
ATOM 6562  C CG  . TRP A 1 828 ? 264.322 -19.897 285.241 1.0 47.70374  ? 828 TRP A CG  828 TRP A CG  1 
ATOM 6563  C CD1 . TRP A 1 828 ? 265.656 -19.938 285.428 1.0 47.70374  ? 828 TRP A CD1 828 TRP A CD1 1 
ATOM 6564  C CD2 . TRP A 1 828 ? 263.726 -20.109 286.522 1.0 47.70374  ? 828 TRP A CD2 828 TRP A CD2 1 
ATOM 6565  N NE1 . TRP A 1 828 ? 265.939 -20.156 286.744 1.0 47.70374  ? 828 TRP A NE1 828 TRP A NE1 1 
ATOM 6566  C CE2 . TRP A 1 828 ? 264.769 -20.274 287.440 1.0 47.70374  ? 828 TRP A CE2 828 TRP A CE2 1 
ATOM 6567  C CE3 . TRP A 1 828 ? 262.412 -20.191 286.977 1.0 47.70374  ? 828 TRP A CE3 828 TRP A CE3 1 
ATOM 6568  C CZ2 . TRP A 1 828 ? 264.546 -20.507 288.788 1.0 47.70374  ? 828 TRP A CZ2 828 TRP A CZ2 1 
ATOM 6569  C CZ3 . TRP A 1 828 ? 262.189 -20.417 288.312 1.0 47.70374  ? 828 TRP A CZ3 828 TRP A CZ3 1 
ATOM 6570  C CH2 . TRP A 1 828 ? 263.250 -20.575 289.204 1.0 47.70374  ? 828 TRP A CH2 828 TRP A CH2 1 
ATOM 6571  N N   . GLN A 1 829 ? 260.882 -20.154 282.193 1.0 47.19405  ? 829 GLN A N   829 GLN A N   1 
ATOM 6572  C CA  . GLN A 1 829 ? 260.075 -19.672 281.085 1.0 47.19405  ? 829 GLN A CA  829 GLN A CA  1 
ATOM 6573  C C   . GLN A 1 829 ? 259.255 -18.463 281.503 1.0 47.19405  ? 829 GLN A C   829 GLN A C   1 
ATOM 6574  O O   . GLN A 1 829 ? 258.763 -18.385 282.631 1.0 47.19405  ? 829 GLN A O   829 GLN A O   1 
ATOM 6575  C CB  . GLN A 1 829 ? 259.166 -20.780 280.534 1.0 47.19405  ? 829 GLN A CB  829 GLN A CB  1 
ATOM 6576  C CG  . GLN A 1 829 ? 258.160 -21.355 281.511 1.0 47.19405  ? 829 GLN A CG  829 GLN A CG  1 
ATOM 6577  C CD  . GLN A 1 829 ? 257.351 -22.474 280.900 1.0 47.19405  ? 829 GLN A CD  829 GLN A CD  1 
ATOM 6578  O OE1 . GLN A 1 829 ? 257.507 -22.793 279.723 1.0 47.19405  ? 829 GLN A OE1 829 GLN A OE1 1 
ATOM 6579  N NE2 . GLN A 1 829 ? 256.480 -23.077 281.695 1.0 47.19405  ? 829 GLN A NE2 829 GLN A NE2 1 
ATOM 6580  N N   . ILE A 1 830 ? 259.148 -17.511 280.587 1.0 47.22116  ? 830 ILE A N   830 ILE A N   1 
ATOM 6581  C CA  . ILE A 1 830 ? 258.331 -16.319 280.747 1.0 47.22116  ? 830 ILE A CA  830 ILE A CA  1 
ATOM 6582  C C   . ILE A 1 830 ? 257.320 -16.295 279.610 1.0 47.22116  ? 830 ILE A C   830 ILE A C   1 
ATOM 6583  O O   . ILE A 1 830 ? 257.670 -16.015 278.464 1.0 47.22116  ? 830 ILE A O   830 ILE A O   1 
ATOM 6584  C CB  . ILE A 1 830 ? 259.191 -15.043 280.742 1.0 47.22116  ? 830 ILE A CB  830 ILE A CB  1 
ATOM 6585  C CG1 . ILE A 1 830 ? 260.247 -15.098 281.836 1.0 47.22116  ? 830 ILE A CG1 830 ILE A CG1 1 
ATOM 6586  C CG2 . ILE A 1 830 ? 258.326 -13.828 280.930 1.0 47.22116  ? 830 ILE A CG2 830 ILE A CG2 1 
ATOM 6587  C CD1 . ILE A 1 830 ? 259.663 -15.206 283.190 1.0 47.22116  ? 830 ILE A CD1 830 ILE A CD1 1 
ATOM 6588  N N   . PRO A 1 831 ? 256.057 -16.608 279.882 1.0 46.96817  ? 831 PRO A N   831 PRO A N   1 
ATOM 6589  C CA  . PRO A 1 831 ? 255.068 -16.653 278.803 1.0 46.96817  ? 831 PRO A CA  831 PRO A CA  1 
ATOM 6590  C C   . PRO A 1 831 ? 254.662 -15.255 278.374 1.0 46.96817  ? 831 PRO A C   831 PRO A C   1 
ATOM 6591  O O   . PRO A 1 831 ? 254.601 -14.327 279.182 1.0 46.96817  ? 831 PRO A O   831 PRO A O   1 
ATOM 6592  C CB  . PRO A 1 831 ? 253.895 -17.407 279.436 1.0 46.96817  ? 831 PRO A CB  831 PRO A CB  1 
ATOM 6593  C CG  . PRO A 1 831 ? 254.005 -17.092 280.869 1.0 46.96817  ? 831 PRO A CG  831 PRO A CG  1 
ATOM 6594  C CD  . PRO A 1 831 ? 255.471 -16.986 281.176 1.0 46.96817  ? 831 PRO A CD  831 PRO A CD  1 
ATOM 6595  N N   . PHE A 1 832 ? 254.398 -15.106 277.081 1.0 46.41974  ? 832 PHE A N   832 PHE A N   1 
ATOM 6596  C CA  . PHE A 1 832 ? 254.003 -13.814 276.525 1.0 46.41974  ? 832 PHE A CA  832 PHE A CA  1 
ATOM 6597  C C   . PHE A 1 832 ? 252.477 -13.716 276.501 1.0 46.41974  ? 832 PHE A C   832 PHE A C   1 
ATOM 6598  O O   . PHE A 1 832 ? 251.827 -13.601 275.469 1.0 46.41974  ? 832 PHE A O   832 PHE A O   1 
ATOM 6599  C CB  . PHE A 1 832 ? 254.627 -13.630 275.146 1.0 46.41974  ? 832 PHE A CB  832 PHE A CB  1 
ATOM 6600  C CG  . PHE A 1 832 ? 254.394 -12.278 274.537 1.0 46.41974  ? 832 PHE A CG  832 PHE A CG  1 
ATOM 6601  C CD1 . PHE A 1 832 ? 254.952 -11.146 275.096 1.0 46.41974  ? 832 PHE A CD1 832 PHE A CD1 1 
ATOM 6602  C CD2 . PHE A 1 832 ? 253.664 -12.152 273.371 1.0 46.41974  ? 832 PHE A CD2 832 PHE A CD2 1 
ATOM 6603  C CE1 . PHE A 1 832 ? 254.745 -9.909  274.527 1.0 46.41974  ? 832 PHE A CE1 832 PHE A CE1 1 
ATOM 6604  C CE2 . PHE A 1 832 ? 253.458 -10.923 272.798 1.0 46.41974  ? 832 PHE A CE2 832 PHE A CE2 1 
ATOM 6605  C CZ  . PHE A 1 832 ? 253.998 -9.800  273.377 1.0 46.41974  ? 832 PHE A CZ  832 PHE A CZ  1 
ATOM 6606  N N   . SER A 1 833 ? 251.901 -13.794 277.692 1.0 48.7578   ? 833 SER A N   833 SER A N   1 
ATOM 6607  C CA  . SER A 1 833 ? 250.461 -13.766 277.856 1.0 48.7578   ? 833 SER A CA  833 SER A CA  1 
ATOM 6608  C C   . SER A 1 833 ? 250.099 -12.651 278.821 1.0 48.7578   ? 833 SER A C   833 SER A C   1 
ATOM 6609  O O   . SER A 1 833 ? 250.954 -12.092 279.511 1.0 48.7578   ? 833 SER A O   833 SER A O   1 
ATOM 6610  C CB  . SER A 1 833 ? 249.928 -15.112 278.354 1.0 48.7578   ? 833 SER A CB  833 SER A CB  1 
ATOM 6611  O OG  . SER A 1 833 ? 248.528 -15.059 278.535 1.0 48.7578   ? 833 SER A OG  833 SER A OG  1 
ATOM 6612  N N   . SER A 1 834 ? 248.810 -12.327 278.859 1.0 50.41258  ? 834 SER A N   834 SER A N   1 
ATOM 6613  C CA  . SER A 1 834 ? 248.359 -11.195 279.656 1.0 50.41258  ? 834 SER A CA  834 SER A CA  1 
ATOM 6614  C C   . SER A 1 834 ? 248.247 -11.557 281.130 1.0 50.41258  ? 834 SER A C   834 SER A C   1 
ATOM 6615  O O   . SER A 1 834 ? 248.613 -10.759 281.999 1.0 50.41258  ? 834 SER A O   834 SER A O   1 
ATOM 6616  C CB  . SER A 1 834 ? 247.020 -10.697 279.123 1.0 50.41258  ? 834 SER A CB  834 SER A CB  1 
ATOM 6617  O OG  . SER A 1 834 ? 247.142 -10.218 277.798 1.0 50.41258  ? 834 SER A OG  834 SER A OG  1 
ATOM 6618  N N   . ASN A 1 835 ? 247.741 -12.751 281.425 1.0 49.97373  ? 835 ASN A N   835 ASN A N   1 
ATOM 6619  C CA  . ASN A 1 835 ? 247.611 -13.251 282.784 1.0 49.97373  ? 835 ASN A CA  835 ASN A CA  1 
ATOM 6620  C C   . ASN A 1 835 ? 248.573 -14.396 283.070 1.0 49.97373  ? 835 ASN A C   835 ASN A C   1 
ATOM 6621  O O   . ASN A 1 835 ? 248.375 -15.134 284.039 1.0 49.97373  ? 835 ASN A O   835 ASN A O   1 
ATOM 6622  C CB  . ASN A 1 835 ? 246.166 -13.679 283.038 1.0 49.97373  ? 835 ASN A CB  835 ASN A CB  1 
ATOM 6623  C CG  . ASN A 1 835 ? 245.641 -14.629 281.975 1.0 49.97373  ? 835 ASN A CG  835 ASN A CG  1 
ATOM 6624  O OD1 . ASN A 1 835 ? 246.358 -15.012 281.055 1.0 49.97373  ? 835 ASN A OD1 835 ASN A OD1 1 
ATOM 6625  N ND2 . ASN A 1 835 ? 244.380 -15.015 282.101 1.0 49.97373  ? 835 ASN A ND2 835 ASN A ND2 1 
ATOM 6626  N N   . PHE A 1 836 ? 249.578 -14.578 282.208 1.0 49.31764  ? 836 PHE A N   836 PHE A N   1 
ATOM 6627  C CA  . PHE A 1 836 ? 250.626 -15.598 282.300 1.0 49.31764  ? 836 PHE A CA  836 PHE A CA  1 
ATOM 6628  C C   . PHE A 1 836 ? 250.084 -17.024 282.282 1.0 49.31764  ? 836 PHE A C   836 PHE A C   1 
ATOM 6629  O O   . PHE A 1 836 ? 250.773 -17.951 282.705 1.0 49.31764  ? 836 PHE A O   836 PHE A O   1 
ATOM 6630  C CB  . PHE A 1 836 ? 251.513 -15.391 283.534 1.0 49.31764  ? 836 PHE A CB  836 PHE A CB  1 
ATOM 6631  C CG  . PHE A 1 836 ? 252.304 -14.124 283.497 1.0 49.31764  ? 836 PHE A CG  836 PHE A CG  1 
ATOM 6632  C CD1 . PHE A 1 836 ? 253.444 -14.034 282.723 1.0 49.31764  ? 836 PHE A CD1 836 PHE A CD1 1 
ATOM 6633  C CD2 . PHE A 1 836 ? 251.913 -13.026 284.238 1.0 49.31764  ? 836 PHE A CD2 836 PHE A CD2 1 
ATOM 6634  C CE1 . PHE A 1 836 ? 254.179 -12.872 282.680 1.0 49.31764  ? 836 PHE A CE1 836 PHE A CE1 1 
ATOM 6635  C CE2 . PHE A 1 836 ? 252.645 -11.859 284.202 1.0 49.31764  ? 836 PHE A CE2 836 PHE A CE2 1 
ATOM 6636  C CZ  . PHE A 1 836 ? 253.780 -11.784 283.421 1.0 49.31764  ? 836 PHE A CZ  836 PHE A CZ  1 
ATOM 6637  N N   . LEU A 1 837 ? 248.874 -17.238 281.783 1.0 49.17174  ? 837 LEU A N   837 LEU A N   1 
ATOM 6638  C CA  . LEU A 1 837 ? 248.278 -18.563 281.758 1.0 49.17174  ? 837 LEU A CA  837 LEU A CA  1 
ATOM 6639  C C   . LEU A 1 837 ? 248.358 -19.155 280.358 1.0 49.17174  ? 837 LEU A C   837 LEU A C   1 
ATOM 6640  O O   . LEU A 1 837 ? 248.746 -18.496 279.393 1.0 49.17174  ? 837 LEU A O   837 LEU A O   1 
ATOM 6641  C CB  . LEU A 1 837 ? 246.823 -18.511 282.223 1.0 49.17174  ? 837 LEU A CB  837 LEU A CB  1 
ATOM 6642  C CG  . LEU A 1 837 ? 246.574 -18.061 283.658 1.0 49.17174  ? 837 LEU A CG  837 LEU A CG  1 
ATOM 6643  C CD1 . LEU A 1 837 ? 245.089 -17.992 283.932 1.0 49.17174  ? 837 LEU A CD1 837 LEU A CD1 1 
ATOM 6644  C CD2 . LEU A 1 837 ? 247.249 -18.987 284.632 1.0 49.17174  ? 837 LEU A CD2 837 LEU A CD2 1 
ATOM 6645  N N   . ASN A 1 838 ? 247.984 -20.429 280.260 1.0 50.66827  ? 838 ASN A N   838 ASN A N   1 
ATOM 6646  C CA  . ASN A 1 838 ? 247.935 -21.133 278.982 1.0 50.66827  ? 838 ASN A CA  838 ASN A CA  1 
ATOM 6647  C C   . ASN A 1 838 ? 246.479 -21.176 278.525 1.0 50.66827  ? 838 ASN A C   838 ASN A C   1 
ATOM 6648  O O   . ASN A 1 838 ? 245.782 -22.180 278.656 1.0 50.66827  ? 838 ASN A O   838 ASN A O   1 
ATOM 6649  C CB  . ASN A 1 838 ? 248.533 -22.530 279.118 1.0 50.66827  ? 838 ASN A CB  838 ASN A CB  1 
ATOM 6650  C CG  . ASN A 1 838 ? 249.037 -23.092 277.797 1.0 50.66827  ? 838 ASN A CG  838 ASN A CG  1 
ATOM 6651  O OD1 . ASN A 1 838 ? 249.770 -24.079 277.779 1.0 50.66827  ? 838 ASN A OD1 838 ASN A OD1 1 
ATOM 6652  N ND2 . ASN A 1 838 ? 248.664 -22.462 276.691 1.0 50.66827  ? 838 ASN A ND2 838 ASN A ND2 1 
ATOM 6653  N N   . MET A 1 839 ? 246.019 -20.059 277.973 1.0 49.95218  ? 839 MET A N   839 MET A N   1 
ATOM 6654  C CA  . MET A 1 839 ? 244.713 -20.044 277.336 1.0 49.95218  ? 839 MET A CA  839 MET A CA  1 
ATOM 6655  C C   . MET A 1 839 ? 244.767 -20.514 275.891 1.0 49.95218  ? 839 MET A C   839 MET A C   1 
ATOM 6656  O O   . MET A 1 839 ? 243.712 -20.749 275.295 1.0 49.95218  ? 839 MET A O   839 MET A O   1 
ATOM 6657  C CB  . MET A 1 839 ? 244.108 -18.643 277.398 1.0 49.95218  ? 839 MET A CB  839 MET A CB  1 
ATOM 6658  C CG  . MET A 1 839 ? 243.761 -18.189 278.798 1.0 49.95218  ? 839 MET A CG  839 MET A CG  1 
ATOM 6659  S SD  . MET A 1 839 ? 242.975 -16.572 278.812 1.0 49.95218  ? 839 MET A SD  839 MET A SD  1 
ATOM 6660  C CE  . MET A 1 839 ? 244.376 -15.531 278.437 1.0 49.95218  ? 839 MET A CE  839 MET A CE  1 
ATOM 6661  N N   . GLY A 1 840 ? 245.956 -20.658 275.324 1.0 45.70016  ? 840 GLY A N   840 GLY A N   1 
ATOM 6662  C CA  . GLY A 1 840 ? 246.083 -21.123 273.958 1.0 45.70016  ? 840 GLY A CA  840 GLY A CA  1 
ATOM 6663  C C   . GLY A 1 840 ? 247.541 -21.188 273.562 1.0 45.70016  ? 840 GLY A C   840 GLY A C   1 
ATOM 6664  O O   . GLY A 1 840 ? 248.402 -20.550 274.176 1.0 45.70016  ? 840 GLY A O   840 GLY A O   1 
ATOM 6665  N N   . THR A 1 841 ? 247.803 -21.991 272.529 1.0 42.57906  ? 841 THR A N   841 THR A N   1 
ATOM 6666  C CA  . THR A 1 841 ? 249.144 -22.055 271.957 1.0 42.57906  ? 841 THR A CA  841 THR A CA  1 
ATOM 6667  C C   . THR A 1 841 ? 249.506 -20.727 271.313 1.0 42.57906  ? 841 THR A C   841 THR A C   1 
ATOM 6668  O O   . THR A 1 841 ? 250.527 -20.116 271.645 1.0 42.57906  ? 841 THR A O   841 THR A O   1 
ATOM 6669  C CB  . THR A 1 841 ? 249.236 -23.191 270.939 1.0 42.57906  ? 841 THR A CB  841 THR A CB  1 
ATOM 6670  O OG1 . THR A 1 841 ? 248.948 -24.437 271.583 1.0 42.57906  ? 841 THR A OG1 841 THR A OG1 1 
ATOM 6671  C CG2 . THR A 1 841 ? 250.623 -23.255 270.348 1.0 42.57906  ? 841 THR A CG2 841 THR A CG2 1 
ATOM 6672  N N   . LEU A 1 842 ? 248.673 -20.262 270.390 1.0 44.12401  ? 842 LEU A N   842 LEU A N   1 
ATOM 6673  C CA  . LEU A 1 842 ? 248.697 -18.863 269.991 1.0 44.12401  ? 842 LEU A CA  842 LEU A CA  1 
ATOM 6674  C C   . LEU A 1 842 ? 248.147 -18.051 271.151 1.0 44.12401  ? 842 LEU A C   842 LEU A C   1 
ATOM 6675  O O   . LEU A 1 842 ? 246.947 -18.102 271.430 1.0 44.12401  ? 842 LEU A O   842 LEU A O   1 
ATOM 6676  C CB  . LEU A 1 842 ? 247.870 -18.655 268.726 1.0 44.12401  ? 842 LEU A CB  842 LEU A CB  1 
ATOM 6677  C CG  . LEU A 1 842 ? 247.940 -17.334 267.954 1.0 44.12401  ? 842 LEU A CG  842 LEU A CG  1 
ATOM 6678  C CD1 . LEU A 1 842 ? 247.626 -17.589 266.526 1.0 44.12401  ? 842 LEU A CD1 842 LEU A CD1 1 
ATOM 6679  C CD2 . LEU A 1 842 ? 246.946 -16.344 268.449 1.0 44.12401  ? 842 LEU A CD2 842 LEU A CD2 1 
ATOM 6680  N N   . THR A 1 843 ? 249.011 -17.296 271.817 1.0 45.68202  ? 843 THR A N   843 THR A N   1 
ATOM 6681  C CA  . THR A 1 843 ? 248.606 -16.550 272.996 1.0 45.68202  ? 843 THR A CA  843 THR A CA  1 
ATOM 6682  C C   . THR A 1 843 ? 247.739 -15.351 272.615 1.0 45.68202  ? 843 THR A C   843 THR A C   1 
ATOM 6683  O O   . THR A 1 843 ? 247.567 -15.019 271.441 1.0 45.68202  ? 843 THR A O   843 THR A O   1 
ATOM 6684  C CB  . THR A 1 843 ? 249.835 -16.093 273.765 1.0 45.68202  ? 843 THR A CB  843 THR A CB  1 
ATOM 6685  O OG1 . THR A 1 843 ? 249.430 -15.369 274.931 1.0 45.68202  ? 843 THR A OG1 843 THR A OG1 1 
ATOM 6686  C CG2 . THR A 1 843 ? 250.675 -15.224 272.885 1.0 45.68202  ? 843 THR A CG2 843 THR A CG2 1 
ATOM 6687  N N   . ASP A 1 844 ? 247.183 -14.692 273.633 1.0 49.04705  ? 844 ASP A N   844 ASP A N   1 
ATOM 6688  C CA  . ASP A 1 844 ? 246.271 -13.585 273.369 1.0 49.04705  ? 844 ASP A CA  844 ASP A CA  1 
ATOM 6689  C C   . ASP A 1 844 ? 247.001 -12.311 272.967 1.0 49.04705  ? 844 ASP A C   844 ASP A C   1 
ATOM 6690  O O   . ASP A 1 844 ? 246.475 -11.529 272.170 1.0 49.04705  ? 844 ASP A O   844 ASP A O   1 
ATOM 6691  C CB  . ASP A 1 844 ? 245.371 -13.323 274.582 1.0 49.04705  ? 844 ASP A CB  844 ASP A CB  1 
ATOM 6692  C CG  . ASP A 1 844 ? 246.147 -13.014 275.851 1.0 49.04705  ? 844 ASP A CG  844 ASP A CG  1 
ATOM 6693  O OD1 . ASP A 1 844 ? 247.386 -13.157 275.871 1.0 49.04705  ? 844 ASP A OD1 844 ASP A OD1 1 
ATOM 6694  O OD2 . ASP A 1 844 ? 245.503 -12.605 276.839 1.0 49.04705  ? 844 ASP A OD2 844 ASP A OD2 1 
ATOM 6695  N N   . LEU A 1 845 ? 248.198 -12.080 273.503 1.0 46.57658  ? 845 LEU A N   845 LEU A N   1 
ATOM 6696  C CA  . LEU A 1 845 ? 248.998 -10.946 273.065 1.0 46.57658  ? 845 LEU A CA  845 LEU A CA  1 
ATOM 6697  C C   . LEU A 1 845 ? 249.642 -11.181 271.708 1.0 46.57658  ? 845 LEU A C   845 LEU A C   1 
ATOM 6698  O O   . LEU A 1 845 ? 250.077 -10.219 271.070 1.0 46.57658  ? 845 LEU A O   845 LEU A O   1 
ATOM 6699  C CB  . LEU A 1 845 ? 250.076 -10.631 274.098 1.0 46.57658  ? 845 LEU A CB  845 LEU A CB  1 
ATOM 6700  C CG  . LEU A 1 845 ? 249.589 -10.084 275.434 1.0 46.57658  ? 845 LEU A CG  845 LEU A CG  1 
ATOM 6701  C CD1 . LEU A 1 845 ? 250.742 -9.978  276.399 1.0 46.57658  ? 845 LEU A CD1 845 LEU A CD1 1 
ATOM 6702  C CD2 . LEU A 1 845 ? 248.953 -8.732  275.232 1.0 46.57658  ? 845 LEU A CD2 845 LEU A CD2 1 
ATOM 6703  N N   . GLY A 1 846 ? 249.712 -12.431 271.254 1.0 45.4119   ? 846 GLY A N   846 GLY A N   1 
ATOM 6704  C CA  . GLY A 1 846 ? 250.274 -12.706 269.946 1.0 45.4119   ? 846 GLY A CA  846 GLY A CA  1 
ATOM 6705  C C   . GLY A 1 846 ? 249.367 -12.286 268.810 1.0 45.4119   ? 846 GLY A C   846 GLY A C   1 
ATOM 6706  O O   . GLY A 1 846 ? 249.845 -11.950 267.725 1.0 45.4119   ? 846 GLY A O   846 GLY A O   1 
ATOM 6707  N N   . GLN A 1 847 ? 248.056 -12.303 269.034 1.0 45.88774  ? 847 GLN A N   847 GLN A N   1 
ATOM 6708  C CA  . GLN A 1 847 ? 247.102 -11.797 268.058 1.0 45.88774  ? 847 GLN A CA  847 GLN A CA  1 
ATOM 6709  C C   . GLN A 1 847 ? 246.512 -10.460 268.479 1.0 45.88774  ? 847 GLN A C   847 GLN A C   1 
ATOM 6710  O O   . GLN A 1 847 ? 245.460 -10.059 267.973 1.0 45.88774  ? 847 GLN A O   847 GLN A O   1 
ATOM 6711  C CB  . GLN A 1 847 ? 245.998 -12.822 267.808 1.0 45.88774  ? 847 GLN A CB  847 GLN A CB  1 
ATOM 6712  C CG  . GLN A 1 847 ? 245.156 -13.181 269.012 1.0 45.88774  ? 847 GLN A CG  847 GLN A CG  1 
ATOM 6713  C CD  . GLN A 1 847 ? 244.157 -14.268 268.684 1.0 45.88774  ? 847 GLN A CD  847 GLN A CD  1 
ATOM 6714  O OE1 . GLN A 1 847 ? 244.048 -14.691 267.537 1.0 45.88774  ? 847 GLN A OE1 847 GLN A OE1 1 
ATOM 6715  N NE2 . GLN A 1 847 ? 243.444 -14.746 269.689 1.0 45.88774  ? 847 GLN A NE2 847 GLN A NE2 1 
ATOM 6716  N N   . ASN A 1 848 ? 247.171 -9.765  269.400 1.0 49.11009  ? 848 ASN A N   848 ASN A N   1 
ATOM 6717  C CA  . ASN A 1 848 ? 246.766 -8.413  269.743 1.0 49.11009  ? 848 ASN A CA  848 ASN A CA  1 
ATOM 6718  C C   . ASN A 1 848 ? 247.147 -7.476  268.608 1.0 49.11009  ? 848 ASN A C   848 ASN A C   1 
ATOM 6719  O O   . ASN A 1 848 ? 248.193 -7.635  267.976 1.0 49.11009  ? 848 ASN A O   848 ASN A O   1 
ATOM 6720  C CB  . ASN A 1 848 ? 247.432 -7.971  271.044 1.0 49.11009  ? 848 ASN A CB  848 ASN A CB  1 
ATOM 6721  C CG  . ASN A 1 848 ? 246.812 -6.714  271.625 1.0 49.11009  ? 848 ASN A CG  848 ASN A CG  1 
ATOM 6722  O OD1 . ASN A 1 848 ? 245.850 -6.169  271.086 1.0 49.11009  ? 848 ASN A OD1 848 ASN A OD1 1 
ATOM 6723  N ND2 . ASN A 1 848 ? 247.369 -6.244  272.733 1.0 49.11009  ? 848 ASN A ND2 848 ASN A ND2 1 
ATOM 6724  N N   . VAL A 1 849 ? 246.288 -6.489  268.352 1.0 50.06068  ? 849 VAL A N   849 VAL A N   1 
ATOM 6725  C CA  . VAL A 1 849 ? 246.521 -5.567  267.253 1.0 50.06068  ? 849 VAL A CA  849 VAL A CA  1 
ATOM 6726  C C   . VAL A 1 849 ? 247.645 -4.588  267.584 1.0 50.06068  ? 849 VAL A C   849 VAL A C   1 
ATOM 6727  O O   . VAL A 1 849 ? 248.262 -4.020  266.676 1.0 50.06068  ? 849 VAL A O   849 VAL A O   1 
ATOM 6728  C CB  . VAL A 1 849 ? 245.189 -4.866  266.909 1.0 50.06068  ? 849 VAL A CB  849 VAL A CB  1 
ATOM 6729  C CG1 . VAL A 1 849 ? 244.760 -3.911  268.017 1.0 50.06068  ? 849 VAL A CG1 849 VAL A CG1 1 
ATOM 6730  C CG2 . VAL A 1 849 ? 245.238 -4.175  265.559 1.0 50.06068  ? 849 VAL A CG2 849 VAL A CG2 1 
ATOM 6731  N N   . MET A 1 850 ? 247.964 -4.419  268.869 1.0 50.11082  ? 850 MET A N   850 MET A N   1 
ATOM 6732  C CA  . MET A 1 850 ? 249.012 -3.483  269.257 1.0 50.11082  ? 850 MET A CA  850 MET A CA  1 
ATOM 6733  C C   . MET A 1 850 ? 250.390 -4.044  268.940 1.0 50.11082  ? 850 MET A C   850 MET A C   1 
ATOM 6734  O O   . MET A 1 850 ? 251.308 -3.292  268.597 1.0 50.11082  ? 850 MET A O   850 MET A O   1 
ATOM 6735  C CB  . MET A 1 850 ? 248.875 -3.151  270.745 1.0 50.11082  ? 850 MET A CB  850 MET A CB  1 
ATOM 6736  C CG  . MET A 1 850 ? 249.828 -2.086  271.280 1.0 50.11082  ? 850 MET A CG  850 MET A CG  1 
ATOM 6737  S SD  . MET A 1 850 ? 251.379 -2.722  271.948 1.0 50.11082  ? 850 MET A SD  850 MET A SD  1 
ATOM 6738  C CE  . MET A 1 850 ? 252.246 -1.197  272.295 1.0 50.11082  ? 850 MET A CE  850 MET A CE  1 
ATOM 6739  N N   . TYR A 1 851 ? 250.552 -5.360  269.033 1.0 47.71364  ? 851 TYR A N   851 TYR A N   1 
ATOM 6740  C CA  . TYR A 1 851 ? 251.857 -5.965  268.816 1.0 47.71364  ? 851 TYR A CA  851 TYR A CA  1 
ATOM 6741  C C   . TYR A 1 851 ? 252.022 -6.535  267.421 1.0 47.71364  ? 851 TYR A C   851 TYR A C   1 
ATOM 6742  O O   . TYR A 1 851 ? 253.146 -6.586  266.920 1.0 47.71364  ? 851 TYR A O   851 TYR A O   1 
ATOM 6743  C CB  . TYR A 1 851 ? 252.107 -7.067  269.844 1.0 47.71364  ? 851 TYR A CB  851 TYR A CB  1 
ATOM 6744  C CG  . TYR A 1 851 ? 252.244 -6.542  271.246 1.0 47.71364  ? 851 TYR A CG  851 TYR A CG  1 
ATOM 6745  C CD1 . TYR A 1 851 ? 253.437 -5.992  271.683 1.0 47.71364  ? 851 TYR A CD1 851 TYR A CD1 1 
ATOM 6746  C CD2 . TYR A 1 851 ? 251.177 -6.584  272.129 1.0 47.71364  ? 851 TYR A CD2 851 TYR A CD2 1 
ATOM 6747  C CE1 . TYR A 1 851 ? 253.567 -5.503  272.964 1.0 47.71364  ? 851 TYR A CE1 851 TYR A CE1 1 
ATOM 6748  C CE2 . TYR A 1 851 ? 251.296 -6.098  273.413 1.0 47.71364  ? 851 TYR A CE2 851 TYR A CE2 1 
ATOM 6749  C CZ  . TYR A 1 851 ? 252.493 -5.559  273.824 1.0 47.71364  ? 851 TYR A CZ  851 TYR A CZ  1 
ATOM 6750  O OH  . TYR A 1 851 ? 252.617 -5.074  275.103 1.0 47.71364  ? 851 TYR A OH  851 TYR A OH  1 
ATOM 6751  N N   . ALA A 1 852 ? 250.936 -6.956  266.774 1.0 46.7466   ? 852 ALA A N   852 ALA A N   1 
ATOM 6752  C CA  . ALA A 1 852 ? 251.057 -7.582  265.462 1.0 46.7466   ? 852 ALA A CA  852 ALA A CA  1 
ATOM 6753  C C   . ALA A 1 852 ? 251.278 -6.542  264.371 1.0 46.7466   ? 852 ALA A C   852 ALA A C   1 
ATOM 6754  O O   . ALA A 1 852 ? 252.208 -6.657  263.565 1.0 46.7466   ? 852 ALA A O   852 ALA A O   1 
ATOM 6755  C CB  . ALA A 1 852 ? 249.815 -8.421  265.165 1.0 46.7466   ? 852 ALA A CB  852 ALA A CB  1 
ATOM 6756  N N   . ASN A 1 853 ? 250.437 -5.508  264.333 1.0 47.6042   ? 853 ASN A N   853 ASN A N   1 
ATOM 6757  C CA  . ASN A 1 853 ? 250.474 -4.515  263.267 1.0 47.6042   ? 853 ASN A CA  853 ASN A CA  1 
ATOM 6758  C C   . ASN A 1 853 ? 251.424 -3.361  263.556 1.0 47.6042   ? 853 ASN A C   853 ASN A C   1 
ATOM 6759  O O   . ASN A 1 853 ? 251.270 -2.281  262.976 1.0 47.6042   ? 853 ASN A O   853 ASN A O   1 
ATOM 6760  C CB  . ASN A 1 853 ? 249.069 -3.981  262.998 1.0 47.6042   ? 853 ASN A CB  853 ASN A CB  1 
ATOM 6761  C CG  . ASN A 1 853 ? 248.168 -5.019  262.378 1.0 47.6042   ? 853 ASN A CG  853 ASN A CG  1 
ATOM 6762  O OD1 . ASN A 1 853 ? 248.610 -5.834  261.576 1.0 47.6042   ? 853 ASN A OD1 853 ASN A OD1 1 
ATOM 6763  N ND2 . ASN A 1 853 ? 246.891 -4.977  262.721 1.0 47.6042   ? 853 ASN A ND2 853 ASN A ND2 1 
ATOM 6764  N N   . SER A 1 854 ? 252.404 -3.553  264.432 1.0 50.30341  ? 854 SER A N   854 SER A N   1 
ATOM 6765  C CA  . SER A 1 854 ? 253.349 -2.496  264.752 1.0 50.30341  ? 854 SER A CA  854 SER A CA  1 
ATOM 6766  C C   . SER A 1 854 ? 254.712 -3.118  265.004 1.0 50.30341  ? 854 SER A C   854 SER A C   1 
ATOM 6767  O O   . SER A 1 854 ? 254.831 -4.318  265.260 1.0 50.30341  ? 854 SER A O   854 SER A O   1 
ATOM 6768  C CB  . SER A 1 854 ? 252.890 -1.682  265.965 1.0 50.30341  ? 854 SER A CB  854 SER A CB  1 
ATOM 6769  O OG  . SER A 1 854 ? 253.834 -0.679  266.291 1.0 50.30341  ? 854 SER A OG  854 SER A OG  1 
ATOM 6770  N N   . SER A 1 855 ? 255.744 -2.287  264.927 1.0 51.31054  ? 855 SER A N   855 SER A N   1 
ATOM 6771  C CA  . SER A 1 855 ? 257.119 -2.728  265.096 1.0 51.31054  ? 855 SER A CA  855 SER A CA  1 
ATOM 6772  C C   . SER A 1 855 ? 257.674 -2.185  266.403 1.0 51.31054  ? 855 SER A C   855 SER A C   1 
ATOM 6773  O O   . SER A 1 855 ? 257.623 -0.976  266.647 1.0 51.31054  ? 855 SER A O   855 SER A O   1 
ATOM 6774  C CB  . SER A 1 855 ? 257.987 -2.266  263.928 1.0 51.31054  ? 855 SER A CB  855 SER A CB  1 
ATOM 6775  O OG  . SER A 1 855 ? 258.114 -0.858  263.930 1.0 51.31054  ? 855 SER A OG  855 SER A OG  1 
ATOM 6776  N N   . HIS A 1 856 ? 258.210 -3.076  267.231 1.0 50.58227  ? 856 HIS A N   856 HIS A N   1 
ATOM 6777  C CA  . HIS A 1 856 ? 258.819 -2.704  268.497 1.0 50.58227  ? 856 HIS A CA  856 HIS A CA  1 
ATOM 6778  C C   . HIS A 1 856 ? 260.161 -3.398  268.635 1.0 50.58227  ? 856 HIS A C   856 HIS A C   1 
ATOM 6779  O O   . HIS A 1 856 ? 260.307 -4.559  268.248 1.0 50.58227  ? 856 HIS A O   856 HIS A O   1 
ATOM 6780  C CB  . HIS A 1 856 ? 257.944 -3.092  269.683 1.0 50.58227  ? 856 HIS A CB  856 HIS A CB  1 
ATOM 6781  C CG  . HIS A 1 856 ? 256.641 -2.366  269.737 1.0 50.58227  ? 856 HIS A CG  856 HIS A CG  1 
ATOM 6782  N ND1 . HIS A 1 856 ? 255.498 -2.846  269.140 1.0 50.58227  ? 856 HIS A ND1 856 HIS A ND1 1 
ATOM 6783  C CD2 . HIS A 1 856 ? 256.298 -1.195  270.322 1.0 50.58227  ? 856 HIS A CD2 856 HIS A CD2 1 
ATOM 6784  C CE1 . HIS A 1 856 ? 254.505 -2.003  269.353 1.0 50.58227  ? 856 HIS A CE1 856 HIS A CE1 1 
ATOM 6785  N NE2 . HIS A 1 856 ? 254.964 -0.992  270.069 1.0 50.58227  ? 856 HIS A NE2 856 HIS A NE2 1 
ATOM 6786  N N   . SER A 1 857 ? 261.127 -2.698  269.219 1.0 50.25954  ? 857 SER A N   857 SER A N   1 
ATOM 6787  C CA  . SER A 1 857 ? 262.430 -3.279  269.507 1.0 50.25954  ? 857 SER A CA  857 SER A CA  1 
ATOM 6788  C C   . SER A 1 857 ? 262.350 -4.068  270.810 1.0 50.25954  ? 857 SER A C   857 SER A C   1 
ATOM 6789  O O   . SER A 1 857 ? 261.270 -4.303  271.355 1.0 50.25954  ? 857 SER A O   857 SER A O   1 
ATOM 6790  C CB  . SER A 1 857 ? 263.491 -2.189  269.565 1.0 50.25954  ? 857 SER A CB  857 SER A CB  1 
ATOM 6791  O OG  . SER A 1 857 ? 263.260 -1.331  270.663 1.0 50.25954  ? 857 SER A OG  857 SER A OG  1 
ATOM 6792  N N   . LEU A 1 858 ? 263.496 -4.473  271.348 1.0 50.9615   ? 858 LEU A N   858 LEU A N   1 
ATOM 6793  C CA  . LEU A 1 858 ? 263.496 -5.199  272.615 1.0 50.9615   ? 858 LEU A CA  858 LEU A CA  1 
ATOM 6794  C C   . LEU A 1 858 ? 264.822 -4.974  273.315 1.0 50.9615   ? 858 LEU A C   858 LEU A C   1 
ATOM 6795  O O   . LEU A 1 858 ? 265.869 -5.370  272.796 1.0 50.9615   ? 858 LEU A O   858 LEU A O   1 
ATOM 6796  C CB  . LEU A 1 858 ? 263.263 -6.689  272.396 1.0 50.9615   ? 858 LEU A CB  858 LEU A CB  1 
ATOM 6797  C CG  . LEU A 1 858 ? 263.101 -7.489  273.683 1.0 50.9615   ? 858 LEU A CG  858 LEU A CG  1 
ATOM 6798  C CD1 . LEU A 1 858 ? 261.830 -7.075  274.383 1.0 50.9615   ? 858 LEU A CD1 858 LEU A CD1 1 
ATOM 6799  C CD2 . LEU A 1 858 ? 263.100 -8.970  273.401 1.0 50.9615   ? 858 LEU A CD2 858 LEU A CD2 1 
ATOM 6800  N N   . ASN A 1 859 ? 264.782 -4.347  274.482 1.0 54.81443  ? 859 ASN A N   859 ASN A N   1 
ATOM 6801  C CA  . ASN A 1 859 ? 265.935 -4.237  275.361 1.0 54.81443  ? 859 ASN A CA  859 ASN A CA  1 
ATOM 6802  C C   . ASN A 1 859 ? 265.648 -5.074  276.596 1.0 54.81443  ? 859 ASN A C   859 ASN A C   1 
ATOM 6803  O O   . ASN A 1 859 ? 264.655 -4.836  277.289 1.0 54.81443  ? 859 ASN A O   859 ASN A O   1 
ATOM 6804  C CB  . ASN A 1 859 ? 266.205 -2.783  275.733 1.0 54.81443  ? 859 ASN A CB  859 ASN A CB  1 
ATOM 6805  C CG  . ASN A 1 859 ? 266.545 -1.935  274.530 1.0 54.81443  ? 859 ASN A CG  859 ASN A CG  1 
ATOM 6806  O OD1 . ASN A 1 859 ? 265.779 -1.056  274.140 1.0 54.81443  ? 859 ASN A OD1 859 ASN A OD1 1 
ATOM 6807  N ND2 . ASN A 1 859 ? 267.702 -2.191  273.934 1.0 54.81443  ? 859 ASN A ND2 859 ASN A ND2 1 
ATOM 6808  N N   . MET A 1 860 ? 266.503 -6.054  276.866 1.0 53.70579  ? 860 MET A N   860 MET A N   1 
ATOM 6809  C CA  . MET A 1 860 ? 266.188 -7.040  277.898 1.0 53.70579  ? 860 MET A CA  860 MET A CA  1 
ATOM 6810  C C   . MET A 1 860 ? 267.488 -7.422  278.607 1.0 53.70579  ? 860 MET A C   860 MET A C   1 
ATOM 6811  O O   . MET A 1 860 ? 268.213 -8.312  278.163 1.0 53.70579  ? 860 MET A O   860 MET A O   1 
ATOM 6812  C CB  . MET A 1 860 ? 265.493 -8.242  277.279 1.0 53.70579  ? 860 MET A CB  860 MET A CB  1 
ATOM 6813  C CG  . MET A 1 860 ? 265.055 -9.309  278.248 1.0 53.70579  ? 860 MET A CG  860 MET A CG  1 
ATOM 6814  S SD  . MET A 1 860 ? 264.048 -10.545 277.412 1.0 53.70579  ? 860 MET A SD  860 MET A SD  1 
ATOM 6815  C CE  . MET A 1 860 ? 265.255 -11.251 276.311 1.0 53.70579  ? 860 MET A CE  860 MET A CE  1 
ATOM 6816  N N   . GLN A 1 861 ? 267.767 -6.749  279.715 1.0 55.85708  ? 861 GLN A N   861 GLN A N   1 
ATOM 6817  C CA  . GLN A 1 861 ? 268.995 -6.989  280.454 1.0 55.85708  ? 861 GLN A CA  861 GLN A CA  1 
ATOM 6818  C C   . GLN A 1 861 ? 268.752 -7.960  281.601 1.0 55.85708  ? 861 GLN A C   861 GLN A C   1 
ATOM 6819  O O   . GLN A 1 861 ? 267.669 -8.005  282.187 1.0 55.85708  ? 861 GLN A O   861 GLN A O   1 
ATOM 6820  C CB  . GLN A 1 861 ? 269.585 -5.678  280.979 1.0 55.85708  ? 861 GLN A CB  861 GLN A CB  1 
ATOM 6821  C CG  . GLN A 1 861 ? 268.705 -4.920  281.942 1.0 55.85708  ? 861 GLN A CG  861 GLN A CG  1 
ATOM 6822  C CD  . GLN A 1 861 ? 269.336 -3.628  282.409 1.0 55.85708  ? 861 GLN A CD  861 GLN A CD  1 
ATOM 6823  O OE1 . GLN A 1 861 ? 270.474 -3.318  282.063 1.0 55.85708  ? 861 GLN A OE1 861 GLN A OE1 1 
ATOM 6824  N NE2 . GLN A 1 861 ? 268.596 -2.863  283.200 1.0 55.85708  ? 861 GLN A NE2 861 GLN A NE2 1 
ATOM 6825  N N   . PHE A 1 862 ? 269.770 -8.757  281.901 1.0 56.1001   ? 862 PHE A N   862 PHE A N   1 
ATOM 6826  C CA  . PHE A 1 862 ? 269.714 -9.761  282.952 1.0 56.1001   ? 862 PHE A CA  862 PHE A CA  1 
ATOM 6827  C C   . PHE A 1 862 ? 270.656 -9.374  284.081 1.0 56.1001   ? 862 PHE A C   862 PHE A C   1 
ATOM 6828  O O   . PHE A 1 862 ? 271.402 -8.397  283.997 1.0 56.1001   ? 862 PHE A O   862 PHE A O   1 
ATOM 6829  C CB  . PHE A 1 862 ? 270.089 -11.144 282.408 1.0 56.1001   ? 862 PHE A CB  862 PHE A CB  1 
ATOM 6830  C CG  . PHE A 1 862 ? 269.084 -11.720 281.453 1.0 56.1001   ? 862 PHE A CG  862 PHE A CG  1 
ATOM 6831  C CD1 . PHE A 1 862 ? 267.776 -11.279 281.439 1.0 56.1001   ? 862 PHE A CD1 862 PHE A CD1 1 
ATOM 6832  C CD2 . PHE A 1 862 ? 269.462 -12.688 280.544 1.0 56.1001   ? 862 PHE A CD2 862 PHE A CD2 1 
ATOM 6833  C CE1 . PHE A 1 862 ? 266.866 -11.802 280.547 1.0 56.1001   ? 862 PHE A CE1 862 PHE A CE1 1 
ATOM 6834  C CE2 . PHE A 1 862 ? 268.549 -13.211 279.655 1.0 56.1001   ? 862 PHE A CE2 862 PHE A CE2 1 
ATOM 6835  C CZ  . PHE A 1 862 ? 267.252 -12.768 279.660 1.0 56.1001   ? 862 PHE A CZ  862 PHE A CZ  1 
ATOM 6836  N N   . THR A 1 863 ? 270.610 -10.156 285.154 1.0 57.46371  ? 863 THR A N   863 THR A N   1 
ATOM 6837  C CA  . THR A 1 863 ? 271.544 -9.989  286.263 1.0 57.46371  ? 863 THR A CA  863 THR A CA  1 
ATOM 6838  C C   . THR A 1 863 ? 271.764 -11.360 286.880 1.0 57.46371  ? 863 THR A C   863 THR A C   1 
ATOM 6839  O O   . THR A 1 863 ? 270.853 -11.914 287.499 1.0 57.46371  ? 863 THR A O   863 THR A O   1 
ATOM 6840  C CB  . THR A 1 863 ? 271.023 -8.998  287.297 1.0 57.46371  ? 863 THR A CB  863 THR A CB  1 
ATOM 6841  O OG1 . THR A 1 863 ? 270.889 -7.704  286.699 1.0 57.46371  ? 863 THR A OG1 863 THR A OG1 1 
ATOM 6842  C CG2 . THR A 1 863 ? 271.979 -8.903  288.468 1.0 57.46371  ? 863 THR A CG2 863 THR A CG2 1 
ATOM 6843  N N   . VAL A 1 864 ? 272.965 -11.904 286.711 1.0 58.3208   ? 864 VAL A N   864 VAL A N   1 
ATOM 6844  C CA  . VAL A 1 864 ? 273.289 -13.242 287.175 1.0 58.3208   ? 864 VAL A CA  864 VAL A CA  1 
ATOM 6845  C C   . VAL A 1 864 ? 274.361 -13.143 288.251 1.0 58.3208   ? 864 VAL A C   864 VAL A C   1 
ATOM 6846  O O   . VAL A 1 864 ? 274.925 -12.080 288.503 1.0 58.3208   ? 864 VAL A O   864 VAL A O   1 
ATOM 6847  C CB  . VAL A 1 864 ? 273.754 -14.153 286.030 1.0 58.3208   ? 864 VAL A CB  864 VAL A CB  1 
ATOM 6848  C CG1 . VAL A 1 864 ? 272.672 -14.266 284.977 1.0 58.3208   ? 864 VAL A CG1 864 VAL A CG1 1 
ATOM 6849  C CG2 . VAL A 1 864 ? 275.032 -13.615 285.430 1.0 58.3208   ? 864 VAL A CG2 864 VAL A CG2 1 
ATOM 6850  N N   . ASP A 1 865 ? 274.632 -14.272 288.887 1.0 62.03491  ? 865 ASP A N   865 ASP A N   1 
ATOM 6851  C CA  . ASP A 1 865 ? 275.717 -14.303 289.852 1.0 62.03491  ? 865 ASP A CA  865 ASP A CA  1 
ATOM 6852  C C   . ASP A 1 865 ? 277.051 -14.452 289.127 1.0 62.03491  ? 865 ASP A C   865 ASP A C   1 
ATOM 6853  O O   . ASP A 1 865 ? 277.125 -15.130 288.101 1.0 62.03491  ? 865 ASP A O   865 ASP A O   1 
ATOM 6854  C CB  . ASP A 1 865 ? 275.538 -15.450 290.837 1.0 62.03491  ? 865 ASP A CB  865 ASP A CB  1 
ATOM 6855  C CG  . ASP A 1 865 ? 274.379 -15.227 291.780 1.0 62.03491  ? 865 ASP A CG  865 ASP A CG  1 
ATOM 6856  O OD1 . ASP A 1 865 ? 274.067 -14.052 292.053 1.0 62.03491  ? 865 ASP A OD1 865 ASP A OD1 1 
ATOM 6857  O OD2 . ASP A 1 865 ? 273.787 -16.218 292.259 1.0 62.03491  ? 865 ASP A OD2 865 ASP A OD2 1 
ATOM 6858  N N   . PRO A 1 866 ? 278.109 -13.819 289.627 1.0 64.18288  ? 866 PRO A N   866 PRO A N   1 
ATOM 6859  C CA  . PRO A 1 866 ? 279.412 -13.938 288.969 1.0 64.18288  ? 866 PRO A CA  866 PRO A CA  1 
ATOM 6860  C C   . PRO A 1 866 ? 280.014 -15.316 289.183 1.0 64.18288  ? 866 PRO A C   866 PRO A C   1 
ATOM 6861  O O   . PRO A 1 866 ? 279.990 -15.861 290.288 1.0 64.18288  ? 866 PRO A O   866 PRO A O   1 
ATOM 6862  C CB  . PRO A 1 866 ? 280.254 -12.855 289.653 1.0 64.18288  ? 866 PRO A CB  866 PRO A CB  1 
ATOM 6863  C CG  . PRO A 1 866 ? 279.264 -11.914 290.239 1.0 64.18288  ? 866 PRO A CG  866 PRO A CG  1 
ATOM 6864  C CD  . PRO A 1 866 ? 278.114 -12.768 290.656 1.0 64.18288  ? 866 PRO A CD  866 PRO A CD  1 
ATOM 6865  N N   . MET A 1 867 ? 280.549 -15.877 288.108 1.0 65.8969   ? 867 MET A N   867 MET A N   1 
ATOM 6866  C CA  . MET A 1 867 ? 281.267 -17.140 288.138 1.0 65.8969   ? 867 MET A CA  867 MET A CA  1 
ATOM 6867  C C   . MET A 1 867 ? 282.749 -16.901 287.882 1.0 65.8969   ? 867 MET A C   867 MET A C   1 
ATOM 6868  O O   . MET A 1 867 ? 283.214 -15.764 287.776 1.0 65.8969   ? 867 MET A O   867 MET A O   1 
ATOM 6869  C CB  . MET A 1 867 ? 280.688 -18.117 287.118 1.0 65.8969   ? 867 MET A CB  867 MET A CB  1 
ATOM 6870  C CG  . MET A 1 867 ? 279.367 -18.739 287.516 1.0 65.8969   ? 867 MET A CG  867 MET A CG  1 
ATOM 6871  S SD  . MET A 1 867 ? 278.703 -19.732 286.169 1.0 65.8969   ? 867 MET A SD  867 MET A SD  1 
ATOM 6872  C CE  . MET A 1 867 ? 279.953 -21.003 286.038 1.0 65.8969   ? 867 MET A CE  867 MET A CE  1 
ATOM 6873  N N   . THR A 1 868 ? 283.494 -17.998 287.779 1.0 68.49239  ? 868 THR A N   868 THR A N   1 
ATOM 6874  C CA  . THR A 1 868 ? 284.942 -17.958 287.647 1.0 68.49239  ? 868 THR A CA  868 THR A CA  1 
ATOM 6875  C C   . THR A 1 868 ? 285.421 -18.227 286.227 1.0 68.49239  ? 868 THR A C   868 THR A C   1 
ATOM 6876  O O   . THR A 1 868 ? 286.632 -18.315 286.001 1.0 68.49239  ? 868 THR A O   868 THR A O   1 
ATOM 6877  C CB  . THR A 1 868 ? 285.578 -18.968 288.601 1.0 68.49239  ? 868 THR A CB  868 THR A CB  1 
ATOM 6878  O OG1 . THR A 1 868 ? 287.002 -18.827 288.564 1.0 68.49239  ? 868 THR A OG1 868 THR A OG1 1 
ATOM 6879  C CG2 . THR A 1 868 ? 285.204 -20.384 288.197 1.0 68.49239  ? 868 THR A CG2 868 THR A CG2 1 
ATOM 6880  N N   . GLU A 1 869 ? 284.509 -18.350 285.269 1.0 67.82772  ? 869 GLU A N   869 GLU A N   1 
ATOM 6881  C CA  . GLU A 1 869 ? 284.851 -18.736 283.908 1.0 67.82772  ? 869 GLU A CA  869 GLU A CA  1 
ATOM 6882  C C   . GLU A 1 869 ? 283.741 -18.247 282.984 1.0 67.82772  ? 869 GLU A C   869 GLU A C   1 
ATOM 6883  O O   . GLU A 1 869 ? 282.627 -17.986 283.452 1.0 67.82772  ? 869 GLU A O   869 GLU A O   1 
ATOM 6884  C CB  . GLU A 1 869 ? 285.046 -20.262 283.810 1.0 67.82772  ? 869 GLU A CB  869 GLU A CB  1 
ATOM 6885  C CG  . GLU A 1 869 ? 283.822 -21.094 284.085 1.0 67.82772  ? 869 GLU A CG  869 GLU A CG  1 
ATOM 6886  C CD  . GLU A 1 869 ? 284.138 -22.574 284.050 1.0 67.82772  ? 869 GLU A CD  869 GLU A CD  1 
ATOM 6887  O OE1 . GLU A 1 869 ? 285.315 -22.928 283.832 1.0 67.82772  ? 869 GLU A OE1 869 GLU A OE1 1 
ATOM 6888  O OE2 . GLU A 1 869 ? 283.217 -23.385 284.242 1.0 67.82772  ? 869 GLU A OE2 869 GLU A OE2 1 
ATOM 6889  N N   . PRO A 1 870 ? 284.024 -18.059 281.684 1.0 63.92335  ? 870 PRO A N   870 PRO A N   1 
ATOM 6890  C CA  . PRO A 1 870 ? 282.990 -17.548 280.773 1.0 63.92335  ? 870 PRO A CA  870 PRO A CA  1 
ATOM 6891  C C   . PRO A 1 870 ? 281.815 -18.497 280.612 1.0 63.92335  ? 870 PRO A C   870 PRO A C   1 
ATOM 6892  O O   . PRO A 1 870 ? 281.920 -19.708 280.807 1.0 63.92335  ? 870 PRO A O   870 PRO A O   1 
ATOM 6893  C CB  . PRO A 1 870 ? 283.738 -17.368 279.447 1.0 63.92335  ? 870 PRO A CB  870 PRO A CB  1 
ATOM 6894  C CG  . PRO A 1 870 ? 284.930 -18.222 279.555 1.0 63.92335  ? 870 PRO A CG  870 PRO A CG  1 
ATOM 6895  C CD  . PRO A 1 870 ? 285.323 -18.145 280.991 1.0 63.92335  ? 870 PRO A CD  870 PRO A CD  1 
ATOM 6896  N N   . THR A 1 871 ? 280.676 -17.912 280.250 1.0 58.02389  ? 871 THR A N   871 THR A N   1 
ATOM 6897  C CA  . THR A 1 871 ? 279.384 -18.581 280.340 1.0 58.02389  ? 871 THR A CA  871 THR A CA  1 
ATOM 6898  C C   . THR A 1 871 ? 278.471 -18.022 279.261 1.0 58.02389  ? 871 THR A C   871 THR A C   1 
ATOM 6899  O O   . THR A 1 871 ? 278.312 -16.805 279.165 1.0 58.02389  ? 871 THR A O   871 THR A O   1 
ATOM 6900  C CB  . THR A 1 871 ? 278.773 -18.361 281.730 1.0 58.02389  ? 871 THR A CB  871 THR A CB  1 
ATOM 6901  O OG1 . THR A 1 871 ? 279.632 -18.908 282.735 1.0 58.02389  ? 871 THR A OG1 871 THR A OG1 1 
ATOM 6902  C CG2 . THR A 1 871 ? 277.429 -19.016 281.847 1.0 58.02389  ? 871 THR A CG2 871 THR A CG2 1 
ATOM 6903  N N   . TYR A 1 872 ? 277.888 -18.891 278.441 1.0 56.53271  ? 872 TYR A N   872 TYR A N   1 
ATOM 6904  C CA  . TYR A 1 872 ? 276.800 -18.468 277.572 1.0 56.53271  ? 872 TYR A CA  872 TYR A CA  1 
ATOM 6905  C C   . TYR A 1 872 ? 275.503 -18.434 278.361 1.0 56.53271  ? 872 TYR A C   872 TYR A C   1 
ATOM 6906  O O   . TYR A 1 872 ? 275.329 -19.174 279.329 1.0 56.53271  ? 872 TYR A O   872 TYR A O   1 
ATOM 6907  C CB  . TYR A 1 872 ? 276.607 -19.422 276.394 1.0 56.53271  ? 872 TYR A CB  872 TYR A CB  1 
ATOM 6908  C CG  . TYR A 1 872 ? 277.712 -19.456 275.376 1.0 56.53271  ? 872 TYR A CG  872 TYR A CG  1 
ATOM 6909  C CD1 . TYR A 1 872 ? 277.870 -18.426 274.464 1.0 56.53271  ? 872 TYR A CD1 872 TYR A CD1 1 
ATOM 6910  C CD2 . TYR A 1 872 ? 278.555 -20.550 275.283 1.0 56.53271  ? 872 TYR A CD2 872 TYR A CD2 1 
ATOM 6911  C CE1 . TYR A 1 872 ? 278.869 -18.463 273.516 1.0 56.53271  ? 872 TYR A CE1 872 TYR A CE1 1 
ATOM 6912  C CE2 . TYR A 1 872 ? 279.555 -20.599 274.339 1.0 56.53271  ? 872 TYR A CE2 872 TYR A CE2 1 
ATOM 6913  C CZ  . TYR A 1 872 ? 279.707 -19.554 273.459 1.0 56.53271  ? 872 TYR A CZ  872 TYR A CZ  1 
ATOM 6914  O OH  . TYR A 1 872 ? 280.705 -19.604 272.515 1.0 56.53271  ? 872 TYR A OH  872 TYR A OH  1 
ATOM 6915  N N   . LEU A 1 873 ? 274.573 -17.593 277.928 1.0 53.4078   ? 873 LEU A N   873 LEU A N   1 
ATOM 6916  C CA  . LEU A 1 873 ? 273.200 -17.684 278.398 1.0 53.4078   ? 873 LEU A CA  873 LEU A CA  1 
ATOM 6917  C C   . LEU A 1 873 ? 272.325 -18.118 277.231 1.0 53.4078   ? 873 LEU A C   873 LEU A C   1 
ATOM 6918  O O   . LEU A 1 873 ? 272.350 -17.500 276.164 1.0 53.4078   ? 873 LEU A O   873 LEU A O   1 
ATOM 6919  C CB  . LEU A 1 873 ? 272.718 -16.369 279.022 1.0 53.4078   ? 873 LEU A CB  873 LEU A CB  1 
ATOM 6920  C CG  . LEU A 1 873 ? 272.509 -15.032 278.314 1.0 53.4078   ? 873 LEU A CG  873 LEU A CG  1 
ATOM 6921  C CD1 . LEU A 1 873 ? 271.088 -14.907 277.795 1.0 53.4078   ? 873 LEU A CD1 873 LEU A CD1 1 
ATOM 6922  C CD2 . LEU A 1 873 ? 272.841 -13.891 279.258 1.0 53.4078   ? 873 LEU A CD2 873 LEU A CD2 1 
ATOM 6923  N N   . MET A 1 874 ? 271.582 -19.202 277.426 1.0 53.97563  ? 874 MET A N   874 MET A N   1 
ATOM 6924  C CA  . MET A 1 874 ? 270.823 -19.824 276.346 1.0 53.97563  ? 874 MET A CA  874 MET A CA  1 
ATOM 6925  C C   . MET A 1 874 ? 269.440 -19.200 276.320 1.0 53.97563  ? 874 MET A C   874 MET A C   1 
ATOM 6926  O O   . MET A 1 874 ? 268.502 -19.693 276.937 1.0 53.97563  ? 874 MET A O   874 MET A O   1 
ATOM 6927  C CB  . MET A 1 874 ? 270.743 -21.330 276.538 1.0 53.97563  ? 874 MET A CB  874 MET A CB  1 
ATOM 6928  C CG  . MET A 1 874 ? 270.082 -22.058 275.392 1.0 53.97563  ? 874 MET A CG  874 MET A CG  1 
ATOM 6929  S SD  . MET A 1 874 ? 269.999 -23.823 275.685 1.0 53.97563  ? 874 MET A SD  874 MET A SD  1 
ATOM 6930  C CE  . MET A 1 874 ? 269.074 -24.328 274.247 1.0 53.97563  ? 874 MET A CE  874 MET A CE  1 
ATOM 6931  N N   . LEU A 1 875 ? 269.309 -18.107 275.587 1.0 49.93404  ? 875 LEU A N   875 LEU A N   1 
ATOM 6932  C CA  . LEU A 1 875 ? 268.040 -17.410 275.469 1.0 49.93404  ? 875 LEU A CA  875 LEU A CA  1 
ATOM 6933  C C   . LEU A 1 875 ? 267.220 -18.024 274.345 1.0 49.93404  ? 875 LEU A C   875 LEU A C   1 
ATOM 6934  O O   . LEU A 1 875 ? 267.708 -18.166 273.221 1.0 49.93404  ? 875 LEU A O   875 LEU A O   1 
ATOM 6935  C CB  . LEU A 1 875 ? 268.284 -15.930 275.204 1.0 49.93404  ? 875 LEU A CB  875 LEU A CB  1 
ATOM 6936  C CG  . LEU A 1 875 ? 267.076 -15.019 275.059 1.0 49.93404  ? 875 LEU A CG  875 LEU A CG  1 
ATOM 6937  C CD1 . LEU A 1 875 ? 266.272 -14.974 276.332 1.0 49.93404  ? 875 LEU A CD1 875 LEU A CD1 1 
ATOM 6938  C CD2 . LEU A 1 875 ? 267.585 -13.653 274.709 1.0 49.93404  ? 875 LEU A CD2 875 LEU A CD2 1 
ATOM 6939  N N   . LEU A 1 876 ? 265.981 -18.394 274.652 1.0 46.50274  ? 876 LEU A N   876 LEU A N   1 
ATOM 6940  C CA  . LEU A 1 876 ? 265.066 -18.960 273.673 1.0 46.50274  ? 876 LEU A CA  876 LEU A CA  1 
ATOM 6941  C C   . LEU A 1 876 ? 263.870 -18.041 273.497 1.0 46.50274  ? 876 LEU A C   876 LEU A C   1 
ATOM 6942  O O   . LEU A 1 876 ? 263.328 -17.529 274.479 1.0 46.50274  ? 876 LEU A O   876 LEU A O   1 
ATOM 6943  C CB  . LEU A 1 876 ? 264.591 -20.350 274.088 1.0 46.50274  ? 876 LEU A CB  876 LEU A CB  1 
ATOM 6944  C CG  . LEU A 1 876 ? 265.674 -21.417 274.059 1.0 46.50274  ? 876 LEU A CG  876 LEU A CG  1 
ATOM 6945  C CD1 . LEU A 1 876 ? 265.127 -22.758 274.490 1.0 46.50274  ? 876 LEU A CD1 876 LEU A CD1 1 
ATOM 6946  C CD2 . LEU A 1 876 ? 266.249 -21.488 272.673 1.0 46.50274  ? 876 LEU A CD2 876 LEU A CD2 1 
ATOM 6947  N N   . PHE A 1 877 ? 263.463 -17.838 272.252 1.0 45.19808  ? 877 PHE A N   877 PHE A N   1 
ATOM 6948  C CA  . PHE A 1 877 ? 262.270 -17.075 271.922 1.0 45.19808  ? 877 PHE A CA  877 PHE A CA  1 
ATOM 6949  C C   . PHE A 1 877 ? 261.218 -18.037 271.402 1.0 45.19808  ? 877 PHE A C   877 PHE A C   1 
ATOM 6950  O O   . PHE A 1 877 ? 261.466 -18.750 270.430 1.0 45.19808  ? 877 PHE A O   877 PHE A O   1 
ATOM 6951  C CB  . PHE A 1 877 ? 262.562 -16.022 270.861 1.0 45.19808  ? 877 PHE A CB  877 PHE A CB  1 
ATOM 6952  C CG  . PHE A 1 877 ? 263.468 -14.934 271.318 1.0 45.19808  ? 877 PHE A CG  877 PHE A CG  1 
ATOM 6953  C CD1 . PHE A 1 877 ? 262.979 -13.883 272.068 1.0 45.19808  ? 877 PHE A CD1 877 PHE A CD1 1 
ATOM 6954  C CD2 . PHE A 1 877 ? 264.806 -14.948 270.975 1.0 45.19808  ? 877 PHE A CD2 877 PHE A CD2 1 
ATOM 6955  C CE1 . PHE A 1 877 ? 263.812 -12.873 272.482 1.0 45.19808  ? 877 PHE A CE1 877 PHE A CE1 1 
ATOM 6956  C CE2 . PHE A 1 877 ? 265.644 -13.943 271.387 1.0 45.19808  ? 877 PHE A CE2 877 PHE A CE2 1 
ATOM 6957  C CZ  . PHE A 1 877 ? 265.146 -12.902 272.139 1.0 45.19808  ? 877 PHE A CZ  877 PHE A CZ  1 
ATOM 6958  N N   . GLY A 1 878 ? 260.050 -18.045 272.029 1.0 45.41619  ? 878 GLY A N   878 GLY A N   1 
ATOM 6959  C CA  . GLY A 1 878 ? 258.979 -18.893 271.553 1.0 45.41619  ? 878 GLY A CA  878 GLY A CA  1 
ATOM 6960  C C   . GLY A 1 878 ? 258.427 -18.436 270.221 1.0 45.41619  ? 878 GLY A C   878 GLY A C   1 
ATOM 6961  O O   . GLY A 1 878 ? 257.775 -17.393 270.133 1.0 45.41619  ? 878 GLY A O   878 GLY A O   1 
ATOM 6962  N N   . VAL A 1 879 ? 258.704 -19.196 269.167 1.0 43.01355  ? 879 VAL A N   879 VAL A N   1 
ATOM 6963  C CA  . VAL A 1 879 ? 258.176 -18.894 267.844 1.0 43.01355  ? 879 VAL A CA  879 VAL A CA  1 
ATOM 6964  C C   . VAL A 1 879 ? 257.311 -20.064 267.405 1.0 43.01355  ? 879 VAL A C   879 VAL A C   1 
ATOM 6965  O O   . VAL A 1 879 ? 257.193 -21.061 268.124 1.0 43.01355  ? 879 VAL A O   879 VAL A O   1 
ATOM 6966  C CB  . VAL A 1 879 ? 259.303 -18.621 266.836 1.0 43.01355  ? 879 VAL A CB  879 VAL A CB  1 
ATOM 6967  C CG1 . VAL A 1 879 ? 260.126 -17.434 267.280 1.0 43.01355  ? 879 VAL A CG1 879 VAL A CG1 1 
ATOM 6968  C CG2 . VAL A 1 879 ? 260.174 -19.838 266.688 1.0 43.01355  ? 879 VAL A CG2 879 VAL A CG2 1 
ATOM 6969  N N   . PHE A 1 880 ? 256.700 -19.956 266.231 1.0 43.44673  ? 880 PHE A N   880 PHE A N   1 
ATOM 6970  C CA  . PHE A 1 880 ? 255.804 -20.981 265.701 1.0 43.44673  ? 880 PHE A CA  880 PHE A CA  1 
ATOM 6971  C C   . PHE A 1 880 ? 256.411 -21.531 264.419 1.0 43.44673  ? 880 PHE A C   880 PHE A C   1 
ATOM 6972  O O   . PHE A 1 880 ? 256.166 -21.003 263.335 1.0 43.44673  ? 880 PHE A O   880 PHE A O   1 
ATOM 6973  C CB  . PHE A 1 880 ? 254.437 -20.417 265.438 1.0 43.44673  ? 880 PHE A CB  880 PHE A CB  1 
ATOM 6974  C CG  . PHE A 1 880 ? 253.648 -20.110 266.670 1.0 43.44673  ? 880 PHE A CG  880 PHE A CG  1 
ATOM 6975  C CD1 . PHE A 1 880 ? 253.950 -20.695 267.885 1.0 43.44673  ? 880 PHE A CD1 880 PHE A CD1 1 
ATOM 6976  C CD2 . PHE A 1 880 ? 252.604 -19.215 266.609 1.0 43.44673  ? 880 PHE A CD2 880 PHE A CD2 1 
ATOM 6977  C CE1 . PHE A 1 880 ? 253.209 -20.393 269.009 1.0 43.44673  ? 880 PHE A CE1 880 PHE A CE1 1 
ATOM 6978  C CE2 . PHE A 1 880 ? 251.864 -18.911 267.721 1.0 43.44673  ? 880 PHE A CE2 880 PHE A CE2 1 
ATOM 6979  C CZ  . PHE A 1 880 ? 252.167 -19.499 268.924 1.0 43.44673  ? 880 PHE A CZ  880 PHE A CZ  1 
ATOM 6980  N N   . ASP A 1 881 ? 257.182 -22.603 264.538 1.0 44.94734  ? 881 ASP A N   881 ASP A N   1 
ATOM 6981  C CA  . ASP A 1 881 ? 257.871 -23.185 263.395 1.0 44.94734  ? 881 ASP A CA  881 ASP A CA  1 
ATOM 6982  C C   . ASP A 1 881 ? 256.929 -24.162 262.703 1.0 44.94734  ? 881 ASP A C   881 ASP A C   1 
ATOM 6983  O O   . ASP A 1 881 ? 256.444 -25.109 263.328 1.0 44.94734  ? 881 ASP A O   881 ASP A O   1 
ATOM 6984  C CB  . ASP A 1 881 ? 259.152 -23.876 263.851 1.0 44.94734  ? 881 ASP A CB  881 ASP A CB  1 
ATOM 6985  C CG  . ASP A 1 881 ? 260.103 -24.148 262.713 1.0 44.94734  ? 881 ASP A CG  881 ASP A CG  1 
ATOM 6986  O OD1 . ASP A 1 881 ? 259.763 -23.837 261.554 1.0 44.94734  ? 881 ASP A OD1 881 ASP A OD1 1 
ATOM 6987  O OD2 . ASP A 1 881 ? 261.207 -24.659 262.982 1.0 44.94734  ? 881 ASP A OD2 881 ASP A OD2 1 
ATOM 6988  N N   . GLN A 1 882 ? 256.657 -23.921 261.421 1.0 40.3433   ? 882 GLN A N   882 GLN A N   1 
ATOM 6989  C CA  . GLN A 1 882 ? 255.679 -24.694 260.670 1.0 40.3433   ? 882 GLN A CA  882 GLN A CA  1 
ATOM 6990  C C   . GLN A 1 882 ? 256.228 -25.018 259.294 1.0 40.3433   ? 882 GLN A C   882 GLN A C   1 
ATOM 6991  O O   . GLN A 1 882 ? 257.090 -24.309 258.772 1.0 40.3433   ? 882 GLN A O   882 GLN A O   1 
ATOM 6992  C CB  . GLN A 1 882 ? 254.363 -23.942 260.484 1.0 40.3433   ? 882 GLN A CB  882 GLN A CB  1 
ATOM 6993  C CG  . GLN A 1 882 ? 253.625 -23.624 261.745 1.0 40.3433   ? 882 GLN A CG  882 GLN A CG  1 
ATOM 6994  C CD  . GLN A 1 882 ? 253.063 -24.836 262.428 1.0 40.3433   ? 882 GLN A CD  882 GLN A CD  1 
ATOM 6995  O OE1 . GLN A 1 882 ? 252.611 -25.772 261.777 1.0 40.3433   ? 882 GLN A OE1 882 GLN A OE1 1 
ATOM 6996  N NE2 . GLN A 1 882 ? 253.063 -24.818 263.753 1.0 40.3433   ? 882 GLN A NE2 882 GLN A NE2 1 
ATOM 6997  N N   . VAL A 1 883 ? 255.728 -26.115 258.718 1.0 37.40904  ? 883 VAL A N   883 VAL A N   1 
ATOM 6998  C CA  . VAL A 1 883 ? 255.981 -26.483 257.333 1.0 37.40904  ? 883 VAL A CA  883 VAL A CA  1 
ATOM 6999  C C   . VAL A 1 883 ? 254.643 -26.811 256.686 1.0 37.40904  ? 883 VAL A C   883 VAL A C   1 
ATOM 7000  O O   . VAL A 1 883 ? 253.639 -27.047 257.360 1.0 37.40904  ? 883 VAL A O   883 VAL A O   1 
ATOM 7001  C CB  . VAL A 1 883 ? 256.934 -27.693 257.183 1.0 37.40904  ? 883 VAL A CB  883 VAL A CB  1 
ATOM 7002  C CG1 . VAL A 1 883 ? 258.186 -27.492 257.958 1.0 37.40904  ? 883 VAL A CG1 883 VAL A CG1 1 
ATOM 7003  C CG2 . VAL A 1 883 ? 256.272 -28.969 257.611 1.0 37.40904  ? 883 VAL A CG2 883 VAL A CG2 1 
ATOM 7004  N N   . VAL A 1 884 ? 254.630 -26.787 255.357 1.0 36.06873  ? 884 VAL A N   884 VAL A N   1 
ATOM 7005  C CA  . VAL A 1 884 ? 253.664 -27.540 254.574 1.0 36.06873  ? 884 VAL A CA  884 VAL A CA  1 
ATOM 7006  C C   . VAL A 1 884 ? 254.489 -28.350 253.594 1.0 36.06873  ? 884 VAL A C   884 VAL A C   1 
ATOM 7007  O O   . VAL A 1 884 ? 255.667 -28.072 253.371 1.0 36.06873  ? 884 VAL A O   884 VAL A O   1 
ATOM 7008  C CB  . VAL A 1 884 ? 252.633 -26.673 253.814 1.0 36.06873  ? 884 VAL A CB  884 VAL A CB  1 
ATOM 7009  C CG1 . VAL A 1 884 ? 251.869 -25.765 254.755 1.0 36.06873  ? 884 VAL A CG1 884 VAL A CG1 1 
ATOM 7010  C CG2 . VAL A 1 884 ? 253.290 -25.886 252.695 1.0 36.06873  ? 884 VAL A CG2 884 VAL A CG2 1 
ATOM 7011  N N   . ILE A 1 885 ? 253.864 -29.369 253.016 1.0 37.63558  ? 885 ILE A N   885 ILE A N   1 
ATOM 7012  C CA  . ILE A 1 885 ? 254.521 -30.157 251.980 1.0 37.63558  ? 885 ILE A CA  885 ILE A CA  1 
ATOM 7013  C C   . ILE A 1 885 ? 253.494 -30.749 251.023 1.0 37.63558  ? 885 ILE A C   885 ILE A C   1 
ATOM 7014  O O   . ILE A 1 885 ? 252.527 -31.394 251.440 1.0 37.63558  ? 885 ILE A O   885 ILE A O   1 
ATOM 7015  C CB  . ILE A 1 885 ? 255.437 -31.232 252.604 1.0 37.63558  ? 885 ILE A CB  885 ILE A CB  1 
ATOM 7016  C CG1 . ILE A 1 885 ? 256.096 -32.086 251.533 1.0 37.63558  ? 885 ILE A CG1 885 ILE A CG1 1 
ATOM 7017  C CG2 . ILE A 1 885 ? 254.753 -32.060 253.671 1.0 37.63558  ? 885 ILE A CG2 885 ILE A CG2 1 
ATOM 7018  C CD1 . ILE A 1 885 ? 257.193 -32.919 252.093 1.0 37.63558  ? 885 ILE A CD1 885 ILE A CD1 1 
ATOM 7019  N N   . ASN A 1 886 ? 253.671 -30.499 249.731 1.0 41.178    ? 886 ASN A N   886 ASN A N   1 
ATOM 7020  C CA  . ASN A 1 886 ? 252.815 -31.086 248.716 1.0 41.178    ? 886 ASN A CA  886 ASN A CA  1 
ATOM 7021  C C   . ASN A 1 886 ? 253.609 -32.030 247.828 1.0 41.178    ? 886 ASN A C   886 ASN A C   1 
ATOM 7022  O O   . ASN A 1 886 ? 254.812 -31.861 247.621 1.0 41.178    ? 886 ASN A O   886 ASN A O   1 
ATOM 7023  C CB  . ASN A 1 886 ? 252.113 -30.020 247.864 1.0 41.178    ? 886 ASN A CB  886 ASN A CB  1 
ATOM 7024  C CG  . ASN A 1 886 ? 253.063 -29.024 247.242 1.0 41.178    ? 886 ASN A CG  886 ASN A CG  1 
ATOM 7025  O OD1 . ASN A 1 886 ? 254.273 -29.067 247.450 1.0 41.178    ? 886 ASN A OD1 886 ASN A OD1 1 
ATOM 7026  N ND2 . ASN A 1 886 ? 252.510 -28.116 246.450 1.0 41.178    ? 886 ASN A ND2 886 ASN A ND2 1 
ATOM 7027  N N   . GLN A 1 887 ? 252.923 -33.053 247.337 1.0 42.25134  ? 887 GLN A N   887 GLN A N   1 
ATOM 7028  C CA  . GLN A 1 887 ? 253.501 -34.042 246.436 1.0 42.25134  ? 887 GLN A CA  887 GLN A CA  1 
ATOM 7029  C C   . GLN A 1 887 ? 252.474 -34.182 245.325 1.0 42.25134  ? 887 GLN A C   887 GLN A C   1 
ATOM 7030  O O   . GLN A 1 887 ? 251.573 -35.020 245.414 1.0 42.25134  ? 887 GLN A O   887 GLN A O   1 
ATOM 7031  C CB  . GLN A 1 887 ? 253.762 -35.359 247.159 1.0 42.25134  ? 887 GLN A CB  887 GLN A CB  1 
ATOM 7032  C CG  . GLN A 1 887 ? 254.795 -35.241 248.267 1.0 42.25134  ? 887 GLN A CG  887 GLN A CG  1 
ATOM 7033  C CD  . GLN A 1 887 ? 254.923 -36.485 249.101 1.0 42.25134  ? 887 GLN A CD  887 GLN A CD  1 
ATOM 7034  O OE1 . GLN A 1 887 ? 254.202 -37.448 248.905 1.0 42.25134  ? 887 GLN A OE1 887 GLN A OE1 1 
ATOM 7035  N NE2 . GLN A 1 887 ? 255.839 -36.465 250.051 1.0 42.25134  ? 887 GLN A NE2 887 GLN A NE2 1 
ATOM 7036  N N   . PRO A 1 888 ? 252.536 -33.337 244.296 1.0 42.26569  ? 888 PRO A N   888 PRO A N   1 
ATOM 7037  C CA  . PRO A 1 888 ? 251.452 -33.311 243.309 1.0 42.26569  ? 888 PRO A CA  888 PRO A CA  1 
ATOM 7038  C C   . PRO A 1 888 ? 251.651 -34.290 242.165 1.0 42.26569  ? 888 PRO A C   888 PRO A C   1 
ATOM 7039  O O   . PRO A 1 888 ? 250.701 -34.622 241.452 1.0 42.26569  ? 888 PRO A O   888 PRO A O   1 
ATOM 7040  C CB  . PRO A 1 888 ? 251.486 -31.866 242.809 1.0 42.26569  ? 888 PRO A CB  888 PRO A CB  1 
ATOM 7041  C CG  . PRO A 1 888 ? 252.914 -31.494 242.919 1.0 42.26569  ? 888 PRO A CG  888 PRO A CG  1 
ATOM 7042  C CD  . PRO A 1 888 ? 253.450 -32.194 244.133 1.0 42.26569  ? 888 PRO A CD  888 PRO A CD  1 
ATOM 7043  N N   . THR A 1 889 ? 252.882 -34.748 241.973 1.0 45.10889  ? 889 THR A N   889 THR A N   1 
ATOM 7044  C CA  . THR A 1 889 ? 253.239 -35.593 240.846 1.0 45.10889  ? 889 THR A CA  889 THR A CA  1 
ATOM 7045  C C   . THR A 1 889 ? 254.184 -36.664 241.369 1.0 45.10889  ? 889 THR A C   889 THR A C   1 
ATOM 7046  O O   . THR A 1 889 ? 254.883 -36.446 242.362 1.0 45.10889  ? 889 THR A O   889 THR A O   1 
ATOM 7047  C CB  . THR A 1 889 ? 253.899 -34.758 239.729 1.0 45.10889  ? 889 THR A CB  889 THR A CB  1 
ATOM 7048  O OG1 . THR A 1 889 ? 253.117 -33.585 239.487 1.0 45.10889  ? 889 THR A OG1 889 THR A OG1 1 
ATOM 7049  C CG2 . THR A 1 889 ? 253.965 -35.522 238.416 1.0 45.10889  ? 889 THR A CG2 889 THR A CG2 1 
ATOM 7050  N N   . ARG A 1 890 ? 254.164 -37.836 240.733 1.0 46.67111  ? 890 ARG A N   890 ARG A N   1 
ATOM 7051  C CA  . ARG A 1 890 ? 255.099 -38.898 241.080 1.0 46.67111  ? 890 ARG A CA  890 ARG A CA  1 
ATOM 7052  C C   . ARG A 1 890 ? 256.532 -38.436 240.841 1.0 46.67111  ? 890 ARG A C   890 ARG A C   1 
ATOM 7053  O O   . ARG A 1 890 ? 256.824 -37.787 239.833 1.0 46.67111  ? 890 ARG A O   890 ARG A O   1 
ATOM 7054  C CB  . ARG A 1 890 ? 254.793 -40.150 240.260 1.0 46.67111  ? 890 ARG A CB  890 ARG A CB  1 
ATOM 7055  C CG  . ARG A 1 890 ? 255.646 -41.343 240.617 1.0 46.67111  ? 890 ARG A CG  890 ARG A CG  1 
ATOM 7056  C CD  . ARG A 1 890 ? 255.287 -42.551 239.783 1.0 46.67111  ? 890 ARG A CD  890 ARG A CD  1 
ATOM 7057  N NE  . ARG A 1 890 ? 255.504 -42.318 238.361 1.0 46.67111  ? 890 ARG A NE  890 ARG A NE  1 
ATOM 7058  C CZ  . ARG A 1 890 ? 256.680 -42.434 237.753 1.0 46.67111  ? 890 ARG A CZ  890 ARG A CZ  1 
ATOM 7059  N NH1 . ARG A 1 890 ? 257.758 -42.778 238.443 1.0 46.67111  ? 890 ARG A NH1 890 ARG A NH1 1 
ATOM 7060  N NH2 . ARG A 1 890 ? 256.779 -42.203 236.453 1.0 46.67111  ? 890 ARG A NH2 890 ARG A NH2 1 
ATOM 7061  N N   . SER A 1 891 ? 257.410 -38.757 241.802 1.0 45.10303  ? 891 SER A N   891 SER A N   1 
ATOM 7062  C CA  . SER A 1 891 ? 258.761 -38.195 241.932 1.0 45.10303  ? 891 SER A CA  891 SER A CA  1 
ATOM 7063  C C   . SER A 1 891 ? 258.734 -36.673 241.999 1.0 45.10303  ? 891 SER A C   891 SER A C   1 
ATOM 7064  O O   . SER A 1 891 ? 259.577 -36.001 241.403 1.0 45.10303  ? 891 SER A O   891 SER A O   1 
ATOM 7065  C CB  . SER A 1 891 ? 259.703 -38.662 240.816 1.0 45.10303  ? 891 SER A CB  891 SER A CB  1 
ATOM 7066  O OG  . SER A 1 891 ? 259.921 -40.057 240.867 1.0 45.10303  ? 891 SER A OG  891 SER A OG  1 
ATOM 7067  N N   . GLY A 1 892 ? 257.774 -36.122 242.719 1.0 43.32393  ? 892 GLY A N   892 GLY A N   1 
ATOM 7068  C CA  . GLY A 1 892 ? 257.676 -34.681 242.885 1.0 43.32393  ? 892 GLY A CA  892 GLY A CA  1 
ATOM 7069  C C   . GLY A 1 892 ? 257.328 -34.331 244.312 1.0 43.32393  ? 892 GLY A C   892 GLY A C   1 
ATOM 7070  O O   . GLY A 1 892 ? 256.442 -34.936 244.912 1.0 43.32393  ? 892 GLY A O   892 GLY A O   1 
ATOM 7071  N N   . ILE A 1 893 ? 258.034 -33.341 244.849 1.0 40.42374  ? 893 ILE A N   893 ILE A N   1 
ATOM 7072  C CA  . ILE A 1 893 ? 257.885 -32.960 246.247 1.0 40.42374  ? 893 ILE A CA  893 ILE A CA  1 
ATOM 7073  C C   . ILE A 1 893 ? 258.340 -31.512 246.381 1.0 40.42374  ? 893 ILE A C   893 ILE A C   1 
ATOM 7074  O O   . ILE A 1 893 ? 259.210 -31.051 245.639 1.0 40.42374  ? 893 ILE A O   893 ILE A O   1 
ATOM 7075  C CB  . ILE A 1 893 ? 258.668 -33.937 247.160 1.0 40.42374  ? 893 ILE A CB  893 ILE A CB  1 
ATOM 7076  C CG1 . ILE A 1 893 ? 258.284 -33.791 248.624 1.0 40.42374  ? 893 ILE A CG1 893 ILE A CG1 1 
ATOM 7077  C CG2 . ILE A 1 893 ? 260.168 -33.796 246.993 1.0 40.42374  ? 893 ILE A CG2 893 ILE A CG2 1 
ATOM 7078  C CD1 . ILE A 1 893 ? 258.822 -34.919 249.454 1.0 40.42374  ? 893 ILE A CD1 893 ILE A CD1 1 
ATOM 7079  N N   . SER A 1 894 ? 257.698 -30.777 247.287 1.0 38.73154  ? 894 SER A N   894 SER A N   1 
ATOM 7080  C CA  . SER A 1 894 ? 258.018 -29.376 247.525 1.0 38.73154  ? 894 SER A CA  894 SER A CA  1 
ATOM 7081  C C   . SER A 1 894 ? 257.493 -28.984 248.892 1.0 38.73154  ? 894 SER A C   894 SER A C   1 
ATOM 7082  O O   . SER A 1 894 ? 256.484 -29.517 249.356 1.0 38.73154  ? 894 SER A O   894 SER A O   1 
ATOM 7083  C CB  . SER A 1 894 ? 257.413 -28.447 246.468 1.0 38.73154  ? 894 SER A CB  894 SER A CB  1 
ATOM 7084  O OG  . SER A 1 894 ? 257.988 -28.667 245.196 1.0 38.73154  ? 894 SER A OG  894 SER A OG  1 
ATOM 7085  N N   . VAL A 1 895 ? 258.178 -28.040 249.530 1.0 35.25389  ? 895 VAL A N   895 VAL A N   1 
ATOM 7086  C CA  . VAL A 1 895 ? 257.826 -27.585 250.860 1.0 35.25389  ? 895 VAL A CA  895 VAL A CA  1 
ATOM 7087  C C   . VAL A 1 895 ? 257.710 -26.069 250.863 1.0 35.25389  ? 895 VAL A C   895 VAL A C   1 
ATOM 7088  O O   . VAL A 1 895 ? 257.867 -25.405 249.842 1.0 35.25389  ? 895 VAL A O   895 VAL A O   1 
ATOM 7089  C CB  . VAL A 1 895 ? 258.840 -28.034 251.925 1.0 35.25389  ? 895 VAL A CB  895 VAL A CB  1 
ATOM 7090  C CG1 . VAL A 1 895 ? 258.739 -29.511 252.169 1.0 35.25389  ? 895 VAL A CG1 895 VAL A CG1 1 
ATOM 7091  C CG2 . VAL A 1 895 ? 260.222 -27.667 251.478 1.0 35.25389  ? 895 VAL A CG2 895 VAL A CG2 1 
ATOM 7092  N N   . ALA A 1 896 ? 257.426 -25.535 252.048 1.0 35.54582  ? 896 ALA A N   896 ALA A N   1 
ATOM 7093  C CA  . ALA A 1 896 ? 257.421 -24.097 252.278 1.0 35.54582  ? 896 ALA A CA  896 ALA A CA  1 
ATOM 7094  C C   . ALA A 1 896 ? 257.702 -23.893 253.758 1.0 35.54582  ? 896 ALA A C   896 ALA A C   1 
ATOM 7095  O O   . ALA A 1 896 ? 256.832 -24.163 254.586 1.0 35.54582  ? 896 ALA A O   896 ALA A O   1 
ATOM 7096  C CB  . ALA A 1 896 ? 256.088 -23.484 251.878 1.0 35.54582  ? 896 ALA A CB  896 ALA A CB  1 
ATOM 7097  N N   . TYR A 1 897 ? 258.904 -23.443 254.090 1.0 40.824    ? 897 TYR A N   897 TYR A N   1 
ATOM 7098  C CA  . TYR A 1 897 ? 259.252 -23.215 255.483 1.0 40.824    ? 897 TYR A CA  897 TYR A CA  1 
ATOM 7099  C C   . TYR A 1 897 ? 258.963 -21.771 255.853 1.0 40.824    ? 897 TYR A C   897 TYR A C   1 
ATOM 7100  O O   . TYR A 1 897 ? 259.384 -20.842 255.161 1.0 40.824    ? 897 TYR A O   897 TYR A O   1 
ATOM 7101  C CB  . TYR A 1 897 ? 260.726 -23.505 255.770 1.0 40.824    ? 897 TYR A CB  897 TYR A CB  1 
ATOM 7102  C CG  . TYR A 1 897 ? 261.162 -24.948 255.716 1.0 40.824    ? 897 TYR A CG  897 TYR A CG  1 
ATOM 7103  C CD1 . TYR A 1 897 ? 260.268 -25.967 255.469 1.0 40.824    ? 897 TYR A CD1 897 TYR A CD1 1 
ATOM 7104  C CD2 . TYR A 1 897 ? 262.470 -25.291 255.993 1.0 40.824    ? 897 TYR A CD2 897 TYR A CD2 1 
ATOM 7105  C CE1 . TYR A 1 897 ? 260.679 -27.282 255.434 1.0 40.824    ? 897 TYR A CE1 897 TYR A CE1 1 
ATOM 7106  C CE2 . TYR A 1 897 ? 262.881 -26.601 255.978 1.0 40.824    ? 897 TYR A CE2 897 TYR A CE2 1 
ATOM 7107  C CZ  . TYR A 1 897 ? 261.982 -27.588 255.702 1.0 40.824    ? 897 TYR A CZ  897 TYR A CZ  1 
ATOM 7108  O OH  . TYR A 1 897 ? 262.393 -28.895 255.681 1.0 40.824    ? 897 TYR A OH  897 TYR A OH  1 
ATOM 7109  N N   . LEU A 1 898 ? 258.268 -21.589 256.973 1.0 39.88481  ? 898 LEU A N   898 LEU A N   1 
ATOM 7110  C CA  . LEU A 1 898 ? 257.866 -20.258 257.404 1.0 39.88481  ? 898 LEU A CA  898 LEU A CA  1 
ATOM 7111  C C   . LEU A 1 898 ? 257.540 -20.269 258.888 1.0 39.88481  ? 898 LEU A C   898 LEU A C   1 
ATOM 7112  O O   . LEU A 1 898 ? 256.717 -21.072 259.333 1.0 39.88481  ? 898 LEU A O   898 LEU A O   1 
ATOM 7113  C CB  . LEU A 1 898 ? 256.669 -19.791 256.572 1.0 39.88481  ? 898 LEU A CB  898 LEU A CB  1 
ATOM 7114  C CG  . LEU A 1 898 ? 256.136 -18.359 256.521 1.0 39.88481  ? 898 LEU A CG  898 LEU A CG  1 
ATOM 7115  C CD1 . LEU A 1 898 ? 255.168 -18.074 257.626 1.0 39.88481  ? 898 LEU A CD1 898 LEU A CD1 1 
ATOM 7116  C CD2 . LEU A 1 898 ? 257.286 -17.372 256.557 1.0 39.88481  ? 898 LEU A CD2 898 LEU A CD2 1 
ATOM 7117  N N   . ARG A 1 899 ? 258.163 -19.387 259.662 1.0 44.65613  ? 899 ARG A N   899 ARG A N   1 
ATOM 7118  C CA  . ARG A 1 899 ? 257.918 -19.307 261.094 1.0 44.65613  ? 899 ARG A CA  899 ARG A CA  1 
ATOM 7119  C C   . ARG A 1 899 ? 257.550 -17.884 261.492 1.0 44.65613  ? 899 ARG A C   899 ARG A C   1 
ATOM 7120  O O   . ARG A 1 899 ? 258.055 -16.919 260.912 1.0 44.65613  ? 899 ARG A O   899 ARG A O   1 
ATOM 7121  C CB  . ARG A 1 899 ? 259.132 -19.803 261.886 1.0 44.65613  ? 899 ARG A CB  899 ARG A CB  1 
ATOM 7122  C CG  . ARG A 1 899 ? 260.391 -18.994 261.722 1.0 44.65613  ? 899 ARG A CG  899 ARG A CG  1 
ATOM 7123  C CD  . ARG A 1 899 ? 261.535 -19.614 262.484 1.0 44.65613  ? 899 ARG A CD  899 ARG A CD  1 
ATOM 7124  N NE  . ARG A 1 899 ? 262.747 -18.821 262.345 1.0 44.65613  ? 899 ARG A NE  899 ARG A NE  1 
ATOM 7125  C CZ  . ARG A 1 899 ? 263.911 -19.140 262.894 1.0 44.65613  ? 899 ARG A CZ  899 ARG A CZ  1 
ATOM 7126  N NH1 . ARG A 1 899 ? 264.021 -20.244 263.617 1.0 44.65613  ? 899 ARG A NH1 899 ARG A NH1 1 
ATOM 7127  N NH2 . ARG A 1 899 ? 264.964 -18.357 262.717 1.0 44.65613  ? 899 ARG A NH2 899 ARG A NH2 1 
ATOM 7128  N N   . LEU A 1 900 ? 256.641 -17.761 262.458 1.0 44.57585  ? 900 LEU A N   900 LEU A N   1 
ATOM 7129  C CA  . LEU A 1 900 ? 256.268 -16.480 263.030 1.0 44.57585  ? 900 LEU A CA  900 LEU A CA  1 
ATOM 7130  C C   . LEU A 1 900 ? 256.812 -16.393 264.441 1.0 44.57585  ? 900 LEU A C   900 LEU A C   1 
ATOM 7131  O O   . LEU A 1 900 ? 256.679 -17.359 265.199 1.0 44.57585  ? 900 LEU A O   900 LEU A O   1 
ATOM 7132  C CB  . LEU A 1 900 ? 254.749 -16.295 263.069 1.0 44.57585  ? 900 LEU A CB  900 LEU A CB  1 
ATOM 7133  C CG  . LEU A 1 900 ? 253.961 -15.753 261.875 1.0 44.57585  ? 900 LEU A CG  900 LEU A CG  1 
ATOM 7134  C CD1 . LEU A 1 900 ? 254.488 -14.397 261.413 1.0 44.57585  ? 900 LEU A CD1 900 LEU A CD1 1 
ATOM 7135  C CD2 . LEU A 1 900 ? 253.915 -16.743 260.760 1.0 44.57585  ? 900 LEU A CD2 900 LEU A CD2 1 
ATOM 7136  N N   . PRO A 1 901 ? 257.393 -15.260 264.855 1.0 45.56247  ? 901 PRO A N   901 PRO A N   1 
ATOM 7137  C CA  . PRO A 1 901 ? 257.608 -14.053 264.064 1.0 45.56247  ? 901 PRO A CA  901 PRO A CA  1 
ATOM 7138  C C   . PRO A 1 901 ? 259.011 -13.932 263.494 1.0 45.56247  ? 901 PRO A C   901 PRO A C   1 
ATOM 7139  O O   . PRO A 1 901 ? 259.248 -13.049 262.669 1.0 45.56247  ? 901 PRO A O   901 PRO A O   1 
ATOM 7140  C CB  . PRO A 1 901 ? 257.374 -12.944 265.079 1.0 45.56247  ? 901 PRO A CB  901 PRO A CB  1 
ATOM 7141  C CG  . PRO A 1 901 ? 257.857 -13.531 266.339 1.0 45.56247  ? 901 PRO A CG  901 PRO A CG  1 
ATOM 7142  C CD  . PRO A 1 901 ? 257.498 -14.985 266.292 1.0 45.56247  ? 901 PRO A CD  901 PRO A CD  1 
ATOM 7143  N N   . PHE A 1 902 ? 259.936 -14.789 263.919 1.0 47.37092  ? 902 PHE A N   902 PHE A N   1 
ATOM 7144  C CA  . PHE A 1 902 ? 261.346 -14.579 263.597 1.0 47.37092  ? 902 PHE A CA  902 PHE A CA  1 
ATOM 7145  C C   . PHE A 1 902 ? 261.697 -15.295 262.295 1.0 47.37092  ? 902 PHE A C   902 PHE A C   1 
ATOM 7146  O O   . PHE A 1 902 ? 262.364 -16.330 262.266 1.0 47.37092  ? 902 PHE A O   902 PHE A O   1 
ATOM 7147  C CB  . PHE A 1 902 ? 262.246 -15.034 264.740 1.0 47.37092  ? 902 PHE A CB  902 PHE A CB  1 
ATOM 7148  C CG  . PHE A 1 902 ? 262.211 -14.137 265.953 1.0 47.37092  ? 902 PHE A CG  902 PHE A CG  1 
ATOM 7149  C CD1 . PHE A 1 902 ? 261.526 -12.935 265.945 1.0 47.37092  ? 902 PHE A CD1 902 PHE A CD1 1 
ATOM 7150  C CD2 . PHE A 1 902 ? 262.912 -14.481 267.090 1.0 47.37092  ? 902 PHE A CD2 902 PHE A CD2 1 
ATOM 7151  C CE1 . PHE A 1 902 ? 261.509 -12.119 267.056 1.0 47.37092  ? 902 PHE A CE1 902 PHE A CE1 1 
ATOM 7152  C CE2 . PHE A 1 902 ? 262.905 -13.661 268.198 1.0 47.37092  ? 902 PHE A CE2 902 PHE A CE2 1 
ATOM 7153  C CZ  . PHE A 1 902 ? 262.200 -12.483 268.181 1.0 47.37092  ? 902 PHE A CZ  902 PHE A CZ  1 
ATOM 7154  N N   . ALA A 1 903 ? 261.237 -14.704 261.192 1.0 47.10418  ? 903 ALA A N   903 ALA A N   1 
ATOM 7155  C CA  . ALA A 1 903 ? 261.629 -15.156 259.859 1.0 47.10418  ? 903 ALA A CA  903 ALA A CA  1 
ATOM 7156  C C   . ALA A 1 903 ? 263.000 -14.562 259.553 1.0 47.10418  ? 903 ALA A C   903 ALA A C   1 
ATOM 7157  O O   . ALA A 1 903 ? 263.143 -13.383 259.219 1.0 47.10418  ? 903 ALA A O   903 ALA A O   1 
ATOM 7158  C CB  . ALA A 1 903 ? 260.587 -14.762 258.821 1.0 47.10418  ? 903 ALA A CB  903 ALA A CB  1 
ATOM 7159  N N   . SER A 1 904 ? 264.022 -15.413 259.701 1.0 51.37494  ? 904 SER A N   904 SER A N   1 
ATOM 7160  C CA  . SER A 1 904 ? 265.436 -15.110 259.476 1.0 51.37494  ? 904 SER A CA  904 SER A CA  1 
ATOM 7161  C C   . SER A 1 904 ? 265.926 -13.940 260.323 1.0 51.37494  ? 904 SER A C   904 SER A C   1 
ATOM 7162  O O   . SER A 1 904 ? 266.326 -12.904 259.788 1.0 51.37494  ? 904 SER A O   904 SER A O   1 
ATOM 7163  C CB  . SER A 1 904 ? 265.710 -14.844 257.991 1.0 51.37494  ? 904 SER A CB  904 SER A CB  1 
ATOM 7164  O OG  . SER A 1 904 ? 267.076 -14.536 257.778 1.0 51.37494  ? 904 SER A OG  904 SER A OG  1 
ATOM 7165  N N   . GLY A 1 905 ? 265.883 -14.091 261.641 1.0 50.40921  ? 905 GLY A N   905 GLY A N   1 
ATOM 7166  C CA  . GLY A 1 905 ? 266.400 -13.077 262.539 1.0 50.40921  ? 905 GLY A CA  905 GLY A CA  1 
ATOM 7167  C C   . GLY A 1 905 ? 267.746 -13.456 263.126 1.0 50.40921  ? 905 GLY A C   905 GLY A C   1 
ATOM 7168  O O   . GLY A 1 905 ? 268.343 -12.694 263.884 1.0 50.40921  ? 905 GLY A O   905 GLY A O   1 
ATOM 7169  N N   . MET B 2 1   ? 249.939 -18.553 249.142 1.0 43.84628  ? 1   MET B N   1   MET B N   1 
ATOM 7170  C CA  . MET B 2 1   ? 250.702 -18.595 250.383 1.0 43.84628  ? 1   MET B CA  1   MET B CA  1 
ATOM 7171  C C   . MET B 2 1   ? 250.081 -17.691 251.434 1.0 43.84628  ? 1   MET B C   1   MET B C   1 
ATOM 7172  O O   . MET B 2 1   ? 249.882 -18.102 252.572 1.0 43.84628  ? 1   MET B O   1   MET B O   1 
ATOM 7173  C CB  . MET B 2 1   ? 252.149 -18.189 250.136 1.0 43.84628  ? 1   MET B CB  1   MET B CB  1 
ATOM 7174  C CG  . MET B 2 1   ? 252.899 -19.129 249.221 1.0 43.84628  ? 1   MET B CG  1   MET B CG  1 
ATOM 7175  S SD  . MET B 2 1   ? 253.083 -20.774 249.919 1.0 43.84628  ? 1   MET B SD  1   MET B SD  1 
ATOM 7176  C CE  . MET B 2 1   ? 253.771 -21.649 248.523 1.0 43.84628  ? 1   MET B CE  1   MET B CE  1 
ATOM 7177  N N   . GLU B 2 2   ? 249.796 -16.453 251.048 1.0 44.94846  ? 2   GLU B N   2   GLU B N   1 
ATOM 7178  C CA  . GLU B 2 2   ? 249.062 -15.551 251.921 1.0 44.94846  ? 2   GLU B CA  2   GLU B CA  1 
ATOM 7179  C C   . GLU B 2 2   ? 247.618 -16.034 252.052 1.0 44.94846  ? 2   GLU B C   2   GLU B C   1 
ATOM 7180  O O   . GLU B 2 2   ? 247.089 -16.647 251.121 1.0 44.94846  ? 2   GLU B O   2   GLU B O   1 
ATOM 7181  C CB  . GLU B 2 2   ? 249.105 -14.124 251.368 1.0 44.94846  ? 2   GLU B CB  2   GLU B CB  1 
ATOM 7182  C CG  . GLU B 2 2   ? 250.461 -13.459 251.456 1.0 44.94846  ? 2   GLU B CG  2   GLU B CG  1 
ATOM 7183  C CD  . GLU B 2 2   ? 251.334 -13.754 250.262 1.0 44.94846  ? 2   GLU B CD  2   GLU B CD  1 
ATOM 7184  O OE1 . GLU B 2 2   ? 250.843 -14.392 249.309 1.0 44.94846  ? 2   GLU B OE1 2   GLU B OE1 1 
ATOM 7185  O OE2 . GLU B 2 2   ? 252.514 -13.353 250.278 1.0 44.94846  ? 2   GLU B OE2 2   GLU B OE2 1 
ATOM 7186  N N   . PRO B 2 3   ? 246.942 -15.768 253.186 1.0 43.70962  ? 3   PRO B N   3   PRO B N   1 
ATOM 7187  C CA  . PRO B 2 3   ? 247.255 -14.943 254.358 1.0 43.70962  ? 3   PRO B CA  3   PRO B CA  1 
ATOM 7188  C C   . PRO B 2 3   ? 248.157 -15.527 255.451 1.0 43.70962  ? 3   PRO B C   3   PRO B C   1 
ATOM 7189  O O   . PRO B 2 3   ? 248.018 -15.060 256.568 1.0 43.70962  ? 3   PRO B O   3   PRO B O   1 
ATOM 7190  C CB  . PRO B 2 3   ? 245.876 -14.664 254.948 1.0 43.70962  ? 3   PRO B CB  3   PRO B CB  1 
ATOM 7191  C CG  . PRO B 2 3   ? 245.085 -15.823 254.578 1.0 43.70962  ? 3   PRO B CG  3   PRO B CG  1 
ATOM 7192  C CD  . PRO B 2 3   ? 245.551 -16.243 253.230 1.0 43.70962  ? 3   PRO B CD  3   PRO B CD  1 
ATOM 7193  N N   . GLN B 2 4   ? 248.961 -16.560 255.188 1.0 42.04206  ? 4   GLN B N   4   GLN B N   1 
ATOM 7194  C CA  . GLN B 2 4   ? 250.154 -16.940 255.963 1.0 42.04206  ? 4   GLN B CA  4   GLN B CA  1 
ATOM 7195  C C   . GLN B 2 4   ? 249.906 -17.331 257.419 1.0 42.04206  ? 4   GLN B C   4   GLN B C   1 
ATOM 7196  O O   . GLN B 2 4   ? 250.849 -17.698 258.119 1.0 42.04206  ? 4   GLN B O   4   GLN B O   1 
ATOM 7197  C CB  . GLN B 2 4   ? 251.218 -15.843 255.944 1.0 42.04206  ? 4   GLN B CB  4   GLN B CB  1 
ATOM 7198  C CG  . GLN B 2 4   ? 251.938 -15.708 254.636 1.0 42.04206  ? 4   GLN B CG  4   GLN B CG  1 
ATOM 7199  C CD  . GLN B 2 4   ? 253.068 -14.722 254.722 1.0 42.04206  ? 4   GLN B CD  4   GLN B CD  1 
ATOM 7200  O OE1 . GLN B 2 4   ? 253.275 -14.097 255.756 1.0 42.04206  ? 4   GLN B OE1 4   GLN B OE1 1 
ATOM 7201  N NE2 . GLN B 2 4   ? 253.814 -14.579 253.638 1.0 42.04206  ? 4   GLN B NE2 4   GLN B NE2 1 
ATOM 7202  N N   . ARG B 2 5   ? 248.683 -17.258 257.914 1.0 41.2801   ? 5   ARG B N   5   ARG B N   1 
ATOM 7203  C CA  . ARG B 2 5   ? 248.347 -17.791 259.222 1.0 41.2801   ? 5   ARG B CA  5   ARG B CA  1 
ATOM 7204  C C   . ARG B 2 5   ? 247.324 -18.906 259.125 1.0 41.2801   ? 5   ARG B C   5   ARG B C   1 
ATOM 7205  O O   . ARG B 2 5   ? 247.369 -19.840 259.934 1.0 41.2801   ? 5   ARG B O   5   ARG B O   1 
ATOM 7206  C CB  . ARG B 2 5   ? 247.834 -16.665 260.143 1.0 41.2801   ? 5   ARG B CB  5   ARG B CB  1 
ATOM 7207  C CG  . ARG B 2 5   ? 247.528 -17.095 261.562 1.0 41.2801   ? 5   ARG B CG  5   ARG B CG  1 
ATOM 7208  C CD  . ARG B 2 5   ? 247.184 -15.989 262.542 1.0 41.2801   ? 5   ARG B CD  5   ARG B CD  1 
ATOM 7209  N NE  . ARG B 2 5   ? 248.325 -15.155 262.900 1.0 41.2801   ? 5   ARG B NE  5   ARG B NE  1 
ATOM 7210  C CZ  . ARG B 2 5   ? 248.246 -14.120 263.728 1.0 41.2801   ? 5   ARG B CZ  5   ARG B CZ  1 
ATOM 7211  N NH1 . ARG B 2 5   ? 249.324 -13.401 264.003 1.0 41.2801   ? 5   ARG B NH1 5   ARG B NH1 1 
ATOM 7212  N NH2 . ARG B 2 5   ? 247.093 -13.818 264.304 1.0 41.2801   ? 5   ARG B NH2 5   ARG B NH2 1 
ATOM 7213  N N   . GLU B 2 6   ? 246.456 -18.881 258.119 1.0 43.45776  ? 6   GLU B N   6   GLU B N   1 
ATOM 7214  C CA  . GLU B 2 6   ? 245.592 -20.001 257.802 1.0 43.45776  ? 6   GLU B CA  6   GLU B CA  1 
ATOM 7215  C C   . GLU B 2 6   ? 246.214 -20.974 256.817 1.0 43.45776  ? 6   GLU B C   6   GLU B C   1 
ATOM 7216  O O   . GLU B 2 6   ? 245.701 -22.086 256.673 1.0 43.45776  ? 6   GLU B O   6   GLU B O   1 
ATOM 7217  C CB  . GLU B 2 6   ? 244.257 -19.499 257.234 1.0 43.45776  ? 6   GLU B CB  6   GLU B CB  1 
ATOM 7218  C CG  . GLU B 2 6   ? 243.374 -18.801 258.254 1.0 43.45776  ? 6   GLU B CG  6   GLU B CG  1 
ATOM 7219  C CD  . GLU B 2 6   ? 243.732 -17.343 258.451 1.0 43.45776  ? 6   GLU B CD  6   GLU B CD  1 
ATOM 7220  O OE1 . GLU B 2 6   ? 244.606 -16.841 257.716 1.0 43.45776  ? 6   GLU B OE1 6   GLU B OE1 1 
ATOM 7221  O OE2 . GLU B 2 6   ? 243.156 -16.705 259.356 1.0 43.45776  ? 6   GLU B OE2 6   GLU B OE2 1 
ATOM 7222  N N   . PHE B 2 7   ? 247.295 -20.590 256.137 1.0 38.79465  ? 7   PHE B N   7   PHE B N   1 
ATOM 7223  C CA  . PHE B 2 7   ? 247.964 -21.531 255.250 1.0 38.79465  ? 7   PHE B CA  7   PHE B CA  1 
ATOM 7224  C C   . PHE B 2 7   ? 248.904 -22.451 256.006 1.0 38.79465  ? 7   PHE B C   7   PHE B C   1 
ATOM 7225  O O   . PHE B 2 7   ? 248.987 -23.640 255.685 1.0 38.79465  ? 7   PHE B O   7   PHE B O   1 
ATOM 7226  C CB  . PHE B 2 7   ? 248.738 -20.795 254.160 1.0 38.79465  ? 7   PHE B CB  7   PHE B CB  1 
ATOM 7227  C CG  . PHE B 2 7   ? 249.392 -21.711 253.169 1.0 38.79465  ? 7   PHE B CG  7   PHE B CG  1 
ATOM 7228  C CD1 . PHE B 2 7   ? 248.639 -22.352 252.202 1.0 38.79465  ? 7   PHE B CD1 7   PHE B CD1 1 
ATOM 7229  C CD2 . PHE B 2 7   ? 250.756 -21.937 253.205 1.0 38.79465  ? 7   PHE B CD2 7   PHE B CD2 1 
ATOM 7230  C CE1 . PHE B 2 7   ? 249.234 -23.200 251.290 1.0 38.79465  ? 7   PHE B CE1 7   PHE B CE1 1 
ATOM 7231  C CE2 . PHE B 2 7   ? 251.355 -22.786 252.298 1.0 38.79465  ? 7   PHE B CE2 7   PHE B CE2 1 
ATOM 7232  C CZ  . PHE B 2 7   ? 250.593 -23.416 251.340 1.0 38.79465  ? 7   PHE B CZ  7   PHE B CZ  1 
ATOM 7233  N N   . PHE B 2 8   ? 249.625 -21.931 256.994 1.0 38.04466  ? 8   PHE B N   8   PHE B N   1 
ATOM 7234  C CA  . PHE B 2 8   ? 250.507 -22.746 257.812 1.0 38.04466  ? 8   PHE B CA  8   PHE B CA  1 
ATOM 7235  C C   . PHE B 2 8   ? 249.853 -23.183 259.107 1.0 38.04466  ? 8   PHE B C   8   PHE B C   1 
ATOM 7236  O O   . PHE B 2 8   ? 250.516 -23.817 259.933 1.0 38.04466  ? 8   PHE B O   8   PHE B O   1 
ATOM 7237  C CB  . PHE B 2 8   ? 251.803 -21.991 258.098 1.0 38.04466  ? 8   PHE B CB  8   PHE B CB  1 
ATOM 7238  C CG  . PHE B 2 8   ? 252.623 -21.757 256.879 1.0 38.04466  ? 8   PHE B CG  8   PHE B CG  1 
ATOM 7239  C CD1 . PHE B 2 8   ? 253.391 -22.773 256.348 1.0 38.04466  ? 8   PHE B CD1 8   PHE B CD1 1 
ATOM 7240  C CD2 . PHE B 2 8   ? 252.606 -20.532 256.242 1.0 38.04466  ? 8   PHE B CD2 8   PHE B CD2 1 
ATOM 7241  C CE1 . PHE B 2 8   ? 254.135 -22.568 255.215 1.0 38.04466  ? 8   PHE B CE1 8   PHE B CE1 1 
ATOM 7242  C CE2 . PHE B 2 8   ? 253.352 -20.322 255.106 1.0 38.04466  ? 8   PHE B CE2 8   PHE B CE2 1 
ATOM 7243  C CZ  . PHE B 2 8   ? 254.114 -21.342 254.592 1.0 38.04466  ? 8   PHE B CZ  8   PHE B CZ  1 
ATOM 7244  N N   . HIS B 2 9   ? 248.575 -22.840 259.294 1.0 39.4978   ? 9   HIS B N   9   HIS B N   1 
ATOM 7245  C CA  . HIS B 2 9   ? 247.724 -23.312 260.388 1.0 39.4978   ? 9   HIS B CA  9   HIS B CA  1 
ATOM 7246  C C   . HIS B 2 9   ? 248.273 -22.912 261.751 1.0 39.4978   ? 9   HIS B C   9   HIS B C   1 
ATOM 7247  O O   . HIS B 2 9   ? 248.277 -23.696 262.700 1.0 39.4978   ? 9   HIS B O   9   HIS B O   1 
ATOM 7248  C CB  . HIS B 2 9   ? 247.486 -24.815 260.291 1.0 39.4978   ? 9   HIS B CB  9   HIS B CB  1 
ATOM 7249  C CG  . HIS B 2 9   ? 246.766 -25.209 259.044 1.0 39.4978   ? 9   HIS B CG  9   HIS B CG  1 
ATOM 7250  N ND1 . HIS B 2 9   ? 247.425 -25.547 257.883 1.0 39.4978   ? 9   HIS B ND1 9   HIS B ND1 1 
ATOM 7251  C CD2 . HIS B 2 9   ? 245.446 -25.265 258.756 1.0 39.4978   ? 9   HIS B CD2 9   HIS B CD2 1 
ATOM 7252  C CE1 . HIS B 2 9   ? 246.542 -25.830 256.944 1.0 39.4978   ? 9   HIS B CE1 9   HIS B CE1 1 
ATOM 7253  N NE2 . HIS B 2 9   ? 245.333 -25.664 257.448 1.0 39.4978   ? 9   HIS B NE2 9   HIS B NE2 1 
ATOM 7254  N N   . ILE B 2 10  ? 248.767 -21.679 261.828 1.0 39.98374  ? 10  ILE B N   10  ILE B N   1 
ATOM 7255  C CA  . ILE B 2 10  ? 248.965 -21.025 263.113 1.0 39.98374  ? 10  ILE B CA  10  ILE B CA  1 
ATOM 7256  C C   . ILE B 2 10  ? 247.621 -20.851 263.806 1.0 39.98374  ? 10  ILE B C   10  ILE B C   1 
ATOM 7257  O O   . ILE B 2 10  ? 247.483 -21.099 265.009 1.0 39.98374  ? 10  ILE B O   10  ILE B O   1 
ATOM 7258  C CB  . ILE B 2 10  ? 249.662 -19.671 262.902 1.0 39.98374  ? 10  ILE B CB  10  ILE B CB  1 
ATOM 7259  C CG1 . ILE B 2 10  ? 250.926 -19.811 262.067 1.0 39.98374  ? 10  ILE B CG1 10  ILE B CG1 1 
ATOM 7260  C CG2 . ILE B 2 10  ? 250.001 -19.041 264.204 1.0 39.98374  ? 10  ILE B CG2 10  ILE B CG2 1 
ATOM 7261  C CD1 . ILE B 2 10  ? 251.979 -20.571 262.726 1.0 39.98374  ? 10  ILE B CD1 10  ILE B CD1 1 
ATOM 7262  N N   . ALA B 2 11  ? 246.611 -20.430 263.049 1.0 39.85406  ? 11  ALA B N   11  ALA B N   1 
ATOM 7263  C CA  . ALA B 2 11  ? 245.243 -20.293 263.521 1.0 39.85406  ? 11  ALA B CA  11  ALA B CA  1 
ATOM 7264  C C   . ALA B 2 11  ? 244.322 -20.749 262.399 1.0 39.85406  ? 11  ALA B C   11  ALA B C   1 
ATOM 7265  O O   . ALA B 2 11  ? 244.774 -21.238 261.361 1.0 39.85406  ? 11  ALA B O   11  ALA B O   1 
ATOM 7266  C CB  . ALA B 2 11  ? 244.956 -18.850 263.951 1.0 39.85406  ? 11  ALA B CB  11  ALA B CB  1 
ATOM 7267  N N   . GLY B 2 12  ? 243.024 -20.588 262.595 1.0 41.81317  ? 12  GLY B N   12  GLY B N   1 
ATOM 7268  C CA  . GLY B 2 12  ? 242.053 -20.876 261.553 1.0 41.81317  ? 12  GLY B CA  12  GLY B CA  1 
ATOM 7269  C C   . GLY B 2 12  ? 241.305 -22.176 261.814 1.0 41.81317  ? 12  GLY B C   12  GLY B C   1 
ATOM 7270  O O   . GLY B 2 12  ? 240.772 -22.386 262.901 1.0 41.81317  ? 12  GLY B O   12  GLY B O   1 
ATOM 7271  N N   . ARG B 2 13  ? 241.268 -23.042 260.809 1.0 40.39968  ? 13  ARG B N   13  ARG B N   1 
ATOM 7272  C CA  . ARG B 2 13  ? 240.450 -24.242 260.845 1.0 40.39968  ? 13  ARG B CA  13  ARG B CA  1 
ATOM 7273  C C   . ARG B 2 13  ? 241.191 -25.389 261.515 1.0 40.39968  ? 13  ARG B C   13  ARG B C   1 
ATOM 7274  O O   . ARG B 2 13  ? 242.411 -25.520 261.401 1.0 40.39968  ? 13  ARG B O   13  ARG B O   1 
ATOM 7275  C CB  . ARG B 2 13  ? 240.047 -24.645 259.430 1.0 40.39968  ? 13  ARG B CB  13  ARG B CB  1 
ATOM 7276  C CG  . ARG B 2 13  ? 239.118 -23.666 258.762 1.0 40.39968  ? 13  ARG B CG  13  ARG B CG  1 
ATOM 7277  C CD  . ARG B 2 13  ? 238.900 -24.033 257.322 1.0 40.39968  ? 13  ARG B CD  13  ARG B CD  1 
ATOM 7278  N NE  . ARG B 2 13  ? 240.110 -23.826 256.537 1.0 40.39968  ? 13  ARG B NE  13  ARG B NE  1 
ATOM 7279  C CZ  . ARG B 2 13  ? 240.235 -24.172 255.262 1.0 40.39968  ? 13  ARG B CZ  13  ARG B CZ  1 
ATOM 7280  N NH1 . ARG B 2 13  ? 239.224 -24.741 254.626 1.0 40.39968  ? 13  ARG B NH1 13  ARG B NH1 1 
ATOM 7281  N NH2 . ARG B 2 13  ? 241.369 -23.947 254.620 1.0 40.39968  ? 13  ARG B NH2 13  ARG B NH2 1 
ATOM 7282  N N   . SER B 2 14  ? 240.433 -26.229 262.212 1.0 40.82901  ? 14  SER B N   14  SER B N   1 
ATOM 7283  C CA  . SER B 2 14  ? 241.004 -27.394 262.861 1.0 40.82901  ? 14  SER B CA  14  SER B CA  1 
ATOM 7284  C C   . SER B 2 14  ? 241.270 -28.485 261.834 1.0 40.82901  ? 14  SER B C   14  SER B C   1 
ATOM 7285  O O   . SER B 2 14  ? 240.872 -28.388 260.674 1.0 40.82901  ? 14  SER B O   14  SER B O   1 
ATOM 7286  C CB  . SER B 2 14  ? 240.077 -27.905 263.960 1.0 40.82901  ? 14  SER B CB  14  SER B CB  1 
ATOM 7287  O OG  . SER B 2 14  ? 238.881 -28.430 263.419 1.0 40.82901  ? 14  SER B OG  14  SER B OG  1 
ATOM 7288  N N   . ALA B 2 15  ? 241.934 -29.552 262.288 1.0 40.69758  ? 15  ALA B N   15  ALA B N   1 
ATOM 7289  C CA  . ALA B 2 15  ? 242.399 -30.609 261.393 1.0 40.69758  ? 15  ALA B CA  15  ALA B CA  1 
ATOM 7290  C C   . ALA B 2 15  ? 241.263 -31.396 260.760 1.0 40.69758  ? 15  ALA B C   15  ALA B C   1 
ATOM 7291  O O   . ALA B 2 15  ? 241.454 -31.979 259.690 1.0 40.69758  ? 15  ALA B O   15  ALA B O   1 
ATOM 7292  C CB  . ALA B 2 15  ? 243.322 -31.564 262.147 1.0 40.69758  ? 15  ALA B CB  15  ALA B CB  1 
ATOM 7293  N N   . LYS B 2 16  ? 240.091 -31.415 261.384 1.0 42.12383  ? 16  LYS B N   16  LYS B N   1 
ATOM 7294  C CA  . LYS B 2 16  ? 238.926 -32.079 260.822 1.0 42.12383  ? 16  LYS B CA  16  LYS B CA  1 
ATOM 7295  C C   . LYS B 2 16  ? 238.177 -31.214 259.822 1.0 42.12383  ? 16  LYS B C   16  LYS B C   1 
ATOM 7296  O O   . LYS B 2 16  ? 237.117 -31.629 259.354 1.0 42.12383  ? 16  LYS B O   16  LYS B O   1 
ATOM 7297  C CB  . LYS B 2 16  ? 237.965 -32.489 261.938 1.0 42.12383  ? 16  LYS B CB  16  LYS B CB  1 
ATOM 7298  C CG  . LYS B 2 16  ? 238.489 -33.565 262.860 1.0 42.12383  ? 16  LYS B CG  16  LYS B CG  1 
ATOM 7299  C CD  . LYS B 2 16  ? 237.447 -33.921 263.911 1.0 42.12383  ? 16  LYS B CD  16  LYS B CD  1 
ATOM 7300  C CE  . LYS B 2 16  ? 237.950 -34.994 264.865 1.0 42.12383  ? 16  LYS B CE  16  LYS B CE  1 
ATOM 7301  N NZ  . LYS B 2 16  ? 236.941 -35.326 265.907 1.0 42.12383  ? 16  LYS B NZ  16  LYS B NZ  1 
ATOM 7302  N N   . GLU B 2 17  ? 238.685 -30.035 259.489 1.0 42.82549  ? 17  GLU B N   17  GLU B N   1 
ATOM 7303  C CA  . GLU B 2 17  ? 237.930 -29.083 258.686 1.0 42.82549  ? 17  GLU B CA  17  GLU B CA  1 
ATOM 7304  C C   . GLU B 2 17  ? 238.601 -28.712 257.377 1.0 42.82549  ? 17  GLU B C   17  GLU B C   1 
ATOM 7305  O O   . GLU B 2 17  ? 237.917 -28.607 256.361 1.0 42.82549  ? 17  GLU B O   17  GLU B O   1 
ATOM 7306  C CB  . GLU B 2 17  ? 237.668 -27.813 259.493 1.0 42.82549  ? 17  GLU B CB  17  GLU B CB  1 
ATOM 7307  C CG  . GLU B 2 17  ? 236.758 -28.025 260.678 1.0 42.82549  ? 17  GLU B CG  17  GLU B CG  1 
ATOM 7308  C CD  . GLU B 2 17  ? 236.550 -26.761 261.479 1.0 42.82549  ? 17  GLU B CD  17  GLU B CD  1 
ATOM 7309  O OE1 . GLU B 2 17  ? 237.197 -25.743 261.162 1.0 42.82549  ? 17  GLU B OE1 17  GLU B OE1 1 
ATOM 7310  O OE2 . GLU B 2 17  ? 235.745 -26.786 262.432 1.0 42.82549  ? 17  GLU B OE2 17  GLU B OE2 1 
ATOM 7311  N N   . TYR B 2 18  ? 239.913 -28.502 257.356 1.0 38.9101   ? 18  TYR B N   18  TYR B N   1 
ATOM 7312  C CA  . TYR B 2 18  ? 240.563 -28.101 256.118 1.0 38.9101   ? 18  TYR B CA  18  TYR B CA  1 
ATOM 7313  C C   . TYR B 2 18  ? 240.951 -29.281 255.242 1.0 38.9101   ? 18  TYR B C   18  TYR B C   1 
ATOM 7314  O O   . TYR B 2 18  ? 241.640 -29.085 254.239 1.0 38.9101   ? 18  TYR B O   18  TYR B O   1 
ATOM 7315  C CB  . TYR B 2 18  ? 241.796 -27.228 256.393 1.0 38.9101   ? 18  TYR B CB  18  TYR B CB  1 
ATOM 7316  C CG  . TYR B 2 18  ? 242.950 -27.881 257.127 1.0 38.9101   ? 18  TYR B CG  18  TYR B CG  1 
ATOM 7317  C CD1 . TYR B 2 18  ? 243.049 -27.798 258.500 1.0 38.9101   ? 18  TYR B CD1 18  TYR B CD1 1 
ATOM 7318  C CD2 . TYR B 2 18  ? 243.961 -28.543 256.441 1.0 38.9101   ? 18  TYR B CD2 18  TYR B CD2 1 
ATOM 7319  C CE1 . TYR B 2 18  ? 244.098 -28.374 259.173 1.0 38.9101   ? 18  TYR B CE1 18  TYR B CE1 1 
ATOM 7320  C CE2 . TYR B 2 18  ? 245.010 -29.128 257.109 1.0 38.9101   ? 18  TYR B CE2 18  TYR B CE2 1 
ATOM 7321  C CZ  . TYR B 2 18  ? 245.071 -29.037 258.474 1.0 38.9101   ? 18  TYR B CZ  18  TYR B CZ  1 
ATOM 7322  O OH  . TYR B 2 18  ? 246.116 -29.613 259.149 1.0 38.9101   ? 18  TYR B OH  18  TYR B OH  1 
ATOM 7323  N N   . LEU B 2 19  ? 240.548 -30.492 255.596 1.0 39.84632  ? 19  LEU B N   19  LEU B N   1 
ATOM 7324  C CA  . LEU B 2 19  ? 240.871 -31.662 254.799 1.0 39.84632  ? 19  LEU B CA  19  LEU B CA  1 
ATOM 7325  C C   . LEU B 2 19  ? 239.716 -32.024 253.881 1.0 39.84632  ? 19  LEU B C   19  LEU B C   1 
ATOM 7326  O O   . LEU B 2 19  ? 238.610 -31.494 253.982 1.0 39.84632  ? 19  LEU B O   19  LEU B O   1 
ATOM 7327  C CB  . LEU B 2 19  ? 241.220 -32.852 255.691 1.0 39.84632  ? 19  LEU B CB  19  LEU B CB  1 
ATOM 7328  C CG  . LEU B 2 19  ? 242.531 -32.769 256.453 1.0 39.84632  ? 19  LEU B CG  19  LEU B CG  1 
ATOM 7329  C CD1 . LEU B 2 19  ? 242.699 -33.995 257.315 1.0 39.84632  ? 19  LEU B CD1 19  LEU B CD1 1 
ATOM 7330  C CD2 . LEU B 2 19  ? 243.670 -32.637 255.481 1.0 39.84632  ? 19  LEU B CD2 19  LEU B CD2 1 
ATOM 7331  N N   . SER B 2 20  ? 240.003 -32.934 252.960 1.0 45.80393  ? 20  SER B N   20  SER B N   1 
ATOM 7332  C CA  . SER B 2 20  ? 238.970 -33.524 252.129 1.0 45.80393  ? 20  SER B CA  20  SER B CA  1 
ATOM 7333  C C   . SER B 2 20  ? 238.014 -34.346 252.982 1.0 45.80393  ? 20  SER B C   20  SER B C   1 
ATOM 7334  O O   . SER B 2 20  ? 238.405 -34.949 253.982 1.0 45.80393  ? 20  SER B O   20  SER B O   1 
ATOM 7335  C CB  . SER B 2 20  ? 239.611 -34.402 251.059 1.0 45.80393  ? 20  SER B CB  20  SER B CB  1 
ATOM 7336  O OG  . SER B 2 20  ? 238.640 -35.133 250.342 1.0 45.80393  ? 20  SER B OG  20  SER B OG  1 
ATOM 7337  N N   . GLU B 2 21  ? 236.739 -34.345 252.589 1.0 49.81075  ? 21  GLU B N   21  GLU B N   1 
ATOM 7338  C CA  . GLU B 2 21  ? 235.752 -35.177 253.270 1.0 49.81075  ? 21  GLU B CA  21  GLU B CA  1 
ATOM 7339  C C   . GLU B 2 21  ? 236.047 -36.654 253.055 1.0 49.81075  ? 21  GLU B C   21  GLU B C   1 
ATOM 7340  O O   . GLU B 2 21  ? 235.808 -37.477 253.944 1.0 49.81075  ? 21  GLU B O   21  GLU B O   1 
ATOM 7341  C CB  . GLU B 2 21  ? 234.344 -34.820 252.787 1.0 49.81075  ? 21  GLU B CB  21  GLU B CB  1 
ATOM 7342  C CG  . GLU B 2 21  ? 233.208 -35.646 253.389 1.0 49.81075  ? 21  GLU B CG  21  GLU B CG  1 
ATOM 7343  C CD  . GLU B 2 21  ? 233.014 -35.430 254.874 1.0 49.81075  ? 21  GLU B CD  21  GLU B CD  1 
ATOM 7344  O OE1 . GLU B 2 21  ? 233.308 -34.325 255.367 1.0 49.81075  ? 21  GLU B OE1 21  GLU B OE1 1 
ATOM 7345  O OE2 . GLU B 2 21  ? 232.554 -36.366 255.554 1.0 49.81075  ? 21  GLU B OE2 21  GLU B OE2 1 
ATOM 7346  N N   . ASN B 2 22  ? 236.605 -37.001 251.894 1.0 48.82501  ? 22  ASN B N   22  ASN B N   1 
ATOM 7347  C CA  . ASN B 2 22  ? 237.013 -38.377 251.644 1.0 48.82501  ? 22  ASN B CA  22  ASN B CA  1 
ATOM 7348  C C   . ASN B 2 22  ? 238.200 -38.789 252.498 1.0 48.82501  ? 22  ASN B C   22  ASN B C   1 
ATOM 7349  O O   . ASN B 2 22  ? 238.340 -39.972 252.819 1.0 48.82501  ? 22  ASN B O   22  ASN B O   1 
ATOM 7350  C CB  . ASN B 2 22  ? 237.345 -38.570 250.169 1.0 48.82501  ? 22  ASN B CB  22  ASN B CB  1 
ATOM 7351  C CG  . ASN B 2 22  ? 236.126 -38.553 249.296 1.0 48.82501  ? 22  ASN B CG  22  ASN B CG  1 
ATOM 7352  O OD1 . ASN B 2 22  ? 235.947 -37.666 248.467 1.0 48.82501  ? 22  ASN B OD1 22  ASN B OD1 1 
ATOM 7353  N ND2 . ASN B 2 22  ? 235.278 -39.551 249.465 1.0 48.82501  ? 22  ASN B ND2 22  ASN B ND2 1 
ATOM 7354  N N   . LEU B 2 23  ? 239.063 -37.850 252.878 1.0 43.22361  ? 23  LEU B N   23  LEU B N   1 
ATOM 7355  C CA  . LEU B 2 23  ? 240.223 -38.225 253.673 1.0 43.22361  ? 23  LEU B CA  23  LEU B CA  1 
ATOM 7356  C C   . LEU B 2 23  ? 239.902 -38.296 255.155 1.0 43.22361  ? 23  LEU B C   23  LEU B C   1 
ATOM 7357  O O   . LEU B 2 23  ? 240.502 -39.108 255.866 1.0 43.22361  ? 23  LEU B O   23  LEU B O   1 
ATOM 7358  C CB  . LEU B 2 23  ? 241.377 -37.249 253.422 1.0 43.22361  ? 23  LEU B CB  23  LEU B CB  1 
ATOM 7359  C CG  . LEU B 2 23  ? 242.790 -37.635 253.870 1.0 43.22361  ? 23  LEU B CG  23  LEU B CG  1 
ATOM 7360  C CD1 . LEU B 2 23  ? 243.763 -37.087 252.871 1.0 43.22361  ? 23  LEU B CD1 23  LEU B CD1 1 
ATOM 7361  C CD2 . LEU B 2 23  ? 243.156 -37.108 255.246 1.0 43.22361  ? 23  LEU B CD2 23  LEU B CD2 1 
ATOM 7362  N N   . VAL B 2 24  ? 238.977 -37.464 255.636 1.0 43.6652   ? 24  VAL B N   24  VAL B N   1 
ATOM 7363  C CA  . VAL B 2 24  ? 238.550 -37.543 257.029 1.0 43.6652   ? 24  VAL B CA  24  VAL B CA  1 
ATOM 7364  C C   . VAL B 2 24  ? 237.802 -38.847 257.278 1.0 43.6652   ? 24  VAL B C   24  VAL B C   1 
ATOM 7365  O O   . VAL B 2 24  ? 237.973 -39.488 258.321 1.0 43.6652   ? 24  VAL B O   24  VAL B O   1 
ATOM 7366  C CB  . VAL B 2 24  ? 237.708 -36.306 257.391 1.0 43.6652   ? 24  VAL B CB  24  VAL B CB  1 
ATOM 7367  C CG1 . VAL B 2 24  ? 237.156 -36.404 258.792 1.0 43.6652   ? 24  VAL B CG1 24  VAL B CG1 1 
ATOM 7368  C CG2 . VAL B 2 24  ? 238.549 -35.061 257.274 1.0 43.6652   ? 24  VAL B CG2 24  VAL B CG2 1 
ATOM 7369  N N   . GLN B 2 25  ? 237.015 -39.296 256.301 1.0 46.49256  ? 25  GLN B N   25  GLN B N   1 
ATOM 7370  C CA  . GLN B 2 25  ? 236.380 -40.603 256.408 1.0 46.49256  ? 25  GLN B CA  25  GLN B CA  1 
ATOM 7371  C C   . GLN B 2 25  ? 237.378 -41.745 256.282 1.0 46.49256  ? 25  GLN B C   25  GLN B C   1 
ATOM 7372  O O   . GLN B 2 25  ? 237.060 -42.869 256.677 1.0 46.49256  ? 25  GLN B O   25  GLN B O   1 
ATOM 7373  C CB  . GLN B 2 25  ? 235.293 -40.756 255.349 1.0 46.49256  ? 25  GLN B CB  25  GLN B CB  1 
ATOM 7374  C CG  . GLN B 2 25  ? 234.115 -39.834 255.542 1.0 46.49256  ? 25  GLN B CG  25  GLN B CG  1 
ATOM 7375  C CD  . GLN B 2 25  ? 233.060 -40.035 254.484 1.0 46.49256  ? 25  GLN B CD  25  GLN B CD  1 
ATOM 7376  O OE1 . GLN B 2 25  ? 233.226 -40.845 253.574 1.0 46.49256  ? 25  GLN B OE1 25  GLN B OE1 1 
ATOM 7377  N NE2 . GLN B 2 25  ? 231.966 -39.294 254.590 1.0 46.49256  ? 25  GLN B NE2 25  GLN B NE2 1 
ATOM 7378  N N   . PHE B 2 26  ? 238.570 -41.487 255.743 1.0 45.05899  ? 26  PHE B N   26  PHE B N   1 
ATOM 7379  C CA  . PHE B 2 26  ? 239.594 -42.521 255.690 1.0 45.05899  ? 26  PHE B CA  26  PHE B CA  1 
ATOM 7380  C C   . PHE B 2 26  ? 240.352 -42.613 257.007 1.0 45.05899  ? 26  PHE B C   26  PHE B C   1 
ATOM 7381  O O   . PHE B 2 26  ? 240.562 -43.711 257.530 1.0 45.05899  ? 26  PHE B O   26  PHE B O   1 
ATOM 7382  C CB  . PHE B 2 26  ? 240.564 -42.252 254.541 1.0 45.05899  ? 26  PHE B CB  26  PHE B CB  1 
ATOM 7383  C CG  . PHE B 2 26  ? 241.599 -43.322 254.363 1.0 45.05899  ? 26  PHE B CG  26  PHE B CG  1 
ATOM 7384  C CD1 . PHE B 2 26  ? 241.288 -44.499 253.708 1.0 45.05899  ? 26  PHE B CD1 26  PHE B CD1 1 
ATOM 7385  C CD2 . PHE B 2 26  ? 242.881 -43.157 254.863 1.0 45.05899  ? 26  PHE B CD2 26  PHE B CD2 1 
ATOM 7386  C CE1 . PHE B 2 26  ? 242.237 -45.488 253.547 1.0 45.05899  ? 26  PHE B CE1 26  PHE B CE1 1 
ATOM 7387  C CE2 . PHE B 2 26  ? 243.830 -44.146 254.715 1.0 45.05899  ? 26  PHE B CE2 26  PHE B CE2 1 
ATOM 7388  C CZ  . PHE B 2 26  ? 243.510 -45.309 254.050 1.0 45.05899  ? 26  PHE B CZ  26  PHE B CZ  1 
ATOM 7389  N N   . ILE B 2 27  ? 240.773 -41.472 257.562 1.0 44.68863  ? 27  ILE B N   27  ILE B N   1 
ATOM 7390  C CA  . ILE B 2 27  ? 241.609 -41.496 258.758 1.0 44.68863  ? 27  ILE B CA  27  ILE B CA  1 
ATOM 7391  C C   . ILE B 2 27  ? 240.832 -41.862 260.010 1.0 44.68863  ? 27  ILE B C   27  ILE B C   1 
ATOM 7392  O O   . ILE B 2 27  ? 241.443 -42.121 261.050 1.0 44.68863  ? 27  ILE B O   27  ILE B O   1 
ATOM 7393  C CB  . ILE B 2 27  ? 242.352 -40.152 258.938 1.0 44.68863  ? 27  ILE B CB  27  ILE B CB  1 
ATOM 7394  C CG1 . ILE B 2 27  ? 241.406 -38.954 259.078 1.0 44.68863  ? 27  ILE B CG1 27  ILE B CG1 1 
ATOM 7395  C CG2 . ILE B 2 27  ? 243.264 -39.903 257.765 1.0 44.68863  ? 27  ILE B CG2 27  ILE B CG2 1 
ATOM 7396  C CD1 . ILE B 2 27  ? 241.115 -38.486 260.513 1.0 44.68863  ? 27  ILE B CD1 27  ILE B CD1 1 
ATOM 7397  N N   . GLN B 2 28  ? 239.504 -41.861 259.950 1.0 46.01895  ? 28  GLN B N   28  GLN B N   1 
ATOM 7398  C CA  . GLN B 2 28  ? 238.702 -42.388 261.041 1.0 46.01895  ? 28  GLN B CA  28  GLN B CA  1 
ATOM 7399  C C   . GLN B 2 28  ? 238.521 -43.889 260.942 1.0 46.01895  ? 28  GLN B C   28  GLN B C   1 
ATOM 7400  O O   . GLN B 2 28  ? 238.466 -44.568 261.972 1.0 46.01895  ? 28  GLN B O   28  GLN B O   1 
ATOM 7401  C CB  . GLN B 2 28  ? 237.331 -41.714 261.069 1.0 46.01895  ? 28  GLN B CB  28  GLN B CB  1 
ATOM 7402  C CG  . GLN B 2 28  ? 237.372 -40.258 261.461 1.0 46.01895  ? 28  GLN B CG  28  GLN B CG  1 
ATOM 7403  C CD  . GLN B 2 28  ? 236.008 -39.616 261.414 1.0 46.01895  ? 28  GLN B CD  28  GLN B CD  1 
ATOM 7404  O OE1 . GLN B 2 28  ? 235.026 -40.249 261.030 1.0 46.01895  ? 28  GLN B OE1 28  GLN B OE1 1 
ATOM 7405  N NE2 . GLN B 2 28  ? 235.939 -38.349 261.799 1.0 46.01895  ? 28  GLN B NE2 28  GLN B NE2 1 
ATOM 7406  N N   . ALA B 2 29  ? 238.425 -44.422 259.725 1.0 45.17878  ? 29  ALA B N   29  ALA B N   1 
ATOM 7407  C CA  . ALA B 2 29  ? 238.279 -45.861 259.556 1.0 45.17878  ? 29  ALA B CA  29  ALA B CA  1 
ATOM 7408  C C   . ALA B 2 29  ? 239.599 -46.572 259.810 1.0 45.17878  ? 29  ALA B C   29  ALA B C   1 
ATOM 7409  O O   . ALA B 2 29  ? 239.709 -47.404 260.716 1.0 45.17878  ? 29  ALA B O   29  ALA B O   1 
ATOM 7410  C CB  . ALA B 2 29  ? 237.756 -46.173 258.154 1.0 45.17878  ? 29  ALA B CB  29  ALA B CB  1 
ATOM 7411  N N   . THR B 2 30  ? 240.622 -46.248 259.023 1.0 46.20807  ? 30  THR B N   30  THR B N   1 
ATOM 7412  C CA  . THR B 2 30  ? 241.937 -46.861 259.186 1.0 46.20807  ? 30  THR B CA  30  THR B CA  1 
ATOM 7413  C C   . THR B 2 30  ? 242.713 -46.025 260.194 1.0 46.20807  ? 30  THR B C   30  THR B C   1 
ATOM 7414  O O   . THR B 2 30  ? 243.563 -45.206 259.850 1.0 46.20807  ? 30  THR B O   30  THR B O   1 
ATOM 7415  C CB  . THR B 2 30  ? 242.666 -46.937 257.855 1.0 46.20807  ? 30  THR B CB  30  THR B CB  1 
ATOM 7416  O OG1 . THR B 2 30  ? 243.025 -45.616 257.446 1.0 46.20807  ? 30  THR B OG1 30  THR B OG1 1 
ATOM 7417  C CG2 . THR B 2 30  ? 241.761 -47.526 256.800 1.0 46.20807  ? 30  THR B CG2 30  THR B CG2 1 
ATOM 7418  N N   . GLN B 2 31  ? 242.398 -46.229 261.462 1.0 48.52365  ? 31  GLN B N   31  GLN B N   1 
ATOM 7419  C CA  . GLN B 2 31  ? 243.034 -45.484 262.538 1.0 48.52365  ? 31  GLN B CA  31  GLN B CA  1 
ATOM 7420  C C   . GLN B 2 31  ? 243.692 -46.381 263.567 1.0 48.52365  ? 31  GLN B C   31  GLN B C   1 
ATOM 7421  O O   . GLN B 2 31  ? 244.778 -46.064 264.056 1.0 48.52365  ? 31  GLN B O   31  GLN B O   1 
ATOM 7422  C CB  . GLN B 2 31  ? 242.005 -44.587 263.235 1.0 48.52365  ? 31  GLN B CB  31  GLN B CB  1 
ATOM 7423  C CG  . GLN B 2 31  ? 242.580 -43.666 264.289 1.0 48.52365  ? 31  GLN B CG  31  GLN B CG  1 
ATOM 7424  C CD  . GLN B 2 31  ? 241.521 -42.815 264.946 1.0 48.52365  ? 31  GLN B CD  31  GLN B CD  1 
ATOM 7425  O OE1 . GLN B 2 31  ? 240.334 -42.945 264.650 1.0 48.52365  ? 31  GLN B OE1 31  GLN B OE1 1 
ATOM 7426  N NE2 . GLN B 2 31  ? 241.942 -41.935 265.845 1.0 48.52365  ? 31  GLN B NE2 31  GLN B NE2 1 
ATOM 7427  N N   . ASN B 2 32  ? 243.077 -47.513 263.887 1.0 49.54013  ? 32  ASN B N   32  ASN B N   1 
ATOM 7428  C CA  . ASN B 2 32  ? 243.583 -48.396 264.926 1.0 49.54013  ? 32  ASN B CA  32  ASN B CA  1 
ATOM 7429  C C   . ASN B 2 32  ? 244.768 -49.237 264.475 1.0 49.54013  ? 32  ASN B C   32  ASN B C   1 
ATOM 7430  O O   . ASN B 2 32  ? 245.324 -49.978 265.291 1.0 49.54013  ? 32  ASN B O   32  ASN B O   1 
ATOM 7431  C CB  . ASN B 2 32  ? 242.455 -49.300 265.420 1.0 49.54013  ? 32  ASN B CB  32  ASN B CB  1 
ATOM 7432  C CG  . ASN B 2 32  ? 241.331 -48.516 266.061 1.0 49.54013  ? 32  ASN B CG  32  ASN B CG  1 
ATOM 7433  O OD1 . ASN B 2 32  ? 240.213 -48.479 265.550 1.0 49.54013  ? 32  ASN B OD1 32  ASN B OD1 1 
ATOM 7434  N ND2 . ASN B 2 32  ? 241.624 -47.875 267.183 1.0 49.54013  ? 32  ASN B ND2 32  ASN B ND2 1 
ATOM 7435  N N   . TYR B 2 33  ? 245.164 -49.156 263.208 1.0 48.50792  ? 33  TYR B N   33  TYR B N   1 
ATOM 7436  C CA  . TYR B 2 33  ? 246.373 -49.837 262.760 1.0 48.50792  ? 33  TYR B CA  33  TYR B CA  1 
ATOM 7437  C C   . TYR B 2 33  ? 247.283 -48.998 261.879 1.0 48.50792  ? 33  TYR B C   33  TYR B C   1 
ATOM 7438  O O   . TYR B 2 33  ? 248.476 -49.306 261.803 1.0 48.50792  ? 33  TYR B O   33  TYR B O   1 
ATOM 7439  C CB  . TYR B 2 33  ? 246.014 -51.130 262.021 1.0 48.50792  ? 33  TYR B CB  33  TYR B CB  1 
ATOM 7440  C CG  . TYR B 2 33  ? 245.186 -50.960 260.766 1.0 48.50792  ? 33  TYR B CG  33  TYR B CG  1 
ATOM 7441  C CD1 . TYR B 2 33  ? 243.799 -50.909 260.825 1.0 48.50792  ? 33  TYR B CD1 33  TYR B CD1 1 
ATOM 7442  C CD2 . TYR B 2 33  ? 245.788 -50.900 259.518 1.0 48.50792  ? 33  TYR B CD2 33  TYR B CD2 1 
ATOM 7443  C CE1 . TYR B 2 33  ? 243.040 -50.774 259.681 1.0 48.50792  ? 33  TYR B CE1 33  TYR B CE1 1 
ATOM 7444  C CE2 . TYR B 2 33  ? 245.037 -50.763 258.371 1.0 48.50792  ? 33  TYR B CE2 33  TYR B CE2 1 
ATOM 7445  C CZ  . TYR B 2 33  ? 243.667 -50.702 258.460 1.0 48.50792  ? 33  TYR B CZ  33  TYR B CZ  1 
ATOM 7446  O OH  . TYR B 2 33  ? 242.921 -50.572 257.317 1.0 48.50792  ? 33  TYR B OH  33  TYR B OH  1 
ATOM 7447  N N   . PHE B 2 34  ? 246.791 -47.954 261.217 1.0 48.6502   ? 34  PHE B N   34  PHE B N   1 
ATOM 7448  C CA  . PHE B 2 34  ? 247.610 -47.172 260.290 1.0 48.6502   ? 34  PHE B CA  34  PHE B CA  1 
ATOM 7449  C C   . PHE B 2 34  ? 247.281 -45.699 260.520 1.0 48.6502   ? 34  PHE B C   34  PHE B C   1 
ATOM 7450  O O   . PHE B 2 34  ? 246.423 -45.129 259.846 1.0 48.6502   ? 34  PHE B O   34  PHE B O   1 
ATOM 7451  C CB  . PHE B 2 34  ? 247.347 -47.616 258.860 1.0 48.6502   ? 34  PHE B CB  34  PHE B CB  1 
ATOM 7452  C CG  . PHE B 2 34  ? 248.199 -46.932 257.841 1.0 48.6502   ? 34  PHE B CG  34  PHE B CG  1 
ATOM 7453  C CD1 . PHE B 2 34  ? 249.566 -47.150 257.805 1.0 48.6502   ? 34  PHE B CD1 34  PHE B CD1 1 
ATOM 7454  C CD2 . PHE B 2 34  ? 247.628 -46.117 256.882 1.0 48.6502   ? 34  PHE B CD2 34  PHE B CD2 1 
ATOM 7455  C CE1 . PHE B 2 34  ? 250.355 -46.531 256.855 1.0 48.6502   ? 34  PHE B CE1 34  PHE B CE1 1 
ATOM 7456  C CE2 . PHE B 2 34  ? 248.406 -45.508 255.923 1.0 48.6502   ? 34  PHE B CE2 34  PHE B CE2 1 
ATOM 7457  C CZ  . PHE B 2 34  ? 249.773 -45.708 255.914 1.0 48.6502   ? 34  PHE B CZ  34  PHE B CZ  1 
ATOM 7458  N N   . ASN B 2 35  ? 247.995 -45.081 261.456 1.0 48.19526  ? 35  ASN B N   35  ASN B N   1 
ATOM 7459  C CA  . ASN B 2 35  ? 247.636 -43.756 261.941 1.0 48.19526  ? 35  ASN B CA  35  ASN B CA  1 
ATOM 7460  C C   . ASN B 2 35  ? 248.154 -42.697 260.977 1.0 48.19526  ? 35  ASN B C   35  ASN B C   1 
ATOM 7461  O O   . ASN B 2 35  ? 249.348 -42.661 260.664 1.0 48.19526  ? 35  ASN B O   35  ASN B O   1 
ATOM 7462  C CB  . ASN B 2 35  ? 248.202 -43.529 263.340 1.0 48.19526  ? 35  ASN B CB  35  ASN B CB  1 
ATOM 7463  C CG  . ASN B 2 35  ? 247.386 -42.540 264.153 1.0 48.19526  ? 35  ASN B CG  35  ASN B CG  1 
ATOM 7464  O OD1 . ASN B 2 35  ? 247.592 -42.392 265.356 1.0 48.19526  ? 35  ASN B OD1 35  ASN B OD1 1 
ATOM 7465  N ND2 . ASN B 2 35  ? 246.428 -41.887 263.510 1.0 48.19526  ? 35  ASN B ND2 35  ASN B ND2 1 
ATOM 7466  N N   . ILE B 2 36  ? 247.255 -41.835 260.511 1.0 45.19937  ? 36  ILE B N   36  ILE B N   1 
ATOM 7467  C CA  . ILE B 2 36  ? 247.621 -40.732 259.642 1.0 45.19937  ? 36  ILE B CA  36  ILE B CA  1 
ATOM 7468  C C   . ILE B 2 36  ? 247.386 -39.377 260.299 1.0 45.19937  ? 36  ILE B C   36  ILE B C   1 
ATOM 7469  O O   . ILE B 2 36  ? 248.222 -38.478 260.148 1.0 45.19937  ? 36  ILE B O   36  ILE B O   1 
ATOM 7470  C CB  . ILE B 2 36  ? 246.864 -40.836 258.300 1.0 45.19937  ? 36  ILE B CB  36  ILE B CB  1 
ATOM 7471  C CG1 . ILE B 2 36  ? 247.230 -42.136 257.606 1.0 45.19937  ? 36  ILE B CG1 36  ILE B CG1 1 
ATOM 7472  C CG2 . ILE B 2 36  ? 247.201 -39.692 257.364 1.0 45.19937  ? 36  ILE B CG2 36  ILE B CG2 1 
ATOM 7473  C CD1 . ILE B 2 36  ? 248.701 -42.232 257.321 1.0 45.19937  ? 36  ILE B CD1 36  ILE B CD1 1 
ATOM 7474  N N   . GLY B 2 37  ? 246.321 -39.226 261.085 1.0 45.39611  ? 37  GLY B N   37  GLY B N   1 
ATOM 7475  C CA  . GLY B 2 37  ? 245.849 -37.961 261.626 1.0 45.39611  ? 37  GLY B CA  37  GLY B CA  1 
ATOM 7476  C C   . GLY B 2 37  ? 246.804 -37.202 262.526 1.0 45.39611  ? 37  GLY B C   37  GLY B C   1 
ATOM 7477  O O   . GLY B 2 37  ? 246.494 -36.066 262.893 1.0 45.39611  ? 37  GLY B O   37  GLY B O   1 
ATOM 7478  N N   . GLU B 2 38  ? 247.945 -37.778 262.896 1.0 47.34133  ? 38  GLU B N   38  GLU B N   1 
ATOM 7479  C CA  . GLU B 2 38  ? 248.979 -37.031 263.595 1.0 47.34133  ? 38  GLU B CA  38  GLU B CA  1 
ATOM 7480  C C   . GLU B 2 38  ? 249.895 -36.272 262.649 1.0 47.34133  ? 38  GLU B C   38  GLU B C   1 
ATOM 7481  O O   . GLU B 2 38  ? 250.835 -35.620 263.113 1.0 47.34133  ? 38  GLU B O   38  GLU B O   1 
ATOM 7482  C CB  . GLU B 2 38  ? 249.809 -37.974 264.465 1.0 47.34133  ? 38  GLU B CB  38  GLU B CB  1 
ATOM 7483  C CG  . GLU B 2 38  ? 249.029 -38.593 265.606 1.0 47.34133  ? 38  GLU B CG  38  GLU B CG  1 
ATOM 7484  C CD  . GLU B 2 38  ? 248.626 -37.578 266.654 1.0 47.34133  ? 38  GLU B CD  38  GLU B CD  1 
ATOM 7485  O OE1 . GLU B 2 38  ? 249.398 -36.625 266.888 1.0 47.34133  ? 38  GLU B OE1 38  GLU B OE1 1 
ATOM 7486  O OE2 . GLU B 2 38  ? 247.534 -37.729 267.240 1.0 47.34133  ? 38  GLU B OE2 38  GLU B OE2 1 
ATOM 7487  N N   . LYS B 2 39  ? 249.650 -36.344 261.341 1.0 40.98463  ? 39  LYS B N   39  LYS B N   1 
ATOM 7488  C CA  . LYS B 2 39  ? 250.458 -35.667 260.340 1.0 40.98463  ? 39  LYS B CA  39  LYS B CA  1 
ATOM 7489  C C   . LYS B 2 39  ? 249.822 -34.369 259.873 1.0 40.98463  ? 39  LYS B C   39  LYS B C   1 
ATOM 7490  O O   . LYS B 2 39  ? 250.166 -33.867 258.800 1.0 40.98463  ? 39  LYS B O   39  LYS B O   1 
ATOM 7491  C CB  . LYS B 2 39  ? 250.694 -36.592 259.148 1.0 40.98463  ? 39  LYS B CB  39  LYS B CB  1 
ATOM 7492  C CG  . LYS B 2 39  ? 251.470 -37.838 259.497 1.0 40.98463  ? 39  LYS B CG  39  LYS B CG  1 
ATOM 7493  C CD  . LYS B 2 39  ? 251.588 -38.772 258.319 1.0 40.98463  ? 39  LYS B CD  39  LYS B CD  1 
ATOM 7494  C CE  . LYS B 2 39  ? 252.478 -39.941 258.666 1.0 40.98463  ? 39  LYS B CE  39  LYS B CE  1 
ATOM 7495  N NZ  . LYS B 2 39  ? 251.898 -40.765 259.747 1.0 40.98463  ? 39  LYS B NZ  39  LYS B NZ  1 
ATOM 7496  N N   . PHE B 2 40  ? 248.891 -33.823 260.645 1.0 39.2602   ? 40  PHE B N   40  PHE B N   1 
ATOM 7497  C CA  . PHE B 2 40  ? 248.194 -32.605 260.265 1.0 39.2602   ? 40  PHE B CA  40  PHE B CA  1 
ATOM 7498  C C   . PHE B 2 40  ? 248.091 -31.707 261.483 1.0 39.2602   ? 40  PHE B C   40  PHE B C   1 
ATOM 7499  O O   . PHE B 2 40  ? 247.634 -32.144 262.541 1.0 39.2602   ? 40  PHE B O   40  PHE B O   1 
ATOM 7500  C CB  . PHE B 2 40  ? 246.806 -32.917 259.705 1.0 39.2602   ? 40  PHE B CB  40  PHE B CB  1 
ATOM 7501  C CG  . PHE B 2 40  ? 246.836 -33.693 258.426 1.0 39.2602   ? 40  PHE B CG  40  PHE B CG  1 
ATOM 7502  C CD1 . PHE B 2 40  ? 247.110 -33.063 257.232 1.0 39.2602   ? 40  PHE B CD1 40  PHE B CD1 1 
ATOM 7503  C CD2 . PHE B 2 40  ? 246.587 -35.052 258.418 1.0 39.2602   ? 40  PHE B CD2 40  PHE B CD2 1 
ATOM 7504  C CE1 . PHE B 2 40  ? 247.141 -33.772 256.055 1.0 39.2602   ? 40  PHE B CE1 40  PHE B CE1 1 
ATOM 7505  C CE2 . PHE B 2 40  ? 246.614 -35.766 257.241 1.0 39.2602   ? 40  PHE B CE2 40  PHE B CE2 1 
ATOM 7506  C CZ  . PHE B 2 40  ? 246.892 -35.124 256.061 1.0 39.2602   ? 40  PHE B CZ  40  PHE B CZ  1 
ATOM 7507  N N   . ARG B 2 41  ? 248.520 -30.462 261.332 1.0 41.74358  ? 41  ARG B N   41  ARG B N   1 
ATOM 7508  C CA  . ARG B 2 41  ? 248.602 -29.549 262.458 1.0 41.74358  ? 41  ARG B CA  41  ARG B CA  1 
ATOM 7509  C C   . ARG B 2 41  ? 247.223 -29.016 262.818 1.0 41.74358  ? 41  ARG B C   41  ARG B C   1 
ATOM 7510  O O   . ARG B 2 41  ? 246.436 -28.646 261.945 1.0 41.74358  ? 41  ARG B O   41  ARG B O   1 
ATOM 7511  C CB  . ARG B 2 41  ? 249.543 -28.396 262.128 1.0 41.74358  ? 41  ARG B CB  41  ARG B CB  1 
ATOM 7512  C CG  . ARG B 2 41  ? 249.781 -27.445 263.255 1.0 41.74358  ? 41  ARG B CG  41  ARG B CG  1 
ATOM 7513  C CD  . ARG B 2 41  ? 250.546 -28.114 264.364 1.0 41.74358  ? 41  ARG B CD  41  ARG B CD  1 
ATOM 7514  N NE  . ARG B 2 41  ? 250.750 -27.185 265.463 1.0 41.74358  ? 41  ARG B NE  41  ARG B NE  1 
ATOM 7515  C CZ  . ARG B 2 41  ? 251.231 -27.530 266.648 1.0 41.74358  ? 41  ARG B CZ  41  ARG B CZ  1 
ATOM 7516  N NH1 . ARG B 2 41  ? 251.564 -28.789 266.888 1.0 41.74358  ? 41  ARG B NH1 41  ARG B NH1 1 
ATOM 7517  N NH2 . ARG B 2 41  ? 251.377 -26.613 267.593 1.0 41.74358  ? 41  ARG B NH2 41  ARG B NH2 1 
ATOM 7518  N N   . ASP B 2 42  ? 246.938 -28.981 264.116 1.0 43.97274  ? 42  ASP B N   42  ASP B N   1 
ATOM 7519  C CA  . ASP B 2 42  ? 245.664 -28.522 264.648 1.0 43.97274  ? 42  ASP B CA  42  ASP B CA  1 
ATOM 7520  C C   . ASP B 2 42  ? 245.919 -27.288 265.503 1.0 43.97274  ? 42  ASP B C   42  ASP B C   1 
ATOM 7521  O O   . ASP B 2 42  ? 246.642 -27.382 266.509 1.0 43.97274  ? 42  ASP B O   42  ASP B O   1 
ATOM 7522  C CB  . ASP B 2 42  ? 245.015 -29.637 265.473 1.0 43.97274  ? 42  ASP B CB  42  ASP B CB  1 
ATOM 7523  C CG  . ASP B 2 42  ? 243.557 -29.378 265.780 1.0 43.97274  ? 42  ASP B CG  42  ASP B CG  1 
ATOM 7524  O OD1 . ASP B 2 42  ? 243.024 -28.342 265.351 1.0 43.97274  ? 42  ASP B OD1 42  ASP B OD1 1 
ATOM 7525  O OD2 . ASP B 2 42  ? 242.936 -30.218 266.462 1.0 43.97274  ? 42  ASP B OD2 42  ASP B OD2 1 
ATOM 7526  N N   . PRO B 2 43  ? 245.379 -26.123 265.155 1.0 42.32605  ? 43  PRO B N   43  PRO B N   1 
ATOM 7527  C CA  . PRO B 2 43  ? 245.646 -24.917 265.944 1.0 42.32605  ? 43  PRO B CA  43  PRO B CA  1 
ATOM 7528  C C   . PRO B 2 43  ? 244.881 -24.923 267.256 1.0 42.32605  ? 43  PRO B C   43  PRO B C   1 
ATOM 7529  O O   . PRO B 2 43  ? 243.921 -25.667 267.454 1.0 42.32605  ? 43  PRO B O   43  PRO B O   1 
ATOM 7530  C CB  . PRO B 2 43  ? 245.168 -23.788 265.033 1.0 42.32605  ? 43  PRO B CB  43  PRO B CB  1 
ATOM 7531  C CG  . PRO B 2 43  ? 244.128 -24.415 264.199 1.0 42.32605  ? 43  PRO B CG  43  PRO B CG  1 
ATOM 7532  C CD  . PRO B 2 43  ? 244.579 -25.822 263.959 1.0 42.32605  ? 43  PRO B CD  43  PRO B CD  1 
ATOM 7533  N N   . TYR B 2 44  ? 245.331 -24.062 268.167 1.0 43.25352  ? 44  TYR B N   44  TYR B N   1 
ATOM 7534  C CA  . TYR B 2 44  ? 244.738 -23.955 269.497 1.0 43.25352  ? 44  TYR B CA  44  TYR B CA  1 
ATOM 7535  C C   . TYR B 2 44  ? 244.987 -22.529 269.975 1.0 43.25352  ? 44  TYR B C   44  TYR B C   1 
ATOM 7536  O O   . TYR B 2 44  ? 246.063 -22.232 270.496 1.0 43.25352  ? 44  TYR B O   44  TYR B O   1 
ATOM 7537  C CB  . TYR B 2 44  ? 245.348 -24.985 270.435 1.0 43.25352  ? 44  TYR B CB  44  TYR B CB  1 
ATOM 7538  C CG  . TYR B 2 44  ? 244.786 -24.998 271.834 1.0 43.25352  ? 44  TYR B CG  44  TYR B CG  1 
ATOM 7539  C CD1 . TYR B 2 44  ? 243.522 -25.505 272.090 1.0 43.25352  ? 44  TYR B CD1 44  TYR B CD1 1 
ATOM 7540  C CD2 . TYR B 2 44  ? 245.537 -24.540 272.904 1.0 43.25352  ? 44  TYR B CD2 44  TYR B CD2 1 
ATOM 7541  C CE1 . TYR B 2 44  ? 243.012 -25.530 273.370 1.0 43.25352  ? 44  TYR B CE1 44  TYR B CE1 1 
ATOM 7542  C CE2 . TYR B 2 44  ? 245.038 -24.564 274.187 1.0 43.25352  ? 44  TYR B CE2 44  TYR B CE2 1 
ATOM 7543  C CZ  . TYR B 2 44  ? 243.776 -25.058 274.414 1.0 43.25352  ? 44  TYR B CZ  44  TYR B CZ  1 
ATOM 7544  O OH  . TYR B 2 44  ? 243.277 -25.082 275.694 1.0 43.25352  ? 44  TYR B OH  44  TYR B OH  1 
ATOM 7545  N N   . VAL B 2 45  ? 243.999 -21.661 269.801 1.0 43.22708  ? 45  VAL B N   45  VAL B N   1 
ATOM 7546  C CA  . VAL B 2 45  ? 244.207 -20.229 269.965 1.0 43.22708  ? 45  VAL B CA  45  VAL B CA  1 
ATOM 7547  C C   . VAL B 2 45  ? 243.588 -19.742 271.266 1.0 43.22708  ? 45  VAL B C   45  VAL B C   1 
ATOM 7548  O O   . VAL B 2 45  ? 242.634 -20.322 271.792 1.0 43.22708  ? 45  VAL B O   45  VAL B O   1 
ATOM 7549  C CB  . VAL B 2 45  ? 243.647 -19.450 268.759 1.0 43.22708  ? 45  VAL B CB  45  VAL B CB  1 
ATOM 7550  C CG1 . VAL B 2 45  ? 244.378 -19.851 267.506 1.0 43.22708  ? 45  VAL B CG1 45  VAL B CG1 1 
ATOM 7551  C CG2 . VAL B 2 45  ? 242.168 -19.708 268.598 1.0 43.22708  ? 45  VAL B CG2 45  VAL B CG2 1 
ATOM 7552  N N   . ALA B 2 46  ? 244.159 -18.664 271.795 1.0 45.77135  ? 46  ALA B N   46  ALA B N   1 
ATOM 7553  C CA  . ALA B 2 46  ? 243.604 -17.976 272.944 1.0 45.77135  ? 46  ALA B CA  46  ALA B CA  1 
ATOM 7554  C C   . ALA B 2 46  ? 242.385 -17.168 272.509 1.0 45.77135  ? 46  ALA B C   46  ALA B C   1 
ATOM 7555  O O   . ALA B 2 46  ? 242.195 -16.923 271.317 1.0 45.77135  ? 46  ALA B O   46  ALA B O   1 
ATOM 7556  C CB  . ALA B 2 46  ? 244.663 -17.065 273.562 1.0 45.77135  ? 46  ALA B CB  46  ALA B CB  1 
ATOM 7557  N N   . PRO B 2 47  ? 241.510 -16.771 273.458 1.0 46.23639  ? 47  PRO B N   47  PRO B N   1 
ATOM 7558  C CA  . PRO B 2 47  ? 240.390 -15.894 273.088 1.0 46.23639  ? 47  PRO B CA  47  PRO B CA  1 
ATOM 7559  C C   . PRO B 2 47  ? 240.798 -14.527 272.561 1.0 46.23639  ? 47  PRO B C   47  PRO B C   1 
ATOM 7560  O O   . PRO B 2 47  ? 240.441 -14.182 271.429 1.0 46.23639  ? 47  PRO B O   47  PRO B O   1 
ATOM 7561  C CB  . PRO B 2 47  ? 239.612 -15.762 274.401 1.0 46.23639  ? 47  PRO B CB  47  PRO B CB  1 
ATOM 7562  C CG  . PRO B 2 47  ? 239.895 -17.009 275.111 1.0 46.23639  ? 47  PRO B CG  47  PRO B CG  1 
ATOM 7563  C CD  . PRO B 2 47  ? 241.310 -17.348 274.799 1.0 46.23639  ? 47  PRO B CD  47  PRO B CD  1 
ATOM 7564  N N   . SER B 2 48  ? 241.551 -13.768 273.367 1.0 51.67368  ? 48  SER B N   48  SER B N   1 
ATOM 7565  C CA  . SER B 2 48  ? 241.951 -12.381 273.079 1.0 51.67368  ? 48  SER B CA  48  SER B CA  1 
ATOM 7566  C C   . SER B 2 48  ? 240.752 -11.484 272.774 1.0 51.67368  ? 48  SER B C   48  SER B C   1 
ATOM 7567  O O   . SER B 2 48  ? 240.816 -10.593 271.925 1.0 51.67368  ? 48  SER B O   48  SER B O   1 
ATOM 7568  C CB  . SER B 2 48  ? 242.974 -12.309 271.945 1.0 51.67368  ? 48  SER B CB  48  SER B CB  1 
ATOM 7569  O OG  . SER B 2 48  ? 243.288 -10.964 271.640 1.0 51.67368  ? 48  SER B OG  48  SER B OG  1 
ATOM 7570  N N   . ALA B 2 49  ? 239.644 -11.727 273.471 1.0 54.23199  ? 49  ALA B N   49  ALA B N   1 
ATOM 7571  C CA  . ALA B 2 49  ? 238.438 -10.924 273.294 1.0 54.23199  ? 49  ALA B CA  49  ALA B CA  1 
ATOM 7572  C C   . ALA B 2 49  ? 237.671 -10.958 274.611 1.0 54.23199  ? 49  ALA B C   49  ALA B C   1 
ATOM 7573  O O   . ALA B 2 49  ? 236.908 -11.894 274.861 1.0 54.23199  ? 49  ALA B O   49  ALA B O   1 
ATOM 7574  C CB  . ALA B 2 49  ? 237.592 -11.447 272.142 1.0 54.23199  ? 49  ALA B CB  49  ALA B CB  1 
ATOM 7575  N N   . GLY B 2 50  ? 237.872 -9.939  275.435 1.0 55.89836  ? 50  GLY B N   50  GLY B N   1 
ATOM 7576  C CA  . GLY B 2 50  ? 237.121 -9.832  276.670 1.0 55.89836  ? 50  GLY B CA  50  GLY B CA  1 
ATOM 7577  C C   . GLY B 2 50  ? 237.488 -10.837 277.738 1.0 55.89836  ? 50  GLY B C   50  GLY B C   1 
ATOM 7578  O O   . GLY B 2 50  ? 236.599 -11.353 278.424 1.0 55.89836  ? 50  GLY B O   50  GLY B O   1 
ATOM 7579  N N   . VAL B 2 51  ? 238.773 -11.140 277.893 1.0 55.05442  ? 51  VAL B N   51  VAL B N   1 
ATOM 7580  C CA  . VAL B 2 51  ? 239.224 -11.989 278.987 1.0 55.05442  ? 51  VAL B CA  51  VAL B CA  1 
ATOM 7581  C C   . VAL B 2 51  ? 240.257 -11.318 279.877 1.0 55.05442  ? 51  VAL B C   51  VAL B C   1 
ATOM 7582  O O   . VAL B 2 51  ? 240.412 -11.735 281.035 1.0 55.05442  ? 51  VAL B O   51  VAL B O   1 
ATOM 7583  C CB  . VAL B 2 51  ? 239.770 -13.336 278.469 1.0 55.05442  ? 51  VAL B CB  51  VAL B CB  1 
ATOM 7584  C CG1 . VAL B 2 51  ? 238.662 -14.158 277.852 1.0 55.05442  ? 51  VAL B CG1 51  VAL B CG1 1 
ATOM 7585  C CG2 . VAL B 2 51  ? 240.881 -13.105 277.460 1.0 55.05442  ? 51  VAL B CG2 51  VAL B CG2 1 
ATOM 7586  N N   . THR B 2 52  ? 240.985 -10.312 279.398 1.0 56.9568   ? 52  THR B N   52  THR B N   1 
ATOM 7587  C CA  . THR B 2 52  ? 241.948 -9.610  280.233 1.0 56.9568   ? 52  THR B CA  52  THR B CA  1 
ATOM 7588  C C   . THR B 2 52  ? 241.994 -8.155  279.790 1.0 56.9568   ? 52  THR B C   52  THR B C   1 
ATOM 7589  O O   . THR B 2 52  ? 242.032 -7.871  278.591 1.0 56.9568   ? 52  THR B O   52  THR B O   1 
ATOM 7590  C CB  . THR B 2 52  ? 243.345 -10.241 280.159 1.0 56.9568   ? 52  THR B CB  52  THR B CB  1 
ATOM 7591  O OG1 . THR B 2 52  ? 243.259 -11.640 280.447 1.0 56.9568   ? 52  THR B OG1 52  THR B OG1 1 
ATOM 7592  C CG2 . THR B 2 52  ? 244.253 -9.617  281.203 1.0 56.9568   ? 52  THR B CG2 52  THR B CG2 1 
ATOM 7593  N N   . THR B 2 53  ? 241.990 -7.243  280.757 1.0 60.89442  ? 53  THR B N   53  THR B N   1 
ATOM 7594  C CA  . THR B 2 53  ? 241.822 -5.826  280.487 1.0 60.89442  ? 53  THR B CA  53  THR B CA  1 
ATOM 7595  C C   . THR B 2 53  ? 243.159 -5.110  280.297 1.0 60.89442  ? 53  THR B C   53  THR B C   1 
ATOM 7596  O O   . THR B 2 53  ? 244.231 -5.626  280.618 1.0 60.89442  ? 53  THR B O   53  THR B O   1 
ATOM 7597  C CB  . THR B 2 53  ? 241.042 -5.167  281.619 1.0 60.89442  ? 53  THR B CB  53  THR B CB  1 
ATOM 7598  O OG1 . THR B 2 53  ? 240.770 -3.804  281.276 1.0 60.89442  ? 53  THR B OG1 53  THR B OG1 1 
ATOM 7599  C CG2 . THR B 2 53  ? 241.844 -5.212  282.903 1.0 60.89442  ? 53  THR B CG2 53  THR B CG2 1 
ATOM 7600  N N   . ASP B 2 54  ? 243.070 -3.894  279.751 1.0 64.83305  ? 54  ASP B N   54  ASP B N   1 
ATOM 7601  C CA  . ASP B 2 54  ? 244.203 -2.981  279.668 1.0 64.83305  ? 54  ASP B CA  54  ASP B CA  1 
ATOM 7602  C C   . ASP B 2 54  ? 244.443 -2.257  280.987 1.0 64.83305  ? 54  ASP B C   54  ASP B C   1 
ATOM 7603  O O   . ASP B 2 54  ? 245.565 -1.809  281.242 1.0 64.83305  ? 54  ASP B O   54  ASP B O   1 
ATOM 7604  C CB  . ASP B 2 54  ? 243.954 -1.947  278.560 1.0 64.83305  ? 54  ASP B CB  54  ASP B CB  1 
ATOM 7605  C CG  . ASP B 2 54  ? 245.224 -1.223  278.108 1.0 64.83305  ? 54  ASP B CG  54  ASP B CG  1 
ATOM 7606  O OD1 . ASP B 2 54  ? 246.337 -1.610  278.515 1.0 64.83305  ? 54  ASP B OD1 54  ASP B OD1 1 
ATOM 7607  O OD2 . ASP B 2 54  ? 245.105 -0.235  277.358 1.0 64.83305  ? 54  ASP B OD2 54  ASP B OD2 1 
ATOM 7608  N N   . ARG B 2 55  ? 243.415 -2.155  281.825 1.0 62.85319  ? 55  ARG B N   55  ARG B N   1 
ATOM 7609  C CA  . ARG B 2 55  ? 243.459 -1.317  283.015 1.0 62.85319  ? 55  ARG B CA  55  ARG B CA  1 
ATOM 7610  C C   . ARG B 2 55  ? 244.425 -1.894  284.040 1.0 62.85319  ? 55  ARG B C   55  ARG B C   1 
ATOM 7611  O O   . ARG B 2 55  ? 244.446 -3.101  284.287 1.0 62.85319  ? 55  ARG B O   55  ARG B O   1 
ATOM 7612  C CB  . ARG B 2 55  ? 242.057 -1.185  283.621 1.0 62.85319  ? 55  ARG B CB  55  ARG B CB  1 
ATOM 7613  C CG  . ARG B 2 55  ? 241.149 -0.105  283.000 1.0 62.85319  ? 55  ARG B CG  55  ARG B CG  1 
ATOM 7614  C CD  . ARG B 2 55  ? 240.615 -0.486  281.620 1.0 62.85319  ? 55  ARG B CD  55  ARG B CD  1 
ATOM 7615  N NE  . ARG B 2 55  ? 239.719 0.519   281.061 1.0 62.85319  ? 55  ARG B NE  55  ARG B NE  1 
ATOM 7616  C CZ  . ARG B 2 55  ? 238.395 0.485   281.169 1.0 62.85319  ? 55  ARG B CZ  55  ARG B CZ  1 
ATOM 7617  N NH1 . ARG B 2 55  ? 237.802 -0.517  281.797 1.0 62.85319  ? 55  ARG B NH1 55  ARG B NH1 1 
ATOM 7618  N NH2 . ARG B 2 55  ? 237.660 1.446   280.633 1.0 62.85319  ? 55  ARG B NH2 55  ARG B NH2 1 
ATOM 7619  N N   . SER B 2 56  ? 245.236 -1.023  284.629 1.0 60.9471   ? 56  SER B N   56  SER B N   1 
ATOM 7620  C CA  . SER B 2 56  ? 246.355 -1.456  285.453 1.0 60.9471   ? 56  SER B CA  56  SER B CA  1 
ATOM 7621  C C   . SER B 2 56  ? 245.865 -1.885  286.829 1.0 60.9471   ? 56  SER B C   56  SER B C   1 
ATOM 7622  O O   . SER B 2 56  ? 245.235 -1.098  287.540 1.0 60.9471   ? 56  SER B O   56  SER B O   1 
ATOM 7623  C CB  . SER B 2 56  ? 247.372 -0.329  285.584 1.0 60.9471   ? 56  SER B CB  56  SER B CB  1 
ATOM 7624  O OG  . SER B 2 56  ? 246.837 0.735   286.347 1.0 60.9471   ? 56  SER B OG  56  SER B OG  1 
ATOM 7625  N N   . GLN B 2 57  ? 246.163 -3.124  287.205 1.0 58.7063   ? 57  GLN B N   57  GLN B N   1 
ATOM 7626  C CA  . GLN B 2 57  ? 245.898 -3.606  288.553 1.0 58.7063   ? 57  GLN B CA  57  GLN B CA  1 
ATOM 7627  C C   . GLN B 2 57  ? 246.875 -4.731  288.851 1.0 58.7063   ? 57  GLN B C   57  GLN B C   1 
ATOM 7628  O O   . GLN B 2 57  ? 247.561 -5.232  287.959 1.0 58.7063   ? 57  GLN B O   57  GLN B O   1 
ATOM 7629  C CB  . GLN B 2 57  ? 244.452 -4.070  288.717 1.0 58.7063   ? 57  GLN B CB  57  GLN B CB  1 
ATOM 7630  C CG  . GLN B 2 57  ? 244.087 -5.269  287.881 1.0 58.7063   ? 57  GLN B CG  57  GLN B CG  1 
ATOM 7631  C CD  . GLN B 2 57  ? 242.637 -5.646  288.047 1.0 58.7063   ? 57  GLN B CD  57  GLN B CD  1 
ATOM 7632  O OE1 . GLN B 2 57  ? 241.916 -5.040  288.836 1.0 58.7063   ? 57  GLN B OE1 57  GLN B OE1 1 
ATOM 7633  N NE2 . GLN B 2 57  ? 242.198 -6.647  287.304 1.0 58.7063   ? 57  GLN B NE2 57  GLN B NE2 1 
ATOM 7634  N N   . LYS B 2 58  ? 246.925 -5.128  290.117 1.0 55.57972  ? 58  LYS B N   58  LYS B N   1 
ATOM 7635  C CA  . LYS B 2 58  ? 247.936 -6.066  290.574 1.0 55.57972  ? 58  LYS B CA  58  LYS B CA  1 
ATOM 7636  C C   . LYS B 2 58  ? 247.426 -7.496  290.521 1.0 55.57972  ? 58  LYS B C   58  LYS B C   1 
ATOM 7637  O O   . LYS B 2 58  ? 246.241 -7.763  290.726 1.0 55.57972  ? 58  LYS B O   58  LYS B O   1 
ATOM 7638  C CB  . LYS B 2 58  ? 248.383 -5.724  291.993 1.0 55.57972  ? 58  LYS B CB  58  LYS B CB  1 
ATOM 7639  C CG  . LYS B 2 58  ? 249.106 -4.395  292.090 1.0 55.57972  ? 58  LYS B CG  58  LYS B CG  1 
ATOM 7640  C CD  . LYS B 2 58  ? 249.534 -4.094  293.502 1.0 55.57972  ? 58  LYS B CD  58  LYS B CD  1 
ATOM 7641  C CE  . LYS B 2 58  ? 250.683 -4.987  293.909 1.0 55.57972  ? 58  LYS B CE  58  LYS B CE  1 
ATOM 7642  N NZ  . LYS B 2 58  ? 251.909 -4.661  293.135 1.0 55.57972  ? 58  LYS B NZ  58  LYS B NZ  1 
ATOM 7643  N N   . LEU B 2 59  ? 248.342 -8.421  290.236 1.0 54.89614  ? 59  LEU B N   59  LEU B N   1 
ATOM 7644  C CA  . LEU B 2 59  ? 247.998 -9.837  290.249 1.0 54.89614  ? 59  LEU B CA  59  LEU B CA  1 
ATOM 7645  C C   . LEU B 2 59  ? 247.954 -10.364 291.676 1.0 54.89614  ? 59  LEU B C   59  LEU B C   1 
ATOM 7646  O O   . LEU B 2 59  ? 246.904 -10.798 292.154 1.0 54.89614  ? 59  LEU B O   59  LEU B O   1 
ATOM 7647  C CB  . LEU B 2 59  ? 248.997 -10.633 289.411 1.0 54.89614  ? 59  LEU B CB  59  LEU B CB  1 
ATOM 7648  C CG  . LEU B 2 59  ? 249.031 -10.312 287.920 1.0 54.89614  ? 59  LEU B CG  59  LEU B CG  1 
ATOM 7649  C CD1 . LEU B 2 59  ? 250.120 -11.113 287.231 1.0 54.89614  ? 59  LEU B CD1 59  LEU B CD1 1 
ATOM 7650  C CD2 . LEU B 2 59  ? 247.684 -10.573 287.284 1.0 54.89614  ? 59  LEU B CD2 59  LEU B CD2 1 
ATOM 7651  N N   . GLN B 2 60  ? 249.082 -10.319 292.376 1.0 55.3101   ? 60  GLN B N   60  GLN B N   1 
ATOM 7652  C CA  . GLN B 2 60  ? 249.132 -10.627 293.796 1.0 55.3101   ? 60  GLN B CA  60  GLN B CA  1 
ATOM 7653  C C   . GLN B 2 60  ? 249.129 -9.339  294.602 1.0 55.3101   ? 60  GLN B C   60  GLN B C   1 
ATOM 7654  O O   . GLN B 2 60  ? 249.649 -8.312  294.163 1.0 55.3101   ? 60  GLN B O   60  GLN B O   1 
ATOM 7655  C CB  . GLN B 2 60  ? 250.366 -11.452 294.144 1.0 55.3101   ? 60  GLN B CB  60  GLN B CB  1 
ATOM 7656  C CG  . GLN B 2 60  ? 250.314 -12.857 293.624 1.0 55.3101   ? 60  GLN B CG  60  GLN B CG  1 
ATOM 7657  C CD  . GLN B 2 60  ? 251.540 -13.646 293.995 1.0 55.3101   ? 60  GLN B CD  60  GLN B CD  1 
ATOM 7658  O OE1 . GLN B 2 60  ? 252.478 -13.111 294.579 1.0 55.3101   ? 60  GLN B OE1 60  GLN B OE1 1 
ATOM 7659  N NE2 . GLN B 2 60  ? 251.538 -14.930 293.668 1.0 55.3101   ? 60  GLN B NE2 60  GLN B NE2 1 
ATOM 7660  N N   . LEU B 2 61  ? 248.547 -9.402  295.796 1.0 53.57671  ? 61  LEU B N   61  LEU B N   1 
ATOM 7661  C CA  . LEU B 2 61  ? 248.209 -8.192  296.541 1.0 53.57671  ? 61  LEU B CA  61  LEU B CA  1 
ATOM 7662  C C   . LEU B 2 61  ? 248.543 -8.408  298.013 1.0 53.57671  ? 61  LEU B C   61  LEU B C   1 
ATOM 7663  O O   . LEU B 2 61  ? 247.799 -9.077  298.734 1.0 53.57671  ? 61  LEU B O   61  LEU B O   1 
ATOM 7664  C CB  . LEU B 2 61  ? 246.738 -7.847  296.328 1.0 53.57671  ? 61  LEU B CB  61  LEU B CB  1 
ATOM 7665  C CG  . LEU B 2 61  ? 246.148 -6.471  296.651 1.0 53.57671  ? 61  LEU B CG  61  LEU B CG  1 
ATOM 7666  C CD1 . LEU B 2 61  ? 245.768 -6.289  298.111 1.0 53.57671  ? 61  LEU B CD1 61  LEU B CD1 1 
ATOM 7667  C CD2 . LEU B 2 61  ? 247.126 -5.395  296.218 1.0 53.57671  ? 61  LEU B CD2 61  LEU B CD2 1 
ATOM 7668  N N   . ARG B 2 62  ? 249.660 -7.835  298.447 1.0 56.45385  ? 62  ARG B N   62  ARG B N   1 
ATOM 7669  C CA  . ARG B 2 62  ? 250.016 -7.816  299.858 1.0 56.45385  ? 62  ARG B CA  62  ARG B CA  1 
ATOM 7670  C C   . ARG B 2 62  ? 249.059 -6.913  300.625 1.0 56.45385  ? 62  ARG B C   62  ARG B C   1 
ATOM 7671  O O   . ARG B 2 62  ? 248.628 -5.874  300.121 1.0 56.45385  ? 62  ARG B O   62  ARG B O   1 
ATOM 7672  C CB  . ARG B 2 62  ? 251.460 -7.319  300.012 1.0 56.45385  ? 62  ARG B CB  62  ARG B CB  1 
ATOM 7673  C CG  . ARG B 2 62  ? 252.107 -7.409  301.402 1.0 56.45385  ? 62  ARG B CG  62  ARG B CG  1 
ATOM 7674  C CD  . ARG B 2 62  ? 251.927 -6.165  302.260 1.0 56.45385  ? 62  ARG B CD  62  ARG B CD  1 
ATOM 7675  N NE  . ARG B 2 62  ? 252.362 -4.953  301.580 1.0 56.45385  ? 62  ARG B NE  62  ARG B NE  1 
ATOM 7676  C CZ  . ARG B 2 62  ? 253.612 -4.510  301.583 1.0 56.45385  ? 62  ARG B CZ  62  ARG B CZ  1 
ATOM 7677  N NH1 . ARG B 2 62  ? 254.545 -5.178  302.245 1.0 56.45385  ? 62  ARG B NH1 62  ARG B NH1 1 
ATOM 7678  N NH2 . ARG B 2 62  ? 253.924 -3.398  300.937 1.0 56.45385  ? 62  ARG B NH2 62  ARG B NH2 1 
ATOM 7679  N N   . VAL B 2 63  ? 248.734 -7.304  301.859 1.0 54.27046  ? 63  VAL B N   63  VAL B N   1 
ATOM 7680  C CA  . VAL B 2 63  ? 248.137 -6.394  302.827 1.0 54.27046  ? 63  VAL B CA  63  VAL B CA  1 
ATOM 7681  C C   . VAL B 2 63  ? 248.906 -6.505  304.136 1.0 54.27046  ? 63  VAL B C   63  VAL B C   1 
ATOM 7682  O O   . VAL B 2 63  ? 249.492 -7.540  304.460 1.0 54.27046  ? 63  VAL B O   63  VAL B O   1 
ATOM 7683  C CB  . VAL B 2 63  ? 246.630 -6.643  303.078 1.0 54.27046  ? 63  VAL B CB  63  VAL B CB  1 
ATOM 7684  C CG1 . VAL B 2 63  ? 245.809 -6.365  301.843 1.0 54.27046  ? 63  VAL B CG1 63  VAL B CG1 1 
ATOM 7685  C CG2 . VAL B 2 63  ? 246.394 -8.038  303.529 1.0 54.27046  ? 63  VAL B CG2 63  VAL B CG2 1 
ATOM 7686  N N   . VAL B 2 64  ? 248.907 -5.408  304.884 1.0 57.01264  ? 64  VAL B N   64  VAL B N   1 
ATOM 7687  C CA  . VAL B 2 64  ? 249.552 -5.334  306.190 1.0 57.01264  ? 64  VAL B CA  64  VAL B CA  1 
ATOM 7688  C C   . VAL B 2 64  ? 248.453 -5.425  307.244 1.0 57.01264  ? 64  VAL B C   64  VAL B C   1 
ATOM 7689  O O   . VAL B 2 64  ? 247.297 -5.094  306.943 1.0 57.01264  ? 64  VAL B O   64  VAL B O   1 
ATOM 7690  C CB  . VAL B 2 64  ? 250.384 -4.047  306.313 1.0 57.01264  ? 64  VAL B CB  64  VAL B CB  1 
ATOM 7691  C CG1 . VAL B 2 64  ? 251.519 -4.069  305.318 1.0 57.01264  ? 64  VAL B CG1 64  VAL B CG1 1 
ATOM 7692  C CG2 . VAL B 2 64  ? 249.515 -2.822  306.084 1.0 57.01264  ? 64  VAL B CG2 64  VAL B CG2 1 
ATOM 7693  N N   . PRO B 2 65  ? 248.729 -5.893  308.460 1.0 59.85643  ? 65  PRO B N   65  PRO B N   1 
ATOM 7694  C CA  . PRO B 2 65  ? 247.664 -5.963  309.462 1.0 59.85643  ? 65  PRO B CA  65  PRO B CA  1 
ATOM 7695  C C   . PRO B 2 65  ? 247.326 -4.589  310.008 1.0 59.85643  ? 65  PRO B C   65  PRO B C   1 
ATOM 7696  O O   . PRO B 2 65  ? 248.181 -3.707  310.111 1.0 59.85643  ? 65  PRO B O   65  PRO B O   1 
ATOM 7697  C CB  . PRO B 2 65  ? 248.257 -6.863  310.548 1.0 59.85643  ? 65  PRO B CB  65  PRO B CB  1 
ATOM 7698  C CG  . PRO B 2 65  ? 249.703 -6.677  310.424 1.0 59.85643  ? 65  PRO B CG  65  PRO B CG  1 
ATOM 7699  C CD  . PRO B 2 65  ? 249.979 -6.484  308.966 1.0 59.85643  ? 65  PRO B CD  65  PRO B CD  1 
ATOM 7700  N N   . ILE B 2 66  ? 246.049 -4.411  310.348 1.0 65.31039  ? 66  ILE B N   66  ILE B N   1 
ATOM 7701  C CA  . ILE B 2 66  ? 245.585 -3.127  310.866 1.0 65.31039  ? 66  ILE B CA  66  ILE B CA  1 
ATOM 7702  C C   . ILE B 2 66  ? 246.130 -2.895  312.268 1.0 65.31039  ? 66  ILE B C   66  ILE B C   1 
ATOM 7703  O O   . ILE B 2 66  ? 246.874 -1.939  312.513 1.0 65.31039  ? 66  ILE B O   66  ILE B O   1 
ATOM 7704  C CB  . ILE B 2 66  ? 244.050 -3.056  310.841 1.0 65.31039  ? 66  ILE B CB  66  ILE B CB  1 
ATOM 7705  C CG1 . ILE B 2 66  ? 243.543 -3.217  309.413 1.0 65.31039  ? 66  ILE B CG1 66  ILE B CG1 1 
ATOM 7706  C CG2 . ILE B 2 66  ? 243.572 -1.742  311.418 1.0 65.31039  ? 66  ILE B CG2 66  ILE B CG2 1 
ATOM 7707  C CD1 . ILE B 2 66  ? 244.029 -2.146  308.475 1.0 65.31039  ? 66  ILE B CD1 66  ILE B CD1 1 
ATOM 7708  N N   . GLN B 2 67  ? 245.777 -3.769  313.205 1.0 70.82852  ? 67  GLN B N   67  GLN B N   1 
ATOM 7709  C CA  . GLN B 2 67  ? 246.354 -3.712  314.538 1.0 70.82852  ? 67  GLN B CA  67  GLN B CA  1 
ATOM 7710  C C   . GLN B 2 67  ? 246.420 -5.117  315.115 1.0 70.82852  ? 67  GLN B C   67  GLN B C   1 
ATOM 7711  O O   . GLN B 2 67  ? 245.493 -5.912  314.951 1.0 70.82852  ? 67  GLN B O   67  GLN B O   1 
ATOM 7712  C CB  . GLN B 2 67  ? 245.579 -2.746  315.449 1.0 70.82852  ? 67  GLN B CB  67  GLN B CB  1 
ATOM 7713  C CG  . GLN B 2 67  ? 244.093 -3.009  315.659 1.0 70.82852  ? 67  GLN B CG  67  GLN B CG  1 
ATOM 7714  C CD  . GLN B 2 67  ? 243.806 -3.897  316.853 1.0 70.82852  ? 67  GLN B CD  67  GLN B CD  1 
ATOM 7715  O OE1 . GLN B 2 67  ? 244.628 -4.022  317.761 1.0 70.82852  ? 67  GLN B OE1 67  GLN B OE1 1 
ATOM 7716  N NE2 . GLN B 2 67  ? 242.608 -4.466  316.887 1.0 70.82852  ? 67  GLN B NE2 67  GLN B NE2 1 
ATOM 7717  N N   . THR B 2 68  ? 247.537 -5.412  315.773 1.0 72.67943  ? 68  THR B N   68  THR B N   1 
ATOM 7718  C CA  . THR B 2 68  ? 247.864 -6.746  316.249 1.0 72.67943  ? 68  THR B CA  68  THR B CA  1 
ATOM 7719  C C   . THR B 2 68  ? 247.905 -6.764  317.768 1.0 72.67943  ? 68  THR B C   68  THR B C   1 
ATOM 7720  O O   . THR B 2 68  ? 248.080 -5.722  318.407 1.0 72.67943  ? 68  THR B O   68  THR B O   1 
ATOM 7721  C CB  . THR B 2 68  ? 249.214 -7.204  315.697 1.0 72.67943  ? 68  THR B CB  68  THR B CB  1 
ATOM 7722  O OG1 . THR B 2 68  ? 250.241 -6.324  316.167 1.0 72.67943  ? 68  THR B OG1 68  THR B OG1 1 
ATOM 7723  C CG2 . THR B 2 68  ? 249.197 -7.178  314.184 1.0 72.67943  ? 68  THR B CG2 68  THR B CG2 1 
ATOM 7724  N N   . GLU B 2 69  ? 247.742 -7.952  318.341 1.0 77.49103  ? 69  GLU B N   69  GLU B N   1 
ATOM 7725  C CA  . GLU B 2 69  ? 247.811 -8.154  319.779 1.0 77.49103  ? 69  GLU B CA  69  GLU B CA  1 
ATOM 7726  C C   . GLU B 2 69  ? 248.688 -9.359  320.075 1.0 77.49103  ? 69  GLU B C   69  GLU B C   1 
ATOM 7727  O O   . GLU B 2 69  ? 248.584 -10.391 319.407 1.0 77.49103  ? 69  GLU B O   69  GLU B O   1 
ATOM 7728  C CB  . GLU B 2 69  ? 246.421 -8.365  320.374 1.0 77.49103  ? 69  GLU B CB  69  GLU B CB  1 
ATOM 7729  C CG  . GLU B 2 69  ? 246.391 -8.481  321.881 1.0 77.49103  ? 69  GLU B CG  69  GLU B CG  1 
ATOM 7730  C CD  . GLU B 2 69  ? 244.993 -8.680  322.414 1.0 77.49103  ? 69  GLU B CD  69  GLU B CD  1 
ATOM 7731  O OE1 . GLU B 2 69  ? 244.051 -8.757  321.598 1.0 77.49103  ? 69  GLU B OE1 69  GLU B OE1 1 
ATOM 7732  O OE2 . GLU B 2 69  ? 244.837 -8.761  323.650 1.0 77.49103  ? 69  GLU B OE2 69  GLU B OE2 1 
ATOM 7733  N N   . ASP B 2 70  ? 249.551 -9.229  321.077 1.0 75.2464   ? 70  ASP B N   70  ASP B N   1 
ATOM 7734  C CA  . ASP B 2 70  ? 250.432 -10.310 321.492 1.0 75.2464   ? 70  ASP B CA  70  ASP B CA  1 
ATOM 7735  C C   . ASP B 2 70  ? 250.043 -10.731 322.900 1.0 75.2464   ? 70  ASP B C   70  ASP B C   1 
ATOM 7736  O O   . ASP B 2 70  ? 250.027 -9.903  323.817 1.0 75.2464   ? 70  ASP B O   70  ASP B O   1 
ATOM 7737  C CB  . ASP B 2 70  ? 251.896 -9.875  321.445 1.0 75.2464   ? 70  ASP B CB  70  ASP B CB  1 
ATOM 7738  C CG  . ASP B 2 70  ? 252.858 -11.048 321.500 1.0 75.2464   ? 70  ASP B CG  70  ASP B CG  1 
ATOM 7739  O OD1 . ASP B 2 70  ? 252.397 -12.208 321.533 1.0 75.2464   ? 70  ASP B OD1 70  ASP B OD1 1 
ATOM 7740  O OD2 . ASP B 2 70  ? 254.084 -10.808 321.516 1.0 75.2464   ? 70  ASP B OD2 70  ASP B OD2 1 
ATOM 7741  N N   . ASN B 2 71  ? 249.725 -12.006 323.066 1.0 74.67396  ? 71  ASN B N   71  ASN B N   1 
ATOM 7742  C CA  . ASN B 2 71  ? 249.477 -12.600 324.369 1.0 74.67396  ? 71  ASN B CA  71  ASN B CA  1 
ATOM 7743  C C   . ASN B 2 71  ? 250.546 -13.663 324.614 1.0 74.67396  ? 71  ASN B C   71  ASN B C   1 
ATOM 7744  O O   . ASN B 2 71  ? 251.347 -13.977 323.730 1.0 74.67396  ? 71  ASN B O   71  ASN B O   1 
ATOM 7745  C CB  . ASN B 2 71  ? 248.056 -13.173 324.437 1.0 74.67396  ? 71  ASN B CB  71  ASN B CB  1 
ATOM 7746  C CG  . ASN B 2 71  ? 247.586 -13.420 325.862 1.0 74.67396  ? 71  ASN B CG  71  ASN B CG  1 
ATOM 7747  O OD1 . ASN B 2 71  ? 248.336 -13.214 326.814 1.0 74.67396  ? 71  ASN B OD1 71  ASN B OD1 1 
ATOM 7748  N ND2 . ASN B 2 71  ? 246.344 -13.856 326.014 1.0 74.67396  ? 71  ASN B ND2 71  ASN B ND2 1 
ATOM 7749  N N   . VAL B 2 72  ? 250.578 -14.193 325.838 1.0 74.24522  ? 72  VAL B N   72  VAL B N   1 
ATOM 7750  C CA  . VAL B 2 72  ? 251.454 -15.315 326.147 1.0 74.24522  ? 72  VAL B CA  72  VAL B CA  1 
ATOM 7751  C C   . VAL B 2 72  ? 251.032 -16.549 325.358 1.0 74.24522  ? 72  VAL B C   72  VAL B C   1 
ATOM 7752  O O   . VAL B 2 72  ? 251.878 -17.327 324.902 1.0 74.24522  ? 72  VAL B O   72  VAL B O   1 
ATOM 7753  C CB  . VAL B 2 72  ? 251.442 -15.571 327.667 1.0 74.24522  ? 72  VAL B CB  72  VAL B CB  1 
ATOM 7754  C CG1 . VAL B 2 72  ? 252.374 -16.718 328.048 1.0 74.24522  ? 72  VAL B CG1 72  VAL B CG1 1 
ATOM 7755  C CG2 . VAL B 2 72  ? 251.804 -14.301 328.422 1.0 74.24522  ? 72  VAL B CG2 72  VAL B CG2 1 
ATOM 7756  N N   . ASN B 2 73  ? 249.732 -16.718 325.134 1.0 74.35063  ? 73  ASN B N   73  ASN B N   1 
ATOM 7757  C CA  . ASN B 2 73  ? 249.215 -17.902 324.465 1.0 74.35063  ? 73  ASN B CA  73  ASN B CA  1 
ATOM 7758  C C   . ASN B 2 73  ? 249.044 -17.740 322.963 1.0 74.35063  ? 73  ASN B C   73  ASN B C   1 
ATOM 7759  O O   . ASN B 2 73  ? 249.263 -18.706 322.227 1.0 74.35063  ? 73  ASN B O   73  ASN B O   1 
ATOM 7760  C CB  . ASN B 2 73  ? 247.870 -18.301 325.075 1.0 74.35063  ? 73  ASN B CB  73  ASN B CB  1 
ATOM 7761  C CG  . ASN B 2 73  ? 248.008 -18.813 326.486 1.0 74.35063  ? 73  ASN B CG  73  ASN B CG  1 
ATOM 7762  O OD1 . ASN B 2 73  ? 248.942 -19.548 326.802 1.0 74.35063  ? 73  ASN B OD1 73  ASN B OD1 1 
ATOM 7763  N ND2 . ASN B 2 73  ? 247.077 -18.430 327.348 1.0 74.35063  ? 73  ASN B ND2 73  ASN B ND2 1 
ATOM 7764  N N   . TYR B 2 74  ? 248.657 -16.562 322.476 1.0 70.30179  ? 74  TYR B N   74  TYR B N   1 
ATOM 7765  C CA  . TYR B 2 74  ? 248.329 -16.408 321.066 1.0 70.30179  ? 74  TYR B CA  74  TYR B CA  1 
ATOM 7766  C C   . TYR B 2 74  ? 248.893 -15.101 320.527 1.0 70.30179  ? 74  TYR B C   74  TYR B C   1 
ATOM 7767  O O   . TYR B 2 74  ? 249.492 -14.306 321.255 1.0 70.30179  ? 74  TYR B O   74  TYR B O   1 
ATOM 7768  C CB  . TYR B 2 74  ? 246.814 -16.491 320.837 1.0 70.30179  ? 74  TYR B CB  74  TYR B CB  1 
ATOM 7769  C CG  . TYR B 2 74  ? 245.972 -15.412 321.482 1.0 70.30179  ? 74  TYR B CG  74  TYR B CG  1 
ATOM 7770  C CD1 . TYR B 2 74  ? 245.456 -15.579 322.758 1.0 70.30179  ? 74  TYR B CD1 74  TYR B CD1 1 
ATOM 7771  C CD2 . TYR B 2 74  ? 245.653 -14.248 320.796 1.0 70.30179  ? 74  TYR B CD2 74  TYR B CD2 1 
ATOM 7772  C CE1 . TYR B 2 74  ? 244.672 -14.607 323.340 1.0 70.30179  ? 74  TYR B CE1 74  TYR B CE1 1 
ATOM 7773  C CE2 . TYR B 2 74  ? 244.878 -13.269 321.373 1.0 70.30179  ? 74  TYR B CE2 74  TYR B CE2 1 
ATOM 7774  C CZ  . TYR B 2 74  ? 244.390 -13.454 322.644 1.0 70.30