import java.io
import java.util
import org.cogroo.text
import typing



class TreeElement:
    def __init__(self): ...
    def getFeatureTag(self) -> str: ...
    def getLevel(self) -> int: ...
    def getMorphologicalTag(self) -> str: ...
    def getParent(self) -> 'TreeElement': ...
    def getSyntacticTag(self) -> str: ...
    def setFeatureTag(self, string: str) -> None: ...
    def setLevel(self, int: int) -> None: ...
    def setMorphologicalTag(self, string: str) -> None: ...
    def setParent(self, treeElement: 'TreeElement') -> None: ...
    def setSyntacticTag(self, string: str) -> None: ...
    def toSyntaxTree(self) -> str: ...
    def toTreebank(self) -> str: ...

class TreeUtil:
    def __init__(self): ...
    @staticmethod
    def createLeafsList(sentence: org.cogroo.text.Sentence) -> java.util.List[TreeElement]: ...
    @staticmethod
    def createTree(sentence: org.cogroo.text.Sentence) -> 'Node': ...

class Leaf(TreeElement):
    def __init__(self, string: str, stringArray: typing.List[str]): ...
    def getLemma(self) -> typing.List[str]: ...
    def getLexeme(self) -> str: ...
    def setLemma(self, stringArray: typing.List[str]) -> None: ...
    def setLexeme(self, string: str) -> None: ...
    def toString(self) -> str: ...
    def toSyntaxTree(self) -> str: ...
    def toTreebank(self) -> str: ...

class Node(TreeElement, java.io.Serializable):
    def __init__(self): ...
    def addElement(self, treeElement: TreeElement) -> None: ...
    def getElements(self) -> typing.List[TreeElement]: ...
    def getElems(self) -> java.util.List[TreeElement]: ...
    def toString(self) -> str: ...
    def toSyntaxTree(self) -> str: ...
    def toTreebank(self) -> str: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("org.cogroo.text.tree")``.

    Leaf: typing.Type[Leaf]
    Node: typing.Type[Node]
    TreeElement: typing.Type[TreeElement]
    TreeUtil: typing.Type[TreeUtil]
