/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.util;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.Span;
import org.cogroo.text.Token;
import org.cogroo.text.impl.TokenImpl;

public class EntityUtils {
    public static List<Token> groupTokensChar(String text, List<Token> toks, List<Span> charSpans, String additionalContext) {
        if (charSpans == null || charSpans.size() == 0) {
            return toks;
        }
        int lastVisitedTok = 0;
        ArrayList<Span> spans = new ArrayList<Span>(charSpans.size());
        for (Span ch : charSpans) {
            Token aToken = toks.get(lastVisitedTok);
            while (aToken.getStart() < ch.getStart()) {
                aToken = toks.get(++lastVisitedTok);
            }
            int start = lastVisitedTok;
            while (aToken.getEnd() < ch.getEnd()) {
                aToken = toks.get(++lastVisitedTok);
            }
            int end = lastVisitedTok + 1;
            Span tokSpan = new Span(start, end);
            spans.add(tokSpan);
        }
        return EntityUtils.groupTokens(text, toks, spans, additionalContext);
    }

    public static List<Token> groupTokens(String text, List<Token> toks, List<? extends Span> spans) {
        return EntityUtils.groupTokens(text, toks, spans, null);
    }

    public static List<Token> groupTokens(String text, List<Token> toks, List<? extends Span> spans, String additionalContext) {
        for (int i = spans.size() - 1; i >= 0; --i) {
            Span span = spans.get(i);
            if (span.length() <= 0) continue;
            int s = toks.get(span.getStart()).getStart();
            int e = toks.get(span.getEnd() - 1).getEnd();
            String lexeme = text.substring(s, e).replace(" ", "_");
            ArrayList<Token> removeToks = new ArrayList<Token>();
            for (int j = span.getEnd() - 1; j >= span.getStart(); --j) {
                removeToks.add(toks.remove(j));
            }
            TokenImpl t = new TokenImpl(s, e, lexeme);
            t.setPOSTag(span.getType());
            toks.add(span.getStart(), t);
        }
        return toks;
    }
}

