/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.postag;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import opennlp.tools.postag.TagDictionary;
import opennlp.tools.util.SequenceValidator;
import org.cogroo.tools.postag.GenderUtil;

public class PortuguesePOSSequenceValidator
implements SequenceValidator<String> {
    private boolean storeUnknown = false;
    public TagDictionary tagDictionary;
    private SortedSet<String> unknown;

    public PortuguesePOSSequenceValidator(TagDictionary tagDictionary) {
        if (this.storeUnknown) {
            this.unknown = new TreeSet<String>();
        }
        this.tagDictionary = tagDictionary;
    }

    public boolean validSequence(int i, String[] inputSequence, String[] outcomesSequence, String outcome) {
        List<String> tagList;
        boolean isValid = false;
        boolean tokExists = false;
        String word = inputSequence[i];
        if (i > 0 && "nm".equals(outcome) && "a".equalsIgnoreCase(inputSequence[i - 1]) && "artf".equals(outcomesSequence[i - 1])) {
            return false;
        }
        outcome = GenderUtil.removeGender(outcome);
        if (PortuguesePOSSequenceValidator.isPunctuation(word)) {
            return outcome.equals(word);
        }
        if (i < inputSequence.length - 1 && PortuguesePOSSequenceValidator.isPunctuation(inputSequence[i + 1]) && outcome.startsWith("B-")) {
            return false;
        }
        if (!PortuguesePOSSequenceValidator.validOutcome(outcome, outcomesSequence)) {
            return false;
        }
        if (this.tagDictionary == null) {
            return true;
        }
        if ((outcome.startsWith("B-") || outcome.startsWith("I-")) && inputSequence.length > 1) {
            return true;
        }
        if (word.equals(outcome)) {
            isValid = true;
        }
        if ((tagList = this.filterMWE(this.queryDictionary(word, true))) != null && tagList.size() > 0) {
            tokExists = true;
            if ("prop".equals(outcome) && Character.isUpperCase(word.charAt(0))) {
                return true;
            }
            if (this.contains(tagList, outcome)) {
                isValid = true;
            }
        }
        if (!tokExists) {
            if (this.storeUnknown) {
                this.unknown.add(word);
            }
            isValid = true;
        }
        return isValid;
    }

    private List<String> filterMWE(String[] arr) {
        if (arr == null) {
            return null;
        }
        ArrayList<String> out = new ArrayList<String>(arr.length);
        for (String t : arr) {
            if (t.startsWith("B-") || t.startsWith("I-")) continue;
            out.add(t);
        }
        return out;
    }

    private String[] queryDictionary(String word, boolean recurse) {
        String[] tags = this.tagDictionary.getTags(word);
        if (tags == null) {
            tags = this.tagDictionary.getTags(word.toLowerCase());
        }
        if (recurse && word.startsWith("-") && word.length() > 1) {
            tags = this.queryDictionary(word.substring(1), false);
        }
        return GenderUtil.removeGender(tags);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.storeUnknown) {
            System.out.println("... palavras desconhecidas ...");
            for (String unk : this.unknown) {
                System.out.println(unk);
            }
            System.out.println("... fim ...");
        }
    }

    static boolean validOutcome(String outcome, String[] sequence) {
        String prevOutcome = null;
        if (sequence.length > 0) {
            prevOutcome = sequence[sequence.length - 1];
        }
        return PortuguesePOSSequenceValidator.validOutcome(outcome, prevOutcome);
    }

    static boolean validOutcome(String outcome, String prevOutcome) {
        boolean prevIsBoundary = false;
        boolean prevIsIntermediate = false;
        boolean isBoundary = false;
        boolean isIntermediate = false;
        if (prevOutcome != null) {
            prevIsBoundary = prevOutcome.startsWith("B-");
            prevIsIntermediate = prevOutcome.startsWith("I-");
        }
        if (outcome != null) {
            isBoundary = outcome.startsWith("B-");
            isIntermediate = outcome.startsWith("I-");
        }
        boolean isSameEntity = false;
        if ((prevIsBoundary || prevIsIntermediate) && isIntermediate) {
            isSameEntity = prevOutcome.substring(2).equals(outcome.substring(2));
        }
        if (isIntermediate) {
            if (prevOutcome == null) {
                return false;
            }
            if (!isSameEntity) {
                return false;
            }
        } else if (isBoundary && prevIsBoundary) {
            return false;
        }
        return !prevIsBoundary || isIntermediate;
    }

    private static boolean isPunctuation(String word) {
        return word.matches("^[\\.,;:()?-]$");
    }

    private boolean contains(List<String> tagList, String outcome) {
        if (tagList.contains(outcome)) {
            return true;
        }
        if (outcome.equals("n-adj")) {
            if (tagList.contains("n") || tagList.contains("adj")) {
                return true;
            }
        } else if (outcome.equals("n") || outcome.equals("adj")) {
            if (tagList.contains("n-adj")) {
                return true;
            }
        } else if (outcome.contains("=")) {
            String outcomeClass = outcome.substring(0, outcome.indexOf(61));
            for (String tag : tagList) {
                String[] tagParts;
                if (!tag.startsWith(outcomeClass) || !tag.contains("/") && !outcome.contains("/")) continue;
                String[] outcomeParts = outcome.split("=");
                if (outcomeParts.length != (tagParts = tag.split("=")).length) {
                    return false;
                }
                for (int i = 0; i < outcomeParts.length; ++i) {
                    String outcomePart = outcomeParts[i];
                    String tagPart = tagParts[i];
                    if (outcomePart.contains("/") || tagPart.contains("/") || outcomePart.equals(tagPart)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

