/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.postag;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.DictionaryFeatureGenerator;
import opennlp.tools.util.featuregen.WindowFeatureGenerator;
import org.cogroo.dictionary.FeatureDictionary;
import org.cogroo.dictionary.impl.FSADictionary;
import org.cogroo.dictionary.impl.FSAFeatureDictionary;
import org.cogroo.tools.postag.PortuguesePOSContextGenerator;
import org.cogroo.util.PairWordPOSTag;

public class PortugueseExtPOSContextGenerator
extends PortuguesePOSContextGenerator {
    private FSADictionary trans;
    private FeatureDictionary feat;
    private WindowFeatureGenerator dfg;

    public PortugueseExtPOSContextGenerator(Dictionary dict) {
        this(0, dict);
    }

    public PortugueseExtPOSContextGenerator(int cacheSize, Dictionary dict) {
        super(cacheSize, dict);
        try {
            this.trans = FSADictionary.createFromResources("/fsa_dictionaries/pos/pt_br_trans.dict");
            this.feat = FSAFeatureDictionary.createFromResources("/fsa_dictionaries/featurizer/pt_br_feats.dict");
            this.dfg = new WindowFeatureGenerator((AdaptiveFeatureGenerator)new DictionaryFeatureGenerator("loc_prep=", new Dictionary(this.getClass().getResourceAsStream("/dictionaries/pt_br/locucoes_prepositivas.xml"))), 2, 2);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void getContext(int index, String[] sequence, String[] priorDecisions, Object[] additionalContext, List<String> modContext) {
        super.getContext(index, sequence, priorDecisions, additionalContext, modContext);
        if (index > 0) {
            this.addTransitivity("prev_", sequence[index - 1], modContext);
        }
        this.addTransitivity("", sequence[index], modContext);
        if (index < sequence.length - 1) {
            this.addTransitivity("nxt_", sequence[index + 1], modContext);
        }
        if ("a".equals(sequence[index].toLowerCase())) {
            String next;
            if (index > 0 && this.isVerbTag(priorDecisions[index - 1])) {
                modContext.add("spec_a=v+a");
                this.addVerbTransitivityAndLemma("spec_a", sequence[index - 1], modContext);
            } else if (index > 1 && this.isVerbTag(priorDecisions[index - 2])) {
                this.addVerbTransitivityAndLemma2("spec_pa", sequence[index - 2], priorDecisions[index - 1], modContext);
            }
            if (index < sequence.length - 1 && (next = sequence[index + 1]).length() > 2) {
                if (this.matchFeature(next, "n", "F")) {
                    modContext.add("spec_af");
                    if (index > 0) {
                        modContext.add("spec_af|" + priorDecisions[index - 1]);
                    }
                } else if (this.matchFeature(next, "n", "M")) {
                    modContext.add("spec_am");
                    if (index > 0) {
                        modContext.add("spec_am|" + priorDecisions[index - 1]);
                    }
                }
            }
        }
        if ("que".equals(sequence[index].toLowerCase()) && index < sequence.length - 1) {
            boolean nextIsVerb = false;
            boolean prevIsVerb = false;
            boolean prevprevIsVerb = false;
            nextIsVerb = this.isCanBeAVerb(sequence[index + 1]);
            if (index > 0) {
                modContext.add("spec_que_prev=" + priorDecisions[index - 1]);
                prevIsVerb = this.isCanBeAVerb(sequence[index - 1]);
                if (index > 1) {
                    modContext.add("spec_que_pprev=" + priorDecisions[index - 2]);
                    prevprevIsVerb = this.isCanBeAVerb(sequence[index - 2]);
                }
            }
            if (nextIsVerb) {
                modContext.add("spec_que=nv");
            }
            if (prevIsVerb) {
                modContext.add("spec_que=pv");
                modContext.add("spec_que_pv=" + priorDecisions[index - 1]);
            }
            if (prevprevIsVerb) {
                modContext.add("spec_que=ppv");
                modContext.add("spec_que_ppv=" + priorDecisions[index - 2]);
            }
        }
    }

    private boolean matchFeature(String next, String tag, String feature) {
        String[] features = this.feat.getFeatures(next, null);
        if (features == null) {
            features = this.feat.getFeatures(next.toLowerCase(), null);
        }
        if (features != null) {
            for (String f : features) {
                if (!f.contains(feature)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCanBeAVerb(String candidate) {
        return this.trans.getTags(candidate) != null;
    }

    private void addVerbTransitivityAndLemma2(String prefix, String ppVerb, String prevTag, List<String> modContext) {
        List<PairWordPOSTag> tagsAndLemmas = this.trans.getTagsAndLemms(ppVerb);
        if (tagsAndLemmas != null && tagsAndLemmas.size() > 0) {
            for (PairWordPOSTag pairWordPOSTag : tagsAndLemmas) {
                modContext.add(prefix + "_lm=" + prevTag + "|" + pairWordPOSTag.getWord());
                modContext.add(prefix + "_tr=" + prevTag + "|" + pairWordPOSTag.getPosTag());
                modContext.add(prefix + "_lmtr=" + prevTag + "|" + pairWordPOSTag.getWord() + "|" + pairWordPOSTag.getPosTag());
            }
        }
    }

    private void addVerbTransitivityAndLemma(String prefix, String verb, List<String> modContext) {
        List<PairWordPOSTag> tagsAndLemmas = this.trans.getTagsAndLemms(verb);
        if (tagsAndLemmas != null && tagsAndLemmas.size() > 0) {
            for (PairWordPOSTag pairWordPOSTag : tagsAndLemmas) {
                modContext.add(prefix + "_lm=" + pairWordPOSTag.getWord());
                modContext.add(prefix + "_tr=" + pairWordPOSTag.getPosTag());
                modContext.add(prefix + "_lmtr=" + pairWordPOSTag.getWord() + "|" + pairWordPOSTag.getPosTag());
            }
        }
    }

    private boolean isVerbTag(String string) {
        return string.startsWith("v-");
    }

    private void addTransitivity(String prefix, String tok, List<String> modContext) {
        String[] tags;
        if (this.trans != null && (tags = this.trans.getTags(tok)) != null) {
            if (tags.length > 1) {
                HashSet<String> trans = new HashSet<String>(Arrays.asList(tags));
                for (String t : trans) {
                    modContext.add(prefix + "trans=" + t);
                }
            } else {
                modContext.add(prefix + "trans=" + tags[0]);
            }
        }
    }
}

