/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.featurizer;

import java.io.IOException;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.CrossValidationPartitioner;
import opennlp.tools.util.eval.Mean;
import org.cogroo.dictionary.FeatureDictionary;
import org.cogroo.tools.featurizer.FeatureSample;
import org.cogroo.tools.featurizer.FeaturizerEvaluationMonitor;
import org.cogroo.tools.featurizer.FeaturizerEvaluator;
import org.cogroo.tools.featurizer.FeaturizerFactory;
import org.cogroo.tools.featurizer.FeaturizerME;
import org.cogroo.tools.featurizer.FeaturizerModel;

public class FeaturizerCrossValidator {
    private final String languageCode;
    private final TrainingParameters params;
    private Mean wordAccuracy = new Mean();
    private FeaturizerEvaluationMonitor[] listeners;
    private FeatureDictionary posDict;
    private String factoryClassName;
    private FeaturizerFactory factory;
    private String cgFlags;

    public FeaturizerCrossValidator(String languageCode, TrainingParameters params, FeatureDictionary dict, String cgFlags, String factoryClass, FeaturizerEvaluationMonitor ... listeners) {
        this.cgFlags = cgFlags;
        this.languageCode = languageCode;
        this.params = params;
        this.listeners = listeners;
        this.posDict = dict;
        this.factoryClassName = factoryClass;
    }

    public void evaluate(ObjectStream<FeatureSample> samples, int nFolds) throws IOException, InvalidFormatException, IOException {
        CrossValidationPartitioner<FeatureSample> partitioner = new CrossValidationPartitioner<FeatureSample>(samples, nFolds);
        while (partitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<FeatureSample> trainingSampleStream = partitioner.next();
            if (this.factory == null) {
                this.factory = FeaturizerFactory.create(this.factoryClassName, this.posDict, this.cgFlags);
            }
            FeaturizerModel model = FeaturizerME.train(this.languageCode, trainingSampleStream, this.params, this.factory);
            FeaturizerEvaluator evaluator = new FeaturizerEvaluator(new FeaturizerME(model), this.listeners);
            evaluator.evaluate(trainingSampleStream.getTestSampleStream());
            this.wordAccuracy.add(evaluator.getWordAccuracy(), evaluator.getWordCount());
        }
    }

    public double getWordAccuracy() {
        return this.wordAccuracy.mean();
    }

    public long getWordCount() {
        return this.wordAccuracy.count();
    }
}

