/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.checkers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.cogroo.entities.Mistake;
import org.cogroo.entities.Sentence;
import org.cogroo.entities.Token;
import org.cogroo.tools.checker.AbstractTypedChecker;
import org.cogroo.tools.checker.JavaRuleDefinition;
import org.cogroo.tools.checker.rules.model.Example;
import org.cogroo.tools.checker.rules.model.TagMask;

public class RepetitionChecker
extends AbstractTypedChecker {
    private static final String ID_PREFIX = "repetition:";
    static final String ID = "repetition:DUPLICATED_TOKEN";
    static final String CATEGORY = "Erros mec\u00e2nicos";
    static final String GROUP = "Repeti\u00e7\u00e3o de palavras";
    static final String DESCRIPTION = "Procura por palavras consecutivas repetidas.";
    static final String MESSAGE = "Verifique a repeti\u00e7\u00e3o de palavras.";
    static final String SHORT = "Repeti\u00e7\u00e3o de palavras.";

    public RepetitionChecker() {
        ArrayList<Example> examples = new ArrayList<Example>();
        examples.add(RepetitionChecker.createExample("Ele ele foi ao mercado.", "Ele foi ao mercado."));
        JavaRuleDefinition repetition = new JavaRuleDefinition(ID, CATEGORY, GROUP, DESCRIPTION, MESSAGE, SHORT, examples);
        this.add(repetition);
    }

    @Override
    public String getIdPrefix() {
        return ID_PREFIX;
    }

    @Override
    public List<Mistake> check(Sentence sentence) {
        LinkedList<Mistake> mistakes = new LinkedList<Mistake>();
        int offset = sentence.getSpan().getStart();
        List<Token> tokens = sentence.getTokens();
        String token = tokens.get(0).getLexeme().toLowerCase();
        for (int i = 1; i < tokens.size(); ++i) {
            String next = tokens.get(i).getLexeme().toLowerCase();
            if (token.equals(next) && !this.isException(tokens, i)) {
                int start = tokens.get(i - 1).getSpan().getStart() + offset;
                int end = tokens.get(i).getSpan().getEnd() + offset;
                mistakes.add(this.createMistake(ID, this.createSuggestion(tokens.get(i - 1).getLexeme()), start, end, sentence.getSentence()));
            }
            token = next;
        }
        return mistakes;
    }

    private boolean isException(List<Token> tokens, int i) {
        int startSecond;
        String word = tokens.get(i).getLexeme().toLowerCase();
        TagMask.Class first = tokens.get(i - 1).getMorphologicalTag().getClazzE();
        TagMask.Class second = tokens.get(i).getMorphologicalTag().getClazzE();
        int startFirst = tokens.get(i - 1).getSpan().getStart();
        if (startFirst == (startSecond = tokens.get(i).getSpan().getStart())) {
            return true;
        }
        if (word.equals("se")) {
            return first.equals((Object)TagMask.Class.SUBORDINATING_CONJUNCTION) && second.equals((Object)TagMask.Class.PERSONAL_PRONOUN);
        }
        if (word.equals("a")) {
            return first.equals((Object)TagMask.Class.PREPOSITION) && second.equals((Object)TagMask.Class.ARTICLE);
        }
        return word.equals("1");
    }

    private String[] createSuggestion(String error) {
        String[] array = new String[]{error};
        return array;
    }

    @Override
    public int getPriority() {
        return 190;
    }
}

