/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.gc.cmdline;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.TypedCmdLineTool;
import org.cogroo.gc.cmdline.grammarchecker.ExamplesTool;
import org.cogroo.gc.cmdline.grammarchecker.GrammarCheckerTool;
import org.cogroo.gc.cmdline.grammarchecker.TextAnalyzerTool;
import org.cogroo.gc.cmdline.grammarchecker.XMLRulesReportTool;

public final class EndUserCLI {
    public static final String CMD = "cogroo";
    private static Map<String, CmdLineTool> toolLookupMap = new LinkedHashMap<String, CmdLineTool>();

    public static Set<String> getToolNames() {
        return toolLookupMap.keySet();
    }

    private static void usage() {
        System.out.print("CoGrOO Grammar Checker. ");
        System.out.println("Usage: cogroo TOOL");
        System.out.println("where TOOL is one of:");
        int numberOfSpaces = -1;
        for (String toolName : toolLookupMap.keySet()) {
            if (toolName.length() <= numberOfSpaces) continue;
            numberOfSpaces = toolName.length();
        }
        numberOfSpaces += 4;
        for (CmdLineTool tool : toolLookupMap.values()) {
            System.out.print("  " + tool.getName());
            for (int i = 0; i < Math.abs(tool.getName().length() - numberOfSpaces); ++i) {
                System.out.print(" ");
            }
            System.out.println(tool.getShortDescription());
        }
        System.out.println("All tools print help when invoked with help parameter");
        System.out.println("Example: cogroo GrammarChecker help");
    }

    public static void main(String[] args) {
        block13: {
            if (args.length == 0) {
                EndUserCLI.usage();
                System.exit(0);
            }
            String[] toolArguments = new String[args.length - 1];
            System.arraycopy(args, 1, toolArguments, 0, toolArguments.length);
            String toolName = args[0];
            String formatName = "opennlp";
            int idx = toolName.indexOf(".");
            if (-1 < idx) {
                formatName = toolName.substring(idx + 1);
                toolName = toolName.substring(0, idx);
            }
            CmdLineTool tool = toolLookupMap.get(toolName);
            try {
                if (null == tool) {
                    throw new TerminateToolException(1, "Tool " + toolName + " is not found.");
                }
                if (0 == toolArguments.length || 0 < toolArguments.length && "help".equals(toolArguments[0])) {
                    if (tool instanceof TypedCmdLineTool) {
                        System.out.println(((TypedCmdLineTool)tool).getHelp(formatName));
                    } else if (tool instanceof BasicCmdLineTool) {
                        System.out.println(tool.getHelp());
                    }
                    System.exit(0);
                }
                if (tool instanceof TypedCmdLineTool) {
                    ((TypedCmdLineTool)tool).run(formatName, toolArguments);
                    break block13;
                }
                if (tool instanceof BasicCmdLineTool) {
                    if (-1 == idx) {
                        ((BasicCmdLineTool)tool).run(toolArguments);
                        break block13;
                    }
                    throw new TerminateToolException(1, "Tool " + toolName + " does not support formats.");
                }
                throw new TerminateToolException(1, "Tool " + toolName + " is not supported.");
            }
            catch (TerminateToolException e) {
                if (e.getMessage() != null) {
                    System.err.println(e.getMessage());
                }
                System.exit(e.getCode());
            }
        }
    }

    static {
        LinkedList<BasicCmdLineTool> tools = new LinkedList<BasicCmdLineTool>();
        tools.add(new GrammarCheckerTool());
        tools.add(new ExamplesTool());
        tools.add(new XMLRulesReportTool());
        tools.add(new TextAnalyzerTool());
        for (CmdLineTool cmdLineTool : tools) {
            toolLookupMap.put(cmdLineTool.getName(), cmdLineTool);
        }
        toolLookupMap = Collections.unmodifiableMap(toolLookupMap);
    }
}

