/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import morfologik.tools.SharedOptions;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;

abstract class Tool {
    protected final Options options = new Options();

    Tool() {
    }

    protected final void go(String[] args) {
        this.options.addOption(SharedOptions.help);
        this.initializeOptions(this.options);
        for (String arg : args) {
            if (!"--help".equals(arg)) continue;
            this.printUsage();
            System.exit(0);
        }
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(this.options, args);
            if (line.hasOption(SharedOptions.help.getLongOpt())) {
                this.printUsage();
                return;
            }
            if (line.getArgList().size() > 0) {
                this.printError("Unreconized left over command line arguments: " + line.getArgList());
                return;
            }
            try {
                this.go(line);
            }
            catch (Throwable e) {
                this.printError("Unhandled program error occurred.", e);
            }
        }
        catch (MissingArgumentException e) {
            this.printError("Provide the required argument for option: " + e.getMessage());
        }
        catch (MissingOptionException e) {
            this.printError("Provide the required option: " + e.getMessage());
        }
        catch (UnrecognizedOptionException e) {
            this.printError(e.getMessage());
        }
        catch (ParseException e) {
            this.printError("Could not parse command line: " + e.getMessage());
        }
    }

    protected void printError(String msg, Throwable t) {
        this.printError(msg);
        t.printStackTrace(System.err);
    }

    protected void printError(String msg) {
        System.err.println();
        System.err.println(msg);
        System.err.println("Invoke with '--help' for help.");
    }

    protected void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.getClass().getName(), this.options, true);
    }

    protected abstract void go(CommandLine var1) throws Exception;

    protected abstract void initializeOptions(Options var1);

    protected boolean isAvailable() {
        return true;
    }
}

