/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.util;

import java.util.LinkedList;
import java.util.List;

public class ToStringHelper {
    private final String className;
    private final List<ValueHolder> valueHolders = new LinkedList<ValueHolder>();
    private boolean omitNullValues = false;

    private ToStringHelper(String className) {
        this.className = ToStringHelper.checkNotNull(className);
    }

    public ToStringHelper add(String name, Object value) {
        ToStringHelper.checkNotNull(name);
        this.addHolder((Object)value).builder.append(name).append('=').append(value);
        return this;
    }

    public ToStringHelper add(String name, boolean value) {
        this.checkNameAndAppend(name).append(value);
        return this;
    }

    public ToStringHelper add(String name, char value) {
        this.checkNameAndAppend(name).append(value);
        return this;
    }

    public ToStringHelper add(String name, double value) {
        this.checkNameAndAppend(name).append(value);
        return this;
    }

    public ToStringHelper add(String name, float value) {
        this.checkNameAndAppend(name).append(value);
        return this;
    }

    public ToStringHelper add(String name, int value) {
        this.checkNameAndAppend(name).append(value);
        return this;
    }

    public ToStringHelper add(String name, long value) {
        this.checkNameAndAppend(name).append(value);
        return this;
    }

    private StringBuilder checkNameAndAppend(String name) {
        ToStringHelper.checkNotNull(name);
        return this.addHolder().builder.append(name).append('=');
    }

    public ToStringHelper addValue(Object value) {
        this.addHolder((Object)value).builder.append(value);
        return this;
    }

    public ToStringHelper addValue(boolean value) {
        this.addHolder().builder.append(value);
        return this;
    }

    public ToStringHelper addValue(char value) {
        this.addHolder().builder.append(value);
        return this;
    }

    public ToStringHelper addValue(double value) {
        this.addHolder().builder.append(value);
        return this;
    }

    public ToStringHelper addValue(float value) {
        this.addHolder().builder.append(value);
        return this;
    }

    public ToStringHelper addValue(int value) {
        this.addHolder().builder.append(value);
        return this;
    }

    public ToStringHelper addValue(long value) {
        this.addHolder().builder.append(value);
        return this;
    }

    public String toString() {
        boolean omitNullValuesSnapshot = this.omitNullValues;
        boolean needsSeparator = false;
        StringBuilder builder = new StringBuilder(32).append(this.className).append('{');
        for (ValueHolder valueHolder : this.valueHolders) {
            if (omitNullValuesSnapshot && valueHolder.isNull) continue;
            if (needsSeparator) {
                builder.append(", ");
            } else {
                needsSeparator = true;
            }
            StringBuilder sequence = valueHolder.builder;
            builder.append((CharSequence)sequence);
        }
        return builder.append('}').toString();
    }

    private ValueHolder addHolder() {
        ValueHolder valueHolder = new ValueHolder();
        this.valueHolders.add(valueHolder);
        return valueHolder;
    }

    private ValueHolder addHolder(Object value) {
        ValueHolder valueHolder = this.addHolder();
        valueHolder.isNull = value == null;
        return valueHolder;
    }

    public static ToStringHelper toStringHelper(Object self) {
        return new ToStringHelper(ToStringHelper.simpleName(self.getClass()));
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(ToStringHelper.simpleName(clazz));
    }

    public static ToStringHelper toStringHelper(String className) {
        return new ToStringHelper(className);
    }

    private static String simpleName(Class<?> clazz) {
        String name = clazz.getName();
        int start = (name = name.replaceAll("\\$[0-9]+", "\\$")).lastIndexOf(36);
        if (start == -1) {
            start = name.lastIndexOf(46);
        }
        return name.substring(start + 1);
    }

    public static <T> T firstNonNull(T first, T second) {
        return first != null ? first : ToStringHelper.checkNotNull(second);
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    private static final class ValueHolder {
        final StringBuilder builder = new StringBuilder();
        boolean isNull;

        private ValueHolder() {
        }
    }
}

