/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.rules.applier;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import org.apache.log4j.Logger;
import org.cogroo.tools.checker.rules.applier.RulesTrees;
import org.cogroo.tools.checker.rules.applier.RulesTreesAccess;
import org.cogroo.tools.checker.rules.util.RulesTreesSerializer;

public class RulesTreesSerializedAccess
implements RulesTreesAccess {
    private static final Logger LOGGER = Logger.getLogger(RulesTreesSerializedAccess.class);
    private RulesTrees rulesTrees;
    private String serializedRulesFile;

    public RulesTreesSerializedAccess(String serializedRulesFile) {
        this.serializedRulesFile = serializedRulesFile;
    }

    @Override
    public void persist(RulesTrees newRulesTrees) {
        if (newRulesTrees == null) {
            throw new IllegalArgumentException();
        }
        long start = System.nanoTime();
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.serializedRulesFile));
            out.writeObject(newRulesTrees);
            LOGGER.info("Rules trees serialized in " + (System.nanoTime() - start) / 1000000L + "ms");
        }
        catch (IOException e) {
            LOGGER.warn("Could not serialize rules trees");
        }
    }

    @Override
    public RulesTrees getTrees() {
        if (this.rulesTrees == null) {
            LOGGER.info("Reading from serialized rules trees");
            long start = System.nanoTime();
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.serializedRulesFile));
                this.rulesTrees = (RulesTrees)in.readObject();
                LOGGER.info("Rules trees read in " + (System.nanoTime() - start) / 1000000L + "ms");
            }
            catch (StreamCorruptedException e) {
                LOGGER.info("Failed to read rules. Will create it from scratch");
                RulesTreesSerializer.serialize();
                try {
                    ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.serializedRulesFile));
                    this.rulesTrees = (RulesTrees)in.readObject();
                    LOGGER.info("Rules trees read in " + (System.nanoTime() - start) / 1000000L + "ms");
                }
                catch (Exception exception) {}
            }
            catch (IOException e) {
                LOGGER.warn("Could not read the serialized rules trees.", e);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Could not read the serialized rules trees.", e);
            }
        }
        return this.rulesTrees;
    }
}

