/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker;

import org.cogroo.entities.impl.MorphologicalTag;
import org.cogroo.tools.checker.rules.model.TagMask;

public class Merger {
    private static TagMask toTagMask(MorphologicalTag tag) {
        TagMask mask = new TagMask();
        if (tag.getClazzE() != null) {
            mask.setClazz(tag.getClazzE());
        }
        if (tag.getGenderE() != null) {
            mask.setGender(tag.getGenderE());
        }
        if (tag.getNumberE() != null) {
            mask.setNumber(tag.getNumberE());
        }
        if (tag.getCase() != null) {
            mask.setCase(tag.getCase());
        }
        if (tag.getPersonE() != null) {
            mask.setPerson(tag.getPersonE());
        }
        if (tag.getTense() != null) {
            mask.setTense(tag.getTense());
        }
        if (tag.getMood() != null) {
            mask.setMood(tag.getMood());
        }
        if (tag.getPunctuation() != null) {
            mask.setPunctuation(tag.getPunctuation());
        }
        return mask;
    }

    public static void generalizePOSTags(MorphologicalTag tag, MorphologicalTag[] allTags) {
        if (allTags == null || allTags.length == 0) {
            if (tag.getGenderE() != null) {
                tag.setGender(TagMask.Gender.NEUTRAL);
            }
            if (tag.getNumberE() != null) {
                tag.setNumber(TagMask.Number.NEUTRAL);
            }
        } else if (allTags != null && allTags.length >= 1 && (tag.getGenderE() != null || tag.getNumberE() != null)) {
            TagMask noGender = Merger.toTagMask(tag);
            noGender.setGender(null);
            TagMask noNumber = Merger.toTagMask(tag);
            noGender.setGender(null);
            boolean is2g = false;
            boolean isSP = false;
            for (MorphologicalTag test : allTags) {
                if (test.match(noGender) && test.getGenderE() != null && !test.getGenderE().equals((Object)tag.getGenderE())) {
                    is2g = true;
                    if (isSP) break;
                }
                if (test.getNumberE() == null || !test.match(noNumber) || test.getNumberE().equals((Object)tag.getNumberE())) continue;
                isSP = true;
                if (is2g) break;
            }
            if (is2g) {
                tag.setGender(TagMask.Gender.NEUTRAL);
            }
            if (isSP) {
                tag.setNumber(TagMask.Number.NEUTRAL);
            }
        }
    }
}

