/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.exceptions;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.cogroo.exceptions.InternationalizedRuntimeException;

public class InternationalizedException
extends Exception {
    private static final long serialVersionUID = 1218000142275850583L;
    private String resourceBundleName;
    private String messageKey;
    private Object[] arguments;
    private Throwable cause;

    public InternationalizedException() {
        this(null, null, null, null);
    }

    public InternationalizedException(Throwable aCause) {
        this(null, null, null, aCause);
    }

    public InternationalizedException(String aResourceBundleName, String aMessageKey, Object[] aArguments) {
        this(aResourceBundleName, aMessageKey, aArguments, null);
    }

    public InternationalizedException(String aResourceBundleName, String aMessageKey, Object[] aArguments, Throwable aCause) {
        this.cause = aCause;
        this.resourceBundleName = aResourceBundleName;
        this.messageKey = aMessageKey;
        this.arguments = aArguments;
        if (this.resourceBundleName == null && this.messageKey == null) {
            if (this.cause instanceof InternationalizedException) {
                this.resourceBundleName = ((InternationalizedException)this.cause).getResourceBundleName();
                this.messageKey = ((InternationalizedException)this.cause).getMessageKey();
                this.arguments = ((InternationalizedException)this.cause).getArguments();
            } else if (this.cause instanceof InternationalizedRuntimeException) {
                this.resourceBundleName = ((InternationalizedRuntimeException)this.cause).getResourceBundleName();
                this.messageKey = ((InternationalizedRuntimeException)this.cause).getMessageKey();
                this.arguments = ((InternationalizedRuntimeException)this.cause).getArguments();
            }
        }
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public Object[] getArguments() {
        if (this.arguments == null) {
            return new Object[0];
        }
        Object[] result = new Object[this.arguments.length];
        System.arraycopy(this.arguments, 0, result, 0, this.arguments.length);
        return result;
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage(Locale.ENGLISH);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    public String getLocalizedMessage(Locale aLocale) {
        if (this.getMessageKey() == null) {
            return null;
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.getResourceBundleName(), aLocale, this.getClass().getClassLoader());
            String message = bundle.getString(this.getMessageKey());
            if (this.getArguments().length > 0) {
                MessageFormat fmt = new MessageFormat(message);
                fmt.setLocale(aLocale);
                return fmt.format(this.getArguments());
            }
            return message;
        }
        catch (Exception e) {
            return "EXCEPTION MESSAGE LOCALIZATION FAILED: " + e.toString();
        }
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public boolean hasMessageKey(String messageKey) {
        if (messageKey.equals(this.getMessageKey())) {
            return true;
        }
        Throwable cause = this.getCause();
        if (cause != null && cause instanceof InternationalizedException) {
            return ((InternationalizedException)cause).hasMessageKey(messageKey);
        }
        return false;
    }

    @Override
    public synchronized Throwable initCause(Throwable aCause) {
        this.cause = aCause;
        return this;
    }
}

