/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.entities.impl;

import java.util.ArrayList;
import java.util.List;
import org.cogroo.entities.Chunk;
import org.cogroo.entities.Token;
import org.cogroo.entities.impl.MorphologicalTag;
import org.cogroo.tools.checker.rules.model.TagMask;

public class ChunkCogroo
extends Chunk {
    private static final long serialVersionUID = -3501790388693489863L;

    private ChunkCogroo(List<Token> tokens) {
        this.tokens = tokens;
        this.morphologicalTag = null;
    }

    public ChunkCogroo(List<Token> tokens, int firstToken) {
        this(tokens);
        this.firstToken = firstToken;
    }

    @Override
    public String toPlainText() {
        StringBuilder chunkAsString = new StringBuilder();
        for (int i = 0; i < this.tokens.size(); ++i) {
            chunkAsString.append(((Token)this.tokens.get(i)).getLexeme());
            if (i + 1 == this.tokens.size()) continue;
            chunkAsString.append(' ');
        }
        return chunkAsString.toString();
    }

    private void processTag() {
        ArrayList<MorphologicalTag> ml = new ArrayList<MorphologicalTag>();
        boolean firstMainFound = false;
        for (int i = 0; i < this.tokens.size(); ++i) {
            Token token = (Token)this.tokens.get(i);
            String chunkTag = token.getChunkTag().toVerboseString();
            if (chunkTag.lastIndexOf("MAIN") != -1) {
                if (!firstMainFound) {
                    firstMainFound = true;
                    this.morphologicalTag = token.getMorphologicalTag();
                }
                if (chunkTag.lastIndexOf("NOUN") == -1) continue;
                ml.add(token.getMorphologicalTag());
                continue;
            }
            if (chunkTag.lastIndexOf("OTHER") == -1) continue;
            return;
        }
        if (ml.size() > 1) {
            this.morphologicalTag = new MorphologicalTag();
            this.morphologicalTag.setClazz(((MorphologicalTag)ml.get(0)).getClazzE());
            this.morphologicalTag.setNumber(TagMask.Number.PLURAL);
            for (MorphologicalTag m : ml) {
                if (m.getGenderE() == null || !m.getGenderE().equals((Object)TagMask.Gender.MALE)) continue;
                this.morphologicalTag.setGender(TagMask.Gender.MALE);
                break;
            }
        } else {
            return;
        }
    }

    @Override
    public void setMorphologicalTag(MorphologicalTag morphologicalTag) {
        this.morphologicalTag = morphologicalTag;
        this.processTag();
    }
}

