/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.entities;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import opennlp.tools.util.Span;
import org.cogroo.entities.Chunk;
import org.cogroo.entities.LexemeTypes;
import org.cogroo.entities.SyntacticChunk;
import org.cogroo.entities.impl.ChunkTag;
import org.cogroo.entities.impl.MorphologicalTag;
import org.cogroo.entities.impl.SyntacticTag;
import org.cogroo.util.ToStringHelper;

public abstract class Token
implements Serializable {
    private static final long serialVersionUID = 5748072170017854287L;
    protected String lexeme;
    protected String[] primitive;
    protected MorphologicalTag morphologicalTag;
    protected ChunkTag chunkTag;
    protected Chunk chunk;
    protected LexemeTypes lexemeType;
    protected Span span;
    private SyntacticChunk syntacticChunk;

    public Token() {
        this.span = new Span(0, 0);
    }

    public Token(Span span) {
        this.span = span;
    }

    public Token(int start, int end) {
        this.span = new Span(start, end);
    }

    public String getLexeme() {
        return this.lexeme;
    }

    public abstract void setLexeme(String var1);

    public String[] getPrimitive() {
        return this.primitive;
    }

    public void setPrimitive(String[] primitive) {
        this.primitive = primitive;
    }

    public MorphologicalTag getMorphologicalTag() {
        return this.morphologicalTag;
    }

    public void setMorphologicalTag(MorphologicalTag tag) {
        this.morphologicalTag = tag;
    }

    public ChunkTag getChunkTag() {
        return this.chunkTag;
    }

    public void setChunkTag(ChunkTag ct) {
        this.chunkTag = ct;
    }

    public void setSpan(Span span) {
        this.span = span;
    }

    public SyntacticTag getSyntacticTag() {
        if (this.getSyntacticChunk() == null) {
            return null;
        }
        return this.getSyntacticChunk().getSyntacticTag();
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    public void setChunk(Chunk chunk) {
        this.chunk = chunk;
    }

    public LexemeTypes getLexemeType() {
        return this.lexemeType;
    }

    public Span getSpan() {
        return this.span;
    }

    public String toString() {
        return ToStringHelper.toStringHelper(this).add("lxm", this.lexeme).add("pr", Arrays.toString(this.primitive)).add("mp", this.morphologicalTag).add("ch", this.chunkTag).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Token) {
            Token that = (Token)obj;
            return Objects.equals(this.lexeme, that.lexeme) && Objects.equals(this.primitive, that.primitive) && Objects.equals(this.morphologicalTag, that.morphologicalTag) && Objects.equals(this.chunkTag, that.chunkTag) && Objects.equals((Object)this.lexemeType, (Object)that.lexemeType) && Objects.equals(this.span, that.span);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lexeme, this.primitive, this.morphologicalTag, this.chunkTag, this.lexemeType, this.span});
    }

    public void setSyntacticChunk(SyntacticChunk syntacticChunk) {
        this.syntacticChunk = syntacticChunk;
    }

    public SyntacticChunk getSyntacticChunk() {
        return this.syntacticChunk;
    }
}

