/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.cmdline.chunker2;

import java.util.Arrays;
import java.util.Random;
import opennlp.tools.util.Span;
import org.cogroo.cmdline.chunker2.DetailedFMeasureForSizeListener;
import org.cogroo.tools.chunker2.ChunkSample;
import org.cogroo.tools.chunker2.ChunkerEvaluationMonitor;
import org.cogroo.tools.chunker2.TokenTag;

public class ChunkerDetailedFMeasureSizeListener
extends DetailedFMeasureForSizeListener<ChunkSample>
implements ChunkerEvaluationMonitor {
    Random randomGenerator = new Random();

    @Override
    protected Span[] asSpanArray(ChunkSample sample) {
        int size = sample.getSentence().length;
        String[] headTags = new String[size];
        String[] chunkTags = new String[size];
        String[] posTags = new String[size];
        String[] lexemes = new String[size];
        TokenTag.extract(TokenTag.create(sample.getSentence(), sample.getTags()), lexemes, posTags, headTags);
        for (int i = 0; i < chunkTags.length; ++i) {
            chunkTags[i] = posTags[i].substring(posTags[i].indexOf(124) + 1);
        }
        Span[] out = this.asHeadSpan(ChunkSample.phrasesAsSpanList(lexemes, posTags, chunkTags), headTags);
        return out;
    }

    private void print(Span[] out, String[] lexemes) {
        Object[] chunks = Span.spansToStrings(out, lexemes);
        for (int i = 0; i < chunks.length; ++i) {
            chunks[i] = out[i].getType() + ": " + (String)chunks[i];
        }
        System.out.println(Arrays.toString(chunks));
    }

    private Span[] asHeadSpan(Span[] chunks, String[] headTags) {
        Span[] out = new Span[chunks.length];
        for (int i = 0; i < chunks.length; ++i) {
            Span c = chunks[i];
            int head = -1;
            for (int j = c.getStart(); j < c.getEnd(); ++j) {
                if (!this.isHead(headTags[j])) continue;
                head = j - c.getStart();
            }
            if (head == -1) {
                head = c.length() == 1 ? 0 : this.randomGenerator.nextInt(100000) + 8;
            }
            out[i] = new Span(c.getStart(), c.getEnd(), Integer.toString(head));
        }
        return out;
    }

    private boolean isHead(String outcome) {
        return !outcome.equals("O");
    }
}

