/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;

public final class PolishStemmer
implements IStemmer,
Iterable<WordData> {
    private final List<DictionaryLookup> delegate = new ArrayList<DictionaryLookup>();

    public PolishStemmer() {
        this(DICTIONARY.MORFOLOGIK);
    }

    public PolishStemmer(DICTIONARY dictionary) {
        switch (dictionary) {
            case MORFOLOGIK: {
                this.delegate.add(new DictionaryLookup(Dictionary.getForLanguage("pl")));
                break;
            }
            case MORFEUSZ: {
                this.delegate.add(new DictionaryLookup(Dictionary.getForLanguage("pl-sgjp")));
                break;
            }
            case COMBINED: {
                this.delegate.add(new DictionaryLookup(Dictionary.getForLanguage("pl")));
                this.delegate.add(new DictionaryLookup(Dictionary.getForLanguage("pl-sgjp")));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    @Override
    public List<WordData> lookup(CharSequence word) {
        DictionaryLookup lookup;
        if (this.delegate.size() == 1) {
            return this.delegate.get(0).lookup(word);
        }
        List<WordData> forms = null;
        Iterator<DictionaryLookup> i$ = this.delegate.iterator();
        while (i$.hasNext() && (forms = (lookup = i$.next()).lookup(word)).size() <= 0) {
        }
        return forms;
    }

    @Override
    public Iterator<WordData> iterator() {
        if (this.delegate.size() == 1) {
            return this.delegate.get(0).iterator();
        }
        throw new RuntimeException("No iteration over compound stemmer forms: " + Arrays.toString(this.delegate.toArray()));
    }

    public static enum DICTIONARY {
        MORFOLOGIK,
        MORFEUSZ,
        COMBINED;

    }
}

