PyCoSim
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Features

- Importing an FMU file, getting information of the model description
  and running a single FMU simulation,
- Importing a system configuration, configuring output logging and
  scenario, running co-simulation and retrieving the results,
- Creating a system configuration, adding fmus, connections, initial
  values

## Install

``` sh
pip install pycosim
```

## How to use

### Creating the simulation instance using the given files

In the case that you already have all the configuration files and fmu
files ready for the simulation, you can just import files to create the
simulation instance. From the simulation instance, use `run_simulation`
method to run simulation. It returns the output instance which contains
logging, error and result. The result is a dict of names of components
as keys and time-series outputs as data.

``` python
import os
from pycosim.osp_command_line import LoggingLevel
from pycosim.simulation import FMU, SimulationConfiguration
import pandas

pandas.options.plotting.backend = "plotly"

path_to_osp_system_strucuture_file = os.path.join("..", "test_data", "OspSystemStructureTest.xml")
path_to_dir = os.path.dirname(path_to_osp_system_strucuture_file)

simulation_config = SimulationConfiguration(
    system_structure=path_to_osp_system_strucuture_file,
    path_to_fmu=path_to_dir
)
```

Note that the path to the directories that contain all the relevant FMUs
should be provided together with the source for the system structure
file. When the system is configured, you can run the simulation for a
given simulation time with default settings:

``` python
simulation_output = simulation_config.run_simulation(
    duration=10,
    logging_level=LoggingLevel.info
)
print(f"Logging: {simulation_output.log}")
print(f"Error: {simulation_output.error}")

for name, output in simulation_output.result.items():
    fig = output.plot(title=name)
    fig.write_image(os.path.join("..", "resources", f"{name}_0.png"))
```

    Logging: Output csv files will be saved in the following directory: C:\Users\keviny\AppData\Local\Temp\pycosim_tmp\sim_0bb5ed62-1e64-45a4-8e23-0f05dcfab787\
    Simulation will run until {10} seconds.
    Running simulation.
    info: Using cache directory: "C:\\Users\\keviny\\AppData\\Local\\cosim"
    info: [FMI Library: FMILIB] Loading 'win64' binary with 'default' platform types
    info: [FMI Library: FMILIB] Loading 'win64' binary with 'default' platform types
    info: [FMI Library: FMILIB] Loading 'win64' binary with 'default' platform types
    info: 10% complete, t=1.000000
    info: 20% complete, t=2.000000
    info: 30% complete, t=3.000000
    info: 40% complete, t=4.000000
    info: 50% complete, t=5.000000
    info: 60% complete, t=6.000000
    info: 70% complete, t=7.000000
    info: 80% complete, t=8.000000
    info: 90% complete, t=9.000000
    info: 100% complete, t=10.000000


    Error: 

![Chassis-Plot](/resources/chassis_0.png)
![Chassis-Plot](/resources/wheel_0.png)
![Chassis-Plot](/resources/ground_0.png)

Default setting for the simulation is: - No scenario - No logging
configuration (All variables will be logged at each time step.) - The
system structure and output files are saved in the same directory as the
temporary one where FMUs are deployed. - Only warning from simulation
setting up and progress messages are logged.

### Scenario configuration

A scenario is a collection of events that override / bias / reset a
variable of components in the target system. A scenario can be created
as follows:

``` python
from pyOSPParser.scenario import OSPScenario, OSPEvent

simulation_end_time = 10
simulation_config.scenario = OSPScenario(name='test_scenario', end=simulation_end_time)

# Adding an event to the scenario
simulation_config.scenario.add_event(OSPEvent(
    time=5,  # Time when the event happens
    model='chassis',  # Name_of_the_component
    variable='C.mChassis', # name_of_the_variable,
    action=OSPEvent.OVERRIDE, # Type of actions among OVERRIDE, BIAS, RESET
    value=19.4 # Value (only for OVERRIDE and BIAS)
))
```

    <pyOSPParser.scenario.OSPEvent at 0x1fe02485c40>

### Logging configuration

A logging configuration specifies which variables will be logged as
output of the simulation. A logging configuration can be defined using
OspLoggingConfiguration class:

``` python
from pyOSPParser.logging_configuration import OspVariableForLogging, OspSimulatorForLogging, OspLoggingConfiguration

# Create a variable object for logging
variables = [OspVariableForLogging(name="zChassis"), OspVariableForLogging(name="p.e")]

# Create a logging configuration of a component
name_of_component = 'chassis'
logging_config_comp = OspSimulatorForLogging(
    name=name_of_component,
    decimation_factor=10, # Relative period of how often the logging is made. 10 means once every ten time steps
    variables=variables
)

# Create a logging configuration instance for the system
simulation_config.logging_config = OspLoggingConfiguration(simulators=[logging_config_comp])
```

You can set the logging level for the messages during setting up and
running a simulation. You can do that by passing the
[`LoggingLevel`](https://kevinksyTRD.github.io/pycosim/osp_command_line_interface.html#logginglevel)
member when running the simulation. If not specified, it will be
‘warning’ by default.

Let’s run the simulation again and see how the new configuration
affected the outputs.

``` python
from pycosim.simulation import LoggingLevel

simulation_output = simulation_config.run_simulation(
    duration=simulation_end_time,
    logging_level=LoggingLevel.warning
)

print(f"Logging: {simulation_output.log}")
print(f"Error: {simulation_output.error}")

for name, output in simulation_output.result.items():
    fig = output.plot(title=name)
    fig.write_image(os.path.join("..", "resources", f"{name}_1.png"))
```

![chassis-plot](/resources/chassis_1.png)
![chassis-plot](/resources/wheel_1.png)
![chassis-plot](/resources/ground_1.png)
