# 概要

文字列をひらがな、片仮名、漢字、数字、アルファベットごとに分割するツールです。
英日両文に適用可能ですが、ピリオドを含む一部の用語は適切に分割できない場合があります。
詳しくは、実行サンプルをご確認ください。


# セットアップ

```
pip install divide-char-type
```


# 使い方

```
from divide_char_type import divide_char_type

data = divide_char_type("今日の天気は晴れです。")

print(data[0])
```


# 戻り値

- 配列型
	- 第0要素：字種分割した全体のリスト
	- 第1要素：字種分割したひらがなのリスト
	- 第2要素：字種分割したカタカナのリスト
	- 第3要素：字種分割した漢字のリスト
	- 第4要素：字種分割したアルファベットのリスト
	- 第5要素：字種分割した数字のリスト
	- 第6要素：字種分割したその他記号などのリスト


# 実行サンプル

```
['1.0', ' ', 'is', ' ', 'number', '.']
['1', ',', '000', ' ', 'is', ' ', 'number', '.']
['u.s.a.', ' ', 'is', ' ', 'state', '.']
['u.k', '.', ' ', 'is', ' ', 'state', '.']
['e.g.', ',', ' ', 'th', ',', ' ', 'ch', ',', ' ', 'sh', ',', ' ', 'ph', ',', ' ', 'gh', ',', ' ', 'ng', ',', ' ', 'qu']
['state', ' ', 'include', ' ', 'u.s.', ' ', 'u.s.', ' ', 'is', ' ', 'state', '.']
['state', ' ', 'include', ' ', 'u.k', '.', ' ', 'u.k', '.', ' ', 'is', ' ', 'state', '.']
['u.s.', 'は', '国', 'です', '。']
['u.s', '.', 'は', '国', 'です', '。']
['あいうえおーかきくけこ']
['アイウエオーカキクケコ']
['今日', 'の', '天気', 'は', '晴', 'れです', '。\n', '明日', 'の', '天気', 'は', '曇', 'りです', '。\n']
['&&&', '1.0', '&&&']
```
