#! usr/bin/python3.6
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject
from pycatia.tps_interfaces.tps_parallel_on_screen import TPSParallelOnScreen


class NonSemanticGDT(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     NonSemanticGDT

    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.non_semantic_gdt = com_object

    def tps_parallel_on_screen(self) -> TPSParallelOnScreen:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func TPSParallelOnScreen() As TPSParallelOnScreen
                | 
                |     Gets the annotation on TPSParallelOnScreen interface.

        :return: TPSParallelOnScreen
        :rtype: TPSParallelOnScreen
        """
        return TPSParallelOnScreen(self.non_semantic_gdt.TPSParallelOnScreen())

    def __repr__(self):
        return f'NonSemanticGdt(name="{self.name}")'
