# Library Version = 16, 0
# Id String = {5AE2215C-270C-470B-A2B6-609A964E53A2}#16.0#0#Win64
# Guid      = {5AE2215C-270C-470B-A2B6-609A964E53A2}
# Lib File  = MWOffice.exe
# 08/09/21 07:49:41

from __future__ import annotations
from enum import Enum
import sys
import win32com.client
awrc = win32com.client.constants

class mwFeatureTypeFlags(Enum):
	"""Constants that define the project features."""
	mwFTF_CircuitSimulator = 1
	mwFTF_NonLinearSimulator = 2
	mwFTF_EMSimulator = 4
	mwFTF_Layout = 8
	mwFTF_SystemSimulator = 16
	mwFTF_AdvancedSystem = 32
	mwFTF_AdvancedMWO = 64
	mwFTF_MMIC = 128
	
	def __int__(self):
		return self.value

class mwShapeToolFlags(Enum):
	"""Constants that define the types of shape tools."""
	mwSTF_Rectangle = 1
	mwSTF_Polygon = 2
	mwSTF_Path = 4
	mwSTF_Ellipse = 8
	mwSTF_Intersect = 16
	mwSTF_Union = 32
	mwSTF_Subtract = 64
	mwSTF_Xor = 128
	mwSTF_Resize = 256
	mwSTF_ResizeCopy = 512
	mwSTF_Ring = 1024
	mwSTF_DrillHole = 2048
	mwSTF_Group = 4096
	mwSTF_UnGroup = 8192
	mwSTF_ArrayCopy = 16384
	mwSTF_StretchArea = 32768
	mwSTF_Sliced = 65536
	mwSTF_Text = 131072
	mwSTF_Ruler = 262144
	mwSTF_DimLine = 524288
	
	def __int__(self):
		return self.value

class mwAlignToolFlags(Enum):
	"""Constants that define the types of alignment tools."""
	mwATF_Top = 1
	mwATF_Bottom = 2
	mwATF_VertCenter = 4
	mwATF_Left = 8
	mwATF_Right = 16
	mwATF_HorzCenter = 32
	mwATF_SpaceV = 64
	mwATF_SpaceH = 128
	
	def __int__(self):
		return self.value

class mwProjectToolFlags(Enum):
	"""Constants that define the types of project tools."""
	mwPTF_Undo = 1
	mwPTF_Redo = 2
	mwPTF_ZoomArea = 4
	mwPTF_ZoomOut = 8
	mwPTF_AutoView = 16
	mwPTF_Tune = 32
	mwPTF_SnapTogether = 64
	mwPTF_SnapToFit = 128
	mwPTF_SnapAll = 256
	mwPTF_AnchorTool = 512
	mwPTF_Measure = 1024
	mwPTF_ViewSchematic = 2048
	mwPTF_ViewLayout = 4096
	mwPTF_View3D = 8192
	mwPTF_GridMult = 16384
	mwPTF_DRC = 32768
	
	def __int__(self):
		return self.value

class mwLinearSolveType(Enum):
	"""Constants that define the solution types available in the linear circuit simulator."""
	mwLST_Smart = 0
	mwLST_Sparse = 1
	mwLST_Full = 2
	
	def __int__(self):
		return self.value

class mwNonLinearSolveType(Enum):
	"""Constants that define the solution types available in the non-linear circuit simulator."""
	mwNLST_Smart = 0
	mwNLST_Iterative = 1
	mwNLST_Direct = 2
	
	def __int__(self):
		return self.value

class mwEMSolverType(Enum):
	"""Constants that define the matrix solution types available in the EM simulator."""
	mwEMST_DefaultDirect = 0
	mwEMST_FullDirect = 1
	mwEMST_SymetricDirect = 2
	mwEMST_IterativeLarge = 3
	mwEMST_IterativeMedium = 4
	mwEMST_IterativeSmall = 5
	mwEMST_IterativeCustom = 6
	
	def __int__(self):
		return self.value

class mwEMSolverToleranceLevel(Enum):
	"""Constants that define the tolerance level for the matrix solver."""
	mwEMSL_Low = 0
	mwEMSL_Medium = 1
	mwEMSL_High = 2
	mwEMSL_VeryHigh = 3
	
	def __int__(self):
		return self.value

class mwEMMeshDensity(Enum):
	"""Constants that define the mesh density levels available for EM simulation."""
	mwEMMD_High = 0
	mwEMMD_Normal = 1
	mwEMMD_Medium = 2
	mwEMME_Low = 3
	
	def __int__(self):
		return self.value

class mwColor(Enum):
	"""Constants that define different types of standard colors."""
	mwCLR_AliceBlue = 16775408
	mwCLR_AntiqueWhite = 14150650
	mwCLR_Aqua = 16776960
	mwCLR_Aquamarine = 13959039
	mwCLR_Azure = 16777200
	mwCLR_Beige = 14480885
	mwCLR_Bisque = 12903679
	mwCLR_Black = 0
	mwCLR_BlanchedAlmond = 13495295
	mwCLR_Blue = 16711680
	mwCLR_BlueViolet = 14822282
	mwCLR_Brown = 2763429
	mwCLR_BurlyWood = 8894686
	mwCLR_CadetBlue = 10526303
	mwCLR_Chartreuse = 65407
	mwCLR_Chocolate = 1993170
	mwCLR_Coral = 5275647
	mwCLR_CornflowerBlue = 15570276
	mwCLR_Cornsilk = 14481663
	mwCLR_Crimson = 3937500
	mwCLR_Cyan = 16776960
	mwCLR_DarkBlue = 9109504
	mwCLR_DarkCyan = 9145088
	mwCLR_DarkGoldenrod = 755384
	mwCLR_DarkGray = 11119017
	mwCLR_DarkGreen = 25600
	mwCLR_DarkKhaki = 7059389
	mwCLR_DarkMagenta = 9109643
	mwCLR_DarkOliveGreen = 3107669
	mwCLR_DarkOrange = 36095
	mwCLR_DarkOrchid = 13382297
	mwCLR_DarkRed = 139
	mwCLR_DarkSalmon = 8034025
	mwCLR_DarkSeaGreen = 9157775
	mwCLR_DarkSlateBlue = 9125192
	mwCLR_DarkSlateGray = 5197615
	mwCLR_DarkTurquoise = 13749760
	mwCLR_DarkViolet = 13828244
	mwCLR_DeepPink = 9639167
	mwCLR_DeepSkyBlue = 16760576
	mwCLR_DimGray = 6908265
	mwCLR_DodgerBlue = 16748574
	mwCLR_Firebrick = 2237106
	mwCLR_FloralWhite = 15792895
	mwCLR_ForestGreen = 2263842
	mwCLR_Fuchsia = 16711935
	mwCLR_Gainsboro = 14474460
	mwCLR_GhostWhite = 16775416
	mwCLR_Gold = 55295
	mwCLR_Goldenrod = 2139610
	mwCLR_Gray = 8421504
	mwCLR_Green = 32768
	mwCLR_GreenYellow = 3145645
	mwCLR_Honeydew = 15794160
	mwCLR_HotPink = 11823615
	mwCLR_IndianRed = 6053069
	mwCLR_Indigo = 8519755
	mwCLR_Ivory = 15794175
	mwCLR_Khaki = 9234160
	mwCLR_Lavender = 16443110
	mwCLR_LavenderBlush = 16118015
	mwCLR_LawnGreen = 64636
	mwCLR_LemonChiffon = 13499135
	mwCLR_LightBlue = 15128749
	mwCLR_LightCoral = 8421616
	mwCLR_LightCyan = 16777184
	mwCLR_LightGoldenrodYellow = 13826810
	mwCLR_LightGray = 13882323
	mwCLR_LightGreen = 9498256
	mwCLR_LightPink = 12695295
	mwCLR_LightSalmon = 8036607
	mwCLR_LightSeaGreen = 11186720
	mwCLR_LightSkyBlue = 16436871
	mwCLR_LightSlateGray = 10061943
	mwCLR_LightSteelBlue = 14599344
	mwCLR_LightYellow = 14745599
	mwCLR_Lime = 65280
	mwCLR_LimeGreen = 3329330
	mwCLR_Linen = 15134970
	mwCLR_Magenta = 16711935
	mwCLR_Maroon = 128
	mwCLR_MediumAquamarine = 11193702
	mwCLR_MediumBlue = 13434880
	mwCLR_MediumOrchid = 13850042
	mwCLR_MediumPurple = 14381203
	mwCLR_MediumSeaGreen = 7451452
	mwCLR_MediumSlateBlue = 15624315
	mwCLR_MediumSpringGreen = 10156544
	mwCLR_MediumTurquoise = 13422920
	mwCLR_MediumVioletRed = 8721863
	mwCLR_MidnightBlue = 7346457
	mwCLR_MintCream = 16449525
	mwCLR_MistyRose = 14804223
	mwCLR_Moccasin = 11920639
	mwCLR_NavajoWhite = 11394815
	mwCLR_Navy = 8388608
	mwCLR_OldLace = 15136253
	mwCLR_Olive = 32896
	mwCLR_OliveDrab = 2330219
	mwCLR_Orange = 42495
	mwCLR_OrangeRed = 17919
	mwCLR_Orchid = 14053594
	mwCLR_PaleGoldenrod = 11200750
	mwCLR_PaleGreen = 10025880
	mwCLR_PaleTurquoise = 15658671
	mwCLR_PaleVioletRed = 9662683
	mwCLR_PapayaWhip = 14020607
	mwCLR_PeachPuff = 12180223
	mwCLR_Peru = 4163021
	mwCLR_Pink = 13353215
	mwCLR_Plum = 14524637
	mwCLR_PowderBlue = 15130800
	mwCLR_Purple = 8388736
	mwCLR_Red = 255
	mwCLR_RosyBrown = 9408444
	mwCLR_RoyalBlue = 14772545
	mwCLR_SaddleBrown = 1262987
	mwCLR_Salmon = 7504122
	mwCLR_SandyBrown = 6333684
	mwCLR_SeaGreen = 5737262
	mwCLR_SeaShell = 15660543
	mwCLR_Sienna = 2970272
	mwCLR_Silver = 12632256
	mwCLR_SkyBlue = 15453831
	mwCLR_SlateBlue = 13458026
	mwCLR_SlateGray = 9470064
	mwCLR_Snow = 16448255
	mwCLR_SpringGreen = 8388352
	mwCLR_SteelBlue = 11829830
	mwCLR_Tan = 9221330
	mwCLR_Teal = 8421376
	mwCLR_Thistle = 14204888
	mwCLR_Tomato = 4678655
	mwCLR_Turquoise = 13688896
	mwCLR_Violet = 15631086
	mwCLR_Wheat = 11788021
	mwCLR_White = 16777215
	mwCLR_WhiteSmoke = 16119285
	mwCLR_Yellow = 65535
	mwCLR_YellowGreen = 3329434
	
	def __int__(self):
		return self.value

class mwGraphColorIndex(Enum):
	"""Constants that define indexes for the graph color values for graph color options."""
	mwGCI_Black = 0
	mwGCI_Red = 1
	mwGCI_Green = 2
	mwGCI_Blue = 3
	mwGCI_Magenta = 4
	mwGCI_Brown = 5
	mwGCI_Cyan = 6
	mwGCI_Yellow = 7
	mwGCI_Gray = 8
	mwGCI_LtGray = 9
	
	def __int__(self):
		return self.value

class mwGraphLineStyleIndex(Enum):
	"""Constants that define indexes for the graph line style values for graph line style options."""
	mwGLS_SolidLine = 0
	mwGLS_DashedLine = 1
	mwGLS_DottedLine = 2
	mwGLS_DotDashLine = 3
	
	def __int__(self):
		return self.value

class mwGraphLineWeightIndex(Enum):
	"""Constants that define index for the graph line weight values for graph line weight options."""
	mwGLW_1PixelWidth = 0
	mwGLW_2PixelWidth = 1
	mwGLW_3PixelWidth = 2
	mwGLW_4PixelWidth = 3
	mwGLW_5PixelWidth = 4
	
	def __int__(self):
		return self.value

class mwGraphLegendStyleIndex(Enum):
	"""Constants that define index values pf legend styles for the legend text entries."""
	mwGLE_DataName = 0
	mwGLE_MeasurementName = 1
	mwGLE_BothNames = 2
	
	def __int__(self):
		return self.value

class mwGraphYieldRangeStyle(Enum):
	"""Constants that define different modes for displaying range values for yield data."""
	mwGYR_MinAndMax = 0
	mwGYR_Envelope = 1
	mwGYR_RangeBox = 2
	
	def __int__(self):
		return self.value

class mwGraphYieldDisplayStyle(Enum):
	"""Constants that define different modes for displaying traces for yield data."""
	mwGYD_AllTraces = 0
	mwGYD_Passed = 1
	mwGYD_Failed = 2
	mwGYD_Mean = 3
	
	def __int__(self):
		return self.value

class mwLayoutViewDetails(Enum):
	"""Constants that define different levels of layout viewing details."""
	mwLVD_AllDetails = 0
	mwLVD_NormalDetails = 1
	mwLVD_LowDetails = 2
	mwLVD_VeryLowDetails = 3
	
	def __int__(self):
		return self.value

class mwLayoutSelectMode(Enum):
	"""Constants that define different types of layout selection modes."""
	mwLSM_AutoSelect = 0
	mwLSM_ManualSelect = 1
	
	def __int__(self):
		return self.value

class mwLayoutCommandMode(Enum):
	"""Constants that define different types of layout design entry modes."""
	mwLCM_ClickAndDrag = 0
	mwLCM_TwoClick = 1
	
	def __int__(self):
		return self.value

class mwLayoutRouteGravity(Enum):
	"""Constants that define different levels of layout route inference snap gravity."""
	mwLRG_NoneGravity = 0
	mwLRG_WeakGravity = 1
	mwLRG_NormalGravity = 2
	mwLRG_StrongGravity = 3
	
	def __int__(self):
		return self.value

class mwSysNoiseModeling(Enum):
	"""Constants that define different modes of system noise modeling."""
	mwSNM_Noiseless = 0
	mwSNM_RFBudgetOnly = 1
	mwSNM_RFBudgetAndTimeDomain = 2
	
	def __int__(self):
		return self.value

class mwLayoutSnapMode(Enum):
	"""Constants that define different types of layout snap modes."""
	mwLSM_Auto = 0
	mwLSM_Manual = 1
	mwLSM_Selected = 2
	
	def __int__(self):
		return self.value

class mwInterpolationMethod(Enum):
	"""Constants that define different methods for value interpolation."""
	mwIM_Linear = 0
	mwIM_RationalFunction = 1
	mwIM_SplineCurve = 2
	
	def __int__(self):
		return self.value

class mwInterpolationCoords(Enum):
	"""Constants that define different interpolation coordinate system types."""
	mwIC_Cartesian = 0
	mwIC_Polar = 1
	
	def __int__(self):
		return self.value

class mwInstanceExportOptions(Enum):
	"""Constants that define different options for exporting instances from layout."""
	mwIEO_NoChangesToCellNames = 0
	mwIEO_AppendNumberToDuplicates = 1
	mwIEO_AppendLibNameToDuplicates = 2
	mwIEO_AppendLibNameToAll = 3
	
	def __int__(self):
		return self.value

class mwFaceInsetOptions(Enum):
	"""Constants that define different options for inserting layout cell faces."""
	mwFIO_NoInset = 0
	mwFIO_InsetNonOrthogOneQtrDbUnit = 1
	mwFIO_InsetNonOrthogOneHalfDbUnit = 2
	mwFIO_InsetNonOrthogThreeQtrDbUnit = 3
	mwFIO_InsetNonOrthogOneDbUnit = 4
	mwFIO_InsetAllOneQtrDbUnit = 5
	mwFIO_InsetAllOneHalfDbUnit = 6
	mwFIO_InsetAllThreeQtrDbUnit = 7
	mwFIO_InsetAllOneDbUnit = 8
	
	def __int__(self):
		return self.value

class mwPortFaceConnectTypes(Enum):
	"""Constants that define different types of face connection options."""
	mwCT_Unknown = 0
	mwCT_CapTopPlate = 1
	mwCT_CapBotPlate = 2
	mwCT_SpiralExit = 3
	mwCT_SpiralTurn = 4
	mwCT_ViaTop = 5
	mwCT_ViaBottom = 6
	mwCT_Resistor = 7
	mwCT_Resistor2 = 8
	mwCT_Resistor3 = 9
	mwCT_Disabled = 10
	mwCT_LineEnd = 100
	mwCT_LineEndN = 199
	mwCT_LineJunction = 200
	mwCT_LineJunctionN = 299
	mwCT_ArtworkLine = 300
	mwCT_ArtworkLineN = 399
	mwCT_PassThroughBase = 399
	mwCT_PassThrough = 400
	mwCT_PassThroughN = 499
	
	def __int__(self):
		return self.value

class mwPathEndTypeOptions(Enum):
	"""Constants that define different options for path end types."""
	mwPETO_ExtendedHalfWidth = 0
	mwPETO_FlushEnd = 1
	mwPETO_Rounded = 2
	
	def __int__(self):
		return self.value

class mwPathMiterTypeOptions(Enum):
	"""Constants that define different options for path miter types."""
	mwPMTO_Square = 0
	mwPMTO_Mitered = 1
	mwPMTO_OffsetMiter = 2
	
	def __int__(self):
		return self.value

class mwRectangleAttributes(Enum):
	"""Constants that define different types of Rectangle attributes."""
	mwRA_LayerIndex = 0
	
	def __int__(self):
		return self.value

class mwPolygonAttributes(Enum):
	"""Constants that define different types of Polygon attributes."""
	mwPOA_LayerIndex = 0
	mwPOA_Area = 1
	mwPOA_RotationAngle = 2
	mwPOA_Flipped = 3
	mwPOA_BasePositionX = 4
	mwPOA_BasePositionY = 5
	
	def __int__(self):
		return self.value

class mwLayoutCellAttributes(Enum):
	"""Constants that define different types of Layout Cell attributes."""
	mwLCA_LineTypeIndex = 0
	mwLCA_UsesProcessLayers = 1
	mwLCA_LayerMappingIndex = 2
	mwLCA_Anchor = 3
	mwLCA_Frozen = 4
	mwLCA_CellName = 5
	mwLCA_ElementName = 6
	
	def __int__(self):
		return self.value

class mwLayoutShapeAttributes(Enum):
	"""Constants that define different types of Layout Shape attributes."""
	mwLSA_LineTypeIndex = 0
	mwLSA_UsesProcessLayers = 1
	mwLSA_LayerMappingIndex = 2
	mwLSA_LayerIndex = 3
	
	def __int__(self):
		return self.value

class mwLayoutPinAttributes(Enum):
	"""Constants that define different types of Layout Pin attributes."""
	mwLPA_PortNumber = 0
	mwLPA_ConnectType = 1
	mwLPA_PinGroup = 2
	mwLPA_GroupType = 3
	
	def __int__(self):
		return self.value

class mwLayoutRoutePathAttributes(Enum):
	"""Constants that define different types of Layout Route attributes."""
	mwLRP_NetworkId = 0
	mwLRP_Associated = 1
	
	def __int__(self):
		return self.value

class mwLayoutNetShapeAttributes(Enum):
	"""Constants that define different types of LayoutNetShape attributes."""
	mwLNS_NetworkId = 0
	mwLNS_Associated = 1
	
	def __int__(self):
		return self.value

class mwLayoutCellShapeAttributes(Enum):
	"""Constants that define the different types of LayoutCellShape attributes."""
	mwLCS_CellName = 0
	mwLCS_IsArtwork = 1
	
	def __int__(self):
		return self.value

class mwLayoutSubcircuitAttributes(Enum):
	"""Constants that define the different types of LayoutSubcircuit attributes."""
	mwLSA_MasterDocName = 0
	
	def __int__(self):
		return self.value

class mwLayoutGroupAttributes(Enum):
	"""Constants that define the different types of Layout Group attributes."""
	mwLGA_GroupChildCount = 0
	
	def __int__(self):
		return self.value

class mwLayoutLayerAttributes(Enum):
	"""Constants that define the different types of LayoutLayer attributes."""
	mwLLA_LayerName = 0
	
	def __int__(self):
		return self.value

class mwLayoutMagnificationAttributes(Enum):
	"""Constants that define different types of layout magnification attributes."""
	mwLMA_Magnification = 0
	
	def __int__(self):
		return self.value

class mwLayout3DPlacementAttributes(Enum):
	"""Constants that define different types of layout 3D placement attributes."""
	mwTDP_EmLayer = 0
	mwTDP_ZOffset = 1
	mwTDP_XAngle = 2
	mwTDP_YAngle = 3
	mwTDP_ZFlip = 4
	
	def __int__(self):
		return self.value

class mwLayoutOrientationAttributes(Enum):
	"""Constants that define different types of layout orientation attributes."""
	mwLOA_FixedPosition = 0
	mwLOA_FlipState = 1
	mwLOA_RotationAngle = 2
	
	def __int__(self):
		return self.value

class mwLayoutCellStretcherAttributes(Enum):
	"""Constants that define different types of layout cell stretcher attributes."""
	mwLCS_ParameterName = 0
	mwLCS_Multiplier = 1
	mwLCS_Offset = 2
	mwLCS_UpperLimit = 3
	mwLCS_LowerLimit = 4
	mwLCS_IsBound = 5
	mwLCS_Direction = 6
	mwLCS_ArrowHeight = 7
	
	def __int__(self):
		return self.value

class mwLayoutDragLayoutObjectAttributes(Enum):
	"""Constants that define different types of layout drag object attributes."""
	mwDLO_UseForAnchor = 0
	mwDLO_StretchToFix = 1
	
	def __int__(self):
		return self.value

class mwLayoutFontAttributes(Enum):
	"""Constants that define different types of layout font attributes."""
	mwLFA_FontName = 0
	mwLFA_BoldStyle = 1
	mwLFA_ItalicStyle = 2
	mwLFA_FontHeight = 3
	
	def __int__(self):
		return self.value

class mwSchematicFontAttributes(Enum):
	"""Constants that define different types of schematic font attributes."""
	mwSFA_FontName = 0
	mwSFA_BoldStyle = 1
	mwSFA_ItalicStyle = 2
	mwSFA_FontHeight = 3
	
	def __int__(self):
		return self.value

class mwLayoutTextAttributes(Enum):
	"""Constants that define different types of layout text attributes."""
	mwLTA_DrawTextAsPoly = 0
	mwLTA_DrawTextArrow = 1
	mwLTA_ArrowPointX = 2
	mwLTA_ArrowPointY = 3
	mwLTA_TextString = 4
	
	def __int__(self):
		return self.value

class mwLayoutDimensionLineAttributes(Enum):
	"""Constants that define different types of layout dimension line attributes."""
	mwDLA_ArrowLocation = 0
	mwDLA_TextLocation = 1
	mwDLA_ArrowLength = 2
	mwDLA_GapLength = 3
	mwDLA_Precision = 4
	mwDLA_ShowUnits = 5
	mwDLA_ShowTolerance = 6
	mwDLA_LengthTolerance = 7
	mwDLA_Length = 8
	
	def __int__(self):
		return self.value

class mwLayoutRulerAttributes(Enum):
	"""Constants that define different types of layout ruler attributes."""
	mwLRA_RulerSpacing = 0
	mwLRA_GapLength = 1
	mwLRA_TickHeight = 2
	mwLRA_Precision = 3
	mwLRA_ShowUnits = 4
	mwLRA_MinorTickSpacing = 5
	mwLRA_MinorTickHeight = 6
	mwLRA_ShowMinorTicks = 7
	mwLRA_ShowLabels = 8
	mwLRA_Length = 9
	
	def __int__(self):
		return self.value

class mwLayoutPolyAttributes(Enum):
	"""Constants that define different types of layout polygon attributes."""
	mwLP_Area = 0
	
	def __int__(self):
		return self.value

class mwLayoutEllipseAttributes(Enum):
	"""Constants that define different types of layout ellipse attributes."""
	mwLEA_Area = 0
	mwLEA_Width = 1
	mwLEA_Height = 2
	mwLEA_Eccentricity = 3
	
	def __int__(self):
		return self.value

class mwLayoutPathAttributes(Enum):
	"""Constants that define different types of layout path attributes."""
	mwLPA_PathWidth = 0
	mwLPA_PathEndType = 1
	mwLPA_MiterType = 2
	mwLPA_OffsetMiterAmount = 3
	mwLPA_BeginExt = 4
	mwLPA_EndExt = 5
	mwLPA_Length = 6
	mwLPA_CurvesFixedRadius = 7
	
	def __int__(self):
		return self.value

class mwLayoutPolylineAttributes(Enum):
	"""Constants that define different types of layout polyline attributes."""
	mwLPLA_Length = 0
	
	def __int__(self):
		return self.value

class mwLayoutArcAttributes(Enum):
	"""Constants that define different types of layout arc attributes."""
	mwLAA_CenterX = 0
	mwLAA_CenterY = 1
	mwLAA_Radius = 2
	mwLAA_StartAngle = 3
	mwLAA_StopAngle = 4
	mwLAA_Filled = 5
	
	def __int__(self):
		return self.value

class mwLayoutFaceAttributes(Enum):
	"""Constants that define different types of layout face attributes."""
	mwFAT_FaceJustification = 0
	mwFAT_XOffset = 1
	mwFAT_YOffset = 2
	mwFAT_AngleOffset = 3
	
	def __int__(self):
		return self.value

class mwLayoutDrillHoleAttributes(Enum):
	"""Constants that define different types of layout drill hole attributes."""
	mwDHA_DrillHoleIndex = 0
	
	def __int__(self):
		return self.value

class mwEmExtractAtrributes(Enum):
	"""Constants that define different types of layout EM extraction attributes."""
	mwEEA_IsEMExtract = 0
	mwEEA_GroupName = 1
	
	def __int__(self):
		return self.value

class mwObjSubShapeAttributes(Enum):
	"""Constants that define different type of object sub shape attributes."""
	mwSSA_SubShapeCount = 0
	
	def __int__(self):
		return self.value

class mwObjectNameAttributes(Enum):
	"""Constants that define different types of object name attributes."""
	mwONA_NetName = 0
	mwONA_PinName = 1
	mwONA_EmExtractName = 2
	
	def __int__(self):
		return self.value

class mwShapeMeshOptionAttributes(Enum):
	"""Constants that define different types of object mesh attributes."""
	mwMOA_MeshUseDefault = 0
	mwMOA_MeshConformalFill = 1
	mwMOA_MeshTriangleFill = 2
	mwMOA_MeshDensity = 3
	mwMOA_X_Min = 4
	mwMOA_X_Max = 5
	mwMOA_Y_Min = 6
	mwMOA_Y_Max = 7
	mwMOA_ZeroThickness = 8
	mwMOA_EdgeMeshing = 9
	mwMOA_Decimation = 10
	mwMOA_AspectRatio = 11
	
	def __int__(self):
		return self.value

class mwEllipseAttributes(Enum):
	"""Constants that define different types of Ellipse attributes."""
	mwEA_LayerIndex = 0
	mwEA_Area = 1
	mwEA_Width = 2
	mwEA_Height = 3
	mwEA_Eccentricity = 4
	mwEA_RotationAngle = 5
	mwEA_Flipped = 6
	mwEA_BasePositionX = 7
	mwEA_BasePositionY = 8
	
	def __int__(self):
		return self.value

class mwArcAttributes(Enum):
	"""Constants that define different types of Arc attributes."""
	mwAA_LayerIndex = 0
	mwAA_CenterX = 1
	mwAA_CenterY = 2
	mwAA_Radius = 3
	mwAA_StartAngle = 4
	mwAA_StopAngle = 5
	mwAA_Length = 6
	mwAA_RotationAngle = 7
	mwAA_Flipped = 8
	mwAA_BasePositionX = 9
	mwAA_BasePositionY = 10
	
	def __int__(self):
		return self.value

class mwPolylineAttributes(Enum):
	"""Constants that defined different types of Polyline attributes."""
	mwPLA_LayerIndex = 0
	mwPLA_Length = 1
	mwPLA_RotationAngle = 2
	mwPLA_Flipped = 3
	mwPLA_BasePositionX = 4
	mwPLA_BasePositionY = 5
	
	def __int__(self):
		return self.value

class mwPathAttributes(Enum):
	"""Constants that define attributes of a shape path object."""
	mwPA_LayerIndex = 0
	mwPA_PathWidth = 1
	mwPA_PathEndType = 2
	mwPA_MiterType = 3
	mwPA_OffsetMiterAmount = 4
	mwPA_BeginExt = 5
	mwPA_EndExt = 6
	mwPA_Length = 7
	mwPA_Area = 8
	mwPA_RotationAngle = 9
	mwPA_Flipped = 10
	mwPA_BasePositionX = 11
	mwPA_BasePositionY = 12
	
	def __int__(self):
		return self.value

class mwArrayCellAttributes(Enum):
	"""Constants that define attributes of an array cell object."""
	mwACA_IsArrayCell = 0
	mwACA_ArrayCellRows = 1
	mwACA_ArrayCellCols = 2
	mwACA_ArrayCellDx = 3
	mwACA_ArrayCellDy = 4
	
	def __int__(self):
		return self.value

class mwCellStretcherAttributes(Enum):
	"""Constants that define different attribute types for cell stretcher shapes"""
	mwCSA_StretchType = 0
	mwCSA_ParameterName = 1
	mwCSA_Multipler = 2
	mwCSA_Offset = 3
	mwCSA_UpperLimit = 4
	mwCSA_LowerLimit = 5
	mwCSA_ArrowHeight = 6
	mwCSA_IsBound = 7
	mwCSA_Region = 8
	
	def __int__(self):
		return self.value

class mwElectNetAttributes(Enum):
	"""Constants that define different attribute types for electrical net elements"""
	mwENA_UserNetName = 0
	
	def __int__(self):
		return self.value

class mwSymbolTextAttributes(Enum):
	"""Constants that define different types of symbol text attributes."""
	mwSTA_Height = 1
	mwSTA_Width = 2
	mwSTA_Rotation = 3
	mwSTA_Text = 4
	mwSTA_Font = 5
	
	def __int__(self):
		return self.value

class mwSymbolPathAttributes(Enum):
	"""Constants that define different types of symbol path attributes."""
	mwSPA_Width = 1
	mwSPA_MiterType = 2
	mwSPA_MiterOffset = 3
	mwSPA_endType = 4
	mwSPA_bOffset = 5
	mwSPA_eOffset = 6
	
	def __int__(self):
		return self.value

class mwLayoutConnectionLineTypes(Enum):
	"""Constants that define different types of layout connection line drawing."""
	mwLCL_StaightLines = 0
	mwLCL_CenterPointLines = 1
	mwLCL_MinimumSpanningLines = 2
	
	def __int__(self):
		return self.value

class mwSpiceExtractionModelLevel(Enum):
	"""Constants that define different spice model extraction levels"""
	mwSML_Simplest = 0
	mwSML_1stOrder = 1
	mwSML_2ndOrder = 2
	mwSML_Distributed = 3
	mwSML_MostAccurate = 4
	
	def __int__(self):
		return self.value

class mwINetModelingLevel(Enum):
	"""Constants that define different iNet modeling accuracy levels"""
	mwNML_ShortCircuits = 0
	mwNML_RCLumped = 1
	mwNML_RLCLumped = 2
	mwNML_Distrubuted = 3
	mwNML_EmExtraction = 4
	
	def __int__(self):
		return self.value

class mwModelCompatibilityVersion(Enum):
	"""Constants that define different model compatibility version levels"""
	mwMCV_Version553 = 553
	mwMCV_Version600 = 600
	mwMCV_Version650 = 650
	mwMCV_Version750 = 750
	mwMCV_Version800 = 800
	mwMCV_Version900 = 900
	
	def __int__(self):
		return self.value

class mwRouteObstructionLevel(Enum):
	"""Constants that define different routing obstruction avoidance levels"""
	mwROL_IgnoreObstructions = 0
	mwROL_IgnoreExistingNets = 1
	mwROL_AvoidObjstructions = 2
	
	def __int__(self):
		return self.value

class mwModelExtractType(Enum):
	"""Constants that define different model options for an element."""
	mwMET_CircuitBasedModel = 0
	mwMET_EMExtractedModel = 1
	
	def __int__(self):
		return self.value

class mwDrawingTextAttributes(Enum):
	"""Constants that define different types of drawing text attributes."""
	mwDTA_Height = 1
	mwDTA_Text = 2
	mwDTA_Font = 3
	mwDTA_Bold = 4
	mwDTA_Italic = 5
	
	def __int__(self):
		return self.value

class mwDefaultFaceAlignType(Enum):
	"""Constants that define different types of default face alignments."""
	mwDFA_Center = 0
	mwDFA_Variable = 1
	
	def __int__(self):
		return self.value

class mwApplicationAttributeType(Enum):
	"""Constants that define different types of application attribute types"""
	mwAAT_IniFilePath = 1
	mwAAT_EnvIniFilePath = 2
	mwAAT_ClientDirectory = 3
	mwAAT_BuildNumber = 4
	mwAAT_AppVersion = 5
	mwAAT_AppVersionShort = 6
	mwAAT_AppStreamVersion = 7
	mwAAT_AppName = 8
	mwAAT_AppNameDetailed = 9
	mwAAT_FoundryProcName = 10
	mwAAT_TestMode = 11
	mwAAT_RegressionCaptureMode = 12
	mwAAT_ProcessID = 13
	mwAAT_BuildRevision = 14
	mwAAT_AppProgId = 15
	mwAAT_LicenseInfo = 16
	mwAAT_ApiMajorVersion = 17
	mwAAT_ApiMinorVersion = 18
	mwAAT_AppAttributeCount = 19
	
	def __int__(self):
		return self.value

class mwApplicationDirectoryType(Enum):
	"""Constants that define different types of application directories."""
	mwADT_AppDir = 0
	mwADT_AppData = 1
	mwADT_AppDataUser = 2
	mwADT_AppDataCommon = 3
	mwADT_TempFile = 4
	mwADT_AppDataLogs = 5
	mwADT_AppDataLibraryCache = 6
	mwADT_Examples = 7
	mwADT_Libraries = 8
	mwADT_EmModels = 9
	mwADT_Models = 10
	mwADT_Cells = 11
	mwADT_Symbols = 12
	mwADT_Signals = 13
	mwADT_Textures = 14
	mwADT_Data = 15
	mwADT_HSpice = 16
	mwADT_TestResults = 17
	mwADT_EmModelsUser = 18
	mwADT_Logs = 19
	mwADT_LibraryCache = 20
	mwADT_Analog = 21
	mwADT_Projects = 22
	mwADT_Scripts = 23
	mwADT_ScriptsUser = 24
	mwADT_CurrentProject = 25
	mwADT_Documents = 26
	mwADT_DesignKits = 27
	mwADT_Measurements = 28
	mwADT_XmlUser = 29
	mwADT_WizardsUser = 30
	mwADT_Wizards = 31
	mwADT_DataSet = 32
	mwADT_VersionControl = 33
	mwADT_OpenAccess = 34
	
	def __int__(self):
		return self.value

class mwApplicationFileType(Enum):
	"""Constants that define different types of application files."""
	mwAFT_Temporary = 0
	mwAFT_CommonIni = 1
	mwAFT_UserIni = 2
	mwAFT_Customizations = 3
	mwAFT_DataCache = 4
	mwAFT_FlexLmLicense = 5
	mwAFT_Executable = 6
	mwAFT_EMSightCache = 7
	mwAFT_MWOfficeExe = 8
	mwAFT_Project = 9
	mwAFT_GlobalScript = 10
	
	def __int__(self):
		return self.value

class mwLayoutCellExportOptions(Enum):
	"""Constants that define different types of layout cell export options"""
	mwLCE_ExportFlattenedOption = 0
	mwLCE_ExportAsInstancesOption = 1
	mwLCE_ExportSpecifiedAsInstances = 2
	
	def __int__(self):
		return self.value

class mwLayoutObjectSelectFilters(Enum):
	"""Constants that define bits for specific object types for restricting selection in layout"""
	mwLSF_None = 0
	mwLSF_Graphics = 1
	mwLSF_Text = 4
	mwLSF_iNet = 64
	mwLSF_LayCell = 256
	mwLSF_SubCell = 512
	mwLSF_CellPort = 4096
	mwLSF_AreaPin = 8192
	mwLSF_LayPort = 16384
	mwLSF_ArtworkCell = 131072
	mwLSF_EMPort = 262144
	mwLSF_LayModifier = 1048576
	mwLSF_ExtractPin = 2097152
	mwLSF_Polygon = 4194304
	mwLSF_Path = 8388608
	mwLSF_Circle = 16777216
	
	def __int__(self):
		return self.value

class mwNetViaSizeOpts(Enum):
	"""Constants that define different types of iNet route to pin via size options."""
	mwVSO_ViaCoversPinRouteIntersection = 0
	mwVSO_ViaConversEntirePin = 1
	mwVSO_ViaMinimalSize = 2
	
	def __int__(self):
		return self.value

class mwDefRouteConnModelTypes(Enum):
	"""Constants that define different types of route-to-route connection models."""
	mwDRCM_CenterlineModel = 0
	mwDRCM_CenterlineAndAdjacent = 1
	
	def __int__(self):
		return self.value

class mwSmithGridAttributes(Enum):
	"""Constants that define the different types of attributes for a Smith Chart type Graph."""
	mwSGA_None = 0
	mwSGA_SmithChartStyle = 1
	mwSGA_DefaultSweepRange = 2
	mwSGA_SweepDisplayMin = 3
	mwSGA_SweepDisplayMax = 4
	mwSGA_ImpedanceGridVisible = 5
	mwSGA_AdmittanceGridVisible = 6
	mwSGA_ValuesVisible = 7
	mwSGA_AutoSize = 8
	mwSGA_ChartSize = 9
	mwSGA_AutoContour = 10
	mwSGA_ContourDensity = 11
	mwSGA_GraticuleColor = 12
	mwSGA_ImpedanceColor = 13
	mwSGA_AdmittanceColor = 14
	mwSGA_ImpedanceLineStyle = 15
	mwSGA_AdmittanceLineStyle = 16
	mwSGA_SweepMinimum = 17
	mwSGA_SweepMaximum = 18
	mwSGA_SweepMinMaxVisible = 19
	
	def __int__(self):
		return self.value

class mwPolarGridAttributes(Enum):
	"""Constants that define the different types of attributes for a Polar Chart type Graph."""
	mwPGA_None = 0
	mwPGA_PolarChartStyle = 1
	mwPGA_DefaultSweepRange = 2
	mwPGA_SweepDisplayMin = 3
	mwPGA_SweepDisplayMax = 4
	mwPGA_GraticuleColor = 5
	mwPGA_MajorDivisionsColor = 6
	mwPGA_MinorDivisionsColor = 7
	mwPGA_MagnitudeLineStyle = 8
	mwPGA_AngleLineStyle = 9
	mwPGA_MagniAutoDivisions = 10
	mwPGA_AngleAutoDivisions = 11
	mwPGA_MagnitudeLimit = 12
	mwPGA_MagnitudeDivisions = 13
	mwPGA_MagnitudeSubdivisions = 14
	mwPGA_MagnitudeMaximum = 15
	mwPGA_MagnitudeMinimum = 16
	mwPGA_AngleDivisions = 17
	mwPGA_AngleSubdivisions = 18
	mwPGA_ShowMagDivisions = 19
	mwPGA_ShowMagSubdivisions = 20
	mwPGA_ShowMagValues = 21
	mwPGA_ShowAngDivisions = 22
	mwPGA_ShowAngSubdivisions = 23
	mwPGA_ShowAngValues = 24
	mwPGA_SweepMinimum = 25
	mwPGA_SweepMaximum = 26
	mwPGA_SweepMinMaxVisible = 27
	
	def __int__(self):
		return self.value

class mwRectGridAttributes(Enum):
	"""Constants that define the different types of attributes for a Rectangular Chart type Graph."""
	mwRGA_None = 0
	mwRGA_RectChartType = 1
	mwRGA_GraticuleColor = 2
	mwRGA_MajorDivisionsColor = 3
	mwRGA_MinorDivisionsColor = 4
	mwRGA_XAxisLineStyle = 5
	mwRGA_LeftYAxisLineStyle = 6
	mwRGA_RightYAxisLineStyle = 7
	mwRGA_ShowTickMarks = 8
	mwRGA_TickMarkSize = 9
	mwRGA_UseDefaultXLabel = 10
	mwRGA_DefaultXLabel = 11
	mwRGA_SweepMinMaxVisible = 12
	
	def __int__(self):
		return self.value

class mwPlot3DGridAttributes(Enum):
	"""Constants that define the different types of attributes for a 3D Plot type Graph."""
	mwP3A_None = 0
	mwP3A_AxisGridColorX = 1
	mwP3A_AxisGridColorY = 2
	mwP3A_AxisGridColorZ = 3
	mwP3A_AxisLabelX = 4
	mwP3A_AxisLabelY = 5
	mwP3A_AxisLabelZ = 6
	mwP3A_UseAutoDivisionsX = 7
	mwP3A_UseAutoDivisionsY = 8
	mwP3A_UseAutoDivisionsZ = 9
	mwP3A_ManualDivisionsX = 10
	mwP3A_ManualDivisionsY = 11
	mwP3A_ManualDivisionsZ = 12
	mwP3A_AutoDivisionsX = 13
	mwP3A_AutoDivisionsY = 14
	mwP3A_AutoDivisionsZ = 15
	mwP3A_ShowDivisionValuesX = 16
	mwP3A_ShowDivisionValuesY = 17
	mwP3A_ShowDivisionValuesZ = 18
	mwP3A_UseAutoRangeX = 19
	mwP3A_UseAutoRangeY = 20
	mwP3A_UseAutoRangeZ = 21
	mwP3A_ManualRangeMinX = 22
	mwP3A_ManualRangeMaxX = 23
	mwP3A_ManualRangeMinY = 24
	mwP3A_ManualRangeMaxY = 25
	mwP3A_ManualRangeMinZ = 26
	mwP3A_ManualRangeMaxZ = 27
	mwP3A_AutoRangeMinX = 28
	mwP3A_AutoRangeMaxX = 29
	mwP3A_AutoRangeMinY = 30
	mwP3A_AutoRangeMaxY = 31
	mwP3A_AutoRangeMinZ = 32
	mwP3A_AutoRangeMaxZ = 33
	mwP3A_EnableLighting = 34
	mwP3A_LightPositionX = 35
	mwP3A_LightPositionY = 36
	mwP3A_LightPositionZ = 37
	mwP3A_LightLevelAmbient = 38
	mwP3A_LightLevelDiffuse = 39
	mwP3A_LightLevelSpecular = 40
	mwP3A_LightMaterialAmbient = 41
	mwP3A_LightMaterialDiffuse = 42
	mwP3A_LightMaterialSpecular = 43
	mwP3A_LightMaterialShininess = 44
	mwP3A_LightMaterialEmission = 45
	mwP3A_UseDefaultLabelX = 46
	mwP3A_ShowUnitsLabelX = 47
	mwP3A_UseDefaultLabelY = 48
	mwP3A_ShowUnitsLabelY = 49
	
	def __int__(self):
		return self.value

class mwTabularGridAttributes(Enum):
	"""Constants that define the different types of attributes for a Tabular Grid type Graph."""
	mwTGA_None = 0
	mwTGA_NumberFormat = 1
	mwTGA_DisplayFormat = 2
	mwTGA_DataPrecision = 3
	mwTGA_SweepPrecision = 4
	
	def __int__(self):
		return self.value

class mwShowFileFlags(Enum):
	"""Constants that define flags for the options when displaying a file using the file util ShowFile."""
	mwSFF_USEEXPLORER = 16
	mwSFF_AUTOUPDATE = 32
	mwSFF_FILEBUFFER = 64
	
	def __int__(self):
		return self.value

class mwShapePreprocessorAttributes(Enum):
	"""Constants that define the different types of Preprocessor attributes."""
	mwSPA_PreprocessorRules = 0
	
	def __int__(self):
		return self.value

class mwBooleanEngineVersions(Enum):
	"""Constants that define the different types of boolean engines that can be used for shape processing in layout."""
	mwBEV_BooleanLatest = 0
	mwBEV_BooleanPolyBool = 1
	mwBEV_BooleanBoost = 2
	mwBEV_BooleanClipper = 3
	
	def __int__(self):
		return self.value

class mwBooleanCornerStyles(Enum):
	"""Constants that define the different types of corner styles that can be used when resizing shapes with acute angles"""
	mwBCS_CornerRounded = 0
	mwBCS_CornerSharp = 1
	
	def __int__(self):
		return self.value

class mwEditGraphPropertiesCommands(Enum):
	"""Constants that define the different types of commands for Edit Graph Properties."""
	mwEGP_RectangularAddAxis = 0
	mwEGP_RectangularRemoveAxis = 1
	
	def __int__(self):
		return self.value

class mwWindowState(Enum):
	"""Constants that define the different window states."""
	mwWS_Maximized = 1
	mwWS_Minimized = 2
	mwWS_Normal = 3
	
	def __int__(self):
		return self.value

class mwOptimizerSetting(Enum):
	"""Constants that define the different optimizer settings."""
	mwOS_OptimizerSelected = 100
	mwOS_MaxIterations = 101
	mwOS_StopAtMin = 102
	mwOS_Property = 103
	mwOS_StopRequested = 104
	mwOS_ResultsSaved = 105
	mwOS_ResultsReverted = 106
	mwOS_ResultsCleared = 107
	mwOS_ResetYield = 108
	mwOS_StopOnErr = 109
	
	def __int__(self):
		return self.value

class mwStatisticalDist(Enum):
	"""Constants that define different types of statistical distributions."""
	mwSD_Deterministic = 0
	mwSD_UniformDist = 1
	mwSD_NormalDist = 2
	mwSD_ModelDist = 3
	mwSD_LogNormal = 4
	mwSD_Discrete = 5
	mwSD_NormalMinusTol = 6
	mwSD_NormalClipped = 7
	
	def __int__(self):
		return self.value

class mwVarPropMode(Enum):
	"""Constants that define different types of variable passing down hierarchy"""
	mwVPM_None = 0
	mwVPM_Weak = 1
	mwVPM_Strong = 2
	
	def __int__(self):
		return self.value

class mwEquationVariableType(Enum):
	"""Constants that define different types of equation variables"""
	mwEVT_VariableDefinition = 0
	mwEVT_ParameterDefinition = 1
	mwEVT_DisplayValue = 2
	
	def __int__(self):
		return self.value

class mwEquationDataType(Enum):
	"""Constants that define different types of data for equations"""
	mwEDT_Real = 0
	mwEDT_Complex = 1
	mwEDT_Integer = 2
	mwEDT_String = 3
	mwEDT_ElementName = 4
	mwEDT_DataModel = 5
	mwEDT_InfoString = 6
	mwEDT_None = 7
	mwEDT_Enumeration = 8
	mwEDT_RealVector = 9
	mwEDT_FileName = 10
	mwEDT_ComplexVector = 11
	
	def __int__(self):
		return self.value

class mwUnitType(Enum):
	"""Constants that define different types of units."""
	mwUT_None = 0
	mwUT_Frequency = 1
	mwUT_Capacitance = 2
	mwUT_Inductance = 3
	mwUT_Resistance = 4
	mwUT_Conductance = 5
	mwUT_Length = 6
	mwUT_LengthEnglish = 7
	mwUT_Temperature = 8
	mwUT_Angle = 9
	mwUT_Time = 10
	mwUT_Voltage = 11
	mwUT_Current = 12
	mwUT_PowerLog = 13
	mwUT_Power = 14
	mwUT_DB = 15
	mwUT_String = 16
	mwUT_Scaler = 17
	mwUT_DBOnlyPower = 18
	mwUT_WattsOnlyPower = 19
	mwUT_TextOnly = 20
	
	def __int__(self):
		return self.value

class mwParameterStyle(Enum):
	"""Constants that define different types of parameter styles."""
	mwPS_Hide = 0
	mwPS_HideUnits = 1
	mwPS_HideEmpty = 2
	mwPS_HideVarName = 3
	mwPS_LeftJustify = 4
	mwPS_BoldFont = 5
	mwPS_HideIfSecondary = 6
	
	def __int__(self):
		return self.value

class mwParameterStyleSetting(Enum):
	"""Constants that define different types of parameter style settings."""
	mwPSS_SetStyle = 0
	mwPSS_ClearStyle = 1
	mwPSS_UseDefaultStyle = 2
	
	def __int__(self):
		return self.value

class mwParamDefDataType(Enum):
	"""Constants that define the data types of a ParameterDefinition."""
	mwPDDT_Real = 0
	mwPDDT_Complex = 1
	mwPDDT_Integer = 2
	mwPDDT_String = 3
	mwPDDT_ElementName = 4
	mwPDDT_DataModel = 5
	mwPDDT_InfoString = 6
	mwPDDT_None = 7
	mwPDDT_Enumeration = 8
	mwPDDT_RealVector = 9
	mwPDDT_FileName = 10
	
	def __int__(self):
		return self.value

class mwParameterDefinitionFlagType(Enum):
	"""Constants that define different types of parameter default flags for parameter definitions."""
	mwPDF_Default = 0
	mwPDF_Hide = 1
	mwPDF_HideIfEmpty = 2
	mwPDF_HideUnits = 3
	mwPDF_LJustify = 4
	mwPDF_ReadOnly = 5
	mwPDF_EmptyStringOk = 6
	mwPDF_HideVarName = 7
	mwPDF_BoldFont = 8
	mwPDF_Secondary = 9
	mwPDF_IsPortNumber = 10
	mwPDF_NoNetlist = 11
	mwPDF_NonStructural = 12
	mwPDF_Structural = 13
	mwPDF_ReadDataTable = 14
	mwPDF_ParDefIsCopy = 15
	mwPDF_ConnectToSim = 16
	mwPDF_ChangeStructural = 17
	mwPDF_DynamicModParam = 18
	mwPDF_StreamParDef = 19
	mwPDF_ChangeNotDirty = 20
	mwPDF_NoAffectLayout = 21
	mwPDF_NoTune = 22
	mwPDF_Synthesized = 23
	mwPDF_Binned = 24
	mwPDF_ChangeConnectivity = 25
	mwPDF_NoDocNameSync = 26
	mwPDF_LayCell_EleParam = 27
	
	def __int__(self):
		return self.value

class mwNodeType(Enum):
	"""Constants that define different types of element nodes."""
	mwNT_Electrical = 0
	mwNT_Input = 1
	mwNT_Output = 2
	mwNT_BiDirectional = 3
	
	def __int__(self):
		return self.value

class mwNodeDataType(Enum):
	"""Constants that define different types of node data types."""
	mwNDT_Unset = 0
	mwNDT_Real = 1
	mwNDT_Digital = 2
	mwNDT_Complex = 3
	mwNDT_FixedPoint = 4
	
	def __int__(self):
		return self.value

class mwNodeFlags(Enum):
	"""Constants that define different types of node flags."""
	mwNF_Default = 0
	mwNF_Secondary = 1
	mwNF_BlockBuffer = 2
	mwNF_ModSignal = 4
	mwNF_NoDigital = 8
	mwNF_DispLabel = 16
	mwNF_RFSignal = 32
	mwNF_AllowDataTypeChange = 64
	mwNF_RW_BiDirection = 128
	
	def __int__(self):
		return self.value

class mwDisplayModeType(Enum):
	"""Constants that define the different types of drawing object display modes."""
	mwDMT_Highlighted = 1
	mwDMT_BuddySelected = 2
	mwDMT_BuddyUnselected = 4
	mwDMT_ObjectMarked = 8
	mwDMT_ObjectCondemned = 16
	
	def __int__(self):
		return self.value

class mwPropertyDataType(Enum):
	"""Constants that define different data types of property objects."""
	mwPDT_Boolean = 0
	mwPDT_Byte = 1
	mwPDT_Integer = 2
	mwPDT_Long = 3
	mwPDT_Single = 4
	mwPDT_Double = 5
	mwPDT_Text = 6
	mwPDT_Date = 7
	
	def __int__(self):
		return self.value

class mwShapeType(Enum):
	"""Constants that define different types of shapes."""
	mwST_Rectangle = 0
	mwST_Polygon = 1
	mwST_Path = 2
	mwST_Ellipse = 3
	mwST_Text = 4
	mwST_DrillHole = 5
	mwST_Port = 6
	mwST_CellStretcher = 7
	mwST_Arc = 8
	mwST_Pin = 9
	mwST_Polyline = 10
	
	def __int__(self):
		return self.value

class mwFillStyle(Enum):
	"""Constants that define different fill style types."""
	mwFS_None = 0
	mwFS_Solid = 1
	mwFS_FineCross = 2
	mwFS_FineDiagonalCross = 3
	mwFS_InverseCross = 4
	mwFS_Checkered = 5
	mwFS_GridPoint = 6
	mwFS_InverseFineCross = 7
	mwFS_FineBackwardDiagonal = 8
	mwFS_FineForwardDiagonal = 9
	mwFS_FineHorizontal = 10
	mwFS_HeavyHorizontal = 11
	mwFS_FineVertical = 12
	mwFS_HeavyVertical = 13
	mwFS_MediumHorizontal = 14
	mwFS_MediumVertical = 15
	mwFS_CoarseGridPoint = 16
	mwFS_Brick = 17
	mwFS_DotCross = 18
	mwFS_LaceRows = 19
	mwFS_ForwardDiagonal = 20
	mwFS_BackwardDiagonal = 21
	mwFS_Horizontal = 22
	mwFS_Vertical = 23
	mwFS_Cross = 24
	mwFS_DiagonalCross = 25
	
	def __int__(self):
		return self.value

class mwLineStyle(Enum):
	"""Constants that define different line style types."""
	mwLS_Solid = 0
	mwLS_Dash = 1
	mwLS_Dot = 2
	mwLS_DashDot = 3
	mwLS_DashDotDot = 4
	
	def __int__(self):
		return self.value

class mwDrawLayerFlags(Enum):
	"""Constants that define different flags for attributes that can be set on DrawingLayer objects."""
	mwDF_Translucent = 1
	mwDF_NegativeLayer = 2
	mwDF_ShowTexture = 4
	mwDF_HatchTexture = 8
	mwDF_ContrastBackGround = 16
	mwDF_AutoGenFromPCell = 32
	mwDF_For3DPcell = 64
	mwDF_ThermalHeatSrc = 128
	
	def __int__(self):
		return self.value

class mwShapeSubObjectType(Enum):
	"""Constants that define different types of shape sub-objects."""
	mwSSO_CutoutPolygon = 0
	mwSSO_CutoutCircle = 1
	mwSSO_CutoutEllipse = 2
	
	def __int__(self):
		return self.value

class mwShapeArcDirection(Enum):
	"""Constants that define different arc segment directions."""
	mwSAD_CounterClockwise = 0
	mwSAD_Clockwise = 1
	
	def __int__(self):
		return self.value

class mwPathEndType(Enum):
	"""Constants that define different types of path ends."""
	mwPET_Various = 0
	mwPET_ExtendedHalfWidth = 1
	mwPET_Flush = 2
	mwPET_Rounded = 3
	mwPET_ExtendedUserDefined = 4
	mwPET_Chamfered = 5
	mwPET_Truncated = 6
	
	def __int__(self):
		return self.value

class mwPathMiterType(Enum):
	"""Constants that define different types of path miters."""
	mwPMT_Various = 0
	mwPMT_Square = 1
	mwPMT_Mitered = 2
	mwPMT_OffsetMitered = 3
	mwPMT_Curved = 4
	mwPMT_Rounded = 5
	mwPMT_Chamfered = 6
	
	def __int__(self):
		return self.value

class mwTextAlignment(Enum):
	"""Constants that define different types of Text alignment."""
	mwTAl_TopLeft = 1
	mwTAl_TopCenter = 2
	mwTAl_TopRight = 3
	mwTAl_CenterLeft = 4
	mwTAl_CenterCenter = 5
	mwTAl_CenterRight = 6
	mwTAl_BottomLeft = 7
	mwTAl_BottomCenter = 8
	mwTAl_BottomRight = 9
	
	def __int__(self):
		return self.value

class mwFaceAlignment(Enum):
	"""Constants that define different types of face alignments."""
	mwFA_Left = 0
	mwFA_Center = 1
	mwFA_Right = 2
	mwFA_OffsetFix = 3
	mwFA_OffsetVar = 4
	mwFA_Adapt = 5
	
	def __int__(self):
		return self.value

class mwFaceMultiLayerProperty(Enum):
	"""Constants that define different types of face multi-layer drawing properties."""
	mwFLP_Default = 0
	mwFLP_Flush = 1
	mwFLP_Inside = 2
	mwFLP_Outside = 3
	mwFLP_Bridge1 = 4
	mwFLP_Bridge2 = 5
	mwFLP_Bridge3 = 6
	mwFLP_Bridge4 = 7
	
	def __int__(self):
		return self.value

class mwFaceShapeType(Enum):
	"""Constants that define different types of face shapes, segment for faces and area for pins"""
	mwFST_SegmentFaceType = 0
	mwFST_AreaFaceType = 1
	
	def __int__(self):
		return self.value

class mwFaceGroupType(Enum):
	"""Constants that define different types of face groups"""
	mwFGT_StrongPinGroup = 0
	mwFGT_WeakPinGroup = 1
	mwFGT_MustConnectPinGroup = 2
	
	def __int__(self):
		return self.value

class mwWindowType(Enum):
	"""Constants that define the different window types."""
	mwWT_Unknown = 0
	mwWT_Datafile = 1
	mwWT_DesignNotes = 2
	mwWT_EmStructure = 3
	mwWT_EmStructure3D = 4
	mwWT_Graph = 5
	mwWT_NetList = 6
	mwWT_GlobalEquation = 7
	mwWT_OutputEquation = 8
	mwWT_Schematic = 9
	mwWT_SchematicLayout = 10
	mwWT_Schematic3DLayout = 11
	mwWT_SystemDiagram = 12
	mwWT_SystemDiagramLayout = 13
	mwWT_SystemDiagram3DLayout = 14
	mwWT_Optimizer = 15
	mwWT_LayoutCell = 16
	mwWT_EmLayoutStructure = 17
	mwWT_EmLayoutStructure3D = 18
	mwWT_EmLayoutStructureSchematic = 19
	mwWT_EmLayoutG3DStructure = 20
	
	def __int__(self):
		return self.value

class mwWindowTileDirection(Enum):
	"""Constants that define the different window tile directions."""
	mwWTD_Horizontal = 0
	mwWTD_Vertical = 1
	
	def __int__(self):
		return self.value

class mwDimensionTextLocation(Enum):
	"""Constants that define different types of text locations for dimension line objects."""
	mwDTL_CenterPar = 0
	mwDTL_CenterPer = 1
	mwDTL_RightPar = 2
	mwDTL_LeftPar = 3
	
	def __int__(self):
		return self.value

class mwDimensionArrowLocation(Enum):
	"""Constants that define different types of arrow locations for dimension line objects."""
	mwDAL_Inside = 0
	mwDAL_Outside = 1
	
	def __int__(self):
		return self.value

class mwLayoutRulerTickLocation(Enum):
	"""Constants that define different types of layout ruler tick mark locations."""
	mwLRT_AboveRuler = -1
	mwLRT_BelowRuler = 1
	
	def __int__(self):
		return self.value

class mwRouteObjectType(Enum):
	"""Constants that define different types of route object types"""
	mwROT_PathRouteObject = 0
	mwROT_ViaRouteObject = 1
	mwROT_GuideRouteObject = 2
	
	def __int__(self):
		return self.value

class mwRouteSegmentEndStyleType(Enum):
	"""Constants that define different route segment end style types"""
	mwEST_FlushEndStyle = 0
	mwEST_ExtendedEndStyle = 1
	mwEST_VariableEndStyle = 2
	mwEST_ChamferEndStyle = 3
	mwEST_CustomEndStyle = 4
	mwEST_RoundedEndStyle = 5
	mwEST_TruncateEndStyle = 6
	
	def __int__(self):
		return self.value

class mwRouteViaDirectionType(Enum):
	"""Constants that define different route via direction types"""
	mwVDT_Layer1ToLayer2ViaDirection = 0
	mwVDT_Layer2ToLayer1ViaDirection = 1
	
	def __int__(self):
		return self.value

class mwRouteSegmentEndOffsetType(Enum):
	"""Constants that define different route segment end offset style types."""
	mwEOS_NormalEndOffsetType = 0
	mwEOS_FlushEndOffsetType = 1
	mwEOS_ExtendedEndOffsetType = 2
	
	def __int__(self):
		return self.value

class mwDrawingArcDirection(Enum):
	"""Constants that define different arc segment directions."""
	mwDAD_CounterClockwise = 0
	mwDAD_Clockwise = 1
	
	def __int__(self):
		return self.value

class mwShapeNetType(Enum):
	"""Constants that define different types of networks for layout shape objects."""
	mwSNT_Normal = 0
	
	def __int__(self):
		return self.value

class mwFilletPolyOptions(Enum):
	"""Constants that define different types of filleted polygon drawing styles."""
	mwFPDS_Default = 0
	mwFPDS_SkipVertexIfTooSmall = 1
	mwFPDS_CanRemovePreFilletedVerts = 2
	
	def __int__(self):
		return self.value

class mwFilletPolyArcPtStyle(Enum):
	"""Constants that define different types of filleted polygon vertex placement styles."""
	mwFPAS_Default = 1
	
	def __int__(self):
		return self.value

class mwLayoutBoundaryType(Enum):
	"""Constants that define the different types of layout boundaries."""
	mwLBT_EmSimulationBoundaryType = 0
	
	def __int__(self):
		return self.value

class mwObjectIncludeType(Enum):
	"""Constants that define the types of objects to be included in an operation."""
	mwOIT_SelectedObjects = 0
	mwOIT_AllObjects = 1
	
	def __int__(self):
		return self.value

class mwDesignRuleType(Enum):
	"""Constants that define different types of design rule types"""
	mwDRT_Width = 0
	mwDRT_Notch = 1
	mwDRT_Jog = 2
	mwDRT_Seperation = 3
	mwDRT_Extension = 4
	mwDRT_Overlap = 5
	mwDRT_ExtensionInv = 6
	mwDRT_PolygonArea = 7
	mwDRT_Angle = 8
	mwDRT_NoHole = 9
	mwDRT_MustHaveHole = 10
	mwDRT_OnGrid = 11
	mwDRT_MaxVertices = 12
	mwDRT_MaxSideLength = 13
	mwDRT_ObjectError = 14
	mwDRT_MultiPolygon = 15
	mwDRT_Edge = 16
	mwDRT_Polygon = 17
	mwDRT_Notch_In = 18
	mwDRT_Notch_Out = 19
	mwDRT_Unknown = 20
	
	def __int__(self):
		return self.value

class mwDesignRuleState(Enum):
	"""Constants that define different types of design rule states"""
	mwDRS_Error = 0
	mwDRS_FalseError = 1
	mwDRS_CheckedError = 2
	
	def __int__(self):
		return self.value

class mwDesignRuleErrorFileFormat(Enum):
	"""Constants that define different types of DRC error file formats."""
	mwDREF_AWR = 0
	mwDREF_Calibre = 1
	mwDREF_Assura = 2
	
	def __int__(self):
		return self.value

class mwAreaAddType(Enum):
	"""Constants that define different constraints for adding objects in an area"""
	mwAAT_ContainedObjects = 0
	mwAAT_OverlappedObjects = 1
	
	def __int__(self):
		return self.value

class mwObjectNameType(Enum):
	"""Constants that define the different types of named that can be assigned to an object."""
	mwNT_NetName = 0
	mwNT_PinName = 1
	mwNT_ExtractName = 2
	
	def __int__(self):
		return self.value

class mwDesignViewType(Enum):
	"""Constants that defined different views on a design"""
	mwDVT_DesignView2D = 0
	mwDVT_DesignView3D = 1
	
	def __int__(self):
		return self.value

class mwComponentTestResultType(Enum):
	"""Constants that define the different types of component test result types."""
	mwDMT_TestRunResultData = 0
	mwDMT_TestRunPerformanceData = 1
	
	def __int__(self):
		return self.value

class mwLayoutSnapType(Enum):
	"""Constants that define different types of layout snap types."""
	mwLST_AllObjects = 0
	mwLST_SelectedOnly = 1
	
	def __int__(self):
		return self.value

class mwLayoutWindowType(Enum):
	"""Constants that define the different layout window styles."""
	mwLWT_Layout2D = 0
	mwLWT_Layout3D = 1
	
	def __int__(self):
		return self.value

class mwRouteTopologyType(Enum):
	"""Constants that define different route topologies"""
	mwRTT_NoneRouteTopology = 0
	mwRTT_StripeRouteTopology = 1
	mwRTT_StandardCellWireRouteTopology = 2
	mwRTT_IOWireRouteTopology = 3
	mwRTT_BlockWireRouteTopology = 4
	mwRTT_RingRouteTopology = 5
	mwRTT_PadRingRouteTopology = 6
	mwRTT_BlockRingRouteTopology = 7
	mwRTT_CoreWireRouteTopology = 8
	
	def __int__(self):
		return self.value

class mwRouteStatusType(Enum):
	"""Constants that define different route status types"""
	mwRST_NormalRouteStatus = 0
	mwRST_FixedRouteStatus = 1
	mwRST_LockedRouteStatus = 2
	
	def __int__(self):
		return self.value

class mwRouteBendStyleType(Enum):
	"""Constants that define different types of bend styles for route objects."""
	mwBS_SquareBendStyle = 0
	mwBS_MiterBendStyle = 1
	mwBS_CurveBendStyle = 2
	mwBS_ChamferBendStyle = 3
	mwBS_RoundedBendStyle = 4
	
	def __int__(self):
		return self.value

class mwNetViaMode(Enum):
	"""Constants that define different types of via modes."""
	mwNVM_FullVias = 0
	mwNVM_MinimalVias = 1
	mwNVM_ManualVias = 2
	mwNVM_SemiAutoVias = 3
	mwNVM_Minimal2Vias = 4
	
	def __int__(self):
		return self.value

class mwRouteConnModel(Enum):
	"""Constants that define different types of route-to-route connection models for a physical net."""
	mwRCM_UseProjectDefault = 0
	mwRCM_CenterlineConnectionModel = 1
	mwRCM_CenterLineAndAdjacentModel = 2
	
	def __int__(self):
		return self.value

class mwViewFrom(Enum):
	"""Constants that define the different predefined view from perspectives in a 3D view"""
	mwVF_Ortho = 0
	mwVF_Top = 1
	mwVF_Front = 2
	mwVF_Back = 3
	mwVF_Left = 4
	mwVF_Right = 5
	mwVF_Bottom = 6
	mwVF_None = 7
	
	def __int__(self):
		return self.value

class mwViewAutoRotate(Enum):
	"""Constants that define the different modes for auto rotation within a 3D view."""
	mwVAW_RotateNone = 0
	mwVAW_RotateNormal = 1
	mwVAW_RotateChangeSlope = 2
	
	def __int__(self):
		return self.value

class mwViewVisual(Enum):
	"""Constants that define the different predefined visual modes in a 3D view."""
	mwVV_WireFrame = 1
	mwVV_Shaded = 2
	mwVV_ShowEdges = 4
	mwVV_Texturing = 8
	mwVV_AntiAliased = 16
	mwVV_ExtrudedOnly = 32
	mwVV_ShapesMerged = 64
	mwVV_ShapesSelected = 128
	mwVV_Stippling = 256
	
	def __int__(self):
		return self.value

class mwLVSHighlightLoc(Enum):
	"""Constants that define where an LVS SchematicHighlight item should be highlighted."""
	mwLVSHL_NoHighlighting = 0
	mwLVSHL_HighlightInSchematic = 1
	mwLVSHL_HighlightInLayout = 2
	mwLVSHL_HighlightInSchemAndLay = 3
	
	def __int__(self):
		return self.value

class mwShapeModifierType(Enum):
	"""Constants that define the different types of shape modifiers."""
	mwMD_ShapeModifier = 0
	mwMD_GlobalModifier = 1
	
	def __int__(self):
		return self.value

class mwShapeModifierPriority(Enum):
	"""Constants that define the different types of modifier priority levels."""
	mwSMP_NormalShape = 1
	mwSMP_FlattenShape = 2
	mwSMP_GlobalModifier = 3
	mwSMP_ShapeProcessor = 4
	
	def __int__(self):
		return self.value

class mwEMPortType(Enum):
	"""Constants that define the different types of EM ports."""
	mwEMP_None = 1
	mwEMP_Left = 2
	mwEMP_Bottom = 3
	mwEMP_Right = 4
	mwEMP_Top = 5
	mwEMP_CenterX = 6
	mwEMP_CenterY = 7
	mwEMP_Via = 8
	mwEMP_GapX = 9
	mwEMP_GapY = 10
	mwEMP_FullLine = 11
	mwEMP_HalfLine = 12
	mwEMP_PinPad = 13
	
	def __int__(self):
		return self.value

class mwEMGroupType(Enum):
	"""Constants that define the different types of EM port group types."""
	mwEMG_None = 0
	mwEMG_NoneOld = 1
	mwEMG_Series = 2
	mwEMG_Mutual = 3
	mwEMG_Coupled = 4
	
	def __int__(self):
		return self.value

class mwEMPortFlags(Enum):
	"""Constants that define flags which can be used in the EM port flags field."""
	mwEMF_Default = 0
	mwEMF_EdgeToGround = 1
	mwEMF_ExtendUpward = 2
	mwEMF_ExtendAsMetal = 4
	mwEMF_ExtendUpDown = 8
	mwEMF_LumpedPredefined = 16
	mwEMF_Auto = 32
	mwEMF_Wave = 64
	mwEMF_WaveCustomExtent = 128
	mwEMF_LumpedDifferential = 256
	mwEMF_EndOfTypes = 512
	
	def __int__(self):
		return self.value

class mwEMShapePortType(Enum):
	"""Constants that define the different types of EM shape port types."""
	mwSPT_EdgePort = 1
	mwSPT_InternalPort = 2
	mwSPT_ViaPort = 3
	mwSPT_PinPadPort = 4
	
	def __int__(self):
		return self.value

class mwCoordEntryMode(Enum):
	"""Constants that define the different bits that can be set in a coordinate entry mode value."""
	mwCE_None = 0
	mwCE_SpecifyPoint = 1
	mwCE_UpFollowsDown = 2
	mwCE_FirstPoint = 4
	mwCE_SegmentInfo = 8
	mwCE_RadiusMode = 16
	
	def __int__(self):
		return self.value

class mwPlacementJustfication(Enum):
	"""Constants that define the different types of placement justification styles."""
	mwPJ_BBoxCenter = 0
	mwPJ_BBoxUpperLeft = 1
	mwPJ_BBoxLowerLeft = 2
	mwPJ_BBoxUpperRight = 3
	mwPJ_BBoxLowerRight = 4
	mwPJ_SameOrigin = 5
	
	def __int__(self):
		return self.value

class mwUnionShapesType(Enum):
	"""Constants that define the different types of shape union types."""
	mwUST_UnionOnExistingLayers = 0
	mwUST_UnionToDestinationLayer = 1
	
	def __int__(self):
		return self.value

class mwIntersectShapesType(Enum):
	"""Constants that define the different types of shape intersection types."""
	mwIST_IntersectOnExistingLayers = 0
	mwIST_IntersectToDestinationLayer = 1
	
	def __int__(self):
		return self.value

class mwExclusiveOrShapesType(Enum):
	"""Constants that define the different types of shape exclusive or types."""
	mwEST_ExclusiveOrOnExistingLayers = 0
	mwEST_ExclusiveOrOnDestinationLayer = 1
	
	def __int__(self):
		return self.value

class mwCellExportFormat(Enum):
	"""Constants that define different types of cell export formats."""
	mwCEF_GDSII = 0
	mwCEF_DXF = 1
	
	def __int__(self):
		return self.value

class mwCellRenameSyncType(Enum):
	"""Constants that define different types of updates that should be performed when a cell in a library is renamed."""
	mwCRT_DontSynchronize = 0
	mwCRT_SynchronizeLibrary = 1
	mwCRT_SynchronizeAllLibraries = 2
	
	def __int__(self):
		return self.value

class mwCellStatus(Enum):
	"""Constants that define the different types of flags which may be included in the cell status field."""
	mwCES_FromProject = 1
	mwCES_LibDeleted = 2
	mwCES_NewerCellAvail = 4
	mwCES_CellModified = 8
	mwCES_CellCondemned = 16
	
	def __int__(self):
		return self.value

class mwLayoutParamDataType(Enum):
	"""Constants that define the data types of a LayoutParameter."""
	mwLPDT_Real = 0
	mwLPDT_Integer = 1
	mwLPDT_String = 2
	mwLPDT_RealVector = 3
	mwLPDT_IntVector = 4
	
	def __int__(self):
		return self.value

class mwDrawingSubObjectType(Enum):
	"""Constants that define different types of drawing sub-objects."""
	mwDSO_CutoutPolygon = 0
	mwDSO_CutoutCircle = 1
	mwDSO_CutoutEllipse = 2
	
	def __int__(self):
		return self.value

class mwObjectSelectFilters(Enum):
	"""Constants that define bits for specific object types for restricting selection"""
	mwOSF_None = 0
	mwOSF_Graphics = 1
	mwOSF_Equation = 2
	mwOSF_Text = 4
	mwOSF_CommonElement = 8
	mwOSF_Wire = 16
	mwOSF_Annotation = 32
	mwOSF_iNet = 64
	mwOSF_MovableProbe = 128
	mwOSF_LayCell = 256
	mwOSF_SubCell = 512
	mwOSF_ParamFrame = 1024
	mwOSF_BySize = 2048
	mwOSF_CellPort = 4096
	mwOSF_AreaPin = 8192
	mwOSF_LayPort = 16384
	mwOSF_ByPositionFixed = 32768
	mwOSF_BySize2 = 65536
	mwOSF_ArtworkCell = 131072
	mwOSF_EMPort = 262144
	mwOSF_EMSubCell = 524288
	mwOSF_LayModifier = 1048576
	mwOSF_ExtractPin = 2097152
	mwOSF_Polygon = 4194304
	mwOSF_Path = 8388608
	mwOSF_Circle = 16777216
	mwOSF_PinObject = 28672
	mwOSF_InstObject = 768
	
	def __int__(self):
		return self.value

class mwElementType(Enum):
	"""Constants that define different types of elements."""
	mwET_Circuit = 0
	mwET_System = 1
	
	def __int__(self):
		return self.value

class mwSubcktGroundType(Enum):
	"""Constants that define different types of sub-circuit grounding."""
	mwSG_Normal = 0
	mwSG_Explicit = 1
	mwSG_Balanced = 2
	
	def __int__(self):
		return self.value

class mwModelParseType(Enum):
	"""Constants that define different types of model parse types."""
	mwMPT_Unknown = 0
	mwMPT_AWRNet = 1
	mwMPT_AWRModel = 2
	mwMPT_LibraModel = 3
	mwMPT_MWHarmModel = 4
	mwMPT_HSPICE_trans = 5
	mwMPT_HSPICE_native = 6
	mwMPT_PSpice = 7
	mwMPT_Touchstone = 8
	mwMPT_MMICAD = 9
	
	def __int__(self):
		return self.value

class mwSchematicExportFormat(Enum):
	"""Constants that define different types of schematic export formats."""
	mwSEF_MWOSchematicFile = 0
	mwSEF_JsonFile = 1
	
	def __int__(self):
		return self.value

class mwSchematicNetlistExportFormat(Enum):
	"""Constants that define different types of schematic netlist export formats."""
	mwNEF_MWONetlistFile = 0
	
	def __int__(self):
		return self.value

class mwDrawingShapeType(Enum):
	"""Constants that define different types of drawing shape objects."""
	mwDST_Unknown = 0
	mwDST_Line = 1
	mwDST_Arc = 2
	mwDST_Polygon = 3
	mwDST_Polyline = 4
	mwDST_Text = 5
	mwDST_Ellipse = 6
	mwDST_Rectangle = 7
	mwDST_Arrow = 8
	mwDST_RichText = 9
	
	def __int__(self):
		return self.value

class mwDiagramLockLevel(Enum):
	"""Constants that define different types of lock levels for schematic and system diagrams"""
	mwDLL_Unlocked = 0
	mwDLL_LockedForEdit = 1
	mwDLL_LockedForViewing = 2
	
	def __int__(self):
		return self.value

class mwEmbeddedDocType(Enum):
	"""Values that define different embedded document types."""
	mwEDT_Unknown = 0
	mwEDT_Schematic = 1
	mwEDT_SchematicLayout = 2
	mwEDT_SchematicLayout3D = 3
	mwEDT_EMLayout = 4
	mwEDT_EMLayout3D = 5
	mwEDT_SystemDiagram = 6
	mwEDT_Graph = 7
	
	def __int__(self):
		return self.value

class mwTestPointType(Enum):
	"""Constants that define the different types of test point objects."""
	mwTPT_NL_Linear = 0
	mwTPT_NL_Element = 1
	mwTPT_V_Source = 2
	mwTPT_I_Source = 3
	mwTPT_V_Meter = 4
	mwTPT_I_Meter = 5
	mwTPT_P_Meter = 6
	mwTPT_CurveTracer = 7
	mwTPT_ControlElement = 8
	mwTPT_OscAnalysis = 9
	mwTPT_OscTuning = 10
	mwTPT_NoiseControl = 11
	mwTPT_V_Noise = 12
	mwTPT_I_Noise = 13
	
	def __int__(self):
		return self.value

class mwTestPointFlags(Enum):
	"""Constants that define the different types of component test point flags."""
	mwTPF_InternalComp = 1
	mwTPF_Node = 2
	mwTPF_Port = 4
	mwTPF_Subcircuit = 8
	mwTPF_Secondary = 16
	mwTPF_Instance = 32
	mwTPF_ChargeSrc = 64
	mwTPF_CurrentSrc = 128
	mwTPF_NonlinModel = 256
	mwTPF_CurveTracer = 512
	mwTPF_NoiseMeasure = 1024
	mwTPF_OpPoint = 2048
	
	def __int__(self):
		return self.value

class mwSimStateFlags(Enum):
	"""Constants that define flags for the different types of simulation dirty states."""
	mwSSF_SimClean = 0
	mwSSF_SimStructureDirty = 1
	mwSSF_SimFrequencyDirty = 2
	mwSSF_ParameterDirty = 8
	mwSSF_NeedsUpdate = 16
	
	def __int__(self):
		return self.value

class mwSystemExportFormat(Enum):
	"""Constants that define different types of system export formats."""
	mwSYF_MWOSystemFile = 0
	mwSYF_JsonFile = 1
	
	def __int__(self):
		return self.value

class mwHatchStyle(Enum):
	"""Constants that define different types of Hatch fill styles."""
	mwHS_None = 0
	mwHS_Solid = 1
	mwHS_Horizontal = 2
	mwHS_Vertical = 3
	mwHS_ForwardDiagonal = 4
	mwHS_BackwardDiagonal = 5
	mwHS_Cross = 6
	mwHS_DiagonalCross = 7
	
	def __int__(self):
		return self.value

class mwBoundaryModelType(Enum):
	"""Constants that define different types of boundary models."""
	mwBMT_PerfectConductor = 0
	mwBMT_SpecifiedMaterial = 1
	mwBMT_ApproximateOpen = 2
	mwBMT_InfiniteWaveguide = 3
	mwBMT_ReadConductor = 4
	mwBMT_Dielectric = 5
	
	def __int__(self):
		return self.value

class mwEmSimulator(Enum):
	"""Constants that define the different types of electromagnetic simulators."""
	mwEMS_AwrAxiem = 0
	mwEMS_AwrAxiem32 = 1
	mwEMS_AwrAxiem64 = 2
	mwEMS_AwrEmSight = 3
	mwEMS_AwrAnalyst = 4
	mwEMS_AwrAce = 5
	mwEMS_SonnetEm = 6
	mwEMS_ZelandIe3d = 7
	mwEMS_OeaNetan = 8
	mwEMS_CST = 9
	mwEMS_HFSSAsync = 10
	mwEMS_CSTAsync = 11
	mwEMS_SonnetAsync = 12
	mwEMS_ClarityAsync = 13
	mwEMS_CelsiusAsync = 14
	mwEMS_EMXAsync = 15
	
	def __int__(self):
		return self.value

class mwEMInputDataXMLType(Enum):
	"""Constants that define the different types of XML Input Data formats."""
	mwEIX_EMSocketDataFile = 0
	mwEIX_EMSocketSimplifiedDataFile = 1
	
	def __int__(self):
		return self.value

class mwMaterialType(Enum):
	"""Constants that define the different types of Materials."""
	mwMT_Begin = 0
	mwMT_RealCond = 1
	mwMT_PEC_Cond = 2
	mwMT_Dielectric = 3
	mwMT_BoundNone = 4
	mwMT_BoundPEC = 5
	mwMT_BoundPMW = 6
	mwMT_BoundABS = 7
	mwMT_BoundSI = 8
	mwMT_BoundElectricSymmetry = 9
	mwMT_BoundMagneticSymmetry = 10
	mwMT_BoundPML = 11
	mwMT_End = 12
	
	def __int__(self):
		return self.value

class mwMaterialProperties(Enum):
	"""Constants that define the different types of Material properties."""
	mwMP_Er = 1
	mwMP_ErX = 2
	mwMP_ErY = 4
	mwMP_ErZ = 8
	mwMP_Tand = 16
	mwMP_TandX = 32
	mwMP_TandY = 64
	mwMP_TandZ = 128
	mwMP_Ur = 256
	mwMP_UrX = 512
	mwMP_UrY = 1024
	mwMP_UrZ = 2048
	mwMP_Tanm = 4096
	mwMP_TanmX = 8192
	mwMP_TanmY = 16384
	mwMP_TanmZ = 32768
	mwMP_Sigma = 65536
	mwMP_SigmaX = 131072
	mwMP_SigmaY = 262144
	mwMP_SigmaZ = 524288
	mwMP_SigmaMagnetic = 1048576
	mwMP_SigmaMagneticX = 2097152
	mwMP_SigmaMagneticY = 4194304
	mwMP_SigmaMagneticZ = 8388608
	mwMP_DC_Resistance = 16777216
	mwMP_RF_Impedance = 33554432
	mwMP_ExcessImagImped = 67108864
	mwMP_EndOfTypes = 134217728
	mwMP_DielMatlDefault = 65553
	mwMP_MetalMatlPropDefault = 117506048
	mwMP_MatlPropMin = 0
	mwMP_MatlPropMax = 536870911
	
	def __int__(self):
		return self.value

class mw3DCadFileType(Enum):
	"""Constants that define the different types of 3D CAD files that can be exported from a 3D EMStructure object."""
	mw3DC_SATFileType = 0
	
	def __int__(self):
		return self.value

class mwGraphType(Enum):
	"""Constants that define different types of graphs."""
	mwGT_RectangularComplex = 0
	mwGT_Polar = 1
	mwGT_SmithChart = 2
	mwGT_Rectangular = 3
	mwGT_Tabular = 4
	mwGT_Antenna = 5
	mwGT_Histogram = 6
	mwGT_ThreeDim = 7
	mwGT_Constellation = 8
	
	def __int__(self):
		return self.value

class mwMeasDataType(Enum):
	"""Constants that define different measurement data types."""
	mwMDT_UnKnown = 0
	mwMDT_ReflectionData = 1
	mwMDT_AdmittanceData = 2
	mwMDT_ImpedanceData = 3
	mwMDT_GainCircleData = 4
	mwMDT_NoiseData = 5
	mwMDT_StabilityData = 6
	mwMDT_CurveTraceData = 7
	mwMDT_SpectrumData = 8
	mwMDT_SourceMapData = 9
	mwMDT_HistogramData = 10
	mwMDT_MultiTraceData = 11
	mwMDT_LoadPullContour = 12
	mwMDT_DiscreteTimeData = 13
	
	def __int__(self):
		return self.value

class mwThickness(Enum):
	"""Constants that define the thickness of a line or trace."""
	mwHairline = 1
	mwThin = 2
	mwMedium = 3
	mwThick = 4
	mwFat = 5
	
	def __int__(self):
		return self.value

class mwScaleType(Enum):
	"""Constants that define the type of scale of an Axis object."""
	mwScaleLinear = 1
	mwScaleLogarithmic = 2
	
	def __int__(self):
		return self.value

class mwDashStyle(Enum):
	"""Constants that define the dash styles of a line."""
	mwLineSolid = 1
	mwLineThick = 2
	mwLineThin = 3
	mwLineThickThin = 4
	
	def __int__(self):
		return self.value

class mwTraceSymbols(Enum):
	"""Constants that define the different symbols for traces objects."""
	mwSymbolTriangle = 1
	mwSymbolSquare = 2
	mwSymbolDiamond = 3
	mwSymbolRomanX = 4
	mwSymbolHorizontalBar = 5
	mwSymbolVerticalBar = 6
	mwSymbolForwardSlash = 7
	mwSymbolBackSlash = 8
	mwSymbolArrow = 9
	mwSymbolCircle = 10
	mwSymbolSmallX = 11
	mwSymbolCross = 12
	
	def __int__(self):
		return self.value

class mwPlotAxis(Enum):
	"""Constants that define different axes for plotting."""
	mwPA_Left = 0
	mwPA_Right = 1
	
	def __int__(self):
		return self.value

class mwTraceStyle(Enum):
	"""Constants that define different styles for a graph trace object."""
	mwTraceStyleAuto = 1
	mwTraceStyleLinear = 2
	mwTraceStyleScatter = 3
	mwTraceStyleSpectral = 4
	mwTraceStyleHistogram = 5
	mwTraceStyleDigital = 6
	mwTraceStyleSampled = 7
	mwTraceStyleVariationBars = 8
	
	def __int__(self):
		return self.value

class mwTraceSteppedColorStyle(Enum):
	"""Constants that define different stepped color styles for a graph trace object."""
	mwSteppedColorStyleNone = 1
	mwSteppedColorStyleStepped = 2
	mwSteppedColorStyleGradient = 3
	mwSteppedColorStyleGradientRed = 4
	mwSteppedColorStyleGradientGreen = 5
	mwSteppedColorStyleGradientBlue = 6
	mwSteppedColorStyleShaded = 7
	
	def __int__(self):
		return self.value

class mwLegendFrameResizeTypes(Enum):
	"""Constants that define the types of graph legend resize styles."""
	mwLFR_TextFitsFrame = 0
	mwLFR_FrameFitsText = 1
	
	def __int__(self):
		return self.value

class mwLegendFormatTypes(Enum):
	"""Constants that define the different type of legend entry format styles."""
	mwLFT_DataNames = 0
	mwLFT_MeasurementNames = 1
	mwLFT_MeasurementAndDataNames = 2
	
	def __int__(self):
		return self.value

class mwMarkerSearchMode(Enum):
	"""Constants that define different search modes for markers."""
	mwMST_Absolute = 0
	mwMST_Delta = 1
	
	def __int__(self):
		return self.value

class mwMarkerSearchDirection(Enum):
	"""Constants that define different search directions for markers."""
	mwMSD_SearchRight = 0
	mwMSD_SearchLeft = 1
	
	def __int__(self):
		return self.value

class mwMarkerSearchVariable(Enum):
	"""Constants that define different search variable types for markers."""
	mwMSV_X = 0
	mwMSV_Y = 1
	mwMSV_SWP = 2
	
	def __int__(self):
		return self.value

class mwMarkerType(Enum):
	"""Constants that define different types of graph markers."""
	mwMT_Normal = 0
	mwMT_Parameter = 1
	mwMT_DataSet = 2
	mwMT_AutoSearch = 3
	mwMT_Offset = 4
	
	def __int__(self):
		return self.value

class mwMarkerAutoSearchMode(Enum):
	"""Constants that define different auto-search marker modes."""
	mwMAM_Max = 0
	mwMAM_Min = 1
	mwMAM_Peak = 2
	mwMAM_Valley = 3
	mwMAM_Value = 4
	mwMAM_XIndex = 5
	
	def __int__(self):
		return self.value

class mwMarkerOffsetMode(Enum):
	"""Constants that define different offset marker modes."""
	mwMOM_X = 0
	mwMOM_Y = 1
	
	def __int__(self):
		return self.value

class mwMarkerOffsetSearchDir(Enum):
	"""Constants that define the search direction for y-offset markers."""
	mwMOD_Left = 0
	mwMOD_Right = 1
	mwMOD_Default = 2
	
	def __int__(self):
		return self.value

class mwMarkerSymbolType(Enum):
	"""Constants that define different types of marker symbols."""
	mwMST_None = 0
	mwMST_TriangleUp = 1
	mwMST_Rectangle = 2
	mwMST_Diamond = 3
	mwMST_HourGlass = 4
	mwMST_LineHorizontal = 5
	mwMST_LineVertical = 6
	mwMST_LineUpDiagonal = 7
	mwMST_LineDownDiagonal = 8
	mwMST_TriangleDown = 9
	mwMST_Circle = 10
	mwMST_Cross = 11
	mwMST_Plus = 12
	
	def __int__(self):
		return self.value

class mwGraphMarkerType(Enum):
	"""Constants that define different output data types for graph cursors and markers."""
	mwGMT_ReflectionCoefficient = 0
	mwGMT_Impdedence = 1
	mwGMT_Admittance = 2
	mwGMT_Unknown = 3
	
	def __int__(self):
		return self.value

class mwGraphMarkerFormat(Enum):
	"""Constants that define different output formats for graph cursors and markers."""
	mwGMF_RealImaginary = 0
	mwGMF_MagnitudeAngle = 1
	mwGMF_DbMagnitudeAngle = 2
	
	def __int__(self):
		return self.value

class mwPrecisionMode(Enum):
	"""Constants that define the different types of precision display modes."""
	mwPM_Auto = 1
	mwPM_Manual = 2
	
	def __int__(self):
		return self.value

class mwPrecisionStyle(Enum):
	"""Constants that define the different types of precision display styles."""
	mwPS_FixedSigFigures = 1
	mwPS_FixedRightDecimal = 2
	mwPS_Scientific = 3
	
	def __int__(self):
		return self.value

class mwLineMarkerType(Enum):
	"""Constants that define different types of LineMarker objects."""
	mwLM_HorizontalLineMarker = 1
	mwLM_VerticalLineMarker = 2
	
	def __int__(self):
		return self.value

class mwLineMarkerTrackType(Enum):
	"""Constants that define different types of LineMarker track types."""
	mwLMT_XAxis = 1
	mwLMT_LeftYAxis = 2
	mwLMT_RightYAxis = 3
	
	def __int__(self):
		return self.value

class mwDataFileType(Enum):
	"""Constants that define different types of data files."""
	mwDFT_SNP = 0
	mwDFT_RAW = 1
	mwDFT_IV = 2
	mwDFT_TXT = 3
	mwDFT_MDIF = 4
	mwDFT_GMDIF = 5
	mwDFT_DSCR = 6
	mwDFT_GMDIFD = 7
	
	def __int__(self):
		return self.value

class mwOutputFilePortParameterType(Enum):
	"""Constants that define different types of output port parameter types."""
	mwOFP_SParameter = 0
	mwOFP_YParameter = 1
	mwOFP_ZParameter = 2
	mwOFP_GParameter = 3
	mwOFP_HParameter = 4
	
	def __int__(self):
		return self.value

class mwOutputFilePortParameterFormat(Enum):
	"""Constants that define different types of output parameter formats."""
	mwOFF_Real_Imaginary = 0
	mwOFF_Magnitude_Angle = 1
	mwOFF_DB_Magnitude_Angle = 2
	
	def __int__(self):
		return self.value

class mwOutputFilePortParameterFreqUnits(Enum):
	"""Constants that define different types of output parameter frequency units."""
	mwOFU_Hz = 0
	mwOFU_kHz = 1
	mwOFU_MHz = 2
	mwOFU_GHz = 3
	mwOFU_THz = 4
	
	def __int__(self):
		return self.value

class mwOutputFileLineEndFormat(Enum):
	"""Constants that define different types of output file line ends."""
	mwOFE_NormalLineEnd = 0
	mwOFE_DOSFormatLineEnd = 1
	
	def __int__(self):
		return self.value

class mwCellLibraryType(Enum):
	"""Constants that define the different cell library types."""
	mwCLT_GDSII = 0
	mwCLT_DXF = 1
	mwCLT_OA = 2
	
	def __int__(self):
		return self.value

class mwCellLibraryStatus(Enum):
	"""Constants that define the different types of flags which may be included in the cell library status field."""
	mwCLS_IncProjCells = 1
	mwCLS_FileNotFound = 2
	mwCLS_NoLinkedFile = 4
	mwCLS_LockLibrary = 8
	mwCLS_DontWriteCellWhenExport = 16
	mwCLS_ReadNewest = 32
	mwCLS_ReplaceAllCells = 64
	mwCLS_Dxf_Cell_Lib = 128
	mwCLS_InvalidFileFormat = 256
	mwCLS_Oa_Cell_Lib = 512
	mwCLS_NeverSaveCells = 1024
	mwCLS_AlwaysSaveCells = 2048
	mwCLS_AllowPathBasedExtraction = 4096
	mwCLS_IncludesRenamedDeletedCells = 8192
	mwCLS_NotSearchable = 16384
	
	def __int__(self):
		return self.value

class mwOptGoalType(Enum):
	"""Constants that define different types of optimization goals."""
	mwOGT_Equals = 0
	mwOGT_LessThan = 1
	mwOGT_GreaterThan = 2
	
	def __int__(self):
		return self.value

class mwLayoutExportFormat(Enum):
	"""Constants that define different types of layout export formats."""
	mwLEF_GDSII_Hierarchical = 0
	mwLEF_GDSII_Flat = 1
	mwLEF_DXF = 2
	mwLEF_Gerber = 3
	mwLEF_DrillFile = 4
	mwLEF_Pads = 5
	
	def __int__(self):
		return self.value

class mwCrossoverRuleFlags(Enum):
	"""Constants that define the different types of CrossoverRule flags."""
	mwCRF_ExtendHalfWidthEnds = 1
	
	def __int__(self):
		return self.value

class mwViaSpacingType(Enum):
	"""Constants that define the different types of via spacings for via fill entries and via fence entries."""
	mwVST_CenterToCenter = 0
	mwVST_EdgeToEdge = 1
	
	def __int__(self):
		return self.value

class mwViaFillStaggerMode(Enum):
	"""Constants that define the different types of via stagger mode for via fill entries."""
	mwVSM_StaggerNone = 0
	mwVSM_StaggerRows = 1
	mwVSM_StaggerColumns = 2
	
	def __int__(self):
		return self.value

class mwViaAlignType(Enum):
	"""Constants that define the different types of via alignments for via fill entries."""
	mwVAT_ConstantSpacing = 0
	mwVAT_ConstantClearance = 1
	
	def __int__(self):
		return self.value

class mwUnitMultType(Enum):
	"""Constants that define different types of multipliers."""
	mwUMT_f = 0
	mwUMT_p = 1
	mwUMT_n = 2
	mwUMT_u = 3
	mwUMT_m = 4
	mwUMT_c = 5
	mwUMT_none = 6
	mwUMT_k = 7
	mwUMT_Mega = 8
	mwUMT_Giga = 9
	mwUMT_Tera = 10
	mwUMT_mil = 11
	mwUMT_inch = 12
	mwUMT_feet = 13
	mwUMT_mile = 14
	mwUMT_DegC = 15
	mwUMT_DegK = 16
	mwUMT_DegF = 17
	mwUMT_Rad = 18
	mwUMT_Deg = 19
	mwUMT_dbm = 20
	mwUMT_dbw = 21
	
	def __int__(self):
		return self.value

class mwVoidFlagType(Enum):
	"""Constants that define the different flags that can be set for the voiding options."""
	mwVDF_None = 0
	mwVDF_IsDynShape = 1
	mwVDF_NonDefault = 2
	mwVDF_PinVoidInline = 4
	mwVDF_Round = 8
	mwVDF_FullRound = 16
	mwVDF_AnyRound = 24
	mwVDF_ShowTopDynOnly = 32
	
	def __int__(self):
		return self.value

class mwConstraintSetType(Enum):
	"""Constants that define the different types of constraint set types."""
	mwCST_Spacing = 0
	mwCST_SameNetSpacing = 1
	mwCST_NetOnly = 2
	
	def __int__(self):
		return self.value

class mwConstraintInfoType(Enum):
	"""Constants that define the different types of constraint info types."""
	mwCIT_AllTypes = -1
	mwCIT_Line = 0
	mwCIT_ThruPin = 1
	mwCIT_SMDPin = 2
	mwCIT_TestPin = 3
	mwCIT_ThroughVia = 4
	mwCIT_BBVia = 5
	mwCIT_MicroVia = 6
	mwCIT_TestVia = 7
	mwCIT_Shape = 8
	mwCIT_BondFinger = 9
	mwCIT_Hole = 10
	mwCIT_END = 11
	mwCIT_PIN = 12
	mwCIT_VIA = 13
	mwCIT_MIN_BVIA_GAP = 14
	mwCIT_END_ALL = 15
	
	def __int__(self):
		return self.value

class mwNetlistType(Enum):
	"""Constants that define different types of netlists."""
	mwNLT_AWR = 0
	mwNLT_SPICE = 1
	mwNLT_PSPICE = 1
	mwNLT_TSTONE = 2
	mwNLT_Touchstone = 2
	mwNLT_HSPICE = 3
	mwNLT_HSPICE_NATIVE = 4
	mwNLT_Native_HSPICE = 4
	mwNLT_Native_APLAC = 7
	mwNLT_Spectre = 8
	mwNLT_HSPICE2 = 10
	
	def __int__(self):
		return self.value

class mwYieldGoalType(Enum):
	"""Constants that define different types of yield goals."""
	mwYGT_LessThan = 0
	mwYGT_GreaterThan = 1
	
	def __int__(self):
		return self.value

class mwSymbolShapeType(Enum):
	"""Constants that define different types of symbol shapes."""
	mwSST_Line = 0
	mwSST_Arc = 1
	mwSST_Polygon = 2
	mwSST_Path = 3
	mwSST_Text = 4
	mwSST_Ellipse = 5
	mwSST_Node = 6
	mwSST_Polyline = 7
	mwSST_MetaText = 8
	
	def __int__(self):
		return self.value

class mwSymbolType(Enum):
	"""Constants that define different types of symbol categories like project or system symbols"""
	mwST_SystemSymbolType = 0
	mwST_ProjectSymbolType = 1
	
	def __int__(self):
		return self.value

class mwSymbolSelectMode(Enum):
	"""Constants that define different types of symbol select modes."""
	mwSM_NormalSelect = 0
	mwSM_EdgeSelect = 1
	
	def __int__(self):
		return self.value

class mwErrorType(Enum):
	"""Constants that define different types of errors."""
	mwET_None = 0
	mwET_Warning = 1
	mwET_Error = 2
	mwET_Fatal = 3
	
	def __int__(self):
		return self.value

class mwEMInitType(Enum):
	"""Constants that define the different types of EMStructure initialization types."""
	mwEMI_Stackup = 0
	mwEMI_LPF = 1
	mwEMI_Default = 2
	
	def __int__(self):
		return self.value

class mwModelPriorityType(Enum):
	"""Constants that define different types of priorities for Model objects."""
	mwMPT_UNINIT = 0
	mwMPT_ALL = 1
	mwMPT_WIRE = 2
	mwMPT_LINEAR = 3
	mwMPT_TUNEOPT = 4
	mwMPT_MEAS = 5
	mwMPT_NONLINEAR = 6
	mwMPT_SOURCE = 7
	mwMPT_IO = 8
	mwMPT_GROUND = 9
	mwMPT_ISOLATED = 10
	mwMPT_SINK = 11
	
	def __int__(self):
		return self.value

class mwModelPropertyFlags(Enum):
	"""Constants that define different bits for model flag types."""
	mwEF_Default = 0
	mwEF_HideName = 1
	mwEF_HasNoiseModel = 4
	mwEF_SupportsTxSynth = 8
	mwEF_Highlightable = 16
	mwEF_NonMeasureable = 32
	mwEF_ConnectToSim = 64
	mwEF_UseUniqueSim = 128
	mwEF_AggregateModel = 256
	mwEF_SpecSampleRate = 512
	mwEF_IsSysSimModel = 1024
	mwEF_HideModel = 2048
	mwEF_UseSimInstId = 4096
	mwEF_DC_Source = 8192
	mwEF_MultiBranch = 16384
	mwEF_NoAddIdInName = 32768
	mwEF_ExtractBlock = 65536
	mwEF_DynamicModel = 131072
	mwEF_IsDynamicRecord = 262144
	mwEF_ExtractedElement = 524288
	mwEF_IncludeInTopOnly = 1048576
	mwEF_AllowDuplicates = 2097152
	mwEF_ForceSimulate = 4194304
	mwEF_HasProfileInfo = 8388608
	mwEF_LockFromView = 16777216
	mwEF_EnableChildSim = 33554432
	mwEF_SimDocRef = 67108864
	mwEF_PartialEmExtraction = 134217728
	mwEF_ExtractFromSelf = 268435456
	
	def __int__(self):
		return self.value

class mwMeasInfoParamFlags(Enum):
	"""Constants that define the different types of MeasurementInfo parameter flags"""
	mwMIP_BackAnnotation = 1
	mwMIP_EM_Annotation = 2
	mwMIP_Sys_Annotation = 4
	mwMIP_ERC_Annotation = 8
	mwMIP_CurrentVisualize = 16
	mwMIP_SupportAnimation = 32
	mwMIP_LayoutAnnotation = 64
	mwMIP_OnlyUpdateIfSimClean = 128
	mwMIP_PassInfoToSim = 256
	mwMIP_NoSimResultsUsed = 512
	mwMIP_DbByDefault = 1024
	mwMIP_IsAnnotation = 79
	mwMIP_FileOutput = 2048
	mwMIP_SynthMeas = 4096
	mwMIP_Hidden = 8192
	
	def __int__(self):
		return self.value

class mwLibraryElementType(Enum):
	"""Constants that define the different types of library elements."""
	mwLET_Unknown = 0
	mwLET_Model = 1
	mwLET_XML = 2
	mwLET_DataFile = 3
	mwLET_Subcircuit = 4
	
	def __int__(self):
		return self.value

class mwDockBorder(Enum):
	"""Constants that define the locations that a window can be docked to."""
	mwDB_Top = 1
	mwDB_Bottom = 2
	mwDB_Left = 3
	mwDB_Right = 4
	
	def __int__(self):
		return self.value

class mwDockState(Enum):
	"""Constants that define the different dockable states of a window."""
	mwDS_Docked = 1
	mwDS_Floating = 2
	mwDS_Normal = 3
	
	def __int__(self):
		return self.value

class mwHotKeyFlags(Enum):
	"""Constants that define the different flags for hotkeys."""
	mwHKF_VirtKey = 1
	mwHKF_NoInvert = 2
	mwHKF_ShiftKey = 4
	mwHKF_ControlKey = 8
	mwHKF_AltKey = 16
	
	def __int__(self):
		return self.value

class mwStatusItemCategory(Enum):
	"""Constants that define the category of a status item."""
	mwRIC_Error = 0
	mwRIC_Warning = 1
	mwRIC_Info = 2
	
	def __int__(self):
		return self.value

class mwJobStatusType(Enum):
	"""Constants that define the different types of job status states for JobProcess objects."""
	mwJS_Unknown = 0
	mwJS_Rejected = 1
	mwJS_Pending = 2
	mwJS_Scheduled = 3
	mwJS_Removed = 4
	mwJS_Running = 5
	mwJS_Suspended = 6
	mwJS_Canceling = 7
	mwJS_Ended = 8
	mwJS_Canceled = 9
	mwJS_Killed = 10
	mwJS_Crashed = 11
	mwJS_Failed = 12
	mwJS_Sending = 13
	mwJS_Receiving = 14
	
	def __int__(self):
		return self.value

class mwScriptModuleSourceType(Enum):
	"""Constants that define the different types of script module sources."""
	mwSMS_Global = 0
	mwSMS_Project = 1
	
	def __int__(self):
		return self.value

class mwScriptModCreateFlags(Enum):
	"""Constants that define the different types of scripting module creation modes."""
	mwSCF_FailExist = 0
	mwSCF_Overwrite = 1
	mwSCF_Append = 2
	
	def __int__(self):
		return self.value

class mwShowFileType(Enum):
	"""Constants that define the different types of files that can be displayed by the file utility ShowFile."""
	mwSFT_PlainText = 0
	mwSFT_RichText = 1
	
	def __int__(self):
		return self.value

class mwPageSetupOrientation(Enum):
	"""Constants that define the different types of page orientations."""
	mwPSO_Portrait = 0
	mwPSO_Landscape = 1
	
	def __int__(self):
		return self.value

class mwPageSetupDetailLevel(Enum):
	"""Constants that define the different levels of output detail."""
	mwPSD_MaximumVisability = 0
	mwPSD_MinimumComplexity = 1
	
	def __int__(self):
		return self.value

class mwPrintPaperSize(Enum):
	"""Constants that define the different sizes of paper for printing."""
	mwPPS_Letter = 0
	mwPPS_LetterSmall = 1
	mwPPS_Tabloid = 2
	mwPPS_Ledger = 3
	mwPPS_Legal = 4
	mwPPS_Statement = 5
	mwPPS_Executive = 6
	mwPPS_A3 = 7
	mwPPS_A4 = 8
	mwPPS_A4_SMALL = 9
	mwPPS_A5 = 10
	mwPPS_B4 = 11
	mwPPS_B5 = 12
	mwPPS_Folio = 13
	mwPPS_Quarto = 14
	mwPPS_10X14 = 15
	mwPPS_11X17 = 16
	mwPPS_Note = 17
	mwPPS_Env_9 = 18
	mwPPS_Env_10 = 19
	mwPPS_Env_11 = 20
	mwPPS_Env_12 = 21
	mwPPS_Env_14 = 22
	mwPPS_CSheet = 23
	mwPPS_DSheet = 24
	mwPPS_ESheet = 25
	mwPPS_Env_DL = 26
	mwPPS_Env_C5 = 27
	mwPPS_Env_C3 = 28
	mwPPS_Env_C4 = 29
	mwPPS_Env_C6 = 30
	mwPPS_Env_C65 = 31
	mwPPS_Env_B4 = 32
	mwPPS_Env_B5 = 33
	mwPPS_Env_B6 = 34
	mwPPS_Env_Italy = 35
	mwPPS_Env_Monarch = 36
	mwPPS_Env_Personal = 37
	mwPPS_Fanfold_US = 38
	mwPPS_Fanfold_Std_German = 39
	mwPPS_Fanfold_Lgl_German = 40
	mwPPS_ISO_B4 = 41
	mwPPS_Japanese_Postcard = 42
	mwPPS_9X11 = 43
	mwPPS_10X11 = 44
	mwPPS_15X11 = 45
	mwPPS_Env_Invite = 46
	mwPPS_Letter_Extra = 47
	mwPPS_Legal_Extra = 48
	mwPPS_Tabloid_Extra = 49
	mwPPS_A4_Extra = 50
	mwPPS_Letter_Transverse = 51
	mwPPS_A4_Transverse = 52
	mwPPS_Letter_Extra_Transverse = 53
	mwPPS_A_Plus = 54
	mwPPS_B_Plus = 55
	mwPPS_Letter_Plus = 56
	mwPPS_A4_Plus = 57
	mwPPS_A5_Transverse = 58
	mwPPS_B5_Transverse = 59
	mwPPS_A3_Extra = 60
	mwPPS_A5_Extra = 61
	mwPPS_B5_Extra = 62
	mwPPS_A2 = 63
	mwPPS_A3_Transverse = 64
	mwPPS_A3_Extra_Transverse = 65
	mwPPS_Dbl_Japanese_Postcard = 66
	mwPPS_A6 = 67
	mwPPS_JEnv_KAKU2 = 68
	mwPPS_JEnv_KAKU3 = 69
	mwPPS_JEnv_CHOU3 = 70
	mwPPS_JEnv_CHOU4 = 71
	mwPPS_Letter_Rotated = 72
	mwPPS_A3_Rotated = 73
	mwPPS_A4_Rotated = 74
	mwPPS_A5_Rotated = 75
	mwPPS_B4_JIS_Rotated = 76
	mwPPS_B5_JIS_Rotated = 77
	mwPPS_Japanese_Postcard_Rotated = 78
	mwPPS_Dbl_Japanese_Postcard_Rotated = 79
	mwPPS_A6_Rotated = 80
	mwPPS_JEnv_KAKU2_Rotated = 81
	mwPPS_JEnv_KAKU3_Rotated = 82
	mwPPS_JEnv_CHOU3_Rotated = 83
	mwPPS_JEnv_CHOU4_Rotated = 84
	mwPPS_B6_JIS = 85
	mwPPS_B6_JIS_Rotated = 86
	mwPPS_12X11 = 87
	mwPPS_JEnv_YOU4 = 88
	mwPPS_JEnv_YOU4_Rotated = 89
	mwPPS_P16K = 90
	mwPPS_P32K = 91
	mwPPS_P32KBIG = 92
	mwPPS_PEnv_1 = 93
	mwPPS_PEnv_2 = 94
	mwPPS_PEnv_3 = 95
	mwPPS_PEnv_4 = 96
	mwPPS_PEnv_5 = 97
	mwPPS_PEnv_6 = 98
	mwPPS_PEnv_7 = 99
	mwPPS_PEnv_8 = 100
	mwPPS_PEnv_9 = 101
	mwPPS_PEnv_10 = 102
	mwPPS_P16K_Rotated = 103
	mwPPS_P32K_Rotated = 104
	mwPPS_P32KBig_Rotated = 105
	mwPPS_PEnv_1_Rotated = 106
	mwPPS_PEnv_2_Rotated = 107
	mwPPS_PEnv_3_Rotated = 108
	mwPPS_PEnv_4_Rotated = 109
	mwPPS_PEnv_5_Rotated = 110
	mwPPS_PEnv_6_Rotated = 111
	mwPPS_PEnv_7_Rotated = 112
	mwPPS_PEnv_8_Rotated = 113
	mwPPS_PEnv_9_Rotated = 114
	mwPPS_PEnv_10_Rotated = 115
	
	def __int__(self):
		return self.value

class mwPrintPaperSource(Enum):
	"""Constants that define the different sources of paper for printing"""
	mwPSR_Upper = 0
	mwPSR_OnlyOne = 1
	mwPSR_Lower = 2
	mwPSR_Middle = 3
	mwPSR_Manual = 4
	mwPSR_Evelope = 5
	mwPSR_EnvManual = 6
	mwPSR_Auto = 7
	mwPSR_Tractor = 8
	mwPSR_SmallFmt = 9
	mwPSR_LargeFmt = 10
	mwPSR_LargeCapacity = 11
	mwPSR_FormSource = 12
	mwPSR_User = 13
	
	def __int__(self):
		return self.value

class mwSimulatorTypeFlags(Enum):
	"""Constants that define the different types of simulator type flags."""
	mwSTF_DefaultSimulator = 1
	mwSTF_CycledSimulator = 2
	mwSTF_CircuitSimulator = 4
	mwSTF_SystemSimulator = 8
	mwSTF_EmSimulator = 16
	mwSTF_AutoSimulate = 32
	mwSTF_NoUpdateOnTune = 64
	mwSTF_UseElectModels = 128
	mwSTF_NoSimDocRequired = 256
	mwSTF_DoNotInitModel = 512
	mwSTF_UseNL_Models = 1024
	mwSTF_UsePathName = 2048
	mwSTF_LinCktSimulator = 4096
	mwSTF_DontRenumberCompNodes = 8192
	mwSTF_SpiceSimulator = 16384
	mwSTF_GetInferfaceFromDoc = 32768
	mwSTF_UseExtendedCktInfo = 65536
	mwSTF_IsDummySimulator = 131072
	mwSTF_TransientSimulator = 262144
	mwSTF_HierarchicalSimulator = 524288
	mwSTF_DontCreateElectModels = 1048576
	mwSTF_LvsSimulator = 2097152
	mwSTF_ElectNetsAsElements = 4194304
	
	def __int__(self):
		return self.value

class mwSystemSimulatorState(Enum):
	"""Constants that define different types of simulator run states"""
	mwSSS_Stopped = 0
	mwSSS_Running = 1
	mwSSS_Paused = 2
	mwSSS_Starting = 3
	
	def __int__(self):
		return self.value

class mwAnalyzeStateType(Enum):
	"""Constants that define the different types of simulator analysis state."""
	mwAST_BeforeSimulate = 1
	mwAST_Simulating = 2
	mwAST_SimulationEnded = 3
	
	def __int__(self):
		return self.value

class mwProjectVersionType(Enum):
	"""Constants that define different types of project version values."""
	mwPV_Latest = 1
	mwPV_Previous = 2
	mwPV_VersionNumber = 3
	
	def __int__(self):
		return self.value

class mwProjectItemType(Enum):
	"""Constants that define the different types of project items."""
	mwPIT_Schematic = 0
	mwPIT_SystemDiagram = 1
	mwPIT_EMStructure = 2
	mwPIT_Netlist = 3
	mwPIT_DataFile = 4
	mwPIT_Graph = 5
	mwPIT_Annotation = 6
	mwPIT_Measurement = 7
	mwPIT_OptimizerGoal = 8
	mwPIT_YieldGoal = 9
	mwPIT_OutputFile = 10
	mwPIT_DesignNotes = 11
	mwPIT_GlobalDefinitions = 12
	mwPIT_OutputEquations = 13
	mwPIT_Wizard = 14
	mwPIT_WizardInstance = 15
	mwPIT_Other = 16
	mwPIT_SampleProjectItem = 17
	mwPIT_DataSetFolder = 18
	mwPIT_DataSet = 19
	
	def __int__(self):
		return self.value

class mwProjectTemplateType(Enum):
	"""Constants that define different types of project template type values."""
	mwPT_NormalTemplate = 1
	
	def __int__(self):
		return self.value

class mwGlobalDefExportFormat(Enum):
	"""Constants that define different types of global definition document export formats."""
	mwGEF_MWOGlobalDefFile = 0
	mwGEF_JsonFile = 1
	
	def __int__(self):
		return self.value

class mwMergeConflictResolutionType(Enum):
	"""Constants that define the different types of conflict resolution modes."""
	mwMCR_Overwrite = 0
	mwMCR_Rename = 1
	
	def __int__(self):
		return self.value

class mwImportProjectRenameItems(Enum):
	"""Constants that define the different types of conflicted import project items to be renamed"""
	mwIPRI_All = 0
	mwIPRI_Conflicted = 1
	
	def __int__(self):
		return self.value

class mwImportProjectRenameStyle(Enum):
	"""Constants that define the types of rename styles that can be applied to conflicted import project items"""
	mwIPI_AddPrefix = 0
	mwIPI_AddSuffix = 1
	
	def __int__(self):
		return self.value

class mwDataSetFlags(Enum):
	"""Constants that define flag types associated with data sets."""
	mwDSF_Default = 0
	mwDSF_IsPartialDataSet = 1
	mwDSF_MeshOnly = 2
	mwDSF_NotFinalIter = 4
	mwDSF_PortOnly = 8
	mwDSF_IncludesGeometry = 16
	mwDSF_ForOptimization = 32
	mwDSF_IncludesG3DModel = 64
	mwDSF_KeepSweepValOrder = 128
	mwDSF_NoAutoLoadInProject = 256
	mwDSF_KeepWriteStreamOpen = 512
	mwDSF_IncompleteDataSet = 1024
	mwDSF_KeepReadStreamOpen = 2048
	mwDSF_DocCleanOnOpen = 4096
	mwDSF_Pinned = 8192
	mwDSF_Updating = 16384
	mwDSF_DisableAutoDelete = 32768
	mwDSF_ForTuning = 65536
	mwDSF_ForYield = 131072
	mwDSF_ClockStringReset = 262144
	mwDSF_DistSimResult = 524288
	mwDSF_InMemoryDataSet = 1048576
	
	def __int__(self):
		return self.value

class mwExternalEditorType(Enum):
	"""Constants that define the different types of external editors for EM3DStructure objects."""
	mwEET_SpaceClaimEditor = 1
	mwEET_OrionEditor = 2
	
	def __int__(self):
		return self.value

class mwEECmdShow(Enum):
	"""Constants that define the different types of external editor show states."""
	mwEECS_Hide = 0
	mwEECS_Show = 1
	
	def __int__(self):
		return self.value

class mwVersionControlStatus(Enum):
	"""Constants that define the different types of version control status types"""
	mwVCF_Normal = 0
	mwVCF_Added = 1
	mwVCF_Modified = 2
	mwVCF_Removed = 3
	mwVCF_Renamed = 4
	mwVCF_Unknown = 5
	mwVCF_Adding = 6
	mwVCF_Conflicted = 7
	mwVCF_Deleting = 8
	mwVCF_Missing = 9
	mwVCF_Renaming = 10
	mwVCF_Unmanaged = 11
	mwVCF_Unversioned = 12
	mwVCF_UnLocked = 13
	mwVCF_Owned = 14
	mwVCF_Unowned = 15
	
	def __int__(self):
		return self.value

class mwPDE_DataTables(Enum):
	"""Constants that define the different types of process definition editor tables"""
	mwPDE_DT_MaterialStack = 0
	mwPDE_DT_LayerDisplay = 1
	mwPDE_DT_LayerDisplay3D = 2
	mwPDE_DT_ViasDrills = 3
	
	def __int__(self):
		return self.value

class mwNetSynthCompTypes(Enum):
	"""Constants that define the types of components used in network synthesis."""
	mwNSC_Invalid = -1
	mwNSC_SE_Ind = 0
	mwNSC_SE_Cap = 1
	mwNSC_SE_Res = 2
	mwNSC_SE_TLine = 3
	mwNSC_SH_Ind = 4
	mwNSC_SH_Cap = 5
	mwNSC_SH_Res = 6
	mwNSC_SH_SerRL = 7
	mwNSC_SH_SerLC = 8
	mwNSC_SH_OpenTLine = 9
	mwNSC_SH_ShortTLine = 10
	mwNSC_SE_ParRC = 11
	mwNSC_SE_ParLC = 12
	mwNSC_SE_ParRLC = 13
	mwNSC_SH_SerRLC = 14
	mwNSC_SH_ParRC = 15
	mwNSC_SH_ParLC = 16
	mwNSC_SH_ParRLC = 17
	mwNSC_SE_LibInd = 18
	mwNSC_SE_LibCap = 19
	mwNSC_SE_LibRes = 20
	mwNSC_SH_LibInd = 21
	mwNSC_SH_LibCap = 22
	mwNSC_SH_LibRes = 23
	
	def __int__(self):
		return self.value

class mwNetSynthDiscrValModes(Enum):
	"""Constants that define the types of discrete value constraints for component parameters in network synthesis."""
	mwNSD_Continuous = 0
	mwNSD_RoundAbs = 1
	mwNSD_RoundSigFigs = 2
	mwNSD_SigDigTable = 3
	mwNSD_ValueList = 4
	
	def __int__(self):
		return self.value

class mwNetSynthVendorLibCompTypes(Enum):
	"""Constants that define the types of vendor library components used in network synthesis."""
	mwNSV_Ind = 0
	mwNSV_Cap = 1
	mwNSV_Res = 2
	
	def __int__(self):
		return self.value


# MWOffice
class CMWOffice:
	"""The MWOffice application object."""
	def __init__(self, *args, **kwargs):
		if "-awr_clsid" in sys.argv:
			clsidIndex = sys.argv.index("-awr_clsid")
			if (clsidIndex + 1) < len(sys.argv):
				clsid = sys.argv[clsidIndex+1]
				self.__IMWOffice= win32com.client.Dispatch(clsid, *args, **kwargs)
			else:
				raise Exception("Error: -awr_clisd argument passed but no clsid followed")
		else:
			self.__IMWOffice= win32com.client.Dispatch("MWOApp.MWOffice", *args, **kwargs)


	def _get_inner(self):
		return self.__IMWOffice

	def New(self, Name: str) -> bool:
		"""Creates a new Project."""
		return self.__IMWOffice.New(Name)


	def Open(self, Filename: str) -> bool:
		"""Opens an existing Project."""
		return self.__IMWOffice.Open(Filename)


	def Dispose(self) -> None:
		"""Releases object references being held by MWOffice."""
		self.__IMWOffice.Dispose()


	def Activate(self) -> None:
		"""Activates the Window associated with the object."""
		self.__IMWOffice.Activate()


	def NewWithProcessLibrary(self, ProcessLibrary: str) -> None:
		"""Creates a new Project with a Process Library."""
		self.__IMWOffice.NewWithProcessLibrary(ProcessLibrary)


	def Quit(self) -> None:
		"""Quits the MWOffice Application."""
		self.__IMWOffice.Quit()


	def CreateEMail(self) -> CEMail:
		"""Returns a reference to a MWOffice EMail object."""
		return CEMail(self.__IMWOffice.CreateEMail())


	def SendEMail(self, ppEmail: CEMail) -> bool:
		"""Sends the provided email object."""
		return self.__IMWOffice.SendEMail(ppEmail._get_inner())


	def InvokeCommand(self, CommandName: str, Arguments, pRet) -> None:
		"""Invoke a application level menu command by name. Any required input will need to be supplied in the arguments."""
		self.__IMWOffice.InvokeCommand(CommandName, Arguments, pRet)


	def StartCommand(self, CommandName: str, pRet) -> None:
		"""Start a application level menu command by name. Any required input will need to be supplied by the user interactively."""
		self.__IMWOffice.StartCommand(CommandName, pRet)


	def WaitForAsyncTask(self, timeout_ms: int) -> bool:
		"""Call to wait for async tasks to complete before continuing with script execution."""
		return self.__IMWOffice.WaitForAsyncTask(timeout_ms)


	def WaitForAsyncTaskEx(self, timeout_ms: int, task_name) -> bool:
		"""Call to wait for async tasks to complete before continuing with script execution, this version provides task name on timeout."""
		return self.__IMWOffice.WaitForAsyncTaskEx(timeout_ms, task_name)



	@property
	def Active(self) -> bool:
		"""Activates the Window associated with the object."""
		return self.__IMWOffice.Active


	@property
	def AppName(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IMWOffice.AppName


	@property
	def Arguments(self) -> CArguments:
		"""Returns a reference to a MWOffice Arguments collection."""
		return CArguments(self.__IMWOffice.Arguments)


	@property
	def Attributes(self) -> CAttributes:
		"""Returns a reference to a collection of Attribute objects."""
		return CAttributes(self.__IMWOffice.Attributes)


	@property
	def AvailableProcessLibraries(self) -> CProcessLibraryInfos:
		"""Returns a reference to a MWOffice FoundryLibrariess collection."""
		return CProcessLibraryInfos(self.__IMWOffice.AvailableProcessLibraries)


	@property
	def BuildNumber(self) -> int:
		"""Returns the build number of MWOffice."""
		return self.__IMWOffice.BuildNumber


	@property
	def BuildRevision(self) -> int:
		"""Returns the build revision for the MWOffice Application."""
		return self.__IMWOffice.BuildRevision


	@property
	def CanPrint(self) -> bool:
		"""Returns a value that indicates if printing is correctly setup."""
		return self.__IMWOffice.CanPrint


	@property
	def CanSendEMail(self) -> bool:
		"""Returns a value that indicates if the MWOffice Application can send email."""
		return self.__IMWOffice.CanSendEMail


	@property
	def Caption(self) -> str:
		"""Returns/Sets the caption of an object."""
		return self.__IMWOffice.Caption


	@property
	def CellMappings(self) -> CCellMappings:
		"""Returns a reference to a collection of MWOffice CellMapping objects."""
		return CCellMappings(self.__IMWOffice.CellMappings)


	@property
	def CommandTables(self) -> CCommandTables:
		"""Returns a reference to a collection of CommandTable objects."""
		return CCommandTables(self.__IMWOffice.CommandTables)


	@property
	def ControlBars(self) -> CControlBars:
		"""Returns a reference to a collection of ControlBar objects."""
		return CControlBars(self.__IMWOffice.ControlBars)


	@property
	def Directories(self) -> CAttributes:
		"""Returns a reference to a collection of Attribute objects."""
		return CAttributes(self.__IMWOffice.Directories)


	@property
	def ExeName(self) -> str:
		"""Returns the name of the MWOffice application executable file."""
		return self.__IMWOffice.ExeName


	@property
	def FileUtil(self) -> CFileUtil:
		"""Returns a reference to a MWOffice FileUtil object."""
		return CFileUtil(self.__IMWOffice.FileUtil)


	@property
	def Files(self) -> CAttributes:
		"""Returns a reference to a collection of Attribute objects."""
		return CAttributes(self.__IMWOffice.Files)


	@property
	def GeomUtil(self) -> CApiGeomUtil:
		"""Returns a reference to a MWOffice GeomUtil object."""
		return CApiGeomUtil(self.__IMWOffice.GeomUtil)


	@property
	def GlobalProject(self) -> CProject:
		""""""
		return CProject(self.__IMWOffice.GlobalProject)


	@property
	def GlobalScripts(self) -> CScriptModules:
		"""Returns a reference to a collection of ScriptModule objects."""
		return CScriptModules(self.__IMWOffice.GlobalScripts)


	@property
	def Height(self) -> int:
		"""Returns/sets the height of a Window object."""
		return self.__IMWOffice.Height


	@Height.setter
	def Height(self, value: int):
		"""Returns/sets the height of a Window object."""
		self.__IMWOffice.Height = value


	@property
	def HotkeyTables(self) -> CHotkeyTables:
		"""Returns a reference to a collection of HotkeyTable objects."""
		return CHotkeyTables(self.__IMWOffice.HotkeyTables)


	@property
	def InstanceCLSID(self) -> str:
		"""Returns the CLSID of the current MWOffice Application instance"""
		return self.__IMWOffice.InstanceCLSID


	@property
	def JobControlMonitor(self) -> CJobMonitor:
		"""Returns a reference to a JobMonitor object."""
		return CJobMonitor(self.__IMWOffice.JobControlMonitor)


	@property
	def LayoutCells(self) -> CLayoutCells:
		"""Returns a reference to a collection of LayoutCell objects."""
		return CLayoutCells(self.__IMWOffice.LayoutCells)


	@property
	def LayoutModes(self) -> CLayoutModeSets:
		"""Returns a reference to a MWOffice LayoutModeSets collection."""
		return CLayoutModeSets(self.__IMWOffice.LayoutModes)


	@property
	def Left(self) -> int:
		"""Returns/sets the left edge of a Window object."""
		return self.__IMWOffice.Left


	@Left.setter
	def Left(self, value: int):
		"""Returns/sets the left edge of a Window object."""
		self.__IMWOffice.Left = value


	@property
	def Libraries(self) -> CLibraries:
		"""Returns a reference to a MWOffice Libraries collection."""
		return CLibraries(self.__IMWOffice.Libraries)


	@property
	def MathUtil(self) -> CMathUtil:
		"""Returns a reference to a MWOffice MathUtil object."""
		return CMathUtil(self.__IMWOffice.MathUtil)


	@property
	def MeasurementInfos(self) -> CMeasurementInfos:
		"""Returns a reference to a collection of MeasurementInfo objects."""
		return CMeasurementInfos(self.__IMWOffice.MeasurementInfos)


	@property
	def Models(self) -> CModels:
		"""Returns a reference to a collection of Model objects representing the available circuit elements."""
		return CModels(self.__IMWOffice.Models)


	@property
	def ModifierLibrary(self) -> CShapeModifierRecords:
		"""Returns a reference to a collection of ShapeModifier objects."""
		return CShapeModifierRecords(self.__IMWOffice.ModifierLibrary)


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__IMWOffice.Options)


	@property
	def PageSetup(self) -> CPageSetup:
		"""Returns a reference to a PageSetup object."""
		return CPageSetup(self.__IMWOffice.PageSetup)


	@property
	def Path(self) -> str:
		"""Returns the path of the MWOffice application."""
		return self.__IMWOffice.Path


	@property
	def Project(self) -> CProject:
		"""Returns a reference to the Project object."""
		return CProject(self.__IMWOffice.Project)


	@property
	def ProjectOpen(self) -> bool:
		"""Returns a value that indicates if the MWOffice Application currently has a project open."""
		return self.__IMWOffice.ProjectOpen


	@property
	def RecentProjects(self) -> CProjectFiles:
		"""Returns a reference to a MWOffice ProjectFiles collection."""
		return CProjectFiles(self.__IMWOffice.RecentProjects)


	@property
	def ScaleHeight(self) -> int:
		"""Returns the height of a Window object's interior."""
		return self.__IMWOffice.ScaleHeight


	@property
	def ScaleWidth(self) -> int:
		"""Returns the width of a Window object's interior."""
		return self.__IMWOffice.ScaleWidth


	@property
	def ScriptingAvailable(self) -> bool:
		"""Returns a value that indicates if scripting is currently available."""
		return self.__IMWOffice.ScriptingAvailable


	def Setting(self, Category: str, ValueName: str):
		"""Returns/Sets a persisted setting of the MWOffice application."""
		return self.__IMWOffice.Setting(Category, ValueName)


	def SetSetting(self, Category: str, ValueName: str, value):
		"""Returns/Sets a persisted setting of the MWOffice application."""
		self.__IMWOffice.Setting = value


	@property
	def SimulatorInfos(self) -> CSimulatorInfos:
		"""Returns a reference to a collection of SimulatorInfo objects."""
		return CSimulatorInfos(self.__IMWOffice.SimulatorInfos)


	@property
	def StackupUtil(self) -> CStackupUtil:
		"""Returns a reference to a MWOffice StackupUtil object."""
		return CStackupUtil(self.__IMWOffice.StackupUtil)


	@property
	def Status(self) -> CStatus:
		"""Returns a reference to a MWOffice Status object."""
		return CStatus(self.__IMWOffice.Status)


	@property
	def SystemInfo(self) -> CSystemInfo:
		"""Returns a reference to a MWOffice SystemInfo object."""
		return CSystemInfo(self.__IMWOffice.SystemInfo)


	@property
	def SystemModels(self) -> CModels:
		"""Returns a reference to a collection of Model objects representing the available system blocks."""
		return CModels(self.__IMWOffice.SystemModels)


	@property
	def Top(self) -> int:
		"""Returns/sets the top edge of a Window object."""
		return self.__IMWOffice.Top


	@Top.setter
	def Top(self, value: int):
		"""Returns/sets the top edge of a Window object."""
		self.__IMWOffice.Top = value


	def UserSetting(self, Category: str, ValueName: str):
		"""Returns/Sets a persisted user setting of the MWOffice application."""
		return self.__IMWOffice.UserSetting(Category, ValueName)


	def SetUserSetting(self, Category: str, ValueName: str, value):
		"""Returns/Sets a persisted user setting of the MWOffice application."""
		self.__IMWOffice.UserSetting = value


	@property
	def Version(self) -> float:
		"""Returns the version number of MWOffice."""
		return self.__IMWOffice.Version


	@property
	def VersionString(self) -> str:
		"""Returns the version string for the MWOffice Application."""
		return self.__IMWOffice.VersionString


	@property
	def Visible(self) -> bool:
		"""Returns/sets a value which specifies if the object is visible."""
		return self.__IMWOffice.Visible


	@Visible.setter
	def Visible(self, value: bool):
		"""Returns/sets a value which specifies if the object is visible."""
		self.__IMWOffice.Visible = value


	@property
	def Width(self) -> int:
		"""Returns/sets the width of a Window object."""
		return self.__IMWOffice.Width


	@Width.setter
	def Width(self, value: int):
		"""Returns/sets the width of a Window object."""
		self.__IMWOffice.Width = value


	@property
	def WindowState(self):
		"""Returns the screen state of a Window object."""
		return self.__IMWOffice.WindowState


	@WindowState.setter
	def WindowState(self, value: mwWindowState):
		"""Returns the screen state of a Window object."""
		self.__IMWOffice.WindowState = value


	@property
	def Windows(self) -> CWindows:
		"""Returns a reference to a collection of Window objects."""
		return CWindows(self.__IMWOffice.Windows)


	@property
	def hWnd(self) -> int:
		"""Returns the window handle of the MWOffice main window."""
		return self.__IMWOffice.hWnd


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Application
class CApplication:
	"""The MWOffice application object."""
	def __init__(self, mwoffice):
		self.__IMWOffice = mwoffice

	def _get_inner(self):
		return self.__IMWOffice


	def New(self, Name: str) -> bool:
		"""Creates a new Project."""
		return self.__IMWOffice.New(Name)


	def Open(self, Filename: str) -> bool:
		"""Opens an existing Project."""
		return self.__IMWOffice.Open(Filename)


	def Dispose(self) -> None:
		"""Releases object references being held by MWOffice."""
		self.__IMWOffice.Dispose()


	def Activate(self) -> None:
		"""Activates the Window associated with the object."""
		self.__IMWOffice.Activate()


	def NewWithProcessLibrary(self, ProcessLibrary: str) -> None:
		"""Creates a new Project with a Process Library."""
		self.__IMWOffice.NewWithProcessLibrary(ProcessLibrary)


	def Quit(self) -> None:
		"""Quits the MWOffice Application."""
		self.__IMWOffice.Quit()


	def CreateEMail(self) -> CEMail:
		"""Returns a reference to a MWOffice EMail object."""
		return CEMail(self.__IMWOffice.CreateEMail())


	def SendEMail(self, ppEmail: CEMail) -> bool:
		"""Sends the provided email object."""
		return self.__IMWOffice.SendEMail(ppEmail._get_inner())


	def InvokeCommand(self, CommandName: str, Arguments, pRet) -> None:
		"""Invoke a application level menu command by name. Any required input will need to be supplied in the arguments."""
		self.__IMWOffice.InvokeCommand(CommandName, Arguments, pRet)


	def StartCommand(self, CommandName: str, pRet) -> None:
		"""Start a application level menu command by name. Any required input will need to be supplied by the user interactively."""
		self.__IMWOffice.StartCommand(CommandName, pRet)


	def WaitForAsyncTask(self, timeout_ms: int) -> bool:
		"""Call to wait for async tasks to complete before continuing with script execution."""
		return self.__IMWOffice.WaitForAsyncTask(timeout_ms)


	def WaitForAsyncTaskEx(self, timeout_ms: int, task_name) -> bool:
		"""Call to wait for async tasks to complete before continuing with script execution, this version provides task name on timeout."""
		return self.__IMWOffice.WaitForAsyncTaskEx(timeout_ms, task_name)



	@property
	def Active(self) -> bool:
		"""Activates the Window associated with the object."""
		return self.__IMWOffice.Active


	@property
	def AppName(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IMWOffice.AppName


	@property
	def Arguments(self) -> CArguments:
		"""Returns a reference to a MWOffice Arguments collection."""
		return CArguments(self.__IMWOffice.Arguments)


	@property
	def Attributes(self) -> CAttributes:
		"""Returns a reference to a collection of Attribute objects."""
		return CAttributes(self.__IMWOffice.Attributes)


	@property
	def AvailableProcessLibraries(self) -> CProcessLibraryInfos:
		"""Returns a reference to a MWOffice FoundryLibrariess collection."""
		return CProcessLibraryInfos(self.__IMWOffice.AvailableProcessLibraries)


	@property
	def BuildNumber(self) -> int:
		"""Returns the build number of MWOffice."""
		return self.__IMWOffice.BuildNumber


	@property
	def BuildRevision(self) -> int:
		"""Returns the build revision for the MWOffice Application."""
		return self.__IMWOffice.BuildRevision


	@property
	def CanPrint(self) -> bool:
		"""Returns a value that indicates if printing is correctly setup."""
		return self.__IMWOffice.CanPrint


	@property
	def CanSendEMail(self) -> bool:
		"""Returns a value that indicates if the MWOffice Application can send email."""
		return self.__IMWOffice.CanSendEMail


	@property
	def Caption(self) -> str:
		"""Returns/Sets the caption of an object."""
		return self.__IMWOffice.Caption


	@property
	def CellMappings(self) -> CCellMappings:
		"""Returns a reference to a collection of MWOffice CellMapping objects."""
		return CCellMappings(self.__IMWOffice.CellMappings)


	@property
	def CommandTables(self) -> CCommandTables:
		"""Returns a reference to a collection of CommandTable objects."""
		return CCommandTables(self.__IMWOffice.CommandTables)


	@property
	def ControlBars(self) -> CControlBars:
		"""Returns a reference to a collection of ControlBar objects."""
		return CControlBars(self.__IMWOffice.ControlBars)


	@property
	def Directories(self) -> CAttributes:
		"""Returns a reference to a collection of Attribute objects."""
		return CAttributes(self.__IMWOffice.Directories)


	@property
	def ExeName(self) -> str:
		"""Returns the name of the MWOffice application executable file."""
		return self.__IMWOffice.ExeName


	@property
	def FileUtil(self) -> CFileUtil:
		"""Returns a reference to a MWOffice FileUtil object."""
		return CFileUtil(self.__IMWOffice.FileUtil)


	@property
	def Files(self) -> CAttributes:
		"""Returns a reference to a collection of Attribute objects."""
		return CAttributes(self.__IMWOffice.Files)


	@property
	def GeomUtil(self) -> CApiGeomUtil:
		"""Returns a reference to a MWOffice GeomUtil object."""
		return CApiGeomUtil(self.__IMWOffice.GeomUtil)


	@property
	def GlobalProject(self) -> CProject:
		""""""
		return CProject(self.__IMWOffice.GlobalProject)


	@property
	def GlobalScripts(self) -> CScriptModules:
		"""Returns a reference to a collection of ScriptModule objects."""
		return CScriptModules(self.__IMWOffice.GlobalScripts)


	@property
	def Height(self) -> int:
		"""Returns/sets the height of a Window object."""
		return self.__IMWOffice.Height


	@Height.setter
	def Height(self, value: int):
		"""Returns/sets the height of a Window object."""
		self.__IMWOffice.Height = value


	@property
	def HotkeyTables(self) -> CHotkeyTables:
		"""Returns a reference to a collection of HotkeyTable objects."""
		return CHotkeyTables(self.__IMWOffice.HotkeyTables)


	@property
	def InstanceCLSID(self) -> str:
		"""Returns the CLSID of the current MWOffice Application instance"""
		return self.__IMWOffice.InstanceCLSID


	@property
	def JobControlMonitor(self) -> CJobMonitor:
		"""Returns a reference to a JobMonitor object."""
		return CJobMonitor(self.__IMWOffice.JobControlMonitor)


	@property
	def LayoutCells(self) -> CLayoutCells:
		"""Returns a reference to a collection of LayoutCell objects."""
		return CLayoutCells(self.__IMWOffice.LayoutCells)


	@property
	def LayoutModes(self) -> CLayoutModeSets:
		"""Returns a reference to a MWOffice LayoutModeSets collection."""
		return CLayoutModeSets(self.__IMWOffice.LayoutModes)


	@property
	def Left(self) -> int:
		"""Returns/sets the left edge of a Window object."""
		return self.__IMWOffice.Left


	@Left.setter
	def Left(self, value: int):
		"""Returns/sets the left edge of a Window object."""
		self.__IMWOffice.Left = value


	@property
	def Libraries(self) -> CLibraries:
		"""Returns a reference to a MWOffice Libraries collection."""
		return CLibraries(self.__IMWOffice.Libraries)


	@property
	def MathUtil(self) -> CMathUtil:
		"""Returns a reference to a MWOffice MathUtil object."""
		return CMathUtil(self.__IMWOffice.MathUtil)


	@property
	def MeasurementInfos(self) -> CMeasurementInfos:
		"""Returns a reference to a collection of MeasurementInfo objects."""
		return CMeasurementInfos(self.__IMWOffice.MeasurementInfos)


	@property
	def Models(self) -> CModels:
		"""Returns a reference to a collection of Model objects representing the available circuit elements."""
		return CModels(self.__IMWOffice.Models)


	@property
	def ModifierLibrary(self) -> CShapeModifierRecords:
		"""Returns a reference to a collection of ShapeModifier objects."""
		return CShapeModifierRecords(self.__IMWOffice.ModifierLibrary)


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__IMWOffice.Options)


	@property
	def PageSetup(self) -> CPageSetup:
		"""Returns a reference to a PageSetup object."""
		return CPageSetup(self.__IMWOffice.PageSetup)


	@property
	def Path(self) -> str:
		"""Returns the path of the MWOffice application."""
		return self.__IMWOffice.Path


	@property
	def Project(self) -> CProject:
		"""Returns a reference to the Project object."""
		return CProject(self.__IMWOffice.Project)


	@property
	def ProjectOpen(self) -> bool:
		"""Returns a value that indicates if the MWOffice Application currently has a project open."""
		return self.__IMWOffice.ProjectOpen


	@property
	def RecentProjects(self) -> CProjectFiles:
		"""Returns a reference to a MWOffice ProjectFiles collection."""
		return CProjectFiles(self.__IMWOffice.RecentProjects)


	@property
	def ScaleHeight(self) -> int:
		"""Returns the height of a Window object's interior."""
		return self.__IMWOffice.ScaleHeight


	@property
	def ScaleWidth(self) -> int:
		"""Returns the width of a Window object's interior."""
		return self.__IMWOffice.ScaleWidth


	@property
	def ScriptingAvailable(self) -> bool:
		"""Returns a value that indicates if scripting is currently available."""
		return self.__IMWOffice.ScriptingAvailable


	def Setting(self, Category: str, ValueName: str):
		"""Returns/Sets a persisted setting of the MWOffice application."""
		return self.__IMWOffice.Setting(Category, ValueName)


	def SetSetting(self, Category: str, ValueName: str, value):
		"""Returns/Sets a persisted setting of the MWOffice application."""
		self.__IMWOffice.Setting = value


	@property
	def SimulatorInfos(self) -> CSimulatorInfos:
		"""Returns a reference to a collection of SimulatorInfo objects."""
		return CSimulatorInfos(self.__IMWOffice.SimulatorInfos)


	@property
	def StackupUtil(self) -> CStackupUtil:
		"""Returns a reference to a MWOffice StackupUtil object."""
		return CStackupUtil(self.__IMWOffice.StackupUtil)


	@property
	def Status(self) -> CStatus:
		"""Returns a reference to a MWOffice Status object."""
		return CStatus(self.__IMWOffice.Status)


	@property
	def SystemInfo(self) -> CSystemInfo:
		"""Returns a reference to a MWOffice SystemInfo object."""
		return CSystemInfo(self.__IMWOffice.SystemInfo)


	@property
	def SystemModels(self) -> CModels:
		"""Returns a reference to a collection of Model objects representing the available system blocks."""
		return CModels(self.__IMWOffice.SystemModels)


	@property
	def Top(self) -> int:
		"""Returns/sets the top edge of a Window object."""
		return self.__IMWOffice.Top


	@Top.setter
	def Top(self, value: int):
		"""Returns/sets the top edge of a Window object."""
		self.__IMWOffice.Top = value


	def UserSetting(self, Category: str, ValueName: str):
		"""Returns/Sets a persisted user setting of the MWOffice application."""
		return self.__IMWOffice.UserSetting(Category, ValueName)


	def SetUserSetting(self, Category: str, ValueName: str, value):
		"""Returns/Sets a persisted user setting of the MWOffice application."""
		self.__IMWOffice.UserSetting = value


	@property
	def Version(self) -> float:
		"""Returns the version number of MWOffice."""
		return self.__IMWOffice.Version


	@property
	def VersionString(self) -> str:
		"""Returns the version string for the MWOffice Application."""
		return self.__IMWOffice.VersionString


	@property
	def Visible(self) -> bool:
		"""Returns/sets a value which specifies if the object is visible."""
		return self.__IMWOffice.Visible


	@Visible.setter
	def Visible(self, value: bool):
		"""Returns/sets a value which specifies if the object is visible."""
		self.__IMWOffice.Visible = value


	@property
	def Width(self) -> int:
		"""Returns/sets the width of a Window object."""
		return self.__IMWOffice.Width


	@Width.setter
	def Width(self, value: int):
		"""Returns/sets the width of a Window object."""
		self.__IMWOffice.Width = value


	@property
	def WindowState(self):
		"""Returns the screen state of a Window object."""
		return self.__IMWOffice.WindowState


	@WindowState.setter
	def WindowState(self, value: mwWindowState):
		"""Returns the screen state of a Window object."""
		self.__IMWOffice.WindowState = value


	@property
	def Windows(self) -> CWindows:
		"""Returns a reference to a collection of Window objects."""
		return CWindows(self.__IMWOffice.Windows)


	@property
	def hWnd(self) -> int:
		"""Returns the window handle of the MWOffice main window."""
		return self.__IMWOffice.hWnd


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Project
class CProject:
	"""An MWOffice Project object."""
	def __init__(self, project):
		self.__IProject = project

	def _get_inner(self):
		return self.__IProject


	def Save(self) -> bool:
		"""Saves changes to the project file specified in the project's FullName property."""
		return self.__IProject.Save()


	def Close(self, SaveChanges: bool, Filename: str) -> None:
		"""Closes the project and all windows associated with the project."""
		self.__IProject.Close(SaveChanges, Filename)


	def SaveAs(self, Filename: str) -> None:
		"""Saves the project to a file."""
		self.__IProject.SaveAs(Filename)


	def NewGlobalEquationsWindow(self) -> CWindow:
		"""Displays the object in new window."""
		return CWindow(self.__IProject.NewGlobalEquationsWindow())


	def NewOutputEquationsWindow(self) -> CWindow:
		"""Displays the object in new window."""
		return CWindow(self.__IProject.NewOutputEquationsWindow())


	def SaveAsVersion(self, Filename: str, Type: mwProjectVersionType, VersionNumber: float = 0) -> None:
		"""Saves the project to a file as a specified version."""
		self.__IProject.SaveAsVersion(Filename, Type, VersionNumber)


	def SaveAsTemplate(self, Filename: str, Type: mwProjectTemplateType) -> None:
		"""Saves the project to a file as a template."""
		self.__IProject.SaveAsTemplate(Filename, Type)


	def Import(self, Filename: str, SuppressWarings: bool = 0) -> None:
		"""Merges one project into another."""
		self.__IProject.Import(Filename, SuppressWarings)


	def ImportTestbench(self, Filename: str, SuppressWarings: bool = 0) -> None:
		"""Merges one project into another."""
		self.__IProject.ImportTestbench(Filename, SuppressWarings)


	def Save2(self, NoPrompt: bool) -> bool:
		"""Saves changes to the project file specified in the project's FullName property."""
		return self.__IProject.Save2(NoPrompt)



	@property
	def Annotations(self) -> CAnnotations:
		"""Returns a reference to a MWOffice Annotations collection."""
		return CAnnotations(self.__IProject.Annotations)


	@property
	def AppVersion(self) -> int:
		"""Returns the application version used to create the project."""
		return self.__IProject.AppVersion


	@property
	def Application(self) -> CApplication:
		"""The MWOffice application object."""
		return CApplication(self.__IProject.Application)


	@property
	def BuildNumber(self) -> int:
		"""Returns the build number of the version used to create the project."""
		return self.__IProject.BuildNumber


	@property
	def CellLibraries(self) -> CCellLibraries:
		"""Returns a reference to a collection of Cell Library objects."""
		return CCellLibraries(self.__IProject.CellLibraries)


	@property
	def DataFiles(self) -> CDataFiles:
		"""Returns a reference to a collection of Datafile objects."""
		return CDataFiles(self.__IProject.DataFiles)


	@property
	def DataSetFolders(self) -> CDataSetFolders:
		"""Returns a reference to a collection of DataSetFolder objects."""
		return CDataSetFolders(self.__IProject.DataSetFolders)


	@property
	def DesignNotes(self) -> CDesignNotes:
		"""Returns a reference to a DesignNotes collection."""
		return CDesignNotes(self.__IProject.DesignNotes)


	@property
	def EM3DStructures(self) -> CEM3DStructures:
		"""Returns a reference to a collection of EM3DStructures."""
		return CEM3DStructures(self.__IProject.EM3DStructures)


	@property
	def EMStructures(self) -> CEMStructures:
		"""Returns a reference to a collection of Electromagnetic Structure objects."""
		return CEMStructures(self.__IProject.EMStructures)


	@property
	def ErrorState(self):
		"""Returns the error state of a Project object."""
		return self.__IProject.ErrorState


	@property
	def Filename(self) -> str:
		"""Returns the name of the current project file including the filename extension, or 'Untitled Project' if the project has not been saved"""
		return self.__IProject.Filename


	@property
	def Frequencies(self) -> CFrequencies:
		"""Returns a reference to a collection of Frequency objects."""
		return CFrequencies(self.__IProject.Frequencies)


	@property
	def FullName(self) -> str:
		"""Returns the file specification of the project, including the path."""
		return self.__IProject.FullName


	@property
	def GlobalDefinitionDocuments(self) -> CGlobalDefinitionDocuments:
		"""Returns a reference to a collection of GlobalDefinitionDocument objects."""
		return CGlobalDefinitionDocuments(self.__IProject.GlobalDefinitionDocuments)


	@property
	def GlobalEquationsWindows(self) -> CWindows:
		"""Returns a reference to a collection of Window objects."""
		return CWindows(self.__IProject.GlobalEquationsWindows)


	@property
	def Graphs(self) -> CGraphs:
		"""Returns a reference to a collection of Graph objects."""
		return CGraphs(self.__IProject.Graphs)


	@property
	def HasEventScripts(self) -> bool:
		"""Returns a value indicating if the project contains event scripts."""
		return self.__IProject.HasEventScripts


	@property
	def LockUpdates(self) -> bool:
		"""Returns/sets a value that indicates if updates should be locked or disabled."""
		return self.__IProject.LockUpdates


	@LockUpdates.setter
	def LockUpdates(self, value: bool):
		"""Returns/sets a value that indicates if updates should be locked or disabled."""
		self.__IProject.LockUpdates = value


	@property
	def Name(self) -> str:
		"""Returns the file name of the project, not including the file's path specification."""
		return self.__IProject.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns the file name of the project, not including the file's path specification."""
		self.__IProject.Name = value


	@property
	def Netlists(self) -> CNetlists:
		"""Returns a reference to a collection of Netlist objects."""
		return CNetlists(self.__IProject.Netlists)


	@property
	def OptGoals(self) -> COptGoals:
		"""Returns a reference to a collection of Goal objects."""
		return COptGoals(self.__IProject.OptGoals)


	@property
	def Optimizer(self) -> COptimizer:
		"""Returns a reference to the Optimizer object."""
		return COptimizer(self.__IProject.Optimizer)


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__IProject.Options)


	@property
	def OutputEquationDocuments(self) -> COutputEquationDocuments:
		"""Returns a reference to a collection of OutputEquationDocument objects."""
		return COutputEquationDocuments(self.__IProject.OutputEquationDocuments)


	@property
	def OutputEquationsWindows(self) -> CWindows:
		"""Returns a reference to a collection of Window objects."""
		return CWindows(self.__IProject.OutputEquationsWindows)


	@property
	def OutputFiles(self) -> COutputFiles:
		"""Returns a reference to a MWOffice OutputFiles collection."""
		return COutputFiles(self.__IProject.OutputFiles)


	@property
	def Parent(self) -> CApplication:
		"""The MWOffice application object."""
		return CApplication(self.__IProject.Parent)


	@property
	def Path(self) -> str:
		"""Returns the path specification for the project, not including the file name or file name extension."""
		return self.__IProject.Path


	@property
	def ProcessDefinitions(self) -> CLayoutProcessDefinitions:
		"""Returns a reference to a MWOffice LayoutProcessDefinition object."""
		return CLayoutProcessDefinitions(self.__IProject.ProcessDefinitions)


	@property
	def ProcessLibraries(self) -> CProcessLibraries:
		"""Returns a reference to a MWOffice FoundryLibrariess collection."""
		return CProcessLibraries(self.__IProject.ProcessLibraries)


	@property
	def ProjectId(self) -> str:
		"""Returns a string of characters representing a unique project identifier."""
		return self.__IProject.ProjectId


	@property
	def ProjectScripts(self) -> CScriptModules:
		"""Returns a reference to a collection of ScriptModule objects."""
		return CScriptModules(self.__IProject.ProjectScripts)


	@property
	def ProjectSymbols(self) -> CSymbols:
		"""Returns a reference to a collection of Symbol objects."""
		return CSymbols(self.__IProject.ProjectSymbols)


	@property
	def Properties(self) -> CProperties:
		"""Returns a reference to a collection of Property objects."""
		return CProperties(self.__IProject.Properties)


	@property
	def ReadOnly(self) -> bool:
		"""Returns True if the project file is read only, otherwise False."""
		return self.__IProject.ReadOnly


	@property
	def RoutePropertyInfo(self) -> CRoutePropertyInfo:
		"""Returns a reference to a RoutePropertyInfo object."""
		return CRoutePropertyInfo(self.__IProject.RoutePropertyInfo)


	@property
	def Saved(self) -> bool:
		"""Returns False if the project has changed, otherwise True."""
		return self.__IProject.Saved


	@Saved.setter
	def Saved(self, value: bool):
		"""Returns False if the project has changed, otherwise True."""
		self.__IProject.Saved = value


	@property
	def Schematics(self) -> CSchematics:
		"""Returns a reference to a collection of Schematic objects."""
		return CSchematics(self.__IProject.Schematics)


	@property
	def SelectFilters(self) -> CCSelectFilters:
		"""Returns a reference to a collection of MWOffice SelectFilter objects."""
		return CCSelectFilters(self.__IProject.SelectFilters)


	@property
	def SimulationFilters(self) -> CSimulationFilters:
		"""Returns a reference to a collection of MWOffice SimulationFilter objects."""
		return CSimulationFilters(self.__IProject.SimulationFilters)


	@property
	def SimulationResults(self) -> CSimulationResults:
		"""Returns a reference to a collection of MWOffice SimulationResult objects."""
		return CSimulationResults(self.__IProject.SimulationResults)


	@property
	def Simulator(self) -> CSimulator:
		"""Returns a reference to a Simulator object."""
		return CSimulator(self.__IProject.Simulator)


	@property
	def Sweeper(self) -> CSweeper:
		"""Returns a reference to a Sweeper object."""
		return CSweeper(self.__IProject.Sweeper)


	@property
	def SwitchLists(self) -> CSwitchLists:
		"""Returns a reference to a collection of MWOffice SwitchList objects."""
		return CSwitchLists(self.__IProject.SwitchLists)


	@property
	def SymbolFiles(self) -> CSymbolFiles:
		"""Returns a reference to a collection of SymbolFile objects."""
		return CSymbolFiles(self.__IProject.SymbolFiles)


	@property
	def Symbols(self) -> CSymbols:
		"""Returns a reference to a collection of Symbol objects."""
		return CSymbols(self.__IProject.Symbols)


	@property
	def Synthesizer(self) -> CSynthesizer:
		"""Returns a reference to a Synthesis object."""
		return CSynthesizer(self.__IProject.Synthesizer)


	@property
	def SystemDiagrams(self) -> CSystemDiagrams:
		"""Returns a reference to a collection of SystemDiagram objects."""
		return CSystemDiagrams(self.__IProject.SystemDiagrams)


	@property
	def TreeView(self) -> CProjectTreeView:
		"""Returns a reference to the MWOffice project TreeView object."""
		return CProjectTreeView(self.__IProject.TreeView)


	@property
	def Tuner(self) -> CTuner:
		"""Returns a reference to a MWOffice Tuner object."""
		return CTuner(self.__IProject.Tuner)


	@property
	def Units(self) -> CUnits:
		"""Returns a reference to a collection of Unit objects."""
		return CUnits(self.__IProject.Units)


	@property
	def UserFolders(self) -> CUserFolder:
		"""Returns a reference to a MWOffice Folders collection."""
		return CUserFolder(self.__IProject.UserFolders)


	@property
	def VersionControls(self) -> CVersionControls:
		"""Returns a reference to a MWOffice Version Controls collection."""
		return CVersionControls(self.__IProject.VersionControls)


	@property
	def WizardDocs(self) -> CWizardDocs:
		"""Returns a reference to a MWOffice WizardDocs collection."""
		return CWizardDocs(self.__IProject.WizardDocs)


	@property
	def Wizards(self) -> CWizards:
		"""Returns a reference to a MWOffice Wizards collection."""
		return CWizards(self.__IProject.Wizards)


	@property
	def YieldAnalyzer(self) -> COptimizer:
		"""Returns a reference to the Optimizer object."""
		return COptimizer(self.__IProject.YieldAnalyzer)


	@property
	def YieldGoals(self) -> CYieldGoals:
		"""Returns a reference to a collection of Goal objects."""
		return CYieldGoals(self.__IProject.YieldGoals)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ProjectFile
class CProjectFile:
	"""A MWOffice ProjectFile object."""
	def __init__(self, projectfile):
		self.__IProjectFile = projectfile

	def _get_inner(self):
		return self.__IProjectFile



	@property
	def AccessDate(self) -> str:
		"""Returns the date of the last access for this ProjectFile."""
		return self.__IProjectFile.AccessDate


	@property
	def Name(self) -> str:
		"""Returns the name of the ProjectFile."""
		return self.__IProjectFile.Name


	@property
	def Path(self) -> str:
		"""Returns the full path to the ProjectFile."""
		return self.__IProjectFile.Path


	@property
	def UseCount(self) -> int:
		"""Returns a count of the number of accesses for this ProjectFile."""
		return self.__IProjectFile.UseCount


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ProjectFiles
class CProjectFiles:
	"""A collection of MWOffice ProjectFile objects."""
	def __init__(self, projectfiles):
		self.__IProjectFiles = projectfiles

	def _get_inner(self):
		return self.__IProjectFiles



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IProjectFiles.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IProjectFiles.Exists(Index)


	def Item(self, Index) -> CProjectFile:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CProjectFile(self.__IProjectFiles.Item(Index))


	def __get_Item(self, Index) -> CProjectFile:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CProjectFile(self.__IProjectFiles.Item(Index))


	def __call__(self, index) -> CProjectFile:
		return self.__get_Item(index)


	def __iter__(self) -> CProjectFile:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IProjectFiles.Count


	def __getitem__(self, index) -> Union[CProjectFile, List[CProjectFile]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ControlBar
class CControlBar:
	"""An MWOffice ControlBar object."""
	def __init__(self, controlbar):
		self.__IControlBar = controlbar

	def _get_inner(self):
		return self.__IControlBar


	def Dock(self) -> None:
		"""Docks a ControlBar object."""
		self.__IControlBar.Dock()


	def Float(self) -> None:
		"""Floats a ControlBar object."""
		self.__IControlBar.Float()


	def LoadSettings(self) -> None:
		"""Sets the ControlBar properties to those previously saved."""
		self.__IControlBar.LoadSettings()


	def SaveSettings(self) -> None:
		"""Saves the current ControlBar properties."""
		self.__IControlBar.SaveSettings()



	@property
	def Align(self):
		"""Returns/sets the border a ControlBar object is docked to."""
		return self.__IControlBar.Align


	@Align.setter
	def Align(self, value: mwDockBorder):
		"""Returns/sets the border a ControlBar object is docked to."""
		self.__IControlBar.Align = value


	@property
	def Caption(self) -> str:
		"""Returns/Sets the caption of an object."""
		return self.__IControlBar.Caption


	@Caption.setter
	def Caption(self, value: str):
		"""Returns/Sets the caption of an object."""
		self.__IControlBar.Caption = value


	@property
	def ControlBarItems(self) -> CControlBarItems:
		"""Returns a reference to a ControlBarItem objects."""
		return CControlBarItems(self.__IControlBar.ControlBarItems)


	@property
	def DockState(self):
		"""Returns/sets the DockState state of a ControlBar object."""
		return self.__IControlBar.DockState


	@DockState.setter
	def DockState(self, value: mwDockState):
		"""Returns/sets the DockState state of a ControlBar object."""
		self.__IControlBar.DockState = value


	@property
	def FloatingCols(self) -> int:
		"""Returns/sets the number of columns the ControlBar has when it is Floating."""
		return self.__IControlBar.FloatingCols


	@FloatingCols.setter
	def FloatingCols(self, value: int):
		"""Returns/sets the number of columns the ControlBar has when it is Floating."""
		self.__IControlBar.FloatingCols = value


	@property
	def FloatingRows(self) -> int:
		"""Returns/sets the number of rows the ControlBar has when it is Floating."""
		return self.__IControlBar.FloatingRows


	@FloatingRows.setter
	def FloatingRows(self, value: int):
		"""Returns/sets the number of rows the ControlBar has when it is Floating."""
		self.__IControlBar.FloatingRows = value


	@property
	def InitiallyVisible(self) -> bool:
		"""Returns/sets whether the ControlBar is initially Visible."""
		return self.__IControlBar.InitiallyVisible


	@InitiallyVisible.setter
	def InitiallyVisible(self, value: bool):
		"""Returns/sets whether the ControlBar is initially Visible."""
		self.__IControlBar.InitiallyVisible = value


	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__IControlBar.Name


	@property
	def Visible(self) -> bool:
		"""Returns/sets the visible state of a ControlBar object."""
		return self.__IControlBar.Visible


	@Visible.setter
	def Visible(self, value: bool):
		"""Returns/sets the visible state of a ControlBar object."""
		self.__IControlBar.Visible = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ControlBars
class CControlBars:
	"""A collection of MWOffice ControlBar objects."""
	def __init__(self, controlbars):
		self.__IControlBars = controlbars

	def _get_inner(self):
		return self.__IControlBars



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IControlBars.Count


	def Item(self, Index) -> CControlBar:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CControlBar(self.__IControlBars.Item(Index))


	def __get_Item(self, Index) -> CControlBar:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CControlBar(self.__IControlBars.Item(Index))


	def __call__(self, index) -> CControlBar:
		return self.__get_Item(index)


	def __iter__(self) -> CControlBar:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IControlBars.Count


	def __getitem__(self, index) -> Union[CControlBar, List[CControlBar]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DataFile
class CDataFile:
	"""An MWOffice Datafile object."""
	def __init__(self, datafile):
		self.__IDataFile = datafile

	def _get_inner(self):
		return self.__IDataFile


	def Activate(self) -> None:
		"""Activates the objects."""
		self.__IDataFile.Activate()


	def NewWindow(self) -> CWindow:
		"""Displays the object in new window."""
		return CWindow(self.__IDataFile.NewWindow())


	def PrintOut(self) -> None:
		"""Sends the object to the current printer."""
		self.__IDataFile.PrintOut()


	def Export(self, FilePath: str) -> bool:
		"""Exports a design document file from MWOffice."""
		return self.__IDataFile.Export(FilePath)


	def IsSimulationStateFlagSet(self, flag: mwSimStateFlags) -> bool:
		"""Returns a value that indicates if a certain simulation state flag is set."""
		return self.__IDataFile.IsSimulationStateFlagSet(flag)


	def Embed(self) -> None:
		"""Convert an externally linked data file into an embedded document."""
		self.__IDataFile.Embed()


	def LinkToFile(self, FilePath: str) -> None:
		"""Convert an embedded data file into an externally linked document."""
		self.__IDataFile.LinkToFile(FilePath)


	def Reload(self) -> None:
		"""Reload an externally linked data file."""
		self.__IDataFile.Reload()


	def Save(self) -> None:
		"""Update the externally linked data file."""
		self.__IDataFile.Save()



	@property
	def DataAsText(self) -> str:
		"""Returns/sets the text value of a Datafile object."""
		return self.__IDataFile.DataAsText


	@DataAsText.setter
	def DataAsText(self, value: str):
		"""Returns/sets the text value of a Datafile object."""
		self.__IDataFile.DataAsText = value


	@property
	def Embedded(self) -> bool:
		"""Returns a value which specifies if the Datafile object is embedded."""
		return self.__IDataFile.Embedded


	@property
	def FilePath(self) -> str:
		"""Returns the Datafile, file path."""
		return self.__IDataFile.FilePath


	@property
	def Modified(self) -> bool:
		"""Returns/sets if the data file status is modified."""
		return self.__IDataFile.Modified


	@Modified.setter
	def Modified(self, value: bool):
		"""Returns/sets if the data file status is modified."""
		self.__IDataFile.Modified = value


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IDataFile.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__IDataFile.Name = value


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__IDataFile.Options)


	@property
	def PortCount(self) -> int:
		"""Returns a count of the ports for this MWOffice Datafile object."""
		return self.__IDataFile.PortCount


	@property
	def ReadOnly(self) -> bool:
		"""Returns/sets if the data file is read-only."""
		return self.__IDataFile.ReadOnly


	@ReadOnly.setter
	def ReadOnly(self, value: bool):
		"""Returns/sets if the data file is read-only."""
		self.__IDataFile.ReadOnly = value


	@property
	def ShowPortNames(self) -> bool:
		"""Returns/Sets a value indicating if port names should be shown for this Datafile object."""
		return self.__IDataFile.ShowPortNames


	@ShowPortNames.setter
	def ShowPortNames(self, value: bool):
		"""Returns/Sets a value indicating if port names should be shown for this Datafile object."""
		self.__IDataFile.ShowPortNames = value


	@property
	def SimulationDirty(self) -> bool:
		"""Returns if the current simulation state is dirty for the object."""
		return self.__IDataFile.SimulationDirty


	@property
	def SimulationState(self) -> int:
		"""Returns the current simulation state for the object."""
		return self.__IDataFile.SimulationState


	@property
	def Type(self):
		"""Returns the type of the MWOffice Datafile object."""
		return self.__IDataFile.Type


	@property
	def UseProjectOptions(self) -> bool:
		"""Returns/sets a value which specifies if the global project options should be used."""
		return self.__IDataFile.UseProjectOptions


	@UseProjectOptions.setter
	def UseProjectOptions(self, value: bool):
		"""Returns/sets a value which specifies if the global project options should be used."""
		self.__IDataFile.UseProjectOptions = value


	@property
	def Windows(self) -> CWindows:
		"""Returns a reference to a collection of Window objects."""
		return CWindows(self.__IDataFile.Windows)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DataFiles
class CDataFiles:
	"""A collection of MWOffice Datafile objects."""
	def __init__(self, datafiles):
		self.__IDataFiles = datafiles

	def _get_inner(self):
		return self.__IDataFiles


	def Add(self, Name: str, Filename: str, Embedded: bool, Type: mwDataFileType) -> CDataFile:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CDataFile(self.__IDataFiles.Add(Name, Filename, Embedded, Type))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IDataFiles.Remove(Index)


	def Import(self, Name: str, Filename: str, Type: mwDataFileType) -> CDataFile:
		"""Adds an object to the collection from a file and returns a reference to the created object."""
		return CDataFile(self.__IDataFiles.Import(Name, Filename, Type))


	def LinkTo(self, Name: str, Filename: str, Type: mwDataFileType) -> CDataFile:
		"""Adds a DataFile object link to the collection from a file and returns a reference to the created object."""
		return CDataFile(self.__IDataFiles.LinkTo(Name, Filename, Type))


	def AddNew(self, Name: str, Type: mwDataFileType) -> CDataFile:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CDataFile(self.__IDataFiles.AddNew(Name, Type))


	def Copy(self, Index, NewName: str = "") -> CDataFile:
		"""Copies an object from another object collection into this object collection."""
		return CDataFile(self.__IDataFiles.Copy(Index, NewName))


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__IDataFiles.GetUniqueName(baseName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IDataFiles.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IDataFiles.Exists(Index)


	def Item(self, Index) -> CDataFile:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDataFile(self.__IDataFiles.Item(Index))


	def __get_Item(self, Index) -> CDataFile:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDataFile(self.__IDataFiles.Item(Index))


	def __call__(self, index) -> CDataFile:
		return self.__get_Item(index)


	def __iter__(self) -> CDataFile:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IDataFiles.Count


	def __getitem__(self, index) -> Union[CDataFile, List[CDataFile]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__IDataFiles.Options)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SampleProjectItem
class CSampleProjectItem:
	"""An MWOffice SampleProjectItem object."""
	def __init__(self, sampleprojectitem):
		self.__ISampleProjectItem = sampleprojectitem

	def _get_inner(self):
		return self.__ISampleProjectItem



	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__ISampleProjectItem.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__ISampleProjectItem.Name = value


	@property
	def TreeNode(self) -> CTreeNode:
		"""Returns a reference to a MWOffice TreeNode object."""
		return CTreeNode(self.__ISampleProjectItem.TreeNode)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SampleProjectItems
class CSampleProjectItems:
	"""A collection of MWOffice SampleProjectItem objects."""
	def __init__(self, sampleprojectitems):
		self.__ISampleProjectItems = sampleprojectitems

	def _get_inner(self):
		return self.__ISampleProjectItems


	def Add(self, Name: str) -> CSampleProjectItem:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CSampleProjectItem(self.__ISampleProjectItems.Add(Name))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ISampleProjectItems.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__ISampleProjectItems.RemoveAll()


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__ISampleProjectItems.GetUniqueName(baseName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ISampleProjectItems.Count


	def Item(self, Index) -> CSampleProjectItem:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSampleProjectItem(self.__ISampleProjectItems.Item(Index))


	def __get_Item(self, Index) -> CSampleProjectItem:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSampleProjectItem(self.__ISampleProjectItems.Item(Index))


	def __call__(self, index) -> CSampleProjectItem:
		return self.__get_Item(index)


	def __iter__(self) -> CSampleProjectItem:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ISampleProjectItems.Count


	def __getitem__(self, index) -> Union[CSampleProjectItem, List[CSampleProjectItem]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DataSetItemProperty
class CDataSetItemProperty:
	"""An MWOffice DAtaSetItemProperty object."""
	def __init__(self, datasetitemproperty):
		self.__IDataSetItemProperty = datasetitemproperty

	def _get_inner(self):
		return self.__IDataSetItemProperty



	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__IDataSetItemProperty.Name


	@property
	def Value(self) -> str:
		"""Returns the value for this DataSetPropety object."""
		return self.__IDataSetItemProperty.Value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DataSetItemProperties
class CDataSetItemProperties:
	"""A collection of MWOffice DataSetItemProperty objects."""
	def __init__(self, datasetitemproperties):
		self.__IDataSetItemProperties = datasetitemproperties

	def _get_inner(self):
		return self.__IDataSetItemProperties



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IDataSetItemProperties.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IDataSetItemProperties.Exists(Index)


	def Item(self, Index) -> CDataSetItemProperty:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDataSetItemProperty(self.__IDataSetItemProperties.Item(Index))


	def __get_Item(self, Index) -> CDataSetItemProperty:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDataSetItemProperty(self.__IDataSetItemProperties.Item(Index))


	def __call__(self, index) -> CDataSetItemProperty:
		return self.__get_Item(index)


	def __iter__(self) -> CDataSetItemProperty:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IDataSetItemProperties.Count


	def __getitem__(self, index) -> Union[CDataSetItemProperty, List[CDataSetItemProperty]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DataSetItem
class CDataSetItem:
	"""An MWOffice DataSetItem object."""
	def __init__(self, datasetitem):
		self.__IDataSetItem = datasetitem

	def _get_inner(self):
		return self.__IDataSetItem



	@property
	def DataSize(self) -> int:
		"""Returns the data size for the MWOffice DataSetItem object."""
		return self.__IDataSetItem.DataSize


	@property
	def FrequencyPoint(self) -> float:
		"""Returns the frequency point for the data set item if it has one."""
		return self.__IDataSetItem.FrequencyPoint


	@property
	def HasFrequency(self) -> bool:
		"""Returns if the data set item has a freqeunce point"""
		return self.__IDataSetItem.HasFrequency


	@property
	def ItemIndex(self) -> int:
		"""Returns the index of the MWOffice DataSetItem object."""
		return self.__IDataSetItem.ItemIndex


	@property
	def ItemInfo(self) -> str:
		"""Returns a summary of the data set item properties."""
		return self.__IDataSetItem.ItemInfo


	@property
	def Properties(self) -> CDataSetItemProperties:
		"""Returns a reference to a collection of MWOffice DataSetItemProperty objects."""
		return CDataSetItemProperties(self.__IDataSetItem.Properties)


	@property
	def SweepID(self) -> int:
		"""Returns the sweep identifier for the MWOffice DataSetItem object."""
		return self.__IDataSetItem.SweepID


	@property
	def SweepSet(self) -> int:
		"""Returns the sweep set identifier for the MWOffice DataSetItem object."""
		return self.__IDataSetItem.SweepSet


	@property
	def Type(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__IDataSetItem.Type


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DataSetItems
class CDataSetItems:
	"""A collection of MWOffice DataSetItem objects."""
	def __init__(self, datasetitems):
		self.__IDataSetItems = datasetitems

	def _get_inner(self):
		return self.__IDataSetItems



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IDataSetItems.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IDataSetItems.Exists(Index)


	def Item(self, Index) -> CDataSetItem:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDataSetItem(self.__IDataSetItems.Item(Index))


	def __get_Item(self, Index) -> CDataSetItem:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDataSetItem(self.__IDataSetItems.Item(Index))


	def __call__(self, index) -> CDataSetItem:
		return self.__get_Item(index)


	def __iter__(self) -> CDataSetItem:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IDataSetItems.Count


	def __getitem__(self, index) -> Union[CDataSetItem, List[CDataSetItem]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DataSetProperty
class CDataSetProperty:
	"""An MWOffice DataSetProperty object."""
	def __init__(self, datasetproperty):
		self.__IDataSetProperty = datasetproperty

	def _get_inner(self):
		return self.__IDataSetProperty



	@property
	def Description(self) -> str:
		"""Returns a description of this DataSetProperty object."""
		return self.__IDataSetProperty.Description


	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__IDataSetProperty.Name


	@property
	def Type(self) -> int:
		"""Returns the type of this DataSetProperty object."""
		return self.__IDataSetProperty.Type


	@property
	def Value(self):
		"""Returns the value for this DataSetPropety object."""
		return self.__IDataSetProperty.Value


	@property
	def ValueAsString(self) -> str:
		"""Returns the value of this DataSetProperty object converted to a string."""
		return self.__IDataSetProperty.ValueAsString


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DataSetProperties
class CDataSetProperties:
	"""A collection of MWOffice DataSetProperty objects."""
	def __init__(self, datasetproperties):
		self.__IDataSetProperties = datasetproperties

	def _get_inner(self):
		return self.__IDataSetProperties



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IDataSetProperties.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IDataSetProperties.Exists(Index)


	def Item(self, Index) -> CDataSetProperty:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDataSetProperty(self.__IDataSetProperties.Item(Index))


	def __get_Item(self, Index) -> CDataSetProperty:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDataSetProperty(self.__IDataSetProperties.Item(Index))


	def __call__(self, index) -> CDataSetProperty:
		return self.__get_Item(index)


	def __iter__(self) -> CDataSetProperty:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IDataSetProperties.Count


	def __getitem__(self, index) -> Union[CDataSetProperty, List[CDataSetProperty]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DataSet
class CDataSet:
	"""An MWOffice DataSet object."""
	def __init__(self, dataset):
		self.__IDataSet = dataset

	def _get_inner(self):
		return self.__IDataSet


	def UpdateResults(self, vbEnableMeasurements: bool = -1, vbAddMissingMeasurements: bool = -1) -> None:
		"""Updates the results of the data set."""
		self.__IDataSet.UpdateResults(vbEnableMeasurements, vbAddMissingMeasurements)


	def UpdateClock(self) -> None:
		"""Updates the clock if the data set current."""
		self.__IDataSet.UpdateClock()



	@property
	def AutoDelete(self) -> bool:
		"""Returns/sets the auto-delete state of the data set object."""
		return self.__IDataSet.AutoDelete


	@AutoDelete.setter
	def AutoDelete(self, value: bool):
		"""Returns/sets the auto-delete state of the data set object."""
		self.__IDataSet.AutoDelete = value


	@property
	def Current(self) -> bool:
		"""Returns true if the data set is current."""
		return self.__IDataSet.Current


	@property
	def DataItems(self) -> CDataSetItems:
		"""Returns a refernces to a collection of MWOffice DataSetItem objects."""
		return CDataSetItems(self.__IDataSet.DataItems)


	@property
	def DocumentName(self) -> str:
		"""Returns the name of the document associated with the data set object."""
		return self.__IDataSet.DocumentName


	@property
	def Filename(self) -> str:
		"""Returns the file name of the data set object."""
		return self.__IDataSet.Filename


	def Flags(self, dataSetFlag: mwDataSetFlags) -> bool:
		"""Returns the state of flags associated with the data set."""
		return self.__IDataSet.Flags(dataSetFlag)


	@property
	def LogInfo(self) -> str:
		"""Returns a string that contains details of the simulate lot for the data set."""
		return self.__IDataSet.LogInfo


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IDataSet.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__IDataSet.Name = value


	@property
	def Pinned(self) -> bool:
		"""Returns/sets the pinned state of the data set object."""
		return self.__IDataSet.Pinned


	@Pinned.setter
	def Pinned(self, value: bool):
		"""Returns/sets the pinned state of the data set object."""
		self.__IDataSet.Pinned = value


	@property
	def Properties(self) -> CDataSetProperties:
		"""Returns a reference to a collection of MWOffice DataSetProperty objects."""
		return CDataSetProperties(self.__IDataSet.Properties)


	@property
	def SimInfo(self) -> str:
		"""Returns a string that contains details of the simulation info for the data set."""
		return self.__IDataSet.SimInfo


	@property
	def SimulatorName(self) -> str:
		"""Returns the simulator used by the data set object."""
		return self.__IDataSet.SimulatorName


	@property
	def SubDataSets(self) -> CDataSets:
		"""Returns a reference to a collection of DataSet objects."""
		return CDataSets(self.__IDataSet.SubDataSets)


	@property
	def TreeNode(self) -> CTreeNode:
		"""Returns a reference to a MWOffice TreeNode object."""
		return CTreeNode(self.__IDataSet.TreeNode)


	@property
	def UserName(self) -> str:
		"""Returns the user assigned name of the data set object."""
		return self.__IDataSet.UserName


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DataSets
class CDataSets:
	"""A collection of MWOffice DataSet objects."""
	def __init__(self, datasets):
		self.__IDataSets = datasets

	def _get_inner(self):
		return self.__IDataSets


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IDataSets.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IDataSets.RemoveAll()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IDataSets.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IDataSets.Exists(Index)


	def Item(self, Index) -> CDataSet:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDataSet(self.__IDataSets.Item(Index))


	def __get_Item(self, Index) -> CDataSet:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDataSet(self.__IDataSets.Item(Index))


	def __call__(self, index) -> CDataSet:
		return self.__get_Item(index)


	def __iter__(self) -> CDataSet:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IDataSets.Count


	def __getitem__(self, index) -> Union[CDataSet, List[CDataSet]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DataSetFolder
class CDataSetFolder:
	"""An MWOffice DataSetFolder object."""
	def __init__(self, datasetfolder):
		self.__IDataSetFolder = datasetfolder

	def _get_inner(self):
		return self.__IDataSetFolder



	@property
	def DataSets(self) -> CDataSets:
		"""Returns a reference to a collection of DataSet objects."""
		return CDataSets(self.__IDataSetFolder.DataSets)


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IDataSetFolder.Name


	@property
	def TreeNode(self) -> CTreeNode:
		"""Returns a reference to a MWOffice TreeNode object."""
		return CTreeNode(self.__IDataSetFolder.TreeNode)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DataSetFolders
class CDataSetFolders:
	"""A collection of MWOffice DataSetFolder objects."""
	def __init__(self, datasetfolders):
		self.__IDataSetFolders = datasetfolders

	def _get_inner(self):
		return self.__IDataSetFolders


	def AddGraphDataSet(self, Name: str) -> CDataSet:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CDataSet(self.__IDataSetFolders.AddGraphDataSet(Name))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IDataSetFolders.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IDataSetFolders.RemoveAll()


	def Import(self, Filename: str) -> CDataSet:
		"""Adds an object to the collection from a file and returns a reference to the created object."""
		return CDataSet(self.__IDataSetFolders.Import(Filename))


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__IDataSetFolders.GetUniqueName(baseName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IDataSetFolders.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IDataSetFolders.Exists(Index)


	def Item(self, Index) -> CDataSetFolder:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDataSetFolder(self.__IDataSetFolders.Item(Index))


	def __get_Item(self, Index) -> CDataSetFolder:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDataSetFolder(self.__IDataSetFolders.Item(Index))


	def __call__(self, index) -> CDataSetFolder:
		return self.__get_Item(index)


	def __iter__(self) -> CDataSetFolder:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IDataSetFolders.Count


	def __getitem__(self, index) -> Union[CDataSetFolder, List[CDataSetFolder]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__IDataSetFolders.Options)


	@property
	def UpdateDependents(self) -> bool:
		"""Returns the whether updating the dependent data sets is enabled."""
		return self.__IDataSetFolders.UpdateDependents


	@UpdateDependents.setter
	def UpdateDependents(self, value: bool):
		"""Returns the whether updating the dependent data sets is enabled."""
		self.__IDataSetFolders.UpdateDependents = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# OutputFile
class COutputFile:
	"""An MWOffice OutputFile object."""
	def __init__(self, outputfile):
		self.__IOutputFile = outputfile

	def _get_inner(self):
		return self.__IOutputFile



	@property
	def Enabled(self) -> bool:
		"""Returns/sets a value which specifies if the object is enabled."""
		return self.__IOutputFile.Enabled


	@Enabled.setter
	def Enabled(self, value: bool):
		"""Returns/sets a value which specifies if the object is enabled."""
		self.__IOutputFile.Enabled = value


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IOutputFile.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__IOutputFile.Name = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# OutputFiles
class COutputFiles:
	"""A collection of MWOffice OutputFile objects."""
	def __init__(self, outputfiles):
		self.__IOutputFiles = outputfiles

	def _get_inner(self):
		return self.__IOutputFiles


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IOutputFiles.Remove(Index)


	def RemoveAll(self) -> None:
		"""Removes all objects in a collection."""
		self.__IOutputFiles.RemoveAll()


	def Add(self, SourceDoc: str, Measurement: str) -> COutputFile:
		"""Adds an object to the collection and returns a reference to the created object."""
		return COutputFile(self.__IOutputFiles.Add(SourceDoc, Measurement))


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__IOutputFiles.GetUniqueName(baseName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IOutputFiles.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IOutputFiles.Exists(Index)


	def Item(self, Index) -> COutputFile:
		"""Returns a specific item of a Collection object either by position or by key."""
		return COutputFile(self.__IOutputFiles.Item(Index))


	def __get_Item(self, Index) -> COutputFile:
		"""Returns a specific item of a Collection object either by position or by key."""
		return COutputFile(self.__IOutputFiles.Item(Index))


	def __call__(self, index) -> COutputFile:
		return self.__get_Item(index)


	def __iter__(self) -> COutputFile:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IOutputFiles.Count


	def __getitem__(self, index) -> Union[COutputFile, List[COutputFile]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Frequency
class CFrequency:
	"""An MWOffice Frequency object."""
	def __init__(self, frequency):
		self.__IFrequency = frequency

	def _get_inner(self):
		return self.__IFrequency



	@property
	def Value(self) -> float:
		"""Returns/sets the value of a Frequency object."""
		return self.__IFrequency.Value


	@Value.setter
	def Value(self, value: float):
		"""Returns/sets the value of a Frequency object."""
		self.__IFrequency.Value = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Frequencies
class CFrequencies:
	"""A collection of MWOffice Frequency objects."""
	def __init__(self, frequencies):
		self.__IFrequencies = frequencies

	def _get_inner(self):
		return self.__IFrequencies


	def Add(self, Value: float) -> CFrequency:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CFrequency(self.__IFrequencies.Add(Value))


	def Remove(self, Index: int) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IFrequencies.Remove(Index)


	def Clear(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IFrequencies.Clear()


	def AddMultiple(self, Values) -> None:
		"""Adds multiple Frequency objects to the collection."""
		self.__IFrequencies.AddMultiple(Values)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IFrequencies.Count


	def Item(self, Index: int) -> CFrequency:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CFrequency(self.__IFrequencies.Item(Index))


	def __get_Item(self, Index: int) -> CFrequency:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CFrequency(self.__IFrequencies.Item(Index))


	def __call__(self, index) -> CFrequency:
		return self.__get_Item(index)


	def __iter__(self) -> CFrequency:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IFrequencies.Count


	def __getitem__(self, index) -> Union[CFrequency, List[CFrequency]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Element
class CElement:
	"""An MWOffice Element object."""
	def __init__(self, element):
		self.__IElement = element

	def _get_inner(self):
		return self.__IElement


	def Delete(self) -> bool:
		"""Removes the object."""
		return self.__IElement.Delete()


	def Move(self, dx: int, dy: int, CCWRotatation: float = 0, Flip: bool = 0, HorizontalAxis: bool = 0, OriginX: float = 0, OriginY: float = 0) -> bool:
		"""Moves DrawingShape object by the given values relative to the current location."""
		return self.__IElement.Move(dx, dy, CCWRotatation, Flip, HorizontalAxis, OriginX, OriginY)


	def Swap(self, newElemName: str) -> bool:
		"""Replaces the element in-place with an element of the spacified type."""
		return self.__IElement.Swap(newElemName)



	@property
	def Attributes(self) -> CAttributes:
		"""Returns a reference to a collection of Attribute objects."""
		return CAttributes(self.__IElement.Attributes)


	@property
	def CellName(self) -> str:
		"""Returns/sets the layout cell name associated with an element."""
		return self.__IElement.CellName


	@CellName.setter
	def CellName(self, value: str):
		"""Returns/sets the layout cell name associated with an element."""
		self.__IElement.CellName = value


	def DisplayMode(self, mode: mwDisplayModeType) -> bool:
		"""Returns/Sets various Element display mode settings."""
		return self.__IElement.DisplayMode(mode)


	def SetDisplayMode(self, mode: mwDisplayModeType, value: bool):
		"""Returns/Sets various Element display mode settings."""
		self.__IElement.DisplayMode = value


	@property
	def DrawingObjects(self) -> CDrawingObjects:
		"""Returns a reference to a collection of DrawingObjects."""
		return CDrawingObjects(self.__IElement.DrawingObjects)


	@property
	def Enabled(self) -> bool:
		"""Returns/sets a value which specifies if the Element object is enabled."""
		return self.__IElement.Enabled


	@Enabled.setter
	def Enabled(self, value: bool):
		"""Returns/sets a value which specifies if the Element object is enabled."""
		self.__IElement.Enabled = value


	@property
	def Flipped(self) -> bool:
		"""Returns a value which specifies if the Element object is flipped."""
		return self.__IElement.Flipped


	@Flipped.setter
	def Flipped(self, value: bool):
		"""Returns a value which specifies if the Element object is flipped."""
		self.__IElement.Flipped = value


	@property
	def Frozen(self) -> bool:
		"""Returns/sets a value that indicates if the Element object is frozen."""
		return self.__IElement.Frozen


	@Frozen.setter
	def Frozen(self, value: bool):
		"""Returns/sets a value that indicates if the Element object is frozen."""
		self.__IElement.Frozen = value


	@property
	def HasLayoutCell(self) -> bool:
		"""Returns if the Element has an associated layout cell."""
		return self.__IElement.HasLayoutCell


	@property
	def Height(self) -> int:
		"""Returns the height of a Symbol object."""
		return self.__IElement.Height


	@property
	def Left(self) -> int:
		"""Returns the left edge of a Symbol object."""
		return self.__IElement.Left


	@property
	def LockParameterizedLayout(self) -> bool:
		"""Returns/sets a value that indicates if the Element's parameterized layout update is locked."""
		return self.__IElement.LockParameterizedLayout


	@LockParameterizedLayout.setter
	def LockParameterizedLayout(self, value: bool):
		"""Returns/sets a value that indicates if the Element's parameterized layout update is locked."""
		self.__IElement.LockParameterizedLayout = value


	@property
	def MultiplicityFactor(self) -> int:
		"""Returns the multiplicity factor for the Element object."""
		return self.__IElement.MultiplicityFactor


	@property
	def MultiplicityFactorParameterName(self) -> str:
		"""Returns/sets the name of the element parameter to be used for the multiplicity factor."""
		return self.__IElement.MultiplicityFactorParameterName


	@MultiplicityFactorParameterName.setter
	def MultiplicityFactorParameterName(self, value: str):
		"""Returns/sets the name of the element parameter to be used for the multiplicity factor."""
		self.__IElement.MultiplicityFactorParameterName = value


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IElement.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__IElement.Name = value


	@property
	def NameVisible(self) -> bool:
		"""Returns/sets a value which specifies if the Element name is visible."""
		return self.__IElement.NameVisible


	@NameVisible.setter
	def NameVisible(self, value: bool):
		"""Returns/sets a value which specifies if the Element name is visible."""
		self.__IElement.NameVisible = value


	@property
	def Nodes(self) -> CNodes:
		"""Returns a reference to a collection of Node objects."""
		return CNodes(self.__IElement.Nodes)


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__IElement.Options)


	@property
	def ParameterFrame(self) -> CParameterFrame:
		"""Returns a reference to a ParameterFrame object."""
		return CParameterFrame(self.__IElement.ParameterFrame)


	@property
	def Parameters(self) -> CParameters:
		"""Returns a reference to a collection of Parameter objects."""
		return CParameters(self.__IElement.Parameters)


	@property
	def PartHelpPath(self) -> str:
		"""Returns/sets the part help path property of the Element object."""
		return self.__IElement.PartHelpPath


	@PartHelpPath.setter
	def PartHelpPath(self, value: str):
		"""Returns/sets the part help path property of the Element object."""
		self.__IElement.PartHelpPath = value


	@property
	def PartNumber(self) -> str:
		"""Returns/sets the part number of an Element object."""
		return self.__IElement.PartNumber


	@PartNumber.setter
	def PartNumber(self, value: str):
		"""Returns/sets the part number of an Element object."""
		self.__IElement.PartNumber = value


	@property
	def Properties2(self) -> CProperties:
		"""Returns a reference to a collection of Property objects."""
		return CProperties(self.__IElement.Properties2)


	@property
	def RotationAngle(self) -> int:
		"""Returns the rotational angle of an Element object."""
		return self.__IElement.RotationAngle


	@RotationAngle.setter
	def RotationAngle(self, value: int):
		"""Returns the rotational angle of an Element object."""
		self.__IElement.RotationAngle = value


	@property
	def Selected(self) -> bool:
		"""Returns/sets a value which specifies if the object is selected."""
		return self.__IElement.Selected


	@Selected.setter
	def Selected(self, value: bool):
		"""Returns/sets a value which specifies if the object is selected."""
		self.__IElement.Selected = value


	@property
	def Symbol(self) -> str:
		"""Returns the symbol name of an Element object."""
		return self.__IElement.Symbol


	@Symbol.setter
	def Symbol(self, value: str):
		"""Returns the symbol name of an Element object."""
		self.__IElement.Symbol = value


	@property
	def SymbolColor(self) -> int:
		"""Returns/sets the color used to render the Element symbol."""
		return self.__IElement.SymbolColor


	@SymbolColor.setter
	def SymbolColor(self, value: int):
		"""Returns/sets the color used to render the Element symbol."""
		self.__IElement.SymbolColor = value


	@property
	def Top(self) -> int:
		"""Returns the top edge of a Symbol object."""
		return self.__IElement.Top


	@property
	def Type(self):
		"""Returns the type of this Element (Circuit or System)."""
		return self.__IElement.Type


	@property
	def UniqueID(self) -> int:
		"""Returns the numerical unique identifier for this element."""
		return self.__IElement.UniqueID


	@property
	def UseDefaultModelOptions(self) -> bool:
		"""Returns/sets a value which specifies if the default inherited options should be used."""
		return self.__IElement.UseDefaultModelOptions


	@UseDefaultModelOptions.setter
	def UseDefaultModelOptions(self, value: bool):
		"""Returns/sets a value which specifies if the default inherited options should be used."""
		self.__IElement.UseDefaultModelOptions = value


	@property
	def UseDefaultSymbolColor(self) -> bool:
		"""Returns/sets a value that indicates if an Element's symbol is drawn using the default color."""
		return self.__IElement.UseDefaultSymbolColor


	@UseDefaultSymbolColor.setter
	def UseDefaultSymbolColor(self, value: bool):
		"""Returns/sets a value that indicates if an Element's symbol is drawn using the default color."""
		self.__IElement.UseDefaultSymbolColor = value


	@property
	def VectorInstanceCount(self) -> int:
		"""Returns the vector instance count for the Element object."""
		return self.__IElement.VectorInstanceCount


	@property
	def VectorInstanceName(self) -> str:
		"""Returns/sets the vector instance property name for an element."""
		return self.__IElement.VectorInstanceName


	@VectorInstanceName.setter
	def VectorInstanceName(self, value: str):
		"""Returns/sets the vector instance property name for an element."""
		self.__IElement.VectorInstanceName = value


	@property
	def Width(self) -> int:
		"""Returns the width of a Symbol object."""
		return self.__IElement.Width


	@property
	def XmlBrowserPath(self) -> str:
		"""Returns the XML broswer path of an Element object. Empty if not placed from XML."""
		return self.__IElement.XmlBrowserPath


	@property
	def XmlComponentPath(self) -> str:
		"""Returns the XML component path of an Element object. Empty if not placed from XML."""
		return self.__IElement.XmlComponentPath


	@property
	def x(self) -> int:
		"""Returns the X value of a Element object."""
		return self.__IElement.x


	@x.setter
	def x(self, value: int):
		"""Returns the X value of a Element object."""
		self.__IElement.x = value


	@property
	def y(self) -> int:
		"""Returns the Y value of a Element object."""
		return self.__IElement.y


	@y.setter
	def y(self, value: int):
		"""Returns the Y value of a Element object."""
		self.__IElement.y = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Elements
class CElements:
	"""A collection of MWOffice Element objects."""
	def __init__(self, elements):
		self.__IElements = elements

	def _get_inner(self):
		return self.__IElements


	def Add(self, Name: str, x: int, y: int, RotationAngle: int = 0, Flipped: bool = 0, Symbol: str = "") -> CElement:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CElement(self.__IElements.Add(Name, x, y, RotationAngle, Flipped, Symbol))


	def AddSubcircuit(self, SubcircuitName: str, x: int, y: int, RotationAngle: int = 0, Flipped: bool = 0, Symbol: str = "", GndType: mwSubcktGroundType = 0) -> CElement:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CElement(self.__IElements.AddSubcircuit(SubcircuitName, x, y, RotationAngle, Flipped, Symbol, GndType))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IElements.Remove(Index)


	def AddDataFile(self, Path: str, x: int, y: int, Embedded: bool = -1, RotationAngle: int = 0, Flipped: bool = 0, Symbol: str = "") -> CElement:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CElement(self.__IElements.AddDataFile(Path, x, y, Embedded, RotationAngle, Flipped, Symbol))


	def AddModelFile(self, Path: str, x: int, y: int, DefaultName: str = "", Type: mwModelParseType = 0, RotationAngle: int = 0, Flipped: bool = 0, Symbol: str = "") -> CElement:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CElement(self.__IElements.AddModelFile(Path, x, y, DefaultName, Type, RotationAngle, Flipped, Symbol))


	def AddXMLComponent(self, XPath: str, x: int, y: int, RotationAngle: int = 0, Flipped: bool = 0, Symbol: str = "") -> CElement:
		"""Adds a XML component specified by an XPath to the collection and returns a reference to the created object."""
		return CElement(self.__IElements.AddXMLComponent(XPath, x, y, RotationAngle, Flipped, Symbol))


	def AddLibraryElement(self, BrowserPath: str, x: int, y: int, RotationAngle: int = 0, Flipped: bool = 0, Symbol: str = "") -> CElement:
		"""Adds a LibraryElement specified by browser path to the collection and returns a reference to the created object."""
		return CElement(self.__IElements.AddLibraryElement(BrowserPath, x, y, RotationAngle, Flipped, Symbol))


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IElements.RemoveAll()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IElements.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IElements.Exists(Index)


	def Item(self, Index) -> CElement:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CElement(self.__IElements.Item(Index))


	def __get_Item(self, Index) -> CElement:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CElement(self.__IElements.Item(Index))


	def __call__(self, index) -> CElement:
		return self.__get_Item(index)


	def __iter__(self) -> CElement:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IElements.Count


	def __getitem__(self, index) -> Union[CElement, List[CElement]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SelectedElements
class CSelectedElements:
	"""A collection of MWOffice SelectedElement objects."""
	def __init__(self, selectedelements):
		self.__ISelectedElements = selectedelements

	def _get_inner(self):
		return self.__ISelectedElements


	def Add(self, Element: CElement) -> bool:
		"""Adds an object to the collection and returns a reference to the created object."""
		return self.__ISelectedElements.Add(Element._get_inner())


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ISelectedElements.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__ISelectedElements.RemoveAll()


	def AddAll(self) -> bool:
		"""Adds an object to the collection and returns a reference to the created object."""
		return self.__ISelectedElements.AddAll()


	def AddFromArea(self, Left: int, Top: int, Right: int, Bottom: int, Type: mwAreaAddType = 0) -> bool:
		"""Adds the objects contained or overlapped by a given rectangle to the collection."""
		return self.__ISelectedElements.AddFromArea(Left, Top, Right, Bottom, Type)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ISelectedElements.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ISelectedElements.Exists(Index)


	def Item(self, Index) -> CElement:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CElement(self.__ISelectedElements.Item(Index))


	def __get_Item(self, Index) -> CElement:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CElement(self.__ISelectedElements.Item(Index))


	def __call__(self, index) -> CElement:
		return self.__get_Item(index)


	def __iter__(self) -> CElement:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ISelectedElements.Count


	def __getitem__(self, index) -> Union[CElement, List[CElement]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# EquationExpression
class CEquationExpression:
	"""A MWOffice EquationExpression object."""
	def __init__(self, equationexpression):
		self.__IEquationExpression = equationexpression

	def _get_inner(self):
		return self.__IEquationExpression



	@property
	def AffectsLayout(self) -> bool:
		"""Returns/sets if the value affects layout. Valid only for EquationExpression that are exported parameters."""
		return self.__IEquationExpression.AffectsLayout


	@AffectsLayout.setter
	def AffectsLayout(self, value: bool):
		"""Returns/sets if the value affects layout. Valid only for EquationExpression that are exported parameters."""
		self.__IEquationExpression.AffectsLayout = value


	@property
	def Constrain(self) -> bool:
		"""Returns/sets a value which specifies if the object is constrained by the upper and lower limit."""
		return self.__IEquationExpression.Constrain


	@Constrain.setter
	def Constrain(self, value: bool):
		"""Returns/sets a value which specifies if the object is constrained by the upper and lower limit."""
		self.__IEquationExpression.Constrain = value


	@property
	def DataType(self):
		"""Returns/sets a value which specifies the data type of an EquationExpression object."""
		return self.__IEquationExpression.DataType


	@DataType.setter
	def DataType(self, value: mwEquationDataType):
		"""Returns/sets a value which specifies the data type of an EquationExpression object."""
		self.__IEquationExpression.DataType = value


	@property
	def Description(self) -> str:
		"""Returns/sets a string for the description field of the EquationExpression object."""
		return self.__IEquationExpression.Description


	@Description.setter
	def Description(self, value: str):
		"""Returns/sets a string for the description field of the EquationExpression object."""
		self.__IEquationExpression.Description = value


	@property
	def DisplayText(self) -> str:
		"""Returns the display text of the EquationExpression object."""
		return self.__IEquationExpression.DisplayText


	@property
	def Distribution(self):
		"""Returns/sets a value which specifies the distribution type of the object."""
		return self.__IEquationExpression.Distribution


	@Distribution.setter
	def Distribution(self, value: mwStatisticalDist):
		"""Returns/sets a value which specifies the distribution type of the object."""
		self.__IEquationExpression.Distribution = value


	@property
	def Enabled(self) -> bool:
		"""Returns/sets a value which specifies if the object is enabled."""
		return self.__IEquationExpression.Enabled


	@Enabled.setter
	def Enabled(self, value: bool):
		"""Returns/sets a value which specifies if the object is enabled."""
		self.__IEquationExpression.Enabled = value


	@property
	def Exported(self) -> bool:
		"""Returns/sets if the EquationExpression object is exported."""
		return self.__IEquationExpression.Exported


	@property
	def Expression(self) -> str:
		"""Returns/sets the expression of an Equation object."""
		return self.__IEquationExpression.Expression


	@Expression.setter
	def Expression(self, value: str):
		"""Returns/sets the expression of an Equation object."""
		self.__IEquationExpression.Expression = value


	@property
	def HasError(self) -> bool:
		"""Returns if the EquationExpression object has an expression error."""
		return self.__IEquationExpression.HasError


	@property
	def Independent(self) -> bool:
		"""Returns if the EquationExpression object is independent or depends on other variables."""
		return self.__IEquationExpression.Independent


	@property
	def LowerConstraint(self) -> float:
		"""Returns/sets the lower constraint of the object."""
		return self.__IEquationExpression.LowerConstraint


	@LowerConstraint.setter
	def LowerConstraint(self, value: float):
		"""Returns/sets the lower constraint of the object."""
		self.__IEquationExpression.LowerConstraint = value


	@property
	def Optimize(self) -> bool:
		"""Returns/sets a value which specifies if the object is optimized."""
		return self.__IEquationExpression.Optimize


	@Optimize.setter
	def Optimize(self, value: bool):
		"""Returns/sets a value which specifies if the object is optimized."""
		self.__IEquationExpression.Optimize = value


	@property
	def OptimizeYield(self) -> bool:
		"""Returns/sets a value which specifies if the object's yield is optimized."""
		return self.__IEquationExpression.OptimizeYield


	@OptimizeYield.setter
	def OptimizeYield(self, value: bool):
		"""Returns/sets a value which specifies if the object's yield is optimized."""
		self.__IEquationExpression.OptimizeYield = value


	@property
	def PropagationMode(self):
		"""Returns/sets a value which specifies the propagation mode of the object. Used for inherited parameters."""
		return self.__IEquationExpression.PropagationMode


	@PropagationMode.setter
	def PropagationMode(self, value: mwVarPropMode):
		"""Returns/sets a value which specifies the propagation mode of the object. Used for inherited parameters."""
		self.__IEquationExpression.PropagationMode = value


	@property
	def StatVariation(self) -> float:
		"""Returns/sets the statistical variation parameter of the object."""
		return self.__IEquationExpression.StatVariation


	@StatVariation.setter
	def StatVariation(self, value: float):
		"""Returns/sets the statistical variation parameter of the object."""
		self.__IEquationExpression.StatVariation = value


	@property
	def StatVariation2(self) -> float:
		"""Returns/sets the second statistical variation parameter of the object."""
		return self.__IEquationExpression.StatVariation2


	@StatVariation2.setter
	def StatVariation2(self, value: float):
		"""Returns/sets the second statistical variation parameter of the object."""
		self.__IEquationExpression.StatVariation2 = value


	@property
	def StepSize(self) -> float:
		"""Returns/sets the step size used for tuning and discrete optimization of the object."""
		return self.__IEquationExpression.StepSize


	@StepSize.setter
	def StepSize(self, value: float):
		"""Returns/sets the step size used for tuning and discrete optimization of the object."""
		self.__IEquationExpression.StepSize = value


	@property
	def Tag(self) -> str:
		"""Returns/sets the tag value of the object."""
		return self.__IEquationExpression.Tag


	@Tag.setter
	def Tag(self, value: str):
		"""Returns/sets the tag value of the object."""
		self.__IEquationExpression.Tag = value


	@property
	def TolInPercent(self) -> bool:
		"""Returns/sets a value which specifies if the object's total is in percent."""
		return self.__IEquationExpression.TolInPercent


	@TolInPercent.setter
	def TolInPercent(self, value: bool):
		"""Returns/sets a value which specifies if the object's total is in percent."""
		self.__IEquationExpression.TolInPercent = value


	@property
	def Tune(self) -> bool:
		"""Returns/sets a value which specifies if the object is tuned."""
		return self.__IEquationExpression.Tune


	@Tune.setter
	def Tune(self, value: bool):
		"""Returns/sets a value which specifies if the object is tuned."""
		self.__IEquationExpression.Tune = value


	@property
	def UnitType(self):
		"""Returns/sets a value which specifies the unit type of an EquationExpression object."""
		return self.__IEquationExpression.UnitType


	@UnitType.setter
	def UnitType(self, value: mwUnitType):
		"""Returns/sets a value which specifies the unit type of an EquationExpression object."""
		self.__IEquationExpression.UnitType = value


	@property
	def UpperConstraint(self) -> float:
		"""Returns/sets the upper constraint of the object."""
		return self.__IEquationExpression.UpperConstraint


	@UpperConstraint.setter
	def UpperConstraint(self, value: float):
		"""Returns/sets the upper constraint of the object."""
		self.__IEquationExpression.UpperConstraint = value


	@property
	def UseStatistics(self) -> bool:
		"""Returns/sets a value which specifies if the object uses statistics."""
		return self.__IEquationExpression.UseStatistics


	@UseStatistics.setter
	def UseStatistics(self, value: bool):
		"""Returns/sets a value which specifies if the object uses statistics."""
		self.__IEquationExpression.UseStatistics = value


	@property
	def ValueAsComplex(self) -> CComplexNumber:
		"""Returns a reference to a ComplexNumber object."""
		return CComplexNumber(self.__IEquationExpression.ValueAsComplex)


	@property
	def ValueAsDouble(self) -> float:
		"""Returns the value interpreted as a numeric double value."""
		return self.__IEquationExpression.ValueAsDouble


	@property
	def ValueAsDoubleVector(self):
		"""Returns the value of the object as a vector of doubles."""
		return self.__IEquationExpression.ValueAsDoubleVector


	@property
	def ValueAsEvaluatedString(self) -> str:
		"""Returns the evaluated value interpreted as a string value."""
		return self.__IEquationExpression.ValueAsEvaluatedString


	@property
	def ValueAsString(self) -> str:
		"""Returns the value interpreted as a string value."""
		return self.__IEquationExpression.ValueAsString


	@property
	def VariableType(self):
		"""Returns/sets a value which specifies variable type of the EquationExpression object."""
		return self.__IEquationExpression.VariableType


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# EquationExpressions
class CEquationExpressions:
	"""A Collection of EquationExpression objects."""
	def __init__(self, equationexpressions):
		self.__IEquationExpressions = equationexpressions

	def _get_inner(self):
		return self.__IEquationExpressions


	def Add(self, Expression: str) -> CEquationExpression:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CEquationExpression(self.__IEquationExpressions.Add(Expression))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IEquationExpressions.Remove(Index)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IEquationExpressions.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IEquationExpressions.Exists(Index)


	def Item(self, Index) -> CEquationExpression:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CEquationExpression(self.__IEquationExpressions.Item(Index))


	def __get_Item(self, Index) -> CEquationExpression:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CEquationExpression(self.__IEquationExpressions.Item(Index))


	def __call__(self, index) -> CEquationExpression:
		return self.__get_Item(index)


	def __iter__(self) -> CEquationExpression:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IEquationExpressions.Count


	def __getitem__(self, index) -> Union[CEquationExpression, List[CEquationExpression]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Equation
class CEquation:
	"""An MWOffice Equation object."""
	def __init__(self, equation):
		self.__IEquation = equation

	def _get_inner(self):
		return self.__IEquation


	def AddSubexpression(self, newExp: str) -> bool:
		"""Adds a subexpression to the end of the current equation object."""
		return self.__IEquation.AddSubexpression(newExp)


	def Delete(self) -> bool:
		"""Removes the object."""
		return self.__IEquation.Delete()



	@property
	def ActiveIndex(self) -> int:
		"""Returns/sets a value for the active index of the equation object. The active index is which line, of a multi-line equation, that is used for most property read/writes."""
		return self.__IEquation.ActiveIndex


	@ActiveIndex.setter
	def ActiveIndex(self, value: int):
		"""Returns/sets a value for the active index of the equation object. The active index is which line, of a multi-line equation, that is used for most property read/writes."""
		self.__IEquation.ActiveIndex = value


	@property
	def AffectsLayout(self) -> bool:
		"""Returns/sets if the value affects layout. Valid only for equations that are exported parameters."""
		return self.__IEquation.AffectsLayout


	@AffectsLayout.setter
	def AffectsLayout(self, value: bool):
		"""Returns/sets if the value affects layout. Valid only for equations that are exported parameters."""
		self.__IEquation.AffectsLayout = value


	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__IEquation.Boundary)


	@property
	def Constrain(self) -> bool:
		"""Returns/sets a value which specifies if the object is constrained by the upper and lower limit."""
		return self.__IEquation.Constrain


	@Constrain.setter
	def Constrain(self, value: bool):
		"""Returns/sets a value which specifies if the object is constrained by the upper and lower limit."""
		self.__IEquation.Constrain = value


	@property
	def DataType(self):
		"""Returns/sets a value which specifies the data type of an equation object."""
		return self.__IEquation.DataType


	@DataType.setter
	def DataType(self, value: mwEquationDataType):
		"""Returns/sets a value which specifies the data type of an equation object."""
		self.__IEquation.DataType = value


	@property
	def Description(self) -> str:
		"""Returns/sets a string for the description field of the equation object."""
		return self.__IEquation.Description


	@Description.setter
	def Description(self, value: str):
		"""Returns/sets a string for the description field of the equation object."""
		self.__IEquation.Description = value


	@property
	def DisplayText(self) -> str:
		"""Returns the display text for the object."""
		return self.__IEquation.DisplayText


	@property
	def Distribution(self):
		"""Returns/sets a value which specifies the distribution type of the object."""
		return self.__IEquation.Distribution


	@Distribution.setter
	def Distribution(self, value: mwStatisticalDist):
		"""Returns/sets a value which specifies the distribution type of the object."""
		self.__IEquation.Distribution = value


	@property
	def Enabled(self) -> bool:
		"""Returns/sets a value which specifies if the object is enabled."""
		return self.__IEquation.Enabled


	@Enabled.setter
	def Enabled(self, value: bool):
		"""Returns/sets a value which specifies if the object is enabled."""
		self.__IEquation.Enabled = value


	@property
	def Expression(self) -> str:
		"""Returns/sets the expression of an Equation object."""
		return self.__IEquation.Expression


	@Expression.setter
	def Expression(self, value: str):
		"""Returns/sets the expression of an Equation object."""
		self.__IEquation.Expression = value


	@property
	def Expressions(self) -> CEquationExpressions:
		"""Returns a reference to a EquationExpression object."""
		return CEquationExpressions(self.__IEquation.Expressions)


	@property
	def FontSize(self) -> float:
		"""Returns/sets a value that affects the font size of the object."""
		return self.__IEquation.FontSize


	@FontSize.setter
	def FontSize(self, value: float):
		"""Returns/sets a value that affects the font size of the object."""
		self.__IEquation.FontSize = value


	@property
	def Framed(self) -> bool:
		"""Returns/sets a value that specifies whether a frame is drawn around the object."""
		return self.__IEquation.Framed


	@Framed.setter
	def Framed(self, value: bool):
		"""Returns/sets a value that specifies whether a frame is drawn around the object."""
		self.__IEquation.Framed = value


	@property
	def LowerConstraint(self) -> float:
		"""Returns/sets the lower constraint of the object."""
		return self.__IEquation.LowerConstraint


	@LowerConstraint.setter
	def LowerConstraint(self, value: float):
		"""Returns/sets the lower constraint of the object."""
		self.__IEquation.LowerConstraint = value


	@property
	def NumSubexpressions(self) -> int:
		"""Returns a count of the number of subexpressions in the equation object."""
		return self.__IEquation.NumSubexpressions


	@property
	def Optimize(self) -> bool:
		"""Returns/sets a value which specifies if the object is optimized."""
		return self.__IEquation.Optimize


	@Optimize.setter
	def Optimize(self, value: bool):
		"""Returns/sets a value which specifies if the object is optimized."""
		self.__IEquation.Optimize = value


	@property
	def OptimizeYield(self) -> bool:
		"""Returns/sets a value which specifies if the object's yield is optimized."""
		return self.__IEquation.OptimizeYield


	@OptimizeYield.setter
	def OptimizeYield(self, value: bool):
		"""Returns/sets a value which specifies if the object's yield is optimized."""
		self.__IEquation.OptimizeYield = value


	@property
	def PropagationMode(self):
		"""Returns/sets a value which specifies the propagation mode of the object. Used for inherited parameters."""
		return self.__IEquation.PropagationMode


	@PropagationMode.setter
	def PropagationMode(self, value: mwVarPropMode):
		"""Returns/sets a value which specifies the propagation mode of the object. Used for inherited parameters."""
		self.__IEquation.PropagationMode = value


	@property
	def Selected(self) -> bool:
		"""Returns/sets if the Equation object is selected."""
		return self.__IEquation.Selected


	@Selected.setter
	def Selected(self, value: bool):
		"""Returns/sets if the Equation object is selected."""
		self.__IEquation.Selected = value


	@property
	def StatVariation(self) -> float:
		"""Returns/sets the statistical variation parameter of the object."""
		return self.__IEquation.StatVariation


	@StatVariation.setter
	def StatVariation(self, value: float):
		"""Returns/sets the statistical variation parameter of the object."""
		self.__IEquation.StatVariation = value


	@property
	def StatVariation2(self) -> float:
		"""Returns/sets the second statistical variation parameter of the object."""
		return self.__IEquation.StatVariation2


	@StatVariation2.setter
	def StatVariation2(self, value: float):
		"""Returns/sets the second statistical variation parameter of the object."""
		self.__IEquation.StatVariation2 = value


	@property
	def StepSize(self) -> float:
		"""Returns/sets the step size used for tuning and discrete optimization of the object."""
		return self.__IEquation.StepSize


	@StepSize.setter
	def StepSize(self, value: float):
		"""Returns/sets the step size used for tuning and discrete optimization of the object."""
		self.__IEquation.StepSize = value


	def Subexpression(self, Index: int) -> str:
		"""Returns/sets the indexed subexpression value in the equation object."""
		return self.__IEquation.Subexpression(Index)


	def SetSubexpression(self, Index: int, value: str):
		"""Returns/sets the indexed subexpression value in the equation object."""
		self.__IEquation.Subexpression = value


	@property
	def Tag(self) -> str:
		"""Returns/sets the tag value of the object."""
		return self.__IEquation.Tag


	@Tag.setter
	def Tag(self, value: str):
		"""Returns/sets the tag value of the object."""
		self.__IEquation.Tag = value


	@property
	def Title(self) -> str:
		"""Returns/sets the title for the object."""
		return self.__IEquation.Title


	@Title.setter
	def Title(self, value: str):
		"""Returns/sets the title for the object."""
		self.__IEquation.Title = value


	@property
	def TolInPercent(self) -> bool:
		"""Returns/sets a value which specifies if the object's total is in percent."""
		return self.__IEquation.TolInPercent


	@TolInPercent.setter
	def TolInPercent(self, value: bool):
		"""Returns/sets a value which specifies if the object's total is in percent."""
		self.__IEquation.TolInPercent = value


	@property
	def Tune(self) -> bool:
		"""Returns/sets a value which specifies if the object is tuned."""
		return self.__IEquation.Tune


	@Tune.setter
	def Tune(self, value: bool):
		"""Returns/sets a value which specifies if the object is tuned."""
		self.__IEquation.Tune = value


	@property
	def UnitType(self):
		"""Returns/sets a value which specifies the unit type of an equation object."""
		return self.__IEquation.UnitType


	@UnitType.setter
	def UnitType(self, value: mwUnitType):
		"""Returns/sets a value which specifies the unit type of an equation object."""
		self.__IEquation.UnitType = value


	@property
	def UpperConstraint(self) -> float:
		"""Returns/sets the upper constraint of the object."""
		return self.__IEquation.UpperConstraint


	@UpperConstraint.setter
	def UpperConstraint(self, value: float):
		"""Returns/sets the upper constraint of the object."""
		self.__IEquation.UpperConstraint = value


	@property
	def UseStatistics(self) -> bool:
		"""Returns/sets a value which specifies if the object uses statistics."""
		return self.__IEquation.UseStatistics


	@UseStatistics.setter
	def UseStatistics(self, value: bool):
		"""Returns/sets a value which specifies if the object uses statistics."""
		self.__IEquation.UseStatistics = value


	@property
	def VariableType(self):
		"""Returns/sets a value which specifies variable type of the equation object."""
		return self.__IEquation.VariableType


	@property
	def x(self) -> int:
		"""Returns/sets the X value of a Equation object."""
		return self.__IEquation.x


	@x.setter
	def x(self, value: int):
		"""Returns/sets the X value of a Equation object."""
		self.__IEquation.x = value


	@property
	def y(self) -> int:
		"""Returns/sets the Y value of a Equation object."""
		return self.__IEquation.y


	@y.setter
	def y(self, value: int):
		"""Returns/sets the Y value of a Equation object."""
		self.__IEquation.y = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Equations
class CEquations:
	"""A collection of MWOffice Equation objects."""
	def __init__(self, equations):
		self.__IEquations = equations

	def _get_inner(self):
		return self.__IEquations


	def Add(self, Expression: str, x: int, y: int) -> CEquation:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CEquation(self.__IEquations.Add(Expression, x, y))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IEquations.Remove(Index)


	def Add2(self, Expression: str, x: float, y: float) -> CEquation:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CEquation(self.__IEquations.Add2(Expression, x, y))


	def Update(self) -> bool:
		"""Called to perform final updates to a collection object."""
		return self.__IEquations.Update()


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IEquations.RemoveAll()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IEquations.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IEquations.Exists(Index)


	def Item(self, Index) -> CEquation:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CEquation(self.__IEquations.Item(Index))


	def __get_Item(self, Index) -> CEquation:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CEquation(self.__IEquations.Item(Index))


	def __call__(self, index) -> CEquation:
		return self.__get_Item(index)


	def __iter__(self) -> CEquation:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IEquations.Count


	def __getitem__(self, index) -> Union[CEquation, List[CEquation]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IEquations.Name


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# GlobalDefinitionDocument
class CGlobalDefinitionDocument:
	"""A MWOffice GlobalDefinitionDocument object."""
	def __init__(self, globaldefinitiondocument):
		self.__IGlobalDefinitionDocument = globaldefinitiondocument

	def _get_inner(self):
		return self.__IGlobalDefinitionDocument


	def Activate(self) -> None:
		"""Activates the objects."""
		self.__IGlobalDefinitionDocument.Activate()


	def NewWindow(self) -> CWindow:
		"""Displays the object in new window."""
		return CWindow(self.__IGlobalDefinitionDocument.NewWindow())


	def PrintOut(self) -> bool:
		"""Sends the object to the current printer."""
		return self.__IGlobalDefinitionDocument.PrintOut()


	def CopyToClipboard(self) -> bool:
		"""Copies the object to the system clipboard."""
		return self.__IGlobalDefinitionDocument.CopyToClipboard()


	def Paste(self, x: int, y: int, CCWRotation: int = 0, Flipped: bool = 0) -> bool:
		"""Pastes the system clipboard to the object."""
		return self.__IGlobalDefinitionDocument.Paste(x, y, CCWRotation, Flipped)


	def InvokeCommand(self, CommandName: str, Arguments, pRet) -> None:
		"""Invoke a menu command by specifying the name for the command. Any required input will need to be supplied as arguments."""
		self.__IGlobalDefinitionDocument.InvokeCommand(CommandName, Arguments, pRet)


	def StartCommand(self, CommandName: str, pRet) -> None:
		"""Start a menu command by specifying the name for the command. Any required input will need to be supplied by the user interactively."""
		self.__IGlobalDefinitionDocument.StartCommand(CommandName, pRet)


	def Export(self, FilePath: str, format: mwGlobalDefExportFormat = 0) -> None:
		"""Exports a design document file from MWOffice."""
		self.__IGlobalDefinitionDocument.Export(FilePath, format)


	def EndActiveCommand(self) -> bool:
		"""Ends the currently active command for this GlobalDefinitionDocument object."""
		return self.__IGlobalDefinitionDocument.EndActiveCommand()


	def Embed(self) -> None:
		"""Convert an externally linked Global Definitions document into an embedded document."""
		self.__IGlobalDefinitionDocument.Embed()


	def LinkToFile(self, FilePath: str) -> None:
		"""Convert an embedded Global Definitions document into an externally linked document."""
		self.__IGlobalDefinitionDocument.LinkToFile(FilePath)


	def Reload(self) -> None:
		"""Reload an externally linked Global Definitions document."""
		self.__IGlobalDefinitionDocument.Reload()


	def Save(self) -> None:
		"""Update the externally linked Global Definitions document file."""
		self.__IGlobalDefinitionDocument.Save()



	@property
	def CanPaste(self) -> bool:
		"""Returns a value that determines the clipboard contents can be pasted to the object."""
		return self.__IGlobalDefinitionDocument.CanPaste


	@property
	def CommandActive(self) -> bool:
		"""Returns a value indicating if there is command currently active for this GlobalDefinitionDocument object."""
		return self.__IGlobalDefinitionDocument.CommandActive


	@property
	def DataElements(self) -> CElements:
		"""Returns a reference to a collection of Element objects."""
		return CElements(self.__IGlobalDefinitionDocument.DataElements)


	@property
	def DrawingShapes(self) -> CDrawingShapes:
		"""Returns a reference to a collection of DrawingShape objects."""
		return CDrawingShapes(self.__IGlobalDefinitionDocument.DrawingShapes)


	@property
	def Embedded(self) -> bool:
		"""Returns whether the Global Definitions document is embedded in the project or linked externally."""
		return self.__IGlobalDefinitionDocument.Embedded


	@property
	def EmbeddedDesigns(self) -> CEmbeddedDesigns:
		"""Returns a reference to a collection of EmbeddedDesign objects."""
		return CEmbeddedDesigns(self.__IGlobalDefinitionDocument.EmbeddedDesigns)


	@property
	def Equations(self) -> CEquations:
		"""Returns a reference to a collection of Equation objects."""
		return CEquations(self.__IGlobalDefinitionDocument.Equations)


	@property
	def FilePath(self) -> str:
		"""Returns the Global Definitions document file path."""
		return self.__IGlobalDefinitionDocument.FilePath


	@property
	def GridVisible(self) -> bool:
		"""Returns/sets a value that specifies if the snap grid is visible for the GlobalDefinitionDocument object."""
		return self.__IGlobalDefinitionDocument.GridVisible


	@GridVisible.setter
	def GridVisible(self, value: bool):
		"""Returns/sets a value that specifies if the snap grid is visible for the GlobalDefinitionDocument object."""
		self.__IGlobalDefinitionDocument.GridVisible = value


	@property
	def HasParent(self) -> bool:
		"""Returns a value that indicates of this GlobalDefinitionDocument has a parent object."""
		return self.__IGlobalDefinitionDocument.HasParent


	@property
	def Modified(self) -> bool:
		"""Returns/sets if the GlobalDefinitionDocument file status is modified."""
		return self.__IGlobalDefinitionDocument.Modified


	@Modified.setter
	def Modified(self, value: bool):
		"""Returns/sets if the GlobalDefinitionDocument file status is modified."""
		self.__IGlobalDefinitionDocument.Modified = value


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IGlobalDefinitionDocument.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__IGlobalDefinitionDocument.Name = value


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__IGlobalDefinitionDocument.Options)


	@property
	def Parent(self) -> CGlobalDefinitionDocument:
		"""Returns a reference to the parent of this GlobalDefinitionDocument if one exists. Otherwise a returns a reference to this document."""
		return CGlobalDefinitionDocument(self.__IGlobalDefinitionDocument.Parent)


	@property
	def ParentName(self) -> str:
		"""Returns the name of the parent of this GlobalDefinitionDocument if one exists. Otherwise an empty string"""
		return self.__IGlobalDefinitionDocument.ParentName


	@property
	def ProcessDefinition(self) -> str:
		"""Returns/sets the process definition name for this GlobalDefinitionDocument object."""
		return self.__IGlobalDefinitionDocument.ProcessDefinition


	@ProcessDefinition.setter
	def ProcessDefinition(self, value: str):
		"""Returns/sets the process definition name for this GlobalDefinitionDocument object."""
		self.__IGlobalDefinitionDocument.ProcessDefinition = value


	@property
	def ReadOnly(self) -> bool:
		"""Returns/sets if the GlobalDefinitionDocument is read-only."""
		return self.__IGlobalDefinitionDocument.ReadOnly


	@property
	def SelectedElements(self) -> CSelectedElements:
		"""Returns a reference to a collection of MWOffice SelectedElement objects."""
		return CSelectedElements(self.__IGlobalDefinitionDocument.SelectedElements)


	@property
	def Windows(self) -> CWindows:
		"""Returns a reference to a collection of Window objects."""
		return CWindows(self.__IGlobalDefinitionDocument.Windows)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# GlobalDefinitionDocuments
class CGlobalDefinitionDocuments:
	"""A collection of GlobalDefinitionDocument objects."""
	def __init__(self, globaldefinitiondocuments):
		self.__IGlobalDefinitionDocuments = globaldefinitiondocuments

	def _get_inner(self):
		return self.__IGlobalDefinitionDocuments


	def Add(self, Name: str, ParentName: str = "") -> CGlobalDefinitionDocument:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CGlobalDefinitionDocument(self.__IGlobalDefinitionDocuments.Add(Name, ParentName))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IGlobalDefinitionDocuments.Remove(Index)


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__IGlobalDefinitionDocuments.GetUniqueName(baseName)


	def Import(self, Name: str, Filename: str, ParentName: str = "") -> CGlobalDefinitionDocument:
		"""Adds a Global Definitions object to the collection from a file and returns a reference to the created object."""
		return CGlobalDefinitionDocument(self.__IGlobalDefinitionDocuments.Import(Name, Filename, ParentName))


	def LinkTo(self, Name: str, Filename: str, ParentName: str = "") -> CGlobalDefinitionDocument:
		"""Adds a Global Definitions object link to the collection from a file and returns a reference to the created object."""
		return CGlobalDefinitionDocument(self.__IGlobalDefinitionDocuments.LinkTo(Name, Filename, ParentName))


	def Copy(self, Index, NewName: str = "", ParentName: str = "") -> CGlobalDefinitionDocument:
		"""Copies the object to the system clipboard."""
		return CGlobalDefinitionDocument(self.__IGlobalDefinitionDocuments.Copy(Index, NewName, ParentName))


	def ImportFromProject(self, projectPath: str, conflictResolution: mwMergeConflictResolutionType = 0) -> bool:
		"""Adds a Global Definitions object to the collection from a file and returns a reference to the created object."""
		return self.__IGlobalDefinitionDocuments.ImportFromProject(projectPath, conflictResolution)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IGlobalDefinitionDocuments.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IGlobalDefinitionDocuments.Exists(Index)


	def Item(self, Index) -> CGlobalDefinitionDocument:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CGlobalDefinitionDocument(self.__IGlobalDefinitionDocuments.Item(Index))


	def __get_Item(self, Index) -> CGlobalDefinitionDocument:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CGlobalDefinitionDocument(self.__IGlobalDefinitionDocuments.Item(Index))


	def __call__(self, index) -> CGlobalDefinitionDocument:
		return self.__get_Item(index)


	def __iter__(self) -> CGlobalDefinitionDocument:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IGlobalDefinitionDocuments.Count


	def __getitem__(self, index) -> Union[CGlobalDefinitionDocument, List[CGlobalDefinitionDocument]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# OutputEquationDocument
class COutputEquationDocument:
	"""A MWOffice OutputEquationDocument object."""
	def __init__(self, outputequationdocument):
		self.__IOutputEquationDocument = outputequationdocument

	def _get_inner(self):
		return self.__IOutputEquationDocument


	def Activate(self) -> None:
		"""Activates the objects."""
		self.__IOutputEquationDocument.Activate()


	def NewWindow(self) -> CWindow:
		"""Displays the object in new window."""
		return CWindow(self.__IOutputEquationDocument.NewWindow())


	def PrintOut(self) -> bool:
		"""Sends the object to the current printer."""
		return self.__IOutputEquationDocument.PrintOut()


	def CopyToClipboard(self) -> bool:
		"""Copies the object to the system clipboard."""
		return self.__IOutputEquationDocument.CopyToClipboard()


	def Paste(self, x: int, y: int, CCWRotation: int = 0, Flipped: bool = 0) -> bool:
		"""Pastes the system clipboard to the object."""
		return self.__IOutputEquationDocument.Paste(x, y, CCWRotation, Flipped)


	def InvokeCommand(self, CommandName: str, Arguments, pRet) -> None:
		"""Invoke a menu command by specifying the name for the command. Any required input will need to be supplied as arguments."""
		self.__IOutputEquationDocument.InvokeCommand(CommandName, Arguments, pRet)


	def StartCommand(self, CommandName: str, pRet) -> None:
		"""Start a menu command by specifying the name for the command. Any required input will need to be supplied by the user interactively."""
		self.__IOutputEquationDocument.StartCommand(CommandName, pRet)


	def EndActiveCommand(self) -> bool:
		"""Ends the currently active command for this OutputEquationDocument object."""
		return self.__IOutputEquationDocument.EndActiveCommand()



	@property
	def CanPaste(self) -> bool:
		"""Returns a value that determines the clipboard contents can be pasted to the object."""
		return self.__IOutputEquationDocument.CanPaste


	@property
	def CommandActive(self) -> bool:
		"""Returns a value indicating if there is command currently active for this OutputEquationDocument object."""
		return self.__IOutputEquationDocument.CommandActive


	@property
	def DrawingShapes(self) -> CDrawingShapes:
		"""Returns a reference to a collection of DrawingShape objects."""
		return CDrawingShapes(self.__IOutputEquationDocument.DrawingShapes)


	@property
	def EmbeddedDesigns(self) -> CEmbeddedDesigns:
		"""Returns a reference to a collection of EmbeddedDesign objects."""
		return CEmbeddedDesigns(self.__IOutputEquationDocument.EmbeddedDesigns)


	@property
	def Equations(self) -> CEquations:
		"""Returns a reference to a collection of Equation objects."""
		return CEquations(self.__IOutputEquationDocument.Equations)


	@property
	def GridVisible(self) -> bool:
		"""Returns/sets a value that specifies if the snap grid is visible for the OutputEquationDocument object."""
		return self.__IOutputEquationDocument.GridVisible


	@GridVisible.setter
	def GridVisible(self, value: bool):
		"""Returns/sets a value that specifies if the snap grid is visible for the OutputEquationDocument object."""
		self.__IOutputEquationDocument.GridVisible = value


	@property
	def Modified(self) -> bool:
		"""Returns/sets if the OutputEquationDocument file status is modified."""
		return self.__IOutputEquationDocument.Modified


	@Modified.setter
	def Modified(self, value: bool):
		"""Returns/sets if the OutputEquationDocument file status is modified."""
		self.__IOutputEquationDocument.Modified = value


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IOutputEquationDocument.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__IOutputEquationDocument.Name = value


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__IOutputEquationDocument.Options)


	@property
	def OutputElements(self) -> CElements:
		"""Returns a reference to a collection of Element objects."""
		return CElements(self.__IOutputEquationDocument.OutputElements)


	@property
	def ReadOnly(self) -> bool:
		"""Returns/sets if the OutputEquationDocument is read-only."""
		return self.__IOutputEquationDocument.ReadOnly


	@property
	def Windows(self) -> CWindows:
		"""Returns a reference to a collection of Window objects."""
		return CWindows(self.__IOutputEquationDocument.Windows)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# OutputEquationDocuments
class COutputEquationDocuments:
	"""A collection of OutputEquationDocument objects."""
	def __init__(self, outputequationdocuments):
		self.__IOutputEquationDocuments = outputequationdocuments

	def _get_inner(self):
		return self.__IOutputEquationDocuments


	def Add(self, Name: str) -> COutputEquationDocument:
		"""Adds an object to the collection and returns a reference to the created object."""
		return COutputEquationDocument(self.__IOutputEquationDocuments.Add(Name))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IOutputEquationDocuments.Remove(Index)


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__IOutputEquationDocuments.GetUniqueName(baseName)


	def Copy(self, Index, NewName: str = "") -> COutputEquationDocument:
		"""Copies the object to the system clipboard."""
		return COutputEquationDocument(self.__IOutputEquationDocuments.Copy(Index, NewName))



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IOutputEquationDocuments.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IOutputEquationDocuments.Exists(Index)


	def Item(self, Index) -> COutputEquationDocument:
		"""Returns a specific item of a Collection object either by position or by key."""
		return COutputEquationDocument(self.__IOutputEquationDocuments.Item(Index))


	def __get_Item(self, Index) -> COutputEquationDocument:
		"""Returns a specific item of a Collection object either by position or by key."""
		return COutputEquationDocument(self.__IOutputEquationDocuments.Item(Index))


	def __call__(self, index) -> COutputEquationDocument:
		return self.__get_Item(index)


	def __iter__(self) -> COutputEquationDocument:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IOutputEquationDocuments.Count


	def __getitem__(self, index) -> Union[COutputEquationDocument, List[COutputEquationDocument]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Goal
class CGoal:
	"""An MWOffice Goal object."""
	def __init__(self, goal):
		self.__IGoal = goal

	def _get_inner(self):
		return self.__IGoal



	@property
	def CircuitName(self) -> str:
		"""Returns the circuit name of a Goal object."""
		return self.__IGoal.CircuitName


	@CircuitName.setter
	def CircuitName(self, value: str):
		"""Returns the circuit name of a Goal object."""
		self.__IGoal.CircuitName = value


	@property
	def Cost(self) -> float:
		"""Returns the cost of a Goal object."""
		return self.__IGoal.Cost


	@property
	def Enable(self) -> bool:
		"""Returns/sets a value which specifies if the Goal object is enabled."""
		return self.__IGoal.Enable


	@Enable.setter
	def Enable(self, value: bool):
		"""Returns/sets a value which specifies if the Goal object is enabled."""
		self.__IGoal.Enable = value


	@property
	def LVal(self) -> float:
		"""Returns/sets the L property of a Goal object."""
		return self.__IGoal.LVal


	@LVal.setter
	def LVal(self, value: float):
		"""Returns/sets the L property of a Goal object."""
		self.__IGoal.LVal = value


	@property
	def Measurement(self) -> CMeasurement:
		"""Returns a reference to MWOffice Measurement object."""
		return CMeasurement(self.__IGoal.Measurement)


	@property
	def MeasurementName(self) -> str:
		"""Returns the measurement name of a Goal object."""
		return self.__IGoal.MeasurementName


	@MeasurementName.setter
	def MeasurementName(self, value: str):
		"""Returns the measurement name of a Goal object."""
		self.__IGoal.MeasurementName = value


	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__IGoal.Name


	@property
	def Tag(self) -> str:
		"""Returns/sets the tag value of the object."""
		return self.__IGoal.Tag


	@Tag.setter
	def Tag(self, value: str):
		"""Returns/sets the tag value of the object."""
		self.__IGoal.Tag = value


	@property
	def Type(self):
		"""Returns the type (<, >, =) of the goal."""
		return self.__IGoal.Type


	@property
	def Weight(self) -> float:
		"""Returns/sets the weight of a Goal object."""
		return self.__IGoal.Weight


	@Weight.setter
	def Weight(self, value: float):
		"""Returns/sets the weight of a Goal object."""
		self.__IGoal.Weight = value


	@property
	def xStart(self) -> float:
		"""Returns/sets the X start of a Goal object."""
		return self.__IGoal.xStart


	@xStart.setter
	def xStart(self, value: float):
		"""Returns/sets the X start of a Goal object."""
		self.__IGoal.xStart = value


	@property
	def xStop(self) -> float:
		"""Returns/sets the X stop of a Goal object."""
		return self.__IGoal.xStop


	@xStop.setter
	def xStop(self, value: float):
		"""Returns/sets the X stop of a Goal object."""
		self.__IGoal.xStop = value


	@property
	def yStart(self) -> float:
		"""Returns/sets the Y start of a Goal object."""
		return self.__IGoal.yStart


	@yStart.setter
	def yStart(self, value: float):
		"""Returns/sets the Y start of a Goal object."""
		self.__IGoal.yStart = value


	@property
	def yStop(self) -> float:
		"""Returns/sets the Y stop of the object."""
		return self.__IGoal.yStop


	@yStop.setter
	def yStop(self, value: float):
		"""Returns/sets the Y stop of the object."""
		self.__IGoal.yStop = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DisplayPrecision
class CDisplayPrecision:
	"""A MWOffice DisplayPrecision object."""
	def __init__(self, displayprecision):
		self.__IDisplayPrecision = displayprecision

	def _get_inner(self):
		return self.__IDisplayPrecision



	@property
	def Digits(self) -> int:
		"""Returns/Sets the number of display digits for the DisplayPrecision object."""
		return self.__IDisplayPrecision.Digits


	@Digits.setter
	def Digits(self, value: int):
		"""Returns/Sets the number of display digits for the DisplayPrecision object."""
		self.__IDisplayPrecision.Digits = value


	@property
	def Style(self):
		"""Returns/Sets the display style for the DisplayPrecision object."""
		return self.__IDisplayPrecision.Style


	@Style.setter
	def Style(self, value: mwPrecisionStyle):
		"""Returns/Sets the display style for the DisplayPrecision object."""
		self.__IDisplayPrecision.Style = value


	@property
	def mode(self):
		"""Returns/Sets the display mode for the DisplayPrecision object."""
		return self.__IDisplayPrecision.mode


	@mode.setter
	def mode(self, value: mwPrecisionMode):
		"""Returns/Sets the display mode for the DisplayPrecision object."""
		self.__IDisplayPrecision.mode = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Graph
class CGraph:
	"""An MWOffice Graph object."""
	def __init__(self, graph):
		self.__IGraph = graph

	def _get_inner(self):
		return self.__IGraph


	def CopyToClipboard(self) -> None:
		"""Copies the object to the system clipboard."""
		self.__IGraph.CopyToClipboard()


	def Activate(self) -> None:
		"""Activates the objects."""
		self.__IGraph.Activate()


	def NewWindow(self) -> CWindow:
		"""Displays the object in new window."""
		return CWindow(self.__IGraph.NewWindow())


	def PrintOut(self) -> None:
		"""Sends the object to the current printer."""
		self.__IGraph.PrintOut()


	def FreezeTraces(self) -> None:
		"""Freezes the traces on the graph."""
		self.__IGraph.FreezeTraces()


	def LogicalToGridCoordinateX(self, LogicalX: int) -> float:
		"""Converts a coordinate value from logical to grid coordinates along the X axis."""
		return self.__IGraph.LogicalToGridCoordinateX(LogicalX)


	def LogicalToGridCoordinateY(self, LogicalY: int, yAxisIndex = 1, OnLeft: bool = -1) -> float:
		"""Converts a coordinate value from logical to grid coordinates along the Y axis."""
		return self.__IGraph.LogicalToGridCoordinateY(LogicalY, yAxisIndex, OnLeft)


	def GridToLogicalCoordinateX(self, GridX: float) -> int:
		"""Converts a coordinate value from grid to logical coordinates along the X axis."""
		return self.__IGraph.GridToLogicalCoordinateX(GridX)


	def GridToLogicalCoordinateY(self, GridY: float, yAxisIndex = 1, OnLeft: bool = -1) -> int:
		"""Converts a coordinate value from grid to logical coordinates along the Y axis."""
		return self.__IGraph.GridToLogicalCoordinateY(GridY, yAxisIndex, OnLeft)


	def ClearFrozenTraces(self) -> None:
		"""Clears any previously frozen traces on the graph."""
		self.__IGraph.ClearFrozenTraces()


	def SimulateMeasurements(self) -> bool:
		"""Simulate measurements for this Graph object."""
		return self.__IGraph.SimulateMeasurements()


	def CopyViewToClipboard(self) -> bool:
		"""Copies the object to the system clipboard."""
		return self.__IGraph.CopyViewToClipboard()


	def ExportTraceData(self, Filename: str) -> bool:
		"""Export trace data from this Graph object."""
		return self.__IGraph.ExportTraceData(Filename)


	def InvokeCommand(self, CommandName: str, Arguments, pRet) -> None:
		"""Invoke a menu command by specifying the name for the command. Any required input will need to be supplied as arguments."""
		self.__IGraph.InvokeCommand(CommandName, Arguments, pRet)


	def StartCommand(self, CommandName: str, pRet) -> None:
		"""Start a menu command by specifying the name for the command. Any required input will need to be supplied by the user interactively."""
		self.__IGraph.StartCommand(CommandName, pRet)


	def EndActiveCommand(self) -> bool:
		"""Ends the currently active command for this Graph object."""
		return self.__IGraph.EndActiveCommand()



	@property
	def Attributes(self) -> CAttributes:
		"""Returns a reference to a collection of Attribute objects."""
		return CAttributes(self.__IGraph.Attributes)


	@property
	def Axes(self) -> CAxes:
		"""Returns a reference to a collection of Axis objects."""
		return CAxes(self.__IGraph.Axes)


	@property
	def BorderColor(self) -> int:
		"""Returns/sets the color of the graph border."""
		return self.__IGraph.BorderColor


	@BorderColor.setter
	def BorderColor(self, value: int):
		"""Returns/sets the color of the graph border."""
		self.__IGraph.BorderColor = value


	@property
	def BorderVisible(self) -> bool:
		"""Returns/sets whether the graph border is displayed."""
		return self.__IGraph.BorderVisible


	@BorderVisible.setter
	def BorderVisible(self, value: bool):
		"""Returns/sets whether the graph border is displayed."""
		self.__IGraph.BorderVisible = value


	@property
	def BorderWeight(self):
		"""Returns/sets the thickness of the graph border."""
		return self.__IGraph.BorderWeight


	@BorderWeight.setter
	def BorderWeight(self, value: mwThickness):
		"""Returns/sets the thickness of the graph border."""
		self.__IGraph.BorderWeight = value


	@property
	def CommandActive(self) -> bool:
		"""Returns a value indicating if there is command currently active for this Graph object."""
		return self.__IGraph.CommandActive


	@property
	def DataPrecision(self) -> CDisplayPrecision:
		"""Returns a reference to a MWOffice DisplayPrecision object."""
		return CDisplayPrecision(self.__IGraph.DataPrecision)


	@property
	def DefaultTitle(self) -> bool:
		"""Returns/sets a value that indicates if the default title should be used for this Graph object."""
		return self.__IGraph.DefaultTitle


	@DefaultTitle.setter
	def DefaultTitle(self, value: bool):
		"""Returns/sets a value that indicates if the default title should be used for this Graph object."""
		self.__IGraph.DefaultTitle = value


	@property
	def DrawingShapes(self) -> CDrawingShapes:
		"""Returns a reference to a collection of DrawingShape objects."""
		return CDrawingShapes(self.__IGraph.DrawingShapes)


	@property
	def EmbeddedDesigns(self) -> CEmbeddedDesigns:
		"""Returns a reference to a collection of EmbeddedDesign objects."""
		return CEmbeddedDesigns(self.__IGraph.EmbeddedDesigns)


	@property
	def Height(self) -> int:
		"""Returns/sets the height of the graph."""
		return self.__IGraph.Height


	@Height.setter
	def Height(self, value: int):
		"""Returns/sets the height of the graph."""
		self.__IGraph.Height = value


	@property
	def Left(self) -> int:
		"""Returns/sets the position of the left edge of the graph"""
		return self.__IGraph.Left


	@Left.setter
	def Left(self, value: int):
		"""Returns/sets the position of the left edge of the graph"""
		self.__IGraph.Left = value


	@property
	def Legend(self) -> CLegend:
		"""Returns a reference to a Legend object."""
		return CLegend(self.__IGraph.Legend)


	@property
	def LineMarkers(self) -> CLineMarkers:
		"""Returns a reference tp a collection of LineMarker objects."""
		return CLineMarkers(self.__IGraph.LineMarkers)


	@property
	def Markers(self) -> CMarkers:
		"""Returns a reference to a collection of Marker objects."""
		return CMarkers(self.__IGraph.Markers)


	@property
	def Measurements(self) -> CMeasurements:
		"""Returns a reference to a collection of Measurement objects."""
		return CMeasurements(self.__IGraph.Measurements)


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IGraph.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__IGraph.Name = value


	@property
	def SelectedDrawingShapes(self) -> CSelectedDrawingShapes:
		"""Returns a reference to a collection of MWOffice SelectedDrawingShape objects."""
		return CSelectedDrawingShapes(self.__IGraph.SelectedDrawingShapes)


	@property
	def SweepPrecision(self) -> CDisplayPrecision:
		"""Returns a reference to a MWOffice DisplayPrecision object."""
		return CDisplayPrecision(self.__IGraph.SweepPrecision)


	@property
	def TickMarksVisible(self) -> bool:
		"""Returns/sets whether the tick marks are displayed on the graph."""
		return self.__IGraph.TickMarksVisible


	@TickMarksVisible.setter
	def TickMarksVisible(self, value: bool):
		"""Returns/sets whether the tick marks are displayed on the graph."""
		self.__IGraph.TickMarksVisible = value


	@property
	def Title(self) -> str:
		"""Returns/sets the text used for the graph title."""
		return self.__IGraph.Title


	@Title.setter
	def Title(self, value: str):
		"""Returns/sets the text used for the graph title."""
		self.__IGraph.Title = value


	@property
	def TitleColor(self) -> int:
		"""Returns/sets the color used for the graph title."""
		return self.__IGraph.TitleColor


	@TitleColor.setter
	def TitleColor(self, value: int):
		"""Returns/sets the color used for the graph title."""
		self.__IGraph.TitleColor = value


	@property
	def TitleFont(self):
		"""Returns/sets the font used for the graph title."""
		return self.__IGraph.TitleFont


	@TitleFont.setter
	def TitleFont(self, value):
		"""Returns/sets the font used for the graph title."""
		self.__IGraph.TitleFont = value


	@property
	def TitleVisible(self) -> bool:
		"""Returns/sets whether the graph title is displayed."""
		return self.__IGraph.TitleVisible


	@TitleVisible.setter
	def TitleVisible(self, value: bool):
		"""Returns/sets whether the graph title is displayed."""
		self.__IGraph.TitleVisible = value


	@property
	def Top(self) -> int:
		"""Returns/sets the position of the top edge of the graph"""
		return self.__IGraph.Top


	@Top.setter
	def Top(self, value: int):
		"""Returns/sets the position of the top edge of the graph"""
		self.__IGraph.Top = value


	@property
	def Traces(self) -> CTraces:
		"""Returns a reference to a collection of Trace objects."""
		return CTraces(self.__IGraph.Traces)


	@property
	def Type(self):
		"""Returns a value which specifies the graph type of a Graph object."""
		return self.__IGraph.Type


	@Type.setter
	def Type(self, value: mwGraphType):
		"""Returns a value which specifies the graph type of a Graph object."""
		self.__IGraph.Type = value


	@property
	def UnitsProcessName(self) -> str:
		"""Returns/sets the name of the process definition units used for formatting the values in this graph."""
		return self.__IGraph.UnitsProcessName


	@UnitsProcessName.setter
	def UnitsProcessName(self, value: str):
		"""Returns/sets the name of the process definition units used for formatting the values in this graph."""
		self.__IGraph.UnitsProcessName = value


	@property
	def Width(self) -> int:
		"""Returns/sets the width of the graph."""
		return self.__IGraph.Width


	@Width.setter
	def Width(self, value: int):
		"""Returns/sets the width of the graph."""
		self.__IGraph.Width = value


	@property
	def Windows(self) -> CWindows:
		"""Returns a reference to a collection of Window objects."""
		return CWindows(self.__IGraph.Windows)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Graphs
class CGraphs:
	"""A collection of MWOffice Graph objects."""
	def __init__(self, graphs):
		self.__IGraphs = graphs

	def _get_inner(self):
		return self.__IGraphs


	def Add(self, Name: str, Type: mwGraphType) -> CGraph:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CGraph(self.__IGraphs.Add(Name, Type))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IGraphs.Remove(Index)


	def Copy(self, Index, NewName: str = "") -> CGraph:
		"""Copies an object from another object collection into this object collection."""
		return CGraph(self.__IGraphs.Copy(Index, NewName))


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__IGraphs.GetUniqueName(baseName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IGraphs.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IGraphs.Exists(Index)


	def Item(self, Index) -> CGraph:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CGraph(self.__IGraphs.Item(Index))


	def __get_Item(self, Index) -> CGraph:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CGraph(self.__IGraphs.Item(Index))


	def __call__(self, index) -> CGraph:
		return self.__get_Item(index)


	def __iter__(self) -> CGraph:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IGraphs.Count


	def __getitem__(self, index) -> Union[CGraph, List[CGraph]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def Options(self, Type: mwGraphType) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__IGraphs.Options(Type))


	def TraceFormatOptions(self, Type: mwGraphType) -> CTraceFormatOptions:
		"""Returns a reference to a collection of TraceFormatOption objects."""
		return CTraceFormatOptions(self.__IGraphs.TraceFormatOptions(Type))


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Axis
class CAxis:
	"""An MWOffice Axis object."""
	def __init__(self, axis):
		self.__IAxis = axis

	def _get_inner(self):
		return self.__IAxis



	@property
	def AutoMax(self) -> bool:
		"""Returns/sets whether the axis maximum value is automatically calculated (when AutoScale is not enabled)."""
		return self.__IAxis.AutoMax


	@AutoMax.setter
	def AutoMax(self, value: bool):
		"""Returns/sets whether the axis maximum value is automatically calculated (when AutoScale is not enabled)."""
		self.__IAxis.AutoMax = value


	@property
	def AutoMin(self) -> bool:
		"""Returns/sets whether the axis minimum value is automatically calculated (when AutoScale is not enabled)."""
		return self.__IAxis.AutoMin


	@AutoMin.setter
	def AutoMin(self, value: bool):
		"""Returns/sets whether the axis minimum value is automatically calculated (when AutoScale is not enabled)."""
		self.__IAxis.AutoMin = value


	@property
	def AutoScale(self) -> bool:
		"""Returns/sets whether the axis minimum and maximum values are automatically calculated."""
		return self.__IAxis.AutoScale


	@AutoScale.setter
	def AutoScale(self, value: bool):
		"""Returns/sets whether the axis minimum and maximum values are automatically calculated."""
		self.__IAxis.AutoScale = value


	@property
	def GridlineLabelsColor(self) -> int:
		"""Returns/sets the color of the axis grid line label."""
		return self.__IAxis.GridlineLabelsColor


	@GridlineLabelsColor.setter
	def GridlineLabelsColor(self, value: int):
		"""Returns/sets the color of the axis grid line label."""
		self.__IAxis.GridlineLabelsColor = value


	@property
	def GridlineLabelsFont(self):
		"""Returns/sets the font of the axis grid line label."""
		return self.__IAxis.GridlineLabelsFont


	@GridlineLabelsFont.setter
	def GridlineLabelsFont(self, value):
		"""Returns/sets the font of the axis grid line label."""
		self.__IAxis.GridlineLabelsFont = value


	@property
	def GridlineLabelsVisible(self) -> bool:
		"""Returns/sets whether the axis grid line labels are displayed."""
		return self.__IAxis.GridlineLabelsVisible


	@GridlineLabelsVisible.setter
	def GridlineLabelsVisible(self, value: bool):
		"""Returns/sets whether the axis grid line labels are displayed."""
		self.__IAxis.GridlineLabelsVisible = value


	@property
	def LabelColor(self) -> int:
		"""Returns/sets the color of the axis label."""
		return self.__IAxis.LabelColor


	@LabelColor.setter
	def LabelColor(self, value: int):
		"""Returns/sets the color of the axis label."""
		self.__IAxis.LabelColor = value


	@property
	def LabelFont(self):
		"""Returns/sets the font of the axis label."""
		return self.__IAxis.LabelFont


	@LabelFont.setter
	def LabelFont(self, value):
		"""Returns/sets the font of the axis label."""
		self.__IAxis.LabelFont = value


	@property
	def LabelText(self) -> str:
		"""Returns/sets the text of the axis label."""
		return self.__IAxis.LabelText


	@LabelText.setter
	def LabelText(self, value: str):
		"""Returns/sets the text of the axis label."""
		self.__IAxis.LabelText = value


	@property
	def LabelUnitsVisible(self) -> bool:
		"""Returns/sets whether the axis label units are displayed."""
		return self.__IAxis.LabelUnitsVisible


	@LabelUnitsVisible.setter
	def LabelUnitsVisible(self, value: bool):
		"""Returns/sets whether the axis label units are displayed."""
		self.__IAxis.LabelUnitsVisible = value


	@property
	def LabelVisible(self) -> bool:
		"""Returns/sets whether the axis labels are displayed."""
		return self.__IAxis.LabelVisible


	@LabelVisible.setter
	def LabelVisible(self, value: bool):
		"""Returns/sets whether the axis labels are displayed."""
		self.__IAxis.LabelVisible = value


	@property
	def MajorGridlinesAutoStep(self) -> bool:
		"""Returns/sets whether the grid line step size is automatically calculated."""
		return self.__IAxis.MajorGridlinesAutoStep


	@MajorGridlinesAutoStep.setter
	def MajorGridlinesAutoStep(self, value: bool):
		"""Returns/sets whether the grid line step size is automatically calculated."""
		self.__IAxis.MajorGridlinesAutoStep = value


	@property
	def MajorGridlinesColor(self) -> int:
		"""Returns/sets the color of the axis major grid lines."""
		return self.__IAxis.MajorGridlinesColor


	@MajorGridlinesColor.setter
	def MajorGridlinesColor(self, value: int):
		"""Returns/sets the color of the axis major grid lines."""
		self.__IAxis.MajorGridlinesColor = value


	@property
	def MajorGridlinesDashStyle(self):
		"""Returns/sets the dash style of the axis major grid lines."""
		return self.__IAxis.MajorGridlinesDashStyle


	@MajorGridlinesDashStyle.setter
	def MajorGridlinesDashStyle(self, value: mwDashStyle):
		"""Returns/sets the dash style of the axis major grid lines."""
		self.__IAxis.MajorGridlinesDashStyle = value


	@property
	def MajorGridlinesStep(self) -> float:
		"""Returns/sets the step size of the axis major grid lines."""
		return self.__IAxis.MajorGridlinesStep


	@MajorGridlinesStep.setter
	def MajorGridlinesStep(self, value: float):
		"""Returns/sets the step size of the axis major grid lines."""
		self.__IAxis.MajorGridlinesStep = value


	@property
	def MajorGridlinesVisible(self) -> bool:
		"""Returns/sets whether the major axis grid lines are displayed."""
		return self.__IAxis.MajorGridlinesVisible


	@MajorGridlinesVisible.setter
	def MajorGridlinesVisible(self, value: bool):
		"""Returns/sets whether the major axis grid lines are displayed."""
		self.__IAxis.MajorGridlinesVisible = value


	@property
	def MajorGridlinesWeight(self):
		"""Returns/sets the thickness of the axis major grid lines."""
		return self.__IAxis.MajorGridlinesWeight


	@MajorGridlinesWeight.setter
	def MajorGridlinesWeight(self, value: mwThickness):
		"""Returns/sets the thickness of the axis major grid lines."""
		self.__IAxis.MajorGridlinesWeight = value


	@property
	def MaximumScale(self) -> float:
		"""Returns/sets the maximum value of the axis scale."""
		return self.__IAxis.MaximumScale


	@MaximumScale.setter
	def MaximumScale(self, value: float):
		"""Returns/sets the maximum value of the axis scale."""
		self.__IAxis.MaximumScale = value


	@property
	def MinimumScale(self) -> float:
		"""Returns/sets the minimum value of the axis scale."""
		return self.__IAxis.MinimumScale


	@MinimumScale.setter
	def MinimumScale(self, value: float):
		"""Returns/sets the minimum value of the axis scale."""
		self.__IAxis.MinimumScale = value


	@property
	def MinorGridlinesAutoStep(self) -> bool:
		"""Returns/sets whether the grid line step size is automatically calculated."""
		return self.__IAxis.MinorGridlinesAutoStep


	@MinorGridlinesAutoStep.setter
	def MinorGridlinesAutoStep(self, value: bool):
		"""Returns/sets whether the grid line step size is automatically calculated."""
		self.__IAxis.MinorGridlinesAutoStep = value


	@property
	def MinorGridlinesColor(self) -> int:
		"""Returns/sets the color of the axis minor grid lines."""
		return self.__IAxis.MinorGridlinesColor


	@MinorGridlinesColor.setter
	def MinorGridlinesColor(self, value: int):
		"""Returns/sets the color of the axis minor grid lines."""
		self.__IAxis.MinorGridlinesColor = value


	@property
	def MinorGridlinesDashStyle(self):
		"""Returns/sets the dash style of the axis minor grid lines."""
		return self.__IAxis.MinorGridlinesDashStyle


	@MinorGridlinesDashStyle.setter
	def MinorGridlinesDashStyle(self, value: mwDashStyle):
		"""Returns/sets the dash style of the axis minor grid lines."""
		self.__IAxis.MinorGridlinesDashStyle = value


	@property
	def MinorGridlinesStep(self) -> float:
		"""Returns/sets the step size of the axis major grid lines."""
		return self.__IAxis.MinorGridlinesStep


	@MinorGridlinesStep.setter
	def MinorGridlinesStep(self, value: float):
		"""Returns/sets the step size of the axis major grid lines."""
		self.__IAxis.MinorGridlinesStep = value


	@property
	def MinorGridlinesVisible(self) -> bool:
		"""Returns/sets whether the minor axis grid lines are displayed."""
		return self.__IAxis.MinorGridlinesVisible


	@MinorGridlinesVisible.setter
	def MinorGridlinesVisible(self, value: bool):
		"""Returns/sets whether the minor axis grid lines are displayed."""
		self.__IAxis.MinorGridlinesVisible = value


	@property
	def MinorGridlinesWeight(self):
		"""Returns/sets the thickness of the axis minor grid lines."""
		return self.__IAxis.MinorGridlinesWeight


	@MinorGridlinesWeight.setter
	def MinorGridlinesWeight(self, value: mwThickness):
		"""Returns/sets the thickness of the axis minor grid lines."""
		self.__IAxis.MinorGridlinesWeight = value


	@property
	def Name(self) -> str:
		"""Returns the name of the axis object."""
		return self.__IAxis.Name


	@property
	def ScaleType(self):
		"""Returns/sets the scale type of the axis."""
		return self.__IAxis.ScaleType


	@ScaleType.setter
	def ScaleType(self, value: mwScaleType):
		"""Returns/sets the scale type of the axis."""
		self.__IAxis.ScaleType = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Axes
class CAxes:
	"""A collection of MWOffice Axis objects."""
	def __init__(self, axes):
		self.__IAxes = axes

	def _get_inner(self):
		return self.__IAxes


	def Add(self) -> CAxes:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CAxes(self.__IAxes.Add())


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IAxes.Remove(Index)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IAxes.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IAxes.Exists(Index)


	def Item(self, Index) -> CAxis:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CAxis(self.__IAxes.Item(Index))


	def __get_Item(self, Index) -> CAxis:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CAxis(self.__IAxes.Item(Index))


	def __call__(self, index) -> CAxis:
		return self.__get_Item(index)


	def __iter__(self) -> CAxis:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IAxes.Count


	def __getitem__(self, index) -> Union[CAxis, List[CAxis]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# TraceFormatOption
class CTraceFormatOption:
	"""An MWOffice TraceFormatOption object."""
	def __init__(self, traceformatoption):
		self.__ITraceFormatOption = traceformatoption

	def _get_inner(self):
		return self.__ITraceFormatOption



	@property
	def Color(self) -> int:
		"""Returns/sets the color value for the TraceFormatOption object."""
		return self.__ITraceFormatOption.Color


	@Color.setter
	def Color(self, value: int):
		"""Returns/sets the color value for the TraceFormatOption object."""
		self.__ITraceFormatOption.Color = value


	@property
	def LineStyle(self) -> int:
		"""Returns/sets the line style for the TraceFormatOption object."""
		return self.__ITraceFormatOption.LineStyle


	@LineStyle.setter
	def LineStyle(self, value: int):
		"""Returns/sets the line style for the TraceFormatOption object."""
		self.__ITraceFormatOption.LineStyle = value


	@property
	def LineWeight(self) -> int:
		"""Returns/sets the line weight for the TraceFormatOption object."""
		return self.__ITraceFormatOption.LineWeight


	@LineWeight.setter
	def LineWeight(self, value: int):
		"""Returns/sets the line weight for the TraceFormatOption object."""
		self.__ITraceFormatOption.LineWeight = value


	@property
	def Symbol(self) -> int:
		"""Returns/sets the symbol for the TraceFormatOption object."""
		return self.__ITraceFormatOption.Symbol


	@Symbol.setter
	def Symbol(self, value: int):
		"""Returns/sets the symbol for the TraceFormatOption object."""
		self.__ITraceFormatOption.Symbol = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# TraceFormatOptions
class CTraceFormatOptions:
	"""A collection of TraceFormatOption objects."""
	def __init__(self, traceformatoptions):
		self.__ITraceFormatOptions = traceformatoptions

	def _get_inner(self):
		return self.__ITraceFormatOptions



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ITraceFormatOptions.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ITraceFormatOptions.Exists(Index)


	def Item(self, Index) -> CTraceFormatOption:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CTraceFormatOption(self.__ITraceFormatOptions.Item(Index))


	def __get_Item(self, Index) -> CTraceFormatOption:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CTraceFormatOption(self.__ITraceFormatOptions.Item(Index))


	def __call__(self, index) -> CTraceFormatOption:
		return self.__get_Item(index)


	def __iter__(self) -> CTraceFormatOption:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ITraceFormatOptions.Count


	def __getitem__(self, index) -> Union[CTraceFormatOption, List[CTraceFormatOption]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Trace
class CTrace:
	"""An MWOffice Trace object."""
	def __init__(self, trace):
		self.__ITrace = trace

	def _get_inner(self):
		return self.__ITrace



	@property
	def AxisIndex(self) -> int:
		"""Returns/Sets the index of the plot axis associated with this Trace object."""
		return self.__ITrace.AxisIndex


	@AxisIndex.setter
	def AxisIndex(self, value: int):
		"""Returns/Sets the index of the plot axis associated with this Trace object."""
		self.__ITrace.AxisIndex = value


	@property
	def Color(self) -> int:
		"""Returns/sets the color of the trace."""
		return self.__ITrace.Color


	@Color.setter
	def Color(self, value: int):
		"""Returns/sets the color of the trace."""
		self.__ITrace.Color = value


	def CompatibleStyle(self, __MIDL__ITrace0000: mwTraceStyle) -> bool:
		"""Returns if the given Trace style is compatible with the Graph."""
		return self.__ITrace.CompatibleStyle(__MIDL__ITrace0000)


	@property
	def DashStyle(self):
		"""Returns/sets the dash style of the trace."""
		return self.__ITrace.DashStyle


	@DashStyle.setter
	def DashStyle(self, value: mwDashStyle):
		"""Returns/sets the dash style of the trace."""
		self.__ITrace.DashStyle = value


	@property
	def DefaultStyle(self):
		"""Returns the default Trace style for the Graph."""
		return self.__ITrace.DefaultStyle


	@property
	def FrequencyArrows(self) -> bool:
		"""Returns/sets whether frequency arrows should be displayed on the text."""
		return self.__ITrace.FrequencyArrows


	@FrequencyArrows.setter
	def FrequencyArrows(self, value: bool):
		"""Returns/sets whether frequency arrows should be displayed on the text."""
		self.__ITrace.FrequencyArrows = value


	@property
	def LegendText(self) -> str:
		"""Returns/sets the legend text displayed for the measurement name."""
		return self.__ITrace.LegendText


	@LegendText.setter
	def LegendText(self, value: str):
		"""Returns/sets the legend text displayed for the measurement name."""
		self.__ITrace.LegendText = value


	@property
	def LegendText2(self) -> str:
		"""Returns/sets the legend text displayed for the data source name."""
		return self.__ITrace.LegendText2


	@LegendText2.setter
	def LegendText2(self, value: str):
		"""Returns/sets the legend text displayed for the data source name."""
		self.__ITrace.LegendText2 = value


	@property
	def MeasurementName(self) -> str:
		"""Returns the name of the measurement associated with this Trace object."""
		return self.__ITrace.MeasurementName


	@property
	def Name(self) -> str:
		"""Returns the name of a trace object."""
		return self.__ITrace.Name


	@property
	def PlotAxis(self):
		"""Returns/sets the axis on which to plot the Trace."""
		return self.__ITrace.PlotAxis


	@PlotAxis.setter
	def PlotAxis(self, value: mwPlotAxis):
		"""Returns/sets the axis on which to plot the Trace."""
		self.__ITrace.PlotAxis = value


	@property
	def SteppedColorStyle(self):
		"""Returns/sets the stepped color style of the Trace."""
		return self.__ITrace.SteppedColorStyle


	@SteppedColorStyle.setter
	def SteppedColorStyle(self, value: mwTraceSteppedColorStyle):
		"""Returns/sets the stepped color style of the Trace."""
		self.__ITrace.SteppedColorStyle = value


	@property
	def Style(self):
		"""Returns/sets the style of the Trace."""
		return self.__ITrace.Style


	@Style.setter
	def Style(self, value: mwTraceStyle):
		"""Returns/sets the style of the Trace."""
		self.__ITrace.Style = value


	@property
	def Symbol(self):
		"""Returns/sets the symbol used by the trace."""
		return self.__ITrace.Symbol


	@Symbol.setter
	def Symbol(self, value: mwTraceSymbols):
		"""Returns/sets the symbol used by the trace."""
		self.__ITrace.Symbol = value


	@property
	def SymbolInterval(self) -> int:
		"""Returns/sets the spacing of the symbols displayed on the trace."""
		return self.__ITrace.SymbolInterval


	@SymbolInterval.setter
	def SymbolInterval(self, value: int):
		"""Returns/sets the spacing of the symbols displayed on the trace."""
		self.__ITrace.SymbolInterval = value


	@property
	def SymbolSize(self) -> int:
		"""Returns/sets the size of the symbol displayed on the trace."""
		return self.__ITrace.SymbolSize


	@SymbolSize.setter
	def SymbolSize(self, value: int):
		"""Returns/sets the size of the symbol displayed on the trace."""
		self.__ITrace.SymbolSize = value


	@property
	def SymbolVisible(self) -> bool:
		"""Returns/sets whether the symbol is displayed on the trace."""
		return self.__ITrace.SymbolVisible


	@SymbolVisible.setter
	def SymbolVisible(self, value: bool):
		"""Returns/sets whether the symbol is displayed on the trace."""
		self.__ITrace.SymbolVisible = value


	@property
	def TextVisible(self) -> bool:
		"""Returns/sets whether the trace text is displayed."""
		return self.__ITrace.TextVisible


	@TextVisible.setter
	def TextVisible(self, value: bool):
		"""Returns/sets whether the trace text is displayed."""
		self.__ITrace.TextVisible = value


	@property
	def UseDefaultLegendText(self) -> bool:
		"""Returns/sets whether to use the default legend text for the measurement name."""
		return self.__ITrace.UseDefaultLegendText


	@UseDefaultLegendText.setter
	def UseDefaultLegendText(self, value: bool):
		"""Returns/sets whether to use the default legend text for the measurement name."""
		self.__ITrace.UseDefaultLegendText = value


	@property
	def UseDefaultLegendText2(self) -> bool:
		"""Returns/sets whether to use the default legend text for the data source name."""
		return self.__ITrace.UseDefaultLegendText2


	@UseDefaultLegendText2.setter
	def UseDefaultLegendText2(self, value: bool):
		"""Returns/sets whether to use the default legend text for the data source name."""
		self.__ITrace.UseDefaultLegendText2 = value


	@property
	def Visible(self) -> bool:
		"""Returns/sets whether the trace is displayed on the graph."""
		return self.__ITrace.Visible


	@Visible.setter
	def Visible(self, value: bool):
		"""Returns/sets whether the trace is displayed on the graph."""
		self.__ITrace.Visible = value


	@property
	def Weight(self):
		"""Returns/sets the thickness of the trace."""
		return self.__ITrace.Weight


	@Weight.setter
	def Weight(self, value: mwThickness):
		"""Returns/sets the thickness of the trace."""
		self.__ITrace.Weight = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Traces
class CTraces:
	"""A collection of MWOffice Trace objects."""
	def __init__(self, traces):
		self.__ITraces = traces

	def _get_inner(self):
		return self.__ITraces



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ITraces.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ITraces.Exists(Index)


	def Item(self, Index) -> CTrace:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CTrace(self.__ITraces.Item(Index))


	def __get_Item(self, Index) -> CTrace:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CTrace(self.__ITraces.Item(Index))


	def __call__(self, index) -> CTrace:
		return self.__get_Item(index)


	def __iter__(self) -> CTrace:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ITraces.Count


	def __getitem__(self, index) -> Union[CTrace, List[CTrace]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Legend
class CLegend:
	"""An MWOffice Legend object."""
	def __init__(self, legend):
		self.__ILegend = legend

	def _get_inner(self):
		return self.__ILegend



	@property
	def BorderShadow(self) -> bool:
		"""Returns/sets whether the legend border is displayed with a shadow."""
		return self.__ILegend.BorderShadow


	@BorderShadow.setter
	def BorderShadow(self, value: bool):
		"""Returns/sets whether the legend border is displayed with a shadow."""
		self.__ILegend.BorderShadow = value


	@property
	def BorderVisible(self) -> bool:
		"""Returns/sets whether the legend border is displayed."""
		return self.__ILegend.BorderVisible


	@BorderVisible.setter
	def BorderVisible(self, value: bool):
		"""Returns/sets whether the legend border is displayed."""
		self.__ILegend.BorderVisible = value


	@property
	def Color(self) -> int:
		"""Returns/sets the color used by the legend."""
		return self.__ILegend.Color


	@Color.setter
	def Color(self, value: int):
		"""Returns/sets the color used by the legend."""
		self.__ILegend.Color = value


	@property
	def EntryFormat(self):
		"""Returns/sets the Legend format type"""
		return self.__ILegend.EntryFormat


	@EntryFormat.setter
	def EntryFormat(self, value: mwLegendFormatTypes):
		"""Returns/sets the Legend format type"""
		self.__ILegend.EntryFormat = value


	@property
	def EntryNames(self) -> CObjectNames:
		"""Returns a reference to a collection of MWOffce ObjectName objects."""
		return CObjectNames(self.__ILegend.EntryNames)


	@property
	def Font(self):
		"""Returns/sets the font used by the legend."""
		return self.__ILegend.Font


	@Font.setter
	def Font(self, value):
		"""Returns/sets the font used by the legend."""
		self.__ILegend.Font = value


	@property
	def FontInfo(self) -> CFontInfo:
		"""Returns a reference to a MWOffice FontInfo object."""
		return CFontInfo(self.__ILegend.FontInfo)


	@property
	def FrameResize(self):
		"""Returns/sets the Legend frame resize style."""
		return self.__ILegend.FrameResize


	@FrameResize.setter
	def FrameResize(self, value: mwLegendFrameResizeTypes):
		"""Returns/sets the Legend frame resize style."""
		self.__ILegend.FrameResize = value


	@property
	def Height(self) -> int:
		"""Returns/sets the height of a Legend object."""
		return self.__ILegend.Height


	@Height.setter
	def Height(self, value: int):
		"""Returns/sets the height of a Legend object."""
		self.__ILegend.Height = value


	@property
	def Left(self) -> int:
		"""Returns/sets the left edge of a Legend object."""
		return self.__ILegend.Left


	@Left.setter
	def Left(self, value: int):
		"""Returns/sets the left edge of a Legend object."""
		self.__ILegend.Left = value


	@property
	def Text2Visible(self) -> bool:
		"""Returns/sets whether the additional legend text is displayed."""
		return self.__ILegend.Text2Visible


	@Text2Visible.setter
	def Text2Visible(self, value: bool):
		"""Returns/sets whether the additional legend text is displayed."""
		self.__ILegend.Text2Visible = value


	@property
	def TextVisible(self) -> bool:
		"""Returns/sets whether the legend text is displayed."""
		return self.__ILegend.TextVisible


	@TextVisible.setter
	def TextVisible(self, value: bool):
		"""Returns/sets whether the legend text is displayed."""
		self.__ILegend.TextVisible = value


	@property
	def Top(self) -> int:
		"""Returns/sets the top edge of a Legend object."""
		return self.__ILegend.Top


	@Top.setter
	def Top(self, value: int):
		"""Returns/sets the top edge of a Legend object."""
		self.__ILegend.Top = value


	@property
	def Visible(self) -> bool:
		"""Returns/sets whether the legend is displayed."""
		return self.__ILegend.Visible


	@Visible.setter
	def Visible(self, value: bool):
		"""Returns/sets whether the legend is displayed."""
		self.__ILegend.Visible = value


	@property
	def Width(self) -> int:
		"""Returns/sets the width of a Legend object."""
		return self.__ILegend.Width


	@Width.setter
	def Width(self, value: int):
		"""Returns/sets the width of a Legend object."""
		self.__ILegend.Width = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# MarkerOptions
class CMarkerOptions:
	"""An MWOffice MarkerOptions Object."""
	def __init__(self, markeroptions):
		self.__IMarkerOptions = markeroptions

	def _get_inner(self):
		return self.__IMarkerOptions



	@property
	def Color(self) -> int:
		"""Returns/sets color used by the marker."""
		return self.__IMarkerOptions.Color


	@Color.setter
	def Color(self, value: int):
		"""Returns/sets color used by the marker."""
		self.__IMarkerOptions.Color = value


	@property
	def ConnectorVisible(self) -> bool:
		"""Returns/sets whether the marker connector is displayed."""
		return self.__IMarkerOptions.ConnectorVisible


	@ConnectorVisible.setter
	def ConnectorVisible(self, value: bool):
		"""Returns/sets whether the marker connector is displayed."""
		self.__IMarkerOptions.ConnectorVisible = value


	@property
	def ConnectorWeight(self):
		"""Returns/sets the thickness of the marker connector."""
		return self.__IMarkerOptions.ConnectorWeight


	@ConnectorWeight.setter
	def ConnectorWeight(self, value: mwThickness):
		"""Returns/sets the thickness of the marker connector."""
		self.__IMarkerOptions.ConnectorWeight = value


	@property
	def DataMarkersInLegend(self) -> bool:
		"""Returns/sets if the data markers should be in the legend."""
		return self.__IMarkerOptions.DataMarkersInLegend


	@DataMarkersInLegend.setter
	def DataMarkersInLegend(self, value: bool):
		"""Returns/sets if the data markers should be in the legend."""
		self.__IMarkerOptions.DataMarkersInLegend = value


	@property
	def DisplayFormat(self):
		"""Returns/sets the marker format."""
		return self.__IMarkerOptions.DisplayFormat


	@DisplayFormat.setter
	def DisplayFormat(self, value: mwGraphMarkerFormat):
		"""Returns/sets the marker format."""
		self.__IMarkerOptions.DisplayFormat = value


	@property
	def DisplayType(self):
		"""Returns/sets the marker display type."""
		return self.__IMarkerOptions.DisplayType


	@DisplayType.setter
	def DisplayType(self, value: mwGraphMarkerType):
		"""Returns/sets the marker display type."""
		self.__IMarkerOptions.DisplayType = value


	@property
	def EnableParameterMarkers(self) -> bool:
		"""Returns/sets if the parameter markers should be enabled."""
		return self.__IMarkerOptions.EnableParameterMarkers


	@EnableParameterMarkers.setter
	def EnableParameterMarkers(self, value: bool):
		"""Returns/sets if the parameter markers should be enabled."""
		self.__IMarkerOptions.EnableParameterMarkers = value


	@property
	def FontStyle(self) -> CFontInfo:
		"""Returns a reference to a MWOffice FontInfo object."""
		return CFontInfo(self.__IMarkerOptions.FontStyle)


	@property
	def FrequencyVisible(self) -> bool:
		"""Returns/sets whether the frequency of the marker is displayed."""
		return self.__IMarkerOptions.FrequencyVisible


	@FrequencyVisible.setter
	def FrequencyVisible(self, value: bool):
		"""Returns/sets whether the frequency of the marker is displayed."""
		self.__IMarkerOptions.FrequencyVisible = value


	@property
	def MarkerSymbol(self):
		"""Returns/sets the symbol type for the marker."""
		return self.__IMarkerOptions.MarkerSymbol


	@MarkerSymbol.setter
	def MarkerSymbol(self, value: mwMarkerSymbolType):
		"""Returns/sets the symbol type for the marker."""
		self.__IMarkerOptions.MarkerSymbol = value


	@property
	def MatchTextColorToTrace(self) -> bool:
		"""Returns/sets whether to match the marker text color to the trace color."""
		return self.__IMarkerOptions.MatchTextColorToTrace


	@MatchTextColorToTrace.setter
	def MatchTextColorToTrace(self, value: bool):
		"""Returns/sets whether to match the marker text color to the trace color."""
		self.__IMarkerOptions.MatchTextColorToTrace = value


	@property
	def NamesInLabels(self) -> bool:
		"""Returns/sets whether the marker names should be displayed in the labels."""
		return self.__IMarkerOptions.NamesInLabels


	@NamesInLabels.setter
	def NamesInLabels(self, value: bool):
		"""Returns/sets whether the marker names should be displayed in the labels."""
		self.__IMarkerOptions.NamesInLabels = value


	@property
	def Normalized(self) -> bool:
		"""Returns/sets if marker values are normalized to reference impedance"""
		return self.__IMarkerOptions.Normalized


	@Normalized.setter
	def Normalized(self, value: bool):
		"""Returns/sets if marker values are normalized to reference impedance"""
		self.__IMarkerOptions.Normalized = value


	@property
	def ParameterMarkersInLegend(self) -> bool:
		"""Returns/sets if the parameter markers should be in the legend."""
		return self.__IMarkerOptions.ParameterMarkersInLegend


	@ParameterMarkersInLegend.setter
	def ParameterMarkersInLegend(self, value: bool):
		"""Returns/sets if the parameter markers should be in the legend."""
		self.__IMarkerOptions.ParameterMarkersInLegend = value


	@property
	def RefImpedance(self) -> float:
		"""Returns/sets the reference impedance"""
		return self.__IMarkerOptions.RefImpedance


	@RefImpedance.setter
	def RefImpedance(self, value: float):
		"""Returns/sets the reference impedance"""
		self.__IMarkerOptions.RefImpedance = value


	@property
	def RefMarkerAllTraces(self) -> bool:
		"""Returns/sets if reference markers affect markers on all traces."""
		return self.__IMarkerOptions.RefMarkerAllTraces


	@RefMarkerAllTraces.setter
	def RefMarkerAllTraces(self, value: bool):
		"""Returns/sets if reference markers affect markers on all traces."""
		self.__IMarkerOptions.RefMarkerAllTraces = value


	@property
	def SymbolSize(self) -> int:
		"""Returns/sets the size of the marker symbol."""
		return self.__IMarkerOptions.SymbolSize


	@SymbolSize.setter
	def SymbolSize(self, value: int):
		"""Returns/sets the size of the marker symbol."""
		self.__IMarkerOptions.SymbolSize = value


	@property
	def SymbolVisible(self) -> bool:
		"""Returns/sets whether the marker symbol is displayed."""
		return self.__IMarkerOptions.SymbolVisible


	@SymbolVisible.setter
	def SymbolVisible(self, value: bool):
		"""Returns/sets whether the marker symbol is displayed."""
		self.__IMarkerOptions.SymbolVisible = value


	@property
	def TextColor(self) -> int:
		"""Returns/sets the color to be used for rendering the text of the marker."""
		return self.__IMarkerOptions.TextColor


	@TextColor.setter
	def TextColor(self, value: int):
		"""Returns/sets the color to be used for rendering the text of the marker."""
		self.__IMarkerOptions.TextColor = value


	@property
	def TiedToLabel(self) -> bool:
		"""Returns/sets whether the MarkerDisplay is tied to the label."""
		return self.__IMarkerOptions.TiedToLabel


	@TiedToLabel.setter
	def TiedToLabel(self, value: bool):
		"""Returns/sets whether the MarkerDisplay is tied to the label."""
		self.__IMarkerOptions.TiedToLabel = value


	@property
	def Transparent(self) -> bool:
		"""Returns/sets whether the MarkerDisplay background is transparent."""
		return self.__IMarkerOptions.Transparent


	@Transparent.setter
	def Transparent(self, value: bool):
		"""Returns/sets whether the MarkerDisplay background is transparent."""
		self.__IMarkerOptions.Transparent = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# MarkerDisplay
class CMarkerDisplay:
	"""An MWOffice MarkerDisplay Object."""
	def __init__(self, markerdisplay):
		self.__IMarkerDisplay = markerdisplay

	def _get_inner(self):
		return self.__IMarkerDisplay



	@property
	def DisplayText(self) -> str:
		"""Returns the text associated with the MWOffice MarkerDisplay object."""
		return self.__IMarkerDisplay.DisplayText


	@property
	def Height(self) -> int:
		"""Returns/sets the height of a Marker object."""
		return self.__IMarkerDisplay.Height


	@Height.setter
	def Height(self, value: int):
		"""Returns/sets the height of a Marker object."""
		self.__IMarkerDisplay.Height = value


	@property
	def Left(self) -> int:
		"""Returns/sets the left edge of a Marker object."""
		return self.__IMarkerDisplay.Left


	@Left.setter
	def Left(self, value: int):
		"""Returns/sets the left edge of a Marker object."""
		self.__IMarkerDisplay.Left = value


	@property
	def Top(self) -> int:
		"""Returns/sets the top edge of a Marker object."""
		return self.__IMarkerDisplay.Top


	@Top.setter
	def Top(self, value: int):
		"""Returns/sets the top edge of a Marker object."""
		self.__IMarkerDisplay.Top = value


	@property
	def Width(self) -> int:
		"""Returns/sets the width of a Marker object."""
		return self.__IMarkerDisplay.Width


	@Width.setter
	def Width(self, value: int):
		"""Returns/sets the width of a Marker object."""
		self.__IMarkerDisplay.Width = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# MarkerLegend
class CMarkerLegend:
	"""An MWOffice MarkerLegend Object."""
	def __init__(self, markerdisplay):
		self.__IMarkerDisplay = markerdisplay

	def _get_inner(self):
		return self.__IMarkerDisplay



	@property
	def DisplayText(self) -> str:
		"""Returns the text associated with the MWOffice MarkerDisplay object."""
		return self.__IMarkerDisplay.DisplayText


	@property
	def Height(self) -> int:
		"""Returns/sets the height of a Marker object."""
		return self.__IMarkerDisplay.Height


	@Height.setter
	def Height(self, value: int):
		"""Returns/sets the height of a Marker object."""
		self.__IMarkerDisplay.Height = value


	@property
	def Left(self) -> int:
		"""Returns/sets the left edge of a Marker object."""
		return self.__IMarkerDisplay.Left


	@Left.setter
	def Left(self, value: int):
		"""Returns/sets the left edge of a Marker object."""
		self.__IMarkerDisplay.Left = value


	@property
	def Top(self) -> int:
		"""Returns/sets the top edge of a Marker object."""
		return self.__IMarkerDisplay.Top


	@Top.setter
	def Top(self, value: int):
		"""Returns/sets the top edge of a Marker object."""
		self.__IMarkerDisplay.Top = value


	@property
	def Width(self) -> int:
		"""Returns/sets the width of a Marker object."""
		return self.__IMarkerDisplay.Width


	@Width.setter
	def Width(self, value: int):
		"""Returns/sets the width of a Marker object."""
		self.__IMarkerDisplay.Width = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# AutoSearchMarker
class CAutoSearchMarker:
	"""An MWOffice AutoSearchMarker Object."""
	def __init__(self, autosearchmarker):
		self.__IAutoSearchMarker = autosearchmarker

	def _get_inner(self):
		return self.__IAutoSearchMarker



	@property
	def ApertureHeight(self) -> float:
		"""Returns/sets the height of the aperture for a Peak/Valley AutoSearchMarker object."""
		return self.__IAutoSearchMarker.ApertureHeight


	@ApertureHeight.setter
	def ApertureHeight(self, value: float):
		"""Returns/sets the height of the aperture for a Peak/Valley AutoSearchMarker object."""
		self.__IAutoSearchMarker.ApertureHeight = value


	@property
	def ApertureWidth(self) -> float:
		"""Returns/sets the width of the aperture for a Peak/Valley AutoSearchMarker object."""
		return self.__IAutoSearchMarker.ApertureWidth


	@ApertureWidth.setter
	def ApertureWidth(self, value: float):
		"""Returns/sets the width of the aperture for a Peak/Valley AutoSearchMarker object."""
		self.__IAutoSearchMarker.ApertureWidth = value


	@property
	def YValue(self) -> float:
		"""Returns/sets the Y value for which an AutoSearchMarker object in Value mode will search."""
		return self.__IAutoSearchMarker.YValue


	@YValue.setter
	def YValue(self, value: float):
		"""Returns/sets the Y value for which an AutoSearchMarker object in Value mode will search."""
		self.__IAutoSearchMarker.YValue = value


	@property
	def mode(self):
		"""Returns/sets the auto-search mode of an AutoSearchMarker object."""
		return self.__IAutoSearchMarker.mode


	@mode.setter
	def mode(self, value: mwMarkerAutoSearchMode):
		"""Returns/sets the auto-search mode of an AutoSearchMarker object."""
		self.__IAutoSearchMarker.mode = value


	@property
	def xIndex(self) -> int:
		"""Returns/sets the X index for which an AutoSearchMarker object in XIndex mode will search."""
		return self.__IAutoSearchMarker.xIndex


	@xIndex.setter
	def xIndex(self, value: int):
		"""Returns/sets the X index for which an AutoSearchMarker object in XIndex mode will search."""
		self.__IAutoSearchMarker.xIndex = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# OffsetMarker
class COffsetMarker:
	"""An MWOffice OffsetMarker Object."""
	def __init__(self, offsetmarker):
		self.__IOffsetMarker = offsetmarker

	def _get_inner(self):
		return self.__IOffsetMarker



	@property
	def Distance(self) -> float:
		"""Returns/sets the offset distance for an OffsetMarker object."""
		return self.__IOffsetMarker.Distance


	@Distance.setter
	def Distance(self, value: float):
		"""Returns/sets the offset distance for an OffsetMarker object."""
		self.__IOffsetMarker.Distance = value


	@property
	def ReferenceMarker(self) -> str:
		"""Returns/sets the name of the marker referenced by an OffsetMarker object."""
		return self.__IOffsetMarker.ReferenceMarker


	@ReferenceMarker.setter
	def ReferenceMarker(self, value: str):
		"""Returns/sets the name of the marker referenced by an OffsetMarker object."""
		self.__IOffsetMarker.ReferenceMarker = value


	@property
	def SearchDirection(self):
		"""Returns/sets the search direction for an OffsetMarker object."""
		return self.__IOffsetMarker.SearchDirection


	@SearchDirection.setter
	def SearchDirection(self, value: mwMarkerOffsetSearchDir):
		"""Returns/sets the search direction for an OffsetMarker object."""
		self.__IOffsetMarker.SearchDirection = value


	@property
	def mode(self):
		"""Returns/sets the offset mode of an OffsetMarker object."""
		return self.__IOffsetMarker.mode


	@mode.setter
	def mode(self, value: mwMarkerOffsetMode):
		"""Returns/sets the offset mode of an OffsetMarker object."""
		self.__IOffsetMarker.mode = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Marker
class CMarker:
	"""An MWOffice Marker object."""
	def __init__(self, marker):
		self.__IMarker = marker

	def _get_inner(self):
		return self.__IMarker


	def Delete(self) -> bool:
		"""Removes the object."""
		return self.__IMarker.Delete()


	def MoveToMaximum(self) -> bool:
		"""Move the marker to display the maximum trace value."""
		return self.__IMarker.MoveToMaximum()


	def MoveToMinimum(self) -> bool:
		"""Move the marker to display the minimum trace value."""
		return self.__IMarker.MoveToMinimum()


	def Search(self, Value: float, mode: mwMarkerSearchMode = 0, dir: mwMarkerSearchDirection = 0, var: mwMarkerSearchVariable = 1) -> bool:
		"""Perform a marker search for a specified trace value."""
		return self.__IMarker.Search(Value, mode, dir, var)



	@property
	def AutoSearch(self) -> CAutoSearchMarker:
		"""Returns a reference to an MWOffice AutoSearchMarker object."""
		return CAutoSearchMarker(self.__IMarker.AutoSearch)


	@property
	def DataItem(self) -> int:
		"""Returns/Sets the data item index for the Marker object."""
		return self.__IMarker.DataItem


	@DataItem.setter
	def DataItem(self, value: int):
		"""Returns/Sets the data item index for the Marker object."""
		self.__IMarker.DataItem = value


	@property
	def DataItemMax(self) -> int:
		"""Returns the maximum allowable data index for the marker object."""
		return self.__IMarker.DataItemMax


	def DataValue(self, dataDim: int) -> float:
		"""Returns the data value associated with this Marker object."""
		return self.__IMarker.DataValue(dataDim)


	@property
	def DataValueText(self) -> str:
		"""Returns a text string with the numeric values from the marker label."""
		return self.__IMarker.DataValueText


	@property
	def Display(self) -> CMarkerDisplay:
		"""Returns a reference to an MWOffice MarkerDisplay object."""
		return CMarkerDisplay(self.__IMarker.Display)


	@property
	def Measurement(self) -> str:
		"""Returns the measurement name associated with this Marker object."""
		return self.__IMarker.Measurement


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IMarker.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__IMarker.Name = value


	@property
	def NumDataValueDim(self) -> int:
		"""Returns the number of data value dimensions available from the data value property."""
		return self.__IMarker.NumDataValueDim


	@property
	def Offset(self) -> COffsetMarker:
		"""Returns a reference to an MWOffice OffsetMarker object."""
		return COffsetMarker(self.__IMarker.Offset)


	@property
	def ReferenceMarker(self) -> bool:
		"""Returns if the marker is a reference marker object."""
		return self.__IMarker.ReferenceMarker


	@property
	def SweepValue(self) -> float:
		"""Returns/Sets the sweep value associated with this Marker object."""
		return self.__IMarker.SweepValue


	@SweepValue.setter
	def SweepValue(self, value: float):
		"""Returns/Sets the sweep value associated with this Marker object."""
		self.__IMarker.SweepValue = value


	@property
	def TraceIndex(self) -> int:
		"""Returns/Sets the trace index of the Marker object."""
		return self.__IMarker.TraceIndex


	@TraceIndex.setter
	def TraceIndex(self, value: int):
		"""Returns/Sets the trace index of the Marker object."""
		self.__IMarker.TraceIndex = value


	@property
	def TraceIndexMax(self) -> int:
		"""Returns the maximum value for the trace index of the Marker object."""
		return self.__IMarker.TraceIndexMax


	@property
	def Type(self):
		"""Returns the type of Marker object."""
		return self.__IMarker.Type


	@Type.setter
	def Type(self, value: mwMarkerType):
		"""Returns the type of Marker object."""
		self.__IMarker.Type = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Markers
class CMarkers:
	"""A collection of MWOffice Marker objects."""
	def __init__(self, markers):
		self.__IMarkers = markers

	def _get_inner(self):
		return self.__IMarkers


	def Add(self, MeasurementIndex, DataIndex, SweepPoint: float) -> CMarker:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CMarker(self.__IMarkers.Add(MeasurementIndex, DataIndex, SweepPoint))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IMarkers.Remove(Index)


	def RemoveAll(self) -> None:
		"""Removes all objects in a collection."""
		self.__IMarkers.RemoveAll()


	def AddEx(self, MeasurementIndex, DataIndex, SweepPoint: float, TraceIndex: int) -> CMarker:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CMarker(self.__IMarkers.AddEx(MeasurementIndex, DataIndex, SweepPoint, TraceIndex))



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IMarkers.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IMarkers.Exists(Index)


	def Item(self, Index) -> CMarker:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CMarker(self.__IMarkers.Item(Index))


	def __get_Item(self, Index) -> CMarker:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CMarker(self.__IMarkers.Item(Index))


	def __call__(self, index) -> CMarker:
		return self.__get_Item(index)


	def __iter__(self) -> CMarker:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IMarkers.Count


	def __getitem__(self, index) -> Union[CMarker, List[CMarker]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def Legend(self) -> CMarkerDisplay:
		"""Returns a reference to a Legend object."""
		return CMarkerDisplay(self.__IMarkers.Legend)


	@property
	def MeasurementCount(self) -> int:
		"""Returns a count of the available measurements for adding markers. The measurement index must be in this range when adding markers."""
		return self.__IMarkers.MeasurementCount


	def MeasurementDataItemCount(self, MeasurementIndex) -> int:
		"""Returns a count of the data items associated with a measurement for adding markers. The data index must be in this range when adding a marker to a measurement."""
		return self.__IMarkers.MeasurementDataItemCount(MeasurementIndex)


	@property
	def Options(self) -> CMarkerOptions:
		"""Returns a reference to an MWOffice MarkerOptions object."""
		return CMarkerOptions(self.__IMarkers.Options)


	@property
	def ParameterMarkerLegend(self) -> CMarkerDisplay:
		"""Returns a reference to a Legend object."""
		return CMarkerDisplay(self.__IMarkers.ParameterMarkerLegend)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LineMarker
class CLineMarker:
	"""An MWOffice LineMarker object."""
	def __init__(self, linemarker):
		self.__ILineMarker = linemarker

	def _get_inner(self):
		return self.__ILineMarker



	@property
	def Axis(self) -> int:
		"""Returns/sets the Y-Axis id for this LineMarker object."""
		return self.__ILineMarker.Axis


	@Axis.setter
	def Axis(self, value: int):
		"""Returns/sets the Y-Axis id for this LineMarker object."""
		self.__ILineMarker.Axis = value


	def DataValue(self, measIndex: int, TraceIndex: int) -> float:
		"""Returns the measured value for the specified measurement and trace"""
		return self.__ILineMarker.DataValue(measIndex, TraceIndex)


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__ILineMarker.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__ILineMarker.Name = value


	@property
	def Number(self) -> int:
		"""Returns/sets the number associated with this LineMarker object."""
		return self.__ILineMarker.Number


	@Number.setter
	def Number(self, value: int):
		"""Returns/sets the number associated with this LineMarker object."""
		self.__ILineMarker.Number = value


	@property
	def Track(self):
		"""Returns the track mode for this LineMarker object."""
		return self.__ILineMarker.Track


	@property
	def Type(self):
		"""Returns the type of the LineMarker object."""
		return self.__ILineMarker.Type


	@property
	def UnitType(self):
		"""Returns the unit type for this LineMarker object."""
		return self.__ILineMarker.UnitType


	@property
	def Value(self) -> float:
		"""Returns/sets the value of the LineMarker object."""
		return self.__ILineMarker.Value


	@Value.setter
	def Value(self, value: float):
		"""Returns/sets the value of the LineMarker object."""
		self.__ILineMarker.Value = value


	@property
	def Visible(self) -> bool:
		"""Returns if this line marker is visible in the current Graph grid area."""
		return self.__ILineMarker.Visible


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LineMarkers
class CLineMarkers:
	"""A collection of MWOffice LineMarker objects."""
	def __init__(self, linemarkers):
		self.__ILineMarkers = linemarkers

	def _get_inner(self):
		return self.__ILineMarkers


	def Add(self, Type: mwLineMarkerType, Value: float, AxisIndex) -> CLineMarker:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CLineMarker(self.__ILineMarkers.Add(Type, Value, AxisIndex))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ILineMarkers.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__ILineMarkers.RemoveAll()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ILineMarkers.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ILineMarkers.Exists(Index)


	def Item(self, Index) -> CLineMarker:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLineMarker(self.__ILineMarkers.Item(Index))


	def __get_Item(self, Index) -> CLineMarker:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLineMarker(self.__ILineMarkers.Item(Index))


	def __call__(self, index) -> CLineMarker:
		return self.__get_Item(index)


	def __iter__(self) -> CLineMarker:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ILineMarkers.Count


	def __getitem__(self, index) -> Union[CLineMarker, List[CLineMarker]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Measurement
class CMeasurement:
	"""An MWOffice Measurement object."""
	def __init__(self, measurement):
		self.__IMeasurement = measurement

	def _get_inner(self):
		return self.__IMeasurement


	def ResizeFor2D(self, xCount: int, DataDimension: int) -> None:
		"""Resizes a Measurement object for two dimensions."""
		self.__IMeasurement.ResizeFor2D(xCount, DataDimension)


	def ResizeFor3D(self, xCount: int, yCount: int, DataDimension: int) -> None:
		"""Resizes a Measurement object for three dimensions."""
		self.__IMeasurement.ResizeFor3D(xCount, yCount, DataDimension)


	def Update(self) -> None:
		"""Updates a Measurement object."""
		self.__IMeasurement.Update()


	def ResizeFor2DEx(self, xCount: int, DataDimension: int, TraceCount: int, SeparateXAxis: bool) -> None:
		"""Resizes a Measurement object for two dimensions and allows specification of the trace count."""
		self.__IMeasurement.ResizeFor2DEx(xCount, DataDimension, TraceCount, SeparateXAxis)


	def SimulateMeasurement(self) -> bool:
		"""Perform simulations required for this measurement."""
		return self.__IMeasurement.SimulateMeasurement()



	@property
	def AxisIndex(self) -> int:
		"""Returns/sets the index of the plot axis for this measurement."""
		return self.__IMeasurement.AxisIndex


	@AxisIndex.setter
	def AxisIndex(self, value: int):
		"""Returns/sets the index of the plot axis for this measurement."""
		self.__IMeasurement.AxisIndex = value


	def AxisPointLabel(self, nIndex: int) -> str:
		"""Returns/sets a axis point label for this measurement."""
		return self.__IMeasurement.AxisPointLabel(nIndex)


	def SetAxisPointLabel(self, nIndex: int, value: str):
		"""Returns/sets a axis point label for this measurement."""
		self.__IMeasurement.AxisPointLabel = value


	@property
	def AxisPointLabelCount(self) -> int:
		"""Returns a count of the axis point labels for this measurement."""
		return self.__IMeasurement.AxisPointLabelCount


	def DataPointLabel(self, xIndex: int) -> str:
		"""Returns/sets the label for a data point of a Measurement object."""
		return self.__IMeasurement.DataPointLabel(xIndex)


	def SetDataPointLabel(self, xIndex: int, value: str):
		"""Returns/sets the label for a data point of a Measurement object."""
		self.__IMeasurement.DataPointLabel = value


	@property
	def DataType(self):
		"""Returns/sets the data type of a Measurement object."""
		return self.__IMeasurement.DataType


	@DataType.setter
	def DataType(self, value: mwMeasDataType):
		"""Returns/sets the data type of a Measurement object."""
		self.__IMeasurement.DataType = value


	@property
	def Enabled(self) -> bool:
		"""Returns/sets a value which specifies if the Measurement object is enabled."""
		return self.__IMeasurement.Enabled


	@Enabled.setter
	def Enabled(self, value: bool):
		"""Returns/sets a value which specifies if the Measurement object is enabled."""
		self.__IMeasurement.Enabled = value


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IMeasurement.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__IMeasurement.Name = value


	@property
	def OnLeftAxis(self) -> bool:
		"""Returns/sets a value indicating if the measurement is plotted against the left axis."""
		return self.__IMeasurement.OnLeftAxis


	@OnLeftAxis.setter
	def OnLeftAxis(self, value: bool):
		"""Returns/sets a value indicating if the measurement is plotted against the left axis."""
		self.__IMeasurement.OnLeftAxis = value


	@property
	def PlotDimension(self) -> int:
		"""Returns the plot dimension of a Measurement object."""
		return self.__IMeasurement.PlotDimension


	@property
	def Source(self) -> str:
		"""Returns the source of a Measurement object."""
		return self.__IMeasurement.Source


	@Source.setter
	def Source(self, value: str):
		"""Returns the source of a Measurement object."""
		self.__IMeasurement.Source = value


	def SweepLabels(self, trace_index: int) -> CSweepLabels:
		"""Returns a reference to a collection of MeasurementInfo objects."""
		return CSweepLabels(self.__IMeasurement.SweepLabels(trace_index))


	@property
	def Tag(self) -> str:
		"""Returns/sets the tag value of the object."""
		return self.__IMeasurement.Tag


	@Tag.setter
	def Tag(self, value: str):
		"""Returns/sets the tag value of the object."""
		self.__IMeasurement.Tag = value


	@property
	def TraceCount(self) -> int:
		"""Returns the number of traces for this measurement."""
		return self.__IMeasurement.TraceCount


	def TraceValues(self, trace_index: int):
		"""Returns the x/y values associated with a trace"""
		return self.__IMeasurement.TraceValues(trace_index)


	@property
	def Type(self) -> str:
		"""Returns the parameter of a Measurement object."""
		return self.__IMeasurement.Type


	@Type.setter
	def Type(self, value: str):
		"""Returns the parameter of a Measurement object."""
		self.__IMeasurement.Type = value


	def UnitType(self, dim: int):
		"""Returns/sets the unit type of a Measurement object."""
		return self.__IMeasurement.UnitType(dim)


	def SetUnitType(self, dim: int, value: mwUnitType):
		"""Returns/sets the unit type of a Measurement object."""
		self.__IMeasurement.UnitType = value


	@property
	def XPointCount(self) -> int:
		"""Returns the number of X points of a Measurement object."""
		return self.__IMeasurement.XPointCount


	def XValue(self, xIndex: int) -> float:
		"""Returns/sets the X value of a Measurement object."""
		return self.__IMeasurement.XValue(xIndex)


	def SetXValue(self, xIndex: int, value: float):
		"""Returns/sets the X value of a Measurement object."""
		self.__IMeasurement.XValue = value


	@property
	def XValues(self):
		"""Returns/sets the X values of a Measurement object."""
		return self.__IMeasurement.XValues


	@XValues.setter
	def XValues(self, value):
		"""Returns/sets the X values of a Measurement object."""
		self.__IMeasurement.XValues = value


	@property
	def YDataDim(self) -> int:
		"""Returns the number of Y dimensions of a Measurement object."""
		return self.__IMeasurement.YDataDim


	@property
	def YPointCount(self) -> int:
		"""Returns the number of Y points of a Measurement object."""
		return self.__IMeasurement.YPointCount


	def YValue(self, xIndex: int, DataDimension: int) -> float:
		"""Returns/sets the Y value of a Measurement object."""
		return self.__IMeasurement.YValue(xIndex, DataDimension)


	def SetYValue(self, xIndex: int, DataDimension: int, value: float):
		"""Returns/sets the Y value of a Measurement object."""
		self.__IMeasurement.YValue = value


	def YValues(self, DataDimension: int):
		"""Returns/sets the Y values of a Measurement object."""
		return self.__IMeasurement.YValues(DataDimension)


	def SetYValues(self, DataDimension: int, value):
		"""Returns/sets the Y values of a Measurement object."""
		self.__IMeasurement.YValues = value


	@property
	def ZDataDim(self) -> int:
		"""Returns the number of Z dimensions of a Measurement object."""
		return self.__IMeasurement.ZDataDim


	def ZValue(self, xIndex: int, yIndex: int, DataDimension: int) -> float:
		"""Returns/sets the Z value of a Measurement object."""
		return self.__IMeasurement.ZValue(xIndex, yIndex, DataDimension)


	def SetZValue(self, xIndex: int, yIndex: int, DataDimension: int, value: float):
		"""Returns/sets the Z value of a Measurement object."""
		self.__IMeasurement.ZValue = value


	def ZValues(self, DataDimension: int):
		"""Returns/sets the Z values of a Measurement object."""
		return self.__IMeasurement.ZValues(DataDimension)


	def SetZValues(self, DataDimension: int, value):
		"""Returns/sets the Z values of a Measurement object."""
		self.__IMeasurement.ZValues = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Measurements
class CMeasurements:
	"""A collection of MWOffice Measurement objects."""
	def __init__(self, measurements):
		self.__IMeasurements = measurements

	def _get_inner(self):
		return self.__IMeasurements


	def Add(self, SourceDoc: str, Measurement: str) -> CMeasurement:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CMeasurement(self.__IMeasurements.Add(SourceDoc, Measurement))


	def RemoveAll(self) -> None:
		"""Removes all objects in a collection."""
		self.__IMeasurements.RemoveAll()


	def Remove(self, MeasName: str) -> None:
		"""Removes a specific member from a collection."""
		self.__IMeasurements.Remove(MeasName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IMeasurements.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IMeasurements.Exists(Index)


	def Item(self, Index) -> CMeasurement:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CMeasurement(self.__IMeasurements.Item(Index))


	def __get_Item(self, Index) -> CMeasurement:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CMeasurement(self.__IMeasurements.Item(Index))


	def __call__(self, index) -> CMeasurement:
		return self.__get_Item(index)


	def __iter__(self) -> CMeasurement:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IMeasurements.Count


	def __getitem__(self, index) -> Union[CMeasurement, List[CMeasurement]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Netlist
class CNetlist:
	"""An MWOffice Netlist object."""
	def __init__(self, netlist):
		self.__INetlist = netlist

	def _get_inner(self):
		return self.__INetlist


	def Activate(self) -> None:
		"""Activates the objects."""
		self.__INetlist.Activate()


	def NewWindow(self) -> CWindow:
		"""Displays the object in new window."""
		return CWindow(self.__INetlist.NewWindow())


	def PrintOut(self) -> None:
		"""Sends the object to the current printer."""
		self.__INetlist.PrintOut()


	def Export(self, FilePath: str) -> bool:
		"""Exports a design document file from MWOffice."""
		return self.__INetlist.Export(FilePath)


	def Parse(self) -> None:
		"""Parse the netlist."""
		self.__INetlist.Parse()


	def IsSimulationStateFlagSet(self, flag: mwSimStateFlags) -> bool:
		"""Returns a value that indicates if a certain simulation state flag is set."""
		return self.__INetlist.IsSimulationStateFlagSet(flag)


	def Embed(self) -> None:
		"""Convert an externally linked netlist into an embedded document."""
		self.__INetlist.Embed()


	def LinkToFile(self, FilePath: str) -> None:
		"""Convert an embedded netlist into an externally linked document."""
		self.__INetlist.LinkToFile(FilePath)


	def Reload(self) -> None:
		"""Reload an externally linked netlist."""
		self.__INetlist.Reload()


	def Save(self) -> None:
		"""Update the externally linked netlist file."""
		self.__INetlist.Save()



	@property
	def Embedded(self) -> bool:
		"""Returns a value which specifies if the Netlist object is embedded."""
		return self.__INetlist.Embedded


	@property
	def Filename(self) -> str:
		"""Returns the file name of a linked Netlist object."""
		return self.__INetlist.Filename


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__INetlist.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__INetlist.Name = value


	@property
	def Properties(self) -> CProperties:
		"""Returns a reference to a collection of Property objects."""
		return CProperties(self.__INetlist.Properties)


	@property
	def SimulationDirty(self) -> bool:
		"""Returns if the current simulation state is dirty for the object."""
		return self.__INetlist.SimulationDirty


	@property
	def SimulationState(self) -> int:
		"""Returns the current simulation state for the object."""
		return self.__INetlist.SimulationState


	@property
	def Text(self) -> str:
		"""Returns/sets the text value of a Netlist object."""
		return self.__INetlist.Text


	@Text.setter
	def Text(self, value: str):
		"""Returns/sets the text value of a Netlist object."""
		self.__INetlist.Text = value


	@property
	def Type(self):
		"""Returns the type of a Netlist object."""
		return self.__INetlist.Type


	@property
	def Windows(self) -> CWindows:
		"""Returns a reference to a collection of Window objects."""
		return CWindows(self.__INetlist.Windows)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Netlists
class CNetlists:
	"""A collection of MWOffice Netlist objects."""
	def __init__(self, netlists):
		self.__INetlists = netlists

	def _get_inner(self):
		return self.__INetlists


	def Add(self, Name: str) -> CNetlist:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CNetlist(self.__INetlists.Add(Name))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__INetlists.Remove(Index)


	def Import(self, Name: str, Filename: str, Embedded: bool, Type: mwNetlistType) -> CNetlist:
		"""Adds an object to the collection from a file and returns a reference to the created object."""
		return CNetlist(self.__INetlists.Import(Name, Filename, Embedded, Type))


	def AddEx(self, Name: str, Type: mwNetlistType, Value = 0) -> CNetlist:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CNetlist(self.__INetlists.AddEx(Name, Type, Value))


	def LinkTo(self, Name: str, Filename: str, Type: mwNetlistType) -> CNetlist:
		"""Adds a Netlist object link to the collection from a file and returns a reference to the created object."""
		return CNetlist(self.__INetlists.LinkTo(Name, Filename, Type))


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__INetlists.GetUniqueName(baseName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__INetlists.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__INetlists.Exists(Index)


	def Item(self, Index) -> CNetlist:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CNetlist(self.__INetlists.Item(Index))


	def __get_Item(self, Index) -> CNetlist:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CNetlist(self.__INetlists.Item(Index))


	def __call__(self, index) -> CNetlist:
		return self.__get_Item(index)


	def __iter__(self) -> CNetlist:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__INetlists.Count


	def __getitem__(self, index) -> Union[CNetlist, List[CNetlist]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Node
class CNode:
	"""An MWOffice Node object."""
	def __init__(self, node):
		self.__INode = node

	def _get_inner(self):
		return self.__INode



	@property
	def Connected(self) -> bool:
		"""Returns if the node is connected to other elements in the design."""
		return self.__INode.Connected


	@property
	def DataType(self):
		"""Returns a value describing the data type of the node."""
		return self.__INode.DataType


	@DataType.setter
	def DataType(self, value: mwNodeDataType):
		"""Returns a value describing the data type of the node."""
		self.__INode.DataType = value


	def NodeFlags(self, nodeFlag: mwNodeFlags) -> bool:
		"""Returns the flags associated with this node."""
		return self.__INode.NodeFlags(nodeFlag)


	@property
	def NodeLabel(self) -> str:
		"""Returns the label associated with this node."""
		return self.__INode.NodeLabel


	@property
	def NodeNumber(self) -> int:
		"""Returns the node number for this node."""
		return self.__INode.NodeNumber


	@property
	def PortNumber(self) -> int:
		"""Returns the port number for this node."""
		return self.__INode.PortNumber


	@property
	def Type(self):
		"""Returns a value describing the type of the node."""
		return self.__INode.Type


	@property
	def x(self) -> int:
		"""Returns the X value of a Node object."""
		return self.__INode.x


	@property
	def y(self) -> int:
		"""Returns the Y value of a Node object."""
		return self.__INode.y


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Nodes
class CNodes:
	"""A collection of MWOffice Node objects."""
	def __init__(self, nodes):
		self.__INodes = nodes

	def _get_inner(self):
		return self.__INodes



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__INodes.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__INodes.Exists(Index)


	def Item(self, Index) -> CNode:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CNode(self.__INodes.Item(Index))


	def __get_Item(self, Index) -> CNode:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CNode(self.__INodes.Item(Index))


	def __call__(self, index) -> CNode:
		return self.__get_Item(index)


	def __iter__(self) -> CNode:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__INodes.Count


	def __getitem__(self, index) -> Union[CNode, List[CNode]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# OptGoals
class COptGoals:
	"""A collection of MWOffice Goal objects."""
	def __init__(self, optgoals):
		self.__IOptGoals = optgoals

	def _get_inner(self):
		return self.__IOptGoals


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IOptGoals.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IOptGoals.RemoveAll()


	def AddGoal(self, CircuitName: str, MeasName: str, GoalType: mwOptGoalType, Weight: float, L: float, xStart: float, xStop: float, xUnit: mwUnitType, yStart: float, yStop: float, yUnit: mwUnitType) -> CGoal:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CGoal(self.__IOptGoals.AddGoal(CircuitName, MeasName, GoalType, Weight, L, xStart, xStop, xUnit, yStart, yStop, yUnit))



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IOptGoals.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IOptGoals.Exists(Index)


	def Item(self, Index) -> CGoal:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CGoal(self.__IOptGoals.Item(Index))


	def __get_Item(self, Index) -> CGoal:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CGoal(self.__IOptGoals.Item(Index))


	def __call__(self, index) -> CGoal:
		return self.__get_Item(index)


	def __iter__(self) -> CGoal:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IOptGoals.Count


	def __getitem__(self, index) -> Union[CGoal, List[CGoal]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def TotalCost(self) -> float:
		"""Returns the total cost of a collection of Goal object."""
		return self.__IOptGoals.TotalCost


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Parameter
class CParameter:
	"""An MWOffice Parameter object."""
	def __init__(self, parameter):
		self.__IParameter = parameter

	def _get_inner(self):
		return self.__IParameter



	@property
	def Constrain(self) -> bool:
		"""Returns/sets a value which specifies if the object is constrained by the upper and lower limit."""
		return self.__IParameter.Constrain


	@Constrain.setter
	def Constrain(self, value: bool):
		"""Returns/sets a value which specifies if the object is constrained by the upper and lower limit."""
		self.__IParameter.Constrain = value


	@property
	def Description(self) -> str:
		"""Returns the description of the object."""
		return self.__IParameter.Description


	@property
	def Distribution(self):
		"""Returns/sets a value which specifies the distribution type of the object."""
		return self.__IParameter.Distribution


	@Distribution.setter
	def Distribution(self, value: mwStatisticalDist):
		"""Returns/sets a value which specifies the distribution type of the object."""
		self.__IParameter.Distribution = value


	@property
	def HasError(self) -> bool:
		"""Returns a value which specifies if the Parameter object has an error."""
		return self.__IParameter.HasError


	@property
	def Independent(self) -> bool:
		"""Returns a value which specifies if the Parameter object is independent."""
		return self.__IParameter.Independent


	@property
	def LowerConstraint(self) -> float:
		"""Returns/sets the lower constraint of the object."""
		return self.__IParameter.LowerConstraint


	@LowerConstraint.setter
	def LowerConstraint(self, value: float):
		"""Returns/sets the lower constraint of the object."""
		self.__IParameter.LowerConstraint = value


	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__IParameter.Name


	@property
	def Optimize(self) -> bool:
		"""Returns/sets a value which specifies if the object is optimized."""
		return self.__IParameter.Optimize


	@Optimize.setter
	def Optimize(self, value: bool):
		"""Returns/sets a value which specifies if the object is optimized."""
		self.__IParameter.Optimize = value


	@property
	def OptimizeYield(self) -> bool:
		"""Returns/sets a value which specifies if the object's yield is optimized."""
		return self.__IParameter.OptimizeYield


	@OptimizeYield.setter
	def OptimizeYield(self, value: bool):
		"""Returns/sets a value which specifies if the object's yield is optimized."""
		self.__IParameter.OptimizeYield = value


	@property
	def ParameterDefinition(self) -> CParameterDefinition:
		"""Returns a reference to a MWOffice ParameterDefinition object."""
		return CParameterDefinition(self.__IParameter.ParameterDefinition)


	@property
	def ReadOnly(self) -> bool:
		"""Returns a value which specifies if the Parameter object is read-only."""
		return self.__IParameter.ReadOnly


	@property
	def StatVariation(self) -> float:
		"""Returns/sets the statistical variation parameter of the object."""
		return self.__IParameter.StatVariation


	@StatVariation.setter
	def StatVariation(self, value: float):
		"""Returns/sets the statistical variation parameter of the object."""
		self.__IParameter.StatVariation = value


	@property
	def StatVariation2(self) -> float:
		"""Returns/sets the second statistical variation parameter of the object."""
		return self.__IParameter.StatVariation2


	@StatVariation2.setter
	def StatVariation2(self, value: float):
		"""Returns/sets the second statistical variation parameter of the object."""
		self.__IParameter.StatVariation2 = value


	@property
	def StepSize(self) -> float:
		"""Returns/sets the step size used for tuning and discrete optimization of the object."""
		return self.__IParameter.StepSize


	@StepSize.setter
	def StepSize(self, value: float):
		"""Returns/sets the step size used for tuning and discrete optimization of the object."""
		self.__IParameter.StepSize = value


	def Style(self, Style: mwParameterStyle):
		"""Returns/sets a value which specifies the style of a parameter object. Styles should be set to mwParamStyleSetting enum values"""
		return self.__IParameter.Style(Style)


	def SetStyle(self, Style: mwParameterStyle, value: mwParameterStyleSetting):
		"""Returns/sets a value which specifies the style of a parameter object. Styles should be set to mwParamStyleSetting enum values"""
		self.__IParameter.Style = value


	@property
	def Tag(self) -> str:
		"""Returns/sets the tag value of the object."""
		return self.__IParameter.Tag


	@Tag.setter
	def Tag(self, value: str):
		"""Returns/sets the tag value of the object."""
		self.__IParameter.Tag = value


	@property
	def TolInPercent(self) -> bool:
		"""Returns/sets a value which specifies if the object's total is in percent."""
		return self.__IParameter.TolInPercent


	@TolInPercent.setter
	def TolInPercent(self, value: bool):
		"""Returns/sets a value which specifies if the object's total is in percent."""
		self.__IParameter.TolInPercent = value


	@property
	def Tune(self) -> bool:
		"""Returns/sets a value which specifies if the object is tuned."""
		return self.__IParameter.Tune


	@Tune.setter
	def Tune(self, value: bool):
		"""Returns/sets a value which specifies if the object is tuned."""
		self.__IParameter.Tune = value


	@property
	def UnitString(self) -> str:
		"""Returns a value which specifies the unit string associated with the parameter."""
		return self.__IParameter.UnitString


	@property
	def UnitType(self):
		"""Returns a value which specifies the unit type of a Parameter object."""
		return self.__IParameter.UnitType


	@property
	def UpperConstraint(self) -> float:
		"""Returns/sets the upper constraint of the object."""
		return self.__IParameter.UpperConstraint


	@UpperConstraint.setter
	def UpperConstraint(self, value: float):
		"""Returns/sets the upper constraint of the object."""
		self.__IParameter.UpperConstraint = value


	@property
	def UseStatistics(self) -> bool:
		"""Returns/sets a value which specifies if the object uses statistics."""
		return self.__IParameter.UseStatistics


	@UseStatistics.setter
	def UseStatistics(self, value: bool):
		"""Returns/sets a value which specifies if the object uses statistics."""
		self.__IParameter.UseStatistics = value


	@property
	def ValueAsComplex(self) -> CComplexNumber:
		"""Returns a reference to a ComplexNumber object."""
		return CComplexNumber(self.__IParameter.ValueAsComplex)


	@property
	def ValueAsDouble(self) -> float:
		"""Returns/sets the value of a Parameter object."""
		return self.__IParameter.ValueAsDouble


	@ValueAsDouble.setter
	def ValueAsDouble(self, value: float):
		"""Returns/sets the value of a Parameter object."""
		self.__IParameter.ValueAsDouble = value


	@property
	def ValueAsDoubleVector(self):
		"""Returns/sets the value of a Parameter object as an array of doubles."""
		return self.__IParameter.ValueAsDoubleVector


	@ValueAsDoubleVector.setter
	def ValueAsDoubleVector(self, value):
		"""Returns/sets the value of a Parameter object as an array of doubles."""
		self.__IParameter.ValueAsDoubleVector = value


	@property
	def ValueAsEvaluatedString(self) -> str:
		"""Returns the evaluated value interpreted as a string value."""
		return self.__IParameter.ValueAsEvaluatedString


	@property
	def ValueAsString(self) -> str:
		"""Returns/sets the text value of a Parameter object."""
		return self.__IParameter.ValueAsString


	@ValueAsString.setter
	def ValueAsString(self, value: str):
		"""Returns/sets the text value of a Parameter object."""
		self.__IParameter.ValueAsString = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Parameters
class CParameters:
	"""A collection of MWOffice Parameter objects."""
	def __init__(self, parameters):
		self.__IParameters = parameters

	def _get_inner(self):
		return self.__IParameters



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IParameters.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IParameters.Exists(Index)


	def Item(self, Index) -> CParameter:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CParameter(self.__IParameters.Item(Index))


	def __get_Item(self, Index) -> CParameter:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CParameter(self.__IParameters.Item(Index))


	def __call__(self, index) -> CParameter:
		return self.__get_Item(index)


	def __iter__(self) -> CParameter:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IParameters.Count


	def __getitem__(self, index) -> Union[CParameter, List[CParameter]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ParameterDefinition
class CParameterDefinition:
	"""An MWOffice ParameterDefinition object."""
	def __init__(self, parameterdefinition):
		self.__IParameterDefinition = parameterdefinition

	def _get_inner(self):
		return self.__IParameterDefinition



	@property
	def DataType(self):
		"""Returns a value which specifies the data type of the ParameterDefinition."""
		return self.__IParameterDefinition.DataType


	@property
	def DefaultName(self):
		"""Returns the default value of the ParameterDefinition."""
		return self.__IParameterDefinition.DefaultName


	def DefinitionFlag(self, flag: mwParameterDefinitionFlagType) -> bool:
		"""Returns a value which indicates if a specific definition flag is set or cleared."""
		return self.__IParameterDefinition.DefinitionFlag(flag)


	@property
	def Description(self) -> str:
		"""Returns the description of the object."""
		return self.__IParameterDefinition.Description


	@property
	def EnumeratedTypes(self):
		"""Returns an array of enumerated types for the ParameterDefinition."""
		return self.__IParameterDefinition.EnumeratedTypes


	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__IParameterDefinition.Name


	@property
	def UnitType(self):
		"""Returns a value which specifies the data unit type of the ParameterDefinition."""
		return self.__IParameterDefinition.UnitType


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ParameterDefinitions
class CParameterDefinitions:
	"""A collection of MWOffice ParameterDefinition objects."""
	def __init__(self, parameterdefinitions):
		self.__IParameterDefinitions = parameterdefinitions

	def _get_inner(self):
		return self.__IParameterDefinitions



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IParameterDefinitions.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IParameterDefinitions.Exists(Index)


	def Item(self, Index) -> CParameterDefinition:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CParameterDefinition(self.__IParameterDefinitions.Item(Index))


	def __get_Item(self, Index) -> CParameterDefinition:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CParameterDefinition(self.__IParameterDefinitions.Item(Index))


	def __call__(self, index) -> CParameterDefinition:
		return self.__get_Item(index)


	def __iter__(self) -> CParameterDefinition:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IParameterDefinitions.Count


	def __getitem__(self, index) -> Union[CParameterDefinition, List[CParameterDefinition]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ParameterFrame
class CParameterFrame:
	"""An MWOffice ParameterFrame object."""
	def __init__(self, parameterframe):
		self.__IParameterFrame = parameterframe

	def _get_inner(self):
		return self.__IParameterFrame


	def UpdateSize(self) -> None:
		"""Recalculates the bounding box of the ParameterFrame object."""
		self.__IParameterFrame.UpdateSize()



	def DisplayMode(self, mode: mwDisplayModeType) -> bool:
		"""Returns/sets various ParameterFrame display mode settings."""
		return self.__IParameterFrame.DisplayMode(mode)


	def SetDisplayMode(self, mode: mwDisplayModeType, value: bool):
		"""Returns/sets various ParameterFrame display mode settings."""
		self.__IParameterFrame.DisplayMode = value


	@property
	def Height(self) -> int:
		"""Returns the height of a ParameterFrame object."""
		return self.__IParameterFrame.Height


	@property
	def Left(self) -> int:
		"""Return the left edge position of the ParameterFrame object."""
		return self.__IParameterFrame.Left


	@property
	def Selected(self) -> bool:
		"""Returns/sets if the ParameterFrame object is selected."""
		return self.__IParameterFrame.Selected


	@Selected.setter
	def Selected(self, value: bool):
		"""Returns/sets if the ParameterFrame object is selected."""
		self.__IParameterFrame.Selected = value


	@property
	def Top(self) -> int:
		"""Returns the top edge position of the ParameterFrame object."""
		return self.__IParameterFrame.Top


	@property
	def Width(self) -> int:
		"""Returns the width of a ParameterFrame object."""
		return self.__IParameterFrame.Width


	@property
	def x(self) -> int:
		"""Returns/sets the x position of a ParameterFrame object."""
		return self.__IParameterFrame.x


	@x.setter
	def x(self, value: int):
		"""Returns/sets the x position of a ParameterFrame object."""
		self.__IParameterFrame.x = value


	@property
	def y(self) -> int:
		"""Returns/sets the y position of a ParameterFrame object."""
		return self.__IParameterFrame.y


	@y.setter
	def y(self, value: int):
		"""Returns/sets the y position of a ParameterFrame object."""
		self.__IParameterFrame.y = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LayoutParameterFrame
class CLayoutParameterFrame:
	"""An MWOffice LayoutParameterFrame object."""
	def __init__(self, layoutparameterframe):
		self.__ILayoutParameterFrame = layoutparameterframe

	def _get_inner(self):
		return self.__ILayoutParameterFrame


	def UpdateSize(self) -> None:
		"""Recalculates the bounding box of the ParameterFrame object."""
		self.__ILayoutParameterFrame.UpdateSize()



	def DisplayMode(self, mode: mwDisplayModeType) -> bool:
		"""Returns/sets various ParameterFrame display mode settings."""
		return self.__ILayoutParameterFrame.DisplayMode(mode)


	def SetDisplayMode(self, mode: mwDisplayModeType, value: bool):
		"""Returns/sets various ParameterFrame display mode settings."""
		self.__ILayoutParameterFrame.DisplayMode = value


	@property
	def FontSize(self) -> float:
		"""Returns/sets size value affecting the font height for the ParameterFrame"""
		return self.__ILayoutParameterFrame.FontSize


	@FontSize.setter
	def FontSize(self, value: float):
		"""Returns/sets size value affecting the font height for the ParameterFrame"""
		self.__ILayoutParameterFrame.FontSize = value


	@property
	def Height(self) -> float:
		"""Returns the height of a LayoutParameterFrame object."""
		return self.__ILayoutParameterFrame.Height


	@property
	def Left(self) -> float:
		"""Return the left edge position of the LayoutParameterFrame object."""
		return self.__ILayoutParameterFrame.Left


	@property
	def Selected(self) -> bool:
		"""Returns/sets if the ParameterFrame object is selected."""
		return self.__ILayoutParameterFrame.Selected


	@Selected.setter
	def Selected(self, value: bool):
		"""Returns/sets if the ParameterFrame object is selected."""
		self.__ILayoutParameterFrame.Selected = value


	@property
	def Top(self) -> float:
		"""Returns the top edge position of the LayoutParameterFrame object."""
		return self.__ILayoutParameterFrame.Top


	@property
	def Width(self) -> float:
		"""Returns the width of a LayoutParameterFrame object."""
		return self.__ILayoutParameterFrame.Width


	@property
	def x(self) -> float:
		"""Returns/sets the x position of a LayoutParameterFrame object."""
		return self.__ILayoutParameterFrame.x


	@x.setter
	def x(self, value: float):
		"""Returns/sets the x position of a LayoutParameterFrame object."""
		self.__ILayoutParameterFrame.x = value


	@property
	def y(self) -> float:
		"""Returns/sets the y position of a LayoutParameterFrame object."""
		return self.__ILayoutParameterFrame.y


	@y.setter
	def y(self, value: float):
		"""Returns/sets the y position of a LayoutParameterFrame object."""
		self.__ILayoutParameterFrame.y = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ProcessLibrary
class CProcessLibrary:
	"""An MWOffice ProcessLibrary object."""
	def __init__(self, processlibrary):
		self.__IProcessLibrary = processlibrary

	def _get_inner(self):
		return self.__IProcessLibrary


	def ReloadXml(self, NewXmlFile: str = "") -> bool:
		"""Reloads the XML element tree."""
		return self.__IProcessLibrary.ReloadXml(NewXmlFile)



	@property
	def IniFilePath(self) -> str:
		"""Returns the file path to the initialization file for this ProcessLibrary object."""
		return self.__IProcessLibrary.IniFilePath


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IProcessLibrary.Name


	def OptionFlag(self, Index: int) -> bool:
		"""Returns/sets the value of an option flag."""
		return self.__IProcessLibrary.OptionFlag(Index)


	def SetOptionFlag(self, Index: int, value: bool):
		"""Returns/sets the value of an option flag."""
		self.__IProcessLibrary.OptionFlag = value


	@property
	def OptionFlags(self):
		"""Returns/sets the value of the option flags bit field."""
		return self.__IProcessLibrary.OptionFlags


	@OptionFlags.setter
	def OptionFlags(self, value):
		"""Returns/sets the value of the option flags bit field."""
		self.__IProcessLibrary.OptionFlags = value


	@property
	def Properties(self) -> CProperties:
		"""Returns a reference to a collection of Property objects."""
		return CProperties(self.__IProcessLibrary.Properties)


	@property
	def Version(self) -> str:
		"""Returns a string containing the version information for the MWOffice ProcessLibrary object."""
		return self.__IProcessLibrary.Version


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ProcessLibraries
class CProcessLibraries:
	"""A collection of MWOffice ProcessLibrary objects."""
	def __init__(self, processlibraries):
		self.__IProcessLibraries = processlibraries

	def _get_inner(self):
		return self.__IProcessLibraries


	def AddLibrary(self, Name: str, IniFilePath: str) -> bool:
		"""Adds a ProcessLibrary entry to the MOWOffice ProcessLibraries collection."""
		return self.__IProcessLibraries.AddLibrary(Name, IniFilePath)


	def RemoveLibrary(self, Index) -> bool:
		"""Removes a ProcessLibrary entry from the MWOffice ProcessLibraries collection."""
		return self.__IProcessLibraries.RemoveLibrary(Index)


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__IProcessLibraries.GetUniqueName(baseName)


	def RemoveLibrary2(self, Name: str, Version: str, NotifyDocs: bool) -> bool:
		"""Removes a ProcessLibrary entry from the MWOffice ProcessLibraries collection."""
		return self.__IProcessLibraries.RemoveLibrary2(Name, Version, NotifyDocs)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IProcessLibraries.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IProcessLibraries.Exists(Index)


	def Item(self, Index) -> CProcessLibrary:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CProcessLibrary(self.__IProcessLibraries.Item(Index))


	def __get_Item(self, Index) -> CProcessLibrary:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CProcessLibrary(self.__IProcessLibraries.Item(Index))


	def __call__(self, index) -> CProcessLibrary:
		return self.__get_Item(index)


	def __iter__(self) -> CProcessLibrary:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IProcessLibraries.Count


	def __getitem__(self, index) -> Union[CProcessLibrary, List[CProcessLibrary]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ProcessLibraryInfo
class CProcessLibraryInfo:
	"""An MWOffice ProcessLibraryInfo object."""
	def __init__(self, processlibraryinfo):
		self.__IProcessLibraryInfo = processlibraryinfo

	def _get_inner(self):
		return self.__IProcessLibraryInfo



	@property
	def Description(self) -> str:
		"""Returns a description of the MWOffice ProcessLibraryInfo object."""
		return self.__IProcessLibraryInfo.Description


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IProcessLibraryInfo.Name


	@property
	def Version(self) -> str:
		"""Returns the version of the MWOffice ProcessLibraryInfo object."""
		return self.__IProcessLibraryInfo.Version


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ProcessLibraryInfos
class CProcessLibraryInfos:
	"""A collection of MWOffice ProcessLibraryInfo objects."""
	def __init__(self, processlibraryinfos):
		self.__IProcessLibraryInfos = processlibraryinfos

	def _get_inner(self):
		return self.__IProcessLibraryInfos



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IProcessLibraryInfos.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IProcessLibraryInfos.Exists(Index)


	def Item(self, Index) -> CProcessLibraryInfo:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CProcessLibraryInfo(self.__IProcessLibraryInfos.Item(Index))


	def __get_Item(self, Index) -> CProcessLibraryInfo:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CProcessLibraryInfo(self.__IProcessLibraryInfos.Item(Index))


	def __call__(self, index) -> CProcessLibraryInfo:
		return self.__get_Item(index)


	def __iter__(self) -> CProcessLibraryInfo:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IProcessLibraryInfos.Count


	def __getitem__(self, index) -> Union[CProcessLibraryInfo, List[CProcessLibraryInfo]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Property
class CProperty:
	"""An MWOffice Property object."""
	def __init__(self, property):
		self.__IProperty = property

	def _get_inner(self):
		return self.__IProperty


	def IsFlagSet(self, flag: int) -> bool:
		"""Returns a value that indicates if the given flag(s) is set on the Property object."""
		return self.__IProperty.IsFlagSet(flag)


	def SetFlag(self, flag: int, state: bool) -> None:
		"""Sets the given flag(s) to the provided state on the Property object."""
		self.__IProperty.SetFlag(flag, state)



	@property
	def Attributes(self) -> int:
		"""Returns/sets a value which specifies the attributes of a Property object."""
		return self.__IProperty.Attributes


	@Attributes.setter
	def Attributes(self, value: int):
		"""Returns/sets a value which specifies the attributes of a Property object."""
		self.__IProperty.Attributes = value


	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__IProperty.Name


	@property
	def Type(self):
		"""Returns a value which specifies the data unit type of the object."""
		return self.__IProperty.Type


	@property
	def Value(self):
		"""Returns the value of a Property object."""
		return self.__IProperty.Value


	@Value.setter
	def Value(self, value):
		"""Returns the value of a Property object."""
		self.__IProperty.Value = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Properties
class CProperties:
	"""A collection of MWOffice Property objects."""
	def __init__(self, properties):
		self.__IProperties = properties

	def _get_inner(self):
		return self.__IProperties


	def Add(self, Name: str, Value, Attributes: int = 0) -> CProperty:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CProperty(self.__IProperties.Add(Name, Value, Attributes))


	def Remove(self, Name: str) -> None:
		"""Removes a specific member from a collection."""
		self.__IProperties.Remove(Name)


	def Exists(self, Name: str) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IProperties.Exists(Name)


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__IProperties.GetUniqueName(baseName)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IProperties.RemoveAll()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IProperties.Count


	def Item(self, Index) -> CProperty:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CProperty(self.__IProperties.Item(Index))


	def __get_Item(self, Index) -> CProperty:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CProperty(self.__IProperties.Item(Index))


	def __call__(self, index) -> CProperty:
		return self.__get_Item(index)


	def __iter__(self) -> CProperty:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IProperties.Count


	def __getitem__(self, index) -> Union[CProperty, List[CProperty]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# TestPoint
class CTestPoint:
	"""A MWOffice TestPoint object."""
	def __init__(self, testpoint):
		self.__ITestPoint = testpoint

	def _get_inner(self):
		return self.__ITestPoint


	def IsFlagSet(self, flag: mwTestPointFlags) -> bool:
		"""Returns a value indicating if a particular flag value is set on the TestPoint object."""
		return self.__ITestPoint.IsFlagSet(flag)



	@property
	def Description(self) -> str:
		"""Returns the description associated with the TestPoint object."""
		return self.__ITestPoint.Description


	@property
	def Flags(self) -> int:
		"""Returns the flags associated with the TestPoint object."""
		return self.__ITestPoint.Flags


	@property
	def Label(self) -> str:
		"""Returns the label associated with the TestPoint object."""
		return self.__ITestPoint.Label


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__ITestPoint.Name


	@property
	def RefName(self) -> str:
		"""Returns the reference name associated with the TestPoint object."""
		return self.__ITestPoint.RefName


	@property
	def Type(self):
		"""Returns the type of the test point object."""
		return self.__ITestPoint.Type


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# TestPoints
class CTestPoints:
	"""A collection of MWOffice TestPoint objects."""
	def __init__(self, testpoints):
		self.__ITestPoints = testpoints

	def _get_inner(self):
		return self.__ITestPoints



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ITestPoints.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ITestPoints.Exists(Index)


	def Item(self, Index) -> CTestPoint:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CTestPoint(self.__ITestPoints.Item(Index))


	def __get_Item(self, Index) -> CTestPoint:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CTestPoint(self.__ITestPoints.Item(Index))


	def __call__(self, index) -> CTestPoint:
		return self.__get_Item(index)


	def __iter__(self) -> CTestPoint:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ITestPoints.Count


	def __getitem__(self, index) -> Union[CTestPoint, List[CTestPoint]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Schematic
class CSchematic:
	"""An MWOffice Schematic object."""
	def __init__(self, schematic):
		self.__ISchematic = schematic

	def _get_inner(self):
		return self.__ISchematic


	def CopyToClipboard(self) -> None:
		"""Copies the object to the system clipboard."""
		self.__ISchematic.CopyToClipboard()


	def SetupConnectivity(self) -> None:
		"""method SetupConnectivity"""
		self.__ISchematic.SetupConnectivity()


	def Activate(self) -> None:
		"""Activates the objects."""
		self.__ISchematic.Activate()


	def NewWindow(self, WindowType: mwWindowType = 9) -> CWindow:
		"""Displays the object in new window."""
		return CWindow(self.__ISchematic.NewWindow(WindowType))


	def Export(self, FilePath: str, format: mwSchematicExportFormat = 0) -> None:
		"""Exports a design document file from MWOffice."""
		self.__ISchematic.Export(FilePath, format)


	def ExportNetlist(self, FilePath: str, format: mwSchematicNetlistExportFormat = 0) -> None:
		"""Exports a netlist document file from MWOffice."""
		self.__ISchematic.ExportNetlist(FilePath, format)


	def PrintOut(self) -> None:
		"""Sends the object to the current printer."""
		self.__ISchematic.PrintOut()


	def LockDiagram(self, NewLevel: mwDiagramLockLevel, Password: str = "") -> bool:
		"""Changes the lock level of the schematic diagram to the given lock level"""
		return self.__ISchematic.LockDiagram(NewLevel, Password)


	def InvokeCommand(self, CommandName: str, Arguments, pRet) -> None:
		"""Invoke a menu command by specifying the name for the command. Arguments need to be supplied for any input."""
		self.__ISchematic.InvokeCommand(CommandName, Arguments, pRet)


	def UpdateConnectivity(self) -> None:
		"""Sends notifications that the connectivity of this schematic document has changed and referring documents need to update."""
		self.__ISchematic.UpdateConnectivity()


	def AddExtraction(self) -> bool:
		"""Add an extraction document associated with this schematic object. Values specified in extract block in the schematic"""
		return self.__ISchematic.AddExtraction()


	def Paste(self, x: int, y: int, CCWRotation: int = 0, Flipped: bool = 0) -> bool:
		"""Pastes the system clipboard to the object."""
		return self.__ISchematic.Paste(x, y, CCWRotation, Flipped)


	def CopyViewToClipboard(self) -> bool:
		"""Copies the object to the system clipboard."""
		return self.__ISchematic.CopyViewToClipboard()


	def PrintView(self) -> bool:
		"""Sends the object to the current printer."""
		return self.__ISchematic.PrintView()


	def StartCommand(self, CommandName: str, pRet) -> None:
		"""Start a menu command by specifying the name for the command, user will need to complete interactive input."""
		self.__ISchematic.StartCommand(CommandName, pRet)


	def IsSimulationStateFlagSet(self, flag: mwSimStateFlags) -> bool:
		"""Returns a value that indicates if a certain simulation state flag is set."""
		return self.__ISchematic.IsSimulationStateFlagSet(flag)


	def EndActiveCommand(self) -> bool:
		"""Ends the currently active command for this Schematic object."""
		return self.__ISchematic.EndActiveCommand()


	def Embed(self) -> None:
		"""Convert an externally linked schematic into an embedded document."""
		self.__ISchematic.Embed()


	def LinkToFile(self, FilePath: str) -> None:
		"""Convert an embedded schematic into an externally linked document."""
		self.__ISchematic.LinkToFile(FilePath)


	def Reload(self) -> None:
		"""Reload an externally linked schematic."""
		self.__ISchematic.Reload()


	def Save(self) -> None:
		"""Update the externally linked schematic file."""
		self.__ISchematic.Save()



	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__ISchematic.Boundary)


	@property
	def CanPaste(self) -> bool:
		"""Returns a value that determines the clipboard contents can be pasted to the object."""
		return self.__ISchematic.CanPaste


	@property
	def Changed(self) -> bool:
		"""Returns/Sets a value that indicates if the object has changed and needs to be saved or resimulated."""
		return self.__ISchematic.Changed


	@Changed.setter
	def Changed(self, value: bool):
		"""Returns/Sets a value that indicates if the object has changed and needs to be saved or resimulated."""
		self.__ISchematic.Changed = value


	@property
	def CommandActive(self) -> bool:
		"""Returns a value indicating if there is command currently active for this Schematic object."""
		return self.__ISchematic.CommandActive


	@property
	def DrawingShapes(self) -> CDrawingShapes:
		"""Returns a reference to a collection of DrawingShape objects."""
		return CDrawingShapes(self.__ISchematic.DrawingShapes)


	@property
	def ElectricalNets(self) -> CElectricalNets:
		"""Returns a reference to a MWOffice ElectNet collection consisting of only the schematic electrical network elements"""
		return CElectricalNets(self.__ISchematic.ElectricalNets)


	@property
	def Elements(self) -> CElements:
		"""Returns a reference to a collection of Element objects."""
		return CElements(self.__ISchematic.Elements)


	@property
	def Embedded(self) -> bool:
		"""Returns if the schematic document is embedded in the project or linked externally"""
		return self.__ISchematic.Embedded


	@property
	def EmbeddedDesigns(self) -> CEmbeddedDesigns:
		"""Returns a reference to a collection of EmbeddedDesign objects."""
		return CEmbeddedDesigns(self.__ISchematic.EmbeddedDesigns)


	@property
	def Equations(self) -> CEquations:
		"""Returns a reference to a collection of Equation objects."""
		return CEquations(self.__ISchematic.Equations)


	@property
	def FilePath(self) -> str:
		"""Returns the Schematic document file path."""
		return self.__ISchematic.FilePath


	@property
	def Frequencies(self) -> CFrequencies:
		"""Returns a reference to a collection of Frequency objects."""
		return CFrequencies(self.__ISchematic.Frequencies)


	@property
	def GridVisible(self) -> bool:
		"""Returns/sets a value that specifies if the snap grid is visible for the Schematic."""
		return self.__ISchematic.GridVisible


	@GridVisible.setter
	def GridVisible(self, value: bool):
		"""Returns/sets a value that specifies if the snap grid is visible for the Schematic."""
		self.__ISchematic.GridVisible = value


	@property
	def Layout(self) -> CLayout:
		"""Returns a reference to a Layout object."""
		return CLayout(self.__ISchematic.Layout)


	@property
	def LockLevel(self):
		"""Returns a value that specifies the lock level of the schematic diagram"""
		return self.__ISchematic.LockLevel


	@property
	def LockUpdates(self) -> bool:
		"""property LockUpdates"""
		return self.__ISchematic.LockUpdates


	@LockUpdates.setter
	def LockUpdates(self, value: bool):
		"""property LockUpdates"""
		self.__ISchematic.LockUpdates = value


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__ISchematic.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__ISchematic.Name = value


	@property
	def NamedConnectors(self) -> CNamedConnectors:
		"""Returns a reference to a MWOffice NamedConnector collection consisting of only the schematic named connector elements"""
		return CNamedConnectors(self.__ISchematic.NamedConnectors)


	@property
	def OptionSets(self) -> COptionSets:
		"""Returns a reference to a collection of OptionSet objects."""
		return COptionSets(self.__ISchematic.OptionSets)


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__ISchematic.Options)


	@property
	def Orthogonal(self) -> bool:
		"""Returns/sets a value that specifies if drawing should be only orthogonal in the schematic."""
		return self.__ISchematic.Orthogonal


	@Orthogonal.setter
	def Orthogonal(self, value: bool):
		"""Returns/sets a value that specifies if drawing should be only orthogonal in the schematic."""
		self.__ISchematic.Orthogonal = value


	@property
	def Ports(self) -> CPorts:
		"""Returns a reference to a MWOffice Port collection consisting of only the schematic port elements"""
		return CPorts(self.__ISchematic.Ports)


	@property
	def ProcessDefinition(self) -> str:
		"""Returns/sets the name of the layout process definition associated with this schematic."""
		return self.__ISchematic.ProcessDefinition


	@ProcessDefinition.setter
	def ProcessDefinition(self, value: str):
		"""Returns/sets the name of the layout process definition associated with this schematic."""
		self.__ISchematic.ProcessDefinition = value


	@property
	def Properties(self) -> CProperties:
		"""Returns a reference to a collection of Property objects."""
		return CProperties(self.__ISchematic.Properties)


	@property
	def ReadOnly(self) -> bool:
		"""Returns a value indicating if the Schematic document is currently read-only."""
		return self.__ISchematic.ReadOnly


	@property
	def SelectedDrawingShapes(self) -> CSelectedDrawingShapes:
		"""Returns a reference to a collection of MWOffice SelectedDrawingShape objects."""
		return CSelectedDrawingShapes(self.__ISchematic.SelectedDrawingShapes)


	@property
	def SelectedElements(self) -> CSelectedElements:
		"""Returns a reference to a collection of MWOffice SelectedElement objects."""
		return CSelectedElements(self.__ISchematic.SelectedElements)


	@property
	def SelectedWires(self) -> CSelectedWires:
		"""Returns a reference to a collection of MWOffice SelectedWire objects."""
		return CSelectedWires(self.__ISchematic.SelectedWires)


	@property
	def SimulationDirty(self) -> bool:
		"""Returns if the current simulation state is dirty for the Schematic object."""
		return self.__ISchematic.SimulationDirty


	@property
	def SimulationState(self) -> int:
		"""Returns the current simulation state for the Schematic object."""
		return self.__ISchematic.SimulationState


	@property
	def SnapToGrid(self) -> bool:
		"""Returns/sets a value that specifies if grid snap is enabled for the Schematic"""
		return self.__ISchematic.SnapToGrid


	@SnapToGrid.setter
	def SnapToGrid(self, value: bool):
		"""Returns/sets a value that specifies if grid snap is enabled for the Schematic"""
		self.__ISchematic.SnapToGrid = value


	@property
	def Subcircuits(self) -> CSubcircuits:
		"""Returns a reference to a MWOffice Subcircuit collection consisting of only the schematic subcircuit elements"""
		return CSubcircuits(self.__ISchematic.Subcircuits)


	@property
	def SweepVariables(self) -> CSweepVariables:
		"""Returns a reference to a MWOffice SweepVariables collection."""
		return CSweepVariables(self.__ISchematic.SweepVariables)


	def TestPoints(self, SimulationVendorName: str) -> CTestPoints:
		"""Returns a reference to a collection of TestPoint objects."""
		return CTestPoints(self.__ISchematic.TestPoints(SimulationVendorName))


	@property
	def UseProjectFrequencies(self) -> bool:
		"""Returns/sets a value which specifies if the global project frequencies should be used for analysis."""
		return self.__ISchematic.UseProjectFrequencies


	@UseProjectFrequencies.setter
	def UseProjectFrequencies(self, value: bool):
		"""Returns/sets a value which specifies if the global project frequencies should be used for analysis."""
		self.__ISchematic.UseProjectFrequencies = value


	@property
	def UseProjectOptions(self) -> bool:
		"""Returns/sets a value which specifies if the global project options should be used."""
		return self.__ISchematic.UseProjectOptions


	@UseProjectOptions.setter
	def UseProjectOptions(self, value: bool):
		"""Returns/sets a value which specifies if the global project options should be used."""
		self.__ISchematic.UseProjectOptions = value


	@property
	def Views(self) -> CViews:
		"""Returns a reference to a MWOffive Views collection."""
		return CViews(self.__ISchematic.Views)


	@property
	def Windows(self) -> CWindows:
		"""Returns a reference to a collection of Window objects."""
		return CWindows(self.__ISchematic.Windows)


	@property
	def Wires(self) -> CWires:
		"""Returns a reference to a collection of WireSegment objects."""
		return CWires(self.__ISchematic.Wires)


	@property
	def XGridSpacing(self) -> int:
		"""Returns/sets a value that specifies the grid spacing along the X coordinate direction."""
		return self.__ISchematic.XGridSpacing


	@property
	def YGridSpacing(self) -> int:
		"""Returns/sets a value that specifies the grid spacing along the Y coordinate direction."""
		return self.__ISchematic.YGridSpacing


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Schematics
class CSchematics:
	"""A collection of MWOffice Schematic objects."""
	def __init__(self, schematics):
		self.__ISchematics = schematics

	def _get_inner(self):
		return self.__ISchematics


	def Add(self, Name: str) -> CSchematic:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CSchematic(self.__ISchematics.Add(Name))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ISchematics.Remove(Index)


	def Import(self, Name: str, Filename: str) -> CSchematic:
		"""Adds an object to the collection from a file and returns a reference to the created object."""
		return CSchematic(self.__ISchematics.Import(Name, Filename))


	def LinkTo(self, Name: str, Filename: str) -> CSchematic:
		"""Adds a Schematic object link to the collection from a file and returns a reference to the created object."""
		return CSchematic(self.__ISchematics.LinkTo(Name, Filename))


	def Copy(self, Index, NewName: str = "") -> CSchematic:
		"""Copies an object from another object collection into this object collection."""
		return CSchematic(self.__ISchematics.Copy(Index, NewName))


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__ISchematics.GetUniqueName(baseName)



	@property
	def ActiveSchematic(self) -> CSchematic:
		"""Returns the active schematic of a Project object."""
		return CSchematic(self.__ISchematics.ActiveSchematic)


	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ISchematics.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ISchematics.Exists(Index)


	def Item(self, Index) -> CSchematic:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSchematic(self.__ISchematics.Item(Index))


	def __get_Item(self, Index) -> CSchematic:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSchematic(self.__ISchematics.Item(Index))


	def __call__(self, index) -> CSchematic:
		return self.__get_Item(index)


	def __iter__(self) -> CSchematic:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ISchematics.Count


	def __getitem__(self, index) -> Union[CSchematic, List[CSchematic]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__ISchematics.Options)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Subcircuits
class CSubcircuits:
	"""A collection of MWOffice Element objects consisting of only the schematic subcircuits"""
	def __init__(self, subcircuits):
		self.__ISubcircuits = subcircuits

	def _get_inner(self):
		return self.__ISubcircuits


	def Add(self, SubcircuitName: str, x: int, y: int, RotationAngle: int = 0, Flipped: bool = 0, Symbol: str = "", GndType: mwSubcktGroundType = 0) -> CElement:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CElement(self.__ISubcircuits.Add(SubcircuitName, x, y, RotationAngle, Flipped, Symbol, GndType))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ISubcircuits.Remove(Index)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ISubcircuits.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ISubcircuits.Exists(Index)


	def Item(self, Index) -> CElement:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CElement(self.__ISubcircuits.Item(Index))


	def __get_Item(self, Index) -> CElement:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CElement(self.__ISubcircuits.Item(Index))


	def __call__(self, index) -> CElement:
		return self.__get_Item(index)


	def __iter__(self) -> CElement:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ISubcircuits.Count


	def __getitem__(self, index) -> Union[CElement, List[CElement]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Ports
class CPorts:
	"""A collection of MWOffice Element objects consisting of only the schematic or system diagram ports"""
	def __init__(self, ports):
		self.__IPorts = ports

	def _get_inner(self):
		return self.__IPorts



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IPorts.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IPorts.Exists(Index)


	def Item(self, Index) -> CElement:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CElement(self.__IPorts.Item(Index))


	def __get_Item(self, Index) -> CElement:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CElement(self.__IPorts.Item(Index))


	def __call__(self, index) -> CElement:
		return self.__get_Item(index)


	def __iter__(self) -> CElement:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IPorts.Count


	def __getitem__(self, index) -> Union[CElement, List[CElement]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ElectricalNets
class CElectricalNets:
	"""A collection of MWOffice Element objects consisting of only the schematic electrical nets"""
	def __init__(self, electricalnets):
		self.__IElectricalNets = electricalnets

	def _get_inner(self):
		return self.__IElectricalNets



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IElectricalNets.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IElectricalNets.Exists(Index)


	def Item(self, Index) -> CElement:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CElement(self.__IElectricalNets.Item(Index))


	def __get_Item(self, Index) -> CElement:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CElement(self.__IElectricalNets.Item(Index))


	def __call__(self, index) -> CElement:
		return self.__get_Item(index)


	def __iter__(self) -> CElement:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IElectricalNets.Count


	def __getitem__(self, index) -> Union[CElement, List[CElement]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# NamedConnectors
class CNamedConnectors:
	"""A collection of MWOffice Element objects consisting of only the schematic named connectors"""
	def __init__(self, namedconnectors):
		self.__INamedConnectors = namedconnectors

	def _get_inner(self):
		return self.__INamedConnectors


	def Add(self, ConnectorName: str, x: int, y: int, RotationAngle: int = 0, Flipped: bool = 0, Symbol: str = "") -> CElement:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CElement(self.__INamedConnectors.Add(ConnectorName, x, y, RotationAngle, Flipped, Symbol))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__INamedConnectors.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__INamedConnectors.RemoveAll()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__INamedConnectors.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__INamedConnectors.Exists(Index)


	def Item(self, Index) -> CElement:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CElement(self.__INamedConnectors.Item(Index))


	def __get_Item(self, Index) -> CElement:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CElement(self.__INamedConnectors.Item(Index))


	def __call__(self, index) -> CElement:
		return self.__get_Item(index)


	def __iter__(self) -> CElement:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__INamedConnectors.Count


	def __getitem__(self, index) -> Union[CElement, List[CElement]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SymbolFile
class CSymbolFile:
	"""An MWOffice SymbolFile object."""
	def __init__(self, symbolfile):
		self.__ISymbolFile = symbolfile

	def _get_inner(self):
		return self.__ISymbolFile


	def Reload(self) -> None:
		"""Reloads the externally linked circuit symbols file."""
		self.__ISymbolFile.Reload()


	def Save(self) -> None:
		"""Updates the externally linked circuit symbols file."""
		self.__ISymbolFile.Save()


	def AddSymbol(self, Name: str) -> None:
		"""Associates a symbol with an externally linked circuit symbols file."""
		self.__ISymbolFile.AddSymbol(Name)



	@property
	def FilePath(self) -> str:
		"""Returns the circuit symbol linked file path."""
		return self.__ISymbolFile.FilePath


	@property
	def Name(self) -> str:
		"""Return name of symbol file."""
		return self.__ISymbolFile.Name


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SymbolFiles
class CSymbolFiles:
	"""A collection of MWOffice SymbolFile objects."""
	def __init__(self, symbolfiles):
		self.__ISymbolFiles = symbolfiles

	def _get_inner(self):
		return self.__ISymbolFiles


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ISymbolFiles.Remove(Index)


	def Embed(self, Index) -> bool:
		"""Embeds the circuit symbols defined in the symbol file into the project."""
		return self.__ISymbolFiles.Embed(Index)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ISymbolFiles.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ISymbolFiles.Exists(Index)


	def Item(self, Index) -> CSymbolFile:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSymbolFile(self.__ISymbolFiles.Item(Index))


	def __get_Item(self, Index) -> CSymbolFile:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSymbolFile(self.__ISymbolFiles.Item(Index))


	def __call__(self, index) -> CSymbolFile:
		return self.__get_Item(index)


	def __iter__(self) -> CSymbolFile:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ISymbolFiles.Count


	def __getitem__(self, index) -> Union[CSymbolFile, List[CSymbolFile]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SymbolNode
class CSymbolNode:
	"""An MWOffice SymbolNode object."""
	def __init__(self, symbolnode):
		self.__ISymbolNode = symbolnode

	def _get_inner(self):
		return self.__ISymbolNode



	@property
	def LabelOffset(self) -> CSize:
		"""Returns the label offset relative to the SymbolNode position."""
		return CSize(self.__ISymbolNode.LabelOffset)


	@property
	def LabelText(self) -> str:
		"""Returns/sets  the label text associated with the SymbolNode."""
		return self.__ISymbolNode.LabelText


	@LabelText.setter
	def LabelText(self, value: str):
		"""Returns/sets  the label text associated with the SymbolNode."""
		self.__ISymbolNode.LabelText = value


	@property
	def LabelVisible(self) -> bool:
		"""Returns a value that specifies if the symbol node label is visible"""
		return self.__ISymbolNode.LabelVisible


	@LabelVisible.setter
	def LabelVisible(self, value: bool):
		"""Returns a value that specifies if the symbol node label is visible"""
		self.__ISymbolNode.LabelVisible = value


	@property
	def x(self) -> int:
		"""Returns the X value of a SymbolNode object position."""
		return self.__ISymbolNode.x


	@x.setter
	def x(self, value: int):
		"""Returns the X value of a SymbolNode object position."""
		self.__ISymbolNode.x = value


	@property
	def y(self) -> int:
		"""Returns the Y value of a SymbolNode object position."""
		return self.__ISymbolNode.y


	@y.setter
	def y(self, value: int):
		"""Returns the Y value of a SymbolNode object position."""
		self.__ISymbolNode.y = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SymbolNodes
class CSymbolNodes:
	"""A collection of MWOffice SymbolNode objects."""
	def __init__(self, symbolnodes):
		self.__ISymbolNodes = symbolnodes

	def _get_inner(self):
		return self.__ISymbolNodes



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ISymbolNodes.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ISymbolNodes.Exists(Index)


	def Item(self, Index) -> CSymbolNode:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSymbolNode(self.__ISymbolNodes.Item(Index))


	def __get_Item(self, Index) -> CSymbolNode:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSymbolNode(self.__ISymbolNodes.Item(Index))


	def __call__(self, index) -> CSymbolNode:
		return self.__get_Item(index)


	def __iter__(self) -> CSymbolNode:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ISymbolNodes.Count


	def __getitem__(self, index) -> Union[CSymbolNode, List[CSymbolNode]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SymbolShape
class CSymbolShape:
	"""An MWOffice SymbolShape object."""
	def __init__(self, symbolshape):
		self.__ISymbolShape = symbolshape

	def _get_inner(self):
		return self.__ISymbolShape



	@property
	def Attributes(self) -> CAttributes:
		"""Returns a reference to a collection of Attribute objects."""
		return CAttributes(self.__ISymbolShape.Attributes)


	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__ISymbolShape.Boundary)


	@property
	def Points(self) -> CPoints:
		"""Returns a reference to a collection of Point objects."""
		return CPoints(self.__ISymbolShape.Points)


	@property
	def Type(self):
		"""Returns a value that specifies the type of the SymbolShape object."""
		return self.__ISymbolShape.Type


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SymbolShapes
class CSymbolShapes:
	"""A collection of MWOffice SymbolShape objects."""
	def __init__(self, symbolshapes):
		self.__ISymbolShapes = symbolshapes

	def _get_inner(self):
		return self.__ISymbolShapes



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ISymbolShapes.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ISymbolShapes.Exists(Index)


	def Item(self, Index) -> CSymbolShape:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSymbolShape(self.__ISymbolShapes.Item(Index))


	def __get_Item(self, Index) -> CSymbolShape:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSymbolShape(self.__ISymbolShapes.Item(Index))


	def __call__(self, index) -> CSymbolShape:
		return self.__get_Item(index)


	def __iter__(self) -> CSymbolShape:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ISymbolShapes.Count


	def __getitem__(self, index) -> Union[CSymbolShape, List[CSymbolShape]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SymbolRecord
class CSymbolRecord:
	"""An MWOffice SymbolRecord object."""
	def __init__(self, symbolrecord):
		self.__ISymbolRecord = symbolrecord

	def _get_inner(self):
		return self.__ISymbolRecord


	def AddArc(self, Left: int, Top: int, Right: int, Bottom: int, xStart: int, yStart: int, xEnd: int, yEnd: int) -> CSymbolShape:
		"""Adds a symbol arc shape to the SymbolRecord object."""
		return CSymbolShape(self.__ISymbolRecord.AddArc(Left, Top, Right, Bottom, xStart, yStart, xEnd, yEnd))


	def AddEllipse(self, Left: int, Top: int, Right: int, Bottom: int) -> CSymbolShape:
		"""Adds a symbol ellipse shape to the SymbolRecord object."""
		return CSymbolShape(self.__ISymbolRecord.AddEllipse(Left, Top, Right, Bottom))


	def AddNode(self, x: int, y: int, TextDx: int, TextDy: int, TextVisible: bool) -> CSymbolNode:
		"""Adds a symbol connection node to the SymbolRecord object."""
		return CSymbolNode(self.__ISymbolRecord.AddNode(x, y, TextDx, TextDy, TextVisible))


	def AddPolygon(self, XYPoints) -> CSymbolShape:
		"""Adds a symbol polygon shape to the SymbolRecord object."""
		return CSymbolShape(self.__ISymbolRecord.AddPolygon(XYPoints))


	def AddText(self, Left: int, Top: int, Right: int, Bottom: int, Text: str) -> CSymbolShape:
		"""Adds a text string shape to the SymbolRecord object."""
		return CSymbolShape(self.__ISymbolRecord.AddText(Left, Top, Right, Bottom, Text))


	def AddLine(self, x1: int, y1: int, x2: int, y2: int) -> CSymbolShape:
		"""Adds a line shape to the to the SymbolRecord object."""
		return CSymbolShape(self.__ISymbolRecord.AddLine(x1, y1, x2, y2))


	def AddPolyline(self, XYPoints) -> CSymbolShape:
		"""Adds a polyline shape to the SymbolRecord object."""
		return CSymbolShape(self.__ISymbolRecord.AddPolyline(XYPoints))


	def AddNode2(self, x: int, y: int, Text: str, TextDx: int, TextDy: int, TextVisible: bool) -> CSymbolNode:
		"""Adds a symbol connection node with label text to the SymbolRecord object."""
		return CSymbolNode(self.__ISymbolRecord.AddNode2(x, y, Text, TextDx, TextDy, TextVisible))


	def AddMetaText(self, Left: int, Top: int, Right: int, Bottom: int, Text: str) -> CSymbolShape:
		"""Adds an embedded text string shape to the SymbolRecord object."""
		return CSymbolShape(self.__ISymbolRecord.AddMetaText(Left, Top, Right, Bottom, Text))


	def AddText2(self, Left: int, Top: int, Height: int, CCWRotation: int, Text: str) -> CSymbolShape:
		"""Adds a text string shape to the SymbolRecord object."""
		return CSymbolShape(self.__ISymbolRecord.AddText2(Left, Top, Height, CCWRotation, Text))


	def AddFilledPolygon(self, XYPoints) -> CSymbolShape:
		"""Adds a symbol polygon shape to the SymbolRecord object."""
		return CSymbolShape(self.__ISymbolRecord.AddFilledPolygon(XYPoints))


	def AddFilledEllipse(self, Left: int, Top: int, Right: int, Bottom: int) -> CSymbolShape:
		"""Adds a symbol ellipse shape to the SymbolRecord object."""
		return CSymbolShape(self.__ISymbolRecord.AddFilledEllipse(Left, Top, Right, Bottom))



	@property
	def FirstNodePlacementOrigin(self) -> bool:
		"""Returns/Sets if the symbol should be created such that the first node is offset to the origin and all shapes are created relative to that for placement."""
		return self.__ISymbolRecord.FirstNodePlacementOrigin


	@FirstNodePlacementOrigin.setter
	def FirstNodePlacementOrigin(self, value: bool):
		"""Returns/Sets if the symbol should be created such that the first node is offset to the origin and all shapes are created relative to that for placement."""
		self.__ISymbolRecord.FirstNodePlacementOrigin = value


	@property
	def NodeLabelFontHeight(self) -> int:
		"""Returns/Sets the height of the node label font."""
		return self.__ISymbolRecord.NodeLabelFontHeight


	@NodeLabelFontHeight.setter
	def NodeLabelFontHeight(self, value: int):
		"""Returns/Sets the height of the node label font."""
		self.__ISymbolRecord.NodeLabelFontHeight = value


	@property
	def Nodes(self) -> CSymbolNodes:
		"""Returns a reference to a collection of SymbolNodes objects."""
		return CSymbolNodes(self.__ISymbolRecord.Nodes)


	@property
	def SelectMode(self):
		"""Returns/Sets a value indicating the selection mode for this Symbol object."""
		return self.__ISymbolRecord.SelectMode


	@SelectMode.setter
	def SelectMode(self, value: mwSymbolSelectMode):
		"""Returns/Sets a value indicating the selection mode for this Symbol object."""
		self.__ISymbolRecord.SelectMode = value


	@property
	def Shapes(self) -> CSymbolShapes:
		"""Returns a reference to a collection of SymbolShape objects."""
		return CSymbolShapes(self.__ISymbolRecord.Shapes)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Symbol
class CSymbol:
	"""An MWOffice Symbol object."""
	def __init__(self, symbol):
		self.__ISymbol = symbol

	def _get_inner(self):
		return self.__ISymbol


	def Delete(self) -> bool:
		"""Deletes the symbol from the project, must be an unreferenced project symbol to be deleted"""
		return self.__ISymbol.Delete()



	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__ISymbol.Boundary)


	@property
	def Embedded(self) -> bool:
		"""Returns whether the circuit symbol is embedded in the project or linked externally."""
		return self.__ISymbol.Embedded


	@property
	def FilePath(self) -> str:
		"""Returns the circuit symbol linked file path."""
		return self.__ISymbol.FilePath


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__ISymbol.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__ISymbol.Name = value


	@property
	def Nodes(self) -> CSymbolNodes:
		"""Returns a reference to a collection of SymbolNodes objects."""
		return CSymbolNodes(self.__ISymbol.Nodes)


	@property
	def ProjectSymbol(self) -> bool:
		"""Returns if the symbol is a project or system symbol"""
		return self.__ISymbol.ProjectSymbol


	@property
	def RecordCount(self) -> int:
		"""Returns the number of records of a Symbol object."""
		return self.__ISymbol.RecordCount


	@property
	def RecordData(self):
		"""Returns/sets the record data of a Symbol object."""
		return self.__ISymbol.RecordData


	@RecordData.setter
	def RecordData(self, value):
		"""Returns/sets the record data of a Symbol object."""
		self.__ISymbol.RecordData = value


	@property
	def Referenced(self) -> bool:
		"""Returns if a symbol is referenced by a schematic element."""
		return self.__ISymbol.Referenced


	@property
	def SelectMode(self):
		"""Returns/Sets a value indicating the selection mode for this Symbol object."""
		return self.__ISymbol.SelectMode


	@SelectMode.setter
	def SelectMode(self, value: mwSymbolSelectMode):
		"""Returns/Sets a value indicating the selection mode for this Symbol object."""
		self.__ISymbol.SelectMode = value


	@property
	def Shapes(self) -> CSymbolShapes:
		"""Returns a reference to a collection of SymbolShape objects."""
		return CSymbolShapes(self.__ISymbol.Shapes)


	@property
	def SymbolType(self):
		"""Returns the type of the symbol like project or system type."""
		return self.__ISymbol.SymbolType


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Symbols
class CSymbols:
	"""A collection of MWOffice Symbol objects."""
	def __init__(self, symbols):
		self.__ISymbols = symbols

	def _get_inner(self):
		return self.__ISymbols


	def SaveToFile(self, Filename: str) -> None:
		"""Saves the project symbols to a symbol file."""
		self.__ISymbols.SaveToFile(Filename)


	def CreateSymbolRecord(self) -> CSymbolRecord:
		"""Returns a reference to a SymbolRecord object."""
		return CSymbolRecord(self.__ISymbols.CreateSymbolRecord())


	def CreateSymbol(self, Name: str, SymbolRecord: CSymbolRecord) -> CSymbol:
		"""Returns a reference to a Symbol object."""
		return CSymbol(self.__ISymbols.CreateSymbol(Name, SymbolRecord._get_inner()))


	def GetDefaultSymbol(self, NumberNodes: int) -> CSymbol:
		"""Returns a reference to a Symbol object."""
		return CSymbol(self.__ISymbols.GetDefaultSymbol(NumberNodes))


	def Import(self, SymbolFilePath: str) -> bool:
		"""Adds a Symbol object to the collection from a file and returns a reference to the created object."""
		return self.__ISymbols.Import(SymbolFilePath)


	def Export(self, SymbolFilePath: str) -> bool:
		"""Exports a design document file from MWOffice."""
		return self.__ISymbols.Export(SymbolFilePath)


	def ImportSystemFile(self, SymbolFilePath: str) -> bool:
		"""Imports a symbol file into the system symbols collection. These symbols are not saved with the project."""
		return self.__ISymbols.ImportSystemFile(SymbolFilePath)


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ISymbols.Remove(Index)


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__ISymbols.GetUniqueName(baseName)


	def LinkTo(self, SymbolFilePath: str) -> bool:
		"""Adds a Circuit Symbols link to the collection from a file"""
		return self.__ISymbols.LinkTo(SymbolFilePath)


	def Copy(self, Index, SymbolName: str) -> CSymbol:
		"""Copies the object to the system clipboard."""
		return CSymbol(self.__ISymbols.Copy(Index, SymbolName))


	def Reload(self, SymbolFilePath: str) -> bool:
		"""Reloads the object from its original source."""
		return self.__ISymbols.Reload(SymbolFilePath)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ISymbols.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ISymbols.Exists(Index)


	def Item(self, Index) -> CSymbol:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSymbol(self.__ISymbols.Item(Index))


	def __get_Item(self, Index) -> CSymbol:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSymbol(self.__ISymbols.Item(Index))


	def __call__(self, index) -> CSymbol:
		return self.__get_Item(index)


	def __iter__(self) -> CSymbol:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ISymbols.Count


	def __getitem__(self, index) -> Union[CSymbol, List[CSymbol]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DefaultValue
class CDefaultValue:
	"""A MWOffice DefaultValue object."""
	def __init__(self, defaultvalue):
		self.__IDefaultValue = defaultvalue

	def _get_inner(self):
		return self.__IDefaultValue



	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IDefaultValue.Name


	@property
	def ParamType(self):
		"""Returns the parameter type of the DefaultValue object."""
		return self.__IDefaultValue.ParamType


	@property
	def Unit(self):
		"""Returns the unit type of the DefaultValue object."""
		return self.__IDefaultValue.Unit


	@property
	def Value(self) -> float:
		"""Returns the numeric value for the DefaultValue object."""
		return self.__IDefaultValue.Value


	@Value.setter
	def Value(self, value: float):
		"""Returns the numeric value for the DefaultValue object."""
		self.__IDefaultValue.Value = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DefaultValues
class CDefaultValues:
	"""A collection of MWOffice DefaultValue objects."""
	def __init__(self, defaultvalues):
		self.__IDefaultValues = defaultvalues

	def _get_inner(self):
		return self.__IDefaultValues



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IDefaultValues.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IDefaultValues.Exists(Index)


	def Item(self, Index) -> CDefaultValue:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDefaultValue(self.__IDefaultValues.Item(Index))


	def __get_Item(self, Index) -> CDefaultValue:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDefaultValue(self.__IDefaultValues.Item(Index))


	def __call__(self, index) -> CDefaultValue:
		return self.__get_Item(index)


	def __iter__(self) -> CDefaultValue:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IDefaultValues.Count


	def __getitem__(self, index) -> Union[CDefaultValue, List[CDefaultValue]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IDefaultValues.Name


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Unit
class CUnit:
	"""An MWOffice Unit object."""
	def __init__(self, unit):
		self.__IUnit = unit

	def _get_inner(self):
		return self.__IUnit



	@property
	def BaseUnitString(self) -> str:
		"""Returns the units string for the base of this unit type."""
		return self.__IUnit.BaseUnitString


	@property
	def Description(self) -> str:
		"""Returns the full description for a unit type."""
		return self.__IUnit.Description


	@property
	def MultType(self):
		"""Returns/sets a value which specifies the multiplier type of a Unit object."""
		return self.__IUnit.MultType


	@MultType.setter
	def MultType(self, value: mwUnitMultType):
		"""Returns/sets a value which specifies the multiplier type of a Unit object."""
		self.__IUnit.MultType = value


	@property
	def MultValue(self) -> float:
		"""Returns the multiplier of a Unit object."""
		return self.__IUnit.MultValue


	@property
	def Type(self):
		"""Returns a value which specifies the unit type of a Unit object."""
		return self.__IUnit.Type


	@property
	def UnitString(self) -> str:
		"""Returns the units string identifier."""
		return self.__IUnit.UnitString


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Units
class CUnits:
	"""A collection of MWOffice Unit objects."""
	def __init__(self, units):
		self.__IUnits = units

	def _get_inner(self):
		return self.__IUnits


	def SetAllToBaseUnits(self) -> bool:
		"""Sets all the unit values in the collection to base units."""
		return self.__IUnits.SetAllToBaseUnits()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IUnits.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IUnits.Exists(Index)


	def Item(self, Index: mwUnitType) -> CUnit:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CUnit(self.__IUnits.Item(Index))


	def __get_Item(self, Index: mwUnitType) -> CUnit:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CUnit(self.__IUnits.Item(Index))


	def __call__(self, index) -> CUnit:
		return self.__get_Item(index)


	def __iter__(self) -> CUnit:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IUnits.Count


	def __getitem__(self, index) -> Union[CUnit, List[CUnit]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def MetricLength(self) -> bool:
		"""Returns a value indicating if the length unit is metric or english"""
		return self.__IUnits.MetricLength


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IUnits.Name


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SweepValue
class CSweepValue:
	"""A MWOffice SweepVariable object."""
	def __init__(self, sweepvalue):
		self.__ISweepValue = sweepvalue

	def _get_inner(self):
		return self.__ISweepValue



	@property
	def ValueAsDouble(self) -> float:
		"""Returns a numeric value for the MWOffice SweepValue object."""
		return self.__ISweepValue.ValueAsDouble


	@property
	def ValueAsString(self) -> str:
		"""Returns a string value for the MWOffice SweepValue object."""
		return self.__ISweepValue.ValueAsString


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SweepValues
class CSweepValues:
	"""A collection of MWOffice SweepValue objects."""
	def __init__(self, sweepvalues):
		self.__ISweepValues = sweepvalues

	def _get_inner(self):
		return self.__ISweepValues



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ISweepValues.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ISweepValues.Exists(Index)


	def Item(self, Index) -> CSweepValue:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSweepValue(self.__ISweepValues.Item(Index))


	def __get_Item(self, Index) -> CSweepValue:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSweepValue(self.__ISweepValues.Item(Index))


	def __call__(self, index) -> CSweepValue:
		return self.__get_Item(index)


	def __iter__(self) -> CSweepValue:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ISweepValues.Count


	def __getitem__(self, index) -> Union[CSweepValue, List[CSweepValue]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SweepVariable
class CSweepVariable:
	"""A MWOffice SweepVariable object."""
	def __init__(self, sweepvariable):
		self.__ISweepVariable = sweepvariable

	def _get_inner(self):
		return self.__ISweepVariable



	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__ISweepVariable.Name


	@property
	def Type(self):
		"""Defines the unit type of the Sweep variable object."""
		return self.__ISweepVariable.Type


	@property
	def Values(self) -> CSweepValues:
		"""Returns a reference to a MWOFfice SweepValues collection."""
		return CSweepValues(self.__ISweepVariable.Values)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SweepVariables
class CSweepVariables:
	"""A collection of MWOffice SweepVariable objects."""
	def __init__(self, sweepvariables):
		self.__ISweepVariables = sweepvariables

	def _get_inner(self):
		return self.__ISweepVariables



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ISweepVariables.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ISweepVariables.Exists(Index)


	def Item(self, Index) -> CSweepVariable:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSweepVariable(self.__ISweepVariables.Item(Index))


	def __get_Item(self, Index) -> CSweepVariable:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSweepVariable(self.__ISweepVariables.Item(Index))


	def __call__(self, index) -> CSweepVariable:
		return self.__get_Item(index)


	def __iter__(self) -> CSweepVariable:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ISweepVariables.Count


	def __getitem__(self, index) -> Union[CSweepVariable, List[CSweepVariable]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Window
class CWindow:
	"""An MWOffice Window object."""
	def __init__(self, window):
		self.__IWindow = window

	def _get_inner(self):
		return self.__IWindow


	def Close(self) -> None:
		"""Closes the Window associated with the object."""
		self.__IWindow.Close()


	def Activate(self) -> None:
		"""Activates the Window associated with the object."""
		self.__IWindow.Activate()


	def ViewAll(self) -> None:
		"""Updates the window to display all objects."""
		self.__IWindow.ViewAll()


	def Center(self) -> bool:
		"""Centers the window in the MDI child region of the main frame window if applicable."""
		return self.__IWindow.Center()



	@property
	def Active(self) -> bool:
		"""Returns the active state of a Window object."""
		return self.__IWindow.Active


	@property
	def Caption(self) -> str:
		"""Returns/Sets the caption of an object."""
		return self.__IWindow.Caption


	@property
	def Floating(self) -> bool:
		"""Returns/sets the floating state of the Window object."""
		return self.__IWindow.Floating


	@Floating.setter
	def Floating(self, value: bool):
		"""Returns/sets the floating state of the Window object."""
		self.__IWindow.Floating = value


	@property
	def Height(self) -> int:
		"""Returns/sets the height of a Window object."""
		return self.__IWindow.Height


	@Height.setter
	def Height(self, value: int):
		"""Returns/sets the height of a Window object."""
		self.__IWindow.Height = value


	@property
	def Left(self) -> int:
		"""Returns/sets the left edge of a Window object."""
		return self.__IWindow.Left


	@Left.setter
	def Left(self, value: int):
		"""Returns/sets the left edge of a Window object."""
		self.__IWindow.Left = value


	@property
	def Next(self) -> CWindow:
		"""Returns a reference to a Window object."""
		return CWindow(self.__IWindow.Next)


	@property
	def Previous(self) -> CWindow:
		"""Returns a reference to a Window object."""
		return CWindow(self.__IWindow.Previous)


	@property
	def Top(self) -> int:
		"""Returns/sets the top edge of a Window object."""
		return self.__IWindow.Top


	@Top.setter
	def Top(self, value: int):
		"""Returns/sets the top edge of a Window object."""
		self.__IWindow.Top = value


	@property
	def Type(self):
		"""Returns the content type of a Window object."""
		return self.__IWindow.Type


	@property
	def Width(self) -> int:
		"""Returns/sets the width of a Window object."""
		return self.__IWindow.Width


	@Width.setter
	def Width(self, value: int):
		"""Returns/sets the width of a Window object."""
		self.__IWindow.Width = value


	@property
	def WindowState(self):
		"""Returns the screen state of a Window object."""
		return self.__IWindow.WindowState


	@WindowState.setter
	def WindowState(self, value: mwWindowState):
		"""Returns the screen state of a Window object."""
		self.__IWindow.WindowState = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Windows
class CWindows:
	"""A collection of MWOffice Window objects."""
	def __init__(self, windows):
		self.__IWindows = windows

	def _get_inner(self):
		return self.__IWindows


	def Add(self, hWnd: int) -> CWindow:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CWindow(self.__IWindows.Add(hWnd))


	def Tile(self, dir: mwWindowTileDirection) -> None:
		"""Tiles all top-level windows in a horizontal or vertical orientation."""
		self.__IWindows.Tile(dir)


	def Cascade(self) -> None:
		"""Cascades all top-level windows."""
		self.__IWindows.Cascade()


	def Close(self) -> None:
		"""Closes all top-level windows."""
		self.__IWindows.Close()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IWindows.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IWindows.Exists(Index)


	def Item(self, Index) -> CWindow:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CWindow(self.__IWindows.Item(Index))


	def __get_Item(self, Index) -> CWindow:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CWindow(self.__IWindows.Item(Index))


	def __call__(self, index) -> CWindow:
		return self.__get_Item(index)


	def __iter__(self) -> CWindow:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IWindows.Count


	def __getitem__(self, index) -> Union[CWindow, List[CWindow]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# WireNet
class CWireNet:
	"""An MWOffice WireNet object."""
	def __init__(self, wirenet):
		self.__IWireNet = wirenet

	def _get_inner(self):
		return self.__IWireNet


	def HighlightNet(self, bHighlightOn: bool, Color: int = 255) -> bool:
		"""Sets the highlight state of the wire net to on or off and allows the specification of the highlight Color."""
		return self.__IWireNet.HighlightNet(bHighlightOn, Color)



	@property
	def ElectNetName(self) -> str:
		"""Returns a reference to an Element object."""
		return self.__IWireNet.ElectNetName


	@property
	def NetHighlight(self) -> bool:
		"""Returns if the wire net is currently highlighted."""
		return self.__IWireNet.NetHighlight


	@property
	def NetHighlightColor(self) -> int:
		"""Returns the highlight color for the net."""
		return self.__IWireNet.NetHighlightColor


	@property
	def Wires(self) -> CWires:
		"""Returns a reference to a collection of WireSegment objects."""
		return CWires(self.__IWireNet.Wires)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# WireSegment
class CWireSegment:
	"""An MWOffice WireSegment object."""
	def __init__(self, wiresegment):
		self.__IWireSegment = wiresegment

	def _get_inner(self):
		return self.__IWireSegment


	def AddBusNetName(self, Name: str, x: int, y: int, Priority: int = 0, Flags: int = 0) -> CBusNetName:
		"""Adds a BusNetName object to the WiresegmentObject and returns a reference to the newly added BusNetName object."""
		return CBusNetName(self.__IWireSegment.AddBusNetName(Name, x, y, Priority, Flags))


	def RemoveBusNetName(self) -> bool:
		"""Removes a BusNetName object from the WireSegment object."""
		return self.__IWireSegment.RemoveBusNetName()


	def Delete(self) -> bool:
		"""Removes the object."""
		return self.__IWireSegment.Delete()



	@property
	def BusNetName(self) -> CBusNetName:
		"""Returns a reference to a MWOffice BusNetName object."""
		return CBusNetName(self.__IWireSegment.BusNetName)


	@property
	def HasBusNetName(self) -> bool:
		"""Returns a value indicating if the WireSegment object has a BusNetName object associated with it."""
		return self.__IWireSegment.HasBusNetName


	@property
	def Nodes(self) -> CNodes:
		"""Returns a reference to a collection of Node objects."""
		return CNodes(self.__IWireSegment.Nodes)


	@property
	def NumConnected1(self) -> int:
		"""Returns a count of the number of connections to the end of the WireSegment object."""
		return self.__IWireSegment.NumConnected1


	@property
	def NumConnected2(self) -> int:
		"""Returns a count of the number of connections to the end of the WireSegment object."""
		return self.__IWireSegment.NumConnected2


	@property
	def ParentNet(self) -> CWireNet:
		"""Returns a reference to a MWOffice WireNet object."""
		return CWireNet(self.__IWireSegment.ParentNet)


	@property
	def Selected(self) -> bool:
		"""Returns/sets a value which specifies if the object is selected."""
		return self.__IWireSegment.Selected


	@Selected.setter
	def Selected(self, value: bool):
		"""Returns/sets a value which specifies if the object is selected."""
		self.__IWireSegment.Selected = value


	@property
	def x1(self) -> int:
		"""Returns the X coordinate of the starting point of a WireSegment object."""
		return self.__IWireSegment.x1


	@x1.setter
	def x1(self, value: int):
		"""Returns the X coordinate of the starting point of a WireSegment object."""
		self.__IWireSegment.x1 = value


	@property
	def x2(self) -> int:
		"""Returns the X coordinate of the ending point of a WireSegment object."""
		return self.__IWireSegment.x2


	@x2.setter
	def x2(self, value: int):
		"""Returns the X coordinate of the ending point of a WireSegment object."""
		self.__IWireSegment.x2 = value


	@property
	def y1(self) -> int:
		"""Returns the Y coordinate of the starting point of a WireSegment object."""
		return self.__IWireSegment.y1


	@y1.setter
	def y1(self, value: int):
		"""Returns the Y coordinate of the starting point of a WireSegment object."""
		self.__IWireSegment.y1 = value


	@property
	def y2(self) -> int:
		"""Returns the Y coordinate of the ending point of a WireSegment object."""
		return self.__IWireSegment.y2


	@y2.setter
	def y2(self, value: int):
		"""Returns the Y coordinate of the ending point of a WireSegment object."""
		self.__IWireSegment.y2 = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Wires
class CWires:
	"""A collection of MWOffice WireSegment objects."""
	def __init__(self, wires):
		self.__IWires = wires

	def _get_inner(self):
		return self.__IWires


	def Add(self, x1: int, y1: int, x2: int, y2: int) -> CWireSegment:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CWireSegment(self.__IWires.Add(x1, y1, x2, y2))


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IWires.RemoveAll()


	def AddBusNet(self, x1: int, y1: int, x2: int, y2: int, NetName: str, xName: int, yName: int, Priority: int = 0, Flags: int = 0) -> CWireSegment:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CWireSegment(self.__IWires.AddBusNet(x1, y1, x2, y2, NetName, xName, yName, Priority, Flags))


	def Cleanup(self) -> bool:
		"""Performs a cleanup operation on the collection object."""
		return self.__IWires.Cleanup()


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IWires.Remove(Index)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IWires.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IWires.Exists(Index)


	def Item(self, Index) -> CWireSegment:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CWireSegment(self.__IWires.Item(Index))


	def __get_Item(self, Index) -> CWireSegment:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CWireSegment(self.__IWires.Item(Index))


	def __call__(self, index) -> CWireSegment:
		return self.__get_Item(index)


	def __iter__(self) -> CWireSegment:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IWires.Count


	def __getitem__(self, index) -> Union[CWireSegment, List[CWireSegment]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SelectedWires
class CSelectedWires:
	"""A collection of MWOffice SelectedWire objects."""
	def __init__(self, selectedwires):
		self.__ISelectedWires = selectedwires

	def _get_inner(self):
		return self.__ISelectedWires


	def Add(self, WireSegment: CWireSegment) -> bool:
		"""Adds an object to the collection and returns a reference to the created object."""
		return self.__ISelectedWires.Add(WireSegment._get_inner())


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ISelectedWires.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__ISelectedWires.RemoveAll()


	def AddAll(self) -> bool:
		"""Adds an object to the collection and returns a reference to the created object."""
		return self.__ISelectedWires.AddAll()


	def AddFromArea(self, Left: int, Top: int, Right: int, Bottom: int, Type: mwAreaAddType = 0) -> bool:
		"""Adds the objects contained or overlapped by a given rectangle to the collection."""
		return self.__ISelectedWires.AddFromArea(Left, Top, Right, Bottom, Type)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ISelectedWires.Count


	def Item(self, Index) -> CWireSegment:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CWireSegment(self.__ISelectedWires.Item(Index))


	def __get_Item(self, Index) -> CWireSegment:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CWireSegment(self.__ISelectedWires.Item(Index))


	def __call__(self, index) -> CWireSegment:
		return self.__get_Item(index)


	def __iter__(self) -> CWireSegment:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ISelectedWires.Count


	def __getitem__(self, index) -> Union[CWireSegment, List[CWireSegment]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# YieldGoals
class CYieldGoals:
	"""A collection of MWOffice Goal objects."""
	def __init__(self, yieldgoals):
		self.__IYieldGoals = yieldgoals

	def _get_inner(self):
		return self.__IYieldGoals


	def Add(self, CircuitName: str, MeasName: str, GoalType: mwYieldGoalType, xStart: float, xStop: float, xUnit: mwUnitType, yStart: float, yStop: float, yUnit: mwUnitType) -> CGoal:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CGoal(self.__IYieldGoals.Add(CircuitName, MeasName, GoalType, xStart, xStop, xUnit, yStart, yStop, yUnit))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IYieldGoals.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IYieldGoals.RemoveAll()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IYieldGoals.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IYieldGoals.Exists(Index)


	def Item(self, Index) -> CGoal:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CGoal(self.__IYieldGoals.Item(Index))


	def __get_Item(self, Index) -> CGoal:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CGoal(self.__IYieldGoals.Item(Index))


	def __call__(self, index) -> CGoal:
		return self.__get_Item(index)


	def __iter__(self) -> CGoal:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IYieldGoals.Count


	def __getitem__(self, index) -> Union[CGoal, List[CGoal]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def TotalCost(self) -> float:
		"""Returns the total cost of a collection of Goal object."""
		return self.__IYieldGoals.TotalCost


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Option
class COption:
	"""An MWOffice Option object."""
	def __init__(self, option):
		self.__IOption = option

	def _get_inner(self):
		return self.__IOption



	@property
	def DataType(self) -> int:
		"""Returns the data type of the Option object."""
		return self.__IOption.DataType


	@property
	def DefaultValue(self):
		"""Returns the default value of the Option object."""
		return self.__IOption.DefaultValue


	@property
	def Description(self) -> str:
		"""Returns a description of the Option object."""
		return self.__IOption.Description


	@property
	def Id(self) -> int:
		"""Returns the ID of the Option object."""
		return self.__IOption.Id


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IOption.Name


	@property
	def ReadOnly(self) -> bool:
		"""Returns a value indicating if the Option object is read-only"""
		return self.__IOption.ReadOnly


	@property
	def Value(self):
		"""Returns/Set the value of a Option object."""
		return self.__IOption.Value


	@Value.setter
	def Value(self, value):
		"""Returns/Set the value of a Option object."""
		self.__IOption.Value = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Options
class COptions:
	"""A collection of MWOffice Option objects."""
	def __init__(self, options):
		self.__IOptions = options

	def _get_inner(self):
		return self.__IOptions



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IOptions.Count


	def Exists(self, __MIDL__IOptions0000) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IOptions.Exists(__MIDL__IOptions0000)


	def Item(self, Index) -> COption:
		"""Returns a specific item of a Collection object either by position or by key."""
		return COption(self.__IOptions.Item(Index))


	def __get_Item(self, Index) -> COption:
		"""Returns a specific item of a Collection object either by position or by key."""
		return COption(self.__IOptions.Item(Index))


	def __call__(self, index) -> COption:
		return self.__get_Item(index)


	def __iter__(self) -> COption:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IOptions.Count


	def __getitem__(self, index) -> Union[COption, List[COption]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# OptionSubSet
class COptionSubSet:
	"""An MWOffice OptionSubSet object."""
	def __init__(self, optionsubset):
		self.__IOptionSubSet = optionsubset

	def _get_inner(self):
		return self.__IOptionSubSet



	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IOptionSubSet.Name


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__IOptionSubSet.Options)


	@property
	def UseProjectDefaults(self) -> bool:
		"""Returns/sets a value indicating if project defaults should be used for this option set."""
		return self.__IOptionSubSet.UseProjectDefaults


	@UseProjectDefaults.setter
	def UseProjectDefaults(self, value: bool):
		"""Returns/sets a value indicating if project defaults should be used for this option set."""
		self.__IOptionSubSet.UseProjectDefaults = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# OptionSubSets
class COptionSubSets:
	"""A collection of MWOffice OptionSubSet objects."""
	def __init__(self, optionsubsets):
		self.__IOptionSubSets = optionsubsets

	def _get_inner(self):
		return self.__IOptionSubSets



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IOptionSubSets.Count


	def Exists(self, __MIDL__IOptionSubSets0000) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IOptionSubSets.Exists(__MIDL__IOptionSubSets0000)


	def Item(self, Index) -> COptionSubSet:
		"""Returns a specific item of a Collection object either by position or by key."""
		return COptionSubSet(self.__IOptionSubSets.Item(Index))


	def __get_Item(self, Index) -> COptionSubSet:
		"""Returns a specific item of a Collection object either by position or by key."""
		return COptionSubSet(self.__IOptionSubSets.Item(Index))


	def __call__(self, index) -> COptionSubSet:
		return self.__get_Item(index)


	def __iter__(self) -> COptionSubSet:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IOptionSubSets.Count


	def __getitem__(self, index) -> Union[COptionSubSet, List[COptionSubSet]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# OptionSet
class COptionSet:
	"""An MWOffice OptionSet object."""
	def __init__(self, optionset):
		self.__IOptionSet = optionset

	def _get_inner(self):
		return self.__IOptionSet



	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IOptionSet.Name


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__IOptionSet.Options)


	@property
	def SubSets(self) -> COptionSubSets:
		"""Returns a reference to an OptionSubSet object."""
		return COptionSubSets(self.__IOptionSet.SubSets)


	@property
	def UseProjectDefaults(self) -> bool:
		"""Returns/sets a value indicating if project defaults should be used for this option set."""
		return self.__IOptionSet.UseProjectDefaults


	@UseProjectDefaults.setter
	def UseProjectDefaults(self, value: bool):
		"""Returns/sets a value indicating if project defaults should be used for this option set."""
		self.__IOptionSet.UseProjectDefaults = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# OptionSets
class COptionSets:
	"""A collection of MWOffice OptionSet objects."""
	def __init__(self, optionsets):
		self.__IOptionSets = optionsets

	def _get_inner(self):
		return self.__IOptionSets



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IOptionSets.Count


	def Exists(self, __MIDL__IOptionSets0000) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IOptionSets.Exists(__MIDL__IOptionSets0000)


	def Item(self, Index) -> COptionSet:
		"""Returns a specific item of a Collection object either by position or by key."""
		return COptionSet(self.__IOptionSets.Item(Index))


	def __get_Item(self, Index) -> COptionSet:
		"""Returns a specific item of a Collection object either by position or by key."""
		return COptionSet(self.__IOptionSets.Item(Index))


	def __call__(self, index) -> COptionSet:
		return self.__get_Item(index)


	def __iter__(self) -> COptionSet:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IOptionSets.Count


	def __getitem__(self, index) -> Union[COptionSet, List[COptionSet]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SystemDiagram
class CSystemDiagram:
	"""An MWOffice SystemDiagram object."""
	def __init__(self, systemdiagram):
		self.__ISystemDiagram = systemdiagram

	def _get_inner(self):
		return self.__ISystemDiagram


	def CopyToClipboard(self) -> None:
		"""Copies the object to the system clipboard."""
		self.__ISystemDiagram.CopyToClipboard()


	def SetupConnectivity(self) -> None:
		"""method SetupConnectivity"""
		self.__ISystemDiagram.SetupConnectivity()


	def Activate(self) -> None:
		"""Activates the objects."""
		self.__ISystemDiagram.Activate()


	def NewWindow(self, WindowType: mwWindowType = 12) -> CWindow:
		"""Displays the object in new window."""
		return CWindow(self.__ISystemDiagram.NewWindow(WindowType))


	def Export(self, FilePath: str, format: mwSystemExportFormat = 0) -> None:
		"""Exports a design document file from MWOffice."""
		self.__ISystemDiagram.Export(FilePath, format)


	def PrintOut(self) -> None:
		"""Sends the object to the current printer."""
		self.__ISystemDiagram.PrintOut()


	def LockDiagram(self, NewLevel: mwDiagramLockLevel, Password: str = "") -> bool:
		"""Changes the lock level of the system diagram to the given lock level"""
		return self.__ISystemDiagram.LockDiagram(NewLevel, Password)


	def InvokeCommand(self, CommandName: str, Arguments, pRet) -> None:
		"""Invoke a menu command by specifying the name for the command. Arguments must be supplied for any required input."""
		self.__ISystemDiagram.InvokeCommand(CommandName, Arguments, pRet)


	def Paste(self, x: int, y: int, CCWRotation: int = 0, Flipped: bool = 0) -> bool:
		"""Pastes the system clipboard to the object."""
		return self.__ISystemDiagram.Paste(x, y, CCWRotation, Flipped)


	def CopyViewToClipboard(self) -> bool:
		"""Copies the object to the system clipboard."""
		return self.__ISystemDiagram.CopyViewToClipboard()


	def PrintView(self) -> bool:
		"""Sends the object to the current printer."""
		return self.__ISystemDiagram.PrintView()


	def StartCommand(self, CommandName: str, pRet) -> None:
		"""Start a menu command by specifying the name for the command. The user will need to complete any required input."""
		self.__ISystemDiagram.StartCommand(CommandName, pRet)


	def IsSimulationStateFlagSet(self, flag: mwSimStateFlags) -> bool:
		"""Returns a value that indicates if a certain simulation state flag is set."""
		return self.__ISystemDiagram.IsSimulationStateFlagSet(flag)


	def EndActiveCommand(self) -> bool:
		"""Ends the currently active command for this SystemDiagram object."""
		return self.__ISystemDiagram.EndActiveCommand()


	def Embed(self) -> None:
		"""Convert an externally linked system diagram into an embedded document."""
		self.__ISystemDiagram.Embed()


	def LinkToFile(self, FilePath: str) -> None:
		"""Convert an embedded system diagram into an externally linked document."""
		self.__ISystemDiagram.LinkToFile(FilePath)


	def Reload(self) -> None:
		"""Reload an externally linked system diagram."""
		self.__ISystemDiagram.Reload()


	def Save(self) -> None:
		"""Update the externally linked system diagram file."""
		self.__ISystemDiagram.Save()



	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__ISystemDiagram.Boundary)


	@property
	def CanPaste(self) -> bool:
		"""Returns a value that determines the clipboard contents can be pasted to the object."""
		return self.__ISystemDiagram.CanPaste


	@property
	def Changed(self) -> bool:
		"""Returns/Sets a value that indicates if the object has changed and needs to be saved or resimulated."""
		return self.__ISystemDiagram.Changed


	@Changed.setter
	def Changed(self, value: bool):
		"""Returns/Sets a value that indicates if the object has changed and needs to be saved or resimulated."""
		self.__ISystemDiagram.Changed = value


	@property
	def CommandActive(self) -> bool:
		"""Returns a value indicating if there is command currently active for this SystemDiagram object."""
		return self.__ISystemDiagram.CommandActive


	@property
	def DrawingShapes(self) -> CDrawingShapes:
		"""Returns a reference to a collection of DrawingShape objects."""
		return CDrawingShapes(self.__ISystemDiagram.DrawingShapes)


	@property
	def Elements(self) -> CElements:
		"""Returns a reference to a collection of Element objects."""
		return CElements(self.__ISystemDiagram.Elements)


	@property
	def Embedded(self) -> bool:
		"""Returns if the SystemDiagram is embedded or linked externally."""
		return self.__ISystemDiagram.Embedded


	@property
	def EmbeddedDesigns(self) -> CEmbeddedDesigns:
		"""Returns a reference to a collection of EmbeddedDesign objects."""
		return CEmbeddedDesigns(self.__ISystemDiagram.EmbeddedDesigns)


	@property
	def Equations(self) -> CEquations:
		"""Returns a reference to a collection of Equation objects."""
		return CEquations(self.__ISystemDiagram.Equations)


	@property
	def FilePath(self) -> str:
		"""Returns the file path for this SystemDiagram object."""
		return self.__ISystemDiagram.FilePath


	@property
	def GridVisible(self) -> bool:
		"""Returns/sets a value that specifies if the snap grid is visible for the SystemDiagram."""
		return self.__ISystemDiagram.GridVisible


	@GridVisible.setter
	def GridVisible(self, value: bool):
		"""Returns/sets a value that specifies if the snap grid is visible for the SystemDiagram."""
		self.__ISystemDiagram.GridVisible = value


	@property
	def LockLevel(self):
		"""Returns a value that specifies the lock level of the schematic diagram"""
		return self.__ISystemDiagram.LockLevel


	@property
	def LockUpdates(self) -> bool:
		"""property LockUpdates"""
		return self.__ISystemDiagram.LockUpdates


	@LockUpdates.setter
	def LockUpdates(self, value: bool):
		"""property LockUpdates"""
		self.__ISystemDiagram.LockUpdates = value


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__ISystemDiagram.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__ISystemDiagram.Name = value


	@property
	def OptionSets(self) -> COptionSets:
		"""Returns a reference to a collection of OptionSet objects."""
		return COptionSets(self.__ISystemDiagram.OptionSets)


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__ISystemDiagram.Options)


	@property
	def Orthogonal(self) -> bool:
		"""Returns/sets a value that specifies if drawing should be only orthogonal for the SystemDiagram."""
		return self.__ISystemDiagram.Orthogonal


	@Orthogonal.setter
	def Orthogonal(self, value: bool):
		"""Returns/sets a value that specifies if drawing should be only orthogonal for the SystemDiagram."""
		self.__ISystemDiagram.Orthogonal = value


	@property
	def Ports(self) -> CPorts:
		"""Returns a reference to a MWOffice Element collection consisting of only the system diagram port elements"""
		return CPorts(self.__ISystemDiagram.Ports)


	@property
	def Properties(self) -> CProperties:
		"""Returns a reference to a collection of Property objects."""
		return CProperties(self.__ISystemDiagram.Properties)


	@property
	def RFBFrequencyOffsets(self) -> CFrequencies:
		"""A collection of the MWOffice frequency objects for the RF Budget Analysis frequency offsets."""
		return CFrequencies(self.__ISystemDiagram.RFBFrequencyOffsets)


	def ReadOnly(self, pRet) -> None:
		"""Returns a value indicating if the SystemDiagram object is currently read-only."""
		return self.__ISystemDiagram.ReadOnly(pRet)


	@property
	def SelectedDrawingShapes(self) -> CSelectedDrawingShapes:
		"""Returns a reference to a collection of MWOffice SelectedDrawingShape objects."""
		return CSelectedDrawingShapes(self.__ISystemDiagram.SelectedDrawingShapes)


	@property
	def SelectedElements(self) -> CSelectedElements:
		"""Returns a reference to a collection of MWOffice SelectedElement objects."""
		return CSelectedElements(self.__ISystemDiagram.SelectedElements)


	@property
	def SelectedWires(self) -> CSelectedWires:
		"""Returns a reference to a collection of MWOffice SelectedWire objects."""
		return CSelectedWires(self.__ISystemDiagram.SelectedWires)


	@property
	def SimulationDirty(self) -> bool:
		"""Returns if the current simulation state is dirty for the SystemDiagram object."""
		return self.__ISystemDiagram.SimulationDirty


	@property
	def SimulationState(self) -> int:
		"""Returns the current simulation state for the SystemDiagram object."""
		return self.__ISystemDiagram.SimulationState


	@property
	def SnapToGrid(self) -> bool:
		"""Returns/sets a value that specifies if grid snap is enabled for the SystemDiagram."""
		return self.__ISystemDiagram.SnapToGrid


	@SnapToGrid.setter
	def SnapToGrid(self, value: bool):
		"""Returns/sets a value that specifies if grid snap is enabled for the SystemDiagram."""
		self.__ISystemDiagram.SnapToGrid = value


	@property
	def Subsystems(self):
		"""Returns a reference to a MWOffice Element collection consisting of only the system diagram subsystem elements"""
		return self.__ISystemDiagram.Subsystems


	@property
	def SweepVariables(self) -> CSweepVariables:
		"""Returns a reference to a MWOffice SweepVariables collection."""
		return CSweepVariables(self.__ISystemDiagram.SweepVariables)


	def TestPoints(self, SimulationVendorName: str) -> CTestPoints:
		"""Returns a reference to a collection of TestPoint objects."""
		return CTestPoints(self.__ISystemDiagram.TestPoints(SimulationVendorName))


	@property
	def UseProjectOptions(self) -> bool:
		"""Returns/sets a value which specifies if the global project options should be used."""
		return self.__ISystemDiagram.UseProjectOptions


	@UseProjectOptions.setter
	def UseProjectOptions(self, value: bool):
		"""Returns/sets a value which specifies if the global project options should be used."""
		self.__ISystemDiagram.UseProjectOptions = value


	@property
	def UseProjectRFBFrequencyOffsets(self) -> bool:
		"""Returns/sets a value which specifies if the global RFB frequency offsets should be used for analysis."""
		return self.__ISystemDiagram.UseProjectRFBFrequencyOffsets


	@UseProjectRFBFrequencyOffsets.setter
	def UseProjectRFBFrequencyOffsets(self, value: bool):
		"""Returns/sets a value which specifies if the global RFB frequency offsets should be used for analysis."""
		self.__ISystemDiagram.UseProjectRFBFrequencyOffsets = value


	@property
	def Views(self) -> CViews:
		"""Returns a reference to a MWOffive Views collection."""
		return CViews(self.__ISystemDiagram.Views)


	@property
	def Windows(self) -> CWindows:
		"""Returns a reference to a collection of Window objects."""
		return CWindows(self.__ISystemDiagram.Windows)


	@property
	def Wires(self) -> CWires:
		"""Returns a reference to a collection of WireSegment objects."""
		return CWires(self.__ISystemDiagram.Wires)


	@property
	def XGridSpacing(self) -> int:
		"""Returns/sets a value that specifies the grid spacing along the X coordinate direction."""
		return self.__ISystemDiagram.XGridSpacing


	@property
	def YGridSpacing(self) -> int:
		"""Returns/sets a value that specifies the grid spacing along the Y coordinate direction."""
		return self.__ISystemDiagram.YGridSpacing


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SystemDiagrams
class CSystemDiagrams:
	"""A collection of MWOffice SystemDiagram objects."""
	def __init__(self, systemdiagrams):
		self.__ISystemDiagrams = systemdiagrams

	def _get_inner(self):
		return self.__ISystemDiagrams


	def Add(self, Name: str) -> CSystemDiagram:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CSystemDiagram(self.__ISystemDiagrams.Add(Name))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ISystemDiagrams.Remove(Index)


	def Import(self, Name: str, Filename: str) -> CSystemDiagram:
		"""Adds an object to the collection from a file and returns a reference to the created object."""
		return CSystemDiagram(self.__ISystemDiagrams.Import(Name, Filename))


	def LinkTo(self, Name: str, Filename: str) -> CSystemDiagram:
		"""Adds a SystemDiagram object link to the collection from a file and returns a reference to the created object."""
		return CSystemDiagram(self.__ISystemDiagrams.LinkTo(Name, Filename))


	def Copy(self, Index, NewName: str = "") -> CSystemDiagram:
		"""Copies an object from another object collection into this object collection."""
		return CSystemDiagram(self.__ISystemDiagrams.Copy(Index, NewName))


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__ISystemDiagrams.GetUniqueName(baseName)



	@property
	def ActiveSystemDiagram(self) -> CSystemDiagram:
		"""Returns the active system diagram of a Project object."""
		return CSystemDiagram(self.__ISystemDiagrams.ActiveSystemDiagram)


	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ISystemDiagrams.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ISystemDiagrams.Exists(Index)


	def Item(self, Index) -> CSystemDiagram:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSystemDiagram(self.__ISystemDiagrams.Item(Index))


	def __get_Item(self, Index) -> CSystemDiagram:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSystemDiagram(self.__ISystemDiagrams.Item(Index))


	def __call__(self, index) -> CSystemDiagram:
		return self.__get_Item(index)


	def __iter__(self) -> CSystemDiagram:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ISystemDiagrams.Count


	def __getitem__(self, index) -> Union[CSystemDiagram, List[CSystemDiagram]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__ISystemDiagrams.Options)


	@property
	def RFBFrequencyOffsets(self) -> CFrequencies:
		"""A collection of the MWOffice frequency objects for the RF Budget Analysis frequency offsets."""
		return CFrequencies(self.__ISystemDiagrams.RFBFrequencyOffsets)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DesignNote
class CDesignNote:
	"""An MWOffice DesignNote object."""
	def __init__(self, designnote):
		self.__IDesignNote = designnote

	def _get_inner(self):
		return self.__IDesignNote


	def CopyToClipboard(self) -> None:
		"""Copies the object to the system clipboard."""
		self.__IDesignNote.CopyToClipboard()


	def Export(self, Path: str) -> None:
		"""Exports the DesignNote to a Rich Text file."""
		self.__IDesignNote.Export(Path)


	def PrintOut(self) -> None:
		"""Sends the object to the current printer."""
		self.__IDesignNote.PrintOut()


	def Import(self, Path: str) -> None:
		"""Imports a Rich Text File into the DesignNote object."""
		self.__IDesignNote.Import(Path)


	def Activate(self) -> None:
		"""Activates the objects."""
		self.__IDesignNote.Activate()


	def NewWindow(self) -> CWindow:
		"""Displays the object in new window."""
		return CWindow(self.__IDesignNote.NewWindow())


	def Paste(self) -> bool:
		"""Pastes the current contents of the clipboard into the design note view."""
		return self.__IDesignNote.Paste()



	@property
	def CanPaste(self) -> bool:
		"""Returns a value which indicates if the current clipboard contents can be pasted into the DesignNote view."""
		return self.__IDesignNote.CanPaste


	@property
	def Content(self) -> str:
		"""Returns the content of a DesignNote in Rich Text format."""
		return self.__IDesignNote.Content


	@property
	def Modified(self) -> bool:
		"""Returns/Sets a value which determines if the Design Note Object has been modified."""
		return self.__IDesignNote.Modified


	@Modified.setter
	def Modified(self, value: bool):
		"""Returns/Sets a value which determines if the Design Note Object has been modified."""
		self.__IDesignNote.Modified = value


	@property
	def Name(self) -> str:
		"""Returns the file name of the project, not including the file's path specification."""
		return self.__IDesignNote.Name


	@property
	def PlainText(self) -> str:
		"""Returns/Sets the content of a DesignNote in plain text."""
		return self.__IDesignNote.PlainText


	@PlainText.setter
	def PlainText(self, value: str):
		"""Returns/Sets the content of a DesignNote in plain text."""
		self.__IDesignNote.PlainText = value


	@property
	def ReadOnly(self) -> bool:
		"""Returns a value which determines if the Design Note object is read-only."""
		return self.__IDesignNote.ReadOnly


	@property
	def Windows(self) -> CWindows:
		"""Returns a reference to a collection of Window objects."""
		return CWindows(self.__IDesignNote.Windows)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DesignNotes
class CDesignNotes:
	"""A collection of MWOffice DesignNote objects."""
	def __init__(self, designnotes):
		self.__IDesignNotes = designnotes

	def _get_inner(self):
		return self.__IDesignNotes



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IDesignNotes.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IDesignNotes.Exists(Index)


	def Item(self, Index) -> CDesignNote:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDesignNote(self.__IDesignNotes.Item(Index))


	def __get_Item(self, Index) -> CDesignNote:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDesignNote(self.__IDesignNotes.Item(Index))


	def __call__(self, index) -> CDesignNote:
		return self.__get_Item(index)


	def __iter__(self) -> CDesignNote:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IDesignNotes.Count


	def __getitem__(self, index) -> Union[CDesignNote, List[CDesignNote]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Simulator
class CSimulator:
	"""An MWOffice Simulator object."""
	def __init__(self, simulator):
		self.__ISimulator = simulator

	def _get_inner(self):
		return self.__ISimulator


	def Analyze(self) -> None:
		"""Invokes a circuit simulator analysis."""
		self.__ISimulator.Analyze()


	def start(self) -> None:
		"""Starts the system simulator to perform an analysis."""
		self.__ISimulator.start()


	def Pause(self) -> None:
		"""Pauses the system simulator during an analysis."""
		self.__ISimulator.Pause()


	def Continue(self) -> None:
		"""Steps a paused system simulation"""
		self.__ISimulator.Continue()


	def stop(self) -> None:
		"""Stops the system simulator during an analysis."""
		self.__ISimulator.stop()


	def AnalyzeOpenGraphs(self) -> None:
		"""Simulates the open graphs."""
		self.__ISimulator.AnalyzeOpenGraphs()


	def RunStop(self) -> None:
		"""Runs the system simulators if they are stopped, stops the system simulators if they are running"""
		self.__ISimulator.RunStop()


	def AnalyzeAsync(self) -> None:
		"""Starts an asynchronous circuit simulator analysis"""
		self.__ISimulator.AnalyzeAsync()



	@property
	def AnalyzeState(self):
		"""Returns a value indicating the current simulator analysis state."""
		return self.__ISimulator.AnalyzeState


	@property
	def state(self):
		"""Returns a value indicating the current system simulator state"""
		return self.__ISimulator.state


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Attribute
class CAttribute:
	"""An MWOffice Attribute object."""
	def __init__(self, attribute):
		self.__IAttribute = attribute

	def _get_inner(self):
		return self.__IAttribute



	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__IAttribute.Name


	@property
	def ReadOnly(self) -> bool:
		"""Returns a value which specifies if the Attribute is read-only."""
		return self.__IAttribute.ReadOnly


	@property
	def Type(self) -> int:
		"""Returns a value which specifies the type of an Attribute object."""
		return self.__IAttribute.Type


	@property
	def Value(self):
		"""Returns/sets the value of the Attribute object."""
		return self.__IAttribute.Value


	@Value.setter
	def Value(self, value):
		"""Returns/sets the value of the Attribute object."""
		self.__IAttribute.Value = value


	@property
	def ValueAsString(self) -> str:
		"""Returns the attribute value as a string."""
		return self.__IAttribute.ValueAsString


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Attributes
class CAttributes:
	"""A collection of MWOffice Attribute objects."""
	def __init__(self, attributes):
		self.__IAttributes = attributes

	def _get_inner(self):
		return self.__IAttributes



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IAttributes.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IAttributes.Exists(Index)


	def Item(self, Index) -> CAttribute:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CAttribute(self.__IAttributes.Item(Index))


	def __get_Item(self, Index) -> CAttribute:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CAttribute(self.__IAttributes.Item(Index))


	def __call__(self, index) -> CAttribute:
		return self.__get_Item(index)


	def __iter__(self) -> CAttribute:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IAttributes.Count


	def __getitem__(self, index) -> Union[CAttribute, List[CAttribute]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Conductor
class CConductor:
	"""An MWOffice Conductor object."""
	def __init__(self, conductor):
		self.__IConductor = conductor

	def _get_inner(self):
		return self.__IConductor



	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Conductors
class CConductors:
	"""A collection of MWOffice Conductor objects."""
	def __init__(self, conductors):
		self.__IConductors = conductors

	def _get_inner(self):
		return self.__IConductors


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__IConductors.GetUniqueName(baseName)



	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# BoundaryModel
class CBoundaryModel:
	"""An MWOffice BoundaryModel object."""
	def __init__(self, boundarymodel):
		self.__IBoundaryModel = boundarymodel

	def _get_inner(self):
		return self.__IBoundaryModel



	@property
	def Type(self):
		"""Returns a value which specifies the type of a BoundaryModel object."""
		return self.__IBoundaryModel.Type


	@Type.setter
	def Type(self, value: mwBoundaryModelType):
		"""Returns a value which specifies the type of a BoundaryModel object."""
		self.__IBoundaryModel.Type = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Boundary
class CBoundary:
	"""An MWOffice Boundary object."""
	def __init__(self, boundary):
		self.__IBoundary = boundary

	def _get_inner(self):
		return self.__IBoundary



	@property
	def Bottom(self) -> float:
		"""Returns the boundary bottom edge for an object."""
		return self.__IBoundary.Bottom


	@property
	def Left(self) -> float:
		"""Returns the boundary left edge for an object."""
		return self.__IBoundary.Left


	@property
	def Right(self) -> float:
		"""Returns the boundary right edge for an object."""
		return self.__IBoundary.Right


	@property
	def Top(self) -> float:
		"""Returns the boundary top edge for an object."""
		return self.__IBoundary.Top


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LayoutParameter
class CLayoutParameter:
	"""An MWOffice LayoutParameter object."""
	def __init__(self, layoutparameter):
		self.__ILayoutParameter = layoutparameter

	def _get_inner(self):
		return self.__ILayoutParameter



	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__ILayoutParameter.Name


	@property
	def ParameterType(self):
		"""Returns the variable type of a LayoutParameter object as an mwLayoutParamDataType enum value."""
		return self.__ILayoutParameter.ParameterType


	@property
	def UnitType(self):
		"""Returns a value which specifies the unit type of a Parameter object."""
		return self.__ILayoutParameter.UnitType


	@property
	def ValueAsDouble(self) -> float:
		"""Returns/sets the value of a LayoutParameter object as a double."""
		return self.__ILayoutParameter.ValueAsDouble


	@ValueAsDouble.setter
	def ValueAsDouble(self, value: float):
		"""Returns/sets the value of a LayoutParameter object as a double."""
		self.__ILayoutParameter.ValueAsDouble = value


	@property
	def ValueAsIntVector(self):
		"""Returns/sets the value of an IntVector type LayoutParameter object."""
		return self.__ILayoutParameter.ValueAsIntVector


	@ValueAsIntVector.setter
	def ValueAsIntVector(self, value):
		"""Returns/sets the value of an IntVector type LayoutParameter object."""
		self.__ILayoutParameter.ValueAsIntVector = value


	@property
	def ValueAsInteger(self) -> int:
		"""Returns/sets the value of a LayoutParameter object as an integer."""
		return self.__ILayoutParameter.ValueAsInteger


	@ValueAsInteger.setter
	def ValueAsInteger(self, value: int):
		"""Returns/sets the value of a LayoutParameter object as an integer."""
		self.__ILayoutParameter.ValueAsInteger = value


	@property
	def ValueAsRealVector(self):
		"""Returns/sets the value of a RealVector type LayoutParameter object."""
		return self.__ILayoutParameter.ValueAsRealVector


	@ValueAsRealVector.setter
	def ValueAsRealVector(self, value):
		"""Returns/sets the value of a RealVector type LayoutParameter object."""
		self.__ILayoutParameter.ValueAsRealVector = value


	@property
	def ValueAsString(self) -> str:
		"""Returns/sets the value of a LayoutParameter object as a string."""
		return self.__ILayoutParameter.ValueAsString


	@ValueAsString.setter
	def ValueAsString(self, value: str):
		"""Returns/sets the value of a LayoutParameter object as a string."""
		self.__ILayoutParameter.ValueAsString = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LayoutParameters
class CLayoutParameters:
	"""A collection of MWOffice LayoutParameters objects."""
	def __init__(self, layoutparameters):
		self.__ILayoutParameters = layoutparameters

	def _get_inner(self):
		return self.__ILayoutParameters


	def Add(self, Name: str, Value: float, UnitType: mwUnitType = 17) -> CLayoutParameter:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CLayoutParameter(self.__ILayoutParameters.Add(Name, Value, UnitType))


	def AddString(self, Name: str, Value: str) -> CLayoutParameter:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CLayoutParameter(self.__ILayoutParameters.AddString(Name, Value))


	def AddInteger(self, Name: str, Value: int) -> CLayoutParameter:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CLayoutParameter(self.__ILayoutParameters.AddInteger(Name, Value))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ILayoutParameters.Remove(Index)


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__ILayoutParameters.GetUniqueName(baseName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ILayoutParameters.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ILayoutParameters.Exists(Index)


	def Item(self, Index) -> CLayoutParameter:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLayoutParameter(self.__ILayoutParameters.Item(Index))


	def __get_Item(self, Index) -> CLayoutParameter:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLayoutParameter(self.__ILayoutParameters.Item(Index))


	def __call__(self, index) -> CLayoutParameter:
		return self.__get_Item(index)


	def __iter__(self) -> CLayoutParameter:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ILayoutParameters.Count


	def __getitem__(self, index) -> Union[CLayoutParameter, List[CLayoutParameter]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def ReadOnly(self) -> bool:
		"""Object or collection is readonly and cannot be changed."""
		return self.__ILayoutParameters.ReadOnly


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ObjectName
class CObjectName:
	"""An MWOffice ObjectName object."""
	def __init__(self, objectname):
		self.__IObjectName = objectname

	def _get_inner(self):
		return self.__IObjectName



	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IObjectName.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__IObjectName.Name = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ObjectNames
class CObjectNames:
	"""A collection of MOffice ObjectName objects."""
	def __init__(self, objectnames):
		self.__IObjectNames = objectnames

	def _get_inner(self):
		return self.__IObjectNames



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IObjectNames.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IObjectNames.Exists(Index)


	def Item(self, Index) -> CObjectName:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CObjectName(self.__IObjectNames.Item(Index))


	def __get_Item(self, Index) -> CObjectName:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CObjectName(self.__IObjectNames.Item(Index))


	def __call__(self, index) -> CObjectName:
		return self.__get_Item(index)


	def __iter__(self) -> CObjectName:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IObjectNames.Count


	def __getitem__(self, index) -> Union[CObjectName, List[CObjectName]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ObjectNameMapping
class CObjectNameMapping:
	"""An MWOffice ObjectNameMapping object."""
	def __init__(self, objectnamemapping):
		self.__IObjectNameMapping = objectnamemapping

	def _get_inner(self):
		return self.__IObjectNameMapping



	@property
	def FromName(self) -> str:
		"""Returns/sets the value of the From object name for the mapping."""
		return self.__IObjectNameMapping.FromName


	@FromName.setter
	def FromName(self, value: str):
		"""Returns/sets the value of the From object name for the mapping."""
		self.__IObjectNameMapping.FromName = value


	@property
	def ToName(self) -> str:
		"""Returns/sets the value of the To object name for the mapping."""
		return self.__IObjectNameMapping.ToName


	@ToName.setter
	def ToName(self, value: str):
		"""Returns/sets the value of the To object name for the mapping."""
		self.__IObjectNameMapping.ToName = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ObjectNameMappings
class CObjectNameMappings:
	"""An MWOffice ObjectNameMappings object."""
	def __init__(self, objectnamemappings):
		self.__IObjectNameMappings = objectnamemappings

	def _get_inner(self):
		return self.__IObjectNameMappings


	def Add(self, FromName: str, ToName: str) -> CObjectNameMapping:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CObjectNameMapping(self.__IObjectNameMappings.Add(FromName, ToName))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IObjectNameMappings.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IObjectNameMappings.RemoveAll()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IObjectNameMappings.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IObjectNameMappings.Exists(Index)


	def Item(self, Index) -> CObjectNameMapping:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CObjectNameMapping(self.__IObjectNameMappings.Item(Index))


	def __get_Item(self, Index) -> CObjectNameMapping:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CObjectNameMapping(self.__IObjectNameMappings.Item(Index))


	def __call__(self, index) -> CObjectNameMapping:
		return self.__get_Item(index)


	def __iter__(self) -> CObjectNameMapping:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IObjectNameMappings.Count


	def __getitem__(self, index) -> Union[CObjectNameMapping, List[CObjectNameMapping]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ComplexNumber
class CComplexNumber:
	"""A MWOffice ComplexNumber object."""
	def __init__(self, complexnumber):
		self.__IComplexNumber = complexnumber

	def _get_inner(self):
		return self.__IComplexNumber



	@property
	def Angle(self) -> float:
		"""Returns the angle of the complex number in degrees."""
		return self.__IComplexNumber.Angle


	@property
	def Imaginary(self) -> float:
		"""Returns/sets the imaginary part of the Complex number."""
		return self.__IComplexNumber.Imaginary


	@Imaginary.setter
	def Imaginary(self, value: float):
		"""Returns/sets the imaginary part of the Complex number."""
		self.__IComplexNumber.Imaginary = value


	@property
	def Magnitude(self) -> float:
		"""Returns the magnitude of the complex number."""
		return self.__IComplexNumber.Magnitude


	@property
	def Real(self) -> float:
		"""Returns/sets the real part of the ComplexNumber."""
		return self.__IComplexNumber.Real


	@Real.setter
	def Real(self, value: float):
		"""Returns/sets the real part of the ComplexNumber."""
		self.__IComplexNumber.Real = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ComplexNumbers
class CComplexNumbers:
	"""A collection of MWOffice ComplexNumber objects."""
	def __init__(self, complexnumbers):
		self.__IComplexNumbers = complexnumbers

	def _get_inner(self):
		return self.__IComplexNumbers


	def Add(self, realPart: float, imagPart: float) -> CComplexNumber:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CComplexNumber(self.__IComplexNumbers.Add(realPart, imagPart))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IComplexNumbers.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IComplexNumbers.RemoveAll()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IComplexNumbers.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IComplexNumbers.Exists(Index)


	def Item(self, Index) -> CComplexNumber:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CComplexNumber(self.__IComplexNumbers.Item(Index))


	def __get_Item(self, Index) -> CComplexNumber:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CComplexNumber(self.__IComplexNumbers.Item(Index))


	def __call__(self, index) -> CComplexNumber:
		return self.__get_Item(index)


	def __iter__(self) -> CComplexNumber:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IComplexNumbers.Count


	def __getitem__(self, index) -> Union[CComplexNumber, List[CComplexNumber]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Offset
class COffset:
	"""An MWOffice Offset object."""
	def __init__(self, offset):
		self.__IOffset = offset

	def _get_inner(self):
		return self.__IOffset



	@property
	def dx(self) -> float:
		"""Returns/sets the DX value of a Offset object."""
		return self.__IOffset.dx


	@dx.setter
	def dx(self, value: float):
		"""Returns/sets the DX value of a Offset object."""
		self.__IOffset.dx = value


	@property
	def dy(self) -> float:
		"""Returns/sets the DY value of a Offset object."""
		return self.__IOffset.dy


	@dy.setter
	def dy(self, value: float):
		"""Returns/sets the DY value of a Offset object."""
		self.__IOffset.dy = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Offsets
class COffsets:
	"""A collection of MWOffice Offset objects."""
	def __init__(self, offsets):
		self.__IOffsets = offsets

	def _get_inner(self):
		return self.__IOffsets



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IOffsets.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IOffsets.Exists(Index)


	def Item(self, Index) -> COffset:
		"""Returns a specific item of a Collection object either by position or by key."""
		return COffset(self.__IOffsets.Item(Index))


	def __get_Item(self, Index) -> COffset:
		"""Returns a specific item of a Collection object either by position or by key."""
		return COffset(self.__IOffsets.Item(Index))


	def __call__(self, index) -> COffset:
		return self.__get_Item(index)


	def __iter__(self) -> COffset:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IOffsets.Count


	def __getitem__(self, index) -> Union[COffset, List[COffset]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# point
class Cpoint:
	"""An MWOffice Point object."""
	def __init__(self, point):
		self.__IPoint = point

	def _get_inner(self):
		return self.__IPoint



	@property
	def x(self) -> int:
		"""Returns/sets the X value of a Point object."""
		return self.__IPoint.x


	@x.setter
	def x(self, value: int):
		"""Returns/sets the X value of a Point object."""
		self.__IPoint.x = value


	@property
	def y(self) -> int:
		"""Returns/sets the Y value of a Point object."""
		return self.__IPoint.y


	@y.setter
	def y(self, value: int):
		"""Returns/sets the Y value of a Point object."""
		self.__IPoint.y = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Points
class CPoints:
	"""A collection of MWOffice Point objects."""
	def __init__(self, points):
		self.__IPoints = points

	def _get_inner(self):
		return self.__IPoints



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IPoints.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IPoints.Exists(Index)


	def Item(self, Index) -> Cpoint:
		"""Returns a specific item of a Collection object either by position or by key."""
		return Cpoint(self.__IPoints.Item(Index))


	def __get_Item(self, Index) -> Cpoint:
		"""Returns a specific item of a Collection object either by position or by key."""
		return Cpoint(self.__IPoints.Item(Index))


	def __call__(self, index) -> Cpoint:
		return self.__get_Item(index)


	def __iter__(self) -> Cpoint:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IPoints.Count


	def __getitem__(self, index) -> Union[Cpoint, List[Cpoint]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Size
class CSize:
	"""An MWOffice Size object."""
	def __init__(self, size):
		self.__ISize = size

	def _get_inner(self):
		return self.__ISize



	@property
	def cx(self) -> int:
		"""Returns/sets the X size value of the Size object."""
		return self.__ISize.cx


	@cx.setter
	def cx(self, value: int):
		"""Returns/sets the X size value of the Size object."""
		self.__ISize.cx = value


	@property
	def cy(self) -> int:
		"""Returns/sets the Y size value of the Size object."""
		return self.__ISize.cy


	@cy.setter
	def cy(self, value: int):
		"""Returns/sets the Y size value of the Size object."""
		self.__ISize.cy = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Sizes
class CSizes:
	"""A collection of MWOffice Size objects."""
	def __init__(self, sizes):
		self.__ISizes = sizes

	def _get_inner(self):
		return self.__ISizes



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ISizes.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ISizes.Exists(Index)


	def Item(self, Index) -> CSize:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSize(self.__ISizes.Item(Index))


	def __get_Item(self, Index) -> CSize:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSize(self.__ISizes.Item(Index))


	def __call__(self, index) -> CSize:
		return self.__get_Item(index)


	def __iter__(self) -> CSize:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ISizes.Count


	def __getitem__(self, index) -> Union[CSize, List[CSize]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Vertex
class CVertex:
	"""An MWOffice Vertex object."""
	def __init__(self, vertex):
		self.__IVertex = vertex

	def _get_inner(self):
		return self.__IVertex



	@property
	def x(self) -> float:
		"""Returns/sets the X value of a Vertex object."""
		return self.__IVertex.x


	@x.setter
	def x(self, value: float):
		"""Returns/sets the X value of a Vertex object."""
		self.__IVertex.x = value


	@property
	def y(self) -> float:
		"""Returns/sets the Y value of a Vertex object."""
		return self.__IVertex.y


	@y.setter
	def y(self, value: float):
		"""Returns/sets the Y value of a Vertex object."""
		self.__IVertex.y = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Vertices
class CVertices:
	"""A collection of MWOffice Vertex objects."""
	def __init__(self, vertices):
		self.__IVertices = vertices

	def _get_inner(self):
		return self.__IVertices


	def Add(self, x: float, y: float) -> CVertex:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CVertex(self.__IVertices.Add(x, y))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IVertices.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IVertices.RemoveAll()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IVertices.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IVertices.Exists(Index)


	def Item(self, Index) -> CVertex:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CVertex(self.__IVertices.Item(Index))


	def __get_Item(self, Index) -> CVertex:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CVertex(self.__IVertices.Item(Index))


	def __call__(self, index) -> CVertex:
		return self.__get_Item(index)


	def __iter__(self) -> CVertex:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IVertices.Count


	def __getitem__(self, index) -> Union[CVertex, List[CVertex]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def XYPoints(self):
		"""Returns/sets the the points of a vertices collection as an array of x,y point pairs."""
		return self.__IVertices.XYPoints


	@XYPoints.setter
	def XYPoints(self, value):
		"""Returns/sets the the points of a vertices collection as an array of x,y point pairs."""
		self.__IVertices.XYPoints = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Vertex3D
class CVertex3D:
	"""An MWOffice Vertex3D object."""
	def __init__(self, vertex3d):
		self.__IVertex3D = vertex3d

	def _get_inner(self):
		return self.__IVertex3D



	@property
	def x(self) -> float:
		"""Returns/sets the X value of a Vertex3D object."""
		return self.__IVertex3D.x


	@x.setter
	def x(self, value: float):
		"""Returns/sets the X value of a Vertex3D object."""
		self.__IVertex3D.x = value


	@property
	def y(self) -> float:
		"""Returns/sets the Y value of a Vertex3D object."""
		return self.__IVertex3D.y


	@y.setter
	def y(self, value: float):
		"""Returns/sets the Y value of a Vertex3D object."""
		self.__IVertex3D.y = value


	@property
	def z(self) -> float:
		"""Returns/sets the Z value of a Vertex3D object."""
		return self.__IVertex3D.z


	@z.setter
	def z(self, value: float):
		"""Returns/sets the Z value of a Vertex3D object."""
		self.__IVertex3D.z = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Vector
class CVector:
	"""An MWOffice Vector object."""
	def __init__(self, vector):
		self.__IVector = vector

	def _get_inner(self):
		return self.__IVector



	@property
	def cx(self) -> float:
		"""Returns/sets the CX value of an Vector object."""
		return self.__IVector.cx


	@cx.setter
	def cx(self, value: float):
		"""Returns/sets the CX value of an Vector object."""
		self.__IVector.cx = value


	@property
	def cy(self) -> float:
		"""Returns/sets the CY value of an Vector object."""
		return self.__IVector.cy


	@cy.setter
	def cy(self, value: float):
		"""Returns/sets the CY value of an Vector object."""
		self.__IVector.cy = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Vectors
class CVectors:
	"""A collection of MWOffice Vector objects."""
	def __init__(self, vectors):
		self.__IVectors = vectors

	def _get_inner(self):
		return self.__IVectors



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IVectors.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IVectors.Exists(Index)


	def Item(self, Index) -> CVector:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CVector(self.__IVectors.Item(Index))


	def __get_Item(self, Index) -> CVector:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CVector(self.__IVectors.Item(Index))


	def __call__(self, index) -> CVector:
		return self.__get_Item(index)


	def __iter__(self) -> CVector:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IVectors.Count


	def __getitem__(self, index) -> Union[CVector, List[CVector]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LineSegment
class CLineSegment:
	"""An MWOffice LineSegment object."""
	def __init__(self, linesegment):
		self.__ILineSegment = linesegment

	def _get_inner(self):
		return self.__ILineSegment



	@property
	def Begin(self) -> CVertex:
		"""Returns a reference to a Vertex object."""
		return CVertex(self.__ILineSegment.Begin)


	@property
	def End(self) -> CVertex:
		"""Returns a reference to a Vertex object."""
		return CVertex(self.__ILineSegment.End)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LineSegments
class CLineSegments:
	"""A collection of MWOffice LineSegment objects."""
	def __init__(self, linesegments):
		self.__ILineSegments = linesegments

	def _get_inner(self):
		return self.__ILineSegments


	def Add(self, x1: float, y1: float, x2: float, y2: float) -> CLineSegment:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CLineSegment(self.__ILineSegments.Add(x1, y1, x2, y2))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ILineSegments.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__ILineSegments.RemoveAll()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ILineSegments.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ILineSegments.Exists(Index)


	def Item(self, Index) -> CLineSegment:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLineSegment(self.__ILineSegments.Item(Index))


	def __get_Item(self, Index) -> CLineSegment:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLineSegment(self.__ILineSegments.Item(Index))


	def __call__(self, index) -> CLineSegment:
		return self.__get_Item(index)


	def __iter__(self) -> CLineSegment:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ILineSegments.Count


	def __getitem__(self, index) -> Union[CLineSegment, List[CLineSegment]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# CellInstance
class CCellInstance:
	"""An MWOffice CellInstance object."""
	def __init__(self, cellinstance):
		self.__ICellInstance = cellinstance

	def _get_inner(self):
		return self.__ICellInstance


	def Delete(self) -> bool:
		"""Removes the object."""
		return self.__ICellInstance.Delete()



	@property
	def BasePosition(self) -> CVertex:
		"""Returns a reference to a Vertex object."""
		return CVertex(self.__ICellInstance.BasePosition)


	@property
	def Bound(self) -> bool:
		"""Returns if the instance is bound to a master library cell."""
		return self.__ICellInstance.Bound


	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__ICellInstance.Boundary)


	@property
	def Flipped(self) -> bool:
		"""Returns/sets if the CellInstance object is flipped."""
		return self.__ICellInstance.Flipped


	@Flipped.setter
	def Flipped(self, value: bool):
		"""Returns/sets if the CellInstance object is flipped."""
		self.__ICellInstance.Flipped = value


	@property
	def MasterCell(self) -> str:
		"""Returns the name of the master cell associated with the CellInstance object."""
		return self.__ICellInstance.MasterCell


	@property
	def MasterLibrary(self) -> str:
		"""Returns the name of the master cell library associated with the CellInstance object."""
		return self.__ICellInstance.MasterLibrary


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__ICellInstance.Name


	@property
	def RotationAngle(self) -> float:
		"""Returns/sets the angle in degrees of the CellInstance object."""
		return self.__ICellInstance.RotationAngle


	@RotationAngle.setter
	def RotationAngle(self, value: float):
		"""Returns/sets the angle in degrees of the CellInstance object."""
		self.__ICellInstance.RotationAngle = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# CellInstances
class CCellInstances:
	"""A collection of MWOffice CellInstance objects."""
	def __init__(self, cellinstances):
		self.__ICellInstances = cellinstances

	def _get_inner(self):
		return self.__ICellInstances


	def Add(self, LibraryName: str, CellName: str, x: float, y: float, CCWRotation: float = 0, Flipped: bool = 0) -> CCellInstance:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CCellInstance(self.__ICellInstances.Add(LibraryName, CellName, x, y, CCWRotation, Flipped))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ICellInstances.Remove(Index)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ICellInstances.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ICellInstances.Exists(Index)


	def Item(self, Index) -> CCellInstance:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CCellInstance(self.__ICellInstances.Item(Index))


	def __get_Item(self, Index) -> CCellInstance:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CCellInstance(self.__ICellInstances.Item(Index))


	def __call__(self, index) -> CCellInstance:
		return self.__get_Item(index)


	def __iter__(self) -> CCellInstance:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ICellInstances.Count


	def __getitem__(self, index) -> Union[CCellInstance, List[CCellInstance]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Cell
class CCell:
	"""An MWOffice Cell object."""
	def __init__(self, cell):
		self.__ICell = cell

	def _get_inner(self):
		return self.__ICell


	def Activate(self) -> None:
		"""Activates the objects."""
		self.__ICell.Activate()


	def NewWindow(self) -> CWindow:
		"""Displays the object in new window."""
		return CWindow(self.__ICell.NewWindow())


	def UpdateViews(self) -> bool:
		"""Updates active views associated with the given cell object to display the latest shape edits."""
		return self.__ICell.UpdateViews()


	def EditCell(self) -> CCellEditor:
		"""Returns a reference to a CellEditor object."""
		return CCellEditor(self.__ICell.EditCell())


	def Export(self, Filename: str, format: mwCellExportFormat, bFlat: bool = 0) -> bool:
		"""Exports a design document file from MWOffice."""
		return self.__ICell.Export(Filename, format, bFlat)


	def Flatten(self) -> bool:
		"""Flattens the cell so that all instances in the cell are removed and replaced by their shapes."""
		return self.__ICell.Flatten()


	def Rename(self, NewName: str, Type: mwCellRenameSyncType) -> bool:
		"""Renames the cell to have a new name with options for library updates."""
		return self.__ICell.Rename(NewName, Type)


	def IsStatusBitSet(self, Status: mwCellStatus) -> bool:
		"""Returns if a specific flag bit is set in the cell status field. """
		return self.__ICell.IsStatusBitSet(Status)



	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__ICell.Boundary)


	@property
	def Editors(self) -> CCellEditors:
		"""Returns a reference to a CellEditors collection."""
		return CCellEditors(self.__ICell.Editors)


	@property
	def Info(self) -> CCellInfo:
		"""Returns a reference to a MWOffice CellInfo object."""
		return CCellInfo(self.__ICell.Info)


	@property
	def Instances(self) -> CCellInstances:
		"""Returns a reference to a MWOffice CellInstances collection."""
		return CCellInstances(self.__ICell.Instances)


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__ICell.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__ICell.Name = value


	@property
	def Shapes(self) -> CShapes:
		"""Returns a reference to a collection of Shape objects."""
		return CShapes(self.__ICell.Shapes)


	@property
	def Status(self) -> int:
		"""Returns/Sets the status value associated with this cell."""
		return self.__ICell.Status


	@Status.setter
	def Status(self, value: int):
		"""Returns/Sets the status value associated with this cell."""
		self.__ICell.Status = value


	@property
	def Windows(self) -> CWindows:
		"""Returns a reference to a collection of Window objects."""
		return CWindows(self.__ICell.Windows)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Cells
class CCells:
	"""A collection of MWOffice Cell objects."""
	def __init__(self, cells):
		self.__ICells = cells

	def _get_inner(self):
		return self.__ICells


	def Add(self, CellName: str) -> CCell:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CCell(self.__ICells.Add(CellName))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ICells.Remove(Index)


	def Copy(self, FromLibrary: str, FromCell: str, NewCellName: str = "", FlattenCell: bool = 0) -> CCell:
		"""Copies an object from another object collection into this object collection."""
		return CCell(self.__ICells.Copy(FromLibrary, FromCell, NewCellName, FlattenCell))


	def Copy2(self, FromLibrary: str, FromCell: str, NewCellName: str = "", FlattenCell: bool = 0, CopyChildren: bool = 0) -> CCell:
		"""Copies an object from another object collection into this object collection."""
		return CCell(self.__ICells.Copy2(FromLibrary, FromCell, NewCellName, FlattenCell, CopyChildren))



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ICells.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ICells.Exists(Index)


	def Item(self, Index) -> CCell:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CCell(self.__ICells.Item(Index))


	def __get_Item(self, Index) -> CCell:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CCell(self.__ICells.Item(Index))


	def __call__(self, index) -> CCell:
		return self.__get_Item(index)


	def __iter__(self) -> CCell:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ICells.Count


	def __getitem__(self, index) -> Union[CCell, List[CCell]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# CellLibrary
class CCellLibrary:
	"""An MWOffice Cell Library object."""
	def __init__(self, celllibrary):
		self.__ICellLibrary = celllibrary

	def _get_inner(self):
		return self.__ICellLibrary


	def SaveAs(self, Filename: str) -> None:
		"""Saves the Cell Library under a new filename."""
		self.__ICellLibrary.SaveAs(Filename)


	def Merge(self, libName: str, mergeFlags: int = 0) -> bool:
		"""Merges the named library with this library to form a single library"""
		return self.__ICellLibrary.Merge(libName, mergeFlags)


	def IsStatusBitSet(self, Status: mwCellLibraryStatus) -> bool:
		"""Returns if a specific flag bit is set in the library status field. """
		return self.__ICellLibrary.IsStatusBitSet(Status)


	def Embed(self) -> None:
		"""Converts an externally linked cell library into an embedded library."""
		self.__ICellLibrary.Embed()


	def LinkToFile(self, FilePath: str) -> None:
		"""Converts an embedded cell library into an externally linked library."""
		self.__ICellLibrary.LinkToFile(FilePath)


	def Reload(self) -> None:
		"""Reloads an externally linked cell library."""
		self.__ICellLibrary.Reload()


	def Save(self) -> None:
		"""Updates the externally linked cell library file."""
		self.__ICellLibrary.Save()



	@property
	def Cells(self) -> CCells:
		"""Returns a reference to a collection of Cell objects."""
		return CCells(self.__ICellLibrary.Cells)


	@property
	def DatabaseUnitsPerMeter(self) -> float:
		"""Returns the number of database units per meter."""
		return self.__ICellLibrary.DatabaseUnitsPerMeter


	@property
	def DatabaseUnitsPerUserUnit(self) -> float:
		"""Returns the number of user units per meter."""
		return self.__ICellLibrary.DatabaseUnitsPerUserUnit


	@property
	def Embedded(self) -> bool:
		"""Returns whether the cell library is embedded in the project or linked externally."""
		return self.__ICellLibrary.Embedded


	@property
	def ExcludeFromExport(self) -> bool:
		"""Returns/sets a value which specifies if the Library is excluded from export."""
		return self.__ICellLibrary.ExcludeFromExport


	@ExcludeFromExport.setter
	def ExcludeFromExport(self, value: bool):
		"""Returns/sets a value which specifies if the Library is excluded from export."""
		self.__ICellLibrary.ExcludeFromExport = value


	@property
	def Filename(self) -> str:
		"""Returns the filename of a Cell Library object."""
		return self.__ICellLibrary.Filename


	@Filename.setter
	def Filename(self, value: str):
		"""Returns the filename of a Cell Library object."""
		self.__ICellLibrary.Filename = value


	@property
	def Locked(self) -> bool:
		"""Returns/sets a value which specifies if the Library is locked."""
		return self.__ICellLibrary.Locked


	@Locked.setter
	def Locked(self, value: bool):
		"""Returns/sets a value which specifies if the Library is locked."""
		self.__ICellLibrary.Locked = value


	@property
	def Modified(self) -> bool:
		"""Returns a value which specifies if the Library has been modified."""
		return self.__ICellLibrary.Modified


	@Modified.setter
	def Modified(self, value: bool):
		"""Returns a value which specifies if the Library has been modified."""
		self.__ICellLibrary.Modified = value


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__ICellLibrary.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__ICellLibrary.Name = value


	@property
	def OverrideDatabaseUnit(self) -> bool:
		"""Returns/sets whether the override unit size should be used instead of the internal library unit size."""
		return self.__ICellLibrary.OverrideDatabaseUnit


	@OverrideDatabaseUnit.setter
	def OverrideDatabaseUnit(self, value: bool):
		"""Returns/sets whether the override unit size should be used instead of the internal library unit size."""
		self.__ICellLibrary.OverrideDatabaseUnit = value


	@property
	def OverrideDatabaseUnitSize(self) -> float:
		"""Returns/sets the unit size to be used when override database unit size is enabled."""
		return self.__ICellLibrary.OverrideDatabaseUnitSize


	@OverrideDatabaseUnitSize.setter
	def OverrideDatabaseUnitSize(self, value: float):
		"""Returns/sets the unit size to be used when override database unit size is enabled."""
		self.__ICellLibrary.OverrideDatabaseUnitSize = value


	@property
	def ProcessDefinition(self) -> str:
		"""Returns/sets the name of the process definition to be used with this cell library."""
		return self.__ICellLibrary.ProcessDefinition


	@ProcessDefinition.setter
	def ProcessDefinition(self, value: str):
		"""Returns/sets the name of the process definition to be used with this cell library."""
		self.__ICellLibrary.ProcessDefinition = value


	@property
	def ReadNewest(self) -> bool:
		"""Returns/sets a value which specifies if the Library should read newest cells."""
		return self.__ICellLibrary.ReadNewest


	@ReadNewest.setter
	def ReadNewest(self, value: bool):
		"""Returns/sets a value which specifies if the Library should read newest cells."""
		self.__ICellLibrary.ReadNewest = value


	@property
	def ReplaceAllCells(self) -> bool:
		"""Returns/sets a value which specifies if the Library should replace all cells including modified cells."""
		return self.__ICellLibrary.ReplaceAllCells


	@ReplaceAllCells.setter
	def ReplaceAllCells(self, value: bool):
		"""Returns/sets a value which specifies if the Library should replace all cells including modified cells."""
		self.__ICellLibrary.ReplaceAllCells = value


	@property
	def SearchPriority(self) -> int:
		"""Returns/sets the search priority of the CellLibrary object. Values range from 1 to the number of libraries in the project."""
		return self.__ICellLibrary.SearchPriority


	@SearchPriority.setter
	def SearchPriority(self, value: int):
		"""Returns/sets the search priority of the CellLibrary object. Values range from 1 to the number of libraries in the project."""
		self.__ICellLibrary.SearchPriority = value


	@property
	def Status(self) -> int:
		"""Returns/Sets the status value associated with this cell library."""
		return self.__ICellLibrary.Status


	@Status.setter
	def Status(self, value: int):
		"""Returns/Sets the status value associated with this cell library."""
		self.__ICellLibrary.Status = value


	@property
	def Type(self):
		"""Returns the cell format for a CellLibrary object."""
		return self.__ICellLibrary.Type


	@property
	def UserUnitsPerMeter(self) -> float:
		"""Returns the number of user units per meter."""
		return self.__ICellLibrary.UserUnitsPerMeter


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# CellLibraries
class CCellLibraries:
	"""A collection of MWOffice Cell Library objects."""
	def __init__(self, celllibraries):
		self.__ICellLibraries = celllibraries

	def _get_inner(self):
		return self.__ICellLibraries


	def Add(self, CellLibraryName: str, Type: mwCellLibraryType) -> CCellLibrary:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CCellLibrary(self.__ICellLibraries.Add(CellLibraryName, Type))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ICellLibraries.Remove(Index)


	def Import(self, Name: str, Filename: str, Type: mwCellLibraryType) -> CCellLibrary:
		"""Adds a CellLibrary object to the collection from a file and returns a reference to the created object."""
		return CCellLibrary(self.__ICellLibraries.Import(Name, Filename, Type))


	def Import2(self, Name: str, Filename: str, Type: mwCellLibraryType, DefaultScaleFactor: float = 0) -> CCellLibrary:
		"""Adds a CellLibrary object to the collection from a file and returns a reference to the created object."""
		return CCellLibrary(self.__ICellLibraries.Import2(Name, Filename, Type, DefaultScaleFactor))


	def LinkTo(self, Name: str, Filename: str, Type: mwCellLibraryType) -> CCellLibrary:
		"""Adds a CellLibrary object to the collection linked the library file and returns a reference to the created object."""
		return CCellLibrary(self.__ICellLibraries.LinkTo(Name, Filename, Type))


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__ICellLibraries.GetUniqueName(baseName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ICellLibraries.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ICellLibraries.Exists(Index)


	def Item(self, Index) -> CCellLibrary:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CCellLibrary(self.__ICellLibraries.Item(Index))


	def __get_Item(self, Index) -> CCellLibrary:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CCellLibrary(self.__ICellLibraries.Item(Index))


	def __call__(self, index) -> CCellLibrary:
		return self.__get_Item(index)


	def __iter__(self) -> CCellLibrary:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ICellLibraries.Count


	def __getitem__(self, index) -> Union[CCellLibrary, List[CCellLibrary]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# EMLayerMapEntry
class CEMLayerMapEntry:
	"""An MWOffice EMLayerMapEntry object."""
	def __init__(self, emlayermapentry):
		self.__IEMLayerMapEntry = emlayermapentry

	def _get_inner(self):
		return self.__IEMLayerMapEntry



	@property
	def DrawingLayer(self) -> str:
		"""Returns the drawing layer for the EMLayerMapping object."""
		return self.__IEMLayerMapEntry.DrawingLayer


	@property
	def EMLayer(self) -> int:
		"""Returns/Sets the EM layer index or the EMLayerMapping object."""
		return self.__IEMLayerMapEntry.EMLayer


	@EMLayer.setter
	def EMLayer(self, value: int):
		"""Returns/Sets the EM layer index or the EMLayerMapping object."""
		self.__IEMLayerMapEntry.EMLayer = value


	@property
	def IsVia(self) -> bool:
		"""Returns/Sets a value which determines whether the layer type is a via layer."""
		return self.__IEMLayerMapEntry.IsVia


	@IsVia.setter
	def IsVia(self, value: bool):
		"""Returns/Sets a value which determines whether the layer type is a via layer."""
		self.__IEMLayerMapEntry.IsVia = value


	@property
	def Material(self) -> str:
		"""Returns/Sets the material for the layer for the EMLayerMapping object."""
		return self.__IEMLayerMapEntry.Material


	@Material.setter
	def Material(self, value: str):
		"""Returns/Sets the material for the layer for the EMLayerMapping object."""
		self.__IEMLayerMapEntry.Material = value


	@property
	def ViaExtent(self) -> int:
		"""Returns/Sets the via extent value for the EMLayerMapEntry object."""
		return self.__IEMLayerMapEntry.ViaExtent


	@ViaExtent.setter
	def ViaExtent(self, value: int):
		"""Returns/Sets the via extent value for the EMLayerMapEntry object."""
		self.__IEMLayerMapEntry.ViaExtent = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# EMLayerMapEntries
class CEMLayerMapEntries:
	"""A collection of MWOffice EMLayerMapEntry objects."""
	def __init__(self, emlayermapentries):
		self.__IEMLayerMapEntries = emlayermapentries

	def _get_inner(self):
		return self.__IEMLayerMapEntries



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IEMLayerMapEntries.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IEMLayerMapEntries.Exists(Index)


	def Item(self, Index) -> CEMLayerMapEntry:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CEMLayerMapEntry(self.__IEMLayerMapEntries.Item(Index))


	def __get_Item(self, Index) -> CEMLayerMapEntry:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CEMLayerMapEntry(self.__IEMLayerMapEntries.Item(Index))


	def __call__(self, index) -> CEMLayerMapEntry:
		return self.__get_Item(index)


	def __iter__(self) -> CEMLayerMapEntry:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IEMLayerMapEntries.Count


	def __getitem__(self, index) -> Union[CEMLayerMapEntry, List[CEMLayerMapEntry]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# EMLayerMapping
class CEMLayerMapping:
	"""An MWOffice EMLayerMapping object."""
	def __init__(self, emlayermapping):
		self.__IEMLayerMapping = emlayermapping

	def _get_inner(self):
		return self.__IEMLayerMapping



	@property
	def Active(self) -> bool:
		"""Returns a value which determines if the mapping is the active mapping."""
		return self.__IEMLayerMapping.Active


	@property
	def Entries(self) -> CEMLayerMapEntries:
		"""Returns a reference to a EMLayerMapEntries collection."""
		return CEMLayerMapEntries(self.__IEMLayerMapping.Entries)


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IEMLayerMapping.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__IEMLayerMapping.Name = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# EMLayerMappings
class CEMLayerMappings:
	"""A collection of MWOffice EMLayerMapping objects."""
	def __init__(self, emlayermappings):
		self.__IEMLayerMappings = emlayermappings

	def _get_inner(self):
		return self.__IEMLayerMappings


	def Add(self, Name: str) -> CEMLayerMapping:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CEMLayerMapping(self.__IEMLayerMappings.Add(Name))


	def Remove(self, Key) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IEMLayerMappings.Remove(Key)


	def SetActive(self, Index) -> None:
		"""Sets the mapping identified by index active to be the active EM mapping."""
		self.__IEMLayerMappings.SetActive(Index)


	def Copy(self, Index, NewName: str = "") -> CEMLayerMapping:
		"""Copies the object to the system clipboard."""
		return CEMLayerMapping(self.__IEMLayerMappings.Copy(Index, NewName))


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__IEMLayerMappings.GetUniqueName(baseName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IEMLayerMappings.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IEMLayerMappings.Exists(Index)


	def Item(self, Index) -> CEMLayerMapping:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CEMLayerMapping(self.__IEMLayerMappings.Item(Index))


	def __get_Item(self, Index) -> CEMLayerMapping:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CEMLayerMapping(self.__IEMLayerMappings.Item(Index))


	def __call__(self, index) -> CEMLayerMapping:
		return self.__get_Item(index)


	def __iter__(self) -> CEMLayerMapping:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IEMLayerMappings.Count


	def __getitem__(self, index) -> Union[CEMLayerMapping, List[CEMLayerMapping]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LayerMapEntry
class CLayerMapEntry:
	"""An MWOffice LayerMapEntry object."""
	def __init__(self, layermapentry):
		self.__ILayerMapEntry = layermapentry

	def _get_inner(self):
		return self.__ILayerMapEntry



	@property
	def DrawingLayer(self) -> str:
		"""Returns the drawing layer name for the entry object."""
		return self.__ILayerMapEntry.DrawingLayer


	@DrawingLayer.setter
	def DrawingLayer(self, value: str):
		"""Returns the drawing layer name for the entry object."""
		self.__ILayerMapEntry.DrawingLayer = value


	@property
	def ModelLayer(self) -> str:
		"""Returns the model layer name for the entry object."""
		return self.__ILayerMapEntry.ModelLayer


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LayerMapEntries
class CLayerMapEntries:
	"""A collection of MWOffice LayerMapEntry objects."""
	def __init__(self, layermapentries):
		self.__ILayerMapEntries = layermapentries

	def _get_inner(self):
		return self.__ILayerMapEntries


	def Add(self, ModelLayer: str, DrawingLayer: str) -> CLayerMapEntry:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CLayerMapEntry(self.__ILayerMapEntries.Add(ModelLayer, DrawingLayer))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ILayerMapEntries.Remove(Index)


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__ILayerMapEntries.GetUniqueName(baseName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ILayerMapEntries.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ILayerMapEntries.Exists(Index)


	def Item(self, Index) -> CLayerMapEntry:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLayerMapEntry(self.__ILayerMapEntries.Item(Index))


	def __get_Item(self, Index) -> CLayerMapEntry:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLayerMapEntry(self.__ILayerMapEntries.Item(Index))


	def __call__(self, index) -> CLayerMapEntry:
		return self.__get_Item(index)


	def __iter__(self) -> CLayerMapEntry:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ILayerMapEntries.Count


	def __getitem__(self, index) -> Union[CLayerMapEntry, List[CLayerMapEntry]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LayerMapping
class CLayerMapping:
	"""An MWOffice LayerMapping object."""
	def __init__(self, layermapping):
		self.__ILayerMapping = layermapping

	def _get_inner(self):
		return self.__ILayerMapping



	@property
	def Entries(self) -> CLayerMapEntries:
		"""Returns a reference to a LayerMapEntries collection."""
		return CLayerMapEntries(self.__ILayerMapping.Entries)


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__ILayerMapping.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__ILayerMapping.Name = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LayerMappings
class CLayerMappings:
	"""A collection of MWOffice LayerMapping objects."""
	def __init__(self, layermappings):
		self.__ILayerMappings = layermappings

	def _get_inner(self):
		return self.__ILayerMappings


	def Add(self, Name: str) -> CLayerMapping:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CLayerMapping(self.__ILayerMappings.Add(Name))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ILayerMappings.Remove(Index)


	def Clear(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__ILayerMappings.Clear()


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__ILayerMappings.GetUniqueName(baseName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ILayerMappings.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ILayerMappings.Exists(Index)


	def Item(self, Index) -> CLayerMapping:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLayerMapping(self.__ILayerMappings.Item(Index))


	def __get_Item(self, Index) -> CLayerMapping:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLayerMapping(self.__ILayerMappings.Item(Index))


	def __call__(self, index) -> CLayerMapping:
		return self.__get_Item(index)


	def __iter__(self) -> CLayerMapping:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ILayerMappings.Count


	def __getitem__(self, index) -> Union[CLayerMapping, List[CLayerMapping]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LayerExportEntry
class CLayerExportEntry:
	"""An MWOffice LayerExportEntry object."""
	def __init__(self, layerexportentry):
		self.__ILayerExportEntry = layerexportentry

	def _get_inner(self):
		return self.__ILayerExportEntry



	@property
	def DrawingLayer(self) -> str:
		"""Returns/Sets the drawing layer for the LayerExportEntry object."""
		return self.__ILayerExportEntry.DrawingLayer


	@DrawingLayer.setter
	def DrawingLayer(self, value: str):
		"""Returns/Sets the drawing layer for the LayerExportEntry object."""
		self.__ILayerExportEntry.DrawingLayer = value


	@property
	def ExportDataType(self) -> int:
		"""Returns the export data type number for the LayerExportEntry object."""
		return self.__ILayerExportEntry.ExportDataType


	@ExportDataType.setter
	def ExportDataType(self, value: int):
		"""Returns the export data type number for the LayerExportEntry object."""
		self.__ILayerExportEntry.ExportDataType = value


	@property
	def ExportLayer(self) -> str:
		"""Returns/Sets the export layer for the LayerExportEntry object."""
		return self.__ILayerExportEntry.ExportLayer


	@ExportLayer.setter
	def ExportLayer(self, value: str):
		"""Returns/Sets the export layer for the LayerExportEntry object."""
		self.__ILayerExportEntry.ExportLayer = value


	@property
	def ExportLayerNumber(self) -> int:
		"""Returns the export layer number for the LayerExportEntry object."""
		return self.__ILayerExportEntry.ExportLayerNumber


	@ExportLayerNumber.setter
	def ExportLayerNumber(self, value: int):
		"""Returns the export layer number for the LayerExportEntry object."""
		self.__ILayerExportEntry.ExportLayerNumber = value


	@property
	def WriteLayer(self) -> bool:
		"""Returns/Sets a value which specifies if the layer should be output when exporting."""
		return self.__ILayerExportEntry.WriteLayer


	@WriteLayer.setter
	def WriteLayer(self, value: bool):
		"""Returns/Sets a value which specifies if the layer should be output when exporting."""
		self.__ILayerExportEntry.WriteLayer = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LayerExportEntries
class CLayerExportEntries:
	"""A collection of MWOffice LayerExportEntry objects."""
	def __init__(self, layerexportentries):
		self.__ILayerExportEntries = layerexportentries

	def _get_inner(self):
		return self.__ILayerExportEntries



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ILayerExportEntries.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ILayerExportEntries.Exists(Index)


	def Item(self, Index) -> CLayerExportEntry:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLayerExportEntry(self.__ILayerExportEntries.Item(Index))


	def __get_Item(self, Index) -> CLayerExportEntry:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLayerExportEntry(self.__ILayerExportEntries.Item(Index))


	def __call__(self, index) -> CLayerExportEntry:
		return self.__get_Item(index)


	def __iter__(self) -> CLayerExportEntry:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ILayerExportEntries.Count


	def __getitem__(self, index) -> Union[CLayerExportEntry, List[CLayerExportEntry]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LayerExportMapping
class CLayerExportMapping:
	"""An MWOffice LayerExportMapping object."""
	def __init__(self, layerexportmapping):
		self.__ILayerExportMapping = layerexportmapping

	def _get_inner(self):
		return self.__ILayerExportMapping



	@property
	def Entries(self) -> CLayerExportEntries:
		"""Returns a reference to a LayerMapEntries collection."""
		return CLayerExportEntries(self.__ILayerExportMapping.Entries)


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__ILayerExportMapping.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__ILayerExportMapping.Name = value


	@property
	def Type(self):
		"""Returns/Sets a value which determines the type of the layer export mapping."""
		return self.__ILayerExportMapping.Type


	@Type.setter
	def Type(self, value: mwLayoutExportFormat):
		"""Returns/Sets a value which determines the type of the layer export mapping."""
		self.__ILayerExportMapping.Type = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LayerExportMappings
class CLayerExportMappings:
	"""A collection of MWOffice LayerExportMapping objects."""
	def __init__(self, layerexportmappings):
		self.__ILayerExportMappings = layerexportmappings

	def _get_inner(self):
		return self.__ILayerExportMappings


	def Add(self, Name: str, Type: mwLayoutExportFormat) -> CLayerExportMapping:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CLayerExportMapping(self.__ILayerExportMappings.Add(Name, Type))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ILayerExportMappings.Remove(Index)


	def Clear(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__ILayerExportMappings.Clear()


	def Copy(self, Index, NewName: str = "") -> CLayerExportMapping:
		"""Copies the object to the system clipboard."""
		return CLayerExportMapping(self.__ILayerExportMappings.Copy(Index, NewName))


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__ILayerExportMappings.GetUniqueName(baseName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ILayerExportMappings.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ILayerExportMappings.Exists(Index)


	def Item(self, Index) -> CLayerExportMapping:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLayerExportMapping(self.__ILayerExportMappings.Item(Index))


	def __get_Item(self, Index) -> CLayerExportMapping:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLayerExportMapping(self.__ILayerExportMappings.Item(Index))


	def __call__(self, index) -> CLayerExportMapping:
		return self.__get_Item(index)


	def __iter__(self) -> CLayerExportMapping:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ILayerExportMappings.Count


	def __getitem__(self, index) -> Union[CLayerExportMapping, List[CLayerExportMapping]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LayerConfiguration
class CLayerConfiguration:
	"""An MWOffice LayerConfiguration object."""
	def __init__(self, layerconfiguration):
		self.__ILayerConfiguration = layerconfiguration

	def _get_inner(self):
		return self.__ILayerConfiguration



	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__ILayerConfiguration.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__ILayerConfiguration.Name = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LayerConfigurations
class CLayerConfigurations:
	"""A collection of MWOffice LayerConfiguration objects."""
	def __init__(self, layerconfigurations):
		self.__ILayerConfigurations = layerconfigurations

	def _get_inner(self):
		return self.__ILayerConfigurations


	def Add(self, Name: str) -> CLayerConfiguration:
		"""Saves the current layer state as a user configuration in the current layer setup"""
		return CLayerConfiguration(self.__ILayerConfigurations.Add(Name))


	def Remove(self, Name: str) -> bool:
		"""Removes a user configuration from the current layer setup"""
		return self.__ILayerConfigurations.Remove(Name)


	def Clear(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__ILayerConfigurations.Clear()


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__ILayerConfigurations.GetUniqueName(baseName)


	def Restore(self, ConfigName: str) -> None:
		"""Restores a user configuration from the current layer setup"""
		self.__ILayerConfigurations.Restore(ConfigName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ILayerConfigurations.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ILayerConfigurations.Exists(Index)


	def Item(self, Index) -> CLayerConfiguration:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLayerConfiguration(self.__ILayerConfigurations.Item(Index))


	def __get_Item(self, Index) -> CLayerConfiguration:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLayerConfiguration(self.__ILayerConfigurations.Item(Index))


	def __call__(self, index) -> CLayerConfiguration:
		return self.__get_Item(index)


	def __iter__(self) -> CLayerConfiguration:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ILayerConfigurations.Count


	def __getitem__(self, index) -> Union[CLayerConfiguration, List[CLayerConfiguration]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DrawingLayer
class CDrawingLayer:
	"""An MWOffice Drawing Layer object."""
	def __init__(self, drawinglayer):
		self.__IDrawingLayer = drawinglayer

	def _get_inner(self):
		return self.__IDrawingLayer


	def IsFlagSet(self, __MIDL__IDrawingLayer0000: mwDrawLayerFlags) -> bool:
		"""Returns a value that indicates if the given flag is set on the DrawingLayer object."""
		return self.__IDrawingLayer.IsFlagSet(__MIDL__IDrawingLayer0000)



	@property
	def Blend(self) -> float:
		"""Returns/sets the 3D layer blend level for a DrawingLayer object."""
		return self.__IDrawingLayer.Blend


	@Blend.setter
	def Blend(self, value: float):
		"""Returns/sets the 3D layer blend level for a DrawingLayer object."""
		self.__IDrawingLayer.Blend = value


	@property
	def Blend2D(self) -> float:
		"""Returns/sets the 2D layer blend level for a DrawingLayer object."""
		return self.__IDrawingLayer.Blend2D


	@Blend2D.setter
	def Blend2D(self, value: float):
		"""Returns/sets the 2D layer blend level for a DrawingLayer object."""
		self.__IDrawingLayer.Blend2D = value


	@property
	def Cloak(self) -> bool:
		"""Returns/sets a value indicating if the drawing layer is cloaked."""
		return self.__IDrawingLayer.Cloak


	@Cloak.setter
	def Cloak(self, value: bool):
		"""Returns/sets a value indicating if the drawing layer is cloaked."""
		self.__IDrawingLayer.Cloak = value


	@property
	def Description(self) -> str:
		"""Returns/sets a value associated with the layer intended to provide an extended description of the layer purpose"""
		return self.__IDrawingLayer.Description


	@Description.setter
	def Description(self, value: str):
		"""Returns/sets a value associated with the layer intended to provide an extended description of the layer purpose"""
		self.__IDrawingLayer.Description = value


	@property
	def FillColor(self) -> int:
		"""Returns/sets the value of a color for the Layer object."""
		return self.__IDrawingLayer.FillColor


	@FillColor.setter
	def FillColor(self, value: int):
		"""Returns/sets the value of a color for the Layer object."""
		self.__IDrawingLayer.FillColor = value


	@property
	def FillStyle(self):
		"""Returns/sets a value which specifies the fill style of a Drawing Layer object."""
		return self.__IDrawingLayer.FillStyle


	@FillStyle.setter
	def FillStyle(self, value: mwFillStyle):
		"""Returns/sets a value which specifies the fill style of a Drawing Layer object."""
		self.__IDrawingLayer.FillStyle = value


	@property
	def Filled(self) -> bool:
		"""Returns/sets a value which specifies if the Drawing Layer is filled."""
		return self.__IDrawingLayer.Filled


	@Filled.setter
	def Filled(self, value: bool):
		"""Returns/sets a value which specifies if the Drawing Layer is filled."""
		self.__IDrawingLayer.Filled = value


	@property
	def Flags(self) -> int:
		"""Returns a value which specifies the flags of the Drawing Layer."""
		return self.__IDrawingLayer.Flags


	@property
	def Frozen(self) -> bool:
		"""Returns a value which specifies if the Drawing Layer object is frozen."""
		return self.__IDrawingLayer.Frozen


	@Frozen.setter
	def Frozen(self, value: bool):
		"""Returns a value which specifies if the Drawing Layer object is frozen."""
		self.__IDrawingLayer.Frozen = value


	@property
	def HatchName(self) -> str:
		"""Returns/sets a value associated with the layer to provide a name for the hatch style."""
		return self.__IDrawingLayer.HatchName


	@HatchName.setter
	def HatchName(self, value: str):
		"""Returns/sets a value associated with the layer to provide a name for the hatch style."""
		self.__IDrawingLayer.HatchName = value


	@property
	def LineColor(self) -> int:
		"""Returns/sets the value of a color for the Layer object."""
		return self.__IDrawingLayer.LineColor


	@LineColor.setter
	def LineColor(self, value: int):
		"""Returns/sets the value of a color for the Layer object."""
		self.__IDrawingLayer.LineColor = value


	@property
	def LineStyle(self):
		"""Returns/sets a value which specifies the line style of a Drawing Layer object."""
		return self.__IDrawingLayer.LineStyle


	@LineStyle.setter
	def LineStyle(self, value: mwLineStyle):
		"""Returns/sets a value which specifies the line style of a Drawing Layer object."""
		self.__IDrawingLayer.LineStyle = value


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IDrawingLayer.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__IDrawingLayer.Name = value


	@property
	def Number(self) -> int:
		"""Returns/sets the number of the drawing layer object."""
		return self.__IDrawingLayer.Number


	@Number.setter
	def Number(self, value: int):
		"""Returns/sets the number of the drawing layer object."""
		self.__IDrawingLayer.Number = value


	@property
	def Opaque(self) -> bool:
		"""Returns/sets a value which specifies if the layer is opaque in 3D view."""
		return self.__IDrawingLayer.Opaque


	@Opaque.setter
	def Opaque(self, value: bool):
		"""Returns/sets a value which specifies if the layer is opaque in 3D view."""
		self.__IDrawingLayer.Opaque = value


	@property
	def Opaque2D(self) -> bool:
		"""Returns/sets a value which specifies if the layer is opaque in 2D view."""
		return self.__IDrawingLayer.Opaque2D


	@Opaque2D.setter
	def Opaque2D(self, value: bool):
		"""Returns/sets a value which specifies if the layer is opaque in 2D view."""
		self.__IDrawingLayer.Opaque2D = value


	@property
	def SystemLayer(self) -> bool:
		"""Returns a value which specifies if the Drawing Layer is a system layer. System layers cannot be removed."""
		return self.__IDrawingLayer.SystemLayer


	@property
	def TextureFile(self) -> str:
		"""Returns/sets the name of the file for the texture of a DrawingLayer object."""
		return self.__IDrawingLayer.TextureFile


	@TextureFile.setter
	def TextureFile(self, value: str):
		"""Returns/sets the name of the file for the texture of a DrawingLayer object."""
		self.__IDrawingLayer.TextureFile = value


	@property
	def TextureScale(self) -> float:
		"""Returns/sets the 3D layer texture scale for a DrawingLayer object."""
		return self.__IDrawingLayer.TextureScale


	@TextureScale.setter
	def TextureScale(self, value: float):
		"""Returns/sets the 3D layer texture scale for a DrawingLayer object."""
		self.__IDrawingLayer.TextureScale = value


	@property
	def Thickness(self) -> float:
		"""Returns/sets the 3D layer thickness for a DrawingLayer object."""
		return self.__IDrawingLayer.Thickness


	@Thickness.setter
	def Thickness(self, value: float):
		"""Returns/sets the 3D layer thickness for a DrawingLayer object."""
		self.__IDrawingLayer.Thickness = value


	@property
	def Visible(self) -> bool:
		"""Returns/sets a value which specifies if the Drawing Layer is visible."""
		return self.__IDrawingLayer.Visible


	@Visible.setter
	def Visible(self, value: bool):
		"""Returns/sets a value which specifies if the Drawing Layer is visible."""
		self.__IDrawingLayer.Visible = value


	@property
	def ZPosition(self) -> float:
		"""Returns/sets the 3D layer Z-Position for a DrawingLayer object."""
		return self.__IDrawingLayer.ZPosition


	@ZPosition.setter
	def ZPosition(self, value: float):
		"""Returns/sets the 3D layer Z-Position for a DrawingLayer object."""
		self.__IDrawingLayer.ZPosition = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DrawingLayers
class CDrawingLayers:
	"""A collection of MWOffice Drawing Layer objects."""
	def __init__(self, drawinglayers):
		self.__IDrawingLayers = drawinglayers

	def _get_inner(self):
		return self.__IDrawingLayers


	def Remove(self, Name: str) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IDrawingLayers.Remove(Name)


	def RemoveAll(self) -> bool:
		"""Removes all non-system drawing layers"""
		return self.__IDrawingLayers.RemoveAll()


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__IDrawingLayers.GetUniqueName(baseName)


	def Add2(self, Name: str, LineColor: int = 255, LineStyle: mwLineStyle = 0, Filled: bool = -1, FillColor: int = 255, FillStyle: mwFillStyle = 1, Thickness: float = 0, ZPosition: float = 0, Opaque2D: bool = -1, Opaque3D: bool = -1, Blend2D: float = 0, Blend3D: float = 0) -> CDrawingLayer:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CDrawingLayer(self.__IDrawingLayers.Add2(Name, LineColor, LineStyle, Filled, FillColor, FillStyle, Thickness, ZPosition, Opaque2D, Opaque3D, Blend2D, Blend3D))



	@property
	def ActiveLayer(self) -> CDrawingLayer:
		"""Returns the active drawing layer object."""
		return CDrawingLayer(self.__IDrawingLayers.ActiveLayer)


	@ActiveLayer.setter
	def ActiveLayer(self, value: CDrawingLayer):
		"""Returns the active drawing layer object."""
		self.__IDrawingLayers.ActiveLayer = value


	@property
	def ActiveLayerName(self) -> str:
		"""Returns/sets the active drawing layer name."""
		return self.__IDrawingLayers.ActiveLayerName


	@ActiveLayerName.setter
	def ActiveLayerName(self, value: str):
		"""Returns/sets the active drawing layer name."""
		self.__IDrawingLayers.ActiveLayerName = value


	@property
	def AllFilled(self) -> bool:
		"""Returns/sets a value indicating if all layers are filled."""
		return self.__IDrawingLayers.AllFilled


	@AllFilled.setter
	def AllFilled(self, value: bool):
		"""Returns/sets a value indicating if all layers are filled."""
		self.__IDrawingLayers.AllFilled = value


	@property
	def AllFrozen(self) -> bool:
		"""Returns/sets a value indicating if all layers are frozen."""
		return self.__IDrawingLayers.AllFrozen


	@AllFrozen.setter
	def AllFrozen(self, value: bool):
		"""Returns/sets a value indicating if all layers are frozen."""
		self.__IDrawingLayers.AllFrozen = value


	@property
	def AllVisible(self) -> bool:
		"""Returns/sets a value indicating if all layers are visible."""
		return self.__IDrawingLayers.AllVisible


	@AllVisible.setter
	def AllVisible(self, value: bool):
		"""Returns/sets a value indicating if all layers are visible."""
		self.__IDrawingLayers.AllVisible = value


	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IDrawingLayers.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IDrawingLayers.Exists(Index)


	def Item(self, Index) -> CDrawingLayer:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingLayer(self.__IDrawingLayers.Item(Index))


	def __get_Item(self, Index) -> CDrawingLayer:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingLayer(self.__IDrawingLayers.Item(Index))


	def __call__(self, index) -> CDrawingLayer:
		return self.__get_Item(index)


	def __iter__(self) -> CDrawingLayer:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IDrawingLayers.Count


	def __getitem__(self, index) -> Union[CDrawingLayer, List[CDrawingLayer]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def UseActiveLayer(self) -> bool:
		"""Returns/sets a value indicating if the active layer should be used or the active line type."""
		return self.__IDrawingLayers.UseActiveLayer


	@UseActiveLayer.setter
	def UseActiveLayer(self, value: bool):
		"""Returns/sets a value indicating if the active layer should be used or the active line type."""
		self.__IDrawingLayers.UseActiveLayer = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# FillPattern
class CFillPattern:
	"""An MWOffice FillPattern object."""
	def __init__(self, fillpattern):
		self.__IFillPattern = fillpattern

	def _get_inner(self):
		return self.__IFillPattern


	def SetPattern(self, Width: int, Height: int, bitString: str) -> bool:
		"""Allows the pattern to set to new values for width, height and pattern bits. System patterns cannot be changed."""
		return self.__IFillPattern.SetPattern(Width, Height, bitString)



	@property
	def Height(self) -> int:
		"""Returns a value indicating the height of the FillPattern object."""
		return self.__IFillPattern.Height


	@property
	def IsSystem(self) -> bool:
		"""Returns if the fill pattern is a system pattern."""
		return self.__IFillPattern.IsSystem


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IFillPattern.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__IFillPattern.Name = value


	@property
	def Pattern(self) -> str:
		"""Returns a string with the bits of the fill pattern object."""
		return self.__IFillPattern.Pattern


	@property
	def Width(self) -> int:
		"""Returns a value indicating the width of the FillPattern object."""
		return self.__IFillPattern.Width


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# FillPatterns
class CFillPatterns:
	"""A collection of MWOffice FillPattern objects."""
	def __init__(self, fillpatterns):
		self.__IFillPatterns = fillpatterns

	def _get_inner(self):
		return self.__IFillPatterns


	def Add(self, Name: str, Width: int, Height: int, bitString: str) -> CFillPattern:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CFillPattern(self.__IFillPatterns.Add(Name, Width, Height, bitString))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IFillPatterns.Remove(Index)


	def Clear(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IFillPatterns.Clear()


	def Copy(self, Index, Name: str) -> CFillPattern:
		"""Copies the object to the system clipboard."""
		return CFillPattern(self.__IFillPatterns.Copy(Index, Name))



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IFillPatterns.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IFillPatterns.Exists(Index)


	def Item(self, Index) -> CFillPattern:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CFillPattern(self.__IFillPatterns.Item(Index))


	def __get_Item(self, Index) -> CFillPattern:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CFillPattern(self.__IFillPatterns.Item(Index))


	def __call__(self, index) -> CFillPattern:
		return self.__get_Item(index)


	def __iter__(self) -> CFillPattern:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IFillPatterns.Count


	def __getitem__(self, index) -> Union[CFillPattern, List[CFillPattern]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LayerSetup
class CLayerSetup:
	"""An MWOffice LayerSetup object."""
	def __init__(self, layersetup):
		self.__ILayerSetup = layersetup

	def _get_inner(self):
		return self.__ILayerSetup



	@property
	def DrawingLayers(self) -> CDrawingLayers:
		"""Returns a reference to a collection of Drawing Layer objects."""
		return CDrawingLayers(self.__ILayerSetup.DrawingLayers)


	@property
	def DrillTools(self) -> CDrillTools:
		"""Returns a reference to a collection of DrillTool objects."""
		return CDrillTools(self.__ILayerSetup.DrillTools)


	@property
	def EMLayerMappings(self) -> CEMLayerMappings:
		"""Returns a reference to a EMLayerMappings collection."""
		return CEMLayerMappings(self.__ILayerSetup.EMLayerMappings)


	@property
	def FillPatterns(self) -> CFillPatterns:
		"""Returns a reference to a MWOffice FillPatterns collection."""
		return CFillPatterns(self.__ILayerSetup.FillPatterns)


	@property
	def LayerConfigurations(self) -> CLayerConfigurations:
		"""Returns a reference to a LayerConfigurations collection."""
		return CLayerConfigurations(self.__ILayerSetup.LayerConfigurations)


	@property
	def LayerExportMappings(self) -> CLayerExportMappings:
		"""Returns a reference to a LayerExportMappings collection."""
		return CLayerExportMappings(self.__ILayerSetup.LayerExportMappings)


	@property
	def LayerMappings(self) -> CLayerMappings:
		"""Returns a reference to a LayerMappings collection."""
		return CLayerMappings(self.__ILayerSetup.LayerMappings)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DrillTool
class CDrillTool:
	"""An MWOffice DrillTool object."""
	def __init__(self, drilltool):
		self.__IDrillTool = drilltool

	def _get_inner(self):
		return self.__IDrillTool



	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IDrillTool.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__IDrillTool.Name = value


	@property
	def Number(self) -> int:
		"""Returns/sets the number of a DrillTool object."""
		return self.__IDrillTool.Number


	@Number.setter
	def Number(self, value: int):
		"""Returns/sets the number of a DrillTool object."""
		self.__IDrillTool.Number = value


	@property
	def Radius(self) -> float:
		"""Returns/sets the radius of a DrillTool object."""
		return self.__IDrillTool.Radius


	@Radius.setter
	def Radius(self, value: float):
		"""Returns/sets the radius of a DrillTool object."""
		self.__IDrillTool.Radius = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DrillTools
class CDrillTools:
	"""A collection of MWOffice DrillTool objects."""
	def __init__(self, drilltools):
		self.__IDrillTools = drilltools

	def _get_inner(self):
		return self.__IDrillTools


	def Add(self, Name: str, Number: int = 1, Radius: float = 9.99999974737875E-05) -> CDrillTool:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CDrillTool(self.__IDrillTools.Add(Name, Number, Radius))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IDrillTools.Remove(Index)


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__IDrillTools.GetUniqueName(baseName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IDrillTools.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IDrillTools.Exists(Index)


	def Item(self, Index) -> CDrillTool:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrillTool(self.__IDrillTools.Item(Index))


	def __get_Item(self, Index) -> CDrillTool:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrillTool(self.__IDrillTools.Item(Index))


	def __call__(self, index) -> CDrillTool:
		return self.__get_Item(index)


	def __iter__(self) -> CDrillTool:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IDrillTools.Count


	def __getitem__(self, index) -> Union[CDrillTool, List[CDrillTool]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ModifierDefDrawingObjects
class CModifierDefDrawingObjects:
	"""A collection of DrawingObject objects."""
	def __init__(self, modifierdefdrawingobjects):
		self.__IModifierDefDrawingObjects = modifierdefdrawingobjects

	def _get_inner(self):
		return self.__IModifierDefDrawingObjects


	def Add(self, pObj: CDrawingObject) -> bool:
		"""Adds an object to the collection and returns a reference to the created object."""
		return self.__IModifierDefDrawingObjects.Add(pObj._get_inner())


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IModifierDefDrawingObjects.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IModifierDefDrawingObjects.RemoveAll()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IModifierDefDrawingObjects.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IModifierDefDrawingObjects.Exists(Index)


	def Item(self, Index) -> CDrawingObject:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingObject(self.__IModifierDefDrawingObjects.Item(Index))


	def __get_Item(self, Index) -> CDrawingObject:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingObject(self.__IModifierDefDrawingObjects.Item(Index))


	def __call__(self, index) -> CDrawingObject:
		return self.__get_Item(index)


	def __iter__(self) -> CDrawingObject:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IModifierDefDrawingObjects.Count


	def __getitem__(self, index) -> Union[CDrawingObject, List[CDrawingObject]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ModifierDefRecord
class CModifierDefRecord:
	"""A MWOffice ModifierDefRecord object."""
	def __init__(self, modifierdefrecord):
		self.__IModifierDefRecord = modifierdefrecord

	def _get_inner(self):
		return self.__IModifierDefRecord



	@property
	def Attributes(self) -> CAttributes:
		"""Returns a reference to a collection of Attribute objects."""
		return CAttributes(self.__IModifierDefRecord.Attributes)


	@property
	def ModifyObjects(self) -> CModifierDefDrawingObjects:
		"""Returns a reference to a ModifierDefDrawingObjects collection."""
		return CModifierDefDrawingObjects(self.__IModifierDefRecord.ModifyObjects)


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IModifierDefRecord.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__IModifierDefRecord.Name = value


	@property
	def ParamFramePosX(self) -> float:
		"""Returns/sets the x coordinate for the placement of the parameter frame when the modifier is created."""
		return self.__IModifierDefRecord.ParamFramePosX


	@ParamFramePosX.setter
	def ParamFramePosX(self, value: float):
		"""Returns/sets the x coordinate for the placement of the parameter frame when the modifier is created."""
		self.__IModifierDefRecord.ParamFramePosX = value


	@property
	def ParamFramePosY(self) -> float:
		"""Returns/sets the y coordinate for the placement of the parameter frame when the modifier is created."""
		return self.__IModifierDefRecord.ParamFramePosY


	@ParamFramePosY.setter
	def ParamFramePosY(self, value: float):
		"""Returns/sets the y coordinate for the placement of the parameter frame when the modifier is created."""
		self.__IModifierDefRecord.ParamFramePosY = value


	@property
	def ShapeVertices(self) -> CVertices:
		"""Returns a reference to a collection of Vertex objects."""
		return CVertices(self.__IModifierDefRecord.ShapeVertices)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ModifierDefRecords
class CModifierDefRecords:
	"""A collection of ModifierDefRecord objects."""
	def __init__(self, modifierdefrecords):
		self.__IModifierDefRecords = modifierdefrecords

	def _get_inner(self):
		return self.__IModifierDefRecords



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IModifierDefRecords.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IModifierDefRecords.Exists(Index)


	def Item(self, Index) -> CModifierDefRecord:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CModifierDefRecord(self.__IModifierDefRecords.Item(Index))


	def __get_Item(self, Index) -> CModifierDefRecord:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CModifierDefRecord(self.__IModifierDefRecords.Item(Index))


	def __call__(self, index) -> CModifierDefRecord:
		return self.__get_Item(index)


	def __iter__(self) -> CModifierDefRecord:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IModifierDefRecords.Count


	def __getitem__(self, index) -> Union[CModifierDefRecord, List[CModifierDefRecord]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ShapeModifierRecord
class CShapeModifierRecord:
	"""A MWOffice ShapeModifierRecord object."""
	def __init__(self, shapemodifierrecord):
		self.__IShapeModifierRecord = shapemodifierrecord

	def _get_inner(self):
		return self.__IShapeModifierRecord



	@property
	def Description(self) -> str:
		"""Returns a description of the ShapeModifier created by this ShapeModifierRecord object."""
		return self.__IShapeModifierRecord.Description


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IShapeModifierRecord.Name


	@property
	def ParameterDefinitions(self) -> CParameterDefinitions:
		"""Returns a reference to a collection of ParameterDefinition objects."""
		return CParameterDefinitions(self.__IShapeModifierRecord.ParameterDefinitions)


	@property
	def Version(self) -> int:
		"""Returns the version of the ShapeModifier created by this ShapeModifierRecord object."""
		return self.__IShapeModifierRecord.Version


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ShapeModifierRecords
class CShapeModifierRecords:
	"""A collection of MWOffice ShapeModfierRecordObjects."""
	def __init__(self, shapemodifierrecords):
		self.__IShapeModifierRecords = shapemodifierrecords

	def _get_inner(self):
		return self.__IShapeModifierRecords



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IShapeModifierRecords.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IShapeModifierRecords.Exists(Index)


	def Item(self, Index) -> CShapeModifierRecord:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CShapeModifierRecord(self.__IShapeModifierRecords.Item(Index))


	def __get_Item(self, Index) -> CShapeModifierRecord:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CShapeModifierRecord(self.__IShapeModifierRecords.Item(Index))


	def __call__(self, index) -> CShapeModifierRecord:
		return self.__get_Item(index)


	def __iter__(self) -> CShapeModifierRecord:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IShapeModifierRecords.Count


	def __getitem__(self, index) -> Union[CShapeModifierRecord, List[CShapeModifierRecord]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ShapeModifier
class CShapeModifier:
	"""A MWOffice ShapeModifier object."""
	def __init__(self, shapemodifier):
		self.__IShapeModifier = shapemodifier

	def _get_inner(self):
		return self.__IShapeModifier



	@property
	def Attributes(self) -> CAttributes:
		"""Returns a reference to a collection of Attribute objects."""
		return CAttributes(self.__IShapeModifier.Attributes)


	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__IShapeModifier.Boundary)


	def DisplayMode(self, mode: mwDisplayModeType) -> bool:
		"""Returns/sets various ShapeModifier display mode settings."""
		return self.__IShapeModifier.DisplayMode(mode)


	def SetDisplayMode(self, mode: mwDisplayModeType, value: bool):
		"""Returns/sets various ShapeModifier display mode settings."""
		self.__IShapeModifier.DisplayMode = value


	@property
	def Enabled(self) -> bool:
		"""Returns/sets if the ShapeModifer object is enabled."""
		return self.__IShapeModifier.Enabled


	@Enabled.setter
	def Enabled(self, value: bool):
		"""Returns/sets if the ShapeModifer object is enabled."""
		self.__IShapeModifier.Enabled = value


	@property
	def GeneratedObjects(self) -> CDrawingObjects:
		"""Returns a reference to a collection of DrawingObjects."""
		return CDrawingObjects(self.__IShapeModifier.GeneratedObjects)


	@property
	def GraphicObject(self) -> CDrawingObject:
		"""Returns a reference to a DrawingObject."""
		return CDrawingObject(self.__IShapeModifier.GraphicObject)


	@property
	def HasError(self) -> bool:
		"""Returns if the ShapeModifier object is in an error state."""
		return self.__IShapeModifier.HasError


	@property
	def MessageId(self) -> int:
		"""Returns the message id for this ShapeModifier object."""
		return self.__IShapeModifier.MessageId


	@property
	def ModifyObjects(self) -> CDrawingObjects:
		"""Returns a reference to a collection of DrawingObjects."""
		return CDrawingObjects(self.__IShapeModifier.ModifyObjects)


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IShapeModifier.Name


	@property
	def OrderIndex(self) -> int:
		"""Returns/sets the order index for this ShapeModifier object."""
		return self.__IShapeModifier.OrderIndex


	@OrderIndex.setter
	def OrderIndex(self, value: int):
		"""Returns/sets the order index for this ShapeModifier object."""
		self.__IShapeModifier.OrderIndex = value


	@property
	def ParameterFrame(self) -> CLayoutParameterFrame:
		"""Returns a reference to a ParameterFrame object."""
		return CLayoutParameterFrame(self.__IShapeModifier.ParameterFrame)


	@property
	def Parameters(self) -> CParameters:
		"""Returns a reference to a collection of Parameter objects."""
		return CParameters(self.__IShapeModifier.Parameters)


	@property
	def Priority(self):
		"""Returns the priority level for this ShapeModifier object."""
		return self.__IShapeModifier.Priority


	@property
	def Record(self) -> CShapeModifierRecord:
		"""Returns a reference to a ShapeModifierRecord object."""
		return CShapeModifierRecord(self.__IShapeModifier.Record)


	@property
	def Selected(self) -> bool:
		"""Returns/sets if the ShapeModifier object is selected."""
		return self.__IShapeModifier.Selected


	@Selected.setter
	def Selected(self, value: bool):
		"""Returns/sets if the ShapeModifier object is selected."""
		self.__IShapeModifier.Selected = value


	@property
	def Size(self) -> float:
		"""Returns/sets a value which affects the size of the modifier object symbol or arrows."""
		return self.__IShapeModifier.Size


	@Size.setter
	def Size(self, value: float):
		"""Returns/sets a value which affects the size of the modifier object symbol or arrows."""
		self.__IShapeModifier.Size = value


	@property
	def Type(self):
		"""Returns the type of the ShapeModifier object."""
		return self.__IShapeModifier.Type


	@property
	def Vertices(self) -> CVertices:
		"""Returns a reference to a collection of Vertex objects."""
		return CVertices(self.__IShapeModifier.Vertices)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ShapeModifiers
class CShapeModifiers:
	"""A collection of MWOffice ShapeModifier objects."""
	def __init__(self, shapemodifiers):
		self.__IShapeModifiers = shapemodifiers

	def _get_inner(self):
		return self.__IShapeModifiers


	def CreateModifierDefRecord(self, Type: str) -> CModifierDefRecord:
		"""Creates and returns a shape modifier record for creating a specific type of shape modifier."""
		return CModifierDefRecord(self.__IShapeModifiers.CreateModifierDefRecord(Type))


	def Add(self, pDef: CModifierDefRecord) -> CShapeModifier:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CShapeModifier(self.__IShapeModifiers.Add(pDef._get_inner()))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IShapeModifiers.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IShapeModifiers.RemoveAll()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IShapeModifiers.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IShapeModifiers.Exists(Index)


	def Item(self, Index) -> CShapeModifier:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CShapeModifier(self.__IShapeModifiers.Item(Index))


	def __get_Item(self, Index) -> CShapeModifier:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CShapeModifier(self.__IShapeModifiers.Item(Index))


	def __call__(self, index) -> CShapeModifier:
		return self.__get_Item(index)


	def __iter__(self) -> CShapeModifier:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IShapeModifiers.Count


	def __getitem__(self, index) -> Union[CShapeModifier, List[CShapeModifier]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DesignRule
class CDesignRule:
	"""An MWOffice DesignRule object."""
	def __init__(self, designrule):
		self.__IDesignRule = designrule

	def _get_inner(self):
		return self.__IDesignRule



	@property
	def Enable(self) -> bool:
		"""Returns a value that determines if the design rule is evaluated during a design rule check"""
		return self.__IDesignRule.Enable


	@Enable.setter
	def Enable(self, value: bool):
		"""Returns a value that determines if the design rule is evaluated during a design rule check"""
		self.__IDesignRule.Enable = value


	@property
	def GroupRules(self) -> CDesignRules:
		"""Returns a reference to a collection of GroupRules objects."""
		return CDesignRules(self.__IDesignRule.GroupRules)


	@property
	def IsGroup(self) -> bool:
		"""Returns a value that determines if the design rule represents a group of rules."""
		return self.__IDesignRule.IsGroup


	@property
	def Rule(self) -> str:
		"""Returns the design rule string."""
		return self.__IDesignRule.Rule


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DesignRules
class CDesignRules:
	"""A collection of MWOffice DesignRule objects."""
	def __init__(self, designrules):
		self.__IDesignRules = designrules

	def _get_inner(self):
		return self.__IDesignRules


	def Add(self, Rule: str, Enable: bool = -1) -> CDesignRule:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CDesignRule(self.__IDesignRules.Add(Rule, Enable))


	def AddGroup(self, GroupName: str, Enable: bool = -1) -> CDesignRule:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CDesignRule(self.__IDesignRules.AddGroup(GroupName, Enable))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IDesignRules.Remove(Index)


	def RemoveAll(self) -> None:
		"""Removes all objects in a collection."""
		self.__IDesignRules.RemoveAll()


	def Import(self, FilePath: str) -> bool:
		"""Adds an object to the collection from a file and returns a reference to the created object."""
		return self.__IDesignRules.Import(FilePath)


	def ImportDefaultRules(self) -> bool:
		"""Adds an object to the collection from a file and returns a reference to the created object."""
		return self.__IDesignRules.ImportDefaultRules()


	def Export(self, FilePath: str, Flags: int = 0) -> bool:
		"""Exports a design document file from MWOffice."""
		return self.__IDesignRules.Export(FilePath, Flags)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IDesignRules.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IDesignRules.Exists(Index)


	def Item(self, Index) -> CDesignRule:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDesignRule(self.__IDesignRules.Item(Index))


	def __get_Item(self, Index) -> CDesignRule:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDesignRule(self.__IDesignRules.Item(Index))


	def __call__(self, index) -> CDesignRule:
		return self.__get_Item(index)


	def __iter__(self) -> CDesignRule:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IDesignRules.Count


	def __getitem__(self, index) -> Union[CDesignRule, List[CDesignRule]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DesignRuleError
class CDesignRuleError:
	"""An MWOffice DesignRuleError object."""
	def __init__(self, designruleerror):
		self.__IDesignRuleError = designruleerror

	def _get_inner(self):
		return self.__IDesignRuleError



	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__IDesignRuleError.Boundary)


	@property
	def CategoryText(self) -> str:
		"""Returns the category string associated with the DesignRuleError object."""
		return self.__IDesignRuleError.CategoryText


	@property
	def Code(self) -> int:
		"""Returns the raw value of a design rule error code defined by the object."""
		return self.__IDesignRuleError.Code


	@property
	def Color(self) -> int:
		"""Returns/sets the color used to highlight the DesignRuleError shapes in the layout."""
		return self.__IDesignRuleError.Color


	@Color.setter
	def Color(self, value: int):
		"""Returns/sets the color used to highlight the DesignRuleError shapes in the layout."""
		self.__IDesignRuleError.Color = value


	@property
	def MessageText(self) -> str:
		"""Returns the message string associated with the DesignRuleError object."""
		return self.__IDesignRuleError.MessageText


	@property
	def Shapes(self) -> CDRCErrorShapes:
		"""Returns a reference to a collection of Vertex objects."""
		return CDRCErrorShapes(self.__IDesignRuleError.Shapes)


	@property
	def Type(self):
		"""Returns a value that specifies the type of the DesignRuleErorr object."""
		return self.__IDesignRuleError.Type


	@property
	def state(self):
		"""Returns/sets a value which specifies the DesignRuleError state"""
		return self.__IDesignRuleError.state


	@state.setter
	def state(self, value: mwDesignRuleState):
		"""Returns/sets a value which specifies the DesignRuleError state"""
		self.__IDesignRuleError.state = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DesignRuleErrors
class CDesignRuleErrors:
	"""A collection of MWOffice DesignRuleError objects."""
	def __init__(self, designruleerrors):
		self.__IDesignRuleErrors = designruleerrors

	def _get_inner(self):
		return self.__IDesignRuleErrors


	def Add(self, ErrorCategory: str, ErrorMessage: str, ErrorType: mwDesignRuleType, ErrorState: mwDesignRuleState, XYPoints) -> CDesignRuleError:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CDesignRuleError(self.__IDesignRuleErrors.Add(ErrorCategory, ErrorMessage, ErrorType, ErrorState, XYPoints))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IDesignRuleErrors.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IDesignRuleErrors.RemoveAll()


	def Load(self, ErrorFile: str, fileFormat: mwDesignRuleErrorFileFormat) -> None:
		"""Reads in the specified DRC error file and adds the errors to the DesignRuleErrors collection (does not clear errors first.)"""
		self.__IDesignRuleErrors.Load(ErrorFile, fileFormat)


	def Save(self, ErrorFile: str) -> None:
		"""Saves the errors in the DesignRuleErrors collection to the specified file name in AWR DRC error format."""
		self.__IDesignRuleErrors.Save(ErrorFile)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IDesignRuleErrors.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IDesignRuleErrors.Exists(Index)


	def Item(self, Index) -> CDesignRuleError:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDesignRuleError(self.__IDesignRuleErrors.Item(Index))


	def __get_Item(self, Index) -> CDesignRuleError:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDesignRuleError(self.__IDesignRuleErrors.Item(Index))


	def __call__(self, index) -> CDesignRuleError:
		return self.__get_Item(index)


	def __iter__(self) -> CDesignRuleError:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IDesignRuleErrors.Count


	def __getitem__(self, index) -> Union[CDesignRuleError, List[CDesignRuleError]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LVSError
class CLVSError:
	"""An MWOffice LVSError object."""
	def __init__(self, lvserror):
		self.__ILVSError = lvserror

	def _get_inner(self):
		return self.__ILVSError



	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__ILVSError.Boundary)


	@property
	def Color(self) -> int:
		"""Returns/sets the color used to highlight the LVSError shapes in the layout and schematic."""
		return self.__ILVSError.Color


	@Color.setter
	def Color(self, value: int):
		"""Returns/sets the color used to highlight the LVSError shapes in the layout and schematic."""
		self.__ILVSError.Color = value


	@property
	def Message(self) -> str:
		"""Returns the message string associated with the LVSError object."""
		return self.__ILVSError.Message


	@property
	def NetlistHighlights(self) -> CLVSNetHighlights:
		"""Returns a reference to a collection of NetlistHighlights."""
		return CLVSNetHighlights(self.__ILVSError.NetlistHighlights)


	@property
	def SchematicHighlights(self) -> CLVSSchemHighlights:
		"""Returns a reference to a collection of SchematicHighlights."""
		return CLVSSchemHighlights(self.__ILVSError.SchematicHighlights)


	@property
	def Shapes(self) -> CDRCErrorShapes:
		"""Returns a reference to a collection of Vertex objects."""
		return CDRCErrorShapes(self.__ILVSError.Shapes)


	@property
	def state(self):
		"""Returns/sets a value which specifies the LVSError state"""
		return self.__ILVSError.state


	@state.setter
	def state(self, value: mwDesignRuleState):
		"""Returns/sets a value which specifies the LVSError state"""
		self.__ILVSError.state = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LVSErrors
class CLVSErrors:
	"""A collection of MWOffice LVSError objects."""
	def __init__(self, lvserrors):
		self.__ILVSErrors = lvserrors

	def _get_inner(self):
		return self.__ILVSErrors


	def Add(self, ErrorCategory: str, ErrorMessage: str, ErrorState: mwDesignRuleState) -> CLVSError:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CLVSError(self.__ILVSErrors.Add(ErrorCategory, ErrorMessage, ErrorState))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ILVSErrors.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__ILVSErrors.RemoveAll()


	def Load(self, ErrorFile: str) -> None:
		"""Reads in the specified LVS error file and adds the errors to the LVSErrors collection (does not clear errors first.)"""
		self.__ILVSErrors.Load(ErrorFile)


	def Save(self, ErrorFile: str) -> None:
		"""Saves the errors in the LVSErrors collection to the specified file name in AWR error format."""
		self.__ILVSErrors.Save(ErrorFile)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ILVSErrors.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ILVSErrors.Exists(Index)


	def Item(self, Index) -> CLVSError:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLVSError(self.__ILVSErrors.Item(Index))


	def __get_Item(self, Index) -> CLVSError:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLVSError(self.__ILVSErrors.Item(Index))


	def __call__(self, index) -> CLVSError:
		return self.__get_Item(index)


	def __iter__(self) -> CLVSError:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ILVSErrors.Count


	def __getitem__(self, index) -> Union[CLVSError, List[CLVSError]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LVSSchemHighlight
class CLVSSchemHighlight:
	"""An MWOffice SchematicHighlight object."""
	def __init__(self, lvsschemhighlight):
		self.__ILVSSchemHighlight = lvsschemhighlight

	def _get_inner(self):
		return self.__ILVSSchemHighlight



	@property
	def HighlightLocation(self):
		"""Returns/Sets the HighlightLoc value associated with the MWOffice SchematicHighlight object."""
		return self.__ILVSSchemHighlight.HighlightLocation


	@HighlightLocation.setter
	def HighlightLocation(self, value: mwLVSHighlightLoc):
		"""Returns/Sets the HighlightLoc value associated with the MWOffice SchematicHighlight object."""
		self.__ILVSSchemHighlight.HighlightLocation = value


	@property
	def ItemID(self) -> str:
		"""Returns/Sets the ItemID string associated with the MWOffice SchematicHighlight object."""
		return self.__ILVSSchemHighlight.ItemID


	@ItemID.setter
	def ItemID(self, value: str):
		"""Returns/Sets the ItemID string associated with the MWOffice SchematicHighlight object."""
		self.__ILVSSchemHighlight.ItemID = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LVSSchemHighlights
class CLVSSchemHighlights:
	"""A collection of MWOffice SchematicHighlights objects."""
	def __init__(self, lvsschemhighlights):
		self.__ILVSSchemHighlights = lvsschemhighlights

	def _get_inner(self):
		return self.__ILVSSchemHighlights


	def Add(self, ItemID: str, HighlightLocation: mwLVSHighlightLoc) -> CLVSSchemHighlight:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CLVSSchemHighlight(self.__ILVSSchemHighlights.Add(ItemID, HighlightLocation))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ILVSSchemHighlights.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__ILVSSchemHighlights.RemoveAll()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ILVSSchemHighlights.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ILVSSchemHighlights.Exists(Index)


	def Item(self, Index) -> CLVSSchemHighlight:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLVSSchemHighlight(self.__ILVSSchemHighlights.Item(Index))


	def __get_Item(self, Index) -> CLVSSchemHighlight:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLVSSchemHighlight(self.__ILVSSchemHighlights.Item(Index))


	def __call__(self, index) -> CLVSSchemHighlight:
		return self.__get_Item(index)


	def __iter__(self) -> CLVSSchemHighlight:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ILVSSchemHighlights.Count


	def __getitem__(self, index) -> Union[CLVSSchemHighlight, List[CLVSSchemHighlight]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LVSNetHighlight
class CLVSNetHighlight:
	"""An MWOffice NetlistHighlight object."""
	def __init__(self, lvsnethighlight):
		self.__ILVSNetHighlight = lvsnethighlight

	def _get_inner(self):
		return self.__ILVSNetHighlight



	@property
	def HighlightString(self) -> str:
		"""Returns/Sets a string to highlight for an MWOffice NetlistHighlight object."""
		return self.__ILVSNetHighlight.HighlightString


	@HighlightString.setter
	def HighlightString(self, value: str):
		"""Returns/Sets a string to highlight for an MWOffice NetlistHighlight object."""
		self.__ILVSNetHighlight.HighlightString = value


	@property
	def NetlistDisplayName(self) -> str:
		"""Returns/Sets a display name for the netlist associated with the MWOffice NetlistHighlight object."""
		return self.__ILVSNetHighlight.NetlistDisplayName


	@NetlistDisplayName.setter
	def NetlistDisplayName(self, value: str):
		"""Returns/Sets a display name for the netlist associated with the MWOffice NetlistHighlight object."""
		self.__ILVSNetHighlight.NetlistDisplayName = value


	@property
	def NetlistPath(self) -> str:
		"""Returns/Sets the full file path string associated with the MWOffice NetlistHighlight object."""
		return self.__ILVSNetHighlight.NetlistPath


	@NetlistPath.setter
	def NetlistPath(self, value: str):
		"""Returns/Sets the full file path string associated with the MWOffice NetlistHighlight object."""
		self.__ILVSNetHighlight.NetlistPath = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LVSNetHighlights
class CLVSNetHighlights:
	"""A collection of MWOffice NetlistHighlight objects."""
	def __init__(self, lvsnethighlights):
		self.__ILVSNetHighlights = lvsnethighlights

	def _get_inner(self):
		return self.__ILVSNetHighlights


	def Add(self, NetlistPath: str, NetlistDisplayName: str, HighlightString: str) -> CLVSNetHighlight:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CLVSNetHighlight(self.__ILVSNetHighlights.Add(NetlistPath, NetlistDisplayName, HighlightString))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ILVSNetHighlights.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__ILVSNetHighlights.RemoveAll()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ILVSNetHighlights.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ILVSNetHighlights.Exists(Index)


	def Item(self, Index) -> CLVSNetHighlight:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLVSNetHighlight(self.__ILVSNetHighlights.Item(Index))


	def __get_Item(self, Index) -> CLVSNetHighlight:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLVSNetHighlight(self.__ILVSNetHighlights.Item(Index))


	def __call__(self, index) -> CLVSNetHighlight:
		return self.__get_Item(index)


	def __iter__(self) -> CLVSNetHighlight:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ILVSNetHighlights.Count


	def __getitem__(self, index) -> Union[CLVSNetHighlight, List[CLVSNetHighlight]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DesignRuleChecker
class CDesignRuleChecker:
	"""An MWOffice DesignRuleChecker object."""
	def __init__(self, designrulechecker):
		self.__IDesignRuleChecker = designrulechecker

	def _get_inner(self):
		return self.__IDesignRuleChecker


	def CreateRuleSet(self) -> CDesignRules:
		"""Creates a collection of rules for a design rule check run."""
		return CDesignRules(self.__IDesignRuleChecker.CreateRuleSet())


	def RunCheck(self, Rules: CDesignRules) -> bool:
		"""Runs a design rule check on the layout associated with the design rule checker"""
		return self.__IDesignRuleChecker.RunCheck(Rules._get_inner())


	def CompareLayoutToGDSFile(self, pGdsFileName: str, pCompareFlattened: bool) -> bool:
		"""Compares the layout associated with this design rule checker with a specified GDSII file."""
		return self.__IDesignRuleChecker.CompareLayoutToGDSFile(pGdsFileName, pCompareFlattened)


	def CompareLayoutToGDSFileEx(self, pGdsFileName: str, fileMap, pCompareFlattened: bool) -> bool:
		"""Compares the layout associated with this design rule checker with the specified GDSII file using the specified export mapping."""
		return self.__IDesignRuleChecker.CompareLayoutToGDSFileEx(pGdsFileName, fileMap, pCompareFlattened)



	@property
	def DesignName(self) -> str:
		"""Returns/sets a string containing the name of the layout checked in the last DRC run."""
		return self.__IDesignRuleChecker.DesignName


	@DesignName.setter
	def DesignName(self, value: str):
		"""Returns/sets a string containing the name of the layout checked in the last DRC run."""
		self.__IDesignRuleChecker.DesignName = value


	@property
	def Errors(self) -> CDesignRuleErrors:
		"""Returns a reference to a collection of DesignRuleError objects."""
		return CDesignRuleErrors(self.__IDesignRuleChecker.Errors)


	@property
	def ErrorsWindow(self) -> CDRCErrorsWindow:
		"""Returns a reference to the DRCErrorsWindow object."""
		return CDRCErrorsWindow(self.__IDesignRuleChecker.ErrorsWindow)


	@property
	def LastRunDateTime(self) -> str:
		"""Returns/sets a string containing the date and time of the last DRC run."""
		return self.__IDesignRuleChecker.LastRunDateTime


	@LastRunDateTime.setter
	def LastRunDateTime(self, value: str):
		"""Returns/sets a string containing the date and time of the last DRC run."""
		self.__IDesignRuleChecker.LastRunDateTime = value


	@property
	def RuleDeckName(self) -> str:
		"""Returns/sets a string containing the name of the rule deck used for the last DRC run."""
		return self.__IDesignRuleChecker.RuleDeckName


	@RuleDeckName.setter
	def RuleDeckName(self, value: str):
		"""Returns/sets a string containing the name of the rule deck used for the last DRC run."""
		self.__IDesignRuleChecker.RuleDeckName = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LayoutVsSchematicChecker
class CLayoutVsSchematicChecker:
	"""An MWOffice LayoutVsSchematicChecker object."""
	def __init__(self, layoutvsschematicchecker):
		self.__ILayoutVsSchematicChecker = layoutvsschematicchecker

	def _get_inner(self):
		return self.__ILayoutVsSchematicChecker


	def RunConnectivityCheck(self) -> bool:
		"""Runs the connectivity checker and reports any errors to the LVS Errors Window"""
		return self.__ILayoutVsSchematicChecker.RunConnectivityCheck()



	@property
	def DesignName(self) -> str:
		"""Returns/sets a string containing the name of the layout/schematic checked in the last LVS run."""
		return self.__ILayoutVsSchematicChecker.DesignName


	@DesignName.setter
	def DesignName(self, value: str):
		"""Returns/sets a string containing the name of the layout/schematic checked in the last LVS run."""
		self.__ILayoutVsSchematicChecker.DesignName = value


	@property
	def Errors(self) -> CLVSErrors:
		"""Returns a reference to a collection of LVSError objects."""
		return CLVSErrors(self.__ILayoutVsSchematicChecker.Errors)


	@property
	def ErrorsWindow(self) -> CLVSErrorsWindow:
		"""Returns a reference to the LVSErrorsWindow object."""
		return CLVSErrorsWindow(self.__ILayoutVsSchematicChecker.ErrorsWindow)


	@property
	def LastRunDateTime(self) -> str:
		"""Returns/sets a string containing the date and time of the last LVS run."""
		return self.__ILayoutVsSchematicChecker.LastRunDateTime


	@LastRunDateTime.setter
	def LastRunDateTime(self, value: str):
		"""Returns/sets a string containing the date and time of the last LVS run."""
		self.__ILayoutVsSchematicChecker.LastRunDateTime = value


	@property
	def RuleDeckName(self) -> str:
		"""Returns/sets a string containing the name of the rule deck used for the last LVS run."""
		return self.__ILayoutVsSchematicChecker.RuleDeckName


	@RuleDeckName.setter
	def RuleDeckName(self, value: str):
		"""Returns/sets a string containing the name of the rule deck used for the last LVS run."""
		self.__ILayoutVsSchematicChecker.RuleDeckName = value


	@property
	def SimConfigName(self) -> str:
		"""Returns/sets a string containing the name of the simulation configuration used for the last LVS run."""
		return self.__ILayoutVsSchematicChecker.SimConfigName


	@SimConfigName.setter
	def SimConfigName(self, value: str):
		"""Returns/sets a string containing the name of the simulation configuration used for the last LVS run."""
		self.__ILayoutVsSchematicChecker.SimConfigName = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DRCErrorsWindow
class CDRCErrorsWindow:
	"""An MWOffice DRCErrorsWindow object."""
	def __init__(self, drcerrorswindow):
		self.__IDRCErrorsWindow = drcerrorswindow

	def _get_inner(self):
		return self.__IDRCErrorsWindow



	@property
	def Title(self) -> str:
		"""Returns/sets the window title for the DRC errors window."""
		return self.__IDRCErrorsWindow.Title


	@Title.setter
	def Title(self, value: str):
		"""Returns/sets the window title for the DRC errors window."""
		self.__IDRCErrorsWindow.Title = value


	@property
	def Visible(self) -> bool:
		"""Returns/sets a value which specifies the visibility of a DRCErrorsWindow object."""
		return self.__IDRCErrorsWindow.Visible


	@Visible.setter
	def Visible(self, value: bool):
		"""Returns/sets a value which specifies the visibility of a DRCErrorsWindow object."""
		self.__IDRCErrorsWindow.Visible = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LVSErrorsWindow
class CLVSErrorsWindow:
	"""An MWOffice DRCErrorsWindow object."""
	def __init__(self, lvserrorswindow):
		self.__ILVSErrorsWindow = lvserrorswindow

	def _get_inner(self):
		return self.__ILVSErrorsWindow



	@property
	def Title(self) -> str:
		"""Returns/sets the window title for the LVS errors window."""
		return self.__ILVSErrorsWindow.Title


	@Title.setter
	def Title(self, value: str):
		"""Returns/sets the window title for the LVS errors window."""
		self.__ILVSErrorsWindow.Title = value


	@property
	def Visible(self) -> bool:
		"""Returns/sets a value which specifies the visibility of a LVSErrorsWindow object."""
		return self.__ILVSErrorsWindow.Visible


	@Visible.setter
	def Visible(self, value: bool):
		"""Returns/sets a value which specifies the visibility of a LVSErrorsWindow object."""
		self.__ILVSErrorsWindow.Visible = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DRCErrorShape
class CDRCErrorShape:
	"""An MWOffice DRCErrorShape object, for use with DRC/LVS error types that have multiple shapes (like mwDRT_MultiPolygon)"""
	def __init__(self, drcerrorshape):
		self.__IDRCErrorShape = drcerrorshape

	def _get_inner(self):
		return self.__IDRCErrorShape



	@property
	def Vertices(self) -> CVertices:
		"""Returns a reference to a collection of Vertex objects."""
		return CVertices(self.__IDRCErrorShape.Vertices)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DRCErrorShapes
class CDRCErrorShapes:
	"""A collection of MWOffice DRCErrorShape objects."""
	def __init__(self, drcerrorshapes):
		self.__IDRCErrorShapes = drcerrorshapes

	def _get_inner(self):
		return self.__IDRCErrorShapes


	def AddPolygon(self, XYPoints) -> CDRCErrorShape:
		"""Adds a polygon shape to the DRCErrorShapes collection."""
		return CDRCErrorShape(self.__IDRCErrorShapes.AddPolygon(XYPoints))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IDRCErrorShapes.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IDRCErrorShapes.RemoveAll()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IDRCErrorShapes.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IDRCErrorShapes.Exists(Index)


	def Item(self, Index) -> CDRCErrorShape:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDRCErrorShape(self.__IDRCErrorShapes.Item(Index))


	def __get_Item(self, Index) -> CDRCErrorShape:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDRCErrorShape(self.__IDRCErrorShapes.Item(Index))


	def __call__(self, index) -> CDRCErrorShape:
		return self.__get_Item(index)


	def __iter__(self) -> CDRCErrorShape:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IDRCErrorShapes.Count


	def __getitem__(self, index) -> Union[CDRCErrorShape, List[CDRCErrorShape]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ConnectivityHighlighter
class CConnectivityHighlighter:
	"""An MWOffice ConnectivityHighlighter object."""
	def __init__(self, connectivityhighlighter):
		self.__IConnectivityHighlighter = connectivityhighlighter

	def _get_inner(self):
		return self.__IConnectivityHighlighter


	def HighlightAll(self) -> bool:
		"""Turns on highlight for all connectivity in the associated layout design."""
		return self.__IConnectivityHighlighter.HighlightAll()


	def HighlightShape(self, pObj: CDrawingObject, Color: int) -> bool:
		"""Turns on highlight for connectivity associated with the given DrawingObject in the associated layout design."""
		return self.__IConnectivityHighlighter.HighlightShape(pObj._get_inner(), Color)


	def HighlightProbe(self, x: float, y: float, Color: int) -> bool:
		"""Turns on highlight for connectivity for shapes associated with a specific probe location in the associated layout design."""
		return self.__IConnectivityHighlighter.HighlightProbe(x, y, Color)


	def HighlightOff(self) -> bool:
		"""Turns off highlight for all connectivity in the associated layout design."""
		return self.__IConnectivityHighlighter.HighlightOff()


	def HighlightSelectedOff(self) -> bool:
		"""Turns off highlight for connectivity for selected shapes in the associated layout design."""
		return self.__IConnectivityHighlighter.HighlightSelectedOff()



	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DrawingObject
class CDrawingObject:
	"""An MWOffice DrawingObject."""
	def __init__(self, drawingobject):
		self.__IDrawingObject = drawingobject

	def _get_inner(self):
		return self.__IDrawingObject


	def Move(self, dx: float, dy: float, CCWRotation: float = 0, Flip: bool = 0, FlipHorizontal: bool = 0, xOrigin: float = 0, yOrigin: float = 0) -> bool:
		"""Moves the DrawingObject by the given values relative to the current location."""
		return self.__IDrawingObject.Move(dx, dy, CCWRotation, Flip, FlipHorizontal, xOrigin, yOrigin)


	def Delete(self) -> bool:
		"""Removes the object."""
		return self.__IDrawingObject.Delete()


	def ResizeObject(self) -> None:
		"""Updates the size and position of the drawing object within the layout."""
		self.__IDrawingObject.ResizeObject()


	def Copy(self, x: float, y: float) -> bool:
		"""Create a copy of the drawing object located at the specified x and y location."""
		return self.__IDrawingObject.Copy(x, y)


	def Flatten(self, FlattenLevel: int = 65000, mergePosNegLayers: bool = 0) -> CShapes:
		"""Flattens the drawing object into a collection of shapes returns a reference to the resulting shapes in the design."""
		return CShapes(self.__IDrawingObject.Flatten(FlattenLevel, mergePosNegLayers))


	def IsTypeBitSet2(self, typeBit: mwObjectSelectFilters) -> bool:
		"""Returns a value that indicates if this drawing object has a specific type bit set, these include specific flags for Polygon, Path, and Circle"""
		return self.__IDrawingObject.IsTypeBitSet2(typeBit)



	@property
	def Attributes(self) -> CAttributes:
		"""Returns a reference to a collection of Attribute objects."""
		return CAttributes(self.__IDrawingObject.Attributes)


	@property
	def BasePosition(self) -> CVertex:
		"""Returns a reference to a Vertex object."""
		return CVertex(self.__IDrawingObject.BasePosition)


	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__IDrawingObject.Boundary)


	@property
	def Cell(self) -> CCell:
		"""Returns a reference to a Cell object."""
		return CCell(self.__IDrawingObject.Cell)


	def DisplayMode(self, mode: mwDisplayModeType) -> bool:
		"""Returns/sets various DrawingObject display mode settings."""
		return self.__IDrawingObject.DisplayMode(mode)


	def SetDisplayMode(self, mode: mwDisplayModeType, value: bool):
		"""Returns/sets various DrawingObject display mode settings."""
		self.__IDrawingObject.DisplayMode = value


	@property
	def EMPorts(self) -> CEMPorts:
		"""Returns a reference to an EMPorts collection."""
		return CEMPorts(self.__IDrawingObject.EMPorts)


	@property
	def EditHandles(self) -> CEditHandles:
		"""Returns a reference to a collection of MWOffice EditHandle objects."""
		return CEditHandles(self.__IDrawingObject.EditHandles)


	@property
	def Element(self) -> CElement:
		"""Returns a reference to an Element object."""
		return CElement(self.__IDrawingObject.Element)


	@property
	def Faces(self) -> CFaces:
		"""Returns a reference to a collection of Face objects."""
		return CFaces(self.__IDrawingObject.Faces)


	@property
	def Flipped(self) -> bool:
		"""Returns/sets a value which specifies if the DrawingObject is flipped."""
		return self.__IDrawingObject.Flipped


	@Flipped.setter
	def Flipped(self, value: bool):
		"""Returns/sets a value which specifies if the DrawingObject is flipped."""
		self.__IDrawingObject.Flipped = value


	@property
	def Frozen(self) -> bool:
		"""Returns/sets a value which specifies if the DrawingObject is frozen."""
		return self.__IDrawingObject.Frozen


	@Frozen.setter
	def Frozen(self, value: bool):
		"""Returns/sets a value which specifies if the DrawingObject is frozen."""
		self.__IDrawingObject.Frozen = value


	@property
	def Group(self) -> bool:
		"""Returns if the drawing object is a group of drawing objects."""
		return self.__IDrawingObject.Group


	@property
	def GroupObjects(self) -> CGroupDrawingObjects:
		"""Returns a reference to a collection of MWOffice GroupDrawingObject objects."""
		return CGroupDrawingObjects(self.__IDrawingObject.GroupObjects)


	@property
	def HasCell(self) -> bool:
		"""Returns a value that indicates if this drawing object has a child cell."""
		return self.__IDrawingObject.HasCell


	@property
	def HasElement(self) -> bool:
		"""Returns a value that indicates if this drawing object has a parent element."""
		return self.__IDrawingObject.HasElement


	@property
	def InfoText(self) -> str:
		"""Returns the DrawingObject information text describing the object."""
		return self.__IDrawingObject.InfoText


	@property
	def InfoTextEx(self) -> str:
		"""Returns the detailed DrawingObject information text describing the object."""
		return self.__IDrawingObject.InfoTextEx


	@property
	def IsElementObject(self) -> bool:
		"""Returns if the DrawingObject is associated with an element object in schematic."""
		return self.__IDrawingObject.IsElementObject


	@property
	def LayerMapping(self) -> str:
		"""Returns/sets a value which specifies the name of the layer mapping applied to this DrawingObject"""
		return self.__IDrawingObject.LayerMapping


	@LayerMapping.setter
	def LayerMapping(self, value: str):
		"""Returns/sets a value which specifies the name of the layer mapping applied to this DrawingObject"""
		self.__IDrawingObject.LayerMapping = value


	@property
	def MarkedNegative(self) -> bool:
		"""Returns/sets if the shape is marked as a negative layer shape."""
		return self.__IDrawingObject.MarkedNegative


	@MarkedNegative.setter
	def MarkedNegative(self, value: bool):
		"""Returns/sets if the shape is marked as a negative layer shape."""
		self.__IDrawingObject.MarkedNegative = value


	@property
	def NetName(self) -> str:
		"""Returns/sets the shape network name associated with this DrawingObject."""
		return self.__IDrawingObject.NetName


	@NetName.setter
	def NetName(self, value: str):
		"""Returns/sets the shape network name associated with this DrawingObject."""
		self.__IDrawingObject.NetName = value


	@property
	def NetType(self):
		"""Returns/sets the shape network type associated with this DrawingObject."""
		return self.__IDrawingObject.NetType


	@NetType.setter
	def NetType(self, value: mwShapeNetType):
		"""Returns/sets the shape network type associated with this DrawingObject."""
		self.__IDrawingObject.NetType = value


	@property
	def PCBPinName(self) -> str:
		"""Returns/sets the PCB pin name associated with this DrawingObject."""
		return self.__IDrawingObject.PCBPinName


	@PCBPinName.setter
	def PCBPinName(self, value: str):
		"""Returns/sets the PCB pin name associated with this DrawingObject."""
		self.__IDrawingObject.PCBPinName = value


	@property
	def PCBPinObject(self) -> bool:
		"""Returns/sets if the shape is marked as a PCB pin object."""
		return self.__IDrawingObject.PCBPinObject


	@PCBPinObject.setter
	def PCBPinObject(self, value: bool):
		"""Returns/sets if the shape is marked as a PCB pin object."""
		self.__IDrawingObject.PCBPinObject = value


	@property
	def Parameters(self) -> CLayoutParameters:
		"""Returns a reference to a collection of LayoutParameter objects"""
		return CLayoutParameters(self.__IDrawingObject.Parameters)


	@property
	def RotationAngle(self) -> float:
		"""Returns/sets the rotation angle of the DrawingObject."""
		return self.__IDrawingObject.RotationAngle


	@RotationAngle.setter
	def RotationAngle(self, value: float):
		"""Returns/sets the rotation angle of the DrawingObject."""
		self.__IDrawingObject.RotationAngle = value


	@property
	def Route(self) -> CRoute:
		"""Returns a reference to a MWOffice Route object."""
		return CRoute(self.__IDrawingObject.Route)


	@property
	def Segments(self) -> CDrawingSegments:
		"""Returns a reference to a collection of MWOffice DrawingSegment objects."""
		return CDrawingSegments(self.__IDrawingObject.Segments)


	@property
	def Selected(self) -> bool:
		"""Returns/sets a value which specifies if a DrawingObject is selected."""
		return self.__IDrawingObject.Selected


	@Selected.setter
	def Selected(self, value: bool):
		"""Returns/sets a value which specifies if a DrawingObject is selected."""
		self.__IDrawingObject.Selected = value


	@property
	def Shapes(self) -> CShapes:
		"""Returns a reference to a collection of Shape objects."""
		return CShapes(self.__IDrawingObject.Shapes)


	@property
	def SubObjects(self) -> CDrawingSubObjects:
		"""Returns a reference to a collection of MWOffice DrawingSubObject objects."""
		return CDrawingSubObjects(self.__IDrawingObject.SubObjects)


	@property
	def TypeBits2(self) -> int:
		"""Returns flags describing the DrawingObject type, these include specific flags for Polygon, Path, and Circle."""
		return self.__IDrawingObject.TypeBits2


	@property
	def UserNetName(self) -> str:
		"""Returns/sets the user net name associated with this DrawingObject."""
		return self.__IDrawingObject.UserNetName


	@UserNetName.setter
	def UserNetName(self, value: str):
		"""Returns/sets the user net name associated with this DrawingObject."""
		self.__IDrawingObject.UserNetName = value


	@property
	def Vertices(self) -> CVertices:
		"""Returns a reference to a collection of Vertex objects."""
		return CVertices(self.__IDrawingObject.Vertices)


	@property
	def Visible(self) -> bool:
		"""Returns if the drawing object has shapes which are on visible layers."""
		return self.__IDrawingObject.Visible


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DrawingObjects
class CDrawingObjects:
	"""A collection of MWOffice DrawingObjects."""
	def __init__(self, drawingobjects):
		self.__IDrawingObjects = drawingobjects

	def _get_inner(self):
		return self.__IDrawingObjects


	def AddRectangle(self, x: float, y: float, dx: float, dy: float, LayerName: str = "", UseProcessLayers: bool = 0, LayerMapping: str = "") -> CDrawingObject:
		"""Adds a rectangle object to DrawingObjects collection."""
		return CDrawingObject(self.__IDrawingObjects.AddRectangle(x, y, dx, dy, LayerName, UseProcessLayers, LayerMapping))


	def AddPolygon(self, XYPoints, LayerName: str = "", UseProcessLayers: bool = 0, LayerMapping: str = "") -> CDrawingObject:
		"""Adds a polygon object to the DrawingObjects collection."""
		return CDrawingObject(self.__IDrawingObjects.AddPolygon(XYPoints, LayerName, UseProcessLayers, LayerMapping))


	def AddPath(self, XYPoints, Width: float, EndStyle: mwPathEndType = 1, MiterStyle: mwPathMiterType = 1, OffsetMiterAmount: float = 0, LayerName: str = "", UseProcessLayers: bool = 0, LayerMapping: str = "") -> CDrawingObject:
		"""Adds a path object to the DrawingObjects collection."""
		return CDrawingObject(self.__IDrawingObjects.AddPath(XYPoints, Width, EndStyle, MiterStyle, OffsetMiterAmount, LayerName, UseProcessLayers, LayerMapping))


	def AddEllipse(self, x: float, y: float, dx: float, dy: float, LayerName: str = "", UseProcessLayers: bool = 0, LayerMapping: str = "") -> CDrawingObject:
		"""Adds an ellipse object to the DrawingObject collection."""
		return CDrawingObject(self.__IDrawingObjects.AddEllipse(x, y, dx, dy, LayerName, UseProcessLayers, LayerMapping))


	def AddDrillHole(self, x: float, y: float, ToolName: str) -> CDrawingObject:
		"""Adds a drill hole object to the DrawingObjects collection."""
		return CDrawingObject(self.__IDrawingObjects.AddDrillHole(x, y, ToolName))


	def AddText(self, x: float, y: float, Height: float, Text: str, RotationAngle: float = 0, Flipped: bool = 0, FontName: str = "", Bold: bool = 0, Italic: bool = 0, DrawAsPolygons: bool = -1, LayerName: str = "", UseProcessLayers: bool = 0, LayerMapping: str = "") -> CDrawingObject:
		"""Adds a text object to the DrawingObjects collection."""
		return CDrawingObject(self.__IDrawingObjects.AddText(x, y, Height, Text, RotationAngle, Flipped, FontName, Bold, Italic, DrawAsPolygons, LayerName, UseProcessLayers, LayerMapping))


	def AddCell(self, LibraryName: str, CellName: str, x: float, y: float, RotationAngle: float = 0, Flipped: bool = 0) -> CDrawingObject:
		"""Adds a cell object to the DrawingObjects collection."""
		return CDrawingObject(self.__IDrawingObjects.AddCell(LibraryName, CellName, x, y, RotationAngle, Flipped))


	def AddDimensionLine(self, x1: float, y1: float, x2: float, y2: float, x3: float, y3: float, ArrowSize: float = 0, TextLocation: mwDimensionTextLocation = 0, ArrowLocation: mwDimensionArrowLocation = 0, FontName: str = "Arial", FontHeight: float = 0, DisplayPrecision: int = 1, ShowUnits: bool = 0, ShowTolorance: bool = 0, ToleranceLength: int = 0) -> CDrawingObject:
		"""Adds a dimension line to the DrawingObjects collection."""
		return CDrawingObject(self.__IDrawingObjects.AddDimensionLine(x1, y1, x2, y2, x3, y3, ArrowSize, TextLocation, ArrowLocation, FontName, FontHeight, DisplayPrecision, ShowUnits, ShowTolorance, ToleranceLength))


	def AddLayoutRuler(self, x1: float, y1: float, x2: float, y2: float, Gap: float = 4.99999987368938E-06, TickHeight: float = 1.49999996210681E-05, TickLocation: mwLayoutRulerTickLocation = -1, DisplayPrecision: int = 1, Spacing: float = 2.99999992421363E-05, ShowUnits: bool = 0, FontName: str = "Arial", FontHeight: float = 2.49999993684469E-05, FontBold: bool = 0, FontItalic: bool = 0) -> CDrawingObject:
		"""Adds a layout ruler object to the DrawingObjects collection."""
		return CDrawingObject(self.__IDrawingObjects.AddLayoutRuler(x1, y1, x2, y2, Gap, TickHeight, TickLocation, DisplayPrecision, Spacing, ShowUnits, FontName, FontHeight, FontBold, FontItalic))


	def AddArrayCell(self, LibraryName: str, CellName: str, x: float, y: float, Rows: int, Columns: int, dx: float, dy: float, RotationAngle: float = 0, Flipped: bool = 0) -> CDrawingObject:
		"""Adds an array cell object to the DrawingObjects collection."""
		return CDrawingObject(self.__IDrawingObjects.AddArrayCell(LibraryName, CellName, x, y, Rows, Columns, dx, dy, RotationAngle, Flipped))


	def AddArc(self, xCenter: float, yCenter: float, Radius: float, StartAngle: float, EndAngle: float, LayerName: str = "", UseProcessLayers: bool = 0, LayerMapping: str = "") -> CDrawingObject:
		"""Adds an arc object to the DrawingObject collection."""
		return CDrawingObject(self.__IDrawingObjects.AddArc(xCenter, yCenter, Radius, StartAngle, EndAngle, LayerName, UseProcessLayers, LayerMapping))


	def AddPathEx(self, XYPoints, Width: float, EndStyle: mwPathEndType = 1, MiterStyle: mwPathMiterType = 1, OffsetMiterAmount: float = 0, PathBeginExtent: float = 0, PathEndExtent: float = 0, LayerName: str = "", UseProcessLayers: bool = 0, LayerMapping: str = "") -> CDrawingObject:
		"""Adds a path object to the DrawingObjects collection."""
		return CDrawingObject(self.__IDrawingObjects.AddPathEx(XYPoints, Width, EndStyle, MiterStyle, OffsetMiterAmount, PathBeginExtent, PathEndExtent, LayerName, UseProcessLayers, LayerMapping))


	def AddTextEx(self, x: float, y: float, Height: float, Text: str, DrawAsPolygons: bool = -1, LayerName: str = "", TextAlignment: mwTextAlignment = 5, RotationAngle: float = 0, Flipped: bool = 0, FontName: str = "", Bold: bool = 0, Italic: bool = 0, UseProcessLayers: bool = 0, LayerMapping: str = "") -> CDrawingObject:
		"""Adds a text object to the DrawingObjects collection."""
		return CDrawingObject(self.__IDrawingObjects.AddTextEx(x, y, Height, Text, DrawAsPolygons, LayerName, TextAlignment, RotationAngle, Flipped, FontName, Bold, Italic, UseProcessLayers, LayerMapping))


	def AddLayoutCell(self, Name: str, x: float, y: float, RotationAngle: float = 0, Flipped: bool = 0) -> CDrawingObject:
		"""Adds a LayoutCell object to the DrawingObjects collection."""
		return CDrawingObject(self.__IDrawingObjects.AddLayoutCell(Name, x, y, RotationAngle, Flipped))


	def CreateRouteRecord(self) -> CRouteRecord:
		"""Returns a reference to a MWOffice RouteRecord object."""
		return CRouteRecord(self.__IDrawingObjects.CreateRouteRecord())


	def AddRoute(self, Record: CRouteRecord) -> CDrawingObject:
		"""Adds a Route object to the DrawingObjects collection."""
		return CDrawingObject(self.__IDrawingObjects.AddRoute(Record._get_inner()))


	def NegateLayer(self, LayerName: str, pProfileShape: CDrawingObject = 0) -> bool:
		"""Process layer shapes to invert complex polygons and subtract them from remaining layer shapes."""
		return self.__IDrawingObjects.NegateLayer(LayerName, pProfileShape._get_inner())


	def NegateLayerShapes(self, LayerName: str) -> bool:
		"""Process layer shapes to invert shapes marked as negative and subtract them from remaining layer shapes."""
		return self.__IDrawingObjects.NegateLayerShapes(LayerName)


	def AddFilletedPolygon(self, XYPoints, SkipFillet, OutsideCornerRadius: float, InsideCornerRadius: float, NumPointsPerCircle: int, LayerName: str = "", FilletOptions: mwFilletPolyOptions = 0, FilletArcPointStyle: mwFilletPolyArcPtStyle = 1, UseProcessLayers: bool = 0, LayerMapping: str = "") -> CDrawingObject:
		"""Adds a filleted polygon object to the DrawingObjects collection."""
		return CDrawingObject(self.__IDrawingObjects.AddFilletedPolygon(XYPoints, SkipFillet, OutsideCornerRadius, InsideCornerRadius, NumPointsPerCircle, LayerName, FilletOptions, FilletArcPointStyle, UseProcessLayers, LayerMapping))


	def AddShape(self, ShapeToCopy: CShape, x: float, y: float, RotationAngle: float = 0, Flipped: bool = 0) -> CDrawingObject:
		"""Adds a copy of a shape object the the DrawingObjects collection."""
		return CDrawingObject(self.__IDrawingObjects.AddShape(ShapeToCopy._get_inner(), x, y, RotationAngle, Flipped))


	def AddBoundary(self, XYPoints, Type: mwLayoutBoundaryType = 0, extractGroup: str = "") -> CDrawingObject:
		"""Adds a polygon object to the DrawingObjects collection."""
		return CDrawingObject(self.__IDrawingObjects.AddBoundary(XYPoints, Type, extractGroup))



	@property
	def ActiveNetName(self) -> str:
		"""Returns/sets the active shape network name to be used with newly created DrawingObjects."""
		return self.__IDrawingObjects.ActiveNetName


	@ActiveNetName.setter
	def ActiveNetName(self, value: str):
		"""Returns/sets the active shape network name to be used with newly created DrawingObjects."""
		self.__IDrawingObjects.ActiveNetName = value


	@property
	def ActiveNetType(self):
		"""Returns/sets the active shape network type to be used with newly created DrawingObjects."""
		return self.__IDrawingObjects.ActiveNetType


	@ActiveNetType.setter
	def ActiveNetType(self, value: mwShapeNetType):
		"""Returns/sets the active shape network type to be used with newly created DrawingObjects."""
		self.__IDrawingObjects.ActiveNetType = value


	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IDrawingObjects.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IDrawingObjects.Exists(Index)


	def Item(self, Index) -> CDrawingObject:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingObject(self.__IDrawingObjects.Item(Index))


	def __get_Item(self, Index) -> CDrawingObject:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingObject(self.__IDrawingObjects.Item(Index))


	def __call__(self, index) -> CDrawingObject:
		return self.__get_Item(index)


	def __iter__(self) -> CDrawingObject:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IDrawingObjects.Count


	def __getitem__(self, index) -> Union[CDrawingObject, List[CDrawingObject]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def MarkNegative(self) -> bool:
		"""Returns/sets a value that indicates if newly added shapes to the DrawingObjects collection should be marked negative."""
		return self.__IDrawingObjects.MarkNegative


	@MarkNegative.setter
	def MarkNegative(self, value: bool):
		"""Returns/sets a value that indicates if newly added shapes to the DrawingObjects collection should be marked negative."""
		self.__IDrawingObjects.MarkNegative = value


	@property
	def PathWriter(self) -> CPathWriter:
		"""Returns a reference to a MWOffice PathWriters object."""
		return CPathWriter(self.__IDrawingObjects.PathWriter)


	@property
	def PolygonWriter(self) -> CPolygonWriter:
		"""Returns a reference to a MWOffice PolygonWriter object."""
		return CPolygonWriter(self.__IDrawingObjects.PolygonWriter)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# PolygonRecord
class CPolygonRecord:
	"""An MWOffice PolygonRecord object."""
	def __init__(self, polygonrecord):
		self.__IPolygonRecord = polygonrecord

	def _get_inner(self):
		return self.__IPolygonRecord


	def PolygonBegin(self, x1: float, y1: float) -> None:
		"""Method to indicate the start of a new polygon object to the PolygonRecord object."""
		self.__IPolygonRecord.PolygonBegin(x1, y1)


	def PolygonEnd(self) -> None:
		"""Method to indicate the end of the polygon object to the PolygonRecord object."""
		self.__IPolygonRecord.PolygonEnd()


	def PolyCutoutBegin(self, x1: float, y1: float) -> None:
		"""Method to indicate the start of a polygon cutout object to the PolygonRecord object."""
		self.__IPolygonRecord.PolyCutoutBegin(x1, y1)


	def PolyCutoutEnd(self) -> None:
		"""Method to indicate the end of a polygon cutout object to the PolygonRecord object."""
		self.__IPolygonRecord.PolyCutoutEnd()


	def AddPolySegment(self, x2: float, y2: float) -> None:
		"""Adds a new segment to the current polygon or cutout polygon to the PolygonRecord object."""
		self.__IPolygonRecord.AddPolySegment(x2, y2)


	def AddPolyArcSegment(self, x2: float, y2: float, centerX: float, centerY: float, dir: mwDrawingArcDirection) -> None:
		"""Adds a new arc segment to the current polygon or cutout polygon to the PolygonRecord object."""
		self.__IPolygonRecord.AddPolyArcSegment(x2, y2, centerX, centerY, dir)


	def AddCircleCutout(self, centerX: float, centerY: float, Radius: float) -> None:
		"""Adds a new circle cutout to the PolygonRecord object."""
		self.__IPolygonRecord.AddCircleCutout(centerX, centerY, Radius)


	def AddEllipseCutout(self, x: float, y: float, dx: float, dy: float) -> None:
		"""Adds a new ellipse cutout to the PolygonRecord object."""
		self.__IPolygonRecord.AddEllipseCutout(x, y, dx, dy)


	def Clear(self) -> None:
		"""Clears the PolygonRecord of all polygon information so it can be reused."""
		self.__IPolygonRecord.Clear()


	def Rotate(self, angleCCW: float, aboutX: float, aboutY: float) -> None:
		"""Adds a counter-clockwise rotation to the object represented by the PolygonRecord object."""
		self.__IPolygonRecord.Rotate(angleCCW, aboutX, aboutY)


	def Mirror(self, aboutX: float) -> None:
		"""Mirrors the object represented by the PolygonRecord object about the y-axis."""
		self.__IPolygonRecord.Mirror(aboutX)


	def Offset(self, dx: float, dy: float) -> None:
		"""Adds an offset to the object represented by the PolygonRecord object."""
		self.__IPolygonRecord.Offset(dx, dy)


	def Scale(self, scaleFactor: float, aboutX: float, aboutY: float) -> None:
		"""Adds a scale factor to the object represented by the PolygonRecord object."""
		self.__IPolygonRecord.Scale(scaleFactor, aboutX, aboutY)


	def AddCircle(self, centerX: float, centerY: float, Radius: float) -> None:
		"""Add a circle shaped polygon to the record object with the given center and radius values"""
		self.__IPolygonRecord.AddCircle(centerX, centerY, Radius)


	def AddEllipse(self, x: float, y: float, dx: float, dy: float) -> None:
		"""Add an ellipse shaped polygon to the record object with the given upper left corner and width and height"""
		self.__IPolygonRecord.AddEllipse(x, y, dx, dy)


	def HasCutouts(self) -> bool:
		"""Returns a value that indicates if the polygon contains cutouts."""
		return self.__IPolygonRecord.HasCutouts()



	@property
	def PCBPinName(self) -> str:
		"""Returns/Sets a value that will be associated with the polygon object as a PCB pin name when it is created."""
		return self.__IPolygonRecord.PCBPinName


	@PCBPinName.setter
	def PCBPinName(self, value: str):
		"""Returns/Sets a value that will be associated with the polygon object as a PCB pin name when it is created."""
		self.__IPolygonRecord.PCBPinName = value


	@property
	def PCBPinObject(self) -> bool:
		"""Returns/Sets a value that indicates if the polygon should marked as a PCB pin when it is created."""
		return self.__IPolygonRecord.PCBPinObject


	@PCBPinObject.setter
	def PCBPinObject(self, value: bool):
		"""Returns/Sets a value that indicates if the polygon should marked as a PCB pin when it is created."""
		self.__IPolygonRecord.PCBPinObject = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# PolygonRecords
class CPolygonRecords:
	"""A collection of PolygonRecord objects."""
	def __init__(self, polygonrecords):
		self.__IPolygonRecords = polygonrecords

	def _get_inner(self):
		return self.__IPolygonRecords


	def Add(self, Record: CPolygonRecord) -> bool:
		"""Adds an object to the collection and returns a reference to the created object."""
		return self.__IPolygonRecords.Add(Record._get_inner())


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IPolygonRecords.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IPolygonRecords.RemoveAll()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IPolygonRecords.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IPolygonRecords.Exists(Index)


	def Item(self, Index) -> CPolygonRecord:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CPolygonRecord(self.__IPolygonRecords.Item(Index))


	def __get_Item(self, Index) -> CPolygonRecord:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CPolygonRecord(self.__IPolygonRecords.Item(Index))


	def __call__(self, index) -> CPolygonRecord:
		return self.__get_Item(index)


	def __iter__(self) -> CPolygonRecord:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IPolygonRecords.Count


	def __getitem__(self, index) -> Union[CPolygonRecord, List[CPolygonRecord]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# PolygonWriter
class CPolygonWriter:
	"""An MWOffice PolygonWriter object."""
	def __init__(self, polygonwriter):
		self.__IPolygonWriter = polygonwriter

	def _get_inner(self):
		return self.__IPolygonWriter


	def CreatePolygonRecord(self) -> CPolygonRecord:
		"""Returns a new PolygonReference reference to be used to create polygon objects."""
		return CPolygonRecord(self.__IPolygonWriter.CreatePolygonRecord())


	def AddPolygon(self, pRecord: CPolygonRecord) -> CDrawingObject:
		"""Adds a new polygon to the PolygonWriter target design using the information specified in the PolygonRecord object."""
		return CDrawingObject(self.__IPolygonWriter.AddPolygon(pRecord._get_inner()))


	def CachePolygon(self, Name: str, pRecord: CPolygonRecord) -> None:
		"""Adds the polygon shape information to a named set of shapes to be created later."""
		self.__IPolygonWriter.CachePolygon(Name, pRecord._get_inner())


	def CreateCachedPolygons(self, Name: str, offsetDx: float = 0, offsetDy: float = 0, rotCCW: float = 0, rotAboutX: float = 0, rotAboutY: float = 0, Mirror: bool = 0, mirrorAboutX: float = 0, Scale: float = 1, scaleAboutX: float = 0, scaleAboutY: float = 0) -> None:
		"""Adds the polygon shapes from the named collection to the design with the given transform values."""
		self.__IPolygonWriter.CreateCachedPolygons(Name, offsetDx, offsetDy, rotCCW, rotAboutX, rotAboutY, Mirror, mirrorAboutX, Scale, scaleAboutX, scaleAboutY)


	def CreatePolygonContainer(self) -> CPolygonRecords:
		"""Returns a reference to a collection of PolygonRecord objects."""
		return CPolygonRecords(self.__IPolygonWriter.CreatePolygonContainer())


	def AddPolygons(self, polygons: CPolygonRecords) -> CResultDrawingObjects:
		"""Adds multiple polygons to the PolygonWriter target design using the information specified in the PolygonRecords collection."""
		return CResultDrawingObjects(self.__IPolygonWriter.AddPolygons(polygons._get_inner()))


	def AddPolygonsPosNeg(self, positivePolygons: CPolygonRecords, negativePolygons: CPolygonRecords) -> CResultDrawingObjects:
		"""Adds multiple positive and negative polygons to the PolygonWriter target design using the information specified in the PolygonRecords collections."""
		return CResultDrawingObjects(self.__IPolygonWriter.AddPolygonsPosNeg(positivePolygons._get_inner(), negativePolygons._get_inner()))


	def CachePolygons(self, Name: str, pRecord: CPolygonRecords) -> None:
		"""Adds the polygon shapes specified in the IPolygonRecords collection to a named set to be created later"""
		self.__IPolygonWriter.CachePolygons(Name, pRecord._get_inner())


	def CachePolygonsPosNeg(self, Name: str, positive: CPolygonRecords, negative: CPolygonRecords) -> None:
		"""Adds the positive and negative shapes specified by IPolgonsRecords collections to a named set to be created later."""
		self.__IPolygonWriter.CachePolygonsPosNeg(Name, positive._get_inner(), negative._get_inner())



	@property
	def LayerMapping(self) -> str:
		"""Returns/sets the current layer mapping to be used by shapes added by the PolygonWriter object. """
		return self.__IPolygonWriter.LayerMapping


	@LayerMapping.setter
	def LayerMapping(self, value: str):
		"""Returns/sets the current layer mapping to be used by shapes added by the PolygonWriter object. """
		self.__IPolygonWriter.LayerMapping = value


	@property
	def LayerName(self) -> str:
		"""Returns/sets the current layer name to be used by shapes added by the PolygonWriter object."""
		return self.__IPolygonWriter.LayerName


	@LayerName.setter
	def LayerName(self, value: str):
		"""Returns/sets the current layer name to be used by shapes added by the PolygonWriter object."""
		self.__IPolygonWriter.LayerName = value


	@property
	def PCBPinName(self) -> str:
		"""Returns/Sets a value that will be associated with the polygons as the PCB pin name when they are created by the PolygonWriter."""
		return self.__IPolygonWriter.PCBPinName


	@PCBPinName.setter
	def PCBPinName(self, value: str):
		"""Returns/Sets a value that will be associated with the polygons as the PCB pin name when they are created by the PolygonWriter."""
		self.__IPolygonWriter.PCBPinName = value


	@property
	def PCBPinObject(self) -> bool:
		"""Returns/Sets a value that indicates if the polygons added by the PolygonWriter should marked as a PCB pins when the are created."""
		return self.__IPolygonWriter.PCBPinObject


	@PCBPinObject.setter
	def PCBPinObject(self, value: bool):
		"""Returns/Sets a value that indicates if the polygons added by the PolygonWriter should marked as a PCB pins when the are created."""
		self.__IPolygonWriter.PCBPinObject = value


	@property
	def UseProcessLayers(self) -> bool:
		"""Returns/sets the if the shapes added by the PolygonWriter object should be set to use process layers."""
		return self.__IPolygonWriter.UseProcessLayers


	@UseProcessLayers.setter
	def UseProcessLayers(self, value: bool):
		"""Returns/sets the if the shapes added by the PolygonWriter object should be set to use process layers."""
		self.__IPolygonWriter.UseProcessLayers = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# PathRecord
class CPathRecord:
	"""An MWOffice PathRecord object."""
	def __init__(self, pathrecord):
		self.__IPathRecord = pathrecord

	def _get_inner(self):
		return self.__IPathRecord


	def PathBegin(self, x1: float, y1: float) -> None:
		"""Method to indicate the start of a new path object to the PathRecord object."""
		self.__IPathRecord.PathBegin(x1, y1)


	def PathEnd(self) -> None:
		"""Method to indicate the end of the path object to the PathRecord object."""
		self.__IPathRecord.PathEnd()


	def AddSegment(self, x2: float, y2: float) -> None:
		"""Adds a new segment to the current path object to in the PathRecord object."""
		self.__IPathRecord.AddSegment(x2, y2)


	def Clear(self) -> None:
		"""Clears the PathRecord of all path information so it can be reused."""
		self.__IPathRecord.Clear()


	def AddArcSegment(self, x2: float, y2: float, cx: float, cy: float, dir: mwDrawingArcDirection) -> None:
		"""Adds a new arc segment to the current path object in the PathRecord object."""
		self.__IPathRecord.AddArcSegment(x2, y2, cx, cy, dir)


	def Rotate(self, angleCCW: float, aboutX: float, aboutY: float) -> None:
		"""Adds a counter-clockwise rotation to the object represented by the PathRecord object."""
		self.__IPathRecord.Rotate(angleCCW, aboutX, aboutY)


	def Mirror(self, aboutX: float) -> None:
		"""Mirrors the object represented by the PathRecord object about the y-axis."""
		self.__IPathRecord.Mirror(aboutX)


	def Offset(self, dx: float, dy: float) -> None:
		"""Adds an offset to the object represented by the PathRecord object."""
		self.__IPathRecord.Offset(dx, dy)


	def Scale(self, scaleFactor: float) -> None:
		"""Adds a scale factor to the object represented by the PathRecord object."""
		self.__IPathRecord.Scale(scaleFactor)



	@property
	def PCBPinName(self) -> str:
		"""Returns/Sets a value that will be associated with the path object as a PCB pin name when it is created."""
		return self.__IPathRecord.PCBPinName


	@PCBPinName.setter
	def PCBPinName(self, value: str):
		"""Returns/Sets a value that will be associated with the path object as a PCB pin name when it is created."""
		self.__IPathRecord.PCBPinName = value


	@property
	def PCBPinObject(self) -> bool:
		"""Returns/Sets a value that indicates if the path object should marked as a PCB pin when it is created."""
		return self.__IPathRecord.PCBPinObject


	@PCBPinObject.setter
	def PCBPinObject(self, value: bool):
		"""Returns/Sets a value that indicates if the path object should marked as a PCB pin when it is created."""
		self.__IPathRecord.PCBPinObject = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# PathWriter
class CPathWriter:
	"""An MWOffice PathWriter object."""
	def __init__(self, pathwriter):
		self.__IPathWriter = pathwriter

	def _get_inner(self):
		return self.__IPathWriter


	def CreatePathRecord(self) -> CPathRecord:
		"""Returns a new PathRecord reference to be used to create path objects."""
		return CPathRecord(self.__IPathWriter.CreatePathRecord())


	def AddPath(self, pRecord: CPathRecord) -> CDrawingObject:
		"""Adds a new path to the PathWriter target design using the information specified in the PathRecord object."""
		return CDrawingObject(self.__IPathWriter.AddPath(pRecord._get_inner()))


	def CachePath(self, Name: str, pPathRecord: CPathRecord) -> None:
		"""Add the path shape information to a named set of shapes to be created later."""
		self.__IPathWriter.CachePath(Name, pPathRecord._get_inner())


	def CreateCachedPaths(self, Name: str, offsetDx: float = 0, offsetDy: float = 0, rotCCW: float = 0, rotAboutX: float = 0, rotAboutY: float = 0, Mirror: bool = 0, mirrorAboutX: float = 0, Scale: float = 1) -> None:
		"""Add the path shapes from the named collection to the design with the given transform values."""
		self.__IPathWriter.CreateCachedPaths(Name, offsetDx, offsetDy, rotCCW, rotAboutX, rotAboutY, Mirror, mirrorAboutX, Scale)


	def CombinePaths(self) -> bool:
		"""Combines multiple overlapping connected paths on each layer to form single path objects."""
		return self.__IPathWriter.CombinePaths()


	def CombineLayerPaths(self, LayerName: str) -> bool:
		"""Combines multiple overlapping connected paths on the given layer to form single path objects"""
		return self.__IPathWriter.CombineLayerPaths(LayerName)



	@property
	def EndType(self):
		"""Gets/sets the path end style to be used by shapes added by the PathWriter object."""
		return self.__IPathWriter.EndType


	@EndType.setter
	def EndType(self, value: mwPathEndType):
		"""Gets/sets the path end style to be used by shapes added by the PathWriter object."""
		self.__IPathWriter.EndType = value


	@property
	def LayerMapping(self) -> str:
		"""Gets/sets the current layer mapping to be used by shapes added by the PathWriter object."""
		return self.__IPathWriter.LayerMapping


	@LayerMapping.setter
	def LayerMapping(self, value: str):
		"""Gets/sets the current layer mapping to be used by shapes added by the PathWriter object."""
		self.__IPathWriter.LayerMapping = value


	@property
	def LayerName(self) -> str:
		"""Gets/sets the current layer name to be used by shapes added by the PathWriter object."""
		return self.__IPathWriter.LayerName


	@LayerName.setter
	def LayerName(self, value: str):
		"""Gets/sets the current layer name to be used by shapes added by the PathWriter object."""
		self.__IPathWriter.LayerName = value


	@property
	def MiterAmount(self) -> float:
		"""Gets/sets the path miter amount to be used by shapes added by the PathWriter object."""
		return self.__IPathWriter.MiterAmount


	@MiterAmount.setter
	def MiterAmount(self, value: float):
		"""Gets/sets the path miter amount to be used by shapes added by the PathWriter object."""
		self.__IPathWriter.MiterAmount = value


	@property
	def MiterStyle(self):
		"""Gets/sets the path miter style to be used by shapes added by the PathWriter object."""
		return self.__IPathWriter.MiterStyle


	@MiterStyle.setter
	def MiterStyle(self, value: mwPathMiterType):
		"""Gets/sets the path miter style to be used by shapes added by the PathWriter object."""
		self.__IPathWriter.MiterStyle = value


	@property
	def PCBPinName(self) -> str:
		"""Returns/Sets a value that will be associated with the paths as the PCB pin name when they are created by the PolygonWriter."""
		return self.__IPathWriter.PCBPinName


	@PCBPinName.setter
	def PCBPinName(self, value: str):
		"""Returns/Sets a value that will be associated with the paths as the PCB pin name when they are created by the PolygonWriter."""
		self.__IPathWriter.PCBPinName = value


	@property
	def PCBPinObject(self) -> bool:
		"""Returns/Sets a value that indicates if the path objects added by the PathWriter should marked as a PCB pins when they are created."""
		return self.__IPathWriter.PCBPinObject


	@PCBPinObject.setter
	def PCBPinObject(self, value: bool):
		"""Returns/Sets a value that indicates if the path objects added by the PathWriter should marked as a PCB pins when they are created."""
		self.__IPathWriter.PCBPinObject = value


	@property
	def UseProcessLayers(self) -> bool:
		"""Gets/sets if the shapes added by the PathWriter object should be set to use process layers."""
		return self.__IPathWriter.UseProcessLayers


	@UseProcessLayers.setter
	def UseProcessLayers(self, value: bool):
		"""Gets/sets if the shapes added by the PathWriter object should be set to use process layers."""
		self.__IPathWriter.UseProcessLayers = value


	@property
	def Width(self) -> float:
		"""Gets/sets the path width to be used by shapes added to the PathWriter object."""
		return self.__IPathWriter.Width


	@Width.setter
	def Width(self, value: float):
		"""Gets/sets the path width to be used by shapes added to the PathWriter object."""
		self.__IPathWriter.Width = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SelectedDrawingObjects
class CSelectedDrawingObjects:
	"""A collection of MWOffice SelectedDrawingObject objects."""
	def __init__(self, selecteddrawingobjects):
		self.__ISelectedDrawingObjects = selecteddrawingobjects

	def _get_inner(self):
		return self.__ISelectedDrawingObjects


	def Add(self, DrawingObject: CDrawingObject) -> bool:
		"""Adds an object to the collection and returns a reference to the created object."""
		return self.__ISelectedDrawingObjects.Add(DrawingObject._get_inner())


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ISelectedDrawingObjects.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__ISelectedDrawingObjects.RemoveAll()


	def AddAll(self) -> bool:
		"""Adds an object to the collection and returns a reference to the created object."""
		return self.__ISelectedDrawingObjects.AddAll()


	def AddFromArea(self, Left: float, Top: float, Right: float, Bottom: float, Type: mwAreaAddType = 0) -> bool:
		"""Adds the objects contained or overlapped by a given rectangle to the collection."""
		return self.__ISelectedDrawingObjects.AddFromArea(Left, Top, Right, Bottom, Type)


	def AddFromRegion(self, XYPoints, Type: mwAreaAddType = 0) -> bool:
		"""Adds an object to the collection and returns a reference to the created object."""
		return self.__ISelectedDrawingObjects.AddFromRegion(XYPoints, Type)


	def AddOverlapped(self, ppShape: CShape, Type: mwAreaAddType = 0) -> bool:
		"""Adds an object to the collection and returns a reference to the created object."""
		return self.__ISelectedDrawingObjects.AddOverlapped(ppShape._get_inner(), Type)


	def AddByName(self, Name: str, Type: mwObjectNameType = 0) -> bool:
		"""Adds an object to the collection and returns a reference to the created object."""
		return self.__ISelectedDrawingObjects.AddByName(Name, Type)


	def GetContainer(self) -> CContainerDrawingObjects:
		"""Returns a reference to a collection of MWOffice ContainerDrawingObject objects."""
		return CContainerDrawingObjects(self.__ISelectedDrawingObjects.GetContainer())


	def AddObjects(self, pContainer: CContainerDrawingObjects) -> bool:
		"""Adds an object to the collection and returns a reference to the created object."""
		return self.__ISelectedDrawingObjects.AddObjects(pContainer._get_inner())


	def RemoveObjects(self, pContainer: CContainerDrawingObjects) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ISelectedDrawingObjects.RemoveObjects(pContainer._get_inner())



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ISelectedDrawingObjects.Count


	@property
	def FirstSelectedIndex(self) -> int:
		"""Returns the index of the first selected object."""
		return self.__ISelectedDrawingObjects.FirstSelectedIndex


	def Item(self, Index) -> CDrawingObject:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingObject(self.__ISelectedDrawingObjects.Item(Index))


	def __get_Item(self, Index) -> CDrawingObject:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingObject(self.__ISelectedDrawingObjects.Item(Index))


	def __call__(self, index) -> CDrawingObject:
		return self.__get_Item(index)


	def __iter__(self) -> CDrawingObject:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ISelectedDrawingObjects.Count


	def __getitem__(self, index) -> Union[CDrawingObject, List[CDrawingObject]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# GroupDrawingObjects
class CGroupDrawingObjects:
	"""A collection of MWOffice GroupDrawingObject objects."""
	def __init__(self, groupdrawingobjects):
		self.__IGroupDrawingObjects = groupdrawingobjects

	def _get_inner(self):
		return self.__IGroupDrawingObjects


	def Add(self, DrawingObject: CDrawingObject) -> bool:
		"""Adds an object to the collection and returns a reference to the created object."""
		return self.__IGroupDrawingObjects.Add(DrawingObject._get_inner())


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IGroupDrawingObjects.Remove(Index)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IGroupDrawingObjects.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IGroupDrawingObjects.Exists(Index)


	def Item(self, Index) -> CDrawingObject:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingObject(self.__IGroupDrawingObjects.Item(Index))


	def __get_Item(self, Index) -> CDrawingObject:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingObject(self.__IGroupDrawingObjects.Item(Index))


	def __call__(self, index) -> CDrawingObject:
		return self.__get_Item(index)


	def __iter__(self) -> CDrawingObject:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IGroupDrawingObjects.Count


	def __getitem__(self, index) -> Union[CDrawingObject, List[CDrawingObject]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ResultDrawingObjects
class CResultDrawingObjects:
	"""A collection of MWOffice ResultDrawingObject objects."""
	def __init__(self, resultdrawingobjects):
		self.__IResultDrawingObjects = resultdrawingobjects

	def _get_inner(self):
		return self.__IResultDrawingObjects



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IResultDrawingObjects.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IResultDrawingObjects.Exists(Index)


	def Item(self, Index) -> CDrawingObject:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingObject(self.__IResultDrawingObjects.Item(Index))


	def __get_Item(self, Index) -> CDrawingObject:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingObject(self.__IResultDrawingObjects.Item(Index))


	def __call__(self, index) -> CDrawingObject:
		return self.__get_Item(index)


	def __iter__(self) -> CDrawingObject:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IResultDrawingObjects.Count


	def __getitem__(self, index) -> Union[CDrawingObject, List[CDrawingObject]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ContainerDrawingObjects
class CContainerDrawingObjects:
	"""A collection of MWOffice ContainerDrawingObject objects."""
	def __init__(self, containerdrawingobjects):
		self.__IContainerDrawingObjects = containerdrawingobjects

	def _get_inner(self):
		return self.__IContainerDrawingObjects


	def Add(self, DrawingObject: CDrawingObject) -> bool:
		"""Adds an object to the collection and returns a reference to the created object."""
		return self.__IContainerDrawingObjects.Add(DrawingObject._get_inner())


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IContainerDrawingObjects.Remove(Index)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IContainerDrawingObjects.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IContainerDrawingObjects.Exists(Index)


	def Item(self, Index) -> CDrawingObject:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingObject(self.__IContainerDrawingObjects.Item(Index))


	def __get_Item(self, Index) -> CDrawingObject:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingObject(self.__IContainerDrawingObjects.Item(Index))


	def __call__(self, index) -> CDrawingObject:
		return self.__get_Item(index)


	def __iter__(self) -> CDrawingObject:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IContainerDrawingObjects.Count


	def __getitem__(self, index) -> Union[CDrawingObject, List[CDrawingObject]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# EMStructureInfo
class CEMStructureInfo:
	"""An MWOffice EMStructure Info object."""
	def __init__(self, emstructureinfo):
		self.__IEMStructureInfo = emstructureinfo

	def _get_inner(self):
		return self.__IEMStructureInfo



	@property
	def CacheSize(self) -> int:
		"""Returns the recommended cache size for solving the Electromagnetic Structure."""
		return self.__IEMStructureInfo.CacheSize


	@property
	def MemoryRequirement(self) -> int:
		"""Returns the memory requirements to solve the Electromagnetic Structure."""
		return self.__IEMStructureInfo.MemoryRequirement


	@property
	def MeshSize(self) -> int:
		"""Returns the mesh size of the Electromagnetic Structure."""
		return self.__IEMStructureInfo.MeshSize


	@property
	def PhysicalMemory(self) -> int:
		"""Returns the physical memory available to solve the Electromagnetic Structure."""
		return self.__IEMStructureInfo.PhysicalMemory


	@property
	def TimePerFrequency(self) -> float:
		"""Returns the time required to solve the Electromagnetic Structure at each frequency."""
		return self.__IEMStructureInfo.TimePerFrequency


	@property
	def TotalTime(self) -> float:
		"""Returns the total time required to solve the Electromagnetic Structure."""
		return self.__IEMStructureInfo.TotalTime


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# EMInitializationRecord
class CEMInitializationRecord:
	"""A MWOffice EMInitializationRecord object."""
	def __init__(self, eminitializationrecord):
		self.__IEMInitializationRecord = eminitializationrecord

	def _get_inner(self):
		return self.__IEMInitializationRecord



	@property
	def EMMappingName(self) -> str:
		"""Returns/sets the EMMapping name to be used when doing LPF initialization."""
		return self.__IEMInitializationRecord.EMMappingName


	@EMMappingName.setter
	def EMMappingName(self, value: str):
		"""Returns/sets the EMMapping name to be used when doing LPF initialization."""
		self.__IEMInitializationRecord.EMMappingName = value


	@property
	def GlobalDocumentName(self) -> str:
		"""Returns/sets the name of the global definition document containing the Stackup element when doing Stackup initialization."""
		return self.__IEMInitializationRecord.GlobalDocumentName


	@GlobalDocumentName.setter
	def GlobalDocumentName(self, value: str):
		"""Returns/sets the name of the global definition document containing the Stackup element when doing Stackup initialization."""
		self.__IEMInitializationRecord.GlobalDocumentName = value


	@property
	def ProcessDefinitionName(self) -> str:
		"""Returns/sets the ProcessDefinition name when doing LPF initialization."""
		return self.__IEMInitializationRecord.ProcessDefinitionName


	@ProcessDefinitionName.setter
	def ProcessDefinitionName(self, value: str):
		"""Returns/sets the ProcessDefinition name when doing LPF initialization."""
		self.__IEMInitializationRecord.ProcessDefinitionName = value


	@property
	def StackupName(self) -> str:
		"""Returns/sets the name of the stackup element in the global definition document when doing Stackup initialization."""
		return self.__IEMInitializationRecord.StackupName


	@StackupName.setter
	def StackupName(self, value: str):
		"""Returns/sets the name of the stackup element in the global definition document when doing Stackup initialization."""
		self.__IEMInitializationRecord.StackupName = value


	@property
	def Type(self):
		"""Returns/sets the type of initialization to be performed on the EMStructure object"""
		return self.__IEMInitializationRecord.Type


	@Type.setter
	def Type(self, value: mwEMInitType):
		"""Returns/sets the type of initialization to be performed on the EMStructure object"""
		self.__IEMInitializationRecord.Type = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# EMStructure
class CEMStructure:
	"""An MWOffice EMStructure object."""
	def __init__(self, emstructure):
		self.__IEMStructure = emstructure

	def _get_inner(self):
		return self.__IEMStructure


	def Export(self, Filename: str) -> None:
		"""Exports a design document file from MWOffice."""
		self.__IEMStructure.Export(Filename)


	def Activate(self) -> None:
		"""Activates the objects."""
		self.__IEMStructure.Activate()


	def NewWindow(self, WindowType: mwWindowType = 3) -> CWindow:
		"""Displays the object in new window."""
		return CWindow(self.__IEMStructure.NewWindow(WindowType))


	def CopyToClipboard(self) -> bool:
		"""Copies the object to the system clipboard."""
		return self.__IEMStructure.CopyToClipboard()


	def Paste(self, x: float, y: float, CCWRotation: float = 0, Flipped: bool = 0) -> bool:
		"""Pastes the system clipboard to the object."""
		return self.__IEMStructure.Paste(x, y, CCWRotation, Flipped)


	def PrintOut(self) -> None:
		"""Sends the object to the current printer."""
		self.__IEMStructure.PrintOut()


	def CopyToClipboardEx(self, Type: mwDesignViewType) -> bool:
		"""Copies the object to the system clipboard."""
		return self.__IEMStructure.CopyToClipboardEx(Type)


	def ForceResimulate(self) -> bool:
		"""Marks the EMStructure as changed and clears existing results for resimulation."""
		return self.__IEMStructure.ForceResimulate()


	def SimulationLogClear(self) -> None:
		"""Clears the EM simulation log"""
		self.__IEMStructure.SimulationLogClear()


	def ExportEmInputData(self, Filename: str) -> None:
		"""Exports the EMStructure EM Socket input data file to the specified filename."""
		self.__IEMStructure.ExportEmInputData(Filename)


	def CreateMesh(self) -> None:
		"""Generates a mesh for the current EMStructure. A mesh Annotation must be enabled to view the mesh."""
		self.__IEMStructure.CreateMesh()


	def InvokeCommand(self, CommandName: str, Arguments, pRet) -> None:
		"""Invoke a menu command by specifying the name for the command. Arguments must be suppled for any required input."""
		self.__IEMStructure.InvokeCommand(CommandName, Arguments, pRet)


	def PasteRelative(self, dx: float, dy: float, CCWRotation: float = 0, Flipped: bool = 0) -> bool:
		"""Pastes the system clipboard to the object."""
		return self.__IEMStructure.PasteRelative(dx, dy, CCWRotation, Flipped)


	def CopyViewToClipboard(self, Type: mwDesignViewType = 0) -> bool:
		"""Copies the object to the system clipboard."""
		return self.__IEMStructure.CopyViewToClipboard(Type)


	def Simulate(self, pDefaultDataSetName: str) -> bool:
		"""Submit the EMStructure document for simulation."""
		return self.__IEMStructure.Simulate(pDefaultDataSetName)


	def Update(self) -> None:
		"""Update the layout structure to be current."""
		self.__IEMStructure.Update()


	def PrintOutEx(self, Type: mwDesignViewType = 0) -> bool:
		"""Sends the object to the current printer."""
		return self.__IEMStructure.PrintOutEx(Type)


	def PrintView(self, Type: mwDesignViewType = 0) -> bool:
		"""Sends the object to the current printer."""
		return self.__IEMStructure.PrintView(Type)


	def ExportEmInputDataXML(self, Filename: str, Type: mwEMInputDataXMLType = 0) -> bool:
		"""Exports the EMStructure EM Socket input data file to the specified filename in XML format."""
		return self.__IEMStructure.ExportEmInputDataXML(Filename, Type)


	def LockDiagram(self, NewLevel: mwDiagramLockLevel, Password: str = "") -> bool:
		"""Changes the lock level of the EMStructure object to the given lock level"""
		return self.__IEMStructure.LockDiagram(NewLevel, Password)


	def StartCommand(self, CommandName: str, pRet) -> None:
		"""Start a menu command by specifying the name for the command. The user will need to complete any required input."""
		self.__IEMStructure.StartCommand(CommandName, pRet)


	def IsSimulationStateFlagSet(self, flag: mwSimStateFlags) -> bool:
		"""Returns a value that indicates if a certain simulation state flag is set."""
		return self.__IEMStructure.IsSimulationStateFlagSet(flag)


	def ImportEmInputData(self, Filename: str) -> bool:
		"""Imports the specified EM input data file."""
		return self.__IEMStructure.ImportEmInputData(Filename)


	def EndActiveCommand(self) -> bool:
		"""Ends the currently active command for this EMStructure object."""
		return self.__IEMStructure.EndActiveCommand()


	def Embed(self) -> None:
		"""Convert an externally linked EM structure into an embedded document."""
		self.__IEMStructure.Embed()


	def LinkToFile(self, FilePath: str) -> None:
		"""Convert an embedded EM structure into an externally linked document."""
		self.__IEMStructure.LinkToFile(FilePath)


	def Reload(self) -> None:
		"""Reload an externally linked EM structure."""
		self.__IEMStructure.Reload()


	def Save(self) -> None:
		"""Update the externally linked EM structure file."""
		self.__IEMStructure.Save()


	def Export3DCadFile(self, FilePath: str, Type: mw3DCadFileType = 0, Version: int = -1, merged: bool = -1) -> bool:
		"""Exports a 3D Cad File of the EMStructure object. Only supportd 3D EMStructures."""
		return self.__IEMStructure.Export3DCadFile(FilePath, Type, Version, merged)


	def RefineSolution(self) -> bool:
		"""Method that attempts to refine the current EMStructure solution."""
		return self.__IEMStructure.RefineSolution()



	@property
	def CanPaste(self) -> bool:
		"""Returns a value that determines the clipboard contents can be pasted to the object."""
		return self.__IEMStructure.CanPaste


	@property
	def CanRefineSolution(self) -> bool:
		"""Returns a value indicating if the EMStructure solution can be refined at this point."""
		return self.__IEMStructure.CanRefineSolution


	@property
	def Changed(self) -> bool:
		"""Returns/Sets a value that indicates if the object has changed and needs to be saved or resimulated."""
		return self.__IEMStructure.Changed


	@Changed.setter
	def Changed(self, value: bool):
		"""Returns/Sets a value that indicates if the object has changed and needs to be saved or resimulated."""
		self.__IEMStructure.Changed = value


	@property
	def CommandActive(self) -> bool:
		"""Returns a value indicating if there is command currently active for this EMStructure object."""
		return self.__IEMStructure.CommandActive


	@property
	def CoordinateEntry(self) -> CCoordinateEntry:
		"""Returns a reference to a CoordinateEntry object."""
		return CCoordinateEntry(self.__IEMStructure.CoordinateEntry)


	@property
	def DrawingObjects(self) -> CDrawingObjects:
		"""Returns a reference to a collection of DrawingObjects."""
		return CDrawingObjects(self.__IEMStructure.DrawingObjects)


	@property
	def EMStructureTests(self) -> CComponentTests:
		"""Returns a reference to a collection of ComponentTest objects."""
		return CComponentTests(self.__IEMStructure.EMStructureTests)


	@property
	def Embedded(self) -> bool:
		"""Returns if the EMStructure is embedded in the project or linked externally."""
		return self.__IEMStructure.Embedded


	@property
	def Enabled(self) -> bool:
		"""Returns/sets a value which specifies if the Electromagnetic Structure is enabled."""
		return self.__IEMStructure.Enabled


	@Enabled.setter
	def Enabled(self, value: bool):
		"""Returns/sets a value which specifies if the Electromagnetic Structure is enabled."""
		self.__IEMStructure.Enabled = value


	@property
	def Enclosure(self) -> CEnclosure:
		"""Returns a reference to an Enclosure object."""
		return CEnclosure(self.__IEMStructure.Enclosure)


	@property
	def Equations(self) -> CEquations:
		"""Returns a reference to a collection of Equation objects."""
		return CEquations(self.__IEMStructure.Equations)


	@property
	def FilePath(self) -> str:
		"""Returns the EMStructure file path."""
		return self.__IEMStructure.FilePath


	@property
	def Frequencies(self) -> CFrequencies:
		"""Returns a reference to a collection of Frequency objects."""
		return CFrequencies(self.__IEMStructure.Frequencies)


	@property
	def GridVisible(self) -> bool:
		"""Returns/sets a value that specifies if the snap grid is visible for the EMStructure."""
		return self.__IEMStructure.GridVisible


	@GridVisible.setter
	def GridVisible(self, value: bool):
		"""Returns/sets a value that specifies if the snap grid is visible for the EMStructure."""
		self.__IEMStructure.GridVisible = value


	@property
	def Info(self) -> CEMStructureInfo:
		"""Returns a reference to an Electromagnetic Structure Info object."""
		return CEMStructureInfo(self.__IEMStructure.Info)


	@property
	def IsForGeneral3DSimulate(self) -> bool:
		"""Returns a value indicating if the EMStructure object is enabled for general 3D simulation."""
		return self.__IEMStructure.IsForGeneral3DSimulate


	@property
	def LockLevel(self):
		"""Returns a value that specifies the lock level of the EMStructure object"""
		return self.__IEMStructure.LockLevel


	@property
	def MaterialLayers(self) -> CMaterialLayers:
		"""Returns a reference to a collection of MaterialLayer objects."""
		return CMaterialLayers(self.__IEMStructure.MaterialLayers)


	@property
	def Materials(self) -> CMaterials:
		"""Returns a reference to a collection of Material objects."""
		return CMaterials(self.__IEMStructure.Materials)


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IEMStructure.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__IEMStructure.Name = value


	@property
	def OptionSets(self) -> COptionSets:
		"""Returns a reference to a collection of OptionSet objects."""
		return COptionSets(self.__IEMStructure.OptionSets)


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__IEMStructure.Options)


	@property
	def Orthogonal(self) -> bool:
		"""Returns/sets a value which specifies if layout drawing should be only orthogonal."""
		return self.__IEMStructure.Orthogonal


	@Orthogonal.setter
	def Orthogonal(self, value: bool):
		"""Returns/sets a value which specifies if layout drawing should be only orthogonal."""
		self.__IEMStructure.Orthogonal = value


	@property
	def Ports(self) -> CEMPorts:
		"""Returns a reference to an EMPorts collection."""
		return CEMPorts(self.__IEMStructure.Ports)


	@property
	def ProcessDefinition(self) -> str:
		"""Returns/sets the name of the layout process definition associated with this EMStructure."""
		return self.__IEMStructure.ProcessDefinition


	@ProcessDefinition.setter
	def ProcessDefinition(self, value: str):
		"""Returns/sets the name of the layout process definition associated with this EMStructure."""
		self.__IEMStructure.ProcessDefinition = value


	@property
	def Properties(self) -> CProperties:
		"""Returns a reference to a collection of Property objects."""
		return CProperties(self.__IEMStructure.Properties)


	@property
	def ReadOnly(self) -> bool:
		"""Returns a value indicating if the EMStructure object is currently read-only."""
		return self.__IEMStructure.ReadOnly


	@property
	def Schematic(self) -> CSchematic:
		"""Returns a reference to a MWOffice Schematic object."""
		return CSchematic(self.__IEMStructure.Schematic)


	@property
	def SelectedObjects(self) -> CSelectedDrawingObjects:
		"""Returns a reference to a collection of DrawingObjects."""
		return CSelectedDrawingObjects(self.__IEMStructure.SelectedObjects)


	@property
	def ShapeModifiers(self) -> CShapeModifiers:
		"""Returns a reference to a collection of ShapeModifier objects."""
		return CShapeModifiers(self.__IEMStructure.ShapeModifiers)


	@property
	def Shapes(self) -> CShapes:
		"""Returns a reference to a collection of Shape objects."""
		return CShapes(self.__IEMStructure.Shapes)


	@property
	def SimulationDirty(self) -> bool:
		"""Returns if the current simulation state is dirty for the EMStructure object."""
		return self.__IEMStructure.SimulationDirty


	@property
	def SimulationLog(self) -> str:
		"""Returns the contents of the EM simulation log"""
		return self.__IEMStructure.SimulationLog


	@property
	def SimulationState(self) -> int:
		"""Returns the current simulation state for the EMStructure object."""
		return self.__IEMStructure.SimulationState


	@property
	def Simulator(self):
		"""Returns/sets the simulator for the EMStructure object."""
		return self.__IEMStructure.Simulator


	@Simulator.setter
	def Simulator(self, value: mwEmSimulator):
		"""Returns/sets the simulator for the EMStructure object."""
		self.__IEMStructure.Simulator = value


	@property
	def SnapToGrid(self) -> bool:
		"""Returns/sets a value which specifies if grid snapping is enabled for the EMStructure."""
		return self.__IEMStructure.SnapToGrid


	@SnapToGrid.setter
	def SnapToGrid(self, value: bool):
		"""Returns/sets a value which specifies if grid snapping is enabled for the EMStructure."""
		self.__IEMStructure.SnapToGrid = value


	def TestPoints(self, SimulationVendorName: str) -> CTestPoints:
		"""Returns a reference to a collection of TestPoint objects."""
		return CTestPoints(self.__IEMStructure.TestPoints(SimulationVendorName))


	@property
	def ThreeDViews(self) -> CThreeDViews:
		"""Returns a reference to a MWOffice 3DViews collection."""
		return CThreeDViews(self.__IEMStructure.ThreeDViews)


	@property
	def UseProjectFrequencies(self) -> bool:
		"""Returns/sets a value which specifies if the global project frequencies should be used for analysis."""
		return self.__IEMStructure.UseProjectFrequencies


	@UseProjectFrequencies.setter
	def UseProjectFrequencies(self, value: bool):
		"""Returns/sets a value which specifies if the global project frequencies should be used for analysis."""
		self.__IEMStructure.UseProjectFrequencies = value


	@property
	def UseProjectOptions(self) -> bool:
		"""Returns/sets a value which specifies if the global project options should be used."""
		return self.__IEMStructure.UseProjectOptions


	@UseProjectOptions.setter
	def UseProjectOptions(self, value: bool):
		"""Returns/sets a value which specifies if the global project options should be used."""
		self.__IEMStructure.UseProjectOptions = value


	@property
	def Views(self) -> CViews:
		"""Returns a reference to a MWOffive Views collection."""
		return CViews(self.__IEMStructure.Views)


	@property
	def Windows(self) -> CWindows:
		"""Returns a reference to a collection of Window objects."""
		return CWindows(self.__IEMStructure.Windows)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# EMStructures
class CEMStructures:
	"""A collection of MWOffice EMStructure objects."""
	def __init__(self, emstructures):
		self.__IEMStructures = emstructures

	def _get_inner(self):
		return self.__IEMStructures


	def Add(self, StructureName: str) -> CEMStructure:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CEMStructure(self.__IEMStructures.Add(StructureName))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IEMStructures.Remove(Index)


	def Import(self, Filename: str) -> CEMStructure:
		"""Adds an object to the collection from a file and returns a reference to the created object."""
		return CEMStructure(self.__IEMStructures.Import(Filename))


	def LinkTo(self, Filename: str) -> CEMStructure:
		"""Adds an Electromagnetic structure referencing an external file and returns a reference to the created object."""
		return CEMStructure(self.__IEMStructures.LinkTo(Filename))


	def Copy(self, Index, NewName: str = "") -> CEMStructure:
		"""Copies an object from another object collection into this object collection."""
		return CEMStructure(self.__IEMStructures.Copy(Index, NewName))


	def AddEx(self, StructureName: str, Simulator: mwEmSimulator) -> CEMStructure:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CEMStructure(self.__IEMStructures.AddEx(StructureName, Simulator))


	def CreateInitRecord(self) -> CEMInitializationRecord:
		"""Returns a reference to a EMInitializationRecord object."""
		return CEMInitializationRecord(self.__IEMStructures.CreateInitRecord())


	def AddInit(self, StructureName: str, Simulator: mwEmSimulator, pInitRecord: CEMInitializationRecord) -> CEMStructure:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CEMStructure(self.__IEMStructures.AddInit(StructureName, Simulator, pInitRecord._get_inner()))


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__IEMStructures.GetUniqueName(baseName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IEMStructures.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IEMStructures.Exists(Index)


	def Item(self, Index) -> CEMStructure:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CEMStructure(self.__IEMStructures.Item(Index))


	def __get_Item(self, Index) -> CEMStructure:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CEMStructure(self.__IEMStructures.Item(Index))


	def __call__(self, index) -> CEMStructure:
		return self.__get_Item(index)


	def __iter__(self) -> CEMStructure:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IEMStructures.Count


	def __getitem__(self, index) -> Union[CEMStructure, List[CEMStructure]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__IEMStructures.Options)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ExternalEditor
class CExternalEditor:
	"""A MWOffice ExternalEditor object."""
	def __init__(self, externaleditor):
		self.__IExternalEditor = externaleditor

	def _get_inner(self):
		return self.__IExternalEditor


	def Update(self) -> bool:
		"""Sends a message to have the ExternalEditor to update."""
		return self.__IExternalEditor.Update()


	def Close(self) -> bool:
		"""Sends a message to have the ExternalEditor close."""
		return self.__IExternalEditor.Close()


	def Save(self) -> bool:
		"""Sends a message to have the ExternalEditor save."""
		return self.__IExternalEditor.Save()


	def Show(self, Show: mwEECmdShow) -> bool:
		"""Sends a message to have the ExternalEditor show or hide."""
		return self.__IExternalEditor.Show(Show)


	def RunScript(self, script: str) -> bool:
		"""Passes a script to the ExternalEditor to execute."""
		return self.__IExternalEditor.RunScript(script)



	@property
	def CommandLine(self) -> str:
		"""Returns the command line passed to the ExternalEditor when opened."""
		return self.__IExternalEditor.CommandLine


	@property
	def Extension(self) -> str:
		"""Returns the file name extension processed by the ExternalEditor."""
		return self.__IExternalEditor.Extension


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IExternalEditor.Name


	@property
	def Path(self) -> str:
		"""Returns the path to the ExternalEditor executable."""
		return self.__IExternalEditor.Path


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# EM3DStructure
class CEM3DStructure:
	"""A MWOffice EM3DStructure object."""
	def __init__(self, em3dstructure):
		self.__IEM3DStructure = em3dstructure

	def _get_inner(self):
		return self.__IEM3DStructure


	def OpenExternalEditor(self, Type: mwExternalEditorType, cmdShow: mwEECmdShow = 0) -> CExternalEditor:
		"""Opens the EM3DStructure design in an external editor"""
		return CExternalEditor(self.__IEM3DStructure.OpenExternalEditor(Type, cmdShow))


	def Export(self, Filename: str) -> bool:
		"""Exports the EM3DStructure object to a specified file."""
		return self.__IEM3DStructure.Export(Filename)


	def NewWindow(self, __MIDL__IEM3DStructure0000: mwWindowType) -> CWindow:
		"""Creates a new window on the EM3DStructure object."""
		return CWindow(self.__IEM3DStructure.NewWindow(__MIDL__IEM3DStructure0000))


	def Activate(self) -> None:
		"""Brings any existing active window on the EM3DStructure object to the foreground."""
		self.__IEM3DStructure.Activate()


	def Update(self) -> None:
		"""Update the structure to refresh any changes made by external editors."""
		self.__IEM3DStructure.Update()


	def CopyToClipboard(self) -> bool:
		"""Copies the object to the system clipboard."""
		return self.__IEM3DStructure.CopyToClipboard()


	def CopyViewToClipboard(self) -> bool:
		"""Copies the object to the system clipboard."""
		return self.__IEM3DStructure.CopyViewToClipboard()


	def PrintOut(self) -> bool:
		"""Sends the object to the current printer."""
		return self.__IEM3DStructure.PrintOut()


	def PrintView(self) -> bool:
		"""Sends the object to the current printer."""
		return self.__IEM3DStructure.PrintView()


	def Simulate(self, DefDataSetName: str) -> bool:
		"""Submit the EM3DStructure document for simulation."""
		return self.__IEM3DStructure.Simulate(DefDataSetName)


	def InvokeCommand(self, CommandName: str, Arguments, pRet) -> None:
		"""Invoke a menu command by specifying the name for the command. Arguments must be suppled for any required input."""
		self.__IEM3DStructure.InvokeCommand(CommandName, Arguments, pRet)


	def StartCommand(self, CommandName: str, pRet) -> None:
		"""Start a menu command by specifying the name for the command. The user will need to complete any required input."""
		self.__IEM3DStructure.StartCommand(CommandName, pRet)


	def EndActiveCommand(self) -> bool:
		"""Terminates the currently active command for this EM3DStructure object."""
		return self.__IEM3DStructure.EndActiveCommand()



	@property
	def Changed(self) -> bool:
		"""Returns/sets a value that indicates if the EM3DStructure is changed."""
		return self.__IEM3DStructure.Changed


	@Changed.setter
	def Changed(self, value: bool):
		"""Returns/sets a value that indicates if the EM3DStructure is changed."""
		self.__IEM3DStructure.Changed = value


	@property
	def CommandActive(self) -> bool:
		"""Returns a value indicating if there is command currently active for this EM3DStructure object."""
		return self.__IEM3DStructure.CommandActive


	@property
	def Embedded(self) -> bool:
		"""Returns a value that indicates if the EM3DStructure document is embedded in the project or external."""
		return self.__IEM3DStructure.Embedded


	@property
	def Enabled(self) -> bool:
		"""Returns/sets a value that indicates if the EM3DStructure is enabled."""
		return self.__IEM3DStructure.Enabled


	@Enabled.setter
	def Enabled(self, value: bool):
		"""Returns/sets a value that indicates if the EM3DStructure is enabled."""
		self.__IEM3DStructure.Enabled = value


	@property
	def FilePath(self) -> str:
		"""Returns a path to this EM3DStructure document."""
		return self.__IEM3DStructure.FilePath


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IEM3DStructure.Name


	@Name.setter
	def Name(self, value: str):
		"""Returns/Sets the name used in code to identify an object."""
		self.__IEM3DStructure.Name = value


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__IEM3DStructure.Options)


	@property
	def Properties(self) -> CProperties:
		"""Returns a reference to a collection of Property objects."""
		return CProperties(self.__IEM3DStructure.Properties)


	@property
	def ReadOnly(self) -> bool:
		"""Returns a value indicating if the EM3DStructure object is currently read-only."""
		return self.__IEM3DStructure.ReadOnly


	@property
	def Schematic(self) -> CSchematic:
		"""Returns a reference to a MWOffice Schematic object."""
		return CSchematic(self.__IEM3DStructure.Schematic)


	@property
	def UseProjectOptions(self) -> bool:
		"""Returns/sets a value which specifies if the global project options should be used."""
		return self.__IEM3DStructure.UseProjectOptions


	@UseProjectOptions.setter
	def UseProjectOptions(self, value: bool):
		"""Returns/sets a value which specifies if the global project options should be used."""
		self.__IEM3DStructure.UseProjectOptions = value


	@property
	def Windows(self) -> CWindows:
		"""Returns a reference to a collection of Window objects."""
		return CWindows(self.__IEM3DStructure.Windows)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# EM3DStructures
class CEM3DStructures:
	"""A collection of EM3DStructure objects."""
	def __init__(self, em3dstructures):
		self.__IEM3DStructures = em3dstructures

	def _get_inner(self):
		return self.__IEM3DStructures


	def Add(self, StructureName: str) -> CEM3DStructure:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CEM3DStructure(self.__IEM3DStructures.Add(StructureName))


	def AddLinked(self, StructureName: str, Filename: str, ppVal) -> None:
		"""Adds an object to the collection and returns a reference to the created object."""
		self.__IEM3DStructures.AddLinked(StructureName, Filename, ppVal)


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IEM3DStructures.Remove(Index)


	def Import(self, Filename: str) -> CEM3DStructure:
		"""Adds an object to the collection from a file and returns a reference to the created object."""
		return CEM3DStructure(self.__IEM3DStructures.Import(Filename))


	def LinkTo(self, Filename: str) -> CEM3DStructure:
		"""Adds an Electromagnetic structure referencing an external file and returns a reference to the created object."""
		return CEM3DStructure(self.__IEM3DStructures.LinkTo(Filename))


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__IEM3DStructures.GetUniqueName(baseName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IEM3DStructures.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IEM3DStructures.Exists(Index)


	def Item(self, Index) -> CEM3DStructure:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CEM3DStructure(self.__IEM3DStructures.Item(Index))


	def __get_Item(self, Index) -> CEM3DStructure:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CEM3DStructure(self.__IEM3DStructures.Item(Index))


	def __call__(self, index) -> CEM3DStructure:
		return self.__get_Item(index)


	def __iter__(self) -> CEM3DStructure:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IEM3DStructures.Count


	def __getitem__(self, index) -> Union[CEM3DStructure, List[CEM3DStructure]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__IEM3DStructures.Options)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Face
class CFace:
	"""An MWOffice Face object."""
	def __init__(self, face):
		self.__IFace = face

	def _get_inner(self):
		return self.__IFace



	@property
	def AdjacentObjects(self) -> CObjectNames:
		"""Returns a reference to a collection of MWOffce ObjectName objects."""
		return CObjectNames(self.__IFace.AdjacentObjects)


	@property
	def Alignment(self):
		"""Returns/sets a value which specifies the alignment style of a Face object."""
		return self.__IFace.Alignment


	@Alignment.setter
	def Alignment(self, value: mwFaceAlignment):
		"""Returns/sets a value which specifies the alignment style of a Face object."""
		self.__IFace.Alignment = value


	@property
	def AreaEnabled(self) -> bool:
		"""Returns/sets if the area portion of an area pin face is enabled or if it is being treated as a segment face."""
		return self.__IFace.AreaEnabled


	@AreaEnabled.setter
	def AreaEnabled(self, value: bool):
		"""Returns/sets if the area portion of an area pin face is enabled or if it is being treated as a segment face."""
		self.__IFace.AreaEnabled = value


	@property
	def ConnectType(self) -> int:
		"""Returns/set the connect type for this MWOffice Face object."""
		return self.__IFace.ConnectType


	@ConnectType.setter
	def ConnectType(self, value: int):
		"""Returns/set the connect type for this MWOffice Face object."""
		self.__IFace.ConnectType = value


	@property
	def Connected(self) -> bool:
		"""Returns if the face is connected to a physical net."""
		return self.__IFace.Connected


	@property
	def ConnectedNetName(self) -> str:
		"""Returns the name of the PhysicalNet object the face is connected to or an empty string if it is not connected."""
		return self.__IFace.ConnectedNetName


	@property
	def ConnectionPoint(self) -> CVertex:
		"""Returns a reference to a Vertex object."""
		return CVertex(self.__IFace.ConnectionPoint)


	@property
	def DrawingLayer(self) -> str:
		"""Returns the name of the drawing layer associated with this Face object."""
		return self.__IFace.DrawingLayer


	@property
	def ElementName(self) -> str:
		"""Returns the name of the element associated with this Face object."""
		return self.__IFace.ElementName


	@property
	def Flipped(self) -> bool:
		"""Returns/sets a value which specifies if the Face object is flipped."""
		return self.__IFace.Flipped


	@Flipped.setter
	def Flipped(self, value: bool):
		"""Returns/sets a value which specifies if the Face object is flipped."""
		self.__IFace.Flipped = value


	@property
	def GroupNumber(self) -> int:
		"""Returns/sets the group number for this MWOffice Face object."""
		return self.__IFace.GroupNumber


	@GroupNumber.setter
	def GroupNumber(self, value: int):
		"""Returns/sets the group number for this MWOffice Face object."""
		self.__IFace.GroupNumber = value


	@property
	def GroupType(self):
		"""Returns/sets the group type for this MWOffice Face object."""
		return self.__IFace.GroupType


	@GroupType.setter
	def GroupType(self, value: mwFaceGroupType):
		"""Returns/sets the group type for this MWOffice Face object."""
		self.__IFace.GroupType = value


	@property
	def Highlight(self) -> bool:
		"""Returns/sets the highlight state for this face object."""
		return self.__IFace.Highlight


	@Highlight.setter
	def Highlight(self, value: bool):
		"""Returns/sets the highlight state for this face object."""
		self.__IFace.Highlight = value


	@property
	def LayerProperty(self):
		"""Returns/sets a value which specified the multi-layer drawing property of a Face object."""
		return self.__IFace.LayerProperty


	@LayerProperty.setter
	def LayerProperty(self, value: mwFaceMultiLayerProperty):
		"""Returns/sets a value which specified the multi-layer drawing property of a Face object."""
		self.__IFace.LayerProperty = value


	@property
	def NodeNumber(self) -> int:
		"""Returns the unique node number of the Face object."""
		return self.__IFace.NodeNumber


	@property
	def Offset(self) -> COffset:
		"""Returns a reference to a Vertex object."""
		return COffset(self.__IFace.Offset)


	@property
	def OffsetAngle(self) -> float:
		"""Returns/sets the offset angle of the Face object."""
		return self.__IFace.OffsetAngle


	@OffsetAngle.setter
	def OffsetAngle(self, value: float):
		"""Returns/sets the offset angle of the Face object."""
		self.__IFace.OffsetAngle = value


	@property
	def PortNumber(self) -> int:
		"""Returns the port number of a Face object."""
		return self.__IFace.PortNumber


	@PortNumber.setter
	def PortNumber(self, value: int):
		"""Returns the port number of a Face object."""
		self.__IFace.PortNumber = value


	@property
	def SnapToAdjacent(self) -> bool:
		"""Returns/sets a value which specifies if the Face object should snap to an adjacent face."""
		return self.__IFace.SnapToAdjacent


	@SnapToAdjacent.setter
	def SnapToAdjacent(self, value: bool):
		"""Returns/sets a value which specifies if the Face object should snap to an adjacent face."""
		self.__IFace.SnapToAdjacent = value


	@property
	def SnapToObject(self) -> str:
		"""Returns/sets the snap to object for this face, format <name>.<id>:<port number>, for example MLIN:TL2:1."""
		return self.__IFace.SnapToObject


	@SnapToObject.setter
	def SnapToObject(self, value: str):
		"""Returns/sets the snap to object for this face, format <name>.<id>:<port number>, for example MLIN:TL2:1."""
		self.__IFace.SnapToObject = value


	@property
	def SubPortNumber(self) -> int:
		"""Returns the sub port number of the Face object."""
		return self.__IFace.SubPortNumber


	@property
	def Type(self):
		"""Returns the type, segment or area pin, of this face object."""
		return self.__IFace.Type


	@property
	def Vertices(self) -> CVertices:
		"""Returns a reference to a collection of Vertex objects."""
		return CVertices(self.__IFace.Vertices)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Faces
class CFaces:
	"""A collection of MWOffice Face objects."""
	def __init__(self, faces):
		self.__IFaces = faces

	def _get_inner(self):
		return self.__IFaces



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IFaces.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IFaces.Exists(Index)


	def Item(self, Index) -> CFace:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CFace(self.__IFaces.Item(Index))


	def __get_Item(self, Index) -> CFace:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CFace(self.__IFaces.Item(Index))


	def __call__(self, index) -> CFace:
		return self.__get_Item(index)


	def __iter__(self) -> CFace:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IFaces.Count


	def __getitem__(self, index) -> Union[CFace, List[CFace]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# CoordinateEntry
class CCoordinateEntry:
	"""A MWOffice CoordinateEntry object."""
	def __init__(self, coordinateentry):
		self.__ICoordinateEntry = coordinateentry

	def _get_inner(self):
		return self.__ICoordinateEntry


	def EnterAbsolute(self, x: float, y: float) -> bool:
		"""Method enters an absolute coordinate through the coordinate entry object."""
		return self.__ICoordinateEntry.EnterAbsolute(x, y)


	def EnterRelative(self, dx: float, dy: float) -> bool:
		"""Method enters a relative coordinate through the coordinate entry object."""
		return self.__ICoordinateEntry.EnterRelative(dx, dy)


	def EnterRadius(self, r: float) -> bool:
		"""Method enters a radius coordinate through the coordinate entry object."""
		return self.__ICoordinateEntry.EnterRadius(r)


	def EnterDoubleClick(self) -> bool:
		"""Method enters the equivalent of a left mouse button double click through the coordinate entry object."""
		return self.__ICoordinateEntry.EnterDoubleClick()


	def EnterReturnKeyPress(self) -> bool:
		"""Method enters the equivalent of a return key press through teh coordinate entry object."""
		return self.__ICoordinateEntry.EnterReturnKeyPress()



	def EntryMode(self, modeType: mwCoordEntryMode) -> bool:
		"""Method allows checking the coordinate entry mode bits."""
		return self.__ICoordinateEntry.EntryMode(modeType)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Layout
class CLayout:
	"""An MWOffice Layout object."""
	def __init__(self, layout):
		self.__ILayout = layout

	def _get_inner(self):
		return self.__ILayout


	def CopyToClipboard(self) -> None:
		"""Copies the object to the system clipboard."""
		self.__ILayout.CopyToClipboard()


	def CreateSnapshot(self) -> CSnapshot:
		"""Returns a reference to a layout Snapshot object."""
		return CSnapshot(self.__ILayout.CreateSnapshot())


	def Export(self, Filename: str, ExportMap, Flat: bool = 0) -> bool:
		"""Exports a design document file from MWOffice."""
		return self.__ILayout.Export(Filename, ExportMap, Flat)


	def Paste(self, x: float, y: float, CCWRotation: float = 0, Flipped: bool = 0) -> bool:
		"""Pastes the system clipboard to the object."""
		return self.__ILayout.Paste(x, y, CCWRotation, Flipped)


	def CreateCell(self, LibraryName: str, CellName: str, IncludeObjects: mwObjectIncludeType = 1, FlattenLayout: bool = -1) -> CCell:
		"""Creates a GDS cell from the layout."""
		return CCell(self.__ILayout.CreateCell(LibraryName, CellName, IncludeObjects, FlattenLayout))


	def PrintOut(self) -> None:
		"""Sends the object to the current printer."""
		self.__ILayout.PrintOut()


	def SnapTogether(self, SnapType: mwLayoutSnapType) -> None:
		"""Snaps together the layout objects."""
		self.__ILayout.SnapTogether(SnapType)


	def Activate(self) -> None:
		"""Activates the objects."""
		self.__ILayout.Activate()


	def NewWindow(self, WindowType: mwLayoutWindowType) -> CWindow:
		"""Displays the object in new window."""
		return CWindow(self.__ILayout.NewWindow(WindowType))


	def Update(self) -> None:
		"""Updates the size and positions of objects in the layout"""
		self.__ILayout.Update()


	def InvokeCommand(self, CommandName: str, Arguments, pRet) -> None:
		"""Invoke a menu command by specifying the name for the command. Arguments must be supplied for all required input."""
		self.__ILayout.InvokeCommand(CommandName, Arguments, pRet)


	def Refresh(self) -> None:
		"""Refresh any windows open on the layout document."""
		self.__ILayout.Refresh()


	def CopyToClipboardEx(self, Type: mwDesignViewType) -> bool:
		"""Copies the object to the system clipboard."""
		return self.__ILayout.CopyToClipboardEx(Type)


	def RegenerateLayout(self) -> bool:
		"""Deletes and regenerates all the cell objects in layout, may cause objects to shift in position."""
		return self.__ILayout.RegenerateLayout()


	def PasteRelative(self, dx: float, dy: float, CCWRotation: float = 0, Flipped: bool = 0) -> bool:
		"""Pastes the system clipboard to the object."""
		return self.__ILayout.PasteRelative(dx, dy, CCWRotation, Flipped)


	def CopyViewToClipboard(self, Type: mwDesignViewType = 0) -> bool:
		"""Copies the object to the system clipboard."""
		return self.__ILayout.CopyViewToClipboard(Type)


	def PrintOutEx(self, Type: mwDesignViewType = 0) -> bool:
		"""Sends the object to the current printer."""
		return self.__ILayout.PrintOutEx(Type)


	def PrintView(self, Type: mwDesignViewType = 0) -> bool:
		"""Sends the object to the current printer."""
		return self.__ILayout.PrintView(Type)


	def StartCommand(self, CommandName: str, pRet) -> None:
		"""Start a menu command by specifying the name for the command. The user will need to complete any required input."""
		self.__ILayout.StartCommand(CommandName, pRet)


	def EndActiveCommand(self) -> bool:
		"""Ends the currently active command for this Layout object."""
		return self.__ILayout.EndActiveCommand()



	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__ILayout.Boundary)


	@property
	def CanPaste(self) -> bool:
		"""Returns a value that determines the clipboard contents can be pasted to the object."""
		return self.__ILayout.CanPaste


	@property
	def CommandActive(self) -> bool:
		"""Returns a value indicating if there is command currently active for this Layout object."""
		return self.__ILayout.CommandActive


	@property
	def ConnectivityHighlighter(self) -> CConnectivityHighlighter:
		"""Returns a reference to an MWOffice ConnectivityHighlighter object."""
		return CConnectivityHighlighter(self.__ILayout.ConnectivityHighlighter)


	@property
	def CoordinateEntry(self) -> CCoordinateEntry:
		"""Returns a reference to a CoordinateEntry object."""
		return CCoordinateEntry(self.__ILayout.CoordinateEntry)


	@property
	def DesignRuleChecker(self) -> CDesignRuleChecker:
		"""Returns a reference to a DesignRuleChecker object."""
		return CDesignRuleChecker(self.__ILayout.DesignRuleChecker)


	@property
	def DrawingObjects(self) -> CDrawingObjects:
		"""Returns a reference to a collection of DrawingObjects."""
		return CDrawingObjects(self.__ILayout.DrawingObjects)


	@property
	def EMPorts(self) -> CEMPorts:
		"""Returns a reference to an EMPorts collection."""
		return CEMPorts(self.__ILayout.EMPorts)


	@property
	def Equations(self) -> CEquations:
		"""Returns a reference to a collection of Equation objects."""
		return CEquations(self.__ILayout.Equations)


	@property
	def FreezeViewUpdates(self) -> bool:
		"""Returns/sets a property that will suspend layout view updates during changes."""
		return self.__ILayout.FreezeViewUpdates


	@FreezeViewUpdates.setter
	def FreezeViewUpdates(self, value: bool):
		"""Returns/sets a property that will suspend layout view updates during changes."""
		self.__ILayout.FreezeViewUpdates = value


	@property
	def GridSnapMultiple(self) -> float:
		"""Returns/sets a value which specifies the grid snap multiple."""
		return self.__ILayout.GridSnapMultiple


	@GridSnapMultiple.setter
	def GridSnapMultiple(self, value: float):
		"""Returns/sets a value which specifies the grid snap multiple."""
		self.__ILayout.GridSnapMultiple = value


	@property
	def GridVisible(self) -> bool:
		"""Returns/sets a value that specifies if the snap grid is visible for the Layout."""
		return self.__ILayout.GridVisible


	@GridVisible.setter
	def GridVisible(self, value: bool):
		"""Returns/sets a value that specifies if the snap grid is visible for the Layout."""
		self.__ILayout.GridVisible = value


	@property
	def Info(self) -> CLayoutInfo:
		"""Returns a reference to a MWOffice LayoutInfo object."""
		return CLayoutInfo(self.__ILayout.Info)


	@property
	def LayoutTests(self) -> CComponentTests:
		"""Returns a reference to a collection of ComponentTest objects."""
		return CComponentTests(self.__ILayout.LayoutTests)


	@property
	def LayoutVsSchematicChecker(self) -> CLayoutVsSchematicChecker:
		"""Returns a reference to a LayoutVsSchematicChecker object."""
		return CLayoutVsSchematicChecker(self.__ILayout.LayoutVsSchematicChecker)


	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__ILayout.Name


	@property
	def Options(self) -> COptions:
		"""Returns a reference to a collection of Option objects."""
		return COptions(self.__ILayout.Options)


	@property
	def Orthogonal(self) -> bool:
		"""Returns/sets a value which specifies if layout drawing should be only orthogonal."""
		return self.__ILayout.Orthogonal


	@Orthogonal.setter
	def Orthogonal(self, value: bool):
		"""Returns/sets a value which specifies if layout drawing should be only orthogonal."""
		self.__ILayout.Orthogonal = value


	@property
	def PhysicalNets(self) -> CPhysicalNets:
		"""Returns a reference to a MWOffice PhysicalNets collection."""
		return CPhysicalNets(self.__ILayout.PhysicalNets)


	@property
	def ProcessDefinition(self) -> str:
		"""Returns/sets the name of the layout process definition associated with this layout."""
		return self.__ILayout.ProcessDefinition


	@ProcessDefinition.setter
	def ProcessDefinition(self, value: str):
		"""Returns/sets the name of the layout process definition associated with this layout."""
		self.__ILayout.ProcessDefinition = value


	@property
	def ReadOnly(self) -> bool:
		"""Returns a value indicating if the Layout object is currently read-only."""
		return self.__ILayout.ReadOnly


	@property
	def SelectedObjects(self) -> CSelectedDrawingObjects:
		"""Returns a reference to a collection of DrawingObjects."""
		return CSelectedDrawingObjects(self.__ILayout.SelectedObjects)


	@property
	def ShapeModifiers(self) -> CShapeModifiers:
		"""Returns a reference to a collection of ShapeModifier objects."""
		return CShapeModifiers(self.__ILayout.ShapeModifiers)


	@property
	def SnapToGrid(self) -> bool:
		"""Returns/sets a value which specifies if grid snapping is enabled."""
		return self.__ILayout.SnapToGrid


	@SnapToGrid.setter
	def SnapToGrid(self, value: bool):
		"""Returns/sets a value which specifies if grid snapping is enabled."""
		self.__ILayout.SnapToGrid = value


	@property
	def ThreeDViews(self) -> CThreeDViews:
		"""Returns a reference to a MWOffice 3DViews collection."""
		return CThreeDViews(self.__ILayout.ThreeDViews)


	@property
	def UseProjectOptions(self) -> bool:
		"""Returns/sets a value which specifies if the global project options should be used."""
		return self.__ILayout.UseProjectOptions


	@UseProjectOptions.setter
	def UseProjectOptions(self, value: bool):
		"""Returns/sets a value which specifies if the global project options should be used."""
		self.__ILayout.UseProjectOptions = value


	@property
	def Views(self) -> CViews:
		"""Returns a reference to a MWOffive Views collection."""
		return CViews(self.__ILayout.Views)


	@property
	def Windows(self) -> CWindows:
		"""Returns a reference to a collection of Window objects."""
		return CWindows(self.__ILayout.Windows)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# CellEditorInfo
class CCellEditorInfo:
	"""A MWOffice CellEditorInfo object."""
	def __init__(self, celleditorinfo):
		self.__ICellEditorInfo = celleditorinfo

	def _get_inner(self):
		return self.__ICellEditorInfo



	@property
	def CellCount(self) -> int:
		"""Returns a count of the Artwork cell objects in the MWOffice CellEditor object."""
		return self.__ICellEditorInfo.CellCount


	@property
	def PortCount(self) -> int:
		"""Returns a count of the number of cell ports in the MWOffice CellEditor object."""
		return self.__ICellEditorInfo.PortCount


	@property
	def ShapeCount(self) -> int:
		"""Returns a count of the shapes in the MWOffice CellEditor object."""
		return self.__ICellEditorInfo.ShapeCount


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# CellEditor
class CCellEditor:
	"""An MWOffice CellEditor object."""
	def __init__(self, celleditor):
		self.__ICellEditor = celleditor

	def _get_inner(self):
		return self.__ICellEditor


	def CopyToClipboard(self) -> None:
		"""Copies the object to the system clipboard."""
		self.__ICellEditor.CopyToClipboard()


	def Export(self, Filename: str, ExportMap, Flat: bool = 0) -> bool:
		"""Exports a design document file from MWOffice."""
		return self.__ICellEditor.Export(Filename, ExportMap, Flat)


	def Paste(self, x: float, y: float, CCWRotation: float = 0, Flipped: bool = 0) -> bool:
		"""Pastes the system clipboard to the object."""
		return self.__ICellEditor.Paste(x, y, CCWRotation, Flipped)


	def CreateCell(self, LibraryName: str, CellName: str, IncludeObjects: mwObjectIncludeType = 1, FlattenLayout: bool = -1) -> CCell:
		"""Creates a GDS cell from the layout."""
		return CCell(self.__ICellEditor.CreateCell(LibraryName, CellName, IncludeObjects, FlattenLayout))


	def PrintOut(self) -> None:
		"""Sends the object to the current printer."""
		self.__ICellEditor.PrintOut()


	def Activate(self) -> None:
		"""Activates the objects."""
		self.__ICellEditor.Activate()


	def NewWindow(self) -> CWindow:
		"""Displays the object in new window."""
		return CWindow(self.__ICellEditor.NewWindow())


	def Update(self) -> None:
		"""Updates the size and positions of objects in the layout"""
		self.__ICellEditor.Update()


	def InvokeCommand(self, CommandName: str, Arguments, pRet) -> None:
		"""Invoke a menu command by specifying the name for the command. Any required input will need to be supplied in arguments."""
		self.__ICellEditor.InvokeCommand(CommandName, Arguments, pRet)


	def Refresh(self) -> None:
		"""Refresh any windows open on the layout document."""
		self.__ICellEditor.Refresh()


	def SaveCell(self) -> bool:
		"""Saves any edits to the cell back to the project."""
		return self.__ICellEditor.SaveCell()


	def CopyToClipboardEx(self, Type: mwDesignViewType) -> bool:
		"""Copies the object to the system clipboard."""
		return self.__ICellEditor.CopyToClipboardEx(Type)


	def CopyViewToClipboard(self, Type: mwDesignViewType = 0) -> bool:
		"""Copies the object to the system clipboard."""
		return self.__ICellEditor.CopyViewToClipboard(Type)


	def PasteRelative(self, dx: float, dy: float, CCWRotation: float = 0, Flipped: bool = 0) -> bool:
		"""Pastes the system clipboard to the object."""
		return self.__ICellEditor.PasteRelative(dx, dy, CCWRotation, Flipped)


	def CreateSnapshot(self) -> CSnapshot:
		"""Returns a reference to a layout Snapshot object."""
		return CSnapshot(self.__ICellEditor.CreateSnapshot())


	def StartCommand(self, CommandName: str, pRet) -> None:
		"""Start a menu command by specifying the name for the command. Any required input will need to be supplied by the user interactively."""
		self.__ICellEditor.StartCommand(CommandName, pRet)


	def PrintOutEx(self, Type: mwDesignViewType = 0) -> bool:
		"""Sends the object to the current printer."""
		return self.__ICellEditor.PrintOutEx(Type)


	def PrintView(self, Type: mwDesignViewType = 0) -> bool:
		"""Sends the object to the current printer."""
		return self.__ICellEditor.PrintView(Type)


	def NewWindowEx(self, WindowType: mwLayoutWindowType) -> CWindow:
		"""Displays the object in new window."""
		return CWindow(self.__ICellEditor.NewWindowEx(WindowType))


	def EndActiveCommand(self) -> bool:
		"""Ends the currently active command for this CellEditor object."""
		return self.__ICellEditor.EndActiveCommand()



	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__ICellEditor.Boundary)


	@property
	def CanPaste(self) -> bool:
		"""Returns a value that determines the clipboard contents can be pasted to the object."""
		return self.__ICellEditor.CanPaste


	@property
	def CellEditorTests(self) -> CComponentTests:
		"""Returns a reference to a collection of ComponentTest objects."""
		return CComponentTests(self.__ICellEditor.CellEditorTests)


	@property
	def CommandActive(self) -> bool:
		"""Returns a value indicating if there is command currently active for this CellEditor object."""
		return self.__ICellEditor.CommandActive


	@property
	def CoordinateEntry(self) -> CCoordinateEntry:
		"""Returns a reference to a CoordinateEntry object."""
		return CCoordinateEntry(self.__ICellEditor.CoordinateEntry)


	@property
	def DesignRuleChecker(self) -> CDesignRuleChecker:
		"""Returns a reference to a DesignRuleChecker object."""
		return CDesignRuleChecker(self.__ICellEditor.DesignRuleChecker)


	@property
	def DrawingObjects(self) -> CDrawingObjects:
		"""Returns a reference to a collection of DrawingObjects."""
		return CDrawingObjects(self.__ICellEditor.DrawingObjects)


	@property
	def GridSnapMultiple(self) -> float:
		"""Returns/sets a value which specifies the grid snap multiple."""
		return self.__ICellEditor.GridSnapMultiple


	@GridSnapMultiple.setter
	def GridSnapMultiple(self, value: float):
		"""Returns/sets a value which specifies the grid snap multiple."""
		self.__ICellEditor.GridSnapMultiple = value


	@property
	def GridVisible(self) -> bool:
		"""Returns/sets a value that specifies if the snap grid is visible for the Layout."""
		return self.__ICellEditor.GridVisible


	@GridVisible.setter
	def GridVisible(self, value: bool):
		"""Returns/sets a value that specifies if the snap grid is visible for the Layout."""
		self.__ICellEditor.GridVisible = value


	@property
	def Info(self) -> CCellEditorInfo:
		"""Returns a reference to a MWOffice CellEditorInfo object."""
		return CCellEditorInfo(self.__ICellEditor.Info)


	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__ICellEditor.Name


	@property
	def Orthogonal(self) -> bool:
		"""Returns/sets a value which specifies if layout drawing should be only orthogonal."""
		return self.__ICellEditor.Orthogonal


	@Orthogonal.setter
	def Orthogonal(self, value: bool):
		"""Returns/sets a value which specifies if layout drawing should be only orthogonal."""
		self.__ICellEditor.Orthogonal = value


	@property
	def SelectedObjects(self) -> CSelectedDrawingObjects:
		"""Returns a reference to a collection of DrawingObjects."""
		return CSelectedDrawingObjects(self.__ICellEditor.SelectedObjects)


	@property
	def SnapToGrid(self) -> bool:
		"""Returns/sets a value which specifies if grid snapping is enabled."""
		return self.__ICellEditor.SnapToGrid


	@SnapToGrid.setter
	def SnapToGrid(self, value: bool):
		"""Returns/sets a value which specifies if grid snapping is enabled."""
		self.__ICellEditor.SnapToGrid = value


	@property
	def ThreeDViews(self) -> CThreeDViews:
		"""Returns a reference to a MWOffice 3DViews collection."""
		return CThreeDViews(self.__ICellEditor.ThreeDViews)


	@property
	def Views(self) -> CViews:
		"""Returns a reference to a MWOffive Views collection."""
		return CViews(self.__ICellEditor.Views)


	@property
	def Windows(self) -> CWindows:
		"""Returns a reference to a collection of Window objects."""
		return CWindows(self.__ICellEditor.Windows)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# CellEditors
class CCellEditors:
	"""A collection of MWOffice CellEditor objects."""
	def __init__(self, celleditors):
		self.__ICellEditors = celleditors

	def _get_inner(self):
		return self.__ICellEditors



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ICellEditors.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ICellEditors.Exists(Index)


	def Item(self, Index) -> CCellEditor:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CCellEditor(self.__ICellEditors.Item(Index))


	def __get_Item(self, Index) -> CCellEditor:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CCellEditor(self.__ICellEditors.Item(Index))


	def __call__(self, index) -> CCellEditor:
		return self.__get_Item(index)


	def __iter__(self) -> CCellEditor:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ICellEditors.Count


	def __getitem__(self, index) -> Union[CCellEditor, List[CCellEditor]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Enclosure
class CEnclosure:
	"""An MWOffice Enclosure object."""
	def __init__(self, enclosure):
		self.__IEnclosure = enclosure

	def _get_inner(self):
		return self.__IEnclosure



	@property
	def EnclosureBottom(self) -> CBoundaryModel:
		"""Returns the boundary model for the bottom of an Enclosure object."""
		return CBoundaryModel(self.__IEnclosure.EnclosureBottom)


	@property
	def EnclosureTop(self) -> CBoundaryModel:
		"""Returns the boundary model for the top of an Enclosure object."""
		return CBoundaryModel(self.__IEnclosure.EnclosureTop)


	@property
	def Height(self) -> float:
		"""Returns the height value of the enclosure object."""
		return self.__IEnclosure.Height


	@property
	def XCellSize(self) -> float:
		"""Returns the X value of the Cell size for the enclosure object."""
		return self.__IEnclosure.XCellSize


	@property
	def XDimension(self) -> float:
		"""Returns/sets the X dimension of the enclosure."""
		return self.__IEnclosure.XDimension


	@XDimension.setter
	def XDimension(self, value: float):
		"""Returns/sets the X dimension of the enclosure."""
		self.__IEnclosure.XDimension = value


	@property
	def XDivisions(self) -> int:
		"""Returns/sets the number of X divisions in the enclosure object."""
		return self.__IEnclosure.XDivisions


	@XDivisions.setter
	def XDivisions(self, value: int):
		"""Returns/sets the number of X divisions in the enclosure object."""
		self.__IEnclosure.XDivisions = value


	@property
	def YCellSize(self) -> float:
		"""Returns the Y value of the Cell size for the enclosure object."""
		return self.__IEnclosure.YCellSize


	@property
	def YDimension(self) -> float:
		"""Returns/sets the Y dimension of the enclosure."""
		return self.__IEnclosure.YDimension


	@YDimension.setter
	def YDimension(self, value: float):
		"""Returns/sets the Y dimension of the enclosure."""
		self.__IEnclosure.YDimension = value


	@property
	def YDivisions(self) -> int:
		"""Returns/sets the number of Y divisions in the enclosure object."""
		return self.__IEnclosure.YDivisions


	@YDivisions.setter
	def YDivisions(self, value: int):
		"""Returns/sets the number of Y divisions in the enclosure object."""
		self.__IEnclosure.YDivisions = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Material
class CMaterial:
	"""An MWOffice Material object."""
	def __init__(self, material):
		self.__IMaterial = material

	def _get_inner(self):
		return self.__IMaterial


	def GetMaterialProperty(self, propetyType: mwMaterialProperties, frequencyHz: float = -1) -> float:
		"""Returns a specifid material property, at a optional given frequency."""
		return self.__IMaterial.GetMaterialProperty(propetyType, frequencyHz)



	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IMaterial.Name


	@property
	def Type(self):
		"""Returns a value indicating the type of the Material object."""
		return self.__IMaterial.Type


	@property
	def Visible(self) -> bool:
		"""Returns/sets a value controlling the visiblity of the Material object."""
		return self.__IMaterial.Visible


	@Visible.setter
	def Visible(self, value: bool):
		"""Returns/sets a value controlling the visiblity of the Material object."""
		self.__IMaterial.Visible = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Materials
class CMaterials:
	"""A collection of MWOffice Material objects."""
	def __init__(self, materials):
		self.__IMaterials = materials

	def _get_inner(self):
		return self.__IMaterials



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IMaterials.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IMaterials.Exists(Index)


	def Item(self, Index) -> CMaterial:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CMaterial(self.__IMaterials.Item(Index))


	def __get_Item(self, Index) -> CMaterial:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CMaterial(self.__IMaterials.Item(Index))


	def __call__(self, index) -> CMaterial:
		return self.__get_Item(index)


	def __iter__(self) -> CMaterial:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IMaterials.Count


	def __getitem__(self, index) -> Union[CMaterial, List[CMaterial]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# MaterialLayer
class CMaterialLayer:
	"""An MWOffice Material Layer object."""
	def __init__(self, materiallayer):
		self.__IMaterialLayer = materiallayer

	def _get_inner(self):
		return self.__IMaterialLayer



	@property
	def BulkConductivity(self) -> float:
		"""Returns/sets the bulk conductivity of a MaterialLayer object."""
		return self.__IMaterialLayer.BulkConductivity


	@BulkConductivity.setter
	def BulkConductivity(self, value: float):
		"""Returns/sets the bulk conductivity of a MaterialLayer object."""
		self.__IMaterialLayer.BulkConductivity = value


	@property
	def DielectricConstant(self) -> float:
		"""Returns/sets the relative dielectric constant of a MaterialLayer object."""
		return self.__IMaterialLayer.DielectricConstant


	@DielectricConstant.setter
	def DielectricConstant(self, value: float):
		"""Returns/sets the relative dielectric constant of a MaterialLayer object."""
		self.__IMaterialLayer.DielectricConstant = value


	@property
	def Hatch(self):
		"""Returns/sets the hatch pattern of a MaterialLayer object."""
		return self.__IMaterialLayer.Hatch


	@Hatch.setter
	def Hatch(self, value: mwHatchStyle):
		"""Returns/sets the hatch pattern of a MaterialLayer object."""
		self.__IMaterialLayer.Hatch = value


	@property
	def LossTangent(self) -> float:
		"""Returns/sets the loss tangent of a MaterialLayer object."""
		return self.__IMaterialLayer.LossTangent


	@LossTangent.setter
	def LossTangent(self, value: float):
		"""Returns/sets the loss tangent of a MaterialLayer object."""
		self.__IMaterialLayer.LossTangent = value


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IMaterialLayer.Name


	@property
	def Thickness(self) -> float:
		"""Returns/sets the thickness of a MaterialLayer object."""
		return self.__IMaterialLayer.Thickness


	@Thickness.setter
	def Thickness(self, value: float):
		"""Returns/sets the thickness of a MaterialLayer object."""
		self.__IMaterialLayer.Thickness = value


	@property
	def ViaHatch(self):
		"""Returns/sets the hatch pattern for vias in a MaterialLayer object."""
		return self.__IMaterialLayer.ViaHatch


	@ViaHatch.setter
	def ViaHatch(self, value: mwHatchStyle):
		"""Returns/sets the hatch pattern for vias in a MaterialLayer object."""
		self.__IMaterialLayer.ViaHatch = value


	@property
	def ViewScale(self) -> float:
		"""Returns/sets the view scale of a MaterialLayer object."""
		return self.__IMaterialLayer.ViewScale


	@ViewScale.setter
	def ViewScale(self, value: float):
		"""Returns/sets the view scale of a MaterialLayer object."""
		self.__IMaterialLayer.ViewScale = value


	@property
	def Visible(self) -> bool:
		"""Returns/sets the a value controlling the visibility of the MaterialLayer object."""
		return self.__IMaterialLayer.Visible


	@Visible.setter
	def Visible(self, value: bool):
		"""Returns/sets the a value controlling the visibility of the MaterialLayer object."""
		self.__IMaterialLayer.Visible = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# MaterialLayers
class CMaterialLayers:
	"""A collection of MWOffice Material Layer objects."""
	def __init__(self, materiallayers):
		self.__IMaterialLayers = materiallayers

	def _get_inner(self):
		return self.__IMaterialLayers


	def Add(self, Layer: int = 1, Hatch: mwHatchStyle = 5, ViaHatch: mwHatchStyle = 4, Thickness: float = 9.99999974737875E-05, DielectricConstant: float = 1, LossTangent: float = 0, BulkConductivity: float = 0, ViewScale: float = 1) -> CMaterialLayer:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CMaterialLayer(self.__IMaterialLayers.Add(Layer, Hatch, ViaHatch, Thickness, DielectricConstant, LossTangent, BulkConductivity, ViewScale))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IMaterialLayers.Remove(Index)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IMaterialLayers.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IMaterialLayers.Exists(Index)


	def Item(self, Index) -> CMaterialLayer:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CMaterialLayer(self.__IMaterialLayers.Item(Index))


	def __get_Item(self, Index) -> CMaterialLayer:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CMaterialLayer(self.__IMaterialLayers.Item(Index))


	def __call__(self, index) -> CMaterialLayer:
		return self.__get_Item(index)


	def __iter__(self) -> CMaterialLayer:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IMaterialLayers.Count


	def __getitem__(self, index) -> Union[CMaterialLayer, List[CMaterialLayer]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ShapeSubObject
class CShapeSubObject:
	"""An MWOffice ShapeSubObject object."""
	def __init__(self, shapesubobject):
		self.__IShapeSubObject = shapesubobject

	def _get_inner(self):
		return self.__IShapeSubObject



	@property
	def Attributes(self) -> CAttributes:
		"""Returns a reference to a collection of Attribute objects."""
		return CAttributes(self.__IShapeSubObject.Attributes)


	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__IShapeSubObject.Boundary)


	@property
	def PolyVertices(self) -> CVertices:
		"""Returns a reference to a collection of Vertex objects."""
		return CVertices(self.__IShapeSubObject.PolyVertices)


	@property
	def Segments(self) -> CShapeSegments:
		"""Returns a reference to a collection of ShapeSegment objects."""
		return CShapeSegments(self.__IShapeSubObject.Segments)


	@property
	def Type(self):
		"""Returns the type of the ShapeSubObject object."""
		return self.__IShapeSubObject.Type


	@property
	def Vertices(self) -> CVertices:
		"""Returns a reference to a collection of Vertex objects."""
		return CVertices(self.__IShapeSubObject.Vertices)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ShapeSubObjects
class CShapeSubObjects:
	"""A collection of MWOffice ShapeSubObject objects."""
	def __init__(self, shapesubobjects):
		self.__IShapeSubObjects = shapesubobjects

	def _get_inner(self):
		return self.__IShapeSubObjects



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IShapeSubObjects.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IShapeSubObjects.Exists(Index)


	def Item(self, Index) -> CShapeSubObject:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CShapeSubObject(self.__IShapeSubObjects.Item(Index))


	def __get_Item(self, Index) -> CShapeSubObject:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CShapeSubObject(self.__IShapeSubObjects.Item(Index))


	def __call__(self, index) -> CShapeSubObject:
		return self.__get_Item(index)


	def __iter__(self) -> CShapeSubObject:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IShapeSubObjects.Count


	def __getitem__(self, index) -> Union[CShapeSubObject, List[CShapeSubObject]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ShapeSegment
class CShapeSegment:
	"""An MWOffice ShapeSegment object."""
	def __init__(self, shapesegment):
		self.__IShapeSegment = shapesegment

	def _get_inner(self):
		return self.__IShapeSegment



	@property
	def Angle(self) -> float:
		"""Returns the angle of the segment."""
		return self.__IShapeSegment.Angle


	@property
	def ArcSegment(self) -> CShapeArcSegment:
		"""Returns a reference to a MWOffice ShapeArcSegment object."""
		return CShapeArcSegment(self.__IShapeSegment.ArcSegment)


	@property
	def Begin(self) -> CVertex:
		"""Returns a reference to a Vertex object."""
		return CVertex(self.__IShapeSegment.Begin)


	@property
	def End(self) -> CVertex:
		"""Returns a reference to a Vertex object."""
		return CVertex(self.__IShapeSegment.End)


	@property
	def IsArcSegment(self) -> bool:
		"""Returns true if the segment is an arc segment."""
		return self.__IShapeSegment.IsArcSegment


	@property
	def Length(self) -> float:
		"""Returns the length of the segment."""
		return self.__IShapeSegment.Length


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ShapeSegments
class CShapeSegments:
	"""A collection of MWOffice ShapeSegment objects."""
	def __init__(self, shapesegments):
		self.__IShapeSegments = shapesegments

	def _get_inner(self):
		return self.__IShapeSegments



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IShapeSegments.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IShapeSegments.Exists(Index)


	def Item(self, Index) -> CShapeSegment:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CShapeSegment(self.__IShapeSegments.Item(Index))


	def __get_Item(self, Index) -> CShapeSegment:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CShapeSegment(self.__IShapeSegments.Item(Index))


	def __call__(self, index) -> CShapeSegment:
		return self.__get_Item(index)


	def __iter__(self) -> CShapeSegment:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IShapeSegments.Count


	def __getitem__(self, index) -> Union[CShapeSegment, List[CShapeSegment]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ShapeArcSegment
class CShapeArcSegment:
	"""An MWOffice ShapeArcSegment object."""
	def __init__(self, shapearcsegment):
		self.__IShapeArcSegment = shapearcsegment

	def _get_inner(self):
		return self.__IShapeArcSegment



	@property
	def Center(self) -> CVertex:
		"""Returns a reference to a Vertex object."""
		return CVertex(self.__IShapeArcSegment.Center)


	@property
	def Direction(self):
		"""Returns a value which indicates the direction of the ShapeArcSegment."""
		return self.__IShapeArcSegment.Direction


	@property
	def Length(self) -> float:
		"""Returns the distance along the arc points from the begin point to the end point."""
		return self.__IShapeArcSegment.Length


	@property
	def Points(self) -> CVertices:
		"""Returns a reference to a collection of Vertex objects."""
		return CVertices(self.__IShapeArcSegment.Points)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ShapeArcSegments
class CShapeArcSegments:
	"""A collection of MWOffice ShapeArcSegment objects."""
	def __init__(self, shapearcsegments):
		self.__IShapeArcSegments = shapearcsegments

	def _get_inner(self):
		return self.__IShapeArcSegments



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IShapeArcSegments.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IShapeArcSegments.Exists(Index)


	def Item(self, Index) -> CShapeArcSegment:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CShapeArcSegment(self.__IShapeArcSegments.Item(Index))


	def __get_Item(self, Index) -> CShapeArcSegment:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CShapeArcSegment(self.__IShapeArcSegments.Item(Index))


	def __call__(self, index) -> CShapeArcSegment:
		return self.__get_Item(index)


	def __iter__(self) -> CShapeArcSegment:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IShapeArcSegments.Count


	def __getitem__(self, index) -> Union[CShapeArcSegment, List[CShapeArcSegment]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Shape
class CShape:
	"""An MWOffice Shape object."""
	def __init__(self, shape):
		self.__IShape = shape

	def _get_inner(self):
		return self.__IShape


	def Move(self, dx: float, dy: float, CCWRotatation: float = 0, Flip: bool = 0, HorizontalAxis: bool = 0, OriginX: float = 0, OriginY: float = 0) -> bool:
		"""Moves Shape object by the given values relative to the current location."""
		return self.__IShape.Move(dx, dy, CCWRotatation, Flip, HorizontalAxis, OriginX, OriginY)



	@property
	def Attributes(self) -> CAttributes:
		"""Returns a reference to a collection of Attribute objects."""
		return CAttributes(self.__IShape.Attributes)


	@property
	def BasePosition(self) -> CVertex:
		"""Returns a reference to a Vertex object."""
		return CVertex(self.__IShape.BasePosition)


	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__IShape.Boundary)


	@property
	def DrawingLayer(self) -> CDrawingLayer:
		"""Returns a reference to a Drawing Layer object."""
		return CDrawingLayer(self.__IShape.DrawingLayer)


	@property
	def Flipped(self) -> bool:
		"""Returns/sets a value that determines if the shape object is flipped."""
		return self.__IShape.Flipped


	@Flipped.setter
	def Flipped(self, value: bool):
		"""Returns/sets a value that determines if the shape object is flipped."""
		self.__IShape.Flipped = value


	@property
	def HierarchicalPath(self) -> str:
		"""Returns a value for some shapes which specifies the hierarchical path for the shape"""
		return self.__IShape.HierarchicalPath


	@property
	def PolyVertices(self) -> CVertices:
		"""Returns a reference to a collection of Vertex objects."""
		return CVertices(self.__IShape.PolyVertices)


	@property
	def RotationAngle(self) -> float:
		"""Returns/sets a value that determines the rotation angle in degrees of the shape object."""
		return self.__IShape.RotationAngle


	@RotationAngle.setter
	def RotationAngle(self, value: float):
		"""Returns/sets a value that determines the rotation angle in degrees of the shape object."""
		self.__IShape.RotationAngle = value


	@property
	def Segments(self) -> CShapeSegments:
		"""Returns a reference to a collection of ShapeSegment objects."""
		return CShapeSegments(self.__IShape.Segments)


	@property
	def SubObjects(self) -> CShapeSubObjects:
		"""Returns a reference to a collection of MWOffice ShapeSubObject objects."""
		return CShapeSubObjects(self.__IShape.SubObjects)


	@property
	def Type(self):
		"""Returns a value which specifies the type of a Shape object."""
		return self.__IShape.Type


	@property
	def Vertices(self) -> CVertices:
		"""Returns a reference to a collection of Vertex objects."""
		return CVertices(self.__IShape.Vertices)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Shapes
class CShapes:
	"""A collection of MWOffice Shape objects."""
	def __init__(self, shapes):
		self.__IShapes = shapes

	def _get_inner(self):
		return self.__IShapes


	def AddRectangle(self, x: float, y: float, dx: float, dy: float, LayerName: str = "") -> CShape:
		"""Adds a rectangle shape to a Shapes collection."""
		return CShape(self.__IShapes.AddRectangle(x, y, dx, dy, LayerName))


	def AddPolygon(self, XYPoints, LayerName: str = "") -> CShape:
		"""Adds a polygon shape to a Shapes collection."""
		return CShape(self.__IShapes.AddPolygon(XYPoints, LayerName))


	def AddPath(self, XYPoints, Width: float, LayerName: str = "", EndStyle: mwPathEndType = 1, MiterStyle: mwPathMiterType = 1, OffsetMiterAmount: float = 0) -> CShape:
		"""Adds a path shape to a Shapes collection."""
		return CShape(self.__IShapes.AddPath(XYPoints, Width, LayerName, EndStyle, MiterStyle, OffsetMiterAmount))


	def AddEllipse(self, x: float, y: float, dx: float, dy: float, LayerName: str = "") -> CShape:
		"""Adds an ellipse shape to a Shapes collection."""
		return CShape(self.__IShapes.AddEllipse(x, y, dx, dy, LayerName))


	def AddDrillHole(self, x: float, y: float, ToolName: str) -> CShape:
		"""Adds a drill hole shape to a Shapes collection."""
		return CShape(self.__IShapes.AddDrillHole(x, y, ToolName))


	def AddText(self, x: float, y: float, Height: float, Text: str, LayerName: str = "", RotationAngle: float = 0, FontName: str = "", Bold: bool = 0, Italic: bool = 0, DrawAsPolygons: bool = -1) -> CShape:
		"""Adds a text shape to a Shapes collection."""
		return CShape(self.__IShapes.AddText(x, y, Height, Text, LayerName, RotationAngle, FontName, Bold, Italic, DrawAsPolygons))


	def AddArc(self, xCenter: float, yCenter: float, Radius: float, StartAngle: float, EndAngle: float, LayerName: str = "") -> CShape:
		"""Adds a arc shape to the Shapes collection."""
		return CShape(self.__IShapes.AddArc(xCenter, yCenter, Radius, StartAngle, EndAngle, LayerName))


	def AddFace(self, x1: float, y1: float, x2: float, y2: float, PortNumber: int = 0, ConnectType: int = 0) -> CShape:
		"""Adds a cell face shape to the Shapes collection. Connect values are from mwPortFaceConnectTypes enum."""
		return CShape(self.__IShapes.AddFace(x1, y1, x2, y2, PortNumber, ConnectType))


	def AddPin(self, XYPoints, LayerName: str = "", PortNumber: int = 0, ConnectType: int = 0) -> CShape:
		"""Adds a pin shape to the shapes collection. Connect values are from mwPortFaceConnectTypes enum."""
		return CShape(self.__IShapes.AddPin(XYPoints, LayerName, PortNumber, ConnectType))


	def AddVia(self, x: float, y: float, dx: float, dy: float, LayerName: str = "", IsPort: bool = 0) -> CShape:
		"""Adds a via shape to the Shapes collection. If the via should be a port the optional bPort is true."""
		return CShape(self.__IShapes.AddVia(x, y, dx, dy, LayerName, IsPort))


	def AddTextEx(self, x: float, y: float, Height: float, Text: str, DrawAsPolygons: bool = -1, LayerName: str = "", TextAlignment: mwTextAlignment = 5, RotationAngle: float = 0, FontName: str = "", Bold: bool = 0, Italic: bool = 0) -> CShape:
		"""Adds a text shape to a Shapes collection."""
		return CShape(self.__IShapes.AddTextEx(x, y, Height, Text, DrawAsPolygons, LayerName, TextAlignment, RotationAngle, FontName, Bold, Italic))


	def AddFaceEx(self, x1: float, y1: float, x2: float, y2: float, PortNumber: int = 0, ConnectType: int = 0, LayerName: str = "") -> CShape:
		"""Adds a cell face shape to the Shapes collection. Connect values are from mwPortFaceConnectTypes enum."""
		return CShape(self.__IShapes.AddFaceEx(x1, y1, x2, y2, PortNumber, ConnectType, LayerName))



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IShapes.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IShapes.Exists(Index)


	def Item(self, Index) -> CShape:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CShape(self.__IShapes.Item(Index))


	def __get_Item(self, Index) -> CShape:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CShape(self.__IShapes.Item(Index))


	def __call__(self, index) -> CShape:
		return self.__get_Item(index)


	def __iter__(self) -> CShape:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IShapes.Count


	def __getitem__(self, index) -> Union[CShape, List[CShape]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def ReadOnly(self) -> bool:
		"""Returns a value which specifies if the shape collection is read-only and cannot have shapes added."""
		return self.__IShapes.ReadOnly


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DrawingSubObject
class CDrawingSubObject:
	"""An MWOffice DrawingSubObject object."""
	def __init__(self, drawingsubobject):
		self.__IDrawingSubObject = drawingsubobject

	def _get_inner(self):
		return self.__IDrawingSubObject


	def Move(self, dx: float, dy: float) -> bool:
		"""Moves the DrawingSubObject by the given offset values."""
		return self.__IDrawingSubObject.Move(dx, dy)


	def Delete(self) -> bool:
		"""Deletes the DrawingSubObject from the parent DrawingObject."""
		return self.__IDrawingSubObject.Delete()



	@property
	def Attributes(self) -> CAttributes:
		"""Returns a reference to a collection of Attribute objects."""
		return CAttributes(self.__IDrawingSubObject.Attributes)


	@property
	def BasePosition(self) -> CVertex:
		"""Returns a reference to a Vertex object."""
		return CVertex(self.__IDrawingSubObject.BasePosition)


	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__IDrawingSubObject.Boundary)


	@property
	def EditHandles(self) -> CEditHandles:
		"""Returns a reference to a collection of MWOffice EditHandle objects."""
		return CEditHandles(self.__IDrawingSubObject.EditHandles)


	@property
	def PolyVertices(self) -> CVertices:
		"""Returns a reference to a collection of Vertex objects."""
		return CVertices(self.__IDrawingSubObject.PolyVertices)


	@property
	def Segments(self) -> CDrawingSegments:
		"""Returns a reference to a collection of MWOffice DrawingSegment objects."""
		return CDrawingSegments(self.__IDrawingSubObject.Segments)


	@property
	def Selected(self) -> bool:
		"""Returns a value indicating whether the DrawingSubObject is selected."""
		return self.__IDrawingSubObject.Selected


	@Selected.setter
	def Selected(self, value: bool):
		"""Returns a value indicating whether the DrawingSubObject is selected."""
		self.__IDrawingSubObject.Selected = value


	@property
	def Type(self):
		"""Returns the type of the drawing subobject."""
		return self.__IDrawingSubObject.Type


	@property
	def Vertices(self) -> CVertices:
		"""Returns a reference to a collection of Vertex objects."""
		return CVertices(self.__IDrawingSubObject.Vertices)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DrawingSubObjects
class CDrawingSubObjects:
	"""A collection of MWOffice DrawingSubObject objects."""
	def __init__(self, drawingsubobjects):
		self.__IDrawingSubObjects = drawingsubobjects

	def _get_inner(self):
		return self.__IDrawingSubObjects


	def AddRectangle(self, x: float, y: float, dx: float, dy: float) -> CDrawingSubObject:
		"""Adds a rectangle to the DrawingSubObjects collection."""
		return CDrawingSubObject(self.__IDrawingSubObjects.AddRectangle(x, y, dx, dy))


	def AddPolygon(self, XYPoints) -> CDrawingSubObject:
		"""Adds a polygon to the DrawingSubObjects collection."""
		return CDrawingSubObject(self.__IDrawingSubObjects.AddPolygon(XYPoints))


	def AddEllipse(self, x: float, y: float, dx: float, dy: float) -> CDrawingSubObject:
		"""Adds an ellipse to the DrawingSubObjects collection."""
		return CDrawingSubObject(self.__IDrawingSubObjects.AddEllipse(x, y, dx, dy))


	def AddCircle(self, x: float, y: float, r: float) -> CDrawingSubObject:
		"""Adds a circle to the DrawingSubObjects collection."""
		return CDrawingSubObject(self.__IDrawingSubObjects.AddCircle(x, y, r))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IDrawingSubObjects.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IDrawingSubObjects.RemoveAll()


	def AddFilletedPolygon(self, XYPoints, SkipFillet, OutsideCornerRadius: float, InsideCornerRadius: float, NumPointsPerCircle: int, FilletOptions: mwFilletPolyOptions = 0, FilletArcPointStyle: mwFilletPolyArcPtStyle = 1) -> CDrawingSubObject:
		"""Adds a filleted polygon to the DrawingSubObjects collection."""
		return CDrawingSubObject(self.__IDrawingSubObjects.AddFilletedPolygon(XYPoints, SkipFillet, OutsideCornerRadius, InsideCornerRadius, NumPointsPerCircle, FilletOptions, FilletArcPointStyle))



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IDrawingSubObjects.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IDrawingSubObjects.Exists(Index)


	def Item(self, Index) -> CDrawingSubObject:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingSubObject(self.__IDrawingSubObjects.Item(Index))


	def __get_Item(self, Index) -> CDrawingSubObject:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingSubObject(self.__IDrawingSubObjects.Item(Index))


	def __call__(self, index) -> CDrawingSubObject:
		return self.__get_Item(index)


	def __iter__(self) -> CDrawingSubObject:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IDrawingSubObjects.Count


	def __getitem__(self, index) -> Union[CDrawingSubObject, List[CDrawingSubObject]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def ReadOnly(self) -> bool:
		"""Returns a value indicating whether the DrawingSubObjects collection is read-only."""
		return self.__IDrawingSubObjects.ReadOnly


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DrawingSegment
class CDrawingSegment:
	"""An MWOffice DrawingSegment object."""
	def __init__(self, drawingsegment):
		self.__IDrawingSegment = drawingsegment

	def _get_inner(self):
		return self.__IDrawingSegment


	def MakeArcSegment(self, centerX: float, centerY: float, dir: mwDrawingArcDirection) -> CDrawingArcSegment:
		"""Makes the segment into an arc segment with a specific center point and direction."""
		return CDrawingArcSegment(self.__IDrawingSegment.MakeArcSegment(centerX, centerY, dir))


	def RevertArcSegment(self) -> bool:
		"""Reverts the segment from an arc segment into a normal straight segment."""
		return self.__IDrawingSegment.RevertArcSegment()



	@property
	def Angle(self) -> float:
		"""Returns the angle of the segment."""
		return self.__IDrawingSegment.Angle


	@property
	def ArcSegment(self) -> CDrawingArcSegment:
		"""Returns a reference to a MWOffice DrawingArcSegment object."""
		return CDrawingArcSegment(self.__IDrawingSegment.ArcSegment)


	@property
	def Begin(self) -> CVertex:
		"""Returns a reference to a Vertex object."""
		return CVertex(self.__IDrawingSegment.Begin)


	@property
	def CanMakeArcSegment(self) -> bool:
		"""Returns if the segment supports conversion to an arc segment."""
		return self.__IDrawingSegment.CanMakeArcSegment


	@property
	def End(self) -> CVertex:
		"""Returns a reference to a Vertex object."""
		return CVertex(self.__IDrawingSegment.End)


	@property
	def IsArcSegment(self) -> bool:
		"""Returns if the segment is an arc segment."""
		return self.__IDrawingSegment.IsArcSegment


	@property
	def LayerName(self) -> str:
		"""Returns the name of the drawing layer associated with this DrawingSegment object."""
		return self.__IDrawingSegment.LayerName


	@property
	def Length(self) -> float:
		"""Returns the length of the segment."""
		return self.__IDrawingSegment.Length


	@property
	def Selected(self) -> bool:
		"""Returns/Sets a value that indicates of the segment is selected."""
		return self.__IDrawingSegment.Selected


	@Selected.setter
	def Selected(self, value: bool):
		"""Returns/Sets a value that indicates of the segment is selected."""
		self.__IDrawingSegment.Selected = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DrawingSegments
class CDrawingSegments:
	"""A collection of MWOffice DrawingSegment objects."""
	def __init__(self, drawingsegments):
		self.__IDrawingSegments = drawingsegments

	def _get_inner(self):
		return self.__IDrawingSegments



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IDrawingSegments.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IDrawingSegments.Exists(Index)


	def Item(self, Index) -> CDrawingSegment:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingSegment(self.__IDrawingSegments.Item(Index))


	def __get_Item(self, Index) -> CDrawingSegment:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingSegment(self.__IDrawingSegments.Item(Index))


	def __call__(self, index) -> CDrawingSegment:
		return self.__get_Item(index)


	def __iter__(self) -> CDrawingSegment:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IDrawingSegments.Count


	def __getitem__(self, index) -> Union[CDrawingSegment, List[CDrawingSegment]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DrawingArcSegment
class CDrawingArcSegment:
	"""An MWOffice DrawingArcSegment object."""
	def __init__(self, drawingarcsegment):
		self.__IDrawingArcSegment = drawingarcsegment

	def _get_inner(self):
		return self.__IDrawingArcSegment



	@property
	def Center(self) -> CVertex:
		"""Returns a reference to a Vertex object."""
		return CVertex(self.__IDrawingArcSegment.Center)


	@property
	def Direction(self):
		"""Returns/sets a value which indicates the direction of the DrawingArcSegment."""
		return self.__IDrawingArcSegment.Direction


	@Direction.setter
	def Direction(self, value: mwDrawingArcDirection):
		"""Returns/sets a value which indicates the direction of the DrawingArcSegment."""
		self.__IDrawingArcSegment.Direction = value


	@property
	def Length(self) -> float:
		"""Returns the distance along the arc points from the begin point to the end point."""
		return self.__IDrawingArcSegment.Length


	@property
	def Points(self) -> CVertices:
		"""Returns a reference to a collection of Vertex objects."""
		return CVertices(self.__IDrawingArcSegment.Points)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DrawingArcSegments
class CDrawingArcSegments:
	"""A collection of DrawingArcSegment objects."""
	def __init__(self, drawingarcsegments):
		self.__IDrawingArcSegments = drawingarcsegments

	def _get_inner(self):
		return self.__IDrawingArcSegments



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IDrawingArcSegments.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IDrawingArcSegments.Exists(Index)


	def Item(self, Index) -> CDrawingArcSegment:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingArcSegment(self.__IDrawingArcSegments.Item(Index))


	def __get_Item(self, Index) -> CDrawingArcSegment:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingArcSegment(self.__IDrawingArcSegments.Item(Index))


	def __call__(self, index) -> CDrawingArcSegment:
		return self.__get_Item(index)


	def __iter__(self) -> CDrawingArcSegment:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IDrawingArcSegments.Count


	def __getitem__(self, index) -> Union[CDrawingArcSegment, List[CDrawingArcSegment]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SnapshotInfo
class CSnapshotInfo:
	"""An MWOffice SnapshotInfo object."""
	def __init__(self, snapshotinfo):
		self.__ISnapshotInfo = snapshotinfo

	def _get_inner(self):
		return self.__ISnapshotInfo



	@property
	def ShapeCount(self) -> int:
		"""Returns a count of the shapes in the Snapshot object."""
		return self.__ISnapshotInfo.ShapeCount


	def ShapeOnLayerCount(self, LayerName: str) -> int:
		"""Returns a count of the shapes on a specific layer in the Snapshot object."""
		return self.__ISnapshotInfo.ShapeOnLayerCount(LayerName)


	def ShapeTypeCount(self, Type: mwShapeType) -> int:
		"""Returns a count of the shapes of a specific type in the Snapshot object."""
		return self.__ISnapshotInfo.ShapeTypeCount(Type)


	def ShapeTypeOnLayerCount(self, __MIDL__ISnapshotInfo0000: mwShapeType, LayerName: str) -> int:
		"""Returns a count of the shapes of a specific type on a specific layer in the Snapshot object."""
		return self.__ISnapshotInfo.ShapeTypeOnLayerCount(__MIDL__ISnapshotInfo0000, LayerName)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Snapshot
class CSnapshot:
	"""An MWOffice Snapshot object."""
	def __init__(self, snapshot):
		self.__ISnapshot = snapshot

	def _get_inner(self):
		return self.__ISnapshot


	def Export(self, Filename: str, ExportMap, LibraryName: str = "", CellName: str = "", Flat: bool = 0) -> bool:
		"""Exports a design document file from MWOffice."""
		return self.__ISnapshot.Export(Filename, ExportMap, LibraryName, CellName, Flat)


	def CopyToLayout(self, pLayout: CLayout, x: float, y: float, just: mwPlacementJustfication = 2) -> bool:
		"""Copies the shapes of this snapshot to the given layout."""
		return self.__ISnapshot.CopyToLayout(pLayout._get_inner(), x, y, just)


	def CopyToCellEditor(self, pCellEdit: CCellEditor, x: float, y: float, just: mwPlacementJustfication = 2) -> bool:
		"""Copies the shapes of this snapshot to the given cell editor."""
		return self.__ISnapshot.CopyToCellEditor(pCellEdit._get_inner(), x, y, just)


	def UnionShapes(self, Type: mwUnionShapesType = 0, destLayer: str = "") -> bool:
		"""Unions the shapes of this snapshot to combine overlapping shapes."""
		return self.__ISnapshot.UnionShapes(Type, destLayer)


	def ResizeShapes(self, Offset: float) -> bool:
		"""Resizes the shapes of this snapshot in place on each layer in the snapshot."""
		return self.__ISnapshot.ResizeShapes(Offset)


	def ResizeLayerShapes(self, Offset: float, LayerName: str) -> bool:
		"""Resizes the shapes on the given layer in place in the snapshot."""
		return self.__ISnapshot.ResizeLayerShapes(Offset, LayerName)


	def MoveShapesToLayer(self, sourceLayer: str, destinationLayer: str) -> bool:
		"""Moves all the shapes of a source layer to a destination layer in the snapshot."""
		return self.__ISnapshot.MoveShapesToLayer(sourceLayer, destinationLayer)


	def CopyShapesToLayer(self, sourceLayer: str, destinationLayer: str) -> bool:
		"""Copies all the shapes from a source layer and adds them to a destination layer in the snapshot."""
		return self.__ISnapshot.CopyShapesToLayer(sourceLayer, destinationLayer)


	def DeleteLayerShapes(self, LayerName: str) -> bool:
		"""Deletes all the shapes on a layer from the snapshot."""
		return self.__ISnapshot.DeleteLayerShapes(LayerName)


	def IntersectShapes(self, Type: mwIntersectShapesType = 0, destLayer: str = "") -> bool:
		"""Process the shapes of this snapshot to produce the intersection of overlapped shapes."""
		return self.__ISnapshot.IntersectShapes(Type, destLayer)


	def ExclusiveOrShapes(self, Type: mwExclusiveOrShapesType = 0, destLayer: str = "") -> bool:
		"""Process the shapes of this snapshot produce the exclusive or of overlapped shapes."""
		return self.__ISnapshot.ExclusiveOrShapes(Type, destLayer)


	def CopyToSnapshot(self, pSnapshot: CSnapshot, x: float, y: float, just: mwPlacementJustfication = 2) -> bool:
		"""Copies the shapes of this snapshot to the given Snapshot."""
		return self.__ISnapshot.CopyToSnapshot(pSnapshot._get_inner(), x, y, just)


	def ResizeCopyLayerShapes(self, Offset: float, srcLayerName: str, destLayerName: str) -> bool:
		"""Copies all the shapes from a src layer to a destination layer while resizing them by a give amount."""
		return self.__ISnapshot.ResizeCopyLayerShapes(Offset, srcLayerName, destLayerName)


	def CopyLayerToLayout(self, pLayout: CLayout, srcLayerName: str, x: float, y: float, just: mwPlacementJustfication = 2) -> bool:
		"""Copies the shapes on the specified layer of this snapshot to the given layout."""
		return self.__ISnapshot.CopyLayerToLayout(pLayout._get_inner(), srcLayerName, x, y, just)


	def CopyLayerToCellEditor(self, pCellEdit: CCellEditor, srcLayerName: str, x: float, y: float, just: mwPlacementJustfication = 2) -> bool:
		"""Copies the shapes on the specified layer of this snapshot to the given cell editor."""
		return self.__ISnapshot.CopyLayerToCellEditor(pCellEdit._get_inner(), srcLayerName, x, y, just)


	def CopyLayerToSnapshot(self, pSnapshot: CSnapshot, srcLayerName: str, x: float, y: float, just: mwPlacementJustfication = 2) -> bool:
		"""Copies the shapes on the specified layer of this snapshot to the given Snapshot."""
		return self.__ISnapshot.CopyLayerToSnapshot(pSnapshot._get_inner(), srcLayerName, x, y, just)


	def UnionLayersEx(self, sourceLayer1: str, sourceLayer2: str, destinationLayer: str, keepLayer1: bool = -1, keepLayer2: bool = -1) -> bool:
		"""Process the shapes on the given source layers to combine overlapping shapes in the snapshot."""
		return self.__ISnapshot.UnionLayersEx(sourceLayer1, sourceLayer2, destinationLayer, keepLayer1, keepLayer2)


	def SubtractLayersEx(self, sourceLayer1: str, sourceLayer2: str, destinationLayer: str, keepLayer1: bool = -1, keepLayer2: bool = -1) -> bool:
		"""Process the shapes to subtract overlapping sections of shapes on layer B from shapes on layer A in the snapshot."""
		return self.__ISnapshot.SubtractLayersEx(sourceLayer1, sourceLayer2, destinationLayer, keepLayer1, keepLayer2)


	def IntersectLayersEx(self, sourceLayer1: str, sourceLayer2: str, destinationLayer: str, keepLayer1: bool = -1, keepLayer2: bool = -1) -> bool:
		"""Process the shapes on the given source layers to produce the intersection of overlapping shapes in the snapshot."""
		return self.__ISnapshot.IntersectLayersEx(sourceLayer1, sourceLayer2, destinationLayer, keepLayer1, keepLayer2)


	def ExclusiveOrLayersEx(self, sourceLayer1: str, sourceLayer2: str, destinationLayer: str, keepLayer1: bool = -1, keepLayer2: bool = -1) -> bool:
		"""Process the shapes on the given source layers to produce the exclusive or of overlapping shapes in the snapshot."""
		return self.__ISnapshot.ExclusiveOrLayersEx(sourceLayer1, sourceLayer2, destinationLayer, keepLayer1, keepLayer2)



	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__ISnapshot.Boundary)


	@property
	def Info(self) -> CSnapshotInfo:
		"""Returns a reference to a SnapshotInfo object."""
		return CSnapshotInfo(self.__ISnapshot.Info)


	@property
	def Shapes(self) -> CShapes:
		"""Returns a reference to a collection of Shape objects."""
		return CShapes(self.__ISnapshot.Shapes)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LibraryElement
class CLibraryElement:
	"""An MWOffice LibraryElement object."""
	def __init__(self, libraryelement):
		self.__ILibraryElement = libraryelement

	def _get_inner(self):
		return self.__ILibraryElement



	@property
	def Attributes(self) -> CAttributes:
		"""Returns a reference to a collection of Attribute objects."""
		return CAttributes(self.__ILibraryElement.Attributes)


	@property
	def BrowserPath(self) -> str:
		"""Returns the browser path for a MWOffice LibraryElement object."""
		return self.__ILibraryElement.BrowserPath


	@property
	def Description(self) -> str:
		"""Returns a text description of the MWOffice LibraryElement object."""
		return self.__ILibraryElement.Description


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__ILibraryElement.Name


	@property
	def SymbolName(self) -> str:
		"""Returns the default symbol name for the MWOffice LibraryElement object."""
		return self.__ILibraryElement.SymbolName


	@property
	def Type(self):
		"""Returns a value indicating the type of this MWOffice LibraryElement object."""
		return self.__ILibraryElement.Type


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LibraryElements
class CLibraryElements:
	"""A collection of MWOffice LibraryElement objects."""
	def __init__(self, libraryelements):
		self.__ILibraryElements = libraryelements

	def _get_inner(self):
		return self.__ILibraryElements



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ILibraryElements.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ILibraryElements.Exists(Index)


	def Item(self, Index) -> CLibraryElement:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLibraryElement(self.__ILibraryElements.Item(Index))


	def __get_Item(self, Index) -> CLibraryElement:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLibraryElement(self.__ILibraryElements.Item(Index))


	def __call__(self, index) -> CLibraryElement:
		return self.__get_Item(index)


	def __iter__(self) -> CLibraryElement:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ILibraryElements.Count


	def __getitem__(self, index) -> Union[CLibraryElement, List[CLibraryElement]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# HiddenLibraryElements
class CHiddenLibraryElements:
	"""A collection of MWOffice LibraryElement objects."""
	def __init__(self, hiddenlibraryelements):
		self.__IHiddenLibraryElements = hiddenlibraryelements

	def _get_inner(self):
		return self.__IHiddenLibraryElements



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IHiddenLibraryElements.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IHiddenLibraryElements.Exists(Index)


	def Item(self, Index) -> CLibraryElement:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLibraryElement(self.__IHiddenLibraryElements.Item(Index))


	def __get_Item(self, Index) -> CLibraryElement:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLibraryElement(self.__IHiddenLibraryElements.Item(Index))


	def __call__(self, index) -> CLibraryElement:
		return self.__get_Item(index)


	def __iter__(self) -> CLibraryElement:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IHiddenLibraryElements.Count


	def __getitem__(self, index) -> Union[CLibraryElement, List[CLibraryElement]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Library
class CLibrary:
	"""An MWOffice Library object."""
	def __init__(self, library):
		self.__ILibrary = library

	def _get_inner(self):
		return self.__ILibrary



	@property
	def HiddenLibraries(self) -> CHiddenLibraries:
		"""Returns a reference to an MWOffice HiddenLibraries collection."""
		return CHiddenLibraries(self.__ILibrary.HiddenLibraries)


	@property
	def Libraries(self) -> CLibraries:
		"""Returns a reference to a MWOffice Libraries collection."""
		return CLibraries(self.__ILibrary.Libraries)


	@property
	def LibraryElements(self) -> CLibraryElements:
		"""Returns a reference to a MWOffice LibraryElements collection."""
		return CLibraryElements(self.__ILibrary.LibraryElements)


	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__ILibrary.Name


	@property
	def NodeExpanded(self) -> bool:
		"""Returns/sets the expanded state of the MWOffice TreeNode object."""
		return self.__ILibrary.NodeExpanded


	@NodeExpanded.setter
	def NodeExpanded(self, value: bool):
		"""Returns/sets the expanded state of the MWOffice TreeNode object."""
		self.__ILibrary.NodeExpanded = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Libraries
class CLibraries:
	"""A collection of MWOffice Library objects."""
	def __init__(self, libraries):
		self.__ILibraries = libraries

	def _get_inner(self):
		return self.__ILibraries



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ILibraries.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ILibraries.Exists(Index)


	def Item(self, Index) -> CLibrary:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLibrary(self.__ILibraries.Item(Index))


	def __get_Item(self, Index) -> CLibrary:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLibrary(self.__ILibraries.Item(Index))


	def __call__(self, index) -> CLibrary:
		return self.__get_Item(index)


	def __iter__(self) -> CLibrary:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ILibraries.Count


	def __getitem__(self, index) -> Union[CLibrary, List[CLibrary]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# HiddenLibrary
class CHiddenLibrary:
	"""An MWOffice Library object."""
	def __init__(self, hiddenlibrary):
		self.__IHiddenLibrary = hiddenlibrary

	def _get_inner(self):
		return self.__IHiddenLibrary



	@property
	def LibraryElements(self) -> CHiddenLibraryElements:
		"""Returns a reference to an MWOffice HiddenLibraryElements collection."""
		return CHiddenLibraryElements(self.__IHiddenLibrary.LibraryElements)


	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__IHiddenLibrary.Name


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# HiddenLibraries
class CHiddenLibraries:
	"""A collection of MWOffice Library objects."""
	def __init__(self, hiddenlibraries):
		self.__IHiddenLibraries = hiddenlibraries

	def _get_inner(self):
		return self.__IHiddenLibraries



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IHiddenLibraries.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IHiddenLibraries.Exists(Index)


	def Item(self, Index) -> CHiddenLibrary:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CHiddenLibrary(self.__IHiddenLibraries.Item(Index))


	def __get_Item(self, Index) -> CHiddenLibrary:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CHiddenLibrary(self.__IHiddenLibraries.Item(Index))


	def __call__(self, index) -> CHiddenLibrary:
		return self.__get_Item(index)


	def __iter__(self) -> CHiddenLibrary:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IHiddenLibraries.Count


	def __getitem__(self, index) -> Union[CHiddenLibrary, List[CHiddenLibrary]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# MeasurementInfo
class CMeasurementInfo:
	"""An MWOffice MeasurementInfo object contains information about measurement types available in the application."""
	def __init__(self, measurementinfo):
		self.__IMeasurementInfo = measurementinfo

	def _get_inner(self):
		return self.__IMeasurementInfo


	def IsFlagSet(self, flag: mwMeasInfoParamFlags) -> bool:
		"""Returns a value that indicates if the given flag is set on this measurement info object."""
		return self.__IMeasurementInfo.IsFlagSet(flag)



	@property
	def Category(self) -> str:
		"""Returns the category name of a MeasurementInfo object."""
		return self.__IMeasurementInfo.Category


	@property
	def DataUnitType(self):
		"""Returns a value which specifies the data unit type of the object."""
		return self.__IMeasurementInfo.DataUnitType


	@property
	def Description(self) -> str:
		"""Returns the description of the object."""
		return self.__IMeasurementInfo.Description


	@property
	def Flags(self) -> int:
		"""Returns the flags for a measurement type"""
		return self.__IMeasurementInfo.Flags


	@property
	def HelpContext(self) -> int:
		"""Returns the help file context id for the object."""
		return self.__IMeasurementInfo.HelpContext


	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__IMeasurementInfo.Name


	@property
	def SimIds(self):
		"""Returns the simulator type id for a measurement type"""
		return self.__IMeasurementInfo.SimIds


	@property
	def SweepUnitType(self):
		"""Returns a value which specifies the sweep unit type of the object."""
		return self.__IMeasurementInfo.SweepUnitType


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# MeasurementInfos
class CMeasurementInfos:
	"""A collection of MWOffice MeasurementInfo objects."""
	def __init__(self, measurementinfos):
		self.__IMeasurementInfos = measurementinfos

	def _get_inner(self):
		return self.__IMeasurementInfos



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IMeasurementInfos.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IMeasurementInfos.Exists(Index)


	def Item(self, Index) -> CMeasurementInfo:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CMeasurementInfo(self.__IMeasurementInfos.Item(Index))


	def __get_Item(self, Index) -> CMeasurementInfo:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CMeasurementInfo(self.__IMeasurementInfos.Item(Index))


	def __call__(self, index) -> CMeasurementInfo:
		return self.__get_Item(index)


	def __iter__(self) -> CMeasurementInfo:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IMeasurementInfos.Count


	def __getitem__(self, index) -> Union[CMeasurementInfo, List[CMeasurementInfo]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SimulatorInfo
class CSimulatorInfo:
	"""A MWOffice SimulatorInfo object."""
	def __init__(self, simulatorinfo):
		self.__ISimulatorInfo = simulatorinfo

	def _get_inner(self):
		return self.__ISimulatorInfo


	def IsFlagSet(self, Flags: mwSimulatorTypeFlags) -> bool:
		"""Returns a value that indicates if the given flag is set on the SimulatorInfo object."""
		return self.__ISimulatorInfo.IsFlagSet(Flags)



	@property
	def Description(self) -> str:
		"""Returns the simulator description for the SimulatorInfo object."""
		return self.__ISimulatorInfo.Description


	@property
	def Flags(self) -> int:
		"""Returns the simulator flags for the SimulatorInfo object."""
		return self.__ISimulatorInfo.Flags


	@property
	def LongName(self) -> str:
		"""Returns the simulator long name for the SimulatorInfo object."""
		return self.__ISimulatorInfo.LongName


	@property
	def ShortName(self) -> str:
		"""Returns the simulator short name for the SimulatorInfo object."""
		return self.__ISimulatorInfo.ShortName


	@property
	def VendorName(self) -> str:
		"""Returns the simulation vendor name for the SimulatorInfo object."""
		return self.__ISimulatorInfo.VendorName


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SimulatorInfos
class CSimulatorInfos:
	"""A collection of MWOffice SimulatorInfo objects."""
	def __init__(self, simulatorinfos):
		self.__ISimulatorInfos = simulatorinfos

	def _get_inner(self):
		return self.__ISimulatorInfos



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ISimulatorInfos.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ISimulatorInfos.Exists(Index)


	def Item(self, Index) -> CSimulatorInfo:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSimulatorInfo(self.__ISimulatorInfos.Item(Index))


	def __get_Item(self, Index) -> CSimulatorInfo:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CSimulatorInfo(self.__ISimulatorInfos.Item(Index))


	def __call__(self, index) -> CSimulatorInfo:
		return self.__get_Item(index)


	def __iter__(self) -> CSimulatorInfo:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ISimulatorInfos.Count


	def __getitem__(self, index) -> Union[CSimulatorInfo, List[CSimulatorInfo]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Model
class CModel:
	"""An MWOffice Model object."""
	def __init__(self, model):
		self.__IModel = model

	def _get_inner(self):
		return self.__IModel


	def Simulate(self) -> None:
		"""Perform a simulate on the Model object."""
		self.__IModel.Simulate()


	def IsFlagSet(self, flag: mwModelPropertyFlags) -> bool:
		"""Returns a value indicating of the given flag is set on the Model object."""
		return self.__IModel.IsFlagSet(flag)



	def Category(self, Level: int) -> str:
		"""Returns the category name of level of a Model object."""
		return self.__IModel.Category(Level)


	@property
	def CategoryPath(self) -> str:
		"""Returns a string that defines the category path of the Model object."""
		return self.__IModel.CategoryPath


	@property
	def Company(self) -> str:
		"""Returns the company name of the author for the object."""
		return self.__IModel.Company


	@property
	def Description(self) -> str:
		"""Returns the description of the object."""
		return self.__IModel.Description


	@property
	def HelpContext(self) -> int:
		"""Returns the help file context id for the object."""
		return self.__IModel.HelpContext


	@property
	def HelpFile(self) -> str:
		"""Returns the name of the help file for the object."""
		return self.__IModel.HelpFile


	@property
	def Levels(self) -> int:
		"""Returns the number of levels of a Model object."""
		return self.__IModel.Levels


	@property
	def Module(self) -> str:
		"""Returns the module name of a Model object."""
		return self.__IModel.Module


	@property
	def ModuleFilename(self) -> str:
		"""Returns a string that specifies the path to the module containing this model."""
		return self.__IModel.ModuleFilename


	def NCorMatrix(self, Index: int, Rows, Columns):
		"""Returns the N Correction results of the Model object simulate."""
		return self.__IModel.NCorMatrix(Index, Rows, Columns)


	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__IModel.Name


	@property
	def NodeCount(self) -> int:
		"""Returns the number of nodes of a Model object."""
		return self.__IModel.NodeCount


	@property
	def ParameterDefinitions(self) -> CParameterDefinitions:
		"""Returns a reference to a collection of ParameterDefinition objects."""
		return CParameterDefinitions(self.__IModel.ParameterDefinitions)


	@property
	def Priority(self):
		"""Returns the priority type for the Model Object."""
		return self.__IModel.Priority


	@property
	def PropertyFlags(self) -> int:
		"""Returns the property flags for the Model object."""
		return self.__IModel.PropertyFlags


	@property
	def SimulatorTypeID(self) -> str:
		"""Returns a string that identifies the simulator type identifier for the Model Object."""
		return self.__IModel.SimulatorTypeID


	@property
	def Symbol(self) -> str:
		"""Returns the symbol name of a Model object."""
		return self.__IModel.Symbol


	@property
	def Version(self) -> int:
		"""Returns the version of the object."""
		return self.__IModel.Version


	def YMatrix(self, Index: int, Rows, Columns):
		"""Returns the Y results of the Model object simulate."""
		return self.__IModel.YMatrix(Index, Rows, Columns)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Models
class CModels:
	"""A collection of MWOffice Model objects."""
	def __init__(self, models):
		self.__IModels = models

	def _get_inner(self):
		return self.__IModels



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IModels.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IModels.Exists(Index)


	def Item(self, Index) -> CModel:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CModel(self.__IModels.Item(Index))


	def __get_Item(self, Index) -> CModel:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CModel(self.__IModels.Item(Index))


	def __call__(self, index) -> CModel:
		return self.__get_Item(index)


	def __iter__(self) -> CModel:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IModels.Count


	def __getitem__(self, index) -> Union[CModel, List[CModel]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LayoutCell
class CLayoutCell:
	"""An MWOffice LayoutCell object."""
	def __init__(self, layoutcell):
		self.__ILayoutCell = layoutcell

	def _get_inner(self):
		return self.__ILayoutCell



	@property
	def CompanyName(self) -> str:
		"""Returns the company name of a LayoutCell object."""
		return self.__ILayoutCell.CompanyName


	@property
	def Description(self) -> str:
		"""Returns a description of a LayoutCell object."""
		return self.__ILayoutCell.Description


	@property
	def ModuleFilename(self) -> str:
		"""Returns the module file name of the layout cell, which is the path to the Dll for the cell."""
		return self.__ILayoutCell.ModuleFilename


	@property
	def ModuleName(self) -> str:
		"""Returns the module name of a LayoutCell object."""
		return self.__ILayoutCell.ModuleName


	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__ILayoutCell.Name


	@property
	def NumberNodes(self) -> int:
		"""Returns the number of nodes in the cell."""
		return self.__ILayoutCell.NumberNodes


	@property
	def ParameterCount(self) -> int:
		"""Returns the number of parameters"""
		return self.__ILayoutCell.ParameterCount


	@property
	def ParameterNames(self):
		"""Returns the name of the parameters contained in a parameter's data."""
		return self.__ILayoutCell.ParameterNames


	@property
	def Version(self) -> int:
		"""Returns the version number of a LayoutCell object."""
		return self.__ILayoutCell.Version


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# LayoutCells
class CLayoutCells:
	"""A collection of MWOffice LayoutCell objects."""
	def __init__(self, layoutcells):
		self.__ILayoutCells = layoutcells

	def _get_inner(self):
		return self.__ILayoutCells



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ILayoutCells.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ILayoutCells.Exists(Index)


	def Item(self, Index) -> CLayoutCell:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLayoutCell(self.__ILayoutCells.Item(Index))


	def __get_Item(self, Index) -> CLayoutCell:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CLayoutCell(self.__ILayoutCells.Item(Index))


	def __call__(self, index) -> CLayoutCell:
		return self.__get_Item(index)


	def __iter__(self) -> CLayoutCell:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ILayoutCells.Count


	def __getitem__(self, index) -> Union[CLayoutCell, List[CLayoutCell]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# OptVariable
class COptVariable:
	"""An MWOffice OptVariable object."""
	def __init__(self, optvariable):
		self.__IOptVariable = optvariable

	def _get_inner(self):
		return self.__IOptVariable



	@property
	def Constrained(self) -> bool:
		"""Returns/sets whether the OptVariable is constrained."""
		return self.__IOptVariable.Constrained


	@Constrained.setter
	def Constrained(self, value: bool):
		"""Returns/sets whether the OptVariable is constrained."""
		self.__IOptVariable.Constrained = value


	@property
	def Enabled(self) -> bool:
		"""Returns/sets if the variable is enabled for optimization. Allows disabling an optimization variable."""
		return self.__IOptVariable.Enabled


	@Enabled.setter
	def Enabled(self, value: bool):
		"""Returns/sets if the variable is enabled for optimization. Allows disabling an optimization variable."""
		self.__IOptVariable.Enabled = value


	@property
	def Maximum(self) -> float:
		"""Returns/sets the maximum value for the OptVariable object."""
		return self.__IOptVariable.Maximum


	@Maximum.setter
	def Maximum(self, value: float):
		"""Returns/sets the maximum value for the OptVariable object."""
		self.__IOptVariable.Maximum = value


	@property
	def Minimum(self) -> float:
		"""Returns/sets the minimum value for the OptVariable object."""
		return self.__IOptVariable.Minimum


	@Minimum.setter
	def Minimum(self, value: float):
		"""Returns/sets the minimum value for the OptVariable object."""
		self.__IOptVariable.Minimum = value


	@property
	def Name(self) -> str:
		"""Returns the file name of the project, not including the file's path specification."""
		return self.__IOptVariable.Name


	@property
	def Nominal(self) -> float:
		"""Returns/sets the nominal value for the OptVariable object."""
		return self.__IOptVariable.Nominal


	@Nominal.setter
	def Nominal(self, value: float):
		"""Returns/sets the nominal value for the OptVariable object."""
		self.__IOptVariable.Nominal = value


	@property
	def step(self) -> float:
		"""Returns/sets the step value for the OptVariable object."""
		return self.__IOptVariable.step


	@step.setter
	def step(self, value: float):
		"""Returns/sets the step value for the OptVariable object."""
		self.__IOptVariable.step = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# OptVariables
class COptVariables:
	"""A collection of MWOffice OptVariable objects."""
	def __init__(self, optvariables):
		self.__IOptVariables = optvariables

	def _get_inner(self):
		return self.__IOptVariables



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IOptVariables.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IOptVariables.Exists(Index)


	def Item(self, Index) -> COptVariable:
		"""Returns a specific item of a Collection object either by position or by key."""
		return COptVariable(self.__IOptVariables.Item(Index))


	def __get_Item(self, Index) -> COptVariable:
		"""Returns a specific item of a Collection object either by position or by key."""
		return COptVariable(self.__IOptVariables.Item(Index))


	def __call__(self, index) -> COptVariable:
		return self.__get_Item(index)


	def __iter__(self) -> COptVariable:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IOptVariables.Count


	def __getitem__(self, index) -> Union[COptVariable, List[COptVariable]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Optimizer
class COptimizer:
	"""An MWOffice Optimizer object."""
	def __init__(self, optimizer):
		self.__IOptimizer = optimizer

	def _get_inner(self):
		return self.__IOptimizer


	def start(self) -> None:
		"""Starts the optimization process."""
		self.__IOptimizer.start()


	def stop(self) -> None:
		"""Stops the optimization process."""
		self.__IOptimizer.stop()


	def Reset(self) -> None:
		"""Resets the optimization process."""
		self.__IOptimizer.Reset()


	def Save(self, Name: str) -> None:
		"""Saves the current optimization."""
		self.__IOptimizer.Save(Name)


	def Revert(self, Name: str) -> None:
		"""Reverts the optimization to the previous state."""
		self.__IOptimizer.Revert(Name)


	def NewWindow(self) -> CWindow:
		"""Displays the object in new window."""
		return CWindow(self.__IOptimizer.NewWindow())


	def Continue(self) -> None:
		"""Continues the current optimization."""
		self.__IOptimizer.Continue()


	def Round(self, numSigDigs: int, roundToStep: bool, simOnApply: bool) -> None:
		"""Rounds the values of the optimization variables."""
		self.__IOptimizer.Round(numSigDigs, roundToStep, simOnApply)



	@property
	def BestCost(self) -> float:
		"""Returns the best cost reached by the optimization."""
		return self.__IOptimizer.BestCost


	@property
	def CancelOnStop(self) -> bool:
		"""Returns/sets a value which specifies if the optimizer should cancel the current iteration on stop."""
		return self.__IOptimizer.CancelOnStop


	@CancelOnStop.setter
	def CancelOnStop(self, value: bool):
		"""Returns/sets a value which specifies if the optimizer should cancel the current iteration on stop."""
		self.__IOptimizer.CancelOnStop = value


	@property
	def Cost(self) -> float:
		"""Returns the cost from the current optimization iteration."""
		return self.__IOptimizer.Cost


	@property
	def Iteration(self) -> int:
		"""Returns the number of current iteration."""
		return self.__IOptimizer.Iteration


	@property
	def LogToFile(self) -> bool:
		"""Returns/sets a value which specifies if the optimizer should log all iterations to a file."""
		return self.__IOptimizer.LogToFile


	@LogToFile.setter
	def LogToFile(self, value: bool):
		"""Returns/sets a value which specifies if the optimizer should log all iterations to a file."""
		self.__IOptimizer.LogToFile = value


	@property
	def MaxIterations(self) -> int:
		"""Returns/sets the maximum number of iterations to perform."""
		return self.__IOptimizer.MaxIterations


	@MaxIterations.setter
	def MaxIterations(self, value: int):
		"""Returns/sets the maximum number of iterations to perform."""
		self.__IOptimizer.MaxIterations = value


	@property
	def Properties(self) -> CProperties:
		"""Returns a reference to a collection of Property objects."""
		return CProperties(self.__IOptimizer.Properties)


	@property
	def Running(self) -> bool:
		"""Returns/sets the running state of the optimizer."""
		return self.__IOptimizer.Running


	@Running.setter
	def Running(self, value: bool):
		"""Returns/sets the running state of the optimizer."""
		self.__IOptimizer.Running = value


	@property
	def ShowAllUpdates(self) -> bool:
		"""Returns/sets a value which specifies if the optimizer should show all iteration updates."""
		return self.__IOptimizer.ShowAllUpdates


	@ShowAllUpdates.setter
	def ShowAllUpdates(self, value: bool):
		"""Returns/sets a value which specifies if the optimizer should show all iteration updates."""
		self.__IOptimizer.ShowAllUpdates = value


	@property
	def SimulatorIteration(self) -> int:
		"""Returns the number of current simulator iteration."""
		return self.__IOptimizer.SimulatorIteration


	@property
	def StopAtMin(self) -> bool:
		"""Returns/sets a value which specifies if the optimization is to stop when the min cost is hit."""
		return self.__IOptimizer.StopAtMin


	@StopAtMin.setter
	def StopAtMin(self, value: bool):
		"""Returns/sets a value which specifies if the optimization is to stop when the min cost is hit."""
		self.__IOptimizer.StopAtMin = value


	@property
	def StopOnErr(self) -> bool:
		"""Returns/sets a value which specifies if the optimization is to stop when there is a simulation error."""
		return self.__IOptimizer.StopOnErr


	@StopOnErr.setter
	def StopOnErr(self, value: bool):
		"""Returns/sets a value which specifies if the optimization is to stop when there is a simulation error."""
		self.__IOptimizer.StopOnErr = value


	@property
	def Type(self):
		"""Returns/sets a value which specifies the type of optimizer."""
		return self.__IOptimizer.Type


	@Type.setter
	def Type(self, value):
		"""Returns/sets a value which specifies the type of optimizer."""
		self.__IOptimizer.Type = value


	@property
	def TypeCount(self) -> int:
		"""Returns the number of types of optimizers."""
		return self.__IOptimizer.TypeCount


	def TypeName(self, Index: int) -> str:
		"""Returns the name of a Optimizer type."""
		return self.__IOptimizer.TypeName(Index)


	@property
	def Variables(self) -> COptVariables:
		"""Returns a reference to an MWOffice OptVariables collection."""
		return COptVariables(self.__IOptimizer.Variables)


	@property
	def Windows(self) -> CWindows:
		"""Returns a reference to a collection of Window objects."""
		return CWindows(self.__IOptimizer.Windows)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Synthesizer
class CSynthesizer:
	"""An MWOffice Synthesis object."""
	def __init__(self, synthesizer):
		self.__ISynthesizer = synthesizer

	def _get_inner(self):
		return self.__ISynthesizer


	def SetSynthesizeParameter(self, Index, Guess: float, Lower: float, Upper: float) -> None:
		"""Sets the physical parameter to be synthesized."""
		self.__ISynthesizer.SetSynthesizeParameter(Index, Guess, Lower, Upper)


	def Analyze(self) -> None:
		"""Calculates the electrical parameters based on the physical parameters."""
		self.__ISynthesizer.Analyze()


	def Synthesize(self) -> None:
		"""Synthesizes physical parameters based on the electrical parameters."""
		self.__ISynthesizer.Synthesize()


	def Reset(self) -> None:
		"""Resets the synthesizer object."""
		self.__ISynthesizer.Reset()



	@property
	def Description(self) -> str:
		"""Returns a description of the model."""
		return self.__ISynthesizer.Description


	def ElectricalParameter(self, Index) -> float:
		"""Returns/sets the value of the electrical parameters."""
		return self.__ISynthesizer.ElectricalParameter(Index)


	def SetElectricalParameter(self, Index, value: float):
		"""Returns/sets the value of the electrical parameters."""
		self.__ISynthesizer.ElectricalParameter = value


	@property
	def ElectricalParameterNames(self):
		"""Returns the names of the electrical parameters."""
		return self.__ISynthesizer.ElectricalParameterNames


	@property
	def ElectricalParameters(self) -> int:
		"""Returns the number of electrical parameters."""
		return self.__ISynthesizer.ElectricalParameters


	@property
	def Model(self) -> str:
		"""Returns/set the model of the synthesizer."""
		return self.__ISynthesizer.Model


	@Model.setter
	def Model(self, value: str):
		"""Returns/set the model of the synthesizer."""
		self.__ISynthesizer.Model = value


	def PhysicalParameter(self, Index) -> float:
		"""Returns/sets the value of the physical parameters."""
		return self.__ISynthesizer.PhysicalParameter(Index)


	def SetPhysicalParameter(self, Index, value: float):
		"""Returns/sets the value of the physical parameters."""
		self.__ISynthesizer.PhysicalParameter = value


	@property
	def PhysicalParameterNames(self):
		"""Returns the names of the physical parameters."""
		return self.__ISynthesizer.PhysicalParameterNames


	@property
	def PhysicalParameters(self) -> int:
		"""Returns the number of physical parameters."""
		return self.__ISynthesizer.PhysicalParameters


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Sweeper
class CSweeper:
	"""An MWOffice Sweeper object."""
	def __init__(self, sweeper):
		self.__ISweeper = sweeper

	def _get_inner(self):
		return self.__ISweeper


	def AddVariable(self, Key: str, Variable) -> None:
		"""Adds an Equation or Parameter to the Sweeper."""
		self.__ISweeper.AddVariable(Key, Variable)


	def RemoveVariable(self, Key: str) -> None:
		"""Removes an Equation or Parameter from the Sweeper."""
		self.__ISweeper.RemoveVariable(Key)


	def Update(self, UpdateDisplay: bool, UpdateGraphs: bool) -> None:
		"""Updates the measurements with the added values."""
		self.__ISweeper.Update(UpdateDisplay, UpdateGraphs)



	def Value(self, Key: str) -> float:
		"""Returns/sets the value of an added Equation or Parameter."""
		return self.__ISweeper.Value(Key)


	def SetValue(self, Key: str, value: float):
		"""Returns/sets the value of an added Equation or Parameter."""
		self.__ISweeper.Value = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# TuneVariable
class CTuneVariable:
	"""A MWOffice TuneVariable object."""
	def __init__(self, tunevariable):
		self.__ITuneVariable = tunevariable

	def _get_inner(self):
		return self.__ITuneVariable


	def TuneUp(self) -> bool:
		"""Increments the tuner nominal value by the amount of step value towards the maximum value."""
		return self.__ITuneVariable.TuneUp()


	def TuneDown(self) -> bool:
		"""Decrements the tuner nominal value by the amount of step value towards the minimum value."""
		return self.__ITuneVariable.TuneDown()



	@property
	def Enabled(self) -> bool:
		"""Returns/sets if the variable is enabled for tuning. Allows disabling a tune variable."""
		return self.__ITuneVariable.Enabled


	@Enabled.setter
	def Enabled(self, value: bool):
		"""Returns/sets if the variable is enabled for tuning. Allows disabling a tune variable."""
		self.__ITuneVariable.Enabled = value


	@property
	def Maximum(self) -> float:
		"""Returns/sets the maximum value for the TuneVariable object."""
		return self.__ITuneVariable.Maximum


	@Maximum.setter
	def Maximum(self, value: float):
		"""Returns/sets the maximum value for the TuneVariable object."""
		self.__ITuneVariable.Maximum = value


	@property
	def Minimum(self) -> float:
		"""Returns/sets the minimum value for the TuneVariable object."""
		return self.__ITuneVariable.Minimum


	@Minimum.setter
	def Minimum(self, value: float):
		"""Returns/sets the minimum value for the TuneVariable object."""
		self.__ITuneVariable.Minimum = value


	@property
	def Name(self) -> str:
		"""Returns the file name of the project, not including the file's path specification."""
		return self.__ITuneVariable.Name


	@property
	def Nominal(self) -> float:
		"""Returns/sets the nominal value for the TuneVariable object."""
		return self.__ITuneVariable.Nominal


	@Nominal.setter
	def Nominal(self, value: float):
		"""Returns/sets the nominal value for the TuneVariable object."""
		self.__ITuneVariable.Nominal = value


	@property
	def step(self) -> float:
		"""Returns/sets the step value for the TuneVariable object."""
		return self.__ITuneVariable.step


	@step.setter
	def step(self, value: float):
		"""Returns/sets the step value for the TuneVariable object."""
		self.__ITuneVariable.step = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# TuneVariables
class CTuneVariables:
	"""A collection of MWOffice TuneVariable objects."""
	def __init__(self, tunevariables):
		self.__ITuneVariables = tunevariables

	def _get_inner(self):
		return self.__ITuneVariables



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ITuneVariables.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ITuneVariables.Exists(Index)


	def Item(self, Index) -> CTuneVariable:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CTuneVariable(self.__ITuneVariables.Item(Index))


	def __get_Item(self, Index) -> CTuneVariable:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CTuneVariable(self.__ITuneVariables.Item(Index))


	def __call__(self, index) -> CTuneVariable:
		return self.__get_Item(index)


	def __iter__(self) -> CTuneVariable:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ITuneVariables.Count


	def __getitem__(self, index) -> Union[CTuneVariable, List[CTuneVariable]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Tuner
class CTuner:
	"""A MWOffice Tuner object."""
	def __init__(self, tuner):
		self.__ITuner = tuner

	def _get_inner(self):
		return self.__ITuner


	def Save(self, stateName: str) -> bool:
		"""Save the current state of the TuneVariables under the provided state name."""
		return self.__ITuner.Save(stateName)


	def Restore(self, stateName: str) -> bool:
		"""Restore the state of the TuneVariables associated with the provided state name."""
		return self.__ITuner.Restore(stateName)


	def Tag(self, tagName: str) -> bool:
		"""Tag the current state of the TuneVariables with the provided state name."""
		return self.__ITuner.Tag(tagName)


	def Sweep(self) -> bool:
		"""Perform a simulation sweep with the current TuneVariable state."""
		return self.__ITuner.Sweep()


	def Freeze(self) -> bool:
		"""Freeze the current sweep output in the graphs and output documents."""
		return self.__ITuner.Freeze()


	def Clear(self) -> bool:
		"""Clear the frozen sweep outputs from the graphics and output documents."""
		return self.__ITuner.Clear()



	@property
	def Variables(self) -> CTuneVariables:
		"""Returns a reference to a MWOffice TuneVariables collection."""
		return CTuneVariables(self.__ITuner.Variables)


	@property
	def Visible(self) -> bool:
		"""Returns/sets if the tuner window is visible."""
		return self.__ITuner.Visible


	@Visible.setter
	def Visible(self, value: bool):
		"""Returns/sets if the tuner window is visible."""
		self.__ITuner.Visible = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ControlBarItem
class CControlBarItem:
	"""An MWOffice ControlBarItem object."""
	def __init__(self, controlbaritem):
		self.__IControlBarItem = controlbaritem

	def _get_inner(self):
		return self.__IControlBarItem


	def Delete(self) -> None:
		"""Removes the object."""
		self.__IControlBarItem.Delete()



	@property
	def Action(self):
		"""Returns the action of the ControlBarItem object."""
		return self.__IControlBarItem.Action


	@property
	def Caption(self) -> str:
		"""Returns/Sets the caption of an object."""
		return self.__IControlBarItem.Caption


	@Caption.setter
	def Caption(self, value: str):
		"""Returns/Sets the caption of an object."""
		self.__IControlBarItem.Caption = value


	@property
	def Image(self) -> int:
		"""Returns the image index of the ControlBarItem object."""
		return self.__IControlBarItem.Image


	@Image.setter
	def Image(self, value: int):
		"""Returns the image index of the ControlBarItem object."""
		self.__IControlBarItem.Image = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# ControlBarItems
class CControlBarItems:
	"""A collection of MWOffice ControlBarItem objects."""
	def __init__(self, controlbaritems):
		self.__IControlBarItems = controlbaritems

	def _get_inner(self):
		return self.__IControlBarItems


	def Add(self, OnAction, Before, Image: int, Caption: str) -> CControlBarItem:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CControlBarItem(self.__IControlBarItems.Add(OnAction, Before, Image, Caption))


	def Clear(self) -> None:
		"""Removes all objects in a collection."""
		self.__IControlBarItems.Clear()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IControlBarItems.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IControlBarItems.Exists(Index)


	def Item(self, Index) -> CControlBarItem:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CControlBarItem(self.__IControlBarItems.Item(Index))


	def __get_Item(self, Index) -> CControlBarItem:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CControlBarItem(self.__IControlBarItems.Item(Index))


	def __call__(self, index) -> CControlBarItem:
		return self.__get_Item(index)


	def __iter__(self) -> CControlBarItem:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IControlBarItems.Count


	def __getitem__(self, index) -> Union[CControlBarItem, List[CControlBarItem]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# MenuBar
class CMenuBar:
	"""An MWOffice MenuBar object."""
	def __init__(self, menubar):
		self.__IMenuBar = menubar

	def _get_inner(self):
		return self.__IMenuBar


	def FreezeUpdates(self) -> None:
		"""Prevents the MenuBar from updating changes that are made to it."""
		self.__IMenuBar.FreezeUpdates()


	def UnfreezeUpdates(self) -> None:
		"""Allows the MenuBar to update when changes are made to it."""
		self.__IMenuBar.UnfreezeUpdates()



	@property
	def Menus(self) -> CMenus:
		"""Returns a reference to a collection of Menu objects."""
		return CMenus(self.__IMenuBar.Menus)


	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__IMenuBar.Name


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# MenuBars
class CMenuBars:
	"""A collection of MWOffice MenuBar objects."""
	def __init__(self, menubars):
		self.__IMenuBars = menubars

	def _get_inner(self):
		return self.__IMenuBars



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IMenuBars.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IMenuBars.Exists(Index)


	def Item(self, Index) -> CMenuBar:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CMenuBar(self.__IMenuBars.Item(Index))


	def __get_Item(self, Index) -> CMenuBar:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CMenuBar(self.__IMenuBars.Item(Index))


	def __call__(self, index) -> CMenuBar:
		return self.__get_Item(index)


	def __iter__(self) -> CMenuBar:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IMenuBars.Count


	def __getitem__(self, index) -> Union[CMenuBar, List[CMenuBar]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Menu
class CMenu:
	"""An MWOffice Menu object."""
	def __init__(self, menu):
		self.__IMenu = menu

	def _get_inner(self):
		return self.__IMenu


	def Delete(self) -> None:
		"""Removes the object."""
		self.__IMenu.Delete()



	@property
	def Caption(self) -> str:
		"""Returns/Sets the caption of an object."""
		return self.__IMenu.Caption


	@Caption.setter
	def Caption(self, value: str):
		"""Returns/Sets the caption of an object."""
		self.__IMenu.Caption = value


	@property
	def MenuItems(self) -> CMenuItems:
		"""Returns a reference to a collection of MenuItem objects."""
		return CMenuItems(self.__IMenu.MenuItems)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Menus
class CMenus:
	"""A collection of MWOffice Menu objects."""
	def __init__(self, menus):
		self.__IMenus = menus

	def _get_inner(self):
		return self.__IMenus


	def Add(self, Caption: str, Before) -> CMenu:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CMenu(self.__IMenus.Add(Caption, Before))


	def Clear(self) -> None:
		"""Removes all objects in a collection."""
		self.__IMenus.Clear()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IMenus.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IMenus.Exists(Index)


	def Item(self, Index) -> CMenu:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CMenu(self.__IMenus.Item(Index))


	def __get_Item(self, Index) -> CMenu:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CMenu(self.__IMenus.Item(Index))


	def __call__(self, index) -> CMenu:
		return self.__get_Item(index)


	def __iter__(self) -> CMenu:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IMenus.Count


	def __getitem__(self, index) -> Union[CMenu, List[CMenu]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# MenuItem
class CMenuItem:
	"""An MWOffice MenuItem object."""
	def __init__(self, menuitem):
		self.__IMenuItem = menuitem

	def _get_inner(self):
		return self.__IMenuItem


	def Delete(self) -> None:
		"""Removes the object."""
		self.__IMenuItem.Delete()



	@property
	def Action(self):
		"""Returns the action of the MenuItem object."""
		return self.__IMenuItem.Action


	@property
	def Caption(self) -> str:
		"""Returns/Sets the caption of an object."""
		return self.__IMenuItem.Caption


	@Caption.setter
	def Caption(self, value: str):
		"""Returns/Sets the caption of an object."""
		self.__IMenuItem.Caption = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# MenuItems
class CMenuItems:
	"""A collection of MWOffice MenuItem objects."""
	def __init__(self, menuitems):
		self.__IMenuItems = menuitems

	def _get_inner(self):
		return self.__IMenuItems


	def Add(self, OnAction, Before, Caption: str) -> CMenuItem:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CMenuItem(self.__IMenuItems.Add(OnAction, Before, Caption))


	def AddMenu(self, Caption: str, Before) -> CMenu:
		"""Adds a new menu to the collection."""
		return CMenu(self.__IMenuItems.AddMenu(Caption, Before))



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IMenuItems.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IMenuItems.Exists(Index)


	def Item(self, Index):
		"""Returns a specific item of a Collection object either by position or by key."""
		return self.__IMenuItems.Item(Index)


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# HotkeyTable
class CHotkeyTable:
	"""An MWOffice HotkeyTable object."""
	def __init__(self, hotkeytable):
		self.__IHotkeyTable = hotkeytable

	def _get_inner(self):
		return self.__IHotkeyTable



	@property
	def Hotkeys(self) -> CHotkeys:
		"""Returns a reference to a collection of Hotkey objects."""
		return CHotkeys(self.__IHotkeyTable.Hotkeys)


	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__IHotkeyTable.Name


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# HotkeyTables
class CHotkeyTables:
	"""A collection of MWOffice HotkeyTable objects."""
	def __init__(self, hotkeytables):
		self.__IHotkeyTables = hotkeytables

	def _get_inner(self):
		return self.__IHotkeyTables


	def Reload(self) -> None:
		"""Reloads the active hotkey table so any changes take affect."""
		self.__IHotkeyTables.Reload()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IHotkeyTables.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IHotkeyTables.Exists(Index)


	def Item(self, Index) -> CHotkeyTable:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CHotkeyTable(self.__IHotkeyTables.Item(Index))


	def __get_Item(self, Index) -> CHotkeyTable:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CHotkeyTable(self.__IHotkeyTables.Item(Index))


	def __call__(self, index) -> CHotkeyTable:
		return self.__get_Item(index)


	def __iter__(self) -> CHotkeyTable:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IHotkeyTables.Count


	def __getitem__(self, index) -> Union[CHotkeyTable, List[CHotkeyTable]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Hotkey
class CHotkey:
	"""An MWOffice Hotkey object."""
	def __init__(self, hotkey):
		self.__IHotkey = hotkey

	def _get_inner(self):
		return self.__IHotkey


	def Delete(self) -> None:
		"""Removes the object."""
		self.__IHotkey.Delete()


	def IsFlagSet(self, flag: mwHotKeyFlags) -> bool:
		"""Returns a value that indicates if the given flag is set for the Hotkey object."""
		return self.__IHotkey.IsFlagSet(flag)



	@property
	def Action(self):
		"""Returns the action of the Hotkey object."""
		return self.__IHotkey.Action


	@property
	def Flags(self) -> int:
		"""Returns the flags of the Hotkey object."""
		return self.__IHotkey.Flags


	@property
	def Key(self) -> int:
		"""Returns the key of the Hotkey object."""
		return self.__IHotkey.Key


	@property
	def Mnemonic(self) -> str:
		"""Returns the mnemonic of the Hotkey object."""
		return self.__IHotkey.Mnemonic


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Hotkeys
class CHotkeys:
	"""A collection of MWOffice Hotkey objects."""
	def __init__(self, hotkeys):
		self.__IHotkeys = hotkeys

	def _get_inner(self):
		return self.__IHotkeys


	def Add(self, OnAction, Key: int, Flags: int) -> CHotkey:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CHotkey(self.__IHotkeys.Add(OnAction, Key, Flags))


	def Clear(self) -> None:
		"""Removes all objects in a collection."""
		self.__IHotkeys.Clear()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IHotkeys.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IHotkeys.Exists(Index)


	def Item(self, Index) -> CHotkey:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CHotkey(self.__IHotkeys.Item(Index))


	def __get_Item(self, Index) -> CHotkey:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CHotkey(self.__IHotkeys.Item(Index))


	def __call__(self, index) -> CHotkey:
		return self.__get_Item(index)


	def __iter__(self) -> CHotkey:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IHotkeys.Count


	def __getitem__(self, index) -> Union[CHotkey, List[CHotkey]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# CommandTable
class CCommandTable:
	"""An MWOffice CommandTable object."""
	def __init__(self, commandtable):
		self.__ICommandTable = commandtable

	def _get_inner(self):
		return self.__ICommandTable



	@property
	def BaseId(self) -> int:
		"""Returns the base command id associated with the CommandTable object if there is one."""
		return self.__ICommandTable.BaseId


	@property
	def Commands(self) -> CCommands:
		"""Returns a reference to a collection of Command objects."""
		return CCommands(self.__ICommandTable.Commands)


	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__ICommandTable.Name


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# CommandTables
class CCommandTables:
	"""A collection of MWOffice CommandTable objects."""
	def __init__(self, commandtables):
		self.__ICommandTables = commandtables

	def _get_inner(self):
		return self.__ICommandTables


	def Add(self, Name: str, Size: int = 1000) -> CCommandTable:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CCommandTable(self.__ICommandTables.Add(Name, Size))


	def Find(self, Name: str) -> CCommand:
		"""Searches the CommandTables for specified Command object."""
		return CCommand(self.__ICommandTables.Find(Name))


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__ICommandTables.GetUniqueName(baseName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ICommandTables.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ICommandTables.Exists(Index)


	def Item(self, Index) -> CCommandTable:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CCommandTable(self.__ICommandTables.Item(Index))


	def __get_Item(self, Index) -> CCommandTable:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CCommandTable(self.__ICommandTables.Item(Index))


	def __call__(self, index) -> CCommandTable:
		return self.__get_Item(index)


	def __iter__(self) -> CCommandTable:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ICommandTables.Count


	def __getitem__(self, index) -> Union[CCommandTable, List[CCommandTable]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Command
class CCommand:
	"""An MWOffice Command object."""
	def __init__(self, command):
		self.__ICommand = command

	def _get_inner(self):
		return self.__ICommand


	def Delete(self) -> None:
		"""Removes the object."""
		self.__ICommand.Delete()



	@property
	def Caption(self) -> str:
		"""Returns/Sets the caption of an object."""
		return self.__ICommand.Caption


	@property
	def HelpFile(self) -> str:
		"""Returns the help file of the Command object."""
		return self.__ICommand.HelpFile


	@property
	def HelpId(self) -> int:
		"""Returns the help file context id of the Command object."""
		return self.__ICommand.HelpId


	@property
	def Helpstring(self) -> str:
		"""Returns the help string of the Command object."""
		return self.__ICommand.Helpstring


	@property
	def Id(self) -> int:
		"""Returns the identification number of the Command object."""
		return self.__ICommand.Id


	@property
	def Image(self) -> int:
		"""Returns the image index of the Command object."""
		return self.__ICommand.Image


	@property
	def Name(self) -> str:
		"""Returns the name used in code to identify an object."""
		return self.__ICommand.Name


	@property
	def Tooltip(self) -> str:
		"""Returns the tooltip of the Command object."""
		return self.__ICommand.Tooltip


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Commands
class CCommands:
	"""A collection of MWOffice Command objects."""
	def __init__(self, commands):
		self.__ICommands = commands

	def _get_inner(self):
		return self.__ICommands


	def Add(self, Name: str, CmdId: int, Caption: str, Image: int, Tooltip: str, Helpstring: str, HelpFile: str, HelpContextID: int) -> CCommand:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CCommand(self.__ICommands.Add(Name, CmdId, Caption, Image, Tooltip, Helpstring, HelpFile, HelpContextID))


	def Clear(self) -> None:
		"""Removes all objects in a collection."""
		self.__ICommands.Clear()


	def GetUniqueName(self, baseName: str) -> str:
		"""Returns a unique name to be used when adding objects to the collection."""
		return self.__ICommands.GetUniqueName(baseName)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ICommands.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__ICommands.Exists(Index)


	def Item(self, Index) -> CCommand:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CCommand(self.__ICommands.Item(Index))


	def __get_Item(self, Index) -> CCommand:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CCommand(self.__ICommands.Item(Index))


	def __call__(self, index) -> CCommand:
		return self.__get_Item(index)


	def __iter__(self) -> CCommand:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ICommands.Count


	def __getitem__(self, index) -> Union[CCommand, List[CCommand]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DrawingShape
class CDrawingShape:
	"""An MWOffice DrawingShape object."""
	def __init__(self, drawingshape):
		self.__IDrawingShape = drawingshape

	def _get_inner(self):
		return self.__IDrawingShape


	def Move(self, dx: int, dy: int, CCWRotation: float = 0, Flip: bool = 0, FlipHorizontal: bool = 0, xOrigin: float = 0, yOrigin: float = 0) -> bool:
		"""Moves DrawingShape object by the given values relative to the current location."""
		return self.__IDrawingShape.Move(dx, dy, CCWRotation, Flip, FlipHorizontal, xOrigin, yOrigin)


	def Delete(self) -> bool:
		"""Removes the object."""
		return self.__IDrawingShape.Delete()


	def IsTypeBitSet2(self, typeBit: mwObjectSelectFilters) -> bool:
		"""Returns a value that indicates if this drawing object has a specific type bit set, these include specific bits for Polygon, Path, and Circle"""
		return self.__IDrawingShape.IsTypeBitSet2(typeBit)



	@property
	def Attributes(self) -> CAttributes:
		"""Returns a reference to a collection of Attribute objects."""
		return CAttributes(self.__IDrawingShape.Attributes)


	@property
	def BasePosition(self) -> Cpoint:
		"""Returns a reference to a Point object."""
		return Cpoint(self.__IDrawingShape.BasePosition)


	@property
	def Flipped(self) -> bool:
		"""Returns/Sets a value that specifies the flipped state of the DrawingShape object."""
		return self.__IDrawingShape.Flipped


	@Flipped.setter
	def Flipped(self, value: bool):
		"""Returns/Sets a value that specifies the flipped state of the DrawingShape object."""
		self.__IDrawingShape.Flipped = value


	@property
	def Height(self) -> int:
		"""Returns the height of the DrawingShape bounding area."""
		return self.__IDrawingShape.Height


	@property
	def Left(self) -> int:
		"""Returns the left edge of the DrawingShape bounding area."""
		return self.__IDrawingShape.Left


	@property
	def Points(self) -> CPoints:
		"""Returns a reference to a collection of Point objects."""
		return CPoints(self.__IDrawingShape.Points)


	@property
	def RotationAngle(self) -> float:
		"""Returns/Sets a value that specifies the rotation angle of the DrawingShape object."""
		return self.__IDrawingShape.RotationAngle


	@RotationAngle.setter
	def RotationAngle(self, value: float):
		"""Returns/Sets a value that specifies the rotation angle of the DrawingShape object."""
		self.__IDrawingShape.RotationAngle = value


	@property
	def Selected(self) -> bool:
		"""Returns/Sets a value that specifies if the DrawingShape object is selected."""
		return self.__IDrawingShape.Selected


	@Selected.setter
	def Selected(self, value: bool):
		"""Returns/Sets a value that specifies if the DrawingShape object is selected."""
		self.__IDrawingShape.Selected = value


	@property
	def Top(self) -> int:
		"""Returns the top edge of the DrawingShape bounding area."""
		return self.__IDrawingShape.Top


	@property
	def Type(self):
		"""Returns a value that specifies the type of the DrawingShape object."""
		return self.__IDrawingShape.Type


	@property
	def TypeBits2(self) -> int:
		"""Returns flags describing the DrawingShape type, these include specific bits for Polygon, Path, and Circle"""
		return self.__IDrawingShape.TypeBits2


	@property
	def Width(self) -> int:
		"""Returns the width of the DrawingShape bounding area."""
		return self.__IDrawingShape.Width


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# DrawingShapes
class CDrawingShapes:
	"""A collection of MWOffice DrawingShape objects."""
	def __init__(self, drawingshapes):
		self.__IDrawingShapes = drawingshapes

	def _get_inner(self):
		return self.__IDrawingShapes


	def AddArc(self, Left: int, Top: int, Right: int, Bottom: int, xStart: int, yStart: int, xEnd: int, yEnd: int) -> CDrawingShape:
		"""Adds an arc shape to the DrawingShapes collection."""
		return CDrawingShape(self.__IDrawingShapes.AddArc(Left, Top, Right, Bottom, xStart, yStart, xEnd, yEnd))


	def AddEllipse(self, Left: int, Top: int, Right: int, Bottom: int) -> CDrawingShape:
		"""Adds an ellipse shape to the DrawingShapes collection."""
		return CDrawingShape(self.__IDrawingShapes.AddEllipse(Left, Top, Right, Bottom))


	def AddPolygon(self, XYPoints) -> CDrawingShape:
		"""Adds a polygon shape to the DrawingShapes collection."""
		return CDrawingShape(self.__IDrawingShapes.AddPolygon(XYPoints))


	def AddPolyline(self, XYPoints) -> CDrawingShape:
		"""Adds a polyline shape to the DrawingShapes collection."""
		return CDrawingShape(self.__IDrawingShapes.AddPolyline(XYPoints))


	def AddText(self, Left: int, Top: int, Height: int, Text: str, FontName: str = "Arial", Bold: bool = 0, Italic: bool = 0) -> CDrawingShape:
		"""Adds a text string shape to the DrawingShapes collection."""
		return CDrawingShape(self.__IDrawingShapes.AddText(Left, Top, Height, Text, FontName, Bold, Italic))


	def AddLine(self, x1: int, y1: int, x2: int, y2: int) -> CDrawingShape:
		"""Adds a line shape to the DrawingShapes collection."""
		return CDrawingShape(self.__IDrawingShapes.AddLine(x1, y1, x2, y2))


	def AddRectangle(self, Left: int, Top: int, Right: int, Bottom: int) -> CDrawingShape:
		"""Adds a rectangle shape to the DrawingShapes collection."""
		return CDrawingShape(self.__IDrawingShapes.AddRectangle(Left, Top, Right, Bottom))


	def AddArrow(self, XYPoints) -> CDrawingShape:
		"""Adds an arrow shape to the DrawingShapes collection."""
		return CDrawingShape(self.__IDrawingShapes.AddArrow(XYPoints))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IDrawingShapes.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IDrawingShapes.RemoveAll()


	def AddRichText(self, Left: int, Top: int, Width: int, Text: str, FontSize: float = 12, FontName: str = "Segoe UI", Callout: bool = -1, TailX: int = 0, TailY: int = 0) -> CDrawingShape:
		"""Adds a rich text shape to the DrawingShapes collection."""
		return CDrawingShape(self.__IDrawingShapes.AddRichText(Left, Top, Width, Text, FontSize, FontName, Callout, TailX, TailY))



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IDrawingShapes.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IDrawingShapes.Exists(Index)


	def Item(self, Index) -> CDrawingShape:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingShape(self.__IDrawingShapes.Item(Index))


	def __get_Item(self, Index) -> CDrawingShape:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingShape(self.__IDrawingShapes.Item(Index))


	def __call__(self, index) -> CDrawingShape:
		return self.__get_Item(index)


	def __iter__(self) -> CDrawingShape:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IDrawingShapes.Count


	def __getitem__(self, index) -> Union[CDrawingShape, List[CDrawingShape]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# SelectedDrawingShapes
class CSelectedDrawingShapes:
	"""A collection of MWOffice SelectedDrawingShapes object."""
	def __init__(self, selecteddrawingshapes):
		self.__ISelectedDrawingShapes = selecteddrawingshapes

	def _get_inner(self):
		return self.__ISelectedDrawingShapes


	def Add(self, DrawingShape: CDrawingShape) -> bool:
		"""Adds an object to the collection and returns a reference to the created object."""
		return self.__ISelectedDrawingShapes.Add(DrawingShape._get_inner())


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__ISelectedDrawingShapes.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__ISelectedDrawingShapes.RemoveAll()


	def AddAll(self) -> bool:
		"""Adds an object to the collection and returns a reference to the created object."""
		return self.__ISelectedDrawingShapes.AddAll()


	def AddFromArea(self, Left: int, Top: int, Right: int, Bottom: int, Type: mwAreaAddType = 0) -> bool:
		"""Adds the objects contained or overlapped by a given rectangle to the collection."""
		return self.__ISelectedDrawingShapes.AddFromArea(Left, Top, Right, Bottom, Type)



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__ISelectedDrawingShapes.Count


	def Item(self, Index) -> CDrawingShape:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingShape(self.__ISelectedDrawingShapes.Item(Index))


	def __get_Item(self, Index) -> CDrawingShape:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CDrawingShape(self.__ISelectedDrawingShapes.Item(Index))


	def __call__(self, index) -> CDrawingShape:
		return self.__get_Item(index)


	def __iter__(self) -> CDrawingShape:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__ISelectedDrawingShapes.Count


	def __getitem__(self, index) -> Union[CDrawingShape, List[CDrawingShape]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Argument
class CArgument:
	"""An MWOffice Argument object."""
	def __init__(self, argument):
		self.__IArgument = argument

	def _get_inner(self):
		return self.__IArgument



	@property
	def Value(self) -> str:
		"""Returns the argument value as a string."""
		return self.__IArgument.Value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Arguments
class CArguments:
	"""A collection of MWOffice Argument objects."""
	def __init__(self, arguments):
		self.__IArguments = arguments

	def _get_inner(self):
		return self.__IArguments



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IArguments.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IArguments.Exists(Index)


	def Item(self, Index) -> CArgument:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CArgument(self.__IArguments.Item(Index))


	def __get_Item(self, Index) -> CArgument:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CArgument(self.__IArguments.Item(Index))


	def __call__(self, index) -> CArgument:
		return self.__get_Item(index)


	def __iter__(self) -> CArgument:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IArguments.Count


	def __getitem__(self, index) -> Union[CArgument, List[CArgument]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# FlightLine
class CFlightLine:
	"""An MWOffice FlightLine object."""
	def __init__(self, flightline):
		self.__IFlightLine = flightline

	def _get_inner(self):
		return self.__IFlightLine



	@property
	def Begin(self) -> CVertex:
		"""Returns a reference to a Vertex object."""
		return CVertex(self.__IFlightLine.Begin)


	@property
	def End(self) -> CVertex:
		"""Returns a reference to a Vertex object."""
		return CVertex(self.__IFlightLine.End)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# FlightLines
class CFlightLines:
	"""A collection of MWOffice FlightLine objects."""
	def __init__(self, flightlines):
		self.__IFlightLines = flightlines

	def _get_inner(self):
		return self.__IFlightLines



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IFlightLines.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IFlightLines.Exists(Index)


	def Item(self, Index) -> CFlightLine:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CFlightLine(self.__IFlightLines.Item(Index))


	def __get_Item(self, Index) -> CFlightLine:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CFlightLine(self.__IFlightLines.Item(Index))


	def __call__(self, index) -> CFlightLine:
		return self.__get_Item(index)


	def __iter__(self) -> CFlightLine:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IFlightLines.Count


	def __getitem__(self, index) -> Union[CFlightLine, List[CFlightLine]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	@property
	def Selected(self) -> bool:
		"""Returns/sets a value that indicates if the Flightlines collection is selected."""
		return self.__IFlightLines.Selected


	@Selected.setter
	def Selected(self, value: bool):
		"""Returns/sets a value that indicates if the Flightlines collection is selected."""
		self.__IFlightLines.Selected = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# NetShape
class CNetShape:
	"""An MWOffice NetShape object."""
	def __init__(self, netshape):
		self.__INetShape = netshape

	def _get_inner(self):
		return self.__INetShape


	def Disassociate(self) -> CDrawingObject:
		"""Removes the association between this NetShape and its PhysicalNet returning a reference to the resulting disassociated DrawingObject."""
		return CDrawingObject(self.__INetShape.Disassociate())



	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__INetShape.Boundary)


	@property
	def LayerName(self) -> str:
		"""Returns/sets the drawing layer used by this NetShape when not using process layers for drawing."""
		return self.__INetShape.LayerName


	@LayerName.setter
	def LayerName(self, value: str):
		"""Returns/sets the drawing layer used by this NetShape when not using process layers for drawing."""
		self.__INetShape.LayerName = value


	@property
	def LineType(self) -> int:
		"""Returns/sets the line type index associate with this NetShape object."""
		return self.__INetShape.LineType


	@LineType.setter
	def LineType(self, value: int):
		"""Returns/sets the line type index associate with this NetShape object."""
		self.__INetShape.LineType = value


	@property
	def NetID(self) -> int:
		"""Returns/sets the physical net identifier associated with this NetShape object."""
		return self.__INetShape.NetID


	@NetID.setter
	def NetID(self, value: int):
		"""Returns/sets the physical net identifier associated with this NetShape object."""
		self.__INetShape.NetID = value


	@property
	def Orphan(self) -> bool:
		"""Returns if this an orphan and not associated with a physical net."""
		return self.__INetShape.Orphan


	@property
	def Points(self) -> CVertices:
		"""Returns a reference to a collection of Vertex objects."""
		return CVertices(self.__INetShape.Points)


	@property
	def PolyPoints(self) -> CVertices:
		"""Returns a reference to a collection of Vertex objects."""
		return CVertices(self.__INetShape.PolyPoints)


	@property
	def Selected(self) -> bool:
		"""Returns/sets if this NetShape object is selected."""
		return self.__INetShape.Selected


	@Selected.setter
	def Selected(self, value: bool):
		"""Returns/sets if this NetShape object is selected."""
		self.__INetShape.Selected = value


	@property
	def UseProcessLayers(self) -> bool:
		"""Returns/sets if this NetShape object is using process layers or drawing layers."""
		return self.__INetShape.UseProcessLayers


	@UseProcessLayers.setter
	def UseProcessLayers(self, value: bool):
		"""Returns/sets if this NetShape object is using process layers or drawing layers."""
		self.__INetShape.UseProcessLayers = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# NetShapes
class CNetShapes:
	"""A collection of MWOffice NetShape objects."""
	def __init__(self, netshapes):
		self.__INetShapes = netshapes

	def _get_inner(self):
		return self.__INetShapes


	def AddRectangle(self, x: float, y: float, dx: float, dy: float, LayerName: str = "", UseProcessLayers: bool = 0, LayerMapping: str = "") -> CNetShape:
		"""Adds a new rectangle NetShape object to the NetShapes collection."""
		return CNetShape(self.__INetShapes.AddRectangle(x, y, dx, dy, LayerName, UseProcessLayers, LayerMapping))


	def AddPolygon(self, XYPoints, LayerName: str = "", UseProcessLayers: bool = 0, LayerMapping: str = "") -> CNetShape:
		"""Adds a new polygon NetShape object to the NetShapes collection."""
		return CNetShape(self.__INetShapes.AddPolygon(XYPoints, LayerName, UseProcessLayers, LayerMapping))


	def AddPath(self, XYPoints, Width: float, EndStyle: mwPathEndType = 1, MiterStyle: mwPathMiterType = 1, OffsetMiterAmount: float = 0, LayerName: str = "", UseProcessLayers: bool = 0, LayerMapping: str = "") -> CNetShape:
		"""Adds a new path NetShape object to the NetShapes collection."""
		return CNetShape(self.__INetShapes.AddPath(XYPoints, Width, EndStyle, MiterStyle, OffsetMiterAmount, LayerName, UseProcessLayers, LayerMapping))


	def AddEllipse(self, x: float, y: float, dx: float, dy: float, LayerName: str = "", UseProcessLayers: bool = 0, LayerMapping: str = "") -> CNetShape:
		"""Adds a new ellipse NetShape object to the NetShapes collection."""
		return CNetShape(self.__INetShapes.AddEllipse(x, y, dx, dy, LayerName, UseProcessLayers, LayerMapping))



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__INetShapes.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__INetShapes.Exists(Index)


	def Item(self, Index) -> CNetShape:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CNetShape(self.__INetShapes.Item(Index))


	def __get_Item(self, Index) -> CNetShape:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CNetShape(self.__INetShapes.Item(Index))


	def __call__(self, index) -> CNetShape:
		return self.__get_Item(index)


	def __iter__(self) -> CNetShape:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__INetShapes.Count


	def __getitem__(self, index) -> Union[CNetShape, List[CNetShape]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# PhysicalNet
class CPhysicalNet:
	"""An MWOffice PhysicalNet object."""
	def __init__(self, physicalnet):
		self.__IPhysicalNet = physicalnet

	def _get_inner(self):
		return self.__IPhysicalNet


	def HighlightNet(self, bHighlightOn: bool, Color: int = 255) -> bool:
		"""Sets the highlight state of the physical net to on or off and allows the specification of the highlight Color."""
		return self.__IPhysicalNet.HighlightNet(bHighlightOn, Color)


	def AssociateObject(self, pObj: CDrawingObject) -> bool:
		"""Associates the object with the physical net if possible"""
		return self.__IPhysicalNet.AssociateObject(pObj._get_inner())



	@property
	def Complete(self) -> bool:
		"""Returns a value indicating if the physical connections for this net are completely connected."""
		return self.__IPhysicalNet.Complete


	@property
	def ElectNetName(self) -> str:
		"""Returns the name of the electrical net element associated with this physical net."""
		return self.__IPhysicalNet.ElectNetName


	@property
	def FlightLines(self) -> CFlightLines:
		"""Returns a reference to a MWOffice FlightLines collection."""
		return CFlightLines(self.__IPhysicalNet.FlightLines)


	@property
	def Name(self) -> str:
		"""Returns/Sets the name used in code to identify an object."""
		return self.__IPhysicalNet.Name


	@property
	def NetHighlight(self) -> bool:
		"""Returns if the physical net is currently highlighted."""
		return self.__IPhysicalNet.NetHighlight


	@property
	def NetHighlightColor(self) -> int:
		"""Returns the highlight color for the net."""
		return self.__IPhysicalNet.NetHighlightColor


	@property
	def NetID(self) -> int:
		"""Returns a value indicating the identifier associated with this physical net."""
		return self.__IPhysicalNet.NetID


	@property
	def Pins(self) -> CPins:
		"""Returns a reference to a MWOffice Pins collection."""
		return CPins(self.__IPhysicalNet.Pins)


	@property
	def RouteConnectionModel(self):
		"""Returns/sets a value indicating the physical net's current mode for route-to-route connections."""
		return self.__IPhysicalNet.RouteConnectionModel


	@RouteConnectionModel.setter
	def RouteConnectionModel(self, value: mwRouteConnModel):
		"""Returns/sets a value indicating the physical net's current mode for route-to-route connections."""
		self.__IPhysicalNet.RouteConnectionModel = value


	@property
	def Routes(self) -> CRoutes:
		"""Returns a reference to a MWOffice Routes collection."""
		return CRoutes(self.__IPhysicalNet.Routes)


	@property
	def SemiAutoViaMode(self) -> bool:
		"""Returns/sets a value indicating if the current via mode should behave as semi-auto, inserting vias initially and then becoming equivalent to manual mode."""
		return self.__IPhysicalNet.SemiAutoViaMode


	@SemiAutoViaMode.setter
	def SemiAutoViaMode(self, value: bool):
		"""Returns/sets a value indicating if the current via mode should behave as semi-auto, inserting vias initially and then becoming equivalent to manual mode."""
		self.__IPhysicalNet.SemiAutoViaMode = value


	@property
	def Shapes(self) -> CNetShapes:
		"""Returns a reference to a MWOffice NetShapes collection."""
		return CNetShapes(self.__IPhysicalNet.Shapes)


	@property
	def UserNetName(self) -> str:
		"""Returns/sets the user net name for PhysicalNet object."""
		return self.__IPhysicalNet.UserNetName


	@UserNetName.setter
	def UserNetName(self, value: str):
		"""Returns/sets the user net name for PhysicalNet object."""
		self.__IPhysicalNet.UserNetName = value


	@property
	def ViaMode(self):
		"""Returns/sets a value indicating the physical net's current mode for automatic via insertion."""
		return self.__IPhysicalNet.ViaMode


	@ViaMode.setter
	def ViaMode(self, value: mwNetViaMode):
		"""Returns/sets a value indicating the physical net's current mode for automatic via insertion."""
		self.__IPhysicalNet.ViaMode = value


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Name)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# PhysicalNets
class CPhysicalNets:
	"""A collection of MWOffice PhysicalNet objects."""
	def __init__(self, physicalnets):
		self.__IPhysicalNets = physicalnets

	def _get_inner(self):
		return self.__IPhysicalNets



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IPhysicalNets.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IPhysicalNets.Exists(Index)


	def Item(self, Index) -> CPhysicalNet:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CPhysicalNet(self.__IPhysicalNets.Item(Index))


	def __get_Item(self, Index) -> CPhysicalNet:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CPhysicalNet(self.__IPhysicalNets.Item(Index))


	def __call__(self, index) -> CPhysicalNet:
		return self.__get_Item(index)


	def __iter__(self) -> CPhysicalNet:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IPhysicalNets.Count


	def __getitem__(self, index) -> Union[CPhysicalNet, List[CPhysicalNet]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# RouteRecord
class CRouteRecord:
	"""An MWOffice RouteRecord object."""
	def __init__(self, routerecord):
		self.__IRouteRecord = routerecord

	def _get_inner(self):
		return self.__IRouteRecord


	def AddSegment(self, x1: float, y1: float, x2: float, y2: float, Width: float, LineType: int, BeginStyle: mwRouteSegmentEndStyleType, BeginExtent: float, EndStyle: mwRouteSegmentEndStyleType, EndExtent: float) -> CRouteObject:
		"""Adds a new route segment to the RouteRecord object."""
		return CRouteObject(self.__IRouteRecord.AddSegment(x1, y1, x2, y2, Width, LineType, BeginStyle, BeginExtent, EndStyle, EndExtent))


	def AddVia(self, xOrigin: float, yOrigin: float, xExtent: float, yExtent: float, xOffset: float, yOffset: float, LineType1: int, LineType2: int, Direction: mwRouteViaDirectionType) -> CRouteObject:
		"""Adds a new route via to the RouteRecord object."""
		return CRouteObject(self.__IRouteRecord.AddVia(xOrigin, yOrigin, xExtent, yExtent, xOffset, yOffset, LineType1, LineType2, Direction))


	def AddGuide(self, x1: float, y1: float, x2: float, y2: float, Begin: int, End: int) -> CRouteObject:
		"""Adds a new route guide to the RouteRecord object."""
		return CRouteObject(self.__IRouteRecord.AddGuide(x1, y1, x2, y2, Begin, End))


	def AddViaType(self, xOrigin: float, yOrigin: float, xExtent: float, yExtent: float, xOffset: float, yOffset: float, LineType1: int, LineType2: int, typeIndex: int, Direction: mwRouteViaDirectionType) -> CRouteObject:
		"""Adds a new route via to the RouteRecord object."""
		return CRouteObject(self.__IRouteRecord.AddViaType(xOrigin, yOrigin, xExtent, yExtent, xOffset, yOffset, LineType1, LineType2, typeIndex, Direction))


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IRouteRecord.RemoveAll()



	@property
	def Guides(self) -> CRouteGuides:
		"""Returns a reference to a MWOffice RouteGuides collection."""
		return CRouteGuides(self.__IRouteRecord.Guides)


	@property
	def Objects(self) -> CRouteObjects:
		"""Returns a reference to a MWOffice RouteObjects collection."""
		return CRouteObjects(self.__IRouteRecord.Objects)


	@property
	def Segments(self) -> CRouteSegments:
		"""Returns a reference to a MWOffice RouteSegments collection."""
		return CRouteSegments(self.__IRouteRecord.Segments)


	@property
	def Vias(self) -> CRouteVias:
		"""Returns a reference to a MWOffice RouteVias collection."""
		return CRouteVias(self.__IRouteRecord.Vias)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Route
class CRoute:
	"""An MWOffice Route object."""
	def __init__(self, route):
		self.__IRoute = route

	def _get_inner(self):
		return self.__IRoute


	def Delete(self) -> bool:
		"""Removes the object."""
		return self.__IRoute.Delete()


	def Disassociate(self) -> bool:
		"""Removes the association the Route and it's parent PhysicalNet"""
		return self.__IRoute.Disassociate()



	@property
	def Associated(self) -> bool:
		"""Returns a value that indicates if the route is associated with a physical net."""
		return self.__IRoute.Associated


	@property
	def BendStyle(self):
		"""Returns/Sets the bend style to be used for the route object."""
		return self.__IRoute.BendStyle


	@BendStyle.setter
	def BendStyle(self, value: mwRouteBendStyleType):
		"""Returns/Sets the bend style to be used for the route object."""
		self.__IRoute.BendStyle = value


	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__IRoute.Boundary)


	@property
	def Continuous(self) -> bool:
		"""Returns/Sets a value that indicates if this Route object is continuous, with all segments connected."""
		return self.__IRoute.Continuous


	@property
	def CustomSegmentEnds(self) -> bool:
		"""Returns/Sets if the ends styles for each segment should be retain a custom style value."""
		return self.__IRoute.CustomSegmentEnds


	@CustomSegmentEnds.setter
	def CustomSegmentEnds(self, value: bool):
		"""Returns/Sets if the ends styles for each segment should be retain a custom style value."""
		self.__IRoute.CustomSegmentEnds = value


	@property
	def FixedRadiusCurves(self) -> bool:
		"""Returns/Sets if curved bends should use a fixed or variable radius for calculating the curve."""
		return self.__IRoute.FixedRadiusCurves


	@FixedRadiusCurves.setter
	def FixedRadiusCurves(self, value: bool):
		"""Returns/Sets if curved bends should use a fixed or variable radius for calculating the curve."""
		self.__IRoute.FixedRadiusCurves = value


	@property
	def Global(self) -> bool:
		"""Returns/Sets a value that indicates if this Route object is global."""
		return self.__IRoute.Global


	@Global.setter
	def Global(self, value: bool):
		"""Returns/Sets a value that indicates if this Route object is global."""
		self.__IRoute.Global = value


	@property
	def Guides(self) -> CRouteGuides:
		"""Returns a reference to a MWOffice RouteGuides collection."""
		return CRouteGuides(self.__IRoute.Guides)


	@property
	def Length(self) -> float:
		"""Returns the sum of the centerline length of all the segments in the route."""
		return self.__IRoute.Length


	@property
	def MiterAmount(self) -> float:
		"""Returns/Sets the miter amount value to be used when the bend style is set to miter bend style."""
		return self.__IRoute.MiterAmount


	@MiterAmount.setter
	def MiterAmount(self, value: float):
		"""Returns/Sets the miter amount value to be used when the bend style is set to miter bend style."""
		self.__IRoute.MiterAmount = value


	@property
	def MiterAmountAbsolute(self) -> bool:
		"""Returns/Sets if the MiterAmount should be taken as an absolute length or a width multiplier, should be set before setting MiterAmount property."""
		return self.__IRoute.MiterAmountAbsolute


	@MiterAmountAbsolute.setter
	def MiterAmountAbsolute(self, value: bool):
		"""Returns/Sets if the MiterAmount should be taken as an absolute length or a width multiplier, should be set before setting MiterAmount property."""
		self.__IRoute.MiterAmountAbsolute = value


	@property
	def NetID(self) -> int:
		"""Returns/Sets a numerical identifier for the physical net associated with this Route object."""
		return self.__IRoute.NetID


	@NetID.setter
	def NetID(self, value: int):
		"""Returns/Sets a numerical identifier for the physical net associated with this Route object."""
		self.__IRoute.NetID = value


	@property
	def Objects(self) -> CRouteObjects:
		"""Returns a reference to a MWOffice RouteObjects collection."""
		return CRouteObjects(self.__IRoute.Objects)


	@property
	def Segments(self) -> CRouteSegments:
		"""Returns a reference to a MWOffice RouteSegments collection."""
		return CRouteSegments(self.__IRoute.Segments)


	@property
	def Selected(self) -> bool:
		"""Returns/Sets a value indicating if the route is selected."""
		return self.__IRoute.Selected


	@Selected.setter
	def Selected(self, value: bool):
		"""Returns/Sets a value indicating if the route is selected."""
		self.__IRoute.Selected = value


	@property
	def Standalone(self) -> bool:
		"""Returns/Sets a value that indicates if the route is a standalone route which doesn't require a physical net."""
		return self.__IRoute.Standalone


	@Standalone.setter
	def Standalone(self, value: bool):
		"""Returns/Sets a value that indicates if the route is a standalone route which doesn't require a physical net."""
		self.__IRoute.Standalone = value


	@property
	def Status(self):
		"""Returns/Sets a value for the route placement status."""
		return self.__IRoute.Status


	@Status.setter
	def Status(self, value: mwRouteStatusType):
		"""Returns/Sets a value for the route placement status."""
		self.__IRoute.Status = value


	@property
	def Topology(self):
		"""Returns/Sets a value for the route topology"""
		return self.__IRoute.Topology


	@Topology.setter
	def Topology(self, value: mwRouteTopologyType):
		"""Returns/Sets a value for the route topology"""
		self.__IRoute.Topology = value


	@property
	def ViaCellName(self) -> str:
		"""Returns the name of the programmatic cell used to draw vias on this Route object."""
		return self.__IRoute.ViaCellName


	@property
	def Vias(self) -> CRouteVias:
		"""Returns a reference to a MWOffice RouteVias collection."""
		return CRouteVias(self.__IRoute.Vias)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# Routes
class CRoutes:
	"""A collection of MWOffice Route objects."""
	def __init__(self, routes):
		self.__IRoutes = routes

	def _get_inner(self):
		return self.__IRoutes


	def CreateRouteRecord(self) -> CRouteRecord:
		"""Returns a reference to a MWOffice RouteRecord object."""
		return CRouteRecord(self.__IRoutes.CreateRouteRecord())


	def AddRoute(self, Record: CRouteRecord) -> CRoute:
		"""Adds the route described by the route record to the PhysicalNet object."""
		return CRoute(self.__IRoutes.AddRoute(Record._get_inner()))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IRoutes.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IRoutes.RemoveAll()


	def AddVias(self, Record: CRouteRecord) -> bool:
		"""Add the vias in the route record to the existing route objects. Allows adding vias after routes have been created."""
		return self.__IRoutes.AddVias(Record._get_inner())



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IRoutes.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IRoutes.Exists(Index)


	def Item(self, Index) -> CRoute:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CRoute(self.__IRoutes.Item(Index))


	def __get_Item(self, Index) -> CRoute:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CRoute(self.__IRoutes.Item(Index))


	def __call__(self, index) -> CRoute:
		return self.__get_Item(index)


	def __iter__(self) -> CRoute:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IRoutes.Count


	def __getitem__(self, index) -> Union[CRoute, List[CRoute]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# RouteObject
class CRouteObject:
	"""An MWOffice RouteObject object."""
	def __init__(self, routeobject):
		self.__IRouteObject = routeobject

	def _get_inner(self):
		return self.__IRouteObject



	@property
	def BeginNode(self) -> int:
		"""Returns/Sets a value for the beginning connectivity node number of this route object."""
		return self.__IRouteObject.BeginNode


	@BeginNode.setter
	def BeginNode(self, value: int):
		"""Returns/Sets a value for the beginning connectivity node number of this route object."""
		self.__IRouteObject.BeginNode = value


	@property
	def Boundary(self) -> CBoundary:
		"""Returns a reference to a Boundary object."""
		return CBoundary(self.__IRouteObject.Boundary)


	@property
	def EndNode(self) -> int:
		"""Returns/Sets a value for the ending connectivity node number of this route object."""
		return self.__IRouteObject.EndNode


	@EndNode.setter
	def EndNode(self, value: int):
		"""Returns/Sets a value for the ending connectivity node number of this route object."""
		self.__IRouteObject.EndNode = value


	@property
	def Selected(self) -> bool:
		"""Returns/Sets a value indicating if the route object is selected."""
		return self.__IRouteObject.Selected


	@Selected.setter
	def Selected(self, value: bool):
		"""Returns/Sets a value indicating if the route object is selected."""
		self.__IRouteObject.Selected = value


	@property
	def Shapes(self) -> CShapes:
		"""Returns a reference to a collection of Shape objects."""
		return CShapes(self.__IRouteObject.Shapes)


	@property
	def Type(self):
		"""Returns a value indicating the type of the underlying route object."""
		return self.__IRouteObject.Type


	@property
	def Vertices(self) -> CVertices:
		"""Returns a reference to a collection of Vertex objects."""
		return CVertices(self.__IRouteObject.Vertices)


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# RouteObjects
class CRouteObjects:
	"""A collection MWOffice RouteObject objects."""
	def __init__(self, routeobjects):
		self.__IRouteObjects = routeobjects

	def _get_inner(self):
		return self.__IRouteObjects



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IRouteObjects.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IRouteObjects.Exists(Index)


	def Item(self, Index) -> CRouteObject:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CRouteObject(self.__IRouteObjects.Item(Index))


	def __get_Item(self, Index) -> CRouteObject:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CRouteObject(self.__IRouteObjects.Item(Index))


	def __call__(self, index) -> CRouteObject:
		return self.__get_Item(index)


	def __iter__(self) -> CRouteObject:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IRouteObjects.Count


	def __getitem__(self, index) -> Union[CRouteObject, List[CRouteObject]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# RouteSegment
class CRouteSegment:
	"""An MWOffice RouteSegment object."""
	def __init__(self, routesegment):
		self.__IRouteSegment = routesegment

	def _get_inner(self):
		return self.__IRouteSegment



	@property
	def Begin(self) -> CVertex:
		"""Returns a reference to a Vertex object."""
		return CVertex(self.__IRouteSegment.Begin)


	@property
	def BeginExtent(self) -> float:
		"""Returns/Sets the extent length value for the beginning of this route segment."""
		return self.__IRouteSegment.BeginExtent


	@BeginExtent.setter
	def BeginExtent(self, value: float):
		"""Returns/Sets the extent length value for the beginning of this route segment."""
		self.__IRouteSegment.BeginExtent = value


	@property
	def BeginOffsetStyle(self):
		"""Returns/Sets the offset style value for the beginning of this route segment."""
		return self.__IRouteSegment.BeginOffsetStyle


	@BeginOffsetStyle.setter
	def BeginOffsetStyle(self, value: mwRouteSegmentEndOffsetType):
		"""Returns/Sets the offset style value for the beginning of this route segment."""
		self.__IRouteSegment.BeginOffsetStyle = value


	@property
	def BeginStyle(self):
		"""Returns/Sets the style value for the beginning of this route segment"""
		return self.__IRouteSegment.BeginStyle


	@BeginStyle.setter
	def BeginStyle(self, value: mwRouteSegmentEndStyleType):
		"""Returns/Sets the style value for the beginning of this route segment"""
		self.__IRouteSegment.BeginStyle = value


	@property
	def End(self) -> CVertex:
		"""Returns a reference to a Vertex object."""
		return CVertex(self.__IRouteSegment.End)


	@property
	def EndExtent(self) -> float:
		"""Returns/Sets the extent length value for the end of this route segment."""
		return self.__IRouteSegment.EndExtent


	@EndExtent.setter
	def EndExtent(self, value: float):
		"""Returns/Sets the extent length value for the end of this route segment."""
		self.__IRouteSegment.EndExtent = value


	@property
	def EndOffsetStyle(self):
		"""Returns/Sets the offset style value for the end of this route segment."""
		return self.__IRouteSegment.EndOffsetStyle


	@EndOffsetStyle.setter
	def EndOffsetStyle(self, value: mwRouteSegmentEndOffsetType):
		"""Returns/Sets the offset style value for the end of this route segment."""
		self.__IRouteSegment.EndOffsetStyle = value


	@property
	def EndStyle(self):
		"""Returns/Sets the style value for the end of this route segment."""
		return self.__IRouteSegment.EndStyle


	@EndStyle.setter
	def EndStyle(self, value: mwRouteSegmentEndStyleType):
		"""Returns/Sets the style value for the end of this route segment."""
		self.__IRouteSegment.EndStyle = value


	@property
	def LineType(self) -> int:
		"""Returns/Sets an index value for the technology line type of this route segment."""
		return self.__IRouteSegment.LineType


	@LineType.setter
	def LineType(self, value: int):
		"""Returns/Sets an index value for the technology line type of this route segment."""
		self.__IRouteSegment.LineType = value


	@property
	def Selected(self) -> bool:
		"""Returns/Sets a value indicating if the route segment is selected."""
		return self.__IRouteSegment.Selected


	@Selected.setter
	def Selected(self, value: bool):
		"""Returns/Sets a value indicating if the route segment is selected."""
		self.__IRouteSegment.Selected = value


	@property
	def Shapes(self) -> CShapes:
		"""Returns a reference to a collection of Shape objects."""
		return CShapes(self.__IRouteSegment.Shapes)


	@property
	def Width(self) -> float:
		"""Returns/Sets the width value for this route segment"""
		return self.__IRouteSegment.Width


	@Width.setter
	def Width(self, value: float):
		"""Returns/Sets the width value for this route segment"""
		self.__IRouteSegment.Width = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# RouteSegments
class CRouteSegments:
	"""A collection of MWOffice RouteSegment objects."""
	def __init__(self, routesegments):
		self.__IRouteSegments = routesegments

	def _get_inner(self):
		return self.__IRouteSegments



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IRouteSegments.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IRouteSegments.Exists(Index)


	def Item(self, Index) -> CRouteSegment:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CRouteSegment(self.__IRouteSegments.Item(Index))


	def __get_Item(self, Index) -> CRouteSegment:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CRouteSegment(self.__IRouteSegments.Item(Index))


	def __call__(self, index) -> CRouteSegment:
		return self.__get_Item(index)


	def __iter__(self) -> CRouteSegment:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IRouteSegments.Count


	def __getitem__(self, index) -> Union[CRouteSegment, List[CRouteSegment]]:
		if isinstance(index, int):
			if index < 0:
				index += self.Count
			if index < 0 or index >= self.Count:
				raise IndexError
			return self.__get_Item(index + 1)
		elif isinstance(index, slice):
			return [self[ii] for ii in range (*index.indices(self.Count))]
		else:
			raise TypeError


	def __str__(self):
		return '{}({})'.format(type(self).__name__, self.Count)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# RouteVia
class CRouteVia:
	"""An MWOffice RouteVia object."""
	def __init__(self, routevia):
		self.__IRouteVia = routevia

	def _get_inner(self):
		return self.__IRouteVia


	def Delete(self) -> bool:
		"""Deletes this RouteVia object from the Route object. Requires Physical net to be in manual via mode to be successful."""
		return self.__IRouteVia.Delete()



	@property
	def AutoSize(self) -> bool:
		"""Returns/sets a value indicating if the via should be autosized to the overlap area between segments and pins."""
		return self.__IRouteVia.AutoSize


	@AutoSize.setter
	def AutoSize(self, value: bool):
		"""Returns/sets a value indicating if the via should be autosized to the overlap area between segments and pins."""
		self.__IRouteVia.AutoSize = value


	@property
	def ConnectType1(self) -> int:
		"""Returns/sets a value indicating the type of connection for side one of the RouteVia object."""
		return self.__IRouteVia.ConnectType1


	@ConnectType1.setter
	def ConnectType1(self, value: int):
		"""Returns/sets a value indicating the type of connection for side one of the RouteVia object."""
		self.__IRouteVia.ConnectType1 = value


	@property
	def ConnectType2(self) -> int:
		"""Returns/sets a value indicating the type of connection for side two of the RouteVia object."""
		return self.__IRouteVia.ConnectType2


	@ConnectType2.setter
	def ConnectType2(self, value: int):
		"""Returns/sets a value indicating the type of connection for side two of the RouteVia object."""
		self.__IRouteVia.ConnectType2 = value


	@property
	def Direction(self):
		"""Returns/sets a value indicating the via direction for this via object."""
		return self.__IRouteVia.Direction


	@Direction.setter
	def Direction(self, value: mwRouteViaDirectionType):
		"""Returns/sets a value indicating the via direction for this via object."""
		self.__IRouteVia.Direction = value


	@property
	def Enabled(self) -> bool:
		"""Returns/sets a value indicating if the via is enabled and drawn within the design."""
		return self.__IRouteVia.Enabled


	@Enabled.setter
	def Enabled(self, value: bool):
		"""Returns/sets a value indicating if the via is enabled and drawn within the design."""
		self.__IRouteVia.Enabled = value


	@property
	def Extent(self) -> CExtent:
		"""Returns a reference to an Extent object."""
		return CExtent(self.__IRouteVia.Extent)


	@property
	def LineConnections(self) -> CRouteViaLineConnections:
		"""Returns a reference to a MWOffice RouteViaLineConnections collection."""
		return CRouteViaLineConnections(self.__IRouteVia.LineConnections)


	@property
	def LineType1(self) -> int:
		"""Returns/sets a value indicating the technology line type associated with the first side of this via object."""
		return self.__IRouteVia.LineType1


	@LineType1.setter
	def LineType1(self, value: int):
		"""Returns/sets a value indicating the technology line type associated with the first side of this via object."""
		self.__IRouteVia.LineType1 = value


	@property
	def LineType2(self) -> int:
		"""Returns/sets a value indicating the technology line type associated with the second side of this via object."""
		return self.__IRouteVia.LineType2


	@LineType2.setter
	def LineType2(self, value: int):
		"""Returns/sets a value indicating the technology line type associated with the second side of this via object."""
		self.__IRouteVia.LineType2 = value


	@property
	def Offset(self) -> COffset:
		"""Returns a reference to an Offset object."""
		return COffset(self.__IRouteVia.Offset)


	@property
	def Origin(self) -> CVertex:
		"""Returns a reference to a Vertex object."""
		return CVertex(self.__IRouteVia.Origin)


	@property
	def PinConnections(self) -> CRouteViaPinConnections:
		"""Returns a refereence to a MWOffice RouteViaPinConnections collection."""
		return CRouteViaPinConnections(self.__IRouteVia.PinConnections)


	@property
	def Selected(self) -> bool:
		"""Returns/Sets a value indicating if the route object is selected."""
		return self.__IRouteVia.Selected


	@Selected.setter
	def Selected(self, value: bool):
		"""Returns/Sets a value indicating if the route object is selected."""
		self.__IRouteVia.Selected = value


	@property
	def Shapes(self) -> CShapes:
		"""Returns a reference to a collection of Shape objects."""
		return CShapes(self.__IRouteVia.Shapes)


	@property
	def typeIndex(self) -> int:
		"""Returns/sets a value indicating the type of this via as defined in the LPF"""
		return self.__IRouteVia.typeIndex


	@typeIndex.setter
	def typeIndex(self, value: int):
		"""Returns/sets a value indicating the type of this via as defined in the LPF"""
		self.__IRouteVia.typeIndex = value


	def __str__(self):
		return '{}'.format(type(self).__name__)

	@property
	def __dict__(self) -> Dict[str: Any]:
		r = {}
		for a in dir(self.__class__):
			if a.startswith('_'):
				continue
			# splitting if allows us to skip value get sometimes
			try:
				value=getattr(self, a)
				if callable(value):
					continue
				elif isinstance(value, int) or isinstance(value, float):
					r[a] = value
				else:
					r[a] = str(value)
			except Exception as e:
				print(f'Could not get value for attribute "{a}"')
				raise(e)
		return r


# RouteVias
class CRouteVias:
	"""A collection MWOffice RouteVia objects."""
	def __init__(self, routevias):
		self.__IRouteVias = routevias

	def _get_inner(self):
		return self.__IRouteVias


	def Add(self, xOrigin: float, yOrigin: float, xExtent: float, yExtent: float, xOffset: float, yOffset: float, LineType1: int, LineType2: int, Direction: mwRouteViaDirectionType) -> CRouteVia:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CRouteVia(self.__IRouteVias.Add(xOrigin, yOrigin, xExtent, yExtent, xOffset, yOffset, LineType1, LineType2, Direction))


	def AddType(self, xOrigin: float, yOrigin: float, xExtent: float, yExtent: float, xOffset: float, yOffset: float, LineType1: int, LineType2: int, typeIndex: int, Direction: mwRouteViaDirectionType) -> CRouteVia:
		"""Adds an object to the collection and returns a reference to the created object."""
		return CRouteVia(self.__IRouteVias.AddType(xOrigin, yOrigin, xExtent, yExtent, xOffset, yOffset, LineType1, LineType2, typeIndex, Direction))


	def Remove(self, Index) -> bool:
		"""Removes a specific member from a collection."""
		return self.__IRouteVias.Remove(Index)


	def RemoveAll(self) -> bool:
		"""Removes all objects in a collection."""
		return self.__IRouteVias.RemoveAll()



	@property
	def Count(self) -> int:
		"""Returns the number of objects in the collection."""
		return self.__IRouteVias.Count


	def Exists(self, Index) -> bool:
		"""Returns whether an item matching the specified criteria exists in the collection."""
		return self.__IRouteVias.Exists(Index)


	def Item(self, Index) -> CRouteVia:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CRouteVia(self.__IRouteVias.Item(Index))


	def __get_Item(self, Index) -> CRouteVia:
		"""Returns a specific item of a Collection object either by position or by key."""
		return CRouteVia(self.__IRouteVias.Item(Index))


	def __call__(self, index) -> CRouteVia:
		return self.__get_Item(index)


	def __iter__(self) -> CRouteVia:
		for index in range(1, self.Count + 1):
			 yield self.__get_Item(index)


	def __len__(self) -> int:
		return self.__IRouteVias.Count


	def __getitem__(self, index) -> Union[CRouteVia, List[CRouteVia]]:
		if isinstance(index,