# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['magicwall']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'magicwall',
    'version': '0.0.1',
    'description': 'This is the magic wall (magicwall.io)',
    'long_description': '# magicwall.io\n\nView, share, compose, edit visual, textual and acustical content and apply\narbitraty effects on it.\n\nConsider magicwall a combination of file sharing, content presentation, blogging\nand programmable playground. Create your own wall by just navigating to it, add\ncontent by dropping or pasting files and arbitrary data from outside, arrange it\nspacially and write code which can be applied to any of that content.\n\nOther people you shared the link to your wall with can copy its content using\nthe drag&drop or copy&paste mechanism or by using Git to clone the whole wall\ncontent.\n\nUse it: [magicwall.io](https://magicwall.io)\n\nHave your own:\n```\ngit clone https://projects.om-office.de/frans/magicwall.io\n```\n\nHave Python3.7+ and `flask` installed and run\n```\nmagicwall.io/magicwall.py\n```\n\nOr use a Docker container:\n```\nmagicwall.io/run-server\n```\n\nVisit the [locally created site](http://localhost:8006)\n\n\n##  Milestone 1\n\nRequirements for basic usage as simple blogging system and for concept\ndemonstration.\n\n* [x] <magicwall.io> registered and used with https\n* [x] Previews of files get turned into HTML elements\n* [x] Visualization works (geometry)\n* [x] Create element from dropping a filter element, text or images\n* [x] Drag/drop of element inside wall area moves it\n* [x] Drag/drop of element outside wall area copies as file\n* [x] Drag/drop of element on remove field removes it\n* [x] Pictures get displayed\n* [x] Basic Markdown text formatting works\n* [x] Basic file info on mouse hover\n* [ ] Drag/drop works on mobile\n* [ ] Basic text editing\n* [ ] Basic "filter" work (e.g. b/w for images and running python)\n* [ ] Auto-update (-> collab mode)\n* [ ] Pasting of text, image data or image files works as dropping\n* [ ] Multiple elements can be dropped/pasted at once\n\n\n##  Milestone 2\n\n* [ ] User / access permission control\n* [ ] Arbitrary files can be added for sharing\n* [ ] CTRL+drag&drop copies\n* [ ] Resize elments\n* [ ] Caching mechanism\n* [ ] Square-select multiple items\n\n\n## Future\n\n* Fullscreen / slideshow mode\n* Undo-stack\n* Config-YAML\n* Filter-Hub\n* Search\n* Offline use\n* Git support\n* Editor\n* Links\n* Copy / Paste between sites\n* Video\n* Live-Update (Weather)\n* Support for folders -> Tree\n* Tree-Structure (allows entering)\n* Filter chaining/stacking\n\n\n## Use cases\n\n* Picture gallery\n* Blogging\n* Mind mapping\n* Algorithm demonstration / education (-> Jupyter)\n* File exchange\n* Note taking\n\n\n## Magic ideas\n\n* Simple auto optimize images (contrast, etc)\n* Simple BW images\n* Configurable Image with roation, cropping, color improvement, vignetting\n* Files to animation\n* SVG background\n* Auto align by date\n* fetch URL -> return generated HTML\n\n\n## License\n\nFor all code contained in this repository the rules of GPLv3 apply unless\notherwise noted. That means that you can do what you want with the source\ncode as long as you make the files with their original copyright notice\nand all modifications available.\n\nSee [GNU / GPLv3](https://www.gnu.org/licenses/gpl-3.0.en.html) for details.\n\n\n## Contributing\n\nBefore contributing consider installing a pre-commit which runs some static\nchecks, code cleaners and unit tests:\n\n```\nln -s ../../.git-pre-commit .git/hooks/pre-commit\n```\nThis `pre-commit` just runs `./qualitygate`, which you can also run manually.\n\n\n## Paradigms\n\n* each site can be seen as a filesystem folder managed and visualized by\n  magicwall.io. I.e. applying an arbitrary folder should give nice results\n  magically.\n\n\n## Random ideas\n\n* Visual Filter (looks like polaroid filter and can be moved over arbitrary elements)\n* Transformer filter\n\n\n## Technical challenges\n\nFeel free to help me with each of those questions\n\n* how to recursively stack drop areas\n* how to keep instances across browsers in sync, see\n    - https://developer.mozilla.org/en-US/docs/Web/API/Background_Synchronization_API\n    - https://stackoverflow.com/questions/55700655/store-data-offline-and-sync-once-online-using-react-native-and-redux-store\n\n\n## Read this\n\n* my [to-go scribble](https://notes.om-office.de/tGG_sJgTThut6-v8F72xYQ#)\n\n* https://stackoverflow.com/questions/57014217/putting-an-image-from-flask-to-an-html5-canvas\n* https://stackoverflow.com/questions/10929941/make-drag-and-drop-uploader-in-flask\n* https://codepen.io/anatomic/pen/DJgrvq\n* https://stackoverflow.com/questions/4288253/html5-canvas-100-width-height-of-viewport\n\n* [Dropzone](https://www.dropzone.dev/js/)\n\n* https://www.reddit.com/r/Python/comments/60gl8w/drag_and_drop_files_with_html5_and_flask/\n* http://hundredminutehack.blogspot.com/2017/03/drag-and-drop-files-with-html5-and-flask.html\n\n* https://www.javascripttutorial.net/web-apis/javascript-drag-and-drop/\n* https://stackoverflow.com/questions/10261989/html5-javascript-drag-and-drop-file-from-external-window-windows-explorer\n* https://stackoverflow.com/questions/21339924/drop-event-not-firing-in-chrome\n* https://stackoverflow.com/questions/2438320/html5-dragover-drop-how-get-current-x-y-coordinates\n* https://stackoverflow.com/questions/2075337/uncaught-referenceerror-is-not-defined\n* https://github.com/gokercebeci/droparea\n\n\n',
    'author': 'Frans Fürst',
    'author_email': 'frans.fuerst+gitlab@protonmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://projects.om-office.de/frans/magicwall.io',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.8,<3.11',
}


setup(**setup_kwargs)
