#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['scirpy',
 'scirpy._io',
 'scirpy._io.tracerlib',
 'scirpy._plotting',
 'scirpy._preprocessing',
 'scirpy._tools',
 'scirpy._util',
 'scirpy.datasets']

package_data = \
{'': ['*'], 'scirpy.datasets': ['_processing_scripts/*']}

install_requires = \
['get_version',
 'scanpy',
 'pandas<1',
 'numpy',
 'scipy',
 'parasail',
 'scikit-learn',
 'python-levenshtein',
 'python-igraph',
 'networkx']

extras_require = \
{'doc': ['sphinx>=2,<3',
         'sphinx_autodoc_typehints>=1.8.0',
         'sphinx_rtd_theme>=0.4',
         'scanpydoc',
         'leidenalg',
         'nbsphinx',
         'jupytext',
         'sphinxcontrib-bibtex',
         'pycairo',
         'jupyter_client',
         'ipykernel'],
 'optional': ['rectangle-packer', 'squarify'],
 'test': ['pytest', 'black']}

setup(name='scirpy',
      version='0.1.1',
      description='Python library for single-cell TCR analysis',
      author='Gregor Sturm',
      author_email='gregor.sturm@i-med.ac.at',
      url='https://github.com/grst/scirpy',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>= 3.6',
     )
