"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebsiteBucket = void 0;
const path = require("path");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const aws_s3_deployment_1 = require("@aws-cdk/aws-s3-deployment");
const core_1 = require("@aws-cdk/core");
class WebsiteBucket extends core_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        const { bucketName, removalPolicy = core_1.RemovalPolicy.RETAIN, disableUpload = false, source, websiteIndexDocument, websiteErrorDocument, } = props;
        const bucket = new aws_s3_1.Bucket(this, 'WebsiteBucket', {
            bucketName,
            removalPolicy,
            websiteIndexDocument: websiteIndexDocument || 'index.html',
            websiteErrorDocument: websiteErrorDocument || 'error.html',
        });
        const originAccessIdentity = new aws_cloudfront_1.OriginAccessIdentity(this, 'OriginAccessIdentity', {
            comment: `CloudFront OriginAccessIdentity for ${bucket.bucketName}`,
        });
        bucket.grantRead(originAccessIdentity.grantPrincipal);
        if (!disableUpload) {
            const placeHolderSource = path.join(__dirname, '..', 'website');
            new aws_s3_deployment_1.BucketDeployment(this, 'Deployment', {
                sources: [aws_s3_deployment_1.Source.asset(source || placeHolderSource)],
                destinationBucket: bucket,
                retainOnDelete: removalPolicy === core_1.RemovalPolicy.RETAIN,
            });
        }
        this.s3OriginConfig = {
            originAccessIdentity,
            s3BucketSource: bucket,
        };
    }
}
exports.WebsiteBucket = WebsiteBucket;
//# sourceMappingURL=data:application/json;base64,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