"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticWebsite = void 0;
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_route53_targets_1 = require("@aws-cdk/aws-route53-targets");
const core_1 = require("@aws-cdk/core");
const lambda_function_associations_1 = require("./lambda-function-associations");
const website_alias_record_1 = require("./website-alias-record");
const website_bucket_1 = require("./website-bucket");
class StaticWebsite extends core_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        const { aliasConfiguration, bucketConfiguration, webACLId, disableIPv6, } = props;
        const websiteBucket = new website_bucket_1.WebsiteBucket(this, 'Bucket', {
            ...bucketConfiguration,
        });
        const distibutionConfig = {
            webACLId,
            enableIpV6: !disableIPv6,
            originConfigs: [
                {
                    s3OriginSource: {
                        ...websiteBucket.s3OriginConfig,
                    },
                    behaviors: [{ isDefaultBehavior: true }],
                },
            ],
            aliasConfiguration,
        };
        this.distribution = new aws_cloudfront_1.CloudFrontWebDistribution(this, 'Distribution', distibutionConfig);
        if (aliasConfiguration) {
            new website_alias_record_1.WebsiteAliasRecord(this, 'AliasRecord', {
                domainName: aliasConfiguration.domainName,
                recordNames: aliasConfiguration.names,
                target: new aws_route53_targets_1.CloudFrontTarget(this.distribution),
                disableIPv6,
            });
        }
    }
    addLambdaFunctionAssociation(assosiation) {
        return this.addLambdaFunctionAssociations([assosiation]);
    }
    addLambdaFunctionAssociations(assosiations) {
        return new lambda_function_associations_1.LambdaFunctionAssociations(this, 'LambdaFunctionAssociation', {
            distribution: this.distribution,
            assosiations,
        });
    }
}
exports.StaticWebsite = StaticWebsite;
//# sourceMappingURL=data:application/json;base64,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