import { AliasConfiguration } from '@aws-cdk/aws-cloudfront';
import { Construct } from '@aws-cdk/core';
import { Association, LambdaFunctionAssociations } from './lambda-function-associations';
import { WebsiteBucketProps } from './website-bucket';
export interface AliasProps extends AliasConfiguration {
    /** The domain name for the site like 'example.com' */
    readonly domainName: string;
}
export interface StaticWebsiteProps extends WebsiteBucketProps {
    /**
     * BucketConfiguration is used to configured the S3 website bucket
     *
     * @default - The website bucket is provided with default values
     */
    readonly bucketConfiguration?: WebsiteBucketProps;
    /**
     * AliasConfiguration is used to configured CloudFront to respond to requests on custom domain names.
     *
     * @default - No custom domain names are set up
     */
    readonly aliasConfiguration?: AliasProps;
    /**
     * AWS WAF WebACL to associate with this CloudFront distribution
     *
     * @default - No AWS Web Application Firewall web access control list (web ACL)
     */
    readonly webACLId?: string;
    /**
     * An override flag that allows you to turn off support for IPv6 if required.
     *
     * @default - Cloudfront IPv6 support is enabled and if you've supplied an aliasConfiguration, an
     * AAAA record will be created for your service, set this to true to switch this off.
     */
    readonly disableIPv6?: boolean;
}
export declare class StaticWebsite extends Construct {
    private readonly distribution;
    constructor(scope: Construct, id: string, props?: StaticWebsiteProps);
    addLambdaFunctionAssociation(assosiation: Association): LambdaFunctionAssociations;
    addLambdaFunctionAssociations(assosiations: Association[]): LambdaFunctionAssociations;
}
