"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonAsyncRunner = void 0;
// eslint-disable-next-line
const PythonShell = require('python-shell').PythonShell;
/**
 * Runs the Python execution and returns a promise with the Python result.
 * This is used with SynchronousPromise to wait for the result from the Python execution synchronously.
 */
class PythonAsyncRunner {
    /**
       * Expect args to be a list with 3 values:
       * 1. The path of the python script.
       * 2. The function name to execute in the above script.
       * 3. The arguments to deliver to the above function.
       */
    runAsync(args) {
        return new Promise(function (resolve, _reject) {
            const pythonOut = new Promise(function (resolveIn, _rejectIn) {
                var options = {
                    mode: 'text',
                    pythonOptions: ['-u'],
                    scriptPath: __dirname + '/../../python/',
                    args: [args[0], args[1], JSON.stringify(args[2])],
                };
                // prevent __pycache__ folder from getting generated
                process.env.PYTHONDONTWRITEBYTECODE = '1';
                // See documentation in python_script_entry.py to see how this execution works.
                PythonShell.run('python_script_entry.py', options, function (err, results) {
                    if (err != undefined) {
                        console.log('Error calling python: ' + JSON.stringify(err));
                        resolveIn(err);
                    }
                    // Results is an array consisting of messages collected during execution
                    // Pop the last one (which is the function repsonse written out by python_script_entry.py)
                    const endResult = results.pop();
                    // The results are wrapped with Payload (as is done in SSM) as well as status (SUCCESS|FAILURE)
                    resolveIn(JSON.parse(endResult));
                });
            });
            pythonOut.then(function (data) {
                resolve(data);
            }).catch(function (err) {
                resolve({ status: 'FAILURE', Payload: err });
            });
        });
    }
}
exports.PythonAsyncRunner = PythonAsyncRunner;
//# sourceMappingURL=data:application/json;base64,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