"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsyncSleep = void 0;
/**
 * Performs an async sleep.
 * This is used with SynchronousPromise to wait for the sleep to complete Synchronously.
 */
class AsyncSleep {
    /**
       * Expects a list with a single value indicating the total time to sleep in millis.
       */
    runAsync(args) {
        return new Promise(function (resolve) {
            setTimeout(resolve, args[0]);
        });
    }
}
exports.AsyncSleep = AsyncSleep;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXN5bmMtc2xlZXAuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvc3luYy9hc3luYy1zbGVlcC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFFQTs7O0dBR0c7QUFDSCxNQUFhLFVBQVU7SUFFckI7O1NBRUs7SUFDTCxRQUFRLENBQUMsSUFBVztRQUNsQixPQUFPLElBQUksT0FBTyxDQUFDLFVBQVMsT0FBTztZQUNqQyxVQUFVLENBQUMsT0FBTyxFQUFFLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQy9CLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztDQUVGO0FBWEQsZ0NBV0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBc3luY1J1bm5lciB9IGZyb20gJy4vYXN5bmMtcnVubmVyJztcblxuLyoqXG4gKiBQZXJmb3JtcyBhbiBhc3luYyBzbGVlcC5cbiAqIFRoaXMgaXMgdXNlZCB3aXRoIFN5bmNocm9ub3VzUHJvbWlzZSB0byB3YWl0IGZvciB0aGUgc2xlZXAgdG8gY29tcGxldGUgU3luY2hyb25vdXNseS5cbiAqL1xuZXhwb3J0IGNsYXNzIEFzeW5jU2xlZXAgaW1wbGVtZW50cyBBc3luY1J1bm5lciB7XG5cbiAgLyoqXG4gICAgICogRXhwZWN0cyBhIGxpc3Qgd2l0aCBhIHNpbmdsZSB2YWx1ZSBpbmRpY2F0aW5nIHRoZSB0b3RhbCB0aW1lIHRvIHNsZWVwIGluIG1pbGxpcy5cbiAgICAgKi9cbiAgcnVuQXN5bmMoYXJnczogYW55W10pOiBQcm9taXNlPGFueT4ge1xuICAgIHJldHVybiBuZXcgUHJvbWlzZShmdW5jdGlvbihyZXNvbHZlKSB7XG4gICAgICBzZXRUaW1lb3V0KHJlc29sdmUsIGFyZ3NbMF0pO1xuICAgIH0pO1xuICB9XG5cbn1cbiJdfQ==