import { AutomationDocument } from '../../document/automation-document';
import { SimulationResult } from '../../domain/simulation-result';
import { SimulationProps } from '../simulation';
export declare class AutomationSimulation {
    private automationDocument;
    private props;
    constructor(automationDocument: AutomationDocument, props: SimulationProps);
    /**
     * Starts the execution of the steps by invoking the first step.
     * The subsequent steps will be invoked by the steps themselves.
     * @param inputs all of the inputs necessary for the document to execute.
     * @returns the outputs specified by all the steps.
     */
    start(inputs: {
        [name: string]: any;
    }): SimulationResult;
    /**
     * Chains the steps together in their default orientation (like a linked list).
     * The order of steps can change depending on the properties provided to the steps.
     * @returns the first step of the chain
     */
    private createChain;
}
