"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeLambdaFunctionSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const data_type_1 = require("../../domain/data-type");
const response_code_1 = require("../../domain/response-code");
const aws_api_step_1 = require("../../parent-steps/automation/aws-api-step");
const data_utils_1 = require("../../utils/data-utils");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_simulation_1 = require("../automation-step-simulation");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implemenation for aws:invokeLambdaFunction
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-lamb.html
 */
class InvokeLambdaFunctionSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:invokeLambdaFunction';
        this.invokeLambdaFunctionStep = step;
        this.props = props;
    }
    executeStep(inputs) {
        const inputMap = this.invokeLambdaFunctionStep.formatInputMap();
        const stepInputs = prune_and_transform_record_1.pruneAndTransformRecord(inputMap, x => x.resolve(inputs));
        stepInputs.InvocationType = stepInputs.InvocationType ?? 'RequestResponse';
        stepInputs.LogType = stepInputs.LogType ?? 'Tail';
        if (stepInputs.Payload) {
            stepInputs.Payload = JSON.stringify(stepInputs.Payload);
        }
        const result = new automation_step_simulation_1.AutomationStepSimulation(new aws_api_step_1.AwsApiStep(new aws_cdk_lib_1.Stack(), 'invokeLambda', {
            service: 'Lambda',
            pascalCaseApi: 'Invoke',
            apiParams: stepInputs,
            outputs: [{
                    outputType: data_type_1.DataTypeEnum.STRING_MAP,
                    name: 'result',
                    selector: '$',
                }],
        }), this.props).invoke({});
        if (result.responseCode !== response_code_1.ResponseCode.SUCCESS) {
            throw new Error(`Invoke lambda failed for ${inputMap.FunctionName}: ${result.stackTrace}`);
        }
        return {
            StatusCode: result.outputs?.['invokeLambda.result'].StatusCode,
            FunctionError: result.outputs?.['invokeLambda.result'].FunctionError ?? null,
            LogResult: data_utils_1.decodeBase64String(result.outputs?.['invokeLambda.result'].LogResult),
            Payload: data_utils_1.stripBeginAndEndQuotes(result.outputs?.['invokeLambda.result'].Payload),
        };
    }
}
exports.InvokeLambdaFunctionSimulation = InvokeLambdaFunctionSimulation;
_a = JSII_RTTI_SYMBOL_1;
InvokeLambdaFunctionSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.InvokeLambdaFunctionSimulation", version: "0.0.14" };
//# sourceMappingURL=data:application/json;base64,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