"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExecuteStateMachineSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const data_type_1 = require("../../domain/data-type");
const response_code_1 = require("../../domain/response-code");
const aws_api_step_1 = require("../../parent-steps/automation/aws-api-step");
const wait_for_and_assert_1 = require("../../parent-steps/automation/sub-steps/wait-for-and-assert");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_simulation_1 = require("../automation-step-simulation");
const automation_simulation_base_1 = require("./automation-simulation-base");
var ExecuteStateMachineStatus;
(function (ExecuteStateMachineStatus) {
    ExecuteStateMachineStatus[ExecuteStateMachineStatus["RUNNING"] = 0] = "RUNNING";
    ExecuteStateMachineStatus[ExecuteStateMachineStatus["SUCCEEDED"] = 1] = "SUCCEEDED";
    ExecuteStateMachineStatus[ExecuteStateMachineStatus["FAILED"] = 2] = "FAILED";
    ExecuteStateMachineStatus[ExecuteStateMachineStatus["TIMED_OUT"] = 3] = "TIMED_OUT";
    ExecuteStateMachineStatus[ExecuteStateMachineStatus["ABORTED"] = 4] = "ABORTED";
})(ExecuteStateMachineStatus || (ExecuteStateMachineStatus = {}));
/**
 * AutomationStep implementation of [aws:executeStateMachine](https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-executeStateMachine.html)
 */
class ExecuteStateMachineSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:executeStateMachine';
        this.executeStateMachineStep = step;
        this.props = props;
    }
    executeStep(inputs) {
        const stateMachineArn = this.executeStateMachineStep.stateMachineArn.resolveToString(inputs);
        console.log(`ExecuteStateMachine: Invoke start execution of ${stateMachineArn}`);
        const executionId = this.startExecution(inputs);
        console.log(`ExecuteStateMachine: Started execution ${executionId}`);
        this.waitForExecution(executionId);
        console.log(`ExecuteStateMachine: Execution ${executionId} is complete`);
        return {};
    }
    startExecution(inputs) {
        const apiParams = prune_and_transform_record_1.pruneAndTransformRecord({
            stateMachineArn: this.executeStateMachineStep.stateMachineArn,
            name: this.executeStateMachineStep.executionName,
            input: this.executeStateMachineStep.input,
        }, x => x.resolve(inputs));
        const result = new automation_step_simulation_1.AutomationStepSimulation(new aws_api_step_1.AwsApiStep(new aws_cdk_lib_1.Stack(), 'startExecution', {
            service: 'StepFunctions',
            pascalCaseApi: 'StartExecution',
            apiParams: apiParams,
            outputs: [{
                    outputType: data_type_1.DataTypeEnum.STRING,
                    selector: '$.executionArn',
                    name: 'ExecutionId',
                }],
        }), this.props).invoke({});
        if (result.responseCode !== response_code_1.ResponseCode.SUCCESS) {
            throw new Error(`Failed to start execution ${apiParams.stateMachineArn}: ${result.stackTrace}`);
        }
        return result.outputs?.['startExecution.ExecutionId'];
    }
    waitForExecution(executionId) {
        wait_for_and_assert_1.waitForAndAssertResource({
            service: 'StepFunctions',
            pascalCaseApi: 'DescribeExecution',
            apiParams: {
                executionArn: executionId,
            },
            selector: '$.status',
            waitForValues: [
                ExecuteStateMachineStatus.ABORTED,
                ExecuteStateMachineStatus.FAILED,
                ExecuteStateMachineStatus.TIMED_OUT,
                ExecuteStateMachineStatus.SUCCEEDED,
            ].map(x => ExecuteStateMachineStatus[x]),
            desiredValues: [ExecuteStateMachineStatus[ExecuteStateMachineStatus.SUCCEEDED]],
        }, this.props);
    }
}
exports.ExecuteStateMachineSimulation = ExecuteStateMachineSimulation;
_a = JSII_RTTI_SYMBOL_1;
ExecuteStateMachineSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.ExecuteStateMachineSimulation", version: "0.0.14" };
//# sourceMappingURL=data:application/json;base64,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