import { Construct } from 'constructs';
import { Platform } from '../../domain/platform';
import { IStringListVariable } from '../../interface/variables/string-list-variable';
import { IStringVariable } from '../../interface/variables/string-variable';
import { CommandStep, CommandStepProps } from '../command-step';
export interface RunDockerActionStepProps extends CommandStepProps {
    readonly action: IStringVariable;
    readonly container?: IStringVariable;
    readonly image?: IStringVariable;
    readonly cmd?: IStringVariable;
    readonly memory?: IStringVariable;
    readonly cpuShares?: IStringVariable;
    readonly volume?: IStringListVariable;
    readonly env?: IStringVariable;
    readonly user?: IStringVariable;
    readonly publish?: IStringVariable;
}
/**
 * CommandStep implementation for aws:runDockerAction
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-rundockeraction
 */
export declare class RunDockerActionStep extends CommandStep {
    readonly dockerAction: IStringVariable;
    readonly container?: IStringVariable;
    readonly image?: IStringVariable;
    readonly cmd?: IStringVariable;
    readonly memory?: IStringVariable;
    readonly cpuShares?: IStringVariable;
    readonly volume?: IStringListVariable;
    readonly env?: IStringVariable;
    readonly user?: IStringVariable;
    readonly publish?: IStringVariable;
    readonly platforms: Platform[];
    readonly action = "aws:runDockerAction";
    constructor(scope: Construct, id: string, props: RunDockerActionStepProps);
    listInputs(): string[];
    toSsmEntry(): {
        [name: string]: any;
    };
}
