"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigurePackageStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * CommandStep implemenation for aws:configurePackage
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-configurepackage
 */
class ConfigurePackageStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX];
        this.action = 'aws:configurePackage';
        this.packageName = props.packageName;
        this.packageAction = props.packageAction;
        this.installationType = props.installationType;
        this.additionalArguments = props.additionalArguments;
        this.version = props.version;
    }
    /**
     * Inputs required for this command include ...
     */
    listInputs() {
        const inputs = [
            this.packageName,
            this.packageAction,
            this.installationType,
            this.additionalArguments,
            this.version,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        const inputs = { name: this.packageName };
        inputs.action = this.packageAction;
        if (this.installationType != undefined) {
            inputs.installationType = this.installationType;
        }
        if (this.additionalArguments != undefined) {
            inputs.additionalArguments = this.additionalArguments;
        }
        if (this.version != undefined) {
            inputs.version = this.version;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.ConfigurePackageStep = ConfigurePackageStep;
_a = JSII_RTTI_SYMBOL_1;
ConfigurePackageStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.ConfigurePackageStep", version: "0.0.14" };
//# sourceMappingURL=data:application/json;base64,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