import { Construct } from 'constructs';
import { ICommandComponent } from '../construct/document-component';
import { CommandDocumentBuilder } from '../document/document-builder';
import { Output } from '../domain/output';
import { Platform } from '../domain/platform';
import { Precondition } from '../domain/precondition';
import { Step, StepProps } from './step';
export interface CommandStepProps extends StepProps {
    /**
     * (Optional) Whether to exit the document execution after failed execution of this step.
     * Finally step will be run.
     * @default false
     */
    readonly exitOnFailure?: boolean;
    /**
     * (Optional) Whether to exit the document execution after successful execution of this step.
     * Finally step will be run.
     * @default false
     */
    readonly exitOnSuccess?: boolean;
    readonly markSuccessAndExitOnFailure?: boolean;
    /**
     * (Optional) Step to jump to in the event that this step is cancelled.
     * @default undefined
     */
    readonly onCancel?: Step;
    readonly finallyStep?: boolean;
    /**
     * (Optional) A precondition to test before execution occurrs.
     * When the precondition isn't met, the command step isn't executed.
     * @default undefined
     */
    readonly precondition?: Precondition;
}
export declare abstract class CommandStep extends Step implements ICommandComponent {
    nextStep: CommandStep | undefined;
    allStepsInExecution: CommandStep[] | undefined;
    readonly exitOnFailure: boolean;
    readonly exitOnSuccess: boolean;
    readonly markSuccessAndExitOnFailure: boolean;
    readonly finallyStep: boolean;
    readonly precondition: Precondition | undefined;
    abstract readonly platforms: Platform[];
    protected constructor(scope: Construct, id: string, props: CommandStepProps);
    addToDocument(doc: CommandDocumentBuilder): void;
    protected prepareSsmEntry(inputs: {
        [name: string]: any;
    }): {
        [name: string]: any;
    };
    /**
     * RunCommand Steps do not have outputs.
     * @returns []
     */
    listOutputs(): Output[];
    variables(): {
        [name: string]: any;
    };
}
