"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeLambdaFunctionStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const data_type_1 = require("../../domain/data-type");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implemenation for aws:invokeLambdaFunction
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-lamb.html
 */
class InvokeLambdaFunctionStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:invokeLambdaFunction';
        this.functionName = props.functionName;
        this.qualifier = props.qualifier;
        this.invocationType = props.invocationType;
        this.logType = props.logType;
        this.clientContext = props.clientContext;
        this.payload = props.payload;
    }
    listOutputs() {
        return [{
                outputType: data_type_1.DataTypeEnum.INTEGER,
                name: 'StatusCode',
                selector: '$.StatusCode',
            }, {
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'FunctionError',
                selector: '$.FunctionError',
            }, {
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'LogResult',
                selector: '$.LogResult',
            }, {
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'Payload',
                selector: '$.Payload',
            }];
    }
    listInputs() {
        const inputs = [
            this.functionName,
            this.qualifier,
            this.invocationType,
            this.logType,
            this.clientContext,
            this.payload,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        const entryMap = this.formatInputMap();
        const entries = prune_and_transform_record_1.pruneAndTransformRecord(entryMap, x => x.print());
        return super.prepareSsmEntry(entries);
    }
    formatInputMap() {
        return {
            FunctionName: this.functionName,
            Qualifier: this.qualifier,
            InvocationType: this.invocationType,
            LogType: this.logType,
            ClientContext: this.clientContext,
            Payload: this.payload,
        };
    }
}
exports.InvokeLambdaFunctionStep = InvokeLambdaFunctionStep;
_a = JSII_RTTI_SYMBOL_1;
InvokeLambdaFunctionStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.InvokeLambdaFunctionStep", version: "0.0.14" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW52b2tlLWxhbWJkYS1mdW5jdGlvbi1zdGVwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3BhcmVudC1zdGVwcy9hdXRvbWF0aW9uL2ludm9rZS1sYW1iZGEtZnVuY3Rpb24tc3RlcC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLHNEQUFzRDtBQUt0RCx1RkFBaUY7QUFDakYsd0RBQXlFO0FBc0N6RTs7O0dBR0c7QUFDSCxNQUFhLHdCQUF5QixTQUFRLGdDQUFjO0lBVTFELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBb0M7UUFDNUUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFWakIsV0FBTSxHQUFXLDBCQUEwQixDQUFDO1FBV25ELElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztRQUN2QyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFDakMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1FBQzNDLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUM7UUFDekMsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO0lBQy9CLENBQUM7SUFFTSxXQUFXO1FBQ2hCLE9BQU8sQ0FBQztnQkFDTixVQUFVLEVBQUUsd0JBQVksQ0FBQyxPQUFPO2dCQUNoQyxJQUFJLEVBQUUsWUFBWTtnQkFDbEIsUUFBUSxFQUFFLGNBQWM7YUFDekIsRUFBRTtnQkFDRCxVQUFVLEVBQUUsd0JBQVksQ0FBQyxNQUFNO2dCQUMvQixJQUFJLEVBQUUsZUFBZTtnQkFDckIsUUFBUSxFQUFFLGlCQUFpQjthQUM1QixFQUFFO2dCQUNELFVBQVUsRUFBRSx3QkFBWSxDQUFDLE1BQU07Z0JBQy9CLElBQUksRUFBRSxXQUFXO2dCQUNqQixRQUFRLEVBQUUsYUFBYTthQUN4QixFQUFFO2dCQUNELFVBQVUsRUFBRSx3QkFBWSxDQUFDLE1BQU07Z0JBQy9CLElBQUksRUFBRSxTQUFTO2dCQUNmLFFBQVEsRUFBRSxXQUFXO2FBQ3RCLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFTSxVQUFVO1FBQ2YsTUFBTSxNQUFNLEdBQUc7WUFDYixJQUFJLENBQUMsWUFBWTtZQUNqQixJQUFJLENBQUMsU0FBUztZQUNkLElBQUksQ0FBQyxjQUFjO1lBQ25CLElBQUksQ0FBQyxPQUFPO1lBQ1osSUFBSSxDQUFDLGFBQWE7WUFDbEIsSUFBSSxDQUFDLE9BQU87U0FDYixDQUFDO1FBRUYsT0FBTyxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLGNBQWMsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0lBQ3hELENBQUM7SUFFTSxVQUFVO1FBQ2YsTUFBTSxRQUFRLEdBQUcsSUFBSSxDQUFDLGNBQWMsRUFBRSxDQUFDO1FBQ3ZDLE1BQU0sT0FBTyxHQUFHLG9EQUF1QixDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDO1FBQ2xFLE9BQU8sS0FBSyxDQUFDLGVBQWUsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRU0sY0FBYztRQUNuQixPQUFPO1lBQ0wsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQy9CLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN6QixjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO1lBQ3JCLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYTtZQUNqQyxPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87U0FDdEIsQ0FBQztJQUNKLENBQUM7O0FBcEVILDREQXFFQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgRGF0YVR5cGVFbnVtIH0gZnJvbSAnLi4vLi4vZG9tYWluL2RhdGEtdHlwZSc7XG5pbXBvcnQgeyBPdXRwdXQgfSBmcm9tICcuLi8uLi9kb21haW4vb3V0cHV0JztcbmltcG9ydCB7IElBd3NJbnZva2VyIH0gZnJvbSAnLi4vLi4vaW50ZXJmYWNlL2F3cy1pbnZva2VyJztcbmltcG9ydCB7IElTdHJpbmdNYXBWYXJpYWJsZSB9IGZyb20gJy4uLy4uL2ludGVyZmFjZS92YXJpYWJsZXMvc3RyaW5nLW1hcC12YXJpYWJsZSc7XG5pbXBvcnQgeyBJU3RyaW5nVmFyaWFibGUgfSBmcm9tICcuLi8uLi9pbnRlcmZhY2UvdmFyaWFibGVzL3N0cmluZy12YXJpYWJsZSc7XG5pbXBvcnQgeyBwcnVuZUFuZFRyYW5zZm9ybVJlY29yZCB9IGZyb20gJy4uLy4uL3V0aWxzL3BydW5lLWFuZC10cmFuc2Zvcm0tcmVjb3JkJztcbmltcG9ydCB7IEF1dG9tYXRpb25TdGVwLCBBdXRvbWF0aW9uU3RlcFByb3BzIH0gZnJvbSAnLi4vYXV0b21hdGlvbi1zdGVwJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBJbnZva2VMYW1iZGFGdW5jdGlvblN0ZXBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJbnZva2VMYW1iZGFGdW5jdGlvblN0ZXBQcm9wcyBleHRlbmRzIEF1dG9tYXRpb25TdGVwUHJvcHMge1xuXG4gIC8qKlxuICAgICAqIFRoZSBuYW1lIG9mIHRoZSBMYW1iZGEgZnVuY3Rpb24uIFRoaXMgZnVuY3Rpb24gbXVzdCBleGlzdC5cbiAgICAgKi9cbiAgcmVhZG9ubHkgZnVuY3Rpb25OYW1lOiBJU3RyaW5nVmFyaWFibGU7XG5cbiAgLyoqXG4gICAgICogKE9wdGlvbmFsKSBUaGUgZnVuY3Rpb24gdmVyc2lvbiBvciBhbGlhcyBuYW1lLlxuICAgICAqL1xuICByZWFkb25seSBxdWFsaWZpZXI/OiBJU3RyaW5nVmFyaWFibGU7XG5cbiAgLyoqXG4gICAgICogKE9wdGlvbmFsKSBUaGUgaW52b2NhdGlvbiB0eXBlLiBUaGUgZGVmYXVsdCB2YWx1ZSBpcyBSZXF1ZXN0UmVzcG9uc2UuXG4gICAgICovXG4gIHJlYWRvbmx5IGludm9jYXRpb25UeXBlPzogSVN0cmluZ1ZhcmlhYmxlO1xuXG4gIC8qKlxuICAgICAqIChPcHRpb25hbCkgSWYgdGhlIGRlZmF1bHQgdmFsdWUgaXMgVGFpbCwgdGhlIGludm9jYXRpb24gdHlwZSBtdXN0IGJlIFJlcXVlc3RSZXNwb25zZS4gTGFtYmRhIHJldHVybnMgdGhlIGxhc3QgNCBLQiBvZiBsb2cgZGF0YSBwcm9kdWNlZCBieSB5b3VyIExhbWJkYSBmdW5jdGlvbiwgYmFzZTY0LWVuY29kZWQuXG4gICAgICovXG4gIHJlYWRvbmx5IGxvZ1R5cGU/OiBJU3RyaW5nVmFyaWFibGU7XG5cbiAgLyoqXG4gICAgICogKE9wdGlvbmFsKSBUaGUgY2xpZW50LXNwZWNpZmljIGluZm9ybWF0aW9uLlxuICAgICAqL1xuICByZWFkb25seSBjbGllbnRDb250ZXh0PzogSVN0cmluZ1ZhcmlhYmxlO1xuXG4gIC8qKlxuICAgICAqIChPcHRpb25hbCkgVGhlIEpTT04gaW5wdXQgZm9yIHlvdXIgTGFtYmRhIGZ1bmN0aW9uLlxuICAgICAqL1xuICByZWFkb25seSBwYXlsb2FkPzogSVN0cmluZ01hcFZhcmlhYmxlO1xufVxuXG4vKipcbiAqIEF1dG9tYXRpb25TdGVwIGltcGxlbWVuYXRpb24gZm9yIGF3czppbnZva2VMYW1iZGFGdW5jdGlvblxuICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3N5c3RlbXMtbWFuYWdlci9sYXRlc3QvdXNlcmd1aWRlL2F1dG9tYXRpb24tYWN0aW9uLWxhbWIuaHRtbFxuICovXG5leHBvcnQgY2xhc3MgSW52b2tlTGFtYmRhRnVuY3Rpb25TdGVwIGV4dGVuZHMgQXV0b21hdGlvblN0ZXAge1xuICByZWFkb25seSBhY3Rpb246IHN0cmluZyA9ICdhd3M6aW52b2tlTGFtYmRhRnVuY3Rpb24nO1xuICByZWFkb25seSBhd3NJbnZva2VyPzogSUF3c0ludm9rZXI7XG4gIHJlYWRvbmx5IGZ1bmN0aW9uTmFtZTogSVN0cmluZ1ZhcmlhYmxlO1xuICByZWFkb25seSBxdWFsaWZpZXI/OiBJU3RyaW5nVmFyaWFibGU7XG4gIHJlYWRvbmx5IGludm9jYXRpb25UeXBlPzogSVN0cmluZ1ZhcmlhYmxlO1xuICByZWFkb25seSBsb2dUeXBlPzogSVN0cmluZ1ZhcmlhYmxlO1xuICByZWFkb25seSBjbGllbnRDb250ZXh0PzogSVN0cmluZ1ZhcmlhYmxlO1xuICByZWFkb25seSBwYXlsb2FkPzogSVN0cmluZ01hcFZhcmlhYmxlO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBJbnZva2VMYW1iZGFGdW5jdGlvblN0ZXBQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuICAgIHRoaXMuZnVuY3Rpb25OYW1lID0gcHJvcHMuZnVuY3Rpb25OYW1lO1xuICAgIHRoaXMucXVhbGlmaWVyID0gcHJvcHMucXVhbGlmaWVyO1xuICAgIHRoaXMuaW52b2NhdGlvblR5cGUgPSBwcm9wcy5pbnZvY2F0aW9uVHlwZTtcbiAgICB0aGlzLmxvZ1R5cGUgPSBwcm9wcy5sb2dUeXBlO1xuICAgIHRoaXMuY2xpZW50Q29udGV4dCA9IHByb3BzLmNsaWVudENvbnRleHQ7XG4gICAgdGhpcy5wYXlsb2FkID0gcHJvcHMucGF5bG9hZDtcbiAgfVxuXG4gIHB1YmxpYyBsaXN0T3V0cHV0cygpOiBPdXRwdXRbXSB7XG4gICAgcmV0dXJuIFt7XG4gICAgICBvdXRwdXRUeXBlOiBEYXRhVHlwZUVudW0uSU5URUdFUixcbiAgICAgIG5hbWU6ICdTdGF0dXNDb2RlJyxcbiAgICAgIHNlbGVjdG9yOiAnJC5TdGF0dXNDb2RlJyxcbiAgICB9LCB7XG4gICAgICBvdXRwdXRUeXBlOiBEYXRhVHlwZUVudW0uU1RSSU5HLFxuICAgICAgbmFtZTogJ0Z1bmN0aW9uRXJyb3InLFxuICAgICAgc2VsZWN0b3I6ICckLkZ1bmN0aW9uRXJyb3InLFxuICAgIH0sIHtcbiAgICAgIG91dHB1dFR5cGU6IERhdGFUeXBlRW51bS5TVFJJTkcsXG4gICAgICBuYW1lOiAnTG9nUmVzdWx0JyxcbiAgICAgIHNlbGVjdG9yOiAnJC5Mb2dSZXN1bHQnLFxuICAgIH0sIHtcbiAgICAgIG91dHB1dFR5cGU6IERhdGFUeXBlRW51bS5TVFJJTkcsXG4gICAgICBuYW1lOiAnUGF5bG9hZCcsXG4gICAgICBzZWxlY3RvcjogJyQuUGF5bG9hZCcsXG4gICAgfV07XG4gIH1cblxuICBwdWJsaWMgbGlzdElucHV0cygpOiBzdHJpbmdbXSB7XG4gICAgY29uc3QgaW5wdXRzID0gW1xuICAgICAgdGhpcy5mdW5jdGlvbk5hbWUsXG4gICAgICB0aGlzLnF1YWxpZmllcixcbiAgICAgIHRoaXMuaW52b2NhdGlvblR5cGUsXG4gICAgICB0aGlzLmxvZ1R5cGUsXG4gICAgICB0aGlzLmNsaWVudENvbnRleHQsXG4gICAgICB0aGlzLnBheWxvYWQsXG4gICAgXTtcblxuICAgIHJldHVybiBpbnB1dHMuZmxhdE1hcChpID0+IGk/LnJlcXVpcmVkSW5wdXRzKCkgPz8gW10pO1xuICB9XG5cbiAgcHVibGljIHRvU3NtRW50cnkoKTogUmVjb3JkPHN0cmluZywgYW55PiB7XG4gICAgY29uc3QgZW50cnlNYXAgPSB0aGlzLmZvcm1hdElucHV0TWFwKCk7XG4gICAgY29uc3QgZW50cmllcyA9IHBydW5lQW5kVHJhbnNmb3JtUmVjb3JkKGVudHJ5TWFwLCB4ID0+IHgucHJpbnQoKSk7XG4gICAgcmV0dXJuIHN1cGVyLnByZXBhcmVTc21FbnRyeShlbnRyaWVzKTtcbiAgfVxuXG4gIHB1YmxpYyBmb3JtYXRJbnB1dE1hcCgpOiBSZWNvcmQ8c3RyaW5nLCBhbnk+IHtcbiAgICByZXR1cm4ge1xuICAgICAgRnVuY3Rpb25OYW1lOiB0aGlzLmZ1bmN0aW9uTmFtZSxcbiAgICAgIFF1YWxpZmllcjogdGhpcy5xdWFsaWZpZXIsXG4gICAgICBJbnZvY2F0aW9uVHlwZTogdGhpcy5pbnZvY2F0aW9uVHlwZSxcbiAgICAgIExvZ1R5cGU6IHRoaXMubG9nVHlwZSxcbiAgICAgIENsaWVudENvbnRleHQ6IHRoaXMuY2xpZW50Q29udGV4dCxcbiAgICAgIFBheWxvYWQ6IHRoaXMucGF5bG9hZCxcbiAgICB9O1xuICB9XG59Il19