"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.isStringMap = exports.assertStringMap = exports.StringMapVariable = exports.HardCodedStringMap = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const variable_1 = require("./variable");
/**
 * A hard-coded string map variable.
 * Used when not dependent on step inputs.
 */
class HardCodedStringMap extends variable_1.HardCodedValueBase {
    static of(val) {
        return new HardCodedStringMap(val);
    }
    resolveToStringMap(inputs) {
        return this.resolve(inputs);
    }
    assertType(value) {
        assertStringMap(value);
    }
}
exports.HardCodedStringMap = HardCodedStringMap;
_a = JSII_RTTI_SYMBOL_1;
HardCodedStringMap[_a] = { fqn: "@cdklabs/cdk-ssm-documents.HardCodedStringMap", version: "0.0.14" };
/**
 * A string map variable reference.
 * Used to resolve the value from step inputs.
 */
class StringMapVariable extends variable_1.GenericVariable {
    static of(reference) {
        return new StringMapVariable(reference);
    }
    resolveToStringMap(inputs) {
        return this.resolve(inputs);
    }
    assertType(value) {
        assertStringMap(value);
    }
}
exports.StringMapVariable = StringMapVariable;
_b = JSII_RTTI_SYMBOL_1;
StringMapVariable[_b] = { fqn: "@cdklabs/cdk-ssm-documents.StringMapVariable", version: "0.0.14" };
/**
 * Assert that the given value is a NullableStringMap.
 * @param value value to assert
 */
function assertStringMap(value) {
    if (!isStringMap(value)) {
        throw new Error(`${value} is not a string map`);
    }
}
exports.assertStringMap = assertStringMap;
/**
 * Whether the given value is a NullableStringMap.
 * @param value value to check
 * @returns true if the value is a NullableStringMap, otherwise false
 */
function isStringMap(value) {
    if (value === null) {
        return true;
    }
    return typeof value === 'object' && !Array.isArray(value);
}
exports.isStringMap = isStringMap;
//# sourceMappingURL=data:application/json;base64,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