/**
 * Outputs for aws:executeAutomation
 */
export interface ExecuteAutomationOutputs {
    /**
     * The ID of the secondary automation.
     */
    readonly executionId: string;
    /**
     * The status of the secondary automation.
     */
    readonly status: string;
    /**
     * The output generated by the secondary automation.
     */
    readonly output?: string[];
}
/**
 * Inputs for aws:executeAutomation
 */
export interface ExecuteAutomationProps {
    readonly documentName: string;
    readonly documentVersion?: string;
    readonly maxConcurrency?: string;
    readonly maxErrors?: string;
    readonly runtimeParameters?: Record<string, any>;
    readonly tags?: Record<string, any>[];
    readonly targetLocations?: Record<string, any>[];
    readonly targetMaps?: Record<string, any>[];
    readonly targetParameterName?: string;
    readonly targets?: Record<string, any>[];
}
/**
 * Interface for simulating aws:executeAutomation
 */
export interface IExecuteAutomationHook {
    /**
     * Simulate the aws:executeAutomation
     */
    execute(props: ExecuteAutomationProps): ExecuteAutomationOutputs;
}
export * from './execute-automation-hook/api-execute-automation-hook';
