"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutomationDocument = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const document_builder_1 = require("./document-builder");
const ssm_document_1 = require("./ssm-document");
/**
 * The AutomationDocuemnt used to both build the SSM Automation yaml/json and to use in simulation.
 * The AutomationDocument will delegate execution responsibility to the AutomationSteps that it receives.
 * The SsmDocument parent class contains methods to runSimulation() as well as print().
 */
class AutomationDocument extends ssm_document_1.SsmDocument {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.builder = new document_builder_1.AutomationDocumentBuilder();
    }
    addStep(component) {
        component.addToDocument(this.builder);
    }
    collectedSteps() {
        this.validateOutputs(this.builder.steps);
        if (this.builder.steps.length == 0) {
            throw new Error('No Steps found. Either you did not declare steps or did not synthesize CDK. ' +
                'Be sure to run cdk.SynthUtils.synthesize(stack) prior to printing or running simulation');
        }
        return this.builder.steps;
    }
    /**
       * @returns an object that can be used to build the json/yaml string representation of this document.
       */
    buildSsmDocument() {
        const automationSteps = this.collectedSteps().map(step => step.toSsmEntry());
        const root = {
            description: this.description,
            schemaVersion: '0.3',
            parameters: this.formatInputs(),
        };
        if (this.assumeRole) {
            root.assumeRole = this.assumeRole;
        }
        if (this.docOutputs.length > 0) {
            root.outputs = this.docOutputs;
        }
        root.mainSteps = automationSteps;
        return root;
    }
    /**
       * Ensures that all outputs specified in the Automation document are valid and that the steps and outputs exist.
       * Throws if any output specified cannot be found.
       */
    validateOutputs(steps) {
        this.docOutputs.forEach(docOutput => {
            if (!docOutput.name.includes('.')) {
                throw new Error(`Automation document outputs must be formatted Step.OutputName, failed validation: ${docOutput}`);
            }
            const stepAndOutput = docOutput.name.split('.');
            const stepOfOutput = steps.filter(step => step.name == stepAndOutput[0]);
            if (stepOfOutput.length != 1) {
                throw new Error(`Document must contain the step for output ${docOutput.name} but found: ${JSON.stringify(stepOfOutput)}`);
            }
            if (!stepOfOutput[0].listOutputs().map(out => out.name).includes(stepAndOutput[1])) {
                throw new Error(`Cannot find output ${JSON.stringify(docOutput)} specified as an output of step ${stepOfOutput[0].name}`);
            }
        });
    }
    documentType() {
        return 'Automation';
    }
}
exports.AutomationDocument = AutomationDocument;
_a = JSII_RTTI_SYMBOL_1;
AutomationDocument[_a] = { fqn: "@cdklabs/cdk-ssm-documents.AutomationDocument", version: "0.0.14" };
//# sourceMappingURL=data:application/json;base64,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