import { Observable } from 'rxjs';
import { VirtualTimeScheduler } from 'rxjs/internal/scheduler/VirtualTimeScheduler';
import { ColdObservable } from 'rxjs/internal/testing/ColdObservable';
import { HotObservable } from 'rxjs/internal/testing/HotObservable';
import { TestMessage } from '../message/TestMessage';
/**
 * @internal
 */
declare class TestScheduler extends VirtualTimeScheduler {
    private readonly autoFlush;
    private readonly frameTimeFactor;
    readonly maxFrame: number;
    private readonly coldObservables;
    private readonly hotObservables;
    private flushed;
    private flushing;
    private readonly _maxFrame;
    constructor(autoFlush: boolean, frameTimeFactor: number, maxFrameValue: number);
    flush(): void;
    getMessages<T = string>(observable: Observable<T>, unsubscriptionMarbles?: string | null): TestMessage<T | TestMessage<T>[]>[];
    createColdObservable<T = string>(marble: string, value?: {
        [key: string]: T;
    } | null, error?: any): ColdObservable<T>;
    createColdObservable<T = string>(message: Array<TestMessage<T>>): ColdObservable<T>;
    createHotObservable<T = string>(marble: string, value?: {
        [key: string]: T;
    } | null, error?: any): HotObservable<T>;
    createHotObservable<T = string>(message: Array<TestMessage<T>>): HotObservable<T>;
    advanceTo(toFrame: number): void;
    private materializeInnerObservable;
    private peek;
    private flushUntil;
}
export { TestScheduler };
//# sourceMappingURL=TestScheduler.d.ts.map