import { TestMessage } from '../message/TestMessage';
/**
 * @internal
 * Base accumulator interface for parsing marble diagram.
 */
interface TokenParseAccumulator {
    /**
     * Current virtual time passed
     */
    currentTimeFrame: number;
    /**
     * Flag indicate values are grouped `()` and emitted simultaneously
     */
    simultaneousGrouped: boolean;
    /**
     * Flag indicate timeframe expansion `...` is in progress
     */
    expandingTokenCount: number;
    /**
     * Tokens for expanding timeframe, will be joined & parsed into number
     */
    expandingValue: Array<string>;
}
/**
 * @internal
 * Accumulator interface for parsing observable marble diagram.
 */
interface ObservableTokenParseAccumulator<T> extends TokenParseAccumulator {
    /**
     * Meta values emitted by marbles (value, error, complete)
     */
    messages: Array<TestMessage<T | Array<TestMessage<T>>>>;
}
/**
 * @internal
 * Accumulator interface for parsing subscription marble diagram.
 */
interface SubscriptionTokenParseAccumulator extends TokenParseAccumulator {
    subscriptionFrame: number;
    unsubscriptionFrame: number;
}
/**
 * @internal
 * Reducer to traverse Observable marble diagram to generate TestMessage metadata.
 * @param value Custom values for marble values
 * @param error Custom error
 * @param materializeInnerObservables Flatten inner observable if available
 * @param frameTimeFactor Custom timeframe factor
 */
declare const observableTokenParseReducer: <T>(value: {
    [key: string]: T;
} | null, error: any, materializeInnerObservables: boolean, frameTimeFactor: number, maxFrame: number) => (acc: ObservableTokenParseAccumulator<T>, token: any) => ObservableTokenParseAccumulator<T>;
/**
 * @internal
 * Reducer to traverse subscription marble diagram to generate SubscriptionLog metadata.
 * @param frameTimeFactor Custom timeframe factor
 */
declare const subscriptionTokenParseReducer: (frameTimeFactor: number, maxFrame: number) => (acc: SubscriptionTokenParseAccumulator, token: string) => SubscriptionTokenParseAccumulator;
export { TokenParseAccumulator, ObservableTokenParseAccumulator, SubscriptionTokenParseAccumulator, subscriptionTokenParseReducer, observableTokenParseReducer };
//# sourceMappingURL=tokenParseReducer.d.ts.map