"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OperationFactory = exports.createNewPollingBasedHeadObservable = exports.cacheUntil = void 0;
var rxjs_1 = require("rxjs");
var operators_1 = require("rxjs/operators");
var delegation_operation_1 = require("./delegation-operation");
var operation_1 = require("./operation");
var origination_operation_1 = require("./origination-operation");
var transaction_operation_1 = require("./transaction-operation");
var cacheUntil = function (cacheUntilObs) { return function (source) {
    var subject = null;
    return rxjs_1.defer(function () {
        if (!subject) {
            subject = new rxjs_1.ReplaySubject();
            source.pipe(operators_1.first()).subscribe(subject);
            cacheUntilObs.pipe(operators_1.first()).subscribe(function () {
                subject = null;
            });
        }
        return subject;
    });
}; };
exports.cacheUntil = cacheUntil;
var createNewPollingBasedHeadObservable = function (pollingTimer, sharedHeadOb, context, scheduler) {
    if (context.config.confirmationPollingTimeoutSecond === undefined) {
        throw new Error('Confirmation polling timeout second can not be undefined!');
    }
    return pollingTimer.pipe(operators_1.switchMap(function () { return sharedHeadOb; }), operators_1.distinctUntilKeyChanged('hash'), operators_1.timeoutWith(context.config.confirmationPollingTimeoutSecond * 1000, rxjs_1.throwError(new Error('Confirmation polling timed out')), scheduler), operators_1.shareReplay({
        refCount: true,
        scheduler: scheduler,
    }));
};
exports.createNewPollingBasedHeadObservable = createNewPollingBasedHeadObservable;
var OperationFactory = /** @class */ (function () {
    function OperationFactory(context) {
        var _this = this;
        this.context = context;
        // Cache the last block for one second across all operations
        this.sharedHeadObs = rxjs_1.defer(function () { return rxjs_1.from(_this.context.rpc.getBlock()); }).pipe(exports.cacheUntil(rxjs_1.timer(0, 1000)));
    }
    OperationFactory.prototype.createNewHeadObservable = function () {
        return __awaiter(this, void 0, void 0, function () {
            var confirmationPollingIntervalSecond, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!(this.context.config.confirmationPollingIntervalSecond !== undefined)) return [3 /*break*/, 1];
                        _a = this.context.config.confirmationPollingIntervalSecond;
                        return [3 /*break*/, 3];
                    case 1: return [4 /*yield*/, this.context.getConfirmationPollingInterval()];
                    case 2:
                        _a = _b.sent();
                        _b.label = 3;
                    case 3:
                        confirmationPollingIntervalSecond = _a;
                        return [2 /*return*/, exports.createNewPollingBasedHeadObservable(rxjs_1.timer(0, confirmationPollingIntervalSecond * 1000), this.sharedHeadObs, this.context)];
                }
            });
        });
    };
    OperationFactory.prototype.createPastBlockWalker = function (startBlock, count) {
        var _this = this;
        if (count === void 0) { count = 1; }
        return rxjs_1.from(this.context.rpc.getBlock({ block: startBlock })).pipe(operators_1.switchMap(function (block) {
            if (count === 1) {
                return rxjs_1.of(block);
            }
            return rxjs_1.range(block.header.level, count - 1).pipe(operators_1.startWith(block), operators_1.concatMap(function (level) { return __awaiter(_this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    return [2 /*return*/, this.context.rpc.getBlock({ block: String(level) })];
                });
            }); }));
        }));
    };
    OperationFactory.prototype.createHeadObservableFromConfig = function (_a) {
        var blockIdentifier = _a.blockIdentifier;
        return __awaiter(this, void 0, void 0, function () {
            var observableSequence, _b, _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        observableSequence = [];
                        if (blockIdentifier) {
                            observableSequence.push(this.createPastBlockWalker(blockIdentifier));
                        }
                        _c = (_b = observableSequence).push;
                        return [4 /*yield*/, this.createNewHeadObservable()];
                    case 1:
                        _c.apply(_b, [_d.sent()]);
                        return [2 /*return*/, rxjs_1.concat.apply(void 0, __spread(observableSequence))];
                }
            });
        });
    };
    OperationFactory.prototype.createOperation = function (hash, config) {
        if (config === void 0) { config = {}; }
        return __awaiter(this, void 0, void 0, function () {
            var _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _a = operation_1.WalletOperation.bind;
                        _b = [void 0, hash,
                            this.context.clone()];
                        return [4 /*yield*/, this.createHeadObservableFromConfig(config)];
                    case 1: return [2 /*return*/, new (_a.apply(operation_1.WalletOperation, _b.concat([_c.sent()])))()];
                }
            });
        });
    };
    OperationFactory.prototype.createTransactionOperation = function (hash, config) {
        if (config === void 0) { config = {}; }
        return __awaiter(this, void 0, void 0, function () {
            var _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _a = transaction_operation_1.TransactionWalletOperation.bind;
                        _b = [void 0, hash,
                            this.context.clone()];
                        return [4 /*yield*/, this.createHeadObservableFromConfig(config)];
                    case 1: return [2 /*return*/, new (_a.apply(transaction_operation_1.TransactionWalletOperation, _b.concat([_c.sent()])))()];
                }
            });
        });
    };
    OperationFactory.prototype.createDelegationOperation = function (hash, config) {
        if (config === void 0) { config = {}; }
        return __awaiter(this, void 0, void 0, function () {
            var _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _a = delegation_operation_1.DelegationWalletOperation.bind;
                        _b = [void 0, hash,
                            this.context.clone()];
                        return [4 /*yield*/, this.createHeadObservableFromConfig(config)];
                    case 1: return [2 /*return*/, new (_a.apply(delegation_operation_1.DelegationWalletOperation, _b.concat([_c.sent()])))()];
                }
            });
        });
    };
    OperationFactory.prototype.createOriginationOperation = function (hash, config) {
        if (config === void 0) { config = {}; }
        return __awaiter(this, void 0, void 0, function () {
            var _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _a = origination_operation_1.OriginationWalletOperation.bind;
                        _b = [void 0, hash,
                            this.context.clone()];
                        return [4 /*yield*/, this.createHeadObservableFromConfig(config)];
                    case 1: return [2 /*return*/, new (_a.apply(origination_operation_1.OriginationWalletOperation, _b.concat([_c.sent()])))()];
                }
            });
        });
    };
    return OperationFactory;
}());
exports.OperationFactory = OperationFactory;
//# sourceMappingURL=operation-factory.js.map